/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2017-2020, The Linux Foundation. All rights reserved.
 */

#ifndef _DP_REG_H_
#define _DP_REG_H_

/* DP_TX Registers */
#define DP_HW_VERSION				(0x00000000)
#define DP_SW_RESET				(0x00000010)
#define DP_PHY_CTRL				(0x00000014)
#define DP_CLK_CTRL				(0x00000018)
#define DP_CLK_ACTIVE				(0x0000001C)
#define DP_INTR_STATUS				(0x00000020)
#define DP_INTR_STATUS2				(0x00000024)
#define DP_INTR_STATUS3				(0x00000028)
#define DP_INTR_STATUS5				(0x00000034)

#define DP_DP_HPD_CTRL				(0x00000000)
#define DP_DP_HPD_INT_STATUS			(0x00000004)
#define DP_DP_HPD_INT_ACK			(0x00000008)
#define DP_DP_HPD_INT_MASK			(0x0000000C)
#define DP_DP_HPD_REFTIMER			(0x00000018)
#define DP_DP_HPD_EVENT_TIME_0			(0x0000001C)
#define DP_DP_HPD_EVENT_TIME_1			(0x00000020)
#define DP_AUX_CTRL				(0x00000030)
#define DP_AUX_DATA				(0x00000034)
#define DP_AUX_TRANS_CTRL			(0x00000038)
#define DP_TIMEOUT_COUNT			(0x0000003C)
#define DP_AUX_LIMITS				(0x00000040)
#define DP_AUX_STATUS				(0x00000044)

#define DP_DPCD_CP_IRQ				(0x201)
#define DP_DPCD_RXSTATUS			(0x69493)

#define DP_INTERRUPT_TRANS_NUM			(0x000000A0)

#define DP_MAINLINK_CTRL			(0x00000000)
#define DP_STATE_CTRL				(0x00000004)
#define DP_CONFIGURATION_CTRL			(0x00000008)
#define DP_SOFTWARE_MVID			(0x00000010)
#define DP_SOFTWARE_NVID			(0x00000018)
#define DP_TOTAL_HOR_VER			(0x0000001C)
#define DP_START_HOR_VER_FROM_SYNC		(0x00000020)
#define DP_HSYNC_VSYNC_WIDTH_POLARITY		(0x00000024)
#define DP_ACTIVE_HOR_VER			(0x00000028)
#define DP_MISC1_MISC0				(0x0000002C)
#define DP_VALID_BOUNDARY			(0x00000030)
#define DP_VALID_BOUNDARY_2			(0x00000034)
#define DP_LOGICAL2PHYSICAL_LANE_MAPPING	(0x00000038)

#define DP1_CONFIGURATION_CTRL			(0x00000400)
#define DP_DP0_TIMESLOT_1_32			(0x00000404)
#define DP_DP0_TIMESLOT_33_63			(0x00000408)
#define DP_DP1_TIMESLOT_1_32			(0x0000040C)
#define DP_DP1_TIMESLOT_33_63			(0x00000410)
#define DP1_SOFTWARE_MVID			(0x00000414)
#define DP1_SOFTWARE_NVID			(0x00000418)
#define DP1_TOTAL_HOR_VER			(0x0000041C)
#define DP1_START_HOR_VER_FROM_SYNC		(0x00000420)
#define DP1_HSYNC_VSYNC_WIDTH_POLARITY		(0x00000424)
#define DP1_ACTIVE_HOR_VER			(0x00000428)
#define DP1_MISC1_MISC0				(0x0000042C)
#define DP_DP0_RG				(0x000004F8)
#define DP_DP1_RG				(0x000004FC)

#define DP_MST_ACT				(0x00000500)
#define DP_MST_MAINLINK_READY			(0x00000504)

#define DP_MAINLINK_READY			(0x00000040)
#define DP_MAINLINK_LEVELS			(0x00000044)
#define DP_TU					(0x0000004C)

#define DP_HBR2_COMPLIANCE_SCRAMBLER_RESET	(0x00000054)
#define DP_TEST_80BIT_CUSTOM_PATTERN_REG0	(0x000000C0)
#define DP_TEST_80BIT_CUSTOM_PATTERN_REG1	(0x000000C4)
#define DP_TEST_80BIT_CUSTOM_PATTERN_REG2	(0x000000C8)

#define MMSS_DP_MISC1_MISC0			(0x0000002C)
#define MMSS_DP_AUDIO_TIMING_GEN		(0x00000080)
#define MMSS_DP_AUDIO_TIMING_RBR_32		(0x00000084)
#define MMSS_DP_AUDIO_TIMING_HBR_32		(0x00000088)
#define MMSS_DP_AUDIO_TIMING_RBR_44		(0x0000008C)
#define MMSS_DP_AUDIO_TIMING_HBR_44		(0x00000090)
#define MMSS_DP_AUDIO_TIMING_RBR_48		(0x00000094)
#define MMSS_DP_AUDIO_TIMING_HBR_48		(0x00000098)

#define MMSS_DP_PSR_CRC_RG			(0x00000154)
#define MMSS_DP_PSR_CRC_B			(0x00000158)

#define DP_COMPRESSION_MODE_CTRL		(0x00000180)
#define DP_PPS_HB_0_3				(0x00000184)
#define DP_PPS_PB_0_3				(0x00000188)
#define DP_PPS_PB_4_7				(0x0000018C)
#define DP_PPS_PB_8_11				(0x00000190)
#define DP_PPS_PB_12_15				(0x00000194)
#define DP_PPS_PB_16_19				(0x00000198)
#define DP_PPS_PB_20_23				(0x0000019C)
#define DP_PPS_PB_24_27				(0x000001A0)
#define DP_PPS_PB_28_31				(0x000001A4)
#define DP_PPS_PPS_0_3				(0x000001A8)
#define DP_PPS_PPS_4_7				(0x000001AC)
#define DP_PPS_PPS_8_11				(0x000001B0)
#define DP_PPS_PPS_12_15			(0x000001B4)
#define DP_PPS_PPS_16_19			(0x000001B8)
#define DP_PPS_PPS_20_23			(0x000001BC)
#define DP_PPS_PPS_24_27			(0x000001C0)
#define DP_PPS_PPS_28_31			(0x000001C4)
#define DP_PPS_PPS_32_35			(0x000001C8)
#define DP_PPS_PPS_36_39			(0x000001CC)
#define DP_PPS_PPS_40_43			(0x000001D0)
#define DP_PPS_PPS_44_47			(0x000001D4)
#define DP_PPS_PPS_48_51			(0x000001D8)
#define DP_PPS_PPS_52_55			(0x000001DC)
#define DP_PPS_PPS_56_59			(0x000001E0)
#define DP_PPS_PPS_60_63			(0x000001E4)
#define DP_PPS_PPS_64_67			(0x000001E8)
#define DP_PPS_PPS_68_71			(0x000001EC)
#define DP_PPS_PPS_72_75			(0x000001F0)
#define DP_PPS_PPS_76_79			(0x000001F4)
#define DP_PPS_PPS_80_83			(0x000001F8)
#define DP_PPS_PPS_84_87			(0x000001FC)

#define MMSS_DP_AUDIO_CFG			(0x00000200)
#define MMSS_DP_AUDIO_STATUS			(0x00000204)
#define MMSS_DP_AUDIO_PKT_CTRL			(0x00000208)
#define MMSS_DP_AUDIO_PKT_CTRL2			(0x0000020C)
#define MMSS_DP_AUDIO_ACR_CTRL			(0x00000210)
#define MMSS_DP_AUDIO_CTRL_RESET		(0x00000214)

#define MMSS_DP_SDP_CFG				(0x00000228)
#define MMSS_DP_SDP_CFG2			(0x0000022C)
#define MMSS_DP_SDP_CFG3			(0x0000024C)
#define MMSS_DP_SDP_CFG4			(0x000004EC)
#define MMSS_DP_AUDIO_TIMESTAMP_0		(0x00000230)
#define MMSS_DP_AUDIO_TIMESTAMP_1		(0x00000234)

#define MMSS_DP_AUDIO_STREAM_0			(0x00000240)
#define MMSS_DP_AUDIO_STREAM_1			(0x00000244)

#define MMSS_DP_EXTENSION_0			(0x00000250)
#define MMSS_DP_EXTENSION_1			(0x00000254)
#define MMSS_DP_EXTENSION_2			(0x00000258)
#define MMSS_DP_EXTENSION_3			(0x0000025C)
#define MMSS_DP_EXTENSION_4			(0x00000260)
#define MMSS_DP_EXTENSION_5			(0x00000264)
#define MMSS_DP_EXTENSION_6			(0x00000268)
#define MMSS_DP_EXTENSION_7			(0x0000026C)
#define MMSS_DP_EXTENSION_8			(0x00000270)
#define MMSS_DP_EXTENSION_9			(0x00000274)
#define MMSS_DP_AUDIO_COPYMANAGEMENT_0		(0x00000278)
#define MMSS_DP_AUDIO_COPYMANAGEMENT_1		(0x0000027C)
#define MMSS_DP_AUDIO_COPYMANAGEMENT_2		(0x00000280)
#define MMSS_DP_AUDIO_COPYMANAGEMENT_3		(0x00000284)
#define MMSS_DP_AUDIO_COPYMANAGEMENT_4		(0x00000288)
#define MMSS_DP_AUDIO_COPYMANAGEMENT_5		(0x0000028C)
#define MMSS_DP_AUDIO_ISRC_0			(0x00000290)
#define MMSS_DP_AUDIO_ISRC_1			(0x00000294)
#define MMSS_DP_AUDIO_ISRC_2			(0x00000298)
#define MMSS_DP_AUDIO_ISRC_3			(0x0000029C)
#define MMSS_DP_AUDIO_ISRC_4			(0x000002A0)
#define MMSS_DP_AUDIO_ISRC_5			(0x000002A4)
#define MMSS_DP_AUDIO_INFOFRAME_0		(0x000002A8)
#define MMSS_DP_AUDIO_INFOFRAME_1		(0x000002AC)
#define MMSS_DP_AUDIO_INFOFRAME_2		(0x000002B0)

#define MMSS_DP_FLUSH				(0x000002F8)
#define MMSS_DP1_FLUSH				(0x000002FC)

#define MMSS_DP_GENERIC0_0			(0x00000300)
#define MMSS_DP_GENERIC0_1			(0x00000304)
#define MMSS_DP_GENERIC0_2			(0x00000308)
#define MMSS_DP_GENERIC0_3			(0x0000030C)
#define MMSS_DP_GENERIC0_4			(0x00000310)
#define MMSS_DP_GENERIC0_5			(0x00000314)
#define MMSS_DP_GENERIC0_6			(0x00000318)
#define MMSS_DP_GENERIC0_7			(0x0000031C)
#define MMSS_DP_GENERIC0_8			(0x00000320)
#define MMSS_DP_GENERIC0_9			(0x00000324)
#define MMSS_DP_GENERIC1_0			(0x00000328)
#define MMSS_DP_GENERIC1_1			(0x0000032C)
#define MMSS_DP_GENERIC1_2			(0x00000330)
#define MMSS_DP_GENERIC1_3			(0x00000334)
#define MMSS_DP_GENERIC1_4			(0x00000338)
#define MMSS_DP_GENERIC1_5			(0x0000033C)
#define MMSS_DP_GENERIC1_6			(0x00000340)
#define MMSS_DP_GENERIC1_7			(0x00000344)
#define MMSS_DP_GENERIC1_8			(0x00000348)
#define MMSS_DP_GENERIC1_9			(0x0000034C)

#define MMSS_DP1_GENERIC0_0			(0x00000490)
#define MMSS_DP1_GENERIC0_1			(0x00000494)
#define MMSS_DP1_GENERIC0_2			(0x00000498)
#define MMSS_DP1_GENERIC0_3			(0x0000049C)
#define MMSS_DP1_GENERIC0_4			(0x000004A0)
#define MMSS_DP1_GENERIC0_5			(0x000004A4)
#define MMSS_DP1_GENERIC0_6			(0x000004A8)
#define MMSS_DP1_GENERIC0_7			(0x000004AC)
#define MMSS_DP1_GENERIC0_8			(0x000004B0)
#define MMSS_DP1_GENERIC0_9			(0x000004B4)
#define MMSS_DP1_GENERIC1_0			(0x000004B8)
#define MMSS_DP1_GENERIC1_1			(0x000004BC)
#define MMSS_DP1_GENERIC1_2			(0x000004C0)
#define MMSS_DP1_GENERIC1_3			(0x000004C4)
#define MMSS_DP1_GENERIC1_4			(0x000004C8)
#define MMSS_DP1_GENERIC1_5			(0x000004CC)
#define MMSS_DP1_GENERIC1_6			(0x000004D0)
#define MMSS_DP1_GENERIC1_7			(0x000004D4)
#define MMSS_DP1_GENERIC1_8			(0x000004D8)
#define MMSS_DP1_GENERIC1_9			(0x000004DC)

#define MMSS_DP_GENERIC2_0			(0x000003d8)
#define MMSS_DP_GENERIC2_1			(0x000003dc)
#define MMSS_DP_GENERIC2_2			(0x000003e0)
#define MMSS_DP_GENERIC2_3			(0x000003e4)
#define MMSS_DP_GENERIC2_4			(0x000003e8)
#define MMSS_DP_GENERIC2_5			(0x000003ec)
#define MMSS_DP_GENERIC2_6			(0x000003f0)
#define MMSS_DP_GENERIC2_7			(0x000003f4)
#define MMSS_DP_GENERIC2_8			(0x000003f8)
#define MMSS_DP_GENERIC2_9			(0x000003fc)
#define MMSS_DP1_GENERIC2_0			(0x00000510)
#define MMSS_DP1_GENERIC2_1			(0x00000514)
#define MMSS_DP1_GENERIC2_2			(0x00000518)
#define MMSS_DP1_GENERIC2_3			(0x0000051c)
#define MMSS_DP1_GENERIC2_4			(0x00000520)
#define MMSS_DP1_GENERIC2_5			(0x00000524)
#define MMSS_DP1_GENERIC2_6			(0x00000528)
#define MMSS_DP1_GENERIC2_7			(0x0000052C)
#define MMSS_DP1_GENERIC2_8			(0x00000530)
#define MMSS_DP1_GENERIC2_9			(0x00000534)

#define MMSS_DP1_SDP_CFG			(0x000004E0)
#define MMSS_DP1_SDP_CFG2			(0x000004E4)
#define MMSS_DP1_SDP_CFG3			(0x000004E8)
#define MMSS_DP1_SDP_CFG4			(0x000004F0)

#define DP1_COMPRESSION_MODE_CTRL		(0x00000560)
#define DP1_PPS_HB_0_3				(0x00000564)
#define DP1_PPS_PB_0_3				(0x00000568)
#define DP1_PPS_PB_4_7				(0x0000056C)
#define DP1_PPS_PB_8_11				(0x00000570)
#define DP1_PPS_PB_12_15			(0x00000574)
#define DP1_PPS_PB_16_19			(0x00000578)
#define DP1_PPS_PB_20_23			(0x0000057C)
#define DP1_PPS_PB_24_27			(0x00000580)
#define DP1_PPS_PB_28_31			(0x00000584)
#define DP1_PPS_PPS_0_3				(0x00000588)
#define DP1_PPS_PPS_4_7				(0x0000058C)
#define DP1_PPS_PPS_8_11			(0x00000590)
#define DP1_PPS_PPS_12_15			(0x00000594)
#define DP1_PPS_PPS_16_19			(0x00000598)
#define DP1_PPS_PPS_20_23			(0x0000059C)
#define DP1_PPS_PPS_24_27			(0x000005A0)
#define DP1_PPS_PPS_28_31			(0x000005A4)
#define DP1_PPS_PPS_32_35			(0x000005A8)
#define DP1_PPS_PPS_36_39			(0x000005AC)
#define DP1_PPS_PPS_40_43			(0x000005B0)
#define DP1_PPS_PPS_44_47			(0x000005B4)
#define DP1_PPS_PPS_48_51			(0x000005B8)
#define DP1_PPS_PPS_52_55			(0x000005BC)
#define DP1_PPS_PPS_56_59			(0x000005C0)
#define DP1_PPS_PPS_60_63			(0x000005C4)
#define DP1_PPS_PPS_64_67			(0x000005C8)
#define DP1_PPS_PPS_68_71			(0x000005CC)
#define DP1_PPS_PPS_72_75			(0x000005D0)
#define DP1_PPS_PPS_76_79			(0x000005D4)
#define DP1_PPS_PPS_80_83			(0x000005D8)
#define DP1_PPS_PPS_84_87			(0x000005DC)

#define MMSS_DP_VSCEXT_0			(0x000002D0)
#define MMSS_DP_VSCEXT_1			(0x000002D4)
#define MMSS_DP_VSCEXT_2			(0x000002D8)
#define MMSS_DP_VSCEXT_3			(0x000002DC)
#define MMSS_DP_VSCEXT_4			(0x000002E0)
#define MMSS_DP_VSCEXT_5			(0x000002E4)
#define MMSS_DP_VSCEXT_6			(0x000002E8)
#define MMSS_DP_VSCEXT_7			(0x000002EC)
#define MMSS_DP_VSCEXT_8			(0x000002F0)
#define MMSS_DP_VSCEXT_9			(0x000002F4)

#define MMSS_DP1_VSCEXT_0			(0x00000468)
#define MMSS_DP1_VSCEXT_1			(0x0000046c)
#define MMSS_DP1_VSCEXT_2			(0x00000470)
#define MMSS_DP1_VSCEXT_3			(0x00000474)
#define MMSS_DP1_VSCEXT_4			(0x00000478)
#define MMSS_DP1_VSCEXT_5			(0x0000047c)
#define MMSS_DP1_VSCEXT_6			(0x00000480)
#define MMSS_DP1_VSCEXT_7			(0x00000484)
#define MMSS_DP1_VSCEXT_8			(0x00000488)
#define MMSS_DP1_VSCEXT_9			(0x0000048c)

#define MMSS_DP_BIST_ENABLE			(0x00000000)
#define MMSS_DP_TIMING_ENGINE_EN		(0x00000010)
#define MMSS_DP_INTF_CONFIG			(0x00000014)
#define MMSS_DP_INTF_HSYNC_CTL			(0x00000018)
#define MMSS_DP_INTF_VSYNC_PERIOD_F0		(0x0000001C)
#define MMSS_DP_INTF_VSYNC_PERIOD_F1		(0x00000020)
#define MMSS_DP_INTF_VSYNC_PULSE_WIDTH_F0	(0x00000024)
#define MMSS_DP_INTF_VSYNC_PULSE_WIDTH_F1	(0x00000028)
#define MMSS_INTF_DISPLAY_V_START_F0		(0x0000002C)
#define MMSS_INTF_DISPLAY_V_START_F1		(0x00000030)
#define MMSS_DP_INTF_DISPLAY_V_END_F0		(0x00000034)
#define MMSS_DP_INTF_DISPLAY_V_END_F1		(0x00000038)
#define MMSS_DP_INTF_ACTIVE_V_START_F0		(0x0000003C)
#define MMSS_DP_INTF_ACTIVE_V_START_F1		(0x00000040)
#define MMSS_DP_INTF_ACTIVE_V_END_F0		(0x00000044)
#define MMSS_DP_INTF_ACTIVE_V_END_F1		(0x00000048)
#define MMSS_DP_INTF_DISPLAY_HCTL		(0x0000004C)
#define MMSS_DP_INTF_ACTIVE_HCTL		(0x00000050)
#define MMSS_DP_INTF_POLARITY_CTL		(0x00000058)
#define MMSS_DP_TPG_MAIN_CONTROL		(0x00000060)
#define MMSS_DP_TPG_VIDEO_CONFIG		(0x00000064)
#define MMSS_DP_DSC_DTO				(0x0000007C)
#define MMSS_DP_DSC_DTO_COUNT			(0x00000084)
#define MMSS_DP_ASYNC_FIFO_CONFIG		(0x00000088)

#define MMSS_DP1_BIST_ENABLE			(0x00000000)
#define MMSS_DP1_TIMING_ENGINE_EN		(0x00000010)
#define MMSS_DP1_INTF_CONFIG			(0x00000014)
#define MMSS_DP1_INTF_HSYNC_CTL			(0x00000018)
#define MMSS_DP1_INTF_VSYNC_PERIOD_F0		(0x0000001C)
#define MMSS_DP1_INTF_VSYNC_PERIOD_F1		(0x00000020)
#define MMSS_DP1_INTF_VSYNC_PULSE_WIDTH_F0	(0x00000024)
#define MMSS_DP1_INTF_VSYNC_PULSE_WIDTH_F1	(0x00000028)
#define MMSS_DP1_INTF_DISPLAY_V_START_F0	(0x0000002C)
#define MMSS_DP1_INTF_DISPLAY_V_START_F1	(0x00000030)
#define MMSS_DP1_INTF_DISPLAY_V_END_F0		(0x00000034)
#define MMSS_DP1_INTF_DISPLAY_V_END_F1		(0x00000038)
#define MMSS_DP1_INTF_ACTIVE_V_START_F0		(0x0000003C)
#define MMSS_DP1_INTF_ACTIVE_V_START_F1		(0x00000040)
#define MMSS_DP1_INTF_ACTIVE_V_END_F0		(0x00000044)
#define MMSS_DP1_INTF_ACTIVE_V_END_F1		(0x00000048)
#define MMSS_DP1_INTF_DISPLAY_HCTL		(0x0000004C)
#define MMSS_DP1_INTF_ACTIVE_HCTL		(0x00000050)
#define MMSS_DP1_INTF_POLARITY_CTL		(0x00000058)
#define MMSS_DP1_TPG_MAIN_CONTROL		(0x00000060)
#define MMSS_DP1_TPG_VIDEO_CONFIG		(0x00000064)
#define MMSS_DP1_DSC_DTO			(0x0000007C)
#define MMSS_DP1_DSC_DTO_COUNT			(0x00000084)
#define MMSS_DP1_ASYNC_FIFO_CONFIG		(0x00000088)

/*DP PHY Register offsets */
#define DP_PHY_REVISION_ID0                     (0x00000000)
#define DP_PHY_REVISION_ID1                     (0x00000004)
#define DP_PHY_REVISION_ID2                     (0x00000008)
#define DP_PHY_REVISION_ID3                     (0x0000000C)

#define DP_PHY_CFG                              (0x00000010)
#define DP_PHY_PD_CTL                           (0x00000018)
#define DP_PHY_MODE                             (0x0000001C)

#define DP_PHY_AUX_CFG0                         (0x00000020)
#define DP_PHY_AUX_CFG1                         (0x00000024)
#define DP_PHY_AUX_CFG2                         (0x00000028)
#define DP_PHY_AUX_CFG3                         (0x0000002C)
#define DP_PHY_AUX_CFG4                         (0x00000030)
#define DP_PHY_AUX_CFG5                         (0x00000034)
#define DP_PHY_AUX_CFG6                         (0x00000038)
#define DP_PHY_AUX_CFG7                         (0x0000003C)
#define DP_PHY_AUX_CFG8                         (0x00000040)
#define DP_PHY_AUX_CFG9                         (0x00000044)
#define DP_PHY_AUX_INTERRUPT_MASK               (0x00000048)
#define DP_PHY_AUX_INTERRUPT_CLEAR              (0x0000004C)
#define DP_PHY_AUX_INTERRUPT_STATUS             (0x000000BC)
#define DP_PHY_AUX_INTERRUPT_MASK_V200          (0x00000048)
#define DP_PHY_AUX_INTERRUPT_CLEAR_V200         (0x0000004C)
#define DP_PHY_AUX_INTERRUPT_STATUS_V200        (0x000000BC)

#define DP_PHY_SPARE0				(0x00AC)

#define TXn_TX_EMP_POST1_LVL			(0x000C)
#define TXn_TX_DRV_LVL				(0x001C)
#define TXn_TX_POL_INV				(0x0064)

#define TXn_TRANSCEIVER_BIAS_EN			(0x005C)
#define TXn_HIGHZ_DRVR_EN			(0x0060)

#define DP_PHY_STATUS_V420			(0x00DC)
#define DP_PHY_AUX_INTERRUPT_MASK_V420		(0x0054)
#define DP_PHY_AUX_INTERRUPT_CLEAR_V420		(0x0058)
#define DP_PHY_AUX_INTERRUPT_STATUS_V420	(0x00D8)
#define DP_PHY_SPARE0_V420			(0x00C8)
#define TXn_TX_DRV_LVL_V420			(0x0014)
#define TXn_TRANSCEIVER_BIAS_EN_V420		(0x0054)
#define TXn_HIGHZ_DRVR_EN_V420			(0x0058)
#define TXn_TX_POL_INV_V420			(0x005C)

#define QSERDES_COM_BIAS_EN_CLKBUFLR_EN		(0x004)

/* DP MMSS_CC registers */
#define MMSS_DP_LINK_CMD_RCGR			(0x0138)
#define MMSS_DP_LINK_CFG_RCGR			(0x013C)
#define MMSS_DP_PIXEL_M				(0x0134)
#define MMSS_DP_PIXEL_N				(0x0138)
#define MMSS_DP_PIXEL1_M			(0x01CC)
#define MMSS_DP_PIXEL1_N			(0x01D0)
#define MMSS_DP_PIXEL_M_V200			(0x0130)
#define MMSS_DP_PIXEL_N_V200			(0x0134)
#define MMSS_DP_PIXEL1_M_V200			(0x0148)
#define MMSS_DP_PIXEL1_N_V200			(0x014C)
#define MMSS_DP_PIXEL_M_V420			(0x01B4)
#define MMSS_DP_PIXEL_N_V420			(0x01B8)
#define MMSS_DP_PIXEL1_M_V420			(0x01CC)
#define MMSS_DP_PIXEL1_N_V420			(0x01D0)

/* DP HDCP 1.3 registers */
#define DP_HDCP_CTRL                                   (0x0A0)
#define DP_HDCP_STATUS                                 (0x0A4)
#define DP_HDCP_SW_UPPER_AKSV                          (0x098)
#define DP_HDCP_SW_LOWER_AKSV                          (0x09C)
#define DP_HDCP_ENTROPY_CTRL0                          (0x350)
#define DP_HDCP_ENTROPY_CTRL1                          (0x35C)
#define DP_HDCP_SHA_STATUS                             (0x0C8)
#define DP_HDCP_RCVPORT_DATA2_0                        (0x0B0)
#define DP_HDCP_RCVPORT_DATA3                          (0x0A4)
#define DP_HDCP_RCVPORT_DATA4                          (0x0A8)
#define DP_HDCP_RCVPORT_DATA5                          (0x0C0)
#define DP_HDCP_RCVPORT_DATA6                          (0x0C4)

#define HDCP_SEC_DP_TZ_HV_HLOS_HDCP_SHA_CTRL           (0x024)
#define HDCP_SEC_DP_TZ_HV_HLOS_HDCP_SHA_DATA           (0x028)
#define HDCP_SEC_DP_TZ_HV_HLOS_HDCP_RCVPORT_DATA0      (0x004)
#define HDCP_SEC_DP_TZ_HV_HLOS_HDCP_RCVPORT_DATA1      (0x008)
#define HDCP_SEC_DP_TZ_HV_HLOS_HDCP_RCVPORT_DATA7      (0x00C)
#define HDCP_SEC_DP_TZ_HV_HLOS_HDCP_RCVPORT_DATA8      (0x010)
#define HDCP_SEC_DP_TZ_HV_HLOS_HDCP_RCVPORT_DATA9      (0x014)
#define HDCP_SEC_DP_TZ_HV_HLOS_HDCP_RCVPORT_DATA10     (0x018)
#define HDCP_SEC_DP_TZ_HV_HLOS_HDCP_RCVPORT_DATA11     (0x01C)
#define HDCP_SEC_DP_TZ_HV_HLOS_HDCP_RCVPORT_DATA12     (0x020)

/* USB3 DP COM registers */
#define USB3_DP_COM_RESET_OVRD_CTRL (0x1C)
#define USB3_DP_COM_PHY_MODE_CTRL   (0x00)
#define USB3_DP_COM_SW_RESET        (0x04)
#define USB3_DP_COM_TYPEC_CTRL      (0x10)
#define USB3_DP_COM_SWI_CTRL        (0x0c)
#define USB3_DP_COM_POWER_DOWN_CTRL (0x08)



#endif /* _DP_REG_H_ */
