/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2015-2019, The Linux Foundation. All rights reserved.
 */

#ifndef SDE_ROTATOR_R1_HWIO_H
#define SDE_ROTATOR_R1_HWIO_H

#include <linux/bitops.h>

#define SDE_MDP_FETCH_CONFIG_RESET_VALUE		0x00000087

#define SDE_MDP_REG_HW_VERSION				0x0
#define SDE_MDP_REG_INTR_EN				0x00010
#define SDE_MDP_REG_INTR_STATUS				0x00014
#define SDE_MDP_REG_INTR_CLEAR				0x00018

#define SDE_MDP_INTR_WB_0_DONE				BIT(0)
#define SDE_MDP_INTR_WB_1_DONE				BIT(1)

enum mdss_mdp_intr_type {
	SDE_MDP_IRQ_WB_ROT_COMP = 0,
	SDE_MDP_IRQ_WB_WFD = 4,
	SDE_MDP_IRQ_PING_PONG_COMP = 8,
	SDE_MDP_IRQ_PING_PONG_RD_PTR = 12,
	SDE_MDP_IRQ_PING_PONG_WR_PTR = 16,
	SDE_MDP_IRQ_PING_PONG_AUTO_REF = 20,
	SDE_MDP_IRQ_INTF_UNDER_RUN = 24,
	SDE_MDP_IRQ_INTF_VSYNC = 25,
};

enum mdss_mdp_ctl_index {
	SDE_MDP_CTL0,
	SDE_MDP_CTL1,
	SDE_MDP_CTL2,
	SDE_MDP_CTL3,
	SDE_MDP_CTL4,
	SDE_MDP_CTL5,
	SDE_MDP_MAX_CTL
};

#define SDE_MDP_REG_CTL_LAYER(lm)	\
			((lm == 5) ? (0x024) : ((lm) * 0x004))
#define SDE_MDP_REG_CTL_TOP				0x014
#define SDE_MDP_REG_CTL_FLUSH				0x018
#define SDE_MDP_REG_CTL_START				0x01C

#define SDE_MDP_CTL_OP_ROT0_MODE			0x1
#define SDE_MDP_CTL_OP_ROT1_MODE			0x2

enum sde_mdp_sspp_index {
	SDE_MDP_SSPP_VIG0,
	SDE_MDP_SSPP_VIG1,
	SDE_MDP_SSPP_VIG2,
	SDE_MDP_SSPP_RGB0,
	SDE_MDP_SSPP_RGB1,
	SDE_MDP_SSPP_RGB2,
	SDE_MDP_SSPP_DMA0,
	SDE_MDP_SSPP_DMA1,
	SDE_MDP_SSPP_VIG3,
	SDE_MDP_SSPP_RGB3,
	SDE_MDP_SSPP_CURSOR0,
	SDE_MDP_SSPP_CURSOR1,
	SDE_MDP_MAX_SSPP
};

#define SDE_MDP_REG_SSPP_SRC_SIZE			0x000
#define SDE_MDP_REG_SSPP_SRC_IMG_SIZE			0x004
#define SDE_MDP_REG_SSPP_SRC_XY				0x008
#define SDE_MDP_REG_SSPP_OUT_SIZE			0x00C
#define SDE_MDP_REG_SSPP_OUT_XY				0x010
#define SDE_MDP_REG_SSPP_SRC0_ADDR			0x014
#define SDE_MDP_REG_SSPP_SRC1_ADDR			0x018
#define SDE_MDP_REG_SSPP_SRC2_ADDR			0x01C
#define SDE_MDP_REG_SSPP_SRC3_ADDR			0x020
#define SDE_MDP_REG_SSPP_SRC_YSTRIDE0			0x024
#define SDE_MDP_REG_SSPP_SRC_YSTRIDE1			0x028
#define SDE_MDP_REG_SSPP_STILE_FRAME_SIZE		0x02C
#define SDE_MDP_REG_SSPP_SRC_FORMAT			0x030
#define SDE_MDP_REG_SSPP_SRC_UNPACK_PATTERN		0x034
#define SDE_MDP_REG_SSPP_SRC_CONSTANT_COLOR		0x03C
#define SDE_MDP_REG_SSPP_REQPRIO_FIFO_WM_0		0x050
#define SDE_MDP_REG_SSPP_REQPRIO_FIFO_WM_1		0x054
#define SDE_MDP_REG_SSPP_REQPRIO_FIFO_WM_2		0x058
#define SDE_MDP_REG_SSPP_DANGER_LUT			0x060
#define SDE_MDP_REG_SSPP_SAFE_LUT			0x064
#define SDE_MDP_REG_SSPP_CREQ_LUT			0x068
#define SDE_MDP_REG_SSPP_QOS_CTRL			0x06C
#define SDE_MDP_REG_SSPP_CDP_CTRL			0x134
#define SDE_MDP_REG_SSPP_UBWC_ERROR_STATUS		0x138

#define SDE_MDP_REG_SSPP_SRC_OP_MODE			0x038
#define SDE_MDP_OP_FLIP_UD				BIT(14)
#define SDE_MDP_OP_FLIP_LR				BIT(13)
#define SDE_MDP_OP_BWC_EN				BIT(0)
#define SDE_MDP_OP_BWC_LOSSLESS				(0 << 1)
#define SDE_MDP_OP_BWC_Q_HIGH				(1 << 1)
#define SDE_MDP_OP_BWC_Q_MED				(2 << 1)

#define SDE_MDP_REG_SSPP_SRC_CONSTANT_COLOR		0x03C
#define SDE_MDP_REG_SSPP_FETCH_CONFIG			0x048
#define SDE_MDP_REG_SSPP_VC1_RANGE			0x04C
#define SDE_MDP_REG_SSPP_SRC_ADDR_SW_STATUS		0x070
#define SDE_MDP_REG_SSPP_CURRENT_SRC0_ADDR		0x0A4
#define SDE_MDP_REG_SSPP_CURRENT_SRC1_ADDR		0x0A8
#define SDE_MDP_REG_SSPP_CURRENT_SRC2_ADDR		0x0AC
#define SDE_MDP_REG_SSPP_CURRENT_SRC3_ADDR		0x0B0
#define SDE_MDP_REG_SSPP_DECIMATION_CONFIG		0x0B4

enum sde_mdp_mixer_wb_index {
	SDE_MDP_WB_LAYERMIXER0,
	SDE_MDP_WB_LAYERMIXER1,
	SDE_MDP_WB_MAX_LAYERMIXER,
};

enum mdss_mdp_writeback_index {
	SDE_MDP_WRITEBACK0,
	SDE_MDP_WRITEBACK1,
	SDE_MDP_WRITEBACK2,
	SDE_MDP_WRITEBACK3,
	SDE_MDP_WRITEBACK4,
	SDE_MDP_MAX_WRITEBACK
};

#define SDE_MDP_REG_WB_DST_FORMAT			0x000
#define SDE_MDP_REG_WB_DST_OP_MODE			0x004
#define SDE_MDP_REG_WB_DST_PACK_PATTERN			0x008
#define SDE_MDP_REG_WB_DST0_ADDR			0x00C
#define SDE_MDP_REG_WB_DST1_ADDR			0x010
#define SDE_MDP_REG_WB_DST2_ADDR			0x014
#define SDE_MDP_REG_WB_DST3_ADDR			0x018
#define SDE_MDP_REG_WB_DST_YSTRIDE0			0x01C
#define SDE_MDP_REG_WB_DST_YSTRIDE1			0x020
#define SDE_MDP_REG_WB_DST_WRITE_CONFIG			0x048
#define SDE_MDP_REG_WB_ROTATION_DNSCALER		0x050
#define SDE_MDP_REG_WB_ROTATOR_PIPE_DOWNSCALER		0x054
#define SDE_MDP_REG_WB_OUT_SIZE				0x074
#define SDE_MDP_REG_WB_ALPHA_X_VALUE			0x078
#define SDE_MDP_REG_WB_DST_ADDR_SW_STATUS		0x2B0

#endif
