/* SPDX-License-Identifier: GPL-2.0-only */
/* Copyright (c) 2018, The Linux Foundation. All rights reserved.
 */

#ifndef _AQT1000_REGISTERS_H
#define _AQT1000_REGISTERS_H

#define AQT1000_PAGE0_BASE                  (0x00000000)
#define AQT1000_PAGE0_PAGE_REGISTER                       (0x00000000)
#define AQT1000_CHIP_CFG0_BASE              (0x00000001)
#define AQT1000_CHIP_CFG0_CHIP_ID_BYTE0                   (0x00000001)
#define AQT1000_CHIP_CFG0_CHIP_ID_BYTE1                   (0x00000002)
#define AQT1000_CHIP_CFG0_CHIP_ID_BYTE2                   (0x00000003)
#define AQT1000_CHIP_CFG0_CHIP_ID_BYTE3                   (0x00000004)
#define AQT1000_CHIP_CFG0_EFUSE_CTL                       (0x00000005)
#define AQT1000_CHIP_CFG0_EFUSE_TEST0                     (0x00000006)
#define AQT1000_CHIP_CFG0_EFUSE_TEST1                     (0x00000007)
#define AQT1000_CHIP_CFG0_EFUSE_VAL_OUT0                  (0x00000009)
#define AQT1000_CHIP_CFG0_EFUSE_VAL_OUT1                  (0x0000000A)
#define AQT1000_CHIP_CFG0_EFUSE_VAL_OUT2                  (0x0000000B)
#define AQT1000_CHIP_CFG0_EFUSE_VAL_OUT3                  (0x0000000C)
#define AQT1000_CHIP_CFG0_EFUSE_VAL_OUT4                  (0x0000000D)
#define AQT1000_CHIP_CFG0_EFUSE_VAL_OUT5                  (0x0000000E)
#define AQT1000_CHIP_CFG0_EFUSE_VAL_OUT6                  (0x0000000F)
#define AQT1000_CHIP_CFG0_EFUSE_VAL_OUT7                  (0x00000010)
#define AQT1000_CHIP_CFG0_EFUSE_VAL_OUT8                  (0x00000011)
#define AQT1000_CHIP_CFG0_EFUSE_VAL_OUT9                  (0x00000012)
#define AQT1000_CHIP_CFG0_EFUSE_VAL_OUT10                 (0x00000013)
#define AQT1000_CHIP_CFG0_EFUSE_VAL_OUT11                 (0x00000014)
#define AQT1000_CHIP_CFG0_EFUSE_VAL_OUT12                 (0x00000015)
#define AQT1000_CHIP_CFG0_EFUSE_VAL_OUT13                 (0x00000016)
#define AQT1000_CHIP_CFG0_EFUSE_VAL_OUT14                 (0x00000017)
#define AQT1000_CHIP_CFG0_EFUSE_VAL_OUT15                 (0x00000018)
#define AQT1000_CHIP_CFG0_EFUSE_STATUS                    (0x00000019)
#define AQT1000_CHIP_CFG0_I2C_SLAVE_ID_NONNEGO            (0x0000001A)
#define AQT1000_CHIP_CFG0_I2C_SLAVE_ID_1                  (0x0000001B)
#define AQT1000_CHIP_CFG0_I2C_SLAVE_ID_2                  (0x0000001C)
#define AQT1000_CHIP_CFG0_I2C_SLAVE_ID_3                  (0x0000001D)
#define AQT1000_CHIP_CFG0_I2C_ACTIVE                      (0x00000020)
#define AQT1000_CHIP_CFG0_CLK_CFG_MCLK                    (0x00000021)
#define AQT1000_CHIP_CFG0_CLK_CFG_MCLK2                   (0x00000022)
#define AQT1000_CHIP_CFG0_CLK_CTL_CDC_DIG                 (0x00000023)
#define AQT1000_CHIP_CFG0_RST_CTL                         (0x00000032)
#define AQT1000_CHIP_CFG0_EFUSE2_CTL                      (0x0000003D)
#define AQT1000_CHIP_CFG0_EFUSE2_TEST0                    (0x0000003E)
#define AQT1000_CHIP_CFG0_EFUSE2_TEST1                    (0x0000003F)
#define AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT0                 (0x00000040)
#define AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT1                 (0x00000041)
#define AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT2                 (0x00000042)
#define AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT3                 (0x00000043)
#define AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT4                 (0x00000044)
#define AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT5                 (0x00000045)
#define AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT6                 (0x00000046)
#define AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT7                 (0x00000047)
#define AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT8                 (0x00000048)
#define AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT9                 (0x00000049)
#define AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT10                (0x0000004A)
#define AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT11                (0x0000004B)
#define AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT12                (0x0000004C)
#define AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT13                (0x0000004D)
#define AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT14                (0x0000004E)
#define AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT15                (0x0000004F)
#define AQT1000_CHIP_CFG0_EFUSE2_STATUS                   (0x00000050)
#define AQT1000_CHIP_CFG1_BASE              (0x00000051)
#define AQT1000_CHIP_CFG1_PWR_CTL                         (0x00000051)
#define AQT1000_CHIP_CFG1_BUS_MTRX_CFG                    (0x00000052)
#define AQT1000_CHIP_CFG1_DMA_BUS_VOTE                    (0x00000053)
#define AQT1000_CHIP_CFG1_USB_BUS_VOTE                    (0x00000054)
#define AQT1000_CHIP_CFG1_BLSP_BUS_VOTE                   (0x00000055)
#define AQT1000_CHIP_CFG1_PWR_MEM_SD                      (0x00000059)
#define AQT1000_CHIP_CFG1_PWR_SYS_MEM_SD_RAM              (0x0000005C)
#define AQT1000_CHIP_CFG1_PWR_SYS_MEM_SD_ROM              (0x0000005D)
#define AQT1000_CHIP_CFG1_PWR_SYS_MEM_FORCE_DS_RAM        (0x0000005E)
#define AQT1000_CHIP_CFG1_PWR_SYS_MEM_FORCE_DS_ROM        (0x0000005F)
#define AQT1000_CHIP_CFG1_CLK_CFG_FLL                     (0x00000061)
#define AQT1000_CHIP_CFG1_CLK_CFG_SPI_M                   (0x00000062)
#define AQT1000_CHIP_CFG1_CLK_CFG_I2C_M                   (0x00000063)
#define AQT1000_CHIP_CFG1_CLK_CFG_UART                    (0x00000064)
#define AQT1000_CHIP_CFG1_RST_USB_SS                      (0x00000071)
#define AQT1000_CHIP_CFG1_RST_BLSP                        (0x00000072)
#define AQT1000_CHIP_CFG1_RST_BUS_MTRX                    (0x00000073)
#define AQT1000_CHIP_CFG1_RST_MISC                        (0x00000074)
#define AQT1000_CHIP_CFG1_ANA_WAIT_STATE_CTL              (0x00000081)
#define AQT1000_PAGE1_BASE                  (0x00000100)
#define AQT1000_PAGE1_PAGE_REGISTER                       (0x00000100)
#define AQT1000_FLL_BASE                    (0x00000101)
#define AQT1000_FLL_USER_CTL_0                            (0x00000101)
#define AQT1000_FLL_USER_CTL_1                            (0x00000102)
#define AQT1000_FLL_USER_CTL_2                            (0x00000103)
#define AQT1000_FLL_USER_CTL_3                            (0x00000104)
#define AQT1000_FLL_USER_CTL_4                            (0x00000105)
#define AQT1000_FLL_USER_CTL_5                            (0x00000106)
#define AQT1000_FLL_USER_CTL_6                            (0x00000107)
#define AQT1000_FLL_USER_CTL_7                            (0x00000108)
#define AQT1000_FLL_USER_CTL_8                            (0x00000109)
#define AQT1000_FLL_USER_CTL_9                            (0x0000010A)
#define AQT1000_FLL_L_VAL_CTL_0                           (0x0000010B)
#define AQT1000_FLL_L_VAL_CTL_1                           (0x0000010C)
#define AQT1000_FLL_DSM_FRAC_CTL_0                        (0x0000010D)
#define AQT1000_FLL_DSM_FRAC_CTL_1                        (0x0000010E)
#define AQT1000_FLL_CONFIG_CTL_0                          (0x0000010F)
#define AQT1000_FLL_CONFIG_CTL_1                          (0x00000110)
#define AQT1000_FLL_CONFIG_CTL_2                          (0x00000111)
#define AQT1000_FLL_CONFIG_CTL_3                          (0x00000112)
#define AQT1000_FLL_CONFIG_CTL_4                          (0x00000113)
#define AQT1000_FLL_TEST_CTL_0                            (0x00000114)
#define AQT1000_FLL_TEST_CTL_1                            (0x00000115)
#define AQT1000_FLL_TEST_CTL_2                            (0x00000116)
#define AQT1000_FLL_TEST_CTL_3                            (0x00000117)
#define AQT1000_FLL_TEST_CTL_4                            (0x00000118)
#define AQT1000_FLL_TEST_CTL_5                            (0x00000119)
#define AQT1000_FLL_TEST_CTL_6                            (0x0000011A)
#define AQT1000_FLL_TEST_CTL_7                            (0x0000011B)
#define AQT1000_FLL_FREQ_CTL_0                            (0x0000011C)
#define AQT1000_FLL_FREQ_CTL_1                            (0x0000011D)
#define AQT1000_FLL_FREQ_CTL_2                            (0x0000011E)
#define AQT1000_FLL_FREQ_CTL_3                            (0x0000011F)
#define AQT1000_FLL_SSC_CTL_0                             (0x00000120)
#define AQT1000_FLL_SSC_CTL_1                             (0x00000121)
#define AQT1000_FLL_SSC_CTL_2                             (0x00000122)
#define AQT1000_FLL_SSC_CTL_3                             (0x00000123)
#define AQT1000_FLL_FLL_MODE                              (0x00000124)
#define AQT1000_FLL_STATUS_0                              (0x00000125)
#define AQT1000_FLL_STATUS_1                              (0x00000126)
#define AQT1000_FLL_STATUS_2                              (0x00000127)
#define AQT1000_FLL_STATUS_3                              (0x00000128)
#define AQT1000_PAGE2_BASE                  (0x00000200)
#define AQT1000_PAGE2_PAGE_REGISTER                       (0x00000200)
#define AQT1000_I2S_BASE                    (0x00000201)
#define AQT1000_I2S_I2S_0_TX_CFG                          (0x00000201)
#define AQT1000_I2S_I2S_0_RX_CFG                          (0x00000202)
#define AQT1000_I2S_I2S_0_CTL                             (0x00000203)
#define AQT1000_I2S_I2S_CLKSRC_CTL                        (0x00000204)
#define AQT1000_I2S_I2S_HS_CLK_CTL                        (0x00000205)
#define AQT1000_I2S_I2S_0_RST                             (0x00000206)
#define AQT1000_I2S_SHADOW_I2S_0_CTL                      (0x00000207)
#define AQT1000_I2S_SHADOW_I2S_0_RX_CFG                   (0x00000208)
#define AQT1000_PAGE5_BASE                  (0x00000500)
#define AQT1000_PAGE5_PAGE_REGISTER                       (0x00000500)
#define AQT1000_INTR_CTRL_INTR_CTRL_BASE    (0x00000501)
#define AQT1000_INTR_CTRL_MCU_INT_POLARITY                (0x00000501)
#define AQT1000_INTR_CTRL_INT_MASK_0                      (0x00000502)
#define AQT1000_INTR_CTRL_INT_MASK_1                      (0x00000503)
#define AQT1000_INTR_CTRL_INT_MASK_2                      (0x00000504)
#define AQT1000_INTR_CTRL_INT_MASK_3                      (0x00000505)
#define AQT1000_INTR_CTRL_INT_MASK_4                      (0x00000506)
#define AQT1000_INTR_CTRL_INT_MASK_5                      (0x00000507)
#define AQT1000_INTR_CTRL_INT_MASK_6                      (0x00000508)
#define AQT1000_INTR_CTRL_INT_STATUS_0                    (0x00000509)
#define AQT1000_INTR_CTRL_INT_STATUS_1                    (0x0000050A)
#define AQT1000_INTR_CTRL_INT_STATUS_2                    (0x0000050B)
#define AQT1000_INTR_CTRL_INT_STATUS_3                    (0x0000050C)
#define AQT1000_INTR_CTRL_INT_STATUS_4                    (0x0000050D)
#define AQT1000_INTR_CTRL_INT_STATUS_5                    (0x0000050E)
#define AQT1000_INTR_CTRL_INT_STATUS_6                    (0x0000050F)
#define AQT1000_INTR_CTRL_INT_CLEAR_0                     (0x00000510)
#define AQT1000_INTR_CTRL_INT_CLEAR_1                     (0x00000511)
#define AQT1000_INTR_CTRL_INT_CLEAR_2                     (0x00000512)
#define AQT1000_INTR_CTRL_INT_CLEAR_3                     (0x00000513)
#define AQT1000_INTR_CTRL_INT_CLEAR_4                     (0x00000514)
#define AQT1000_INTR_CTRL_INT_CLEAR_5                     (0x00000515)
#define AQT1000_INTR_CTRL_INT_CLEAR_6                     (0x00000516)
#define AQT1000_INTR_CTRL_INT_TYPE_0                      (0x00000517)
#define AQT1000_INTR_CTRL_INT_TYPE_1                      (0x00000518)
#define AQT1000_INTR_CTRL_INT_TYPE_2                      (0x00000519)
#define AQT1000_INTR_CTRL_INT_TYPE_3                      (0x0000051A)
#define AQT1000_INTR_CTRL_INT_TYPE_4                      (0x0000051B)
#define AQT1000_INTR_CTRL_INT_TYPE_5                      (0x0000051C)
#define AQT1000_INTR_CTRL_INT_TYPE_6                      (0x0000051D)
#define AQT1000_INTR_CTRL_INT_TEST_EN_0                   (0x0000051E)
#define AQT1000_INTR_CTRL_INT_TEST_EN_1                   (0x0000051F)
#define AQT1000_INTR_CTRL_INT_TEST_EN_2                   (0x00000520)
#define AQT1000_INTR_CTRL_INT_TEST_EN_3                   (0x00000521)
#define AQT1000_INTR_CTRL_INT_TEST_EN_4                   (0x00000522)
#define AQT1000_INTR_CTRL_INT_TEST_EN_5                   (0x00000523)
#define AQT1000_INTR_CTRL_INT_TEST_EN_6                   (0x00000524)
#define AQT1000_INTR_CTRL_INT_TEST_VAL_0                  (0x00000525)
#define AQT1000_INTR_CTRL_INT_TEST_VAL_1                  (0x00000526)
#define AQT1000_INTR_CTRL_INT_TEST_VAL_2                  (0x00000527)
#define AQT1000_INTR_CTRL_INT_TEST_VAL_3                  (0x00000528)
#define AQT1000_INTR_CTRL_INT_TEST_VAL_4                  (0x00000529)
#define AQT1000_INTR_CTRL_INT_TEST_VAL_5                  (0x0000052A)
#define AQT1000_INTR_CTRL_INT_TEST_VAL_6                  (0x0000052B)
#define AQT1000_INTR_CTRL_INT_DEST_0                      (0x0000052C)
#define AQT1000_INTR_CTRL_INT_DEST_1                      (0x0000052D)
#define AQT1000_INTR_CTRL_INT_DEST_2                      (0x0000052E)
#define AQT1000_INTR_CTRL_INT_DEST_3                      (0x0000052F)
#define AQT1000_INTR_CTRL_INT_DEST_4                      (0x00000530)
#define AQT1000_INTR_CTRL_INT_DEST_5                      (0x00000531)
#define AQT1000_INTR_CTRL_INT_DEST_6                      (0x00000532)
#define AQT1000_INTR_CTRL_INT_DEST_7                      (0x00000533)
#define AQT1000_INTR_CTRL_INT_DEST_8                      (0x00000534)
#define AQT1000_INTR_CTRL_INT_DEST_9                      (0x00000535)
#define AQT1000_INTR_CTRL_INT_DEST_10                     (0x00000536)
#define AQT1000_INTR_CTRL_INT_DEST_11                     (0x00000537)
#define AQT1000_INTR_CTRL_INT_DEST_12                     (0x00000538)
#define AQT1000_INTR_CTRL_INT_DEST_13                     (0x00000539)
#define AQT1000_INTR_CTRL_CLR_COMMIT                      (0x000005E1)
#define AQT1000_ANA_BASE                    (0x00000600)
#define AQT1000_ANA_PAGE_REGISTER                         (0x00000600)
#define AQT1000_ANA_BIAS                                  (0x00000601)
#define AQT1000_ANA_RX_SUPPLIES                           (0x00000608)
#define AQT1000_ANA_HPH                                   (0x00000609)
#define AQT1000_ANA_AMIC1                                 (0x0000060E)
#define AQT1000_ANA_AMIC2                                 (0x0000060F)
#define AQT1000_ANA_AMIC3                                 (0x00000610)
#define AQT1000_ANA_AMIC3_HPF                             (0x00000611)
#define AQT1000_ANA_MBHC_MECH                             (0x00000614)
#define AQT1000_ANA_MBHC_ELECT                            (0x00000615)
#define AQT1000_ANA_MBHC_ZDET                             (0x00000616)
#define AQT1000_ANA_MBHC_RESULT_1                         (0x00000617)
#define AQT1000_ANA_MBHC_RESULT_2                         (0x00000618)
#define AQT1000_ANA_MBHC_RESULT_3                         (0x00000619)
#define AQT1000_ANA_MBHC_BTN0                             (0x0000061A)
#define AQT1000_ANA_MBHC_BTN1                             (0x0000061B)
#define AQT1000_ANA_MBHC_BTN2                             (0x0000061C)
#define AQT1000_ANA_MBHC_BTN3                             (0x0000061D)
#define AQT1000_ANA_MBHC_BTN4                             (0x0000061E)
#define AQT1000_ANA_MBHC_BTN5                             (0x0000061F)
#define AQT1000_ANA_MBHC_BTN6                             (0x00000620)
#define AQT1000_ANA_MBHC_BTN7                             (0x00000621)
#define AQT1000_ANA_MICB1                                 (0x00000622)
#define AQT1000_ANA_MICB1_RAMP                            (0x00000624)
#define AQT1000_BIAS_BASE                   (0x00000628)
#define AQT1000_BIAS_CTL                                  (0x00000628)
#define AQT1000_BIAS_CCOMP_FINE_ADJ                       (0x00000629)
#define AQT1000_LED_BASE                    (0x0000062E)
#define AQT1000_LED_LED_MODE_SEL_R                        (0x0000062E)
#define AQT1000_LED_LED_MISC_R                            (0x0000062F)
#define AQT1000_LED_LED_MODE_SEL_G                        (0x00000630)
#define AQT1000_LED_LED_MISC_G                            (0x00000631)
#define AQT1000_LED_LED_MODE_SEL_B                        (0x00000632)
#define AQT1000_LED_LED_MISC_B                            (0x00000633)
#define AQT1000_LDOH_BASE                   (0x0000063A)
#define AQT1000_LDOH_MODE                                 (0x0000063A)
#define AQT1000_LDOH_BIAS                                 (0x0000063B)
#define AQT1000_LDOH_STB_LOADS                            (0x0000063C)
#define AQT1000_LDOH_MISC1                                (0x0000063D)
#define AQT1000_LDOL_BASE                   (0x00000640)
#define AQT1000_LDOL_VDDCX_ADJUST                         (0x00000640)
#define AQT1000_LDOL_DISABLE_LDOL                         (0x00000641)
#define AQT1000_BUCK_5V_BASE                (0x00000644)
#define AQT1000_BUCK_5V_EN_CTL                            (0x00000644)
#define AQT1000_BUCK_5V_VOUT_SEL                          (0x00000645)
#define AQT1000_BUCK_5V_CTRL_VCL_1                        (0x00000646)
#define AQT1000_BUCK_5V_CTRL_VCL_2                        (0x00000647)
#define AQT1000_BUCK_5V_CTRL_CCL_2                        (0x00000648)
#define AQT1000_BUCK_5V_CTRL_CCL_1                        (0x00000649)
#define AQT1000_BUCK_5V_CTRL_CCL_3                        (0x0000064A)
#define AQT1000_BUCK_5V_CTRL_CCL_4                        (0x0000064B)
#define AQT1000_BUCK_5V_CTRL_CCL_5                        (0x0000064C)
#define AQT1000_BUCK_5V_IBIAS_CTL_1                       (0x0000064D)
#define AQT1000_BUCK_5V_IBIAS_CTL_2                       (0x0000064E)
#define AQT1000_BUCK_5V_IBIAS_CTL_3                       (0x0000064F)
#define AQT1000_BUCK_5V_IBIAS_CTL_4                       (0x00000650)
#define AQT1000_BUCK_5V_IBIAS_CTL_5                       (0x00000651)
#define AQT1000_BUCK_5V_ATEST_DTEST_CTL                   (0x00000652)
#define AQT1000_PON_BASE                    (0x00000653)
#define AQT1000_PON_BG_CTRL                               (0x00000653)
#define AQT1000_PON_TEST_CTRL                             (0x00000654)
#define AQT1000_MBHC_BASE                   (0x00000656)
#define AQT1000_MBHC_CTL_CLK                              (0x00000656)
#define AQT1000_MBHC_CTL_ANA                              (0x00000657)
#define AQT1000_MBHC_CTL_SPARE_1                          (0x00000658)
#define AQT1000_MBHC_CTL_SPARE_2                          (0x00000659)
#define AQT1000_MBHC_CTL_BCS                              (0x0000065A)
#define AQT1000_MBHC_MOISTURE_DET_FSM_STATUS              (0x0000065B)
#define AQT1000_MBHC_TEST_CTL                             (0x0000065C)
#define AQT1000_MICB1_BASE                  (0x0000066B)
#define AQT1000_MICB1_TEST_CTL_1                          (0x0000066B)
#define AQT1000_MICB1_TEST_CTL_2                          (0x0000066C)
#define AQT1000_MICB1_TEST_CTL_3                          (0x0000066D)
#define AQT1000_MICB1_MISC_BASE             (0x0000066E)
#define AQT1000_MICB1_MISC_MICB1_INM_RES_BIAS             (0x0000066E)
#define AQT1000_MICB1_MISC_MICB_MISC1                     (0x0000066F)
#define AQT1000_MICB1_MISC_MICB_MISC2                     (0x00000670)
#define AQT1000_TX_COM_BASE                 (0x00000677)
#define AQT1000_TX_COM_ADC_VCM                            (0x00000677)
#define AQT1000_TX_COM_BIAS_ATEST                         (0x00000678)
#define AQT1000_TX_COM_ADC_INT1_IB                        (0x00000679)
#define AQT1000_TX_COM_ADC_INT2_IB                        (0x0000067A)
#define AQT1000_TX_COM_TXFE_DIV_CTL                       (0x0000067B)
#define AQT1000_TX_COM_TXFE_DIV_START                     (0x0000067C)
#define AQT1000_TX_COM_TXFE_DIV_STOP_9P6M                 (0x0000067D)
#define AQT1000_TX_COM_TXFE_DIV_STOP_12P288M              (0x0000067E)
#define AQT1000_TX_1_2_BASE                 (0x0000067F)
#define AQT1000_TX_1_2_TEST_EN                            (0x0000067F)
#define AQT1000_TX_1_2_ADC_IB                             (0x00000680)
#define AQT1000_TX_1_2_ATEST_REFCTL                       (0x00000681)
#define AQT1000_TX_1_2_TEST_CTL                           (0x00000682)
#define AQT1000_TX_1_2_TEST_BLK_EN                        (0x00000683)
#define AQT1000_TX_1_2_TXFE_CLKDIV                        (0x00000684)
#define AQT1000_TX_1_2_SAR1_ERR                           (0x00000685)
#define AQT1000_TX_1_2_SAR2_ERR                           (0x00000686)
#define AQT1000_TX_3_BASE                   (0x00000687)
#define AQT1000_TX_3_TEST_EN                              (0x00000687)
#define AQT1000_TX_3_ADC_IB                               (0x00000688)
#define AQT1000_TX_3_ATEST_REFCTL                         (0x00000689)
#define AQT1000_TX_3_TEST_CTL                             (0x0000068A)
#define AQT1000_TX_3_TEST_BLK_EN                          (0x0000068B)
#define AQT1000_TX_3_TXFE_CLKDIV                          (0x0000068C)
#define AQT1000_TX_3_SAR1_ERR                             (0x0000068D)
#define AQT1000_TX_3_SAR2_ERR                             (0x0000068E)
#define AQT1000_TX_BASE                     (0x0000068F)
#define AQT1000_TX_ATEST1_2_SEL                           (0x0000068F)
#define AQT1000_CLASSH_BASE                 (0x00000697)
#define AQT1000_CLASSH_MODE_1                             (0x00000697)
#define AQT1000_CLASSH_MODE_2                             (0x00000698)
#define AQT1000_CLASSH_MODE_3                             (0x00000699)
#define AQT1000_CLASSH_CTRL_VCL_1                         (0x0000069A)
#define AQT1000_CLASSH_CTRL_VCL_2                         (0x0000069B)
#define AQT1000_CLASSH_CTRL_CCL_1                         (0x0000069C)
#define AQT1000_CLASSH_CTRL_CCL_2                         (0x0000069D)
#define AQT1000_CLASSH_CTRL_CCL_3                         (0x0000069E)
#define AQT1000_CLASSH_CTRL_CCL_4                         (0x0000069F)
#define AQT1000_CLASSH_CTRL_CCL_5                         (0x000006A0)
#define AQT1000_CLASSH_BUCK_TMUX_A_D                      (0x000006A1)
#define AQT1000_CLASSH_BUCK_SW_DRV_CNTL                   (0x000006A2)
#define AQT1000_CLASSH_SPARE                              (0x000006A3)
#define AQT1000_FLYBACK_BASE                (0x000006A4)
#define AQT1000_FLYBACK_EN                                (0x000006A4)
#define AQT1000_FLYBACK_VNEG_CTRL_1                       (0x000006A5)
#define AQT1000_FLYBACK_VNEG_CTRL_2                       (0x000006A6)
#define AQT1000_FLYBACK_VNEG_CTRL_3                       (0x000006A7)
#define AQT1000_FLYBACK_VNEG_CTRL_4                       (0x000006A8)
#define AQT1000_FLYBACK_VNEG_CTRL_5                       (0x000006A9)
#define AQT1000_FLYBACK_VNEG_CTRL_6                       (0x000006AA)
#define AQT1000_FLYBACK_VNEG_CTRL_7                       (0x000006AB)
#define AQT1000_FLYBACK_VNEG_CTRL_8                       (0x000006AC)
#define AQT1000_FLYBACK_VNEG_CTRL_9                       (0x000006AD)
#define AQT1000_FLYBACK_VNEGDAC_CTRL_1                    (0x000006AE)
#define AQT1000_FLYBACK_VNEGDAC_CTRL_2                    (0x000006AF)
#define AQT1000_FLYBACK_VNEGDAC_CTRL_3                    (0x000006B0)
#define AQT1000_FLYBACK_CTRL_1                            (0x000006B1)
#define AQT1000_FLYBACK_TEST_CTL                          (0x000006B2)
#define AQT1000_RX_BASE                     (0x000006B3)
#define AQT1000_RX_AUX_SW_CTL                             (0x000006B3)
#define AQT1000_RX_PA_AUX_IN_CONN                         (0x000006B4)
#define AQT1000_RX_TIMER_DIV                              (0x000006B5)
#define AQT1000_RX_OCP_CTL                                (0x000006B6)
#define AQT1000_RX_OCP_COUNT                              (0x000006B7)
#define AQT1000_RX_BIAS_ATEST                             (0x000006B8)
#define AQT1000_RX_BIAS_MISC1                             (0x000006B9)
#define AQT1000_RX_BIAS_HPH_LDO                           (0x000006BA)
#define AQT1000_RX_BIAS_HPH_PA                            (0x000006BB)
#define AQT1000_RX_BIAS_HPH_RDACBUFF_CNP2                 (0x000006BC)
#define AQT1000_RX_BIAS_HPH_RDAC_LDO                      (0x000006BD)
#define AQT1000_RX_BIAS_HPH_CNP1                          (0x000006BE)
#define AQT1000_RX_BIAS_HPH_LOWPOWER                      (0x000006BF)
#define AQT1000_RX_BIAS_MISC2                             (0x000006C0)
#define AQT1000_RX_BIAS_MISC3                             (0x000006C1)
#define AQT1000_RX_BIAS_MISC4                             (0x000006C2)
#define AQT1000_RX_BIAS_MISC5                             (0x000006C3)
#define AQT1000_RX_BIAS_BUCK_RST                          (0x000006C4)
#define AQT1000_RX_BIAS_BUCK_VREF_ERRAMP                  (0x000006C5)
#define AQT1000_RX_BIAS_FLYB_ERRAMP                       (0x000006C6)
#define AQT1000_RX_BIAS_FLYB_BUFF                         (0x000006C7)
#define AQT1000_RX_BIAS_FLYB_MID_RST                      (0x000006C8)
#define AQT1000_HPH_BASE                    (0x000006C9)
#define AQT1000_HPH_L_STATUS                              (0x000006C9)
#define AQT1000_HPH_R_STATUS                              (0x000006CA)
#define AQT1000_HPH_CNP_EN                                (0x000006CB)
#define AQT1000_HPH_CNP_WG_CTL                            (0x000006CC)
#define AQT1000_HPH_CNP_WG_TIME                           (0x000006CD)
#define AQT1000_HPH_OCP_CTL                               (0x000006CE)
#define AQT1000_HPH_AUTO_CHOP                             (0x000006CF)
#define AQT1000_HPH_CHOP_CTL                              (0x000006D0)
#define AQT1000_HPH_PA_CTL1                               (0x000006D1)
#define AQT1000_HPH_PA_CTL2                               (0x000006D2)
#define AQT1000_HPH_L_EN                                  (0x000006D3)
#define AQT1000_HPH_L_TEST                                (0x000006D4)
#define AQT1000_HPH_L_ATEST                               (0x000006D5)
#define AQT1000_HPH_R_EN                                  (0x000006D6)
#define AQT1000_HPH_R_TEST                                (0x000006D7)
#define AQT1000_HPH_R_ATEST                               (0x000006D8)
#define AQT1000_HPH_RDAC_CLK_CTL1                         (0x000006D9)
#define AQT1000_HPH_RDAC_CLK_CTL2                         (0x000006DA)
#define AQT1000_HPH_RDAC_LDO_CTL                          (0x000006DB)
#define AQT1000_HPH_RDAC_CHOP_CLK_LP_CTL                  (0x000006DC)
#define AQT1000_HPH_REFBUFF_UHQA_CTL                      (0x000006DD)
#define AQT1000_HPH_REFBUFF_LP_CTL                        (0x000006DE)
#define AQT1000_HPH_L_DAC_CTL                             (0x000006DF)
#define AQT1000_HPH_R_DAC_CTL                             (0x000006E0)
#define AQT1000_HPHLR_BASE                  (0x000006E1)
#define AQT1000_HPHLR_SURGE_COMP_SEL                      (0x000006E1)
#define AQT1000_HPHLR_SURGE_EN                            (0x000006E2)
#define AQT1000_HPHLR_SURGE_MISC1                         (0x000006E3)
#define AQT1000_HPHLR_SURGE_STATUS                        (0x000006E4)
#define AQT1000_ANA_NEW_BASE                (0x00000700)
#define AQT1000_ANA_NEW_PAGE_REGISTER                     (0x00000700)
#define AQT1000_HPH_NEW_BASE                (0x00000701)
#define AQT1000_HPH_NEW_ANA_HPH2                          (0x00000701)
#define AQT1000_HPH_NEW_ANA_HPH3                          (0x00000702)
#define AQT1000_CLK_SYS_BASE                (0x0000070E)
#define AQT1000_CLK_SYS_MCLK1_PRG                         (0x0000070E)
#define AQT1000_CLK_SYS_MCLK2_I2S_HS_CLK_PRG              (0x0000070F)
#define AQT1000_CLK_SYS_XO_CAP_XTP                        (0x00000710)
#define AQT1000_CLK_SYS_XO_CAP_XTM                        (0x00000711)
#define AQT1000_CLK_SYS_PLL_ENABLES                       (0x00000712)
#define AQT1000_CLK_SYS_PLL_PRESET                        (0x00000713)
#define AQT1000_CLK_SYS_PLL_STATUS                        (0x00000714)
#define AQT1000_MBHC_NEW_BASE               (0x0000071F)
#define AQT1000_MBHC_NEW_ELECT_REM_CLAMP_CTL              (0x0000071F)
#define AQT1000_MBHC_NEW_CTL_1                            (0x00000720)
#define AQT1000_MBHC_NEW_CTL_2                            (0x00000721)
#define AQT1000_MBHC_NEW_PLUG_DETECT_CTL                  (0x00000722)
#define AQT1000_MBHC_NEW_ZDET_ANA_CTL                     (0x00000723)
#define AQT1000_MBHC_NEW_ZDET_RAMP_CTL                    (0x00000724)
#define AQT1000_MBHC_NEW_FSM_STATUS                       (0x00000725)
#define AQT1000_MBHC_NEW_ADC_RESULT                       (0x00000726)
#define AQT1000_HPH_NEW_INT_BASE            (0x00000732)
#define AQT1000_HPH_NEW_INT_RDAC_GAIN_CTL                 (0x00000732)
#define AQT1000_HPH_NEW_INT_RDAC_HD2_CTL_L                (0x00000733)
#define AQT1000_HPH_NEW_INT_RDAC_VREF_CTL                 (0x00000734)
#define AQT1000_HPH_NEW_INT_RDAC_OVERRIDE_CTL             (0x00000735)
#define AQT1000_HPH_NEW_INT_RDAC_HD2_CTL_R                (0x00000736)
#define AQT1000_HPH_NEW_INT_PA_MISC1                      (0x00000737)
#define AQT1000_HPH_NEW_INT_PA_MISC2                      (0x00000738)
#define AQT1000_HPH_NEW_INT_PA_RDAC_MISC                  (0x00000739)
#define AQT1000_HPH_NEW_INT_HPH_TIMER1                    (0x0000073A)
#define AQT1000_HPH_NEW_INT_HPH_TIMER2                    (0x0000073B)
#define AQT1000_HPH_NEW_INT_HPH_TIMER3                    (0x0000073C)
#define AQT1000_HPH_NEW_INT_HPH_TIMER4                    (0x0000073D)
#define AQT1000_HPH_NEW_INT_PA_RDAC_MISC2                 (0x0000073E)
#define AQT1000_HPH_NEW_INT_PA_RDAC_MISC3                 (0x0000073F)
#define AQT1000_RX_NEW_INT_BASE             (0x00000745)
#define AQT1000_RX_NEW_INT_HPH_RDAC_BIAS_LOHIFI           (0x00000745)
#define AQT1000_RX_NEW_INT_HPH_RDAC_BIAS_ULP              (0x00000746)
#define AQT1000_RX_NEW_INT_HPH_RDAC_LDO_LP                (0x00000747)
#define AQT1000_CLK_SYS_INT_BASE            (0x0000076C)
#define AQT1000_CLK_SYS_INT_CLK_TEST1                     (0x0000076C)
#define AQT1000_CLK_SYS_INT_XO_TEST1                      (0x0000076D)
#define AQT1000_CLK_SYS_INT_XO_TEST2                      (0x0000076E)
#define AQT1000_CLK_SYS_INT_POST_DIV_REG0                 (0x0000076F)
#define AQT1000_CLK_SYS_INT_POST_DIV_REG1                 (0x00000770)
#define AQT1000_CLK_SYS_INT_REF_DIV_REG0                  (0x00000771)
#define AQT1000_CLK_SYS_INT_REF_DIV_REG1                  (0x00000772)
#define AQT1000_CLK_SYS_INT_FILTER_REG0                   (0x00000773)
#define AQT1000_CLK_SYS_INT_FILTER_REG1                   (0x00000774)
#define AQT1000_CLK_SYS_INT_PLL_L_VAL                     (0x00000775)
#define AQT1000_CLK_SYS_INT_PLL_M_VAL                     (0x00000776)
#define AQT1000_CLK_SYS_INT_PLL_N_VAL                     (0x00000777)
#define AQT1000_CLK_SYS_INT_TEST_REG0                     (0x00000778)
#define AQT1000_CLK_SYS_INT_PFD_CP_DSM_PROG               (0x00000779)
#define AQT1000_CLK_SYS_INT_VCO_PROG                      (0x0000077A)
#define AQT1000_CLK_SYS_INT_TEST_REG1                     (0x0000077B)
#define AQT1000_CLK_SYS_INT_LDO_LOCK_CFG                  (0x0000077C)
#define AQT1000_CLK_SYS_INT_DIG_LOCK_DET_CFG              (0x0000077D)
#define AQT1000_MBHC_NEW_INT_BASE           (0x000007AF)
#define AQT1000_MBHC_NEW_INT_MOISTURE_DET_DC_CTRL         (0x000007AF)
#define AQT1000_MBHC_NEW_INT_MOISTURE_DET_POLLING_CTRL    (0x000007B0)
#define AQT1000_MBHC_NEW_INT_MECH_DET_CURRENT             (0x000007B1)
#define AQT1000_MBHC_NEW_INT_SPARE_2                      (0x000007B2)
#define AQT1000_PAGE10_BASE                 (0x00000A00)
#define AQT1000_PAGE10_PAGE_REGISTER                      (0x00000A00)
#define AQT1000_CDC_ANC0_BASE               (0x00000A01)
#define AQT1000_CDC_ANC0_CLK_RESET_CTL                    (0x00000A01)
#define AQT1000_CDC_ANC0_MODE_1_CTL                       (0x00000A02)
#define AQT1000_CDC_ANC0_MODE_2_CTL                       (0x00000A03)
#define AQT1000_CDC_ANC0_FF_SHIFT                         (0x00000A04)
#define AQT1000_CDC_ANC0_FB_SHIFT                         (0x00000A05)
#define AQT1000_CDC_ANC0_LPF_FF_A_CTL                     (0x00000A06)
#define AQT1000_CDC_ANC0_LPF_FF_B_CTL                     (0x00000A07)
#define AQT1000_CDC_ANC0_LPF_FB_CTL                       (0x00000A08)
#define AQT1000_CDC_ANC0_SMLPF_CTL                        (0x00000A09)
#define AQT1000_CDC_ANC0_DCFLT_SHIFT_CTL                  (0x00000A0A)
#define AQT1000_CDC_ANC0_IIR_ADAPT_CTL                    (0x00000A0B)
#define AQT1000_CDC_ANC0_IIR_COEFF_1_CTL                  (0x00000A0C)
#define AQT1000_CDC_ANC0_IIR_COEFF_2_CTL                  (0x00000A0D)
#define AQT1000_CDC_ANC0_FF_A_GAIN_CTL                    (0x00000A0E)
#define AQT1000_CDC_ANC0_FF_B_GAIN_CTL                    (0x00000A0F)
#define AQT1000_CDC_ANC0_FB_GAIN_CTL                      (0x00000A10)
#define AQT1000_CDC_ANC0_RC_COMMON_CTL                    (0x00000A11)
#define AQT1000_CDC_ANC0_FIFO_COMMON_CTL                  (0x00000A13)
#define AQT1000_CDC_ANC0_RC0_STATUS_FMIN_CNTR             (0x00000A14)
#define AQT1000_CDC_ANC0_RC1_STATUS_FMIN_CNTR             (0x00000A15)
#define AQT1000_CDC_ANC0_RC0_STATUS_FMAX_CNTR             (0x00000A16)
#define AQT1000_CDC_ANC0_RC1_STATUS_FMAX_CNTR             (0x00000A17)
#define AQT1000_CDC_ANC0_STATUS_FIFO                      (0x00000A18)
#define AQT1000_CDC_ANC1_BASE               (0x00000A19)
#define AQT1000_CDC_ANC1_CLK_RESET_CTL                    (0x00000A19)
#define AQT1000_CDC_ANC1_MODE_1_CTL                       (0x00000A1A)
#define AQT1000_CDC_ANC1_MODE_2_CTL                       (0x00000A1B)
#define AQT1000_CDC_ANC1_FF_SHIFT                         (0x00000A1C)
#define AQT1000_CDC_ANC1_FB_SHIFT                         (0x00000A1D)
#define AQT1000_CDC_ANC1_LPF_FF_A_CTL                     (0x00000A1E)
#define AQT1000_CDC_ANC1_LPF_FF_B_CTL                     (0x00000A1F)
#define AQT1000_CDC_ANC1_LPF_FB_CTL                       (0x00000A20)
#define AQT1000_CDC_ANC1_SMLPF_CTL                        (0x00000A21)
#define AQT1000_CDC_ANC1_DCFLT_SHIFT_CTL                  (0x00000A22)
#define AQT1000_CDC_ANC1_IIR_ADAPT_CTL                    (0x00000A23)
#define AQT1000_CDC_ANC1_IIR_COEFF_1_CTL                  (0x00000A24)
#define AQT1000_CDC_ANC1_IIR_COEFF_2_CTL                  (0x00000A25)
#define AQT1000_CDC_ANC1_FF_A_GAIN_CTL                    (0x00000A26)
#define AQT1000_CDC_ANC1_FF_B_GAIN_CTL                    (0x00000A27)
#define AQT1000_CDC_ANC1_FB_GAIN_CTL                      (0x00000A28)
#define AQT1000_CDC_ANC1_RC_COMMON_CTL                    (0x00000A29)
#define AQT1000_CDC_ANC1_FIFO_COMMON_CTL                  (0x00000A2B)
#define AQT1000_CDC_ANC1_RC0_STATUS_FMIN_CNTR             (0x00000A2C)
#define AQT1000_CDC_ANC1_RC1_STATUS_FMIN_CNTR             (0x00000A2D)
#define AQT1000_CDC_ANC1_RC0_STATUS_FMAX_CNTR             (0x00000A2E)
#define AQT1000_CDC_ANC1_RC1_STATUS_FMAX_CNTR             (0x00000A2F)
#define AQT1000_CDC_ANC1_STATUS_FIFO                      (0x00000A30)
#define AQT1000_CDC_TX0_BASE                (0x00000A31)
#define AQT1000_CDC_TX0_TX_PATH_CTL                       (0x00000A31)
#define AQT1000_CDC_TX0_TX_PATH_CFG0                      (0x00000A32)
#define AQT1000_CDC_TX0_TX_PATH_CFG1                      (0x00000A33)
#define AQT1000_CDC_TX0_TX_VOL_CTL                        (0x00000A34)
#define AQT1000_CDC_TX0_TX_PATH_SEC0                      (0x00000A37)
#define AQT1000_CDC_TX0_TX_PATH_SEC1                      (0x00000A38)
#define AQT1000_CDC_TX0_TX_PATH_SEC2                      (0x00000A39)
#define AQT1000_CDC_TX0_TX_PATH_SEC3                      (0x00000A3A)
#define AQT1000_CDC_TX0_TX_PATH_SEC4                      (0x00000A3B)
#define AQT1000_CDC_TX0_TX_PATH_SEC5                      (0x00000A3C)
#define AQT1000_CDC_TX0_TX_PATH_SEC6                      (0x00000A3D)
#define AQT1000_CDC_TX1_BASE                (0x00000A41)
#define AQT1000_CDC_TX1_TX_PATH_CTL                       (0x00000A41)
#define AQT1000_CDC_TX1_TX_PATH_CFG0                      (0x00000A42)
#define AQT1000_CDC_TX1_TX_PATH_CFG1                      (0x00000A43)
#define AQT1000_CDC_TX1_TX_VOL_CTL                        (0x00000A44)
#define AQT1000_CDC_TX1_TX_PATH_SEC0                      (0x00000A47)
#define AQT1000_CDC_TX1_TX_PATH_SEC1                      (0x00000A48)
#define AQT1000_CDC_TX1_TX_PATH_SEC2                      (0x00000A49)
#define AQT1000_CDC_TX1_TX_PATH_SEC3                      (0x00000A4A)
#define AQT1000_CDC_TX1_TX_PATH_SEC4                      (0x00000A4B)
#define AQT1000_CDC_TX1_TX_PATH_SEC5                      (0x00000A4C)
#define AQT1000_CDC_TX1_TX_PATH_SEC6                      (0x00000A4D)
#define AQT1000_CDC_TX2_BASE                (0x00000A51)
#define AQT1000_CDC_TX2_TX_PATH_CTL                       (0x00000A51)
#define AQT1000_CDC_TX2_TX_PATH_CFG0                      (0x00000A52)
#define AQT1000_CDC_TX2_TX_PATH_CFG1                      (0x00000A53)
#define AQT1000_CDC_TX2_TX_VOL_CTL                        (0x00000A54)
#define AQT1000_CDC_TX2_TX_PATH_SEC0                      (0x00000A57)
#define AQT1000_CDC_TX2_TX_PATH_SEC1                      (0x00000A58)
#define AQT1000_CDC_TX2_TX_PATH_SEC2                      (0x00000A59)
#define AQT1000_CDC_TX2_TX_PATH_SEC3                      (0x00000A5A)
#define AQT1000_CDC_TX2_TX_PATH_SEC4                      (0x00000A5B)
#define AQT1000_CDC_TX2_TX_PATH_SEC5                      (0x00000A5C)
#define AQT1000_CDC_TX2_TX_PATH_SEC6                      (0x00000A5D)
#define AQT1000_CDC_TX2_TX_PATH_SEC7                      (0x00000A5E)
#define AQT1000_PAGE11_BASE                 (0x00000B00)
#define AQT1000_PAGE11_PAGE_REGISTER                      (0x00000B00)
#define AQT1000_CDC_COMPANDER1_BASE         (0x00000B01)
#define AQT1000_CDC_COMPANDER1_CTL0                       (0x00000B01)
#define AQT1000_CDC_COMPANDER1_CTL1                       (0x00000B02)
#define AQT1000_CDC_COMPANDER1_CTL2                       (0x00000B03)
#define AQT1000_CDC_COMPANDER1_CTL3                       (0x00000B04)
#define AQT1000_CDC_COMPANDER1_CTL4                       (0x00000B05)
#define AQT1000_CDC_COMPANDER1_CTL5                       (0x00000B06)
#define AQT1000_CDC_COMPANDER1_CTL6                       (0x00000B07)
#define AQT1000_CDC_COMPANDER1_CTL7                       (0x00000B08)
#define AQT1000_CDC_COMPANDER2_BASE         (0x00000B09)
#define AQT1000_CDC_COMPANDER2_CTL0                       (0x00000B09)
#define AQT1000_CDC_COMPANDER2_CTL1                       (0x00000B0A)
#define AQT1000_CDC_COMPANDER2_CTL2                       (0x00000B0B)
#define AQT1000_CDC_COMPANDER2_CTL3                       (0x00000B0C)
#define AQT1000_CDC_COMPANDER2_CTL4                       (0x00000B0D)
#define AQT1000_CDC_COMPANDER2_CTL5                       (0x00000B0E)
#define AQT1000_CDC_COMPANDER2_CTL6                       (0x00000B0F)
#define AQT1000_CDC_COMPANDER2_CTL7                       (0x00000B10)
#define AQT1000_CDC_RX1_BASE                (0x00000B55)
#define AQT1000_CDC_RX1_RX_PATH_CTL                       (0x00000B55)
#define AQT1000_CDC_RX1_RX_PATH_CFG0                      (0x00000B56)
#define AQT1000_CDC_RX1_RX_PATH_CFG1                      (0x00000B57)
#define AQT1000_CDC_RX1_RX_PATH_CFG2                      (0x00000B58)
#define AQT1000_CDC_RX1_RX_VOL_CTL                        (0x00000B59)
#define AQT1000_CDC_RX1_RX_PATH_MIX_CTL                   (0x00000B5A)
#define AQT1000_CDC_RX1_RX_PATH_MIX_CFG                   (0x00000B5B)
#define AQT1000_CDC_RX1_RX_VOL_MIX_CTL                    (0x00000B5C)
#define AQT1000_CDC_RX1_RX_PATH_SEC0                      (0x00000B5D)
#define AQT1000_CDC_RX1_RX_PATH_SEC1                      (0x00000B5E)
#define AQT1000_CDC_RX1_RX_PATH_SEC2                      (0x00000B5F)
#define AQT1000_CDC_RX1_RX_PATH_SEC3                      (0x00000B60)
#define AQT1000_CDC_RX1_RX_PATH_SEC4                      (0x00000B61)
#define AQT1000_CDC_RX1_RX_PATH_SEC5                      (0x00000B62)
#define AQT1000_CDC_RX1_RX_PATH_SEC6                      (0x00000B63)
#define AQT1000_CDC_RX1_RX_PATH_SEC7                      (0x00000B64)
#define AQT1000_CDC_RX1_RX_PATH_MIX_SEC0                  (0x00000B65)
#define AQT1000_CDC_RX1_RX_PATH_MIX_SEC1                  (0x00000B66)
#define AQT1000_CDC_RX1_RX_PATH_DSMDEM_CTL                (0x00000B67)
#define AQT1000_CDC_RX2_BASE                (0x00000B69)
#define AQT1000_CDC_RX2_RX_PATH_CTL                       (0x00000B69)
#define AQT1000_CDC_RX2_RX_PATH_CFG0                      (0x00000B6A)
#define AQT1000_CDC_RX2_RX_PATH_CFG1                      (0x00000B6B)
#define AQT1000_CDC_RX2_RX_PATH_CFG2                      (0x00000B6C)
#define AQT1000_CDC_RX2_RX_VOL_CTL                        (0x00000B6D)
#define AQT1000_CDC_RX2_RX_PATH_MIX_CTL                   (0x00000B6E)
#define AQT1000_CDC_RX2_RX_PATH_MIX_CFG                   (0x00000B6F)
#define AQT1000_CDC_RX2_RX_VOL_MIX_CTL                    (0x00000B70)
#define AQT1000_CDC_RX2_RX_PATH_SEC0                      (0x00000B71)
#define AQT1000_CDC_RX2_RX_PATH_SEC1                      (0x00000B72)
#define AQT1000_CDC_RX2_RX_PATH_SEC2                      (0x00000B73)
#define AQT1000_CDC_RX2_RX_PATH_SEC3                      (0x00000B74)
#define AQT1000_CDC_RX2_RX_PATH_SEC4                      (0x00000B75)
#define AQT1000_CDC_RX2_RX_PATH_SEC5                      (0x00000B76)
#define AQT1000_CDC_RX2_RX_PATH_SEC6                      (0x00000B77)
#define AQT1000_CDC_RX2_RX_PATH_SEC7                      (0x00000B78)
#define AQT1000_CDC_RX2_RX_PATH_MIX_SEC0                  (0x00000B79)
#define AQT1000_CDC_RX2_RX_PATH_MIX_SEC1                  (0x00000B7A)
#define AQT1000_CDC_RX2_RX_PATH_DSMDEM_CTL                (0x00000B7B)
#define AQT1000_CDC_EQ_IIR0_BASE            (0x00000BD1)
#define AQT1000_CDC_EQ_IIR0_PATH_CTL                      (0x00000BD1)
#define AQT1000_CDC_EQ_IIR0_PATH_CFG0                     (0x00000BD2)
#define AQT1000_CDC_EQ_IIR0_PATH_CFG1                     (0x00000BD3)
#define AQT1000_CDC_EQ_IIR0_PATH_CFG2                     (0x00000BD4)
#define AQT1000_CDC_EQ_IIR0_PATH_CFG3                     (0x00000BD5)
#define AQT1000_CDC_EQ_IIR0_COEF_CFG0                     (0x00000BD6)
#define AQT1000_CDC_EQ_IIR0_COEF_CFG1                     (0x00000BD7)
#define AQT1000_CDC_EQ_IIR1_BASE            (0x00000BE1)
#define AQT1000_CDC_EQ_IIR1_PATH_CTL                      (0x00000BE1)
#define AQT1000_CDC_EQ_IIR1_PATH_CFG0                     (0x00000BE2)
#define AQT1000_CDC_EQ_IIR1_PATH_CFG1                     (0x00000BE3)
#define AQT1000_CDC_EQ_IIR1_PATH_CFG2                     (0x00000BE4)
#define AQT1000_CDC_EQ_IIR1_PATH_CFG3                     (0x00000BE5)
#define AQT1000_CDC_EQ_IIR1_COEF_CFG0                     (0x00000BE6)
#define AQT1000_CDC_EQ_IIR1_COEF_CFG1                     (0x00000BE7)
#define AQT1000_PAGE12_BASE                 (0x00000C00)
#define AQT1000_PAGE12_PAGE_REGISTER                      (0x00000C00)
#define AQT1000_CDC_CLSH_CDC_CLSH_BASE      (0x00000C01)
#define AQT1000_CDC_CLSH_CRC                              (0x00000C01)
#define AQT1000_CDC_CLSH_DLY_CTRL                         (0x00000C02)
#define AQT1000_CDC_CLSH_DECAY_CTRL                       (0x00000C03)
#define AQT1000_CDC_CLSH_HPH_V_PA                         (0x00000C04)
#define AQT1000_CDC_CLSH_EAR_V_PA                         (0x00000C05)
#define AQT1000_CDC_CLSH_HPH_V_HD                         (0x00000C06)
#define AQT1000_CDC_CLSH_EAR_V_HD                         (0x00000C07)
#define AQT1000_CDC_CLSH_K1_MSB                           (0x00000C08)
#define AQT1000_CDC_CLSH_K1_LSB                           (0x00000C09)
#define AQT1000_CDC_CLSH_K2_MSB                           (0x00000C0A)
#define AQT1000_CDC_CLSH_K2_LSB                           (0x00000C0B)
#define AQT1000_CDC_CLSH_IDLE_CTRL                        (0x00000C0C)
#define AQT1000_CDC_CLSH_IDLE_HPH                         (0x00000C0D)
#define AQT1000_CDC_CLSH_IDLE_EAR                         (0x00000C0E)
#define AQT1000_CDC_CLSH_TEST0                            (0x00000C0F)
#define AQT1000_CDC_CLSH_TEST1                            (0x00000C10)
#define AQT1000_CDC_CLSH_OVR_VREF                         (0x00000C11)
#define AQT1000_MIXING_ASRC0_BASE           (0x00000C55)
#define AQT1000_MIXING_ASRC0_CLK_RST_CTL                  (0x00000C55)
#define AQT1000_MIXING_ASRC0_CTL0                         (0x00000C56)
#define AQT1000_MIXING_ASRC0_CTL1                         (0x00000C57)
#define AQT1000_MIXING_ASRC0_FIFO_CTL                     (0x00000C58)
#define AQT1000_MIXING_ASRC0_STATUS_FMIN_CNTR_LSB         (0x00000C59)
#define AQT1000_MIXING_ASRC0_STATUS_FMIN_CNTR_MSB         (0x00000C5A)
#define AQT1000_MIXING_ASRC0_STATUS_FMAX_CNTR_LSB         (0x00000C5B)
#define AQT1000_MIXING_ASRC0_STATUS_FMAX_CNTR_MSB         (0x00000C5C)
#define AQT1000_MIXING_ASRC0_STATUS_FIFO                  (0x00000C5D)
#define AQT1000_MIXING_ASRC1_BASE           (0x00000C61)
#define AQT1000_MIXING_ASRC1_CLK_RST_CTL                  (0x00000C61)
#define AQT1000_MIXING_ASRC1_CTL0                         (0x00000C62)
#define AQT1000_MIXING_ASRC1_CTL1                         (0x00000C63)
#define AQT1000_MIXING_ASRC1_FIFO_CTL                     (0x00000C64)
#define AQT1000_MIXING_ASRC1_STATUS_FMIN_CNTR_LSB         (0x00000C65)
#define AQT1000_MIXING_ASRC1_STATUS_FMIN_CNTR_MSB         (0x00000C66)
#define AQT1000_MIXING_ASRC1_STATUS_FMAX_CNTR_LSB         (0x00000C67)
#define AQT1000_MIXING_ASRC1_STATUS_FMAX_CNTR_MSB         (0x00000C68)
#define AQT1000_MIXING_ASRC1_STATUS_FIFO                  (0x00000C69)
#define AQT1000_CDC_SIDETONE_SRC0_BASE      (0x00000CB5)
#define AQT1000_CDC_SIDETONE_SRC0_ST_SRC_PATH_CTL         (0x00000CB5)
#define AQT1000_CDC_SIDETONE_SRC0_ST_SRC_PATH_CFG1        (0x00000CB6)
#define AQT1000_SIDETONE_ASRC0_BASE         (0x00000CBD)
#define AQT1000_SIDETONE_ASRC0_CLK_RST_CTL                (0x00000CBD)
#define AQT1000_SIDETONE_ASRC0_CTL0                       (0x00000CBE)
#define AQT1000_SIDETONE_ASRC0_CTL1                       (0x00000CBF)
#define AQT1000_SIDETONE_ASRC0_FIFO_CTL                   (0x00000CC0)
#define AQT1000_SIDETONE_ASRC0_STATUS_FMIN_CNTR_LSB       (0x00000CC1)
#define AQT1000_SIDETONE_ASRC0_STATUS_FMIN_CNTR_MSB       (0x00000CC2)
#define AQT1000_SIDETONE_ASRC0_STATUS_FMAX_CNTR_LSB       (0x00000CC3)
#define AQT1000_SIDETONE_ASRC0_STATUS_FMAX_CNTR_MSB       (0x00000CC4)
#define AQT1000_SIDETONE_ASRC0_STATUS_FIFO                (0x00000CC5)
#define AQT1000_EC_REF_HQ0_BASE             (0x00000CD5)
#define AQT1000_EC_REF_HQ0_EC_REF_HQ_PATH_CTL             (0x00000CD5)
#define AQT1000_EC_REF_HQ0_EC_REF_HQ_CFG0                 (0x00000CD6)
#define AQT1000_EC_REF_HQ1_BASE             (0x00000CDD)
#define AQT1000_EC_REF_HQ1_EC_REF_HQ_PATH_CTL             (0x00000CDD)
#define AQT1000_EC_REF_HQ1_EC_REF_HQ_CFG0                 (0x00000CDE)
#define AQT1000_EC_ASRC0_BASE               (0x00000CE5)
#define AQT1000_EC_ASRC0_CLK_RST_CTL                      (0x00000CE5)
#define AQT1000_EC_ASRC0_CTL0                             (0x00000CE6)
#define AQT1000_EC_ASRC0_CTL1                             (0x00000CE7)
#define AQT1000_EC_ASRC0_FIFO_CTL                         (0x00000CE8)
#define AQT1000_EC_ASRC0_STATUS_FMIN_CNTR_LSB             (0x00000CE9)
#define AQT1000_EC_ASRC0_STATUS_FMIN_CNTR_MSB             (0x00000CEA)
#define AQT1000_EC_ASRC0_STATUS_FMAX_CNTR_LSB             (0x00000CEB)
#define AQT1000_EC_ASRC0_STATUS_FMAX_CNTR_MSB             (0x00000CEC)
#define AQT1000_EC_ASRC0_STATUS_FIFO                      (0x00000CED)
#define AQT1000_EC_ASRC1_BASE               (0x00000CF1)
#define AQT1000_EC_ASRC1_CLK_RST_CTL                      (0x00000CF1)
#define AQT1000_EC_ASRC1_CTL0                             (0x00000CF2)
#define AQT1000_EC_ASRC1_CTL1                             (0x00000CF3)
#define AQT1000_EC_ASRC1_FIFO_CTL                         (0x00000CF4)
#define AQT1000_EC_ASRC1_STATUS_FMIN_CNTR_LSB             (0x00000CF5)
#define AQT1000_EC_ASRC1_STATUS_FMIN_CNTR_MSB             (0x00000CF6)
#define AQT1000_EC_ASRC1_STATUS_FMAX_CNTR_LSB             (0x00000CF7)
#define AQT1000_EC_ASRC1_STATUS_FMAX_CNTR_MSB             (0x00000CF8)
#define AQT1000_EC_ASRC1_STATUS_FIFO                      (0x00000CF9)
#define AQT1000_PAGE13_BASE                 (0x00000D00)
#define AQT1000_PAGE13_PAGE_REGISTER                      (0x00000D00)
#define AQT1000_CDC_RX_INP_MUX_CDC_RX_INP_MUX_BASE (0x00000D01)
#define AQT1000_CDC_RX_INP_MUX_RX_INT1_CFG0               (0x00000D03)
#define AQT1000_CDC_RX_INP_MUX_RX_INT1_CFG1               (0x00000D04)
#define AQT1000_CDC_RX_INP_MUX_RX_INT2_CFG0               (0x00000D05)
#define AQT1000_CDC_RX_INP_MUX_RX_INT2_CFG1               (0x00000D06)
#define AQT1000_CDC_RX_INP_MUX_EQ_IIR_CFG0                (0x00000D11)
#define AQT1000_CDC_RX_INP_MUX_DSD_CFG0                   (0x00000D12)
#define AQT1000_CDC_RX_INP_MUX_RX_MIX_CFG0                (0x00000D13)
#define AQT1000_CDC_RX_INP_MUX_SIDETONE_SRC_CFG0          (0x00000D18)
#define AQT1000_CDC_RX_INP_MUX_ANC_CFG0                   (0x00000D1A)
#define AQT1000_CDC_RX_INP_MUX_SPLINE_ASRC_CFG0           (0x00000D1B)
#define AQT1000_CDC_RX_INP_MUX_EC_REF_HQ_CFG0             (0x00000D1C)
#define AQT1000_CDC_TX_INP_MUX_CDC_TX_INP_MUX_BASE (0x00000D1D)
#define AQT1000_CDC_TX_INP_MUX_ADC_MUX0_CFG0              (0x00000D1D)
#define AQT1000_CDC_TX_INP_MUX_ADC_MUX0_CFG1              (0x00000D1E)
#define AQT1000_CDC_TX_INP_MUX_ADC_MUX1_CFG0              (0x00000D1F)
#define AQT1000_CDC_TX_INP_MUX_ADC_MUX1_CFG1              (0x00000D20)
#define AQT1000_CDC_TX_INP_MUX_ADC_MUX2_CFG0              (0x00000D21)
#define AQT1000_CDC_TX_INP_MUX_ADC_MUX2_CFG1              (0x00000D22)
#define AQT1000_CDC_TX_INP_MUX_ADC_MUX10_CFG0             (0x00000D29)
#define AQT1000_CDC_TX_INP_MUX_ADC_MUX10_CFG1             (0x00000D2A)
#define AQT1000_CDC_TX_INP_MUX_ADC_MUX11_CFG0             (0x00000D2B)
#define AQT1000_CDC_TX_INP_MUX_ADC_MUX11_CFG1             (0x00000D2C)
#define AQT1000_CDC_TX_INP_MUX_ADC_MUX12_CFG0             (0x00000D2D)
#define AQT1000_CDC_TX_INP_MUX_ADC_MUX12_CFG1             (0x00000D2E)
#define AQT1000_CDC_TX_INP_MUX_ADC_MUX13_CFG0             (0x00000D2F)
#define AQT1000_CDC_TX_INP_MUX_ADC_MUX13_CFG1             (0x00000D30)
#define AQT1000_CDC_SIDETONE_IIR_INP_MUX_CDC_SIDETONE_IIR_INP_MUX_BASE (0xD31)
#define AQT1000_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG0    (0x00000D31)
#define AQT1000_CDC_IF_ROUTER_CDC_IF_ROUTER_BASE (0x00000D3D)
#define AQT1000_CDC_IF_ROUTER_TX_MUX_CFG0                 (0x00000D3D)
#define AQT1000_CDC_CLK_RST_CTRL_CDC_CLK_RST_CTRL_BASE (0x00000D41)
#define AQT1000_CDC_CLK_RST_CTRL_MCLK_CONTROL             (0x00000D41)
#define AQT1000_CDC_CLK_RST_CTRL_FS_CNT_CONTROL           (0x00000D42)
#define AQT1000_CDC_CLK_RST_CTRL_DSD_CONTROL              (0x00000D44)
#define AQT1000_CDC_CLK_RST_CTRL_ASRC_SHARE_CONTROL       (0x00000D45)
#define AQT1000_CDC_CLK_RST_CTRL_GFM_CONTROL              (0x00000D46)
#define AQT1000_CDC_CLK_RST_CTRL_I2S_CONTROL              (0x00000D47)
#define AQT1000_CDC_SIDETONE_IIR0_BASE      (0x00000D55)
#define AQT1000_CDC_SIDETONE_IIR0_IIR_PATH_CTL            (0x00000D55)
#define AQT1000_CDC_SIDETONE_IIR0_IIR_GAIN_B1_CTL         (0x00000D56)
#define AQT1000_CDC_SIDETONE_IIR0_IIR_GAIN_B2_CTL         (0x00000D57)
#define AQT1000_CDC_SIDETONE_IIR0_IIR_GAIN_B3_CTL         (0x00000D58)
#define AQT1000_CDC_SIDETONE_IIR0_IIR_GAIN_B4_CTL         (0x00000D59)
#define AQT1000_CDC_SIDETONE_IIR0_IIR_GAIN_B5_CTL         (0x00000D5A)
#define AQT1000_CDC_SIDETONE_IIR0_IIR_GAIN_B6_CTL         (0x00000D5B)
#define AQT1000_CDC_SIDETONE_IIR0_IIR_GAIN_B7_CTL         (0x00000D5C)
#define AQT1000_CDC_SIDETONE_IIR0_IIR_GAIN_B8_CTL         (0x00000D5D)
#define AQT1000_CDC_SIDETONE_IIR0_IIR_CTL                 (0x00000D5E)
#define AQT1000_CDC_SIDETONE_IIR0_IIR_GAIN_TIMER_CTL      (0x00000D5F)
#define AQT1000_CDC_SIDETONE_IIR0_IIR_COEF_B1_CTL         (0x00000D60)
#define AQT1000_CDC_SIDETONE_IIR0_IIR_COEF_B2_CTL         (0x00000D61)
#define AQT1000_CDC_TOP_CDC_TOP_BASE        (0x00000D81)
#define AQT1000_CDC_TOP_TOP_CFG0                          (0x00000D81)
#define AQT1000_CDC_TOP_HPHL_COMP_WR_LSB                  (0x00000D89)
#define AQT1000_CDC_TOP_HPHL_COMP_WR_MSB                  (0x00000D8A)
#define AQT1000_CDC_TOP_HPHL_COMP_LUT                     (0x00000D8B)
#define AQT1000_CDC_TOP_HPHL_COMP_RD_LSB                  (0x00000D8C)
#define AQT1000_CDC_TOP_HPHL_COMP_RD_MSB                  (0x00000D8D)
#define AQT1000_CDC_TOP_HPHR_COMP_WR_LSB                  (0x00000D8E)
#define AQT1000_CDC_TOP_HPHR_COMP_WR_MSB                  (0x00000D8F)
#define AQT1000_CDC_TOP_HPHR_COMP_LUT                     (0x00000D90)
#define AQT1000_CDC_TOP_HPHR_COMP_RD_LSB                  (0x00000D91)
#define AQT1000_CDC_TOP_HPHR_COMP_RD_MSB                  (0x00000D92)
#define AQT1000_CDC_DSD0_BASE               (0x00000DB1)
#define AQT1000_CDC_DSD0_PATH_CTL                         (0x00000DB1)
#define AQT1000_CDC_DSD0_CFG0                             (0x00000DB2)
#define AQT1000_CDC_DSD0_CFG1                             (0x00000DB3)
#define AQT1000_CDC_DSD0_CFG2                             (0x00000DB4)
#define AQT1000_CDC_DSD0_CFG3                             (0x00000DB5)
#define AQT1000_CDC_DSD0_CFG4                             (0x00000DB6)
#define AQT1000_CDC_DSD0_CFG5                             (0x00000DB7)
#define AQT1000_CDC_DSD1_BASE               (0x00000DC1)
#define AQT1000_CDC_DSD1_PATH_CTL                         (0x00000DC1)
#define AQT1000_CDC_DSD1_CFG0                             (0x00000DC2)
#define AQT1000_CDC_DSD1_CFG1                             (0x00000DC3)
#define AQT1000_CDC_DSD1_CFG2                             (0x00000DC4)
#define AQT1000_CDC_DSD1_CFG3                             (0x00000DC5)
#define AQT1000_CDC_DSD1_CFG4                             (0x00000DC6)
#define AQT1000_CDC_DSD1_CFG5                             (0x00000DC7)
#define AQT1000_CDC_RX_IDLE_DET_CDC_RX_IDLE_DET_BASE (0x00000DD1)
#define AQT1000_CDC_RX_IDLE_DET_PATH_CTL                  (0x00000DD1)
#define AQT1000_CDC_RX_IDLE_DET_CFG0                      (0x00000DD2)
#define AQT1000_CDC_RX_IDLE_DET_CFG1                      (0x00000DD3)
#define AQT1000_CDC_RX_IDLE_DET_CFG2                      (0x00000DD4)
#define AQT1000_CDC_RX_IDLE_DET_CFG3                      (0x00000DD5)
#define AQT1000_CDC_DOP_DET_CDC_DOP_DET_BASE (0x00000DD9)
#define AQT1000_CDC_DOP_DET_CTL                           (0x00000DD9)
#define AQT1000_CDC_DOP_DET_CFG0                          (0x00000DDA)
#define AQT1000_CDC_DOP_DET_CFG1                          (0x00000DDB)
#define AQT1000_CDC_DOP_DET_CFG2                          (0x00000DDC)
#define AQT1000_CDC_DOP_DET_CFG3                          (0x00000DDD)
#define AQT1000_CDC_DOP_DET_CFG4                          (0x00000DDE)
#define AQT1000_CDC_DOP_DET_STATUS0                       (0x00000DE1)
#define AQT1000_PAGE15_BASE                 (0x00000F00)
#define AQT1000_PAGE15_PAGE_REGISTER                      (0x00000F00)
#define AQT1000_CDC_DEBUG_CDC_DEBUG_BASE    (0x00000FA1)
#define AQT1000_CDC_DEBUG_DSD0_DEBUG_CFG0                 (0x00000FA1)
#define AQT1000_CDC_DEBUG_DSD0_DEBUG_CFG1                 (0x00000FA2)
#define AQT1000_CDC_DEBUG_DSD0_DEBUG_CFG2                 (0x00000FA3)
#define AQT1000_CDC_DEBUG_DSD0_DEBUG_CFG3                 (0x00000FA4)
#define AQT1000_CDC_DEBUG_DSD1_DEBUG_CFG0                 (0x00000FA5)
#define AQT1000_CDC_DEBUG_DSD1_DEBUG_CFG1                 (0x00000FA6)
#define AQT1000_CDC_DEBUG_DSD1_DEBUG_CFG2                 (0x00000FA7)
#define AQT1000_CDC_DEBUG_DSD1_DEBUG_CFG3                 (0x00000FA8)
#define AQT1000_CDC_DEBUG_RC_RE_ASRC_DEBUG_CFG0           (0x00000FAB)
#define AQT1000_CDC_DEBUG_ANC0_RC0_FIFO_CTL               (0x00000FAC)
#define AQT1000_CDC_DEBUG_ANC0_RC1_FIFO_CTL               (0x00000FAD)
#define AQT1000_CDC_DEBUG_ANC1_RC0_FIFO_CTL               (0x00000FAE)
#define AQT1000_CDC_DEBUG_ANC1_RC1_FIFO_CTL               (0x00000FAF)
#define AQT1000_CDC_DEBUG_ANC_RC_RST_DBG_CNTR             (0x00000FB0)
#define AQT1000_PAGE128_BASE                (0x00008000)
#define AQT1000_PAGE128_PAGE_REGISTER                     (0x00008000)
#define AQT1000_TLMM_TLMM_BASE              (0x00008001)
#define AQT1000_TLMM_SPI_CLK_PINCFG                       (0x00008001)
#define AQT1000_TLMM_SPI_MOSI_PINCFG                      (0x00008002)
#define AQT1000_TLMM_SPI_MISO_PINCFG                      (0x00008003)
#define AQT1000_TLMM_SPI_CS_N_PINCFG                      (0x00008004)
#define AQT1000_TLMM_GPIO1_PINCFG                         (0x00008005)
#define AQT1000_TLMM_GPIO2_PINCFG                         (0x00008006)
#define AQT1000_TLMM_GPIO3_PINCFG                         (0x00008007)
#define AQT1000_TLMM_GPIO4_PINCFG                         (0x00008008)
#define AQT1000_TLMM_GPIO5_PINCFG                         (0x00008009)
#define AQT1000_TLMM_GPIO6_PINCFG                         (0x0000800A)
#define AQT1000_TLMM_GPIO7_PINCFG                         (0x0000800B)
#define AQT1000_TLMM_GPIO8_PINCFG                         (0x0000800C)
#define AQT1000_TLMM_GPIO9_PINCFG                         (0x0000800D)
#define AQT1000_TLMM_GPIO10_PINCFG                        (0x0000800E)
#define AQT1000_PAD_CTRL_PAD_CTRL_BASE      (0x00008031)
#define AQT1000_PAD_CTRL_PAD_PDN_CTRL_0                   (0x00008031)
#define AQT1000_PAD_CTRL_PAD_PDN_CTRL_1                   (0x00008032)
#define AQT1000_PAD_CTRL_PAD_PU_CTRL_0                    (0x00008033)
#define AQT1000_PAD_CTRL_PAD_PU_CTRL_1                    (0x00008034)
#define AQT1000_PAD_CTRL_GPIO_CTL_0_OE                    (0x00008036)
#define AQT1000_PAD_CTRL_GPIO_CTL_1_OE                    (0x00008037)
#define AQT1000_PAD_CTRL_GPIO_CTL_0_DATA                  (0x00008038)
#define AQT1000_PAD_CTRL_GPIO_CTL_1_DATA                  (0x00008039)
#define AQT1000_PAD_CTRL_PAD_DRVCTL                       (0x0000803A)
#define AQT1000_PAD_CTRL_PIN_STATUS                       (0x0000803B)
#define AQT1000_PAD_CTRL_MEM_CTRL                         (0x0000803C)
#define AQT1000_PAD_CTRL_PAD_INP_DISABLE_0                (0x0000803E)
#define AQT1000_PAD_CTRL_PAD_INP_DISABLE_1                (0x0000803F)
#define AQT1000_PAD_CTRL_PIN_CTL_OE_0                     (0x00008040)
#define AQT1000_PAD_CTRL_PIN_CTL_OE_1                     (0x00008041)
#define AQT1000_PAD_CTRL_PIN_CTL_DATA_0                   (0x00008042)
#define AQT1000_PAD_CTRL_PIN_CTL_DATA_1                   (0x00008043)
#define AQT1000_PAD_CTRL_USB_PHY_CLK_DIV                  (0x00008044)
#define AQT1000_PAD_CTRL_DEBUG_BUS_CDC                    (0x00008045)
#define AQT1000_PAD_CTRL_DEBUG_BUS_SEL                    (0x00008046)
#define AQT1000_PAD_CTRL_DEBUG_EN_1                       (0x00008047)
#define AQT1000_PAD_CTRL_DEBUG_EN_2                       (0x00008048)
#define AQT1000_PAD_CTRL_DEBUG_EN_3                       (0x00008049)
#define AQT1000_PAD_CTRL_DEBUG_EN_4                       (0x0000804A)
#define AQT1000_PAD_CTRL_DEBUG_EN_5                       (0x0000804B)
#define AQT1000_PAD_CTRL_DEBUG_MUX_BIT_0                  (0x0000804C)
#define AQT1000_PAD_CTRL_DEBUG_MUX_BIT_1                  (0x0000804D)
#define AQT1000_PAD_CTRL_DEBUG_MUX_BIT_2                  (0x0000804E)
#define AQT1000_PAD_CTRL_DEBUG_MUX_BIT_3                  (0x0000804F)
#define AQT1000_PAD_CTRL_DEBUG_MUX_BIT_4                  (0x00008050)
#define AQT1000_PAD_CTRL_DEBUG_MUX_BIT_5                  (0x00008051)
#define AQT1000_PAD_CTRL_DEBUG_MUX_BIT_6                  (0x00008052)
#define AQT1000_PAD_CTRL_DEBUG_MUX_BIT_7                  (0x00008053)
#define AQT1000_PAD_CTRL_DEBUG_MUX_BIT_8                  (0x00008054)
#define AQT1000_PAD_CTRL_DEBUG_MUX_BIT_9                  (0x00008055)
#define AQT1000_PAD_CTRL_DEBUG_MUX_BIT_10                 (0x00008056)
#define AQT1000_PAD_CTRL_DEBUG_MUX_BIT_11                 (0x00008057)
#define AQT1000_PAD_CTRL_DEBUG_MUX_BIT_12                 (0x00008058)
#define AQT1000_PAD_CTRL_DEBUG_MUX_BIT_13                 (0x00008059)
#define AQT1000_PAD_CTRL_DEBUG_READ_0                     (0x0000805A)
#define AQT1000_PAD_CTRL_DEBUG_READ_1                     (0x0000805B)
#define AQT1000_PAD_CTRL_DEBUG_READ_2                     (0x0000805C)
#define AQT1000_PAD_CTRL_DEBUG_READ_3                     (0x0000805D)
#define AQT1000_PAD_CTRL_FPGA_CTL                         (0x00008061)
#define AQT1000_MAX_REGISTER                              (0x000080FF)

#endif /*_AQT_REGISTERS_H*/
