/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2015-2017, 2020, The Linux Foundation. All rights reserved.
 */

#ifndef ANALOG_CDC_REGMAP_H
#define ANALOG_CDC_REGMAP_H

#include <linux/regmap.h>
#include "sdm660-cdc-registers.h"

/*
 * Default register reset values that are common across different versions
 * are defined here. If a register reset value is changed based on version
 * then remove it from this structure and add it in version specific
 * structures.
 */

struct reg_default
	msm89xx_pmic_cdc_defaults[MSM89XX_PMIC_CDC_CACHE_SIZE] = {
	{MSM89XX_PMIC_DIGITAL_REVISION1, 0x00},
	{MSM89XX_PMIC_DIGITAL_REVISION2, 0x00},
	{MSM89XX_PMIC_DIGITAL_PERPH_TYPE, 0x23},
	{MSM89XX_PMIC_DIGITAL_PERPH_SUBTYPE, 0x01},
	{MSM89XX_PMIC_DIGITAL_INT_RT_STS, 0x00},
	{MSM89XX_PMIC_DIGITAL_INT_SET_TYPE, 0xFF},
	{MSM89XX_PMIC_DIGITAL_INT_POLARITY_HIGH, 0xFF},
	{MSM89XX_PMIC_DIGITAL_INT_POLARITY_LOW, 0x00},
	{MSM89XX_PMIC_DIGITAL_INT_LATCHED_CLR, 0x00},
	{MSM89XX_PMIC_DIGITAL_INT_EN_SET, 0x00},
	{MSM89XX_PMIC_DIGITAL_INT_EN_CLR, 0x00},
	{MSM89XX_PMIC_DIGITAL_INT_LATCHED_STS, 0x00},
	{MSM89XX_PMIC_DIGITAL_INT_PENDING_STS, 0x00},
	{MSM89XX_PMIC_DIGITAL_INT_MID_SEL, 0x00},
	{MSM89XX_PMIC_DIGITAL_INT_PRIORITY, 0x00},
	{MSM89XX_PMIC_DIGITAL_GPIO_MODE, 0x00},
	{MSM89XX_PMIC_DIGITAL_PIN_CTL_OE, 0x01},
	{MSM89XX_PMIC_DIGITAL_PIN_CTL_DATA, 0x00},
	{MSM89XX_PMIC_DIGITAL_PIN_STATUS, 0x00},
	{MSM89XX_PMIC_DIGITAL_HDRIVE_CTL, 0x00},
	{MSM89XX_PMIC_DIGITAL_CDC_RST_CTL, 0x00},
	{MSM89XX_PMIC_DIGITAL_CDC_TOP_CLK_CTL, 0x00},
	{MSM89XX_PMIC_DIGITAL_CDC_ANA_CLK_CTL, 0x00},
	{MSM89XX_PMIC_DIGITAL_CDC_DIG_CLK_CTL, 0x00},
	{MSM89XX_PMIC_DIGITAL_CDC_CONN_TX1_CTL, 0x02},
	{MSM89XX_PMIC_DIGITAL_CDC_CONN_TX2_CTL, 0x02},
	{MSM89XX_PMIC_DIGITAL_CDC_CONN_HPHR_DAC_CTL, 0x00},
	{MSM89XX_PMIC_DIGITAL_CDC_CONN_RX1_CTL, 0x00},
	{MSM89XX_PMIC_DIGITAL_CDC_CONN_RX2_CTL, 0x00},
	{MSM89XX_PMIC_DIGITAL_CDC_CONN_RX3_CTL, 0x00},
	{MSM89XX_PMIC_DIGITAL_CDC_CONN_RX_LB_CTL, 0x00},
	{MSM89XX_PMIC_DIGITAL_CDC_RX_CTL1, 0x7C},
	{MSM89XX_PMIC_DIGITAL_CDC_RX_CTL2, 0x7C},
	{MSM89XX_PMIC_DIGITAL_CDC_RX_CTL3, 0x7C},
	{MSM89XX_PMIC_DIGITAL_DEM_BYPASS_DATA0, 0x00},
	{MSM89XX_PMIC_DIGITAL_DEM_BYPASS_DATA1, 0x00},
	{MSM89XX_PMIC_DIGITAL_DEM_BYPASS_DATA2, 0x00},
	{MSM89XX_PMIC_DIGITAL_DEM_BYPASS_DATA3, 0x00},
	{MSM89XX_PMIC_DIGITAL_DIG_DEBUG_CTL, 0x00},
	{MSM89XX_PMIC_DIGITAL_DIG_DEBUG_EN, 0x00},
	{MSM89XX_PMIC_DIGITAL_SPARE_0, 0x00},
	{MSM89XX_PMIC_DIGITAL_SPARE_1, 0x00},
	{MSM89XX_PMIC_DIGITAL_SPARE_2, 0x00},
	{MSM89XX_PMIC_DIGITAL_SEC_ACCESS, 0x00},
	{MSM89XX_PMIC_DIGITAL_PERPH_RESET_CTL1, 0x00},
	{MSM89XX_PMIC_DIGITAL_PERPH_RESET_CTL2, 0x02},
	{MSM89XX_PMIC_DIGITAL_PERPH_RESET_CTL3, 0x05},
	{MSM89XX_PMIC_DIGITAL_PERPH_RESET_CTL4, 0x00},
	{MSM89XX_PMIC_DIGITAL_INT_TEST1, 0x00},
	{MSM89XX_PMIC_DIGITAL_INT_TEST_VAL, 0x00},
	{MSM89XX_PMIC_DIGITAL_TRIM_NUM, 0x00},
	{MSM89XX_PMIC_DIGITAL_TRIM_CTRL, 0x00},
	{MSM89XX_PMIC_ANALOG_REVISION1, 0x00},
	{MSM89XX_PMIC_ANALOG_REVISION2, 0x00},
	{MSM89XX_PMIC_ANALOG_REVISION3, 0x00},
	{MSM89XX_PMIC_ANALOG_REVISION4, 0x00},
	{MSM89XX_PMIC_ANALOG_PERPH_TYPE, 0x23},
	{MSM89XX_PMIC_ANALOG_PERPH_SUBTYPE, 0x09},
	{MSM89XX_PMIC_ANALOG_INT_RT_STS, 0x00},
	{MSM89XX_PMIC_ANALOG_INT_SET_TYPE, 0x3F},
	{MSM89XX_PMIC_ANALOG_INT_POLARITY_HIGH, 0x3F},
	{MSM89XX_PMIC_ANALOG_INT_POLARITY_LOW, 0x00},
	{MSM89XX_PMIC_ANALOG_INT_LATCHED_CLR, 0x00},
	{MSM89XX_PMIC_ANALOG_INT_EN_SET, 0x00},
	{MSM89XX_PMIC_ANALOG_INT_EN_CLR, 0x00},
	{MSM89XX_PMIC_ANALOG_INT_LATCHED_STS, 0x00},
	{MSM89XX_PMIC_ANALOG_INT_PENDING_STS, 0x00},
	{MSM89XX_PMIC_ANALOG_INT_MID_SEL, 0x00},
	{MSM89XX_PMIC_ANALOG_INT_PRIORITY, 0x00},
	{MSM89XX_PMIC_ANALOG_MICB_1_EN, 0x00},
	{MSM89XX_PMIC_ANALOG_MICB_1_VAL, 0x20},
	{MSM89XX_PMIC_ANALOG_MICB_1_CTL, 0x00},
	{MSM89XX_PMIC_ANALOG_MICB_1_INT_RBIAS, 0x49},
	{MSM89XX_PMIC_ANALOG_MICB_2_EN, 0x20},
	{MSM89XX_PMIC_ANALOG_TX_1_2_ATEST_CTL_2, 0x00},
	{MSM89XX_PMIC_ANALOG_MASTER_BIAS_CTL, 0x00},
	{MSM89XX_PMIC_ANALOG_MBHC_DET_CTL_1, 0x35},
	{MSM89XX_PMIC_ANALOG_MBHC_DET_CTL_2, 0x08},
	{MSM89XX_PMIC_ANALOG_MBHC_FSM_CTL, 0x00},
	{MSM89XX_PMIC_ANALOG_MBHC_DBNC_TIMER, 0x98},
	{MSM89XX_PMIC_ANALOG_MBHC_BTN0_ZDETL_CTL, 0x00},
	{MSM89XX_PMIC_ANALOG_MBHC_BTN1_ZDETM_CTL, 0x20},
	{MSM89XX_PMIC_ANALOG_MBHC_BTN2_ZDETH_CTL, 0x40},
	{MSM89XX_PMIC_ANALOG_MBHC_BTN3_CTL, 0x61},
	{MSM89XX_PMIC_ANALOG_MBHC_BTN4_CTL, 0x80},
	{MSM89XX_PMIC_ANALOG_MBHC_BTN_RESULT, 0x00},
	{MSM89XX_PMIC_ANALOG_MBHC_ZDET_ELECT_RESULT, 0x00},
	{MSM89XX_PMIC_ANALOG_TX_1_EN, 0x03},
	{MSM89XX_PMIC_ANALOG_TX_2_EN, 0x03},
	{MSM89XX_PMIC_ANALOG_TX_1_2_TEST_CTL_1, 0xBF},
	{MSM89XX_PMIC_ANALOG_TX_1_2_TEST_CTL_2, 0x8C},
	{MSM89XX_PMIC_ANALOG_TX_1_2_ATEST_CTL, 0x00},
	{MSM89XX_PMIC_ANALOG_TX_1_2_OPAMP_BIAS, 0x6B},
	{MSM89XX_PMIC_ANALOG_TX_1_2_TXFE_CLKDIV, 0x51},
	{MSM89XX_PMIC_ANALOG_TX_3_EN, 0x02},
	{MSM89XX_PMIC_ANALOG_NCP_EN, 0x26},
	{MSM89XX_PMIC_ANALOG_NCP_CLK, 0x23},
	{MSM89XX_PMIC_ANALOG_NCP_DEGLITCH, 0x5B},
	{MSM89XX_PMIC_ANALOG_NCP_FBCTRL, 0x08},
	{MSM89XX_PMIC_ANALOG_NCP_BIAS, 0x29},
	{MSM89XX_PMIC_ANALOG_NCP_VCTRL, 0x24},
	{MSM89XX_PMIC_ANALOG_NCP_TEST, 0x00},
	{MSM89XX_PMIC_ANALOG_NCP_CLIM_ADDR, 0xD5},
	{MSM89XX_PMIC_ANALOG_RX_CLOCK_DIVIDER, 0xE8},
	{MSM89XX_PMIC_ANALOG_RX_COM_OCP_CTL, 0xCF},
	{MSM89XX_PMIC_ANALOG_RX_COM_OCP_COUNT, 0x6E},
	{MSM89XX_PMIC_ANALOG_RX_COM_BIAS_DAC, 0x18},
	{MSM89XX_PMIC_ANALOG_RX_HPH_BIAS_PA, 0x5A},
	{MSM89XX_PMIC_ANALOG_RX_HPH_BIAS_LDO_OCP, 0x69},
	{MSM89XX_PMIC_ANALOG_RX_HPH_BIAS_CNP, 0x29},
	{MSM89XX_PMIC_ANALOG_RX_HPH_CNP_EN, 0x80},
	{MSM89XX_PMIC_ANALOG_RX_HPH_CNP_WG_CTL, 0xDA},
	{MSM89XX_PMIC_ANALOG_RX_HPH_CNP_WG_TIME, 0x16},
	{MSM89XX_PMIC_ANALOG_RX_HPH_L_TEST, 0x00},
	{MSM89XX_PMIC_ANALOG_RX_HPH_L_PA_DAC_CTL, 0x20},
	{MSM89XX_PMIC_ANALOG_RX_HPH_R_TEST, 0x00},
	{MSM89XX_PMIC_ANALOG_RX_HPH_R_PA_DAC_CTL, 0x20},
	{MSM89XX_PMIC_ANALOG_RX_EAR_CTL, 0x12},
	{MSM89XX_PMIC_ANALOG_RX_ATEST, 0x00},
	{MSM89XX_PMIC_ANALOG_RX_HPH_STATUS, 0x0C},
	{MSM89XX_PMIC_ANALOG_RX_EAR_STATUS, 0x00},
	{MSM89XX_PMIC_ANALOG_RX_LO_DAC_CTL, 0x00},
	{MSM89XX_PMIC_ANALOG_RX_LO_EN_CTL, 0x00},
	{MSM89XX_PMIC_ANALOG_SPKR_DAC_CTL, 0x83},
	{MSM89XX_PMIC_ANALOG_SPKR_DRV_CLIP_DET, 0x91},
	{MSM89XX_PMIC_ANALOG_SPKR_DRV_CTL, 0x29},
	{MSM89XX_PMIC_ANALOG_SPKR_ANA_BIAS_SET, 0x4D},
	{MSM89XX_PMIC_ANALOG_SPKR_OCP_CTL, 0xE1},
	{MSM89XX_PMIC_ANALOG_SPKR_PWRSTG_CTL, 0x1E},
	{MSM89XX_PMIC_ANALOG_SPKR_DRV_MISC, 0xCB},
	{MSM89XX_PMIC_ANALOG_SPKR_DRV_DBG, 0x00},
	{MSM89XX_PMIC_ANALOG_CURRENT_LIMIT, 0x02},
	{MSM89XX_PMIC_ANALOG_OUTPUT_VOLTAGE, 0x14},
	{MSM89XX_PMIC_ANALOG_BYPASS_MODE, 0x00},
	{MSM89XX_PMIC_ANALOG_BOOST_EN_CTL, 0x1F},
	{MSM89XX_PMIC_ANALOG_SLOPE_COMP_IP_ZERO, 0x8C},
	{MSM89XX_PMIC_ANALOG_RDSON_MAX_DUTY_CYCLE, 0xC0},
	{MSM89XX_PMIC_ANALOG_BOOST_TEST1_1, 0x00},
	{MSM89XX_PMIC_ANALOG_BOOST_TEST_2, 0x00},
	{MSM89XX_PMIC_ANALOG_SPKR_SAR_STATUS, 0x00},
	{MSM89XX_PMIC_ANALOG_SPKR_DRV_STATUS, 0x00},
	{MSM89XX_PMIC_ANALOG_PBUS_ADD_CSR, 0x00},
	{MSM89XX_PMIC_ANALOG_PBUS_ADD_SEL, 0x00},
	{MSM89XX_PMIC_ANALOG_SEC_ACCESS, 0x00},
	{MSM89XX_PMIC_ANALOG_PERPH_RESET_CTL1, 0x00},
	{MSM89XX_PMIC_ANALOG_PERPH_RESET_CTL2, 0x01},
	{MSM89XX_PMIC_ANALOG_PERPH_RESET_CTL3, 0x05},
	{MSM89XX_PMIC_ANALOG_PERPH_RESET_CTL4, 0x00},
	{MSM89XX_PMIC_ANALOG_INT_TEST1, 0x00},
	{MSM89XX_PMIC_ANALOG_INT_TEST_VAL, 0x00},
	{MSM89XX_PMIC_ANALOG_TRIM_NUM, 0x04},
	{MSM89XX_PMIC_ANALOG_TRIM_CTRL1, 0x00},
	{MSM89XX_PMIC_ANALOG_TRIM_CTRL2, 0x00},
	{MSM89XX_PMIC_ANALOG_TRIM_CTRL3, 0x00},
	{MSM89XX_PMIC_ANALOG_TRIM_CTRL4, 0x00},
};

#endif
