/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2016, The Linux Foundation. All rights reserved.
 */

#ifndef _WCD934X_REGISTERS_H
#define _WCD934X_REGISTERS_H

#define WCD934X_PAGE_SIZE 256
#define WCD934X_NUM_PAGES 256

extern const u8 * const wcd934x_reg[WCD934X_NUM_PAGES];

enum {
	WCD934X_PAGE_0 = 0,
	WCD934X_PAGE_1,
	WCD934X_PAGE_2,
	WCD934X_PAGE_4 = 4,
	WCD934X_PAGE_5,
	WCD934X_PAGE_6,
	WCD934X_PAGE_7,
	WCD934X_PAGE_10 = 0xA,
	WCD934X_PAGE_11,
	WCD934X_PAGE_12,
	WCD934X_PAGE_13,
	WCD934X_PAGE_14,
	WCD934X_PAGE_15,
	WCD934X_PAGE_0x50,
	WCD934X_PAGE_0X80,
};

enum {
	WCD934X_WRITE = 0,
	WCD934X_READ,
	WCD934X_READ_WRITE,
};

/* Page-0 Registers */
#define WCD934X_PAGE0_PAGE_REGISTER                        0x0000
#define WCD934X_CODEC_RPM_CLK_BYPASS                       0x0001
#define WCD934X_CODEC_RPM_CLK_GATE                         0x0002
#define WCD934X_CODEC_RPM_CLK_MCLK_CFG                     0x0003
#define WCD934X_CODEC_RPM_CLK_MCLK2_CFG                    0x0004
#define WCD934X_CODEC_RPM_I2S_DSD_CLK_SEL                  0x0005
#define WCD934X_CODEC_RPM_RST_CTL                          0x0009
#define WCD934X_CODEC_RPM_PWR_CDC_DIG_HM_CTL               0x0011
#define WCD934X_CHIP_TIER_CTRL_CHIP_ID_BYTE0               0x0021
#define WCD934X_CHIP_TIER_CTRL_CHIP_ID_BYTE1               0x0022
#define WCD934X_CHIP_TIER_CTRL_CHIP_ID_BYTE2               0x0023
#define WCD934X_CHIP_TIER_CTRL_CHIP_ID_BYTE3               0x0024
#define WCD934X_CHIP_TIER_CTRL_EFUSE_CTL                   0x0025
#define WCD934X_CHIP_TIER_CTRL_EFUSE_TEST0                 0x0026
#define WCD934X_CHIP_TIER_CTRL_EFUSE_TEST1                 0x0027
#define WCD934X_CHIP_TIER_CTRL_EFUSE_VAL_OUT0              0x0029
#define WCD934X_CHIP_TIER_CTRL_EFUSE_VAL_OUT1              0x002a
#define WCD934X_CHIP_TIER_CTRL_EFUSE_VAL_OUT2              0x002b
#define WCD934X_CHIP_TIER_CTRL_EFUSE_VAL_OUT3              0x002c
#define WCD934X_CHIP_TIER_CTRL_EFUSE_VAL_OUT4              0x002d
#define WCD934X_CHIP_TIER_CTRL_EFUSE_VAL_OUT5              0x002e
#define WCD934X_CHIP_TIER_CTRL_EFUSE_VAL_OUT6              0x002f
#define WCD934X_CHIP_TIER_CTRL_EFUSE_VAL_OUT7              0x0030
#define WCD934X_CHIP_TIER_CTRL_EFUSE_VAL_OUT8              0x0031
#define WCD934X_CHIP_TIER_CTRL_EFUSE_VAL_OUT9              0x0032
#define WCD934X_CHIP_TIER_CTRL_EFUSE_VAL_OUT10             0x0033
#define WCD934X_CHIP_TIER_CTRL_EFUSE_VAL_OUT11             0x0034
#define WCD934X_CHIP_TIER_CTRL_EFUSE_VAL_OUT12             0x0035
#define WCD934X_CHIP_TIER_CTRL_EFUSE_VAL_OUT13             0x0036
#define WCD934X_CHIP_TIER_CTRL_EFUSE_VAL_OUT14             0x0037
#define WCD934X_CHIP_TIER_CTRL_EFUSE_VAL_OUT15             0x0038
#define WCD934X_CHIP_TIER_CTRL_EFUSE_STATUS                0x0039
#define WCD934X_CHIP_TIER_CTRL_I2C_SLAVE_ID_NONNEGO        0x003a
#define WCD934X_CHIP_TIER_CTRL_I2C_SLAVE_ID_1              0x003b
#define WCD934X_CHIP_TIER_CTRL_I2C_SLAVE_ID_2              0x003c
#define WCD934X_CHIP_TIER_CTRL_I2C_SLAVE_ID_3              0x003d
#define WCD934X_CHIP_TIER_CTRL_ANA_WAIT_STATE_CTL          0x003e
#define WCD934X_CHIP_TIER_CTRL_SLNQ_WAIT_STATE_CTL         0x003f
#define WCD934X_CHIP_TIER_CTRL_I2C_ACTIVE                  0x0040
#define WCD934X_CHIP_TIER_CTRL_ALT_FUNC_EN                 0x0041
#define WCD934X_CHIP_TIER_CTRL_GPIO_CTL_OE                 0x0042
#define WCD934X_CHIP_TIER_CTRL_GPIO_CTL_DATA               0x0043
#define WCD934X_DATA_HUB_RX0_CFG                           0x0051
#define WCD934X_DATA_HUB_RX1_CFG                           0x0052
#define WCD934X_DATA_HUB_RX2_CFG                           0x0053
#define WCD934X_DATA_HUB_RX3_CFG                           0x0054
#define WCD934X_DATA_HUB_RX4_CFG                           0x0055
#define WCD934X_DATA_HUB_RX5_CFG                           0x0056
#define WCD934X_DATA_HUB_RX6_CFG                           0x0057
#define WCD934X_DATA_HUB_RX7_CFG                           0x0058
#define WCD934X_DATA_HUB_SB_TX0_INP_CFG                    0x0061
#define WCD934X_DATA_HUB_SB_TX1_INP_CFG                    0x0062
#define WCD934X_DATA_HUB_SB_TX2_INP_CFG                    0x0063
#define WCD934X_DATA_HUB_SB_TX3_INP_CFG                    0x0064
#define WCD934X_DATA_HUB_SB_TX4_INP_CFG                    0x0065
#define WCD934X_DATA_HUB_SB_TX5_INP_CFG                    0x0066
#define WCD934X_DATA_HUB_SB_TX6_INP_CFG                    0x0067
#define WCD934X_DATA_HUB_SB_TX7_INP_CFG                    0x0068
#define WCD934X_DATA_HUB_SB_TX8_INP_CFG                    0x0069
#define WCD934X_DATA_HUB_SB_TX9_INP_CFG                    0x006a
#define WCD934X_DATA_HUB_SB_TX10_INP_CFG                   0x006b
#define WCD934X_DATA_HUB_SB_TX11_INP_CFG                   0x006c
#define WCD934X_DATA_HUB_SB_TX13_INP_CFG                   0x006e
#define WCD934X_DATA_HUB_SB_TX14_INP_CFG                   0x006f
#define WCD934X_DATA_HUB_SB_TX15_INP_CFG                   0x0070
#define WCD934X_DATA_HUB_I2S_TX0_CFG                       0x0071
#define WCD934X_DATA_HUB_I2S_TX1_0_CFG                     0x0073
#define WCD934X_DATA_HUB_I2S_TX1_1_CFG                     0x0074
#define WCD934X_DATA_HUB_I2S_0_CTL                         0x0081
#define WCD934X_DATA_HUB_I2S_1_CTL                         0x0082
#define WCD934X_DATA_HUB_I2S_2_CTL                         0x0083
#define WCD934X_DATA_HUB_I2S_3_CTL                         0x0084
#define WCD934X_DATA_HUB_I2S_CLKSRC_CTL                    0x0085
#define WCD934X_DATA_HUB_I2S_COMMON_CTL                    0x0086
#define WCD934X_DATA_HUB_I2S_0_TDM_CTL                     0x0087
#define WCD934X_DATA_HUB_I2S_STATUS                        0x0088
#define WCD934X_DMA_RDMA_CTL_0                             0x0091
#define WCD934X_DMA_CH_2_3_CFG_RDMA_0                      0x0092
#define WCD934X_DMA_CH_0_1_CFG_RDMA_0                      0x0093
#define WCD934X_DMA_RDMA_CTL_1                             0x0094
#define WCD934X_DMA_CH_2_3_CFG_RDMA_1                      0x0095
#define WCD934X_DMA_CH_0_1_CFG_RDMA_1                      0x0096
#define WCD934X_DMA_RDMA_CTL_2                             0x0097
#define WCD934X_DMA_CH_2_3_CFG_RDMA_2                      0x0098
#define WCD934X_DMA_CH_0_1_CFG_RDMA_2                      0x0099
#define WCD934X_DMA_RDMA_CTL_3                             0x009A
#define WCD934X_DMA_CH_2_3_CFG_RDMA_3                      0x009B
#define WCD934X_DMA_CH_0_1_CFG_RDMA_3                      0x009C
#define WCD934X_DMA_RDMA_CTL_4                             0x009D
#define WCD934X_DMA_CH_2_3_CFG_RDMA_4                      0x009E
#define WCD934X_DMA_CH_0_1_CFG_RDMA_4                      0x009F
#define WCD934X_DMA_RDMA4_PRT_CFG                          0x00b1
#define WCD934X_DMA_RDMA_SBTX0_7_CFG                       0x00b9
#define WCD934X_DMA_RDMA_SBTX8_11_CFG                      0x00ba
#define WCD934X_DMA_WDMA_CTL_0                             0x00c1
#define WCD934X_DMA_CH_4_5_CFG_WDMA_0                      0x00c2
#define WCD934X_DMA_CH_2_3_CFG_WDMA_0                      0x00c3
#define WCD934X_DMA_CH_0_1_CFG_WDMA_0                      0x00c4
#define WCD934X_DMA_WDMA_CTL_1                             0x00C6
#define WCD934X_DMA_CH_4_5_CFG_WDMA_1                      0x00C7
#define WCD934X_DMA_CH_2_3_CFG_WDMA_1                      0x00C8
#define WCD934X_DMA_CH_0_1_CFG_WDMA_1                      0x00C9
#define WCD934X_DMA_WDMA_CTL_2                             0x00CB
#define WCD934X_DMA_CH_4_5_CFG_WDMA_2                      0x00CC
#define WCD934X_DMA_CH_2_3_CFG_WDMA_2                      0x00CD
#define WCD934X_DMA_CH_0_1_CFG_WDMA_2                      0x00CE
#define WCD934X_DMA_WDMA_CTL_3                             0x00D0
#define WCD934X_DMA_CH_4_5_CFG_WDMA_3                      0x00D1
#define WCD934X_DMA_CH_2_3_CFG_WDMA_3                      0x00D2
#define WCD934X_DMA_CH_0_1_CFG_WDMA_3                      0x00D3
#define WCD934X_DMA_WDMA_CTL_4                             0x00D5
#define WCD934X_DMA_CH_4_5_CFG_WDMA_4                      0x00D6
#define WCD934X_DMA_CH_2_3_CFG_WDMA_4                      0x00D7
#define WCD934X_DMA_CH_0_1_CFG_WDMA_4                      0x00D8
#define WCD934X_DMA_WDMA0_PRT_CFG                          0x00E1
#define WCD934X_DMA_WDMA3_PRT_CFG                          0x00E2
#define WCD934X_DMA_WDMA4_PRT0_3_CFG                       0x00E3
#define WCD934X_DMA_WDMA4_PRT4_7_CFG                       0x00E4
#define WCD934X_PAGE1_PAGE_REGISTER                        0x0100
#define WCD934X_CPE_FLL_USER_CTL_0                         0x0101
#define WCD934X_CPE_FLL_USER_CTL_1                         0x0102
#define WCD934X_CPE_FLL_USER_CTL_2                         0x0103
#define WCD934X_CPE_FLL_USER_CTL_3                         0x0104
#define WCD934X_CPE_FLL_USER_CTL_4                         0x0105
#define WCD934X_CPE_FLL_USER_CTL_5                         0x0106
#define WCD934X_CPE_FLL_USER_CTL_6                         0x0107
#define WCD934X_CPE_FLL_USER_CTL_7                         0x0108
#define WCD934X_CPE_FLL_USER_CTL_8                         0x0109
#define WCD934X_CPE_FLL_USER_CTL_9                         0x010a
#define WCD934X_CPE_FLL_L_VAL_CTL_0                        0x010b
#define WCD934X_CPE_FLL_L_VAL_CTL_1                        0x010c
#define WCD934X_CPE_FLL_DSM_FRAC_CTL_0                     0x010d
#define WCD934X_CPE_FLL_DSM_FRAC_CTL_1                     0x010e
#define WCD934X_CPE_FLL_CONFIG_CTL_0                       0x010f
#define WCD934X_CPE_FLL_CONFIG_CTL_1                       0x0110
#define WCD934X_CPE_FLL_CONFIG_CTL_2                       0x0111
#define WCD934X_CPE_FLL_CONFIG_CTL_3                       0x0112
#define WCD934X_CPE_FLL_CONFIG_CTL_4                       0x0113
#define WCD934X_CPE_FLL_TEST_CTL_0                         0x0114
#define WCD934X_CPE_FLL_TEST_CTL_1                         0x0115
#define WCD934X_CPE_FLL_TEST_CTL_2                         0x0116
#define WCD934X_CPE_FLL_TEST_CTL_3                         0x0117
#define WCD934X_CPE_FLL_TEST_CTL_4                         0x0118
#define WCD934X_CPE_FLL_TEST_CTL_5                         0x0119
#define WCD934X_CPE_FLL_TEST_CTL_6                         0x011a
#define WCD934X_CPE_FLL_TEST_CTL_7                         0x011b
#define WCD934X_CPE_FLL_FREQ_CTL_0                         0x011c
#define WCD934X_CPE_FLL_FREQ_CTL_1                         0x011d
#define WCD934X_CPE_FLL_FREQ_CTL_2                         0x011e
#define WCD934X_CPE_FLL_FREQ_CTL_3                         0x011f
#define WCD934X_CPE_FLL_SSC_CTL_0                          0x0120
#define WCD934X_CPE_FLL_SSC_CTL_1                          0x0121
#define WCD934X_CPE_FLL_SSC_CTL_2                          0x0122
#define WCD934X_CPE_FLL_SSC_CTL_3                          0x0123
#define WCD934X_CPE_FLL_FLL_MODE                           0x0124
#define WCD934X_CPE_FLL_STATUS_0                           0x0125
#define WCD934X_CPE_FLL_STATUS_1                           0x0126
#define WCD934X_CPE_FLL_STATUS_2                           0x0127
#define WCD934X_CPE_FLL_STATUS_3                           0x0128
#define WCD934X_I2S_FLL_USER_CTL_0                         0x0141
#define WCD934X_I2S_FLL_USER_CTL_1                         0x0142
#define WCD934X_I2S_FLL_USER_CTL_2                         0x0143
#define WCD934X_I2S_FLL_USER_CTL_3                         0x0144
#define WCD934X_I2S_FLL_USER_CTL_4                         0x0145
#define WCD934X_I2S_FLL_USER_CTL_5                         0x0146
#define WCD934X_I2S_FLL_USER_CTL_6                         0x0147
#define WCD934X_I2S_FLL_USER_CTL_7                         0x0148
#define WCD934X_I2S_FLL_USER_CTL_8                         0x0149
#define WCD934X_I2S_FLL_USER_CTL_9                         0x014a
#define WCD934X_I2S_FLL_L_VAL_CTL_0                        0x014b
#define WCD934X_I2S_FLL_L_VAL_CTL_1                        0x014c
#define WCD934X_I2S_FLL_DSM_FRAC_CTL_0                     0x014d
#define WCD934X_I2S_FLL_DSM_FRAC_CTL_1                     0x014e
#define WCD934X_I2S_FLL_CONFIG_CTL_0                       0x014f
#define WCD934X_I2S_FLL_CONFIG_CTL_1                       0x0150
#define WCD934X_I2S_FLL_CONFIG_CTL_2                       0x0151
#define WCD934X_I2S_FLL_CONFIG_CTL_3                       0x0152
#define WCD934X_I2S_FLL_CONFIG_CTL_4                       0x0153
#define WCD934X_I2S_FLL_TEST_CTL_0                         0x0154
#define WCD934X_I2S_FLL_TEST_CTL_1                         0x0155
#define WCD934X_I2S_FLL_TEST_CTL_2                         0x0156
#define WCD934X_I2S_FLL_TEST_CTL_3                         0x0157
#define WCD934X_I2S_FLL_TEST_CTL_4                         0x0158
#define WCD934X_I2S_FLL_TEST_CTL_5                         0x0159
#define WCD934X_I2S_FLL_TEST_CTL_6                         0x015a
#define WCD934X_I2S_FLL_TEST_CTL_7                         0x015b
#define WCD934X_I2S_FLL_FREQ_CTL_0                         0x015c
#define WCD934X_I2S_FLL_FREQ_CTL_1                         0x015d
#define WCD934X_I2S_FLL_FREQ_CTL_2                         0x015e
#define WCD934X_I2S_FLL_FREQ_CTL_3                         0x015f
#define WCD934X_I2S_FLL_SSC_CTL_0                          0x0160
#define WCD934X_I2S_FLL_SSC_CTL_1                          0x0161
#define WCD934X_I2S_FLL_SSC_CTL_2                          0x0162
#define WCD934X_I2S_FLL_SSC_CTL_3                          0x0163
#define WCD934X_I2S_FLL_FLL_MODE                           0x0164
#define WCD934X_I2S_FLL_STATUS_0                           0x0165
#define WCD934X_I2S_FLL_STATUS_1                           0x0166
#define WCD934X_I2S_FLL_STATUS_2                           0x0167
#define WCD934X_I2S_FLL_STATUS_3                           0x0168
#define WCD934X_SB_FLL_USER_CTL_0                          0x0181
#define WCD934X_SB_FLL_USER_CTL_1                          0x0182
#define WCD934X_SB_FLL_USER_CTL_2                          0x0183
#define WCD934X_SB_FLL_USER_CTL_3                          0x0184
#define WCD934X_SB_FLL_USER_CTL_4                          0x0185
#define WCD934X_SB_FLL_USER_CTL_5                          0x0186
#define WCD934X_SB_FLL_USER_CTL_6                          0x0187
#define WCD934X_SB_FLL_USER_CTL_7                          0x0188
#define WCD934X_SB_FLL_USER_CTL_8                          0x0189
#define WCD934X_SB_FLL_USER_CTL_9                          0x018a
#define WCD934X_SB_FLL_L_VAL_CTL_0                         0x018b
#define WCD934X_SB_FLL_L_VAL_CTL_1                         0x018c
#define WCD934X_SB_FLL_DSM_FRAC_CTL_0                      0x018d
#define WCD934X_SB_FLL_DSM_FRAC_CTL_1                      0x018e
#define WCD934X_SB_FLL_CONFIG_CTL_0                        0x018f
#define WCD934X_SB_FLL_CONFIG_CTL_1                        0x0190
#define WCD934X_SB_FLL_CONFIG_CTL_2                        0x0191
#define WCD934X_SB_FLL_CONFIG_CTL_3                        0x0192
#define WCD934X_SB_FLL_CONFIG_CTL_4                        0x0193
#define WCD934X_SB_FLL_TEST_CTL_0                          0x0194
#define WCD934X_SB_FLL_TEST_CTL_1                          0x0195
#define WCD934X_SB_FLL_TEST_CTL_2                          0x0196
#define WCD934X_SB_FLL_TEST_CTL_3                          0x0197
#define WCD934X_SB_FLL_TEST_CTL_4                          0x0198
#define WCD934X_SB_FLL_TEST_CTL_5                          0x0199
#define WCD934X_SB_FLL_TEST_CTL_6                          0x019a
#define WCD934X_SB_FLL_TEST_CTL_7                          0x019b
#define WCD934X_SB_FLL_FREQ_CTL_0                          0x019c
#define WCD934X_SB_FLL_FREQ_CTL_1                          0x019d
#define WCD934X_SB_FLL_FREQ_CTL_2                          0x019e
#define WCD934X_SB_FLL_FREQ_CTL_3                          0x019f
#define WCD934X_SB_FLL_SSC_CTL_0                           0x01a0
#define WCD934X_SB_FLL_SSC_CTL_1                           0x01a1
#define WCD934X_SB_FLL_SSC_CTL_2                           0x01a2
#define WCD934X_SB_FLL_SSC_CTL_3                           0x01a3
#define WCD934X_SB_FLL_FLL_MODE                            0x01a4
#define WCD934X_SB_FLL_STATUS_0                            0x01a5
#define WCD934X_SB_FLL_STATUS_1                            0x01a6
#define WCD934X_SB_FLL_STATUS_2                            0x01a7
#define WCD934X_SB_FLL_STATUS_3                            0x01a8
#define WCD934X_PAGE2_PAGE_REGISTER                        0x0200
#define WCD934X_CPE_SS_CPE_CTL                             0x0201
#define WCD934X_CPE_SS_PWR_SYS_PSTATE_CTL_0                0x0202
#define WCD934X_CPE_SS_PWR_SYS_PSTATE_CTL_1                0x0203
#define WCD934X_CPE_SS_PWR_CPEFLL_CTL                      0x0204
#define WCD934X_CPE_SS_PWR_CPE_SYSMEM_DEEPSLP_0            0x0205
#define WCD934X_CPE_SS_PWR_CPE_SYSMEM_DEEPSLP_1            0x0206
#define WCD934X_CPE_SS_PWR_CPE_SYSMEM_DEEPSLP_OVERRIDE     0x0207
#define WCD934X_CPE_SS_PWR_CPE_SYSMEM_SHUTDOWN_0           0x0208
#define WCD934X_CPE_SS_PWR_CPE_SYSMEM_SHUTDOWN_1           0x0209
#define WCD934X_CPE_SS_PWR_CPE_SYSMEM_SHUTDOWN_2           0x020a
#define WCD934X_CPE_SS_PWR_CPE_SYSMEM_SHUTDOWN_3           0x020b
#define WCD934X_CPE_SS_PWR_CPE_SYSMEM_SHUTDOWN_4           0x020c
#define WCD934X_CPE_SS_PWR_CPE_SYSMEM_SHUTDOWN_5           0x020d
#define WCD934X_CPE_SS_PWR_CPE_DRAM1_SHUTDOWN              0x020e
#define WCD934X_CPE_SS_SOC_SW_COLLAPSE_CTL                 0x020f
#define WCD934X_CPE_SS_SOC_SW_COLLAPSE_OVERRIDE_CTL        0x0210
#define WCD934X_CPE_SS_SOC_SW_COLLAPSE_OVERRIDE_CTL1       0x0211
#define WCD934X_CPE_SS_US_BUF_INT_PERIOD                   0x0212
#define WCD934X_CPE_SS_CPARMAD_BUFRDY_INT_PERIOD           0x0213
#define WCD934X_CPE_SS_SVA_CFG                             0x0214
#define WCD934X_CPE_SS_US_CFG                              0x0215
#define WCD934X_CPE_SS_MAD_CTL                             0x0216
#define WCD934X_CPE_SS_CPAR_CTL                            0x0217
#define WCD934X_CPE_SS_DMIC0_CTL                           0x0218
#define WCD934X_CPE_SS_DMIC1_CTL                           0x0219
#define WCD934X_CPE_SS_DMIC2_CTL                           0x021a
#define WCD934X_CPE_SS_DMIC_CFG                            0x021b
#define WCD934X_CPE_SS_CPAR_CFG                            0x021c
#define WCD934X_CPE_SS_WDOG_CFG                            0x021d
#define WCD934X_CPE_SS_BACKUP_INT                          0x021e
#define WCD934X_CPE_SS_STATUS                              0x021f
#define WCD934X_CPE_SS_CPE_OCD_CFG                         0x0220
#define WCD934X_CPE_SS_SS_ERROR_INT_MASK_0A                0x0221
#define WCD934X_CPE_SS_SS_ERROR_INT_MASK_0B                0x0222
#define WCD934X_CPE_SS_SS_ERROR_INT_MASK_1A                0x0223
#define WCD934X_CPE_SS_SS_ERROR_INT_MASK_1B                0x0224
#define WCD934X_CPE_SS_SS_ERROR_INT_STATUS_0A              0x0225
#define WCD934X_CPE_SS_SS_ERROR_INT_STATUS_0B              0x0226
#define WCD934X_CPE_SS_SS_ERROR_INT_STATUS_1A              0x0227
#define WCD934X_CPE_SS_SS_ERROR_INT_STATUS_1B              0x0228
#define WCD934X_CPE_SS_SS_ERROR_INT_CLEAR_0A               0x0229
#define WCD934X_CPE_SS_SS_ERROR_INT_CLEAR_0B               0x022a
#define WCD934X_CPE_SS_SS_ERROR_INT_CLEAR_1A               0x022b
#define WCD934X_CPE_SS_SS_ERROR_INT_CLEAR_1B               0x022c
#define WCD934X_SOC_MAD_MAIN_CTL_1                         0x0281
#define WCD934X_SOC_MAD_MAIN_CTL_2                         0x0282
#define WCD934X_SOC_MAD_AUDIO_CTL_1                        0x0283
#define WCD934X_SOC_MAD_AUDIO_CTL_2                        0x0284
#define WCD934X_SOC_MAD_AUDIO_CTL_3                        0x0285
#define WCD934X_SOC_MAD_AUDIO_CTL_4                        0x0286
#define WCD934X_SOC_MAD_AUDIO_CTL_5                        0x0287
#define WCD934X_SOC_MAD_AUDIO_CTL_6                        0x0288
#define WCD934X_SOC_MAD_AUDIO_CTL_7                        0x0289
#define WCD934X_SOC_MAD_AUDIO_CTL_8                        0x028a
#define WCD934X_SOC_MAD_AUDIO_IIR_CTL_PTR                  0x028b
#define WCD934X_SOC_MAD_AUDIO_IIR_CTL_VAL                  0x028c
#define WCD934X_SOC_MAD_ULTR_CTL_1                         0x028d
#define WCD934X_SOC_MAD_ULTR_CTL_2                         0x028e
#define WCD934X_SOC_MAD_ULTR_CTL_3                         0x028f
#define WCD934X_SOC_MAD_ULTR_CTL_4                         0x0290
#define WCD934X_SOC_MAD_ULTR_CTL_5                         0x0291
#define WCD934X_SOC_MAD_ULTR_CTL_6                         0x0292
#define WCD934X_SOC_MAD_ULTR_CTL_7                         0x0293
#define WCD934X_SOC_MAD_BEACON_CTL_1                       0x0294
#define WCD934X_SOC_MAD_BEACON_CTL_2                       0x0295
#define WCD934X_SOC_MAD_BEACON_CTL_3                       0x0296
#define WCD934X_SOC_MAD_BEACON_CTL_4                       0x0297
#define WCD934X_SOC_MAD_BEACON_CTL_5                       0x0298
#define WCD934X_SOC_MAD_BEACON_CTL_6                       0x0299
#define WCD934X_SOC_MAD_BEACON_CTL_7                       0x029a
#define WCD934X_SOC_MAD_BEACON_CTL_8                       0x029b
#define WCD934X_SOC_MAD_BEACON_IIR_CTL_PTR                 0x029c
#define WCD934X_SOC_MAD_BEACON_IIR_CTL_VAL                 0x029d
#define WCD934X_SOC_MAD_INP_SEL                            0x029e
#define WCD934X_PAGE4_PAGE_REGISTER                        0x0400
#define WCD934X_INTR_CFG                                   0x0401
#define WCD934X_INTR_CLR_COMMIT                            0x0402
#define WCD934X_INTR_PIN1_MASK0                            0x0409
#define WCD934X_INTR_PIN1_MASK1                            0x040a
#define WCD934X_INTR_PIN1_MASK2                            0x040b
#define WCD934X_INTR_PIN1_MASK3                            0x040c
#define WCD934X_INTR_PIN1_STATUS0                          0x0411
#define WCD934X_INTR_PIN1_STATUS1                          0x0412
#define WCD934X_INTR_PIN1_STATUS2                          0x0413
#define WCD934X_INTR_PIN1_STATUS3                          0x0414
#define WCD934X_INTR_PIN1_CLEAR0                           0x0419
#define WCD934X_INTR_PIN1_CLEAR1                           0x041a
#define WCD934X_INTR_PIN1_CLEAR2                           0x041b
#define WCD934X_INTR_PIN1_CLEAR3                           0x041c
#define WCD934X_INTR_PIN2_MASK3                            0x0424
#define WCD934X_INTR_PIN2_STATUS3                          0x042c
#define WCD934X_INTR_PIN2_CLEAR3                           0x0434
#define WCD934X_INTR_CPESS_SUMRY_MASK2                     0x043b
#define WCD934X_INTR_CPESS_SUMRY_MASK3                     0x043c
#define WCD934X_INTR_CPESS_SUMRY_STATUS2                   0x0443
#define WCD934X_INTR_CPESS_SUMRY_STATUS3                   0x0444
#define WCD934X_INTR_CPESS_SUMRY_CLEAR2                    0x044b
#define WCD934X_INTR_CPESS_SUMRY_CLEAR3                    0x044c
#define WCD934X_INTR_LEVEL0                                0x0461
#define WCD934X_INTR_LEVEL1                                0x0462
#define WCD934X_INTR_LEVEL2                                0x0463
#define WCD934X_INTR_LEVEL3                                0x0464
#define WCD934X_INTR_BYPASS0                               0x0469
#define WCD934X_INTR_BYPASS1                               0x046a
#define WCD934X_INTR_BYPASS2                               0x046b
#define WCD934X_INTR_BYPASS3                               0x046c
#define WCD934X_INTR_SET0                                  0x0471
#define WCD934X_INTR_SET1                                  0x0472
#define WCD934X_INTR_SET2                                  0x0473
#define WCD934X_INTR_SET3                                  0x0474
#define WCD934X_INTR_CODEC_MISC_MASK                       0x04b1
#define WCD934X_INTR_CODEC_MISC_STATUS                     0x04b2
#define WCD934X_INTR_CODEC_MISC_CLEAR                      0x04b3
#define WCD934X_PAGE5_PAGE_REGISTER                        0x0500
#define WCD934X_SLNQ_DIG_DEVICE                            0x0501
#define WCD934X_SLNQ_DIG_REVISION                          0x0502
#define WCD934X_SLNQ_DIG_H_COMMAND                         0x0511
#define WCD934X_SLNQ_DIG_NUMBER_OF_BYTE_MSB                0x0512
#define WCD934X_SLNQ_DIG_NUMBER_OF_BYTE_LSB                0x0513
#define WCD934X_SLNQ_DIG_MASTER_ADDRESS_MSB                0x0514
#define WCD934X_SLNQ_DIG_MASTER_ADDRESS_LSB                0x0515
#define WCD934X_SLNQ_DIG_SLAVE_ADDRESS_MSB                 0x0516
#define WCD934X_SLNQ_DIG_SLAVE_ADDRESS_LSB                 0x0517
#define WCD934X_SLNQ_DIG_TIMER0_INTERRUPT_MSB              0x0518
#define WCD934X_SLNQ_DIG_TIMER0_INTERRUPT_LSB              0x0519
#define WCD934X_SLNQ_DIG_TIMER1_INTERRUPT_MSB              0x051a
#define WCD934X_SLNQ_DIG_TIMER1_INTERRUPT_LSB              0x051b
#define WCD934X_SLNQ_DIG_TIMER2_INTERRUPT_MSB              0x051c
#define WCD934X_SLNQ_DIG_TIMER2_INTERRUPT_LSB              0x051d
#define WCD934X_SLNQ_DIG_COMM_CTL                          0x0520
#define WCD934X_SLNQ_DIG_FRAME_CTRL                        0x0542
#define WCD934X_SLNQ_DIG_PDM_2ND_DATA_CH1_2                0x055c
#define WCD934X_SLNQ_DIG_PDM_2ND_DATA_CH3_4                0x055d
#define WCD934X_SLNQ_DIG_PDM_2ND_DATA_CH5                  0x055e
#define WCD934X_SLNQ_DIG_SW_EVENT_RD                       0x0561
#define WCD934X_SLNQ_DIG_SW_EVENT_CTRL                     0x0562
#define WCD934X_SLNQ_DIG_PDM_SELECT_1                      0x0563
#define WCD934X_SLNQ_DIG_PDM_SELECT_2                      0x0564
#define WCD934X_SLNQ_DIG_PDM_SELECT_3                      0x0565
#define WCD934X_SLNQ_DIG_PDM_SAMPLING_FREQ                 0x0566
#define WCD934X_SLNQ_DIG_PDM_DC_CONVERSION_CTL             0x0569
#define WCD934X_SLNQ_DIG_PDM_DC_CONVERSION_SEL             0x056a
#define WCD934X_SLNQ_DIG_PDM_DC_CONV_CHA_MSB               0x056b
#define WCD934X_SLNQ_DIG_PDM_DC_CONV_CHA_LSB               0x056c
#define WCD934X_SLNQ_DIG_PDM_DC_CONV_CHB_MSB               0x056d
#define WCD934X_SLNQ_DIG_PDM_DC_CONV_CHB_LSB               0x056e
#define WCD934X_SLNQ_DIG_RAM_CNTRL                         0x0571
#define WCD934X_SLNQ_DIG_SRAM_BANK                         0x0572
#define WCD934X_SLNQ_DIG_SRAM_BYTE_0                       0x0573
#define WCD934X_SLNQ_DIG_SRAM_BYTE_1                       0x0574
#define WCD934X_SLNQ_DIG_SRAM_BYTE_2                       0x0575
#define WCD934X_SLNQ_DIG_SRAM_BYTE_3                       0x0576
#define WCD934X_SLNQ_DIG_SRAM_BYTE_4                       0x0577
#define WCD934X_SLNQ_DIG_SRAM_BYTE_5                       0x0578
#define WCD934X_SLNQ_DIG_SRAM_BYTE_6                       0x0579
#define WCD934X_SLNQ_DIG_SRAM_BYTE_7                       0x057a
#define WCD934X_SLNQ_DIG_SRAM_BYTE_8                       0x057b
#define WCD934X_SLNQ_DIG_SRAM_BYTE_9                       0x057c
#define WCD934X_SLNQ_DIG_SRAM_BYTE_A                       0x057d
#define WCD934X_SLNQ_DIG_SRAM_BYTE_B                       0x057e
#define WCD934X_SLNQ_DIG_SRAM_BYTE_C                       0x057f
#define WCD934X_SLNQ_DIG_SRAM_BYTE_D                       0x0580
#define WCD934X_SLNQ_DIG_SRAM_BYTE_E                       0x0581
#define WCD934X_SLNQ_DIG_SRAM_BYTE_F                       0x0582
#define WCD934X_SLNQ_DIG_SRAM_BYTE_10                      0x0583
#define WCD934X_SLNQ_DIG_SRAM_BYTE_11                      0x0584
#define WCD934X_SLNQ_DIG_SRAM_BYTE_12                      0x0585
#define WCD934X_SLNQ_DIG_SRAM_BYTE_13                      0x0586
#define WCD934X_SLNQ_DIG_SRAM_BYTE_14                      0x0587
#define WCD934X_SLNQ_DIG_SRAM_BYTE_15                      0x0588
#define WCD934X_SLNQ_DIG_SRAM_BYTE_16                      0x0589
#define WCD934X_SLNQ_DIG_SRAM_BYTE_17                      0x058a
#define WCD934X_SLNQ_DIG_SRAM_BYTE_18                      0x058b
#define WCD934X_SLNQ_DIG_SRAM_BYTE_19                      0x058c
#define WCD934X_SLNQ_DIG_SRAM_BYTE_1A                      0x058d
#define WCD934X_SLNQ_DIG_SRAM_BYTE_1B                      0x058e
#define WCD934X_SLNQ_DIG_SRAM_BYTE_1C                      0x058f
#define WCD934X_SLNQ_DIG_SRAM_BYTE_1D                      0x0590
#define WCD934X_SLNQ_DIG_SRAM_BYTE_1E                      0x0591
#define WCD934X_SLNQ_DIG_SRAM_BYTE_1F                      0x0592
#define WCD934X_SLNQ_DIG_SRAM_BYTE_20                      0x0593
#define WCD934X_SLNQ_DIG_SRAM_BYTE_21                      0x0594
#define WCD934X_SLNQ_DIG_SRAM_BYTE_22                      0x0595
#define WCD934X_SLNQ_DIG_SRAM_BYTE_23                      0x0596
#define WCD934X_SLNQ_DIG_SRAM_BYTE_24                      0x0597
#define WCD934X_SLNQ_DIG_SRAM_BYTE_25                      0x0598
#define WCD934X_SLNQ_DIG_SRAM_BYTE_26                      0x0599
#define WCD934X_SLNQ_DIG_SRAM_BYTE_27                      0x059a
#define WCD934X_SLNQ_DIG_SRAM_BYTE_28                      0x059b
#define WCD934X_SLNQ_DIG_SRAM_BYTE_29                      0x059c
#define WCD934X_SLNQ_DIG_SRAM_BYTE_2A                      0x059d
#define WCD934X_SLNQ_DIG_SRAM_BYTE_2B                      0x059e
#define WCD934X_SLNQ_DIG_SRAM_BYTE_2C                      0x059f
#define WCD934X_SLNQ_DIG_SRAM_BYTE_2D                      0x05a0
#define WCD934X_SLNQ_DIG_SRAM_BYTE_2E                      0x05a1
#define WCD934X_SLNQ_DIG_SRAM_BYTE_2F                      0x05a2
#define WCD934X_SLNQ_DIG_SRAM_BYTE_30                      0x05a3
#define WCD934X_SLNQ_DIG_SRAM_BYTE_31                      0x05a4
#define WCD934X_SLNQ_DIG_SRAM_BYTE_32                      0x05a5
#define WCD934X_SLNQ_DIG_SRAM_BYTE_33                      0x05a6
#define WCD934X_SLNQ_DIG_SRAM_BYTE_34                      0x05a7
#define WCD934X_SLNQ_DIG_SRAM_BYTE_35                      0x05a8
#define WCD934X_SLNQ_DIG_SRAM_BYTE_36                      0x05a9
#define WCD934X_SLNQ_DIG_SRAM_BYTE_37                      0x05aa
#define WCD934X_SLNQ_DIG_SRAM_BYTE_38                      0x05ab
#define WCD934X_SLNQ_DIG_SRAM_BYTE_39                      0x05ac
#define WCD934X_SLNQ_DIG_SRAM_BYTE_3A                      0x05ad
#define WCD934X_SLNQ_DIG_SRAM_BYTE_3B                      0x05ae
#define WCD934X_SLNQ_DIG_SRAM_BYTE_3C                      0x05af
#define WCD934X_SLNQ_DIG_SRAM_BYTE_3D                      0x05b0
#define WCD934X_SLNQ_DIG_SRAM_BYTE_3E                      0x05b1
#define WCD934X_SLNQ_DIG_SRAM_BYTE_3F                      0x05b2
#define WCD934X_SLNQ_DIG_TOP_CTRL1                         0x05b3
#define WCD934X_SLNQ_DIG_TOP_CTRL2                         0x05b4
#define WCD934X_SLNQ_DIG_PDM_CTRL                          0x05b5
#define WCD934X_SLNQ_DIG_PDM_MUTE_CTRL                     0x05b6
#define WCD934X_SLNQ_DIG_DEC_BYPASS_CTRL                   0x05b7
#define WCD934X_SLNQ_DIG_DEC_BYPASS_STATUS                 0x05b8
#define WCD934X_SLNQ_DIG_DEC_BYPASS_FS                     0x05b9
#define WCD934X_SLNQ_DIG_DEC_BYPASS_IN_SEL                 0x05ba
#define WCD934X_SLNQ_DIG_GPOUT_ENABLE                      0x05bb
#define WCD934X_SLNQ_DIG_GPOUT_VAL                         0x05bc
#define WCD934X_SLNQ_DIG_ANA_INTERRUPT_MASK                0x05be
#define WCD934X_SLNQ_DIG_ANA_INTERRUPT_STATUS              0x05bf
#define WCD934X_SLNQ_DIG_ANA_INTERRUPT_CLR                 0x05c0
#define WCD934X_SLNQ_DIG_IP_TESTING                        0x05c1
#define WCD934X_SLNQ_DIG_INTERRUPT_CNTRL                   0x05e3
#define WCD934X_SLNQ_DIG_INTERRUPT_CNT                     0x05e9
#define WCD934X_SLNQ_DIG_INTERRUPT_CNT_MSB                 0x05eb
#define WCD934X_SLNQ_DIG_INTERRUPT_CNT_LSB                 0x05ec
#define WCD934X_SLNQ_DIG_INTERRUPT_MASK0                   0x05f1
#define WCD934X_SLNQ_DIG_INTERRUPT_MASK1                   0x05f2
#define WCD934X_SLNQ_DIG_INTERRUPT_MASK2                   0x05f3
#define WCD934X_SLNQ_DIG_INTERRUPT_MASK3                   0x05f4
#define WCD934X_SLNQ_DIG_INTERRUPT_MASK4                   0x05f5
#define WCD934X_SLNQ_DIG_INTERRUPT_STATUS0                 0x05f6
#define WCD934X_SLNQ_DIG_INTERRUPT_STATUS1                 0x05f7
#define WCD934X_SLNQ_DIG_INTERRUPT_STATUS2                 0x05f8
#define WCD934X_SLNQ_DIG_INTERRUPT_STATUS3                 0x05f9
#define WCD934X_SLNQ_DIG_INTERRUPT_STATUS4                 0x05fa
#define WCD934X_SLNQ_DIG_INTERRUPT_CLR0                    0x05fb
#define WCD934X_SLNQ_DIG_INTERRUPT_CLR1                    0x05fc
#define WCD934X_SLNQ_DIG_INTERRUPT_CLR2                    0x05fd
#define WCD934X_SLNQ_DIG_INTERRUPT_CLR3                    0x05fe
#define WCD934X_SLNQ_DIG_INTERRUPT_CLR4                    0x05ff
#define WCD934X_ANA_PAGE_REGISTER                          0x0600
#define WCD934X_ANA_BIAS                                   0x0601
#define WCD934X_ANA_RCO                                    0x0603
#define WCD934X_ANA_PAGE6_SPARE2                           0x0604
#define WCD934X_ANA_PAGE6_SPARE3                           0x0605
#define WCD934X_ANA_BUCK_CTL                               0x0606
#define WCD934X_ANA_BUCK_STATUS                            0x0607
#define WCD934X_ANA_RX_SUPPLIES                            0x0608
#define WCD934X_ANA_HPH                                    0x0609
#define WCD934X_ANA_EAR                                    0x060a
#define WCD934X_ANA_LO_1_2                                 0x060b
#define WCD934X_ANA_MAD_SETUP                              0x060d
#define WCD934X_ANA_AMIC1                                  0x060e
#define WCD934X_ANA_AMIC2                                  0x060f
#define WCD934X_ANA_AMIC3                                  0x0610
#define WCD934X_ANA_AMIC4                                  0x0611
#define WCD934X_ANA_MBHC_MECH                              0x0614
#define WCD934X_ANA_MBHC_ELECT                             0x0615
#define WCD934X_ANA_MBHC_ZDET                              0x0616
#define WCD934X_ANA_MBHC_RESULT_1                          0x0617
#define WCD934X_ANA_MBHC_RESULT_2                          0x0618
#define WCD934X_ANA_MBHC_RESULT_3                          0x0619
#define WCD934X_ANA_MBHC_BTN0                              0x061a
#define WCD934X_ANA_MBHC_BTN1                              0x061b
#define WCD934X_ANA_MBHC_BTN2                              0x061c
#define WCD934X_ANA_MBHC_BTN3                              0x061d
#define WCD934X_ANA_MBHC_BTN4                              0x061e
#define WCD934X_ANA_MBHC_BTN5                              0x061f
#define WCD934X_ANA_MBHC_BTN6                              0x0620
#define WCD934X_ANA_MBHC_BTN7                              0x0621
#define WCD934X_ANA_MICB1                                  0x0622
#define WCD934X_ANA_MICB2                                  0x0623
#define WCD934X_ANA_MICB2_RAMP                             0x0624
#define WCD934X_ANA_MICB3                                  0x0625
#define WCD934X_ANA_MICB4                                  0x0626
#define WCD934X_ANA_VBADC                                  0x0627
#define WCD934X_BIAS_CTL                                   0x0628
#define WCD934X_BIAS_VBG_FINE_ADJ                          0x0629
#define WCD934X_RCO_CTRL_1                                 0x062e
#define WCD934X_RCO_CTRL_2                                 0x062f
#define WCD934X_RCO_CAL                                    0x0630
#define WCD934X_RCO_CAL_1                                  0x0631
#define WCD934X_RCO_CAL_2                                  0x0632
#define WCD934X_RCO_TEST_CTRL                              0x0633
#define WCD934X_RCO_CAL_OUT_1                              0x0634
#define WCD934X_RCO_CAL_OUT_2                              0x0635
#define WCD934X_RCO_CAL_OUT_3                              0x0636
#define WCD934X_RCO_CAL_OUT_4                              0x0637
#define WCD934X_RCO_CAL_OUT_5                              0x0638
#define WCD934X_SIDO_MODE_1                                0x063a
#define WCD934X_SIDO_MODE_2                                0x063b
#define WCD934X_SIDO_MODE_3                                0x063c
#define WCD934X_SIDO_MODE_4                                0x063d
#define WCD934X_SIDO_VCL_1                                 0x063e
#define WCD934X_SIDO_VCL_2                                 0x063f
#define WCD934X_SIDO_VCL_3                                 0x0640
#define WCD934X_SIDO_CCL_1                                 0x0641
#define WCD934X_SIDO_CCL_2                                 0x0642
#define WCD934X_SIDO_CCL_3                                 0x0643
#define WCD934X_SIDO_CCL_4                                 0x0644
#define WCD934X_SIDO_CCL_5                                 0x0645
#define WCD934X_SIDO_CCL_6                                 0x0646
#define WCD934X_SIDO_CCL_7                                 0x0647
#define WCD934X_SIDO_CCL_8                                 0x0648
#define WCD934X_SIDO_CCL_9                                 0x0649
#define WCD934X_SIDO_CCL_10                                0x064a
#define WCD934X_SIDO_FILTER_1                              0x064b
#define WCD934X_SIDO_FILTER_2                              0x064c
#define WCD934X_SIDO_DRIVER_1                              0x064d
#define WCD934X_SIDO_DRIVER_2                              0x064e
#define WCD934X_SIDO_DRIVER_3                              0x064f
#define WCD934X_SIDO_CAL_CODE_EXT_1                        0x0650
#define WCD934X_SIDO_CAL_CODE_EXT_2                        0x0651
#define WCD934X_SIDO_CAL_CODE_OUT_1                        0x0652
#define WCD934X_SIDO_CAL_CODE_OUT_2                        0x0653
#define WCD934X_SIDO_TEST_1                                0x0654
#define WCD934X_SIDO_TEST_2                                0x0655
#define WCD934X_MBHC_CTL_CLK                               0x0656
#define WCD934X_MBHC_CTL_ANA                               0x0657
#define WCD934X_MBHC_CTL_SPARE_1                           0x0658
#define WCD934X_MBHC_CTL_SPARE_2                           0x0659
#define WCD934X_MBHC_CTL_BCS                               0x065a
#define WCD934X_MBHC_STATUS_SPARE_1                        0x065b
#define WCD934X_MBHC_TEST_CTL                              0x065c
#define WCD934X_VBADC_SUBBLOCK_EN                          0x065d
#define WCD934X_VBADC_IBIAS_FE                             0x065e
#define WCD934X_VBADC_BIAS_ADC                             0x065f
#define WCD934X_VBADC_FE_CTRL                              0x0660
#define WCD934X_VBADC_ADC_REF                              0x0661
#define WCD934X_VBADC_ADC_IO                               0x0662
#define WCD934X_VBADC_ADC_SAR                              0x0663
#define WCD934X_VBADC_DEBUG                                0x0664
#define WCD934X_LDOH_MODE                                  0x0667
#define WCD934X_LDOH_BIAS                                  0x0668
#define WCD934X_LDOH_STB_LOADS                             0x0669
#define WCD934X_LDOH_SLOWRAMP                              0x066a
#define WCD934X_MICB1_TEST_CTL_1                           0x066b
#define WCD934X_MICB1_TEST_CTL_2                           0x066c
#define WCD934X_MICB1_TEST_CTL_3                           0x066d
#define WCD934X_MICB2_TEST_CTL_1                           0x066e
#define WCD934X_MICB2_TEST_CTL_2                           0x066f
#define WCD934X_MICB2_TEST_CTL_3                           0x0670
#define WCD934X_MICB3_TEST_CTL_1                           0x0671
#define WCD934X_MICB3_TEST_CTL_2                           0x0672
#define WCD934X_MICB3_TEST_CTL_3                           0x0673
#define WCD934X_MICB4_TEST_CTL_1                           0x0674
#define WCD934X_MICB4_TEST_CTL_2                           0x0675
#define WCD934X_MICB4_TEST_CTL_3                           0x0676
#define WCD934X_TX_COM_ADC_VCM                             0x0677
#define WCD934X_TX_COM_BIAS_ATEST                          0x0678
#define WCD934X_TX_COM_ADC_INT1_IB                         0x0679
#define WCD934X_TX_COM_ADC_INT2_IB                         0x067a
#define WCD934X_TX_COM_TXFE_DIV_CTL                        0x067b
#define WCD934X_TX_COM_TXFE_DIV_START                      0x067c
#define WCD934X_TX_COM_TXFE_DIV_STOP_9P6M                  0x067d
#define WCD934X_TX_COM_TXFE_DIV_STOP_12P288M               0x067e
#define WCD934X_TX_1_2_TEST_EN                             0x067f
#define WCD934X_TX_1_2_ADC_IB                              0x0680
#define WCD934X_TX_1_2_ATEST_REFCTL                        0x0681
#define WCD934X_TX_1_2_TEST_CTL                            0x0682
#define WCD934X_TX_1_2_TEST_BLK_EN                         0x0683
#define WCD934X_TX_1_2_TXFE_CLKDIV                         0x0684
#define WCD934X_TX_1_2_SAR1_ERR                            0x0685
#define WCD934X_TX_1_2_SAR2_ERR                            0x0686
#define WCD934X_TX_3_4_TEST_EN                             0x0687
#define WCD934X_TX_3_4_ADC_IB                              0x0688
#define WCD934X_TX_3_4_ATEST_REFCTL                        0x0689
#define WCD934X_TX_3_4_TEST_CTL                            0x068a
#define WCD934X_TX_3_4_TEST_BLK_EN                         0x068b
#define WCD934X_TX_3_4_TXFE_CLKDIV                         0x068c
#define WCD934X_TX_3_4_SAR1_ERR                            0x068d
#define WCD934X_TX_3_4_SAR2_ERR                            0x068e
#define WCD934X_CLASSH_MODE_1                              0x0697
#define WCD934X_CLASSH_MODE_2                              0x0698
#define WCD934X_CLASSH_MODE_3                              0x0699
#define WCD934X_CLASSH_CTRL_VCL_1                          0x069a
#define WCD934X_CLASSH_CTRL_VCL_2                          0x069b
#define WCD934X_CLASSH_CTRL_CCL_1                          0x069c
#define WCD934X_CLASSH_CTRL_CCL_2                          0x069d
#define WCD934X_CLASSH_CTRL_CCL_3                          0x069e
#define WCD934X_CLASSH_CTRL_CCL_4                          0x069f
#define WCD934X_CLASSH_CTRL_CCL_5                          0x06a0
#define WCD934X_CLASSH_BUCK_TMUX_A_D                       0x06a1
#define WCD934X_CLASSH_BUCK_SW_DRV_CNTL                    0x06a2
#define WCD934X_CLASSH_SPARE                               0x06a3
#define WCD934X_FLYBACK_EN                                 0x06a4
#define WCD934X_FLYBACK_VNEG_CTRL_1                        0x06a5
#define WCD934X_FLYBACK_VNEG_CTRL_2                        0x06a6
#define WCD934X_FLYBACK_VNEG_CTRL_3                        0x06a7
#define WCD934X_FLYBACK_VNEG_CTRL_4                        0x06a8
#define WCD934X_FLYBACK_VNEG_CTRL_5                        0x06a9
#define WCD934X_FLYBACK_VNEG_CTRL_6                        0x06aa
#define WCD934X_FLYBACK_VNEG_CTRL_7                        0x06ab
#define WCD934X_FLYBACK_VNEG_CTRL_8                        0x06ac
#define WCD934X_FLYBACK_VNEG_CTRL_9                        0x06ad
#define WCD934X_FLYBACK_VNEGDAC_CTRL_1                     0x06ae
#define WCD934X_FLYBACK_VNEGDAC_CTRL_2                     0x06af
#define WCD934X_FLYBACK_VNEGDAC_CTRL_3                     0x06b0
#define WCD934X_FLYBACK_CTRL_1                             0x06b1
#define WCD934X_FLYBACK_TEST_CTL                           0x06b2
#define WCD934X_RX_AUX_SW_CTL                              0x06b3
#define WCD934X_RX_PA_AUX_IN_CONN                          0x06b4
#define WCD934X_RX_TIMER_DIV                               0x06b5
#define WCD934X_RX_OCP_CTL                                 0x06b6
#define WCD934X_RX_OCP_COUNT                               0x06b7
#define WCD934X_RX_BIAS_EAR_DAC                            0x06b8
#define WCD934X_RX_BIAS_EAR_AMP                            0x06b9
#define WCD934X_RX_BIAS_HPH_LDO                            0x06ba
#define WCD934X_RX_BIAS_HPH_PA                             0x06bb
#define WCD934X_RX_BIAS_HPH_RDACBUFF_CNP2                  0x06bc
#define WCD934X_RX_BIAS_HPH_RDAC_LDO                       0x06bd
#define WCD934X_RX_BIAS_HPH_CNP1                           0x06be
#define WCD934X_RX_BIAS_HPH_LOWPOWER                       0x06bf
#define WCD934X_RX_BIAS_DIFFLO_PA                          0x06c0
#define WCD934X_RX_BIAS_DIFFLO_REF                         0x06c1
#define WCD934X_RX_BIAS_DIFFLO_LDO                         0x06c2
#define WCD934X_RX_BIAS_SELO_DAC_PA                        0x06c3
#define WCD934X_RX_BIAS_BUCK_RST                           0x06c4
#define WCD934X_RX_BIAS_BUCK_VREF_ERRAMP                   0x06c5
#define WCD934X_RX_BIAS_FLYB_ERRAMP                        0x06c6
#define WCD934X_RX_BIAS_FLYB_BUFF                          0x06c7
#define WCD934X_RX_BIAS_FLYB_MID_RST                       0x06c8
#define WCD934X_HPH_L_STATUS                               0x06c9
#define WCD934X_HPH_R_STATUS                               0x06ca
#define WCD934X_HPH_CNP_EN                                 0x06cb
#define WCD934X_HPH_CNP_WG_CTL                             0x06cc
#define WCD934X_HPH_CNP_WG_TIME                            0x06cd
#define WCD934X_HPH_OCP_CTL                                0x06ce
#define WCD934X_HPH_AUTO_CHOP                              0x06cf
#define WCD934X_HPH_CHOP_CTL                               0x06d0
#define WCD934X_HPH_PA_CTL1                                0x06d1
#define WCD934X_HPH_PA_CTL2                                0x06d2
#define WCD934X_HPH_L_EN                                   0x06d3
#define WCD934X_HPH_L_TEST                                 0x06d4
#define WCD934X_HPH_L_ATEST                                0x06d5
#define WCD934X_HPH_R_EN                                   0x06d6
#define WCD934X_HPH_R_TEST                                 0x06d7
#define WCD934X_HPH_R_ATEST                                0x06d8
#define WCD934X_HPH_RDAC_CLK_CTL1                          0x06d9
#define WCD934X_HPH_RDAC_CLK_CTL2                          0x06da
#define WCD934X_HPH_RDAC_LDO_CTL                           0x06db
#define WCD934X_HPH_RDAC_CHOP_CLK_LP_CTL                   0x06dc
#define WCD934X_HPH_REFBUFF_UHQA_CTL                       0x06dd
#define WCD934X_HPH_REFBUFF_LP_CTL                         0x06de
#define WCD934X_HPH_L_DAC_CTL                              0x06df
#define WCD934X_HPH_R_DAC_CTL                              0x06e0
#define WCD934X_EAR_EN_REG                                 0x06e1
#define WCD934X_EAR_CMBUFF                                 0x06e2
#define WCD934X_EAR_ICTL                                   0x06e3
#define WCD934X_EAR_EN_DBG_CTL                             0x06e4
#define WCD934X_EAR_CNP                                    0x06e5
#define WCD934X_EAR_DAC_CTL_ATEST                          0x06e6
#define WCD934X_EAR_STATUS_REG                             0x06e7
#define WCD934X_EAR_EAR_MISC                               0x06e8
#define WCD934X_DIFF_LO_MISC                               0x06e9
#define WCD934X_DIFF_LO_LO2_COMPANDER                      0x06ea
#define WCD934X_DIFF_LO_LO1_COMPANDER                      0x06eb
#define WCD934X_DIFF_LO_COMMON                             0x06ec
#define WCD934X_DIFF_LO_BYPASS_EN                          0x06ed
#define WCD934X_DIFF_LO_CNP                                0x06ee
#define WCD934X_DIFF_LO_CORE_OUT_PROG                      0x06ef
#define WCD934X_DIFF_LO_LDO_OUT_PROG                       0x06f0
#define WCD934X_DIFF_LO_COM_SWCAP_REFBUF_FREQ              0x06f1
#define WCD934X_DIFF_LO_COM_PA_FREQ                        0x06f2
#define WCD934X_DIFF_LO_RESERVED_REG                       0x06f3
#define WCD934X_DIFF_LO_LO1_STATUS_1                       0x06f4
#define WCD934X_DIFF_LO_LO1_STATUS_2                       0x06f5
#define WCD934X_ANA_NEW_PAGE_REGISTER                      0x0700
#define WCD934X_HPH_NEW_ANA_HPH2                           0x0701
#define WCD934X_HPH_NEW_ANA_HPH3                           0x0702
#define WCD934X_SLNQ_ANA_EN                                0x0703
#define WCD934X_SLNQ_ANA_STATUS                            0x0704
#define WCD934X_SLNQ_ANA_LDO_CONFIG                        0x0705
#define WCD934X_SLNQ_ANA_LDO_OCP_CONFIG                    0x0706
#define WCD934X_SLNQ_ANA_TX_LDO_CONFIG                     0x0707
#define WCD934X_SLNQ_ANA_TX_DRV_CONFIG                     0x0708
#define WCD934X_SLNQ_ANA_RX_CONFIG_1                       0x0709
#define WCD934X_SLNQ_ANA_RX_CONFIG_2                       0x070a
#define WCD934X_SLNQ_ANA_PLL_ENABLES                       0x070b
#define WCD934X_SLNQ_ANA_PLL_PRESET                        0x070c
#define WCD934X_SLNQ_ANA_PLL_STATUS                        0x070d
#define WCD934X_CLK_SYS_PLL_ENABLES                        0x070e
#define WCD934X_CLK_SYS_PLL_PRESET                         0x070f
#define WCD934X_CLK_SYS_PLL_STATUS                         0x0710
#define WCD934X_CLK_SYS_MCLK_PRG                           0x0711
#define WCD934X_CLK_SYS_MCLK2_PRG1                         0x0712
#define WCD934X_CLK_SYS_MCLK2_PRG2                         0x0713
#define WCD934X_CLK_SYS_XO_PRG                             0x0714
#define WCD934X_CLK_SYS_XO_CAP_XTP                         0x0715
#define WCD934X_CLK_SYS_XO_CAP_XTM                         0x0716
#define WCD934X_BOOST_BST_EN_DLY                           0x0718
#define WCD934X_BOOST_CTRL_ILIM                            0x0719
#define WCD934X_BOOST_VOUT_SETTING                         0x071a
#define WCD934X_SIDO_NEW_VOUT_A_STARTUP                    0x071b
#define WCD934X_SIDO_NEW_VOUT_D_STARTUP                    0x071c
#define WCD934X_SIDO_NEW_VOUT_D_FREQ1                      0x071d
#define WCD934X_SIDO_NEW_VOUT_D_FREQ2                      0x071e
#define WCD934X_MBHC_NEW_ELECT_REM_CLAMP_CTL               0x071f
#define WCD934X_MBHC_NEW_CTL_1                             0x0720
#define WCD934X_MBHC_NEW_CTL_2                             0x0721
#define WCD934X_MBHC_NEW_PLUG_DETECT_CTL                   0x0722
#define WCD934X_MBHC_NEW_ZDET_ANA_CTL                      0x0723
#define WCD934X_MBHC_NEW_ZDET_RAMP_CTL                     0x0724
#define WCD934X_MBHC_NEW_FSM_STATUS                        0x0725
#define WCD934X_MBHC_NEW_ADC_RESULT                        0x0726
#define WCD934X_TX_NEW_AMIC_4_5_SEL                        0x0727
#define WCD934X_VBADC_NEW_ADC_MODE                         0x072f
#define WCD934X_VBADC_NEW_ADC_DOUTMSB                      0x0730
#define WCD934X_VBADC_NEW_ADC_DOUTLSB                      0x0731
#define WCD934X_HPH_NEW_INT_RDAC_GAIN_CTL                  0x0732
#define WCD934X_HPH_NEW_INT_RDAC_HD2_CTL                   0x0733
#define WCD934X_HPH_NEW_INT_RDAC_HD2_CTL_L                 0x0733
#define WCD934X_HPH_NEW_INT_RDAC_VREF_CTL                  0x0734
#define WCD934X_HPH_NEW_INT_RDAC_OVERRIDE_CTL              0x0735
#define WCD934X_HPH_NEW_INT_RDAC_MISC1                     0x0736
#define WCD934X_HPH_NEW_INT_RDAC_HD2_CTL_R                 0x0736
#define WCD934X_HPH_NEW_INT_PA_MISC1                       0x0737
#define WCD934X_HPH_NEW_INT_PA_MISC2                       0x0738
#define WCD934X_HPH_NEW_INT_PA_RDAC_MISC                   0x0739
#define WCD934X_HPH_NEW_INT_HPH_TIMER1                     0x073a
#define WCD934X_HPH_NEW_INT_HPH_TIMER2                     0x073b
#define WCD934X_HPH_NEW_INT_HPH_TIMER3                     0x073c
#define WCD934X_HPH_NEW_INT_HPH_TIMER4                     0x073d
#define WCD934X_HPH_NEW_INT_PA_RDAC_MISC2                  0x073e
#define WCD934X_HPH_NEW_INT_PA_RDAC_MISC3                  0x073f
#define WCD934X_RX_NEW_INT_HPH_RDAC_BIAS_LOHIFI            0x0745
#define WCD934X_RX_NEW_INT_HPH_RDAC_BIAS_ULP               0x0746
#define WCD934X_RX_NEW_INT_HPH_RDAC_LDO_LP                 0x0747
#define WCD934X_SLNQ_INT_ANA_INT_LDO_TEST                  0x074b
#define WCD934X_SLNQ_INT_ANA_INT_LDO_DEBUG_1               0x074c
#define WCD934X_SLNQ_INT_ANA_INT_LDO_DEBUG_2               0x074d
#define WCD934X_SLNQ_INT_ANA_INT_TX_LDO_TEST               0x074e
#define WCD934X_SLNQ_INT_ANA_INT_TX_DRV_TEST               0x074f
#define WCD934X_SLNQ_INT_ANA_INT_RX_TEST                   0x0750
#define WCD934X_SLNQ_INT_ANA_INT_RX_TEST_STATUS            0x0751
#define WCD934X_SLNQ_INT_ANA_INT_RX_DEBUG_1                0x0752
#define WCD934X_SLNQ_INT_ANA_INT_RX_DEBUG_2                0x0753
#define WCD934X_SLNQ_INT_ANA_INT_CLK_CTRL                  0x0754
#define WCD934X_SLNQ_INT_ANA_INT_RESERVED_1                0x0755
#define WCD934X_SLNQ_INT_ANA_INT_RESERVED_2                0x0756
#define WCD934X_SLNQ_INT_ANA_INT_PLL_POST_DIV_REG0         0x0757
#define WCD934X_SLNQ_INT_ANA_INT_PLL_POST_DIV_REG1         0x0758
#define WCD934X_SLNQ_INT_ANA_INT_PLL_REF_DIV_REG0          0x0759
#define WCD934X_SLNQ_INT_ANA_INT_PLL_REF_DIV_REG1          0x075a
#define WCD934X_SLNQ_INT_ANA_INT_PLL_FILTER_REG0           0x075b
#define WCD934X_SLNQ_INT_ANA_INT_PLL_FILTER_REG1           0x075c
#define WCD934X_SLNQ_INT_ANA_INT_PLL_L_VAL                 0x075d
#define WCD934X_SLNQ_INT_ANA_INT_PLL_M_VAL                 0x075e
#define WCD934X_SLNQ_INT_ANA_INT_PLL_N_VAL                 0x075f
#define WCD934X_SLNQ_INT_ANA_INT_PLL_TEST_REG0             0x0760
#define WCD934X_SLNQ_INT_ANA_INT_PLL_PFD_CP_DSM_PROG       0x0761
#define WCD934X_SLNQ_INT_ANA_INT_PLL_VCO_PROG              0x0762
#define WCD934X_SLNQ_INT_ANA_INT_PLL_TEST_REG1             0x0763
#define WCD934X_SLNQ_INT_ANA_INT_PLL_LDO_LOCK_CFG          0x0764
#define WCD934X_SLNQ_INT_ANA_INT_PLL_DIG_LOCK_DET_CFG      0x0765
#define WCD934X_CLK_SYS_INT_POST_DIV_REG0                  0x076c
#define WCD934X_CLK_SYS_INT_POST_DIV_REG1                  0x076d
#define WCD934X_CLK_SYS_INT_REF_DIV_REG0                   0x076e
#define WCD934X_CLK_SYS_INT_REF_DIV_REG1                   0x076f
#define WCD934X_CLK_SYS_INT_FILTER_REG0                    0x0770
#define WCD934X_CLK_SYS_INT_FILTER_REG1                    0x0771
#define WCD934X_CLK_SYS_INT_PLL_L_VAL                      0x0772
#define WCD934X_CLK_SYS_INT_PLL_M_VAL                      0x0773
#define WCD934X_CLK_SYS_INT_PLL_N_VAL                      0x0774
#define WCD934X_CLK_SYS_INT_TEST_REG0                      0x0775
#define WCD934X_CLK_SYS_INT_PFD_CP_DSM_PROG                0x0776
#define WCD934X_CLK_SYS_INT_VCO_PROG                       0x0777
#define WCD934X_CLK_SYS_INT_TEST_REG1                      0x0778
#define WCD934X_CLK_SYS_INT_LDO_LOCK_CFG                   0x0779
#define WCD934X_CLK_SYS_INT_DIG_LOCK_DET_CFG               0x077a
#define WCD934X_CLK_SYS_INT_CLK_TEST1                      0x077b
#define WCD934X_CLK_SYS_INT_CLK_TEST2                      0x077c
#define WCD934X_CLK_SYS_INT_CLK_TEST3                      0x077d
#define WCD934X_CLK_SYS_INT_XO_TEST1                       0x077e
#define WCD934X_CLK_SYS_INT_XO_TEST2                       0x077f
#define WCD934X_BOOST_INT_VCOMP_HYST                       0x0787
#define WCD934X_BOOST_INT_VLOOP_FILTER                     0x0788
#define WCD934X_BOOST_INT_CTRL_IDELTA                      0x0789
#define WCD934X_BOOST_INT_CTRL_ILIM_STARTUP                0x078a
#define WCD934X_BOOST_INT_CTRL_MIN_ONTIME                  0x078b
#define WCD934X_BOOST_INT_CTRL_MAX_ONTIME                  0x078c
#define WCD934X_BOOST_INT_CTRL_TIMING                      0x078d
#define WCD934X_BOOST_INT_TMUX_A_D                         0x078e
#define WCD934X_BOOST_INT_SW_DRV_CNTL                      0x078f
#define WCD934X_BOOST_INT_SPARE1                           0x0790
#define WCD934X_BOOST_INT_SPARE2                           0x0791
#define WCD934X_SIDO_NEW_INT_RAMP_STATUS                   0x0796
#define WCD934X_SIDO_NEW_INT_SPARE_1                       0x0797
#define WCD934X_SIDO_NEW_INT_DEBUG_VOUT_SETTING_A          0x0798
#define WCD934X_SIDO_NEW_INT_DEBUG_VOUT_SETTING_D          0x0799
#define WCD934X_SIDO_NEW_INT_RAMP_INC_WAIT                 0x079a
#define WCD934X_SIDO_NEW_INT_DYNAMIC_IPEAK_CTL             0x079b
#define WCD934X_SIDO_NEW_INT_RAMP_IBLEED_CTL               0x079c
#define WCD934X_SIDO_NEW_INT_DEBUG_CPROVR_TEST             0x079d
#define WCD934X_SIDO_NEW_INT_RAMP_CTL_A                    0x079e
#define WCD934X_SIDO_NEW_INT_RAMP_CTL_D                    0x079f
#define WCD934X_SIDO_NEW_INT_RAMP_TIMEOUT_PERIOD           0x07a0
#define WCD934X_SIDO_NEW_INT_DYNAMIC_IPEAK_SETTING1        0x07a1
#define WCD934X_SIDO_NEW_INT_DYNAMIC_IPEAK_SETTING2        0x07a2
#define WCD934X_SIDO_NEW_INT_DYNAMIC_IPEAK_SETTING3        0x07a3
#define WCD934X_SIDO_NEW_INT_HIGH_ACCU_MODE_SEL1           0x07a4
#define WCD934X_SIDO_NEW_INT_HIGH_ACCU_MODE_SEL2           0x07a5
#define WCD934X_MBHC_NEW_INT_SLNQ_HPF                      0x07af
#define WCD934X_MBHC_NEW_INT_SLNQ_REF                      0x07b0
#define WCD934X_MBHC_NEW_INT_SLNQ_COMP                     0x07b1
#define WCD934X_MBHC_NEW_INT_SPARE_2                       0x07b2
#define WCD934X_PAGE10_PAGE_REGISTER                       0x0a00
#define WCD934X_CDC_ANC0_CLK_RESET_CTL                     0x0a01
#define WCD934X_CDC_ANC0_MODE_1_CTL                        0x0a02
#define WCD934X_CDC_ANC0_MODE_2_CTL                        0x0a03
#define WCD934X_CDC_ANC0_FF_SHIFT                          0x0a04
#define WCD934X_CDC_ANC0_FB_SHIFT                          0x0a05
#define WCD934X_CDC_ANC0_LPF_FF_A_CTL                      0x0a06
#define WCD934X_CDC_ANC0_LPF_FF_B_CTL                      0x0a07
#define WCD934X_CDC_ANC0_LPF_FB_CTL                        0x0a08
#define WCD934X_CDC_ANC0_SMLPF_CTL                         0x0a09
#define WCD934X_CDC_ANC0_DCFLT_SHIFT_CTL                   0x0a0a
#define WCD934X_CDC_ANC0_IIR_ADAPT_CTL                     0x0a0b
#define WCD934X_CDC_ANC0_IIR_COEFF_1_CTL                   0x0a0c
#define WCD934X_CDC_ANC0_IIR_COEFF_2_CTL                   0x0a0d
#define WCD934X_CDC_ANC0_FF_A_GAIN_CTL                     0x0a0e
#define WCD934X_CDC_ANC0_FF_B_GAIN_CTL                     0x0a0f
#define WCD934X_CDC_ANC0_FB_GAIN_CTL                       0x0a10
#define WCD934X_CDC_ANC0_RC_COMMON_CTL                     0x0a11
#define WCD934X_CDC_ANC0_FIFO_COMMON_CTL                   0x0a13
#define WCD934X_CDC_ANC0_RC0_STATUS_FMIN_CNTR              0x0a14
#define WCD934X_CDC_ANC0_RC1_STATUS_FMIN_CNTR              0x0a15
#define WCD934X_CDC_ANC0_RC0_STATUS_FMAX_CNTR              0x0a16
#define WCD934X_CDC_ANC0_RC1_STATUS_FMAX_CNTR              0x0a17
#define WCD934X_CDC_ANC0_STATUS_FIFO                       0x0a18
#define WCD934X_CDC_ANC1_CLK_RESET_CTL                     0x0a19
#define WCD934X_CDC_ANC1_MODE_1_CTL                        0x0a1a
#define WCD934X_CDC_ANC1_MODE_2_CTL                        0x0a1b
#define WCD934X_CDC_ANC1_FF_SHIFT                          0x0a1c
#define WCD934X_CDC_ANC1_FB_SHIFT                          0x0a1d
#define WCD934X_CDC_ANC1_LPF_FF_A_CTL                      0x0a1e
#define WCD934X_CDC_ANC1_LPF_FF_B_CTL                      0x0a1f
#define WCD934X_CDC_ANC1_LPF_FB_CTL                        0x0a20
#define WCD934X_CDC_ANC1_SMLPF_CTL                         0x0a21
#define WCD934X_CDC_ANC1_DCFLT_SHIFT_CTL                   0x0a22
#define WCD934X_CDC_ANC1_IIR_ADAPT_CTL                     0x0a23
#define WCD934X_CDC_ANC1_IIR_COEFF_1_CTL                   0x0a24
#define WCD934X_CDC_ANC1_IIR_COEFF_2_CTL                   0x0a25
#define WCD934X_CDC_ANC1_FF_A_GAIN_CTL                     0x0a26
#define WCD934X_CDC_ANC1_FF_B_GAIN_CTL                     0x0a27
#define WCD934X_CDC_ANC1_FB_GAIN_CTL                       0x0a28
#define WCD934X_CDC_ANC1_RC_COMMON_CTL                     0x0a29
#define WCD934X_CDC_ANC1_FIFO_COMMON_CTL                   0x0a2b
#define WCD934X_CDC_ANC1_RC0_STATUS_FMIN_CNTR              0x0a2c
#define WCD934X_CDC_ANC1_RC1_STATUS_FMIN_CNTR              0x0a2d
#define WCD934X_CDC_ANC1_RC0_STATUS_FMAX_CNTR              0x0a2e
#define WCD934X_CDC_ANC1_RC1_STATUS_FMAX_CNTR              0x0a2f
#define WCD934X_CDC_ANC1_STATUS_FIFO                       0x0a30
#define WCD934X_CDC_TX0_TX_PATH_CTL                        0x0a31
#define WCD934X_CDC_TX0_TX_PATH_CFG0                       0x0a32
#define WCD934X_CDC_TX0_TX_PATH_CFG1                       0x0a33
#define WCD934X_CDC_TX0_TX_VOL_CTL                         0x0a34
#define WCD934X_CDC_TX0_TX_PATH_192_CTL                    0x0a35
#define WCD934X_CDC_TX0_TX_PATH_192_CFG                    0x0a36
#define WCD934X_CDC_TX0_TX_PATH_SEC0                       0x0a37
#define WCD934X_CDC_TX0_TX_PATH_SEC1                       0x0a38
#define WCD934X_CDC_TX0_TX_PATH_SEC2                       0x0a39
#define WCD934X_CDC_TX0_TX_PATH_SEC3                       0x0a3a
#define WCD934X_CDC_TX0_TX_PATH_SEC4                       0x0a3b
#define WCD934X_CDC_TX0_TX_PATH_SEC5                       0x0a3c
#define WCD934X_CDC_TX0_TX_PATH_SEC6                       0x0a3d
#define WCD934X_CDC_TX0_TX_PATH_SEC7                       0x0a3e
#define WCD934X_CDC_TX1_TX_PATH_CTL                        0x0a41
#define WCD934X_CDC_TX1_TX_PATH_CFG0                       0x0a42
#define WCD934X_CDC_TX1_TX_PATH_CFG1                       0x0a43
#define WCD934X_CDC_TX1_TX_VOL_CTL                         0x0a44
#define WCD934X_CDC_TX1_TX_PATH_192_CTL                    0x0a45
#define WCD934X_CDC_TX1_TX_PATH_192_CFG                    0x0a46
#define WCD934X_CDC_TX1_TX_PATH_SEC0                       0x0a47
#define WCD934X_CDC_TX1_TX_PATH_SEC1                       0x0a48
#define WCD934X_CDC_TX1_TX_PATH_SEC2                       0x0a49
#define WCD934X_CDC_TX1_TX_PATH_SEC3                       0x0a4a
#define WCD934X_CDC_TX1_TX_PATH_SEC4                       0x0a4b
#define WCD934X_CDC_TX1_TX_PATH_SEC5                       0x0a4c
#define WCD934X_CDC_TX1_TX_PATH_SEC6                       0x0a4d
#define WCD934X_CDC_TX2_TX_PATH_CTL                        0x0a51
#define WCD934X_CDC_TX2_TX_PATH_CFG0                       0x0a52
#define WCD934X_CDC_TX2_TX_PATH_CFG1                       0x0a53
#define WCD934X_CDC_TX2_TX_VOL_CTL                         0x0a54
#define WCD934X_CDC_TX2_TX_PATH_192_CTL                    0x0a55
#define WCD934X_CDC_TX2_TX_PATH_192_CFG                    0x0a56
#define WCD934X_CDC_TX2_TX_PATH_SEC0                       0x0a57
#define WCD934X_CDC_TX2_TX_PATH_SEC1                       0x0a58
#define WCD934X_CDC_TX2_TX_PATH_SEC2                       0x0a59
#define WCD934X_CDC_TX2_TX_PATH_SEC3                       0x0a5a
#define WCD934X_CDC_TX2_TX_PATH_SEC4                       0x0a5b
#define WCD934X_CDC_TX2_TX_PATH_SEC5                       0x0a5c
#define WCD934X_CDC_TX2_TX_PATH_SEC6                       0x0a5d
#define WCD934X_CDC_TX3_TX_PATH_CTL                        0x0a61
#define WCD934X_CDC_TX3_TX_PATH_CFG0                       0x0a62
#define WCD934X_CDC_TX3_TX_PATH_CFG1                       0x0a63
#define WCD934X_CDC_TX3_TX_VOL_CTL                         0x0a64
#define WCD934X_CDC_TX3_TX_PATH_192_CTL                    0x0a65
#define WCD934X_CDC_TX3_TX_PATH_192_CFG                    0x0a66
#define WCD934X_CDC_TX3_TX_PATH_SEC0                       0x0a67
#define WCD934X_CDC_TX3_TX_PATH_SEC1                       0x0a68
#define WCD934X_CDC_TX3_TX_PATH_SEC2                       0x0a69
#define WCD934X_CDC_TX3_TX_PATH_SEC3                       0x0a6a
#define WCD934X_CDC_TX3_TX_PATH_SEC4                       0x0a6b
#define WCD934X_CDC_TX3_TX_PATH_SEC5                       0x0a6c
#define WCD934X_CDC_TX3_TX_PATH_SEC6                       0x0a6d
#define WCD934X_CDC_TX4_TX_PATH_CTL                        0x0a71
#define WCD934X_CDC_TX4_TX_PATH_CFG0                       0x0a72
#define WCD934X_CDC_TX4_TX_PATH_CFG1                       0x0a73
#define WCD934X_CDC_TX4_TX_VOL_CTL                         0x0a74
#define WCD934X_CDC_TX4_TX_PATH_192_CTL                    0x0a75
#define WCD934X_CDC_TX4_TX_PATH_192_CFG                    0x0a76
#define WCD934X_CDC_TX4_TX_PATH_SEC0                       0x0a77
#define WCD934X_CDC_TX4_TX_PATH_SEC1                       0x0a78
#define WCD934X_CDC_TX4_TX_PATH_SEC2                       0x0a79
#define WCD934X_CDC_TX4_TX_PATH_SEC3                       0x0a7a
#define WCD934X_CDC_TX4_TX_PATH_SEC4                       0x0a7b
#define WCD934X_CDC_TX4_TX_PATH_SEC5                       0x0a7c
#define WCD934X_CDC_TX4_TX_PATH_SEC6                       0x0a7d
#define WCD934X_CDC_TX5_TX_PATH_CTL                        0x0a81
#define WCD934X_CDC_TX5_TX_PATH_CFG0                       0x0a82
#define WCD934X_CDC_TX5_TX_PATH_CFG1                       0x0a83
#define WCD934X_CDC_TX5_TX_VOL_CTL                         0x0a84
#define WCD934X_CDC_TX5_TX_PATH_192_CTL                    0x0a85
#define WCD934X_CDC_TX5_TX_PATH_192_CFG                    0x0a86
#define WCD934X_CDC_TX5_TX_PATH_SEC0                       0x0a87
#define WCD934X_CDC_TX5_TX_PATH_SEC1                       0x0a88
#define WCD934X_CDC_TX5_TX_PATH_SEC2                       0x0a89
#define WCD934X_CDC_TX5_TX_PATH_SEC3                       0x0a8a
#define WCD934X_CDC_TX5_TX_PATH_SEC4                       0x0a8b
#define WCD934X_CDC_TX5_TX_PATH_SEC5                       0x0a8c
#define WCD934X_CDC_TX5_TX_PATH_SEC6                       0x0a8d
#define WCD934X_CDC_TX6_TX_PATH_CTL                        0x0a91
#define WCD934X_CDC_TX6_TX_PATH_CFG0                       0x0a92
#define WCD934X_CDC_TX6_TX_PATH_CFG1                       0x0a93
#define WCD934X_CDC_TX6_TX_VOL_CTL                         0x0a94
#define WCD934X_CDC_TX6_TX_PATH_192_CTL                    0x0a95
#define WCD934X_CDC_TX6_TX_PATH_192_CFG                    0x0a96
#define WCD934X_CDC_TX6_TX_PATH_SEC0                       0x0a97
#define WCD934X_CDC_TX6_TX_PATH_SEC1                       0x0a98
#define WCD934X_CDC_TX6_TX_PATH_SEC2                       0x0a99
#define WCD934X_CDC_TX6_TX_PATH_SEC3                       0x0a9a
#define WCD934X_CDC_TX6_TX_PATH_SEC4                       0x0a9b
#define WCD934X_CDC_TX6_TX_PATH_SEC5                       0x0a9c
#define WCD934X_CDC_TX6_TX_PATH_SEC6                       0x0a9d
#define WCD934X_CDC_TX7_TX_PATH_CTL                        0x0aa1
#define WCD934X_CDC_TX7_TX_PATH_CFG0                       0x0aa2
#define WCD934X_CDC_TX7_TX_PATH_CFG1                       0x0aa3
#define WCD934X_CDC_TX7_TX_VOL_CTL                         0x0aa4
#define WCD934X_CDC_TX7_TX_PATH_192_CTL                    0x0aa5
#define WCD934X_CDC_TX7_TX_PATH_192_CFG                    0x0aa6
#define WCD934X_CDC_TX7_TX_PATH_SEC0                       0x0aa7
#define WCD934X_CDC_TX7_TX_PATH_SEC1                       0x0aa8
#define WCD934X_CDC_TX7_TX_PATH_SEC2                       0x0aa9
#define WCD934X_CDC_TX7_TX_PATH_SEC3                       0x0aaa
#define WCD934X_CDC_TX7_TX_PATH_SEC4                       0x0aab
#define WCD934X_CDC_TX7_TX_PATH_SEC5                       0x0aac
#define WCD934X_CDC_TX7_TX_PATH_SEC6                       0x0aad
#define WCD934X_CDC_TX8_TX_PATH_CTL                        0x0ab1
#define WCD934X_CDC_TX8_TX_PATH_CFG0                       0x0ab2
#define WCD934X_CDC_TX8_TX_PATH_CFG1                       0x0ab3
#define WCD934X_CDC_TX8_TX_VOL_CTL                         0x0ab4
#define WCD934X_CDC_TX8_TX_PATH_192_CTL                    0x0ab5
#define WCD934X_CDC_TX8_TX_PATH_192_CFG                    0x0ab6
#define WCD934X_CDC_TX8_TX_PATH_SEC0                       0x0ab7
#define WCD934X_CDC_TX8_TX_PATH_SEC1                       0x0ab8
#define WCD934X_CDC_TX8_TX_PATH_SEC2                       0x0ab9
#define WCD934X_CDC_TX8_TX_PATH_SEC3                       0x0aba
#define WCD934X_CDC_TX8_TX_PATH_SEC4                       0x0abb
#define WCD934X_CDC_TX8_TX_PATH_SEC5                       0x0abc
#define WCD934X_CDC_TX8_TX_PATH_SEC6                       0x0abd
#define WCD934X_CDC_TX9_SPKR_PROT_PATH_CTL                 0x0ac2
#define WCD934X_CDC_TX9_SPKR_PROT_PATH_CFG0                0x0ac3
#define WCD934X_CDC_TX10_SPKR_PROT_PATH_CTL                0x0ac6
#define WCD934X_CDC_TX10_SPKR_PROT_PATH_CFG0               0x0ac7
#define WCD934X_CDC_TX11_SPKR_PROT_PATH_CTL                0x0aca
#define WCD934X_CDC_TX11_SPKR_PROT_PATH_CFG0               0x0acb
#define WCD934X_CDC_TX12_SPKR_PROT_PATH_CTL                0x0ace
#define WCD934X_CDC_TX12_SPKR_PROT_PATH_CFG0               0x0acf
#define WCD934X_PAGE11_PAGE_REGISTER                       0x0b00
#define WCD934X_CDC_COMPANDER1_CTL0                        0x0b01
#define WCD934X_CDC_COMPANDER1_CTL1                        0x0b02
#define WCD934X_CDC_COMPANDER1_CTL2                        0x0b03
#define WCD934X_CDC_COMPANDER1_CTL3                        0x0b04
#define WCD934X_CDC_COMPANDER1_CTL4                        0x0b05
#define WCD934X_CDC_COMPANDER1_CTL5                        0x0b06
#define WCD934X_CDC_COMPANDER1_CTL6                        0x0b07
#define WCD934X_CDC_COMPANDER1_CTL7                        0x0b08
#define WCD934X_CDC_COMPANDER2_CTL0                        0x0b09
#define WCD934X_CDC_COMPANDER2_CTL1                        0x0b0a
#define WCD934X_CDC_COMPANDER2_CTL2                        0x0b0b
#define WCD934X_CDC_COMPANDER2_CTL3                        0x0b0c
#define WCD934X_CDC_COMPANDER2_CTL4                        0x0b0d
#define WCD934X_CDC_COMPANDER2_CTL5                        0x0b0e
#define WCD934X_CDC_COMPANDER2_CTL6                        0x0b0f
#define WCD934X_CDC_COMPANDER2_CTL7                        0x0b10
#define WCD934X_CDC_COMPANDER3_CTL0                        0x0b11
#define WCD934X_CDC_COMPANDER3_CTL1                        0x0b12
#define WCD934X_CDC_COMPANDER3_CTL2                        0x0b13
#define WCD934X_CDC_COMPANDER3_CTL3                        0x0b14
#define WCD934X_CDC_COMPANDER3_CTL4                        0x0b15
#define WCD934X_CDC_COMPANDER3_CTL5                        0x0b16
#define WCD934X_CDC_COMPANDER3_CTL6                        0x0b17
#define WCD934X_CDC_COMPANDER3_CTL7                        0x0b18
#define WCD934X_CDC_COMPANDER4_CTL0                        0x0b19
#define WCD934X_CDC_COMPANDER4_CTL1                        0x0b1a
#define WCD934X_CDC_COMPANDER4_CTL2                        0x0b1b
#define WCD934X_CDC_COMPANDER4_CTL3                        0x0b1c
#define WCD934X_CDC_COMPANDER4_CTL4                        0x0b1d
#define WCD934X_CDC_COMPANDER4_CTL5                        0x0b1e
#define WCD934X_CDC_COMPANDER4_CTL6                        0x0b1f
#define WCD934X_CDC_COMPANDER4_CTL7                        0x0b20
#define WCD934X_CDC_COMPANDER7_CTL0                        0x0b31
#define WCD934X_CDC_COMPANDER7_CTL1                        0x0b32
#define WCD934X_CDC_COMPANDER7_CTL2                        0x0b33
#define WCD934X_CDC_COMPANDER7_CTL3                        0x0b34
#define WCD934X_CDC_COMPANDER7_CTL4                        0x0b35
#define WCD934X_CDC_COMPANDER7_CTL5                        0x0b36
#define WCD934X_CDC_COMPANDER7_CTL6                        0x0b37
#define WCD934X_CDC_COMPANDER7_CTL7                        0x0b38
#define WCD934X_CDC_COMPANDER8_CTL0                        0x0b39
#define WCD934X_CDC_COMPANDER8_CTL1                        0x0b3a
#define WCD934X_CDC_COMPANDER8_CTL2                        0x0b3b
#define WCD934X_CDC_COMPANDER8_CTL3                        0x0b3c
#define WCD934X_CDC_COMPANDER8_CTL4                        0x0b3d
#define WCD934X_CDC_COMPANDER8_CTL5                        0x0b3e
#define WCD934X_CDC_COMPANDER8_CTL6                        0x0b3f
#define WCD934X_CDC_COMPANDER8_CTL7                        0x0b40
#define WCD934X_CDC_RX0_RX_PATH_CTL                        0x0b41
#define WCD934X_CDC_RX0_RX_PATH_CFG0                       0x0b42
#define WCD934X_CDC_RX0_RX_PATH_CFG1                       0x0b43
#define WCD934X_CDC_RX0_RX_PATH_CFG2                       0x0b44
#define WCD934X_CDC_RX0_RX_VOL_CTL                         0x0b45
#define WCD934X_CDC_RX0_RX_PATH_MIX_CTL                    0x0b46
#define WCD934X_CDC_RX0_RX_PATH_MIX_CFG                    0x0b47
#define WCD934X_CDC_RX0_RX_VOL_MIX_CTL                     0x0b48
#define WCD934X_CDC_RX0_RX_PATH_SEC0                       0x0b49
#define WCD934X_CDC_RX0_RX_PATH_SEC1                       0x0b4a
#define WCD934X_CDC_RX0_RX_PATH_SEC2                       0x0b4b
#define WCD934X_CDC_RX0_RX_PATH_SEC3                       0x0b4c
#define WCD934X_CDC_RX0_RX_PATH_SEC5                       0x0b4e
#define WCD934X_CDC_RX0_RX_PATH_SEC6                       0x0b4f
#define WCD934X_CDC_RX0_RX_PATH_SEC7                       0x0b50
#define WCD934X_CDC_RX0_RX_PATH_MIX_SEC0                   0x0b51
#define WCD934X_CDC_RX0_RX_PATH_MIX_SEC1                   0x0b52
#define WCD934X_CDC_RX0_RX_PATH_DSMDEM_CTL                 0x0b53
#define WCD934X_CDC_RX1_RX_PATH_CTL                        0x0b55
#define WCD934X_CDC_RX1_RX_PATH_CFG0                       0x0b56
#define WCD934X_CDC_RX1_RX_PATH_CFG1                       0x0b57
#define WCD934X_CDC_RX1_RX_PATH_CFG2                       0x0b58
#define WCD934X_CDC_RX1_RX_VOL_CTL                         0x0b59
#define WCD934X_CDC_RX1_RX_PATH_MIX_CTL                    0x0b5a
#define WCD934X_CDC_RX1_RX_PATH_MIX_CFG                    0x0b5b
#define WCD934X_CDC_RX1_RX_VOL_MIX_CTL                     0x0b5c
#define WCD934X_CDC_RX1_RX_PATH_SEC0                       0x0b5d
#define WCD934X_CDC_RX1_RX_PATH_SEC1                       0x0b5e
#define WCD934X_CDC_RX1_RX_PATH_SEC2                       0x0b5f
#define WCD934X_CDC_RX1_RX_PATH_SEC3                       0x0b60
#define WCD934X_CDC_RX1_RX_PATH_SEC4                       0x0b61
#define WCD934X_CDC_RX1_RX_PATH_SEC5                       0x0b62
#define WCD934X_CDC_RX1_RX_PATH_SEC6                       0x0b63
#define WCD934X_CDC_RX1_RX_PATH_SEC7                       0x0b64
#define WCD934X_CDC_RX1_RX_PATH_MIX_SEC0                   0x0b65
#define WCD934X_CDC_RX1_RX_PATH_MIX_SEC1                   0x0b66
#define WCD934X_CDC_RX1_RX_PATH_DSMDEM_CTL                 0x0b67
#define WCD934X_CDC_RX2_RX_PATH_CTL                        0x0b69
#define WCD934X_CDC_RX2_RX_PATH_CFG0                       0x0b6a
#define WCD934X_CDC_RX2_RX_PATH_CFG1                       0x0b6b
#define WCD934X_CDC_RX2_RX_PATH_CFG2                       0x0b6c
#define WCD934X_CDC_RX2_RX_VOL_CTL                         0x0b6d
#define WCD934X_CDC_RX2_RX_PATH_MIX_CTL                    0x0b6e
#define WCD934X_CDC_RX2_RX_PATH_MIX_CFG                    0x0b6f
#define WCD934X_CDC_RX2_RX_VOL_MIX_CTL                     0x0b70
#define WCD934X_CDC_RX2_RX_PATH_SEC0                       0x0b71
#define WCD934X_CDC_RX2_RX_PATH_SEC1                       0x0b72
#define WCD934X_CDC_RX2_RX_PATH_SEC2                       0x0b73
#define WCD934X_CDC_RX2_RX_PATH_SEC3                       0x0b74
#define WCD934X_CDC_RX2_RX_PATH_SEC4                       0x0b75
#define WCD934X_CDC_RX2_RX_PATH_SEC5                       0x0b76
#define WCD934X_CDC_RX2_RX_PATH_SEC6                       0x0b77
#define WCD934X_CDC_RX2_RX_PATH_SEC7                       0x0b78
#define WCD934X_CDC_RX2_RX_PATH_MIX_SEC0                   0x0b79
#define WCD934X_CDC_RX2_RX_PATH_MIX_SEC1                   0x0b7a
#define WCD934X_CDC_RX2_RX_PATH_DSMDEM_CTL                 0x0b7b
#define WCD934X_CDC_RX3_RX_PATH_CTL                        0x0b7d
#define WCD934X_CDC_RX3_RX_PATH_CFG0                       0x0b7e
#define WCD934X_CDC_RX3_RX_PATH_CFG1                       0x0b7f
#define WCD934X_CDC_RX3_RX_PATH_CFG2                       0x0b80
#define WCD934X_CDC_RX3_RX_VOL_CTL                         0x0b81
#define WCD934X_CDC_RX3_RX_PATH_MIX_CTL                    0x0b82
#define WCD934X_CDC_RX3_RX_PATH_MIX_CFG                    0x0b83
#define WCD934X_CDC_RX3_RX_VOL_MIX_CTL                     0x0b84
#define WCD934X_CDC_RX3_RX_PATH_SEC0                       0x0b85
#define WCD934X_CDC_RX3_RX_PATH_SEC1                       0x0b86
#define WCD934X_CDC_RX3_RX_PATH_SEC2                       0x0b87
#define WCD934X_CDC_RX3_RX_PATH_SEC3                       0x0b88
#define WCD934X_CDC_RX3_RX_PATH_SEC5                       0x0b8a
#define WCD934X_CDC_RX3_RX_PATH_SEC6                       0x0b8b
#define WCD934X_CDC_RX3_RX_PATH_SEC7                       0x0b8c
#define WCD934X_CDC_RX3_RX_PATH_MIX_SEC0                   0x0b8d
#define WCD934X_CDC_RX3_RX_PATH_MIX_SEC1                   0x0b8e
#define WCD934X_CDC_RX3_RX_PATH_DSMDEM_CTL                 0x0b8f
#define WCD934X_CDC_RX4_RX_PATH_CTL                        0x0b91
#define WCD934X_CDC_RX4_RX_PATH_CFG0                       0x0b92
#define WCD934X_CDC_RX4_RX_PATH_CFG1                       0x0b93
#define WCD934X_CDC_RX4_RX_PATH_CFG2                       0x0b94
#define WCD934X_CDC_RX4_RX_VOL_CTL                         0x0b95
#define WCD934X_CDC_RX4_RX_PATH_MIX_CTL                    0x0b96
#define WCD934X_CDC_RX4_RX_PATH_MIX_CFG                    0x0b97
#define WCD934X_CDC_RX4_RX_VOL_MIX_CTL                     0x0b98
#define WCD934X_CDC_RX4_RX_PATH_SEC0                       0x0b99
#define WCD934X_CDC_RX4_RX_PATH_SEC1                       0x0b9a
#define WCD934X_CDC_RX4_RX_PATH_SEC2                       0x0b9b
#define WCD934X_CDC_RX4_RX_PATH_SEC3                       0x0b9c
#define WCD934X_CDC_RX4_RX_PATH_SEC5                       0x0b9e
#define WCD934X_CDC_RX4_RX_PATH_SEC6                       0x0b9f
#define WCD934X_CDC_RX4_RX_PATH_SEC7                       0x0ba0
#define WCD934X_CDC_RX4_RX_PATH_MIX_SEC0                   0x0ba1
#define WCD934X_CDC_RX4_RX_PATH_MIX_SEC1                   0x0ba2
#define WCD934X_CDC_RX4_RX_PATH_DSMDEM_CTL                 0x0ba3
#define WCD934X_CDC_RX7_RX_PATH_CTL                        0x0bcd
#define WCD934X_CDC_RX7_RX_PATH_CFG0                       0x0bce
#define WCD934X_CDC_RX7_RX_PATH_CFG1                       0x0bcf
#define WCD934X_CDC_RX7_RX_PATH_CFG2                       0x0bd0
#define WCD934X_CDC_RX7_RX_VOL_CTL                         0x0bd1
#define WCD934X_CDC_RX7_RX_PATH_MIX_CTL                    0x0bd2
#define WCD934X_CDC_RX7_RX_PATH_MIX_CFG                    0x0bd3
#define WCD934X_CDC_RX7_RX_VOL_MIX_CTL                     0x0bd4
#define WCD934X_CDC_RX7_RX_PATH_SEC0                       0x0bd5
#define WCD934X_CDC_RX7_RX_PATH_SEC1                       0x0bd6
#define WCD934X_CDC_RX7_RX_PATH_SEC2                       0x0bd7
#define WCD934X_CDC_RX7_RX_PATH_SEC3                       0x0bd8
#define WCD934X_CDC_RX7_RX_PATH_SEC5                       0x0bda
#define WCD934X_CDC_RX7_RX_PATH_SEC6                       0x0bdb
#define WCD934X_CDC_RX7_RX_PATH_SEC7                       0x0bdc
#define WCD934X_CDC_RX7_RX_PATH_MIX_SEC0                   0x0bdd
#define WCD934X_CDC_RX7_RX_PATH_MIX_SEC1                   0x0bde
#define WCD934X_CDC_RX7_RX_PATH_DSMDEM_CTL                 0x0bdf
#define WCD934X_CDC_RX8_RX_PATH_CTL                        0x0be1
#define WCD934X_CDC_RX8_RX_PATH_CFG0                       0x0be2
#define WCD934X_CDC_RX8_RX_PATH_CFG1                       0x0be3
#define WCD934X_CDC_RX8_RX_PATH_CFG2                       0x0be4
#define WCD934X_CDC_RX8_RX_VOL_CTL                         0x0be5
#define WCD934X_CDC_RX8_RX_PATH_MIX_CTL                    0x0be6
#define WCD934X_CDC_RX8_RX_PATH_MIX_CFG                    0x0be7
#define WCD934X_CDC_RX8_RX_VOL_MIX_CTL                     0x0be8
#define WCD934X_CDC_RX8_RX_PATH_SEC0                       0x0be9
#define WCD934X_CDC_RX8_RX_PATH_SEC1                       0x0bea
#define WCD934X_CDC_RX8_RX_PATH_SEC2                       0x0beb
#define WCD934X_CDC_RX8_RX_PATH_SEC3                       0x0bec
#define WCD934X_CDC_RX8_RX_PATH_SEC5                       0x0bee
#define WCD934X_CDC_RX8_RX_PATH_SEC6                       0x0bef
#define WCD934X_CDC_RX8_RX_PATH_SEC7                       0x0bf0
#define WCD934X_CDC_RX8_RX_PATH_MIX_SEC0                   0x0bf1
#define WCD934X_CDC_RX8_RX_PATH_MIX_SEC1                   0x0bf2
#define WCD934X_CDC_RX8_RX_PATH_DSMDEM_CTL                 0x0bf3
#define WCD934X_PAGE12_PAGE_REGISTER                       0x0c00
#define WCD934X_CDC_CLSH_CRC                               0x0c01
#define WCD934X_CDC_CLSH_DLY_CTRL                          0x0c02
#define WCD934X_CDC_CLSH_DECAY_CTRL                        0x0c03
#define WCD934X_CDC_CLSH_HPH_V_PA                          0x0c04
#define WCD934X_CDC_CLSH_EAR_V_PA                          0x0c05
#define WCD934X_CDC_CLSH_HPH_V_HD                          0x0c06
#define WCD934X_CDC_CLSH_EAR_V_HD                          0x0c07
#define WCD934X_CDC_CLSH_K1_MSB                            0x0c08
#define WCD934X_CDC_CLSH_K1_LSB                            0x0c09
#define WCD934X_CDC_CLSH_K2_MSB                            0x0c0a
#define WCD934X_CDC_CLSH_K2_LSB                            0x0c0b
#define WCD934X_CDC_CLSH_IDLE_CTRL                         0x0c0c
#define WCD934X_CDC_CLSH_IDLE_HPH                          0x0c0d
#define WCD934X_CDC_CLSH_IDLE_EAR                          0x0c0e
#define WCD934X_CDC_CLSH_TEST0                             0x0c0f
#define WCD934X_CDC_CLSH_TEST1                             0x0c10
#define WCD934X_CDC_CLSH_OVR_VREF                          0x0c11
#define WCD934X_CDC_BOOST0_BOOST_PATH_CTL                  0x0c19
#define WCD934X_CDC_BOOST0_BOOST_CTL                       0x0c1a
#define WCD934X_CDC_BOOST0_BOOST_CFG1                      0x0c1b
#define WCD934X_CDC_BOOST0_BOOST_CFG2                      0x0c1c
#define WCD934X_CDC_BOOST1_BOOST_PATH_CTL                  0x0c21
#define WCD934X_CDC_BOOST1_BOOST_CTL                       0x0c22
#define WCD934X_CDC_BOOST1_BOOST_CFG1                      0x0c23
#define WCD934X_CDC_BOOST1_BOOST_CFG2                      0x0c24
#define WCD934X_CDC_VBAT_VBAT_PATH_CTL                     0x0c3d
#define WCD934X_CDC_VBAT_VBAT_CFG                          0x0c3e
#define WCD934X_CDC_VBAT_VBAT_ADC_CAL1                     0x0c3f
#define WCD934X_CDC_VBAT_VBAT_ADC_CAL2                     0x0c40
#define WCD934X_CDC_VBAT_VBAT_ADC_CAL3                     0x0c41
#define WCD934X_CDC_VBAT_VBAT_PK_EST1                      0x0c42
#define WCD934X_CDC_VBAT_VBAT_PK_EST2                      0x0c43
#define WCD934X_CDC_VBAT_VBAT_PK_EST3                      0x0c44
#define WCD934X_CDC_VBAT_VBAT_RF_PROC1                     0x0c45
#define WCD934X_CDC_VBAT_VBAT_RF_PROC2                     0x0c46
#define WCD934X_CDC_VBAT_VBAT_TAC1                         0x0c47
#define WCD934X_CDC_VBAT_VBAT_TAC2                         0x0c48
#define WCD934X_CDC_VBAT_VBAT_TAC3                         0x0c49
#define WCD934X_CDC_VBAT_VBAT_TAC4                         0x0c4a
#define WCD934X_CDC_VBAT_VBAT_GAIN_UPD1                    0x0c4b
#define WCD934X_CDC_VBAT_VBAT_GAIN_UPD2                    0x0c4c
#define WCD934X_CDC_VBAT_VBAT_GAIN_UPD3                    0x0c4d
#define WCD934X_CDC_VBAT_VBAT_GAIN_UPD4                    0x0c4e
#define WCD934X_CDC_VBAT_VBAT_DEBUG1                       0x0c4f
#define WCD934X_CDC_VBAT_VBAT_GAIN_UPD_MON                 0x0c50
#define WCD934X_CDC_VBAT_VBAT_GAIN_MON_VAL                 0x0c51
#define WCD934X_CDC_VBAT_VBAT_BAN                          0x0c52
#define WCD934X_MIXING_ASRC0_CLK_RST_CTL                   0x0c55
#define WCD934X_MIXING_ASRC0_CTL0                          0x0c56
#define WCD934X_MIXING_ASRC0_CTL1                          0x0c57
#define WCD934X_MIXING_ASRC0_FIFO_CTL                      0x0c58
#define WCD934X_MIXING_ASRC0_STATUS_FMIN_CNTR_LSB          0x0c59
#define WCD934X_MIXING_ASRC0_STATUS_FMIN_CNTR_MSB          0x0c5a
#define WCD934X_MIXING_ASRC0_STATUS_FMAX_CNTR_LSB          0x0c5b
#define WCD934X_MIXING_ASRC0_STATUS_FMAX_CNTR_MSB          0x0c5c
#define WCD934X_MIXING_ASRC0_STATUS_FIFO                   0x0c5d
#define WCD934X_MIXING_ASRC1_CLK_RST_CTL                   0x0c61
#define WCD934X_MIXING_ASRC1_CTL0                          0x0c62
#define WCD934X_MIXING_ASRC1_CTL1                          0x0c63
#define WCD934X_MIXING_ASRC1_FIFO_CTL                      0x0c64
#define WCD934X_MIXING_ASRC1_STATUS_FMIN_CNTR_LSB          0x0c65
#define WCD934X_MIXING_ASRC1_STATUS_FMIN_CNTR_MSB          0x0c66
#define WCD934X_MIXING_ASRC1_STATUS_FMAX_CNTR_LSB          0x0c67
#define WCD934X_MIXING_ASRC1_STATUS_FMAX_CNTR_MSB          0x0c68
#define WCD934X_MIXING_ASRC1_STATUS_FIFO                   0x0c69
#define WCD934X_MIXING_ASRC2_CLK_RST_CTL                   0x0c6d
#define WCD934X_MIXING_ASRC2_CTL0                          0x0c6e
#define WCD934X_MIXING_ASRC2_CTL1                          0x0c6f
#define WCD934X_MIXING_ASRC2_FIFO_CTL                      0x0c70
#define WCD934X_MIXING_ASRC2_STATUS_FMIN_CNTR_LSB          0x0c71
#define WCD934X_MIXING_ASRC2_STATUS_FMIN_CNTR_MSB          0x0c72
#define WCD934X_MIXING_ASRC2_STATUS_FMAX_CNTR_LSB          0x0c73
#define WCD934X_MIXING_ASRC2_STATUS_FMAX_CNTR_MSB          0x0c74
#define WCD934X_MIXING_ASRC2_STATUS_FIFO                   0x0c75
#define WCD934X_MIXING_ASRC3_CLK_RST_CTL                   0x0c79
#define WCD934X_MIXING_ASRC3_CTL0                          0x0c7a
#define WCD934X_MIXING_ASRC3_CTL1                          0x0c7b
#define WCD934X_MIXING_ASRC3_FIFO_CTL                      0x0c7c
#define WCD934X_MIXING_ASRC3_STATUS_FMIN_CNTR_LSB          0x0c7d
#define WCD934X_MIXING_ASRC3_STATUS_FMIN_CNTR_MSB          0x0c7e
#define WCD934X_MIXING_ASRC3_STATUS_FMAX_CNTR_LSB          0x0c7f
#define WCD934X_MIXING_ASRC3_STATUS_FMAX_CNTR_MSB          0x0c80
#define WCD934X_MIXING_ASRC3_STATUS_FIFO                   0x0c81
#define WCD934X_SWR_AHB_BRIDGE_WR_DATA_0                   0x0c85
#define WCD934X_SWR_AHB_BRIDGE_WR_DATA_1                   0x0c86
#define WCD934X_SWR_AHB_BRIDGE_WR_DATA_2                   0x0c87
#define WCD934X_SWR_AHB_BRIDGE_WR_DATA_3                   0x0c88
#define WCD934X_SWR_AHB_BRIDGE_WR_ADDR_0                   0x0c89
#define WCD934X_SWR_AHB_BRIDGE_WR_ADDR_1                   0x0c8a
#define WCD934X_SWR_AHB_BRIDGE_WR_ADDR_2                   0x0c8b
#define WCD934X_SWR_AHB_BRIDGE_WR_ADDR_3                   0x0c8c
#define WCD934X_SWR_AHB_BRIDGE_RD_ADDR_0                   0x0c8d
#define WCD934X_SWR_AHB_BRIDGE_RD_ADDR_1                   0x0c8e
#define WCD934X_SWR_AHB_BRIDGE_RD_ADDR_2                   0x0c8f
#define WCD934X_SWR_AHB_BRIDGE_RD_ADDR_3                   0x0c90
#define WCD934X_SWR_AHB_BRIDGE_RD_DATA_0                   0x0c91
#define WCD934X_SWR_AHB_BRIDGE_RD_DATA_1                   0x0c92
#define WCD934X_SWR_AHB_BRIDGE_RD_DATA_2                   0x0c93
#define WCD934X_SWR_AHB_BRIDGE_RD_DATA_3                   0x0c94
#define WCD934X_SWR_AHB_BRIDGE_ACCESS_CFG                  0x0c95
#define WCD934X_SWR_AHB_BRIDGE_ACCESS_STATUS               0x0c96
#define WCD934X_CDC_SIDETONE_SRC0_ST_SRC_PATH_CTL          0x0cb5
#define WCD934X_CDC_SIDETONE_SRC0_ST_SRC_PATH_CFG1         0x0cb6
#define WCD934X_CDC_SIDETONE_SRC1_ST_SRC_PATH_CTL          0x0cb9
#define WCD934X_CDC_SIDETONE_SRC1_ST_SRC_PATH_CFG1         0x0cba
#define WCD934X_SIDETONE_ASRC0_CLK_RST_CTL                 0x0cbd
#define WCD934X_SIDETONE_ASRC0_CTL0                        0x0cbe
#define WCD934X_SIDETONE_ASRC0_CTL1                        0x0cbf
#define WCD934X_SIDETONE_ASRC0_FIFO_CTL                    0x0cc0
#define WCD934X_SIDETONE_ASRC0_STATUS_FMIN_CNTR_LSB        0x0cc1
#define WCD934X_SIDETONE_ASRC0_STATUS_FMIN_CNTR_MSB        0x0cc2
#define WCD934X_SIDETONE_ASRC0_STATUS_FMAX_CNTR_LSB        0x0cc3
#define WCD934X_SIDETONE_ASRC0_STATUS_FMAX_CNTR_MSB        0x0cc4
#define WCD934X_SIDETONE_ASRC0_STATUS_FIFO                 0x0cc5
#define WCD934X_SIDETONE_ASRC1_CLK_RST_CTL                 0x0cc9
#define WCD934X_SIDETONE_ASRC1_CTL0                        0x0cca
#define WCD934X_SIDETONE_ASRC1_CTL1                        0x0ccb
#define WCD934X_SIDETONE_ASRC1_FIFO_CTL                    0x0ccc
#define WCD934X_SIDETONE_ASRC1_STATUS_FMIN_CNTR_LSB        0x0ccd
#define WCD934X_SIDETONE_ASRC1_STATUS_FMIN_CNTR_MSB        0x0cce
#define WCD934X_SIDETONE_ASRC1_STATUS_FMAX_CNTR_LSB        0x0ccf
#define WCD934X_SIDETONE_ASRC1_STATUS_FMAX_CNTR_MSB        0x0cd0
#define WCD934X_SIDETONE_ASRC1_STATUS_FIFO                 0x0cd1
#define WCD934X_EC_REF_HQ0_EC_REF_HQ_PATH_CTL              0x0cd5
#define WCD934X_EC_REF_HQ0_EC_REF_HQ_CFG0                  0x0cd6
#define WCD934X_EC_REF_HQ1_EC_REF_HQ_PATH_CTL              0x0cdd
#define WCD934X_EC_REF_HQ1_EC_REF_HQ_CFG0                  0x0cde
#define WCD934X_EC_ASRC0_CLK_RST_CTL                       0x0ce5
#define WCD934X_EC_ASRC0_CTL0                              0x0ce6
#define WCD934X_EC_ASRC0_CTL1                              0x0ce7
#define WCD934X_EC_ASRC0_FIFO_CTL                          0x0ce8
#define WCD934X_EC_ASRC0_STATUS_FMIN_CNTR_LSB              0x0ce9
#define WCD934X_EC_ASRC0_STATUS_FMIN_CNTR_MSB              0x0cea
#define WCD934X_EC_ASRC0_STATUS_FMAX_CNTR_LSB              0x0ceb
#define WCD934X_EC_ASRC0_STATUS_FMAX_CNTR_MSB              0x0cec
#define WCD934X_EC_ASRC0_STATUS_FIFO                       0x0ced
#define WCD934X_EC_ASRC1_CLK_RST_CTL                       0x0cf1
#define WCD934X_EC_ASRC1_CTL0                              0x0cf2
#define WCD934X_EC_ASRC1_CTL1                              0x0cf3
#define WCD934X_EC_ASRC1_FIFO_CTL                          0x0cf4
#define WCD934X_EC_ASRC1_STATUS_FMIN_CNTR_LSB              0x0cf5
#define WCD934X_EC_ASRC1_STATUS_FMIN_CNTR_MSB              0x0cf6
#define WCD934X_EC_ASRC1_STATUS_FMAX_CNTR_LSB              0x0cf7
#define WCD934X_EC_ASRC1_STATUS_FMAX_CNTR_MSB              0x0cf8
#define WCD934X_EC_ASRC1_STATUS_FIFO                       0x0cf9
#define WCD934X_PAGE13_PAGE_REGISTER                       0x0d00
#define WCD934X_CDC_RX_INP_MUX_RX_INT0_CFG0                0x0d01
#define WCD934X_CDC_RX_INP_MUX_RX_INT0_CFG1                0x0d02
#define WCD934X_CDC_RX_INP_MUX_RX_INT1_CFG0                0x0d03
#define WCD934X_CDC_RX_INP_MUX_RX_INT1_CFG1                0x0d04
#define WCD934X_CDC_RX_INP_MUX_RX_INT2_CFG0                0x0d05
#define WCD934X_CDC_RX_INP_MUX_RX_INT2_CFG1                0x0d06
#define WCD934X_CDC_RX_INP_MUX_RX_INT3_CFG0                0x0d07
#define WCD934X_CDC_RX_INP_MUX_RX_INT3_CFG1                0x0d08
#define WCD934X_CDC_RX_INP_MUX_RX_INT4_CFG0                0x0d09
#define WCD934X_CDC_RX_INP_MUX_RX_INT4_CFG1                0x0d0a
#define WCD934X_CDC_RX_INP_MUX_RX_INT7_CFG0                0x0d0f
#define WCD934X_CDC_RX_INP_MUX_RX_INT7_CFG1                0x0d10
#define WCD934X_CDC_RX_INP_MUX_RX_INT8_CFG0                0x0d11
#define WCD934X_CDC_RX_INP_MUX_RX_INT8_CFG1                0x0d12
#define WCD934X_CDC_RX_INP_MUX_RX_MIX_CFG0                 0x0d13
#define WCD934X_CDC_RX_INP_MUX_RX_MIX_CFG1                 0x0d14
#define WCD934X_CDC_RX_INP_MUX_RX_MIX_CFG2                 0x0d15
#define WCD934X_CDC_RX_INP_MUX_RX_MIX_CFG3                 0x0d16
#define WCD934X_CDC_RX_INP_MUX_RX_MIX_CFG4                 0x0d17
#define WCD934X_CDC_RX_INP_MUX_SIDETONE_SRC_CFG0           0x0d18
#define WCD934X_CDC_RX_INP_MUX_SIDETONE_SRC_CFG1           0x0d19
#define WCD934X_CDC_RX_INP_MUX_ANC_CFG0                    0x0d1a
#define WCD934X_CDC_RX_INP_MUX_SPLINE_ASRC_CFG0            0x0d1b
#define WCD934X_CDC_RX_INP_MUX_EC_REF_HQ_CFG0              0x0d1c
#define WCD934X_CDC_TX_INP_MUX_ADC_MUX0_CFG0               0x0d1d
#define WCD934X_CDC_TX_INP_MUX_ADC_MUX0_CFG1               0x0d1e
#define WCD934X_CDC_TX_INP_MUX_ADC_MUX1_CFG0               0x0d1f
#define WCD934X_CDC_TX_INP_MUX_ADC_MUX1_CFG1               0x0d20
#define WCD934X_CDC_TX_INP_MUX_ADC_MUX2_CFG0               0x0d21
#define WCD934X_CDC_TX_INP_MUX_ADC_MUX2_CFG1               0x0d22
#define WCD934X_CDC_TX_INP_MUX_ADC_MUX3_CFG0               0x0d23
#define WCD934X_CDC_TX_INP_MUX_ADC_MUX3_CFG1               0x0d25
#define WCD934X_CDC_TX_INP_MUX_ADC_MUX4_CFG0               0x0d26
#define WCD934X_CDC_TX_INP_MUX_ADC_MUX5_CFG0               0x0d27
#define WCD934X_CDC_TX_INP_MUX_ADC_MUX6_CFG0               0x0d28
#define WCD934X_CDC_TX_INP_MUX_ADC_MUX7_CFG0               0x0d29
#define WCD934X_CDC_TX_INP_MUX_ADC_MUX8_CFG0               0x0d2a
#define WCD934X_CDC_TX_INP_MUX_ADC_MUX10_CFG0              0x0d2b
#define WCD934X_CDC_TX_INP_MUX_ADC_MUX11_CFG0              0x0d2c
#define WCD934X_CDC_TX_INP_MUX_ADC_MUX12_CFG0              0x0d2d
#define WCD934X_CDC_TX_INP_MUX_ADC_MUX13_CFG0              0x0d2e
#define WCD934X_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG0     0x0d31
#define WCD934X_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG1     0x0d32
#define WCD934X_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG2     0x0d33
#define WCD934X_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG3     0x0d34
#define WCD934X_CDC_SIDETONE_IIR_INP_MUX_IIR1_MIX_CFG0     0x0d35
#define WCD934X_CDC_SIDETONE_IIR_INP_MUX_IIR1_MIX_CFG1     0x0d36
#define WCD934X_CDC_SIDETONE_IIR_INP_MUX_IIR1_MIX_CFG2     0x0d37
#define WCD934X_CDC_SIDETONE_IIR_INP_MUX_IIR1_MIX_CFG3     0x0d38
#define WCD934X_CDC_IF_ROUTER_TX_MUX_CFG0                  0x0d3a
#define WCD934X_CDC_IF_ROUTER_TX_MUX_CFG1                  0x0d3b
#define WCD934X_CDC_IF_ROUTER_TX_MUX_CFG2                  0x0d3c
#define WCD934X_CDC_IF_ROUTER_TX_MUX_CFG3                  0x0d3d
#define WCD934X_CDC_CLK_RST_CTRL_MCLK_CONTROL              0x0d41
#define WCD934X_CDC_CLK_RST_CTRL_FS_CNT_CONTROL            0x0d42
#define WCD934X_CDC_CLK_RST_CTRL_SWR_CONTROL               0x0d43
#define WCD934X_CDC_CLK_RST_CTRL_DSD_CONTROL               0x0d44
#define WCD934X_CDC_CLK_RST_CTRL_ASRC_SHARE_CONTROL        0x0d45
#define WCD934X_CDC_CLK_RST_CTRL_GFM_CONTROL               0x0d46
#define WCD934X_CDC_PROX_DETECT_PROX_CTL                   0x0d49
#define WCD934X_CDC_PROX_DETECT_PROX_POLL_PERIOD0          0x0d4a
#define WCD934X_CDC_PROX_DETECT_PROX_POLL_PERIOD1          0x0d4b
#define WCD934X_CDC_PROX_DETECT_PROX_SIG_PATTERN_LSB       0x0d4c
#define WCD934X_CDC_PROX_DETECT_PROX_SIG_PATTERN_MSB       0x0d4d
#define WCD934X_CDC_PROX_DETECT_PROX_STATUS                0x0d4e
#define WCD934X_CDC_PROX_DETECT_PROX_TEST_CTRL             0x0d4f
#define WCD934X_CDC_PROX_DETECT_PROX_TEST_BUFF_LSB         0x0d50
#define WCD934X_CDC_PROX_DETECT_PROX_TEST_BUFF_MSB         0x0d51
#define WCD934X_CDC_PROX_DETECT_PROX_TEST_BUFF_LSB_RD      0x0d52
#define WCD934X_CDC_PROX_DETECT_PROX_TEST_BUFF_MSB_RD      0x0d53
#define WCD934X_CDC_PROX_DETECT_PROX_CTL_REPEAT_PAT        0x0d54
#define WCD934X_CDC_SIDETONE_IIR0_IIR_PATH_CTL             0x0d55
#define WCD934X_CDC_SIDETONE_IIR0_IIR_GAIN_B1_CTL          0x0d56
#define WCD934X_CDC_SIDETONE_IIR0_IIR_GAIN_B2_CTL          0x0d57
#define WCD934X_CDC_SIDETONE_IIR0_IIR_GAIN_B3_CTL          0x0d58
#define WCD934X_CDC_SIDETONE_IIR0_IIR_GAIN_B4_CTL          0x0d59
#define WCD934X_CDC_SIDETONE_IIR0_IIR_GAIN_B5_CTL          0x0d5a
#define WCD934X_CDC_SIDETONE_IIR0_IIR_GAIN_B6_CTL          0x0d5b
#define WCD934X_CDC_SIDETONE_IIR0_IIR_GAIN_B7_CTL          0x0d5c
#define WCD934X_CDC_SIDETONE_IIR0_IIR_GAIN_B8_CTL          0x0d5d
#define WCD934X_CDC_SIDETONE_IIR0_IIR_CTL                  0x0d5e
#define WCD934X_CDC_SIDETONE_IIR0_IIR_GAIN_TIMER_CTL       0x0d5f
#define WCD934X_CDC_SIDETONE_IIR0_IIR_COEF_B1_CTL          0x0d60
#define WCD934X_CDC_SIDETONE_IIR0_IIR_COEF_B2_CTL          0x0d61
#define WCD934X_CDC_SIDETONE_IIR1_IIR_PATH_CTL             0x0d65
#define WCD934X_CDC_SIDETONE_IIR1_IIR_GAIN_B1_CTL          0x0d66
#define WCD934X_CDC_SIDETONE_IIR1_IIR_GAIN_B2_CTL          0x0d67
#define WCD934X_CDC_SIDETONE_IIR1_IIR_GAIN_B3_CTL          0x0d68
#define WCD934X_CDC_SIDETONE_IIR1_IIR_GAIN_B4_CTL          0x0d69
#define WCD934X_CDC_SIDETONE_IIR1_IIR_GAIN_B5_CTL          0x0d6a
#define WCD934X_CDC_SIDETONE_IIR1_IIR_GAIN_B6_CTL          0x0d6b
#define WCD934X_CDC_SIDETONE_IIR1_IIR_GAIN_B7_CTL          0x0d6c
#define WCD934X_CDC_SIDETONE_IIR1_IIR_GAIN_B8_CTL          0x0d6d
#define WCD934X_CDC_SIDETONE_IIR1_IIR_CTL                  0x0d6e
#define WCD934X_CDC_SIDETONE_IIR1_IIR_GAIN_TIMER_CTL       0x0d6f
#define WCD934X_CDC_SIDETONE_IIR1_IIR_COEF_B1_CTL          0x0d70
#define WCD934X_CDC_SIDETONE_IIR1_IIR_COEF_B2_CTL          0x0d71
#define WCD934X_CDC_TOP_TOP_CFG0                           0x0d81
#define WCD934X_CDC_TOP_TOP_CFG1                           0x0d82
#define WCD934X_CDC_TOP_TOP_CFG7                           0x0d88
#define WCD934X_CDC_TOP_HPHL_COMP_WR_LSB                   0x0d89
#define WCD934X_CDC_TOP_HPHL_COMP_WR_MSB                   0x0d8a
#define WCD934X_CDC_TOP_HPHL_COMP_LUT                      0x0d8b
#define WCD934X_CDC_TOP_HPHL_COMP_RD_LSB                   0x0d8c
#define WCD934X_CDC_TOP_HPHL_COMP_RD_MSB                   0x0d8d
#define WCD934X_CDC_TOP_HPHR_COMP_WR_LSB                   0x0d8e
#define WCD934X_CDC_TOP_HPHR_COMP_WR_MSB                   0x0d8f
#define WCD934X_CDC_TOP_HPHR_COMP_LUT                      0x0d90
#define WCD934X_CDC_TOP_HPHR_COMP_RD_LSB                   0x0d91
#define WCD934X_CDC_TOP_HPHR_COMP_RD_MSB                   0x0d92
#define WCD934X_CDC_TOP_DIFFL_COMP_WR_LSB                  0x0d93
#define WCD934X_CDC_TOP_DIFFL_COMP_WR_MSB                  0x0d94
#define WCD934X_CDC_TOP_DIFFL_COMP_LUT                     0x0d95
#define WCD934X_CDC_TOP_DIFFL_COMP_RD_LSB                  0x0d96
#define WCD934X_CDC_TOP_DIFFL_COMP_RD_MSB                  0x0d97
#define WCD934X_CDC_TOP_DIFFR_COMP_WR_LSB                  0x0d98
#define WCD934X_CDC_TOP_DIFFR_COMP_WR_MSB                  0x0d99
#define WCD934X_CDC_TOP_DIFFR_COMP_LUT                     0x0d9a
#define WCD934X_CDC_TOP_DIFFR_COMP_RD_LSB                  0x0d9b
#define WCD934X_CDC_TOP_DIFFR_COMP_RD_MSB                  0x0d9c
#define WCD934X_CDC_DSD0_PATH_CTL                          0x0db1
#define WCD934X_CDC_DSD0_CFG0                              0x0db2
#define WCD934X_CDC_DSD0_CFG1                              0x0db3
#define WCD934X_CDC_DSD0_CFG2                              0x0db4
#define WCD934X_CDC_DSD0_CFG3                              0x0db5
#define WCD934X_CDC_DSD0_CFG4                              0x0db6
#define WCD934X_CDC_DSD0_CFG5                              0x0db7
#define WCD934X_CDC_DSD1_PATH_CTL                          0x0dc1
#define WCD934X_CDC_DSD1_CFG0                              0x0dc2
#define WCD934X_CDC_DSD1_CFG1                              0x0dc3
#define WCD934X_CDC_DSD1_CFG2                              0x0dc4
#define WCD934X_CDC_DSD1_CFG3                              0x0dc5
#define WCD934X_CDC_DSD1_CFG4                              0x0dc6
#define WCD934X_CDC_DSD1_CFG5                              0x0dc7
#define WCD934X_CDC_RX_IDLE_DET_PATH_CTL                   0x0dd1
#define WCD934X_CDC_RX_IDLE_DET_CFG0                       0x0dd2
#define WCD934X_CDC_RX_IDLE_DET_CFG1                       0x0dd3
#define WCD934X_CDC_RX_IDLE_DET_CFG2                       0x0dd4
#define WCD934X_CDC_RX_IDLE_DET_CFG3                       0x0dd5
#define WCD934X_PAGE14_PAGE_REGISTER                       0x0e00
#define WCD934X_CDC_RATE_EST0_RE_CLK_RST_CTL               0x0e01
#define WCD934X_CDC_RATE_EST0_RE_CTL                       0x0e02
#define WCD934X_CDC_RATE_EST0_RE_PULSE_SUPR_CTL            0x0e03
#define WCD934X_CDC_RATE_EST0_RE_TIMER                     0x0e04
#define WCD934X_CDC_RATE_EST0_RE_BW_SW                     0x0e05
#define WCD934X_CDC_RATE_EST0_RE_THRESH                    0x0e06
#define WCD934X_CDC_RATE_EST0_RE_STATUS                    0x0e07
#define WCD934X_CDC_RATE_EST0_RE_DIAG_CTRL                 0x0e09
#define WCD934X_CDC_RATE_EST0_RE_DIAG_TIMER2               0x0e0c
#define WCD934X_CDC_RATE_EST0_RE_DIAG_OFFSET_BW1           0x0e0d
#define WCD934X_CDC_RATE_EST0_RE_DIAG_OFFSET_BW2           0x0e0e
#define WCD934X_CDC_RATE_EST0_RE_DIAG_OFFSET_BW3           0x0e0f
#define WCD934X_CDC_RATE_EST0_RE_DIAG_OFFSET_BW4           0x0e10
#define WCD934X_CDC_RATE_EST0_RE_DIAG_OFFSET_BW5           0x0e11
#define WCD934X_CDC_RATE_EST0_RE_DIAG_LIMIT_BW1            0x0e12
#define WCD934X_CDC_RATE_EST0_RE_DIAG_LIMIT_BW2            0x0e13
#define WCD934X_CDC_RATE_EST0_RE_DIAG_LIMIT_BW3            0x0e14
#define WCD934X_CDC_RATE_EST0_RE_DIAG_LIMIT_BW4            0x0e15
#define WCD934X_CDC_RATE_EST0_RE_DIAG_LIMIT_BW5            0x0e16
#define WCD934X_CDC_RATE_EST0_RE_DIAG_LIMITD1_BW1          0x0e17
#define WCD934X_CDC_RATE_EST0_RE_DIAG_LIMITD1_BW2          0x0e18
#define WCD934X_CDC_RATE_EST0_RE_DIAG_LIMITD1_BW3          0x0e19
#define WCD934X_CDC_RATE_EST0_RE_DIAG_LIMITD1_BW4          0x0e1a
#define WCD934X_CDC_RATE_EST0_RE_DIAG_LIMITD1_BW5          0x0e1b
#define WCD934X_CDC_RATE_EST0_RE_DIAG_HYST_BW1             0x0e1c
#define WCD934X_CDC_RATE_EST0_RE_DIAG_HYST_BW2             0x0e1d
#define WCD934X_CDC_RATE_EST0_RE_DIAG_HYST_BW3             0x0e1e
#define WCD934X_CDC_RATE_EST0_RE_DIAG_HYST_BW4             0x0e1f
#define WCD934X_CDC_RATE_EST0_RE_DIAG_HYST_BW5             0x0e20
#define WCD934X_CDC_RATE_EST0_RE_RMAX_DIAG                 0x0e21
#define WCD934X_CDC_RATE_EST0_RE_RMIN_DIAG                 0x0e22
#define WCD934X_CDC_RATE_EST0_RE_PH_DET                    0x0e23
#define WCD934X_CDC_RATE_EST0_RE_DIAG_CLR                  0x0e24
#define WCD934X_CDC_RATE_EST0_RE_MB_SW_STATE               0x0e25
#define WCD934X_CDC_RATE_EST0_RE_MAST_DIAG_STATE           0x0e26
#define WCD934X_CDC_RATE_EST0_RE_RATE_OUT_7_0              0x0e27
#define WCD934X_CDC_RATE_EST0_RE_RATE_OUT_15_8             0x0e28
#define WCD934X_CDC_RATE_EST0_RE_RATE_OUT_23_16            0x0e29
#define WCD934X_CDC_RATE_EST0_RE_RATE_OUT_31_24            0x0e2a
#define WCD934X_CDC_RATE_EST0_RE_RATE_OUT_39_32            0x0e2b
#define WCD934X_CDC_RATE_EST0_RE_RATE_OUT_40_43            0x0e2c
#define WCD934X_CDC_RATE_EST1_RE_CLK_RST_CTL               0x0e31
#define WCD934X_CDC_RATE_EST1_RE_CTL                       0x0e32
#define WCD934X_CDC_RATE_EST1_RE_PULSE_SUPR_CTL            0x0e33
#define WCD934X_CDC_RATE_EST1_RE_TIMER                     0x0e34
#define WCD934X_CDC_RATE_EST1_RE_BW_SW                     0x0e35
#define WCD934X_CDC_RATE_EST1_RE_THRESH                    0x0e36
#define WCD934X_CDC_RATE_EST1_RE_STATUS                    0x0e37
#define WCD934X_CDC_RATE_EST1_RE_DIAG_CTRL                 0x0e39
#define WCD934X_CDC_RATE_EST1_RE_DIAG_TIMER2               0x0e3c
#define WCD934X_CDC_RATE_EST1_RE_DIAG_OFFSET_BW1           0x0e3d
#define WCD934X_CDC_RATE_EST1_RE_DIAG_OFFSET_BW2           0x0e3e
#define WCD934X_CDC_RATE_EST1_RE_DIAG_OFFSET_BW3           0x0e3f
#define WCD934X_CDC_RATE_EST1_RE_DIAG_OFFSET_BW4           0x0e40
#define WCD934X_CDC_RATE_EST1_RE_DIAG_OFFSET_BW5           0x0e41
#define WCD934X_CDC_RATE_EST1_RE_DIAG_LIMIT_BW1            0x0e42
#define WCD934X_CDC_RATE_EST1_RE_DIAG_LIMIT_BW2            0x0e43
#define WCD934X_CDC_RATE_EST1_RE_DIAG_LIMIT_BW3            0x0e44
#define WCD934X_CDC_RATE_EST1_RE_DIAG_LIMIT_BW4            0x0e45
#define WCD934X_CDC_RATE_EST1_RE_DIAG_LIMIT_BW5            0x0e46
#define WCD934X_CDC_RATE_EST1_RE_DIAG_LIMITD1_BW1          0x0e47
#define WCD934X_CDC_RATE_EST1_RE_DIAG_LIMITD1_BW2          0x0e48
#define WCD934X_CDC_RATE_EST1_RE_DIAG_LIMITD1_BW3          0x0e49
#define WCD934X_CDC_RATE_EST1_RE_DIAG_LIMITD1_BW4          0x0e4a
#define WCD934X_CDC_RATE_EST1_RE_DIAG_LIMITD1_BW5          0x0e4b
#define WCD934X_CDC_RATE_EST1_RE_DIAG_HYST_BW1             0x0e4c
#define WCD934X_CDC_RATE_EST1_RE_DIAG_HYST_BW2             0x0e4d
#define WCD934X_CDC_RATE_EST1_RE_DIAG_HYST_BW3             0x0e4e
#define WCD934X_CDC_RATE_EST1_RE_DIAG_HYST_BW4             0x0e4f
#define WCD934X_CDC_RATE_EST1_RE_DIAG_HYST_BW5             0x0e50
#define WCD934X_CDC_RATE_EST1_RE_RMAX_DIAG                 0x0e51
#define WCD934X_CDC_RATE_EST1_RE_RMIN_DIAG                 0x0e52
#define WCD934X_CDC_RATE_EST1_RE_PH_DET                    0x0e53
#define WCD934X_CDC_RATE_EST1_RE_DIAG_CLR                  0x0e54
#define WCD934X_CDC_RATE_EST1_RE_MB_SW_STATE               0x0e55
#define WCD934X_CDC_RATE_EST1_RE_MAST_DIAG_STATE           0x0e56
#define WCD934X_CDC_RATE_EST1_RE_RATE_OUT_7_0              0x0e57
#define WCD934X_CDC_RATE_EST1_RE_RATE_OUT_15_8             0x0e58
#define WCD934X_CDC_RATE_EST1_RE_RATE_OUT_23_16            0x0e59
#define WCD934X_CDC_RATE_EST1_RE_RATE_OUT_31_24            0x0e5a
#define WCD934X_CDC_RATE_EST1_RE_RATE_OUT_39_32            0x0e5b
#define WCD934X_CDC_RATE_EST1_RE_RATE_OUT_40_43            0x0e5c
#define WCD934X_CDC_RATE_EST2_RE_CLK_RST_CTL               0x0e61
#define WCD934X_CDC_RATE_EST2_RE_CTL                       0x0e62
#define WCD934X_CDC_RATE_EST2_RE_PULSE_SUPR_CTL            0x0e63
#define WCD934X_CDC_RATE_EST2_RE_TIMER                     0x0e64
#define WCD934X_CDC_RATE_EST2_RE_BW_SW                     0x0e65
#define WCD934X_CDC_RATE_EST2_RE_THRESH                    0x0e66
#define WCD934X_CDC_RATE_EST2_RE_STATUS                    0x0e67
#define WCD934X_CDC_RATE_EST2_RE_DIAG_CTRL                 0x0e69
#define WCD934X_CDC_RATE_EST2_RE_DIAG_TIMER2               0x0e6c
#define WCD934X_CDC_RATE_EST2_RE_DIAG_OFFSET_BW1           0x0e6d
#define WCD934X_CDC_RATE_EST2_RE_DIAG_OFFSET_BW2           0x0e6e
#define WCD934X_CDC_RATE_EST2_RE_DIAG_OFFSET_BW3           0x0e6f
#define WCD934X_CDC_RATE_EST2_RE_DIAG_OFFSET_BW4           0x0e70
#define WCD934X_CDC_RATE_EST2_RE_DIAG_OFFSET_BW5           0x0e71
#define WCD934X_CDC_RATE_EST2_RE_DIAG_LIMIT_BW1            0x0e72
#define WCD934X_CDC_RATE_EST2_RE_DIAG_LIMIT_BW2            0x0e73
#define WCD934X_CDC_RATE_EST2_RE_DIAG_LIMIT_BW3            0x0e74
#define WCD934X_CDC_RATE_EST2_RE_DIAG_LIMIT_BW4            0x0e75
#define WCD934X_CDC_RATE_EST2_RE_DIAG_LIMIT_BW5            0x0e76
#define WCD934X_CDC_RATE_EST2_RE_DIAG_LIMITD1_BW1          0x0e77
#define WCD934X_CDC_RATE_EST2_RE_DIAG_LIMITD1_BW2          0x0e78
#define WCD934X_CDC_RATE_EST2_RE_DIAG_LIMITD1_BW3          0x0e79
#define WCD934X_CDC_RATE_EST2_RE_DIAG_LIMITD1_BW4          0x0e7a
#define WCD934X_CDC_RATE_EST2_RE_DIAG_LIMITD1_BW5          0x0e7b
#define WCD934X_CDC_RATE_EST2_RE_DIAG_HYST_BW1             0x0e7c
#define WCD934X_CDC_RATE_EST2_RE_DIAG_HYST_BW2             0x0e7d
#define WCD934X_CDC_RATE_EST2_RE_DIAG_HYST_BW3             0x0e7e
#define WCD934X_CDC_RATE_EST2_RE_DIAG_HYST_BW4             0x0e7f
#define WCD934X_CDC_RATE_EST2_RE_DIAG_HYST_BW5             0x0e80
#define WCD934X_CDC_RATE_EST2_RE_RMAX_DIAG                 0x0e81
#define WCD934X_CDC_RATE_EST2_RE_RMIN_DIAG                 0x0e82
#define WCD934X_CDC_RATE_EST2_RE_PH_DET                    0x0e83
#define WCD934X_CDC_RATE_EST2_RE_DIAG_CLR                  0x0e84
#define WCD934X_CDC_RATE_EST2_RE_MB_SW_STATE               0x0e85
#define WCD934X_CDC_RATE_EST2_RE_MAST_DIAG_STATE           0x0e86
#define WCD934X_CDC_RATE_EST2_RE_RATE_OUT_7_0              0x0e87
#define WCD934X_CDC_RATE_EST2_RE_RATE_OUT_15_8             0x0e88
#define WCD934X_CDC_RATE_EST2_RE_RATE_OUT_23_16            0x0e89
#define WCD934X_CDC_RATE_EST2_RE_RATE_OUT_31_24            0x0e8a
#define WCD934X_CDC_RATE_EST2_RE_RATE_OUT_39_32            0x0e8b
#define WCD934X_CDC_RATE_EST2_RE_RATE_OUT_40_43            0x0e8c
#define WCD934X_CDC_RATE_EST3_RE_CLK_RST_CTL               0x0e91
#define WCD934X_CDC_RATE_EST3_RE_CTL                       0x0e92
#define WCD934X_CDC_RATE_EST3_RE_PULSE_SUPR_CTL            0x0e93
#define WCD934X_CDC_RATE_EST3_RE_TIMER                     0x0e94
#define WCD934X_CDC_RATE_EST3_RE_BW_SW                     0x0e95
#define WCD934X_CDC_RATE_EST3_RE_THRESH                    0x0e96
#define WCD934X_CDC_RATE_EST3_RE_STATUS                    0x0e97
#define WCD934X_CDC_RATE_EST3_RE_DIAG_CTRL                 0x0e99
#define WCD934X_CDC_RATE_EST3_RE_DIAG_TIMER2               0x0e9c
#define WCD934X_CDC_RATE_EST3_RE_DIAG_OFFSET_BW1           0x0e9d
#define WCD934X_CDC_RATE_EST3_RE_DIAG_OFFSET_BW2           0x0e9e
#define WCD934X_CDC_RATE_EST3_RE_DIAG_OFFSET_BW3           0x0e9f
#define WCD934X_CDC_RATE_EST3_RE_DIAG_OFFSET_BW4           0x0ea0
#define WCD934X_CDC_RATE_EST3_RE_DIAG_OFFSET_BW5           0x0ea1
#define WCD934X_CDC_RATE_EST3_RE_DIAG_LIMIT_BW1            0x0ea2
#define WCD934X_CDC_RATE_EST3_RE_DIAG_LIMIT_BW2            0x0ea3
#define WCD934X_CDC_RATE_EST3_RE_DIAG_LIMIT_BW3            0x0ea4
#define WCD934X_CDC_RATE_EST3_RE_DIAG_LIMIT_BW4            0x0ea5
#define WCD934X_CDC_RATE_EST3_RE_DIAG_LIMIT_BW5            0x0ea6
#define WCD934X_CDC_RATE_EST3_RE_DIAG_LIMITD1_BW1          0x0ea7
#define WCD934X_CDC_RATE_EST3_RE_DIAG_LIMITD1_BW2          0x0ea8
#define WCD934X_CDC_RATE_EST3_RE_DIAG_LIMITD1_BW3          0x0ea9
#define WCD934X_CDC_RATE_EST3_RE_DIAG_LIMITD1_BW4          0x0eaa
#define WCD934X_CDC_RATE_EST3_RE_DIAG_LIMITD1_BW5          0x0eab
#define WCD934X_CDC_RATE_EST3_RE_DIAG_HYST_BW1             0x0eac
#define WCD934X_CDC_RATE_EST3_RE_DIAG_HYST_BW2             0x0ead
#define WCD934X_CDC_RATE_EST3_RE_DIAG_HYST_BW3             0x0eae
#define WCD934X_CDC_RATE_EST3_RE_DIAG_HYST_BW4             0x0eaf
#define WCD934X_CDC_RATE_EST3_RE_DIAG_HYST_BW5             0x0eb0
#define WCD934X_CDC_RATE_EST3_RE_RMAX_DIAG                 0x0eb1
#define WCD934X_CDC_RATE_EST3_RE_RMIN_DIAG                 0x0eb2
#define WCD934X_CDC_RATE_EST3_RE_PH_DET                    0x0eb3
#define WCD934X_CDC_RATE_EST3_RE_DIAG_CLR                  0x0eb4
#define WCD934X_CDC_RATE_EST3_RE_MB_SW_STATE               0x0eb5
#define WCD934X_CDC_RATE_EST3_RE_MAST_DIAG_STATE           0x0eb6
#define WCD934X_CDC_RATE_EST3_RE_RATE_OUT_7_0              0x0eb7
#define WCD934X_CDC_RATE_EST3_RE_RATE_OUT_15_8             0x0eb8
#define WCD934X_CDC_RATE_EST3_RE_RATE_OUT_23_16            0x0eb9
#define WCD934X_CDC_RATE_EST3_RE_RATE_OUT_31_24            0x0eba
#define WCD934X_CDC_RATE_EST3_RE_RATE_OUT_39_32            0x0ebb
#define WCD934X_CDC_RATE_EST3_RE_RATE_OUT_40_43            0x0ebc
#define WCD934X_PAGE15_PAGE_REGISTER                       0x0f00
#define WCD934X_SPLINE_SRC0_CLK_RST_CTL_0                  0x0f01
#define WCD934X_SPLINE_SRC0_STATUS                         0x0f02
#define WCD934X_SPLINE_SRC1_CLK_RST_CTL_0                  0x0f19
#define WCD934X_SPLINE_SRC1_STATUS                         0x0f1a
#define WCD934X_SPLINE_SRC2_CLK_RST_CTL_0                  0x0f31
#define WCD934X_SPLINE_SRC2_STATUS                         0x0f32
#define WCD934X_SPLINE_SRC3_CLK_RST_CTL_0                  0x0f49
#define WCD934X_SPLINE_SRC3_STATUS                         0x0f4a
#define WCD934X_CDC_DEBUG_DSD0_DEBUG_CFG0                  0x0fa1
#define WCD934X_CDC_DEBUG_DSD0_DEBUG_CFG1                  0x0fa2
#define WCD934X_CDC_DEBUG_DSD0_DEBUG_CFG2                  0x0fa3
#define WCD934X_CDC_DEBUG_DSD0_DEBUG_CFG3                  0x0fa4
#define WCD934X_CDC_DEBUG_DSD1_DEBUG_CFG0                  0x0fa5
#define WCD934X_CDC_DEBUG_DSD1_DEBUG_CFG1                  0x0fa6
#define WCD934X_CDC_DEBUG_DSD1_DEBUG_CFG2                  0x0fa7
#define WCD934X_CDC_DEBUG_DSD1_DEBUG_CFG3                  0x0fa8
#define WCD934X_CDC_DEBUG_SPLINE_SRC_DEBUG_CFG0            0x0fa9
#define WCD934X_CDC_DEBUG_SPLINE_SRC_DEBUG_CFG1            0x0faa
#define WCD934X_CDC_DEBUG_RC_RE_ASRC_DEBUG_CFG0            0x0fab
#define WCD934X_CDC_DEBUG_ANC0_RC0_FIFO_CTL                0x0fac
#define WCD934X_CDC_DEBUG_ANC0_RC1_FIFO_CTL                0x0fad
#define WCD934X_CDC_DEBUG_ANC1_RC0_FIFO_CTL                0x0fae
#define WCD934X_CDC_DEBUG_ANC1_RC1_FIFO_CTL                0x0faf
#define WCD934X_CDC_DEBUG_ANC_RC_RST_DBG_CNTR              0x0fb0
#define WCD934X_PAGE80_PAGE_REGISTER                       0x5000
#define WCD934X_CODEC_CPR_WR_DATA_0                        0x5001
#define WCD934X_CODEC_CPR_WR_DATA_1                        0x5002
#define WCD934X_CODEC_CPR_WR_DATA_2                        0x5003
#define WCD934X_CODEC_CPR_WR_DATA_3                        0x5004
#define WCD934X_CODEC_CPR_WR_ADDR_0                        0x5005
#define WCD934X_CODEC_CPR_WR_ADDR_1                        0x5006
#define WCD934X_CODEC_CPR_WR_ADDR_2                        0x5007
#define WCD934X_CODEC_CPR_WR_ADDR_3                        0x5008
#define WCD934X_CODEC_CPR_RD_ADDR_0                        0x5009
#define WCD934X_CODEC_CPR_RD_ADDR_1                        0x500a
#define WCD934X_CODEC_CPR_RD_ADDR_2                        0x500b
#define WCD934X_CODEC_CPR_RD_ADDR_3                        0x500c
#define WCD934X_CODEC_CPR_RD_DATA_0                        0x500d
#define WCD934X_CODEC_CPR_RD_DATA_1                        0x500e
#define WCD934X_CODEC_CPR_RD_DATA_2                        0x500f
#define WCD934X_CODEC_CPR_RD_DATA_3                        0x5010
#define WCD934X_CODEC_CPR_ACCESS_CFG                       0x5011
#define WCD934X_CODEC_CPR_ACCESS_STATUS                    0x5012
#define WCD934X_CODEC_CPR_NOM_CX_VDD                       0x5021
#define WCD934X_CODEC_CPR_SVS_CX_VDD                       0x5022
#define WCD934X_CODEC_CPR_SVS2_CX_VDD                      0x5023
#define WCD934X_CODEC_CPR_NOM_MX_VDD                       0x5024
#define WCD934X_CODEC_CPR_SVS_MX_VDD                       0x5025
#define WCD934X_CODEC_CPR_SVS2_MX_VDD                      0x5026
#define WCD934X_CODEC_CPR_SVS2_MIN_CX_VDD                  0x5027
#define WCD934X_CODEC_CPR_MAX_SVS2_STEP                    0x5028
#define WCD934X_CODEC_CPR_CTL                              0x5029
#define WCD934X_CODEC_CPR_SW_MODECHNG_STATUS               0x502a
#define WCD934X_CODEC_CPR_SW_MODECHNG_START                0x502b
#define WCD934X_CODEC_CPR_CPR_STATUS                       0x502c
#define WCD934X_PAGE128_PAGE_REGISTER                      0x8000
#define WCD934X_TLMM_BIST_MODE_PINCFG                      0x8001
#define WCD934X_TLMM_RF_PA_ON_PINCFG                       0x8002
#define WCD934X_TLMM_INTR1_PINCFG                          0x8003
#define WCD934X_TLMM_INTR2_PINCFG                          0x8004
#define WCD934X_TLMM_SWR_DATA_PINCFG                       0x8005
#define WCD934X_TLMM_SWR_CLK_PINCFG                        0x8006
#define WCD934X_TLMM_I2S_2_SCK_PINCFG                      0x8007
#define WCD934X_TLMM_SLIMBUS_DATA1_PINCFG                  0x8008
#define WCD934X_TLMM_SLIMBUS_DATA2_PINCFG                  0x8009
#define WCD934X_TLMM_SLIMBUS_CLK_PINCFG                    0x800a
#define WCD934X_TLMM_I2C_CLK_PINCFG                        0x800b
#define WCD934X_TLMM_I2C_DATA_PINCFG                       0x800c
#define WCD934X_TLMM_I2S_0_RX_PINCFG                       0x800d
#define WCD934X_TLMM_I2S_0_TX_PINCFG                       0x800e
#define WCD934X_TLMM_I2S_0_SCK_PINCFG                      0x800f
#define WCD934X_TLMM_I2S_0_WS_PINCFG                       0x8010
#define WCD934X_TLMM_I2S_1_RX_PINCFG                       0x8011
#define WCD934X_TLMM_I2S_1_TX_PINCFG                       0x8012
#define WCD934X_TLMM_I2S_1_SCK_PINCFG                      0x8013
#define WCD934X_TLMM_I2S_1_WS_PINCFG                       0x8014
#define WCD934X_TLMM_DMIC1_CLK_PINCFG                      0x8015
#define WCD934X_TLMM_DMIC1_DATA_PINCFG                     0x8016
#define WCD934X_TLMM_DMIC2_CLK_PINCFG                      0x8017
#define WCD934X_TLMM_DMIC2_DATA_PINCFG                     0x8018
#define WCD934X_TLMM_DMIC3_CLK_PINCFG                      0x8019
#define WCD934X_TLMM_DMIC3_DATA_PINCFG                     0x801a
#define WCD934X_TLMM_JTCK_PINCFG                           0x801b
#define WCD934X_TLMM_GPIO1_PINCFG                          0x801c
#define WCD934X_TLMM_GPIO2_PINCFG                          0x801d
#define WCD934X_TLMM_GPIO3_PINCFG                          0x801e
#define WCD934X_TLMM_GPIO4_PINCFG                          0x801f
#define WCD934X_TLMM_SPI_S_CSN_PINCFG                      0x8020
#define WCD934X_TLMM_SPI_S_CLK_PINCFG                      0x8021
#define WCD934X_TLMM_SPI_S_DOUT_PINCFG                     0x8022
#define WCD934X_TLMM_SPI_S_DIN_PINCFG                      0x8023
#define WCD934X_TLMM_BA_N_PINCFG                           0x8024
#define WCD934X_TLMM_GPIO0_PINCFG                          0x8025
#define WCD934X_TLMM_I2S_2_RX_PINCFG                       0x8026
#define WCD934X_TLMM_I2S_2_WS_PINCFG                       0x8027
#define WCD934X_TEST_DEBUG_PIN_CTL_OE_0                    0x8031
#define WCD934X_TEST_DEBUG_PIN_CTL_OE_1                    0x8032
#define WCD934X_TEST_DEBUG_PIN_CTL_OE_2                    0x8033
#define WCD934X_TEST_DEBUG_PIN_CTL_OE_3                    0x8034
#define WCD934X_TEST_DEBUG_PIN_CTL_OE_4                    0x8035
#define WCD934X_TEST_DEBUG_PIN_CTL_DATA_0                  0x8036
#define WCD934X_TEST_DEBUG_PIN_CTL_DATA_1                  0x8037
#define WCD934X_TEST_DEBUG_PIN_CTL_DATA_2                  0x8038
#define WCD934X_TEST_DEBUG_PIN_CTL_DATA_3                  0x8039
#define WCD934X_TEST_DEBUG_PIN_CTL_DATA_4                  0x803a
#define WCD934X_TEST_DEBUG_PAD_DRVCTL_0                    0x803b
#define WCD934X_TEST_DEBUG_PAD_DRVCTL_1                    0x803c
#define WCD934X_TEST_DEBUG_PIN_STATUS                      0x803d
#define WCD934X_TEST_DEBUG_NPL_DLY_TEST_1                  0x803e
#define WCD934X_TEST_DEBUG_NPL_DLY_TEST_2                  0x803f
#define WCD934X_TEST_DEBUG_MEM_CTRL                        0x8040
#define WCD934X_TEST_DEBUG_DEBUG_BUS_SEL                   0x8041
#define WCD934X_TEST_DEBUG_DEBUG_JTAG                      0x8042
#define WCD934X_TEST_DEBUG_DEBUG_EN_1                      0x8043
#define WCD934X_TEST_DEBUG_DEBUG_EN_2                      0x8044
#define WCD934X_TEST_DEBUG_DEBUG_EN_3                      0x8045
#define WCD934X_TEST_DEBUG_DEBUG_EN_4                      0x8046
#define WCD934X_TEST_DEBUG_DEBUG_EN_5                      0x8047
#define WCD934X_TEST_DEBUG_ANA_DTEST_DIR                   0x804a
#define WCD934X_TEST_DEBUG_PAD_INP_DISABLE_0               0x804b
#define WCD934X_TEST_DEBUG_PAD_INP_DISABLE_1               0x804c
#define WCD934X_TEST_DEBUG_PAD_INP_DISABLE_2               0x804d
#define WCD934X_TEST_DEBUG_PAD_INP_DISABLE_3               0x804e
#define WCD934X_TEST_DEBUG_PAD_INP_DISABLE_4               0x804f
#define WCD934X_TEST_DEBUG_SYSMEM_CTRL                     0x8050
#define WCD934X_TEST_DEBUG_SOC_SW_PWR_SEQ_DELAY            0x8051
#define WCD934X_TEST_DEBUG_LVAL_NOM_LOW                    0x8052
#define WCD934X_TEST_DEBUG_LVAL_NOM_HIGH                   0x8053
#define WCD934X_TEST_DEBUG_LVAL_SVS_SVS2_LOW               0x8054
#define WCD934X_TEST_DEBUG_LVAL_SVS_SVS2_HIGH              0x8055
#define WCD934X_TEST_DEBUG_SPI_SLAVE_CHAR                  0x8056
#define WCD934X_TEST_DEBUG_CODEC_DIAGS                     0x8057
#define WCD934X_MAX_REGISTER                               0x80FF

/* SLIMBUS Slave Registers */
#define WCD934X_SLIM_PGD_PORT_INT_RX_EN0                     (0x30)
#define WCD934X_SLIM_PGD_PORT_INT_TX_EN0                     (0x32)
#define WCD934X_SLIM_PGD_PORT_INT_STATUS_RX_0                (0x34)
#define WCD934X_SLIM_PGD_PORT_INT_STATUS_RX_1                (0x35)
#define WCD934X_SLIM_PGD_PORT_INT_STATUS_TX_0                (0x36)
#define WCD934X_SLIM_PGD_PORT_INT_STATUS_TX_1                (0x37)
#define WCD934X_SLIM_PGD_PORT_INT_CLR_RX_0                   (0x38)
#define WCD934X_SLIM_PGD_PORT_INT_CLR_RX_1                   (0x39)
#define WCD934X_SLIM_PGD_PORT_INT_CLR_TX_0                   (0x3A)
#define WCD934X_SLIM_PGD_PORT_INT_CLR_TX_1                   (0x3B)
#define WCD934X_SLIM_PGD_PORT_INT_RX_SOURCE0                 (0x60)
#define WCD934X_SLIM_PGD_PORT_INT_TX_SOURCE0                 (0x70)

#endif
