/* Copyright (c) 2017-2018, The Linux Foundation. All rights
 * reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * This file contain content copied from Synopsis driver,
 * provided under the license below
 */
/* =========================================================================
 * The Synopsys DWC ETHER QOS Software Driver and documentation (hereinafter
 * "Software") is an unsupported proprietary work of Synopsys, Inc. unless
 * otherwise expressly agreed to in writing between Synopsys and you.
 *
 * The Software IS NOT an item of Licensed Software or Licensed Product under
 * any End User Software License Agreement or Agreement for Licensed Product
 * with Synopsys or any supplement thereto.  Permission is hereby granted,
 * free of charge, to any person obtaining a copy of this software annotated
 * with this license and the Software, to deal in the Software without
 * restriction, including without limitation the rights to use, copy, modify,
 * merge, publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THIS SOFTWARE IS BEING DISTRIBUTED BY SYNOPSYS SOLELY ON AN "AS IS" BASIS
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE HEREBY DISCLAIMED. IN NO EVENT SHALL SYNOPSYS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 * ========================================================================= */

#ifndef __DWC_ETH_QOS__REGACC__H__

#define __DWC_ETH_QOS__REGACC__H__

#define MAKE_MASK_32(e, s) (((e) - (s)) == 31 ? 0xffffffffUL : ((1UL << ((e) - (s) + 1)) - 1))

#define MAKE_MASK_64(e, s) (((e) - (s)) == 63 ? 0xffffffffffffffffULL : ((1ULL << ((e) - (s) + 1)) - 1))

#define GET_BITS(e, s, reg, data) \
  (data = ((e) - (s) > 31) ?\
    (((reg) >> (s)) & MAKE_MASK_64(e, s)) :\
    (((reg) >> (s)) & MAKE_MASK_32(e, s)))

#define SET_BITS(e, s, reg, val) do { \
  if ((e) - (s) > 31) { \
    reg = ((((val) << (s)) & (MAKE_MASK_64((e), (s)) << (s))) | ((reg) & (~(MAKE_MASK_64((e), (s)) << (s))))); \
  } \
  else { \
    reg = ((((val) << (s)) & (MAKE_MASK_32((e), (s)) << (s))) | ((reg) & (~(MAKE_MASK_32((e), (s)) << (s))))); \
  } \
} while (0)

/* virtual_registers Low Bit Macro Name's */
#define RX_CONTEXT_DESC_RDES3_OWN_LBIT_POS  0x1f
#define RX_CONTEXT_DESC_RDES3_CTXT_LBIT_POS  0x1e
#define RX_CONTEXT_DESC_RDES2_RESERVED_BITS_LBIT_POS  0
#define RX_CONTEXT_DESC_RDES1_RTSH_LBIT_POS  0
#define RX_CONTEXT_DESC_RDES0_RTSL_LBIT_POS  0
#define TX_CONTEXT_DESC_TDES3_OWN_LBIT_POS  0x1f
#define TX_CONTEXT_DESC_TDES3_CTXT_LBIT_POS  0x1e
#define TX_CONTEXT_DESC_TDES3_OSTC_LBIT_POS  0x1b
#define TX_CONTEXT_DESC_TDES3_TCMSSV_LBIT_POS  0x1a
#define TX_CONTEXT_DESC_TDES3_CDX_LBIT_POS  0x17
#define TX_CONTEXT_DESC_TDES3_IVTIR_LBIT_POS  0x12
#define TX_CONTEXT_DESC_TDES3_SVLTV_LBIT_POS  0x11
#define TX_CONTEXT_DESC_TDES3_IVLTV_LBIT_POS  0x11
#define TX_CONTEXT_DESC_TDES3_VLTV_LBIT_POS  0x10
#define TX_CONTEXT_DESC_TDES2_IVT_LBIT_POS  0x10
#define TX_CONTEXT_DESC_TDES3_VT_LBIT_POS  0
#define TX_CONTEXT_DESC_TDES2_SVT_LBIT_POS  0xf
#define TX_CONTEXT_DESC_TDES2_MSS_LBIT_POS  0
#define TX_CONTEXT_DESC_TDES1_NDAP_LBIT_POS  0
#define TX_CONTEXT_DESC_TDES0_TTSL_LBIT_POS  0
#define RX_NORMAL_DESC_RDES3_OWN_LBIT_POS  0x1f
#define RX_NORMAL_DESC_RDES3_CTXT_LBIT_POS  0x1e
#define RX_NORMAL_DESC_RDES3_FD_LBIT_POS  0x1d
#define RX_NORMAL_DESC_RDES3_LD_LBIT_POS  0x1c
#define RX_NORMAL_DESC_RDES3_RS2V_LBIT_POS  0x1b
#define RX_NORMAL_DESC_RDES3_RS1V_LBIT_POS  0x1a
#define RX_NORMAL_DESC_RDES3_RS0V_LBIT_POS  0x19
#define RX_NORMAL_DESC_RDES3_CE_LBIT_POS  0x18
#define RX_NORMAL_DESC_RDES3_GP_LBIT_POS  0x17
#define RX_NORMAL_DESC_RDES3_RWT_LBIT_POS  0x16
#define RX_NORMAL_DESC_RDES3_OE_LBIT_POS  0x15
#define RX_NORMAL_DESC_RDES3_RE_LBIT_POS  0x14
#define RX_NORMAL_DESC_RDES3_DE_LBIT_POS  0x13
#define RX_NORMAL_DESC_RDES3_LT_LBIT_POS  0x10
#define RX_NORMAL_DESC_RDES3_ES_LBIT_POS  0xf
#define RX_NORMAL_DESC_RDES3_FL_LBIT_POS  0
#define RX_NORMAL_DESC_RDES2_B2AP_NDA_LBIT_POS  0
#define RX_NORMAL_DESC_RDES1_COP_LBIT_POS  0x10
#define RX_NORMAL_DESC_RDES1_TD_LBIT_POS  0xf
#define RX_NORMAL_DESC_RDES1_TSA_LBIT_POS  0xe
#define RX_NORMAL_DESC_RDES1_PV_LBIT_POS  0xd
#define RX_NORMAL_DESC_RDES1_PFT_LBIT_POS  0xc
#define RX_NORMAL_DESC_RDES1_PMT_LBIT_POS  0x8
#define RX_NORMAL_DESC_RDES1_IPPE_LBIT_POS  0x7
#define RX_NORMAL_DESC_RDES1_IPCB_LBIT_POS  0x6
#define RX_NORMAL_DESC_RDES1_IPV6_LBIT_POS  0x5
#define RX_NORMAL_DESC_RDES1_IPV4_LBIT_POS  0x4
#define RX_NORMAL_DESC_RDES1_IPHE_LBIT_POS  0x3
#define RX_NORMAL_DESC_RDES1_PT_LBIT_POS  0
#define RX_NORMAL_DESC_RDES0_HDR_B1AP_LBIT_POS  0
#define TX_NORMAL_DESC_TDES3_OWN_LBIT_POS  0x1f
#define TX_NORMAL_DESC_TDES3_CTXT_LBIT_POS  0x1e
#define TX_NORMAL_DESC_TDES3_FD_LBIT_POS  0x1d
#define TX_NORMAL_DESC_TDES3_LD_LBIT_POS  0x1c
#define TX_NORMAL_DESC_TDES3_CPC_LBIT_POS  0x1a
#define TX_NORMAL_DESC_TDES3_SAIC_LBIT_POS  0x17
#define TX_NORMAL_DESC_TDES3_SLOTNUM_TCPHDRLEN_LBIT_POS  0x13
#define TX_NORMAL_DESC_TDES3_TSE_LBIT_POS  0x12
#define TX_NORMAL_DESC_TDES3_CIC_LBIT_POS  0x10
#define TX_NORMAL_DESC_TDES3_TIPLH_LBIT_POS  0xf
#define TX_NORMAL_DESC_TDES3_FL_LBIT_POS  0
#define TX_NORMAL_DESC_TDES2_IC_LBIT_POS  0x1f
#define TX_NORMAL_DESC_TDES2_TTSE_LBIT_POS  0x1e
#define TX_NORMAL_DESC_TDES2_B2L_LBIT_POS  0x10
#define TX_NORMAL_DESC_TDES2_VTIR_LBIT_POS  0xe
#define TX_NORMAL_DESC_TDES2_HL_B1L_LBIT_POS  0
#define TX_NORMAL_DESC_TDES1_B2A_NDA_LBIT_POS  0
#define TX_NORMAL_DESC_TDES0_B1A_HAP_LBIT_POS  0
#define TX_ERROR_COUNTERS_TX_ERRORS_HEARTBEAT_ERROR_LBIT_POS  0x4
#define TX_ERROR_COUNTERS_TX_ERRORS_WINDOW_ERROR_LBIT_POS  0x3
#define TX_ERROR_COUNTERS_TX_ERRORS_FIFO_ERROR_LBIT_POS  0x2
#define TX_ERROR_COUNTERS_TX_ERRORS_CARRIER_ERROR_LBIT_POS  0x1
#define TX_ERROR_COUNTERS_TX_ERRORS_ABORTED_ERROR_LBIT_POS  0
#define RX_ERROR_COUNTERS_RX_ERRORS_MISSED_ERROR_LBIT_POS  0x5
#define RX_ERROR_COUNTERS_RX_ERRORS_FIFO_ERROR_LBIT_POS  0x4
#define RX_ERROR_COUNTERS_RX_ERRORS_FRAME_ERROR_LBIT_POS  0x3
#define RX_ERROR_COUNTERS_RX_ERRORS_CRC_ERROR_LBIT_POS  0x2
#define RX_ERROR_COUNTERS_RX_ERRORS_OVERRUN_ERROR_LBIT_POS  0x1
#define RX_ERROR_COUNTERS_RX_ERRORS_LENGTH_ERROR_LBIT_POS  0
#define RX_PKT_FEATURES_VLAN_TAG_SVT_LBIT_POS  0x10
#define RX_PKT_FEATURES_VLAN_TAG_VT_LBIT_POS  0
#define RX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_LBIT_POS  0x1
#define RX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_DONE_LBIT_POS  0
#define TX_PKT_FEATURES_TCP_HDR_LEN_LEN_LBIT_POS  0
#define TX_PKT_FEATURES_PKT_TYPE_TCP_PKT_LBIT_POS  0x1
#define TX_PKT_FEATURES_PKT_TYPE_IP_PKT_LBIT_POS  0
#define TX_PKT_FEATURES_TUCSE_TCPCSE_LBIT_POS  0
#define TX_PKT_FEATURES_TUCSO_TCPCSO_LBIT_POS  0
#define TX_PKT_FEATURES_TUCSS_TCPCSS_LBIT_POS  0
#define TX_PKT_FEATURES_IPCSE_IPCSE_LBIT_POS  0
#define TX_PKT_FEATURES_IPCSO_IPCSO_LBIT_POS  0
#define TX_PKT_FEATURES_IPCSS_IPCSS_LBIT_POS  0
#define TX_PKT_FEATURES_PAY_LEN_PAY_LEN_LBIT_POS  0
#define TX_PKT_FEATURES_HDR_LEN_HDR_LEN_LBIT_POS  0
#define TX_PKT_FEATURES_MSS_MSS_LBIT_POS  0
#define TX_PKT_FEATURES_VLAN_TAG_SVT_LBIT_POS  0x10
#define TX_PKT_FEATURES_VLAN_TAG_VT_LBIT_POS  0
#define TX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_LBIT_POS  0x3
#define TX_PKT_FEATURES_PKT_ATTRIBUTES_PTP_ENABLE_LBIT_POS  0x2
#define TX_PKT_FEATURES_PKT_ATTRIBUTES_TSO_ENABLE_LBIT_POS  0x1
#define TX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_ENABLE_LBIT_POS  0

/* virtual_registers High Bit Macro Name's */
#define RX_CONTEXT_DESC_RDES3_OWN_HBIT_POS  0x1f
#define RX_CONTEXT_DESC_RDES3_CTXT_HBIT_POS  0x1e
#define RX_CONTEXT_DESC_RDES2_RESERVED_BITS_HBIT_POS  0x1f
#define RX_CONTEXT_DESC_RDES1_RTSH_HBIT_POS  0x1f
#define RX_CONTEXT_DESC_RDES0_RTSL_HBIT_POS  0x1f
#define TX_CONTEXT_DESC_TDES3_OWN_HBIT_POS  0x1f
#define TX_CONTEXT_DESC_TDES3_CTXT_HBIT_POS  0x1e
#define TX_CONTEXT_DESC_TDES3_OSTC_HBIT_POS  0x1b
#define TX_CONTEXT_DESC_TDES3_TCMSSV_HBIT_POS  0x1a
#define TX_CONTEXT_DESC_TDES3_CDX_HBIT_POS  0x17
#define TX_CONTEXT_DESC_TDES3_IVTIR_HBIT_POS  0x13
#define TX_CONTEXT_DESC_TDES3_SVLTV_HBIT_POS  0x11
#define TX_CONTEXT_DESC_TDES3_IVLTV_HBIT_POS  0x11
#define TX_CONTEXT_DESC_TDES3_VLTV_HBIT_POS  0x10
#define TX_CONTEXT_DESC_TDES3_VT_HBIT_POS  0xf
#define TX_CONTEXT_DESC_TDES2_IVT_HBIT_POS  0x1f
#define TX_CONTEXT_DESC_TDES2_SVT_HBIT_POS  0x1f
#define TX_CONTEXT_DESC_TDES2_MSS_HBIT_POS  0xe
#define TX_CONTEXT_DESC_TDES1_NDAP_HBIT_POS  0x1f
#define TX_CONTEXT_DESC_TDES0_TTSL_HBIT_POS  0x1f
#define RX_NORMAL_DESC_RDES3_OWN_HBIT_POS  0x1f
#define RX_NORMAL_DESC_RDES3_CTXT_HBIT_POS  0x1e
#define RX_NORMAL_DESC_RDES3_FD_HBIT_POS  0x1d
#define RX_NORMAL_DESC_RDES3_LD_HBIT_POS  0x1c
#define RX_NORMAL_DESC_RDES3_RS2V_HBIT_POS  0x1b
#define RX_NORMAL_DESC_RDES3_RS1V_HBIT_POS  0x1a
#define RX_NORMAL_DESC_RDES3_RS0V_HBIT_POS  0x19
#define RX_NORMAL_DESC_RDES3_CE_HBIT_POS  0x18
#define RX_NORMAL_DESC_RDES3_GP_HBIT_POS  0x17
#define RX_NORMAL_DESC_RDES3_RWT_HBIT_POS  0x16
#define RX_NORMAL_DESC_RDES3_OE_HBIT_POS  0x15
#define RX_NORMAL_DESC_RDES3_RE_HBIT_POS  0x14
#define RX_NORMAL_DESC_RDES3_DE_HBIT_POS  0x13
#define RX_NORMAL_DESC_RDES3_LT_HBIT_POS  0x12
#define RX_NORMAL_DESC_RDES3_ES_HBIT_POS  0xf
#define RX_NORMAL_DESC_RDES3_FL_HBIT_POS  0xe
#define RX_NORMAL_DESC_RDES2_B2AP_NDA_HBIT_POS  0x1f
#define RX_NORMAL_DESC_RDES1_COP_HBIT_POS  0x1f
#define RX_NORMAL_DESC_RDES1_TD_HBIT_POS  0xf
#define RX_NORMAL_DESC_RDES1_TSA_HBIT_POS  0xe
#define RX_NORMAL_DESC_RDES1_PV_HBIT_POS  0xd
#define RX_NORMAL_DESC_RDES1_PFT_HBIT_POS  0xc
#define RX_NORMAL_DESC_RDES1_PMT_HBIT_POS  0xb
#define RX_NORMAL_DESC_RDES1_IPPE_HBIT_POS  0x7
#define RX_NORMAL_DESC_RDES1_IPCB_HBIT_POS  0x6
#define RX_NORMAL_DESC_RDES1_IPV6_HBIT_POS  0x5
#define RX_NORMAL_DESC_RDES1_IPV4_HBIT_POS  0x4
#define RX_NORMAL_DESC_RDES1_IPHE_HBIT_POS  0x3
#define RX_NORMAL_DESC_RDES1_PT_HBIT_POS  0x2
#define RX_NORMAL_DESC_RDES0_HDR_B1AP_HBIT_POS  0x1f
#define TX_NORMAL_DESC_TDES3_OWN_HBIT_POS  0x1f
#define TX_NORMAL_DESC_TDES3_CTXT_HBIT_POS  0x1e
#define TX_NORMAL_DESC_TDES3_FD_HBIT_POS  0x1d
#define TX_NORMAL_DESC_TDES3_LD_HBIT_POS  0x1c
#define TX_NORMAL_DESC_TDES3_CPC_HBIT_POS  0x1b
#define TX_NORMAL_DESC_TDES3_SAIC_HBIT_POS  0x19
#define TX_NORMAL_DESC_TDES3_SLOTNUM_TCPHDRLEN_HBIT_POS  0x16
#define TX_NORMAL_DESC_TDES3_TSE_HBIT_POS  0x12
#define TX_NORMAL_DESC_TDES3_CIC_HBIT_POS  0x11
#define TX_NORMAL_DESC_TDES3_TIPLH_HBIT_POS  0xf
#define TX_NORMAL_DESC_TDES3_FL_HBIT_POS  0xe
#define TX_NORMAL_DESC_TDES2_IC_HBIT_POS  0x1f
#define TX_NORMAL_DESC_TDES2_TTSE_HBIT_POS  0x1e
#define TX_NORMAL_DESC_TDES2_B2L_HBIT_POS  0x1d
#define TX_NORMAL_DESC_TDES2_VTIR_HBIT_POS  0xf
#define TX_NORMAL_DESC_TDES2_HL_B1L_HBIT_POS  0xd
#define TX_NORMAL_DESC_TDES1_B2A_NDA_HBIT_POS  0x1f
#define TX_NORMAL_DESC_TDES0_B1A_HAP_HBIT_POS  0x1f
#define TX_ERROR_COUNTERS_TX_ERRORS_HEARTBEAT_ERROR_HBIT_POS  0x4
#define TX_ERROR_COUNTERS_TX_ERRORS_WINDOW_ERROR_HBIT_POS  0x3
#define TX_ERROR_COUNTERS_TX_ERRORS_FIFO_ERROR_HBIT_POS  0x2
#define TX_ERROR_COUNTERS_TX_ERRORS_CARRIER_ERROR_HBIT_POS  0x1
#define TX_ERROR_COUNTERS_TX_ERRORS_ABORTED_ERROR_HBIT_POS  0
#define RX_ERROR_COUNTERS_RX_ERRORS_MISSED_ERROR_HBIT_POS  0x5
#define RX_ERROR_COUNTERS_RX_ERRORS_FIFO_ERROR_HBIT_POS  0x4
#define RX_ERROR_COUNTERS_RX_ERRORS_FRAME_ERROR_HBIT_POS  0x3
#define RX_ERROR_COUNTERS_RX_ERRORS_CRC_ERROR_HBIT_POS  0x2
#define RX_ERROR_COUNTERS_RX_ERRORS_OVERRUN_ERROR_HBIT_POS  0x1
#define RX_ERROR_COUNTERS_RX_ERRORS_LENGTH_ERROR_HBIT_POS  0
#define RX_PKT_FEATURES_VLAN_TAG_SVT_HBIT_POS  0x1f
#define RX_PKT_FEATURES_VLAN_TAG_VT_HBIT_POS  0xf
#define RX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_HBIT_POS  0x1
#define RX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_DONE_HBIT_POS  0
#define TX_PKT_FEATURES_TCP_HDR_LEN_LEN_HBIT_POS  0x1f
#define TX_PKT_FEATURES_PKT_TYPE_TCP_PKT_HBIT_POS  0x1
#define TX_PKT_FEATURES_PKT_TYPE_IP_PKT_HBIT_POS  0
#define TX_PKT_FEATURES_TUCSE_TCPCSE_HBIT_POS  0xf
#define TX_PKT_FEATURES_TUCSO_TCPCSO_HBIT_POS  0x7
#define TX_PKT_FEATURES_TUCSS_TCPCSS_HBIT_POS  0x7
#define TX_PKT_FEATURES_IPCSE_IPCSE_HBIT_POS  0xf
#define TX_PKT_FEATURES_IPCSO_IPCSO_HBIT_POS  0x7
#define TX_PKT_FEATURES_IPCSS_IPCSS_HBIT_POS  0x7
#define TX_PKT_FEATURES_PAY_LEN_PAY_LEN_HBIT_POS  0x3f
#define TX_PKT_FEATURES_HDR_LEN_HDR_LEN_HBIT_POS  0x3f
#define TX_PKT_FEATURES_MSS_MSS_HBIT_POS  0x3f
#define TX_PKT_FEATURES_VLAN_TAG_SVT_HBIT_POS  0x1f
#define TX_PKT_FEATURES_VLAN_TAG_VT_HBIT_POS  0xf
#define TX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_HBIT_POS  0x3
#define TX_PKT_FEATURES_PKT_ATTRIBUTES_PTP_ENABLE_HBIT_POS  0x2
#define TX_PKT_FEATURES_PKT_ATTRIBUTES_TSO_ENABLE_HBIT_POS  0x1
#define TX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_ENABLE_HBIT_POS  0

/* virtual_registers Register-Field Read-Write Macros */
#define RX_CONTEXT_DESC_RDES3_OWN_MLF_RD(ptr, data) do { \
  GET_BITS(RX_CONTEXT_DESC_RDES3_OWN_HBIT_POS, RX_CONTEXT_DESC_RDES3_OWN_LBIT_POS, ptr, data); \
} while (0)

#define RX_CONTEXT_DESC_RDES3_OWN_MLF_WR(ptr, data) do { \
  SET_BITS(RX_CONTEXT_DESC_RDES3_OWN_HBIT_POS, RX_CONTEXT_DESC_RDES3_OWN_LBIT_POS, ptr, data); \
} while (0)

#define RX_CONTEXT_DESC_RDES3_CTXT_MLF_RD(ptr, data) do { \
  GET_BITS(RX_CONTEXT_DESC_RDES3_CTXT_HBIT_POS, RX_CONTEXT_DESC_RDES3_CTXT_LBIT_POS, ptr, data); \
} while (0)

#define RX_CONTEXT_DESC_RDES3_CTXT_MLF_WR(ptr, data) do { \
  SET_BITS(RX_CONTEXT_DESC_RDES3_CTXT_HBIT_POS, RX_CONTEXT_DESC_RDES3_CTXT_LBIT_POS, ptr, data); \
} while (0)

#define RX_CONTEXT_DESC_RDES2_RESERVED_BITS_MLF_RD(ptr, data) do { \
  GET_BITS(RX_CONTEXT_DESC_RDES2_RESERVED_BITS_HBIT_POS, RX_CONTEXT_DESC_RDES2_RESERVED_BITS_LBIT_POS, ptr, data); \
} while (0)

#define RX_CONTEXT_DESC_RDES2_RESERVED_BITS_MLF_WR(ptr, data) do { \
  SET_BITS(RX_CONTEXT_DESC_RDES2_RESERVED_BITS_HBIT_POS, RX_CONTEXT_DESC_RDES2_RESERVED_BITS_LBIT_POS, ptr, data); \
} while (0)

#define RX_CONTEXT_DESC_RDES1_RTSH_MLF_RD(ptr, data) do { \
  GET_BITS(RX_CONTEXT_DESC_RDES1_RTSH_HBIT_POS, RX_CONTEXT_DESC_RDES1_RTSH_LBIT_POS, ptr, data); \
} while (0)

#define RX_CONTEXT_DESC_RDES1_RTSH_MLF_WR(ptr, data) do { \
  SET_BITS(RX_CONTEXT_DESC_RDES1_RTSH_HBIT_POS, RX_CONTEXT_DESC_RDES1_RTSH_LBIT_POS, ptr, data); \
} while (0)

#define RX_CONTEXT_DESC_RDES0_RTSL_MLF_RD(ptr, data) do { \
  GET_BITS(RX_CONTEXT_DESC_RDES0_RTSL_HBIT_POS, RX_CONTEXT_DESC_RDES0_RTSL_LBIT_POS, ptr, data); \
} while (0)

#define RX_CONTEXT_DESC_RDES0_RTSL_MLF_WR(ptr, data) do { \
  SET_BITS(RX_CONTEXT_DESC_RDES0_RTSL_HBIT_POS, RX_CONTEXT_DESC_RDES0_RTSL_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES3_OWN_MLF_RD(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES3_OWN_HBIT_POS, TX_CONTEXT_DESC_TDES3_OWN_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES3_OWN_MLF_WR(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES3_OWN_HBIT_POS, TX_CONTEXT_DESC_TDES3_OWN_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES3_CTXT_MLF_RD(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES3_CTXT_HBIT_POS, TX_CONTEXT_DESC_TDES3_CTXT_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES3_CTXT_MLF_WR(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES3_CTXT_HBIT_POS, TX_CONTEXT_DESC_TDES3_CTXT_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES3_OSTC_MLF_RD(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES3_OSTC_HBIT_POS, TX_CONTEXT_DESC_TDES3_OSTC_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES3_OSTC_MLF_WR(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES3_OSTC_HBIT_POS, TX_CONTEXT_DESC_TDES3_OSTC_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES3_TCMSSV_MLF_RD(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES3_TCMSSV_HBIT_POS, TX_CONTEXT_DESC_TDES3_TCMSSV_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES3_TCMSSV_MLF_WR(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES3_TCMSSV_HBIT_POS, TX_CONTEXT_DESC_TDES3_TCMSSV_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES3_CDX_MLF_RD(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES3_CDX_HBIT_POS, TX_CONTEXT_DESC_TDES3_CDX_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES3_CDX_MLF_WR(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES3_CDX_HBIT_POS, TX_CONTEXT_DESC_TDES3_CDX_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES3_IVTIR_MLF_RD(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES3_IVTIR_HBIT_POS, TX_CONTEXT_DESC_TDES3_IVTIR_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES3_IVTIR_MLF_WR(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES3_IVTIR_HBIT_POS, TX_CONTEXT_DESC_TDES3_IVTIR_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES3_SVLTV_MLF_RD(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES3_SVLTV_HBIT_POS, TX_CONTEXT_DESC_TDES3_SVLTV_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES3_SVLTV_MLF_WR(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES3_SVLTV_HBIT_POS, TX_CONTEXT_DESC_TDES3_SVLTV_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES3_IVLTV_MLF_RD(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES3_IVLTV_HBIT_POS, TX_CONTEXT_DESC_TDES3_IVLTV_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES3_IVLTV_MLF_WR(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES3_IVLTV_HBIT_POS, TX_CONTEXT_DESC_TDES3_IVLTV_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES3_VLTV_MLF_RD(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES3_VLTV_HBIT_POS, TX_CONTEXT_DESC_TDES3_VLTV_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES3_VLTV_MLF_WR(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES3_VLTV_HBIT_POS, TX_CONTEXT_DESC_TDES3_VLTV_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES3_VT_MLF_RD(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES3_VT_HBIT_POS, TX_CONTEXT_DESC_TDES3_VT_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES3_VT_MLF_WR(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES3_VT_HBIT_POS, TX_CONTEXT_DESC_TDES3_VT_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES2_IVT_MLF_RD(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES2_IVT_HBIT_POS, TX_CONTEXT_DESC_TDES2_IVT_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES2_IVT_MLF_WR(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES2_IVT_HBIT_POS, TX_CONTEXT_DESC_TDES2_IVT_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES2_SVT_MLF_RD(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES2_SVT_HBIT_POS, TX_CONTEXT_DESC_TDES2_SVT_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES2_SVT_MLF_WR(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES2_SVT_HBIT_POS, TX_CONTEXT_DESC_TDES2_SVT_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES2_MSS_MLF_RD(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES2_MSS_HBIT_POS, TX_CONTEXT_DESC_TDES2_MSS_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES2_MSS_MLF_WR(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES2_MSS_HBIT_POS, TX_CONTEXT_DESC_TDES2_MSS_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES1_NDAP_MLF_RD(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES1_NDAP_HBIT_POS, TX_CONTEXT_DESC_TDES1_NDAP_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES1_NDAP_MLF_WR(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES1_NDAP_HBIT_POS, TX_CONTEXT_DESC_TDES1_NDAP_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES0_TTSL_MLF_RD(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES0_TTSL_HBIT_POS, TX_CONTEXT_DESC_TDES0_TTSL_LBIT_POS, ptr, data); \
} while (0)

#define TX_CONTEXT_DESC_TDES0_TTSL_MLF_WR(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES0_TTSL_HBIT_POS, TX_CONTEXT_DESC_TDES0_TTSL_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_OWN_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_OWN_HBIT_POS, RX_NORMAL_DESC_RDES3_OWN_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_OWN_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_OWN_HBIT_POS, RX_NORMAL_DESC_RDES3_OWN_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_CTXT_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_CTXT_HBIT_POS, RX_NORMAL_DESC_RDES3_CTXT_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_CTXT_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_CTXT_HBIT_POS, RX_NORMAL_DESC_RDES3_CTXT_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_FD_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_FD_HBIT_POS, RX_NORMAL_DESC_RDES3_FD_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_FD_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_FD_HBIT_POS, RX_NORMAL_DESC_RDES3_FD_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_LD_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_LD_HBIT_POS, RX_NORMAL_DESC_RDES3_LD_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_LD_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_LD_HBIT_POS, RX_NORMAL_DESC_RDES3_LD_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_RS2V_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_RS2V_HBIT_POS, RX_NORMAL_DESC_RDES3_RS2V_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_RS2V_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_RS2V_HBIT_POS, RX_NORMAL_DESC_RDES3_RS2V_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_RS1V_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_RS1V_HBIT_POS, RX_NORMAL_DESC_RDES3_RS1V_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_RS1V_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_RS1V_HBIT_POS, RX_NORMAL_DESC_RDES3_RS1V_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_RS0V_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_RS0V_HBIT_POS, RX_NORMAL_DESC_RDES3_RS0V_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_RS0V_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_RS0V_HBIT_POS, RX_NORMAL_DESC_RDES3_RS0V_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_CE_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_CE_HBIT_POS, RX_NORMAL_DESC_RDES3_CE_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_CE_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_CE_HBIT_POS, RX_NORMAL_DESC_RDES3_CE_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_GP_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_GP_HBIT_POS, RX_NORMAL_DESC_RDES3_GP_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_GP_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_GP_HBIT_POS, RX_NORMAL_DESC_RDES3_GP_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_RWT_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_RWT_HBIT_POS, RX_NORMAL_DESC_RDES3_RWT_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_RWT_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_RWT_HBIT_POS, RX_NORMAL_DESC_RDES3_RWT_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_OE_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_OE_HBIT_POS, RX_NORMAL_DESC_RDES3_OE_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_OE_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_OE_HBIT_POS, RX_NORMAL_DESC_RDES3_OE_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_RE_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_RE_HBIT_POS, RX_NORMAL_DESC_RDES3_RE_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_RE_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_RE_HBIT_POS, RX_NORMAL_DESC_RDES3_RE_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_DE_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_DE_HBIT_POS, RX_NORMAL_DESC_RDES3_DE_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_DE_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_DE_HBIT_POS, RX_NORMAL_DESC_RDES3_DE_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_LT_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_LT_HBIT_POS, RX_NORMAL_DESC_RDES3_LT_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_LT_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_LT_HBIT_POS, RX_NORMAL_DESC_RDES3_LT_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_ES_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_ES_HBIT_POS, RX_NORMAL_DESC_RDES3_ES_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_ES_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_ES_HBIT_POS, RX_NORMAL_DESC_RDES3_ES_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_FL_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_FL_HBIT_POS, RX_NORMAL_DESC_RDES3_FL_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES3_FL_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_FL_HBIT_POS, RX_NORMAL_DESC_RDES3_FL_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES2_B2AP_NDA_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES2_B2AP_NDA_HBIT_POS, RX_NORMAL_DESC_RDES2_B2AP_NDA_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES2_B2AP_NDA_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES2_B2AP_NDA_HBIT_POS, RX_NORMAL_DESC_RDES2_B2AP_NDA_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES1_COP_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES1_COP_HBIT_POS, RX_NORMAL_DESC_RDES1_COP_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES1_COP_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES1_COP_HBIT_POS, RX_NORMAL_DESC_RDES1_COP_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES1_TD_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES1_TD_HBIT_POS, RX_NORMAL_DESC_RDES1_TD_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES1_TD_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES1_TD_HBIT_POS, RX_NORMAL_DESC_RDES1_TD_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES1_TSA_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES1_TSA_HBIT_POS, RX_NORMAL_DESC_RDES1_TSA_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES1_TSA_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES1_TSA_HBIT_POS, RX_NORMAL_DESC_RDES1_TSA_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES1_PV_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES1_PV_HBIT_POS, RX_NORMAL_DESC_RDES1_PV_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES1_PV_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES1_PV_HBIT_POS, RX_NORMAL_DESC_RDES1_PV_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES1_PFT_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES1_PFT_HBIT_POS, RX_NORMAL_DESC_RDES1_PFT_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES1_PFT_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES1_PFT_HBIT_POS, RX_NORMAL_DESC_RDES1_PFT_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES1_PMT_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES1_PMT_HBIT_POS, RX_NORMAL_DESC_RDES1_PMT_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES1_PMT_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES1_PMT_HBIT_POS, RX_NORMAL_DESC_RDES1_PMT_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES1_IPPE_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES1_IPPE_HBIT_POS, RX_NORMAL_DESC_RDES1_IPPE_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES1_IPPE_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES1_IPPE_HBIT_POS, RX_NORMAL_DESC_RDES1_IPPE_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES1_IPCB_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES1_IPCB_HBIT_POS, RX_NORMAL_DESC_RDES1_IPCB_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES1_IPCB_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES1_IPCB_HBIT_POS, RX_NORMAL_DESC_RDES1_IPCB_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES1_IPV6_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES1_IPV6_HBIT_POS, RX_NORMAL_DESC_RDES1_IPV6_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES1_IPV6_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES1_IPV6_HBIT_POS, RX_NORMAL_DESC_RDES1_IPV6_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES1_IPV4_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES1_IPV4_HBIT_POS, RX_NORMAL_DESC_RDES1_IPV4_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES1_IPV4_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES1_IPV4_HBIT_POS, RX_NORMAL_DESC_RDES1_IPV4_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES1_IPHE_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES1_IPHE_HBIT_POS, RX_NORMAL_DESC_RDES1_IPHE_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES1_IPHE_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES1_IPHE_HBIT_POS, RX_NORMAL_DESC_RDES1_IPHE_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES1_PT_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES1_PT_HBIT_POS, RX_NORMAL_DESC_RDES1_PT_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES1_PT_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES1_PT_HBIT_POS, RX_NORMAL_DESC_RDES1_PT_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES0_HDR_B1AP_MLF_RD(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES0_HDR_B1AP_HBIT_POS, RX_NORMAL_DESC_RDES0_HDR_B1AP_LBIT_POS, ptr, data); \
} while (0)

#define RX_NORMAL_DESC_RDES0_HDR_B1AP_MLF_WR(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES0_HDR_B1AP_HBIT_POS, RX_NORMAL_DESC_RDES0_HDR_B1AP_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES3_OWN_MLF_RD(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES3_OWN_HBIT_POS, TX_NORMAL_DESC_TDES3_OWN_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES3_OWN_MLF_WR(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES3_OWN_HBIT_POS, TX_NORMAL_DESC_TDES3_OWN_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES3_CTXT_MLF_RD(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES3_CTXT_HBIT_POS, TX_NORMAL_DESC_TDES3_CTXT_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES3_CTXT_MLF_WR(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES3_CTXT_HBIT_POS, TX_NORMAL_DESC_TDES3_CTXT_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES3_FD_MLF_RD(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES3_FD_HBIT_POS, TX_NORMAL_DESC_TDES3_FD_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES3_FD_MLF_WR(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES3_FD_HBIT_POS, TX_NORMAL_DESC_TDES3_FD_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES3_LD_MLF_RD(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES3_LD_HBIT_POS, TX_NORMAL_DESC_TDES3_LD_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES3_LD_MLF_WR(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES3_LD_HBIT_POS, TX_NORMAL_DESC_TDES3_LD_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES3_CPC_MLF_RD(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES3_CPC_HBIT_POS, TX_NORMAL_DESC_TDES3_CPC_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES3_CPC_MLF_WR(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES3_CPC_HBIT_POS, TX_NORMAL_DESC_TDES3_CPC_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES3_SAIC_MLF_RD(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES3_SAIC_HBIT_POS, TX_NORMAL_DESC_TDES3_SAIC_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES3_SAIC_MLF_WR(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES3_SAIC_HBIT_POS, TX_NORMAL_DESC_TDES3_SAIC_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES3_SLOTNUM_TCPHDRLEN_MLF_RD(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES3_SLOTNUM_TCPHDRLEN_HBIT_POS, TX_NORMAL_DESC_TDES3_SLOTNUM_TCPHDRLEN_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES3_SLOTNUM_TCPHDRLEN_MLF_WR(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES3_SLOTNUM_TCPHDRLEN_HBIT_POS, TX_NORMAL_DESC_TDES3_SLOTNUM_TCPHDRLEN_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES3_TSE_MLF_RD(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES3_TSE_HBIT_POS, TX_NORMAL_DESC_TDES3_TSE_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES3_TSE_MLF_WR(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES3_TSE_HBIT_POS, TX_NORMAL_DESC_TDES3_TSE_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES3_CIC_MLF_RD(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES3_CIC_HBIT_POS, TX_NORMAL_DESC_TDES3_CIC_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES3_CIC_MLF_WR(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES3_CIC_HBIT_POS, TX_NORMAL_DESC_TDES3_CIC_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES3_TIPLH_MLF_RD(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES3_TIPLH_HBIT_POS, TX_NORMAL_DESC_TDES3_TIPLH_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES3_TIPLH_MLF_WR(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES3_TIPLH_HBIT_POS, TX_NORMAL_DESC_TDES3_TIPLH_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES3_FL_MLF_RD(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES3_FL_HBIT_POS, TX_NORMAL_DESC_TDES3_FL_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES3_FL_MLF_WR(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES3_FL_HBIT_POS, TX_NORMAL_DESC_TDES3_FL_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES2_IC_MLF_RD(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES2_IC_HBIT_POS, TX_NORMAL_DESC_TDES2_IC_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES2_IC_MLF_WR(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES2_IC_HBIT_POS, TX_NORMAL_DESC_TDES2_IC_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES2_TTSE_MLF_RD(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES2_TTSE_HBIT_POS, TX_NORMAL_DESC_TDES2_TTSE_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES2_TTSE_MLF_WR(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES2_TTSE_HBIT_POS, TX_NORMAL_DESC_TDES2_TTSE_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES2_B2L_MLF_RD(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES2_B2L_HBIT_POS, TX_NORMAL_DESC_TDES2_B2L_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES2_B2L_MLF_WR(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES2_B2L_HBIT_POS, TX_NORMAL_DESC_TDES2_B2L_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES2_VTIR_MLF_RD(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES2_VTIR_HBIT_POS, TX_NORMAL_DESC_TDES2_VTIR_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES2_VTIR_MLF_WR(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES2_VTIR_HBIT_POS, TX_NORMAL_DESC_TDES2_VTIR_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES2_HL_B1L_MLF_RD(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES2_HL_B1L_HBIT_POS, TX_NORMAL_DESC_TDES2_HL_B1L_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES2_HL_B1L_MLF_WR(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES2_HL_B1L_HBIT_POS, TX_NORMAL_DESC_TDES2_HL_B1L_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES1_B2A_NDA_MLF_RD(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES1_B2A_NDA_HBIT_POS, TX_NORMAL_DESC_TDES1_B2A_NDA_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES1_B2A_NDA_MLF_WR(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES1_B2A_NDA_HBIT_POS, TX_NORMAL_DESC_TDES1_B2A_NDA_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES0_B1A_HAP_MLF_RD(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES0_B1A_HAP_HBIT_POS, TX_NORMAL_DESC_TDES0_B1A_HAP_LBIT_POS, ptr, data); \
} while (0)

#define TX_NORMAL_DESC_TDES0_B1A_HAP_MLF_WR(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES0_B1A_HAP_HBIT_POS, TX_NORMAL_DESC_TDES0_B1A_HAP_LBIT_POS, ptr, data); \
} while (0)

#define TX_ERROR_COUNTERS_TX_ERRORS_HEARTBEAT_ERROR_MLF_RD(ptr, data) do { \
  GET_BITS(TX_ERROR_COUNTERS_TX_ERRORS_HEARTBEAT_ERROR_HBIT_POS, TX_ERROR_COUNTERS_TX_ERRORS_HEARTBEAT_ERROR_LBIT_POS, ptr, data); \
} while (0)

#define TX_ERROR_COUNTERS_TX_ERRORS_HEARTBEAT_ERROR_MLF_WR(ptr, data) do { \
  SET_BITS(TX_ERROR_COUNTERS_TX_ERRORS_HEARTBEAT_ERROR_HBIT_POS, TX_ERROR_COUNTERS_TX_ERRORS_HEARTBEAT_ERROR_LBIT_POS, ptr, data); \
} while (0)

#define TX_ERROR_COUNTERS_TX_ERRORS_WINDOW_ERROR_MLF_RD(ptr, data) do { \
  GET_BITS(TX_ERROR_COUNTERS_TX_ERRORS_WINDOW_ERROR_HBIT_POS, TX_ERROR_COUNTERS_TX_ERRORS_WINDOW_ERROR_LBIT_POS, ptr, data); \
} while (0)

#define TX_ERROR_COUNTERS_TX_ERRORS_WINDOW_ERROR_MLF_WR(ptr, data) do { \
  SET_BITS(TX_ERROR_COUNTERS_TX_ERRORS_WINDOW_ERROR_HBIT_POS, TX_ERROR_COUNTERS_TX_ERRORS_WINDOW_ERROR_LBIT_POS, ptr, data); \
} while (0)

#define TX_ERROR_COUNTERS_TX_ERRORS_FIFO_ERROR_MLF_RD(ptr, data) do { \
  GET_BITS(TX_ERROR_COUNTERS_TX_ERRORS_FIFO_ERROR_HBIT_POS, TX_ERROR_COUNTERS_TX_ERRORS_FIFO_ERROR_LBIT_POS, ptr, data); \
} while (0)

#define TX_ERROR_COUNTERS_TX_ERRORS_FIFO_ERROR_MLF_WR(ptr, data) do { \
  SET_BITS(TX_ERROR_COUNTERS_TX_ERRORS_FIFO_ERROR_HBIT_POS, TX_ERROR_COUNTERS_TX_ERRORS_FIFO_ERROR_LBIT_POS, ptr, data); \
} while (0)

#define TX_ERROR_COUNTERS_TX_ERRORS_CARRIER_ERROR_MLF_RD(ptr, data) do { \
  GET_BITS(TX_ERROR_COUNTERS_TX_ERRORS_CARRIER_ERROR_HBIT_POS, TX_ERROR_COUNTERS_TX_ERRORS_CARRIER_ERROR_LBIT_POS, ptr, data); \
} while (0)

#define TX_ERROR_COUNTERS_TX_ERRORS_CARRIER_ERROR_MLF_WR(ptr, data) do { \
  SET_BITS(TX_ERROR_COUNTERS_TX_ERRORS_CARRIER_ERROR_HBIT_POS, TX_ERROR_COUNTERS_TX_ERRORS_CARRIER_ERROR_LBIT_POS, ptr, data); \
} while (0)

#define TX_ERROR_COUNTERS_TX_ERRORS_ABORTED_ERROR_MLF_RD(ptr, data) do { \
  GET_BITS(TX_ERROR_COUNTERS_TX_ERRORS_ABORTED_ERROR_HBIT_POS, TX_ERROR_COUNTERS_TX_ERRORS_ABORTED_ERROR_LBIT_POS, ptr, data); \
} while (0)

#define TX_ERROR_COUNTERS_TX_ERRORS_ABORTED_ERROR_MLF_WR(ptr, data) do { \
  SET_BITS(TX_ERROR_COUNTERS_TX_ERRORS_ABORTED_ERROR_HBIT_POS, TX_ERROR_COUNTERS_TX_ERRORS_ABORTED_ERROR_LBIT_POS, ptr, data); \
} while (0)

#define RX_ERROR_COUNTERS_RX_ERRORS_MISSED_ERROR_MLF_RD(ptr, data) do { \
  GET_BITS(RX_ERROR_COUNTERS_RX_ERRORS_MISSED_ERROR_HBIT_POS, RX_ERROR_COUNTERS_RX_ERRORS_MISSED_ERROR_LBIT_POS, ptr, data); \
} while (0)

#define RX_ERROR_COUNTERS_RX_ERRORS_MISSED_ERROR_MLF_WR(ptr, data) do { \
  SET_BITS(RX_ERROR_COUNTERS_RX_ERRORS_MISSED_ERROR_HBIT_POS, RX_ERROR_COUNTERS_RX_ERRORS_MISSED_ERROR_LBIT_POS, ptr, data); \
} while (0)

#define RX_ERROR_COUNTERS_RX_ERRORS_FIFO_ERROR_MLF_RD(ptr, data) do { \
  GET_BITS(RX_ERROR_COUNTERS_RX_ERRORS_FIFO_ERROR_HBIT_POS, RX_ERROR_COUNTERS_RX_ERRORS_FIFO_ERROR_LBIT_POS, ptr, data); \
} while (0)

#define RX_ERROR_COUNTERS_RX_ERRORS_FIFO_ERROR_MLF_WR(ptr, data) do { \
  SET_BITS(RX_ERROR_COUNTERS_RX_ERRORS_FIFO_ERROR_HBIT_POS, RX_ERROR_COUNTERS_RX_ERRORS_FIFO_ERROR_LBIT_POS, ptr, data); \
} while (0)

#define RX_ERROR_COUNTERS_RX_ERRORS_FRAME_ERROR_MLF_RD(ptr, data) do { \
  GET_BITS(RX_ERROR_COUNTERS_RX_ERRORS_FRAME_ERROR_HBIT_POS, RX_ERROR_COUNTERS_RX_ERRORS_FRAME_ERROR_LBIT_POS, ptr, data); \
} while (0)

#define RX_ERROR_COUNTERS_RX_ERRORS_FRAME_ERROR_MLF_WR(ptr, data) do { \
  SET_BITS(RX_ERROR_COUNTERS_RX_ERRORS_FRAME_ERROR_HBIT_POS, RX_ERROR_COUNTERS_RX_ERRORS_FRAME_ERROR_LBIT_POS, ptr, data); \
} while (0)

#define RX_ERROR_COUNTERS_RX_ERRORS_CRC_ERROR_MLF_RD(ptr, data) do { \
  GET_BITS(RX_ERROR_COUNTERS_RX_ERRORS_CRC_ERROR_HBIT_POS, RX_ERROR_COUNTERS_RX_ERRORS_CRC_ERROR_LBIT_POS, ptr, data); \
} while (0)

#define RX_ERROR_COUNTERS_RX_ERRORS_CRC_ERROR_MLF_WR(ptr, data) do { \
  SET_BITS(RX_ERROR_COUNTERS_RX_ERRORS_CRC_ERROR_HBIT_POS, RX_ERROR_COUNTERS_RX_ERRORS_CRC_ERROR_LBIT_POS, ptr, data); \
} while (0)

#define RX_ERROR_COUNTERS_RX_ERRORS_OVERRUN_ERROR_MLF_RD(ptr, data) do { \
  GET_BITS(RX_ERROR_COUNTERS_RX_ERRORS_OVERRUN_ERROR_HBIT_POS, RX_ERROR_COUNTERS_RX_ERRORS_OVERRUN_ERROR_LBIT_POS, ptr, data); \
} while (0)

#define RX_ERR_COUNTERS_RX_ERR_OVERRUN_ERR_MLF_WR(ptr, data) do { \
  SET_BITS(RX_ERROR_COUNTERS_RX_ERRORS_OVERRUN_ERROR_HBIT_POS, RX_ERROR_COUNTERS_RX_ERRORS_OVERRUN_ERROR_LBIT_POS, ptr, data); \
} while (0)

#define RX_ERROR_COUNTERS_RX_ERRORS_LENGTH_ERROR_MLF_RD(ptr, data) do { \
  GET_BITS(RX_ERROR_COUNTERS_RX_ERRORS_LENGTH_ERROR_HBIT_POS, RX_ERROR_COUNTERS_RX_ERRORS_LENGTH_ERROR_LBIT_POS, ptr, data); \
} while (0)

#define RX_ERROR_COUNTERS_RX_ERRORS_LENGTH_ERROR_MLF_WR(ptr, data) do { \
  SET_BITS(RX_ERROR_COUNTERS_RX_ERRORS_LENGTH_ERROR_HBIT_POS, RX_ERROR_COUNTERS_RX_ERRORS_LENGTH_ERROR_LBIT_POS, ptr, data); \
} while (0)

#define RX_PKT_FEATURES_VLAN_TAG_SVT_MLF_RD(ptr, data) do { \
  GET_BITS(RX_PKT_FEATURES_VLAN_TAG_SVT_HBIT_POS, RX_PKT_FEATURES_VLAN_TAG_SVT_LBIT_POS, ptr, data); \
} while (0)

#define RX_PKT_FEATURES_VLAN_TAG_SVT_MLF_WR(ptr, data) do { \
  SET_BITS(RX_PKT_FEATURES_VLAN_TAG_SVT_HBIT_POS, RX_PKT_FEATURES_VLAN_TAG_SVT_LBIT_POS, ptr, data); \
} while (0)

#define RX_PKT_FEATURES_VLAN_TAG_VT_MLF_RD(ptr, data) do { \
  GET_BITS(RX_PKT_FEATURES_VLAN_TAG_VT_HBIT_POS, RX_PKT_FEATURES_VLAN_TAG_VT_LBIT_POS, ptr, data); \
} while (0)

#define RX_PKT_FEATURES_VLAN_TAG_VT_MLF_WR(ptr, data) do { \
  SET_BITS(RX_PKT_FEATURES_VLAN_TAG_VT_HBIT_POS, RX_PKT_FEATURES_VLAN_TAG_VT_LBIT_POS, ptr, data); \
} while (0)

#define RX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_MLF_RD(ptr, data) do { \
  GET_BITS(RX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_HBIT_POS, RX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_LBIT_POS, ptr, data); \
} while (0)

#define RX_PKT_ATTR_VLAN_PKT_MLF_WR(ptr, data) do { \
  SET_BITS(RX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_HBIT_POS, RX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_LBIT_POS, ptr, data); \
} while (0)

#define RX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_DONE_MLF_RD(ptr, data) do { \
  GET_BITS(RX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_DONE_HBIT_POS, RX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_DONE_LBIT_POS, ptr, data); \
} while (0)

#define RX_PKT_ATTR_CSUM_DONE_MLF_WR(ptr, data) do { \
  SET_BITS(RX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_DONE_HBIT_POS, RX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_DONE_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_TCP_HDR_LEN_LEN_MLF_RD(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_TCP_HDR_LEN_LEN_HBIT_POS, TX_PKT_FEATURES_TCP_HDR_LEN_LEN_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_TCP_HDR_LEN_MLF_WR(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_TCP_HDR_LEN_LEN_HBIT_POS, TX_PKT_FEATURES_TCP_HDR_LEN_LEN_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_PKT_TYPE_TCP_PKT_MLF_RD(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_PKT_TYPE_TCP_PKT_HBIT_POS, TX_PKT_FEATURES_PKT_TYPE_TCP_PKT_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_PKT_TYPE_TCP_PKT_MLF_WR(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_PKT_TYPE_TCP_PKT_HBIT_POS, TX_PKT_FEATURES_PKT_TYPE_TCP_PKT_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_PKT_TYPE_IP_PKT_MLF_RD(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_PKT_TYPE_IP_PKT_HBIT_POS, TX_PKT_FEATURES_PKT_TYPE_IP_PKT_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_PKT_TYPE_IP_PKT_MLF_WR(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_PKT_TYPE_IP_PKT_HBIT_POS, TX_PKT_FEATURES_PKT_TYPE_IP_PKT_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_TUCSE_TCPCSE_MLF_RD(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_TUCSE_TCPCSE_HBIT_POS, TX_PKT_FEATURES_TUCSE_TCPCSE_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_TUCSE_TCPCSE_MLF_WR(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_TUCSE_TCPCSE_HBIT_POS, TX_PKT_FEATURES_TUCSE_TCPCSE_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_TUCSO_TCPCSO_MLF_RD(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_TUCSO_TCPCSO_HBIT_POS, TX_PKT_FEATURES_TUCSO_TCPCSO_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_TUCSO_TCPCSO_MLF_WR(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_TUCSO_TCPCSO_HBIT_POS, TX_PKT_FEATURES_TUCSO_TCPCSO_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_TUCSS_TCPCSS_MLF_RD(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_TUCSS_TCPCSS_HBIT_POS, TX_PKT_FEATURES_TUCSS_TCPCSS_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_TUCSS_TCPCSS_MLF_WR(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_TUCSS_TCPCSS_HBIT_POS, TX_PKT_FEATURES_TUCSS_TCPCSS_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_IPCSE_IPCSE_MLF_RD(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_IPCSE_IPCSE_HBIT_POS, TX_PKT_FEATURES_IPCSE_IPCSE_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_IPCSE_IPCSE_MLF_WR(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_IPCSE_IPCSE_HBIT_POS, TX_PKT_FEATURES_IPCSE_IPCSE_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_IPCSO_IPCSO_MLF_RD(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_IPCSO_IPCSO_HBIT_POS, TX_PKT_FEATURES_IPCSO_IPCSO_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_IPCSO_IPCSO_MLF_WR(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_IPCSO_IPCSO_HBIT_POS, TX_PKT_FEATURES_IPCSO_IPCSO_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_IPCSS_IPCSS_MLF_RD(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_IPCSS_IPCSS_HBIT_POS, TX_PKT_FEATURES_IPCSS_IPCSS_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_IPCSS_IPCSS_MLF_WR(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_IPCSS_IPCSS_HBIT_POS, TX_PKT_FEATURES_IPCSS_IPCSS_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_PAY_LEN_PAY_LEN_MLF_RD(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_PAY_LEN_PAY_LEN_HBIT_POS, TX_PKT_FEATURES_PAY_LEN_PAY_LEN_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_PAY_LEN_PAY_LEN_MLF_WR(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_PAY_LEN_PAY_LEN_HBIT_POS, TX_PKT_FEATURES_PAY_LEN_PAY_LEN_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_HDR_LEN_HDR_LEN_MLF_RD(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_HDR_LEN_HDR_LEN_HBIT_POS, TX_PKT_FEATURES_HDR_LEN_HDR_LEN_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_HDR_LEN_HDR_LEN_MLF_WR(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_HDR_LEN_HDR_LEN_HBIT_POS, TX_PKT_FEATURES_HDR_LEN_HDR_LEN_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_MSS_MSS_MLF_RD(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_MSS_MSS_HBIT_POS, TX_PKT_FEATURES_MSS_MSS_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_MSS_MSS_MLF_WR(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_MSS_MSS_HBIT_POS, TX_PKT_FEATURES_MSS_MSS_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_VLAN_TAG_SVT_MLF_RD(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_VLAN_TAG_SVT_HBIT_POS, TX_PKT_FEATURES_VLAN_TAG_SVT_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_VLAN_TAG_SVT_MLF_WR(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_VLAN_TAG_SVT_HBIT_POS, TX_PKT_FEATURES_VLAN_TAG_SVT_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_VLAN_TAG_VT_MLF_RD(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_VLAN_TAG_VT_HBIT_POS, TX_PKT_FEATURES_VLAN_TAG_VT_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_VLAN_TAG_VT_MLF_WR(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_VLAN_TAG_VT_HBIT_POS, TX_PKT_FEATURES_VLAN_TAG_VT_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_MLF_RD(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_HBIT_POS, TX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_MLF_WR(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_HBIT_POS, TX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_PKT_ATTRIBUTES_PTP_ENABLE_MLF_RD(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_PKT_ATTRIBUTES_PTP_ENABLE_HBIT_POS, TX_PKT_FEATURES_PKT_ATTRIBUTES_PTP_ENABLE_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_PKT_ATTRIBUTES_PTP_ENABLE_MLF_WR(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_PKT_ATTRIBUTES_PTP_ENABLE_HBIT_POS, TX_PKT_FEATURES_PKT_ATTRIBUTES_PTP_ENABLE_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_PKT_ATTRIBUTES_TSO_ENABLE_MLF_RD(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_PKT_ATTRIBUTES_TSO_ENABLE_HBIT_POS, TX_PKT_FEATURES_PKT_ATTRIBUTES_TSO_ENABLE_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_PKT_ATTRIBUTES_TSO_ENABLE_MLF_WR(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_PKT_ATTRIBUTES_TSO_ENABLE_HBIT_POS, TX_PKT_FEATURES_PKT_ATTRIBUTES_TSO_ENABLE_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_ENABLE_MLF_RD(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_ENABLE_HBIT_POS, TX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_ENABLE_LBIT_POS, ptr, data); \
} while (0)

#define TX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_ENABLE_MLF_WR(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_ENABLE_HBIT_POS, TX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_ENABLE_LBIT_POS, ptr, data); \
} while (0)

/* virtual_registers Register Read-Write Macros */
#define RX_CONTEXT_DESC_RDES3_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define RX_CONTEXT_DESC_RDES3_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define RX_CONTEXT_DESC_RDES2_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define RX_CONTEXT_DESC_RDES2_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define RX_CONTEXT_DESC_RDES1_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define RX_CONTEXT_DESC_RDES1_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define RX_CONTEXT_DESC_RDES0_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define RX_CONTEXT_DESC_RDES0_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define TX_CONTEXT_DESC_TDES3_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define TX_CONTEXT_DESC_TDES3_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define TX_CONTEXT_DESC_TDES2_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define TX_CONTEXT_DESC_TDES2_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define TX_CONTEXT_DESC_TDES1_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define TX_CONTEXT_DESC_TDES1_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define TX_CONTEXT_DESC_TDES0_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define TX_CONTEXT_DESC_TDES0_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define RX_NORMAL_DESC_RDES3_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define RX_NORMAL_DESC_RDES3_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define RX_NORMAL_DESC_RDES2_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define RX_NORMAL_DESC_RDES2_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define RX_NORMAL_DESC_RDES1_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define RX_NORMAL_DESC_RDES1_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define RX_NORMAL_DESC_RDES0_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define RX_NORMAL_DESC_RDES0_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define RX_NORMAL_DESC_TX_ERRORS_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define RX_NORMAL_DESC_TX_ERRORS_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define RX_NORMAL_DESC_RX_BUF_PTR_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define RX_NORMAL_DESC_RX_BUF_PTR_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define RX_NORMAL_DESC_NEXT_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define RX_NORMAL_DESC_NEXT_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define RX_NORMAL_DESC_SKB_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define RX_NORMAL_DESC_SKB_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define TX_NORMAL_DESC_TDES3_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define TX_NORMAL_DESC_TDES3_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define TX_NORMAL_DESC_TDES2_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define TX_NORMAL_DESC_TDES2_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define TX_NORMAL_DESC_TDES1_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define TX_NORMAL_DESC_TDES1_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define TX_NORMAL_DESC_TDES0_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define TX_NORMAL_DESC_TDES0_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define TX_NORMAL_DESC_TX_BUF_PTR_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define TX_NORMAL_DESC_TX_BUF_PTR_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define TX_NORMAL_DESC_NEXT_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define TX_NORMAL_DESC_NEXT_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define TX_ERROR_COUNTERS_TX_ERRORS_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define TX_ERROR_COUNTERS_TX_ERRORS_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define RX_ERROR_COUNTERS_RX_ERRORS_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define RX_ERROR_COUNTERS_RX_ERRORS_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define RX_PKT_FEATURES_VLAN_TAG_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define RX_PKT_FEATURES_VLAN_TAG_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define RX_PKT_FEATURES_PKT_ATTRIBUTES_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define RX_PKT_FEATURES_PKT_ATTRIBUTES_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define TX_PKT_FEATURES_TCP_HDR_LEN_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define TX_PKT_FEATURES_TCP_HDR_LEN_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define TX_PKT_FEATURES_PKT_TYPE_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define TX_PKT_FEATURES_PKT_TYPE_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define TX_PKT_FEATURES_TUCSE_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define TX_PKT_FEATURES_TUCSE_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define TX_PKT_FEATURES_TUCSO_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define TX_PKT_FEATURES_TUCSO_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define TX_PKT_FEATURES_TUCSS_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define TX_PKT_FEATURES_TUCSS_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define TX_PKT_FEATURES_IPCSE_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define TX_PKT_FEATURES_IPCSE_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define TX_PKT_FEATURES_IPCSO_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define TX_PKT_FEATURES_IPCSO_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define TX_PKT_FEATURES_IPCSS_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define TX_PKT_FEATURES_IPCSS_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define TX_PKT_FEATURES_PAY_LEN_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define TX_PKT_FEATURES_PAY_LEN_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define TX_PKT_FEATURES_HDR_LEN_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define TX_PKT_FEATURES_HDR_LEN_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define TX_PKT_FEATURES_MSS_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define TX_PKT_FEATURES_MSS_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define TX_PKT_FEATURES_VLAN_TAG_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define TX_PKT_FEATURES_VLAN_TAG_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define TX_PKT_FEATURES_PKT_ATTRIBUTES_ML_RD(ptr, data) do { \
	data = ptr; \
} while (0)

#define TX_PKT_FEATURES_PKT_ATTRIBUTES_ML_WR(ptr, data) do { \
	ptr = data; \
} while (0)

#define  BASE_ADDRESS dwc_eth_qos_base_addr
#ifdef DWC_ETH_QOS_VER_4_0
#define MAC_ARPA_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x0ae0))
#else
#define MAC_ARPA_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x0210))
#endif

#define MAC_ARPA_RGWR(data) do {\
		iowrite32(data, (void *)MAC_ARPA_RGOFFADDR);\
} while (0)

#define MAC_ARPA_RGRD(data) do {\
		(data) = ioread32((void *)MAC_ARPA_RGOFFADDR);\
} while (0)

#define MAC_ARPA_ARPPA_UDFWR(data) do {\
		MAC_ARPA_RGWR(data);\
} while (0)

#define MAC_ARPA_ARPPA_UDFRD(data) do {\
		MAC_ARPA_RGRD(data);\
} while (0)

#define MAC_L3A3R7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xa6c))

#define MAC_L3A3R7_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A3R7_RGOFFADDR);\
} while (0)

#define MAC_L3A3R7_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A3R7_RGOFFADDR);\
} while (0)

#define MAC_L3A3R7_L3A30_UDFWR(data) do {\
		MAC_L3A3R7_RGWR(data);\
} while (0)

#define MAC_L3A3R7_L3A30_UDFRD(data) do {\
		MAC_L3A3R7_RGRD(data);\
} while (0)

#define MAC_L3A3R6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xa3c))

#define MAC_L3A3R6_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A3R6_RGOFFADDR);\
} while (0)

#define MAC_L3A3R6_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A3R6_RGOFFADDR);\
} while (0)

#define MAC_L3A3R6_L3A30_UDFWR(data) do {\
		MAC_L3A3R6_RGWR(data);\
} while (0)

#define MAC_L3A3R6_L3A30_UDFRD(data) do {\
		MAC_L3A3R6_RGRD(data);\
} while (0)

#define MAC_L3A3R5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xa0c))

#define MAC_L3A3R5_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A3R5_RGOFFADDR);\
} while (0)

#define MAC_L3A3R5_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A3R5_RGOFFADDR);\
} while (0)

#define MAC_L3A3R5_L3A30_UDFWR(data) do {\
		MAC_L3A3R5_RGWR(data);\
} while (0)

#define MAC_L3A3R5_L3A30_UDFRD(data) do {\
		MAC_L3A3R5_RGRD(data);\
} while (0)

#define MAC_L3A3R4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x9dc))

#define MAC_L3A3R4_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A3R4_RGOFFADDR);\
} while (0)

#define MAC_L3A3R4_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A3R4_RGOFFADDR);\
} while (0)

#define MAC_L3A3R4_L3A30_UDFWR(data) do {\
		MAC_L3A3R4_RGWR(data);\
} while (0)

#define MAC_L3A3R4_L3A30_UDFRD(data) do {\
		MAC_L3A3R4_RGRD(data);\
} while (0)

#define MAC_L3A3R3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x9ac))

#define MAC_L3A3R3_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A3R3_RGOFFADDR);\
} while (0)

#define MAC_L3A3R3_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A3R3_RGOFFADDR);\
} while (0)

#define MAC_L3A3R3_L3A30_UDFWR(data) do {\
		MAC_L3A3R3_RGWR(data);\
} while (0)

#define MAC_L3A3R3_L3A30_UDFRD(data) do {\
		MAC_L3A3R3_RGRD(data);\
} while (0)

#define MAC_L3A3R2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x97c))

#define MAC_L3A3R2_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A3R2_RGOFFADDR);\
} while (0)

#define MAC_L3A3R2_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A3R2_RGOFFADDR);\
} while (0)

#define MAC_L3A3R2_L3A30_UDFWR(data) do {\
		MAC_L3A3R2_RGWR(data);\
} while (0)

#define MAC_L3A3R2_L3A30_UDFRD(data) do {\
		MAC_L3A3R2_RGRD(data);\
} while (0)

#define MAC_L3A3R1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x94c))

#define MAC_L3A3R1_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A3R1_RGOFFADDR);\
} while (0)

#define MAC_L3A3R1_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A3R1_RGOFFADDR);\
} while (0)

#define MAC_L3A3R1_L3A30_UDFWR(data) do {\
		MAC_L3A3R1_RGWR(data);\
} while (0)

#define MAC_L3A3R1_L3A30_UDFRD(data) do {\
		MAC_L3A3R1_RGRD(data);\
} while (0)

#define MAC_L3A3R0_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x91c))

#define MAC_L3A3R0_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A3R0_RGOFFADDR);\
} while (0)

#define MAC_L3A3R0_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A3R0_RGOFFADDR);\
} while (0)

#define MAC_L3A3R0_L3A30_UDFWR(data) do {\
		MAC_L3A3R0_RGWR(data);\
} while (0)

#define MAC_L3A3R0_L3A30_UDFRD(data) do {\
		MAC_L3A3R0_RGRD(data);\
} while (0)

#define MAC_L3A2R7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xa68))

#define MAC_L3A2R7_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A2R7_RGOFFADDR);\
} while (0)

#define MAC_L3A2R7_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A2R7_RGOFFADDR);\
} while (0)

#define MAC_L3A2R7_L3A20_UDFWR(data) do {\
		MAC_L3A2R7_RGWR(data);\
} while (0)

#define MAC_L3A2R7_L3A20_UDFRD(data) do {\
		MAC_L3A2R7_RGRD(data);\
} while (0)

#define MAC_L3A2R6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xa38))

#define MAC_L3A2R6_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A2R6_RGOFFADDR);\
} while (0)

#define MAC_L3A2R6_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A2R6_RGOFFADDR);\
} while (0)

#define MAC_L3A2R6_L3A20_UDFWR(data) do {\
		MAC_L3A2R6_RGWR(data);\
} while (0)

#define MAC_L3A2R6_L3A20_UDFRD(data) do {\
		MAC_L3A2R6_RGRD(data);\
} while (0)

#define MAC_L3A2R5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xa08))

#define MAC_L3A2R5_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A2R5_RGOFFADDR);\
} while (0)

#define MAC_L3A2R5_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A2R5_RGOFFADDR);\
} while (0)

#define MAC_L3A2R5_L3A20_UDFWR(data) do {\
		MAC_L3A2R5_RGWR(data);\
} while (0)

#define MAC_L3A2R5_L3A20_UDFRD(data) do {\
		MAC_L3A2R5_RGRD(data);\
} while (0)

#define MAC_L3A2R4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x9d8))

#define MAC_L3A2R4_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A2R4_RGOFFADDR);\
} while (0)

#define MAC_L3A2R4_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A2R4_RGOFFADDR);\
} while (0)

#define MAC_L3A2R4_L3A20_UDFWR(data) do {\
		MAC_L3A2R4_RGWR(data);\
} while (0)

#define MAC_L3A2R4_L3A20_UDFRD(data) do {\
		MAC_L3A2R4_RGRD(data);\
} while (0)

#define MAC_L3A2R3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x9a8))

#define MAC_L3A2R3_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A2R3_RGOFFADDR);\
} while (0)

#define MAC_L3A2R3_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A2R3_RGOFFADDR);\
} while (0)

#define MAC_L3A2R3_L3A20_UDFWR(data) do {\
		MAC_L3A2R3_RGWR(data);\
} while (0)

#define MAC_L3A2R3_L3A20_UDFRD(data) do {\
		MAC_L3A2R3_RGRD(data);\
} while (0)

#define MAC_L3A2R2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x978))

#define MAC_L3A2R2_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A2R2_RGOFFADDR);\
} while (0)

#define MAC_L3A2R2_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A2R2_RGOFFADDR);\
} while (0)

#define MAC_L3A2R2_L3A20_UDFWR(data) do {\
		MAC_L3A2R2_RGWR(data);\
} while (0)

#define MAC_L3A2R2_L3A20_UDFRD(data) do {\
		MAC_L3A2R2_RGRD(data);\
} while (0)

#define MAC_L3A2R1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x948))

#define MAC_L3A2R1_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A2R1_RGOFFADDR);\
} while (0)

#define MAC_L3A2R1_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A2R1_RGOFFADDR);\
} while (0)

#define MAC_L3A2R1_L3A20_UDFWR(data) do {\
		MAC_L3A2R1_RGWR(data);\
} while (0)

#define MAC_L3A2R1_L3A20_UDFRD(data) do {\
		MAC_L3A2R1_RGRD(data);\
} while (0)

#define MAC_L3A2R0_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x918))

#define MAC_L3A2R0_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A2R0_RGOFFADDR);\
} while (0)

#define MAC_L3A2R0_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A2R0_RGOFFADDR);\
} while (0)

#define MAC_L3A2R0_L3A20_UDFWR(data) do {\
		MAC_L3A2R0_RGWR(data);\
} while (0)

#define MAC_L3A2R0_L3A20_UDFRD(data) do {\
		MAC_L3A2R0_RGRD(data);\
} while (0)

#define MAC_L3A1R7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xa64))

#define MAC_L3A1R7_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A1R7_RGOFFADDR);\
} while (0)

#define MAC_L3A1R7_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A1R7_RGOFFADDR);\
} while (0)

#define MAC_L3A1R7_L3A10_UDFWR(data) do {\
		MAC_L3A1R7_RGWR(data);\
} while (0)

#define MAC_L3A1R7_L3A10_UDFRD(data) do {\
		MAC_L3A1R7_RGRD(data);\
} while (0)

#define MAC_L3A1R6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xa34))

#define MAC_L3A1R6_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A1R6_RGOFFADDR);\
} while (0)

#define MAC_L3A1R6_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A1R6_RGOFFADDR);\
} while (0)

#define MAC_L3A1R6_L3A10_UDFWR(data) do {\
		MAC_L3A1R6_RGWR(data);\
} while (0)

#define MAC_L3A1R6_L3A10_UDFRD(data) do {\
		MAC_L3A1R6_RGRD(data);\
} while (0)

#define MAC_L3A1R5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xa04))

#define MAC_L3A1R5_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A1R5_RGOFFADDR);\
} while (0)

#define MAC_L3A1R5_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A1R5_RGOFFADDR);\
} while (0)

#define MAC_L3A1R5_L3A10_UDFWR(data) do {\
		MAC_L3A1R5_RGWR(data);\
} while (0)

#define MAC_L3A1R5_L3A10_UDFRD(data) do {\
		MAC_L3A1R5_RGRD(data);\
} while (0)

#define MAC_L3A1R4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x9d4))

#define MAC_L3A1R4_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A1R4_RGOFFADDR);\
} while (0)

#define MAC_L3A1R4_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A1R4_RGOFFADDR);\
} while (0)

#define MAC_L3A1R4_L3A10_UDFWR(data) do {\
		MAC_L3A1R4_RGWR(data);\
} while (0)

#define MAC_L3A1R4_L3A10_UDFRD(data) do {\
		MAC_L3A1R4_RGRD(data);\
} while (0)

#define MAC_L3A1R3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x9a4))

#define MAC_L3A1R3_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A1R3_RGOFFADDR);\
} while (0)

#define MAC_L3A1R3_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A1R3_RGOFFADDR);\
} while (0)

#define MAC_L3A1R3_L3A10_UDFWR(data) do {\
		MAC_L3A1R3_RGWR(data);\
} while (0)

#define MAC_L3A1R3_L3A10_UDFRD(data) do {\
		MAC_L3A1R3_RGRD(data);\
} while (0)

#define MAC_L3A1R2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x974))

#define MAC_L3A1R2_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A1R2_RGOFFADDR);\
} while (0)

#define MAC_L3A1R2_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A1R2_RGOFFADDR);\
} while (0)

#define MAC_L3A1R2_L3A10_UDFWR(data) do {\
		MAC_L3A1R2_RGWR(data);\
} while (0)

#define MAC_L3A1R2_L3A10_UDFRD(data) do {\
		MAC_L3A1R2_RGRD(data);\
} while (0)

#define MAC_L3A1R1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x944))

#define MAC_L3A1R1_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A1R1_RGOFFADDR);\
} while (0)

#define MAC_L3A1R1_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A1R1_RGOFFADDR);\
} while (0)

#define MAC_L3A1R1_L3A10_UDFWR(data) do {\
		MAC_L3A1R1_RGWR(data);\
} while (0)

#define MAC_L3A1R1_L3A10_UDFRD(data) do {\
		MAC_L3A1R1_RGRD(data);\
} while (0)

#define MAC_L3A1R0_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x914))

#define MAC_L3A1R0_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A1R0_RGOFFADDR);\
} while (0)

#define MAC_L3A1R0_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A1R0_RGOFFADDR);\
} while (0)

#define MAC_L3A1R0_L3A10_UDFWR(data) do {\
		MAC_L3A1R0_RGWR(data);\
} while (0)

#define MAC_L3A1R0_L3A10_UDFRD(data) do {\
		MAC_L3A1R0_RGRD(data);\
} while (0)

#define MAC_L3A0R7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xa60))

#define MAC_L3A0R7_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A0R7_RGOFFADDR);\
} while (0)

#define MAC_L3A0R7_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A0R7_RGOFFADDR);\
} while (0)

#define MAC_L3A0R7_L3A00_UDFWR(data) do {\
		MAC_L3A0R7_RGWR(data);\
} while (0)

#define MAC_L3A0R7_L3A00_UDFRD(data) do {\
		MAC_L3A0R7_RGRD(data);\
} while (0)

#define MAC_L3A0R6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xa30))

#define MAC_L3A0R6_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A0R6_RGOFFADDR);\
} while (0)

#define MAC_L3A0R6_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A0R6_RGOFFADDR);\
} while (0)

#define MAC_L3A0R6_L3A00_UDFWR(data) do {\
		MAC_L3A0R6_RGWR(data);\
} while (0)

#define MAC_L3A0R6_L3A00_UDFRD(data) do {\
		MAC_L3A0R6_RGRD(data);\
} while (0)

#define MAC_L3A0R5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xa00))

#define MAC_L3A0R5_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A0R5_RGOFFADDR);\
} while (0)

#define MAC_L3A0R5_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A0R5_RGOFFADDR);\
} while (0)

#define MAC_L3A0R5_L3A00_UDFWR(data) do {\
		MAC_L3A0R5_RGWR(data);\
} while (0)

#define MAC_L3A0R5_L3A00_UDFRD(data) do {\
		MAC_L3A0R5_RGRD(data);\
} while (0)

#define MAC_L3A0R4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x9d0))

#define MAC_L3A0R4_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A0R4_RGOFFADDR);\
} while (0)

#define MAC_L3A0R4_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A0R4_RGOFFADDR);\
} while (0)

#define MAC_L3A0R4_L3A00_UDFWR(data) do {\
		MAC_L3A0R4_RGWR(data);\
} while (0)

#define MAC_L3A0R4_L3A00_UDFRD(data) do {\
		MAC_L3A0R4_RGRD(data);\
} while (0)

#define MAC_L3A0R3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x9a0))

#define MAC_L3A0R3_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A0R3_RGOFFADDR);\
} while (0)

#define MAC_L3A0R3_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A0R3_RGOFFADDR);\
} while (0)

#define MAC_L3A0R3_L3A00_UDFWR(data) do {\
		MAC_L3A0R3_RGWR(data);\
} while (0)

#define MAC_L3A0R3_L3A00_UDFRD(data) do {\
		MAC_L3A0R3_RGRD(data);\
} while (0)

#define MAC_L3A0R2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x970))

#define MAC_L3A0R2_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A0R2_RGOFFADDR);\
} while (0)

#define MAC_L3A0R2_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A0R2_RGOFFADDR);\
} while (0)

#define MAC_L3A0R2_L3A00_UDFWR(data) do {\
		MAC_L3A0R2_RGWR(data);\
} while (0)

#define MAC_L3A0R2_L3A00_UDFRD(data) do {\
		MAC_L3A0R2_RGRD(data);\
} while (0)

#define MAC_L3A0R1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x940))

#define MAC_L3A0R1_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A0R1_RGOFFADDR);\
} while (0)

#define MAC_L3A0R1_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A0R1_RGOFFADDR);\
} while (0)

#define MAC_L3A0R1_L3A00_UDFWR(data) do {\
		MAC_L3A0R1_RGWR(data);\
} while (0)

#define MAC_L3A0R1_L3A00_UDFRD(data) do {\
		MAC_L3A0R1_RGRD(data);\
} while (0)

#define MAC_L3A0R0_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x910))

#define MAC_L3A0R0_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3A0R0_RGOFFADDR);\
} while (0)

#define MAC_L3A0R0_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3A0R0_RGOFFADDR);\
} while (0)

#define MAC_L3A0R0_L3A00_UDFWR(data) do {\
		MAC_L3A0R0_RGWR(data);\
} while (0)

#define MAC_L3A0R0_L3A00_UDFRD(data) do {\
		MAC_L3A0R0_RGRD(data);\
} while (0)

#define MAC_L4AR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xa54))

#define MAC_L4AR7_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L4AR7_RGOFFADDR);\
} while (0)

#define MAC_L4AR7_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L4AR7_RGOFFADDR);\
} while (0)

/*#define MAC_L4AR7_L4SP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR7_L4SP0_MASK (ULONG)(0xffff)

/*#define MAC_L4AR7_L4SP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_L4AR7_L4SP0_WR_MASK (ULONG)(0xffff0000)

#define MAC_L4AR7_L4SP0_UDFWR(data) do {\
		ULONG v;\
		MAC_L4AR7_RGRD(v);\
		v = ((v & MAC_L4AR7_L4SP0_WR_MASK) | ((data & MAC_L4AR7_L4SP0_MASK) << 0));\
		MAC_L4AR7_RGWR(v);\
} while (0)

#define MAC_L4AR7_L4SP0_UDFRD(data) do {\
		MAC_L4AR7_RGRD(data);\
		data = ((data >> 0) & MAC_L4AR7_L4SP0_MASK);\
} while (0)

/*#define MAC_L4AR7_L4DP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR7_L4DP0_MASK (ULONG)(0xffff)

/*#define MAC_L4AR7_L4DP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_L4AR7_L4DP0_WR_MASK (ULONG)(0xffff)

#define MAC_L4AR7_L4DP0_UDFWR(data) do {\
		ULONG v;\
		MAC_L4AR7_RGRD(v);\
		v = ((v & MAC_L4AR7_L4DP0_WR_MASK) | ((data & MAC_L4AR7_L4DP0_MASK) << 16));\
		MAC_L4AR7_RGWR(v);\
} while (0)

#define MAC_L4AR7_L4DP0_UDFRD(data) do {\
		MAC_L4AR7_RGRD(data);\
		data = ((data >> 16) & MAC_L4AR7_L4DP0_MASK);\
} while (0)

#define MAC_L4AR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xa24))

#define MAC_L4AR6_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L4AR6_RGOFFADDR);\
} while (0)

#define MAC_L4AR6_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L4AR6_RGOFFADDR);\
} while (0)

/*#define MAC_L4AR6_L4SP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR6_L4SP0_MASK (ULONG)(0xffff)

/*#define MAC_L4AR6_L4SP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_L4AR6_L4SP0_WR_MASK (ULONG)(0xffff0000)

#define MAC_L4AR6_L4SP0_UDFWR(data) do {\
		ULONG v;\
		MAC_L4AR6_RGRD(v);\
		v = ((v & MAC_L4AR6_L4SP0_WR_MASK) | ((data & MAC_L4AR6_L4SP0_MASK) << 0));\
		MAC_L4AR6_RGWR(v);\
} while (0)

#define MAC_L4AR6_L4SP0_UDFRD(data) do {\
		MAC_L4AR6_RGRD(data);\
		data = ((data >> 0) & MAC_L4AR6_L4SP0_MASK);\
} while (0)

/*#define MAC_L4AR6_L4DP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR6_L4DP0_MASK (ULONG)(0xffff)

/*#define MAC_L4AR6_L4DP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_L4AR6_L4DP0_WR_MASK (ULONG)(0xffff)

#define MAC_L4AR6_L4DP0_UDFWR(data) do {\
		ULONG v;\
		MAC_L4AR6_RGRD(v);\
		v = ((v & MAC_L4AR6_L4DP0_WR_MASK) | ((data & MAC_L4AR6_L4DP0_MASK) << 16));\
		MAC_L4AR6_RGWR(v);\
} while (0)

#define MAC_L4AR6_L4DP0_UDFRD(data) do {\
		MAC_L4AR6_RGRD(data);\
		data = ((data >> 16) & MAC_L4AR6_L4DP0_MASK);\
} while (0)

#define MAC_L4AR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x9f4))

#define MAC_L4AR5_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L4AR5_RGOFFADDR);\
} while (0)

#define MAC_L4AR5_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L4AR5_RGOFFADDR);\
} while (0)

/*#define MAC_L4AR5_L4SP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR5_L4SP0_MASK (ULONG)(0xffff)

/*#define MAC_L4AR5_L4SP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_L4AR5_L4SP0_WR_MASK (ULONG)(0xffff0000)

#define MAC_L4AR5_L4SP0_UDFWR(data) do {\
		ULONG v;\
		MAC_L4AR5_RGRD(v);\
		v = ((v & MAC_L4AR5_L4SP0_WR_MASK) | ((data & MAC_L4AR5_L4SP0_MASK) << 0));\
		MAC_L4AR5_RGWR(v);\
} while (0)

#define MAC_L4AR5_L4SP0_UDFRD(data) do {\
		MAC_L4AR5_RGRD(data);\
		data = ((data >> 0) & MAC_L4AR5_L4SP0_MASK);\
} while (0)

/*#define MAC_L4AR5_L4DP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR5_L4DP0_MASK (ULONG)(0xffff)

/*#define MAC_L4AR5_L4DP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_L4AR5_L4DP0_WR_MASK (ULONG)(0xffff)

#define MAC_L4AR5_L4DP0_UDFWR(data) do {\
		ULONG v;\
		MAC_L4AR5_RGRD(v);\
		v = ((v & MAC_L4AR5_L4DP0_WR_MASK) | ((data & MAC_L4AR5_L4DP0_MASK) << 16));\
		MAC_L4AR5_RGWR(v);\
} while (0)

#define MAC_L4AR5_L4DP0_UDFRD(data) do {\
		MAC_L4AR5_RGRD(data);\
		data = ((data >> 16) & MAC_L4AR5_L4DP0_MASK);\
} while (0)

#define MAC_L4AR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x9c4))

#define MAC_L4AR4_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L4AR4_RGOFFADDR);\
} while (0)

#define MAC_L4AR4_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L4AR4_RGOFFADDR);\
} while (0)

/*#define MAC_L4AR4_L4SP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR4_L4SP0_MASK (ULONG)(0xffff)

/*#define MAC_L4AR4_L4SP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_L4AR4_L4SP0_WR_MASK (ULONG)(0xffff0000)

#define MAC_L4AR4_L4SP0_UDFWR(data) do {\
		ULONG v;\
		MAC_L4AR4_RGRD(v);\
		v = ((v & MAC_L4AR4_L4SP0_WR_MASK) | ((data & MAC_L4AR4_L4SP0_MASK) << 0));\
		MAC_L4AR4_RGWR(v);\
} while (0)

#define MAC_L4AR4_L4SP0_UDFRD(data) do {\
		MAC_L4AR4_RGRD(data);\
		data = ((data >> 0) & MAC_L4AR4_L4SP0_MASK);\
} while (0)

/*#define MAC_L4AR4_L4DP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR4_L4DP0_MASK (ULONG)(0xffff)

/*#define MAC_L4AR4_L4DP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_L4AR4_L4DP0_WR_MASK (ULONG)(0xffff)

#define MAC_L4AR4_L4DP0_UDFWR(data) do {\
		ULONG v;\
		MAC_L4AR4_RGRD(v);\
		v = ((v & MAC_L4AR4_L4DP0_WR_MASK) | ((data & MAC_L4AR4_L4DP0_MASK) << 16));\
		MAC_L4AR4_RGWR(v);\
} while (0)

#define MAC_L4AR4_L4DP0_UDFRD(data) do {\
		MAC_L4AR4_RGRD(data);\
		data = ((data >> 16) & MAC_L4AR4_L4DP0_MASK);\
} while (0)

#define MAC_L4AR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x994))

#define MAC_L4AR3_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L4AR3_RGOFFADDR);\
} while (0)

#define MAC_L4AR3_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L4AR3_RGOFFADDR);\
} while (0)

/*#define MAC_L4AR3_L4SP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR3_L4SP0_MASK (ULONG)(0xffff)

/*#define MAC_L4AR3_L4SP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_L4AR3_L4SP0_WR_MASK (ULONG)(0xffff0000)

#define MAC_L4AR3_L4SP0_UDFWR(data) do {\
		ULONG v;\
		MAC_L4AR3_RGRD(v);\
		v = ((v & MAC_L4AR3_L4SP0_WR_MASK) | ((data & MAC_L4AR3_L4SP0_MASK) << 0));\
		MAC_L4AR3_RGWR(v);\
} while (0)

#define MAC_L4AR3_L4SP0_UDFRD(data) do {\
		MAC_L4AR3_RGRD(data);\
		data = ((data >> 0) & MAC_L4AR3_L4SP0_MASK);\
} while (0)

/*#define MAC_L4AR3_L4DP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR3_L4DP0_MASK (ULONG)(0xffff)

/*#define MAC_L4AR3_L4DP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_L4AR3_L4DP0_WR_MASK (ULONG)(0xffff)

#define MAC_L4AR3_L4DP0_UDFWR(data) do {\
		ULONG v;\
		MAC_L4AR3_RGRD(v);\
		v = ((v & MAC_L4AR3_L4DP0_WR_MASK) | ((data & MAC_L4AR3_L4DP0_MASK) << 16));\
		MAC_L4AR3_RGWR(v);\
} while (0)

#define MAC_L4AR3_L4DP0_UDFRD(data) do {\
		MAC_L4AR3_RGRD(data);\
		data = ((data >> 16) & MAC_L4AR3_L4DP0_MASK);\
} while (0)

#define MAC_L4AR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x964))

#define MAC_L4AR2_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L4AR2_RGOFFADDR);\
} while (0)

#define MAC_L4AR2_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L4AR2_RGOFFADDR);\
} while (0)

/*#define MAC_L4AR2_L4SP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR2_L4SP0_MASK (ULONG)(0xffff)

/*#define MAC_L4AR2_L4SP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_L4AR2_L4SP0_WR_MASK (ULONG)(0xffff0000)

#define MAC_L4AR2_L4SP0_UDFWR(data) do {\
		ULONG v;\
		MAC_L4AR2_RGRD(v);\
		v = ((v & MAC_L4AR2_L4SP0_WR_MASK) | ((data & MAC_L4AR2_L4SP0_MASK) << 0));\
		MAC_L4AR2_RGWR(v);\
} while (0)

#define MAC_L4AR2_L4SP0_UDFRD(data) do {\
		MAC_L4AR2_RGRD(data);\
		data = ((data >> 0) & MAC_L4AR2_L4SP0_MASK);\
} while (0)

/*#define MAC_L4AR2_L4DP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR2_L4DP0_MASK (ULONG)(0xffff)

/*#define MAC_L4AR2_L4DP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_L4AR2_L4DP0_WR_MASK (ULONG)(0xffff)

#define MAC_L4AR2_L4DP0_UDFWR(data) do {\
		ULONG v;\
		MAC_L4AR2_RGRD(v);\
		v = ((v & MAC_L4AR2_L4DP0_WR_MASK) | ((data & MAC_L4AR2_L4DP0_MASK) << 16));\
		MAC_L4AR2_RGWR(v);\
} while (0)

#define MAC_L4AR2_L4DP0_UDFRD(data) do {\
		MAC_L4AR2_RGRD(data);\
		data = ((data >> 16) & MAC_L4AR2_L4DP0_MASK);\
} while (0)

#define MAC_L4AR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x934))

#define MAC_L4AR1_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L4AR1_RGOFFADDR);\
} while (0)

#define MAC_L4AR1_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L4AR1_RGOFFADDR);\
} while (0)

/*#define MAC_L4AR1_L4SP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR1_L4SP0_MASK (ULONG)(0xffff)

/*#define MAC_L4AR1_L4SP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_L4AR1_L4SP0_WR_MASK (ULONG)(0xffff0000)

#define MAC_L4AR1_L4SP0_UDFWR(data) do {\
		ULONG v;\
		MAC_L4AR1_RGRD(v);\
		v = ((v & MAC_L4AR1_L4SP0_WR_MASK) | ((data & MAC_L4AR1_L4SP0_MASK) << 0));\
		MAC_L4AR1_RGWR(v);\
} while (0)

#define MAC_L4AR1_L4SP0_UDFRD(data) do {\
		MAC_L4AR1_RGRD(data);\
		data = ((data >> 0) & MAC_L4AR1_L4SP0_MASK);\
} while (0)

/*#define MAC_L4AR1_L4DP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR1_L4DP0_MASK (ULONG)(0xffff)

/*#define MAC_L4AR1_L4DP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_L4AR1_L4DP0_WR_MASK (ULONG)(0xffff)

#define MAC_L4AR1_L4DP0_UDFWR(data) do {\
		ULONG v;\
		MAC_L4AR1_RGRD(v);\
		v = ((v & MAC_L4AR1_L4DP0_WR_MASK) | ((data & MAC_L4AR1_L4DP0_MASK) << 16));\
		MAC_L4AR1_RGWR(v);\
} while (0)

#define MAC_L4AR1_L4DP0_UDFRD(data) do {\
		MAC_L4AR1_RGRD(data);\
		data = ((data >> 16) & MAC_L4AR1_L4DP0_MASK);\
} while (0)

#define MAC_L4AR0_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x904))

#define MAC_L4AR0_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L4AR0_RGOFFADDR);\
} while (0)

#define MAC_L4AR0_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L4AR0_RGOFFADDR);\
} while (0)

/*#define MAC_L4AR0_L4SP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR0_L4SP0_MASK (ULONG)(0xffff)

/*#define MAC_L4AR0_L4SP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_L4AR0_L4SP0_WR_MASK (ULONG)(0xffff0000)

#define MAC_L4AR0_L4SP0_UDFWR(data) do {\
		ULONG v;\
		MAC_L4AR0_RGRD(v);\
		v = ((v & MAC_L4AR0_L4SP0_WR_MASK) | ((data & MAC_L4AR0_L4SP0_MASK) << 0));\
		MAC_L4AR0_RGWR(v);\
} while (0)

#define MAC_L4AR0_L4SP0_UDFRD(data) do {\
		MAC_L4AR0_RGRD(data);\
		data = ((data >> 0) & MAC_L4AR0_L4SP0_MASK);\
} while (0)

/*#define MAC_L4AR0_L4DP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR0_L4DP0_MASK (ULONG)(0xffff)

/*#define MAC_L4AR0_L4DP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_L4AR0_L4DP0_WR_MASK (ULONG)(0xffff)

#define MAC_L4AR0_L4DP0_UDFWR(data) do {\
		ULONG v;\
		MAC_L4AR0_RGRD(v);\
		v = ((v & MAC_L4AR0_L4DP0_WR_MASK) | ((data & MAC_L4AR0_L4DP0_MASK) << 16));\
		MAC_L4AR0_RGWR(v);\
} while (0)

#define MAC_L4AR0_L4DP0_UDFRD(data) do {\
		MAC_L4AR0_RGRD(data);\
		data = ((data >> 16) & MAC_L4AR0_L4DP0_MASK);\
} while (0)

#define MAC_L3L4CR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xa50))

#define MAC_L3L4CR7_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3L4CR7_RGOFFADDR);\
} while (0)

#define MAC_L3L4CR7_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3L4CR7_RGOFFADDR);\
} while (0)

/*#define  MAC_L3L4CR7_Mask_1 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR7_MASK_1 (ULONG)(0x1)

/*#define MAC_L3L4CR7_RES_Wr_Mask_1 (ULONG)(~((~(~0<<(1)))<<(1)))*/

#define MAC_L3L4CR7_RES_WR_MASK_1 (ULONG)(0xfffffffd)

/*#define  MAC_L3L4CR7_Mask_17 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR7_MASK_17 (ULONG)(0x1)

/*#define MAC_L3L4CR7_RES_Wr_Mask_17 (ULONG)(~((~(~0<<(1)))<<(17)))*/

#define MAC_L3L4CR7_RES_WR_MASK_17 (ULONG)(0xfffdffff)

/*#define  MAC_L3L4CR7_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  MAC_L3L4CR7_MASK_22 (ULONG)(0x3ff)

/*#define MAC_L3L4CR7_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define MAC_L3L4CR7_RES_WR_MASK_22 (ULONG)(0x3fffff)

/*#define MAC_L3L4CR7_L3PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR7_L3PEN0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR7_L3PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_L3L4CR7_L3PEN0_WR_MASK (ULONG)(0xfffffffe)

#define MAC_L3L4CR7_L3PEN0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR7_RGRD(v);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR7_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR7_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR7_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR7_L3PEN0_WR_MASK) | ((data & MAC_L3L4CR7_L3PEN0_MASK) << 0));\
		MAC_L3L4CR7_RGWR(v);\
} while (0)

#define MAC_L3L4CR7_L3PEN0_UDFRD(data) do {\
		MAC_L3L4CR7_RGRD(data);\
		data = ((data >> 0) & MAC_L3L4CR7_L3PEN0_MASK);\
} while (0)

/*#define MAC_L3L4CR7_L3SAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR7_L3SAM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR7_L3SAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MAC_L3L4CR7_L3SAM0_WR_MASK (ULONG)(0xfffffffb)

#define MAC_L3L4CR7_L3SAM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR7_RGRD(v);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR7_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR7_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR7_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR7_L3SAM0_WR_MASK) | ((data & MAC_L3L4CR7_L3SAM0_MASK) << 2));\
		MAC_L3L4CR7_RGWR(v);\
} while (0)

#define MAC_L3L4CR7_L3SAM0_UDFRD(data) do {\
		MAC_L3L4CR7_RGRD(data);\
		data = ((data >> 2) & MAC_L3L4CR7_L3SAM0_MASK);\
} while (0)

/*#define MAC_L3L4CR7_L3SAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR7_L3SAIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR7_L3SAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MAC_L3L4CR7_L3SAIM0_WR_MASK (ULONG)(0xfffffff7)

#define MAC_L3L4CR7_L3SAIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR7_RGRD(v);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR7_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR7_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR7_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR7_L3SAIM0_WR_MASK) | ((data & MAC_L3L4CR7_L3SAIM0_MASK) << 3));\
		MAC_L3L4CR7_RGWR(v);\
} while (0)

#define MAC_L3L4CR7_L3SAIM0_UDFRD(data) do {\
		MAC_L3L4CR7_RGRD(data);\
		data = ((data >> 3) & MAC_L3L4CR7_L3SAIM0_MASK);\
} while (0)

/*#define MAC_L3L4CR7_L3DAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR7_L3DAM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR7_L3DAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MAC_L3L4CR7_L3DAM0_WR_MASK (ULONG)(0xffffffef)

#define MAC_L3L4CR7_L3DAM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR7_RGRD(v);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR7_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR7_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR7_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR7_L3DAM0_WR_MASK) | ((data & MAC_L3L4CR7_L3DAM0_MASK) << 4));\
		MAC_L3L4CR7_RGWR(v);\
} while (0)

#define MAC_L3L4CR7_L3DAM0_UDFRD(data) do {\
		MAC_L3L4CR7_RGRD(data);\
		data = ((data >> 4) & MAC_L3L4CR7_L3DAM0_MASK);\
} while (0)

/*#define MAC_L3L4CR7_L3DAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR7_L3DAIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR7_L3DAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MAC_L3L4CR7_L3DAIM0_WR_MASK (ULONG)(0xffffffdf)

#define MAC_L3L4CR7_L3DAIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR7_RGRD(v);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR7_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR7_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR7_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR7_L3DAIM0_WR_MASK) | ((data & MAC_L3L4CR7_L3DAIM0_MASK) << 5));\
		MAC_L3L4CR7_RGWR(v);\
} while (0)

#define MAC_L3L4CR7_L3DAIM0_UDFRD(data) do {\
		MAC_L3L4CR7_RGRD(data);\
		data = ((data >> 5) & MAC_L3L4CR7_L3DAIM0_MASK);\
} while (0)

/*#define MAC_L3L4CR7_L3HSBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR7_L3HSBM0_MASK (ULONG)(0x1f)

/*#define MAC_L3L4CR7_L3HSBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (6)))*/

#define MAC_L3L4CR7_L3HSBM0_WR_MASK (ULONG)(0xfffff83f)

#define MAC_L3L4CR7_L3HSBM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR7_RGRD(v);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR7_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR7_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR7_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR7_L3HSBM0_WR_MASK) | ((data & MAC_L3L4CR7_L3HSBM0_MASK) << 6));\
		MAC_L3L4CR7_RGWR(v);\
} while (0)

#define MAC_L3L4CR7_L3HSBM0_UDFRD(data) do {\
		MAC_L3L4CR7_RGRD(data);\
		data = ((data >> 6) & MAC_L3L4CR7_L3HSBM0_MASK);\
} while (0)

/*#define MAC_L3L4CR7_L3HDBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR7_L3HDBM0_MASK (ULONG)(0x1f)

/*#define MAC_L3L4CR7_L3HDBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (11)))*/

#define MAC_L3L4CR7_L3HDBM0_WR_MASK (ULONG)(0xffff07ff)

#define MAC_L3L4CR7_L3HDBM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR7_RGRD(v);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR7_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR7_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR7_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR7_L3HDBM0_WR_MASK) | ((data & MAC_L3L4CR7_L3HDBM0_MASK) << 11));\
		MAC_L3L4CR7_RGWR(v);\
} while (0)

#define MAC_L3L4CR7_L3HDBM0_UDFRD(data) do {\
		MAC_L3L4CR7_RGRD(data);\
		data = ((data >> 11) & MAC_L3L4CR7_L3HDBM0_MASK);\
} while (0)

/*#define MAC_L3L4CR7_L4PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR7_L4PEN0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR7_L4PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MAC_L3L4CR7_L4PEN0_WR_MASK (ULONG)(0xfffeffff)

#define MAC_L3L4CR7_L4PEN0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR7_RGRD(v);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR7_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR7_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR7_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR7_L4PEN0_WR_MASK) | ((data & MAC_L3L4CR7_L4PEN0_MASK) << 16));\
		MAC_L3L4CR7_RGWR(v);\
} while (0)

#define MAC_L3L4CR7_L4PEN0_UDFRD(data) do {\
		MAC_L3L4CR7_RGRD(data);\
		data = ((data >> 16) & MAC_L3L4CR7_L4PEN0_MASK);\
} while (0)

/*#define MAC_L3L4CR7_L4SPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR7_L4SPM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR7_L4SPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MAC_L3L4CR7_L4SPM0_WR_MASK (ULONG)(0xfffbffff)

#define MAC_L3L4CR7_L4SPM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR7_RGRD(v);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR7_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR7_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR7_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR7_L4SPM0_WR_MASK) | ((data & MAC_L3L4CR7_L4SPM0_MASK) << 18));\
		MAC_L3L4CR7_RGWR(v);\
} while (0)

#define MAC_L3L4CR7_L4SPM0_UDFRD(data) do {\
		MAC_L3L4CR7_RGRD(data);\
		data = ((data >> 18) & MAC_L3L4CR7_L4SPM0_MASK);\
} while (0)

/*#define MAC_L3L4CR7_L4SPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR7_L4SPIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR7_L4SPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MAC_L3L4CR7_L4SPIM0_WR_MASK (ULONG)(0xfff7ffff)

#define MAC_L3L4CR7_L4SPIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR7_RGRD(v);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR7_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR7_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR7_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR7_L4SPIM0_WR_MASK) | ((data & MAC_L3L4CR7_L4SPIM0_MASK) << 19));\
		MAC_L3L4CR7_RGWR(v);\
} while (0)

#define MAC_L3L4CR7_L4SPIM0_UDFRD(data) do {\
		MAC_L3L4CR7_RGRD(data);\
		data = ((data >> 19) & MAC_L3L4CR7_L4SPIM0_MASK);\
} while (0)

/*#define MAC_L3L4CR7_L4DPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR7_L4DPM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR7_L4DPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MAC_L3L4CR7_L4DPM0_WR_MASK (ULONG)(0xffefffff)

#define MAC_L3L4CR7_L4DPM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR7_RGRD(v);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR7_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR7_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR7_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR7_L4DPM0_WR_MASK) | ((data & MAC_L3L4CR7_L4DPM0_MASK) << 20));\
		MAC_L3L4CR7_RGWR(v);\
} while (0)

#define MAC_L3L4CR7_L4DPM0_UDFRD(data) do {\
		MAC_L3L4CR7_RGRD(data);\
		data = ((data >> 20) & MAC_L3L4CR7_L4DPM0_MASK);\
} while (0)

/*#define MAC_L3L4CR7_L4DPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR7_L4DPIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR7_L4DPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (21)))*/

#define MAC_L3L4CR7_L4DPIM0_WR_MASK (ULONG)(0xffdfffff)

#define MAC_L3L4CR7_L4DPIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR7_RGRD(v);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR7_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR7_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR7_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR7_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR7_L4DPIM0_WR_MASK) | ((data & MAC_L3L4CR7_L4DPIM0_MASK) << 21));\
		MAC_L3L4CR7_RGWR(v);\
} while (0)

#define MAC_L3L4CR7_L4DPIM0_UDFRD(data) do {\
		MAC_L3L4CR7_RGRD(data);\
		data = ((data >> 21) & MAC_L3L4CR7_L4DPIM0_MASK);\
} while (0)

#define MAC_L3L4CR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xa20))

#define MAC_L3L4CR6_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3L4CR6_RGOFFADDR);\
} while (0)

#define MAC_L3L4CR6_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3L4CR6_RGOFFADDR);\
} while (0)

/*#define  MAC_L3L4CR6_Mask_1 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR6_MASK_1 (ULONG)(0x1)

/*#define MAC_L3L4CR6_RES_Wr_Mask_1 (ULONG)(~((~(~0<<(1)))<<(1)))*/

#define MAC_L3L4CR6_RES_WR_MASK_1 (ULONG)(0xfffffffd)

/*#define  MAC_L3L4CR6_Mask_17 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR6_MASK_17 (ULONG)(0x1)

/*#define MAC_L3L4CR6_RES_Wr_Mask_17 (ULONG)(~((~(~0<<(1)))<<(17)))*/

#define MAC_L3L4CR6_RES_WR_MASK_17 (ULONG)(0xfffdffff)

/*#define  MAC_L3L4CR6_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  MAC_L3L4CR6_MASK_22 (ULONG)(0x3ff)

/*#define MAC_L3L4CR6_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define MAC_L3L4CR6_RES_WR_MASK_22 (ULONG)(0x3fffff)

/*#define MAC_L3L4CR6_L3PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR6_L3PEN0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR6_L3PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_L3L4CR6_L3PEN0_WR_MASK (ULONG)(0xfffffffe)

#define MAC_L3L4CR6_L3PEN0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR6_RGRD(v);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR6_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR6_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR6_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR6_L3PEN0_WR_MASK) | ((data & MAC_L3L4CR6_L3PEN0_MASK) << 0));\
		MAC_L3L4CR6_RGWR(v);\
} while (0)

#define MAC_L3L4CR6_L3PEN0_UDFRD(data) do {\
		MAC_L3L4CR6_RGRD(data);\
		data = ((data >> 0) & MAC_L3L4CR6_L3PEN0_MASK);\
} while (0)

/*#define MAC_L3L4CR6_L3SAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR6_L3SAM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR6_L3SAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MAC_L3L4CR6_L3SAM0_WR_MASK (ULONG)(0xfffffffb)

#define MAC_L3L4CR6_L3SAM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR6_RGRD(v);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR6_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR6_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR6_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR6_L3SAM0_WR_MASK) | ((data & MAC_L3L4CR6_L3SAM0_MASK) << 2));\
		MAC_L3L4CR6_RGWR(v);\
} while (0)

#define MAC_L3L4CR6_L3SAM0_UDFRD(data) do {\
		MAC_L3L4CR6_RGRD(data);\
		data = ((data >> 2) & MAC_L3L4CR6_L3SAM0_MASK);\
} while (0)

/*#define MAC_L3L4CR6_L3SAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR6_L3SAIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR6_L3SAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MAC_L3L4CR6_L3SAIM0_WR_MASK (ULONG)(0xfffffff7)

#define MAC_L3L4CR6_L3SAIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR6_RGRD(v);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR6_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR6_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR6_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR6_L3SAIM0_WR_MASK) | ((data & MAC_L3L4CR6_L3SAIM0_MASK) << 3));\
		MAC_L3L4CR6_RGWR(v);\
} while (0)

#define MAC_L3L4CR6_L3SAIM0_UDFRD(data) do {\
		MAC_L3L4CR6_RGRD(data);\
		data = ((data >> 3) & MAC_L3L4CR6_L3SAIM0_MASK);\
} while (0)

/*#define MAC_L3L4CR6_L3DAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR6_L3DAM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR6_L3DAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MAC_L3L4CR6_L3DAM0_WR_MASK (ULONG)(0xffffffef)

#define MAC_L3L4CR6_L3DAM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR6_RGRD(v);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR6_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR6_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR6_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR6_L3DAM0_WR_MASK) | ((data & MAC_L3L4CR6_L3DAM0_MASK) << 4));\
		MAC_L3L4CR6_RGWR(v);\
} while (0)

#define MAC_L3L4CR6_L3DAM0_UDFRD(data) do {\
		MAC_L3L4CR6_RGRD(data);\
		data = ((data >> 4) & MAC_L3L4CR6_L3DAM0_MASK);\
} while (0)

/*#define MAC_L3L4CR6_L3DAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR6_L3DAIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR6_L3DAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MAC_L3L4CR6_L3DAIM0_WR_MASK (ULONG)(0xffffffdf)

#define MAC_L3L4CR6_L3DAIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR6_RGRD(v);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR6_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR6_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR6_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR6_L3DAIM0_WR_MASK) | ((data & MAC_L3L4CR6_L3DAIM0_MASK) << 5));\
		MAC_L3L4CR6_RGWR(v);\
} while (0)

#define MAC_L3L4CR6_L3DAIM0_UDFRD(data) do {\
		MAC_L3L4CR6_RGRD(data);\
		data = ((data >> 5) & MAC_L3L4CR6_L3DAIM0_MASK);\
} while (0)

/*#define MAC_L3L4CR6_L3HSBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR6_L3HSBM0_MASK (ULONG)(0x1f)

/*#define MAC_L3L4CR6_L3HSBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (6)))*/

#define MAC_L3L4CR6_L3HSBM0_WR_MASK (ULONG)(0xfffff83f)

#define MAC_L3L4CR6_L3HSBM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR6_RGRD(v);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR6_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR6_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR6_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR6_L3HSBM0_WR_MASK) | ((data & MAC_L3L4CR6_L3HSBM0_MASK) << 6));\
		MAC_L3L4CR6_RGWR(v);\
} while (0)

#define MAC_L3L4CR6_L3HSBM0_UDFRD(data) do {\
		MAC_L3L4CR6_RGRD(data);\
		data = ((data >> 6) & MAC_L3L4CR6_L3HSBM0_MASK);\
} while (0)

/*#define MAC_L3L4CR6_L3HDBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR6_L3HDBM0_MASK (ULONG)(0x1f)

/*#define MAC_L3L4CR6_L3HDBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (11)))*/

#define MAC_L3L4CR6_L3HDBM0_WR_MASK (ULONG)(0xffff07ff)

#define MAC_L3L4CR6_L3HDBM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR6_RGRD(v);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR6_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR6_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR6_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR6_L3HDBM0_WR_MASK) | ((data & MAC_L3L4CR6_L3HDBM0_MASK) << 11));\
		MAC_L3L4CR6_RGWR(v);\
} while (0)

#define MAC_L3L4CR6_L3HDBM0_UDFRD(data) do {\
		MAC_L3L4CR6_RGRD(data);\
		data = ((data >> 11) & MAC_L3L4CR6_L3HDBM0_MASK);\
} while (0)

/*#define MAC_L3L4CR6_L4PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR6_L4PEN0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR6_L4PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MAC_L3L4CR6_L4PEN0_WR_MASK (ULONG)(0xfffeffff)

#define MAC_L3L4CR6_L4PEN0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR6_RGRD(v);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR6_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR6_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR6_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR6_L4PEN0_WR_MASK) | ((data & MAC_L3L4CR6_L4PEN0_MASK) << 16));\
		MAC_L3L4CR6_RGWR(v);\
} while (0)

#define MAC_L3L4CR6_L4PEN0_UDFRD(data) do {\
		MAC_L3L4CR6_RGRD(data);\
		data = ((data >> 16) & MAC_L3L4CR6_L4PEN0_MASK);\
} while (0)

/*#define MAC_L3L4CR6_L4SPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR6_L4SPM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR6_L4SPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MAC_L3L4CR6_L4SPM0_WR_MASK (ULONG)(0xfffbffff)

#define MAC_L3L4CR6_L4SPM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR6_RGRD(v);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR6_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR6_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR6_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR6_L4SPM0_WR_MASK) | ((data & MAC_L3L4CR6_L4SPM0_MASK) << 18));\
		MAC_L3L4CR6_RGWR(v);\
} while (0)

#define MAC_L3L4CR6_L4SPM0_UDFRD(data) do {\
		MAC_L3L4CR6_RGRD(data);\
		data = ((data >> 18) & MAC_L3L4CR6_L4SPM0_MASK);\
} while (0)

/*#define MAC_L3L4CR6_L4SPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR6_L4SPIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR6_L4SPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MAC_L3L4CR6_L4SPIM0_WR_MASK (ULONG)(0xfff7ffff)

#define MAC_L3L4CR6_L4SPIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR6_RGRD(v);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR6_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR6_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR6_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR6_L4SPIM0_WR_MASK) | ((data & MAC_L3L4CR6_L4SPIM0_MASK) << 19));\
		MAC_L3L4CR6_RGWR(v);\
} while (0)

#define MAC_L3L4CR6_L4SPIM0_UDFRD(data) do {\
		MAC_L3L4CR6_RGRD(data);\
		data = ((data >> 19) & MAC_L3L4CR6_L4SPIM0_MASK);\
} while (0)

/*#define MAC_L3L4CR6_L4DPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR6_L4DPM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR6_L4DPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MAC_L3L4CR6_L4DPM0_WR_MASK (ULONG)(0xffefffff)

#define MAC_L3L4CR6_L4DPM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR6_RGRD(v);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR6_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR6_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR6_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR6_L4DPM0_WR_MASK) | ((data & MAC_L3L4CR6_L4DPM0_MASK) << 20));\
		MAC_L3L4CR6_RGWR(v);\
} while (0)

#define MAC_L3L4CR6_L4DPM0_UDFRD(data) do {\
		MAC_L3L4CR6_RGRD(data);\
		data = ((data >> 20) & MAC_L3L4CR6_L4DPM0_MASK);\
} while (0)

/*#define MAC_L3L4CR6_L4DPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR6_L4DPIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR6_L4DPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (21)))*/

#define MAC_L3L4CR6_L4DPIM0_WR_MASK (ULONG)(0xffdfffff)

#define MAC_L3L4CR6_L4DPIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR6_RGRD(v);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR6_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR6_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR6_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR6_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR6_L4DPIM0_WR_MASK) | ((data & MAC_L3L4CR6_L4DPIM0_MASK) << 21));\
		MAC_L3L4CR6_RGWR(v);\
} while (0)

#define MAC_L3L4CR6_L4DPIM0_UDFRD(data) do {\
		MAC_L3L4CR6_RGRD(data);\
		data = ((data >> 21) & MAC_L3L4CR6_L4DPIM0_MASK);\
} while (0)

#define MAC_L3L4CR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x9f0))

#define MAC_L3L4CR5_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3L4CR5_RGOFFADDR);\
} while (0)

#define MAC_L3L4CR5_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3L4CR5_RGOFFADDR);\
} while (0)

/*#define  MAC_L3L4CR5_Mask_1 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR5_MASK_1 (ULONG)(0x1)

/*#define MAC_L3L4CR5_RES_Wr_Mask_1 (ULONG)(~((~(~0<<(1)))<<(1)))*/

#define MAC_L3L4CR5_RES_WR_MASK_1 (ULONG)(0xfffffffd)

/*#define  MAC_L3L4CR5_Mask_17 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR5_MASK_17 (ULONG)(0x1)

/*#define MAC_L3L4CR5_RES_Wr_Mask_17 (ULONG)(~((~(~0<<(1)))<<(17)))*/

#define MAC_L3L4CR5_RES_WR_MASK_17 (ULONG)(0xfffdffff)

/*#define  MAC_L3L4CR5_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  MAC_L3L4CR5_MASK_22 (ULONG)(0x3ff)

/*#define MAC_L3L4CR5_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define MAC_L3L4CR5_RES_WR_MASK_22 (ULONG)(0x3fffff)

/*#define MAC_L3L4CR5_L3PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR5_L3PEN0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR5_L3PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_L3L4CR5_L3PEN0_WR_MASK (ULONG)(0xfffffffe)

#define MAC_L3L4CR5_L3PEN0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR5_RGRD(v);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR5_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR5_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR5_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR5_L3PEN0_WR_MASK) | ((data & MAC_L3L4CR5_L3PEN0_MASK) << 0));\
		MAC_L3L4CR5_RGWR(v);\
} while (0)

#define MAC_L3L4CR5_L3PEN0_UDFRD(data) do {\
		MAC_L3L4CR5_RGRD(data);\
		data = ((data >> 0) & MAC_L3L4CR5_L3PEN0_MASK);\
} while (0)

/*#define MAC_L3L4CR5_L3SAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR5_L3SAM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR5_L3SAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MAC_L3L4CR5_L3SAM0_WR_MASK (ULONG)(0xfffffffb)

#define MAC_L3L4CR5_L3SAM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR5_RGRD(v);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR5_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR5_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR5_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR5_L3SAM0_WR_MASK) | ((data & MAC_L3L4CR5_L3SAM0_MASK) << 2));\
		MAC_L3L4CR5_RGWR(v);\
} while (0)

#define MAC_L3L4CR5_L3SAM0_UDFRD(data) do {\
		MAC_L3L4CR5_RGRD(data);\
		data = ((data >> 2) & MAC_L3L4CR5_L3SAM0_MASK);\
} while (0)

/*#define MAC_L3L4CR5_L3SAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR5_L3SAIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR5_L3SAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MAC_L3L4CR5_L3SAIM0_WR_MASK (ULONG)(0xfffffff7)

#define MAC_L3L4CR5_L3SAIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR5_RGRD(v);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR5_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR5_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR5_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR5_L3SAIM0_WR_MASK) | ((data & MAC_L3L4CR5_L3SAIM0_MASK) << 3));\
		MAC_L3L4CR5_RGWR(v);\
} while (0)

#define MAC_L3L4CR5_L3SAIM0_UDFRD(data) do {\
		MAC_L3L4CR5_RGRD(data);\
		data = ((data >> 3) & MAC_L3L4CR5_L3SAIM0_MASK);\
} while (0)

/*#define MAC_L3L4CR5_L3DAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR5_L3DAM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR5_L3DAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MAC_L3L4CR5_L3DAM0_WR_MASK (ULONG)(0xffffffef)

#define MAC_L3L4CR5_L3DAM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR5_RGRD(v);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR5_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR5_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR5_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR5_L3DAM0_WR_MASK) | ((data & MAC_L3L4CR5_L3DAM0_MASK) << 4));\
		MAC_L3L4CR5_RGWR(v);\
} while (0)

#define MAC_L3L4CR5_L3DAM0_UDFRD(data) do {\
		MAC_L3L4CR5_RGRD(data);\
		data = ((data >> 4) & MAC_L3L4CR5_L3DAM0_MASK);\
} while (0)

/*#define MAC_L3L4CR5_L3DAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR5_L3DAIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR5_L3DAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MAC_L3L4CR5_L3DAIM0_WR_MASK (ULONG)(0xffffffdf)

#define MAC_L3L4CR5_L3DAIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR5_RGRD(v);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR5_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR5_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR5_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR5_L3DAIM0_WR_MASK) | ((data & MAC_L3L4CR5_L3DAIM0_MASK) << 5));\
		MAC_L3L4CR5_RGWR(v);\
} while (0)

#define MAC_L3L4CR5_L3DAIM0_UDFRD(data) do {\
		MAC_L3L4CR5_RGRD(data);\
		data = ((data >> 5) & MAC_L3L4CR5_L3DAIM0_MASK);\
} while (0)

/*#define MAC_L3L4CR5_L3HSBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR5_L3HSBM0_MASK (ULONG)(0x1f)

/*#define MAC_L3L4CR5_L3HSBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (6)))*/

#define MAC_L3L4CR5_L3HSBM0_WR_MASK (ULONG)(0xfffff83f)

#define MAC_L3L4CR5_L3HSBM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR5_RGRD(v);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR5_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR5_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR5_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR5_L3HSBM0_WR_MASK) | ((data & MAC_L3L4CR5_L3HSBM0_MASK) << 6));\
		MAC_L3L4CR5_RGWR(v);\
} while (0)

#define MAC_L3L4CR5_L3HSBM0_UDFRD(data) do {\
		MAC_L3L4CR5_RGRD(data);\
		data = ((data >> 6) & MAC_L3L4CR5_L3HSBM0_MASK);\
} while (0)

/*#define MAC_L3L4CR5_L3HDBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR5_L3HDBM0_MASK (ULONG)(0x1f)

/*#define MAC_L3L4CR5_L3HDBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (11)))*/

#define MAC_L3L4CR5_L3HDBM0_WR_MASK (ULONG)(0xffff07ff)

#define MAC_L3L4CR5_L3HDBM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR5_RGRD(v);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR5_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR5_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR5_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR5_L3HDBM0_WR_MASK) | ((data & MAC_L3L4CR5_L3HDBM0_MASK) << 11));\
		MAC_L3L4CR5_RGWR(v);\
} while (0)

#define MAC_L3L4CR5_L3HDBM0_UDFRD(data) do {\
		MAC_L3L4CR5_RGRD(data);\
		data = ((data >> 11) & MAC_L3L4CR5_L3HDBM0_MASK);\
} while (0)

/*#define MAC_L3L4CR5_L4PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR5_L4PEN0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR5_L4PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MAC_L3L4CR5_L4PEN0_WR_MASK (ULONG)(0xfffeffff)

#define MAC_L3L4CR5_L4PEN0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR5_RGRD(v);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR5_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR5_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR5_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR5_L4PEN0_WR_MASK) | ((data & MAC_L3L4CR5_L4PEN0_MASK) << 16));\
		MAC_L3L4CR5_RGWR(v);\
} while (0)

#define MAC_L3L4CR5_L4PEN0_UDFRD(data) do {\
		MAC_L3L4CR5_RGRD(data);\
		data = ((data >> 16) & MAC_L3L4CR5_L4PEN0_MASK);\
} while (0)

/*#define MAC_L3L4CR5_L4SPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR5_L4SPM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR5_L4SPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MAC_L3L4CR5_L4SPM0_WR_MASK (ULONG)(0xfffbffff)

#define MAC_L3L4CR5_L4SPM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR5_RGRD(v);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR5_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR5_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR5_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR5_L4SPM0_WR_MASK) | ((data & MAC_L3L4CR5_L4SPM0_MASK) << 18));\
		MAC_L3L4CR5_RGWR(v);\
} while (0)

#define MAC_L3L4CR5_L4SPM0_UDFRD(data) do {\
		MAC_L3L4CR5_RGRD(data);\
		data = ((data >> 18) & MAC_L3L4CR5_L4SPM0_MASK);\
} while (0)

/*#define MAC_L3L4CR5_L4SPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR5_L4SPIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR5_L4SPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MAC_L3L4CR5_L4SPIM0_WR_MASK (ULONG)(0xfff7ffff)

#define MAC_L3L4CR5_L4SPIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR5_RGRD(v);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR5_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR5_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR5_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR5_L4SPIM0_WR_MASK) | ((data & MAC_L3L4CR5_L4SPIM0_MASK) << 19));\
		MAC_L3L4CR5_RGWR(v);\
} while (0)

#define MAC_L3L4CR5_L4SPIM0_UDFRD(data) do {\
		MAC_L3L4CR5_RGRD(data);\
		data = ((data >> 19) & MAC_L3L4CR5_L4SPIM0_MASK);\
} while (0)

/*#define MAC_L3L4CR5_L4DPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR5_L4DPM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR5_L4DPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MAC_L3L4CR5_L4DPM0_WR_MASK (ULONG)(0xffefffff)

#define MAC_L3L4CR5_L4DPM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR5_RGRD(v);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR5_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR5_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR5_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR5_L4DPM0_WR_MASK) | ((data & MAC_L3L4CR5_L4DPM0_MASK) << 20));\
		MAC_L3L4CR5_RGWR(v);\
} while (0)

#define MAC_L3L4CR5_L4DPM0_UDFRD(data) do {\
		MAC_L3L4CR5_RGRD(data);\
		data = ((data >> 20) & MAC_L3L4CR5_L4DPM0_MASK);\
} while (0)

/*#define MAC_L3L4CR5_L4DPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR5_L4DPIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR5_L4DPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (21)))*/

#define MAC_L3L4CR5_L4DPIM0_WR_MASK (ULONG)(0xffdfffff)

#define MAC_L3L4CR5_L4DPIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR5_RGRD(v);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR5_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR5_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR5_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR5_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR5_L4DPIM0_WR_MASK) | ((data & MAC_L3L4CR5_L4DPIM0_MASK) << 21));\
		MAC_L3L4CR5_RGWR(v);\
} while (0)

#define MAC_L3L4CR5_L4DPIM0_UDFRD(data) do {\
		MAC_L3L4CR5_RGRD(data);\
		data = ((data >> 21) & MAC_L3L4CR5_L4DPIM0_MASK);\
} while (0)

#define MAC_L3L4CR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x9c0))

#define MAC_L3L4CR4_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3L4CR4_RGOFFADDR);\
} while (0)

#define MAC_L3L4CR4_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3L4CR4_RGOFFADDR);\
} while (0)

/*#define  MAC_L3L4CR4_Mask_1 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR4_MASK_1 (ULONG)(0x1)

/*#define MAC_L3L4CR4_RES_Wr_Mask_1 (ULONG)(~((~(~0<<(1)))<<(1)))*/

#define MAC_L3L4CR4_RES_WR_MASK_1 (ULONG)(0xfffffffd)

/*#define  MAC_L3L4CR4_Mask_17 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR4_MASK_17 (ULONG)(0x1)

/*#define MAC_L3L4CR4_RES_Wr_Mask_17 (ULONG)(~((~(~0<<(1)))<<(17)))*/

#define MAC_L3L4CR4_RES_WR_MASK_17 (ULONG)(0xfffdffff)

/*#define  MAC_L3L4CR4_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  MAC_L3L4CR4_MASK_22 (ULONG)(0x3ff)

/*#define MAC_L3L4CR4_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define MAC_L3L4CR4_RES_WR_MASK_22 (ULONG)(0x3fffff)

/*#define MAC_L3L4CR4_L3PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR4_L3PEN0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR4_L3PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_L3L4CR4_L3PEN0_WR_MASK (ULONG)(0xfffffffe)

#define MAC_L3L4CR4_L3PEN0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR4_RGRD(v);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR4_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR4_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR4_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR4_L3PEN0_WR_MASK) | ((data & MAC_L3L4CR4_L3PEN0_MASK) << 0));\
		MAC_L3L4CR4_RGWR(v);\
} while (0)

#define MAC_L3L4CR4_L3PEN0_UDFRD(data) do {\
		MAC_L3L4CR4_RGRD(data);\
		data = ((data >> 0) & MAC_L3L4CR4_L3PEN0_MASK);\
} while (0)

/*#define MAC_L3L4CR4_L3SAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR4_L3SAM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR4_L3SAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MAC_L3L4CR4_L3SAM0_WR_MASK (ULONG)(0xfffffffb)

#define MAC_L3L4CR4_L3SAM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR4_RGRD(v);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR4_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR4_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR4_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR4_L3SAM0_WR_MASK) | ((data & MAC_L3L4CR4_L3SAM0_MASK) << 2));\
		MAC_L3L4CR4_RGWR(v);\
} while (0)

#define MAC_L3L4CR4_L3SAM0_UDFRD(data) do {\
		MAC_L3L4CR4_RGRD(data);\
		data = ((data >> 2) & MAC_L3L4CR4_L3SAM0_MASK);\
} while (0)

/*#define MAC_L3L4CR4_L3SAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR4_L3SAIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR4_L3SAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MAC_L3L4CR4_L3SAIM0_WR_MASK (ULONG)(0xfffffff7)

#define MAC_L3L4CR4_L3SAIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR4_RGRD(v);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR4_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR4_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR4_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR4_L3SAIM0_WR_MASK) | ((data & MAC_L3L4CR4_L3SAIM0_MASK) << 3));\
		MAC_L3L4CR4_RGWR(v);\
} while (0)

#define MAC_L3L4CR4_L3SAIM0_UDFRD(data) do {\
		MAC_L3L4CR4_RGRD(data);\
		data = ((data >> 3) & MAC_L3L4CR4_L3SAIM0_MASK);\
} while (0)

/*#define MAC_L3L4CR4_L3DAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR4_L3DAM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR4_L3DAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MAC_L3L4CR4_L3DAM0_WR_MASK (ULONG)(0xffffffef)

#define MAC_L3L4CR4_L3DAM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR4_RGRD(v);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR4_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR4_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR4_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR4_L3DAM0_WR_MASK) | ((data & MAC_L3L4CR4_L3DAM0_MASK) << 4));\
		MAC_L3L4CR4_RGWR(v);\
} while (0)

#define MAC_L3L4CR4_L3DAM0_UDFRD(data) do {\
		MAC_L3L4CR4_RGRD(data);\
		data = ((data >> 4) & MAC_L3L4CR4_L3DAM0_MASK);\
} while (0)

/*#define MAC_L3L4CR4_L3DAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR4_L3DAIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR4_L3DAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MAC_L3L4CR4_L3DAIM0_WR_MASK (ULONG)(0xffffffdf)

#define MAC_L3L4CR4_L3DAIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR4_RGRD(v);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR4_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR4_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR4_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR4_L3DAIM0_WR_MASK) | ((data & MAC_L3L4CR4_L3DAIM0_MASK) << 5));\
		MAC_L3L4CR4_RGWR(v);\
} while (0)

#define MAC_L3L4CR4_L3DAIM0_UDFRD(data) do {\
		MAC_L3L4CR4_RGRD(data);\
		data = ((data >> 5) & MAC_L3L4CR4_L3DAIM0_MASK);\
} while (0)

/*#define MAC_L3L4CR4_L3HSBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR4_L3HSBM0_MASK (ULONG)(0x1f)

/*#define MAC_L3L4CR4_L3HSBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (6)))*/

#define MAC_L3L4CR4_L3HSBM0_WR_MASK (ULONG)(0xfffff83f)

#define MAC_L3L4CR4_L3HSBM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR4_RGRD(v);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR4_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR4_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR4_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR4_L3HSBM0_WR_MASK) | ((data & MAC_L3L4CR4_L3HSBM0_MASK) << 6));\
		MAC_L3L4CR4_RGWR(v);\
} while (0)

#define MAC_L3L4CR4_L3HSBM0_UDFRD(data) do {\
		MAC_L3L4CR4_RGRD(data);\
		data = ((data >> 6) & MAC_L3L4CR4_L3HSBM0_MASK);\
} while (0)

/*#define MAC_L3L4CR4_L3HDBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR4_L3HDBM0_MASK (ULONG)(0x1f)

/*#define MAC_L3L4CR4_L3HDBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (11)))*/

#define MAC_L3L4CR4_L3HDBM0_WR_MASK (ULONG)(0xffff07ff)

#define MAC_L3L4CR4_L3HDBM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR4_RGRD(v);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR4_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR4_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR4_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR4_L3HDBM0_WR_MASK) | ((data & MAC_L3L4CR4_L3HDBM0_MASK) << 11));\
		MAC_L3L4CR4_RGWR(v);\
} while (0)

#define MAC_L3L4CR4_L3HDBM0_UDFRD(data) do {\
		MAC_L3L4CR4_RGRD(data);\
		data = ((data >> 11) & MAC_L3L4CR4_L3HDBM0_MASK);\
} while (0)

/*#define MAC_L3L4CR4_L4PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR4_L4PEN0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR4_L4PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MAC_L3L4CR4_L4PEN0_WR_MASK (ULONG)(0xfffeffff)

#define MAC_L3L4CR4_L4PEN0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR4_RGRD(v);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR4_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR4_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR4_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR4_L4PEN0_WR_MASK) | ((data & MAC_L3L4CR4_L4PEN0_MASK) << 16));\
		MAC_L3L4CR4_RGWR(v);\
} while (0)

#define MAC_L3L4CR4_L4PEN0_UDFRD(data) do {\
		MAC_L3L4CR4_RGRD(data);\
		data = ((data >> 16) & MAC_L3L4CR4_L4PEN0_MASK);\
} while (0)

/*#define MAC_L3L4CR4_L4SPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR4_L4SPM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR4_L4SPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MAC_L3L4CR4_L4SPM0_WR_MASK (ULONG)(0xfffbffff)

#define MAC_L3L4CR4_L4SPM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR4_RGRD(v);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR4_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR4_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR4_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR4_L4SPM0_WR_MASK) | ((data & MAC_L3L4CR4_L4SPM0_MASK) << 18));\
		MAC_L3L4CR4_RGWR(v);\
} while (0)

#define MAC_L3L4CR4_L4SPM0_UDFRD(data) do {\
		MAC_L3L4CR4_RGRD(data);\
		data = ((data >> 18) & MAC_L3L4CR4_L4SPM0_MASK);\
} while (0)

/*#define MAC_L3L4CR4_L4SPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR4_L4SPIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR4_L4SPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MAC_L3L4CR4_L4SPIM0_WR_MASK (ULONG)(0xfff7ffff)

#define MAC_L3L4CR4_L4SPIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR4_RGRD(v);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR4_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR4_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR4_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR4_L4SPIM0_WR_MASK) | ((data & MAC_L3L4CR4_L4SPIM0_MASK) << 19));\
		MAC_L3L4CR4_RGWR(v);\
} while (0)

#define MAC_L3L4CR4_L4SPIM0_UDFRD(data) do {\
		MAC_L3L4CR4_RGRD(data);\
		data = ((data >> 19) & MAC_L3L4CR4_L4SPIM0_MASK);\
} while (0)

/*#define MAC_L3L4CR4_L4DPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR4_L4DPM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR4_L4DPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MAC_L3L4CR4_L4DPM0_WR_MASK (ULONG)(0xffefffff)

#define MAC_L3L4CR4_L4DPM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR4_RGRD(v);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR4_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR4_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR4_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR4_L4DPM0_WR_MASK) | ((data & MAC_L3L4CR4_L4DPM0_MASK) << 20));\
		MAC_L3L4CR4_RGWR(v);\
} while (0)

#define MAC_L3L4CR4_L4DPM0_UDFRD(data) do {\
		MAC_L3L4CR4_RGRD(data);\
		data = ((data >> 20) & MAC_L3L4CR4_L4DPM0_MASK);\
} while (0)

/*#define MAC_L3L4CR4_L4DPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR4_L4DPIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR4_L4DPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (21)))*/

#define MAC_L3L4CR4_L4DPIM0_WR_MASK (ULONG)(0xffdfffff)

#define MAC_L3L4CR4_L4DPIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR4_RGRD(v);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR4_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR4_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR4_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR4_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR4_L4DPIM0_WR_MASK) | ((data & MAC_L3L4CR4_L4DPIM0_MASK) << 21));\
		MAC_L3L4CR4_RGWR(v);\
} while (0)

#define MAC_L3L4CR4_L4DPIM0_UDFRD(data) do {\
		MAC_L3L4CR4_RGRD(data);\
		data = ((data >> 21) & MAC_L3L4CR4_L4DPIM0_MASK);\
} while (0)

#define MAC_L3L4CR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x990))

#define MAC_L3L4CR3_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3L4CR3_RGOFFADDR);\
} while (0)

#define MAC_L3L4CR3_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3L4CR3_RGOFFADDR);\
} while (0)

/*#define  MAC_L3L4CR3_Mask_1 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR3_MASK_1 (ULONG)(0x1)

/*#define MAC_L3L4CR3_RES_Wr_Mask_1 (ULONG)(~((~(~0<<(1)))<<(1)))*/

#define MAC_L3L4CR3_RES_WR_MASK_1 (ULONG)(0xfffffffd)

/*#define  MAC_L3L4CR3_Mask_17 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR3_MASK_17 (ULONG)(0x1)

/*#define MAC_L3L4CR3_RES_Wr_Mask_17 (ULONG)(~((~(~0<<(1)))<<(17)))*/

#define MAC_L3L4CR3_RES_WR_MASK_17 (ULONG)(0xfffdffff)

/*#define  MAC_L3L4CR3_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  MAC_L3L4CR3_MASK_22 (ULONG)(0x3ff)

/*#define MAC_L3L4CR3_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define MAC_L3L4CR3_RES_WR_MASK_22 (ULONG)(0x3fffff)

/*#define MAC_L3L4CR3_L3PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR3_L3PEN0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR3_L3PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_L3L4CR3_L3PEN0_WR_MASK (ULONG)(0xfffffffe)

#define MAC_L3L4CR3_L3PEN0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR3_RGRD(v);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR3_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR3_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR3_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR3_L3PEN0_WR_MASK) | ((data & MAC_L3L4CR3_L3PEN0_MASK) << 0));\
		MAC_L3L4CR3_RGWR(v);\
} while (0)

#define MAC_L3L4CR3_L3PEN0_UDFRD(data) do {\
		MAC_L3L4CR3_RGRD(data);\
		data = ((data >> 0) & MAC_L3L4CR3_L3PEN0_MASK);\
} while (0)

/*#define MAC_L3L4CR3_L3SAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR3_L3SAM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR3_L3SAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MAC_L3L4CR3_L3SAM0_WR_MASK (ULONG)(0xfffffffb)

#define MAC_L3L4CR3_L3SAM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR3_RGRD(v);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR3_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR3_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR3_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR3_L3SAM0_WR_MASK) | ((data & MAC_L3L4CR3_L3SAM0_MASK) << 2));\
		MAC_L3L4CR3_RGWR(v);\
} while (0)

#define MAC_L3L4CR3_L3SAM0_UDFRD(data) do {\
		MAC_L3L4CR3_RGRD(data);\
		data = ((data >> 2) & MAC_L3L4CR3_L3SAM0_MASK);\
} while (0)

/*#define MAC_L3L4CR3_L3SAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR3_L3SAIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR3_L3SAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MAC_L3L4CR3_L3SAIM0_WR_MASK (ULONG)(0xfffffff7)

#define MAC_L3L4CR3_L3SAIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR3_RGRD(v);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR3_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR3_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR3_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR3_L3SAIM0_WR_MASK) | ((data & MAC_L3L4CR3_L3SAIM0_MASK) << 3));\
		MAC_L3L4CR3_RGWR(v);\
} while (0)

#define MAC_L3L4CR3_L3SAIM0_UDFRD(data) do {\
		MAC_L3L4CR3_RGRD(data);\
		data = ((data >> 3) & MAC_L3L4CR3_L3SAIM0_MASK);\
} while (0)

/*#define MAC_L3L4CR3_L3DAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR3_L3DAM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR3_L3DAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MAC_L3L4CR3_L3DAM0_WR_MASK (ULONG)(0xffffffef)

#define MAC_L3L4CR3_L3DAM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR3_RGRD(v);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR3_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR3_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR3_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR3_L3DAM0_WR_MASK) | ((data & MAC_L3L4CR3_L3DAM0_MASK) << 4));\
		MAC_L3L4CR3_RGWR(v);\
} while (0)

#define MAC_L3L4CR3_L3DAM0_UDFRD(data) do {\
		MAC_L3L4CR3_RGRD(data);\
		data = ((data >> 4) & MAC_L3L4CR3_L3DAM0_MASK);\
} while (0)

/*#define MAC_L3L4CR3_L3DAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR3_L3DAIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR3_L3DAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MAC_L3L4CR3_L3DAIM0_WR_MASK (ULONG)(0xffffffdf)

#define MAC_L3L4CR3_L3DAIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR3_RGRD(v);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR3_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR3_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR3_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR3_L3DAIM0_WR_MASK) | ((data & MAC_L3L4CR3_L3DAIM0_MASK) << 5));\
		MAC_L3L4CR3_RGWR(v);\
} while (0)

#define MAC_L3L4CR3_L3DAIM0_UDFRD(data) do {\
		MAC_L3L4CR3_RGRD(data);\
		data = ((data >> 5) & MAC_L3L4CR3_L3DAIM0_MASK);\
} while (0)

/*#define MAC_L3L4CR3_L3HSBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR3_L3HSBM0_MASK (ULONG)(0x1f)

/*#define MAC_L3L4CR3_L3HSBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (6)))*/

#define MAC_L3L4CR3_L3HSBM0_WR_MASK (ULONG)(0xfffff83f)

#define MAC_L3L4CR3_L3HSBM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR3_RGRD(v);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR3_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR3_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR3_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR3_L3HSBM0_WR_MASK) | ((data & MAC_L3L4CR3_L3HSBM0_MASK) << 6));\
		MAC_L3L4CR3_RGWR(v);\
} while (0)

#define MAC_L3L4CR3_L3HSBM0_UDFRD(data) do {\
		MAC_L3L4CR3_RGRD(data);\
		data = ((data >> 6) & MAC_L3L4CR3_L3HSBM0_MASK);\
} while (0)

/*#define MAC_L3L4CR3_L3HDBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR3_L3HDBM0_MASK (ULONG)(0x1f)

/*#define MAC_L3L4CR3_L3HDBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (11)))*/

#define MAC_L3L4CR3_L3HDBM0_WR_MASK (ULONG)(0xffff07ff)

#define MAC_L3L4CR3_L3HDBM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR3_RGRD(v);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR3_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR3_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR3_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR3_L3HDBM0_WR_MASK) | ((data & MAC_L3L4CR3_L3HDBM0_MASK) << 11));\
		MAC_L3L4CR3_RGWR(v);\
} while (0)

#define MAC_L3L4CR3_L3HDBM0_UDFRD(data) do {\
		MAC_L3L4CR3_RGRD(data);\
		data = ((data >> 11) & MAC_L3L4CR3_L3HDBM0_MASK);\
} while (0)

/*#define MAC_L3L4CR3_L4PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR3_L4PEN0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR3_L4PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MAC_L3L4CR3_L4PEN0_WR_MASK (ULONG)(0xfffeffff)

#define MAC_L3L4CR3_L4PEN0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR3_RGRD(v);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR3_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR3_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR3_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR3_L4PEN0_WR_MASK) | ((data & MAC_L3L4CR3_L4PEN0_MASK) << 16));\
		MAC_L3L4CR3_RGWR(v);\
} while (0)

#define MAC_L3L4CR3_L4PEN0_UDFRD(data) do {\
		MAC_L3L4CR3_RGRD(data);\
		data = ((data >> 16) & MAC_L3L4CR3_L4PEN0_MASK);\
} while (0)

/*#define MAC_L3L4CR3_L4SPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR3_L4SPM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR3_L4SPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MAC_L3L4CR3_L4SPM0_WR_MASK (ULONG)(0xfffbffff)

#define MAC_L3L4CR3_L4SPM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR3_RGRD(v);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR3_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR3_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR3_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR3_L4SPM0_WR_MASK) | ((data & MAC_L3L4CR3_L4SPM0_MASK) << 18));\
		MAC_L3L4CR3_RGWR(v);\
} while (0)

#define MAC_L3L4CR3_L4SPM0_UDFRD(data) do {\
		MAC_L3L4CR3_RGRD(data);\
		data = ((data >> 18) & MAC_L3L4CR3_L4SPM0_MASK);\
} while (0)

/*#define MAC_L3L4CR3_L4SPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR3_L4SPIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR3_L4SPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MAC_L3L4CR3_L4SPIM0_WR_MASK (ULONG)(0xfff7ffff)

#define MAC_L3L4CR3_L4SPIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR3_RGRD(v);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR3_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR3_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR3_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR3_L4SPIM0_WR_MASK) | ((data & MAC_L3L4CR3_L4SPIM0_MASK) << 19));\
		MAC_L3L4CR3_RGWR(v);\
} while (0)

#define MAC_L3L4CR3_L4SPIM0_UDFRD(data) do {\
		MAC_L3L4CR3_RGRD(data);\
		data = ((data >> 19) & MAC_L3L4CR3_L4SPIM0_MASK);\
} while (0)

/*#define MAC_L3L4CR3_L4DPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR3_L4DPM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR3_L4DPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MAC_L3L4CR3_L4DPM0_WR_MASK (ULONG)(0xffefffff)

#define MAC_L3L4CR3_L4DPM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR3_RGRD(v);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR3_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR3_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR3_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR3_L4DPM0_WR_MASK) | ((data & MAC_L3L4CR3_L4DPM0_MASK) << 20));\
		MAC_L3L4CR3_RGWR(v);\
} while (0)

#define MAC_L3L4CR3_L4DPM0_UDFRD(data) do {\
		MAC_L3L4CR3_RGRD(data);\
		data = ((data >> 20) & MAC_L3L4CR3_L4DPM0_MASK);\
} while (0)

/*#define MAC_L3L4CR3_L4DPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR3_L4DPIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR3_L4DPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (21)))*/

#define MAC_L3L4CR3_L4DPIM0_WR_MASK (ULONG)(0xffdfffff)

#define MAC_L3L4CR3_L4DPIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR3_RGRD(v);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR3_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR3_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR3_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR3_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR3_L4DPIM0_WR_MASK) | ((data & MAC_L3L4CR3_L4DPIM0_MASK) << 21));\
		MAC_L3L4CR3_RGWR(v);\
} while (0)

#define MAC_L3L4CR3_L4DPIM0_UDFRD(data) do {\
		MAC_L3L4CR3_RGRD(data);\
		data = ((data >> 21) & MAC_L3L4CR3_L4DPIM0_MASK);\
} while (0)

#define MAC_L3L4CR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x960))

#define MAC_L3L4CR2_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3L4CR2_RGOFFADDR);\
} while (0)

#define MAC_L3L4CR2_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3L4CR2_RGOFFADDR);\
} while (0)

/*#define  MAC_L3L4CR2_Mask_1 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR2_MASK_1 (ULONG)(0x1)

/*#define MAC_L3L4CR2_RES_Wr_Mask_1 (ULONG)(~((~(~0<<(1)))<<(1)))*/

#define MAC_L3L4CR2_RES_WR_MASK_1 (ULONG)(0xfffffffd)

/*#define  MAC_L3L4CR2_Mask_17 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR2_MASK_17 (ULONG)(0x1)

/*#define MAC_L3L4CR2_RES_Wr_Mask_17 (ULONG)(~((~(~0<<(1)))<<(17)))*/

#define MAC_L3L4CR2_RES_WR_MASK_17 (ULONG)(0xfffdffff)

/*#define  MAC_L3L4CR2_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  MAC_L3L4CR2_MASK_22 (ULONG)(0x3ff)

/*#define MAC_L3L4CR2_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define MAC_L3L4CR2_RES_WR_MASK_22 (ULONG)(0x3fffff)

/*#define MAC_L3L4CR2_L3PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR2_L3PEN0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR2_L3PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_L3L4CR2_L3PEN0_WR_MASK (ULONG)(0xfffffffe)

#define MAC_L3L4CR2_L3PEN0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR2_RGRD(v);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR2_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR2_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR2_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR2_L3PEN0_WR_MASK) | ((data & MAC_L3L4CR2_L3PEN0_MASK) << 0));\
		MAC_L3L4CR2_RGWR(v);\
} while (0)

#define MAC_L3L4CR2_L3PEN0_UDFRD(data) do {\
		MAC_L3L4CR2_RGRD(data);\
		data = ((data >> 0) & MAC_L3L4CR2_L3PEN0_MASK);\
} while (0)

/*#define MAC_L3L4CR2_L3SAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR2_L3SAM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR2_L3SAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MAC_L3L4CR2_L3SAM0_WR_MASK (ULONG)(0xfffffffb)

#define MAC_L3L4CR2_L3SAM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR2_RGRD(v);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR2_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR2_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR2_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR2_L3SAM0_WR_MASK) | ((data & MAC_L3L4CR2_L3SAM0_MASK) << 2));\
		MAC_L3L4CR2_RGWR(v);\
} while (0)

#define MAC_L3L4CR2_L3SAM0_UDFRD(data) do {\
		MAC_L3L4CR2_RGRD(data);\
		data = ((data >> 2) & MAC_L3L4CR2_L3SAM0_MASK);\
} while (0)

/*#define MAC_L3L4CR2_L3SAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR2_L3SAIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR2_L3SAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MAC_L3L4CR2_L3SAIM0_WR_MASK (ULONG)(0xfffffff7)

#define MAC_L3L4CR2_L3SAIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR2_RGRD(v);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR2_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR2_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR2_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR2_L3SAIM0_WR_MASK) | ((data & MAC_L3L4CR2_L3SAIM0_MASK) << 3));\
		MAC_L3L4CR2_RGWR(v);\
} while (0)

#define MAC_L3L4CR2_L3SAIM0_UDFRD(data) do {\
		MAC_L3L4CR2_RGRD(data);\
		data = ((data >> 3) & MAC_L3L4CR2_L3SAIM0_MASK);\
} while (0)

/*#define MAC_L3L4CR2_L3DAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR2_L3DAM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR2_L3DAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MAC_L3L4CR2_L3DAM0_WR_MASK (ULONG)(0xffffffef)

#define MAC_L3L4CR2_L3DAM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR2_RGRD(v);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR2_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR2_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR2_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR2_L3DAM0_WR_MASK) | ((data & MAC_L3L4CR2_L3DAM0_MASK) << 4));\
		MAC_L3L4CR2_RGWR(v);\
} while (0)

#define MAC_L3L4CR2_L3DAM0_UDFRD(data) do {\
		MAC_L3L4CR2_RGRD(data);\
		data = ((data >> 4) & MAC_L3L4CR2_L3DAM0_MASK);\
} while (0)

/*#define MAC_L3L4CR2_L3DAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR2_L3DAIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR2_L3DAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MAC_L3L4CR2_L3DAIM0_WR_MASK (ULONG)(0xffffffdf)

#define MAC_L3L4CR2_L3DAIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR2_RGRD(v);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR2_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR2_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR2_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR2_L3DAIM0_WR_MASK) | ((data & MAC_L3L4CR2_L3DAIM0_MASK) << 5));\
		MAC_L3L4CR2_RGWR(v);\
} while (0)

#define MAC_L3L4CR2_L3DAIM0_UDFRD(data) do {\
		MAC_L3L4CR2_RGRD(data);\
		data = ((data >> 5) & MAC_L3L4CR2_L3DAIM0_MASK);\
} while (0)

/*#define MAC_L3L4CR2_L3HSBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR2_L3HSBM0_MASK (ULONG)(0x1f)

/*#define MAC_L3L4CR2_L3HSBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (6)))*/

#define MAC_L3L4CR2_L3HSBM0_WR_MASK (ULONG)(0xfffff83f)

#define MAC_L3L4CR2_L3HSBM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR2_RGRD(v);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR2_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR2_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR2_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR2_L3HSBM0_WR_MASK) | ((data & MAC_L3L4CR2_L3HSBM0_MASK) << 6));\
		MAC_L3L4CR2_RGWR(v);\
} while (0)

#define MAC_L3L4CR2_L3HSBM0_UDFRD(data) do {\
		MAC_L3L4CR2_RGRD(data);\
		data = ((data >> 6) & MAC_L3L4CR2_L3HSBM0_MASK);\
} while (0)

/*#define MAC_L3L4CR2_L3HDBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR2_L3HDBM0_MASK (ULONG)(0x1f)

/*#define MAC_L3L4CR2_L3HDBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (11)))*/

#define MAC_L3L4CR2_L3HDBM0_WR_MASK (ULONG)(0xffff07ff)

#define MAC_L3L4CR2_L3HDBM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR2_RGRD(v);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR2_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR2_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR2_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR2_L3HDBM0_WR_MASK) | ((data & MAC_L3L4CR2_L3HDBM0_MASK) << 11));\
		MAC_L3L4CR2_RGWR(v);\
} while (0)

#define MAC_L3L4CR2_L3HDBM0_UDFRD(data) do {\
		MAC_L3L4CR2_RGRD(data);\
		data = ((data >> 11) & MAC_L3L4CR2_L3HDBM0_MASK);\
} while (0)

/*#define MAC_L3L4CR2_L4PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR2_L4PEN0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR2_L4PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MAC_L3L4CR2_L4PEN0_WR_MASK (ULONG)(0xfffeffff)

#define MAC_L3L4CR2_L4PEN0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR2_RGRD(v);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR2_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR2_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR2_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR2_L4PEN0_WR_MASK) | ((data & MAC_L3L4CR2_L4PEN0_MASK) << 16));\
		MAC_L3L4CR2_RGWR(v);\
} while (0)

#define MAC_L3L4CR2_L4PEN0_UDFRD(data) do {\
		MAC_L3L4CR2_RGRD(data);\
		data = ((data >> 16) & MAC_L3L4CR2_L4PEN0_MASK);\
} while (0)

/*#define MAC_L3L4CR2_L4SPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR2_L4SPM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR2_L4SPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MAC_L3L4CR2_L4SPM0_WR_MASK (ULONG)(0xfffbffff)

#define MAC_L3L4CR2_L4SPM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR2_RGRD(v);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR2_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR2_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR2_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR2_L4SPM0_WR_MASK) | ((data & MAC_L3L4CR2_L4SPM0_MASK) << 18));\
		MAC_L3L4CR2_RGWR(v);\
} while (0)

#define MAC_L3L4CR2_L4SPM0_UDFRD(data) do {\
		MAC_L3L4CR2_RGRD(data);\
		data = ((data >> 18) & MAC_L3L4CR2_L4SPM0_MASK);\
} while (0)

/*#define MAC_L3L4CR2_L4SPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR2_L4SPIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR2_L4SPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MAC_L3L4CR2_L4SPIM0_WR_MASK (ULONG)(0xfff7ffff)

#define MAC_L3L4CR2_L4SPIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR2_RGRD(v);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR2_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR2_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR2_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR2_L4SPIM0_WR_MASK) | ((data & MAC_L3L4CR2_L4SPIM0_MASK) << 19));\
		MAC_L3L4CR2_RGWR(v);\
} while (0)

#define MAC_L3L4CR2_L4SPIM0_UDFRD(data) do {\
		MAC_L3L4CR2_RGRD(data);\
		data = ((data >> 19) & MAC_L3L4CR2_L4SPIM0_MASK);\
} while (0)

/*#define MAC_L3L4CR2_L4DPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR2_L4DPM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR2_L4DPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MAC_L3L4CR2_L4DPM0_WR_MASK (ULONG)(0xffefffff)

#define MAC_L3L4CR2_L4DPM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR2_RGRD(v);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR2_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR2_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR2_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR2_L4DPM0_WR_MASK) | ((data & MAC_L3L4CR2_L4DPM0_MASK) << 20));\
		MAC_L3L4CR2_RGWR(v);\
} while (0)

#define MAC_L3L4CR2_L4DPM0_UDFRD(data) do {\
		MAC_L3L4CR2_RGRD(data);\
		data = ((data >> 20) & MAC_L3L4CR2_L4DPM0_MASK);\
} while (0)

/*#define MAC_L3L4CR2_L4DPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR2_L4DPIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR2_L4DPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (21)))*/

#define MAC_L3L4CR2_L4DPIM0_WR_MASK (ULONG)(0xffdfffff)

#define MAC_L3L4CR2_L4DPIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR2_RGRD(v);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR2_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR2_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR2_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR2_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR2_L4DPIM0_WR_MASK) | ((data & MAC_L3L4CR2_L4DPIM0_MASK) << 21));\
		MAC_L3L4CR2_RGWR(v);\
} while (0)

#define MAC_L3L4CR2_L4DPIM0_UDFRD(data) do {\
		MAC_L3L4CR2_RGRD(data);\
		data = ((data >> 21) & MAC_L3L4CR2_L4DPIM0_MASK);\
} while (0)

#define MAC_L3L4CR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x930))

#define MAC_L3L4CR1_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3L4CR1_RGOFFADDR);\
} while (0)

#define MAC_L3L4CR1_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3L4CR1_RGOFFADDR);\
} while (0)

/*#define  MAC_L3L4CR1_Mask_1 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR1_MASK_1 (ULONG)(0x1)

/*#define MAC_L3L4CR1_RES_Wr_Mask_1 (ULONG)(~((~(~0<<(1)))<<(1)))*/

#define MAC_L3L4CR1_RES_WR_MASK_1 (ULONG)(0xfffffffd)

/*#define  MAC_L3L4CR1_Mask_17 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR1_MASK_17 (ULONG)(0x1)

/*#define MAC_L3L4CR1_RES_Wr_Mask_17 (ULONG)(~((~(~0<<(1)))<<(17)))*/

#define MAC_L3L4CR1_RES_WR_MASK_17 (ULONG)(0xfffdffff)

/*#define  MAC_L3L4CR1_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  MAC_L3L4CR1_MASK_22 (ULONG)(0x3ff)

/*#define MAC_L3L4CR1_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define MAC_L3L4CR1_RES_WR_MASK_22 (ULONG)(0x3fffff)

/*#define MAC_L3L4CR1_L3PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR1_L3PEN0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR1_L3PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_L3L4CR1_L3PEN0_WR_MASK (ULONG)(0xfffffffe)

#define MAC_L3L4CR1_L3PEN0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR1_RGRD(v);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR1_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR1_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR1_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR1_L3PEN0_WR_MASK) | ((data & MAC_L3L4CR1_L3PEN0_MASK) << 0));\
		MAC_L3L4CR1_RGWR(v);\
} while (0)

#define MAC_L3L4CR1_L3PEN0_UDFRD(data) do {\
		MAC_L3L4CR1_RGRD(data);\
		data = ((data >> 0) & MAC_L3L4CR1_L3PEN0_MASK);\
} while (0)

/*#define MAC_L3L4CR1_L3SAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR1_L3SAM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR1_L3SAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MAC_L3L4CR1_L3SAM0_WR_MASK (ULONG)(0xfffffffb)

#define MAC_L3L4CR1_L3SAM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR1_RGRD(v);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR1_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR1_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR1_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR1_L3SAM0_WR_MASK) | ((data & MAC_L3L4CR1_L3SAM0_MASK) << 2));\
		MAC_L3L4CR1_RGWR(v);\
} while (0)

#define MAC_L3L4CR1_L3SAM0_UDFRD(data) do {\
		MAC_L3L4CR1_RGRD(data);\
		data = ((data >> 2) & MAC_L3L4CR1_L3SAM0_MASK);\
} while (0)

/*#define MAC_L3L4CR1_L3SAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR1_L3SAIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR1_L3SAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MAC_L3L4CR1_L3SAIM0_WR_MASK (ULONG)(0xfffffff7)

#define MAC_L3L4CR1_L3SAIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR1_RGRD(v);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR1_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR1_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR1_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR1_L3SAIM0_WR_MASK) | ((data & MAC_L3L4CR1_L3SAIM0_MASK) << 3));\
		MAC_L3L4CR1_RGWR(v);\
} while (0)

#define MAC_L3L4CR1_L3SAIM0_UDFRD(data) do {\
		MAC_L3L4CR1_RGRD(data);\
		data = ((data >> 3) & MAC_L3L4CR1_L3SAIM0_MASK);\
} while (0)

/*#define MAC_L3L4CR1_L3DAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR1_L3DAM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR1_L3DAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MAC_L3L4CR1_L3DAM0_WR_MASK (ULONG)(0xffffffef)

#define MAC_L3L4CR1_L3DAM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR1_RGRD(v);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR1_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR1_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR1_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR1_L3DAM0_WR_MASK) | ((data & MAC_L3L4CR1_L3DAM0_MASK) << 4));\
		MAC_L3L4CR1_RGWR(v);\
} while (0)

#define MAC_L3L4CR1_L3DAM0_UDFRD(data) do {\
		MAC_L3L4CR1_RGRD(data);\
		data = ((data >> 4) & MAC_L3L4CR1_L3DAM0_MASK);\
} while (0)

/*#define MAC_L3L4CR1_L3DAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR1_L3DAIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR1_L3DAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MAC_L3L4CR1_L3DAIM0_WR_MASK (ULONG)(0xffffffdf)

#define MAC_L3L4CR1_L3DAIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR1_RGRD(v);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR1_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR1_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR1_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR1_L3DAIM0_WR_MASK) | ((data & MAC_L3L4CR1_L3DAIM0_MASK) << 5));\
		MAC_L3L4CR1_RGWR(v);\
} while (0)

#define MAC_L3L4CR1_L3DAIM0_UDFRD(data) do {\
		MAC_L3L4CR1_RGRD(data);\
		data = ((data >> 5) & MAC_L3L4CR1_L3DAIM0_MASK);\
} while (0)

/*#define MAC_L3L4CR1_L3HSBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR1_L3HSBM0_MASK (ULONG)(0x1f)

/*#define MAC_L3L4CR1_L3HSBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (6)))*/

#define MAC_L3L4CR1_L3HSBM0_WR_MASK (ULONG)(0xfffff83f)

#define MAC_L3L4CR1_L3HSBM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR1_RGRD(v);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR1_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR1_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR1_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR1_L3HSBM0_WR_MASK) | ((data & MAC_L3L4CR1_L3HSBM0_MASK) << 6));\
		MAC_L3L4CR1_RGWR(v);\
} while (0)

#define MAC_L3L4CR1_L3HSBM0_UDFRD(data) do {\
		MAC_L3L4CR1_RGRD(data);\
		data = ((data >> 6) & MAC_L3L4CR1_L3HSBM0_MASK);\
} while (0)

/*#define MAC_L3L4CR1_L3HDBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR1_L3HDBM0_MASK (ULONG)(0x1f)

/*#define MAC_L3L4CR1_L3HDBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (11)))*/

#define MAC_L3L4CR1_L3HDBM0_WR_MASK (ULONG)(0xffff07ff)

#define MAC_L3L4CR1_L3HDBM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR1_RGRD(v);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR1_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR1_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR1_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR1_L3HDBM0_WR_MASK) | ((data & MAC_L3L4CR1_L3HDBM0_MASK) << 11));\
		MAC_L3L4CR1_RGWR(v);\
} while (0)

#define MAC_L3L4CR1_L3HDBM0_UDFRD(data) do {\
		MAC_L3L4CR1_RGRD(data);\
		data = ((data >> 11) & MAC_L3L4CR1_L3HDBM0_MASK);\
} while (0)

/*#define MAC_L3L4CR1_L4PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR1_L4PEN0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR1_L4PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MAC_L3L4CR1_L4PEN0_WR_MASK (ULONG)(0xfffeffff)

#define MAC_L3L4CR1_L4PEN0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR1_RGRD(v);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR1_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR1_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR1_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR1_L4PEN0_WR_MASK) | ((data & MAC_L3L4CR1_L4PEN0_MASK) << 16));\
		MAC_L3L4CR1_RGWR(v);\
} while (0)

#define MAC_L3L4CR1_L4PEN0_UDFRD(data) do {\
		MAC_L3L4CR1_RGRD(data);\
		data = ((data >> 16) & MAC_L3L4CR1_L4PEN0_MASK);\
} while (0)

/*#define MAC_L3L4CR1_L4SPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR1_L4SPM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR1_L4SPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MAC_L3L4CR1_L4SPM0_WR_MASK (ULONG)(0xfffbffff)

#define MAC_L3L4CR1_L4SPM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR1_RGRD(v);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR1_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR1_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR1_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR1_L4SPM0_WR_MASK) | ((data & MAC_L3L4CR1_L4SPM0_MASK) << 18));\
		MAC_L3L4CR1_RGWR(v);\
} while (0)

#define MAC_L3L4CR1_L4SPM0_UDFRD(data) do {\
		MAC_L3L4CR1_RGRD(data);\
		data = ((data >> 18) & MAC_L3L4CR1_L4SPM0_MASK);\
} while (0)

/*#define MAC_L3L4CR1_L4SPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR1_L4SPIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR1_L4SPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MAC_L3L4CR1_L4SPIM0_WR_MASK (ULONG)(0xfff7ffff)

#define MAC_L3L4CR1_L4SPIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR1_RGRD(v);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR1_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR1_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR1_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR1_L4SPIM0_WR_MASK) | ((data & MAC_L3L4CR1_L4SPIM0_MASK) << 19));\
		MAC_L3L4CR1_RGWR(v);\
} while (0)

#define MAC_L3L4CR1_L4SPIM0_UDFRD(data) do {\
		MAC_L3L4CR1_RGRD(data);\
		data = ((data >> 19) & MAC_L3L4CR1_L4SPIM0_MASK);\
} while (0)

/*#define MAC_L3L4CR1_L4DPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR1_L4DPM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR1_L4DPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MAC_L3L4CR1_L4DPM0_WR_MASK (ULONG)(0xffefffff)

#define MAC_L3L4CR1_L4DPM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR1_RGRD(v);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR1_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR1_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR1_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR1_L4DPM0_WR_MASK) | ((data & MAC_L3L4CR1_L4DPM0_MASK) << 20));\
		MAC_L3L4CR1_RGWR(v);\
} while (0)

#define MAC_L3L4CR1_L4DPM0_UDFRD(data) do {\
		MAC_L3L4CR1_RGRD(data);\
		data = ((data >> 20) & MAC_L3L4CR1_L4DPM0_MASK);\
} while (0)

/*#define MAC_L3L4CR1_L4DPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR1_L4DPIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR1_L4DPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (21)))*/

#define MAC_L3L4CR1_L4DPIM0_WR_MASK (ULONG)(0xffdfffff)

#define MAC_L3L4CR1_L4DPIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR1_RGRD(v);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR1_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR1_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR1_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR1_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR1_L4DPIM0_WR_MASK) | ((data & MAC_L3L4CR1_L4DPIM0_MASK) << 21));\
		MAC_L3L4CR1_RGWR(v);\
} while (0)

#define MAC_L3L4CR1_L4DPIM0_UDFRD(data) do {\
		MAC_L3L4CR1_RGRD(data);\
		data = ((data >> 21) & MAC_L3L4CR1_L4DPIM0_MASK);\
} while (0)

#define MAC_L3L4CR0_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x900))

#define MAC_L3L4CR0_RGWR(data) do {\
		iowrite32(data, (void *)MAC_L3L4CR0_RGOFFADDR);\
} while (0)

#define MAC_L3L4CR0_RGRD(data) do {\
		(data) = ioread32((void *)MAC_L3L4CR0_RGOFFADDR);\
} while (0)

/*#define  MAC_L3L4CR0_Mask_1 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR0_MASK_1 (ULONG)(0x1)

/*#define MAC_L3L4CR0_RES_Wr_Mask_1 (ULONG)(~((~(~0<<(1)))<<(1)))*/

#define MAC_L3L4CR0_RES_WR_MASK_1 (ULONG)(0xfffffffd)

/*#define  MAC_L3L4CR0_Mask_17 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR0_MASK_17 (ULONG)(0x1)

/*#define MAC_L3L4CR0_RES_Wr_Mask_17 (ULONG)(~((~(~0<<(1)))<<(17)))*/

#define MAC_L3L4CR0_RES_WR_MASK_17 (ULONG)(0xfffdffff)

/*#define  MAC_L3L4CR0_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  MAC_L3L4CR0_MASK_22 (ULONG)(0x3ff)

/*#define MAC_L3L4CR0_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define MAC_L3L4CR0_RES_WR_MASK_22 (ULONG)(0x3fffff)

/*#define MAC_L3L4CR0_L3PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR0_L3PEN0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR0_L3PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_L3L4CR0_L3PEN0_WR_MASK (ULONG)(0xfffffffe)

#define MAC_L3L4CR0_L3PEN0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR0_RGRD(v);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR0_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR0_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR0_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR0_L3PEN0_WR_MASK) | ((data & MAC_L3L4CR0_L3PEN0_MASK) << 0));\
		MAC_L3L4CR0_RGWR(v);\
} while (0)

#define MAC_L3L4CR0_L3PEN0_UDFRD(data) do {\
		MAC_L3L4CR0_RGRD(data);\
		data = ((data >> 0) & MAC_L3L4CR0_L3PEN0_MASK);\
} while (0)

/*#define MAC_L3L4CR0_L3SAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR0_L3SAM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR0_L3SAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MAC_L3L4CR0_L3SAM0_WR_MASK (ULONG)(0xfffffffb)

#define MAC_L3L4CR0_L3SAM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR0_RGRD(v);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR0_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR0_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR0_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR0_L3SAM0_WR_MASK) | ((data & MAC_L3L4CR0_L3SAM0_MASK) << 2));\
		MAC_L3L4CR0_RGWR(v);\
} while (0)

#define MAC_L3L4CR0_L3SAM0_UDFRD(data) do {\
		MAC_L3L4CR0_RGRD(data);\
		data = ((data >> 2) & MAC_L3L4CR0_L3SAM0_MASK);\
} while (0)

/*#define MAC_L3L4CR0_L3SAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR0_L3SAIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR0_L3SAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MAC_L3L4CR0_L3SAIM0_WR_MASK (ULONG)(0xfffffff7)

#define MAC_L3L4CR0_L3SAIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR0_RGRD(v);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR0_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR0_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR0_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR0_L3SAIM0_WR_MASK) | ((data & MAC_L3L4CR0_L3SAIM0_MASK) << 3));\
		MAC_L3L4CR0_RGWR(v);\
} while (0)

#define MAC_L3L4CR0_L3SAIM0_UDFRD(data) do {\
		MAC_L3L4CR0_RGRD(data);\
		data = ((data >> 3) & MAC_L3L4CR0_L3SAIM0_MASK);\
} while (0)

/*#define MAC_L3L4CR0_L3DAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR0_L3DAM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR0_L3DAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MAC_L3L4CR0_L3DAM0_WR_MASK (ULONG)(0xffffffef)

#define MAC_L3L4CR0_L3DAM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR0_RGRD(v);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR0_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR0_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR0_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR0_L3DAM0_WR_MASK) | ((data & MAC_L3L4CR0_L3DAM0_MASK) << 4));\
		MAC_L3L4CR0_RGWR(v);\
} while (0)

#define MAC_L3L4CR0_L3DAM0_UDFRD(data) do {\
		MAC_L3L4CR0_RGRD(data);\
		data = ((data >> 4) & MAC_L3L4CR0_L3DAM0_MASK);\
} while (0)

/*#define MAC_L3L4CR0_L3DAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR0_L3DAIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR0_L3DAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MAC_L3L4CR0_L3DAIM0_WR_MASK (ULONG)(0xffffffdf)

#define MAC_L3L4CR0_L3DAIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR0_RGRD(v);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR0_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR0_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR0_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR0_L3DAIM0_WR_MASK) | ((data & MAC_L3L4CR0_L3DAIM0_MASK) << 5));\
		MAC_L3L4CR0_RGWR(v);\
} while (0)

#define MAC_L3L4CR0_L3DAIM0_UDFRD(data) do {\
		MAC_L3L4CR0_RGRD(data);\
		data = ((data >> 5) & MAC_L3L4CR0_L3DAIM0_MASK);\
} while (0)

/*#define MAC_L3L4CR0_L3HSBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR0_L3HSBM0_MASK (ULONG)(0x1f)

/*#define MAC_L3L4CR0_L3HSBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (6)))*/

#define MAC_L3L4CR0_L3HSBM0_WR_MASK (ULONG)(0xfffff83f)

#define MAC_L3L4CR0_L3HSBM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR0_RGRD(v);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR0_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR0_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR0_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR0_L3HSBM0_WR_MASK) | ((data & MAC_L3L4CR0_L3HSBM0_MASK) << 6));\
		MAC_L3L4CR0_RGWR(v);\
} while (0)

#define MAC_L3L4CR0_L3HSBM0_UDFRD(data) do {\
		MAC_L3L4CR0_RGRD(data);\
		data = ((data >> 6) & MAC_L3L4CR0_L3HSBM0_MASK);\
} while (0)

/*#define MAC_L3L4CR0_L3HDBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR0_L3HDBM0_MASK (ULONG)(0x1f)

/*#define MAC_L3L4CR0_L3HDBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (11)))*/

#define MAC_L3L4CR0_L3HDBM0_WR_MASK (ULONG)(0xffff07ff)

#define MAC_L3L4CR0_L3HDBM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR0_RGRD(v);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR0_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR0_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR0_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR0_L3HDBM0_WR_MASK) | ((data & MAC_L3L4CR0_L3HDBM0_MASK) << 11));\
		MAC_L3L4CR0_RGWR(v);\
} while (0)

#define MAC_L3L4CR0_L3HDBM0_UDFRD(data) do {\
		MAC_L3L4CR0_RGRD(data);\
		data = ((data >> 11) & MAC_L3L4CR0_L3HDBM0_MASK);\
} while (0)

/*#define MAC_L3L4CR0_L4PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR0_L4PEN0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR0_L4PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MAC_L3L4CR0_L4PEN0_WR_MASK (ULONG)(0xfffeffff)

#define MAC_L3L4CR0_L4PEN0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR0_RGRD(v);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR0_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR0_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR0_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR0_L4PEN0_WR_MASK) | ((data & MAC_L3L4CR0_L4PEN0_MASK) << 16));\
		MAC_L3L4CR0_RGWR(v);\
} while (0)

#define MAC_L3L4CR0_L4PEN0_UDFRD(data) do {\
		MAC_L3L4CR0_RGRD(data);\
		data = ((data >> 16) & MAC_L3L4CR0_L4PEN0_MASK);\
} while (0)

/*#define MAC_L3L4CR0_L4SPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR0_L4SPM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR0_L4SPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MAC_L3L4CR0_L4SPM0_WR_MASK (ULONG)(0xfffbffff)

#define MAC_L3L4CR0_L4SPM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR0_RGRD(v);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR0_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR0_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR0_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR0_L4SPM0_WR_MASK) | ((data & MAC_L3L4CR0_L4SPM0_MASK) << 18));\
		MAC_L3L4CR0_RGWR(v);\
} while (0)

#define MAC_L3L4CR0_L4SPM0_UDFRD(data) do {\
		MAC_L3L4CR0_RGRD(data);\
		data = ((data >> 18) & MAC_L3L4CR0_L4SPM0_MASK);\
} while (0)

/*#define MAC_L3L4CR0_L4SPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR0_L4SPIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR0_L4SPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MAC_L3L4CR0_L4SPIM0_WR_MASK (ULONG)(0xfff7ffff)

#define MAC_L3L4CR0_L4SPIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR0_RGRD(v);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR0_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR0_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR0_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR0_L4SPIM0_WR_MASK) | ((data & MAC_L3L4CR0_L4SPIM0_MASK) << 19));\
		MAC_L3L4CR0_RGWR(v);\
} while (0)

#define MAC_L3L4CR0_L4SPIM0_UDFRD(data) do {\
		MAC_L3L4CR0_RGRD(data);\
		data = ((data >> 19) & MAC_L3L4CR0_L4SPIM0_MASK);\
} while (0)

/*#define MAC_L3L4CR0_L4DPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR0_L4DPM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR0_L4DPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MAC_L3L4CR0_L4DPM0_WR_MASK (ULONG)(0xffefffff)

#define MAC_L3L4CR0_L4DPM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR0_RGRD(v);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR0_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR0_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR0_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR0_L4DPM0_WR_MASK) | ((data & MAC_L3L4CR0_L4DPM0_MASK) << 20));\
		MAC_L3L4CR0_RGWR(v);\
} while (0)

#define MAC_L3L4CR0_L4DPM0_UDFRD(data) do {\
		MAC_L3L4CR0_RGRD(data);\
		data = ((data >> 20) & MAC_L3L4CR0_L4DPM0_MASK);\
} while (0)

/*#define MAC_L3L4CR0_L4DPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR0_L4DPIM0_MASK (ULONG)(0x1)

/*#define MAC_L3L4CR0_L4DPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (21)))*/

#define MAC_L3L4CR0_L4DPIM0_WR_MASK (ULONG)(0xffdfffff)

#define MAC_L3L4CR0_L4DPIM0_UDFWR(data) do {\
		ULONG v;\
		MAC_L3L4CR0_RGRD(v);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_1)) | (((0) & (MAC_L3L4CR0_MASK_1)) << 1);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_17)) | (((0) & (MAC_L3L4CR0_MASK_17)) << 17);\
		v = (v & (MAC_L3L4CR0_RES_WR_MASK_22)) | (((0) & (MAC_L3L4CR0_MASK_22)) << 22);\
		v = ((v & MAC_L3L4CR0_L4DPIM0_WR_MASK) | ((data & MAC_L3L4CR0_L4DPIM0_MASK) << 21));\
		MAC_L3L4CR0_RGWR(v);\
} while (0)

#define MAC_L3L4CR0_L4DPIM0_UDFRD(data) do {\
		MAC_L3L4CR0_RGRD(data);\
		data = ((data >> 21) & MAC_L3L4CR0_L4DPIM0_MASK);\
} while (0)

#define MAC_GPIOS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x20c))

#define MAC_GPIOS_RGWR(data) do {\
		iowrite32(data, (void *)MAC_GPIOS_RGOFFADDR);\
} while (0)

#define MAC_GPIOS_RGRD(data) do {\
		(data) = ioread32((void *)MAC_GPIOS_RGOFFADDR);\
} while (0)

/*#define MAC_GPIOS_GPO_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_GPIOS_GPO_MASK (ULONG)(0xffff)

/*#define MAC_GPIOS_GPO_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_GPIOS_GPO_WR_MASK (ULONG)(0xffff)

#define MAC_GPIOS_GPO_UDFWR(data) do {\
		ULONG v;\
		MAC_GPIOS_RGRD(v);\
		v = ((v & MAC_GPIOS_GPO_WR_MASK) | ((data & MAC_GPIOS_GPO_MASK) << 16));\
		MAC_GPIOS_RGWR(v);\
} while (0)

#define MAC_GPIOS_GPO_UDFRD(data) do {\
		MAC_GPIOS_RGRD(data);\
		data = ((data >> 16) & MAC_GPIOS_GPO_MASK);\
} while (0)

/*#define MAC_GPIOS_GPIS_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_GPIOS_GPIS_MASK (ULONG)(0xffff)

#define MAC_GPIOS_GPIS_UDFRD(data) do {\
		MAC_GPIOS_RGRD(data);\
		data = ((data >> 0) & MAC_GPIOS_GPIS_MASK);\
} while (0)

#define MAC_PCS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xf8))

#define MAC_PCS_RGWR(data) do {\
		iowrite32(data, (void *)MAC_PCS_RGOFFADDR);\
} while (0)

#define MAC_PCS_RGRD(data) do {\
		(data) = ioread32((void *)MAC_PCS_RGOFFADDR);\
} while (0)

/*#define  MAC_PCS_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  MAC_PCS_MASK_22 (ULONG)(0x3ff)

/*#define MAC_PCS_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define MAC_PCS_RES_WR_MASK_22 (ULONG)(0x3fffff)

/*#define  MAC_PCS_Mask_5 (ULONG)(~(~0<<(11)))*/

#define  MAC_PCS_MASK_5 (ULONG)(0x7ff)

/*#define MAC_PCS_RES_Wr_Mask_5 (ULONG)(~((~(~0<<(11)))<<(5)))*/

#define MAC_PCS_RES_WR_MASK_5 (ULONG)(0xffff001f)

/*#define  MAC_PCS_Mask_3 (ULONG)(~(~0<<(1)))*/

#define  MAC_PCS_MASK_3 (ULONG)(0x1)

/*#define MAC_PCS_RES_Wr_Mask_3 (ULONG)(~((~(~0<<(1)))<<(3)))*/

#define MAC_PCS_RES_WR_MASK_3 (ULONG)(0xfffffff7)

/*#define MAC_PCS_FALSCARDET_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PCS_FALSCARDET_MASK (ULONG)(0x1)

/*#define MAC_PCS_FALSCARDET_Wr_Mask (ULONG)(~((~(~0 << (1))) << (21)))*/

#define MAC_PCS_FALSCARDET_WR_MASK (ULONG)(0xffdfffff)

#define MAC_PCS_FALSCARDET_UDFWR(data) do {\
		ULONG v;\
		MAC_PCS_RGRD(v);\
		v = (v & (MAC_PCS_RES_WR_MASK_22)) | (((0) & (MAC_PCS_MASK_22)) << 22);\
		v = (v & (MAC_PCS_RES_WR_MASK_5)) | (((0) & (MAC_PCS_MASK_5)) << 5);\
		v = (v & (MAC_PCS_RES_WR_MASK_3)) | (((0) & (MAC_PCS_MASK_3)) << 3);\
		v = ((v & MAC_PCS_FALSCARDET_WR_MASK) | ((data & MAC_PCS_FALSCARDET_MASK) << 21));\
		MAC_PCS_RGWR(v);\
} while (0)

#define MAC_PCS_FALSCARDET_UDFRD(data) do {\
		MAC_PCS_RGRD(data);\
		data = ((data >> 21) & MAC_PCS_FALSCARDET_MASK);\
} while (0)

/*#define MAC_PCS_JABTO_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PCS_JABTO_MASK (ULONG)(0x1)

/*#define MAC_PCS_JABTO_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MAC_PCS_JABTO_WR_MASK (ULONG)(0xffefffff)

#define MAC_PCS_JABTO_UDFWR(data) do {\
		ULONG v;\
		MAC_PCS_RGRD(v);\
		v = (v & (MAC_PCS_RES_WR_MASK_22)) | (((0) & (MAC_PCS_MASK_22)) << 22);\
		v = (v & (MAC_PCS_RES_WR_MASK_5)) | (((0) & (MAC_PCS_MASK_5)) << 5);\
		v = (v & (MAC_PCS_RES_WR_MASK_3)) | (((0) & (MAC_PCS_MASK_3)) << 3);\
		v = ((v & MAC_PCS_JABTO_WR_MASK) | ((data & MAC_PCS_JABTO_MASK) << 20));\
		MAC_PCS_RGWR(v);\
} while (0)

#define MAC_PCS_JABTO_UDFRD(data) do {\
		MAC_PCS_RGRD(data);\
		data = ((data >> 20) & MAC_PCS_JABTO_MASK);\
} while (0)

/*#define MAC_PCS_LNKSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PCS_LNKSTS_MASK (ULONG)(0x1)

/*#define MAC_PCS_LNKSTS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MAC_PCS_LNKSTS_WR_MASK (ULONG)(0xfff7ffff)

#define MAC_PCS_LNKSTS_UDFWR(data) do {\
		ULONG v;\
		MAC_PCS_RGRD(v);\
		v = (v & (MAC_PCS_RES_WR_MASK_22)) | (((0) & (MAC_PCS_MASK_22)) << 22);\
		v = (v & (MAC_PCS_RES_WR_MASK_5)) | (((0) & (MAC_PCS_MASK_5)) << 5);\
		v = (v & (MAC_PCS_RES_WR_MASK_3)) | (((0) & (MAC_PCS_MASK_3)) << 3);\
		v = ((v & MAC_PCS_LNKSTS_WR_MASK) | ((data & MAC_PCS_LNKSTS_MASK) << 19));\
		MAC_PCS_RGWR(v);\
} while (0)

#define MAC_PCS_LNKSTS_UDFRD(data) do {\
		MAC_PCS_RGRD(data);\
		data = ((data >> 19) & MAC_PCS_LNKSTS_MASK);\
} while (0)

/*#define MAC_PCS_LNKSPEED_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_PCS_LNKSPEED_MASK (ULONG)(0x3)

/*#define MAC_PCS_LNKSPEED_Wr_Mask (ULONG)(~((~(~0 << (2))) << (17)))*/

#define MAC_PCS_LNKSPEED_WR_MASK (ULONG)(0xfff9ffff)

#define MAC_PCS_LNKSPEED_UDFWR(data) do {\
		ULONG v;\
		MAC_PCS_RGRD(v);\
		v = (v & (MAC_PCS_RES_WR_MASK_22)) | (((0) & (MAC_PCS_MASK_22)) << 22);\
		v = (v & (MAC_PCS_RES_WR_MASK_5)) | (((0) & (MAC_PCS_MASK_5)) << 5);\
		v = (v & (MAC_PCS_RES_WR_MASK_3)) | (((0) & (MAC_PCS_MASK_3)) << 3);\
		v = ((v & MAC_PCS_LNKSPEED_WR_MASK) | ((data & MAC_PCS_LNKSPEED_MASK) << 17));\
		MAC_PCS_RGWR(v);\
} while (0)

#define MAC_PCS_LNKSPEED_UDFRD(data) do {\
		MAC_PCS_RGRD(data);\
		data = ((data >> 17) & MAC_PCS_LNKSPEED_MASK);\
} while (0)

/*#define MAC_PCS_LNKMOD_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PCS_LNKMOD_MASK (ULONG)(0x1)

/*#define MAC_PCS_LNKMOD_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MAC_PCS_LNKMOD_WR_MASK (ULONG)(0xfffeffff)

#define MAC_PCS_LNKMOD_UDFWR(data) do {\
		ULONG v;\
		MAC_PCS_RGRD(v);\
		v = (v & (MAC_PCS_RES_WR_MASK_22)) | (((0) & (MAC_PCS_MASK_22)) << 22);\
		v = (v & (MAC_PCS_RES_WR_MASK_5)) | (((0) & (MAC_PCS_MASK_5)) << 5);\
		v = (v & (MAC_PCS_RES_WR_MASK_3)) | (((0) & (MAC_PCS_MASK_3)) << 3);\
		v = ((v & MAC_PCS_LNKMOD_WR_MASK) | ((data & MAC_PCS_LNKMOD_MASK) << 16));\
		MAC_PCS_RGWR(v);\
} while (0)

#define MAC_PCS_LNKMOD_UDFRD(data) do {\
		MAC_PCS_RGRD(data);\
		data = ((data >> 16) & MAC_PCS_LNKMOD_MASK);\
} while (0)

/*#define MAC_PCS_SMIDRXS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PCS_SMIDRXS_MASK (ULONG)(0x1)

/*#define MAC_PCS_SMIDRXS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MAC_PCS_SMIDRXS_WR_MASK (ULONG)(0xffffffef)

#define MAC_PCS_SMIDRXS_UDFWR(data) do {\
		ULONG v;\
		MAC_PCS_RGRD(v);\
		v = (v & (MAC_PCS_RES_WR_MASK_22)) | (((0) & (MAC_PCS_MASK_22)) << 22);\
		v = (v & (MAC_PCS_RES_WR_MASK_5)) | (((0) & (MAC_PCS_MASK_5)) << 5);\
		v = (v & (MAC_PCS_RES_WR_MASK_3)) | (((0) & (MAC_PCS_MASK_3)) << 3);\
		v = ((v & MAC_PCS_SMIDRXS_WR_MASK) | ((data & MAC_PCS_SMIDRXS_MASK) << 4));\
		MAC_PCS_RGWR(v);\
} while (0)

#define MAC_PCS_SMIDRXS_UDFRD(data) do {\
		MAC_PCS_RGRD(data);\
		data = ((data >> 4) & MAC_PCS_SMIDRXS_MASK);\
} while (0)

/*#define MAC_PCS_SFTERR_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PCS_SFTERR_MASK (ULONG)(0x1)

/*#define MAC_PCS_SFTERR_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MAC_PCS_SFTERR_WR_MASK (ULONG)(0xfffffffb)

#define MAC_PCS_SFTERR_UDFWR(data) do {\
		ULONG v;\
		MAC_PCS_RGRD(v);\
		v = (v & (MAC_PCS_RES_WR_MASK_22)) | (((0) & (MAC_PCS_MASK_22)) << 22);\
		v = (v & (MAC_PCS_RES_WR_MASK_5)) | (((0) & (MAC_PCS_MASK_5)) << 5);\
		v = (v & (MAC_PCS_RES_WR_MASK_3)) | (((0) & (MAC_PCS_MASK_3)) << 3);\
		v = ((v & MAC_PCS_SFTERR_WR_MASK) | ((data & MAC_PCS_SFTERR_MASK) << 2));\
		MAC_PCS_RGWR(v);\
} while (0)

#define MAC_PCS_SFTERR_UDFRD(data) do {\
		MAC_PCS_RGRD(data);\
		data = ((data >> 2) & MAC_PCS_SFTERR_MASK);\
} while (0)

/*#define MAC_PCS_LUD_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PCS_LUD_MASK (ULONG)(0x1)

/*#define MAC_PCS_LUD_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_PCS_LUD_WR_MASK (ULONG)(0xfffffffd)

#define MAC_PCS_LUD_UDFWR(data) do {\
		ULONG v;\
		MAC_PCS_RGRD(v);\
		v = (v & (MAC_PCS_RES_WR_MASK_22)) | (((0) & (MAC_PCS_MASK_22)) << 22);\
		v = (v & (MAC_PCS_RES_WR_MASK_5)) | (((0) & (MAC_PCS_MASK_5)) << 5);\
		v = (v & (MAC_PCS_RES_WR_MASK_3)) | (((0) & (MAC_PCS_MASK_3)) << 3);\
		v = ((v & MAC_PCS_LUD_WR_MASK) | ((data & MAC_PCS_LUD_MASK) << 1));\
		MAC_PCS_RGWR(v);\
} while (0)

#define MAC_PCS_LUD_UDFRD(data) do {\
		MAC_PCS_RGRD(data);\
		data = ((data >> 1) & MAC_PCS_LUD_MASK);\
} while (0)

/*#define MAC_PCS_TC_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PCS_TC_MASK (ULONG)(0x1)

/*#define MAC_PCS_TC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_PCS_TC_WR_MASK (ULONG)(0xfffffffe)

#define MAC_PCS_TC_UDFWR(data) do {\
		ULONG v;\
		MAC_PCS_RGRD(v);\
		v = (v & (MAC_PCS_RES_WR_MASK_22)) | (((0) & (MAC_PCS_MASK_22)) << 22);\
		v = (v & (MAC_PCS_RES_WR_MASK_5)) | (((0) & (MAC_PCS_MASK_5)) << 5);\
		v = (v & (MAC_PCS_RES_WR_MASK_3)) | (((0) & (MAC_PCS_MASK_3)) << 3);\
		v = ((v & MAC_PCS_TC_WR_MASK) | ((data & MAC_PCS_TC_MASK) << 0));\
		MAC_PCS_RGWR(v);\
} while (0)

#define MAC_PCS_TC_UDFRD(data) do {\
		MAC_PCS_RGRD(data);\
		data = ((data >> 0) & MAC_PCS_TC_MASK);\
} while (0)

#define MAC_TES_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xf4))

#define MAC_TES_RGRD(data) do {\
		(data) = ioread32((void *)MAC_TES_RGOFFADDR);\
} while (0)

/*#define MAC_TES_GFD_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TES_GFD_MASK (ULONG)(0x1)

#define MAC_TES_GFD_UDFRD(data) do {\
		MAC_TES_RGRD(data);\
		data = ((data >> 15) & MAC_TES_GFD_MASK);\
} while (0)

/*#define MAC_TES_GHD_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TES_GHD_MASK (ULONG)(0x1)

#define MAC_TES_GHD_UDFRD(data) do {\
		MAC_TES_RGRD(data);\
		data = ((data >> 14) & MAC_TES_GHD_MASK);\
} while (0)

#define MAC_AE_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xf0))

#define MAC_AE_RGRD(data) do {\
		(data) = ioread32((void *)MAC_AE_RGOFFADDR);\
} while (0)

/*#define MAC_AE_NPA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_AE_NPA_MASK (ULONG)(0x1)

#define MAC_AE_NPA_UDFRD(data) do {\
		MAC_AE_RGRD(data);\
		data = ((data >> 2) & MAC_AE_NPA_MASK);\
} while (0)

/*#define MAC_AE_NPR_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_AE_NPR_MASK (ULONG)(0x1)

#define MAC_AE_NPR_UDFRD(data) do {\
		MAC_AE_RGRD(data);\
		data = ((data >> 1) & MAC_AE_NPR_MASK);\
} while (0)

#define MAC_ALPA_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xec))

#define MAC_ALPA_RGRD(data) do {\
		(data) = ioread32((void *)MAC_ALPA_RGOFFADDR);\
} while (0)

/*#define MAC_ALPA_NP_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ALPA_NP_MASK (ULONG)(0x1)

#define MAC_ALPA_NP_UDFRD(data) do {\
		MAC_ALPA_RGRD(data);\
		data = ((data >> 15) & MAC_ALPA_NP_MASK);\
} while (0)

/*#define MAC_ALPA_ACK_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ALPA_ACK_MASK (ULONG)(0x1)

#define MAC_ALPA_ACK_UDFRD(data) do {\
		MAC_ALPA_RGRD(data);\
		data = ((data >> 14) & MAC_ALPA_ACK_MASK);\
} while (0)

/*#define MAC_ALPA_RFE_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_ALPA_RFE_MASK (ULONG)(0x3)

#define MAC_ALPA_RFE_UDFRD(data) do {\
		MAC_ALPA_RGRD(data);\
		data = ((data >> 12) & MAC_ALPA_RFE_MASK);\
} while (0)

/*#define MAC_ALPA_PSE_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_ALPA_PSE_MASK (ULONG)(0x3)

#define MAC_ALPA_PSE_UDFRD(data) do {\
		MAC_ALPA_RGRD(data);\
		data = ((data >> 7) & MAC_ALPA_PSE_MASK);\
} while (0)

/*#define MAC_ALPA_HD_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ALPA_HD_MASK (ULONG)(0x1)

#define MAC_ALPA_HD_UDFRD(data) do {\
		MAC_ALPA_RGRD(data);\
		data = ((data >> 6) & MAC_ALPA_HD_MASK);\
} while (0)

/*#define MAC_ALPA_FD_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ALPA_FD_MASK (ULONG)(0x1)

#define MAC_ALPA_FD_UDFRD(data) do {\
		MAC_ALPA_RGRD(data);\
		data = ((data >> 5) & MAC_ALPA_FD_MASK);\
} while (0)

#define MAC_AAD_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe8))

#define MAC_AAD_RGWR(data) do {\
		iowrite32(data, (void *)MAC_AAD_RGOFFADDR);\
} while (0)

#define MAC_AAD_RGRD(data) do {\
		(data) = ioread32((void *)MAC_AAD_RGOFFADDR);\
} while (0)

/*#define  MAC_AAD_Mask_16 (ULONG)(~(~0<<(16)))*/

#define  MAC_AAD_MASK_16 (ULONG)(0xffff)

/*#define MAC_AAD_RES_Wr_Mask_16 (ULONG)(~((~(~0<<(16)))<<(16)))*/

#define MAC_AAD_RES_WR_MASK_16 (ULONG)(0xffff)

/*#define  MAC_AAD_Mask_14 (ULONG)(~(~0<<(1)))*/

#define  MAC_AAD_MASK_14 (ULONG)(0x1)

/*#define MAC_AAD_RES_Wr_Mask_14 (ULONG)(~((~(~0<<(1)))<<(14)))*/

#define MAC_AAD_RES_WR_MASK_14 (ULONG)(0xffffbfff)

/*#define  MAC_AAD_Mask_9 (ULONG)(~(~0<<(3)))*/

#define  MAC_AAD_MASK_9 (ULONG)(0x7)

/*#define MAC_AAD_RES_Wr_Mask_9 (ULONG)(~((~(~0<<(3)))<<(9)))*/

#define MAC_AAD_RES_WR_MASK_9 (ULONG)(0xfffff1ff)

/*#define  MAC_AAD_Mask_0 (ULONG)(~(~0<<(5)))*/

#define  MAC_AAD_MASK_0 (ULONG)(0x1f)

/*#define MAC_AAD_RES_Wr_Mask_0 (ULONG)(~((~(~0<<(5)))<<(0)))*/

#define MAC_AAD_RES_WR_MASK_0 (ULONG)(0xffffffe0)

/*#define MAC_AAD_NPS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_AAD_NPS_MASK (ULONG)(0x1)

/*#define MAC_AAD_NPS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (15)))*/

#define MAC_AAD_NPS_WR_MASK (ULONG)(0xffff7fff)

#define MAC_AAD_NPS_UDFWR(data) do {\
		ULONG v;\
		MAC_AAD_RGRD(v);\
		v = (v & (MAC_AAD_RES_WR_MASK_16)) | (((0) & (MAC_AAD_MASK_16)) << 16);\
		v = (v & (MAC_AAD_RES_WR_MASK_14)) | (((0) & (MAC_AAD_MASK_14)) << 14);\
		v = (v & (MAC_AAD_RES_WR_MASK_9)) | (((0) & (MAC_AAD_MASK_9)) << 9);\
		v = (v & (MAC_AAD_RES_WR_MASK_0)) | (((0) & (MAC_AAD_MASK_0)) << 0);\
		v = ((v & MAC_AAD_NPS_WR_MASK) | ((data & MAC_AAD_NPS_MASK) << 15));\
		MAC_AAD_RGWR(v);\
} while (0)

#define MAC_AAD_NPS_UDFRD(data) do {\
		MAC_AAD_RGRD(data);\
		data = ((data >> 15) & MAC_AAD_NPS_MASK);\
} while (0)

/*#define MAC_AAD_RFE_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_AAD_RFE_MASK (ULONG)(0x3)

/*#define MAC_AAD_RFE_Wr_Mask (ULONG)(~((~(~0 << (2))) << (12)))*/

#define MAC_AAD_RFE_WR_MASK (ULONG)(0xffffcfff)

#define MAC_AAD_RFE_UDFWR(data) do {\
		ULONG v;\
		MAC_AAD_RGRD(v);\
		v = (v & (MAC_AAD_RES_WR_MASK_16)) | (((0) & (MAC_AAD_MASK_16)) << 16);\
		v = (v & (MAC_AAD_RES_WR_MASK_14)) | (((0) & (MAC_AAD_MASK_14)) << 14);\
		v = (v & (MAC_AAD_RES_WR_MASK_9)) | (((0) & (MAC_AAD_MASK_9)) << 9);\
		v = (v & (MAC_AAD_RES_WR_MASK_0)) | (((0) & (MAC_AAD_MASK_0)) << 0);\
		v = ((v & MAC_AAD_RFE_WR_MASK) | ((data & MAC_AAD_RFE_MASK) << 12));\
		MAC_AAD_RGWR(v);\
} while (0)

#define MAC_AAD_RFE_UDFRD(data) do {\
		MAC_AAD_RGRD(data);\
		data = ((data >> 12) & MAC_AAD_RFE_MASK);\
} while (0)

/*#define MAC_AAD_PSE_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_AAD_PSE_MASK (ULONG)(0x3)

/*#define MAC_AAD_PSE_Wr_Mask (ULONG)(~((~(~0 << (2))) << (7)))*/

#define MAC_AAD_PSE_WR_MASK (ULONG)(0xfffffe7f)

#define MAC_AAD_PSE_UDFWR(data) do {\
		ULONG v;\
		MAC_AAD_RGRD(v);\
		v = (v & (MAC_AAD_RES_WR_MASK_16)) | (((0) & (MAC_AAD_MASK_16)) << 16);\
		v = (v & (MAC_AAD_RES_WR_MASK_14)) | (((0) & (MAC_AAD_MASK_14)) << 14);\
		v = (v & (MAC_AAD_RES_WR_MASK_9)) | (((0) & (MAC_AAD_MASK_9)) << 9);\
		v = (v & (MAC_AAD_RES_WR_MASK_0)) | (((0) & (MAC_AAD_MASK_0)) << 0);\
		v = ((v & MAC_AAD_PSE_WR_MASK) | ((data & MAC_AAD_PSE_MASK) << 7));\
		MAC_AAD_RGWR(v);\
} while (0)

#define MAC_AAD_PSE_UDFRD(data) do {\
		MAC_AAD_RGRD(data);\
		data = ((data >> 7) & MAC_AAD_PSE_MASK);\
} while (0)

/*#define MAC_AAD_HD_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_AAD_HD_MASK (ULONG)(0x1)

/*#define MAC_AAD_HD_Wr_Mask (ULONG)(~((~(~0 << (1))) << (6)))*/

#define MAC_AAD_HD_WR_MASK (ULONG)(0xffffffbf)

#define MAC_AAD_HD_UDFWR(data) do {\
		ULONG v;\
		MAC_AAD_RGRD(v);\
		v = (v & (MAC_AAD_RES_WR_MASK_16)) | (((0) & (MAC_AAD_MASK_16)) << 16);\
		v = (v & (MAC_AAD_RES_WR_MASK_14)) | (((0) & (MAC_AAD_MASK_14)) << 14);\
		v = (v & (MAC_AAD_RES_WR_MASK_9)) | (((0) & (MAC_AAD_MASK_9)) << 9);\
		v = (v & (MAC_AAD_RES_WR_MASK_0)) | (((0) & (MAC_AAD_MASK_0)) << 0);\
		v = ((v & MAC_AAD_HD_WR_MASK) | ((data & MAC_AAD_HD_MASK) << 6));\
		MAC_AAD_RGWR(v);\
} while (0)

#define MAC_AAD_HD_UDFRD(data) do {\
		MAC_AAD_RGRD(data);\
		data = ((data >> 6) & MAC_AAD_HD_MASK);\
} while (0)

/*#define MAC_AAD_FD_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_AAD_FD_MASK (ULONG)(0x1)

/*#define MAC_AAD_FD_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MAC_AAD_FD_WR_MASK (ULONG)(0xffffffdf)

#define MAC_AAD_FD_UDFWR(data) do {\
		ULONG v;\
		MAC_AAD_RGRD(v);\
		v = (v & (MAC_AAD_RES_WR_MASK_16)) | (((0) & (MAC_AAD_MASK_16)) << 16);\
		v = (v & (MAC_AAD_RES_WR_MASK_14)) | (((0) & (MAC_AAD_MASK_14)) << 14);\
		v = (v & (MAC_AAD_RES_WR_MASK_9)) | (((0) & (MAC_AAD_MASK_9)) << 9);\
		v = (v & (MAC_AAD_RES_WR_MASK_0)) | (((0) & (MAC_AAD_MASK_0)) << 0);\
		v = ((v & MAC_AAD_FD_WR_MASK) | ((data & MAC_AAD_FD_MASK) << 5));\
		MAC_AAD_RGWR(v);\
} while (0)

#define MAC_AAD_FD_UDFRD(data) do {\
		MAC_AAD_RGRD(data);\
		data = ((data >> 5) & MAC_AAD_FD_MASK);\
} while (0)

#define MAC_ANS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe4))

#define MAC_ANS_RGRD(data) do {\
		(data) = ioread32((void *)MAC_ANS_RGOFFADDR);\
} while (0)

/*#define MAC_ANS_ES_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ANS_ES_MASK (ULONG)(0x1)

#define MAC_ANS_ES_UDFRD(data) do {\
		MAC_ANS_RGRD(data);\
		data = ((data >> 8) & MAC_ANS_ES_MASK);\
} while (0)

/*#define MAC_ANS_ANC_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ANS_ANC_MASK (ULONG)(0x1)

#define MAC_ANS_ANC_UDFRD(data) do {\
		MAC_ANS_RGRD(data);\
		data = ((data >> 5) & MAC_ANS_ANC_MASK);\
} while (0)

/*#define MAC_ANS_ANA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ANS_ANA_MASK (ULONG)(0x1)

#define MAC_ANS_ANA_UDFRD(data) do {\
		MAC_ANS_RGRD(data);\
		data = ((data >> 3) & MAC_ANS_ANA_MASK);\
} while (0)

/*#define MAC_ANS_LS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ANS_LS_MASK (ULONG)(0x1)

#define MAC_ANS_LS_UDFRD(data) do {\
		MAC_ANS_RGRD(data);\
		data = ((data >> 2) & MAC_ANS_LS_MASK);\
} while (0)

#define MAC_ANC_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe0))

#define MAC_ANC_RGWR(data) do {\
		iowrite32(data, (void *)MAC_ANC_RGOFFADDR);\
} while (0)

#define MAC_ANC_RGRD(data) do {\
		(data) = ioread32((void *)MAC_ANC_RGOFFADDR);\
} while (0)

/*#define  MAC_ANC_Mask_19 (ULONG)(~(~0<<(13)))*/

#define  MAC_ANC_MASK_19 (ULONG)(0x1fff)

/*#define MAC_ANC_RES_Wr_Mask_19 (ULONG)(~((~(~0<<(13)))<<(19)))*/

#define MAC_ANC_RES_WR_MASK_19 (ULONG)(0x7ffff)

/*#define  MAC_ANC_Mask_15 (ULONG)(~(~0<<(1)))*/

#define  MAC_ANC_MASK_15 (ULONG)(0x1)

/*#define MAC_ANC_RES_Wr_Mask_15 (ULONG)(~((~(~0<<(1)))<<(15)))*/

#define MAC_ANC_RES_WR_MASK_15 (ULONG)(0xffff7fff)

/*#define  MAC_ANC_Mask_13 (ULONG)(~(~0<<(1)))*/

#define  MAC_ANC_MASK_13 (ULONG)(0x1)

/*#define MAC_ANC_RES_Wr_Mask_13 (ULONG)(~((~(~0<<(1)))<<(13)))*/

#define MAC_ANC_RES_WR_MASK_13 (ULONG)(0xffffdfff)

/*#define  MAC_ANC_Mask_10 (ULONG)(~(~0<<(2)))*/

#define  MAC_ANC_MASK_10 (ULONG)(0x3)

/*#define MAC_ANC_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(2)))<<(10)))*/

#define MAC_ANC_RES_WR_MASK_10 (ULONG)(0xfffff3ff)

/*#define  MAC_ANC_Mask_0 (ULONG)(~(~0<<(9)))*/

#define  MAC_ANC_MASK_0 (ULONG)(0x1ff)

/*#define MAC_ANC_RES_Wr_Mask_0 (ULONG)(~((~(~0<<(9)))<<(0)))*/

#define MAC_ANC_RES_WR_MASK_0 (ULONG)(0xfffffe00)

/*#define MAC_ANC_SGMRAL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ANC_SGMRAL_MASK (ULONG)(0x1)

/*#define MAC_ANC_SGMRAL_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MAC_ANC_SGMRAL_WR_MASK (ULONG)(0xfffbffff)

#define MAC_ANC_SGMRAL_UDFWR(data) do {\
		ULONG v;\
		MAC_ANC_RGRD(v);\
		v = (v & (MAC_ANC_RES_WR_MASK_19)) | (((0) & (MAC_ANC_MASK_19)) << 19);\
		v = (v & (MAC_ANC_RES_WR_MASK_15)) | (((0) & (MAC_ANC_MASK_15)) << 15);\
		v = (v & (MAC_ANC_RES_WR_MASK_13)) | (((0) & (MAC_ANC_MASK_13)) << 13);\
		v = (v & (MAC_ANC_RES_WR_MASK_10)) | (((0) & (MAC_ANC_MASK_10)) << 10);\
		v = (v & (MAC_ANC_RES_WR_MASK_0)) | (((0) & (MAC_ANC_MASK_0)) << 0);\
		v = ((v & MAC_ANC_SGMRAL_WR_MASK) | ((data & MAC_ANC_SGMRAL_MASK) << 18));\
		MAC_ANC_RGWR(v);\
} while (0)

#define MAC_ANC_SGMRAL_UDFRD(data) do {\
		MAC_ANC_RGRD(data);\
		data = ((data >> 18) & MAC_ANC_SGMRAL_MASK);\
} while (0)

/*#define MAC_ANC_LR_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ANC_LR_MASK (ULONG)(0x1)

/*#define MAC_ANC_LR_Wr_Mask (ULONG)(~((~(~0 << (1))) << (17)))*/

#define MAC_ANC_LR_WR_MASK (ULONG)(0xfffdffff)

#define MAC_ANC_LR_UDFWR(data) do {\
		ULONG v;\
		MAC_ANC_RGRD(v);\
		v = (v & (MAC_ANC_RES_WR_MASK_19)) | (((0) & (MAC_ANC_MASK_19)) << 19);\
		v = (v & (MAC_ANC_RES_WR_MASK_15)) | (((0) & (MAC_ANC_MASK_15)) << 15);\
		v = (v & (MAC_ANC_RES_WR_MASK_13)) | (((0) & (MAC_ANC_MASK_13)) << 13);\
		v = (v & (MAC_ANC_RES_WR_MASK_10)) | (((0) & (MAC_ANC_MASK_10)) << 10);\
		v = (v & (MAC_ANC_RES_WR_MASK_0)) | (((0) & (MAC_ANC_MASK_0)) << 0);\
		v = ((v & MAC_ANC_LR_WR_MASK) | ((data & MAC_ANC_LR_MASK) << 17));\
		MAC_ANC_RGWR(v);\
} while (0)

#define MAC_ANC_LR_UDFRD(data) do {\
		MAC_ANC_RGRD(data);\
		data = ((data >> 17) & MAC_ANC_LR_MASK);\
} while (0)

/*#define MAC_ANC_ECD_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ANC_ECD_MASK (ULONG)(0x1)

/*#define MAC_ANC_ECD_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MAC_ANC_ECD_WR_MASK (ULONG)(0xfffeffff)

#define MAC_ANC_ECD_UDFWR(data) do {\
		ULONG v;\
		MAC_ANC_RGRD(v);\
		v = (v & (MAC_ANC_RES_WR_MASK_19)) | (((0) & (MAC_ANC_MASK_19)) << 19);\
		v = (v & (MAC_ANC_RES_WR_MASK_15)) | (((0) & (MAC_ANC_MASK_15)) << 15);\
		v = (v & (MAC_ANC_RES_WR_MASK_13)) | (((0) & (MAC_ANC_MASK_13)) << 13);\
		v = (v & (MAC_ANC_RES_WR_MASK_10)) | (((0) & (MAC_ANC_MASK_10)) << 10);\
		v = (v & (MAC_ANC_RES_WR_MASK_0)) | (((0) & (MAC_ANC_MASK_0)) << 0);\
		v = ((v & MAC_ANC_ECD_WR_MASK) | ((data & MAC_ANC_ECD_MASK) << 16));\
		MAC_ANC_RGWR(v);\
} while (0)

#define MAC_ANC_ECD_UDFRD(data) do {\
		MAC_ANC_RGRD(data);\
		data = ((data >> 16) & MAC_ANC_ECD_MASK);\
} while (0)

/*#define MAC_ANC_ELE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ANC_ELE_MASK (ULONG)(0x1)

/*#define MAC_ANC_ELE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (14)))*/

#define MAC_ANC_ELE_WR_MASK (ULONG)(0xffffbfff)

#define MAC_ANC_ELE_UDFWR(data) do {\
		ULONG v;\
		MAC_ANC_RGRD(v);\
		v = (v & (MAC_ANC_RES_WR_MASK_19)) | (((0) & (MAC_ANC_MASK_19)) << 19);\
		v = (v & (MAC_ANC_RES_WR_MASK_15)) | (((0) & (MAC_ANC_MASK_15)) << 15);\
		v = (v & (MAC_ANC_RES_WR_MASK_13)) | (((0) & (MAC_ANC_MASK_13)) << 13);\
		v = (v & (MAC_ANC_RES_WR_MASK_10)) | (((0) & (MAC_ANC_MASK_10)) << 10);\
		v = (v & (MAC_ANC_RES_WR_MASK_0)) | (((0) & (MAC_ANC_MASK_0)) << 0);\
		v = ((v & MAC_ANC_ELE_WR_MASK) | ((data & MAC_ANC_ELE_MASK) << 14));\
		MAC_ANC_RGWR(v);\
} while (0)

#define MAC_ANC_ELE_UDFRD(data) do {\
		MAC_ANC_RGRD(data);\
		data = ((data >> 14) & MAC_ANC_ELE_MASK);\
} while (0)

/*#define MAC_ANC_ANE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ANC_ANE_MASK (ULONG)(0x1)

/*#define MAC_ANC_ANE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define MAC_ANC_ANE_WR_MASK (ULONG)(0xffffefff)

#define MAC_ANC_ANE_UDFWR(data) do {\
		ULONG v;\
		MAC_ANC_RGRD(v);\
		v = (v & (MAC_ANC_RES_WR_MASK_19)) | (((0) & (MAC_ANC_MASK_19)) << 19);\
		v = (v & (MAC_ANC_RES_WR_MASK_15)) | (((0) & (MAC_ANC_MASK_15)) << 15);\
		v = (v & (MAC_ANC_RES_WR_MASK_13)) | (((0) & (MAC_ANC_MASK_13)) << 13);\
		v = (v & (MAC_ANC_RES_WR_MASK_10)) | (((0) & (MAC_ANC_MASK_10)) << 10);\
		v = (v & (MAC_ANC_RES_WR_MASK_0)) | (((0) & (MAC_ANC_MASK_0)) << 0);\
		v = ((v & MAC_ANC_ANE_WR_MASK) | ((data & MAC_ANC_ANE_MASK) << 12));\
		MAC_ANC_RGWR(v);\
} while (0)

#define MAC_ANC_ANE_UDFRD(data) do {\
		MAC_ANC_RGRD(data);\
		data = ((data >> 12) & MAC_ANC_ANE_MASK);\
} while (0)

/*#define MAC_ANC_RAN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ANC_RAN_MASK (ULONG)(0x1)

/*#define MAC_ANC_RAN_Wr_Mask (ULONG)(~((~(~0 << (1))) << (9)))*/

#define MAC_ANC_RAN_WR_MASK (ULONG)(0xfffffdff)

#define MAC_ANC_RAN_UDFWR(data) do {\
		ULONG v;\
		MAC_ANC_RGRD(v);\
		v = (v & (MAC_ANC_RES_WR_MASK_19)) | (((0) & (MAC_ANC_MASK_19)) << 19);\
		v = (v & (MAC_ANC_RES_WR_MASK_15)) | (((0) & (MAC_ANC_MASK_15)) << 15);\
		v = (v & (MAC_ANC_RES_WR_MASK_13)) | (((0) & (MAC_ANC_MASK_13)) << 13);\
		v = (v & (MAC_ANC_RES_WR_MASK_10)) | (((0) & (MAC_ANC_MASK_10)) << 10);\
		v = (v & (MAC_ANC_RES_WR_MASK_0)) | (((0) & (MAC_ANC_MASK_0)) << 0);\
		v = ((v & MAC_ANC_RAN_WR_MASK) | ((data & MAC_ANC_RAN_MASK) << 9));\
		MAC_ANC_RGWR(v);\
} while (0)

#define MAC_ANC_RAN_UDFRD(data) do {\
		MAC_ANC_RGRD(data);\
		data = ((data >> 9) & MAC_ANC_RAN_MASK);\
} while (0)

#define MAC_1USTICK_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xdc))

#define MAC_1USTICK_RGWR(data) do {\
		iowrite32(data, (void *)MAC_1USTICK_RGOFFADDR);\
} while (0)

#define MAC_1USTICK_RGRD(data) do {\
		(data) = ioread32((void *)MAC_1USTICK_RGOFFADDR);\
} while (0)

#define MAC_1USTICK_CNTR_MASK 0xFFF
#define MAC_1USTICK_CNTR_WR_MASK 0xFFFFF000

#define MAC_1USTICK_CNTR_UDFWR(data) do {\
		ULONG v;\
		MAC_1USTICK_RGRD(v);\
		v = ((v & MAC_1USTICK_CNTR_WR_MASK) | ((data & MAC_1USTICK_CNTR_MASK) << 0));\
		MAC_1USTICK_RGWR(v);\
} while (0)

#define MAC_1USTICK_CNTR_UDFRD(data) do {\
		MAC_1USTICK_RGRD(data);\
		data = ((data >> 0) & MAC_1USTICK_CNTR_MASK);\
} while (0)


#define MAC_LPET_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd8))

#define MAC_LPET_RGWR(data) do {\
		iowrite32(data, (void *)MAC_LPET_RGOFFADDR);\
} while (0)

#define MAC_LPET_RGRD(data) do {\
		(data) = ioread32((void *)MAC_LPET_RGOFFADDR);\
} while (0)

#define MAC_LPET_LPIET_MASK 0xFFFF
#define MAC_LPET_LPIET_WR_MASK 0xFFF80007

#define MAC_LPET_LPIET_UDFWR(data) do {\
		ULONG v;\
		MAC_LPET_RGRD(v);\
		v = ((v & MAC_LPET_LPIET_WR_MASK) | ((data & MAC_LPET_LPIET_MASK) << 3));\
		MAC_LPET_RGWR(v);\
} while (0)

#define MAC_LPET_LPIET_UDFRD(data) do {\
		MAC_LPET_RGRD(data);\
		data = ((data >> 3) & MAC_LPET_LPIET_MASK);\
} while (0)

#define MAC_LPC_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd4))

#define MAC_LPC_RGWR(data) do {\
		iowrite32(data, (void *)MAC_LPC_RGOFFADDR);\
} while (0)

#define MAC_LPC_RGRD(data) do {\
		(data) = ioread32((void *)MAC_LPC_RGOFFADDR);\
} while (0)

/*#define  MAC_LPC_Mask_26 (ULONG)(~(~0<<(6)))*/

#define  MAC_LPC_MASK_26 (ULONG)(0x3f)

/*#define MAC_LPC_RES_Wr_Mask_26 (ULONG)(~((~(~0<<(6)))<<(26)))*/

#define MAC_LPC_RES_WR_MASK_26 (ULONG)(0x3ffffff)

/*#define MAC_LPC_TLPIEX_Mask (ULONG)(~(~0<<(10)))*/

#define MAC_LPC_TLPIEX_MASK (ULONG)(0x3ff)

/*#define MAC_LPC_TLPIEX_Wr_Mask (ULONG)(~((~(~0 << (10))) << (16)))*/

#define MAC_LPC_TLPIEX_WR_MASK (ULONG)(0xfc00ffff)

#define MAC_LPC_TLPIEX_UDFWR(data) do {\
		ULONG v;\
		MAC_LPC_RGRD(v);\
		v = (v & (MAC_LPC_RES_WR_MASK_26)) | (((0) & (MAC_LPC_MASK_26)) << 26);\
		v = ((v & MAC_LPC_TLPIEX_WR_MASK) | ((data & MAC_LPC_TLPIEX_MASK) << 16));\
		MAC_LPC_RGWR(v);\
} while (0)

#define MAC_LPC_TLPIEX_UDFRD(data) do {\
		MAC_LPC_RGRD(data);\
		data = ((data >> 16) & MAC_LPC_TLPIEX_MASK);\
} while (0)

/*#define MAC_LPC_TWT_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_LPC_TWT_MASK (ULONG)(0xffff)

/*#define MAC_LPC_TWT_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_LPC_TWT_WR_MASK (ULONG)(0xffff0000)

#define MAC_LPC_TWT_UDFWR(data) do {\
		ULONG v;\
		MAC_LPC_RGRD(v);\
		v = (v & (MAC_LPC_RES_WR_MASK_26)) | (((0) & (MAC_LPC_MASK_26)) << 26);\
		v = ((v & MAC_LPC_TWT_WR_MASK) | ((data & MAC_LPC_TWT_MASK) << 0));\
		MAC_LPC_RGWR(v);\
} while (0)

#define MAC_LPC_TWT_UDFRD(data) do {\
		MAC_LPC_RGRD(data);\
		data = ((data >> 0) & MAC_LPC_TWT_MASK);\
} while (0)

#define MAC_LPS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd0))

#define MAC_LPS_RGWR(data) do {\
		iowrite32(data, (void *)MAC_LPS_RGOFFADDR);\
} while (0)

#define MAC_LPS_RGRD(data) do {\
		(data) = ioread32((void *)MAC_LPS_RGOFFADDR);\
} while (0)

/*#define  MAC_LPS_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  MAC_LPS_MASK_22 (ULONG)(0xffc)

/*#define MAC_LPS_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define MAC_LPS_RES_WR_MASK_22 (ULONG)(0x3fffff)

/*#define  MAC_LPS_Mask_10 (ULONG)(~(~0<<(6)))*/

#define  MAC_LPS_MASK_10 (ULONG)(0x3f)

/*#define MAC_LPS_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(6)))<<(10)))*/

#define MAC_LPS_RES_WR_MASK_10 (ULONG)(0xffff03ff)

/*#define  MAC_LPS_Mask_4 (ULONG)(~(~0<<(4)))*/

#define  MAC_LPS_MASK_4 (ULONG)(0xf)

/*#define MAC_LPS_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(4)))<<(4)))*/

#define MAC_LPS_RES_WR_MASK_4 (ULONG)(0xffffff0f)

/*#define MAC_LPS_LPITXA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_LPS_LPITXA_MASK (ULONG)(0x1)

/*#define MAC_LPS_LPITXA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MAC_LPS_LPITXA_WR_MASK (ULONG)(0xfff7ffff)

#define MAC_LPS_LPIATE_MASK (ULONG)(0x1)

#define MAC_LPS_LPIATE_WR_MASK (ULONG)(0xffefffff)

#define MAC_LPS_LPITCSE_MASK (ULONG)(0x1)

#define MAC_LPS_LPITCSE_WR_MASK (ULONG)(0xffdfffff)

#define MAC_LPS_LPITCSE_UDFWR(data) do {\
		ULONG v;\
		MAC_LPS_RGRD(v);\
		v = (v & (MAC_LPS_RES_WR_MASK_22)) | (((0) & (MAC_LPS_MASK_22)) << 22);\
		v = (v & (MAC_LPS_RES_WR_MASK_10)) | (((0) & (MAC_LPS_MASK_10)) << 10);\
		v = (v & (MAC_LPS_RES_WR_MASK_4)) | (((0) & (MAC_LPS_MASK_4)) << 4);\
		v = ((v & MAC_LPS_LPITCSE_WR_MASK) | ((data & MAC_LPS_LPITCSE_MASK) << 21));\
		MAC_LPS_RGWR(v);\
} while (0)

#define MAC_LPS_LPITCSE_UDFRD(data) do {\
		MAC_LPS_RGRD(data);\
		data = ((data >> 21) & MAC_LPS_LPITCSE_MASK);\
} while (0)

#define MAC_LPS_LPIATE_UDFWR(data) do {\
		ULONG v;\
		MAC_LPS_RGRD(v);\
		v = (v & (MAC_LPS_RES_WR_MASK_22)) | (((0) & (MAC_LPS_MASK_22)) << 22);\
		v = (v & (MAC_LPS_RES_WR_MASK_10)) | (((0) & (MAC_LPS_MASK_10)) << 10);\
		v = (v & (MAC_LPS_RES_WR_MASK_4)) | (((0) & (MAC_LPS_MASK_4)) << 4);\
		v = ((v & MAC_LPS_LPIATE_WR_MASK) | ((data & MAC_LPS_LPIATE_MASK) << 20));\
		MAC_LPS_RGWR(v);\
} while (0)

#define MAC_LPS_LPIATE_UDFRD(data) do {\
		MAC_LPS_RGRD(data);\
		data = ((data >> 20) & MAC_LPS_LPIATE_MASK);\
} while (0)

#define MAC_LPS_LPITXA_UDFWR(data) do {\
		ULONG v;\
		MAC_LPS_RGRD(v);\
		v = (v & (MAC_LPS_RES_WR_MASK_22)) | (((0) & (MAC_LPS_MASK_22)) << 22);\
		v = (v & (MAC_LPS_RES_WR_MASK_10)) | (((0) & (MAC_LPS_MASK_10)) << 10);\
		v = (v & (MAC_LPS_RES_WR_MASK_4)) | (((0) & (MAC_LPS_MASK_4)) << 4);\
		v = ((v & MAC_LPS_LPITXA_WR_MASK) | ((data & MAC_LPS_LPITXA_MASK) << 19));\
		MAC_LPS_RGWR(v);\
} while (0)

#define MAC_LPS_LPITXA_UDFRD(data) do {\
		MAC_LPS_RGRD(data);\
		data = ((data >> 19) & MAC_LPS_LPITXA_MASK);\
} while (0)

/*#define MAC_LPS_PLSEN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_LPS_PLSEN_MASK (ULONG)(0x1)

/*#define MAC_LPS_PLSEN_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MAC_LPS_PLSEN_WR_MASK (ULONG)(0xfffbffff)

#define MAC_LPS_PLSEN_UDFWR(data) do {\
		ULONG v;\
		MAC_LPS_RGRD(v);\
		v = (v & (MAC_LPS_RES_WR_MASK_22)) | (((0) & (MAC_LPS_MASK_22)) << 22);\
		v = (v & (MAC_LPS_RES_WR_MASK_10)) | (((0) & (MAC_LPS_MASK_10)) << 10);\
		v = (v & (MAC_LPS_RES_WR_MASK_4)) | (((0) & (MAC_LPS_MASK_4)) << 4);\
		v = ((v & MAC_LPS_PLSEN_WR_MASK) | ((data & MAC_LPS_PLSEN_MASK) << 18));\
		MAC_LPS_RGWR(v);\
} while (0)

#define MAC_LPS_PLSEN_UDFRD(data) do {\
		MAC_LPS_RGRD(data);\
		data = ((data >> 18) & MAC_LPS_PLSEN_MASK);\
} while (0)

/*#define MAC_LPS_PLS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_LPS_PLS_MASK (ULONG)(0x1)

/*#define MAC_LPS_PLS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (17)))*/

#define MAC_LPS_PLS_WR_MASK (ULONG)(0xfffdffff)

#define MAC_LPS_PLS_UDFWR(data) do {\
		ULONG v;\
		MAC_LPS_RGRD(v);\
		v = (v & (MAC_LPS_RES_WR_MASK_22)) | (((0) & (MAC_LPS_MASK_22)) << 22);\
		v = (v & (MAC_LPS_RES_WR_MASK_10)) | (((0) & (MAC_LPS_MASK_10)) << 10);\
		v = (v & (MAC_LPS_RES_WR_MASK_4)) | (((0) & (MAC_LPS_MASK_4)) << 4);\
		v = ((v & MAC_LPS_PLS_WR_MASK) | ((data & MAC_LPS_PLS_MASK) << 17));\
		MAC_LPS_RGWR(v);\
} while (0)

#define MAC_LPS_PLS_UDFRD(data) do {\
		MAC_LPS_RGRD(data);\
		data = ((data >> 17) & MAC_LPS_PLS_MASK);\
} while (0)

/*#define MAC_LPS_LPIEN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_LPS_LPIEN_MASK (ULONG)(0x1)

/*#define MAC_LPS_LPIEN_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MAC_LPS_LPIEN_WR_MASK (ULONG)(0xfffeffff)

#define MAC_LPS_LPIEN_UDFWR(data) do {\
		ULONG v;\
		MAC_LPS_RGRD(v);\
		v = (v & (MAC_LPS_RES_WR_MASK_22)) | (((0) & (MAC_LPS_MASK_22)) << 22);\
		v = (v & (MAC_LPS_RES_WR_MASK_10)) | (((0) & (MAC_LPS_MASK_10)) << 10);\
		v = (v & (MAC_LPS_RES_WR_MASK_4)) | (((0) & (MAC_LPS_MASK_4)) << 4);\
		v = ((v & MAC_LPS_LPIEN_WR_MASK) | ((data & MAC_LPS_LPIEN_MASK) << 16));\
		MAC_LPS_RGWR(v);\
} while (0)

#define MAC_LPS_LPIEN_UDFRD(data) do {\
		MAC_LPS_RGRD(data);\
		data = ((data >> 16) & MAC_LPS_LPIEN_MASK);\
} while (0)

/*#define MAC_LPS_RLPIST_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_LPS_RLPIST_MASK (ULONG)(0x1)

#define MAC_LPS_RLPIST_UDFRD(data) do {\
		MAC_LPS_RGRD(data);\
		data = ((data >> 9) & MAC_LPS_RLPIST_MASK);\
} while (0)

/*#define MAC_LPS_TLPIST_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_LPS_TLPIST_MASK (ULONG)(0x1)

#define MAC_LPS_TLPIST_UDFRD(data) do {\
		MAC_LPS_RGRD(data);\
		data = ((data >> 8) & MAC_LPS_TLPIST_MASK);\
} while (0)

/*#define MAC_LPS_RLPIEX_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_LPS_RLPIEX_MASK (ULONG)(0x1)

/*#define MAC_LPS_RLPIEX_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MAC_LPS_RLPIEX_WR_MASK (ULONG)(0xfffffff7)

#define MAC_LPS_RLPIEX_UDFWR(data) do {\
		ULONG v;\
		MAC_LPS_RGRD(v);\
		v = (v & (MAC_LPS_RES_WR_MASK_22)) | (((0) & (MAC_LPS_MASK_22)) << 22);\
		v = (v & (MAC_LPS_RES_WR_MASK_10)) | (((0) & (MAC_LPS_MASK_10)) << 10);\
		v = (v & (MAC_LPS_RES_WR_MASK_4)) | (((0) & (MAC_LPS_MASK_4)) << 4);\
		v = ((v & MAC_LPS_RLPIEX_WR_MASK) | ((data & MAC_LPS_RLPIEX_MASK) << 3));\
		MAC_LPS_RGWR(v);\
} while (0)

#define MAC_LPS_RLPIEX_UDFRD(data) do {\
		MAC_LPS_RGRD(data);\
		data = ((data >> 3) & MAC_LPS_RLPIEX_MASK);\
} while (0)

/*#define MAC_LPS_RLPIEN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_LPS_RLPIEN_MASK (ULONG)(0x1)

/*#define MAC_LPS_RLPIEN_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MAC_LPS_RLPIEN_WR_MASK (ULONG)(0xfffffffb)

#define MAC_LPS_RLPIEN_UDFWR(data) do {\
		ULONG v;\
		MAC_LPS_RGRD(v);\
		v = (v & (MAC_LPS_RES_WR_MASK_22)) | (((0) & (MAC_LPS_MASK_22)) << 22);\
		v = (v & (MAC_LPS_RES_WR_MASK_10)) | (((0) & (MAC_LPS_MASK_10)) << 10);\
		v = (v & (MAC_LPS_RES_WR_MASK_4)) | (((0) & (MAC_LPS_MASK_4)) << 4);\
		v = ((v & MAC_LPS_RLPIEN_WR_MASK) | ((data & MAC_LPS_RLPIEN_MASK) << 2));\
		MAC_LPS_RGWR(v);\
} while (0)

#define MAC_LPS_RLPIEN_UDFRD(data) do {\
		MAC_LPS_RGRD(data);\
		data = ((data >> 2) & MAC_LPS_RLPIEN_MASK);\
} while (0)

/*#define MAC_LPS_TLPIEX_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_LPS_TLPIEX_MASK (ULONG)(0x1)

/*#define MAC_LPS_TLPIEX_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_LPS_TLPIEX_WR_MASK (ULONG)(0xfffffffd)

#define MAC_LPS_TLPIEX_UDFWR(data) do {\
		ULONG v;\
		MAC_LPS_RGRD(v);\
		v = (v & (MAC_LPS_RES_WR_MASK_22)) | (((0) & (MAC_LPS_MASK_22)) << 22);\
		v = (v & (MAC_LPS_RES_WR_MASK_10)) | (((0) & (MAC_LPS_MASK_10)) << 10);\
		v = (v & (MAC_LPS_RES_WR_MASK_4)) | (((0) & (MAC_LPS_MASK_4)) << 4);\
		v = ((v & MAC_LPS_TLPIEX_WR_MASK) | ((data & MAC_LPS_TLPIEX_MASK) << 1));\
		MAC_LPS_RGWR(v);\
} while (0)

#define MAC_LPS_TLPIEX_UDFRD(data) do {\
		MAC_LPS_RGRD(data);\
		data = ((data >> 1) & MAC_LPS_TLPIEX_MASK);\
} while (0)

/*#define MAC_LPS_TLPIEN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_LPS_TLPIEN_MASK (ULONG)(0x1)

/*#define MAC_LPS_TLPIEN_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_LPS_TLPIEN_WR_MASK (ULONG)(0xfffffffe)

#define MAC_LPS_TLPIEN_UDFWR(data) do {\
		ULONG v;\
		MAC_LPS_RGRD(v);\
		v = (v & (MAC_LPS_RES_WR_MASK_22)) | (((0) & (MAC_LPS_MASK_22)) << 22);\
		v = (v & (MAC_LPS_RES_WR_MASK_10)) | (((0) & (MAC_LPS_MASK_10)) << 10);\
		v = (v & (MAC_LPS_RES_WR_MASK_4)) | (((0) & (MAC_LPS_MASK_4)) << 4);\
		v = ((v & MAC_LPS_TLPIEN_WR_MASK) | ((data & MAC_LPS_TLPIEN_MASK) << 0));\
		MAC_LPS_RGWR(v);\
} while (0)

#define MAC_LPS_TLPIEN_UDFRD(data) do {\
		MAC_LPS_RGRD(data);\
		data = ((data >> 0) & MAC_LPS_TLPIEN_MASK);\
} while (0)

#define MAC_PPS_WIDTH3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xbbc))

#define MAC_PPS_WIDTH3_RGWR(data) do {\
		iowrite32(data, (void *)MAC_PPS_WIDTH3_RGOFFADDR);\
} while (0)

#define MAC_PPS_WIDTH3_RGRD(data) do {\
		(data) = ioread32((void *)MAC_PPS_WIDTH3_RGOFFADDR);\
} while (0)

#define MAC_PPS_WIDTH3_PPSWIDTH0_UDFWR(data) do {\
		MAC_PPS_WIDTH3_RGWR(data);\
} while (0)

#define MAC_PPS_WIDTH3_PPSWIDTH0_UDFRD(data) do {\
		MAC_PPS_WIDTH3_RGRD(data);\
} while (0)

#define MAC_PPS_WIDTH2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xbac))

#define MAC_PPS_WIDTH2_RGWR(data) do {\
		iowrite32(data, (void *)MAC_PPS_WIDTH2_RGOFFADDR);\
} while (0)

#define MAC_PPS_WIDTH2_RGRD(data) do {\
		(data) = ioread32((void *)MAC_PPS_WIDTH2_RGOFFADDR);\
} while (0)

#define MAC_PPS_WIDTH2_PPSWIDTH0_UDFWR(data) do {\
		MAC_PPS_WIDTH2_RGWR(data);\
} while (0)

#define MAC_PPS_WIDTH2_PPSWIDTH0_UDFRD(data) do {\
		MAC_PPS_WIDTH2_RGRD(data);\
} while (0)

#define MAC_PPS_WIDTH1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xb9c))

#define MAC_PPS_WIDTH1_RGWR(data) do {\
		iowrite32(data, (void *)MAC_PPS_WIDTH1_RGOFFADDR);\
} while (0)

#define MAC_PPS_WIDTH1_RGRD(data) do {\
		(data) = ioread32((void *)MAC_PPS_WIDTH1_RGOFFADDR);\
} while (0)

#define MAC_PPS_WIDTH1_PPSWIDTH0_UDFWR(data) do {\
		MAC_PPS_WIDTH1_RGWR(data);\
} while (0)

#define MAC_PPS_WIDTH1_PPSWIDTH0_UDFRD(data) do {\
		MAC_PPS_WIDTH1_RGRD(data);\
} while (0)

#define MAC_PPS_WIDTH0_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xb8c))

#define MAC_PPS_WIDTH0_RGWR(data) do {\
		iowrite32(data, (void *)MAC_PPS_WIDTH0_RGOFFADDR);\
} while (0)

#define MAC_PPS_WIDTH0_RGRD(data) do {\
		(data) = ioread32((void *)MAC_PPS_WIDTH0_RGOFFADDR);\
} while (0)

#define MAC_PPS_WIDTH0_PPSWIDTH0_UDFWR(data) do {\
		MAC_PPS_WIDTH0_RGWR(data);\
} while (0)

#define MAC_PPS_WIDTH0_PPSWIDTH0_UDFRD(data) do {\
		MAC_PPS_WIDTH0_RGRD(data);\
} while (0)

#define MAC_PPS_INTVAL3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xbb8))

#define MAC_PPS_INTVAL3_RGWR(data) do {\
		iowrite32(data, (void *)MAC_PPS_INTVAL3_RGOFFADDR);\
} while (0)

#define MAC_PPS_INTVAL3_RGRD(data) do {\
		(data) = ioread32((void *)MAC_PPS_INTVAL3_RGOFFADDR);\
} while (0)

#define MAC_PPS_INTVAL3_PPSINT0_UDFWR(data) do {\
		MAC_PPS_INTVAL3_RGWR(data);\
} while (0)

#define MAC_PPS_INTVAL3_PPSINT0_UDFRD(data) do {\
		MAC_PPS_INTVAL3_RGRD(data);\
} while (0)

#define MAC_PPS_INTVAL2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xba8))

#define MAC_PPS_INTVAL2_RGWR(data) do {\
		iowrite32(data, (void *)MAC_PPS_INTVAL2_RGOFFADDR);\
} while (0)

#define MAC_PPS_INTVAL2_RGRD(data) do {\
		(data) = ioread32((void *)MAC_PPS_INTVAL2_RGOFFADDR);\
} while (0)

#define MAC_PPS_INTVAL2_PPSINT0_UDFWR(data) do {\
		MAC_PPS_INTVAL2_RGWR(data);\
} while (0)

#define MAC_PPS_INTVAL2_PPSINT0_UDFRD(data) do {\
		MAC_PPS_INTVAL2_RGRD(data);\
} while (0)

#define MAC_PPS_INTVAL1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xb98))

#define MAC_PPS_INTVAL1_RGWR(data) do {\
		iowrite32(data, (void *)MAC_PPS_INTVAL1_RGOFFADDR);\
} while (0)

#define MAC_PPS_INTVAL1_RGRD(data) do {\
		(data) = ioread32((void *)MAC_PPS_INTVAL1_RGOFFADDR);\
} while (0)

#define MAC_PPS_INTVAL1_PPSINT0_UDFWR(data) do {\
		MAC_PPS_INTVAL1_RGWR(data);\
} while (0)

#define MAC_PPS_INTVAL1_PPSINT0_UDFRD(data) do {\
		MAC_PPS_INTVAL1_RGRD(data);\
} while (0)

#define MAC_PPS_INTVAL0_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xb88))

#define MAC_PPS_INTVAL0_RGWR(data) do {\
		iowrite32(data, (void *)MAC_PPS_INTVAL0_RGOFFADDR);\
} while (0)

#define MAC_PPS_INTVAL0_RGRD(data) do {\
		(data) = ioread32((void *)MAC_PPS_INTVAL0_RGOFFADDR);\
} while (0)

#define MAC_PPS_INTVAL0_PPSINT0_UDFWR(data) do {\
		MAC_PPS_INTVAL0_RGWR(data);\
} while (0)

#define MAC_PPS_INTVAL0_PPSINT0_UDFRD(data) do {\
		MAC_PPS_INTVAL0_RGRD(data);\
} while (0)

#define MAC_PPS_TTNS3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xbb4))

#define MAC_PPS_TTNS3_RGWR(data) do {\
		iowrite32(data, (void *)MAC_PPS_TTNS3_RGOFFADDR);\
} while (0)

#define MAC_PPS_TTNS3_RGRD(data) do {\
		(data) = ioread32((void *)MAC_PPS_TTNS3_RGOFFADDR);\
} while (0)

/*#define MAC_PPS_TTNS3_TTSL0_Mask (ULONG)(~(~0<<(31)))*/

#define MAC_PPS_TTNS3_TTSL0_MASK (ULONG)(0x7fffffff)

/*#define MAC_PPS_TTNS3_TTSL0_Wr_Mask (ULONG)(~((~(~0 << (31))) << (0)))*/

#define MAC_PPS_TTNS3_TTSL0_WR_MASK (ULONG)(0x80000000)

#define MAC_PPS_TTNS3_TTSL0_UDFWR(data) do {\
		ULONG v;\
		MAC_PPS_TTNS3_RGRD(v);\
		v = ((v & MAC_PPS_TTNS3_TTSL0_WR_MASK) | ((data & MAC_PPS_TTNS3_TTSL0_MASK) << 0));\
		MAC_PPS_TTNS3_RGWR(v);\
} while (0)

#define MAC_PPS_TTNS3_TTSL0_UDFRD(data) do {\
		MAC_PPS_TTNS3_RGRD(data);\
		data = ((data >> 0) & MAC_PPS_TTNS3_TTSL0_MASK);\
} while (0)

/*#define MAC_PPS_TTNS3_TRGTBUSY0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PPS_TTNS3_TRGTBUSY0_MASK (ULONG)(0x1)

/*#define MAC_PPS_TTNS3_TRGTBUSY0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (31)))*/

#define MAC_PPS_TTNS3_TRGTBUSY0_WR_MASK (ULONG)(0x7fffffff)

#define MAC_PPS_TTNS3_TRGTBUSY0_UDFWR(data) do {\
		ULONG v;\
		MAC_PPS_TTNS3_RGRD(v);\
		v = ((v & MAC_PPS_TTNS3_TRGTBUSY0_WR_MASK) | ((data & MAC_PPS_TTNS3_TRGTBUSY0_MASK) << 31));\
		MAC_PPS_TTNS3_RGWR(v);\
} while (0)

#define MAC_PPS_TTNS3_TRGTBUSY0_UDFRD(data) do {\
		MAC_PPS_TTNS3_RGRD(data);\
		data = ((data >> 31) & MAC_PPS_TTNS3_TRGTBUSY0_MASK);\
} while (0)

#define MAC_PPS_TTNS2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xba4))

#define MAC_PPS_TTNS2_RGWR(data) do {\
		iowrite32(data, (void *)MAC_PPS_TTNS2_RGOFFADDR);\
} while (0)

#define MAC_PPS_TTNS2_RGRD(data) do {\
		(data) = ioread32((void *)MAC_PPS_TTNS2_RGOFFADDR);\
} while (0)

/*#define MAC_PPS_TTNS2_TTSL0_Mask (ULONG)(~(~0<<(31)))*/

#define MAC_PPS_TTNS2_TTSL0_MASK (ULONG)(0x7fffffff)

/*#define MAC_PPS_TTNS2_TTSL0_Wr_Mask (ULONG)(~((~(~0 << (31))) << (0)))*/

#define MAC_PPS_TTNS2_TTSL0_WR_MASK (ULONG)(0x80000000)

#define MAC_PPS_TTNS2_TTSL0_UDFWR(data) do {\
		ULONG v;\
		MAC_PPS_TTNS2_RGRD(v);\
		v = ((v & MAC_PPS_TTNS2_TTSL0_WR_MASK) | ((data & MAC_PPS_TTNS2_TTSL0_MASK) << 0));\
		MAC_PPS_TTNS2_RGWR(v);\
} while (0)

#define MAC_PPS_TTNS2_TTSL0_UDFRD(data) do {\
		MAC_PPS_TTNS2_RGRD(data);\
		data = ((data >> 0) & MAC_PPS_TTNS2_TTSL0_MASK);\
} while (0)

/*#define MAC_PPS_TTNS2_TRGTBUSY0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PPS_TTNS2_TRGTBUSY0_MASK (ULONG)(0x1)

/*#define MAC_PPS_TTNS2_TRGTBUSY0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (31)))*/

#define MAC_PPS_TTNS2_TRGTBUSY0_WR_MASK (ULONG)(0x7fffffff)

#define MAC_PPS_TTNS2_TRGTBUSY0_UDFWR(data) do {\
		ULONG v;\
		MAC_PPS_TTNS2_RGRD(v);\
		v = ((v & MAC_PPS_TTNS2_TRGTBUSY0_WR_MASK) | ((data & MAC_PPS_TTNS2_TRGTBUSY0_MASK) << 31));\
		MAC_PPS_TTNS2_RGWR(v);\
} while (0)

#define MAC_PPS_TTNS2_TRGTBUSY0_UDFRD(data) do {\
		MAC_PPS_TTNS2_RGRD(data);\
		data = ((data >> 31) & MAC_PPS_TTNS2_TRGTBUSY0_MASK);\
} while (0)

#define MAC_LMIR_RGOFFADDR ((volatile unsigned int *)(BASE_ADDRESS + 0xbd0))

#define MAC_LMIR_RGWR(data) do {\
		iowrite32(data, (void *)MAC_LMIR_RGOFFADDR);\
} while (0)

#define MAC_LMIR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_LMIR_RGOFFADDR);\
} while (0)

#define MAC_SPI2R_RGOFFADDR ((volatile unsigned int *)(BASE_ADDRESS + 0xbcc))

#define MAC_SPI2R_RGWR(data) do {\
		iowrite32(data, (void *)MAC_SPI2R_RGOFFADDR);\
} while (0)

#define MAC_SPI2R_RGRD(data) do {\
		(data) = ioread32((void *)MAC_SPI2R_RGOFFADDR);\
} while (0)

/*#define  MAC_SPI2R_Mask_16 (unsigned int)(~(~0<<(16)))*/

#define  MAC_SPI2R_MASK_16 (unsigned int)(0xffff)

/*#define MAC_SPI2R_RES_Wr_Mask_16 (unsigned int)(~((~(~0<<(16)))<<(16)))*/

#define MAC_SPI2R_RES_WR_MASK_16 (unsigned int)(0xffff)

/*#define MAC_SPI2R_SPIO_Mask (unsigned int)(~(~0<<(16)))*/

#define MAC_SPI2R_SPIO_MASK (unsigned int)(0xffff)

/*#define MAC_SPI2R_SPIO_Wr_Mask (unsigned int)(~((~(~0 << (16))) << (0)))*/

#define MAC_SPI2R_SPIO_WR_MASK (unsigned int)(0xffff0000)

#define MAC_SPI2R_SPIO_UDFWR(data) do {\
		unsigned int v = 0; \
		v = (v & (MAC_SPI2R_RES_WR_MASK_16)) | (((0) & (MAC_SPI2R_MASK_16)) << 16);\
		(v) = ((v & MAC_SPI2R_SPIO_WR_MASK) | ((data & MAC_SPI2R_SPIO_MASK) << 0));\
		MAC_SPI2R_RGWR(v);\
} while (0)

#define MAC_SPI2R_SPIO_UDFRD(data) do {\
		MAC_SPI2R_RGRD(data);\
		data = ((data >> 0) & MAC_SPI2R_SPIO_MASK);\
} while (0)

#define MAC_SPI1R_RGOFFADDR ((volatile unsigned int *)(BASE_ADDRESS + 0xbc8))

#define MAC_SPI1R_RGWR(data) do {\
		iowrite32(data, (void *)MAC_SPI1R_RGOFFADDR);\
} while (0)

#define MAC_SPI1R_RGRD(data) do {\
		(data) = ioread32((void *)MAC_SPI1R_RGOFFADDR);\
} while (0)

#define MAC_SPI1R_SPIO_UDFWR(data) do {\
		MAC_SPI1R_RGWR(data);\
} while (0)

#define MAC_SPI1R_SPIO_UDFRD(data) do {\
		MAC_SPI1R_RGRD(data);\
} while (0)

#define MAC_SPI0R_RGOFFADDR ((volatile unsigned int *)(BASE_ADDRESS + 0xbc4))

#define MAC_SPI0R_RGWR(data) do {\
		iowrite32(data, (void *)MAC_SPI0R_RGOFFADDR);\
} while (0)

#define MAC_SPI0R_RGRD(data) do {\
		(data) = ioread32((void *)MAC_SPI0R_RGOFFADDR);\
} while (0)

#define MAC_SPI0R_SPIO_UDFWR(data) do {\
		MAC_SPI0R_RGWR(data);\
} while (0)

#define MAC_SPI0R_SPIO_UDFRD(data) do {\
		MAC_SPI0R_RGRD(data);\
} while (0)

#define MAC_PTO_CR_RGOFFADDR ((volatile unsigned int *)(BASE_ADDRESS + 0xbc0))

#define MAC_PTO_CR_RGWR(data) do {\
		iowrite32(data, (void *)MAC_PTO_CR_RGOFFADDR);\
} while (0)

#define MAC_PTO_CR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_PTO_CR_RGOFFADDR);\
} while (0)

/*#define  MAC_PTO_CR_Mask_16 (unsigned int)(~(~0<<(16)))*/

#define  MAC_PTO_CR_MASK_16 (unsigned int)(0xffff)

/*#define MAC_PTO_CR_RES_Wr_Mask_16 (unsigned int)(~((~(~0<<(16)))<<(16)))*/

#define MAC_PTO_CR_RES_WR_MASK_16 (unsigned int)(0xffff)

/*#define  MAC_PTO_CR_Mask_6 (unsigned int)(~(~0<<(2)))*/

#define  MAC_PTO_CR_MASK_6 (unsigned int)(0x3)

/*#define MAC_PTO_CR_RES_Wr_Mask_6 (unsigned int)(~((~(~0<<(2)))<<(6)))*/

#define MAC_PTO_CR_RES_WR_MASK_6 (unsigned int)(0xffffff3f)

/*#define  MAC_PTO_CR_Mask_3 (unsigned int)(~(~0<<(1)))*/

#define  MAC_PTO_CR_MASK_3 (unsigned int)(0x1)

/*#define MAC_PTO_CR_RES_Wr_Mask_3 (unsigned int)(~((~(~0<<(1)))<<(3)))*/

#define MAC_PTO_CR_RES_WR_MASK_3 (unsigned int)(0xfffffff7)

/*#define MAC_PTO_CR_DN_Mask (unsigned int)(~(~0<<(8)))*/

#define MAC_PTO_CR_DN_MASK (unsigned int)(0xff)

/*#define MAC_PTO_CR_DN_Wr_Mask (unsigned int)(~((~(~0 << (8))) << (8)))*/

#define MAC_PTO_CR_DN_WR_MASK (unsigned int)(0xffff00ff)

#define MAC_PTO_CR_DN_UDFWR(data) do {\
		unsigned int v;\
		MAC_PTO_CR_RGRD(v);\
		v = (v & (MAC_PTO_CR_RES_WR_MASK_16)) | (((0) & (MAC_PTO_CR_MASK_16)) << 16);\
		v = (v & (MAC_PTO_CR_RES_WR_MASK_6)) | (((0) & (MAC_PTO_CR_MASK_6)) << 6);\
		v = (v & (MAC_PTO_CR_RES_WR_MASK_3)) | (((0) & (MAC_PTO_CR_MASK_3)) << 3);\
		v = ((v & MAC_PTO_CR_DN_WR_MASK) | ((data & MAC_PTO_CR_DN_MASK) << 8));\
		MAC_PTO_CR_RGWR(v);\
} while (0)

#define MAC_PTO_CR_DN_UDFRD(data) do {\
		MAC_PTO_CR_RGRD(data);\
		data = ((data >> 8) & MAC_PTO_CR_DN_MASK);\
} while (0)

/*#define MAC_PTO_CR_APDREQTRIG_Mask (unsigned int)(~(~0<<(1)))*/

#define MAC_PTO_CR_APDREQTRIG_MASK (unsigned int)(0x1)

/*#define MAC_PTO_CR_APDREQTRIG_Wr_Mask (unsigned int)(~((~(~0 << (1))) << (5)))*/

#define MAC_PTO_CR_APDREQTRIG_WR_MASK (unsigned int)(0xffffffdf)

#define MAC_PTO_CR_APDREQTRIG_UDFWR(data) do {\
		unsigned int v;\
		MAC_PTO_CR_RGRD(v);\
		v = (v & (MAC_PTO_CR_RES_WR_MASK_16)) | (((0) & (MAC_PTO_CR_MASK_16)) << 16);\
		v = (v & (MAC_PTO_CR_RES_WR_MASK_6)) | (((0) & (MAC_PTO_CR_MASK_6)) << 6);\
		v = (v & (MAC_PTO_CR_RES_WR_MASK_3)) | (((0) & (MAC_PTO_CR_MASK_3)) << 3);\
		v = ((v & MAC_PTO_CR_APDREQTRIG_WR_MASK) | ((data & MAC_PTO_CR_APDREQTRIG_MASK) << 5));\
		MAC_PTO_CR_RGWR(v);\
} while (0)

#define MAC_PTO_CR_APDREQTRIG_UDFRD(data) do {\
		MAC_PTO_CR_RGRD(data);\
		data = ((data >> 5) & MAC_PTO_CR_APDREQTRIG_MASK);\
} while (0)

/*#define MAC_PTO_CR_ASYNCTRIG_Mask (unsigned int)(~(~0<<(1)))*/

#define MAC_PTO_CR_ASYNCTRIG_MASK (unsigned int)(0x1)

/*#define MAC_PTO_CR_ASYNCTRIG_Wr_Mask (unsigned int)(~((~(~0 << (1))) << (4)))*/

#define MAC_PTO_CR_ASYNCTRIG_WR_MASK (unsigned int)(0xffffffef)

#define MAC_PTO_CR_ASYNCTRIG_UDFWR(data) do {\
		unsigned int v;\
		MAC_PTO_CR_RGRD(v);\
		v = (v & (MAC_PTO_CR_RES_WR_MASK_16)) | (((0) & (MAC_PTO_CR_MASK_16)) << 16);\
		v = (v & (MAC_PTO_CR_RES_WR_MASK_6)) | (((0) & (MAC_PTO_CR_MASK_6)) << 6);\
		v = (v & (MAC_PTO_CR_RES_WR_MASK_3)) | (((0) & (MAC_PTO_CR_MASK_3)) << 3);\
		v = ((v & MAC_PTO_CR_ASYNCTRIG_WR_MASK) | ((data & MAC_PTO_CR_ASYNCTRIG_MASK) << 4));\
		MAC_PTO_CR_RGWR(v);\
} while (0)

#define MAC_PTO_CR_ASYNCTRIG_UDFRD(data) do {\
		MAC_PTO_CR_RGRD(data);\
		data = ((data >> 4) & MAC_PTO_CR_ASYNCTRIG_MASK);\
} while (0)

/*#define MAC_PTO_CR_APDREQEN_Mask (unsigned int)(~(~0<<(1)))*/

#define MAC_PTO_CR_APDREQEN_MASK (unsigned int)(0x1)

/*#define MAC_PTO_CR_APDREQEN_Wr_Mask (unsigned int)(~((~(~0 << (1))) << (2)))*/

#define MAC_PTO_CR_APDREQEN_WR_MASK (unsigned int)(0xfffffffb)

#define MAC_PTO_CR_APDREQEN_UDFWR(data) do {\
		unsigned int v;\
		MAC_PTO_CR_RGRD(v);\
		v = (v & (MAC_PTO_CR_RES_WR_MASK_16)) | (((0) & (MAC_PTO_CR_MASK_16)) << 16);\
		v = (v & (MAC_PTO_CR_RES_WR_MASK_6)) | (((0) & (MAC_PTO_CR_MASK_6)) << 6);\
		v = (v & (MAC_PTO_CR_RES_WR_MASK_3)) | (((0) & (MAC_PTO_CR_MASK_3)) << 3);\
		v = ((v & MAC_PTO_CR_APDREQEN_WR_MASK) | ((data & MAC_PTO_CR_APDREQEN_MASK) << 2));\
		MAC_PTO_CR_RGWR(v);\
} while (0)

#define MAC_PTO_CR_APDREQEN_UDFRD(data) do {\
		MAC_PTO_CR_RGRD(data);\
		data = ((data >> 2) & MAC_PTO_CR_APDREQEN_MASK);\
} while (0)

/*#define MAC_PTO_CR_ASYNCEN_Mask (unsigned int)(~(~0<<(1)))*/

#define MAC_PTO_CR_ASYNCEN_MASK (unsigned int)(0x1)

/*#define MAC_PTO_CR_ASYNCEN_Wr_Mask (unsigned int)(~((~(~0 << (1))) << (1)))*/

#define MAC_PTO_CR_ASYNCEN_WR_MASK (unsigned int)(0xfffffffd)

#define MAC_PTO_CR_ASYNCEN_UDFWR(data) do {\
		unsigned int v;\
		MAC_PTO_CR_RGRD(v);\
		v = (v & (MAC_PTO_CR_RES_WR_MASK_16)) | (((0) & (MAC_PTO_CR_MASK_16)) << 16);\
		v = (v & (MAC_PTO_CR_RES_WR_MASK_6)) | (((0) & (MAC_PTO_CR_MASK_6)) << 6);\
		v = (v & (MAC_PTO_CR_RES_WR_MASK_3)) | (((0) & (MAC_PTO_CR_MASK_3)) << 3);\
		v = ((v & MAC_PTO_CR_ASYNCEN_WR_MASK) | ((data & MAC_PTO_CR_ASYNCEN_MASK) << 1));\
		MAC_PTO_CR_RGWR(v);\
} while (0)

#define MAC_PTO_CR_ASYNCEN_UDFRD(data) do {\
		MAC_PTO_CR_RGRD(data);\
		data = ((data >> 1) & MAC_PTO_CR_ASYNCEN_MASK);\
} while (0)

/*#define MAC_PTO_CR_PTOEN_Mask (unsigned int)(~(~0<<(1)))*/

#define MAC_PTO_CR_PTOEN_MASK (unsigned int)(0x1)

/*#define MAC_PTO_CR_PTOEN_Wr_Mask (unsigned int)(~((~(~0 << (1))) << (0)))*/

#define MAC_PTO_CR_PTOEN_WR_MASK (unsigned int)(0xfffffffe)

#define MAC_PTO_CR_PTOEN_UDFWR(data) do {\
		unsigned int v;\
		MAC_PTO_CR_RGRD(v);\
		v = (v & (MAC_PTO_CR_RES_WR_MASK_16)) | (((0) & (MAC_PTO_CR_MASK_16)) << 16);\
		v = (v & (MAC_PTO_CR_RES_WR_MASK_6)) | (((0) & (MAC_PTO_CR_MASK_6)) << 6);\
		v = (v & (MAC_PTO_CR_RES_WR_MASK_3)) | (((0) & (MAC_PTO_CR_MASK_3)) << 3);\
		v = ((v & MAC_PTO_CR_PTOEN_WR_MASK) | ((data & MAC_PTO_CR_PTOEN_MASK) << 0));\
		MAC_PTO_CR_RGWR(v);\
} while (0)

#define MAC_PTO_CR_PTOEN_UDFRD(data) do {\
		MAC_PTO_CR_RGRD(data);\
		data = ((data >> 0) & MAC_PTO_CR_PTOEN_MASK);\
} while (0)

#define MAC_PPS_TTNS1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xb94))

#define MAC_PPS_TTNS1_RGWR(data) do {\
		iowrite32(data, (void *)MAC_PPS_TTNS1_RGOFFADDR);\
} while (0)

#define MAC_PPS_TTNS1_RGRD(data) do {\
		(data) = ioread32((void *)MAC_PPS_TTNS1_RGOFFADDR);\
} while (0)

/*#define MAC_PPS_TTNS1_TTSL0_Mask (ULONG)(~(~0<<(31)))*/

#define MAC_PPS_TTNS1_TTSL0_MASK (ULONG)(0x7fffffff)

/*#define MAC_PPS_TTNS1_TTSL0_Wr_Mask (ULONG)(~((~(~0 << (31))) << (0)))*/

#define MAC_PPS_TTNS1_TTSL0_WR_MASK (ULONG)(0x80000000)

#define MAC_PPS_TTNS1_TTSL0_UDFWR(data) do {\
		ULONG v;\
		MAC_PPS_TTNS1_RGRD(v);\
		v = ((v & MAC_PPS_TTNS1_TTSL0_WR_MASK) | ((data & MAC_PPS_TTNS1_TTSL0_MASK) << 0));\
		MAC_PPS_TTNS1_RGWR(v);\
} while (0)

#define MAC_PPS_TTNS1_TTSL0_UDFRD(data) do {\
		MAC_PPS_TTNS1_RGRD(data);\
		data = ((data >> 0) & MAC_PPS_TTNS1_TTSL0_MASK);\
} while (0)

/*#define MAC_PPS_TTNS1_TRGTBUSY0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PPS_TTNS1_TRGTBUSY0_MASK (ULONG)(0x1)

/*#define MAC_PPS_TTNS1_TRGTBUSY0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (31)))*/

#define MAC_PPS_TTNS1_TRGTBUSY0_WR_MASK (ULONG)(0x7fffffff)

#define MAC_PPS_TTNS1_TRGTBUSY0_UDFWR(data) do {\
		ULONG v;\
		MAC_PPS_TTNS1_RGRD(v);\
		v = ((v & MAC_PPS_TTNS1_TRGTBUSY0_WR_MASK) | ((data & MAC_PPS_TTNS1_TRGTBUSY0_MASK) << 31));\
		MAC_PPS_TTNS1_RGWR(v);\
} while (0)

#define MAC_PPS_TTNS1_TRGTBUSY0_UDFRD(data) do {\
		MAC_PPS_TTNS1_RGRD(data);\
		data = ((data >> 31) & MAC_PPS_TTNS1_TRGTBUSY0_MASK);\
} while (0)

#define MAC_PPS_TTNS0_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xb84))

#define MAC_PPS_TTNS0_RGWR(data) do {\
		iowrite32(data, (void *)MAC_PPS_TTNS0_RGOFFADDR);\
} while (0)

#define MAC_PPS_TTNS0_RGRD(data) do {\
		(data) = ioread32((void *)MAC_PPS_TTNS0_RGOFFADDR);\
} while (0)

/*#define MAC_PPS_TTNS0_TTSL0_Mask (ULONG)(~(~0<<(31)))*/

#define MAC_PPS_TTNS0_TTSL0_MASK (ULONG)(0x7fffffff)

/*#define MAC_PPS_TTNS0_TTSL0_Wr_Mask (ULONG)(~((~(~0 << (31))) << (0)))*/

#define MAC_PPS_TTNS0_TTSL0_WR_MASK (ULONG)(0x80000000)

#define MAC_PPS_TTNS0_TTSL0_UDFWR(data) do {\
		ULONG v;\
		MAC_PPS_TTNS0_RGRD(v);\
		v = ((v & MAC_PPS_TTNS0_TTSL0_WR_MASK) | ((data & MAC_PPS_TTNS0_TTSL0_MASK) << 0));\
		MAC_PPS_TTNS0_RGWR(v);\
} while (0)

#define MAC_PPS_TTNS0_TTSL0_UDFRD(data) do {\
		MAC_PPS_TTNS0_RGRD(data);\
		data = ((data >> 0) & MAC_PPS_TTNS0_TTSL0_MASK);\
} while (0)

/*#define MAC_PPS_TTNS0_TRGTBUSY0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PPS_TTNS0_TRGTBUSY0_MASK (ULONG)(0x1)

/*#define MAC_PPS_TTNS0_TRGTBUSY0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (31)))*/

#define MAC_PPS_TTNS0_TRGTBUSY0_WR_MASK (ULONG)(0x7fffffff)

#define MAC_PPS_TTNS0_TRGTBUSY0_UDFWR(data) do {\
		ULONG v;\
		MAC_PPS_TTNS0_RGRD(v);\
		v = ((v & MAC_PPS_TTNS0_TRGTBUSY0_WR_MASK) | ((data & MAC_PPS_TTNS0_TRGTBUSY0_MASK) << 31));\
		MAC_PPS_TTNS0_RGWR(v);\
} while (0)

#define MAC_PPS_TTNS0_TRGTBUSY0_UDFRD(data) do {\
		MAC_PPS_TTNS0_RGRD(data);\
		data = ((data >> 31) & MAC_PPS_TTNS0_TRGTBUSY0_MASK);\
} while (0)

#define MAC_PPS_TTS3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xbb0))

#define MAC_PPS_TTS3_RGWR(data) do {\
		iowrite32(data, (void *)MAC_PPS_TTS3_RGOFFADDR);\
} while (0)

#define MAC_PPS_TTS3_RGRD(data) do {\
		(data) = ioread32((void *)MAC_PPS_TTS3_RGOFFADDR);\
} while (0)

#define MAC_PPS_TTS3_TSTRH0_UDFWR(data) do {\
		MAC_PPS_TTS3_RGWR(data);\
} while (0)

#define MAC_PPS_TTS3_TSTRH0_UDFRD(data) do {\
		MAC_PPS_TTS3_RGRD(data);\
} while (0)

#define MAC_PPS_TTS2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xba0))

#define MAC_PPS_TTS2_RGWR(data) do {\
		iowrite32(data, (void *)MAC_PPS_TTS2_RGOFFADDR);\
} while (0)

#define MAC_PPS_TTS2_RGRD(data) do {\
		(data) = ioread32((void *)MAC_PPS_TTS2_RGOFFADDR);\
} while (0)

#define MAC_PPS_TTS2_TSTRH0_UDFWR(data) do {\
		MAC_PPS_TTS2_RGWR(data);\
} while (0)

#define MAC_PPS_TTS2_TSTRH0_UDFRD(data) do {\
		MAC_PPS_TTS2_RGRD(data);\
} while (0)

#define MAC_PPS_TTS1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xb90))

#define MAC_PPS_TTS1_RGWR(data) do {\
		iowrite32(data, (void *)MAC_PPS_TTS1_RGOFFADDR);\
} while (0)

#define MAC_PPS_TTS1_RGRD(data) do {\
		(data) = ioread32((void *)MAC_PPS_TTS1_RGOFFADDR);\
} while (0)

#define MAC_PPS_TTS1_TSTRH0_UDFWR(data) do {\
		MAC_PPS_TTS1_RGWR(data);\
} while (0)

#define MAC_PPS_TTS1_TSTRH0_UDFRD(data) do {\
		MAC_PPS_TTS1_RGRD(data);\
} while (0)

#define MAC_PPS_TTS0_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xb80))

#define MAC_PPS_TTS0_RGWR(data) do {\
		iowrite32(data, (void *)MAC_PPS_TTS0_RGOFFADDR);\
} while (0)

#define MAC_PPS_TTS0_RGRD(data) do {\
		(data) = ioread32((void *)MAC_PPS_TTS0_RGOFFADDR);\
} while (0)

#define MAC_PPS_TTS0_TSTRH0_UDFWR(data) do {\
		MAC_PPS_TTS0_RGWR(data);\
} while (0)

#define MAC_PPS_TTS0_TSTRH0_UDFRD(data) do {\
		MAC_PPS_TTS0_RGRD(data);\
} while (0)

#define MAC_PPSC_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xb70))

#define MAC_PPSC_RGWR(data) do {\
		iowrite32(data, (void *)MAC_PPSC_RGOFFADDR);\
} while (0)

#define MAC_PPSC_RGRD(data) do {\
		(data) = ioread32((void *)MAC_PPSC_RGOFFADDR);\
} while (0)

/*#define  MAC_PPSC_Mask_31 (ULONG)(~(~0<<(1)))*/

#define  MAC_PPSC_MASK_31 (ULONG)(0x1)

/*#define MAC_PPSC_RES_Wr_Mask_31 (ULONG)(~((~(~0<<(1)))<<(31)))*/

#define MAC_PPSC_RES_WR_MASK_31 (ULONG)(0x7fffffff)

/*#define  MAC_PPSC_Mask_27 (ULONG)(~(~0<<(2)))*/

#define  MAC_PPSC_MASK_27 (ULONG)(0x3)

/*#define MAC_PPSC_RES_Wr_Mask_27 (ULONG)(~((~(~0<<(2)))<<(27)))*/

#define MAC_PPSC_RES_WR_MASK_27 (ULONG)(0xe7ffffff)

/*#define  MAC_PPSC_Mask_23 (ULONG)(~(~0<<(1)))*/

#define  MAC_PPSC_MASK_23 (ULONG)(0x1)

/*#define MAC_PPSC_RES_Wr_Mask_23 (ULONG)(~((~(~0<<(1)))<<(23)))*/

#define MAC_PPSC_RES_WR_MASK_23 (ULONG)(0xff7fffff)

/*#define  MAC_PPSC_Mask_19 (ULONG)(~(~0<<(2)))*/

#define  MAC_PPSC_MASK_19 (ULONG)(0x3)

/*#define MAC_PPSC_RES_Wr_Mask_19 (ULONG)(~((~(~0<<(2)))<<(19)))*/

#define MAC_PPSC_RES_WR_MASK_19 (ULONG)(0xffe7ffff)

/*#define  MAC_PPSC_Mask_15 (ULONG)(~(~0<<(1)))*/

#define  MAC_PPSC_MASK_15 (ULONG)(0x1)

/*#define MAC_PPSC_RES_Wr_Mask_15 (ULONG)(~((~(~0<<(1)))<<(15)))*/

#define MAC_PPSC_RES_WR_MASK_15 (ULONG)(0xffff7fff)

/*#define  MAC_PPSC_Mask_11 (ULONG)(~(~0<<(2)))*/

#define  MAC_PPSC_MASK_11 (ULONG)(0x3)

/*#define MAC_PPSC_RES_Wr_Mask_11 (ULONG)(~((~(~0<<(2)))<<(11)))*/

#define MAC_PPSC_RES_WR_MASK_11 (ULONG)(0xffffe7ff)

/*#define  MAC_PPSC_Mask_7 (ULONG)(~(~0<<(1)))*/

#define  MAC_PPSC_MASK_7 (ULONG)(0x1)

/*#define MAC_PPSC_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(1)))<<(7)))*/

#define MAC_PPSC_RES_WR_MASK_7 (ULONG)(0xffffff7f)

/*#define MAC_PPSC_TRGTMODSEL3_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_PPSC_TRGTMODSEL3_MASK (ULONG)(0x3)

/*#define MAC_PPSC_TRGTMODSEL3_Wr_Mask (ULONG)(~((~(~0 << (2))) << (29)))*/

#define MAC_PPSC_TRGTMODSEL3_WR_MASK (ULONG)(0x9fffffff)

#define MAC_PPSC_TRGTMODSEL3_UDFWR(data) do {\
		ULONG v;\
		MAC_PPSC_RGRD(v);\
		v = (v & (MAC_PPSC_RES_WR_MASK_31)) | (((0) & (MAC_PPSC_MASK_31)) << 31);\
		v = (v & (MAC_PPSC_RES_WR_MASK_27)) | (((0) & (MAC_PPSC_MASK_27)) << 27);\
		v = (v & (MAC_PPSC_RES_WR_MASK_23)) | (((0) & (MAC_PPSC_MASK_23)) << 23);\
		v = (v & (MAC_PPSC_RES_WR_MASK_19)) | (((0) & (MAC_PPSC_MASK_19)) << 19);\
		v = (v & (MAC_PPSC_RES_WR_MASK_15)) | (((0) & (MAC_PPSC_MASK_15)) << 15);\
		v = (v & (MAC_PPSC_RES_WR_MASK_11)) | (((0) & (MAC_PPSC_MASK_11)) << 11);\
		v = (v & (MAC_PPSC_RES_WR_MASK_7)) | (((0) & (MAC_PPSC_MASK_7)) << 7);\
		v = ((v & MAC_PPSC_TRGTMODSEL3_WR_MASK) | ((data & MAC_PPSC_TRGTMODSEL3_MASK) << 29));\
		MAC_PPSC_RGWR(v);\
} while (0)

#define MAC_PPSC_TRGTMODSEL3_UDFRD(data) do {\
		MAC_PPSC_RGRD(data);\
		data = ((data >> 29) & MAC_PPSC_TRGTMODSEL3_MASK);\
} while (0)

/*#define MAC_PPSC_PPSCMD3_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_PPSC_PPSCMD3_MASK (ULONG)(0x7)

/*#define MAC_PPSC_PPSCMD3_Wr_Mask (ULONG)(~((~(~0 << (3))) << (24)))*/

#define MAC_PPSC_PPSCMD3_WR_MASK (ULONG)(0xf8ffffff)

#define MAC_PPSC_PPSCMD3_UDFWR(data) do {\
		ULONG v;\
		MAC_PPSC_RGRD(v);\
		v = (v & (MAC_PPSC_RES_WR_MASK_31)) | (((0) & (MAC_PPSC_MASK_31)) << 31);\
		v = (v & (MAC_PPSC_RES_WR_MASK_27)) | (((0) & (MAC_PPSC_MASK_27)) << 27);\
		v = (v & (MAC_PPSC_RES_WR_MASK_23)) | (((0) & (MAC_PPSC_MASK_23)) << 23);\
		v = (v & (MAC_PPSC_RES_WR_MASK_19)) | (((0) & (MAC_PPSC_MASK_19)) << 19);\
		v = (v & (MAC_PPSC_RES_WR_MASK_15)) | (((0) & (MAC_PPSC_MASK_15)) << 15);\
		v = (v & (MAC_PPSC_RES_WR_MASK_11)) | (((0) & (MAC_PPSC_MASK_11)) << 11);\
		v = (v & (MAC_PPSC_RES_WR_MASK_7)) | (((0) & (MAC_PPSC_MASK_7)) << 7);\
		v = ((v & MAC_PPSC_PPSCMD3_WR_MASK) | ((data & MAC_PPSC_PPSCMD3_MASK) << 24));\
		MAC_PPSC_RGWR(v);\
} while (0)

#define MAC_PPSC_PPSCMD3_UDFRD(data) do {\
		MAC_PPSC_RGRD(data);\
		data = ((data >> 24) & MAC_PPSC_PPSCMD3_MASK);\
} while (0)

/*#define MAC_PPSC_TRGTMODSEL2_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_PPSC_TRGTMODSEL2_MASK (ULONG)(0x3)

/*#define MAC_PPSC_TRGTMODSEL2_Wr_Mask (ULONG)(~((~(~0 << (2))) << (21)))*/

#define MAC_PPSC_TRGTMODSEL2_WR_MASK (ULONG)(0xff9fffff)

#define MAC_PPSC_TRGTMODSEL2_UDFWR(data) do {\
		ULONG v;\
		MAC_PPSC_RGRD(v);\
		v = (v & (MAC_PPSC_RES_WR_MASK_31)) | (((0) & (MAC_PPSC_MASK_31)) << 31);\
		v = (v & (MAC_PPSC_RES_WR_MASK_27)) | (((0) & (MAC_PPSC_MASK_27)) << 27);\
		v = (v & (MAC_PPSC_RES_WR_MASK_23)) | (((0) & (MAC_PPSC_MASK_23)) << 23);\
		v = (v & (MAC_PPSC_RES_WR_MASK_19)) | (((0) & (MAC_PPSC_MASK_19)) << 19);\
		v = (v & (MAC_PPSC_RES_WR_MASK_15)) | (((0) & (MAC_PPSC_MASK_15)) << 15);\
		v = (v & (MAC_PPSC_RES_WR_MASK_11)) | (((0) & (MAC_PPSC_MASK_11)) << 11);\
		v = (v & (MAC_PPSC_RES_WR_MASK_7)) | (((0) & (MAC_PPSC_MASK_7)) << 7);\
		v = ((v & MAC_PPSC_TRGTMODSEL2_WR_MASK) | ((data & MAC_PPSC_TRGTMODSEL2_MASK) << 21));\
		MAC_PPSC_RGWR(v);\
} while (0)

#define MAC_PPSC_TRGTMODSEL2_UDFRD(data) do {\
		MAC_PPSC_RGRD(data);\
		data = ((data >> 21) & MAC_PPSC_TRGTMODSEL2_MASK);\
} while (0)

/*#define MAC_PPSC_PPSCMD2_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_PPSC_PPSCMD2_MASK (ULONG)(0x7)

/*#define MAC_PPSC_PPSCMD2_Wr_Mask (ULONG)(~((~(~0 << (3))) << (16)))*/

#define MAC_PPSC_PPSCMD2_WR_MASK (ULONG)(0xfff8ffff)

#define MAC_PPSC_PPSCMD2_UDFWR(data) do {\
		ULONG v;\
		MAC_PPSC_RGRD(v);\
		v = (v & (MAC_PPSC_RES_WR_MASK_31)) | (((0) & (MAC_PPSC_MASK_31)) << 31);\
		v = (v & (MAC_PPSC_RES_WR_MASK_27)) | (((0) & (MAC_PPSC_MASK_27)) << 27);\
		v = (v & (MAC_PPSC_RES_WR_MASK_23)) | (((0) & (MAC_PPSC_MASK_23)) << 23);\
		v = (v & (MAC_PPSC_RES_WR_MASK_19)) | (((0) & (MAC_PPSC_MASK_19)) << 19);\
		v = (v & (MAC_PPSC_RES_WR_MASK_15)) | (((0) & (MAC_PPSC_MASK_15)) << 15);\
		v = (v & (MAC_PPSC_RES_WR_MASK_11)) | (((0) & (MAC_PPSC_MASK_11)) << 11);\
		v = (v & (MAC_PPSC_RES_WR_MASK_7)) | (((0) & (MAC_PPSC_MASK_7)) << 7);\
		v = ((v & MAC_PPSC_PPSCMD2_WR_MASK) | ((data & MAC_PPSC_PPSCMD2_MASK) << 16));\
		MAC_PPSC_RGWR(v);\
} while (0)

#define MAC_PPSC_PPSCMD2_UDFRD(data) do {\
		MAC_PPSC_RGRD(data);\
		data = ((data >> 16) & MAC_PPSC_PPSCMD2_MASK);\
} while (0)

/*#define MAC_PPSC_TRGTMODSEL1_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_PPSC_TRGTMODSEL1_MASK (ULONG)(0x3)

/*#define MAC_PPSC_TRGTMODSEL1_Wr_Mask (ULONG)(~((~(~0 << (2))) << (13)))*/

#define MAC_PPSC_TRGTMODSEL1_WR_MASK (ULONG)(0xffff9fff)

#define MAC_PPSC_TRGTMODSEL1_UDFWR(data) do {\
		ULONG v;\
		MAC_PPSC_RGRD(v);\
		v = (v & (MAC_PPSC_RES_WR_MASK_31)) | (((0) & (MAC_PPSC_MASK_31)) << 31);\
		v = (v & (MAC_PPSC_RES_WR_MASK_27)) | (((0) & (MAC_PPSC_MASK_27)) << 27);\
		v = (v & (MAC_PPSC_RES_WR_MASK_23)) | (((0) & (MAC_PPSC_MASK_23)) << 23);\
		v = (v & (MAC_PPSC_RES_WR_MASK_19)) | (((0) & (MAC_PPSC_MASK_19)) << 19);\
		v = (v & (MAC_PPSC_RES_WR_MASK_15)) | (((0) & (MAC_PPSC_MASK_15)) << 15);\
		v = (v & (MAC_PPSC_RES_WR_MASK_11)) | (((0) & (MAC_PPSC_MASK_11)) << 11);\
		v = (v & (MAC_PPSC_RES_WR_MASK_7)) | (((0) & (MAC_PPSC_MASK_7)) << 7);\
		v = ((v & MAC_PPSC_TRGTMODSEL1_WR_MASK) | ((data & MAC_PPSC_TRGTMODSEL1_MASK) << 13));\
		MAC_PPSC_RGWR(v);\
} while (0)

#define MAC_PPSC_TRGTMODSEL1_UDFRD(data) do {\
		MAC_PPSC_RGRD(data);\
		data = ((data >> 13) & MAC_PPSC_TRGTMODSEL1_MASK);\
} while (0)

/*#define MAC_PPSC_PPSCMD1_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_PPSC_PPSCMD1_MASK (ULONG)(0x7)

/*#define MAC_PPSC_PPSCMD1_Wr_Mask (ULONG)(~((~(~0 << (3))) << (8)))*/

#define MAC_PPSC_PPSCMD1_WR_MASK (ULONG)(0xfffff8ff)

#define MAC_PPSC_PPSCMD1_UDFWR(data) do {\
		ULONG v;\
		MAC_PPSC_RGRD(v);\
		v = (v & (MAC_PPSC_RES_WR_MASK_31)) | (((0) & (MAC_PPSC_MASK_31)) << 31);\
		v = (v & (MAC_PPSC_RES_WR_MASK_27)) | (((0) & (MAC_PPSC_MASK_27)) << 27);\
		v = (v & (MAC_PPSC_RES_WR_MASK_23)) | (((0) & (MAC_PPSC_MASK_23)) << 23);\
		v = (v & (MAC_PPSC_RES_WR_MASK_19)) | (((0) & (MAC_PPSC_MASK_19)) << 19);\
		v = (v & (MAC_PPSC_RES_WR_MASK_15)) | (((0) & (MAC_PPSC_MASK_15)) << 15);\
		v = (v & (MAC_PPSC_RES_WR_MASK_11)) | (((0) & (MAC_PPSC_MASK_11)) << 11);\
		v = (v & (MAC_PPSC_RES_WR_MASK_7)) | (((0) & (MAC_PPSC_MASK_7)) << 7);\
		v = ((v & MAC_PPSC_PPSCMD1_WR_MASK) | ((data & MAC_PPSC_PPSCMD1_MASK) << 8));\
		MAC_PPSC_RGWR(v);\
} while (0)

#define MAC_PPSC_PPSCMD1_UDFRD(data) do {\
		MAC_PPSC_RGRD(data);\
		data = ((data >> 8) & MAC_PPSC_PPSCMD1_MASK);\
} while (0)

/*#define MAC_PPSC_TRGTMODSEL0_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_PPSC_TRGTMODSEL0_MASK (ULONG)(0x3)

/*#define MAC_PPSC_TRGTMODSEL0_Wr_Mask (ULONG)(~((~(~0 << (2))) << (5)))*/

#define MAC_PPSC_TRGTMODSEL0_WR_MASK (ULONG)(0xffffff9f)

#define MAC_PPSC_TRGTMODSEL0_UDFWR(data) do {\
		ULONG v;\
		MAC_PPSC_RGRD(v);\
		v = (v & (MAC_PPSC_RES_WR_MASK_31)) | (((0) & (MAC_PPSC_MASK_31)) << 31);\
		v = (v & (MAC_PPSC_RES_WR_MASK_27)) | (((0) & (MAC_PPSC_MASK_27)) << 27);\
		v = (v & (MAC_PPSC_RES_WR_MASK_23)) | (((0) & (MAC_PPSC_MASK_23)) << 23);\
		v = (v & (MAC_PPSC_RES_WR_MASK_19)) | (((0) & (MAC_PPSC_MASK_19)) << 19);\
		v = (v & (MAC_PPSC_RES_WR_MASK_15)) | (((0) & (MAC_PPSC_MASK_15)) << 15);\
		v = (v & (MAC_PPSC_RES_WR_MASK_11)) | (((0) & (MAC_PPSC_MASK_11)) << 11);\
		v = (v & (MAC_PPSC_RES_WR_MASK_7)) | (((0) & (MAC_PPSC_MASK_7)) << 7);\
		v = ((v & MAC_PPSC_TRGTMODSEL0_WR_MASK) | ((data & MAC_PPSC_TRGTMODSEL0_MASK) << 5));\
		MAC_PPSC_RGWR(v);\
} while (0)

#define MAC_PPSC_TRGTMODSEL0_UDFRD(data) do {\
		MAC_PPSC_RGRD(data);\
		data = ((data >> 5) & MAC_PPSC_TRGTMODSEL0_MASK);\
} while (0)

/*#define MAC_PPSC_PPSEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PPSC_PPSEN0_MASK (ULONG)(0x1)

/*#define MAC_PPSC_PPSEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MAC_PPSC_PPSEN0_WR_MASK (ULONG)(0xffffffef)

#define MAC_PPSC_PPSEN0_UDFWR(data) do {\
		ULONG v;\
		MAC_PPSC_RGRD(v);\
		v = (v & (MAC_PPSC_RES_WR_MASK_31)) | (((0) & (MAC_PPSC_MASK_31)) << 31);\
		v = (v & (MAC_PPSC_RES_WR_MASK_27)) | (((0) & (MAC_PPSC_MASK_27)) << 27);\
		v = (v & (MAC_PPSC_RES_WR_MASK_23)) | (((0) & (MAC_PPSC_MASK_23)) << 23);\
		v = (v & (MAC_PPSC_RES_WR_MASK_19)) | (((0) & (MAC_PPSC_MASK_19)) << 19);\
		v = (v & (MAC_PPSC_RES_WR_MASK_15)) | (((0) & (MAC_PPSC_MASK_15)) << 15);\
		v = (v & (MAC_PPSC_RES_WR_MASK_11)) | (((0) & (MAC_PPSC_MASK_11)) << 11);\
		v = (v & (MAC_PPSC_RES_WR_MASK_7)) | (((0) & (MAC_PPSC_MASK_7)) << 7);\
		v = ((v & MAC_PPSC_PPSEN0_WR_MASK) | ((data & MAC_PPSC_PPSEN0_MASK) << 4));\
		MAC_PPSC_RGWR(v);\
} while (0)

#define MAC_PPSC_PPSEN0_UDFRD(data) do {\
		MAC_PPSC_RGRD(data);\
		data = ((data >> 4) & MAC_PPSC_PPSEN0_MASK);\
} while (0)

/*#define MAC_PPSC_PPSCTRL0_Mask (ULONG)(~(~0<<(4)))*/

#define MAC_PPSC_PPSCTRL0_MASK (ULONG)(0xf)

/*#define MAC_PPSC_PPSCTRL0_Wr_Mask (ULONG)(~((~(~0 << (4))) << (0)))*/

#define MAC_PPSC_PPSCTRL0_WR_MASK (ULONG)(0xfffffff0)

#define MAC_PPSC_PPSCTRL0_UDFWR(data) do {\
		ULONG v;\
		MAC_PPSC_RGRD(v);\
		v = (v & (MAC_PPSC_RES_WR_MASK_31)) | (((0) & (MAC_PPSC_MASK_31)) << 31);\
		v = (v & (MAC_PPSC_RES_WR_MASK_27)) | (((0) & (MAC_PPSC_MASK_27)) << 27);\
		v = (v & (MAC_PPSC_RES_WR_MASK_23)) | (((0) & (MAC_PPSC_MASK_23)) << 23);\
		v = (v & (MAC_PPSC_RES_WR_MASK_19)) | (((0) & (MAC_PPSC_MASK_19)) << 19);\
		v = (v & (MAC_PPSC_RES_WR_MASK_15)) | (((0) & (MAC_PPSC_MASK_15)) << 15);\
		v = (v & (MAC_PPSC_RES_WR_MASK_11)) | (((0) & (MAC_PPSC_MASK_11)) << 11);\
		v = (v & (MAC_PPSC_RES_WR_MASK_7)) | (((0) & (MAC_PPSC_MASK_7)) << 7);\
		v = ((v & MAC_PPSC_PPSCTRL0_WR_MASK) | ((data & MAC_PPSC_PPSCTRL0_MASK) << 0));\
		MAC_PPSC_RGWR(v);\
} while (0)

#define MAC_PPSC_PPSCTRL0_UDFRD(data) do {\
		MAC_PPSC_RGRD(data);\
		data = ((data >> 0) & MAC_PPSC_PPSCTRL0_MASK);\
} while (0)

#define MAC_TEAC_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xb54))

#define MAC_TEAC_RGWR(data) do {\
		iowrite32(data, (void *)MAC_TEAC_RGOFFADDR);\
} while (0)

#define MAC_TEAC_RGRD(data) do {\
		(data) = ioread32((void *)MAC_TEAC_RGOFFADDR);\
} while (0)

/*#define  MAC_TEAC_Mask_31 (ULONG)(~(~0<<(1)))*/

#define  MAC_TEAC_MASK_31 (ULONG)(0x1)

/*#define MAC_TEAC_RES_Wr_Mask_31 (ULONG)(~((~(~0<<(1)))<<(31)))*/

#define MAC_TEAC_RES_WR_MASK_31 (ULONG)(0x7fffffff)

/*#define MAC_TEAC_OSTIAC_Mask (ULONG)(~(~0<<(31)))*/

#define MAC_TEAC_OSTIAC_MASK (ULONG)(0x7fffffff)

/*#define MAC_TEAC_OSTIAC_Wr_Mask (ULONG)(~((~(~0 << (31))) << (0)))*/

#define MAC_TEAC_OSTIAC_WR_MASK (ULONG)(0x80000000)

#define MAC_TEAC_OSTIAC_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MAC_TEAC_RES_WR_MASK_31)) | (((0) & (MAC_TEAC_MASK_31)) << 31);\
		(v) = ((v & MAC_TEAC_OSTIAC_WR_MASK) | ((data & MAC_TEAC_OSTIAC_MASK) << 0));\
		MAC_TEAC_RGWR(v);\
} while (0)

#define MAC_TEAC_OSTIAC_UDFRD(data) do {\
		MAC_TEAC_RGRD(data);\
		data = ((data >> 0) & MAC_TEAC_OSTIAC_MASK);\
} while (0)

#define MAC_TIAC_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xb50))

#define MAC_TIAC_RGWR(data) do {\
		iowrite32(data, (void *)MAC_TIAC_RGOFFADDR);\
} while (0)

#define MAC_TIAC_RGRD(data) do {\
		(data) = ioread32((void *)MAC_TIAC_RGOFFADDR);\
} while (0)

#define MAC_TIAC_OSTIAC_UDFWR(data) do {\
		MAC_TIAC_RGWR(data);\
} while (0)

#define MAC_TIAC_OSTIAC_UDFRD(data) do {\
		MAC_TIAC_RGRD(data);\
} while (0)

#define MAC_ATS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xb4c))

#define MAC_ATS_RGRD(data) do {\
		(data) = ioread32((void *)MAC_ATS_RGOFFADDR);\
} while (0)

#define MAC_ATS_AUXTSHI_UDFRD(data) do {\
		MAC_ATS_RGRD(data);\
} while (0)

#define MAC_ATN_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xb48))

#define MAC_ATN_RGRD(data) do {\
		(data) = ioread32((void *)MAC_ATN_RGOFFADDR);\
} while (0)

/*#define MAC_ATN_AUXTSLO_Mask (ULONG)(~(~0<<(31)))*/

#define MAC_ATN_AUXTSLO_MASK (ULONG)(0x7fffffff)

#define MAC_ATN_AUXTSLO_UDFRD(data) do {\
		MAC_ATN_RGRD(data);\
		data = ((data >> 0) & MAC_ATN_AUXTSLO_MASK);\
} while (0)

#define MAC_AC_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xb40))

#define MAC_AC_RGWR(data) do {\
		iowrite32(data, (void *)MAC_AC_RGOFFADDR);\
} while (0)

#define MAC_AC_RGRD(data) do {\
		(data) = ioread32((void *)MAC_AC_RGOFFADDR);\
} while (0)

/*#define  MAC_AC_Mask_8 (ULONG)(~(~0<<(24)))*/

#define  MAC_AC_MASK_8 (ULONG)(0xffffff)

/*#define MAC_AC_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(24)))<<(8)))*/

#define MAC_AC_RES_WR_MASK_8 (ULONG)(0xff)

/*#define  MAC_AC_Mask_1 (ULONG)(~(~0<<(3)))*/

#define  MAC_AC_MASK_1 (ULONG)(0x7)

/*#define MAC_AC_RES_Wr_Mask_1 (ULONG)(~((~(~0<<(3)))<<(1)))*/

#define MAC_AC_RES_WR_MASK_1 (ULONG)(0xfffffff1)

/*#define MAC_AC_ATSEN3_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_AC_ATSEN3_MASK (ULONG)(0x1)

/*#define MAC_AC_ATSEN3_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MAC_AC_ATSEN3_WR_MASK (ULONG)(0xffffff7f)

#define MAC_AC_ATSEN3_UDFWR(data) do {\
		ULONG v;\
		MAC_AC_RGRD(v);\
		v = (v & (MAC_AC_RES_WR_MASK_8)) | (((0) & (MAC_AC_MASK_8)) << 8);\
		v = (v & (MAC_AC_RES_WR_MASK_1)) | (((0) & (MAC_AC_MASK_1)) << 1);\
		v = ((v & MAC_AC_ATSEN3_WR_MASK) | ((data & MAC_AC_ATSEN3_MASK) << 7));\
		MAC_AC_RGWR(v);\
} while (0)

#define MAC_AC_ATSEN3_UDFRD(data) do {\
		MAC_AC_RGRD(data);\
		data = ((data >> 7) & MAC_AC_ATSEN3_MASK);\
} while (0)

/*#define MAC_AC_ATSEN2_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_AC_ATSEN2_MASK (ULONG)(0x1)

/*#define MAC_AC_ATSEN2_Wr_Mask (ULONG)(~((~(~0 << (1))) << (6)))*/

#define MAC_AC_ATSEN2_WR_MASK (ULONG)(0xffffffbf)

#define MAC_AC_ATSEN2_UDFWR(data) do {\
		ULONG v;\
		MAC_AC_RGRD(v);\
		v = (v & (MAC_AC_RES_WR_MASK_8)) | (((0) & (MAC_AC_MASK_8)) << 8);\
		v = (v & (MAC_AC_RES_WR_MASK_1)) | (((0) & (MAC_AC_MASK_1)) << 1);\
		v = ((v & MAC_AC_ATSEN2_WR_MASK) | ((data & MAC_AC_ATSEN2_MASK) << 6));\
		MAC_AC_RGWR(v);\
} while (0)

#define MAC_AC_ATSEN2_UDFRD(data) do {\
		MAC_AC_RGRD(data);\
		data = ((data >> 6) & MAC_AC_ATSEN2_MASK);\
} while (0)

/*#define MAC_AC_ATSEN1_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_AC_ATSEN1_MASK (ULONG)(0x1)

/*#define MAC_AC_ATSEN1_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MAC_AC_ATSEN1_WR_MASK (ULONG)(0xffffffdf)

#define MAC_AC_ATSEN1_UDFWR(data) do {\
		ULONG v;\
		MAC_AC_RGRD(v);\
		v = (v & (MAC_AC_RES_WR_MASK_8)) | (((0) & (MAC_AC_MASK_8)) << 8);\
		v = (v & (MAC_AC_RES_WR_MASK_1)) | (((0) & (MAC_AC_MASK_1)) << 1);\
		v = ((v & MAC_AC_ATSEN1_WR_MASK) | ((data & MAC_AC_ATSEN1_MASK) << 5));\
		MAC_AC_RGWR(v);\
} while (0)

#define MAC_AC_ATSEN1_UDFRD(data) do {\
		MAC_AC_RGRD(data);\
		data = ((data >> 5) & MAC_AC_ATSEN1_MASK);\
} while (0)

/*#define MAC_AC_ATSEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_AC_ATSEN0_MASK (ULONG)(0x1)

/*#define MAC_AC_ATSEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MAC_AC_ATSEN0_WR_MASK (ULONG)(0xffffffef)

#define MAC_AC_ATSEN0_UDFWR(data) do {\
		ULONG v;\
		MAC_AC_RGRD(v);\
		v = (v & (MAC_AC_RES_WR_MASK_8)) | (((0) & (MAC_AC_MASK_8)) << 8);\
		v = (v & (MAC_AC_RES_WR_MASK_1)) | (((0) & (MAC_AC_MASK_1)) << 1);\
		v = ((v & MAC_AC_ATSEN0_WR_MASK) | ((data & MAC_AC_ATSEN0_MASK) << 4));\
		MAC_AC_RGWR(v);\
} while (0)

#define MAC_AC_ATSEN0_UDFRD(data) do {\
		MAC_AC_RGRD(data);\
		data = ((data >> 4) & MAC_AC_ATSEN0_MASK);\
} while (0)

/*#define MAC_AC_ATSFC_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_AC_ATSFC_MASK (ULONG)(0x1)

/*#define MAC_AC_ATSFC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_AC_ATSFC_WR_MASK (ULONG)(0xfffffffe)

#define MAC_AC_ATSFC_UDFWR(data) do {\
		ULONG v;\
		MAC_AC_RGRD(v);\
		v = (v & (MAC_AC_RES_WR_MASK_8)) | (((0) & (MAC_AC_MASK_8)) << 8);\
		v = (v & (MAC_AC_RES_WR_MASK_1)) | (((0) & (MAC_AC_MASK_1)) << 1);\
		v = ((v & MAC_AC_ATSFC_WR_MASK) | ((data & MAC_AC_ATSFC_MASK) << 0));\
		MAC_AC_RGWR(v);\
} while (0)

#define MAC_AC_ATSFC_UDFRD(data) do {\
		MAC_AC_RGRD(data);\
		data = ((data >> 0) & MAC_AC_ATSFC_MASK);\
} while (0)

#define MAC_TTN_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xb34))

#define MAC_TTN_RGRD(data) do {\
		(data) = ioread32((void *)MAC_TTN_RGOFFADDR);\
} while (0)

#define MAC_TTN_TXTSSTSHI_UDFRD(data) do {\
		MAC_TTN_RGRD(data);\
} while (0)

#define MAC_TTSN_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xb30))

#define MAC_TTSN_RGRD(data) do {\
		(data) = ioread32((void *)MAC_TTSN_RGOFFADDR);\
} while (0)

/*#define MAC_TTSN_TXTSSTSMIS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TTSN_TXTSSTSMIS_MASK (ULONG)(0x1)

#define MAC_TTSN_TXTSSTSMIS_UDFRD(data) do {\
		MAC_TTSN_RGRD(data);\
		data = ((data >> 31) & MAC_TTSN_TXTSSTSMIS_MASK);\
} while (0)

/*#define MAC_TTSN_TXTSSTSLO_Mask (ULONG)(~(~0<<(31)))*/

#define MAC_TTSN_TXTSSTSLO_MASK (ULONG)(0x7fffffff)

#define MAC_TTSN_TXTSSTSLO_UDFRD(data) do {\
		MAC_TTSN_RGRD(data);\
		data = ((data >> 0) & MAC_TTSN_TXTSSTSLO_MASK);\
} while (0)

#define MAC_TSR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xb20))

#define MAC_TSR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_TSR_RGOFFADDR);\
} while (0)

/*#define MAC_TSR_ATSNS_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_TSR_ATSNS_MASK (ULONG)(0x1f)

#define MAC_TSR_ATSNS_UDFRD(data) do {\
		MAC_TSR_RGRD(data);\
		data = ((data >> 25) & MAC_TSR_ATSNS_MASK);\
} while (0)

/*#define MAC_TSR_ATSSTM_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TSR_ATSSTM_MASK (ULONG)(0x1)

#define MAC_TSR_ATSSTM_UDFRD(data) do {\
		MAC_TSR_RGRD(data);\
		data = ((data >> 24) & MAC_TSR_ATSSTM_MASK);\
} while (0)

/*#define MAC_TSR_ATSSTN_Mask (ULONG)(~(~0<<(4)))*/

#define MAC_TSR_ATSSTN_MASK (ULONG)(0xf)

#define MAC_TSR_ATSSTN_UDFRD(data) do {\
		MAC_TSR_RGRD(data);\
		data = ((data >> 16) & MAC_TSR_ATSSTN_MASK);\
} while (0)

/*#define MAC_TSR_TSTRGTERR3_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TSR_TSTRGTERR3_MASK (ULONG)(0x1)

#define MAC_TSR_TSTRGTERR3_UDFRD(data) do {\
		MAC_TSR_RGRD(data);\
		data = ((data >> 9) & MAC_TSR_TSTRGTERR3_MASK);\
} while (0)

/*#define MAC_TSR_TSTARGT3_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TSR_TSTARGT3_MASK (ULONG)(0x1)

#define MAC_TSR_TSTARGT3_UDFRD(data) do {\
		MAC_TSR_RGRD(data);\
		data = ((data >> 8) & MAC_TSR_TSTARGT3_MASK);\
} while (0)

/*#define MAC_TSR_TSTRGTERR2_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TSR_TSTRGTERR2_MASK (ULONG)(0x1)

#define MAC_TSR_TSTRGTERR2_UDFRD(data) do {\
		MAC_TSR_RGRD(data);\
		data = ((data >> 7) & MAC_TSR_TSTRGTERR2_MASK);\
} while (0)

/*#define MAC_TSR_TSTARGT2_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TSR_TSTARGT2_MASK (ULONG)(0x1)

#define MAC_TSR_TSTARGT2_UDFRD(data) do {\
		MAC_TSR_RGRD(data);\
		data = ((data >> 6) & MAC_TSR_TSTARGT2_MASK);\
} while (0)

/*#define MAC_TSR_TSTRGTERR1_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TSR_TSTRGTERR1_MASK (ULONG)(0x1)

#define MAC_TSR_TSTRGTERR1_UDFRD(data) do {\
		MAC_TSR_RGRD(data);\
		data = ((data >> 5) & MAC_TSR_TSTRGTERR1_MASK);\
} while (0)

/*#define MAC_TSR_TSTARGT1_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TSR_TSTARGT1_MASK (ULONG)(0x1)

#define MAC_TSR_TSTARGT1_UDFRD(data) do {\
		MAC_TSR_RGRD(data);\
		data = ((data >> 4) & MAC_TSR_TSTARGT1_MASK);\
} while (0)

/*#define MAC_TSR_TSTRGTERR0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TSR_TSTRGTERR0_MASK (ULONG)(0x1)

#define MAC_TSR_TSTRGTERR0_UDFRD(data) do {\
		MAC_TSR_RGRD(data);\
		data = ((data >> 3) & MAC_TSR_TSTRGTERR0_MASK);\
} while (0)

/*#define MAC_TSR_AUXTSTRIG_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TSR_AUXTSTRIG_MASK (ULONG)(0x1)

#define MAC_TSR_AUXTSTRIG_UDFRD(data) do {\
		MAC_TSR_RGRD(data);\
		data = ((data >> 2) & MAC_TSR_AUXTSTRIG_MASK);\
} while (0)

/*#define MAC_TSR_TSTARGT0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TSR_TSTARGT0_MASK (ULONG)(0x1)

#define MAC_TSR_TSTARGT0_UDFRD(data) do {\
		MAC_TSR_RGRD(data);\
		data = ((data >> 1) & MAC_TSR_TSTARGT0_MASK);\
} while (0)

/*#define MAC_TSR_TSSOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TSR_TSSOVF_MASK (ULONG)(0x1)

#define MAC_TSR_TSSOVF_UDFRD(data) do {\
		MAC_TSR_RGRD(data);\
		data = ((data >> 0) & MAC_TSR_TSSOVF_MASK);\
} while (0)

#define MAC_STHWR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xb1c))

#define MAC_STHWR_RGWR(data) do {\
		iowrite32(data, (void *)MAC_STHWR_RGOFFADDR);\
} while (0)

#define MAC_STHWR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_STHWR_RGOFFADDR);\
} while (0)

/*#define  MAC_STHWR_Mask_16 (ULONG)(~(~0<<(16)))*/

#define  MAC_STHWR_MASK_16 (ULONG)(0xffff)

/*#define MAC_STHWR_RES_Wr_Mask_16 (ULONG)(~((~(~0<<(16)))<<(16)))*/

#define MAC_STHWR_RES_WR_MASK_16 (ULONG)(0xffff)

/*#define MAC_STHWR_TSHWR_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_STHWR_TSHWR_MASK (ULONG)(0xffff)

/*#define MAC_STHWR_TSHWR_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_STHWR_TSHWR_WR_MASK (ULONG)(0xffff0000)

#define MAC_STHWR_TSHWR_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MAC_STHWR_RES_WR_MASK_16)) | (((0) & (MAC_STHWR_MASK_16)) << 16);\
		(v) = ((v & MAC_STHWR_TSHWR_WR_MASK) | ((data & MAC_STHWR_TSHWR_MASK) << 0));\
		MAC_STHWR_RGWR(v);\
} while (0)

#define MAC_STHWR_TSHWR_UDFRD(data) do {\
		MAC_STHWR_RGRD(data);\
		data = ((data >> 0) & MAC_STHWR_TSHWR_MASK);\
} while (0)

#define MAC_TAR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xb18))

#define MAC_TAR_RGWR(data) do {\
		iowrite32(data, (void *)MAC_TAR_RGOFFADDR);\
} while (0)

#define MAC_TAR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_TAR_RGOFFADDR);\
} while (0)

#define MAC_TAR_TSAR_UDFWR(data) do {\
		MAC_TAR_RGWR(data);\
} while (0)

#define MAC_TAR_TSAR_UDFRD(data) do {\
		MAC_TAR_RGRD(data);\
} while (0)

#define MAC_STNSUR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xb14))

#define MAC_STNSUR_RGWR(data) do {\
		iowrite32(data, (void *)MAC_STNSUR_RGOFFADDR);\
} while (0)

#define MAC_STNSUR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_STNSUR_RGOFFADDR);\
} while (0)

/*#define MAC_STNSUR_ADDSUB_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_STNSUR_ADDSUB_MASK (ULONG)(0x1)

/*#define MAC_STNSUR_ADDSUB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (31)))*/

#define MAC_STNSUR_ADDSUB_WR_MASK (ULONG)(0x7fffffff)

#define MAC_STNSUR_ADDSUB_UDFWR(data) do {\
		ULONG v;\
		MAC_STNSUR_RGRD(v);\
		v = ((v & MAC_STNSUR_ADDSUB_WR_MASK) | ((data & MAC_STNSUR_ADDSUB_MASK) << 31));\
		MAC_STNSUR_RGWR(v);\
} while (0)

#define MAC_STNSUR_ADDSUB_UDFRD(data) do {\
		MAC_STNSUR_RGRD(data);\
		data = ((data >> 31) & MAC_STNSUR_ADDSUB_MASK);\
} while (0)

/*#define MAC_STNSUR_TSSS_Mask (ULONG)(~(~0<<(31)))*/

#define MAC_STNSUR_TSSS_MASK (ULONG)(0x7fffffff)

/*#define MAC_STNSUR_TSSS_Wr_Mask (ULONG)(~((~(~0 << (31))) << (0)))*/

#define MAC_STNSUR_TSSS_WR_MASK (ULONG)(0x80000000)

#define MAC_STNSUR_TSSS_UDFWR(data) do {\
		ULONG v;\
		MAC_STNSUR_RGRD(v);\
		v = ((v & MAC_STNSUR_TSSS_WR_MASK) | ((data & MAC_STNSUR_TSSS_MASK) << 0));\
		MAC_STNSUR_RGWR(v);\
} while (0)

#define MAC_STNSUR_TSSS_UDFRD(data) do {\
		MAC_STNSUR_RGRD(data);\
		data = ((data >> 0) & MAC_STNSUR_TSSS_MASK);\
} while (0)

#define MAC_STSUR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xb10))

#define MAC_STSUR_RGWR(data) do {\
		iowrite32(data, (void *)MAC_STSUR_RGOFFADDR);\
} while (0)

#define MAC_STSUR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_STSUR_RGOFFADDR);\
} while (0)

#define MAC_STSUR_TSS_UDFWR(data) do {\
		MAC_STSUR_RGWR(data);\
} while (0)

#define MAC_STSUR_TSS_UDFRD(data) do {\
		MAC_STSUR_RGRD(data);\
} while (0)

#define MAC_STNSR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xb0c))

#define MAC_STNSR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_STNSR_RGOFFADDR);\
} while (0)

/*#define MAC_STNSR_TSSS_Mask (ULONG)(~(~0<<(31)))*/

#define MAC_STNSR_TSSS_MASK (ULONG)(0x7fffffff)

#define MAC_STNSR_TSSS_UDFRD(data) do {\
		MAC_STNSR_RGRD(data);\
		data = ((data >> 0) & MAC_STNSR_TSSS_MASK);\
} while (0)

#define MAC_STSR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xb08))

#define MAC_STSR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_STSR_RGOFFADDR);\
} while (0)

#define MAC_STSR_TSS_UDFRD(data) do {\
		MAC_STSR_RGRD(data);\
} while (0)

#define MAC_SSIR_RGOFFADDR ((volatile unsigned int *)(BASE_ADDRESS + 0xb04))

#define MAC_SSIR_RGWR(data) do {\
		iowrite32(data, (void *)MAC_SSIR_RGOFFADDR);\
} while (0)

#define MAC_SSIR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_SSIR_RGOFFADDR);\
} while (0)

/*#define  MAC_SSIR_Mask_24 (unsigned int)(~(~0<<(8)))*/

#define  MAC_SSIR_MASK_24 (unsigned int)(0xff)

/*#define MAC_SSIR_RES_Wr_Mask_24 (unsigned int)(~((~(~0<<(8)))<<(24)))*/

#define MAC_SSIR_RES_WR_MASK_24 (unsigned int)(0xffffff)

/*#define  MAC_SSIR_Mask_0 (unsigned int)(~(~0<<(8)))*/

#define  MAC_SSIR_MASK_0 (unsigned int)(0xff)

/*#define MAC_SSIR_RES_Wr_Mask_0 (unsigned int)(~((~(~0<<(8)))<<(0)))*/

#define MAC_SSIR_RES_WR_MASK_0 (unsigned int)(0xffffff00)

/*#define MAC_SSIR_SSINC_Mask (unsigned int)(~(~0<<(8)))*/

#define MAC_SSIR_SSINC_MASK (unsigned int)(0xff)

/*#define MAC_SSIR_SSINC_Wr_Mask (unsigned int)(~((~(~0 << (8))) << (16)))*/

#define MAC_SSIR_SSINC_WR_MASK (unsigned int)(0xff00ffff)

#define MAC_SSIR_SSINC_UDFWR(data) do {\
		unsigned int v;\
		MAC_SSIR_RGRD(v);\
		v = (v & (MAC_SSIR_RES_WR_MASK_24)) | (((0) & (MAC_SSIR_MASK_24)) << 24);\
		v = (v & (MAC_SSIR_RES_WR_MASK_0)) | (((0) & (MAC_SSIR_MASK_0)) << 0);\
		v = ((v & MAC_SSIR_SSINC_WR_MASK) | ((data & MAC_SSIR_SSINC_MASK) << 16));\
		MAC_SSIR_RGWR(v);\
} while (0)

#define MAC_SSIR_SSINC_UDFRD(data) do {\
		MAC_SSIR_RGRD(data);\
		data = ((data >> 16) & MAC_SSIR_SSINC_MASK);\
} while (0)

/*#define MAC_SSIR_SNSINC_Mask (unsigned int)(~(~0<<(8)))*/

#define MAC_SSIR_SNSINC_MASK (unsigned int)(0xff)

/*#define MAC_SSIR_SNSINC_Wr_Mask (unsigned int)(~((~(~0 << (8))) << (8)))*/

#define MAC_SSIR_SNSINC_WR_MASK (unsigned int)(0xffff00ff)

#define MAC_SSIR_SNSINC_UDFWR(data) do {\
		unsigned int v;\
		MAC_SSIR_RGRD(v);\
		v = (v & (MAC_SSIR_RES_WR_MASK_24)) | (((0) & (MAC_SSIR_MASK_24)) << 24);\
		v = (v & (MAC_SSIR_RES_WR_MASK_0)) | (((0) & (MAC_SSIR_MASK_0)) << 0);\
		v = ((v & MAC_SSIR_SNSINC_WR_MASK) | ((data & MAC_SSIR_SNSINC_MASK) << 8));\
		MAC_SSIR_RGWR(v);\
} while (0)

#define MAC_SSIR_SNSINC_UDFRD(data) do {\
		MAC_SSIR_RGRD(data);\
		data = ((data >> 8) & MAC_SSIR_SNSINC_MASK);\
} while (0)

#define MAC_TCR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xb00))

#define MAC_TCR_RGWR(data) do {\
		iowrite32(data, (void *)MAC_TCR_RGOFFADDR);\
} while (0)

#define MAC_TCR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_TCR_RGOFFADDR);\
} while (0)

/*#define  MAC_TCR_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MAC_TCR_MASK_29 (ULONG)(0x7)

/*#define MAC_TCR_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MAC_TCR_RES_WR_MASK_29 (ULONG)(0x1fffffff)

/*#define  MAC_TCR_Mask_25 (ULONG)(~(~0<<(3)))*/

#define  MAC_TCR_MASK_25 (ULONG)(0x7)

/*#define MAC_TCR_RES_Wr_Mask_25 (ULONG)(~((~(~0<<(3)))<<(25)))*/

#define MAC_TCR_RES_WR_MASK_25 (ULONG)(0xf1ffffff)

/*#define  MAC_TCR_Mask_21 (ULONG)(~(~0<<(3)))*/

#define  MAC_TCR_MASK_21 (ULONG)(0x7)

/*#define MAC_TCR_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(3)))<<(21)))*/

#define MAC_TCR_RES_WR_MASK_21 (ULONG)(0xff1fffff)

/*#define  MAC_TCR_Mask_19 (ULONG)(~(~0<<(1)))*/

#define  MAC_TCR_MASK_19 (ULONG)(0x1)

/*#define MAC_TCR_RES_Wr_Mask_19 (ULONG)(~((~(~0<<(1)))<<(19)))*/

#define MAC_TCR_RES_WR_MASK_19 (ULONG)(0xfff7ffff)

/*#define  MAC_TCR_Mask_6 (ULONG)(~(~0<<(2)))*/

#define  MAC_TCR_MASK_6 (ULONG)(0x3)

/*#define MAC_TCR_RES_Wr_Mask_6 (ULONG)(~((~(~0<<(2)))<<(6)))*/

#define MAC_TCR_RES_WR_MASK_6 (ULONG)(0xffffff3f)

/*#define MAC_TCR_AV8021ASMEN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_AV8021ASMEN_MASK (ULONG)(0x1)

/*#define MAC_TCR_AV8021ASMEN_Wr_Mask (ULONG)(~((~(~0 << (1))) << (28)))*/

#define MAC_TCR_AV8021ASMEN_WR_MASK (ULONG)(0xefffffff)

#define MAC_TCR_AV8021ASMEN_UDFWR(data) do {\
		ULONG v;\
		MAC_TCR_RGRD(v);\
		v = ((v & MAC_TCR_AV8021ASMEN_WR_MASK) | ((data & MAC_TCR_AV8021ASMEN_MASK) << 28));\
		MAC_TCR_RGWR(v);\
} while (0)

#define MAC_TCR_AV8021ASMEN_UDFRD(data) do {\
		MAC_TCR_RGRD(data);\
		data = ((data >> 28) & MAC_TCR_AV8021ASMEN_MASK);\
} while (0)

/*#define MAC_TCR_TXTSSTSM_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TXTSSTSM_MASK (ULONG)(0x1)

/*#define MAC_TCR_TXTSSTSM_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define MAC_TCR_TXTSSTSM_WR_MASK (ULONG)(0xfeffffff)

#define MAC_TCR_TXTSSTSM_UDFWR(data) do {\
		ULONG v;\
		MAC_TCR_RGRD(v);\
		v = (v & (MAC_TCR_RES_WR_MASK_29)) | (((0) & (MAC_TCR_MASK_29)) << 29);\
		v = (v & (MAC_TCR_RES_WR_MASK_25)) | (((0) & (MAC_TCR_MASK_25)) << 25);\
		v = (v & (MAC_TCR_RES_WR_MASK_21)) | (((0) & (MAC_TCR_MASK_21)) << 21);\
		v = (v & (MAC_TCR_RES_WR_MASK_19)) | (((0) & (MAC_TCR_MASK_19)) << 19);\
		v = (v & (MAC_TCR_RES_WR_MASK_6)) | (((0) & (MAC_TCR_MASK_6)) << 6);\
		v = ((v & MAC_TCR_TXTSSTSM_WR_MASK) | ((data & MAC_TCR_TXTSSTSM_MASK) << 24));\
		MAC_TCR_RGWR(v);\
} while (0)

#define MAC_TCR_TXTSSTSM_UDFRD(data) do {\
		MAC_TCR_RGRD(data);\
		data = ((data >> 24) & MAC_TCR_TXTSSTSM_MASK);\
} while (0)

/*#define MAC_TCR_ESTI_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_ESTI_MASK (ULONG)(0x1)

/*#define MAC_TCR_ESTI_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MAC_TCR_ESTI_WR_MASK (ULONG)(0xffefffff)

#define MAC_TCR_ESTI_UDFWR(data) do {\
		ULONG v;\
		MAC_TCR_RGRD(v);\
		v = (v & (MAC_TCR_RES_WR_MASK_29)) | (((0) & (MAC_TCR_MASK_29)) << 29);\
		v = (v & (MAC_TCR_RES_WR_MASK_25)) | (((0) & (MAC_TCR_MASK_25)) << 25);\
		v = (v & (MAC_TCR_RES_WR_MASK_21)) | (((0) & (MAC_TCR_MASK_21)) << 21);\
		v = (v & (MAC_TCR_RES_WR_MASK_19)) | (((0) & (MAC_TCR_MASK_19)) << 19);\
		v = (v & (MAC_TCR_RES_WR_MASK_6)) | (((0) & (MAC_TCR_MASK_6)) << 6);\
		v = ((v & MAC_TCR_ESTI_WR_MASK) | ((data & MAC_TCR_ESTI_MASK) << 20));\
		MAC_TCR_RGWR(v);\
} while (0)

#define MAC_TCR_ESTI_UDFRD(data) do {\
		MAC_TCR_RGRD(data);\
		data = ((data >> 20) & MAC_TCR_ESTI_MASK);\
} while (0)

/*#define MAC_TCR_TSENMACADDR_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSENMACADDR_MASK (ULONG)(0x1)

/*#define MAC_TCR_TSENMACADDR_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MAC_TCR_TSENMACADDR_WR_MASK (ULONG)(0xfffbffff)

#define MAC_TCR_TSENMACADDR_UDFWR(data) do {\
		ULONG v;\
		MAC_TCR_RGRD(v);\
		v = (v & (MAC_TCR_RES_WR_MASK_29)) | (((0) & (MAC_TCR_MASK_29)) << 29);\
		v = (v & (MAC_TCR_RES_WR_MASK_25)) | (((0) & (MAC_TCR_MASK_25)) << 25);\
		v = (v & (MAC_TCR_RES_WR_MASK_21)) | (((0) & (MAC_TCR_MASK_21)) << 21);\
		v = (v & (MAC_TCR_RES_WR_MASK_19)) | (((0) & (MAC_TCR_MASK_19)) << 19);\
		v = (v & (MAC_TCR_RES_WR_MASK_6)) | (((0) & (MAC_TCR_MASK_6)) << 6);\
		v = ((v & MAC_TCR_TSENMACADDR_WR_MASK) | ((data & MAC_TCR_TSENMACADDR_MASK) << 18));\
		MAC_TCR_RGWR(v);\
} while (0)

#define MAC_TCR_TSENMACADDR_UDFRD(data) do {\
		MAC_TCR_RGRD(data);\
		data = ((data >> 18) & MAC_TCR_TSENMACADDR_MASK);\
} while (0)

/*#define MAC_TCR_SNAPTYPSEL_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_TCR_SNAPTYPSEL_MASK (ULONG)(0x3)

/*#define MAC_TCR_SNAPTYPSEL_Wr_Mask (ULONG)(~((~(~0 << (2))) << (16)))*/

#define MAC_TCR_SNAPTYPSEL_WR_MASK (ULONG)(0xfffcffff)

#define MAC_TCR_SNAPTYPSEL_UDFWR(data) do {\
		ULONG v;\
		MAC_TCR_RGRD(v);\
		v = (v & (MAC_TCR_RES_WR_MASK_29)) | (((0) & (MAC_TCR_MASK_29)) << 29);\
		v = (v & (MAC_TCR_RES_WR_MASK_25)) | (((0) & (MAC_TCR_MASK_25)) << 25);\
		v = (v & (MAC_TCR_RES_WR_MASK_21)) | (((0) & (MAC_TCR_MASK_21)) << 21);\
		v = (v & (MAC_TCR_RES_WR_MASK_19)) | (((0) & (MAC_TCR_MASK_19)) << 19);\
		v = (v & (MAC_TCR_RES_WR_MASK_6)) | (((0) & (MAC_TCR_MASK_6)) << 6);\
		v = ((v & MAC_TCR_SNAPTYPSEL_WR_MASK) | ((data & MAC_TCR_SNAPTYPSEL_MASK) << 16));\
		MAC_TCR_RGWR(v);\
} while (0)

#define MAC_TCR_SNAPTYPSEL_UDFRD(data) do {\
		MAC_TCR_RGRD(data);\
		data = ((data >> 16) & MAC_TCR_SNAPTYPSEL_MASK);\
} while (0)

/*#define MAC_TCR_TSMSTRENA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSMSTRENA_MASK (ULONG)(0x1)

/*#define MAC_TCR_TSMSTRENA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (15)))*/

#define MAC_TCR_TSMSTRENA_WR_MASK (ULONG)(0xffff7fff)

#define MAC_TCR_TSMSTRENA_UDFWR(data) do {\
		ULONG v;\
		MAC_TCR_RGRD(v);\
		v = (v & (MAC_TCR_RES_WR_MASK_29)) | (((0) & (MAC_TCR_MASK_29)) << 29);\
		v = (v & (MAC_TCR_RES_WR_MASK_25)) | (((0) & (MAC_TCR_MASK_25)) << 25);\
		v = (v & (MAC_TCR_RES_WR_MASK_21)) | (((0) & (MAC_TCR_MASK_21)) << 21);\
		v = (v & (MAC_TCR_RES_WR_MASK_19)) | (((0) & (MAC_TCR_MASK_19)) << 19);\
		v = (v & (MAC_TCR_RES_WR_MASK_6)) | (((0) & (MAC_TCR_MASK_6)) << 6);\
		v = ((v & MAC_TCR_TSMSTRENA_WR_MASK) | ((data & MAC_TCR_TSMSTRENA_MASK) << 15));\
		MAC_TCR_RGWR(v);\
} while (0)

#define MAC_TCR_TSMSTRENA_UDFRD(data) do {\
		MAC_TCR_RGRD(data);\
		data = ((data >> 15) & MAC_TCR_TSMSTRENA_MASK);\
} while (0)

/*#define MAC_TCR_TSEVNTENA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSEVNTENA_MASK (ULONG)(0x1)

/*#define MAC_TCR_TSEVNTENA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (14)))*/

#define MAC_TCR_TSEVNTENA_WR_MASK (ULONG)(0xffffbfff)

#define MAC_TCR_TSEVNTENA_UDFWR(data) do {\
		ULONG v;\
		MAC_TCR_RGRD(v);\
		v = (v & (MAC_TCR_RES_WR_MASK_29)) | (((0) & (MAC_TCR_MASK_29)) << 29);\
		v = (v & (MAC_TCR_RES_WR_MASK_25)) | (((0) & (MAC_TCR_MASK_25)) << 25);\
		v = (v & (MAC_TCR_RES_WR_MASK_21)) | (((0) & (MAC_TCR_MASK_21)) << 21);\
		v = (v & (MAC_TCR_RES_WR_MASK_19)) | (((0) & (MAC_TCR_MASK_19)) << 19);\
		v = (v & (MAC_TCR_RES_WR_MASK_6)) | (((0) & (MAC_TCR_MASK_6)) << 6);\
		v = ((v & MAC_TCR_TSEVNTENA_WR_MASK) | ((data & MAC_TCR_TSEVNTENA_MASK) << 14));\
		MAC_TCR_RGWR(v);\
} while (0)

#define MAC_TCR_TSEVNTENA_UDFRD(data) do {\
		MAC_TCR_RGRD(data);\
		data = ((data >> 14) & MAC_TCR_TSEVNTENA_MASK);\
} while (0)

/*#define MAC_TCR_TSIPV4ENA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSIPV4ENA_MASK (ULONG)(0x1)

/*#define MAC_TCR_TSIPV4ENA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (13)))*/

#define MAC_TCR_TSIPV4ENA_WR_MASK (ULONG)(0xffffdfff)

#define MAC_TCR_TSIPV4ENA_UDFWR(data) do {\
		ULONG v;\
		MAC_TCR_RGRD(v);\
		v = (v & (MAC_TCR_RES_WR_MASK_29)) | (((0) & (MAC_TCR_MASK_29)) << 29);\
		v = (v & (MAC_TCR_RES_WR_MASK_25)) | (((0) & (MAC_TCR_MASK_25)) << 25);\
		v = (v & (MAC_TCR_RES_WR_MASK_21)) | (((0) & (MAC_TCR_MASK_21)) << 21);\
		v = (v & (MAC_TCR_RES_WR_MASK_19)) | (((0) & (MAC_TCR_MASK_19)) << 19);\
		v = (v & (MAC_TCR_RES_WR_MASK_6)) | (((0) & (MAC_TCR_MASK_6)) << 6);\
		v = ((v & MAC_TCR_TSIPV4ENA_WR_MASK) | ((data & MAC_TCR_TSIPV4ENA_MASK) << 13));\
		MAC_TCR_RGWR(v);\
} while (0)

#define MAC_TCR_TSIPV4ENA_UDFRD(data) do {\
		MAC_TCR_RGRD(data);\
		data = ((data >> 13) & MAC_TCR_TSIPV4ENA_MASK);\
} while (0)

/*#define MAC_TCR_TSIPV6ENA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSIPV6ENA_MASK (ULONG)(0x1)

/*#define MAC_TCR_TSIPV6ENA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define MAC_TCR_TSIPV6ENA_WR_MASK (ULONG)(0xffffefff)

#define MAC_TCR_TSIPV6ENA_UDFWR(data) do {\
		ULONG v;\
		MAC_TCR_RGRD(v);\
		v = (v & (MAC_TCR_RES_WR_MASK_29)) | (((0) & (MAC_TCR_MASK_29)) << 29);\
		v = (v & (MAC_TCR_RES_WR_MASK_25)) | (((0) & (MAC_TCR_MASK_25)) << 25);\
		v = (v & (MAC_TCR_RES_WR_MASK_21)) | (((0) & (MAC_TCR_MASK_21)) << 21);\
		v = (v & (MAC_TCR_RES_WR_MASK_19)) | (((0) & (MAC_TCR_MASK_19)) << 19);\
		v = (v & (MAC_TCR_RES_WR_MASK_6)) | (((0) & (MAC_TCR_MASK_6)) << 6);\
		v = ((v & MAC_TCR_TSIPV6ENA_WR_MASK) | ((data & MAC_TCR_TSIPV6ENA_MASK) << 12));\
		MAC_TCR_RGWR(v);\
} while (0)

#define MAC_TCR_TSIPV6ENA_UDFRD(data) do {\
		MAC_TCR_RGRD(data);\
		data = ((data >> 12) & MAC_TCR_TSIPV6ENA_MASK);\
} while (0)

/*#define MAC_TCR_TSIPENA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSIPENA_MASK (ULONG)(0x1)

/*#define MAC_TCR_TSIPENA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MAC_TCR_TSIPENA_WR_MASK (ULONG)(0xfffff7ff)

#define MAC_TCR_TSIPENA_UDFWR(data) do {\
		ULONG v;\
		MAC_TCR_RGRD(v);\
		v = (v & (MAC_TCR_RES_WR_MASK_29)) | (((0) & (MAC_TCR_MASK_29)) << 29);\
		v = (v & (MAC_TCR_RES_WR_MASK_25)) | (((0) & (MAC_TCR_MASK_25)) << 25);\
		v = (v & (MAC_TCR_RES_WR_MASK_21)) | (((0) & (MAC_TCR_MASK_21)) << 21);\
		v = (v & (MAC_TCR_RES_WR_MASK_19)) | (((0) & (MAC_TCR_MASK_19)) << 19);\
		v = (v & (MAC_TCR_RES_WR_MASK_6)) | (((0) & (MAC_TCR_MASK_6)) << 6);\
		v = ((v & MAC_TCR_TSIPENA_WR_MASK) | ((data & MAC_TCR_TSIPENA_MASK) << 11));\
		MAC_TCR_RGWR(v);\
} while (0)

#define MAC_TCR_TSIPENA_UDFRD(data) do {\
		MAC_TCR_RGRD(data);\
		data = ((data >> 11) & MAC_TCR_TSIPENA_MASK);\
} while (0)

/*#define MAC_TCR_TSVER2ENA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSVER2ENA_MASK (ULONG)(0x1)

/*#define MAC_TCR_TSVER2ENA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (10)))*/

#define MAC_TCR_TSVER2ENA_WR_MASK (ULONG)(0xfffffbff)

#define MAC_TCR_TSVER2ENA_UDFWR(data) do {\
		ULONG v;\
		MAC_TCR_RGRD(v);\
		v = (v & (MAC_TCR_RES_WR_MASK_29)) | (((0) & (MAC_TCR_MASK_29)) << 29);\
		v = (v & (MAC_TCR_RES_WR_MASK_25)) | (((0) & (MAC_TCR_MASK_25)) << 25);\
		v = (v & (MAC_TCR_RES_WR_MASK_21)) | (((0) & (MAC_TCR_MASK_21)) << 21);\
		v = (v & (MAC_TCR_RES_WR_MASK_19)) | (((0) & (MAC_TCR_MASK_19)) << 19);\
		v = (v & (MAC_TCR_RES_WR_MASK_6)) | (((0) & (MAC_TCR_MASK_6)) << 6);\
		v = ((v & MAC_TCR_TSVER2ENA_WR_MASK) | ((data & MAC_TCR_TSVER2ENA_MASK) << 10));\
		MAC_TCR_RGWR(v);\
} while (0)

#define MAC_TCR_TSVER2ENA_UDFRD(data) do {\
		MAC_TCR_RGRD(data);\
		data = ((data >> 10) & MAC_TCR_TSVER2ENA_MASK);\
} while (0)

/*#define MAC_TCR_TSCTRLSSR_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSCTRLSSR_MASK (ULONG)(0x1)

/*#define MAC_TCR_TSCTRLSSR_Wr_Mask (ULONG)(~((~(~0 << (1))) << (9)))*/

#define MAC_TCR_TSCTRLSSR_WR_MASK (ULONG)(0xfffffdff)

#define MAC_TCR_TSCTRLSSR_UDFWR(data) do {\
		ULONG v;\
		MAC_TCR_RGRD(v);\
		v = (v & (MAC_TCR_RES_WR_MASK_29)) | (((0) & (MAC_TCR_MASK_29)) << 29);\
		v = (v & (MAC_TCR_RES_WR_MASK_25)) | (((0) & (MAC_TCR_MASK_25)) << 25);\
		v = (v & (MAC_TCR_RES_WR_MASK_21)) | (((0) & (MAC_TCR_MASK_21)) << 21);\
		v = (v & (MAC_TCR_RES_WR_MASK_19)) | (((0) & (MAC_TCR_MASK_19)) << 19);\
		v = (v & (MAC_TCR_RES_WR_MASK_6)) | (((0) & (MAC_TCR_MASK_6)) << 6);\
		v = ((v & MAC_TCR_TSCTRLSSR_WR_MASK) | ((data & MAC_TCR_TSCTRLSSR_MASK) << 9));\
		MAC_TCR_RGWR(v);\
} while (0)

#define MAC_TCR_TSCTRLSSR_UDFRD(data) do {\
		MAC_TCR_RGRD(data);\
		data = ((data >> 9) & MAC_TCR_TSCTRLSSR_MASK);\
} while (0)

/*#define MAC_TCR_TSENALL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSENALL_MASK (ULONG)(0x1)

/*#define MAC_TCR_TSENALL_Wr_Mask (ULONG)(~((~(~0 << (1))) << (8)))*/

#define MAC_TCR_TSENALL_WR_MASK (ULONG)(0xfffffeff)

#define MAC_TCR_TSENALL_UDFWR(data) do {\
		ULONG v;\
		MAC_TCR_RGRD(v);\
		v = (v & (MAC_TCR_RES_WR_MASK_29)) | (((0) & (MAC_TCR_MASK_29)) << 29);\
		v = (v & (MAC_TCR_RES_WR_MASK_25)) | (((0) & (MAC_TCR_MASK_25)) << 25);\
		v = (v & (MAC_TCR_RES_WR_MASK_21)) | (((0) & (MAC_TCR_MASK_21)) << 21);\
		v = (v & (MAC_TCR_RES_WR_MASK_19)) | (((0) & (MAC_TCR_MASK_19)) << 19);\
		v = (v & (MAC_TCR_RES_WR_MASK_6)) | (((0) & (MAC_TCR_MASK_6)) << 6);\
		v = ((v & MAC_TCR_TSENALL_WR_MASK) | ((data & MAC_TCR_TSENALL_MASK) << 8));\
		MAC_TCR_RGWR(v);\
} while (0)

#define MAC_TCR_TSENALL_UDFRD(data) do {\
		MAC_TCR_RGRD(data);\
		data = ((data >> 8) & MAC_TCR_TSENALL_MASK);\
} while (0)

/*#define MAC_TCR_TSADDREG_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSADDREG_MASK (ULONG)(0x1)

/*#define MAC_TCR_TSADDREG_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MAC_TCR_TSADDREG_WR_MASK (ULONG)(0xffffffdf)

#define MAC_TCR_TSADDREG_UDFWR(data) do {\
		ULONG v;\
		MAC_TCR_RGRD(v);\
		v = (v & (MAC_TCR_RES_WR_MASK_29)) | (((0) & (MAC_TCR_MASK_29)) << 29);\
		v = (v & (MAC_TCR_RES_WR_MASK_25)) | (((0) & (MAC_TCR_MASK_25)) << 25);\
		v = (v & (MAC_TCR_RES_WR_MASK_21)) | (((0) & (MAC_TCR_MASK_21)) << 21);\
		v = (v & (MAC_TCR_RES_WR_MASK_19)) | (((0) & (MAC_TCR_MASK_19)) << 19);\
		v = (v & (MAC_TCR_RES_WR_MASK_6)) | (((0) & (MAC_TCR_MASK_6)) << 6);\
		v = ((v & MAC_TCR_TSADDREG_WR_MASK) | ((data & MAC_TCR_TSADDREG_MASK) << 5));\
		MAC_TCR_RGWR(v);\
} while (0)

#define MAC_TCR_TSADDREG_UDFRD(data) do {\
		MAC_TCR_RGRD(data);\
		data = ((data >> 5) & MAC_TCR_TSADDREG_MASK);\
} while (0)

/*#define MAC_TCR_TSTRIG_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSTRIG_MASK (ULONG)(0x1)

/*#define MAC_TCR_TSTRIG_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MAC_TCR_TSTRIG_WR_MASK (ULONG)(0xffffffef)

#define MAC_TCR_TSTRIG_UDFWR(data) do {\
		ULONG v;\
		MAC_TCR_RGRD(v);\
		v = (v & (MAC_TCR_RES_WR_MASK_29)) | (((0) & (MAC_TCR_MASK_29)) << 29);\
		v = (v & (MAC_TCR_RES_WR_MASK_25)) | (((0) & (MAC_TCR_MASK_25)) << 25);\
		v = (v & (MAC_TCR_RES_WR_MASK_21)) | (((0) & (MAC_TCR_MASK_21)) << 21);\
		v = (v & (MAC_TCR_RES_WR_MASK_19)) | (((0) & (MAC_TCR_MASK_19)) << 19);\
		v = (v & (MAC_TCR_RES_WR_MASK_6)) | (((0) & (MAC_TCR_MASK_6)) << 6);\
		v = ((v & MAC_TCR_TSTRIG_WR_MASK) | ((data & MAC_TCR_TSTRIG_MASK) << 4));\
		MAC_TCR_RGWR(v);\
} while (0)

#define MAC_TCR_TSTRIG_UDFRD(data) do {\
		MAC_TCR_RGRD(data);\
		data = ((data >> 4) & MAC_TCR_TSTRIG_MASK);\
} while (0)

/*#define MAC_TCR_TSUPDT_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSUPDT_MASK (ULONG)(0x1)

/*#define MAC_TCR_TSUPDT_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MAC_TCR_TSUPDT_WR_MASK (ULONG)(0xfffffff7)

#define MAC_TCR_TSUPDT_UDFWR(data) do {\
		ULONG v;\
		MAC_TCR_RGRD(v);\
		v = (v & (MAC_TCR_RES_WR_MASK_29)) | (((0) & (MAC_TCR_MASK_29)) << 29);\
		v = (v & (MAC_TCR_RES_WR_MASK_25)) | (((0) & (MAC_TCR_MASK_25)) << 25);\
		v = (v & (MAC_TCR_RES_WR_MASK_21)) | (((0) & (MAC_TCR_MASK_21)) << 21);\
		v = (v & (MAC_TCR_RES_WR_MASK_19)) | (((0) & (MAC_TCR_MASK_19)) << 19);\
		v = (v & (MAC_TCR_RES_WR_MASK_6)) | (((0) & (MAC_TCR_MASK_6)) << 6);\
		v = ((v & MAC_TCR_TSUPDT_WR_MASK) | ((data & MAC_TCR_TSUPDT_MASK) << 3));\
		MAC_TCR_RGWR(v);\
} while (0)

#define MAC_TCR_TSUPDT_UDFRD(data) do {\
		MAC_TCR_RGRD(data);\
		data = ((data >> 3) & MAC_TCR_TSUPDT_MASK);\
} while (0)

/*#define MAC_TCR_TSINIT_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSINIT_MASK (ULONG)(0x1)

/*#define MAC_TCR_TSINIT_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MAC_TCR_TSINIT_WR_MASK (ULONG)(0xfffffffb)

#define MAC_TCR_TSINIT_UDFWR(data) do {\
		ULONG v;\
		MAC_TCR_RGRD(v);\
		v = (v & (MAC_TCR_RES_WR_MASK_29)) | (((0) & (MAC_TCR_MASK_29)) << 29);\
		v = (v & (MAC_TCR_RES_WR_MASK_25)) | (((0) & (MAC_TCR_MASK_25)) << 25);\
		v = (v & (MAC_TCR_RES_WR_MASK_21)) | (((0) & (MAC_TCR_MASK_21)) << 21);\
		v = (v & (MAC_TCR_RES_WR_MASK_19)) | (((0) & (MAC_TCR_MASK_19)) << 19);\
		v = (v & (MAC_TCR_RES_WR_MASK_6)) | (((0) & (MAC_TCR_MASK_6)) << 6);\
		v = ((v & MAC_TCR_TSINIT_WR_MASK) | ((data & MAC_TCR_TSINIT_MASK) << 2));\
		MAC_TCR_RGWR(v);\
} while (0)

#define MAC_TCR_TSINIT_UDFRD(data) do {\
		MAC_TCR_RGRD(data);\
		data = ((data >> 2) & MAC_TCR_TSINIT_MASK);\
} while (0)

/*#define MAC_TCR_TSCFUPDT_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSCFUPDT_MASK (ULONG)(0x1)

/*#define MAC_TCR_TSCFUPDT_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_TCR_TSCFUPDT_WR_MASK (ULONG)(0xfffffffd)

#define MAC_TCR_TSCFUPDT_UDFWR(data) do {\
		ULONG v;\
		MAC_TCR_RGRD(v);\
		v = (v & (MAC_TCR_RES_WR_MASK_29)) | (((0) & (MAC_TCR_MASK_29)) << 29);\
		v = (v & (MAC_TCR_RES_WR_MASK_25)) | (((0) & (MAC_TCR_MASK_25)) << 25);\
		v = (v & (MAC_TCR_RES_WR_MASK_21)) | (((0) & (MAC_TCR_MASK_21)) << 21);\
		v = (v & (MAC_TCR_RES_WR_MASK_19)) | (((0) & (MAC_TCR_MASK_19)) << 19);\
		v = (v & (MAC_TCR_RES_WR_MASK_6)) | (((0) & (MAC_TCR_MASK_6)) << 6);\
		v = ((v & MAC_TCR_TSCFUPDT_WR_MASK) | ((data & MAC_TCR_TSCFUPDT_MASK) << 1));\
		MAC_TCR_RGWR(v);\
} while (0)

#define MAC_TCR_TSCFUPDT_UDFRD(data) do {\
		MAC_TCR_RGRD(data);\
		data = ((data >> 1) & MAC_TCR_TSCFUPDT_MASK);\
} while (0)

/*#define MAC_TCR_TSENA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSENA_MASK (ULONG)(0x1)

/*#define MAC_TCR_TSENA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_TCR_TSENA_WR_MASK (ULONG)(0xfffffffe)

#define MAC_TCR_TSENA_UDFWR(data) do {\
		ULONG v;\
		MAC_TCR_RGRD(v);\
		v = (v & (MAC_TCR_RES_WR_MASK_29)) | (((0) & (MAC_TCR_MASK_29)) << 29);\
		v = (v & (MAC_TCR_RES_WR_MASK_25)) | (((0) & (MAC_TCR_MASK_25)) << 25);\
		v = (v & (MAC_TCR_RES_WR_MASK_21)) | (((0) & (MAC_TCR_MASK_21)) << 21);\
		v = (v & (MAC_TCR_RES_WR_MASK_19)) | (((0) & (MAC_TCR_MASK_19)) << 19);\
		v = (v & (MAC_TCR_RES_WR_MASK_6)) | (((0) & (MAC_TCR_MASK_6)) << 6);\
		v = ((v & MAC_TCR_TSENA_WR_MASK) | ((data & MAC_TCR_TSENA_MASK) << 0));\
		MAC_TCR_RGWR(v);\
} while (0)

#define MAC_TCR_TSENA_UDFRD(data) do {\
		MAC_TCR_RGRD(data);\
		data = ((data >> 0) & MAC_TCR_TSENA_MASK);\
} while (0)

#define MTL_DSR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xc0c))

#define MTL_DSR_RGWR(data) do {\
		iowrite32(data, (void *)MTL_DSR_RGOFFADDR);\
} while (0)

#define MTL_DSR_RGRD(data) do {\
		(data) = ioread32((void *)MTL_DSR_RGOFFADDR);\
} while (0)

/*#define  MTL_DSR_Mask_10 (ULONG)(~(~0<<(6)))*/

#define  MTL_DSR_MASK_10 (ULONG)(0x3f)

/*#define MTL_DSR_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(6)))<<(10)))*/

#define MTL_DSR_RES_WR_MASK_10 (ULONG)(0xffff03ff)

/*#define  MTL_DSR_Mask_5 (ULONG)(~(~0<<(3)))*/

#define  MTL_DSR_MASK_5 (ULONG)(0x7)

/*#define MTL_DSR_RES_Wr_Mask_5 (ULONG)(~((~(~0<<(3)))<<(5)))*/

#define MTL_DSR_RES_WR_MASK_5 (ULONG)(0xffffff1f)

/*#define MTL_DSR_LOCR_Mask (ULONG)(~(~0<<(16)))*/

#define MTL_DSR_LOCR_MASK (ULONG)(0xffff)

#define MTL_DSR_LOCR_UDFRD(data) do {\
		MTL_DSR_RGRD(data);\
		data = ((data >> 16) & MTL_DSR_LOCR_MASK);\
} while (0)

/*#define MTL_DSR_STSI_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_DSR_STSI_MASK (ULONG)(0x1)

#define MTL_DSR_STSI_UDFRD(data) do {\
		MTL_DSR_RGRD(data);\
		data = ((data >> 9) & MTL_DSR_STSI_MASK);\
} while (0)

/*#define MTL_DSR_PKTI_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_DSR_PKTI_MASK (ULONG)(0x1)

#define MTL_DSR_PKTI_UDFRD(data) do {\
		MTL_DSR_RGRD(data);\
		data = ((data >> 8) & MTL_DSR_PKTI_MASK);\
} while (0)

/*#define MTL_DSR_BYTEEN_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_DSR_BYTEEN_MASK (ULONG)(0x3)

/*#define MTL_DSR_BYTEEN_Wr_Mask (ULONG)(~((~(~0 << (2))) << (3)))*/

#define MTL_DSR_BYTEEN_WR_MASK (ULONG)(0xffffffe7)

#define MTL_DSR_BYTEEN_UDFWR(data) do {\
		ULONG v;\
		MTL_DSR_RGRD(v);\
		v = (v & (MTL_DSR_RES_WR_MASK_10)) | (((0) & (MTL_DSR_MASK_10)) << 10);\
		v = (v & (MTL_DSR_RES_WR_MASK_5)) | (((0) & (MTL_DSR_MASK_5)) << 5);\
		v = ((v & MTL_DSR_BYTEEN_WR_MASK) | ((data & MTL_DSR_BYTEEN_MASK) << 3));\
		MTL_DSR_RGWR(v);\
} while (0)

#define MTL_DSR_BYTEEN_UDFRD(data) do {\
		MTL_DSR_RGRD(data);\
		data = ((data >> 3) & MTL_DSR_BYTEEN_MASK);\
} while (0)

/*#define MTL_DSR_PKTSTATE_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_DSR_PKTSTATE_MASK (ULONG)(0x3)

#define MTL_DSR_PKTSTATE_UDFRD(data) do {\
		MTL_DSR_RGRD(data);\
		data = ((data >> 1) & MTL_DSR_PKTSTATE_MASK);\
} while (0)

/*#define MTL_DSR_FIFOBUSY_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_DSR_FIFOBUSY_MASK (ULONG)(0x1)

#define MTL_DSR_FIFOBUSY_UDFRD(data) do {\
		MTL_DSR_RGRD(data);\
		data = ((data >> 0) & MTL_DSR_FIFOBUSY_MASK);\
} while (0)

#define MAC_RWPFFR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xc4))

#define MAC_RWPFFR_RGWR(data) do {\
		iowrite32(data, (void *)MAC_RWPFFR_RGOFFADDR);\
} while (0)

#define MAC_RWPFFR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_RWPFFR_RGOFFADDR);\
} while (0)

#define MAC_RWPFFR_MAC_RWPFF_UDFWR(data) do {\
		MAC_RWPFFR_RGWR(data);\
} while (0)

#define MAC_RWPFFR_MAC_RWPFF_UDFRD(data) do {\
		MAC_RWPFFR_RGRD(data);\
} while (0)

#define MAC_RTSR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xb8))

#define MAC_RTSR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_RTSR_RGOFFADDR);\
} while (0)

/*#define MAC_RTSR_RWT_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_RTSR_RWT_MASK (ULONG)(0x1)

#define MAC_RTSR_RWT_UDFRD(data) do {\
		MAC_RTSR_RGRD(data);\
		data = ((data >> 8) & MAC_RTSR_RWT_MASK);\
} while (0)

/*#define MAC_RTSR_EXCOL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_RTSR_EXCOL_MASK (ULONG)(0x1)

#define MAC_RTSR_EXCOL_UDFRD(data) do {\
		MAC_RTSR_RGRD(data);\
		data = ((data >> 5) & MAC_RTSR_EXCOL_MASK);\
} while (0)

/*#define MAC_RTSR_LCOL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_RTSR_LCOL_MASK (ULONG)(0x1)

#define MAC_RTSR_LCOL_UDFRD(data) do {\
		MAC_RTSR_RGRD(data);\
		data = ((data >> 4) & MAC_RTSR_LCOL_MASK);\
} while (0)

/*#define MAC_RTSR_EXDEF_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_RTSR_EXDEF_MASK (ULONG)(0x1)

#define MAC_RTSR_EXDEF_UDFRD(data) do {\
		MAC_RTSR_RGRD(data);\
		data = ((data >> 3) & MAC_RTSR_EXDEF_MASK);\
} while (0)

/*#define MAC_RTSR_LCARR_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_RTSR_LCARR_MASK (ULONG)(0x1)

#define MAC_RTSR_LCARR_UDFRD(data) do {\
		MAC_RTSR_RGRD(data);\
		data = ((data >> 2) & MAC_RTSR_LCARR_MASK);\
} while (0)

/*#define MAC_RTSR_NCARR_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_RTSR_NCARR_MASK (ULONG)(0x1)

#define MAC_RTSR_NCARR_UDFRD(data) do {\
		MAC_RTSR_RGRD(data);\
		data = ((data >> 1) & MAC_RTSR_NCARR_MASK);\
} while (0)

/*#define MAC_RTSR_TJT_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_RTSR_TJT_MASK (ULONG)(0x1)

#define MAC_RTSR_TJT_UDFRD(data) do {\
		MAC_RTSR_RGRD(data);\
		data = ((data >> 0) & MAC_RTSR_TJT_MASK);\
} while (0)

#define MTL_IER_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xc1c))

#define MTL_IER_RGWR(data) do {\
		iowrite32(data, (void *)MTL_IER_RGOFFADDR);\
} while (0)

#define MTL_IER_RGRD(data) do {\
		(data) = ioread32((void *)MTL_IER_RGOFFADDR);\
} while (0)

/*#define  MTL_IER_Mask_17 (ULONG)(~(~0<<(15)))*/

#define  MTL_IER_MASK_17 (ULONG)(0x7fff)

/*#define MTL_IER_RES_Wr_Mask_17 (ULONG)(~((~(~0<<(15)))<<(17)))*/

#define MTL_IER_RES_WR_MASK_17 (ULONG)(0x1ffff)

/*#define MTL_IER_MACIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_MACIE_MASK (ULONG)(0x1)

/*#define MTL_IER_MACIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MTL_IER_MACIE_WR_MASK (ULONG)(0xfffeffff)

#define MTL_IER_MACIE_UDFWR(data) do {\
		ULONG v;\
		MTL_IER_RGRD(v);\
		v = (v & (MTL_IER_RES_WR_MASK_17)) | (((0) & (MTL_IER_MASK_17)) << 17);\
		v = ((v & MTL_IER_MACIE_WR_MASK) | ((data & MTL_IER_MACIE_MASK) << 16));\
		MTL_IER_RGWR(v);\
} while (0)

#define MTL_IER_MACIE_UDFRD(data) do {\
		MTL_IER_RGRD(data);\
		data = ((data >> 16) & MTL_IER_MACIE_MASK);\
} while (0)

/*#define MTL_IER_Q7RXOIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q7RXOIE_MASK (ULONG)(0x1)

/*#define MTL_IER_Q7RXOIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (15)))*/

#define MTL_IER_Q7RXOIE_WR_MASK (ULONG)(0xffff7fff)

#define MTL_IER_Q7RXOIE_UDFWR(data) do {\
		ULONG v;\
		MTL_IER_RGRD(v);\
		v = (v & (MTL_IER_RES_WR_MASK_17)) | (((0) & (MTL_IER_MASK_17)) << 17);\
		v = ((v & MTL_IER_Q7RXOIE_WR_MASK) | ((data & MTL_IER_Q7RXOIE_MASK) << 15));\
		MTL_IER_RGWR(v);\
} while (0)

#define MTL_IER_Q7RXOIE_UDFRD(data) do {\
		MTL_IER_RGRD(data);\
		data = ((data >> 15) & MTL_IER_Q7RXOIE_MASK);\
} while (0)

/*#define MTL_IER_Q7TXUIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q7TXUIE_MASK (ULONG)(0x1)

/*#define MTL_IER_Q7TXUIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (14)))*/

#define MTL_IER_Q7TXUIE_WR_MASK (ULONG)(0xffffbfff)

#define MTL_IER_Q7TXUIE_UDFWR(data) do {\
		ULONG v;\
		MTL_IER_RGRD(v);\
		v = (v & (MTL_IER_RES_WR_MASK_17)) | (((0) & (MTL_IER_MASK_17)) << 17);\
		v = ((v & MTL_IER_Q7TXUIE_WR_MASK) | ((data & MTL_IER_Q7TXUIE_MASK) << 14));\
		MTL_IER_RGWR(v);\
} while (0)

#define MTL_IER_Q7TXUIE_UDFRD(data) do {\
		MTL_IER_RGRD(data);\
		data = ((data >> 14) & MTL_IER_Q7TXUIE_MASK);\
} while (0)

/*#define MTL_IER_Q6RXOIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q6RXOIE_MASK (ULONG)(0x1)

/*#define MTL_IER_Q6RXOIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (13)))*/

#define MTL_IER_Q6RXOIE_WR_MASK (ULONG)(0xffffdfff)

#define MTL_IER_Q6RXOIE_UDFWR(data) do {\
		ULONG v;\
		MTL_IER_RGRD(v);\
		v = (v & (MTL_IER_RES_WR_MASK_17)) | (((0) & (MTL_IER_MASK_17)) << 17);\
		v = ((v & MTL_IER_Q6RXOIE_WR_MASK) | ((data & MTL_IER_Q6RXOIE_MASK) << 13));\
		MTL_IER_RGWR(v);\
} while (0)

#define MTL_IER_Q6RXOIE_UDFRD(data) do {\
		MTL_IER_RGRD(data);\
		data = ((data >> 13) & MTL_IER_Q6RXOIE_MASK);\
} while (0)

/*#define MTL_IER_Q6TXUIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q6TXUIE_MASK (ULONG)(0x1)

/*#define MTL_IER_Q6TXUIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define MTL_IER_Q6TXUIE_WR_MASK (ULONG)(0xffffefff)

#define MTL_IER_Q6TXUIE_UDFWR(data) do {\
		ULONG v;\
		MTL_IER_RGRD(v);\
		v = (v & (MTL_IER_RES_WR_MASK_17)) | (((0) & (MTL_IER_MASK_17)) << 17);\
		v = ((v & MTL_IER_Q6TXUIE_WR_MASK) | ((data & MTL_IER_Q6TXUIE_MASK) << 12));\
		MTL_IER_RGWR(v);\
} while (0)

#define MTL_IER_Q6TXUIE_UDFRD(data) do {\
		MTL_IER_RGRD(data);\
		data = ((data >> 12) & MTL_IER_Q6TXUIE_MASK);\
} while (0)

/*#define MTL_IER_Q5RXOIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q5RXOIE_MASK (ULONG)(0x1)

/*#define MTL_IER_Q5RXOIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MTL_IER_Q5RXOIE_WR_MASK (ULONG)(0xfffff7ff)

#define MTL_IER_Q5RXOIE_UDFWR(data) do {\
		ULONG v;\
		MTL_IER_RGRD(v);\
		v = (v & (MTL_IER_RES_WR_MASK_17)) | (((0) & (MTL_IER_MASK_17)) << 17);\
		v = ((v & MTL_IER_Q5RXOIE_WR_MASK) | ((data & MTL_IER_Q5RXOIE_MASK) << 11));\
		MTL_IER_RGWR(v);\
} while (0)

#define MTL_IER_Q5RXOIE_UDFRD(data) do {\
		MTL_IER_RGRD(data);\
		data = ((data >> 11) & MTL_IER_Q5RXOIE_MASK);\
} while (0)

/*#define MTL_IER_Q5TXUIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q5TXUIE_MASK (ULONG)(0x1)

/*#define MTL_IER_Q5TXUIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (10)))*/

#define MTL_IER_Q5TXUIE_WR_MASK (ULONG)(0xfffffbff)

#define MTL_IER_Q5TXUIE_UDFWR(data) do {\
		ULONG v;\
		MTL_IER_RGRD(v);\
		v = (v & (MTL_IER_RES_WR_MASK_17)) | (((0) & (MTL_IER_MASK_17)) << 17);\
		v = ((v & MTL_IER_Q5TXUIE_WR_MASK) | ((data & MTL_IER_Q5TXUIE_MASK) << 10));\
		MTL_IER_RGWR(v);\
} while (0)

#define MTL_IER_Q5TXUIE_UDFRD(data) do {\
		MTL_IER_RGRD(data);\
		data = ((data >> 10) & MTL_IER_Q5TXUIE_MASK);\
} while (0)

/*#define MTL_IER_Q4RXOIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q4RXOIE_MASK (ULONG)(0x1)

/*#define MTL_IER_Q4RXOIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (9)))*/

#define MTL_IER_Q4RXOIE_WR_MASK (ULONG)(0xfffffdff)

#define MTL_IER_Q4RXOIE_UDFWR(data) do {\
		ULONG v;\
		MTL_IER_RGRD(v);\
		v = (v & (MTL_IER_RES_WR_MASK_17)) | (((0) & (MTL_IER_MASK_17)) << 17);\
		v = ((v & MTL_IER_Q4RXOIE_WR_MASK) | ((data & MTL_IER_Q4RXOIE_MASK) << 9));\
		MTL_IER_RGWR(v);\
} while (0)

#define MTL_IER_Q4RXOIE_UDFRD(data) do {\
		MTL_IER_RGRD(data);\
		data = ((data >> 9) & MTL_IER_Q4RXOIE_MASK);\
} while (0)

/*#define MTL_IER_Q4TXUIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q4TXUIE_MASK (ULONG)(0x1)

/*#define MTL_IER_Q4TXUIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (8)))*/

#define MTL_IER_Q4TXUIE_WR_MASK (ULONG)(0xfffffeff)

#define MTL_IER_Q4TXUIE_UDFWR(data) do {\
		ULONG v;\
		MTL_IER_RGRD(v);\
		v = (v & (MTL_IER_RES_WR_MASK_17)) | (((0) & (MTL_IER_MASK_17)) << 17);\
		v = ((v & MTL_IER_Q4TXUIE_WR_MASK) | ((data & MTL_IER_Q4TXUIE_MASK) << 8));\
		MTL_IER_RGWR(v);\
} while (0)

#define MTL_IER_Q4TXUIE_UDFRD(data) do {\
		MTL_IER_RGRD(data);\
		data = ((data >> 8) & MTL_IER_Q4TXUIE_MASK);\
} while (0)

/*#define MTL_IER_Q3RXOIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q3RXOIE_MASK (ULONG)(0x1)

/*#define MTL_IER_Q3RXOIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MTL_IER_Q3RXOIE_WR_MASK (ULONG)(0xffffff7f)

#define MTL_IER_Q3RXOIE_UDFWR(data) do {\
		ULONG v;\
		MTL_IER_RGRD(v);\
		v = (v & (MTL_IER_RES_WR_MASK_17)) | (((0) & (MTL_IER_MASK_17)) << 17);\
		v = ((v & MTL_IER_Q3RXOIE_WR_MASK) | ((data & MTL_IER_Q3RXOIE_MASK) << 7));\
		MTL_IER_RGWR(v);\
} while (0)

#define MTL_IER_Q3RXOIE_UDFRD(data) do {\
		MTL_IER_RGRD(data);\
		data = ((data >> 7) & MTL_IER_Q3RXOIE_MASK);\
} while (0)

/*#define MTL_IER_Q3TXUIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q3TXUIE_MASK (ULONG)(0x1)

/*#define MTL_IER_Q3TXUIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (6)))*/

#define MTL_IER_Q3TXUIE_WR_MASK (ULONG)(0xffffffbf)

#define MTL_IER_Q3TXUIE_UDFWR(data) do {\
		ULONG v;\
		MTL_IER_RGRD(v);\
		v = (v & (MTL_IER_RES_WR_MASK_17)) | (((0) & (MTL_IER_MASK_17)) << 17);\
		v = ((v & MTL_IER_Q3TXUIE_WR_MASK) | ((data & MTL_IER_Q3TXUIE_MASK) << 6));\
		MTL_IER_RGWR(v);\
} while (0)

#define MTL_IER_Q3TXUIE_UDFRD(data) do {\
		MTL_IER_RGRD(data);\
		data = ((data >> 6) & MTL_IER_Q3TXUIE_MASK);\
} while (0)

/*#define MTL_IER_Q2RXOIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q2RXOIE_MASK (ULONG)(0x1)

/*#define MTL_IER_Q2RXOIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MTL_IER_Q2RXOIE_WR_MASK (ULONG)(0xffffffdf)

#define MTL_IER_Q2RXOIE_UDFWR(data) do {\
		ULONG v;\
		MTL_IER_RGRD(v);\
		v = (v & (MTL_IER_RES_WR_MASK_17)) | (((0) & (MTL_IER_MASK_17)) << 17);\
		v = ((v & MTL_IER_Q2RXOIE_WR_MASK) | ((data & MTL_IER_Q2RXOIE_MASK) << 5));\
		MTL_IER_RGWR(v);\
} while (0)

#define MTL_IER_Q2RXOIE_UDFRD(data) do {\
		MTL_IER_RGRD(data);\
		data = ((data >> 5) & MTL_IER_Q2RXOIE_MASK);\
} while (0)

/*#define MTL_IER_Q2TXUIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q2TXUIE_MASK (ULONG)(0x1)

/*#define MTL_IER_Q2TXUIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MTL_IER_Q2TXUIE_WR_MASK (ULONG)(0xffffffef)

#define MTL_IER_Q2TXUIE_UDFWR(data) do {\
		ULONG v;\
		MTL_IER_RGRD(v);\
		v = (v & (MTL_IER_RES_WR_MASK_17)) | (((0) & (MTL_IER_MASK_17)) << 17);\
		v = ((v & MTL_IER_Q2TXUIE_WR_MASK) | ((data & MTL_IER_Q2TXUIE_MASK) << 4));\
		MTL_IER_RGWR(v);\
} while (0)

#define MTL_IER_Q2TXUIE_UDFRD(data) do {\
		MTL_IER_RGRD(data);\
		data = ((data >> 4) & MTL_IER_Q2TXUIE_MASK);\
} while (0)

/*#define MTL_IER_Q1RXOIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q1RXOIE_MASK (ULONG)(0x1)

/*#define MTL_IER_Q1RXOIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_IER_Q1RXOIE_WR_MASK (ULONG)(0xfffffff7)

#define MTL_IER_Q1RXOIE_UDFWR(data) do {\
		ULONG v;\
		MTL_IER_RGRD(v);\
		v = (v & (MTL_IER_RES_WR_MASK_17)) | (((0) & (MTL_IER_MASK_17)) << 17);\
		v = ((v & MTL_IER_Q1RXOIE_WR_MASK) | ((data & MTL_IER_Q1RXOIE_MASK) << 3));\
		MTL_IER_RGWR(v);\
} while (0)

#define MTL_IER_Q1RXOIE_UDFRD(data) do {\
		MTL_IER_RGRD(data);\
		data = ((data >> 3) & MTL_IER_Q1RXOIE_MASK);\
} while (0)

/*#define MTL_IER_Q1TXUIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q1TXUIE_MASK (ULONG)(0x1)

/*#define MTL_IER_Q1TXUIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MTL_IER_Q1TXUIE_WR_MASK (ULONG)(0xfffffffb)

#define MTL_IER_Q1TXUIE_UDFWR(data) do {\
		ULONG v;\
		MTL_IER_RGRD(v);\
		v = (v & (MTL_IER_RES_WR_MASK_17)) | (((0) & (MTL_IER_MASK_17)) << 17);\
		v = ((v & MTL_IER_Q1TXUIE_WR_MASK) | ((data & MTL_IER_Q1TXUIE_MASK) << 2));\
		MTL_IER_RGWR(v);\
} while (0)

#define MTL_IER_Q1TXUIE_UDFRD(data) do {\
		MTL_IER_RGRD(data);\
		data = ((data >> 2) & MTL_IER_Q1TXUIE_MASK);\
} while (0)

/*#define MTL_IER_Q0RXOIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q0RXOIE_MASK (ULONG)(0x1)

/*#define MTL_IER_Q0RXOIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MTL_IER_Q0RXOIE_WR_MASK (ULONG)(0xfffffffd)

#define MTL_IER_Q0RXOIE_UDFWR(data) do {\
		ULONG v;\
		MTL_IER_RGRD(v);\
		v = (v & (MTL_IER_RES_WR_MASK_17)) | (((0) & (MTL_IER_MASK_17)) << 17);\
		v = ((v & MTL_IER_Q0RXOIE_WR_MASK) | ((data & MTL_IER_Q0RXOIE_MASK) << 1));\
		MTL_IER_RGWR(v);\
} while (0)

#define MTL_IER_Q0RXOIE_UDFRD(data) do {\
		MTL_IER_RGRD(data);\
		data = ((data >> 1) & MTL_IER_Q0RXOIE_MASK);\
} while (0)

/*#define MTL_IER_Q0TXUIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q0TXUIE_MASK (ULONG)(0x1)

/*#define MTL_IER_Q0TXUIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MTL_IER_Q0TXUIE_WR_MASK (ULONG)(0xfffffffe)

#define MTL_IER_Q0TXUIE_UDFWR(data) do {\
		ULONG v;\
		MTL_IER_RGRD(v);\
		v = (v & (MTL_IER_RES_WR_MASK_17)) | (((0) & (MTL_IER_MASK_17)) << 17);\
		v = ((v & MTL_IER_Q0TXUIE_WR_MASK) | ((data & MTL_IER_Q0TXUIE_MASK) << 0));\
		MTL_IER_RGWR(v);\
} while (0)

#define MTL_IER_Q0TXUIE_UDFRD(data) do {\
		MTL_IER_RGRD(data);\
		data = ((data >> 0) & MTL_IER_Q0TXUIE_MASK);\
} while (0)

#define MTL_QRCR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xefc))

#define MTL_QRCR7_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QRCR7_RGOFFADDR);\
} while (0)

#define MTL_QRCR7_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QRCR7_RGOFFADDR);\
} while (0)

/*#define  MTL_QRCR7_Mask_4 (ULONG)(~(~0<<(28)))*/

#define  MTL_QRCR7_MASK_4 (ULONG)(0xfffffff)

/*#define MTL_QRCR7_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(28)))<<(4)))*/

#define MTL_QRCR7_RES_WR_MASK_4 (ULONG)(0xf)

/*#define MTL_QRCR7_RXQ_WEGT_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QRCR7_RXQ_WEGT_MASK (ULONG)(0x7)

/*#define MTL_QRCR7_RXQ_WEGT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (0)))*/

#define MTL_QRCR7_RXQ_WEGT_WR_MASK (ULONG)(0xfffffff8)

#define MTL_QRCR7_RXQ_WEGT_UDFWR(data) do {\
		ULONG v;\
		MTL_QRCR7_RGRD(v);\
		v = (v & (MTL_QRCR7_RES_WR_MASK_4)) | (((0) & (MTL_QRCR7_MASK_4)) << 4);\
		v = ((v & MTL_QRCR7_RXQ_WEGT_WR_MASK) | ((data & MTL_QRCR7_RXQ_WEGT_MASK) << 0));\
		MTL_QRCR7_RGWR(v);\
} while (0)

#define MTL_QRCR7_RXQ_WEGT_UDFRD(data) do {\
		MTL_QRCR7_RGRD(data);\
		data = ((data >> 0) & MTL_QRCR7_RXQ_WEGT_MASK);\
} while (0)

/*#define MTL_QRCR7_RXQ_PKT_ARBIT_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QRCR7_RXQ_PKT_ARBIT_MASK (ULONG)(0x1)

/*#define MTL_QRCR7_RXQ_PKT_ARBIT_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_QRCR7_RXQ_PKT_ARBIT_WR_MASK (ULONG)(0xfffffff7)

#define MTL_QRCR7_RXQ_PKT_ARBIT_UDFWR(data) do {\
		ULONG v;\
		MTL_QRCR7_RGRD(v);\
		v = (v & (MTL_QRCR7_RES_WR_MASK_4)) | (((0) & (MTL_QRCR7_MASK_4)) << 4);\
		v = ((v & MTL_QRCR7_RXQ_PKT_ARBIT_WR_MASK) | ((data & MTL_QRCR7_RXQ_PKT_ARBIT_MASK) << 3));\
		MTL_QRCR7_RGWR(v);\
} while (0)

#define MTL_QRCR7_RXQ_PKT_ARBIT_UDFRD(data) do {\
		MTL_QRCR7_RGRD(data);\
		data = ((data >> 3) & MTL_QRCR7_RXQ_PKT_ARBIT_MASK);\
} while (0)

#define MTL_QRCR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xebc))

#define MTL_QRCR6_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QRCR6_RGOFFADDR);\
} while (0)

#define MTL_QRCR6_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QRCR6_RGOFFADDR);\
} while (0)

/*#define  MTL_QRCR6_Mask_4 (ULONG)(~(~0<<(28)))*/

#define  MTL_QRCR6_MASK_4 (ULONG)(0xfffffff)

/*#define MTL_QRCR6_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(28)))<<(4)))*/

#define MTL_QRCR6_RES_WR_MASK_4 (ULONG)(0xf)

/*#define MTL_QRCR6_RXQ_WEGT_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QRCR6_RXQ_WEGT_MASK (ULONG)(0x7)

/*#define MTL_QRCR6_RXQ_WEGT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (0)))*/

#define MTL_QRCR6_RXQ_WEGT_WR_MASK (ULONG)(0xfffffff8)

#define MTL_QRCR6_RXQ_WEGT_UDFWR(data) do {\
		ULONG v;\
		MTL_QRCR6_RGRD(v);\
		v = (v & (MTL_QRCR6_RES_WR_MASK_4)) | (((0) & (MTL_QRCR6_MASK_4)) << 4);\
		v = ((v & MTL_QRCR6_RXQ_WEGT_WR_MASK) | ((data & MTL_QRCR6_RXQ_WEGT_MASK) << 0));\
		MTL_QRCR6_RGWR(v);\
} while (0)

#define MTL_QRCR6_RXQ_WEGT_UDFRD(data) do {\
		MTL_QRCR6_RGRD(data);\
		data = ((data >> 0) & MTL_QRCR6_RXQ_WEGT_MASK);\
} while (0)

/*#define MTL_QRCR6_RXQ_PKT_ARBIT_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QRCR6_RXQ_PKT_ARBIT_MASK (ULONG)(0x1)

/*#define MTL_QRCR6_RXQ_PKT_ARBIT_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_QRCR6_RXQ_PKT_ARBIT_WR_MASK (ULONG)(0xfffffff7)

#define MTL_QRCR6_RXQ_PKT_ARBIT_UDFWR(data) do {\
		ULONG v;\
		MTL_QRCR6_RGRD(v);\
		v = (v & (MTL_QRCR6_RES_WR_MASK_4)) | (((0) & (MTL_QRCR6_MASK_4)) << 4);\
		v = ((v & MTL_QRCR6_RXQ_PKT_ARBIT_WR_MASK) | ((data & MTL_QRCR6_RXQ_PKT_ARBIT_MASK) << 3));\
		MTL_QRCR6_RGWR(v);\
} while (0)

#define MTL_QRCR6_RXQ_PKT_ARBIT_UDFRD(data) do {\
		MTL_QRCR6_RGRD(data);\
		data = ((data >> 3) & MTL_QRCR6_RXQ_PKT_ARBIT_MASK);\
} while (0)

#define MTL_QRCR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe7c))

#define MTL_QRCR5_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QRCR5_RGOFFADDR);\
} while (0)

#define MTL_QRCR5_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QRCR5_RGOFFADDR);\
} while (0)

/*#define  MTL_QRCR5_Mask_4 (ULONG)(~(~0<<(28)))*/

#define  MTL_QRCR5_MASK_4 (ULONG)(0xfffffff)

/*#define MTL_QRCR5_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(28)))<<(4)))*/

#define MTL_QRCR5_RES_WR_MASK_4 (ULONG)(0xf)

/*#define MTL_QRCR5_RXQ_WEGT_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QRCR5_RXQ_WEGT_MASK (ULONG)(0x7)

/*#define MTL_QRCR5_RXQ_WEGT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (0)))*/

#define MTL_QRCR5_RXQ_WEGT_WR_MASK (ULONG)(0xfffffff8)

#define MTL_QRCR5_RXQ_WEGT_UDFWR(data) do {\
		ULONG v;\
		MTL_QRCR5_RGRD(v);\
		v = (v & (MTL_QRCR5_RES_WR_MASK_4)) | (((0) & (MTL_QRCR5_MASK_4)) << 4);\
		v = ((v & MTL_QRCR5_RXQ_WEGT_WR_MASK) | ((data & MTL_QRCR5_RXQ_WEGT_MASK) << 0));\
		MTL_QRCR5_RGWR(v);\
} while (0)

#define MTL_QRCR5_RXQ_WEGT_UDFRD(data) do {\
		MTL_QRCR5_RGRD(data);\
		data = ((data >> 0) & MTL_QRCR5_RXQ_WEGT_MASK);\
} while (0)

/*#define MTL_QRCR5_RXQ_PKT_ARBIT_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QRCR5_RXQ_PKT_ARBIT_MASK (ULONG)(0x1)

/*#define MTL_QRCR5_RXQ_PKT_ARBIT_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_QRCR5_RXQ_PKT_ARBIT_WR_MASK (ULONG)(0xfffffff7)

#define MTL_QRCR5_RXQ_PKT_ARBIT_UDFWR(data) do {\
		ULONG v;\
		MTL_QRCR5_RGRD(v);\
		v = (v & (MTL_QRCR5_RES_WR_MASK_4)) | (((0) & (MTL_QRCR5_MASK_4)) << 4);\
		v = ((v & MTL_QRCR5_RXQ_PKT_ARBIT_WR_MASK) | ((data & MTL_QRCR5_RXQ_PKT_ARBIT_MASK) << 3));\
		MTL_QRCR5_RGWR(v);\
} while (0)

#define MTL_QRCR5_RXQ_PKT_ARBIT_UDFRD(data) do {\
		MTL_QRCR5_RGRD(data);\
		data = ((data >> 3) & MTL_QRCR5_RXQ_PKT_ARBIT_MASK);\
} while (0)

#define MTL_QRCR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe3c))

#define MTL_QRCR4_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QRCR4_RGOFFADDR);\
} while (0)

#define MTL_QRCR4_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QRCR4_RGOFFADDR);\
} while (0)

/*#define  MTL_QRCR4_Mask_4 (ULONG)(~(~0<<(28)))*/

#define  MTL_QRCR4_MASK_4 (ULONG)(0xfffffff)

/*#define MTL_QRCR4_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(28)))<<(4)))*/

#define MTL_QRCR4_RES_WR_MASK_4 (ULONG)(0xf)

/*#define MTL_QRCR4_RXQ_WEGT_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QRCR4_RXQ_WEGT_MASK (ULONG)(0x7)

/*#define MTL_QRCR4_RXQ_WEGT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (0)))*/

#define MTL_QRCR4_RXQ_WEGT_WR_MASK (ULONG)(0xfffffff8)

#define MTL_QRCR4_RXQ_WEGT_UDFWR(data) do {\
		ULONG v;\
		MTL_QRCR4_RGRD(v);\
		v = (v & (MTL_QRCR4_RES_WR_MASK_4)) | (((0) & (MTL_QRCR4_MASK_4)) << 4);\
		v = ((v & MTL_QRCR4_RXQ_WEGT_WR_MASK) | ((data & MTL_QRCR4_RXQ_WEGT_MASK) << 0));\
		MTL_QRCR4_RGWR(v);\
} while (0)

#define MTL_QRCR4_RXQ_WEGT_UDFRD(data) do {\
		MTL_QRCR4_RGRD(data);\
		data = ((data >> 0) & MTL_QRCR4_RXQ_WEGT_MASK);\
} while (0)

/*#define MTL_QRCR4_RXQ_PKT_ARBIT_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QRCR4_RXQ_PKT_ARBIT_MASK (ULONG)(0x1)

/*#define MTL_QRCR4_RXQ_PKT_ARBIT_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_QRCR4_RXQ_PKT_ARBIT_WR_MASK (ULONG)(0xfffffff7)

#define MTL_QRCR4_RXQ_PKT_ARBIT_UDFWR(data) do {\
		ULONG v;\
		MTL_QRCR4_RGRD(v);\
		v = (v & (MTL_QRCR4_RES_WR_MASK_4)) | (((0) & (MTL_QRCR4_MASK_4)) << 4);\
		v = ((v & MTL_QRCR4_RXQ_PKT_ARBIT_WR_MASK) | ((data & MTL_QRCR4_RXQ_PKT_ARBIT_MASK) << 3));\
		MTL_QRCR4_RGWR(v);\
} while (0)

#define MTL_QRCR4_RXQ_PKT_ARBIT_UDFRD(data) do {\
		MTL_QRCR4_RGRD(data);\
		data = ((data >> 3) & MTL_QRCR4_RXQ_PKT_ARBIT_MASK);\
} while (0)

#define MTL_QRCR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xdfc))

#define MTL_QRCR3_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QRCR3_RGOFFADDR);\
} while (0)

#define MTL_QRCR3_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QRCR3_RGOFFADDR);\
} while (0)

/*#define  MTL_QRCR3_Mask_4 (ULONG)(~(~0<<(28)))*/

#define  MTL_QRCR3_MASK_4 (ULONG)(0xfffffff)

/*#define MTL_QRCR3_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(28)))<<(4)))*/

#define MTL_QRCR3_RES_WR_MASK_4 (ULONG)(0xf)

/*#define MTL_QRCR3_RXQ_WEGT_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QRCR3_RXQ_WEGT_MASK (ULONG)(0x7)

/*#define MTL_QRCR3_RXQ_WEGT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (0)))*/

#define MTL_QRCR3_RXQ_WEGT_WR_MASK (ULONG)(0xfffffff8)

#define MTL_QRCR3_RXQ_WEGT_UDFWR(data) do {\
		ULONG v;\
		MTL_QRCR3_RGRD(v);\
		v = (v & (MTL_QRCR3_RES_WR_MASK_4)) | (((0) & (MTL_QRCR3_MASK_4)) << 4);\
		v = ((v & MTL_QRCR3_RXQ_WEGT_WR_MASK) | ((data & MTL_QRCR3_RXQ_WEGT_MASK) << 0));\
		MTL_QRCR3_RGWR(v);\
} while (0)

#define MTL_QRCR3_RXQ_WEGT_UDFRD(data) do {\
		MTL_QRCR3_RGRD(data);\
		data = ((data >> 0) & MTL_QRCR3_RXQ_WEGT_MASK);\
} while (0)

/*#define MTL_QRCR3_RXQ_PKT_ARBIT_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QRCR3_RXQ_PKT_ARBIT_MASK (ULONG)(0x1)

/*#define MTL_QRCR3_RXQ_PKT_ARBIT_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_QRCR3_RXQ_PKT_ARBIT_WR_MASK (ULONG)(0xfffffff7)

#define MTL_QRCR3_RXQ_PKT_ARBIT_UDFWR(data) do {\
		ULONG v;\
		MTL_QRCR3_RGRD(v);\
		v = (v & (MTL_QRCR3_RES_WR_MASK_4)) | (((0) & (MTL_QRCR3_MASK_4)) << 4);\
		v = ((v & MTL_QRCR3_RXQ_PKT_ARBIT_WR_MASK) | ((data & MTL_QRCR3_RXQ_PKT_ARBIT_MASK) << 3));\
		MTL_QRCR3_RGWR(v);\
} while (0)

#define MTL_QRCR3_RXQ_PKT_ARBIT_UDFRD(data) do {\
		MTL_QRCR3_RGRD(data);\
		data = ((data >> 3) & MTL_QRCR3_RXQ_PKT_ARBIT_MASK);\
} while (0)

#define MTL_QRCR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xdbc))

#define MTL_QRCR2_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QRCR2_RGOFFADDR);\
} while (0)

#define MTL_QRCR2_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QRCR2_RGOFFADDR);\
} while (0)

/*#define  MTL_QRCR2_Mask_4 (ULONG)(~(~0<<(28)))*/

#define  MTL_QRCR2_MASK_4 (ULONG)(0xfffffff)

/*#define MTL_QRCR2_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(28)))<<(4)))*/

#define MTL_QRCR2_RES_WR_MASK_4 (ULONG)(0xf)

/*#define MTL_QRCR2_RXQ_WEGT_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QRCR2_RXQ_WEGT_MASK (ULONG)(0x7)

/*#define MTL_QRCR2_RXQ_WEGT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (0)))*/

#define MTL_QRCR2_RXQ_WEGT_WR_MASK (ULONG)(0xfffffff8)

#define MTL_QRCR2_RXQ_WEGT_UDFWR(data) do {\
		ULONG v;\
		MTL_QRCR2_RGRD(v);\
		v = (v & (MTL_QRCR2_RES_WR_MASK_4)) | (((0) & (MTL_QRCR2_MASK_4)) << 4);\
		v = ((v & MTL_QRCR2_RXQ_WEGT_WR_MASK) | ((data & MTL_QRCR2_RXQ_WEGT_MASK) << 0));\
		MTL_QRCR2_RGWR(v);\
} while (0)

#define MTL_QRCR2_RXQ_WEGT_UDFRD(data) do {\
		MTL_QRCR2_RGRD(data);\
		data = ((data >> 0) & MTL_QRCR2_RXQ_WEGT_MASK);\
} while (0)

/*#define MTL_QRCR2_RXQ_PKT_ARBIT_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QRCR2_RXQ_PKT_ARBIT_MASK (ULONG)(0x1)

/*#define MTL_QRCR2_RXQ_PKT_ARBIT_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_QRCR2_RXQ_PKT_ARBIT_WR_MASK (ULONG)(0xfffffff7)

#define MTL_QRCR2_RXQ_PKT_ARBIT_UDFWR(data) do {\
		ULONG v;\
		MTL_QRCR2_RGRD(v);\
		v = (v & (MTL_QRCR2_RES_WR_MASK_4)) | (((0) & (MTL_QRCR2_MASK_4)) << 4);\
		v = ((v & MTL_QRCR2_RXQ_PKT_ARBIT_WR_MASK) | ((data & MTL_QRCR2_RXQ_PKT_ARBIT_MASK) << 3));\
		MTL_QRCR2_RGWR(v);\
} while (0)

#define MTL_QRCR2_RXQ_PKT_ARBIT_UDFRD(data) do {\
		MTL_QRCR2_RGRD(data);\
		data = ((data >> 3) & MTL_QRCR2_RXQ_PKT_ARBIT_MASK);\
} while (0)

#define MTL_QRCR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd7c))

#define MTL_QRCR1_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QRCR1_RGOFFADDR);\
} while (0)

#define MTL_QRCR1_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QRCR1_RGOFFADDR);\
} while (0)

/*#define  MTL_QRCR1_Mask_4 (ULONG)(~(~0<<(28)))*/

#define  MTL_QRCR1_MASK_4 (ULONG)(0xfffffff)

/*#define MTL_QRCR1_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(28)))<<(4)))*/

#define MTL_QRCR1_RES_WR_MASK_4 (ULONG)(0xf)

/*#define MTL_QRCR1_RXQ_WEGT_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QRCR1_RXQ_WEGT_MASK (ULONG)(0x7)

/*#define MTL_QRCR1_RXQ_WEGT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (0)))*/

#define MTL_QRCR1_RXQ_WEGT_WR_MASK (ULONG)(0xfffffff8)

#define MTL_QRCR1_RXQ_WEGT_UDFWR(data) do {\
		ULONG v;\
		MTL_QRCR1_RGRD(v);\
		v = (v & (MTL_QRCR1_RES_WR_MASK_4)) | (((0) & (MTL_QRCR1_MASK_4)) << 4);\
		v = ((v & MTL_QRCR1_RXQ_WEGT_WR_MASK) | ((data & MTL_QRCR1_RXQ_WEGT_MASK) << 0));\
		MTL_QRCR1_RGWR(v);\
} while (0)

#define MTL_QRCR1_RXQ_WEGT_UDFRD(data) do {\
		MTL_QRCR1_RGRD(data);\
		data = ((data >> 0) & MTL_QRCR1_RXQ_WEGT_MASK);\
} while (0)

/*#define MTL_QRCR1_RXQ_PKT_ARBIT_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QRCR1_RXQ_PKT_ARBIT_MASK (ULONG)(0x1)

/*#define MTL_QRCR1_RXQ_PKT_ARBIT_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_QRCR1_RXQ_PKT_ARBIT_WR_MASK (ULONG)(0xfffffff7)

#define MTL_QRCR1_RXQ_PKT_ARBIT_UDFWR(data) do {\
		ULONG v;\
		MTL_QRCR1_RGRD(v);\
		v = (v & (MTL_QRCR1_RES_WR_MASK_4)) | (((0) & (MTL_QRCR1_MASK_4)) << 4);\
		v = ((v & MTL_QRCR1_RXQ_PKT_ARBIT_WR_MASK) | ((data & MTL_QRCR1_RXQ_PKT_ARBIT_MASK) << 3));\
		MTL_QRCR1_RGWR(v);\
} while (0)

#define MTL_QRCR1_RXQ_PKT_ARBIT_UDFRD(data) do {\
		MTL_QRCR1_RGRD(data);\
		data = ((data >> 3) & MTL_QRCR1_RXQ_PKT_ARBIT_MASK);\
} while (0)

#define MTL_QRDR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xef8))

#define MTL_QRDR7_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QRDR7_RGOFFADDR);\
} while (0)

/*#define MTL_QRDR7_RWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QRDR7_RWCSTS_MASK (ULONG)(0x1)

#define MTL_QRDR7_RWCSTS_UDFRD(data) do {\
		MTL_QRDR7_RGRD(data);\
		data = ((data >> 0) & MTL_QRDR7_RWCSTS_MASK);\
} while (0)

/*#define MTL_QRDR7_RRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QRDR7_RRCSTS_MASK (ULONG)(0x3)

#define MTL_QRDR7_RRCSTS_UDFRD(data) do {\
		MTL_QRDR7_RGRD(data);\
		data = ((data >> 1) & MTL_QRDR7_RRCSTS_MASK);\
} while (0)

/*#define MTL_QRDR7_RXQSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QRDR7_RXQSTS_MASK (ULONG)(0x3)

#define MTL_QRDR7_RXQSTS_UDFRD(data) do {\
		MTL_QRDR7_RGRD(data);\
		data = ((data >> 4) & MTL_QRDR7_RXQSTS_MASK);\
} while (0)

/*#define MTL_QRDR7_PRXQ_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_QRDR7_PRXQ_MASK (ULONG)(0x3fff)

#define MTL_QRDR7_PRXQ_UDFRD(data) do {\
		MTL_QRDR7_RGRD(data);\
		data = ((data >> 16) & MTL_QRDR7_PRXQ_MASK);\
} while (0)

#define MTL_QRDR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xeb8))

#define MTL_QRDR6_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QRDR6_RGOFFADDR);\
} while (0)

/*#define MTL_QRDR6_RWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QRDR6_RWCSTS_MASK (ULONG)(0x1)

#define MTL_QRDR6_RWCSTS_UDFRD(data) do {\
		MTL_QRDR6_RGRD(data);\
		data = ((data >> 0) & MTL_QRDR6_RWCSTS_MASK);\
} while (0)

/*#define MTL_QRDR6_RRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QRDR6_RRCSTS_MASK (ULONG)(0x3)

#define MTL_QRDR6_RRCSTS_UDFRD(data) do {\
		MTL_QRDR6_RGRD(data);\
		data = ((data >> 1) & MTL_QRDR6_RRCSTS_MASK);\
} while (0)

/*#define MTL_QRDR6_RXQSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QRDR6_RXQSTS_MASK (ULONG)(0x3)

#define MTL_QRDR6_RXQSTS_UDFRD(data) do {\
		MTL_QRDR6_RGRD(data);\
		data = ((data >> 4) & MTL_QRDR6_RXQSTS_MASK);\
} while (0)

/*#define MTL_QRDR6_PRXQ_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_QRDR6_PRXQ_MASK (ULONG)(0x3fff)

#define MTL_QRDR6_PRXQ_UDFRD(data) do {\
		MTL_QRDR6_RGRD(data);\
		data = ((data >> 16) & MTL_QRDR6_PRXQ_MASK);\
} while (0)

#define MTL_QRDR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe78))

#define MTL_QRDR5_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QRDR5_RGOFFADDR);\
} while (0)

/*#define MTL_QRDR5_RWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QRDR5_RWCSTS_MASK (ULONG)(0x1)

#define MTL_QRDR5_RWCSTS_UDFRD(data) do {\
		MTL_QRDR5_RGRD(data);\
		data = ((data >> 0) & MTL_QRDR5_RWCSTS_MASK);\
} while (0)

/*#define MTL_QRDR5_RRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QRDR5_RRCSTS_MASK (ULONG)(0x3)

#define MTL_QRDR5_RRCSTS_UDFRD(data) do {\
		MTL_QRDR5_RGRD(data);\
		data = ((data >> 1) & MTL_QRDR5_RRCSTS_MASK);\
} while (0)

/*#define MTL_QRDR5_RXQSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QRDR5_RXQSTS_MASK (ULONG)(0x3)

#define MTL_QRDR5_RXQSTS_UDFRD(data) do {\
		MTL_QRDR5_RGRD(data);\
		data = ((data >> 4) & MTL_QRDR5_RXQSTS_MASK);\
} while (0)

/*#define MTL_QRDR5_PRXQ_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_QRDR5_PRXQ_MASK (ULONG)(0x3fff)

#define MTL_QRDR5_PRXQ_UDFRD(data) do {\
		MTL_QRDR5_RGRD(data);\
		data = ((data >> 16) & MTL_QRDR5_PRXQ_MASK);\
} while (0)

#define MTL_QRDR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe38))

#define MTL_QRDR4_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QRDR4_RGOFFADDR);\
} while (0)

/*#define MTL_QRDR4_RWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QRDR4_RWCSTS_MASK (ULONG)(0x1)

#define MTL_QRDR4_RWCSTS_UDFRD(data) do {\
		MTL_QRDR4_RGRD(data);\
		data = ((data >> 0) & MTL_QRDR4_RWCSTS_MASK);\
} while (0)

/*#define MTL_QRDR4_RRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QRDR4_RRCSTS_MASK (ULONG)(0x3)

#define MTL_QRDR4_RRCSTS_UDFRD(data) do {\
		MTL_QRDR4_RGRD(data);\
		data = ((data >> 1) & MTL_QRDR4_RRCSTS_MASK);\
} while (0)

/*#define MTL_QRDR4_RXQSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QRDR4_RXQSTS_MASK (ULONG)(0x3)

#define MTL_QRDR4_RXQSTS_UDFRD(data) do {\
		MTL_QRDR4_RGRD(data);\
		data = ((data >> 4) & MTL_QRDR4_RXQSTS_MASK);\
} while (0)

/*#define MTL_QRDR4_PRXQ_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_QRDR4_PRXQ_MASK (ULONG)(0x3fff)

#define MTL_QRDR4_PRXQ_UDFRD(data) do {\
		MTL_QRDR4_RGRD(data);\
		data = ((data >> 16) & MTL_QRDR4_PRXQ_MASK);\
} while (0)

#define MTL_QRDR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xdf8))

#define MTL_QRDR3_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QRDR3_RGOFFADDR);\
} while (0)

/*#define MTL_QRDR3_RWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QRDR3_RWCSTS_MASK (ULONG)(0x1)

#define MTL_QRDR3_RWCSTS_UDFRD(data) do {\
		MTL_QRDR3_RGRD(data);\
		data = ((data >> 0) & MTL_QRDR3_RWCSTS_MASK);\
} while (0)

/*#define MTL_QRDR3_RRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QRDR3_RRCSTS_MASK (ULONG)(0x3)

#define MTL_QRDR3_RRCSTS_UDFRD(data) do {\
		MTL_QRDR3_RGRD(data);\
		data = ((data >> 1) & MTL_QRDR3_RRCSTS_MASK);\
} while (0)

/*#define MTL_QRDR3_RXQSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QRDR3_RXQSTS_MASK (ULONG)(0x3)

#define MTL_QRDR3_RXQSTS_UDFRD(data) do {\
		MTL_QRDR3_RGRD(data);\
		data = ((data >> 4) & MTL_QRDR3_RXQSTS_MASK);\
} while (0)

/*#define MTL_QRDR3_PRXQ_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_QRDR3_PRXQ_MASK (ULONG)(0x3fff)

#define MTL_QRDR3_PRXQ_UDFRD(data) do {\
		MTL_QRDR3_RGRD(data);\
		data = ((data >> 16) & MTL_QRDR3_PRXQ_MASK);\
} while (0)

#define MTL_QRDR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xdb8))

#define MTL_QRDR2_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QRDR2_RGOFFADDR);\
} while (0)

/*#define MTL_QRDR2_RWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QRDR2_RWCSTS_MASK (ULONG)(0x1)

#define MTL_QRDR2_RWCSTS_UDFRD(data) do {\
		MTL_QRDR2_RGRD(data);\
		data = ((data >> 0) & MTL_QRDR2_RWCSTS_MASK);\
} while (0)

/*#define MTL_QRDR2_RRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QRDR2_RRCSTS_MASK (ULONG)(0x3)

#define MTL_QRDR2_RRCSTS_UDFRD(data) do {\
		MTL_QRDR2_RGRD(data);\
		data = ((data >> 1) & MTL_QRDR2_RRCSTS_MASK);\
} while (0)

/*#define MTL_QRDR2_RXQSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QRDR2_RXQSTS_MASK (ULONG)(0x3)

#define MTL_QRDR2_RXQSTS_UDFRD(data) do {\
		MTL_QRDR2_RGRD(data);\
		data = ((data >> 4) & MTL_QRDR2_RXQSTS_MASK);\
} while (0)

/*#define MTL_QRDR2_PRXQ_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_QRDR2_PRXQ_MASK (ULONG)(0x3fff)

#define MTL_QRDR2_PRXQ_UDFRD(data) do {\
		MTL_QRDR2_RGRD(data);\
		data = ((data >> 16) & MTL_QRDR2_PRXQ_MASK);\
} while (0)

#define MTL_QRDR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd78))

#define MTL_QRDR1_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QRDR1_RGOFFADDR);\
} while (0)

/*#define MTL_QRDR1_RWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QRDR1_RWCSTS_MASK (ULONG)(0x1)

#define MTL_QRDR1_RWCSTS_UDFRD(data) do {\
		MTL_QRDR1_RGRD(data);\
		data = ((data >> 0) & MTL_QRDR1_RWCSTS_MASK);\
} while (0)

/*#define MTL_QRDR1_RRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QRDR1_RRCSTS_MASK (ULONG)(0x3)

#define MTL_QRDR1_RRCSTS_UDFRD(data) do {\
		MTL_QRDR1_RGRD(data);\
		data = ((data >> 1) & MTL_QRDR1_RRCSTS_MASK);\
} while (0)

/*#define MTL_QRDR1_RXQSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QRDR1_RXQSTS_MASK (ULONG)(0x3)

#define MTL_QRDR1_RXQSTS_UDFRD(data) do {\
		MTL_QRDR1_RGRD(data);\
		data = ((data >> 4) & MTL_QRDR1_RXQSTS_MASK);\
} while (0)

/*#define MTL_QRDR1_PRXQ_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_QRDR1_PRXQ_MASK (ULONG)(0x3fff)

#define MTL_QRDR1_PRXQ_UDFRD(data) do {\
		MTL_QRDR1_RGRD(data);\
		data = ((data >> 16) & MTL_QRDR1_PRXQ_MASK);\
} while (0)

#define MTL_QOCR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xef4))

#define MTL_QOCR7_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QOCR7_RGOFFADDR);\
} while (0)

#define MTL_QOCR7_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QOCR7_RGOFFADDR);\
} while (0)

/*#define  MTL_QOCR7_Mask_12 (ULONG)(~(~0<<(4)))*/

#define  MTL_QOCR7_MASK_12 (ULONG)(0xf)

/*#define MTL_QOCR7_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(4)))<<(12)))*/

#define MTL_QOCR7_RES_WR_MASK_12 (ULONG)(0xffff0fff)

/*#define  MTL_QOCR7_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  MTL_QOCR7_MASK_28 (ULONG)(0xf)

/*#define MTL_QOCR7_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define MTL_QOCR7_RES_WR_MASK_28 (ULONG)(0xfffffff)

/*#define MTL_QOCR7_OVFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QOCR7_OVFPKTCNT_MASK (ULONG)(0x7ff)

/*#define MTL_QOCR7_OVFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_QOCR7_OVFPKTCNT_WR_MASK (ULONG)(0xfffff800)

#define MTL_QOCR7_OVFPKTCNT_UDFWR(data) do {\
		ULONG v;\
		MTL_QOCR7_RGRD(v);\
		v = (v & (MTL_QOCR7_RES_WR_MASK_12)) | (((0) & (MTL_QOCR7_MASK_12)) << 12);\
		v = (v & (MTL_QOCR7_RES_WR_MASK_28)) | (((0) & (MTL_QOCR7_MASK_28)) << 28);\
		v = ((v & MTL_QOCR7_OVFPKTCNT_WR_MASK) | ((data & MTL_QOCR7_OVFPKTCNT_MASK) << 0));\
		MTL_QOCR7_RGWR(v);\
} while (0)

#define MTL_QOCR7_OVFPKTCNT_UDFRD(data) do {\
		MTL_QOCR7_RGRD(data);\
		data = ((data >> 0) & MTL_QOCR7_OVFPKTCNT_MASK);\
} while (0)

/*#define MTL_QOCR7_OVFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QOCR7_OVFCNTOVF_MASK (ULONG)(0x1)

/*#define MTL_QOCR7_OVFCNTOVF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MTL_QOCR7_OVFCNTOVF_WR_MASK (ULONG)(0xfffff7ff)

#define MTL_QOCR7_OVFCNTOVF_UDFWR(data) do {\
		ULONG v;\
		MTL_QOCR7_RGRD(v);\
		v = (v & (MTL_QOCR7_RES_WR_MASK_12)) | (((0) & (MTL_QOCR7_MASK_12)) << 12);\
		v = (v & (MTL_QOCR7_RES_WR_MASK_28)) | (((0) & (MTL_QOCR7_MASK_28)) << 28);\
		v = ((v & MTL_QOCR7_OVFCNTOVF_WR_MASK) | ((data & MTL_QOCR7_OVFCNTOVF_MASK) << 11));\
		MTL_QOCR7_RGWR(v);\
} while (0)

#define MTL_QOCR7_OVFCNTOVF_UDFRD(data) do {\
		MTL_QOCR7_RGRD(data);\
		data = ((data >> 11) & MTL_QOCR7_OVFCNTOVF_MASK);\
} while (0)

/*#define MTL_QOCR7_MISPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QOCR7_MISPKTCNT_MASK (ULONG)(0x7ff)

/*#define MTL_QOCR7_MISPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (16)))*/

#define MTL_QOCR7_MISPKTCNT_WR_MASK (ULONG)(0xf800ffff)

#define MTL_QOCR7_MISPKTCNT_UDFWR(data) do {\
		ULONG v;\
		MTL_QOCR7_RGRD(v);\
		v = (v & (MTL_QOCR7_RES_WR_MASK_12)) | (((0) & (MTL_QOCR7_MASK_12)) << 12);\
		v = (v & (MTL_QOCR7_RES_WR_MASK_28)) | (((0) & (MTL_QOCR7_MASK_28)) << 28);\
		v = ((v & MTL_QOCR7_MISPKTCNT_WR_MASK) | ((data & MTL_QOCR7_MISPKTCNT_MASK) << 16));\
		MTL_QOCR7_RGWR(v);\
} while (0)

#define MTL_QOCR7_MISPKTCNT_UDFRD(data) do {\
		MTL_QOCR7_RGRD(data);\
		data = ((data >> 16) & MTL_QOCR7_MISPKTCNT_MASK);\
} while (0)

/*#define MTL_QOCR7_MISCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QOCR7_MISCNTOVF_MASK (ULONG)(0x1)

/*#define MTL_QOCR7_MISCNTOVF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define MTL_QOCR7_MISCNTOVF_WR_MASK (ULONG)(0xf7ffffff)

#define MTL_QOCR7_MISCNTOVF_UDFWR(data) do {\
		ULONG v;\
		MTL_QOCR7_RGRD(v);\
		v = (v & (MTL_QOCR7_RES_WR_MASK_12)) | (((0) & (MTL_QOCR7_MASK_12)) << 12);\
		v = (v & (MTL_QOCR7_RES_WR_MASK_28)) | (((0) & (MTL_QOCR7_MASK_28)) << 28);\
		v = ((v & MTL_QOCR7_MISCNTOVF_WR_MASK) | ((data & MTL_QOCR7_MISCNTOVF_MASK) << 27));\
		MTL_QOCR7_RGWR(v);\
} while (0)

#define MTL_QOCR7_MISCNTOVF_UDFRD(data) do {\
		MTL_QOCR7_RGRD(data);\
		data = ((data >> 27) & MTL_QOCR7_MISCNTOVF_MASK);\
} while (0)

#define MTL_QOCR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xeb4))

#define MTL_QOCR6_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QOCR6_RGOFFADDR);\
} while (0)

#define MTL_QOCR6_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QOCR6_RGOFFADDR);\
} while (0)

/*#define  MTL_QOCR6_Mask_12 (ULONG)(~(~0<<(4)))*/

#define  MTL_QOCR6_MASK_12 (ULONG)(0xf)

/*#define MTL_QOCR6_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(4)))<<(12)))*/

#define MTL_QOCR6_RES_WR_MASK_12 (ULONG)(0xffff0fff)

/*#define  MTL_QOCR6_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  MTL_QOCR6_MASK_28 (ULONG)(0xf)

/*#define MTL_QOCR6_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define MTL_QOCR6_RES_WR_MASK_28 (ULONG)(0xfffffff)

/*#define MTL_QOCR6_OVFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QOCR6_OVFPKTCNT_MASK (ULONG)(0x7ff)

/*#define MTL_QOCR6_OVFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_QOCR6_OVFPKTCNT_WR_MASK (ULONG)(0xfffff800)

#define MTL_QOCR6_OVFPKTCNT_UDFWR(data) do {\
		ULONG v;\
		MTL_QOCR6_RGRD(v);\
		v = (v & (MTL_QOCR6_RES_WR_MASK_12)) | (((0) & (MTL_QOCR6_MASK_12)) << 12);\
		v = (v & (MTL_QOCR6_RES_WR_MASK_28)) | (((0) & (MTL_QOCR6_MASK_28)) << 28);\
		v = ((v & MTL_QOCR6_OVFPKTCNT_WR_MASK) | ((data & MTL_QOCR6_OVFPKTCNT_MASK) << 0));\
		MTL_QOCR6_RGWR(v);\
} while (0)

#define MTL_QOCR6_OVFPKTCNT_UDFRD(data) do {\
		MTL_QOCR6_RGRD(data);\
		data = ((data >> 0) & MTL_QOCR6_OVFPKTCNT_MASK);\
} while (0)

/*#define MTL_QOCR6_OVFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QOCR6_OVFCNTOVF_MASK (ULONG)(0x1)

/*#define MTL_QOCR6_OVFCNTOVF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MTL_QOCR6_OVFCNTOVF_WR_MASK (ULONG)(0xfffff7ff)

#define MTL_QOCR6_OVFCNTOVF_UDFWR(data) do {\
		ULONG v;\
		MTL_QOCR6_RGRD(v);\
		v = (v & (MTL_QOCR6_RES_WR_MASK_12)) | (((0) & (MTL_QOCR6_MASK_12)) << 12);\
		v = (v & (MTL_QOCR6_RES_WR_MASK_28)) | (((0) & (MTL_QOCR6_MASK_28)) << 28);\
		v = ((v & MTL_QOCR6_OVFCNTOVF_WR_MASK) | ((data & MTL_QOCR6_OVFCNTOVF_MASK) << 11));\
		MTL_QOCR6_RGWR(v);\
} while (0)

#define MTL_QOCR6_OVFCNTOVF_UDFRD(data) do {\
		MTL_QOCR6_RGRD(data);\
		data = ((data >> 11) & MTL_QOCR6_OVFCNTOVF_MASK);\
} while (0)

/*#define MTL_QOCR6_MISPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QOCR6_MISPKTCNT_MASK (ULONG)(0x7ff)

/*#define MTL_QOCR6_MISPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (16)))*/

#define MTL_QOCR6_MISPKTCNT_WR_MASK (ULONG)(0xf800ffff)

#define MTL_QOCR6_MISPKTCNT_UDFWR(data) do {\
		ULONG v;\
		MTL_QOCR6_RGRD(v);\
		v = (v & (MTL_QOCR6_RES_WR_MASK_12)) | (((0) & (MTL_QOCR6_MASK_12)) << 12);\
		v = (v & (MTL_QOCR6_RES_WR_MASK_28)) | (((0) & (MTL_QOCR6_MASK_28)) << 28);\
		v = ((v & MTL_QOCR6_MISPKTCNT_WR_MASK) | ((data & MTL_QOCR6_MISPKTCNT_MASK) << 16));\
		MTL_QOCR6_RGWR(v);\
} while (0)

#define MTL_QOCR6_MISPKTCNT_UDFRD(data) do {\
		MTL_QOCR6_RGRD(data);\
		data = ((data >> 16) & MTL_QOCR6_MISPKTCNT_MASK);\
} while (0)

/*#define MTL_QOCR6_MISCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QOCR6_MISCNTOVF_MASK (ULONG)(0x1)

/*#define MTL_QOCR6_MISCNTOVF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define MTL_QOCR6_MISCNTOVF_WR_MASK (ULONG)(0xf7ffffff)

#define MTL_QOCR6_MISCNTOVF_UDFWR(data) do {\
		ULONG v;\
		MTL_QOCR6_RGRD(v);\
		v = (v & (MTL_QOCR6_RES_WR_MASK_12)) | (((0) & (MTL_QOCR6_MASK_12)) << 12);\
		v = (v & (MTL_QOCR6_RES_WR_MASK_28)) | (((0) & (MTL_QOCR6_MASK_28)) << 28);\
		v = ((v & MTL_QOCR6_MISCNTOVF_WR_MASK) | ((data & MTL_QOCR6_MISCNTOVF_MASK) << 27));\
		MTL_QOCR6_RGWR(v);\
} while (0)

#define MTL_QOCR6_MISCNTOVF_UDFRD(data) do {\
		MTL_QOCR6_RGRD(data);\
		data = ((data >> 27) & MTL_QOCR6_MISCNTOVF_MASK);\
} while (0)

#define MTL_QOCR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe74))

#define MTL_QOCR5_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QOCR5_RGOFFADDR);\
} while (0)

#define MTL_QOCR5_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QOCR5_RGOFFADDR);\
} while (0)

/*#define  MTL_QOCR5_Mask_12 (ULONG)(~(~0<<(4)))*/

#define  MTL_QOCR5_MASK_12 (ULONG)(0xf)

/*#define MTL_QOCR5_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(4)))<<(12)))*/

#define MTL_QOCR5_RES_WR_MASK_12 (ULONG)(0xffff0fff)

/*#define  MTL_QOCR5_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  MTL_QOCR5_MASK_28 (ULONG)(0xf)

/*#define MTL_QOCR5_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define MTL_QOCR5_RES_WR_MASK_28 (ULONG)(0xfffffff)

/*#define MTL_QOCR5_OVFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QOCR5_OVFPKTCNT_MASK (ULONG)(0x7ff)

/*#define MTL_QOCR5_OVFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_QOCR5_OVFPKTCNT_WR_MASK (ULONG)(0xfffff800)

#define MTL_QOCR5_OVFPKTCNT_UDFWR(data) do {\
		ULONG v;\
		MTL_QOCR5_RGRD(v);\
		v = (v & (MTL_QOCR5_RES_WR_MASK_12)) | (((0) & (MTL_QOCR5_MASK_12)) << 12);\
		v = (v & (MTL_QOCR5_RES_WR_MASK_28)) | (((0) & (MTL_QOCR5_MASK_28)) << 28);\
		v = ((v & MTL_QOCR5_OVFPKTCNT_WR_MASK) | ((data & MTL_QOCR5_OVFPKTCNT_MASK) << 0));\
		MTL_QOCR5_RGWR(v);\
} while (0)

#define MTL_QOCR5_OVFPKTCNT_UDFRD(data) do {\
		MTL_QOCR5_RGRD(data);\
		data = ((data >> 0) & MTL_QOCR5_OVFPKTCNT_MASK);\
} while (0)

/*#define MTL_QOCR5_OVFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QOCR5_OVFCNTOVF_MASK (ULONG)(0x1)

/*#define MTL_QOCR5_OVFCNTOVF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MTL_QOCR5_OVFCNTOVF_WR_MASK (ULONG)(0xfffff7ff)

#define MTL_QOCR5_OVFCNTOVF_UDFWR(data) do {\
		ULONG v;\
		MTL_QOCR5_RGRD(v);\
		v = (v & (MTL_QOCR5_RES_WR_MASK_12)) | (((0) & (MTL_QOCR5_MASK_12)) << 12);\
		v = (v & (MTL_QOCR5_RES_WR_MASK_28)) | (((0) & (MTL_QOCR5_MASK_28)) << 28);\
		v = ((v & MTL_QOCR5_OVFCNTOVF_WR_MASK) | ((data & MTL_QOCR5_OVFCNTOVF_MASK) << 11));\
		MTL_QOCR5_RGWR(v);\
} while (0)

#define MTL_QOCR5_OVFCNTOVF_UDFRD(data) do {\
		MTL_QOCR5_RGRD(data);\
		data = ((data >> 11) & MTL_QOCR5_OVFCNTOVF_MASK);\
} while (0)

/*#define MTL_QOCR5_MISPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QOCR5_MISPKTCNT_MASK (ULONG)(0x7ff)

/*#define MTL_QOCR5_MISPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (16)))*/

#define MTL_QOCR5_MISPKTCNT_WR_MASK (ULONG)(0xf800ffff)

#define MTL_QOCR5_MISPKTCNT_UDFWR(data) do {\
		ULONG v;\
		MTL_QOCR5_RGRD(v);\
		v = (v & (MTL_QOCR5_RES_WR_MASK_12)) | (((0) & (MTL_QOCR5_MASK_12)) << 12);\
		v = (v & (MTL_QOCR5_RES_WR_MASK_28)) | (((0) & (MTL_QOCR5_MASK_28)) << 28);\
		v = ((v & MTL_QOCR5_MISPKTCNT_WR_MASK) | ((data & MTL_QOCR5_MISPKTCNT_MASK) << 16));\
		MTL_QOCR5_RGWR(v);\
} while (0)

#define MTL_QOCR5_MISPKTCNT_UDFRD(data) do {\
		MTL_QOCR5_RGRD(data);\
		data = ((data >> 16) & MTL_QOCR5_MISPKTCNT_MASK);\
} while (0)

/*#define MTL_QOCR5_MISCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QOCR5_MISCNTOVF_MASK (ULONG)(0x1)

/*#define MTL_QOCR5_MISCNTOVF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define MTL_QOCR5_MISCNTOVF_WR_MASK (ULONG)(0xf7ffffff)

#define MTL_QOCR5_MISCNTOVF_UDFWR(data) do {\
		ULONG v;\
		MTL_QOCR5_RGRD(v);\
		v = (v & (MTL_QOCR5_RES_WR_MASK_12)) | (((0) & (MTL_QOCR5_MASK_12)) << 12);\
		v = (v & (MTL_QOCR5_RES_WR_MASK_28)) | (((0) & (MTL_QOCR5_MASK_28)) << 28);\
		v = ((v & MTL_QOCR5_MISCNTOVF_WR_MASK) | ((data & MTL_QOCR5_MISCNTOVF_MASK) << 27));\
		MTL_QOCR5_RGWR(v);\
} while (0)

#define MTL_QOCR5_MISCNTOVF_UDFRD(data) do {\
		MTL_QOCR5_RGRD(data);\
		data = ((data >> 27) & MTL_QOCR5_MISCNTOVF_MASK);\
} while (0)

#define MTL_QOCR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe34))

#define MTL_QOCR4_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QOCR4_RGOFFADDR);\
} while (0)

#define MTL_QOCR4_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QOCR4_RGOFFADDR);\
} while (0)

/*#define  MTL_QOCR4_Mask_12 (ULONG)(~(~0<<(4)))*/

#define  MTL_QOCR4_MASK_12 (ULONG)(0xf)

/*#define MTL_QOCR4_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(4)))<<(12)))*/

#define MTL_QOCR4_RES_WR_MASK_12 (ULONG)(0xffff0fff)

/*#define  MTL_QOCR4_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  MTL_QOCR4_MASK_28 (ULONG)(0xf)

/*#define MTL_QOCR4_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define MTL_QOCR4_RES_WR_MASK_28 (ULONG)(0xfffffff)

/*#define MTL_QOCR4_OVFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QOCR4_OVFPKTCNT_MASK (ULONG)(0x7ff)

/*#define MTL_QOCR4_OVFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_QOCR4_OVFPKTCNT_WR_MASK (ULONG)(0xfffff800)

#define MTL_QOCR4_OVFPKTCNT_UDFWR(data) do {\
		ULONG v;\
		MTL_QOCR4_RGRD(v);\
		v = (v & (MTL_QOCR4_RES_WR_MASK_12)) | (((0) & (MTL_QOCR4_MASK_12)) << 12);\
		v = (v & (MTL_QOCR4_RES_WR_MASK_28)) | (((0) & (MTL_QOCR4_MASK_28)) << 28);\
		v = ((v & MTL_QOCR4_OVFPKTCNT_WR_MASK) | ((data & MTL_QOCR4_OVFPKTCNT_MASK) << 0));\
		MTL_QOCR4_RGWR(v);\
} while (0)

#define MTL_QOCR4_OVFPKTCNT_UDFRD(data) do {\
		MTL_QOCR4_RGRD(data);\
		data = ((data >> 0) & MTL_QOCR4_OVFPKTCNT_MASK);\
} while (0)

/*#define MTL_QOCR4_OVFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QOCR4_OVFCNTOVF_MASK (ULONG)(0x1)

/*#define MTL_QOCR4_OVFCNTOVF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MTL_QOCR4_OVFCNTOVF_WR_MASK (ULONG)(0xfffff7ff)

#define MTL_QOCR4_OVFCNTOVF_UDFWR(data) do {\
		ULONG v;\
		MTL_QOCR4_RGRD(v);\
		v = (v & (MTL_QOCR4_RES_WR_MASK_12)) | (((0) & (MTL_QOCR4_MASK_12)) << 12);\
		v = (v & (MTL_QOCR4_RES_WR_MASK_28)) | (((0) & (MTL_QOCR4_MASK_28)) << 28);\
		v = ((v & MTL_QOCR4_OVFCNTOVF_WR_MASK) | ((data & MTL_QOCR4_OVFCNTOVF_MASK) << 11));\
		MTL_QOCR4_RGWR(v);\
} while (0)

#define MTL_QOCR4_OVFCNTOVF_UDFRD(data) do {\
		MTL_QOCR4_RGRD(data);\
		data = ((data >> 11) & MTL_QOCR4_OVFCNTOVF_MASK);\
} while (0)

/*#define MTL_QOCR4_MISPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QOCR4_MISPKTCNT_MASK (ULONG)(0x7ff)

/*#define MTL_QOCR4_MISPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (16)))*/

#define MTL_QOCR4_MISPKTCNT_WR_MASK (ULONG)(0xf800ffff)

#define MTL_QOCR4_MISPKTCNT_UDFWR(data) do {\
		ULONG v;\
		MTL_QOCR4_RGRD(v);\
		v = (v & (MTL_QOCR4_RES_WR_MASK_12)) | (((0) & (MTL_QOCR4_MASK_12)) << 12);\
		v = (v & (MTL_QOCR4_RES_WR_MASK_28)) | (((0) & (MTL_QOCR4_MASK_28)) << 28);\
		v = ((v & MTL_QOCR4_MISPKTCNT_WR_MASK) | ((data & MTL_QOCR4_MISPKTCNT_MASK) << 16));\
		MTL_QOCR4_RGWR(v);\
} while (0)

#define MTL_QOCR4_MISPKTCNT_UDFRD(data) do {\
		MTL_QOCR4_RGRD(data);\
		data = ((data >> 16) & MTL_QOCR4_MISPKTCNT_MASK);\
} while (0)

/*#define MTL_QOCR4_MISCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QOCR4_MISCNTOVF_MASK (ULONG)(0x1)

/*#define MTL_QOCR4_MISCNTOVF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define MTL_QOCR4_MISCNTOVF_WR_MASK (ULONG)(0xf7ffffff)

#define MTL_QOCR4_MISCNTOVF_UDFWR(data) do {\
		ULONG v;\
		MTL_QOCR4_RGRD(v);\
		v = (v & (MTL_QOCR4_RES_WR_MASK_12)) | (((0) & (MTL_QOCR4_MASK_12)) << 12);\
		v = (v & (MTL_QOCR4_RES_WR_MASK_28)) | (((0) & (MTL_QOCR4_MASK_28)) << 28);\
		v = ((v & MTL_QOCR4_MISCNTOVF_WR_MASK) | ((data & MTL_QOCR4_MISCNTOVF_MASK) << 27));\
		MTL_QOCR4_RGWR(v);\
} while (0)

#define MTL_QOCR4_MISCNTOVF_UDFRD(data) do {\
		MTL_QOCR4_RGRD(data);\
		data = ((data >> 27) & MTL_QOCR4_MISCNTOVF_MASK);\
} while (0)

#define MTL_QOCR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xdf4))

#define MTL_QOCR3_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QOCR3_RGOFFADDR);\
} while (0)

#define MTL_QOCR3_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QOCR3_RGOFFADDR);\
} while (0)

/*#define  MTL_QOCR3_Mask_12 (ULONG)(~(~0<<(4)))*/

#define  MTL_QOCR3_MASK_12 (ULONG)(0xf)

/*#define MTL_QOCR3_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(4)))<<(12)))*/

#define MTL_QOCR3_RES_WR_MASK_12 (ULONG)(0xffff0fff)

/*#define  MTL_QOCR3_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  MTL_QOCR3_MASK_28 (ULONG)(0xf)

/*#define MTL_QOCR3_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define MTL_QOCR3_RES_WR_MASK_28 (ULONG)(0xfffffff)

/*#define MTL_QOCR3_OVFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QOCR3_OVFPKTCNT_MASK (ULONG)(0x7ff)

/*#define MTL_QOCR3_OVFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_QOCR3_OVFPKTCNT_WR_MASK (ULONG)(0xfffff800)

#define MTL_QOCR3_OVFPKTCNT_UDFWR(data) do {\
		ULONG v;\
		MTL_QOCR3_RGRD(v);\
		v = (v & (MTL_QOCR3_RES_WR_MASK_12)) | (((0) & (MTL_QOCR3_MASK_12)) << 12);\
		v = (v & (MTL_QOCR3_RES_WR_MASK_28)) | (((0) & (MTL_QOCR3_MASK_28)) << 28);\
		v = ((v & MTL_QOCR3_OVFPKTCNT_WR_MASK) | ((data & MTL_QOCR3_OVFPKTCNT_MASK) << 0));\
		MTL_QOCR3_RGWR(v);\
} while (0)

#define MTL_QOCR3_OVFPKTCNT_UDFRD(data) do {\
		MTL_QOCR3_RGRD(data);\
		data = ((data >> 0) & MTL_QOCR3_OVFPKTCNT_MASK);\
} while (0)

/*#define MTL_QOCR3_OVFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QOCR3_OVFCNTOVF_MASK (ULONG)(0x1)

/*#define MTL_QOCR3_OVFCNTOVF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MTL_QOCR3_OVFCNTOVF_WR_MASK (ULONG)(0xfffff7ff)

#define MTL_QOCR3_OVFCNTOVF_UDFWR(data) do {\
		ULONG v;\
		MTL_QOCR3_RGRD(v);\
		v = (v & (MTL_QOCR3_RES_WR_MASK_12)) | (((0) & (MTL_QOCR3_MASK_12)) << 12);\
		v = (v & (MTL_QOCR3_RES_WR_MASK_28)) | (((0) & (MTL_QOCR3_MASK_28)) << 28);\
		v = ((v & MTL_QOCR3_OVFCNTOVF_WR_MASK) | ((data & MTL_QOCR3_OVFCNTOVF_MASK) << 11));\
		MTL_QOCR3_RGWR(v);\
} while (0)

#define MTL_QOCR3_OVFCNTOVF_UDFRD(data) do {\
		MTL_QOCR3_RGRD(data);\
		data = ((data >> 11) & MTL_QOCR3_OVFCNTOVF_MASK);\
} while (0)

/*#define MTL_QOCR3_MISPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QOCR3_MISPKTCNT_MASK (ULONG)(0x7ff)

/*#define MTL_QOCR3_MISPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (16)))*/

#define MTL_QOCR3_MISPKTCNT_WR_MASK (ULONG)(0xf800ffff)

#define MTL_QOCR3_MISPKTCNT_UDFWR(data) do {\
		ULONG v;\
		MTL_QOCR3_RGRD(v);\
		v = (v & (MTL_QOCR3_RES_WR_MASK_12)) | (((0) & (MTL_QOCR3_MASK_12)) << 12);\
		v = (v & (MTL_QOCR3_RES_WR_MASK_28)) | (((0) & (MTL_QOCR3_MASK_28)) << 28);\
		v = ((v & MTL_QOCR3_MISPKTCNT_WR_MASK) | ((data & MTL_QOCR3_MISPKTCNT_MASK) << 16));\
		MTL_QOCR3_RGWR(v);\
} while (0)

#define MTL_QOCR3_MISPKTCNT_UDFRD(data) do {\
		MTL_QOCR3_RGRD(data);\
		data = ((data >> 16) & MTL_QOCR3_MISPKTCNT_MASK);\
} while (0)

/*#define MTL_QOCR3_MISCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QOCR3_MISCNTOVF_MASK (ULONG)(0x1)

/*#define MTL_QOCR3_MISCNTOVF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define MTL_QOCR3_MISCNTOVF_WR_MASK (ULONG)(0xf7ffffff)

#define MTL_QOCR3_MISCNTOVF_UDFWR(data) do {\
		ULONG v;\
		MTL_QOCR3_RGRD(v);\
		v = (v & (MTL_QOCR3_RES_WR_MASK_12)) | (((0) & (MTL_QOCR3_MASK_12)) << 12);\
		v = (v & (MTL_QOCR3_RES_WR_MASK_28)) | (((0) & (MTL_QOCR3_MASK_28)) << 28);\
		v = ((v & MTL_QOCR3_MISCNTOVF_WR_MASK) | ((data & MTL_QOCR3_MISCNTOVF_MASK) << 27));\
		MTL_QOCR3_RGWR(v);\
} while (0)

#define MTL_QOCR3_MISCNTOVF_UDFRD(data) do {\
		MTL_QOCR3_RGRD(data);\
		data = ((data >> 27) & MTL_QOCR3_MISCNTOVF_MASK);\
} while (0)

#define MTL_QOCR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xdb4))

#define MTL_QOCR2_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QOCR2_RGOFFADDR);\
} while (0)

#define MTL_QOCR2_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QOCR2_RGOFFADDR);\
} while (0)

/*#define  MTL_QOCR2_Mask_12 (ULONG)(~(~0<<(4)))*/

#define  MTL_QOCR2_MASK_12 (ULONG)(0xf)

/*#define MTL_QOCR2_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(4)))<<(12)))*/

#define MTL_QOCR2_RES_WR_MASK_12 (ULONG)(0xffff0fff)

/*#define  MTL_QOCR2_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  MTL_QOCR2_MASK_28 (ULONG)(0xf)

/*#define MTL_QOCR2_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define MTL_QOCR2_RES_WR_MASK_28 (ULONG)(0xfffffff)

/*#define MTL_QOCR2_OVFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QOCR2_OVFPKTCNT_MASK (ULONG)(0x7ff)

/*#define MTL_QOCR2_OVFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_QOCR2_OVFPKTCNT_WR_MASK (ULONG)(0xfffff800)

#define MTL_QOCR2_OVFPKTCNT_UDFWR(data) do {\
		ULONG v;\
		MTL_QOCR2_RGRD(v);\
		v = (v & (MTL_QOCR2_RES_WR_MASK_12)) | (((0) & (MTL_QOCR2_MASK_12)) << 12);\
		v = (v & (MTL_QOCR2_RES_WR_MASK_28)) | (((0) & (MTL_QOCR2_MASK_28)) << 28);\
		v = ((v & MTL_QOCR2_OVFPKTCNT_WR_MASK) | ((data & MTL_QOCR2_OVFPKTCNT_MASK) << 0));\
		MTL_QOCR2_RGWR(v);\
} while (0)

#define MTL_QOCR2_OVFPKTCNT_UDFRD(data) do {\
		MTL_QOCR2_RGRD(data);\
		data = ((data >> 0) & MTL_QOCR2_OVFPKTCNT_MASK);\
} while (0)

/*#define MTL_QOCR2_OVFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QOCR2_OVFCNTOVF_MASK (ULONG)(0x1)

/*#define MTL_QOCR2_OVFCNTOVF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MTL_QOCR2_OVFCNTOVF_WR_MASK (ULONG)(0xfffff7ff)

#define MTL_QOCR2_OVFCNTOVF_UDFWR(data) do {\
		ULONG v;\
		MTL_QOCR2_RGRD(v);\
		v = (v & (MTL_QOCR2_RES_WR_MASK_12)) | (((0) & (MTL_QOCR2_MASK_12)) << 12);\
		v = (v & (MTL_QOCR2_RES_WR_MASK_28)) | (((0) & (MTL_QOCR2_MASK_28)) << 28);\
		v = ((v & MTL_QOCR2_OVFCNTOVF_WR_MASK) | ((data & MTL_QOCR2_OVFCNTOVF_MASK) << 11));\
		MTL_QOCR2_RGWR(v);\
} while (0)

#define MTL_QOCR2_OVFCNTOVF_UDFRD(data) do {\
		MTL_QOCR2_RGRD(data);\
		data = ((data >> 11) & MTL_QOCR2_OVFCNTOVF_MASK);\
} while (0)

/*#define MTL_QOCR2_MISPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QOCR2_MISPKTCNT_MASK (ULONG)(0x7ff)

/*#define MTL_QOCR2_MISPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (16)))*/

#define MTL_QOCR2_MISPKTCNT_WR_MASK (ULONG)(0xf800ffff)

#define MTL_QOCR2_MISPKTCNT_UDFWR(data) do {\
		ULONG v;\
		MTL_QOCR2_RGRD(v);\
		v = (v & (MTL_QOCR2_RES_WR_MASK_12)) | (((0) & (MTL_QOCR2_MASK_12)) << 12);\
		v = (v & (MTL_QOCR2_RES_WR_MASK_28)) | (((0) & (MTL_QOCR2_MASK_28)) << 28);\
		v = ((v & MTL_QOCR2_MISPKTCNT_WR_MASK) | ((data & MTL_QOCR2_MISPKTCNT_MASK) << 16));\
		MTL_QOCR2_RGWR(v);\
} while (0)

#define MTL_QOCR2_MISPKTCNT_UDFRD(data) do {\
		MTL_QOCR2_RGRD(data);\
		data = ((data >> 16) & MTL_QOCR2_MISPKTCNT_MASK);\
} while (0)

/*#define MTL_QOCR2_MISCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QOCR2_MISCNTOVF_MASK (ULONG)(0x1)

/*#define MTL_QOCR2_MISCNTOVF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define MTL_QOCR2_MISCNTOVF_WR_MASK (ULONG)(0xf7ffffff)

#define MTL_QOCR2_MISCNTOVF_UDFWR(data) do {\
		ULONG v;\
		MTL_QOCR2_RGRD(v);\
		v = (v & (MTL_QOCR2_RES_WR_MASK_12)) | (((0) & (MTL_QOCR2_MASK_12)) << 12);\
		v = (v & (MTL_QOCR2_RES_WR_MASK_28)) | (((0) & (MTL_QOCR2_MASK_28)) << 28);\
		v = ((v & MTL_QOCR2_MISCNTOVF_WR_MASK) | ((data & MTL_QOCR2_MISCNTOVF_MASK) << 27));\
		MTL_QOCR2_RGWR(v);\
} while (0)

#define MTL_QOCR2_MISCNTOVF_UDFRD(data) do {\
		MTL_QOCR2_RGRD(data);\
		data = ((data >> 27) & MTL_QOCR2_MISCNTOVF_MASK);\
} while (0)

#define MTL_QOCR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd74))

#define MTL_QOCR1_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QOCR1_RGOFFADDR);\
} while (0)

#define MTL_QOCR1_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QOCR1_RGOFFADDR);\
} while (0)

/*#define  MTL_QOCR1_Mask_12 (ULONG)(~(~0<<(4)))*/

#define  MTL_QOCR1_MASK_12 (ULONG)(0xf)

/*#define MTL_QOCR1_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(4)))<<(12)))*/

#define MTL_QOCR1_RES_WR_MASK_12 (ULONG)(0xffff0fff)

/*#define  MTL_QOCR1_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  MTL_QOCR1_MASK_28 (ULONG)(0xf)

/*#define MTL_QOCR1_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define MTL_QOCR1_RES_WR_MASK_28 (ULONG)(0xfffffff)

/*#define MTL_QOCR1_OVFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QOCR1_OVFPKTCNT_MASK (ULONG)(0x7ff)

/*#define MTL_QOCR1_OVFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_QOCR1_OVFPKTCNT_WR_MASK (ULONG)(0xfffff800)

#define MTL_QOCR1_OVFPKTCNT_UDFWR(data) do {\
		ULONG v;\
		MTL_QOCR1_RGRD(v);\
		v = (v & (MTL_QOCR1_RES_WR_MASK_12)) | (((0) & (MTL_QOCR1_MASK_12)) << 12);\
		v = (v & (MTL_QOCR1_RES_WR_MASK_28)) | (((0) & (MTL_QOCR1_MASK_28)) << 28);\
		v = ((v & MTL_QOCR1_OVFPKTCNT_WR_MASK) | ((data & MTL_QOCR1_OVFPKTCNT_MASK) << 0));\
		MTL_QOCR1_RGWR(v);\
} while (0)

#define MTL_QOCR1_OVFPKTCNT_UDFRD(data) do {\
		MTL_QOCR1_RGRD(data);\
		data = ((data >> 0) & MTL_QOCR1_OVFPKTCNT_MASK);\
} while (0)

/*#define MTL_QOCR1_OVFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QOCR1_OVFCNTOVF_MASK (ULONG)(0x1)

/*#define MTL_QOCR1_OVFCNTOVF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MTL_QOCR1_OVFCNTOVF_WR_MASK (ULONG)(0xfffff7ff)

#define MTL_QOCR1_OVFCNTOVF_UDFWR(data) do {\
		ULONG v;\
		MTL_QOCR1_RGRD(v);\
		v = (v & (MTL_QOCR1_RES_WR_MASK_12)) | (((0) & (MTL_QOCR1_MASK_12)) << 12);\
		v = (v & (MTL_QOCR1_RES_WR_MASK_28)) | (((0) & (MTL_QOCR1_MASK_28)) << 28);\
		v = ((v & MTL_QOCR1_OVFCNTOVF_WR_MASK) | ((data & MTL_QOCR1_OVFCNTOVF_MASK) << 11));\
		MTL_QOCR1_RGWR(v);\
} while (0)

#define MTL_QOCR1_OVFCNTOVF_UDFRD(data) do {\
		MTL_QOCR1_RGRD(data);\
		data = ((data >> 11) & MTL_QOCR1_OVFCNTOVF_MASK);\
} while (0)

/*#define MTL_QOCR1_MISPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QOCR1_MISPKTCNT_MASK (ULONG)(0x7ff)

/*#define MTL_QOCR1_MISPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (16)))*/

#define MTL_QOCR1_MISPKTCNT_WR_MASK (ULONG)(0xf800ffff)

#define MTL_QOCR1_MISPKTCNT_UDFWR(data) do {\
		ULONG v;\
		MTL_QOCR1_RGRD(v);\
		v = (v & (MTL_QOCR1_RES_WR_MASK_12)) | (((0) & (MTL_QOCR1_MASK_12)) << 12);\
		v = (v & (MTL_QOCR1_RES_WR_MASK_28)) | (((0) & (MTL_QOCR1_MASK_28)) << 28);\
		v = ((v & MTL_QOCR1_MISPKTCNT_WR_MASK) | ((data & MTL_QOCR1_MISPKTCNT_MASK) << 16));\
		MTL_QOCR1_RGWR(v);\
} while (0)

#define MTL_QOCR1_MISPKTCNT_UDFRD(data) do {\
		MTL_QOCR1_RGRD(data);\
		data = ((data >> 16) & MTL_QOCR1_MISPKTCNT_MASK);\
} while (0)

/*#define MTL_QOCR1_MISCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QOCR1_MISCNTOVF_MASK (ULONG)(0x1)

/*#define MTL_QOCR1_MISCNTOVF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define MTL_QOCR1_MISCNTOVF_WR_MASK (ULONG)(0xf7ffffff)

#define MTL_QOCR1_MISCNTOVF_UDFWR(data) do {\
		ULONG v;\
		MTL_QOCR1_RGRD(v);\
		v = (v & (MTL_QOCR1_RES_WR_MASK_12)) | (((0) & (MTL_QOCR1_MASK_12)) << 12);\
		v = (v & (MTL_QOCR1_RES_WR_MASK_28)) | (((0) & (MTL_QOCR1_MASK_28)) << 28);\
		v = ((v & MTL_QOCR1_MISCNTOVF_WR_MASK) | ((data & MTL_QOCR1_MISCNTOVF_MASK) << 27));\
		MTL_QOCR1_RGWR(v);\
} while (0)

#define MTL_QOCR1_MISCNTOVF_UDFRD(data) do {\
		MTL_QOCR1_RGRD(data);\
		data = ((data >> 27) & MTL_QOCR1_MISCNTOVF_MASK);\
} while (0)

#define MTL_QLCR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xee4))

#define MTL_QLCR7_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QLCR7_RGOFFADDR);\
} while (0)

#define MTL_QLCR7_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QLCR7_RGOFFADDR);\
} while (0)

/*#define  MTL_QLCR7_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_QLCR7_MASK_29 (ULONG)(0x7)

/*#define MTL_QLCR7_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_QLCR7_RES_WR_MASK_29 (ULONG)(0x1fffffff)

/*#define MTL_QLCR7_LC_Mask (ULONG)(~(~0<<(29)))*/

#define MTL_QLCR7_LC_MASK (ULONG)(0x1fffffff)

/*#define MTL_QLCR7_LC_Wr_Mask (ULONG)(~((~(~0 << (29))) << (0)))*/

#define MTL_QLCR7_LC_WR_MASK (ULONG)(0xe0000000)

#define MTL_QLCR7_LC_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QLCR7_RES_WR_MASK_29)) | (((0) & (MTL_QLCR7_MASK_29)) << 29);\
		(v) = ((v & MTL_QLCR7_LC_WR_MASK) | ((data & MTL_QLCR7_LC_MASK) << 0));\
		MTL_QLCR7_RGWR(v);\
} while (0)

#define MTL_QLCR7_LC_UDFRD(data) do {\
		MTL_QLCR7_RGRD(data);\
		data = ((data >> 0) & MTL_QLCR7_LC_MASK);\
} while (0)

#define MTL_QLCR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xea4))

#define MTL_QLCR6_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QLCR6_RGOFFADDR);\
} while (0)

#define MTL_QLCR6_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QLCR6_RGOFFADDR);\
} while (0)

/*#define  MTL_QLCR6_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_QLCR6_MASK_29 (ULONG)(0x7)

/*#define MTL_QLCR6_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_QLCR6_RES_WR_MASK_29 (ULONG)(0x1fffffff)

/*#define MTL_QLCR6_LC_Mask (ULONG)(~(~0<<(29)))*/

#define MTL_QLCR6_LC_MASK (ULONG)(0x1fffffff)

/*#define MTL_QLCR6_LC_Wr_Mask (ULONG)(~((~(~0 << (29))) << (0)))*/

#define MTL_QLCR6_LC_WR_MASK (ULONG)(0xe0000000)

#define MTL_QLCR6_LC_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QLCR6_RES_WR_MASK_29)) | (((0) & (MTL_QLCR6_MASK_29)) << 29);\
		(v) = ((v & MTL_QLCR6_LC_WR_MASK) | ((data & MTL_QLCR6_LC_MASK) << 0));\
		MTL_QLCR6_RGWR(v);\
} while (0)

#define MTL_QLCR6_LC_UDFRD(data) do {\
		MTL_QLCR6_RGRD(data);\
		data = ((data >> 0) & MTL_QLCR6_LC_MASK);\
} while (0)

#define MTL_QLCR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe64))

#define MTL_QLCR5_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QLCR5_RGOFFADDR);\
} while (0)

#define MTL_QLCR5_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QLCR5_RGOFFADDR);\
} while (0)

/*#define  MTL_QLCR5_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_QLCR5_MASK_29 (ULONG)(0x7)

/*#define MTL_QLCR5_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_QLCR5_RES_WR_MASK_29 (ULONG)(0x1fffffff)

/*#define MTL_QLCR5_LC_Mask (ULONG)(~(~0<<(29)))*/

#define MTL_QLCR5_LC_MASK (ULONG)(0x1fffffff)

/*#define MTL_QLCR5_LC_Wr_Mask (ULONG)(~((~(~0 << (29))) << (0)))*/

#define MTL_QLCR5_LC_WR_MASK (ULONG)(0xe0000000)

#define MTL_QLCR5_LC_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QLCR5_RES_WR_MASK_29)) | (((0) & (MTL_QLCR5_MASK_29)) << 29);\
		(v) = ((v & MTL_QLCR5_LC_WR_MASK) | ((data & MTL_QLCR5_LC_MASK) << 0));\
		MTL_QLCR5_RGWR(v);\
} while (0)

#define MTL_QLCR5_LC_UDFRD(data) do {\
		MTL_QLCR5_RGRD(data);\
		data = ((data >> 0) & MTL_QLCR5_LC_MASK);\
} while (0)

#define MTL_QLCR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe24))

#define MTL_QLCR4_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QLCR4_RGOFFADDR);\
} while (0)

#define MTL_QLCR4_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QLCR4_RGOFFADDR);\
} while (0)

/*#define  MTL_QLCR4_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_QLCR4_MASK_29 (ULONG)(0x7)

/*#define MTL_QLCR4_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_QLCR4_RES_WR_MASK_29 (ULONG)(0x1fffffff)

/*#define MTL_QLCR4_LC_Mask (ULONG)(~(~0<<(29)))*/

#define MTL_QLCR4_LC_MASK (ULONG)(0x1fffffff)

/*#define MTL_QLCR4_LC_Wr_Mask (ULONG)(~((~(~0 << (29))) << (0)))*/

#define MTL_QLCR4_LC_WR_MASK (ULONG)(0xe0000000)

#define MTL_QLCR4_LC_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QLCR4_RES_WR_MASK_29)) | (((0) & (MTL_QLCR4_MASK_29)) << 29);\
		(v) = ((v & MTL_QLCR4_LC_WR_MASK) | ((data & MTL_QLCR4_LC_MASK) << 0));\
		MTL_QLCR4_RGWR(v);\
} while (0)

#define MTL_QLCR4_LC_UDFRD(data) do {\
		MTL_QLCR4_RGRD(data);\
		data = ((data >> 0) & MTL_QLCR4_LC_MASK);\
} while (0)

#define MTL_QLCR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xde4))

#define MTL_QLCR3_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QLCR3_RGOFFADDR);\
} while (0)

#define MTL_QLCR3_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QLCR3_RGOFFADDR);\
} while (0)

/*#define  MTL_QLCR3_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_QLCR3_MASK_29 (ULONG)(0x7)

/*#define MTL_QLCR3_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_QLCR3_RES_WR_MASK_29 (ULONG)(0x1fffffff)

/*#define MTL_QLCR3_LC_Mask (ULONG)(~(~0<<(29)))*/

#define MTL_QLCR3_LC_MASK (ULONG)(0x1fffffff)

/*#define MTL_QLCR3_LC_Wr_Mask (ULONG)(~((~(~0 << (29))) << (0)))*/

#define MTL_QLCR3_LC_WR_MASK (ULONG)(0xe0000000)

#define MTL_QLCR3_LC_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QLCR3_RES_WR_MASK_29)) | (((0) & (MTL_QLCR3_MASK_29)) << 29);\
		(v) = ((v & MTL_QLCR3_LC_WR_MASK) | ((data & MTL_QLCR3_LC_MASK) << 0));\
		MTL_QLCR3_RGWR(v);\
} while (0)

#define MTL_QLCR3_LC_UDFRD(data) do {\
		MTL_QLCR3_RGRD(data);\
		data = ((data >> 0) & MTL_QLCR3_LC_MASK);\
} while (0)

#define MTL_QLCR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xda4))

#define MTL_QLCR2_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QLCR2_RGOFFADDR);\
} while (0)

#define MTL_QLCR2_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QLCR2_RGOFFADDR);\
} while (0)

/*#define  MTL_QLCR2_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_QLCR2_MASK_29 (ULONG)(0x7)

/*#define MTL_QLCR2_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_QLCR2_RES_WR_MASK_29 (ULONG)(0x1fffffff)

/*#define MTL_QLCR2_LC_Mask (ULONG)(~(~0<<(29)))*/

#define MTL_QLCR2_LC_MASK (ULONG)(0x1fffffff)

/*#define MTL_QLCR2_LC_Wr_Mask (ULONG)(~((~(~0 << (29))) << (0)))*/

#define MTL_QLCR2_LC_WR_MASK (ULONG)(0xe0000000)

#define MTL_QLCR2_LC_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QLCR2_RES_WR_MASK_29)) | (((0) & (MTL_QLCR2_MASK_29)) << 29);\
		(v) = ((v & MTL_QLCR2_LC_WR_MASK) | ((data & MTL_QLCR2_LC_MASK) << 0));\
		MTL_QLCR2_RGWR(v);\
} while (0)

#define MTL_QLCR2_LC_UDFRD(data) do {\
		MTL_QLCR2_RGRD(data);\
		data = ((data >> 0) & MTL_QLCR2_LC_MASK);\
} while (0)

#define MTL_QLCR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd64))

#define MTL_QLCR1_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QLCR1_RGOFFADDR);\
} while (0)

#define MTL_QLCR1_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QLCR1_RGOFFADDR);\
} while (0)

/*#define  MTL_QLCR1_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_QLCR1_MASK_29 (ULONG)(0x7)

/*#define MTL_QLCR1_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_QLCR1_RES_WR_MASK_29 (ULONG)(0x1fffffff)

/*#define MTL_QLCR1_LC_Mask (ULONG)(~(~0<<(29)))*/

#define MTL_QLCR1_LC_MASK (ULONG)(0x1fffffff)

/*#define MTL_QLCR1_LC_Wr_Mask (ULONG)(~((~(~0 << (29))) << (0)))*/

#define MTL_QLCR1_LC_WR_MASK (ULONG)(0xe0000000)

#define MTL_QLCR1_LC_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QLCR1_RES_WR_MASK_29)) | (((0) & (MTL_QLCR1_MASK_29)) << 29);\
		(v) = ((v & MTL_QLCR1_LC_WR_MASK) | ((data & MTL_QLCR1_LC_MASK) << 0));\
		MTL_QLCR1_RGWR(v);\
} while (0)

#define MTL_QLCR1_LC_UDFRD(data) do {\
		MTL_QLCR1_RGRD(data);\
		data = ((data >> 0) & MTL_QLCR1_LC_MASK);\
} while (0)

#define MTL_QHCR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xee0))

#define MTL_QHCR7_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QHCR7_RGOFFADDR);\
} while (0)

#define MTL_QHCR7_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QHCR7_RGOFFADDR);\
} while (0)

/*#define  MTL_QHCR7_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_QHCR7_MASK_29 (ULONG)(0x7)

/*#define MTL_QHCR7_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_QHCR7_RES_WR_MASK_29 (ULONG)(0x1fffffff)

/*#define MTL_QHCR7_HC_Mask (ULONG)(~(~0<<(29)))*/

#define MTL_QHCR7_HC_MASK (ULONG)(0x1fffffff)

/*#define MTL_QHCR7_HC_Wr_Mask (ULONG)(~((~(~0 << (29))) << (0)))*/

#define MTL_QHCR7_HC_WR_MASK (ULONG)(0xe0000000)

#define MTL_QHCR7_HC_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QHCR7_RES_WR_MASK_29)) | (((0) & (MTL_QHCR7_MASK_29)) << 29);\
		(v) = ((v & MTL_QHCR7_HC_WR_MASK) | ((data & MTL_QHCR7_HC_MASK) << 0));\
		MTL_QHCR7_RGWR(v);\
} while (0)

#define MTL_QHCR7_HC_UDFRD(data) do {\
		MTL_QHCR7_RGRD(data);\
		data = ((data >> 0) & MTL_QHCR7_HC_MASK);\
} while (0)

#define MTL_QHCR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xea0))

#define MTL_QHCR6_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QHCR6_RGOFFADDR);\
} while (0)

#define MTL_QHCR6_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QHCR6_RGOFFADDR);\
} while (0)

/*#define  MTL_QHCR6_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_QHCR6_MASK_29 (ULONG)(0x7)

/*#define MTL_QHCR6_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_QHCR6_RES_WR_MASK_29 (ULONG)(0x1fffffff)

/*#define MTL_QHCR6_HC_Mask (ULONG)(~(~0<<(29)))*/

#define MTL_QHCR6_HC_MASK (ULONG)(0x1fffffff)

/*#define MTL_QHCR6_HC_Wr_Mask (ULONG)(~((~(~0 << (29))) << (0)))*/

#define MTL_QHCR6_HC_WR_MASK (ULONG)(0xe0000000)

#define MTL_QHCR6_HC_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QHCR6_RES_WR_MASK_29)) | (((0) & (MTL_QHCR6_MASK_29)) << 29);\
		(v) = ((v & MTL_QHCR6_HC_WR_MASK) | ((data & MTL_QHCR6_HC_MASK) << 0));\
		MTL_QHCR6_RGWR(v);\
} while (0)

#define MTL_QHCR6_HC_UDFRD(data) do {\
		MTL_QHCR6_RGRD(data);\
		data = ((data >> 0) & MTL_QHCR6_HC_MASK);\
} while (0)

#define MTL_QHCR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe60))

#define MTL_QHCR5_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QHCR5_RGOFFADDR);\
} while (0)

#define MTL_QHCR5_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QHCR5_RGOFFADDR);\
} while (0)

/*#define  MTL_QHCR5_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_QHCR5_MASK_29 (ULONG)(0x7)

/*#define MTL_QHCR5_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_QHCR5_RES_WR_MASK_29 (ULONG)(0x1fffffff)

/*#define MTL_QHCR5_HC_Mask (ULONG)(~(~0<<(29)))*/

#define MTL_QHCR5_HC_MASK (ULONG)(0x1fffffff)

/*#define MTL_QHCR5_HC_Wr_Mask (ULONG)(~((~(~0 << (29))) << (0)))*/

#define MTL_QHCR5_HC_WR_MASK (ULONG)(0xe0000000)

#define MTL_QHCR5_HC_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QHCR5_RES_WR_MASK_29)) | (((0) & (MTL_QHCR5_MASK_29)) << 29);\
		(v) = ((v & MTL_QHCR5_HC_WR_MASK) | ((data & MTL_QHCR5_HC_MASK) << 0));\
		MTL_QHCR5_RGWR(v);\
} while (0)

#define MTL_QHCR5_HC_UDFRD(data) do {\
		MTL_QHCR5_RGRD(data);\
		data = ((data >> 0) & MTL_QHCR5_HC_MASK);\
} while (0)

#define MTL_QHCR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe20))

#define MTL_QHCR4_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QHCR4_RGOFFADDR);\
} while (0)

#define MTL_QHCR4_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QHCR4_RGOFFADDR);\
} while (0)

/*#define  MTL_QHCR4_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_QHCR4_MASK_29 (ULONG)(0x7)

/*#define MTL_QHCR4_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_QHCR4_RES_WR_MASK_29 (ULONG)(0x1fffffff)

/*#define MTL_QHCR4_HC_Mask (ULONG)(~(~0<<(29)))*/

#define MTL_QHCR4_HC_MASK (ULONG)(0x1fffffff)

/*#define MTL_QHCR4_HC_Wr_Mask (ULONG)(~((~(~0 << (29))) << (0)))*/

#define MTL_QHCR4_HC_WR_MASK (ULONG)(0xe0000000)

#define MTL_QHCR4_HC_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QHCR4_RES_WR_MASK_29)) | (((0) & (MTL_QHCR4_MASK_29)) << 29);\
		(v) = ((v & MTL_QHCR4_HC_WR_MASK) | ((data & MTL_QHCR4_HC_MASK) << 0));\
		MTL_QHCR4_RGWR(v);\
} while (0)

#define MTL_QHCR4_HC_UDFRD(data) do {\
		MTL_QHCR4_RGRD(data);\
		data = ((data >> 0) & MTL_QHCR4_HC_MASK);\
} while (0)

#define MTL_QHCR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xde0))

#define MTL_QHCR3_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QHCR3_RGOFFADDR);\
} while (0)

#define MTL_QHCR3_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QHCR3_RGOFFADDR);\
} while (0)

/*#define  MTL_QHCR3_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_QHCR3_MASK_29 (ULONG)(0x7)

/*#define MTL_QHCR3_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_QHCR3_RES_WR_MASK_29 (ULONG)(0x1fffffff)

/*#define MTL_QHCR3_HC_Mask (ULONG)(~(~0<<(29)))*/

#define MTL_QHCR3_HC_MASK (ULONG)(0x1fffffff)

/*#define MTL_QHCR3_HC_Wr_Mask (ULONG)(~((~(~0 << (29))) << (0)))*/

#define MTL_QHCR3_HC_WR_MASK (ULONG)(0xe0000000)

#define MTL_QHCR3_HC_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QHCR3_RES_WR_MASK_29)) | (((0) & (MTL_QHCR3_MASK_29)) << 29);\
		(v) = ((v & MTL_QHCR3_HC_WR_MASK) | ((data & MTL_QHCR3_HC_MASK) << 0));\
		MTL_QHCR3_RGWR(v);\
} while (0)

#define MTL_QHCR3_HC_UDFRD(data) do {\
		MTL_QHCR3_RGRD(data);\
		data = ((data >> 0) & MTL_QHCR3_HC_MASK);\
} while (0)

#define MTL_QHCR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xda0))

#define MTL_QHCR2_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QHCR2_RGOFFADDR);\
} while (0)

#define MTL_QHCR2_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QHCR2_RGOFFADDR);\
} while (0)

/*#define  MTL_QHCR2_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_QHCR2_MASK_29 (ULONG)(0x7)

/*#define MTL_QHCR2_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_QHCR2_RES_WR_MASK_29 (ULONG)(0x1fffffff)

/*#define MTL_QHCR2_HC_Mask (ULONG)(~(~0<<(29)))*/

#define MTL_QHCR2_HC_MASK (ULONG)(0x1fffffff)

/*#define MTL_QHCR2_HC_Wr_Mask (ULONG)(~((~(~0 << (29))) << (0)))*/

#define MTL_QHCR2_HC_WR_MASK (ULONG)(0xe0000000)

#define MTL_QHCR2_HC_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QHCR2_RES_WR_MASK_29)) | (((0) & (MTL_QHCR2_MASK_29)) << 29);\
		(v) = ((v & MTL_QHCR2_HC_WR_MASK) | ((data & MTL_QHCR2_HC_MASK) << 0));\
		MTL_QHCR2_RGWR(v);\
} while (0)

#define MTL_QHCR2_HC_UDFRD(data) do {\
		MTL_QHCR2_RGRD(data);\
		data = ((data >> 0) & MTL_QHCR2_HC_MASK);\
} while (0)

#define MTL_QHCR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd60))

#define MTL_QHCR1_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QHCR1_RGOFFADDR);\
} while (0)

#define MTL_QHCR1_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QHCR1_RGOFFADDR);\
} while (0)

/*#define  MTL_QHCR1_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_QHCR1_MASK_29 (ULONG)(0x7)

/*#define MTL_QHCR1_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_QHCR1_RES_WR_MASK_29 (ULONG)(0x1fffffff)

/*#define MTL_QHCR1_HC_Mask (ULONG)(~(~0<<(29)))*/

#define MTL_QHCR1_HC_MASK (ULONG)(0x1fffffff)

/*#define MTL_QHCR1_HC_Wr_Mask (ULONG)(~((~(~0 << (29))) << (0)))*/

#define MTL_QHCR1_HC_WR_MASK (ULONG)(0xe0000000)

#define MTL_QHCR1_HC_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QHCR1_RES_WR_MASK_29)) | (((0) & (MTL_QHCR1_MASK_29)) << 29);\
		(v) = ((v & MTL_QHCR1_HC_WR_MASK) | ((data & MTL_QHCR1_HC_MASK) << 0));\
		MTL_QHCR1_RGWR(v);\
} while (0)

#define MTL_QHCR1_HC_UDFRD(data) do {\
		MTL_QHCR1_RGRD(data);\
		data = ((data >> 0) & MTL_QHCR1_HC_MASK);\
} while (0)

#define MTL_QSSCR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xedc))

#define MTL_QSSCR7_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QSSCR7_RGOFFADDR);\
} while (0)

#define MTL_QSSCR7_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QSSCR7_RGOFFADDR);\
} while (0)

/*#define  MTL_QSSCR7_Mask_14 (ULONG)(~(~0<<(18)))*/

#define  MTL_QSSCR7_MASK_14 (ULONG)(0x3ffff)

/*#define MTL_QSSCR7_RES_Wr_Mask_14 (ULONG)(~((~(~0<<(18)))<<(14)))*/

#define MTL_QSSCR7_RES_WR_MASK_14 (ULONG)(0x3fff)

/*#define MTL_QSSCR7_SSC_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_QSSCR7_SSC_MASK (ULONG)(0x3fff)

/*#define MTL_QSSCR7_SSC_Wr_Mask (ULONG)(~((~(~0 << (14))) << (0)))*/

#define MTL_QSSCR7_SSC_WR_MASK (ULONG)(0xffffc000)

#define MTL_QSSCR7_SSC_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QSSCR7_RES_WR_MASK_14)) | (((0) & (MTL_QSSCR7_MASK_14)) << 14);\
		(v) = ((v & MTL_QSSCR7_SSC_WR_MASK) | ((data & MTL_QSSCR7_SSC_MASK) << 0));\
		MTL_QSSCR7_RGWR(v);\
} while (0)

#define MTL_QSSCR7_SSC_UDFRD(data) do {\
		MTL_QSSCR7_RGRD(data);\
		data = ((data >> 0) & MTL_QSSCR7_SSC_MASK);\
} while (0)

#define MTL_QSSCR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe9c))

#define MTL_QSSCR6_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QSSCR6_RGOFFADDR);\
} while (0)

#define MTL_QSSCR6_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QSSCR6_RGOFFADDR);\
} while (0)

/*#define  MTL_QSSCR6_Mask_14 (ULONG)(~(~0<<(18)))*/

#define  MTL_QSSCR6_MASK_14 (ULONG)(0x3ffff)

/*#define MTL_QSSCR6_RES_Wr_Mask_14 (ULONG)(~((~(~0<<(18)))<<(14)))*/

#define MTL_QSSCR6_RES_WR_MASK_14 (ULONG)(0x3fff)

/*#define MTL_QSSCR6_SSC_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_QSSCR6_SSC_MASK (ULONG)(0x3fff)

/*#define MTL_QSSCR6_SSC_Wr_Mask (ULONG)(~((~(~0 << (14))) << (0)))*/

#define MTL_QSSCR6_SSC_WR_MASK (ULONG)(0xffffc000)

#define MTL_QSSCR6_SSC_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QSSCR6_RES_WR_MASK_14)) | (((0) & (MTL_QSSCR6_MASK_14)) << 14);\
		(v) = ((v & MTL_QSSCR6_SSC_WR_MASK) | ((data & MTL_QSSCR6_SSC_MASK) << 0));\
		MTL_QSSCR6_RGWR(v);\
} while (0)

#define MTL_QSSCR6_SSC_UDFRD(data) do {\
		MTL_QSSCR6_RGRD(data);\
		data = ((data >> 0) & MTL_QSSCR6_SSC_MASK);\
} while (0)

#define MTL_QSSCR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe5c))

#define MTL_QSSCR5_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QSSCR5_RGOFFADDR);\
} while (0)

#define MTL_QSSCR5_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QSSCR5_RGOFFADDR);\
} while (0)

/*#define  MTL_QSSCR5_Mask_14 (ULONG)(~(~0<<(18)))*/

#define  MTL_QSSCR5_MASK_14 (ULONG)(0x3ffff)

/*#define MTL_QSSCR5_RES_Wr_Mask_14 (ULONG)(~((~(~0<<(18)))<<(14)))*/

#define MTL_QSSCR5_RES_WR_MASK_14 (ULONG)(0x3fff)

/*#define MTL_QSSCR5_SSC_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_QSSCR5_SSC_MASK (ULONG)(0x3fff)

/*#define MTL_QSSCR5_SSC_Wr_Mask (ULONG)(~((~(~0 << (14))) << (0)))*/

#define MTL_QSSCR5_SSC_WR_MASK (ULONG)(0xffffc000)

#define MTL_QSSCR5_SSC_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QSSCR5_RES_WR_MASK_14)) | (((0) & (MTL_QSSCR5_MASK_14)) << 14);\
		(v) = ((v & MTL_QSSCR5_SSC_WR_MASK) | ((data & MTL_QSSCR5_SSC_MASK) << 0));\
		MTL_QSSCR5_RGWR(v);\
} while (0)

#define MTL_QSSCR5_SSC_UDFRD(data) do {\
		MTL_QSSCR5_RGRD(data);\
		data = ((data >> 0) & MTL_QSSCR5_SSC_MASK);\
} while (0)

#define MTL_QSSCR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe1c))

#define MTL_QSSCR4_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QSSCR4_RGOFFADDR);\
} while (0)

#define MTL_QSSCR4_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QSSCR4_RGOFFADDR);\
} while (0)

/*#define  MTL_QSSCR4_Mask_14 (ULONG)(~(~0<<(18)))*/

#define  MTL_QSSCR4_MASK_14 (ULONG)(0x3ffff)

/*#define MTL_QSSCR4_RES_Wr_Mask_14 (ULONG)(~((~(~0<<(18)))<<(14)))*/

#define MTL_QSSCR4_RES_WR_MASK_14 (ULONG)(0x3fff)

/*#define MTL_QSSCR4_SSC_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_QSSCR4_SSC_MASK (ULONG)(0x3fff)

/*#define MTL_QSSCR4_SSC_Wr_Mask (ULONG)(~((~(~0 << (14))) << (0)))*/

#define MTL_QSSCR4_SSC_WR_MASK (ULONG)(0xffffc000)

#define MTL_QSSCR4_SSC_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QSSCR4_RES_WR_MASK_14)) | (((0) & (MTL_QSSCR4_MASK_14)) << 14);\
		(v) = ((v & MTL_QSSCR4_SSC_WR_MASK) | ((data & MTL_QSSCR4_SSC_MASK) << 0));\
		MTL_QSSCR4_RGWR(v);\
} while (0)

#define MTL_QSSCR4_SSC_UDFRD(data) do {\
		MTL_QSSCR4_RGRD(data);\
		data = ((data >> 0) & MTL_QSSCR4_SSC_MASK);\
} while (0)

#define MTL_QSSCR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xddc))

#define MTL_QSSCR3_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QSSCR3_RGOFFADDR);\
} while (0)

#define MTL_QSSCR3_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QSSCR3_RGOFFADDR);\
} while (0)

/*#define  MTL_QSSCR3_Mask_14 (ULONG)(~(~0<<(18)))*/

#define  MTL_QSSCR3_MASK_14 (ULONG)(0x3ffff)

/*#define MTL_QSSCR3_RES_Wr_Mask_14 (ULONG)(~((~(~0<<(18)))<<(14)))*/

#define MTL_QSSCR3_RES_WR_MASK_14 (ULONG)(0x3fff)

/*#define MTL_QSSCR3_SSC_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_QSSCR3_SSC_MASK (ULONG)(0x3fff)

/*#define MTL_QSSCR3_SSC_Wr_Mask (ULONG)(~((~(~0 << (14))) << (0)))*/

#define MTL_QSSCR3_SSC_WR_MASK (ULONG)(0xffffc000)

#define MTL_QSSCR3_SSC_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QSSCR3_RES_WR_MASK_14)) | (((0) & (MTL_QSSCR3_MASK_14)) << 14);\
		(v) = ((v & MTL_QSSCR3_SSC_WR_MASK) | ((data & MTL_QSSCR3_SSC_MASK) << 0));\
		MTL_QSSCR3_RGWR(v);\
} while (0)

#define MTL_QSSCR3_SSC_UDFRD(data) do {\
		MTL_QSSCR3_RGRD(data);\
		data = ((data >> 0) & MTL_QSSCR3_SSC_MASK);\
} while (0)

#define MTL_QSSCR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd9c))

#define MTL_QSSCR2_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QSSCR2_RGOFFADDR);\
} while (0)

#define MTL_QSSCR2_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QSSCR2_RGOFFADDR);\
} while (0)

/*#define  MTL_QSSCR2_Mask_14 (ULONG)(~(~0<<(18)))*/

#define  MTL_QSSCR2_MASK_14 (ULONG)(0x3ffff)

/*#define MTL_QSSCR2_RES_Wr_Mask_14 (ULONG)(~((~(~0<<(18)))<<(14)))*/

#define MTL_QSSCR2_RES_WR_MASK_14 (ULONG)(0x3fff)

/*#define MTL_QSSCR2_SSC_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_QSSCR2_SSC_MASK (ULONG)(0x3fff)

/*#define MTL_QSSCR2_SSC_Wr_Mask (ULONG)(~((~(~0 << (14))) << (0)))*/

#define MTL_QSSCR2_SSC_WR_MASK (ULONG)(0xffffc000)

#define MTL_QSSCR2_SSC_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QSSCR2_RES_WR_MASK_14)) | (((0) & (MTL_QSSCR2_MASK_14)) << 14);\
		(v) = ((v & MTL_QSSCR2_SSC_WR_MASK) | ((data & MTL_QSSCR2_SSC_MASK) << 0));\
		MTL_QSSCR2_RGWR(v);\
} while (0)

#define MTL_QSSCR2_SSC_UDFRD(data) do {\
		MTL_QSSCR2_RGRD(data);\
		data = ((data >> 0) & MTL_QSSCR2_SSC_MASK);\
} while (0)

#define MTL_QSSCR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd5c))

#define MTL_QSSCR1_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QSSCR1_RGOFFADDR);\
} while (0)

#define MTL_QSSCR1_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QSSCR1_RGOFFADDR);\
} while (0)

/*#define  MTL_QSSCR1_Mask_14 (ULONG)(~(~0<<(18)))*/

#define  MTL_QSSCR1_MASK_14 (ULONG)(0x3ffff)

/*#define MTL_QSSCR1_RES_Wr_Mask_14 (ULONG)(~((~(~0<<(18)))<<(14)))*/

#define MTL_QSSCR1_RES_WR_MASK_14 (ULONG)(0x3fff)

/*#define MTL_QSSCR1_SSC_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_QSSCR1_SSC_MASK (ULONG)(0x3fff)

/*#define MTL_QSSCR1_SSC_Wr_Mask (ULONG)(~((~(~0 << (14))) << (0)))*/

#define MTL_QSSCR1_SSC_WR_MASK (ULONG)(0xffffc000)

#define MTL_QSSCR1_SSC_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QSSCR1_RES_WR_MASK_14)) | (((0) & (MTL_QSSCR1_MASK_14)) << 14);\
		(v) = ((v & MTL_QSSCR1_SSC_WR_MASK) | ((data & MTL_QSSCR1_SSC_MASK) << 0));\
		MTL_QSSCR1_RGWR(v);\
} while (0)

#define MTL_QSSCR1_SSC_UDFRD(data) do {\
		MTL_QSSCR1_RGRD(data);\
		data = ((data >> 0) & MTL_QSSCR1_SSC_MASK);\
} while (0)

#define MTL_QW7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xed8))

#define MTL_QW7_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QW7_RGOFFADDR);\
} while (0)

#define MTL_QW7_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QW7_RGOFFADDR);\
} while (0)

/*#define  MTL_QW7_Mask_21 (ULONG)(~(~0<<(11)))*/

#define  MTL_QW7_MASK_21 (ULONG)(0x7ff)

/*#define MTL_QW7_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(11)))<<(21)))*/

#define MTL_QW7_RES_WR_MASK_21 (ULONG)(0x1fffff)

/*#define MTL_QW7_ISCQW_Mask (ULONG)(~(~0<<(21)))*/

#define MTL_QW7_ISCQW_MASK (ULONG)(0x1fffff)

/*#define MTL_QW7_ISCQW_Wr_Mask (ULONG)(~((~(~0 << (21))) << (0)))*/

#define MTL_QW7_ISCQW_WR_MASK (ULONG)(0xffe00000)

#define MTL_QW7_ISCQW_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QW7_RES_WR_MASK_21)) | (((0) & (MTL_QW7_MASK_21)) << 21);\
		(v) = ((v & MTL_QW7_ISCQW_WR_MASK) | ((data & MTL_QW7_ISCQW_MASK) << 0));\
		MTL_QW7_RGWR(v);\
} while (0)

#define MTL_QW7_ISCQW_UDFRD(data) do {\
		MTL_QW7_RGRD(data);\
		data = ((data >> 0) & MTL_QW7_ISCQW_MASK);\
} while (0)

#define MTL_QW6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe98))

#define MTL_QW6_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QW6_RGOFFADDR);\
} while (0)

#define MTL_QW6_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QW6_RGOFFADDR);\
} while (0)

/*#define  MTL_QW6_Mask_21 (ULONG)(~(~0<<(11)))*/

#define  MTL_QW6_MASK_21 (ULONG)(0x7ff)

/*#define MTL_QW6_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(11)))<<(21)))*/

#define MTL_QW6_RES_WR_MASK_21 (ULONG)(0x1fffff)

/*#define MTL_QW6_ISCQW_Mask (ULONG)(~(~0<<(21)))*/

#define MTL_QW6_ISCQW_MASK (ULONG)(0x1fffff)

/*#define MTL_QW6_ISCQW_Wr_Mask (ULONG)(~((~(~0 << (21))) << (0)))*/

#define MTL_QW6_ISCQW_WR_MASK (ULONG)(0xffe00000)

#define MTL_QW6_ISCQW_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QW6_RES_WR_MASK_21)) | (((0) & (MTL_QW6_MASK_21)) << 21);\
		(v) = ((v & MTL_QW6_ISCQW_WR_MASK) | ((data & MTL_QW6_ISCQW_MASK) << 0));\
		MTL_QW6_RGWR(v);\
} while (0)

#define MTL_QW6_ISCQW_UDFRD(data) do {\
		MTL_QW6_RGRD(data);\
		data = ((data >> 0) & MTL_QW6_ISCQW_MASK);\
} while (0)

#define MTL_QW5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe58))

#define MTL_QW5_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QW5_RGOFFADDR);\
} while (0)

#define MTL_QW5_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QW5_RGOFFADDR);\
} while (0)

/*#define  MTL_QW5_Mask_21 (ULONG)(~(~0<<(11)))*/

#define  MTL_QW5_MASK_21 (ULONG)(0x7ff)

/*#define MTL_QW5_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(11)))<<(21)))*/

#define MTL_QW5_RES_WR_MASK_21 (ULONG)(0x1fffff)

/*#define MTL_QW5_ISCQW_Mask (ULONG)(~(~0<<(21)))*/

#define MTL_QW5_ISCQW_MASK (ULONG)(0x1fffff)

/*#define MTL_QW5_ISCQW_Wr_Mask (ULONG)(~((~(~0 << (21))) << (0)))*/

#define MTL_QW5_ISCQW_WR_MASK (ULONG)(0xffe00000)

#define MTL_QW5_ISCQW_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QW5_RES_WR_MASK_21)) | (((0) & (MTL_QW5_MASK_21)) << 21);\
		(v) = ((v & MTL_QW5_ISCQW_WR_MASK) | ((data & MTL_QW5_ISCQW_MASK) << 0));\
		MTL_QW5_RGWR(v);\
} while (0)

#define MTL_QW5_ISCQW_UDFRD(data) do {\
		MTL_QW5_RGRD(data);\
		data = ((data >> 0) & MTL_QW5_ISCQW_MASK);\
} while (0)

#define MTL_QW4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe18))

#define MTL_QW4_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QW4_RGOFFADDR);\
} while (0)

#define MTL_QW4_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QW4_RGOFFADDR);\
} while (0)

/*#define  MTL_QW4_Mask_21 (ULONG)(~(~0<<(11)))*/

#define  MTL_QW4_MASK_21 (ULONG)(0x7ff)

/*#define MTL_QW4_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(11)))<<(21)))*/

#define MTL_QW4_RES_WR_MASK_21 (ULONG)(0x1fffff)

/*#define MTL_QW4_ISCQW_Mask (ULONG)(~(~0<<(21)))*/

#define MTL_QW4_ISCQW_MASK (ULONG)(0x1fffff)

/*#define MTL_QW4_ISCQW_Wr_Mask (ULONG)(~((~(~0 << (21))) << (0)))*/

#define MTL_QW4_ISCQW_WR_MASK (ULONG)(0xffe00000)

#define MTL_QW4_ISCQW_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QW4_RES_WR_MASK_21)) | (((0) & (MTL_QW4_MASK_21)) << 21);\
		(v) = ((v & MTL_QW4_ISCQW_WR_MASK) | ((data & MTL_QW4_ISCQW_MASK) << 0));\
		MTL_QW4_RGWR(v);\
} while (0)

#define MTL_QW4_ISCQW_UDFRD(data) do {\
		MTL_QW4_RGRD(data);\
		data = ((data >> 0) & MTL_QW4_ISCQW_MASK);\
} while (0)

#define MTL_QW3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xdd8))

#define MTL_QW3_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QW3_RGOFFADDR);\
} while (0)

#define MTL_QW3_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QW3_RGOFFADDR);\
} while (0)

/*#define  MTL_QW3_Mask_21 (ULONG)(~(~0<<(11)))*/

#define  MTL_QW3_MASK_21 (ULONG)(0x7ff)

/*#define MTL_QW3_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(11)))<<(21)))*/

#define MTL_QW3_RES_WR_MASK_21 (ULONG)(0x1fffff)

/*#define MTL_QW3_ISCQW_Mask (ULONG)(~(~0<<(21)))*/

#define MTL_QW3_ISCQW_MASK (ULONG)(0x1fffff)

/*#define MTL_QW3_ISCQW_Wr_Mask (ULONG)(~((~(~0 << (21))) << (0)))*/

#define MTL_QW3_ISCQW_WR_MASK (ULONG)(0xffe00000)

#define MTL_QW3_ISCQW_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QW3_RES_WR_MASK_21)) | (((0) & (MTL_QW3_MASK_21)) << 21);\
		(v) = ((v & MTL_QW3_ISCQW_WR_MASK) | ((data & MTL_QW3_ISCQW_MASK) << 0));\
		MTL_QW3_RGWR(v);\
} while (0)

#define MTL_QW3_ISCQW_UDFRD(data) do {\
		MTL_QW3_RGRD(data);\
		data = ((data >> 0) & MTL_QW3_ISCQW_MASK);\
} while (0)

#define MTL_QW2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd98))

#define MTL_QW2_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QW2_RGOFFADDR);\
} while (0)

#define MTL_QW2_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QW2_RGOFFADDR);\
} while (0)

/*#define  MTL_QW2_Mask_21 (ULONG)(~(~0<<(11)))*/

#define  MTL_QW2_MASK_21 (ULONG)(0x7ff)

/*#define MTL_QW2_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(11)))<<(21)))*/

#define MTL_QW2_RES_WR_MASK_21 (ULONG)(0x1fffff)

/*#define MTL_QW2_ISCQW_Mask (ULONG)(~(~0<<(21)))*/

#define MTL_QW2_ISCQW_MASK (ULONG)(0x1fffff)

/*#define MTL_QW2_ISCQW_Wr_Mask (ULONG)(~((~(~0 << (21))) << (0)))*/

#define MTL_QW2_ISCQW_WR_MASK (ULONG)(0xffe00000)

#define MTL_QW2_ISCQW_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QW2_RES_WR_MASK_21)) | (((0) & (MTL_QW2_MASK_21)) << 21);\
		(v) = ((v & MTL_QW2_ISCQW_WR_MASK) | ((data & MTL_QW2_ISCQW_MASK) << 0));\
		MTL_QW2_RGWR(v);\
} while (0)

#define MTL_QW2_ISCQW_UDFRD(data) do {\
		MTL_QW2_RGRD(data);\
		data = ((data >> 0) & MTL_QW2_ISCQW_MASK);\
} while (0)

#define MTL_QW1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd58))

#define MTL_QW1_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QW1_RGOFFADDR);\
} while (0)

#define MTL_QW1_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QW1_RGOFFADDR);\
} while (0)

/*#define  MTL_QW1_Mask_21 (ULONG)(~(~0<<(11)))*/

#define  MTL_QW1_MASK_21 (ULONG)(0x7ff)

/*#define MTL_QW1_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(11)))<<(21)))*/

#define MTL_QW1_RES_WR_MASK_21 (ULONG)(0x1fffff)

/*#define MTL_QW1_ISCQW_Mask (ULONG)(~(~0<<(21)))*/

#define MTL_QW1_ISCQW_MASK (ULONG)(0x1fffff)

/*#define MTL_QW1_ISCQW_Wr_Mask (ULONG)(~((~(~0 << (21))) << (0)))*/

#define MTL_QW1_ISCQW_WR_MASK (ULONG)(0xffe00000)

#define MTL_QW1_ISCQW_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QW1_RES_WR_MASK_21)) | (((0) & (MTL_QW1_MASK_21)) << 21);\
		(v) = ((v & MTL_QW1_ISCQW_WR_MASK) | ((data & MTL_QW1_ISCQW_MASK) << 0));\
		MTL_QW1_RGWR(v);\
} while (0)

#define MTL_QW1_ISCQW_UDFRD(data) do {\
		MTL_QW1_RGRD(data);\
		data = ((data >> 0) & MTL_QW1_ISCQW_MASK);\
} while (0)

#define MTL_QESR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xed4))

#define MTL_QESR7_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QESR7_RGOFFADDR);\
} while (0)

/*#define MTL_QESR7_ABS_Mask (ULONG)(~(~0<<(24)))*/

#define MTL_QESR7_ABS_MASK (ULONG)(0xffffff)

#define MTL_QESR7_ABS_UDFRD(data) do {\
		MTL_QESR7_RGRD(data);\
		data = ((data >> 0) & MTL_QESR7_ABS_MASK);\
} while (0)

/*#define MTL_QESR7_ABSU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QESR7_ABSU_MASK (ULONG)(0x1)

#define MTL_QESR7_ABSU_UDFRD(data) do {\
		MTL_QESR7_RGRD(data);\
		data = ((data >> 24) & MTL_QESR7_ABSU_MASK);\
} while (0)

#define MTL_QESR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe94))

#define MTL_QESR6_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QESR6_RGOFFADDR);\
} while (0)

/*#define MTL_QESR6_ABS_Mask (ULONG)(~(~0<<(24)))*/

#define MTL_QESR6_ABS_MASK (ULONG)(0xffffff)

#define MTL_QESR6_ABS_UDFRD(data) do {\
		MTL_QESR6_RGRD(data);\
		data = ((data >> 0) & MTL_QESR6_ABS_MASK);\
} while (0)

/*#define MTL_QESR6_ABSU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QESR6_ABSU_MASK (ULONG)(0x1)

#define MTL_QESR6_ABSU_UDFRD(data) do {\
		MTL_QESR6_RGRD(data);\
		data = ((data >> 24) & MTL_QESR6_ABSU_MASK);\
} while (0)

#define MTL_QESR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe54))

#define MTL_QESR5_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QESR5_RGOFFADDR);\
} while (0)

/*#define MTL_QESR5_ABS_Mask (ULONG)(~(~0<<(24)))*/

#define MTL_QESR5_ABS_MASK (ULONG)(0xffffff)

#define MTL_QESR5_ABS_UDFRD(data) do {\
		MTL_QESR5_RGRD(data);\
		data = ((data >> 0) & MTL_QESR5_ABS_MASK);\
} while (0)

/*#define MTL_QESR5_ABSU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QESR5_ABSU_MASK (ULONG)(0x1)

#define MTL_QESR5_ABSU_UDFRD(data) do {\
		MTL_QESR5_RGRD(data);\
		data = ((data >> 24) & MTL_QESR5_ABSU_MASK);\
} while (0)

#define MTL_QESR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe14))

#define MTL_QESR4_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QESR4_RGOFFADDR);\
} while (0)

/*#define MTL_QESR4_ABS_Mask (ULONG)(~(~0<<(24)))*/

#define MTL_QESR4_ABS_MASK (ULONG)(0xffffff)

#define MTL_QESR4_ABS_UDFRD(data) do {\
		MTL_QESR4_RGRD(data);\
		data = ((data >> 0) & MTL_QESR4_ABS_MASK);\
} while (0)

/*#define MTL_QESR4_ABSU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QESR4_ABSU_MASK (ULONG)(0x1)

#define MTL_QESR4_ABSU_UDFRD(data) do {\
		MTL_QESR4_RGRD(data);\
		data = ((data >> 24) & MTL_QESR4_ABSU_MASK);\
} while (0)

#define MTL_QESR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xdd4))

#define MTL_QESR3_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QESR3_RGOFFADDR);\
} while (0)

/*#define MTL_QESR3_ABS_Mask (ULONG)(~(~0<<(24)))*/

#define MTL_QESR3_ABS_MASK (ULONG)(0xffffff)

#define MTL_QESR3_ABS_UDFRD(data) do {\
		MTL_QESR3_RGRD(data);\
		data = ((data >> 0) & MTL_QESR3_ABS_MASK);\
} while (0)

/*#define MTL_QESR3_ABSU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QESR3_ABSU_MASK (ULONG)(0x1)

#define MTL_QESR3_ABSU_UDFRD(data) do {\
		MTL_QESR3_RGRD(data);\
		data = ((data >> 24) & MTL_QESR3_ABSU_MASK);\
} while (0)

#define MTL_QESR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd94))

#define MTL_QESR2_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QESR2_RGOFFADDR);\
} while (0)

/*#define MTL_QESR2_ABS_Mask (ULONG)(~(~0<<(24)))*/

#define MTL_QESR2_ABS_MASK (ULONG)(0xffffff)

#define MTL_QESR2_ABS_UDFRD(data) do {\
		MTL_QESR2_RGRD(data);\
		data = ((data >> 0) & MTL_QESR2_ABS_MASK);\
} while (0)

/*#define MTL_QESR2_ABSU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QESR2_ABSU_MASK (ULONG)(0x1)

#define MTL_QESR2_ABSU_UDFRD(data) do {\
		MTL_QESR2_RGRD(data);\
		data = ((data >> 24) & MTL_QESR2_ABSU_MASK);\
} while (0)

#define MTL_QESR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd54))

#define MTL_QESR1_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QESR1_RGOFFADDR);\
} while (0)

/*#define MTL_QESR1_ABS_Mask (ULONG)(~(~0<<(24)))*/

#define MTL_QESR1_ABS_MASK (ULONG)(0xffffff)

#define MTL_QESR1_ABS_UDFRD(data) do {\
		MTL_QESR1_RGRD(data);\
		data = ((data >> 0) & MTL_QESR1_ABS_MASK);\
} while (0)

/*#define MTL_QESR1_ABSU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QESR1_ABSU_MASK (ULONG)(0x1)

#define MTL_QESR1_ABSU_UDFRD(data) do {\
		MTL_QESR1_RGRD(data);\
		data = ((data >> 24) & MTL_QESR1_ABSU_MASK);\
} while (0)

#define MTL_QECR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xed0))

#define MTL_QECR7_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QECR7_RGOFFADDR);\
} while (0)

#define MTL_QECR7_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QECR7_RGOFFADDR);\
} while (0)

/*#define  MTL_QECR7_Mask_0 (ULONG)(~(~0<<(2)))*/

#define  MTL_QECR7_MASK_0 (ULONG)(0x3)

/*#define MTL_QECR7_RES_Wr_Mask_0 (ULONG)(~((~(~0<<(2)))<<(0)))*/

#define MTL_QECR7_RES_WR_MASK_0 (ULONG)(0xfffffffc)

/*#define  MTL_QECR7_Mask_7 (ULONG)(~(~0<<(17)))*/

#define  MTL_QECR7_MASK_7 (ULONG)(0x1ffff)

/*#define MTL_QECR7_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(17)))<<(7)))*/

#define MTL_QECR7_RES_WR_MASK_7 (ULONG)(0xff00007f)

/*#define  MTL_QECR7_Mask_25 (ULONG)(~(~0<<(7)))*/

#define  MTL_QECR7_MASK_25 (ULONG)(0x7f)

/*#define MTL_QECR7_RES_Wr_Mask_25 (ULONG)(~((~(~0<<(7)))<<(25)))*/

#define MTL_QECR7_RES_WR_MASK_25 (ULONG)(0x1ffffff)

/*#define MTL_QECR7_AVALG_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR7_AVALG_MASK (ULONG)(0x1)

/*#define MTL_QECR7_AVALG_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MTL_QECR7_AVALG_WR_MASK (ULONG)(0xfffffffb)

#define MTL_QECR7_AVALG_UDFWR(data) do {\
		ULONG v;\
		MTL_QECR7_RGRD(v);\
		v = (v & (MTL_QECR7_RES_WR_MASK_0)) | (((0) & (MTL_QECR7_MASK_0)) << 0);\
		v = (v & (MTL_QECR7_RES_WR_MASK_7)) | (((0) & (MTL_QECR7_MASK_7)) << 7);\
		v = (v & (MTL_QECR7_RES_WR_MASK_25)) | (((0) & (MTL_QECR7_MASK_25)) << 25);\
		v = ((v & MTL_QECR7_AVALG_WR_MASK) | ((data & MTL_QECR7_AVALG_MASK) << 2));\
		MTL_QECR7_RGWR(v);\
} while (0)

#define MTL_QECR7_AVALG_UDFRD(data) do {\
		MTL_QECR7_RGRD(data);\
		data = ((data >> 2) & MTL_QECR7_AVALG_MASK);\
} while (0)

/*#define MTL_QECR7_CC_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR7_CC_MASK (ULONG)(0x1)

/*#define MTL_QECR7_CC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_QECR7_CC_WR_MASK (ULONG)(0xfffffff7)

#define MTL_QECR7_CC_UDFWR(data) do {\
		ULONG v;\
		MTL_QECR7_RGRD(v);\
		v = (v & (MTL_QECR7_RES_WR_MASK_0)) | (((0) & (MTL_QECR7_MASK_0)) << 0);\
		v = (v & (MTL_QECR7_RES_WR_MASK_7)) | (((0) & (MTL_QECR7_MASK_7)) << 7);\
		v = (v & (MTL_QECR7_RES_WR_MASK_25)) | (((0) & (MTL_QECR7_MASK_25)) << 25);\
		v = ((v & MTL_QECR7_CC_WR_MASK) | ((data & MTL_QECR7_CC_MASK) << 3));\
		MTL_QECR7_RGWR(v);\
} while (0)

#define MTL_QECR7_CC_UDFRD(data) do {\
		MTL_QECR7_RGRD(data);\
		data = ((data >> 3) & MTL_QECR7_CC_MASK);\
} while (0)

/*#define MTL_QECR7_SLC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QECR7_SLC_MASK (ULONG)(0x7)

/*#define MTL_QECR7_SLC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_QECR7_SLC_WR_MASK (ULONG)(0xffffff8f)

#define MTL_QECR7_SLC_UDFWR(data) do {\
		ULONG v;\
		MTL_QECR7_RGRD(v);\
		v = (v & (MTL_QECR7_RES_WR_MASK_0)) | (((0) & (MTL_QECR7_MASK_0)) << 0);\
		v = (v & (MTL_QECR7_RES_WR_MASK_7)) | (((0) & (MTL_QECR7_MASK_7)) << 7);\
		v = (v & (MTL_QECR7_RES_WR_MASK_25)) | (((0) & (MTL_QECR7_MASK_25)) << 25);\
		v = ((v & MTL_QECR7_SLC_WR_MASK) | ((data & MTL_QECR7_SLC_MASK) << 4));\
		MTL_QECR7_RGWR(v);\
} while (0)

#define MTL_QECR7_SLC_UDFRD(data) do {\
		MTL_QECR7_RGRD(data);\
		data = ((data >> 4) & MTL_QECR7_SLC_MASK);\
} while (0)

/*#define MTL_QECR7_ABPSSIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR7_ABPSSIE_MASK (ULONG)(0x1)

/*#define MTL_QECR7_ABPSSIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define MTL_QECR7_ABPSSIE_WR_MASK (ULONG)(0xfeffffff)

#define MTL_QECR7_ABPSSIE_UDFWR(data) do {\
		ULONG v;\
		MTL_QECR7_RGRD(v);\
		v = (v & (MTL_QECR7_RES_WR_MASK_0)) | (((0) & (MTL_QECR7_MASK_0)) << 0);\
		v = (v & (MTL_QECR7_RES_WR_MASK_7)) | (((0) & (MTL_QECR7_MASK_7)) << 7);\
		v = (v & (MTL_QECR7_RES_WR_MASK_25)) | (((0) & (MTL_QECR7_MASK_25)) << 25);\
		v = ((v & MTL_QECR7_ABPSSIE_WR_MASK) | ((data & MTL_QECR7_ABPSSIE_MASK) << 24));\
		MTL_QECR7_RGWR(v);\
} while (0)

#define MTL_QECR7_ABPSSIE_UDFRD(data) do {\
		MTL_QECR7_RGRD(data);\
		data = ((data >> 24) & MTL_QECR7_ABPSSIE_MASK);\
} while (0)

#define MTL_QECR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe90))

#define MTL_QECR6_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QECR6_RGOFFADDR);\
} while (0)

#define MTL_QECR6_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QECR6_RGOFFADDR);\
} while (0)

/*#define  MTL_QECR6_Mask_0 (ULONG)(~(~0<<(2)))*/

#define  MTL_QECR6_MASK_0 (ULONG)(0x3)

/*#define MTL_QECR6_RES_Wr_Mask_0 (ULONG)(~((~(~0<<(2)))<<(0)))*/

#define MTL_QECR6_RES_WR_MASK_0 (ULONG)(0xfffffffc)

/*#define  MTL_QECR6_Mask_7 (ULONG)(~(~0<<(17)))*/

#define  MTL_QECR6_MASK_7 (ULONG)(0x1ffff)

/*#define MTL_QECR6_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(17)))<<(7)))*/

#define MTL_QECR6_RES_WR_MASK_7 (ULONG)(0xff00007f)

/*#define  MTL_QECR6_Mask_25 (ULONG)(~(~0<<(7)))*/

#define  MTL_QECR6_MASK_25 (ULONG)(0x7f)

/*#define MTL_QECR6_RES_Wr_Mask_25 (ULONG)(~((~(~0<<(7)))<<(25)))*/

#define MTL_QECR6_RES_WR_MASK_25 (ULONG)(0x1ffffff)

/*#define MTL_QECR6_AVALG_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR6_AVALG_MASK (ULONG)(0x1)

/*#define MTL_QECR6_AVALG_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MTL_QECR6_AVALG_WR_MASK (ULONG)(0xfffffffb)

#define MTL_QECR6_AVALG_UDFWR(data) do {\
		ULONG v;\
		MTL_QECR6_RGRD(v);\
		v = (v & (MTL_QECR6_RES_WR_MASK_0)) | (((0) & (MTL_QECR6_MASK_0)) << 0);\
		v = (v & (MTL_QECR6_RES_WR_MASK_7)) | (((0) & (MTL_QECR6_MASK_7)) << 7);\
		v = (v & (MTL_QECR6_RES_WR_MASK_25)) | (((0) & (MTL_QECR6_MASK_25)) << 25);\
		v = ((v & MTL_QECR6_AVALG_WR_MASK) | ((data & MTL_QECR6_AVALG_MASK) << 2));\
		MTL_QECR6_RGWR(v);\
} while (0)

#define MTL_QECR6_AVALG_UDFRD(data) do {\
		MTL_QECR6_RGRD(data);\
		data = ((data >> 2) & MTL_QECR6_AVALG_MASK);\
} while (0)

/*#define MTL_QECR6_CC_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR6_CC_MASK (ULONG)(0x1)

/*#define MTL_QECR6_CC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_QECR6_CC_WR_MASK (ULONG)(0xfffffff7)

#define MTL_QECR6_CC_UDFWR(data) do {\
		ULONG v;\
		MTL_QECR6_RGRD(v);\
		v = (v & (MTL_QECR6_RES_WR_MASK_0)) | (((0) & (MTL_QECR6_MASK_0)) << 0);\
		v = (v & (MTL_QECR6_RES_WR_MASK_7)) | (((0) & (MTL_QECR6_MASK_7)) << 7);\
		v = (v & (MTL_QECR6_RES_WR_MASK_25)) | (((0) & (MTL_QECR6_MASK_25)) << 25);\
		v = ((v & MTL_QECR6_CC_WR_MASK) | ((data & MTL_QECR6_CC_MASK) << 3));\
		MTL_QECR6_RGWR(v);\
} while (0)

#define MTL_QECR6_CC_UDFRD(data) do {\
		MTL_QECR6_RGRD(data);\
		data = ((data >> 3) & MTL_QECR6_CC_MASK);\
} while (0)

/*#define MTL_QECR6_SLC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QECR6_SLC_MASK (ULONG)(0x7)

/*#define MTL_QECR6_SLC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_QECR6_SLC_WR_MASK (ULONG)(0xffffff8f)

#define MTL_QECR6_SLC_UDFWR(data) do {\
		ULONG v;\
		MTL_QECR6_RGRD(v);\
		v = (v & (MTL_QECR6_RES_WR_MASK_0)) | (((0) & (MTL_QECR6_MASK_0)) << 0);\
		v = (v & (MTL_QECR6_RES_WR_MASK_7)) | (((0) & (MTL_QECR6_MASK_7)) << 7);\
		v = (v & (MTL_QECR6_RES_WR_MASK_25)) | (((0) & (MTL_QECR6_MASK_25)) << 25);\
		v = ((v & MTL_QECR6_SLC_WR_MASK) | ((data & MTL_QECR6_SLC_MASK) << 4));\
		MTL_QECR6_RGWR(v);\
} while (0)

#define MTL_QECR6_SLC_UDFRD(data) do {\
		MTL_QECR6_RGRD(data);\
		data = ((data >> 4) & MTL_QECR6_SLC_MASK);\
} while (0)

/*#define MTL_QECR6_ABPSSIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR6_ABPSSIE_MASK (ULONG)(0x1)

/*#define MTL_QECR6_ABPSSIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define MTL_QECR6_ABPSSIE_WR_MASK (ULONG)(0xfeffffff)

#define MTL_QECR6_ABPSSIE_UDFWR(data) do {\
		ULONG v;\
		MTL_QECR6_RGRD(v);\
		v = (v & (MTL_QECR6_RES_WR_MASK_0)) | (((0) & (MTL_QECR6_MASK_0)) << 0);\
		v = (v & (MTL_QECR6_RES_WR_MASK_7)) | (((0) & (MTL_QECR6_MASK_7)) << 7);\
		v = (v & (MTL_QECR6_RES_WR_MASK_25)) | (((0) & (MTL_QECR6_MASK_25)) << 25);\
		v = ((v & MTL_QECR6_ABPSSIE_WR_MASK) | ((data & MTL_QECR6_ABPSSIE_MASK) << 24));\
		MTL_QECR6_RGWR(v);\
} while (0)

#define MTL_QECR6_ABPSSIE_UDFRD(data) do {\
		MTL_QECR6_RGRD(data);\
		data = ((data >> 24) & MTL_QECR6_ABPSSIE_MASK);\
} while (0)

#define MTL_QECR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe50))

#define MTL_QECR5_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QECR5_RGOFFADDR);\
} while (0)

#define MTL_QECR5_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QECR5_RGOFFADDR);\
} while (0)

/*#define  MTL_QECR5_Mask_0 (ULONG)(~(~0<<(2)))*/

#define  MTL_QECR5_MASK_0 (ULONG)(0x3)

/*#define MTL_QECR5_RES_Wr_Mask_0 (ULONG)(~((~(~0<<(2)))<<(0)))*/

#define MTL_QECR5_RES_WR_MASK_0 (ULONG)(0xfffffffc)

/*#define  MTL_QECR5_Mask_7 (ULONG)(~(~0<<(17)))*/

#define  MTL_QECR5_MASK_7 (ULONG)(0x1ffff)

/*#define MTL_QECR5_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(17)))<<(7)))*/

#define MTL_QECR5_RES_WR_MASK_7 (ULONG)(0xff00007f)

/*#define  MTL_QECR5_Mask_25 (ULONG)(~(~0<<(7)))*/

#define  MTL_QECR5_MASK_25 (ULONG)(0x7f)

/*#define MTL_QECR5_RES_Wr_Mask_25 (ULONG)(~((~(~0<<(7)))<<(25)))*/

#define MTL_QECR5_RES_WR_MASK_25 (ULONG)(0x1ffffff)

/*#define MTL_QECR5_AVALG_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR5_AVALG_MASK (ULONG)(0x1)

/*#define MTL_QECR5_AVALG_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MTL_QECR5_AVALG_WR_MASK (ULONG)(0xfffffffb)

#define MTL_QECR5_AVALG_UDFWR(data) do {\
		ULONG v;\
		MTL_QECR5_RGRD(v);\
		v = (v & (MTL_QECR5_RES_WR_MASK_0)) | (((0) & (MTL_QECR5_MASK_0)) << 0);\
		v = (v & (MTL_QECR5_RES_WR_MASK_7)) | (((0) & (MTL_QECR5_MASK_7)) << 7);\
		v = (v & (MTL_QECR5_RES_WR_MASK_25)) | (((0) & (MTL_QECR5_MASK_25)) << 25);\
		v = ((v & MTL_QECR5_AVALG_WR_MASK) | ((data & MTL_QECR5_AVALG_MASK) << 2));\
		MTL_QECR5_RGWR(v);\
} while (0)

#define MTL_QECR5_AVALG_UDFRD(data) do {\
		MTL_QECR5_RGRD(data);\
		data = ((data >> 2) & MTL_QECR5_AVALG_MASK);\
} while (0)

/*#define MTL_QECR5_CC_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR5_CC_MASK (ULONG)(0x1)

/*#define MTL_QECR5_CC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_QECR5_CC_WR_MASK (ULONG)(0xfffffff7)

#define MTL_QECR5_CC_UDFWR(data) do {\
		ULONG v;\
		MTL_QECR5_RGRD(v);\
		v = (v & (MTL_QECR5_RES_WR_MASK_0)) | (((0) & (MTL_QECR5_MASK_0)) << 0);\
		v = (v & (MTL_QECR5_RES_WR_MASK_7)) | (((0) & (MTL_QECR5_MASK_7)) << 7);\
		v = (v & (MTL_QECR5_RES_WR_MASK_25)) | (((0) & (MTL_QECR5_MASK_25)) << 25);\
		v = ((v & MTL_QECR5_CC_WR_MASK) | ((data & MTL_QECR5_CC_MASK) << 3));\
		MTL_QECR5_RGWR(v);\
} while (0)

#define MTL_QECR5_CC_UDFRD(data) do {\
		MTL_QECR5_RGRD(data);\
		data = ((data >> 3) & MTL_QECR5_CC_MASK);\
} while (0)

/*#define MTL_QECR5_SLC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QECR5_SLC_MASK (ULONG)(0x7)

/*#define MTL_QECR5_SLC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_QECR5_SLC_WR_MASK (ULONG)(0xffffff8f)

#define MTL_QECR5_SLC_UDFWR(data) do {\
		ULONG v;\
		MTL_QECR5_RGRD(v);\
		v = (v & (MTL_QECR5_RES_WR_MASK_0)) | (((0) & (MTL_QECR5_MASK_0)) << 0);\
		v = (v & (MTL_QECR5_RES_WR_MASK_7)) | (((0) & (MTL_QECR5_MASK_7)) << 7);\
		v = (v & (MTL_QECR5_RES_WR_MASK_25)) | (((0) & (MTL_QECR5_MASK_25)) << 25);\
		v = ((v & MTL_QECR5_SLC_WR_MASK) | ((data & MTL_QECR5_SLC_MASK) << 4));\
		MTL_QECR5_RGWR(v);\
} while (0)

#define MTL_QECR5_SLC_UDFRD(data) do {\
		MTL_QECR5_RGRD(data);\
		data = ((data >> 4) & MTL_QECR5_SLC_MASK);\
} while (0)

/*#define MTL_QECR5_ABPSSIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR5_ABPSSIE_MASK (ULONG)(0x1)

/*#define MTL_QECR5_ABPSSIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define MTL_QECR5_ABPSSIE_WR_MASK (ULONG)(0xfeffffff)

#define MTL_QECR5_ABPSSIE_UDFWR(data) do {\
		ULONG v;\
		MTL_QECR5_RGRD(v);\
		v = (v & (MTL_QECR5_RES_WR_MASK_0)) | (((0) & (MTL_QECR5_MASK_0)) << 0);\
		v = (v & (MTL_QECR5_RES_WR_MASK_7)) | (((0) & (MTL_QECR5_MASK_7)) << 7);\
		v = (v & (MTL_QECR5_RES_WR_MASK_25)) | (((0) & (MTL_QECR5_MASK_25)) << 25);\
		v = ((v & MTL_QECR5_ABPSSIE_WR_MASK) | ((data & MTL_QECR5_ABPSSIE_MASK) << 24));\
		MTL_QECR5_RGWR(v);\
} while (0)

#define MTL_QECR5_ABPSSIE_UDFRD(data) do {\
		MTL_QECR5_RGRD(data);\
		data = ((data >> 24) & MTL_QECR5_ABPSSIE_MASK);\
} while (0)

#define MTL_QECR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe10))

#define MTL_QECR4_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QECR4_RGOFFADDR);\
} while (0)

#define MTL_QECR4_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QECR4_RGOFFADDR);\
} while (0)

/*#define  MTL_QECR4_Mask_0 (ULONG)(~(~0<<(2)))*/

#define  MTL_QECR4_MASK_0 (ULONG)(0x3)

/*#define MTL_QECR4_RES_Wr_Mask_0 (ULONG)(~((~(~0<<(2)))<<(0)))*/

#define MTL_QECR4_RES_WR_MASK_0 (ULONG)(0xfffffffc)

/*#define  MTL_QECR4_Mask_7 (ULONG)(~(~0<<(17)))*/

#define  MTL_QECR4_MASK_7 (ULONG)(0x1ffff)

/*#define MTL_QECR4_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(17)))<<(7)))*/

#define MTL_QECR4_RES_WR_MASK_7 (ULONG)(0xff00007f)

/*#define  MTL_QECR4_Mask_25 (ULONG)(~(~0<<(7)))*/

#define  MTL_QECR4_MASK_25 (ULONG)(0x7f)

/*#define MTL_QECR4_RES_Wr_Mask_25 (ULONG)(~((~(~0<<(7)))<<(25)))*/

#define MTL_QECR4_RES_WR_MASK_25 (ULONG)(0x1ffffff)

/*#define MTL_QECR4_AVALG_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR4_AVALG_MASK (ULONG)(0x1)

/*#define MTL_QECR4_AVALG_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MTL_QECR4_AVALG_WR_MASK (ULONG)(0xfffffffb)

#define MTL_QECR4_AVALG_UDFWR(data) do {\
		ULONG v;\
		MTL_QECR4_RGRD(v);\
		v = (v & (MTL_QECR4_RES_WR_MASK_0)) | (((0) & (MTL_QECR4_MASK_0)) << 0);\
		v = (v & (MTL_QECR4_RES_WR_MASK_7)) | (((0) & (MTL_QECR4_MASK_7)) << 7);\
		v = (v & (MTL_QECR4_RES_WR_MASK_25)) | (((0) & (MTL_QECR4_MASK_25)) << 25);\
		v = ((v & MTL_QECR4_AVALG_WR_MASK) | ((data & MTL_QECR4_AVALG_MASK) << 2));\
		MTL_QECR4_RGWR(v);\
} while (0)

#define MTL_QECR4_AVALG_UDFRD(data) do {\
		MTL_QECR4_RGRD(data);\
		data = ((data >> 2) & MTL_QECR4_AVALG_MASK);\
} while (0)

/*#define MTL_QECR4_CC_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR4_CC_MASK (ULONG)(0x1)

/*#define MTL_QECR4_CC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_QECR4_CC_WR_MASK (ULONG)(0xfffffff7)

#define MTL_QECR4_CC_UDFWR(data) do {\
		ULONG v;\
		MTL_QECR4_RGRD(v);\
		v = (v & (MTL_QECR4_RES_WR_MASK_0)) | (((0) & (MTL_QECR4_MASK_0)) << 0);\
		v = (v & (MTL_QECR4_RES_WR_MASK_7)) | (((0) & (MTL_QECR4_MASK_7)) << 7);\
		v = (v & (MTL_QECR4_RES_WR_MASK_25)) | (((0) & (MTL_QECR4_MASK_25)) << 25);\
		v = ((v & MTL_QECR4_CC_WR_MASK) | ((data & MTL_QECR4_CC_MASK) << 3));\
		MTL_QECR4_RGWR(v);\
} while (0)

#define MTL_QECR4_CC_UDFRD(data) do {\
		MTL_QECR4_RGRD(data);\
		data = ((data >> 3) & MTL_QECR4_CC_MASK);\
} while (0)

/*#define MTL_QECR4_SLC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QECR4_SLC_MASK (ULONG)(0x7)

/*#define MTL_QECR4_SLC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_QECR4_SLC_WR_MASK (ULONG)(0xffffff8f)

#define MTL_QECR4_SLC_UDFWR(data) do {\
		ULONG v;\
		MTL_QECR4_RGRD(v);\
		v = (v & (MTL_QECR4_RES_WR_MASK_0)) | (((0) & (MTL_QECR4_MASK_0)) << 0);\
		v = (v & (MTL_QECR4_RES_WR_MASK_7)) | (((0) & (MTL_QECR4_MASK_7)) << 7);\
		v = (v & (MTL_QECR4_RES_WR_MASK_25)) | (((0) & (MTL_QECR4_MASK_25)) << 25);\
		v = ((v & MTL_QECR4_SLC_WR_MASK) | ((data & MTL_QECR4_SLC_MASK) << 4));\
		MTL_QECR4_RGWR(v);\
} while (0)

#define MTL_QECR4_SLC_UDFRD(data) do {\
		MTL_QECR4_RGRD(data);\
		data = ((data >> 4) & MTL_QECR4_SLC_MASK);\
} while (0)

/*#define MTL_QECR4_ABPSSIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR4_ABPSSIE_MASK (ULONG)(0x1)

/*#define MTL_QECR4_ABPSSIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define MTL_QECR4_ABPSSIE_WR_MASK (ULONG)(0xfeffffff)

#define MTL_QECR4_ABPSSIE_UDFWR(data) do {\
		ULONG v;\
		MTL_QECR4_RGRD(v);\
		v = (v & (MTL_QECR4_RES_WR_MASK_0)) | (((0) & (MTL_QECR4_MASK_0)) << 0);\
		v = (v & (MTL_QECR4_RES_WR_MASK_7)) | (((0) & (MTL_QECR4_MASK_7)) << 7);\
		v = (v & (MTL_QECR4_RES_WR_MASK_25)) | (((0) & (MTL_QECR4_MASK_25)) << 25);\
		v = ((v & MTL_QECR4_ABPSSIE_WR_MASK) | ((data & MTL_QECR4_ABPSSIE_MASK) << 24));\
		MTL_QECR4_RGWR(v);\
} while (0)

#define MTL_QECR4_ABPSSIE_UDFRD(data) do {\
		MTL_QECR4_RGRD(data);\
		data = ((data >> 24) & MTL_QECR4_ABPSSIE_MASK);\
} while (0)

#define MTL_QECR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xdd0))

#define MTL_QECR3_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QECR3_RGOFFADDR);\
} while (0)

#define MTL_QECR3_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QECR3_RGOFFADDR);\
} while (0)

/*#define  MTL_QECR3_Mask_0 (ULONG)(~(~0<<(2)))*/

#define  MTL_QECR3_MASK_0 (ULONG)(0x3)

/*#define MTL_QECR3_RES_Wr_Mask_0 (ULONG)(~((~(~0<<(2)))<<(0)))*/

#define MTL_QECR3_RES_WR_MASK_0 (ULONG)(0xfffffffc)

/*#define  MTL_QECR3_Mask_7 (ULONG)(~(~0<<(17)))*/

#define  MTL_QECR3_MASK_7 (ULONG)(0x1ffff)

/*#define MTL_QECR3_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(17)))<<(7)))*/

#define MTL_QECR3_RES_WR_MASK_7 (ULONG)(0xff00007f)

/*#define  MTL_QECR3_Mask_25 (ULONG)(~(~0<<(7)))*/

#define  MTL_QECR3_MASK_25 (ULONG)(0x7f)

/*#define MTL_QECR3_RES_Wr_Mask_25 (ULONG)(~((~(~0<<(7)))<<(25)))*/

#define MTL_QECR3_RES_WR_MASK_25 (ULONG)(0x1ffffff)

/*#define MTL_QECR3_AVALG_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR3_AVALG_MASK (ULONG)(0x1)

/*#define MTL_QECR3_AVALG_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MTL_QECR3_AVALG_WR_MASK (ULONG)(0xfffffffb)

#define MTL_QECR3_AVALG_UDFWR(data) do {\
		ULONG v;\
		MTL_QECR3_RGRD(v);\
		v = (v & (MTL_QECR3_RES_WR_MASK_0)) | (((0) & (MTL_QECR3_MASK_0)) << 0);\
		v = (v & (MTL_QECR3_RES_WR_MASK_7)) | (((0) & (MTL_QECR3_MASK_7)) << 7);\
		v = (v & (MTL_QECR3_RES_WR_MASK_25)) | (((0) & (MTL_QECR3_MASK_25)) << 25);\
		v = ((v & MTL_QECR3_AVALG_WR_MASK) | ((data & MTL_QECR3_AVALG_MASK) << 2));\
		MTL_QECR3_RGWR(v);\
} while (0)

#define MTL_QECR3_AVALG_UDFRD(data) do {\
		MTL_QECR3_RGRD(data);\
		data = ((data >> 2) & MTL_QECR3_AVALG_MASK);\
} while (0)

/*#define MTL_QECR3_CC_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR3_CC_MASK (ULONG)(0x1)

/*#define MTL_QECR3_CC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_QECR3_CC_WR_MASK (ULONG)(0xfffffff7)

#define MTL_QECR3_CC_UDFWR(data) do {\
		ULONG v;\
		MTL_QECR3_RGRD(v);\
		v = (v & (MTL_QECR3_RES_WR_MASK_0)) | (((0) & (MTL_QECR3_MASK_0)) << 0);\
		v = (v & (MTL_QECR3_RES_WR_MASK_7)) | (((0) & (MTL_QECR3_MASK_7)) << 7);\
		v = (v & (MTL_QECR3_RES_WR_MASK_25)) | (((0) & (MTL_QECR3_MASK_25)) << 25);\
		v = ((v & MTL_QECR3_CC_WR_MASK) | ((data & MTL_QECR3_CC_MASK) << 3));\
		MTL_QECR3_RGWR(v);\
} while (0)

#define MTL_QECR3_CC_UDFRD(data) do {\
		MTL_QECR3_RGRD(data);\
		data = ((data >> 3) & MTL_QECR3_CC_MASK);\
} while (0)

/*#define MTL_QECR3_SLC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QECR3_SLC_MASK (ULONG)(0x7)

/*#define MTL_QECR3_SLC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_QECR3_SLC_WR_MASK (ULONG)(0xffffff8f)

#define MTL_QECR3_SLC_UDFWR(data) do {\
		ULONG v;\
		MTL_QECR3_RGRD(v);\
		v = (v & (MTL_QECR3_RES_WR_MASK_0)) | (((0) & (MTL_QECR3_MASK_0)) << 0);\
		v = (v & (MTL_QECR3_RES_WR_MASK_7)) | (((0) & (MTL_QECR3_MASK_7)) << 7);\
		v = (v & (MTL_QECR3_RES_WR_MASK_25)) | (((0) & (MTL_QECR3_MASK_25)) << 25);\
		v = ((v & MTL_QECR3_SLC_WR_MASK) | ((data & MTL_QECR3_SLC_MASK) << 4));\
		MTL_QECR3_RGWR(v);\
} while (0)

#define MTL_QECR3_SLC_UDFRD(data) do {\
		MTL_QECR3_RGRD(data);\
		data = ((data >> 4) & MTL_QECR3_SLC_MASK);\
} while (0)

/*#define MTL_QECR3_ABPSSIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR3_ABPSSIE_MASK (ULONG)(0x1)

/*#define MTL_QECR3_ABPSSIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define MTL_QECR3_ABPSSIE_WR_MASK (ULONG)(0xfeffffff)

#define MTL_QECR3_ABPSSIE_UDFWR(data) do {\
		ULONG v;\
		MTL_QECR3_RGRD(v);\
		v = (v & (MTL_QECR3_RES_WR_MASK_0)) | (((0) & (MTL_QECR3_MASK_0)) << 0);\
		v = (v & (MTL_QECR3_RES_WR_MASK_7)) | (((0) & (MTL_QECR3_MASK_7)) << 7);\
		v = (v & (MTL_QECR3_RES_WR_MASK_25)) | (((0) & (MTL_QECR3_MASK_25)) << 25);\
		v = ((v & MTL_QECR3_ABPSSIE_WR_MASK) | ((data & MTL_QECR3_ABPSSIE_MASK) << 24));\
		MTL_QECR3_RGWR(v);\
} while (0)

#define MTL_QECR3_ABPSSIE_UDFRD(data) do {\
		MTL_QECR3_RGRD(data);\
		data = ((data >> 24) & MTL_QECR3_ABPSSIE_MASK);\
} while (0)

#define MTL_QECR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd90))

#define MTL_QECR2_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QECR2_RGOFFADDR);\
} while (0)

#define MTL_QECR2_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QECR2_RGOFFADDR);\
} while (0)

/*#define  MTL_QECR2_Mask_0 (ULONG)(~(~0<<(2)))*/

#define  MTL_QECR2_MASK_0 (ULONG)(0x3)

/*#define MTL_QECR2_RES_Wr_Mask_0 (ULONG)(~((~(~0<<(2)))<<(0)))*/

#define MTL_QECR2_RES_WR_MASK_0 (ULONG)(0xfffffffc)

/*#define  MTL_QECR2_Mask_7 (ULONG)(~(~0<<(17)))*/

#define  MTL_QECR2_MASK_7 (ULONG)(0x1ffff)

/*#define MTL_QECR2_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(17)))<<(7)))*/

#define MTL_QECR2_RES_WR_MASK_7 (ULONG)(0xff00007f)

/*#define  MTL_QECR2_Mask_25 (ULONG)(~(~0<<(7)))*/

#define  MTL_QECR2_MASK_25 (ULONG)(0x7f)

/*#define MTL_QECR2_RES_Wr_Mask_25 (ULONG)(~((~(~0<<(7)))<<(25)))*/

#define MTL_QECR2_RES_WR_MASK_25 (ULONG)(0x1ffffff)

/*#define MTL_QECR2_AVALG_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR2_AVALG_MASK (ULONG)(0x1)

/*#define MTL_QECR2_AVALG_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MTL_QECR2_AVALG_WR_MASK (ULONG)(0xfffffffb)

#define MTL_QECR2_AVALG_UDFWR(data) do {\
		ULONG v;\
		MTL_QECR2_RGRD(v);\
		v = (v & (MTL_QECR2_RES_WR_MASK_0)) | (((0) & (MTL_QECR2_MASK_0)) << 0);\
		v = (v & (MTL_QECR2_RES_WR_MASK_7)) | (((0) & (MTL_QECR2_MASK_7)) << 7);\
		v = (v & (MTL_QECR2_RES_WR_MASK_25)) | (((0) & (MTL_QECR2_MASK_25)) << 25);\
		v = ((v & MTL_QECR2_AVALG_WR_MASK) | ((data & MTL_QECR2_AVALG_MASK) << 2));\
		MTL_QECR2_RGWR(v);\
} while (0)

#define MTL_QECR2_AVALG_UDFRD(data) do {\
		MTL_QECR2_RGRD(data);\
		data = ((data >> 2) & MTL_QECR2_AVALG_MASK);\
} while (0)

/*#define MTL_QECR2_CC_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR2_CC_MASK (ULONG)(0x1)

/*#define MTL_QECR2_CC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_QECR2_CC_WR_MASK (ULONG)(0xfffffff7)

#define MTL_QECR2_CC_UDFWR(data) do {\
		ULONG v;\
		MTL_QECR2_RGRD(v);\
		v = (v & (MTL_QECR2_RES_WR_MASK_0)) | (((0) & (MTL_QECR2_MASK_0)) << 0);\
		v = (v & (MTL_QECR2_RES_WR_MASK_7)) | (((0) & (MTL_QECR2_MASK_7)) << 7);\
		v = (v & (MTL_QECR2_RES_WR_MASK_25)) | (((0) & (MTL_QECR2_MASK_25)) << 25);\
		v = ((v & MTL_QECR2_CC_WR_MASK) | ((data & MTL_QECR2_CC_MASK) << 3));\
		MTL_QECR2_RGWR(v);\
} while (0)

#define MTL_QECR2_CC_UDFRD(data) do {\
		MTL_QECR2_RGRD(data);\
		data = ((data >> 3) & MTL_QECR2_CC_MASK);\
} while (0)

/*#define MTL_QECR2_SLC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QECR2_SLC_MASK (ULONG)(0x7)

/*#define MTL_QECR2_SLC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_QECR2_SLC_WR_MASK (ULONG)(0xffffff8f)

#define MTL_QECR2_SLC_UDFWR(data) do {\
		ULONG v;\
		MTL_QECR2_RGRD(v);\
		v = (v & (MTL_QECR2_RES_WR_MASK_0)) | (((0) & (MTL_QECR2_MASK_0)) << 0);\
		v = (v & (MTL_QECR2_RES_WR_MASK_7)) | (((0) & (MTL_QECR2_MASK_7)) << 7);\
		v = (v & (MTL_QECR2_RES_WR_MASK_25)) | (((0) & (MTL_QECR2_MASK_25)) << 25);\
		v = ((v & MTL_QECR2_SLC_WR_MASK) | ((data & MTL_QECR2_SLC_MASK) << 4));\
		MTL_QECR2_RGWR(v);\
} while (0)

#define MTL_QECR2_SLC_UDFRD(data) do {\
		MTL_QECR2_RGRD(data);\
		data = ((data >> 4) & MTL_QECR2_SLC_MASK);\
} while (0)

/*#define MTL_QECR2_ABPSSIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR2_ABPSSIE_MASK (ULONG)(0x1)

/*#define MTL_QECR2_ABPSSIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define MTL_QECR2_ABPSSIE_WR_MASK (ULONG)(0xfeffffff)

#define MTL_QECR2_ABPSSIE_UDFWR(data) do {\
		ULONG v;\
		MTL_QECR2_RGRD(v);\
		v = (v & (MTL_QECR2_RES_WR_MASK_0)) | (((0) & (MTL_QECR2_MASK_0)) << 0);\
		v = (v & (MTL_QECR2_RES_WR_MASK_7)) | (((0) & (MTL_QECR2_MASK_7)) << 7);\
		v = (v & (MTL_QECR2_RES_WR_MASK_25)) | (((0) & (MTL_QECR2_MASK_25)) << 25);\
		v = ((v & MTL_QECR2_ABPSSIE_WR_MASK) | ((data & MTL_QECR2_ABPSSIE_MASK) << 24));\
		MTL_QECR2_RGWR(v);\
} while (0)

#define MTL_QECR2_ABPSSIE_UDFRD(data) do {\
		MTL_QECR2_RGRD(data);\
		data = ((data >> 24) & MTL_QECR2_ABPSSIE_MASK);\
} while (0)

#define MTL_QECR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd50))

#define MTL_QECR1_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QECR1_RGOFFADDR);\
} while (0)

#define MTL_QECR1_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QECR1_RGOFFADDR);\
} while (0)

/*#define  MTL_QECR1_Mask_0 (ULONG)(~(~0<<(2)))*/

#define  MTL_QECR1_MASK_0 (ULONG)(0x3)

/*#define MTL_QECR1_RES_Wr_Mask_0 (ULONG)(~((~(~0<<(2)))<<(0)))*/

#define MTL_QECR1_RES_WR_MASK_0 (ULONG)(0xfffffffc)

/*#define  MTL_QECR1_Mask_7 (ULONG)(~(~0<<(17)))*/

#define  MTL_QECR1_MASK_7 (ULONG)(0x1ffff)

/*#define MTL_QECR1_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(17)))<<(7)))*/

#define MTL_QECR1_RES_WR_MASK_7 (ULONG)(0xff00007f)

/*#define  MTL_QECR1_Mask_25 (ULONG)(~(~0<<(7)))*/

#define  MTL_QECR1_MASK_25 (ULONG)(0x7f)

/*#define MTL_QECR1_RES_Wr_Mask_25 (ULONG)(~((~(~0<<(7)))<<(25)))*/

#define MTL_QECR1_RES_WR_MASK_25 (ULONG)(0x1ffffff)

/*#define MTL_QECR1_AVALG_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR1_AVALG_MASK (ULONG)(0x1)

/*#define MTL_QECR1_AVALG_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MTL_QECR1_AVALG_WR_MASK (ULONG)(0xfffffffb)

#define MTL_QECR1_AVALG_UDFWR(data) do {\
		ULONG v;\
		MTL_QECR1_RGRD(v);\
		v = (v & (MTL_QECR1_RES_WR_MASK_0)) | (((0) & (MTL_QECR1_MASK_0)) << 0);\
		v = (v & (MTL_QECR1_RES_WR_MASK_7)) | (((0) & (MTL_QECR1_MASK_7)) << 7);\
		v = (v & (MTL_QECR1_RES_WR_MASK_25)) | (((0) & (MTL_QECR1_MASK_25)) << 25);\
		v = ((v & MTL_QECR1_AVALG_WR_MASK) | ((data & MTL_QECR1_AVALG_MASK) << 2));\
		MTL_QECR1_RGWR(v);\
} while (0)

#define MTL_QECR1_AVALG_UDFRD(data) do {\
		MTL_QECR1_RGRD(data);\
		data = ((data >> 2) & MTL_QECR1_AVALG_MASK);\
} while (0)

/*#define MTL_QECR1_CC_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR1_CC_MASK (ULONG)(0x1)

/*#define MTL_QECR1_CC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_QECR1_CC_WR_MASK (ULONG)(0xfffffff7)

#define MTL_QECR1_CC_UDFWR(data) do {\
		ULONG v;\
		MTL_QECR1_RGRD(v);\
		v = (v & (MTL_QECR1_RES_WR_MASK_0)) | (((0) & (MTL_QECR1_MASK_0)) << 0);\
		v = (v & (MTL_QECR1_RES_WR_MASK_7)) | (((0) & (MTL_QECR1_MASK_7)) << 7);\
		v = (v & (MTL_QECR1_RES_WR_MASK_25)) | (((0) & (MTL_QECR1_MASK_25)) << 25);\
		v = ((v & MTL_QECR1_CC_WR_MASK) | ((data & MTL_QECR1_CC_MASK) << 3));\
		MTL_QECR1_RGWR(v);\
} while (0)

#define MTL_QECR1_CC_UDFRD(data) do {\
		MTL_QECR1_RGRD(data);\
		data = ((data >> 3) & MTL_QECR1_CC_MASK);\
} while (0)

/*#define MTL_QECR1_SLC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QECR1_SLC_MASK (ULONG)(0x7)

/*#define MTL_QECR1_SLC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_QECR1_SLC_WR_MASK (ULONG)(0xffffff8f)

#define MTL_QECR1_SLC_UDFWR(data) do {\
		ULONG v;\
		MTL_QECR1_RGRD(v);\
		v = (v & (MTL_QECR1_RES_WR_MASK_0)) | (((0) & (MTL_QECR1_MASK_0)) << 0);\
		v = (v & (MTL_QECR1_RES_WR_MASK_7)) | (((0) & (MTL_QECR1_MASK_7)) << 7);\
		v = (v & (MTL_QECR1_RES_WR_MASK_25)) | (((0) & (MTL_QECR1_MASK_25)) << 25);\
		v = ((v & MTL_QECR1_SLC_WR_MASK) | ((data & MTL_QECR1_SLC_MASK) << 4));\
		MTL_QECR1_RGWR(v);\
} while (0)

#define MTL_QECR1_SLC_UDFRD(data) do {\
		MTL_QECR1_RGRD(data);\
		data = ((data >> 4) & MTL_QECR1_SLC_MASK);\
} while (0)

/*#define MTL_QECR1_ABPSSIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR1_ABPSSIE_MASK (ULONG)(0x1)

/*#define MTL_QECR1_ABPSSIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define MTL_QECR1_ABPSSIE_WR_MASK (ULONG)(0xfeffffff)

#define MTL_QECR1_ABPSSIE_UDFWR(data) do {\
		ULONG v;\
		MTL_QECR1_RGRD(v);\
		v = (v & (MTL_QECR1_RES_WR_MASK_0)) | (((0) & (MTL_QECR1_MASK_0)) << 0);\
		v = (v & (MTL_QECR1_RES_WR_MASK_7)) | (((0) & (MTL_QECR1_MASK_7)) << 7);\
		v = (v & (MTL_QECR1_RES_WR_MASK_25)) | (((0) & (MTL_QECR1_MASK_25)) << 25);\
		v = ((v & MTL_QECR1_ABPSSIE_WR_MASK) | ((data & MTL_QECR1_ABPSSIE_MASK) << 24));\
		MTL_QECR1_RGWR(v);\
} while (0)

#define MTL_QECR1_ABPSSIE_UDFRD(data) do {\
		MTL_QECR1_RGRD(data);\
		data = ((data >> 24) & MTL_QECR1_ABPSSIE_MASK);\
} while (0)

#define MTL_QTDR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xec8))

#define MTL_QTDR7_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QTDR7_RGOFFADDR);\
} while (0)

/*#define MTL_QTDR7_TXQPAUSED_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR7_TXQPAUSED_MASK (ULONG)(0x1)

#define MTL_QTDR7_TXQPAUSED_UDFRD(data) do {\
		MTL_QTDR7_RGRD(data);\
		data = ((data >> 0) & MTL_QTDR7_TXQPAUSED_MASK);\
} while (0)

/*#define MTL_QTDR7_TRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QTDR7_TRCSTS_MASK (ULONG)(0x3)

#define MTL_QTDR7_TRCSTS_UDFRD(data) do {\
		MTL_QTDR7_RGRD(data);\
		data = ((data >> 1) & MTL_QTDR7_TRCSTS_MASK);\
} while (0)

/*#define MTL_QTDR7_TWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR7_TWCSTS_MASK (ULONG)(0x1)

#define MTL_QTDR7_TWCSTS_UDFRD(data) do {\
		MTL_QTDR7_RGRD(data);\
		data = ((data >> 3) & MTL_QTDR7_TWCSTS_MASK);\
} while (0)

/*#define MTL_QTDR7_TXQSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR7_TXQSTS_MASK (ULONG)(0x1)

#define MTL_QTDR7_TXQSTS_UDFRD(data) do {\
		MTL_QTDR7_RGRD(data);\
		data = ((data >> 4) & MTL_QTDR7_TXQSTS_MASK);\
} while (0)

/*#define MTL_QTDR7_TXSTSFSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR7_TXSTSFSTS_MASK (ULONG)(0x1)

#define MTL_QTDR7_TXSTSFSTS_UDFRD(data) do {\
		MTL_QTDR7_RGRD(data);\
		data = ((data >> 5) & MTL_QTDR7_TXSTSFSTS_MASK);\
} while (0)

/*#define MTL_QTDR7_PTXQ_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTDR7_PTXQ_MASK (ULONG)(0x7)

#define MTL_QTDR7_PTXQ_UDFRD(data) do {\
		MTL_QTDR7_RGRD(data);\
		data = ((data >> 16) & MTL_QTDR7_PTXQ_MASK);\
} while (0)

/*#define MTL_QTDR7_STXSTSF_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTDR7_STXSTSF_MASK (ULONG)(0x7)

#define MTL_QTDR7_STXSTSF_UDFRD(data) do {\
		MTL_QTDR7_RGRD(data);\
		data = ((data >> 20) & MTL_QTDR7_STXSTSF_MASK);\
} while (0)

#define MTL_QTDR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe88))

#define MTL_QTDR6_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QTDR6_RGOFFADDR);\
} while (0)

/*#define MTL_QTDR6_TXQPAUSED_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR6_TXQPAUSED_MASK (ULONG)(0x1)

#define MTL_QTDR6_TXQPAUSED_UDFRD(data) do {\
		MTL_QTDR6_RGRD(data);\
		data = ((data >> 0) & MTL_QTDR6_TXQPAUSED_MASK);\
} while (0)

/*#define MTL_QTDR6_TRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QTDR6_TRCSTS_MASK (ULONG)(0x3)

#define MTL_QTDR6_TRCSTS_UDFRD(data) do {\
		MTL_QTDR6_RGRD(data);\
		data = ((data >> 1) & MTL_QTDR6_TRCSTS_MASK);\
} while (0)

/*#define MTL_QTDR6_TWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR6_TWCSTS_MASK (ULONG)(0x1)

#define MTL_QTDR6_TWCSTS_UDFRD(data) do {\
		MTL_QTDR6_RGRD(data);\
		data = ((data >> 3) & MTL_QTDR6_TWCSTS_MASK);\
} while (0)

/*#define MTL_QTDR6_TXQSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR6_TXQSTS_MASK (ULONG)(0x1)

#define MTL_QTDR6_TXQSTS_UDFRD(data) do {\
		MTL_QTDR6_RGRD(data);\
		data = ((data >> 4) & MTL_QTDR6_TXQSTS_MASK);\
} while (0)

/*#define MTL_QTDR6_TXSTSFSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR6_TXSTSFSTS_MASK (ULONG)(0x1)

#define MTL_QTDR6_TXSTSFSTS_UDFRD(data) do {\
		MTL_QTDR6_RGRD(data);\
		data = ((data >> 5) & MTL_QTDR6_TXSTSFSTS_MASK);\
} while (0)

/*#define MTL_QTDR6_PTXQ_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTDR6_PTXQ_MASK (ULONG)(0x7)

#define MTL_QTDR6_PTXQ_UDFRD(data) do {\
		MTL_QTDR6_RGRD(data);\
		data = ((data >> 16) & MTL_QTDR6_PTXQ_MASK);\
} while (0)

/*#define MTL_QTDR6_STXSTSF_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTDR6_STXSTSF_MASK (ULONG)(0x7)

#define MTL_QTDR6_STXSTSF_UDFRD(data) do {\
		MTL_QTDR6_RGRD(data);\
		data = ((data >> 20) & MTL_QTDR6_STXSTSF_MASK);\
} while (0)

#define MTL_QTDR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe48))

#define MTL_QTDR5_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QTDR5_RGOFFADDR);\
} while (0)

/*#define MTL_QTDR5_TXQPAUSED_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR5_TXQPAUSED_MASK (ULONG)(0x1)

#define MTL_QTDR5_TXQPAUSED_UDFRD(data) do {\
		MTL_QTDR5_RGRD(data);\
		data = ((data >> 0) & MTL_QTDR5_TXQPAUSED_MASK);\
} while (0)

/*#define MTL_QTDR5_TRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QTDR5_TRCSTS_MASK (ULONG)(0x3)

#define MTL_QTDR5_TRCSTS_UDFRD(data) do {\
		MTL_QTDR5_RGRD(data);\
		data = ((data >> 1) & MTL_QTDR5_TRCSTS_MASK);\
} while (0)

/*#define MTL_QTDR5_TWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR5_TWCSTS_MASK (ULONG)(0x1)

#define MTL_QTDR5_TWCSTS_UDFRD(data) do {\
		MTL_QTDR5_RGRD(data);\
		data = ((data >> 3) & MTL_QTDR5_TWCSTS_MASK);\
} while (0)

/*#define MTL_QTDR5_TXQSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR5_TXQSTS_MASK (ULONG)(0x1)

#define MTL_QTDR5_TXQSTS_UDFRD(data) do {\
		MTL_QTDR5_RGRD(data);\
		data = ((data >> 4) & MTL_QTDR5_TXQSTS_MASK);\
} while (0)

/*#define MTL_QTDR5_TXSTSFSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR5_TXSTSFSTS_MASK (ULONG)(0x1)

#define MTL_QTDR5_TXSTSFSTS_UDFRD(data) do {\
		MTL_QTDR5_RGRD(data);\
		data = ((data >> 5) & MTL_QTDR5_TXSTSFSTS_MASK);\
} while (0)

/*#define MTL_QTDR5_PTXQ_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTDR5_PTXQ_MASK (ULONG)(0x7)

#define MTL_QTDR5_PTXQ_UDFRD(data) do {\
		MTL_QTDR5_RGRD(data);\
		data = ((data >> 16) & MTL_QTDR5_PTXQ_MASK);\
} while (0)

/*#define MTL_QTDR5_STXSTSF_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTDR5_STXSTSF_MASK (ULONG)(0x7)

#define MTL_QTDR5_STXSTSF_UDFRD(data) do {\
		MTL_QTDR5_RGRD(data);\
		data = ((data >> 20) & MTL_QTDR5_STXSTSF_MASK);\
} while (0)

#define MTL_QTDR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe08))

#define MTL_QTDR4_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QTDR4_RGOFFADDR);\
} while (0)

/*#define MTL_QTDR4_TXQPAUSED_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR4_TXQPAUSED_MASK (ULONG)(0x1)

#define MTL_QTDR4_TXQPAUSED_UDFRD(data) do {\
		MTL_QTDR4_RGRD(data);\
		data = ((data >> 0) & MTL_QTDR4_TXQPAUSED_MASK);\
} while (0)

/*#define MTL_QTDR4_TRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QTDR4_TRCSTS_MASK (ULONG)(0x3)

#define MTL_QTDR4_TRCSTS_UDFRD(data) do {\
		MTL_QTDR4_RGRD(data);\
		data = ((data >> 1) & MTL_QTDR4_TRCSTS_MASK);\
} while (0)

/*#define MTL_QTDR4_TWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR4_TWCSTS_MASK (ULONG)(0x1)

#define MTL_QTDR4_TWCSTS_UDFRD(data) do {\
		MTL_QTDR4_RGRD(data);\
		data = ((data >> 3) & MTL_QTDR4_TWCSTS_MASK);\
} while (0)

/*#define MTL_QTDR4_TXQSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR4_TXQSTS_MASK (ULONG)(0x1)

#define MTL_QTDR4_TXQSTS_UDFRD(data) do {\
		MTL_QTDR4_RGRD(data);\
		data = ((data >> 4) & MTL_QTDR4_TXQSTS_MASK);\
} while (0)

/*#define MTL_QTDR4_TXSTSFSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR4_TXSTSFSTS_MASK (ULONG)(0x1)

#define MTL_QTDR4_TXSTSFSTS_UDFRD(data) do {\
		MTL_QTDR4_RGRD(data);\
		data = ((data >> 5) & MTL_QTDR4_TXSTSFSTS_MASK);\
} while (0)

/*#define MTL_QTDR4_PTXQ_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTDR4_PTXQ_MASK (ULONG)(0x7)

#define MTL_QTDR4_PTXQ_UDFRD(data) do {\
		MTL_QTDR4_RGRD(data);\
		data = ((data >> 16) & MTL_QTDR4_PTXQ_MASK);\
} while (0)

/*#define MTL_QTDR4_STXSTSF_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTDR4_STXSTSF_MASK (ULONG)(0x7)

#define MTL_QTDR4_STXSTSF_UDFRD(data) do {\
		MTL_QTDR4_RGRD(data);\
		data = ((data >> 20) & MTL_QTDR4_STXSTSF_MASK);\
} while (0)

#define MTL_QTDR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xdc8))

#define MTL_QTDR3_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QTDR3_RGOFFADDR);\
} while (0)

/*#define MTL_QTDR3_TXQPAUSED_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR3_TXQPAUSED_MASK (ULONG)(0x1)

#define MTL_QTDR3_TXQPAUSED_UDFRD(data) do {\
		MTL_QTDR3_RGRD(data);\
		data = ((data >> 0) & MTL_QTDR3_TXQPAUSED_MASK);\
} while (0)

/*#define MTL_QTDR3_TRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QTDR3_TRCSTS_MASK (ULONG)(0x3)

#define MTL_QTDR3_TRCSTS_UDFRD(data) do {\
		MTL_QTDR3_RGRD(data);\
		data = ((data >> 1) & MTL_QTDR3_TRCSTS_MASK);\
} while (0)

/*#define MTL_QTDR3_TWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR3_TWCSTS_MASK (ULONG)(0x1)

#define MTL_QTDR3_TWCSTS_UDFRD(data) do {\
		MTL_QTDR3_RGRD(data);\
		data = ((data >> 3) & MTL_QTDR3_TWCSTS_MASK);\
} while (0)

/*#define MTL_QTDR3_TXQSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR3_TXQSTS_MASK (ULONG)(0x1)

#define MTL_QTDR3_TXQSTS_UDFRD(data) do {\
		MTL_QTDR3_RGRD(data);\
		data = ((data >> 4) & MTL_QTDR3_TXQSTS_MASK);\
} while (0)

/*#define MTL_QTDR3_TXSTSFSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR3_TXSTSFSTS_MASK (ULONG)(0x1)

#define MTL_QTDR3_TXSTSFSTS_UDFRD(data) do {\
		MTL_QTDR3_RGRD(data);\
		data = ((data >> 5) & MTL_QTDR3_TXSTSFSTS_MASK);\
} while (0)

/*#define MTL_QTDR3_PTXQ_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTDR3_PTXQ_MASK (ULONG)(0x7)

#define MTL_QTDR3_PTXQ_UDFRD(data) do {\
		MTL_QTDR3_RGRD(data);\
		data = ((data >> 16) & MTL_QTDR3_PTXQ_MASK);\
} while (0)

/*#define MTL_QTDR3_STXSTSF_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTDR3_STXSTSF_MASK (ULONG)(0x7)

#define MTL_QTDR3_STXSTSF_UDFRD(data) do {\
		MTL_QTDR3_RGRD(data);\
		data = ((data >> 20) & MTL_QTDR3_STXSTSF_MASK);\
} while (0)

#define MTL_QTDR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd88))

#define MTL_QTDR2_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QTDR2_RGOFFADDR);\
} while (0)

/*#define MTL_QTDR2_TXQPAUSED_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR2_TXQPAUSED_MASK (ULONG)(0x1)

#define MTL_QTDR2_TXQPAUSED_UDFRD(data) do {\
		MTL_QTDR2_RGRD(data);\
		data = ((data >> 0) & MTL_QTDR2_TXQPAUSED_MASK);\
} while (0)

/*#define MTL_QTDR2_TRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QTDR2_TRCSTS_MASK (ULONG)(0x3)

#define MTL_QTDR2_TRCSTS_UDFRD(data) do {\
		MTL_QTDR2_RGRD(data);\
		data = ((data >> 1) & MTL_QTDR2_TRCSTS_MASK);\
} while (0)

/*#define MTL_QTDR2_TWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR2_TWCSTS_MASK (ULONG)(0x1)

#define MTL_QTDR2_TWCSTS_UDFRD(data) do {\
		MTL_QTDR2_RGRD(data);\
		data = ((data >> 3) & MTL_QTDR2_TWCSTS_MASK);\
} while (0)

/*#define MTL_QTDR2_TXQSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR2_TXQSTS_MASK (ULONG)(0x1)

#define MTL_QTDR2_TXQSTS_UDFRD(data) do {\
		MTL_QTDR2_RGRD(data);\
		data = ((data >> 4) & MTL_QTDR2_TXQSTS_MASK);\
} while (0)

/*#define MTL_QTDR2_TXSTSFSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR2_TXSTSFSTS_MASK (ULONG)(0x1)

#define MTL_QTDR2_TXSTSFSTS_UDFRD(data) do {\
		MTL_QTDR2_RGRD(data);\
		data = ((data >> 5) & MTL_QTDR2_TXSTSFSTS_MASK);\
} while (0)

/*#define MTL_QTDR2_PTXQ_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTDR2_PTXQ_MASK (ULONG)(0x7)

#define MTL_QTDR2_PTXQ_UDFRD(data) do {\
		MTL_QTDR2_RGRD(data);\
		data = ((data >> 16) & MTL_QTDR2_PTXQ_MASK);\
} while (0)

/*#define MTL_QTDR2_STXSTSF_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTDR2_STXSTSF_MASK (ULONG)(0x7)

#define MTL_QTDR2_STXSTSF_UDFRD(data) do {\
		MTL_QTDR2_RGRD(data);\
		data = ((data >> 20) & MTL_QTDR2_STXSTSF_MASK);\
} while (0)

#define MTL_QTDR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd48))

#define MTL_QTDR1_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QTDR1_RGOFFADDR);\
} while (0)

/*#define MTL_QTDR1_TXQPAUSED_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR1_TXQPAUSED_MASK (ULONG)(0x1)

#define MTL_QTDR1_TXQPAUSED_UDFRD(data) do {\
		MTL_QTDR1_RGRD(data);\
		data = ((data >> 0) & MTL_QTDR1_TXQPAUSED_MASK);\
} while (0)

/*#define MTL_QTDR1_TRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QTDR1_TRCSTS_MASK (ULONG)(0x3)

#define MTL_QTDR1_TRCSTS_UDFRD(data) do {\
		MTL_QTDR1_RGRD(data);\
		data = ((data >> 1) & MTL_QTDR1_TRCSTS_MASK);\
} while (0)

/*#define MTL_QTDR1_TWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR1_TWCSTS_MASK (ULONG)(0x1)

#define MTL_QTDR1_TWCSTS_UDFRD(data) do {\
		MTL_QTDR1_RGRD(data);\
		data = ((data >> 3) & MTL_QTDR1_TWCSTS_MASK);\
} while (0)

/*#define MTL_QTDR1_TXQSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR1_TXQSTS_MASK (ULONG)(0x1)

#define MTL_QTDR1_TXQSTS_UDFRD(data) do {\
		MTL_QTDR1_RGRD(data);\
		data = ((data >> 4) & MTL_QTDR1_TXQSTS_MASK);\
} while (0)

/*#define MTL_QTDR1_TXSTSFSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR1_TXSTSFSTS_MASK (ULONG)(0x1)

#define MTL_QTDR1_TXSTSFSTS_UDFRD(data) do {\
		MTL_QTDR1_RGRD(data);\
		data = ((data >> 5) & MTL_QTDR1_TXSTSFSTS_MASK);\
} while (0)

/*#define MTL_QTDR1_PTXQ_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTDR1_PTXQ_MASK (ULONG)(0x7)

#define MTL_QTDR1_PTXQ_UDFRD(data) do {\
		MTL_QTDR1_RGRD(data);\
		data = ((data >> 16) & MTL_QTDR1_PTXQ_MASK);\
} while (0)

/*#define MTL_QTDR1_STXSTSF_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTDR1_STXSTSF_MASK (ULONG)(0x7)

#define MTL_QTDR1_STXSTSF_UDFRD(data) do {\
		MTL_QTDR1_RGRD(data);\
		data = ((data >> 20) & MTL_QTDR1_STXSTSF_MASK);\
} while (0)

#define MTL_QUCR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xec4))

#define MTL_QUCR7_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QUCR7_RGOFFADDR);\
} while (0)

#define MTL_QUCR7_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QUCR7_RGOFFADDR);\
} while (0)

/*#define  MTL_QUCR7_Mask_12 (ULONG)(~(~0<<(20)))*/

#define  MTL_QUCR7_MASK_12 (ULONG)(0xfffff)

/*#define MTL_QUCR7_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(20)))<<(12)))*/

#define MTL_QUCR7_RES_WR_MASK_12 (ULONG)(0xfff)

/*#define MTL_QUCR7_UFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QUCR7_UFPKTCNT_MASK (ULONG)(0x7ff)

/*#define MTL_QUCR7_UFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_QUCR7_UFPKTCNT_WR_MASK (ULONG)(0xfffff800)

#define MTL_QUCR7_UFPKTCNT_UDFWR(data) do {\
		ULONG v;\
		MTL_QUCR7_RGRD(v);\
		v = (v & (MTL_QUCR7_RES_WR_MASK_12)) | (((0) & (MTL_QUCR7_MASK_12)) << 12);\
		v = ((v & MTL_QUCR7_UFPKTCNT_WR_MASK) | ((data & MTL_QUCR7_UFPKTCNT_MASK) << 0));\
		MTL_QUCR7_RGWR(v);\
} while (0)

#define MTL_QUCR7_UFPKTCNT_UDFRD(data) do {\
		MTL_QUCR7_RGRD(data);\
		data = ((data >> 0) & MTL_QUCR7_UFPKTCNT_MASK);\
} while (0)

/*#define MTL_QUCR7_UFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QUCR7_UFCNTOVF_MASK (ULONG)(0x1)

#define MTL_QUCR7_UFCNTOVF_UDFRD(data) do {\
		MTL_QUCR7_RGRD(data);\
		data = ((data >> 11) & MTL_QUCR7_UFCNTOVF_MASK);\
} while (0)

#define MTL_QUCR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe84))

#define MTL_QUCR6_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QUCR6_RGOFFADDR);\
} while (0)

#define MTL_QUCR6_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QUCR6_RGOFFADDR);\
} while (0)

/*#define  MTL_QUCR6_Mask_12 (ULONG)(~(~0<<(20)))*/

#define  MTL_QUCR6_MASK_12 (ULONG)(0xfffff)

/*#define MTL_QUCR6_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(20)))<<(12)))*/

#define MTL_QUCR6_RES_WR_MASK_12 (ULONG)(0xfff)

/*#define MTL_QUCR6_UFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QUCR6_UFPKTCNT_MASK (ULONG)(0x7ff)

/*#define MTL_QUCR6_UFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_QUCR6_UFPKTCNT_WR_MASK (ULONG)(0xfffff800)

#define MTL_QUCR6_UFPKTCNT_UDFWR(data) do {\
		ULONG v;\
		MTL_QUCR6_RGRD(v);\
		v = (v & (MTL_QUCR6_RES_WR_MASK_12)) | (((0) & (MTL_QUCR6_MASK_12)) << 12);\
		v = ((v & MTL_QUCR6_UFPKTCNT_WR_MASK) | ((data & MTL_QUCR6_UFPKTCNT_MASK) << 0));\
		MTL_QUCR6_RGWR(v);\
} while (0)

#define MTL_QUCR6_UFPKTCNT_UDFRD(data) do {\
		MTL_QUCR6_RGRD(data);\
		data = ((data >> 0) & MTL_QUCR6_UFPKTCNT_MASK);\
} while (0)

/*#define MTL_QUCR6_UFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QUCR6_UFCNTOVF_MASK (ULONG)(0x1)

#define MTL_QUCR6_UFCNTOVF_UDFRD(data) do {\
		MTL_QUCR6_RGRD(data);\
		data = ((data >> 11) & MTL_QUCR6_UFCNTOVF_MASK);\
} while (0)

#define MTL_QUCR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe44))

#define MTL_QUCR5_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QUCR5_RGOFFADDR);\
} while (0)

#define MTL_QUCR5_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QUCR5_RGOFFADDR);\
} while (0)

/*#define  MTL_QUCR5_Mask_12 (ULONG)(~(~0<<(20)))*/

#define  MTL_QUCR5_MASK_12 (ULONG)(0xfffff)

/*#define MTL_QUCR5_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(20)))<<(12)))*/

#define MTL_QUCR5_RES_WR_MASK_12 (ULONG)(0xfff)

/*#define MTL_QUCR5_UFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QUCR5_UFPKTCNT_MASK (ULONG)(0x7ff)

/*#define MTL_QUCR5_UFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_QUCR5_UFPKTCNT_WR_MASK (ULONG)(0xfffff800)

#define MTL_QUCR5_UFPKTCNT_UDFWR(data) do {\
		ULONG v;\
		MTL_QUCR5_RGRD(v);\
		v = (v & (MTL_QUCR5_RES_WR_MASK_12)) | (((0) & (MTL_QUCR5_MASK_12)) << 12);\
		v = ((v & MTL_QUCR5_UFPKTCNT_WR_MASK) | ((data & MTL_QUCR5_UFPKTCNT_MASK) << 0));\
		MTL_QUCR5_RGWR(v);\
} while (0)

#define MTL_QUCR5_UFPKTCNT_UDFRD(data) do {\
		MTL_QUCR5_RGRD(data);\
		data = ((data >> 0) & MTL_QUCR5_UFPKTCNT_MASK);\
} while (0)

/*#define MTL_QUCR5_UFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QUCR5_UFCNTOVF_MASK (ULONG)(0x1)

#define MTL_QUCR5_UFCNTOVF_UDFRD(data) do {\
		MTL_QUCR5_RGRD(data);\
		data = ((data >> 11) & MTL_QUCR5_UFCNTOVF_MASK);\
} while (0)

#define MTL_QUCR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe04))

#define MTL_QUCR4_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QUCR4_RGOFFADDR);\
} while (0)

#define MTL_QUCR4_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QUCR4_RGOFFADDR);\
} while (0)

/*#define  MTL_QUCR4_Mask_12 (ULONG)(~(~0<<(20)))*/

#define  MTL_QUCR4_MASK_12 (ULONG)(0xfffff)

/*#define MTL_QUCR4_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(20)))<<(12)))*/

#define MTL_QUCR4_RES_WR_MASK_12 (ULONG)(0xfff)

/*#define MTL_QUCR4_UFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QUCR4_UFPKTCNT_MASK (ULONG)(0x7ff)

/*#define MTL_QUCR4_UFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_QUCR4_UFPKTCNT_WR_MASK (ULONG)(0xfffff800)

#define MTL_QUCR4_UFPKTCNT_UDFWR(data) do {\
		ULONG v;\
		MTL_QUCR4_RGRD(v);\
		v = (v & (MTL_QUCR4_RES_WR_MASK_12)) | (((0) & (MTL_QUCR4_MASK_12)) << 12);\
		v = ((v & MTL_QUCR4_UFPKTCNT_WR_MASK) | ((data & MTL_QUCR4_UFPKTCNT_MASK) << 0));\
		MTL_QUCR4_RGWR(v);\
} while (0)

#define MTL_QUCR4_UFPKTCNT_UDFRD(data) do {\
		MTL_QUCR4_RGRD(data);\
		data = ((data >> 0) & MTL_QUCR4_UFPKTCNT_MASK);\
} while (0)

/*#define MTL_QUCR4_UFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QUCR4_UFCNTOVF_MASK (ULONG)(0x1)

#define MTL_QUCR4_UFCNTOVF_UDFRD(data) do {\
		MTL_QUCR4_RGRD(data);\
		data = ((data >> 11) & MTL_QUCR4_UFCNTOVF_MASK);\
} while (0)

#define MTL_QUCR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xdc4))

#define MTL_QUCR3_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QUCR3_RGOFFADDR);\
} while (0)

#define MTL_QUCR3_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QUCR3_RGOFFADDR);\
} while (0)

/*#define  MTL_QUCR3_Mask_12 (ULONG)(~(~0<<(20)))*/

#define  MTL_QUCR3_MASK_12 (ULONG)(0xfffff)

/*#define MTL_QUCR3_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(20)))<<(12)))*/

#define MTL_QUCR3_RES_WR_MASK_12 (ULONG)(0xfff)

/*#define MTL_QUCR3_UFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QUCR3_UFPKTCNT_MASK (ULONG)(0x7ff)

/*#define MTL_QUCR3_UFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_QUCR3_UFPKTCNT_WR_MASK (ULONG)(0xfffff800)

#define MTL_QUCR3_UFPKTCNT_UDFWR(data) do {\
		ULONG v;\
		MTL_QUCR3_RGRD(v);\
		v = (v & (MTL_QUCR3_RES_WR_MASK_12)) | (((0) & (MTL_QUCR3_MASK_12)) << 12);\
		v = ((v & MTL_QUCR3_UFPKTCNT_WR_MASK) | ((data & MTL_QUCR3_UFPKTCNT_MASK) << 0));\
		MTL_QUCR3_RGWR(v);\
} while (0)

#define MTL_QUCR3_UFPKTCNT_UDFRD(data) do {\
		MTL_QUCR3_RGRD(data);\
		data = ((data >> 0) & MTL_QUCR3_UFPKTCNT_MASK);\
} while (0)

/*#define MTL_QUCR3_UFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QUCR3_UFCNTOVF_MASK (ULONG)(0x1)

#define MTL_QUCR3_UFCNTOVF_UDFRD(data) do {\
		MTL_QUCR3_RGRD(data);\
		data = ((data >> 11) & MTL_QUCR3_UFCNTOVF_MASK);\
} while (0)

#define MTL_QUCR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd84))

#define MTL_QUCR2_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QUCR2_RGOFFADDR);\
} while (0)

#define MTL_QUCR2_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QUCR2_RGOFFADDR);\
} while (0)

/*#define  MTL_QUCR2_Mask_12 (ULONG)(~(~0<<(20)))*/

#define  MTL_QUCR2_MASK_12 (ULONG)(0xfffff)

/*#define MTL_QUCR2_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(20)))<<(12)))*/

#define MTL_QUCR2_RES_WR_MASK_12 (ULONG)(0xfff)

/*#define MTL_QUCR2_UFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QUCR2_UFPKTCNT_MASK (ULONG)(0x7ff)

/*#define MTL_QUCR2_UFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_QUCR2_UFPKTCNT_WR_MASK (ULONG)(0xfffff800)

#define MTL_QUCR2_UFPKTCNT_UDFWR(data) do {\
		ULONG v;\
		MTL_QUCR2_RGRD(v);\
		v = (v & (MTL_QUCR2_RES_WR_MASK_12)) | (((0) & (MTL_QUCR2_MASK_12)) << 12);\
		v = ((v & MTL_QUCR2_UFPKTCNT_WR_MASK) | ((data & MTL_QUCR2_UFPKTCNT_MASK) << 0));\
		MTL_QUCR2_RGWR(v);\
} while (0)

#define MTL_QUCR2_UFPKTCNT_UDFRD(data) do {\
		MTL_QUCR2_RGRD(data);\
		data = ((data >> 0) & MTL_QUCR2_UFPKTCNT_MASK);\
} while (0)

/*#define MTL_QUCR2_UFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QUCR2_UFCNTOVF_MASK (ULONG)(0x1)

#define MTL_QUCR2_UFCNTOVF_UDFRD(data) do {\
		MTL_QUCR2_RGRD(data);\
		data = ((data >> 11) & MTL_QUCR2_UFCNTOVF_MASK);\
} while (0)

#define MTL_QUCR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd44))

#define MTL_QUCR1_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QUCR1_RGOFFADDR);\
} while (0)

#define MTL_QUCR1_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QUCR1_RGOFFADDR);\
} while (0)

/*#define  MTL_QUCR1_Mask_12 (ULONG)(~(~0<<(20)))*/

#define  MTL_QUCR1_MASK_12 (ULONG)(0xfffff)

/*#define MTL_QUCR1_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(20)))<<(12)))*/

#define MTL_QUCR1_RES_WR_MASK_12 (ULONG)(0xfff)

/*#define MTL_QUCR1_UFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QUCR1_UFPKTCNT_MASK (ULONG)(0x7ff)

/*#define MTL_QUCR1_UFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_QUCR1_UFPKTCNT_WR_MASK (ULONG)(0xfffff800)

#define MTL_QUCR1_UFPKTCNT_UDFWR(data) do {\
		ULONG v;\
		MTL_QUCR1_RGRD(v);\
		v = (v & (MTL_QUCR1_RES_WR_MASK_12)) | (((0) & (MTL_QUCR1_MASK_12)) << 12);\
		v = ((v & MTL_QUCR1_UFPKTCNT_WR_MASK) | ((data & MTL_QUCR1_UFPKTCNT_MASK) << 0));\
		MTL_QUCR1_RGWR(v);\
} while (0)

#define MTL_QUCR1_UFPKTCNT_UDFRD(data) do {\
		MTL_QUCR1_RGRD(data);\
		data = ((data >> 0) & MTL_QUCR1_UFPKTCNT_MASK);\
} while (0)

/*#define MTL_QUCR1_UFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QUCR1_UFCNTOVF_MASK (ULONG)(0x1)

#define MTL_QUCR1_UFCNTOVF_UDFRD(data) do {\
		MTL_QUCR1_RGRD(data);\
		data = ((data >> 11) & MTL_QUCR1_UFCNTOVF_MASK);\
} while (0)

#define MTL_QTOMR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xec0))

#define MTL_QTOMR7_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QTOMR7_RGOFFADDR);\
} while (0)

#define MTL_QTOMR7_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QTOMR7_RGOFFADDR);\
} while (0)

/*#define  MTL_QTOMR7_Mask_7 (ULONG)(~(~0<<(9)))*/

#define  MTL_QTOMR7_MASK_7 (ULONG)(0x1ff)

/*#define MTL_QTOMR7_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(9)))<<(7)))*/

#define MTL_QTOMR7_RES_WR_MASK_7 (ULONG)(0xffff007f)

/*#define  MTL_QTOMR7_Mask_26 (ULONG)(~(~0<<(6)))*/

#define  MTL_QTOMR7_MASK_26 (ULONG)(0x3f)

/*#define MTL_QTOMR7_RES_Wr_Mask_26 (ULONG)(~((~(~0<<(6)))<<(26)))*/

#define MTL_QTOMR7_RES_WR_MASK_26 (ULONG)(0x3ffffff)

/*#define MTL_QTOMR7_FTQ_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTOMR7_FTQ_MASK (ULONG)(0x1)

/*#define MTL_QTOMR7_FTQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MTL_QTOMR7_FTQ_WR_MASK (ULONG)(0xfffffffe)

#define MTL_QTOMR7_FTQ_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR7_RGRD(v);\
		v = (v & (MTL_QTOMR7_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR7_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR7_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR7_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR7_FTQ_WR_MASK) | ((data & MTL_QTOMR7_FTQ_MASK) << 0));\
		MTL_QTOMR7_RGWR(v);\
} while (0)

#define MTL_QTOMR7_FTQ_UDFRD(data) do {\
		MTL_QTOMR7_RGRD(data);\
		data = ((data >> 0) & MTL_QTOMR7_FTQ_MASK);\
} while (0)

/*#define MTL_QTOMR7_TSF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTOMR7_TSF_MASK (ULONG)(0x1)

/*#define MTL_QTOMR7_TSF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MTL_QTOMR7_TSF_WR_MASK (ULONG)(0xfffffffd)

#define MTL_QTOMR7_TSF_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR7_RGRD(v);\
		v = (v & (MTL_QTOMR7_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR7_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR7_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR7_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR7_TSF_WR_MASK) | ((data & MTL_QTOMR7_TSF_MASK) << 1));\
		MTL_QTOMR7_RGWR(v);\
} while (0)

#define MTL_QTOMR7_TSF_UDFRD(data) do {\
		MTL_QTOMR7_RGRD(data);\
		data = ((data >> 1) & MTL_QTOMR7_TSF_MASK);\
} while (0)

/*#define MTL_QTOMR7_TXQEN_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QTOMR7_TXQEN_MASK (ULONG)(0x3)

/*#define MTL_QTOMR7_TXQEN_Wr_Mask (ULONG)(~((~(~0 << (2))) << (2)))*/

#define MTL_QTOMR7_TXQEN_WR_MASK (ULONG)(0xfffffff3)

#define MTL_QTOMR7_TXQEN_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR7_RGRD(v);\
		v = (v & (MTL_QTOMR7_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR7_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR7_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR7_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR7_TXQEN_WR_MASK) | ((data & MTL_QTOMR7_TXQEN_MASK) << 2));\
		MTL_QTOMR7_RGWR(v);\
} while (0)

#define MTL_QTOMR7_TXQEN_UDFRD(data) do {\
		MTL_QTOMR7_RGRD(data);\
		data = ((data >> 2) & MTL_QTOMR7_TXQEN_MASK);\
} while (0)

/*#define MTL_QTOMR7_TTC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTOMR7_TTC_MASK (ULONG)(0x7)

/*#define MTL_QTOMR7_TTC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_QTOMR7_TTC_WR_MASK (ULONG)(0xffffff8f)

#define MTL_QTOMR7_TTC_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR7_RGRD(v);\
		v = (v & (MTL_QTOMR7_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR7_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR7_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR7_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR7_TTC_WR_MASK) | ((data & MTL_QTOMR7_TTC_MASK) << 4));\
		MTL_QTOMR7_RGWR(v);\
} while (0)

#define MTL_QTOMR7_TTC_UDFRD(data) do {\
		MTL_QTOMR7_RGRD(data);\
		data = ((data >> 4) & MTL_QTOMR7_TTC_MASK);\
} while (0)

/*#define MTL_QTOMR7_TQS_Mask (ULONG)(~(~0<<(10)))*/

#define MTL_QTOMR7_TQS_MASK (ULONG)(0x3ff)

/*#define MTL_QTOMR7_TQS_Wr_Mask (ULONG)(~((~(~0 << (10))) << (16)))*/

#define MTL_QTOMR7_TQS_WR_MASK (ULONG)(0xfc00ffff)

#define MTL_QTOMR7_TQS_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR7_RGRD(v);\
		v = (v & (MTL_QTOMR7_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR7_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR7_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR7_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR7_TQS_WR_MASK) | ((data & MTL_QTOMR7_TQS_MASK) << 16));\
		MTL_QTOMR7_RGWR(v);\
} while (0)

#define MTL_QTOMR7_TQS_UDFRD(data) do {\
		MTL_QTOMR7_RGRD(data);\
		data = ((data >> 16) & MTL_QTOMR7_TQS_MASK);\
} while (0)

#define MTL_QTOMR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe80))

#define MTL_QTOMR6_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QTOMR6_RGOFFADDR);\
} while (0)

#define MTL_QTOMR6_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QTOMR6_RGOFFADDR);\
} while (0)

/*#define  MTL_QTOMR6_Mask_7 (ULONG)(~(~0<<(9)))*/

#define  MTL_QTOMR6_MASK_7 (ULONG)(0x1ff)

/*#define MTL_QTOMR6_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(9)))<<(7)))*/

#define MTL_QTOMR6_RES_WR_MASK_7 (ULONG)(0xffff007f)

/*#define  MTL_QTOMR6_Mask_26 (ULONG)(~(~0<<(6)))*/

#define  MTL_QTOMR6_MASK_26 (ULONG)(0x3f)

/*#define MTL_QTOMR6_RES_Wr_Mask_26 (ULONG)(~((~(~0<<(6)))<<(26)))*/

#define MTL_QTOMR6_RES_WR_MASK_26 (ULONG)(0x3ffffff)

/*#define MTL_QTOMR6_FTQ_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTOMR6_FTQ_MASK (ULONG)(0x1)

/*#define MTL_QTOMR6_FTQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MTL_QTOMR6_FTQ_WR_MASK (ULONG)(0xfffffffe)

#define MTL_QTOMR6_FTQ_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR6_RGRD(v);\
		v = (v & (MTL_QTOMR6_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR6_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR6_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR6_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR6_FTQ_WR_MASK) | ((data & MTL_QTOMR6_FTQ_MASK) << 0));\
		MTL_QTOMR6_RGWR(v);\
} while (0)

#define MTL_QTOMR6_FTQ_UDFRD(data) do {\
		MTL_QTOMR6_RGRD(data);\
		data = ((data >> 0) & MTL_QTOMR6_FTQ_MASK);\
} while (0)

/*#define MTL_QTOMR6_TSF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTOMR6_TSF_MASK (ULONG)(0x1)

/*#define MTL_QTOMR6_TSF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MTL_QTOMR6_TSF_WR_MASK (ULONG)(0xfffffffd)

#define MTL_QTOMR6_TSF_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR6_RGRD(v);\
		v = (v & (MTL_QTOMR6_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR6_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR6_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR6_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR6_TSF_WR_MASK) | ((data & MTL_QTOMR6_TSF_MASK) << 1));\
		MTL_QTOMR6_RGWR(v);\
} while (0)

#define MTL_QTOMR6_TSF_UDFRD(data) do {\
		MTL_QTOMR6_RGRD(data);\
		data = ((data >> 1) & MTL_QTOMR6_TSF_MASK);\
} while (0)

/*#define MTL_QTOMR6_TXQEN_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QTOMR6_TXQEN_MASK (ULONG)(0x3)

/*#define MTL_QTOMR6_TXQEN_Wr_Mask (ULONG)(~((~(~0 << (2))) << (2)))*/

#define MTL_QTOMR6_TXQEN_WR_MASK (ULONG)(0xfffffff3)

#define MTL_QTOMR6_TXQEN_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR6_RGRD(v);\
		v = (v & (MTL_QTOMR6_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR6_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR6_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR6_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR6_TXQEN_WR_MASK) | ((data & MTL_QTOMR6_TXQEN_MASK) << 2));\
		MTL_QTOMR6_RGWR(v);\
} while (0)

#define MTL_QTOMR6_TXQEN_UDFRD(data) do {\
		MTL_QTOMR6_RGRD(data);\
		data = ((data >> 2) & MTL_QTOMR6_TXQEN_MASK);\
} while (0)

/*#define MTL_QTOMR6_TTC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTOMR6_TTC_MASK (ULONG)(0x7)

/*#define MTL_QTOMR6_TTC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_QTOMR6_TTC_WR_MASK (ULONG)(0xffffff8f)

#define MTL_QTOMR6_TTC_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR6_RGRD(v);\
		v = (v & (MTL_QTOMR6_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR6_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR6_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR6_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR6_TTC_WR_MASK) | ((data & MTL_QTOMR6_TTC_MASK) << 4));\
		MTL_QTOMR6_RGWR(v);\
} while (0)

#define MTL_QTOMR6_TTC_UDFRD(data) do {\
		MTL_QTOMR6_RGRD(data);\
		data = ((data >> 4) & MTL_QTOMR6_TTC_MASK);\
} while (0)

/*#define MTL_QTOMR6_TQS_Mask (ULONG)(~(~0<<(10)))*/

#define MTL_QTOMR6_TQS_MASK (ULONG)(0x3ff)

/*#define MTL_QTOMR6_TQS_Wr_Mask (ULONG)(~((~(~0 << (10))) << (16)))*/

#define MTL_QTOMR6_TQS_WR_MASK (ULONG)(0xfc00ffff)

#define MTL_QTOMR6_TQS_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR6_RGRD(v);\
		v = (v & (MTL_QTOMR6_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR6_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR6_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR6_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR6_TQS_WR_MASK) | ((data & MTL_QTOMR6_TQS_MASK) << 16));\
		MTL_QTOMR6_RGWR(v);\
} while (0)

#define MTL_QTOMR6_TQS_UDFRD(data) do {\
		MTL_QTOMR6_RGRD(data);\
		data = ((data >> 16) & MTL_QTOMR6_TQS_MASK);\
} while (0)

#define MTL_QTOMR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe40))

#define MTL_QTOMR5_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QTOMR5_RGOFFADDR);\
} while (0)

#define MTL_QTOMR5_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QTOMR5_RGOFFADDR);\
} while (0)

/*#define  MTL_QTOMR5_Mask_7 (ULONG)(~(~0<<(9)))*/

#define  MTL_QTOMR5_MASK_7 (ULONG)(0x1ff)

/*#define MTL_QTOMR5_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(9)))<<(7)))*/

#define MTL_QTOMR5_RES_WR_MASK_7 (ULONG)(0xffff007f)

/*#define  MTL_QTOMR5_Mask_26 (ULONG)(~(~0<<(6)))*/

#define  MTL_QTOMR5_MASK_26 (ULONG)(0x3f)

/*#define MTL_QTOMR5_RES_Wr_Mask_26 (ULONG)(~((~(~0<<(6)))<<(26)))*/

#define MTL_QTOMR5_RES_WR_MASK_26 (ULONG)(0x3ffffff)

/*#define MTL_QTOMR5_FTQ_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTOMR5_FTQ_MASK (ULONG)(0x1)

/*#define MTL_QTOMR5_FTQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MTL_QTOMR5_FTQ_WR_MASK (ULONG)(0xfffffffe)

#define MTL_QTOMR5_FTQ_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR5_RGRD(v);\
		v = (v & (MTL_QTOMR5_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR5_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR5_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR5_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR5_FTQ_WR_MASK) | ((data & MTL_QTOMR5_FTQ_MASK) << 0));\
		MTL_QTOMR5_RGWR(v);\
} while (0)

#define MTL_QTOMR5_FTQ_UDFRD(data) do {\
		MTL_QTOMR5_RGRD(data);\
		data = ((data >> 0) & MTL_QTOMR5_FTQ_MASK);\
} while (0)

/*#define MTL_QTOMR5_TSF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTOMR5_TSF_MASK (ULONG)(0x1)

/*#define MTL_QTOMR5_TSF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MTL_QTOMR5_TSF_WR_MASK (ULONG)(0xfffffffd)

#define MTL_QTOMR5_TSF_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR5_RGRD(v);\
		v = (v & (MTL_QTOMR5_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR5_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR5_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR5_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR5_TSF_WR_MASK) | ((data & MTL_QTOMR5_TSF_MASK) << 1));\
		MTL_QTOMR5_RGWR(v);\
} while (0)

#define MTL_QTOMR5_TSF_UDFRD(data) do {\
		MTL_QTOMR5_RGRD(data);\
		data = ((data >> 1) & MTL_QTOMR5_TSF_MASK);\
} while (0)

/*#define MTL_QTOMR5_TXQEN_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QTOMR5_TXQEN_MASK (ULONG)(0x3)

/*#define MTL_QTOMR5_TXQEN_Wr_Mask (ULONG)(~((~(~0 << (2))) << (2)))*/

#define MTL_QTOMR5_TXQEN_WR_MASK (ULONG)(0xfffffff3)

#define MTL_QTOMR5_TXQEN_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR5_RGRD(v);\
		v = (v & (MTL_QTOMR5_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR5_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR5_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR5_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR5_TXQEN_WR_MASK) | ((data & MTL_QTOMR5_TXQEN_MASK) << 2));\
		MTL_QTOMR5_RGWR(v);\
} while (0)

#define MTL_QTOMR5_TXQEN_UDFRD(data) do {\
		MTL_QTOMR5_RGRD(data);\
		data = ((data >> 2) & MTL_QTOMR5_TXQEN_MASK);\
} while (0)

/*#define MTL_QTOMR5_TTC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTOMR5_TTC_MASK (ULONG)(0x7)

/*#define MTL_QTOMR5_TTC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_QTOMR5_TTC_WR_MASK (ULONG)(0xffffff8f)

#define MTL_QTOMR5_TTC_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR5_RGRD(v);\
		v = (v & (MTL_QTOMR5_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR5_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR5_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR5_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR5_TTC_WR_MASK) | ((data & MTL_QTOMR5_TTC_MASK) << 4));\
		MTL_QTOMR5_RGWR(v);\
} while (0)

#define MTL_QTOMR5_TTC_UDFRD(data) do {\
		MTL_QTOMR5_RGRD(data);\
		data = ((data >> 4) & MTL_QTOMR5_TTC_MASK);\
} while (0)

/*#define MTL_QTOMR5_TQS_Mask (ULONG)(~(~0<<(10)))*/

#define MTL_QTOMR5_TQS_MASK (ULONG)(0x3ff)

/*#define MTL_QTOMR5_TQS_Wr_Mask (ULONG)(~((~(~0 << (10))) << (16)))*/

#define MTL_QTOMR5_TQS_WR_MASK (ULONG)(0xfc00ffff)

#define MTL_QTOMR5_TQS_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR5_RGRD(v);\
		v = (v & (MTL_QTOMR5_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR5_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR5_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR5_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR5_TQS_WR_MASK) | ((data & MTL_QTOMR5_TQS_MASK) << 16));\
		MTL_QTOMR5_RGWR(v);\
} while (0)

#define MTL_QTOMR5_TQS_UDFRD(data) do {\
		MTL_QTOMR5_RGRD(data);\
		data = ((data >> 16) & MTL_QTOMR5_TQS_MASK);\
} while (0)

#define MTL_QTOMR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xe00))

#define MTL_QTOMR4_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QTOMR4_RGOFFADDR);\
} while (0)

#define MTL_QTOMR4_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QTOMR4_RGOFFADDR);\
} while (0)

/*#define  MTL_QTOMR4_Mask_7 (ULONG)(~(~0<<(9)))*/

#define  MTL_QTOMR4_MASK_7 (ULONG)(0x1ff)

/*#define MTL_QTOMR4_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(9)))<<(7)))*/

#define MTL_QTOMR4_RES_WR_MASK_7 (ULONG)(0xffff007f)

/*#define  MTL_QTOMR4_Mask_26 (ULONG)(~(~0<<(6)))*/

#define  MTL_QTOMR4_MASK_26 (ULONG)(0x3f)

/*#define MTL_QTOMR4_RES_Wr_Mask_26 (ULONG)(~((~(~0<<(6)))<<(26)))*/

#define MTL_QTOMR4_RES_WR_MASK_26 (ULONG)(0x3ffffff)

/*#define MTL_QTOMR4_FTQ_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTOMR4_FTQ_MASK (ULONG)(0x1)

/*#define MTL_QTOMR4_FTQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MTL_QTOMR4_FTQ_WR_MASK (ULONG)(0xfffffffe)

#define MTL_QTOMR4_FTQ_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR4_RGRD(v);\
		v = (v & (MTL_QTOMR4_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR4_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR4_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR4_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR4_FTQ_WR_MASK) | ((data & MTL_QTOMR4_FTQ_MASK) << 0));\
		MTL_QTOMR4_RGWR(v);\
} while (0)

#define MTL_QTOMR4_FTQ_UDFRD(data) do {\
		MTL_QTOMR4_RGRD(data);\
		data = ((data >> 0) & MTL_QTOMR4_FTQ_MASK);\
} while (0)

/*#define MTL_QTOMR4_TSF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTOMR4_TSF_MASK (ULONG)(0x1)

/*#define MTL_QTOMR4_TSF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MTL_QTOMR4_TSF_WR_MASK (ULONG)(0xfffffffd)

#define MTL_QTOMR4_TSF_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR4_RGRD(v);\
		v = (v & (MTL_QTOMR4_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR4_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR4_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR4_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR4_TSF_WR_MASK) | ((data & MTL_QTOMR4_TSF_MASK) << 1));\
		MTL_QTOMR4_RGWR(v);\
} while (0)

#define MTL_QTOMR4_TSF_UDFRD(data) do {\
		MTL_QTOMR4_RGRD(data);\
		data = ((data >> 1) & MTL_QTOMR4_TSF_MASK);\
} while (0)

/*#define MTL_QTOMR4_TXQEN_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QTOMR4_TXQEN_MASK (ULONG)(0x3)

/*#define MTL_QTOMR4_TXQEN_Wr_Mask (ULONG)(~((~(~0 << (2))) << (2)))*/

#define MTL_QTOMR4_TXQEN_WR_MASK (ULONG)(0xfffffff3)

#define MTL_QTOMR4_TXQEN_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR4_RGRD(v);\
		v = (v & (MTL_QTOMR4_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR4_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR4_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR4_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR4_TXQEN_WR_MASK) | ((data & MTL_QTOMR4_TXQEN_MASK) << 2));\
		MTL_QTOMR4_RGWR(v);\
} while (0)

#define MTL_QTOMR4_TXQEN_UDFRD(data) do {\
		MTL_QTOMR4_RGRD(data);\
		data = ((data >> 2) & MTL_QTOMR4_TXQEN_MASK);\
} while (0)

/*#define MTL_QTOMR4_TTC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTOMR4_TTC_MASK (ULONG)(0x7)

/*#define MTL_QTOMR4_TTC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_QTOMR4_TTC_WR_MASK (ULONG)(0xffffff8f)

#define MTL_QTOMR4_TTC_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR4_RGRD(v);\
		v = (v & (MTL_QTOMR4_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR4_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR4_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR4_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR4_TTC_WR_MASK) | ((data & MTL_QTOMR4_TTC_MASK) << 4));\
		MTL_QTOMR4_RGWR(v);\
} while (0)

#define MTL_QTOMR4_TTC_UDFRD(data) do {\
		MTL_QTOMR4_RGRD(data);\
		data = ((data >> 4) & MTL_QTOMR4_TTC_MASK);\
} while (0)

/*#define MTL_QTOMR4_TQS_Mask (ULONG)(~(~0<<(10)))*/

#define MTL_QTOMR4_TQS_MASK (ULONG)(0x3ff)

/*#define MTL_QTOMR4_TQS_Wr_Mask (ULONG)(~((~(~0 << (10))) << (16)))*/

#define MTL_QTOMR4_TQS_WR_MASK (ULONG)(0xfc00ffff)

#define MTL_QTOMR4_TQS_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR4_RGRD(v);\
		v = (v & (MTL_QTOMR4_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR4_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR4_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR4_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR4_TQS_WR_MASK) | ((data & MTL_QTOMR4_TQS_MASK) << 16));\
		MTL_QTOMR4_RGWR(v);\
} while (0)

#define MTL_QTOMR4_TQS_UDFRD(data) do {\
		MTL_QTOMR4_RGRD(data);\
		data = ((data >> 16) & MTL_QTOMR4_TQS_MASK);\
} while (0)

#define MTL_QTOMR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xdc0))

#define MTL_QTOMR3_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QTOMR3_RGOFFADDR);\
} while (0)

#define MTL_QTOMR3_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QTOMR3_RGOFFADDR);\
} while (0)

/*#define  MTL_QTOMR3_Mask_7 (ULONG)(~(~0<<(9)))*/

#define  MTL_QTOMR3_MASK_7 (ULONG)(0x1ff)

/*#define MTL_QTOMR3_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(9)))<<(7)))*/

#define MTL_QTOMR3_RES_WR_MASK_7 (ULONG)(0xffff007f)

/*#define  MTL_QTOMR3_Mask_26 (ULONG)(~(~0<<(6)))*/

#define  MTL_QTOMR3_MASK_26 (ULONG)(0x3f)

/*#define MTL_QTOMR3_RES_Wr_Mask_26 (ULONG)(~((~(~0<<(6)))<<(26)))*/

#define MTL_QTOMR3_RES_WR_MASK_26 (ULONG)(0x3ffffff)

/*#define MTL_QTOMR3_FTQ_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTOMR3_FTQ_MASK (ULONG)(0x1)

/*#define MTL_QTOMR3_FTQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MTL_QTOMR3_FTQ_WR_MASK (ULONG)(0xfffffffe)

#define MTL_QTOMR3_FTQ_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR3_RGRD(v);\
		v = (v & (MTL_QTOMR3_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR3_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR3_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR3_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR3_FTQ_WR_MASK) | ((data & MTL_QTOMR3_FTQ_MASK) << 0));\
		MTL_QTOMR3_RGWR(v);\
} while (0)

#define MTL_QTOMR3_FTQ_UDFRD(data) do {\
		MTL_QTOMR3_RGRD(data);\
		data = ((data >> 0) & MTL_QTOMR3_FTQ_MASK);\
} while (0)

/*#define MTL_QTOMR3_TSF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTOMR3_TSF_MASK (ULONG)(0x1)

/*#define MTL_QTOMR3_TSF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MTL_QTOMR3_TSF_WR_MASK (ULONG)(0xfffffffd)

#define MTL_QTOMR3_TSF_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR3_RGRD(v);\
		v = (v & (MTL_QTOMR3_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR3_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR3_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR3_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR3_TSF_WR_MASK) | ((data & MTL_QTOMR3_TSF_MASK) << 1));\
		MTL_QTOMR3_RGWR(v);\
} while (0)

#define MTL_QTOMR3_TSF_UDFRD(data) do {\
		MTL_QTOMR3_RGRD(data);\
		data = ((data >> 1) & MTL_QTOMR3_TSF_MASK);\
} while (0)

/*#define MTL_QTOMR3_TXQEN_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QTOMR3_TXQEN_MASK (ULONG)(0x3)

/*#define MTL_QTOMR3_TXQEN_Wr_Mask (ULONG)(~((~(~0 << (2))) << (2)))*/

#define MTL_QTOMR3_TXQEN_WR_MASK (ULONG)(0xfffffff3)

#define MTL_QTOMR3_TXQEN_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR3_RGRD(v);\
		v = (v & (MTL_QTOMR3_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR3_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR3_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR3_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR3_TXQEN_WR_MASK) | ((data & MTL_QTOMR3_TXQEN_MASK) << 2));\
		MTL_QTOMR3_RGWR(v);\
} while (0)

#define MTL_QTOMR3_TXQEN_UDFRD(data) do {\
		MTL_QTOMR3_RGRD(data);\
		data = ((data >> 2) & MTL_QTOMR3_TXQEN_MASK);\
} while (0)

/*#define MTL_QTOMR3_TTC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTOMR3_TTC_MASK (ULONG)(0x7)

/*#define MTL_QTOMR3_TTC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_QTOMR3_TTC_WR_MASK (ULONG)(0xffffff8f)

#define MTL_QTOMR3_TTC_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR3_RGRD(v);\
		v = (v & (MTL_QTOMR3_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR3_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR3_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR3_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR3_TTC_WR_MASK) | ((data & MTL_QTOMR3_TTC_MASK) << 4));\
		MTL_QTOMR3_RGWR(v);\
} while (0)

#define MTL_QTOMR3_TTC_UDFRD(data) do {\
		MTL_QTOMR3_RGRD(data);\
		data = ((data >> 4) & MTL_QTOMR3_TTC_MASK);\
} while (0)

/*#define MTL_QTOMR3_TQS_Mask (ULONG)(~(~0<<(10)))*/

#define MTL_QTOMR3_TQS_MASK (ULONG)(0x3ff)

/*#define MTL_QTOMR3_TQS_Wr_Mask (ULONG)(~((~(~0 << (10))) << (16)))*/

#define MTL_QTOMR3_TQS_WR_MASK (ULONG)(0xfc00ffff)

#define MTL_QTOMR3_TQS_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR3_RGRD(v);\
		v = (v & (MTL_QTOMR3_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR3_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR3_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR3_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR3_TQS_WR_MASK) | ((data & MTL_QTOMR3_TQS_MASK) << 16));\
		MTL_QTOMR3_RGWR(v);\
} while (0)

#define MTL_QTOMR3_TQS_UDFRD(data) do {\
		MTL_QTOMR3_RGRD(data);\
		data = ((data >> 16) & MTL_QTOMR3_TQS_MASK);\
} while (0)

#define MTL_QTOMR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd80))

#define MTL_QTOMR2_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QTOMR2_RGOFFADDR);\
} while (0)

#define MTL_QTOMR2_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QTOMR2_RGOFFADDR);\
} while (0)

/*#define  MTL_QTOMR2_Mask_7 (ULONG)(~(~0<<(9)))*/

#define  MTL_QTOMR2_MASK_7 (ULONG)(0x1ff)

/*#define MTL_QTOMR2_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(9)))<<(7)))*/

#define MTL_QTOMR2_RES_WR_MASK_7 (ULONG)(0xffff007f)

/*#define  MTL_QTOMR2_Mask_26 (ULONG)(~(~0<<(6)))*/

#define  MTL_QTOMR2_MASK_26 (ULONG)(0x3f)

/*#define MTL_QTOMR2_RES_Wr_Mask_26 (ULONG)(~((~(~0<<(6)))<<(26)))*/

#define MTL_QTOMR2_RES_WR_MASK_26 (ULONG)(0x3ffffff)

/*#define MTL_QTOMR2_FTQ_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTOMR2_FTQ_MASK (ULONG)(0x1)

/*#define MTL_QTOMR2_FTQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MTL_QTOMR2_FTQ_WR_MASK (ULONG)(0xfffffffe)

#define MTL_QTOMR2_FTQ_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR2_RGRD(v);\
		v = (v & (MTL_QTOMR2_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR2_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR2_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR2_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR2_FTQ_WR_MASK) | ((data & MTL_QTOMR2_FTQ_MASK) << 0));\
		MTL_QTOMR2_RGWR(v);\
} while (0)

#define MTL_QTOMR2_FTQ_UDFRD(data) do {\
		MTL_QTOMR2_RGRD(data);\
		data = ((data >> 0) & MTL_QTOMR2_FTQ_MASK);\
} while (0)

/*#define MTL_QTOMR2_TSF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTOMR2_TSF_MASK (ULONG)(0x1)

/*#define MTL_QTOMR2_TSF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MTL_QTOMR2_TSF_WR_MASK (ULONG)(0xfffffffd)

#define MTL_QTOMR2_TSF_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR2_RGRD(v);\
		v = (v & (MTL_QTOMR2_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR2_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR2_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR2_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR2_TSF_WR_MASK) | ((data & MTL_QTOMR2_TSF_MASK) << 1));\
		MTL_QTOMR2_RGWR(v);\
} while (0)

#define MTL_QTOMR2_TSF_UDFRD(data) do {\
		MTL_QTOMR2_RGRD(data);\
		data = ((data >> 1) & MTL_QTOMR2_TSF_MASK);\
} while (0)

/*#define MTL_QTOMR2_TXQEN_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QTOMR2_TXQEN_MASK (ULONG)(0x3)

/*#define MTL_QTOMR2_TXQEN_Wr_Mask (ULONG)(~((~(~0 << (2))) << (2)))*/

#define MTL_QTOMR2_TXQEN_WR_MASK (ULONG)(0xfffffff3)

#define MTL_QTOMR2_TXQEN_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR2_RGRD(v);\
		v = (v & (MTL_QTOMR2_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR2_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR2_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR2_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR2_TXQEN_WR_MASK) | ((data & MTL_QTOMR2_TXQEN_MASK) << 2));\
		MTL_QTOMR2_RGWR(v);\
} while (0)

#define MTL_QTOMR2_TXQEN_UDFRD(data) do {\
		MTL_QTOMR2_RGRD(data);\
		data = ((data >> 2) & MTL_QTOMR2_TXQEN_MASK);\
} while (0)

/*#define MTL_QTOMR2_TTC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTOMR2_TTC_MASK (ULONG)(0x7)

/*#define MTL_QTOMR2_TTC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_QTOMR2_TTC_WR_MASK (ULONG)(0xffffff8f)

#define MTL_QTOMR2_TTC_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR2_RGRD(v);\
		v = (v & (MTL_QTOMR2_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR2_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR2_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR2_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR2_TTC_WR_MASK) | ((data & MTL_QTOMR2_TTC_MASK) << 4));\
		MTL_QTOMR2_RGWR(v);\
} while (0)

#define MTL_QTOMR2_TTC_UDFRD(data) do {\
		MTL_QTOMR2_RGRD(data);\
		data = ((data >> 4) & MTL_QTOMR2_TTC_MASK);\
} while (0)

/*#define MTL_QTOMR2_TQS_Mask (ULONG)(~(~0<<(10)))*/

#define MTL_QTOMR2_TQS_MASK (ULONG)(0x3ff)

/*#define MTL_QTOMR2_TQS_Wr_Mask (ULONG)(~((~(~0 << (10))) << (16)))*/

#define MTL_QTOMR2_TQS_WR_MASK (ULONG)(0xfc00ffff)

#define MTL_QTOMR2_TQS_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR2_RGRD(v);\
		v = (v & (MTL_QTOMR2_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR2_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR2_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR2_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR2_TQS_WR_MASK) | ((data & MTL_QTOMR2_TQS_MASK) << 16));\
		MTL_QTOMR2_RGWR(v);\
} while (0)

#define MTL_QTOMR2_TQS_UDFRD(data) do {\
		MTL_QTOMR2_RGRD(data);\
		data = ((data >> 16) & MTL_QTOMR2_TQS_MASK);\
} while (0)

#define MTL_QTOMR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd40))

#define MTL_QTOMR1_RGWR(data) do {\
		iowrite32(data, (void *)MTL_QTOMR1_RGOFFADDR);\
} while (0)

#define MTL_QTOMR1_RGRD(data) do {\
		(data) = ioread32((void *)MTL_QTOMR1_RGOFFADDR);\
} while (0)

/*#define  MTL_QTOMR1_Mask_7 (ULONG)(~(~0<<(9)))*/

#define  MTL_QTOMR1_MASK_7 (ULONG)(0x1ff)

/*#define MTL_QTOMR1_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(9)))<<(7)))*/

#define MTL_QTOMR1_RES_WR_MASK_7 (ULONG)(0xffff007f)

/*#define  MTL_QTOMR1_Mask_26 (ULONG)(~(~0<<(6)))*/

#define  MTL_QTOMR1_MASK_26 (ULONG)(0x3f)

/*#define MTL_QTOMR1_RES_Wr_Mask_26 (ULONG)(~((~(~0<<(6)))<<(26)))*/

#define MTL_QTOMR1_RES_WR_MASK_26 (ULONG)(0x3ffffff)

/*#define MTL_QTOMR1_FTQ_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTOMR1_FTQ_MASK (ULONG)(0x1)

/*#define MTL_QTOMR1_FTQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MTL_QTOMR1_FTQ_WR_MASK (ULONG)(0xfffffffe)

#define MTL_QTOMR1_FTQ_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR1_RGRD(v);\
		v = (v & (MTL_QTOMR1_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR1_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR1_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR1_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR1_FTQ_WR_MASK) | ((data & MTL_QTOMR1_FTQ_MASK) << 0));\
		MTL_QTOMR1_RGWR(v);\
} while (0)

#define MTL_QTOMR1_FTQ_UDFRD(data) do {\
		MTL_QTOMR1_RGRD(data);\
		data = ((data >> 0) & MTL_QTOMR1_FTQ_MASK);\
} while (0)

/*#define MTL_QTOMR1_TSF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTOMR1_TSF_MASK (ULONG)(0x1)

/*#define MTL_QTOMR1_TSF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MTL_QTOMR1_TSF_WR_MASK (ULONG)(0xfffffffd)

#define MTL_QTOMR1_TSF_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR1_RGRD(v);\
		v = (v & (MTL_QTOMR1_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR1_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR1_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR1_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR1_TSF_WR_MASK) | ((data & MTL_QTOMR1_TSF_MASK) << 1));\
		MTL_QTOMR1_RGWR(v);\
} while (0)

#define MTL_QTOMR1_TSF_UDFRD(data) do {\
		MTL_QTOMR1_RGRD(data);\
		data = ((data >> 1) & MTL_QTOMR1_TSF_MASK);\
} while (0)

/*#define MTL_QTOMR1_TXQEN_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QTOMR1_TXQEN_MASK (ULONG)(0x3)

/*#define MTL_QTOMR1_TXQEN_Wr_Mask (ULONG)(~((~(~0 << (2))) << (2)))*/

#define MTL_QTOMR1_TXQEN_WR_MASK (ULONG)(0xfffffff3)

#define MTL_QTOMR1_TXQEN_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR1_RGRD(v);\
		v = (v & (MTL_QTOMR1_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR1_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR1_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR1_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR1_TXQEN_WR_MASK) | ((data & MTL_QTOMR1_TXQEN_MASK) << 2));\
		MTL_QTOMR1_RGWR(v);\
} while (0)

#define MTL_QTOMR1_TXQEN_UDFRD(data) do {\
		MTL_QTOMR1_RGRD(data);\
		data = ((data >> 2) & MTL_QTOMR1_TXQEN_MASK);\
} while (0)

/*#define MTL_QTOMR1_TTC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTOMR1_TTC_MASK (ULONG)(0x7)

/*#define MTL_QTOMR1_TTC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_QTOMR1_TTC_WR_MASK (ULONG)(0xffffff8f)

#define MTL_QTOMR1_TTC_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR1_RGRD(v);\
		v = (v & (MTL_QTOMR1_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR1_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR1_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR1_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR1_TTC_WR_MASK) | ((data & MTL_QTOMR1_TTC_MASK) << 4));\
		MTL_QTOMR1_RGWR(v);\
} while (0)

#define MTL_QTOMR1_TTC_UDFRD(data) do {\
		MTL_QTOMR1_RGRD(data);\
		data = ((data >> 4) & MTL_QTOMR1_TTC_MASK);\
} while (0)

/*#define MTL_QTOMR1_TQS_Mask (ULONG)(~(~0<<(10)))*/

#define MTL_QTOMR1_TQS_MASK (ULONG)(0x3ff)

/*#define MTL_QTOMR1_TQS_Wr_Mask (ULONG)(~((~(~0 << (10))) << (16)))*/

#define MTL_QTOMR1_TQS_WR_MASK (ULONG)(0xfc00ffff)

#define MTL_QTOMR1_TQS_UDFWR(data) do {\
		ULONG v;\
		MTL_QTOMR1_RGRD(v);\
		v = (v & (MTL_QTOMR1_RES_WR_MASK_7)) | (((0) & (MTL_QTOMR1_MASK_7)) << 7);\
		v = (v & (MTL_QTOMR1_RES_WR_MASK_26)) | (((0) & (MTL_QTOMR1_MASK_26)) << 26);\
		v = ((v & MTL_QTOMR1_TQS_WR_MASK) | ((data & MTL_QTOMR1_TQS_MASK) << 16));\
		MTL_QTOMR1_RGWR(v);\
} while (0)

#define MTL_QTOMR1_TQS_UDFRD(data) do {\
		MTL_QTOMR1_RGRD(data);\
		data = ((data >> 16) & MTL_QTOMR1_TQS_MASK);\
} while (0)

#define MAC_PMTCSR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xc0))

#define MAC_PMTCSR_RGWR(data) do {\
		iowrite32(data, (void *)MAC_PMTCSR_RGOFFADDR);\
} while (0)

#define MAC_PMTCSR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_PMTCSR_RGOFFADDR);\
} while (0)

/*#define  MAC_PMTCSR_Mask_27 (ULONG)(~(~0<<(4)))*/

#define  MAC_PMTCSR_MASK_27 (ULONG)(0xf)

/*#define MAC_PMTCSR_RES_Wr_Mask_27 (ULONG)(~((~(~0<<(4)))<<(27)))*/

#define MAC_PMTCSR_RES_WR_MASK_27 (ULONG)(0x87ffffff)

/*#define  MAC_PMTCSR_Mask_10 (ULONG)(~(~0<<(14)))*/

#define  MAC_PMTCSR_MASK_10 (ULONG)(0x3fff)

/*#define MAC_PMTCSR_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(14)))<<(10)))*/

#define MAC_PMTCSR_RES_WR_MASK_10 (ULONG)(0xff0003ff)

/*#define  MAC_PMTCSR_Mask_7 (ULONG)(~(~0<<(2)))*/

#define  MAC_PMTCSR_MASK_7 (ULONG)(0x3)

/*#define MAC_PMTCSR_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(2)))<<(7)))*/

#define MAC_PMTCSR_RES_WR_MASK_7 (ULONG)(0xfffffe7f)

/*#define  MAC_PMTCSR_Mask_3 (ULONG)(~(~0<<(2)))*/

#define  MAC_PMTCSR_MASK_3 (ULONG)(0x3)

/*#define MAC_PMTCSR_RES_Wr_Mask_3 (ULONG)(~((~(~0<<(2)))<<(3)))*/

#define MAC_PMTCSR_RES_WR_MASK_3 (ULONG)(0xffffffe7)

/*#define MAC_PMTCSR_RWKFILTRST_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PMTCSR_RWKFILTRST_MASK (ULONG)(0x1)

/*#define MAC_PMTCSR_RWKFILTRST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (31)))*/

#define MAC_PMTCSR_RWKFILTRST_WR_MASK (ULONG)(0x7fffffff)

#define MAC_PMTCSR_RWKFILTRST_UDFWR(data) do {\
		ULONG v;\
		MAC_PMTCSR_RGRD(v);\
		v = (v & (MAC_PMTCSR_RES_WR_MASK_27)) | (((0) & (MAC_PMTCSR_MASK_27)) << 27);\
		v = (v & (MAC_PMTCSR_RES_WR_MASK_10)) | (((0) & (MAC_PMTCSR_MASK_10)) << 10);\
		v = (v & (MAC_PMTCSR_RES_WR_MASK_7)) | (((0) & (MAC_PMTCSR_MASK_7)) << 7);\
		v = (v & (MAC_PMTCSR_RES_WR_MASK_3)) | (((0) & (MAC_PMTCSR_MASK_3)) << 3);\
		v = ((v & MAC_PMTCSR_RWKFILTRST_WR_MASK) | ((data & MAC_PMTCSR_RWKFILTRST_MASK) << 31));\
		MAC_PMTCSR_RGWR(v);\
} while (0)

#define MAC_PMTCSR_RWKFILTRST_UDFRD(data) do {\
		MAC_PMTCSR_RGRD(data);\
		data = ((data >> 31) & MAC_PMTCSR_RWKFILTRST_MASK);\
} while (0)

/*#define MAC_PMTCSR_RWKPTR_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_PMTCSR_RWKPTR_MASK (ULONG)(0x7)

#define MAC_PMTCSR_RWKPTR_UDFRD(data) do {\
		MAC_PMTCSR_RGRD(data);\
		data = ((data >> 24) & MAC_PMTCSR_RWKPTR_MASK);\
} while (0)

/*#define MAC_PMTCSR_GLBLUCAST_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PMTCSR_GLBLUCAST_MASK (ULONG)(0x1)

/*#define MAC_PMTCSR_GLBLUCAST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (9)))*/

#define MAC_PMTCSR_GLBLUCAST_WR_MASK (ULONG)(0xfffffdff)

#define MAC_PMTCSR_GLBLUCAST_UDFWR(data) do {\
		ULONG v;\
		MAC_PMTCSR_RGRD(v);\
		v = (v & (MAC_PMTCSR_RES_WR_MASK_27)) | (((0) & (MAC_PMTCSR_MASK_27)) << 27);\
		v = (v & (MAC_PMTCSR_RES_WR_MASK_10)) | (((0) & (MAC_PMTCSR_MASK_10)) << 10);\
		v = (v & (MAC_PMTCSR_RES_WR_MASK_7)) | (((0) & (MAC_PMTCSR_MASK_7)) << 7);\
		v = (v & (MAC_PMTCSR_RES_WR_MASK_3)) | (((0) & (MAC_PMTCSR_MASK_3)) << 3);\
		v = ((v & MAC_PMTCSR_GLBLUCAST_WR_MASK) | ((data & MAC_PMTCSR_GLBLUCAST_MASK) << 9));\
		MAC_PMTCSR_RGWR(v);\
} while (0)

#define MAC_PMTCSR_GLBLUCAST_UDFRD(data) do {\
		MAC_PMTCSR_RGRD(data);\
		data = ((data >> 9) & MAC_PMTCSR_GLBLUCAST_MASK);\
} while (0)

/*#define MAC_PMTCSR_RWKPRCVD_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PMTCSR_RWKPRCVD_MASK (ULONG)(0x1)

/*#define MAC_PMTCSR_RWKPRCVD_Wr_Mask (ULONG)(~((~(~0 << (1))) << (6)))*/

#define MAC_PMTCSR_RWKPRCVD_WR_MASK (ULONG)(0xffffffbf)

#define MAC_PMTCSR_RWKPRCVD_UDFWR(data) do {\
		ULONG v;\
		MAC_PMTCSR_RGRD(v);\
		v = (v & (MAC_PMTCSR_RES_WR_MASK_27)) | (((0) & (MAC_PMTCSR_MASK_27)) << 27);\
		v = (v & (MAC_PMTCSR_RES_WR_MASK_10)) | (((0) & (MAC_PMTCSR_MASK_10)) << 10);\
		v = (v & (MAC_PMTCSR_RES_WR_MASK_7)) | (((0) & (MAC_PMTCSR_MASK_7)) << 7);\
		v = (v & (MAC_PMTCSR_RES_WR_MASK_3)) | (((0) & (MAC_PMTCSR_MASK_3)) << 3);\
		v = ((v & MAC_PMTCSR_RWKPRCVD_WR_MASK) | ((data & MAC_PMTCSR_RWKPRCVD_MASK) << 6));\
		MAC_PMTCSR_RGWR(v);\
} while (0)

#define MAC_PMTCSR_RWKPRCVD_UDFRD(data) do {\
		MAC_PMTCSR_RGRD(data);\
		data = ((data >> 6) & MAC_PMTCSR_RWKPRCVD_MASK);\
} while (0)

/*#define MAC_PMTCSR_MGKPRCVD_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PMTCSR_MGKPRCVD_MASK (ULONG)(0x1)

/*#define MAC_PMTCSR_MGKPRCVD_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MAC_PMTCSR_MGKPRCVD_WR_MASK (ULONG)(0xffffffdf)

#define MAC_PMTCSR_MGKPRCVD_UDFWR(data) do {\
		ULONG v;\
		MAC_PMTCSR_RGRD(v);\
		v = (v & (MAC_PMTCSR_RES_WR_MASK_27)) | (((0) & (MAC_PMTCSR_MASK_27)) << 27);\
		v = (v & (MAC_PMTCSR_RES_WR_MASK_10)) | (((0) & (MAC_PMTCSR_MASK_10)) << 10);\
		v = (v & (MAC_PMTCSR_RES_WR_MASK_7)) | (((0) & (MAC_PMTCSR_MASK_7)) << 7);\
		v = (v & (MAC_PMTCSR_RES_WR_MASK_3)) | (((0) & (MAC_PMTCSR_MASK_3)) << 3);\
		v = ((v & MAC_PMTCSR_MGKPRCVD_WR_MASK) | ((data & MAC_PMTCSR_MGKPRCVD_MASK) << 5));\
		MAC_PMTCSR_RGWR(v);\
} while (0)

#define MAC_PMTCSR_MGKPRCVD_UDFRD(data) do {\
		MAC_PMTCSR_RGRD(data);\
		data = ((data >> 5) & MAC_PMTCSR_MGKPRCVD_MASK);\
} while (0)

/*#define MAC_PMTCSR_RWKPKTEN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PMTCSR_RWKPKTEN_MASK (ULONG)(0x1)

/*#define MAC_PMTCSR_RWKPKTEN_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MAC_PMTCSR_RWKPKTEN_WR_MASK (ULONG)(0xfffffffb)

#define MAC_PMTCSR_RWKPKTEN_UDFWR(data) do {\
		ULONG v;\
		MAC_PMTCSR_RGRD(v);\
		v = (v & (MAC_PMTCSR_RES_WR_MASK_27)) | (((0) & (MAC_PMTCSR_MASK_27)) << 27);\
		v = (v & (MAC_PMTCSR_RES_WR_MASK_10)) | (((0) & (MAC_PMTCSR_MASK_10)) << 10);\
		v = (v & (MAC_PMTCSR_RES_WR_MASK_7)) | (((0) & (MAC_PMTCSR_MASK_7)) << 7);\
		v = (v & (MAC_PMTCSR_RES_WR_MASK_3)) | (((0) & (MAC_PMTCSR_MASK_3)) << 3);\
		v = ((v & MAC_PMTCSR_RWKPKTEN_WR_MASK) | ((data & MAC_PMTCSR_RWKPKTEN_MASK) << 2));\
		MAC_PMTCSR_RGWR(v);\
} while (0)

#define MAC_PMTCSR_RWKPKTEN_UDFRD(data) do {\
		MAC_PMTCSR_RGRD(data);\
		data = ((data >> 2) & MAC_PMTCSR_RWKPKTEN_MASK);\
} while (0)

/*#define MAC_PMTCSR_MGKPKTEN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PMTCSR_MGKPKTEN_MASK (ULONG)(0x1)

/*#define MAC_PMTCSR_MGKPKTEN_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_PMTCSR_MGKPKTEN_WR_MASK (ULONG)(0xfffffffd)

#define MAC_PMTCSR_MGKPKTEN_UDFWR(data) do {\
		ULONG v;\
		MAC_PMTCSR_RGRD(v);\
		v = (v & (MAC_PMTCSR_RES_WR_MASK_27)) | (((0) & (MAC_PMTCSR_MASK_27)) << 27);\
		v = (v & (MAC_PMTCSR_RES_WR_MASK_10)) | (((0) & (MAC_PMTCSR_MASK_10)) << 10);\
		v = (v & (MAC_PMTCSR_RES_WR_MASK_7)) | (((0) & (MAC_PMTCSR_MASK_7)) << 7);\
		v = (v & (MAC_PMTCSR_RES_WR_MASK_3)) | (((0) & (MAC_PMTCSR_MASK_3)) << 3);\
		v = ((v & MAC_PMTCSR_MGKPKTEN_WR_MASK) | ((data & MAC_PMTCSR_MGKPKTEN_MASK) << 1));\
		MAC_PMTCSR_RGWR(v);\
} while (0)

#define MAC_PMTCSR_MGKPKTEN_UDFRD(data) do {\
		MAC_PMTCSR_RGRD(data);\
		data = ((data >> 1) & MAC_PMTCSR_MGKPKTEN_MASK);\
} while (0)

/*#define MAC_PMTCSR_PWRDWN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PMTCSR_PWRDWN_MASK (ULONG)(0x1)

/*#define MAC_PMTCSR_PWRDWN_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_PMTCSR_PWRDWN_WR_MASK (ULONG)(0xfffffffe)

#define MAC_PMTCSR_PWRDWN_UDFWR(data) do {\
		ULONG v;\
		MAC_PMTCSR_RGRD(v);\
		v = (v & (MAC_PMTCSR_RES_WR_MASK_27)) | (((0) & (MAC_PMTCSR_MASK_27)) << 27);\
		v = (v & (MAC_PMTCSR_RES_WR_MASK_10)) | (((0) & (MAC_PMTCSR_MASK_10)) << 10);\
		v = (v & (MAC_PMTCSR_RES_WR_MASK_7)) | (((0) & (MAC_PMTCSR_MASK_7)) << 7);\
		v = (v & (MAC_PMTCSR_RES_WR_MASK_3)) | (((0) & (MAC_PMTCSR_MASK_3)) << 3);\
		v = ((v & MAC_PMTCSR_PWRDWN_WR_MASK) | ((data & MAC_PMTCSR_PWRDWN_MASK) << 0));\
		MAC_PMTCSR_RGWR(v);\
} while (0)

#define MAC_PMTCSR_PWRDWN_UDFRD(data) do {\
		MAC_PMTCSR_RGRD(data);\
		data = ((data >> 0) & MAC_PMTCSR_PWRDWN_MASK);\
} while (0)

#define MMC_RXICMP_ERR_OCTETS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x884))

#define MMC_RXICMP_ERR_OCTETS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXICMP_ERR_OCTETS_RGOFFADDR);\
} while (0)

#define MMC_RXICMP_ERR_OCTETS_RXICMP_ERR_OCTETS_UDFRD(data) do {\
		MMC_RXICMP_ERR_OCTETS_RGRD(data);\
} while (0)

#define MMC_RXICMP_GD_OCTETS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x880))

#define MMC_RXICMP_GD_OCTETS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXICMP_GD_OCTETS_RGOFFADDR);\
} while (0)

#define MMC_RXICMP_GD_OCTETS_RXICMP_GD_OCTETS_UDFRD(data) do {\
		MMC_RXICMP_GD_OCTETS_RGRD(data);\
} while (0)

#define MMC_RXTCP_ERR_OCTETS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x87c))

#define MMC_RXTCP_ERR_OCTETS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXTCP_ERR_OCTETS_RGOFFADDR);\
} while (0)

#define MMC_RXTCP_ERR_OCTETS_RXTCP_ERR_OCTETS_UDFRD(data) do {\
		MMC_RXTCP_ERR_OCTETS_RGRD(data);\
} while (0)

#define MMC_RXTCP_GD_OCTETS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x878))

#define MMC_RXTCP_GD_OCTETS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXTCP_GD_OCTETS_RGOFFADDR);\
} while (0)

#define MMC_RXTCP_GD_OCTETS_RXTCP_GD_OCTETS_UDFRD(data) do {\
		MMC_RXTCP_GD_OCTETS_RGRD(data);\
} while (0)

#define MMC_RXUDP_ERR_OCTETS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x874))

#define MMC_RXUDP_ERR_OCTETS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXUDP_ERR_OCTETS_RGOFFADDR);\
} while (0)

#define MMC_RXUDP_ERR_OCTETS_RXUDP_ERR_OCTETS_UDFRD(data) do {\
		MMC_RXUDP_ERR_OCTETS_RGRD(data);\
} while (0)

#define MMC_RXUDP_GD_OCTETS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x870))

#define MMC_RXUDP_GD_OCTETS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXUDP_GD_OCTETS_RGOFFADDR);\
} while (0)

#define MMC_RXUDP_GD_OCTETS_RXUDP_GD_OCTETS_UDFRD(data) do {\
		MMC_RXUDP_GD_OCTETS_RGRD(data);\
} while (0)

#define MMC_RXIPV6_NOPAY_OCTETS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x86c))

#define MMC_RXIPV6_NOPAY_OCTETS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXIPV6_NOPAY_OCTETS_RGOFFADDR);\
} while (0)

#define MMC_RXIPV6_NOPAY_OCTETS_RXIPV6_NOPAY_OCTETS_UDFRD(data) do {\
		MMC_RXIPV6_NOPAY_OCTETS_RGRD(data);\
} while (0)

#define MMC_RXIPV6_HDRERR_OCTETS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x868))

#define MMC_RXIPV6_HDRERR_OCTETS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXIPV6_HDRERR_OCTETS_RGOFFADDR);\
} while (0)

#define MMC_RXIPV6_HDRERR_OCTETS_RXIPV6_HDRERR_OCTETS_UDFRD(data) do {\
		MMC_RXIPV6_HDRERR_OCTETS_RGRD(data);\
} while (0)

#define MMC_RXIPV6_GD_OCTETS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x864))

#define MMC_RXIPV6_GD_OCTETS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXIPV6_GD_OCTETS_RGOFFADDR);\
} while (0)

#define MMC_RXIPV6_GD_OCTETS_RXIPV6_GD_OCTETS_UDFRD(data) do {\
		MMC_RXIPV6_GD_OCTETS_RGRD(data);\
} while (0)

#define MMC_RXIPV4_UDSBL_OCTETS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x860))

#define MMC_RXIPV4_UDSBL_OCTETS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXIPV4_UDSBL_OCTETS_RGOFFADDR);\
} while (0)

#define MMC_RXIPV4_UDSBL_OCTETS_RXIPV4_UDSBL_OCTETS_UDFRD(data) do {\
		MMC_RXIPV4_UDSBL_OCTETS_RGRD(data);\
} while (0)

#define MMC_RXIPV4_FRAG_OCTETS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x85c))

#define MMC_RXIPV4_FRAG_OCTETS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXIPV4_FRAG_OCTETS_RGOFFADDR);\
} while (0)

#define MMC_RXIPV4_FRAG_OCTETS_RXIPV4_FRAG_OCTETS_UDFRD(data) do {\
		MMC_RXIPV4_FRAG_OCTETS_RGRD(data);\
} while (0)

#define MMC_RXIPV4_NOPAY_OCTETS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x858))

#define MMC_RXIPV4_NOPAY_OCTETS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXIPV4_NOPAY_OCTETS_RGOFFADDR);\
} while (0)

#define MMC_RXIPV4_NOPAY_OCTETS_RXIPV4_NOPAY_OCTETS_UDFRD(data) do {\
		MMC_RXIPV4_NOPAY_OCTETS_RGRD(data);\
} while (0)

#define MMC_RXIPV4_HDRERR_OCTETS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x854))

#define MMC_RXIPV4_HDRERR_OCTETS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXIPV4_HDRERR_OCTETS_RGOFFADDR);\
} while (0)

#define MMC_RXIPV4_HDRERR_OCTETS_RXIPV4_HDRERR_OCTETS_UDFRD(data) do {\
		MMC_RXIPV4_HDRERR_OCTETS_RGRD(data);\
} while (0)

#define MMC_RXIPV4_GD_OCTETS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x850))

#define MMC_RXIPV4_GD_OCTETS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXIPV4_GD_OCTETS_RGOFFADDR);\
} while (0)

#define MMC_RXIPV4_GD_OCTETS_RXIPV4_GD_OCTETS_UDFRD(data) do {\
		MMC_RXIPV4_GD_OCTETS_RGRD(data);\
} while (0)

#define MMC_RXICMP_ERR_PKTS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x844))

#define MMC_RXICMP_ERR_PKTS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXICMP_ERR_PKTS_RGOFFADDR);\
} while (0)

#define MMC_RXICMP_ERR_PKTS_RXICMP_ERR_PKTS_UDFRD(data) do {\
		MMC_RXICMP_ERR_PKTS_RGRD(data);\
} while (0)

#define MMC_RXICMP_GD_PKTS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x840))

#define MMC_RXICMP_GD_PKTS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXICMP_GD_PKTS_RGOFFADDR);\
} while (0)

#define MMC_RXICMP_GD_PKTS_RXICMP_GD_PKTS_UDFRD(data) do {\
		MMC_RXICMP_GD_PKTS_RGRD(data);\
} while (0)

#define MMC_RXTCP_ERR_PKTS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x83c))

#define MMC_RXTCP_ERR_PKTS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXTCP_ERR_PKTS_RGOFFADDR);\
} while (0)

#define MMC_RXTCP_ERR_PKTS_RXTCP_ERR_PKTS_UDFRD(data) do {\
		MMC_RXTCP_ERR_PKTS_RGRD(data);\
} while (0)

#define MMC_RXTCP_GD_PKTS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x838))

#define MMC_RXTCP_GD_PKTS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXTCP_GD_PKTS_RGOFFADDR);\
} while (0)

#define MMC_RXTCP_GD_PKTS_RXTCP_GD_PKTS_UDFRD(data) do {\
		MMC_RXTCP_GD_PKTS_RGRD(data);\
} while (0)

#define MMC_RXUDP_ERR_PKTS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x834))

#define MMC_RXUDP_ERR_PKTS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXUDP_ERR_PKTS_RGOFFADDR);\
} while (0)

#define MMC_RXUDP_ERR_PKTS_RXUDP_ERR_PKTS_UDFRD(data) do {\
		MMC_RXUDP_ERR_PKTS_RGRD(data);\
} while (0)

#define MMC_RXUDP_GD_PKTS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x830))

#define MMC_RXUDP_GD_PKTS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXUDP_GD_PKTS_RGOFFADDR);\
} while (0)

#define MMC_RXUDP_GD_PKTS_RXUDP_GD_PKTS_UDFRD(data) do {\
		MMC_RXUDP_GD_PKTS_RGRD(data);\
} while (0)

#define MMC_RXIPV6_NOPAY_PKTS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x82c))

#define MMC_RXIPV6_NOPAY_PKTS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXIPV6_NOPAY_PKTS_RGOFFADDR);\
} while (0)

#define MMC_RXIPV6_NOPAY_PKTS_RXIPV6_NOPAY_PKTS_UDFRD(data) do {\
		MMC_RXIPV6_NOPAY_PKTS_RGRD(data);\
} while (0)

#define MMC_RXIPV6_HDRERR_PKTS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x828))

#define MMC_RXIPV6_HDRERR_PKTS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXIPV6_HDRERR_PKTS_RGOFFADDR);\
} while (0)

#define MMC_RXIPV6_HDRERR_PKTS_RXIPV6_HDRERR_PKTS_UDFRD(data) do {\
		MMC_RXIPV6_HDRERR_PKTS_RGRD(data);\
} while (0)

#define MMC_RXIPV6_GD_PKTS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x824))

#define MMC_RXIPV6_GD_PKTS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXIPV6_GD_PKTS_RGOFFADDR);\
} while (0)

#define MMC_RXIPV6_GD_PKTS_RXIPV6_GD_PKTS_UDFRD(data) do {\
		MMC_RXIPV6_GD_PKTS_RGRD(data);\
} while (0)

#define MMC_RXIPV4_UBSBL_PKTS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x820))

#define MMC_RXIPV4_UBSBL_PKTS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXIPV4_UBSBL_PKTS_RGOFFADDR);\
} while (0)

#define MMC_RXIPV4_UBSBL_PKTS_RXIPV4_UBSBL_PKTS_UDFRD(data) do {\
		MMC_RXIPV4_UBSBL_PKTS_RGRD(data);\
} while (0)

#define MMC_RXIPV4_FRAG_PKTS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x81c))

#define MMC_RXIPV4_FRAG_PKTS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXIPV4_FRAG_PKTS_RGOFFADDR);\
} while (0)

#define MMC_RXIPV4_FRAG_PKTS_RXIPV4_FRAG_PKTS_UDFRD(data) do {\
		MMC_RXIPV4_FRAG_PKTS_RGRD(data);\
} while (0)

#define MMC_RXIPV4_NOPAY_PKTS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x818))

#define MMC_RXIPV4_NOPAY_PKTS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXIPV4_NOPAY_PKTS_RGOFFADDR);\
} while (0)

#define MMC_RXIPV4_NOPAY_PKTS_RXIPV4_NOPAY_PKTS_UDFRD(data) do {\
		MMC_RXIPV4_NOPAY_PKTS_RGRD(data);\
} while (0)

#define MMC_RXIPV4_HDRERR_PKTS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x814))

#define MMC_RXIPV4_HDRERR_PKTS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXIPV4_HDRERR_PKTS_RGOFFADDR);\
} while (0)

#define MMC_RXIPV4_HDRERR_PKTS_RXIPV4_HDRERR_PKTS_UDFRD(data) do {\
		MMC_RXIPV4_HDRERR_PKTS_RGRD(data);\
} while (0)

#define MMC_RXIPV4_GD_PKTS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x810))

#define MMC_RXIPV4_GD_PKTS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXIPV4_GD_PKTS_RGOFFADDR);\
} while (0)

#define MMC_RXIPV4_GD_PKTS_RXIPV4_GD_PKTS_UDFRD(data) do {\
		MMC_RXIPV4_GD_PKTS_RGRD(data);\
} while (0)

#define MMC_EMAC_RX_LPI_TRAN_CNTR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x000007F8))

#define MMC_EMAC_RX_LPI_TRAN_CNTR_RGRD(data) do {\
		(data) = ioread32((void *)MMC_EMAC_RX_LPI_TRAN_CNTR_RGOFFADDR);\
} while (0)

#define MMC_EMAC_TX_LPI_TRAN_CNTR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x000007F0))

#define MMC_EMAC_TX_LPI_TRAN_CNTR_RGRD(data) do {\
		(data) = ioread32((void *)MMC_EMAC_TX_LPI_TRAN_CNTR_RGOFFADDR);\
} while (0)

#define MMC_RXCTRLPACKETS_G_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x7e4))

#define MMC_RXCTRLPACKETS_G_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXCTRLPACKETS_G_RGOFFADDR);\
} while (0)

#define MMC_RXCTRLPACKETS_G_RXCTRLPACKETS_G_UDFRD(data) do {\
		MMC_RXCTRLPACKETS_G_RGRD(data);\
} while (0)

#define MMC_RXRCVERROR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x7e0))

#define MMC_RXRCVERROR_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXRCVERROR_RGOFFADDR);\
} while (0)

#define MMC_RXRCVERROR_RXRCVERROR_UDFRD(data) do {\
		MMC_RXRCVERROR_RGRD(data);\
} while (0)

#define MMC_RXWATCHDOGERROR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x7dc))

#define MMC_RXWATCHDOGERROR_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXWATCHDOGERROR_RGOFFADDR);\
} while (0)

#define MMC_RXWATCHDOGERROR_RXWATCHDOGERROR_UDFRD(data) do {\
		MMC_RXWATCHDOGERROR_RGRD(data);\
} while (0)

#define MMC_RXVLANPACKETS_GB_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x7d8))

#define MMC_RXVLANPACKETS_GB_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXVLANPACKETS_GB_RGOFFADDR);\
} while (0)

#define MMC_RXVLANPACKETS_GB_RXVLANPACKETS_GB_UDFRD(data) do {\
		MMC_RXVLANPACKETS_GB_RGRD(data);\
} while (0)

#define MMC_RXFIFOOVERFLOW_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x7d4))

#define MMC_RXFIFOOVERFLOW_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXFIFOOVERFLOW_RGOFFADDR);\
} while (0)

#define MMC_RXFIFOOVERFLOW_RXFIFOOVERFLOW_UDFRD(data) do {\
		MMC_RXFIFOOVERFLOW_RGRD(data);\
} while (0)

#define MMC_RXPAUSEPACKETS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x7d0))

#define MMC_RXPAUSEPACKETS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXPAUSEPACKETS_RGOFFADDR);\
} while (0)

#define MMC_RXPAUSEPACKETS_RXPAUSEPACKETS_UDFRD(data) do {\
		MMC_RXPAUSEPACKETS_RGRD(data);\
} while (0)

#define MMC_RXOUTOFRANGETYPE_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x7cc))

#define MMC_RXOUTOFRANGETYPE_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXOUTOFRANGETYPE_RGOFFADDR);\
} while (0)

#define MMC_RXOUTOFRANGETYPE_RXOUTOFRANGETYPE_UDFRD(data) do {\
		MMC_RXOUTOFRANGETYPE_RGRD(data);\
} while (0)

#define MMC_RXLENGTHERROR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x7c8))

#define MMC_RXLENGTHERROR_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXLENGTHERROR_RGOFFADDR);\
} while (0)

#define MMC_RXLENGTHERROR_RXLENGTHERROR_UDFRD(data) do {\
		MMC_RXLENGTHERROR_RGRD(data);\
} while (0)

#define MMC_RXUNICASTPACKETS_G_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x7c4))

#define MMC_RXUNICASTPACKETS_G_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXUNICASTPACKETS_G_RGOFFADDR);\
} while (0)

#define MMC_RXUNICASTPACKETS_G_RXUNICASTPACKETS_G_UDFRD(data) do {\
		MMC_RXUNICASTPACKETS_G_RGRD(data);\
} while (0)

#define MMC_RX1024TOMAXOCTETS_GB_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x7c0))

#define MMC_RX1024TOMAXOCTETS_GB_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RX1024TOMAXOCTETS_GB_RGOFFADDR);\
} while (0)

#define MMC_RX1024TOMAXOCTETS_GB_RX1024TOMAXOCTETS_GB_UDFRD(data) do {\
		MMC_RX1024TOMAXOCTETS_GB_RGRD(data);\
} while (0)

#define MMC_RX512TO1023OCTETS_GB_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x7bc))

#define MMC_RX512TO1023OCTETS_GB_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RX512TO1023OCTETS_GB_RGOFFADDR);\
} while (0)

#define MMC_RX512TO1023OCTETS_GB_RX512TO1023OCTETS_GB_UDFRD(data) do {\
		MMC_RX512TO1023OCTETS_GB_RGRD(data);\
} while (0)

#define MMC_RX256TO511OCTETS_GB_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x7b8))

#define MMC_RX256TO511OCTETS_GB_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RX256TO511OCTETS_GB_RGOFFADDR);\
} while (0)

#define MMC_RX256TO511OCTETS_GB_RX256TO511OCTETS_GB_UDFRD(data) do {\
		MMC_RX256TO511OCTETS_GB_RGRD(data);\
} while (0)

#define MMC_RX128TO255OCTETS_GB_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x7b4))

#define MMC_RX128TO255OCTETS_GB_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RX128TO255OCTETS_GB_RGOFFADDR);\
} while (0)

#define MMC_RX128TO255OCTETS_GB_RX128TO255OCTETS_GB_UDFRD(data) do {\
		MMC_RX128TO255OCTETS_GB_RGRD(data);\
} while (0)

#define MMC_RX65TO127OCTETS_GB_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x7b0))

#define MMC_RX65TO127OCTETS_GB_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RX65TO127OCTETS_GB_RGOFFADDR);\
} while (0)

#define MMC_RX65TO127OCTETS_GB_RX65TO127OCTETS_GB_UDFRD(data) do {\
		MMC_RX65TO127OCTETS_GB_RGRD(data);\
} while (0)

#define MMC_RX64OCTETS_GB_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x7ac))

#define MMC_RX64OCTETS_GB_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RX64OCTETS_GB_RGOFFADDR);\
} while (0)

#define MMC_RX64OCTETS_GB_RX64OCTETS_GB_UDFRD(data) do {\
		MMC_RX64OCTETS_GB_RGRD(data);\
} while (0)

#define MMC_RXOVERSIZE_G_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x7a8))

#define MMC_RXOVERSIZE_G_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXOVERSIZE_G_RGOFFADDR);\
} while (0)

#define MMC_RXOVERSIZE_G_RXOVERSIZE_G_UDFRD(data) do {\
		MMC_RXOVERSIZE_G_RGRD(data);\
} while (0)

#define MMC_RXUNDERSIZE_G_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x7a4))

#define MMC_RXUNDERSIZE_G_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXUNDERSIZE_G_RGOFFADDR);\
} while (0)

#define MMC_RXUNDERSIZE_G_RXUNDERSIZE_G_UDFRD(data) do {\
		MMC_RXUNDERSIZE_G_RGRD(data);\
} while (0)

#define MMC_RXJABBERERROR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x7a0))

#define MMC_RXJABBERERROR_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXJABBERERROR_RGOFFADDR);\
} while (0)

#define MMC_RXJABBERERROR_RXJABBERERROR_UDFRD(data) do {\
		MMC_RXJABBERERROR_RGRD(data);\
} while (0)

#define MMC_RXRUNTERROR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x79c))

#define MMC_RXRUNTERROR_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXRUNTERROR_RGOFFADDR);\
} while (0)

#define MMC_RXRUNTERROR_RXRUNTERROR_UDFRD(data) do {\
		MMC_RXRUNTERROR_RGRD(data);\
} while (0)

#define MMC_RXALIGNMENTERROR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x798))

#define MMC_RXALIGNMENTERROR_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXALIGNMENTERROR_RGOFFADDR);\
} while (0)

#define MMC_RXALIGNMENTERROR_RXALIGNMENTERROR_UDFRD(data) do {\
		MMC_RXALIGNMENTERROR_RGRD(data);\
} while (0)

#define MMC_RXCRCERROR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x794))

#define MMC_RXCRCERROR_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXCRCERROR_RGOFFADDR);\
} while (0)

#define MMC_RXCRCERROR_RXCRCERROR_UDFRD(data) do {\
		MMC_RXCRCERROR_RGRD(data);\
} while (0)

#define MMC_RXMULTICASTPACKETS_G_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x790))

#define MMC_RXMULTICASTPACKETS_G_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXMULTICASTPACKETS_G_RGOFFADDR);\
} while (0)

#define MMC_RXMULTICASTPACKETS_G_RXMULTICASTPACKETS_G_UDFRD(data) do {\
		MMC_RXMULTICASTPACKETS_G_RGRD(data);\
} while (0)

#define MMC_RXBROADCASTPACKETS_G_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x78c))

#define MMC_RXBROADCASTPACKETS_G_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXBROADCASTPACKETS_G_RGOFFADDR);\
} while (0)

#define MMC_RXBROADCASTPACKETS_G_RXBROADCASTPACKETS_G_UDFRD(data) do {\
		MMC_RXBROADCASTPACKETS_G_RGRD(data);\
} while (0)

#define MMC_RXOCTETCOUNT_G_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x788))

#define MMC_RXOCTETCOUNT_G_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXOCTETCOUNT_G_RGOFFADDR);\
} while (0)

#define MMC_RXOCTETCOUNT_G_RXOCTETCOUNT_G_UDFRD(data) do {\
		MMC_RXOCTETCOUNT_G_RGRD(data);\
} while (0)

#define MMC_RXOCTETCOUNT_GB_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x784))

#define MMC_RXOCTETCOUNT_GB_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXOCTETCOUNT_GB_RGOFFADDR);\
} while (0)

#define MMC_RXOCTETCOUNT_GB_RXOCTETCOUNT_GB_UDFRD(data) do {\
		MMC_RXOCTETCOUNT_GB_RGRD(data);\
} while (0)

#define MMC_RXPACKETCOUNT_GB_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x780))

#define MMC_RXPACKETCOUNT_GB_RGRD(data) do {\
		(data) = ioread32((void *)MMC_RXPACKETCOUNT_GB_RGOFFADDR);\
} while (0)

#define MMC_RXPACKETCOUNT_GB_RXPACKETCOUNT_GB_UDFRD(data) do {\
		MMC_RXPACKETCOUNT_GB_RGRD(data);\
} while (0)

#define MMC_TXOVERSIZE_G_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x778))

#define MMC_TXOVERSIZE_G_RGRD(data) do {\
		(data) = ioread32((void *)MMC_TXOVERSIZE_G_RGOFFADDR);\
} while (0)

#define MMC_TXOVERSIZE_G_TXOVERSIZE_G_UDFRD(data) do {\
		MMC_TXOVERSIZE_G_RGRD(data);\
} while (0)

#define MMC_TXVLANPACKETS_G_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x774))

#define MMC_TXVLANPACKETS_G_RGRD(data) do {\
		(data) = ioread32((void *)MMC_TXVLANPACKETS_G_RGOFFADDR);\
} while (0)

#define MMC_TXVLANPACKETS_G_TXVLANPACKETS_G_UDFRD(data) do {\
		MMC_TXVLANPACKETS_G_RGRD(data);\
} while (0)

#define MMC_TXPAUSEPACKETS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x770))

#define MMC_TXPAUSEPACKETS_RGRD(data) do {\
		(data) = ioread32((void *)MMC_TXPAUSEPACKETS_RGOFFADDR);\
} while (0)

#define MMC_TXPAUSEPACKETS_TXPAUSEPACKETS_UDFRD(data) do {\
		MMC_TXPAUSEPACKETS_RGRD(data);\
} while (0)

#define MMC_TXEXCESSDEF_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x76c))

#define MMC_TXEXCESSDEF_RGRD(data) do {\
		(data) = ioread32((void *)MMC_TXEXCESSDEF_RGOFFADDR);\
} while (0)

#define MMC_TXEXCESSDEF_TXEXCESSDEF_UDFRD(data) do {\
		MMC_TXEXCESSDEF_RGRD(data);\
} while (0)

#define MMC_TXPACKETSCOUNT_G_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x768))

#define MMC_TXPACKETSCOUNT_G_RGRD(data) do {\
		(data) = ioread32((void *)MMC_TXPACKETSCOUNT_G_RGOFFADDR);\
} while (0)

#define MMC_TXPACKETSCOUNT_G_TXPACKETSCOUNT_G_UDFRD(data) do {\
		MMC_TXPACKETSCOUNT_G_RGRD(data);\
} while (0)

#define MMC_TXOCTETCOUNT_G_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x764))

#define MMC_TXOCTETCOUNT_G_RGRD(data) do {\
		(data) = ioread32((void *)MMC_TXOCTETCOUNT_G_RGOFFADDR);\
} while (0)

#define MMC_TXOCTETCOUNT_G_TXOCTETCOUNT_G_UDFRD(data) do {\
		MMC_TXOCTETCOUNT_G_RGRD(data);\
} while (0)

#define MMC_TXCARRIERERROR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x760))

#define MMC_TXCARRIERERROR_RGRD(data) do {\
		(data) = ioread32((void *)MMC_TXCARRIERERROR_RGOFFADDR);\
} while (0)

#define MMC_TXCARRIERERROR_TXCARRIERERROR_UDFRD(data) do {\
		MMC_TXCARRIERERROR_RGRD(data);\
} while (0)

#define MMC_TXEXESSCOL_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x75c))

#define MMC_TXEXESSCOL_RGRD(data) do {\
		(data) = ioread32((void *)MMC_TXEXESSCOL_RGOFFADDR);\
} while (0)

#define MMC_TXEXESSCOL_TXEXESSCOL_UDFRD(data) do {\
		MMC_TXEXESSCOL_RGRD(data);\
} while (0)

#define MMC_TXLATECOL_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x758))

#define MMC_TXLATECOL_RGRD(data) do {\
		(data) = ioread32((void *)MMC_TXLATECOL_RGOFFADDR);\
} while (0)

#define MMC_TXLATECOL_TXLATECOL_UDFRD(data) do {\
		MMC_TXLATECOL_RGRD(data);\
} while (0)

#define MMC_TXDEFERRED_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x754))

#define MMC_TXDEFERRED_RGRD(data) do {\
		(data) = ioread32((void *)MMC_TXDEFERRED_RGOFFADDR);\
} while (0)

#define MMC_TXDEFERRED_TXDEFERRED_UDFRD(data) do {\
		MMC_TXDEFERRED_RGRD(data);\
} while (0)

#define MMC_TXMULTICOL_G_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x750))

#define MMC_TXMULTICOL_G_RGRD(data) do {\
		(data) = ioread32((void *)MMC_TXMULTICOL_G_RGOFFADDR);\
} while (0)

#define MMC_TXMULTICOL_G_TXMULTICOL_G_UDFRD(data) do {\
		MMC_TXMULTICOL_G_RGRD(data);\
} while (0)

#define MMC_TXSINGLECOL_G_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x74c))

#define MMC_TXSINGLECOL_G_RGRD(data) do {\
		(data) = ioread32((void *)MMC_TXSINGLECOL_G_RGOFFADDR);\
} while (0)

#define MMC_TXSINGLECOL_G_TXSINGLECOL_G_UDFRD(data) do {\
		MMC_TXSINGLECOL_G_RGRD(data);\
} while (0)

#define MMC_TXUNDERFLOWERROR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x748))

#define MMC_TXUNDERFLOWERROR_RGRD(data) do {\
		(data) = ioread32((void *)MMC_TXUNDERFLOWERROR_RGOFFADDR);\
} while (0)

#define MMC_TXUNDERFLOWERROR_TXUNDERFLOWERROR_UDFRD(data) do {\
		MMC_TXUNDERFLOWERROR_RGRD(data);\
} while (0)

#define MMC_TXBROADCASTPACKETS_GB_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x744))

#define MMC_TXBROADCASTPACKETS_GB_RGRD(data) do {\
		(data) = ioread32((void *)MMC_TXBROADCASTPACKETS_GB_RGOFFADDR);\
} while (0)

#define MMC_TXBROADCASTPACKETS_GB_TXBROADCASTPACKETS_GB_UDFRD(data) do {\
		MMC_TXBROADCASTPACKETS_GB_RGRD(data);\
} while (0)

#define MMC_TXMULTICASTPACKETS_GB_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x740))

#define MMC_TXMULTICASTPACKETS_GB_RGRD(data) do {\
		(data) = ioread32((void *)MMC_TXMULTICASTPACKETS_GB_RGOFFADDR);\
} while (0)

#define MMC_TXMULTICASTPACKETS_GB_TXMULTICASTPACKETS_GB_UDFRD(data) do {\
		MMC_TXMULTICASTPACKETS_GB_RGRD(data);\
} while (0)

#define MMC_TXUNICASTPACKETS_GB_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x73c))

#define MMC_TXUNICASTPACKETS_GB_RGRD(data) do {\
		(data) = ioread32((void *)MMC_TXUNICASTPACKETS_GB_RGOFFADDR);\
} while (0)

#define MMC_TXUNICASTPACKETS_GB_TXUNICASTPACKETS_GB_UDFRD(data) do {\
		MMC_TXUNICASTPACKETS_GB_RGRD(data);\
} while (0)

#define MMC_TX1024TOMAXOCTETS_GB_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x738))

#define MMC_TX1024TOMAXOCTETS_GB_RGRD(data) do {\
		(data) = ioread32((void *)MMC_TX1024TOMAXOCTETS_GB_RGOFFADDR);\
} while (0)

#define MMC_TX1024TOMAXOCTETS_GB_TX1024TOMAXOCTETS_GB_UDFRD(data) do {\
		MMC_TX1024TOMAXOCTETS_GB_RGRD(data);\
} while (0)

#define MMC_TX512TO1023OCTETS_GB_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x734))

#define MMC_TX512TO1023OCTETS_GB_RGRD(data) do {\
		(data) = ioread32((void *)MMC_TX512TO1023OCTETS_GB_RGOFFADDR);\
} while (0)

#define MMC_TX512TO1023OCTETS_GB_TX512TO1023OCTETS_GB_UDFRD(data) do {\
		MMC_TX512TO1023OCTETS_GB_RGRD(data);\
} while (0)

#define MMC_TX256TO511OCTETS_GB_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x730))

#define MMC_TX256TO511OCTETS_GB_RGRD(data) do {\
		(data) = ioread32((void *)MMC_TX256TO511OCTETS_GB_RGOFFADDR);\
} while (0)

#define MMC_TX256TO511OCTETS_GB_TX256TO511OCTETS_GB_UDFRD(data) do {\
		MMC_TX256TO511OCTETS_GB_RGRD(data);\
} while (0)

#define MMC_TX128TO255OCTETS_GB_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x72c))

#define MMC_TX128TO255OCTETS_GB_RGRD(data) do {\
		(data) = ioread32((void *)MMC_TX128TO255OCTETS_GB_RGOFFADDR);\
} while (0)

#define MMC_TX128TO255OCTETS_GB_TX128TO255OCTETS_GB_UDFRD(data) do {\
		MMC_TX128TO255OCTETS_GB_RGRD(data);\
} while (0)

#define MMC_TX65TO127OCTETS_GB_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x728))

#define MMC_TX65TO127OCTETS_GB_RGRD(data) do {\
		(data) = ioread32((void *)MMC_TX65TO127OCTETS_GB_RGOFFADDR);\
} while (0)

#define MMC_TX65TO127OCTETS_GB_TX65TO127OCTETS_GB_UDFRD(data) do {\
		MMC_TX65TO127OCTETS_GB_RGRD(data);\
} while (0)

#define MMC_TX64OCTETS_GB_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x724))

#define MMC_TX64OCTETS_GB_RGRD(data) do {\
		(data) = ioread32((void *)MMC_TX64OCTETS_GB_RGOFFADDR);\
} while (0)

#define MMC_TX64OCTETS_GB_TX64OCTETS_GB_UDFRD(data) do {\
		MMC_TX64OCTETS_GB_RGRD(data);\
} while (0)

#define MMC_TXMULTICASTPACKETS_G_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x720))

#define MMC_TXMULTICASTPACKETS_G_RGRD(data) do {\
		(data) = ioread32((void *)MMC_TXMULTICASTPACKETS_G_RGOFFADDR);\
} while (0)

#define MMC_TXMULTICASTPACKETS_G_TXMULTICASTPACKETS_G_UDFRD(data) do {\
		MMC_TXMULTICASTPACKETS_G_RGRD(data);\
} while (0)

#define MMC_TXBROADCASTPACKETS_G_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x71c))

#define MMC_TXBROADCASTPACKETS_G_RGRD(data) do {\
		(data) = ioread32((void *)MMC_TXBROADCASTPACKETS_G_RGOFFADDR);\
} while (0)

#define MMC_TXBROADCASTPACKETS_G_TXBROADCASTPACKETS_G_UDFRD(data) do {\
		MMC_TXBROADCASTPACKETS_G_RGRD(data);\
} while (0)

#define MMC_TXPACKETCOUNT_GB_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x718))

#define MMC_TXPACKETCOUNT_GB_RGRD(data) do {\
		(data) = ioread32((void *)MMC_TXPACKETCOUNT_GB_RGOFFADDR);\
} while (0)

#define MMC_TXPACKETCOUNT_GB_TXPACKETCOUNT_GB_UDFRD(data) do {\
		MMC_TXPACKETCOUNT_GB_RGRD(data);\
} while (0)

#define MMC_TXOCTETCOUNT_GB_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x714))

#define MMC_TXOCTETCOUNT_GB_RGRD(data) do {\
		(data) = ioread32((void *)MMC_TXOCTETCOUNT_GB_RGOFFADDR);\
} while (0)

#define MMC_TXOCTETCOUNT_GB_TXOCTETCOUNT_GB_UDFRD(data) do {\
		MMC_TXOCTETCOUNT_GB_RGRD(data);\
} while (0)

#define MMC_IPC_INTR_RX_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x808))

#define MMC_IPC_INTR_RX_RGRD(data) do {\
		(data) = ioread32((void *)MMC_IPC_INTR_RX_RGOFFADDR);\
} while (0)

/*#define MMC_IPC_INTR_RX_RXICMP_ERR_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXICMP_ERR_OCTETS_MASK (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXICMP_ERR_OCTETS_UDFRD(data) do {\
		MMC_IPC_INTR_RX_RGRD(data);\
		data = ((data >> 29) & MMC_IPC_INTR_RX_RXICMP_ERR_OCTETS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_RX_RXICMP_GD_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXICMP_GD_OCTETS_MASK (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXICMP_GD_OCTETS_UDFRD(data) do {\
		MMC_IPC_INTR_RX_RGRD(data);\
		data = ((data >> 28) & MMC_IPC_INTR_RX_RXICMP_GD_OCTETS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_RX_RXTCP_ERR_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXTCP_ERR_OCTETS_MASK (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXTCP_ERR_OCTETS_UDFRD(data) do {\
		MMC_IPC_INTR_RX_RGRD(data);\
		data = ((data >> 27) & MMC_IPC_INTR_RX_RXTCP_ERR_OCTETS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_RX_RXTCP_GD_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXTCP_GD_OCTETS_MASK (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXTCP_GD_OCTETS_UDFRD(data) do {\
		MMC_IPC_INTR_RX_RGRD(data);\
		data = ((data >> 26) & MMC_IPC_INTR_RX_RXTCP_GD_OCTETS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_RX_RXUDP_ERR_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXUDP_ERR_OCTETS_MASK (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXUDP_ERR_OCTETS_UDFRD(data) do {\
		MMC_IPC_INTR_RX_RGRD(data);\
		data = ((data >> 25) & MMC_IPC_INTR_RX_RXUDP_ERR_OCTETS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_RX_RXUDP_GD_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXUDP_GD_OCTETS_MASK (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXUDP_GD_OCTETS_UDFRD(data) do {\
		MMC_IPC_INTR_RX_RGRD(data);\
		data = ((data >> 24) & MMC_IPC_INTR_RX_RXUDP_GD_OCTETS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_RX_RXIPV6_NOPAY_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV6_NOPAY_OCTETS_MASK (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV6_NOPAY_OCTETS_UDFRD(data) do {\
		MMC_IPC_INTR_RX_RGRD(data);\
		data = ((data >> 23) & MMC_IPC_INTR_RX_RXIPV6_NOPAY_OCTETS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_RX_RXIPV6_HDRERR_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV6_HDRERR_OCTETS_MASK (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV6_HDRERR_OCTETS_UDFRD(data) do {\
		MMC_IPC_INTR_RX_RGRD(data);\
		data = ((data >> 22) & MMC_IPC_INTR_RX_RXIPV6_HDRERR_OCTETS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_RX_RXIPV6_GD_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV6_GD_OCTETS_MASK (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV6_GD_OCTETS_UDFRD(data) do {\
		MMC_IPC_INTR_RX_RGRD(data);\
		data = ((data >> 21) & MMC_IPC_INTR_RX_RXIPV6_GD_OCTETS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_RX_RXIPV4_UDSBL_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV4_UDSBL_OCTETS_MASK (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV4_UDSBL_OCTETS_UDFRD(data) do {\
		MMC_IPC_INTR_RX_RGRD(data);\
		data = ((data >> 20) & MMC_IPC_INTR_RX_RXIPV4_UDSBL_OCTETS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_RX_RXIPV4_FRAG_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV4_FRAG_OCTETS_MASK (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV4_FRAG_OCTETS_UDFRD(data) do {\
		MMC_IPC_INTR_RX_RGRD(data);\
		data = ((data >> 19) & MMC_IPC_INTR_RX_RXIPV4_FRAG_OCTETS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_RX_RXIPV4_NOPAY_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV4_NOPAY_OCTETS_MASK (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV4_NOPAY_OCTETS_UDFRD(data) do {\
		MMC_IPC_INTR_RX_RGRD(data);\
		data = ((data >> 18) & MMC_IPC_INTR_RX_RXIPV4_NOPAY_OCTETS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_RX_RXIPV4_HDRERR_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV4_HDRERR_OCTETS_MASK (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV4_HDRERR_OCTETS_UDFRD(data) do {\
		MMC_IPC_INTR_RX_RGRD(data);\
		data = ((data >> 17) & MMC_IPC_INTR_RX_RXIPV4_HDRERR_OCTETS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_RX_RXIPV4_GD_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV4_GD_OCTETS_MASK (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV4_GD_OCTETS_UDFRD(data) do {\
		MMC_IPC_INTR_RX_RGRD(data);\
		data = ((data >> 16) & MMC_IPC_INTR_RX_RXIPV4_GD_OCTETS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_RX_RXICMP_ERR_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXICMP_ERR_FRMS_MASK (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXICMP_ERR_FRMS_UDFRD(data) do {\
		MMC_IPC_INTR_RX_RGRD(data);\
		data = ((data >> 13) & MMC_IPC_INTR_RX_RXICMP_ERR_FRMS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_RX_RXICMP_GD_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXICMP_GD_FRMS_MASK (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXICMP_GD_FRMS_UDFRD(data) do {\
		MMC_IPC_INTR_RX_RGRD(data);\
		data = ((data >> 12) & MMC_IPC_INTR_RX_RXICMP_GD_FRMS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_RX_RXTCP_ERR_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXTCP_ERR_FRMS_MASK (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXTCP_ERR_FRMS_UDFRD(data) do {\
		MMC_IPC_INTR_RX_RGRD(data);\
		data = ((data >> 11) & MMC_IPC_INTR_RX_RXTCP_ERR_FRMS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_RX_RXTCP_GD_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXTCP_GD_FRMS_MASK (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXTCP_GD_FRMS_UDFRD(data) do {\
		MMC_IPC_INTR_RX_RGRD(data);\
		data = ((data >> 10) & MMC_IPC_INTR_RX_RXTCP_GD_FRMS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_RX_RXUDP_ERR_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXUDP_ERR_FRMS_MASK (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXUDP_ERR_FRMS_UDFRD(data) do {\
		MMC_IPC_INTR_RX_RGRD(data);\
		data = ((data >> 9) & MMC_IPC_INTR_RX_RXUDP_ERR_FRMS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_RX_RXUDP_GD_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXUDP_GD_FRMS_MASK (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXUDP_GD_FRMS_UDFRD(data) do {\
		MMC_IPC_INTR_RX_RGRD(data);\
		data = ((data >> 8) & MMC_IPC_INTR_RX_RXUDP_GD_FRMS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_RX_RXIPV6_NOPAY_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV6_NOPAY_FRMS_MASK (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV6_NOPAY_FRMS_UDFRD(data) do {\
		MMC_IPC_INTR_RX_RGRD(data);\
		data = ((data >> 7) & MMC_IPC_INTR_RX_RXIPV6_NOPAY_FRMS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_RX_RXIPV6_HDRERR_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV6_HDRERR_FRMS_MASK (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV6_HDRERR_FRMS_UDFRD(data) do {\
		MMC_IPC_INTR_RX_RGRD(data);\
		data = ((data >> 6) & MMC_IPC_INTR_RX_RXIPV6_HDRERR_FRMS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_RX_RXIPV6_GD_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV6_GD_FRMS_MASK (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV6_GD_FRMS_UDFRD(data) do {\
		MMC_IPC_INTR_RX_RGRD(data);\
		data = ((data >> 5) & MMC_IPC_INTR_RX_RXIPV6_GD_FRMS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_RX_RXIPV4_UDSBL_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV4_UDSBL_FRMS_MASK (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV4_UDSBL_FRMS_UDFRD(data) do {\
		MMC_IPC_INTR_RX_RGRD(data);\
		data = ((data >> 4) & MMC_IPC_INTR_RX_RXIPV4_UDSBL_FRMS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_RX_RXIPV4_FRAG_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV4_FRAG_FRMS_MASK (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV4_FRAG_FRMS_UDFRD(data) do {\
		MMC_IPC_INTR_RX_RGRD(data);\
		data = ((data >> 3) & MMC_IPC_INTR_RX_RXIPV4_FRAG_FRMS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_RX_RXIPV4_NOPAY_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV4_NOPAY_FRMS_MASK (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV4_NOPAY_FRMS_UDFRD(data) do {\
		MMC_IPC_INTR_RX_RGRD(data);\
		data = ((data >> 2) & MMC_IPC_INTR_RX_RXIPV4_NOPAY_FRMS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_RX_RXIPV4_HDRERR_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV4_HDRERR_FRMS_MASK (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV4_HDRERR_FRMS_UDFRD(data) do {\
		MMC_IPC_INTR_RX_RGRD(data);\
		data = ((data >> 1) & MMC_IPC_INTR_RX_RXIPV4_HDRERR_FRMS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_RX_RXIPV4_GD_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV4_GD_FRMS_MASK (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV4_GD_FRMS_UDFRD(data) do {\
		MMC_IPC_INTR_RX_RGRD(data);\
		data = ((data >> 0) & MMC_IPC_INTR_RX_RXIPV4_GD_FRMS_MASK);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x800))

#define MMC_IPC_INTR_MASK_RX_RGWR(data) do {\
		iowrite32(data, (void *)MMC_IPC_INTR_MASK_RX_RGOFFADDR);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RGRD(data) do {\
		(data) = ioread32((void *)MMC_IPC_INTR_MASK_RX_RGOFFADDR);\
} while (0)

/*#define  MMC_IPC_INTR_MASK_RX_Mask_30 (ULONG)(~(~0<<(2)))*/

#define  MMC_IPC_INTR_MASK_RX_MASK_30 (ULONG)(0x3)

/*#define MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30 (ULONG)(~((~(~0<<(2)))<<(30)))*/

#define MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30 (ULONG)(0x3fffffff)

/*#define  MMC_IPC_INTR_MASK_RX_Mask_14 (ULONG)(~(~0<<(2)))*/

#define  MMC_IPC_INTR_MASK_RX_MASK_14 (ULONG)(0x3)

/*#define MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14 (ULONG)(~((~(~0<<(2)))<<(14)))*/

#define MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14 (ULONG)(0xffff3fff)

/*#define MMC_IPC_INTR_MASK_RX_RXICMP_ERR_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXICMP_ERR_OCTETS_MASK (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXICMP_ERR_OCTETS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (29)))*/

#define MMC_IPC_INTR_MASK_RX_RXICMP_ERR_OCTETS_WR_MASK (ULONG)(0xdfffffff)

#define MMC_IPC_INTR_MASK_RX_RXICMP_ERR_OCTETS_UDFWR(data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_30)) << 30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_14)) << 14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXICMP_ERR_OCTETS_WR_MASK) | ((data & MMC_IPC_INTR_MASK_RX_RXICMP_ERR_OCTETS_MASK) << 29));\
		MMC_IPC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RXICMP_ERR_OCTETS_UDFRD(data) do {\
		MMC_IPC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 29) & MMC_IPC_INTR_MASK_RX_RXICMP_ERR_OCTETS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_MASK_RX_RXICMP_GD_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXICMP_GD_OCTETS_MASK (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXICMP_GD_OCTETS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (28)))*/

#define MMC_IPC_INTR_MASK_RX_RXICMP_GD_OCTETS_WR_MASK (ULONG)(0xefffffff)

#define MMC_IPC_INTR_MASK_RX_RXICMP_GD_OCTETS_UDFWR(data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_30)) << 30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_14)) << 14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXICMP_GD_OCTETS_WR_MASK) | ((data & MMC_IPC_INTR_MASK_RX_RXICMP_GD_OCTETS_MASK) << 28));\
		MMC_IPC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RXICMP_GD_OCTETS_UDFRD(data) do {\
		MMC_IPC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 28) & MMC_IPC_INTR_MASK_RX_RXICMP_GD_OCTETS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_MASK_RX_RXTCP_ERR_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXTCP_ERR_OCTETS_MASK (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXTCP_ERR_OCTETS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define MMC_IPC_INTR_MASK_RX_RXTCP_ERR_OCTETS_WR_MASK (ULONG)(0xf7ffffff)

#define MMC_IPC_INTR_MASK_RX_RXTCP_ERR_OCTETS_UDFWR(data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_30)) << 30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_14)) << 14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXTCP_ERR_OCTETS_WR_MASK) | ((data & MMC_IPC_INTR_MASK_RX_RXTCP_ERR_OCTETS_MASK) << 27));\
		MMC_IPC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RXTCP_ERR_OCTETS_UDFRD(data) do {\
		MMC_IPC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 27) & MMC_IPC_INTR_MASK_RX_RXTCP_ERR_OCTETS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_MASK_RX_RXTCP_GD_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXTCP_GD_OCTETS_MASK (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXTCP_GD_OCTETS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (26)))*/

#define MMC_IPC_INTR_MASK_RX_RXTCP_GD_OCTETS_WR_MASK (ULONG)(0xfbffffff)

#define MMC_IPC_INTR_MASK_RX_RXTCP_GD_OCTETS_UDFWR(data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_30)) << 30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_14)) << 14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXTCP_GD_OCTETS_WR_MASK) | ((data & MMC_IPC_INTR_MASK_RX_RXTCP_GD_OCTETS_MASK) << 26));\
		MMC_IPC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RXTCP_GD_OCTETS_UDFRD(data) do {\
		MMC_IPC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 26) & MMC_IPC_INTR_MASK_RX_RXTCP_GD_OCTETS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_MASK_RX_RXUDP_ERR_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXUDP_ERR_OCTETS_MASK (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXUDP_ERR_OCTETS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (25)))*/

#define MMC_IPC_INTR_MASK_RX_RXUDP_ERR_OCTETS_WR_MASK (ULONG)(0xfdffffff)

#define MMC_IPC_INTR_MASK_RX_RXUDP_ERR_OCTETS_UDFWR(data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_30)) << 30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_14)) << 14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXUDP_ERR_OCTETS_WR_MASK) | ((data & MMC_IPC_INTR_MASK_RX_RXUDP_ERR_OCTETS_MASK) << 25));\
		MMC_IPC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RXUDP_ERR_OCTETS_UDFRD(data) do {\
		MMC_IPC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 25) & MMC_IPC_INTR_MASK_RX_RXUDP_ERR_OCTETS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_MASK_RX_RXUDP_GD_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXUDP_GD_OCTETS_MASK (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXUDP_GD_OCTETS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define MMC_IPC_INTR_MASK_RX_RXUDP_GD_OCTETS_WR_MASK (ULONG)(0xfeffffff)

#define MMC_IPC_INTR_MASK_RX_RXUDP_GD_OCTETS_UDFWR(data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_30)) << 30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_14)) << 14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXUDP_GD_OCTETS_WR_MASK) | ((data & MMC_IPC_INTR_MASK_RX_RXUDP_GD_OCTETS_MASK) << 24));\
		MMC_IPC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RXUDP_GD_OCTETS_UDFRD(data) do {\
		MMC_IPC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 24) & MMC_IPC_INTR_MASK_RX_RXUDP_GD_OCTETS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_OCTETS_MASK (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_OCTETS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (23)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_OCTETS_WR_MASK (ULONG)(0xff7fffff)

#define MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_OCTETS_UDFWR(data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_30)) << 30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_14)) << 14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_OCTETS_WR_MASK) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_OCTETS_MASK) << 23));\
		MMC_IPC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_OCTETS_UDFRD(data) do {\
		MMC_IPC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 23) & MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_OCTETS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_OCTETS_MASK (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_OCTETS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (22)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_OCTETS_WR_MASK (ULONG)(0xffbfffff)

#define MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_OCTETS_UDFWR(data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_30)) << 30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_14)) << 14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_OCTETS_WR_MASK) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_OCTETS_MASK) << 22));\
		MMC_IPC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_OCTETS_UDFRD(data) do {\
		MMC_IPC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 22) & MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_OCTETS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV6_GD_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV6_GD_OCTETS_MASK (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV6_GD_OCTETS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (21)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV6_GD_OCTETS_WR_MASK (ULONG)(0xffdfffff)

#define MMC_IPC_INTR_MASK_RX_RXIPV6_GD_OCTETS_UDFWR(data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_30)) << 30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_14)) << 14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV6_GD_OCTETS_WR_MASK) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV6_GD_OCTETS_MASK) << 21));\
		MMC_IPC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RXIPV6_GD_OCTETS_UDFRD(data) do {\
		MMC_IPC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 21) & MMC_IPC_INTR_MASK_RX_RXIPV6_GD_OCTETS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_OCTETS_MASK (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_OCTETS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_OCTETS_WR_MASK (ULONG)(0xffefffff)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_OCTETS_UDFWR(data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_30)) << 30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_14)) << 14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_OCTETS_WR_MASK) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_OCTETS_MASK) << 20));\
		MMC_IPC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_OCTETS_UDFRD(data) do {\
		MMC_IPC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 20) & MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_OCTETS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_OCTETS_MASK (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_OCTETS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_OCTETS_WR_MASK (ULONG)(0xfff7ffff)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_OCTETS_UDFWR(data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_30)) << 30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_14)) << 14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_OCTETS_WR_MASK) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_OCTETS_MASK) << 19));\
		MMC_IPC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_OCTETS_UDFRD(data) do {\
		MMC_IPC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 19) & MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_OCTETS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_OCTETS_MASK (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_OCTETS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_OCTETS_WR_MASK (ULONG)(0xfffbffff)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_OCTETS_UDFWR(data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_30)) << 30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_14)) << 14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_OCTETS_WR_MASK) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_OCTETS_MASK) << 18));\
		MMC_IPC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_OCTETS_UDFRD(data) do {\
		MMC_IPC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 18) & MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_OCTETS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_OCTETS_MASK (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_OCTETS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (17)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_OCTETS_WR_MASK (ULONG)(0xfffdffff)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_OCTETS_UDFWR(data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_30)) << 30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_14)) << 14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_OCTETS_WR_MASK) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_OCTETS_MASK) << 17));\
		MMC_IPC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_OCTETS_UDFRD(data) do {\
		MMC_IPC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 17) & MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_OCTETS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_GD_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_GD_OCTETS_MASK (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_GD_OCTETS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_GD_OCTETS_WR_MASK (ULONG)(0xfffeffff)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_GD_OCTETS_UDFWR(data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_30)) << 30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_14)) << 14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV4_GD_OCTETS_WR_MASK) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV4_GD_OCTETS_MASK) << 16));\
		MMC_IPC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_GD_OCTETS_UDFRD(data) do {\
		MMC_IPC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 16) & MMC_IPC_INTR_MASK_RX_RXIPV4_GD_OCTETS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_MASK_RX_RXICMP_ERR_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXICMP_ERR_FRMS_MASK (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXICMP_ERR_FRMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (13)))*/

#define MMC_IPC_INTR_MASK_RX_RXICMP_ERR_FRMS_WR_MASK (ULONG)(0xffffdfff)

#define MMC_IPC_INTR_MASK_RX_RXICMP_ERR_FRMS_UDFWR(data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_30)) << 30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_14)) << 14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXICMP_ERR_FRMS_WR_MASK) | ((data & MMC_IPC_INTR_MASK_RX_RXICMP_ERR_FRMS_MASK) << 13));\
		MMC_IPC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RXICMP_ERR_FRMS_UDFRD(data) do {\
		MMC_IPC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 13) & MMC_IPC_INTR_MASK_RX_RXICMP_ERR_FRMS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_MASK_RX_RXICMP_GD_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXICMP_GD_FRMS_MASK (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXICMP_GD_FRMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define MMC_IPC_INTR_MASK_RX_RXICMP_GD_FRMS_WR_MASK (ULONG)(0xffffefff)

#define MMC_IPC_INTR_MASK_RX_RXICMP_GD_FRMS_UDFWR(data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_30)) << 30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_14)) << 14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXICMP_GD_FRMS_WR_MASK) | ((data & MMC_IPC_INTR_MASK_RX_RXICMP_GD_FRMS_MASK) << 12));\
		MMC_IPC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RXICMP_GD_FRMS_UDFRD(data) do {\
		MMC_IPC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 12) & MMC_IPC_INTR_MASK_RX_RXICMP_GD_FRMS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_MASK_RX_RXTCP_ERR_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXTCP_ERR_FRMS_MASK (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXTCP_ERR_FRMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MMC_IPC_INTR_MASK_RX_RXTCP_ERR_FRMS_WR_MASK (ULONG)(0xfffff7ff)

#define MMC_IPC_INTR_MASK_RX_RXTCP_ERR_FRMS_UDFWR(data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_30)) << 30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_14)) << 14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXTCP_ERR_FRMS_WR_MASK) | ((data & MMC_IPC_INTR_MASK_RX_RXTCP_ERR_FRMS_MASK) << 11));\
		MMC_IPC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RXTCP_ERR_FRMS_UDFRD(data) do {\
		MMC_IPC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 11) & MMC_IPC_INTR_MASK_RX_RXTCP_ERR_FRMS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_MASK_RX_RXTCP_GD_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXTCP_GD_FRMS_MASK (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXTCP_GD_FRMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (10)))*/

#define MMC_IPC_INTR_MASK_RX_RXTCP_GD_FRMS_WR_MASK (ULONG)(0xfffffbff)

#define MMC_IPC_INTR_MASK_RX_RXTCP_GD_FRMS_UDFWR(data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_30)) << 30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_14)) << 14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXTCP_GD_FRMS_WR_MASK) | ((data & MMC_IPC_INTR_MASK_RX_RXTCP_GD_FRMS_MASK) << 10));\
		MMC_IPC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RXTCP_GD_FRMS_UDFRD(data) do {\
		MMC_IPC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 10) & MMC_IPC_INTR_MASK_RX_RXTCP_GD_FRMS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_MASK_RX_RXUDP_ERR_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXUDP_ERR_FRMS_MASK (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXUDP_ERR_FRMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (9)))*/

#define MMC_IPC_INTR_MASK_RX_RXUDP_ERR_FRMS_WR_MASK (ULONG)(0xfffffdff)

#define MMC_IPC_INTR_MASK_RX_RXUDP_ERR_FRMS_UDFWR(data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_30)) << 30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_14)) << 14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXUDP_ERR_FRMS_WR_MASK) | ((data & MMC_IPC_INTR_MASK_RX_RXUDP_ERR_FRMS_MASK) << 9));\
		MMC_IPC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RXUDP_ERR_FRMS_UDFRD(data) do {\
		MMC_IPC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 9) & MMC_IPC_INTR_MASK_RX_RXUDP_ERR_FRMS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_MASK_RX_RXUDP_GD_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXUDP_GD_FRMS_MASK (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXUDP_GD_FRMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (8)))*/

#define MMC_IPC_INTR_MASK_RX_RXUDP_GD_FRMS_WR_MASK (ULONG)(0xfffffeff)

#define MMC_IPC_INTR_MASK_RX_RXUDP_GD_FRMS_UDFWR(data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_30)) << 30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_14)) << 14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXUDP_GD_FRMS_WR_MASK) | ((data & MMC_IPC_INTR_MASK_RX_RXUDP_GD_FRMS_MASK) << 8));\
		MMC_IPC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RXUDP_GD_FRMS_UDFRD(data) do {\
		MMC_IPC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 8) & MMC_IPC_INTR_MASK_RX_RXUDP_GD_FRMS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_FRMS_MASK (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_FRMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_FRMS_WR_MASK (ULONG)(0xffffff7f)

#define MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_FRMS_UDFWR(data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_30)) << 30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_14)) << 14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_FRMS_WR_MASK) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_FRMS_MASK) << 7));\
		MMC_IPC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_FRMS_UDFRD(data) do {\
		MMC_IPC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 7) & MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_FRMS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_FRMS_MASK (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_FRMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (6)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_FRMS_WR_MASK (ULONG)(0xffffffbf)

#define MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_FRMS_UDFWR(data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_30)) << 30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_14)) << 14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_FRMS_WR_MASK) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_FRMS_MASK) << 6));\
		MMC_IPC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_FRMS_UDFRD(data) do {\
		MMC_IPC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 6) & MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_FRMS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV6_GD_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV6_GD_FRMS_MASK (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV6_GD_FRMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV6_GD_FRMS_WR_MASK (ULONG)(0xffffffdf)

#define MMC_IPC_INTR_MASK_RX_RXIPV6_GD_FRMS_UDFWR(data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_30)) << 30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_14)) << 14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV6_GD_FRMS_WR_MASK) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV6_GD_FRMS_MASK) << 5));\
		MMC_IPC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RXIPV6_GD_FRMS_UDFRD(data) do {\
		MMC_IPC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 5) & MMC_IPC_INTR_MASK_RX_RXIPV6_GD_FRMS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_FRMS_MASK (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_FRMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_FRMS_WR_MASK (ULONG)(0xffffffef)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_FRMS_UDFWR(data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_30)) << 30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_14)) << 14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_FRMS_WR_MASK) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_FRMS_MASK) << 4));\
		MMC_IPC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_FRMS_UDFRD(data) do {\
		MMC_IPC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 4) & MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_FRMS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_FRMS_MASK (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_FRMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_FRMS_WR_MASK (ULONG)(0xfffffff7)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_FRMS_UDFWR(data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_30)) << 30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_14)) << 14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_FRMS_WR_MASK) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_FRMS_MASK) << 3));\
		MMC_IPC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_FRMS_UDFRD(data) do {\
		MMC_IPC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 3) & MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_FRMS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_FRMS_MASK (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_FRMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_FRMS_WR_MASK (ULONG)(0xfffffffb)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_FRMS_UDFWR(data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_30)) << 30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_14)) << 14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_FRMS_WR_MASK) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_FRMS_MASK) << 2));\
		MMC_IPC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_FRMS_UDFRD(data) do {\
		MMC_IPC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 2) & MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_FRMS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_FRMS_MASK (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_FRMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_FRMS_WR_MASK (ULONG)(0xfffffffd)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_FRMS_UDFWR(data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_30)) << 30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_14)) << 14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_FRMS_WR_MASK) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_FRMS_MASK) << 1));\
		MMC_IPC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_FRMS_UDFRD(data) do {\
		MMC_IPC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 1) & MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_FRMS_MASK);\
} while (0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_GD_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_GD_FRMS_MASK (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_GD_FRMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_GD_FRMS_WR_MASK (ULONG)(0xfffffffe)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_GD_FRMS_UDFWR(data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_30)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_30)) << 30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_WR_MASK_14)) | (((0) & (MMC_IPC_INTR_MASK_RX_MASK_14)) << 14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV4_GD_FRMS_WR_MASK) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV4_GD_FRMS_MASK) << 0));\
		MMC_IPC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_GD_FRMS_UDFRD(data) do {\
		MMC_IPC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 0) & MMC_IPC_INTR_MASK_RX_RXIPV4_GD_FRMS_MASK);\
} while (0)

#define MMC_INTR_MASK_TX_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x710))

#define MMC_INTR_MASK_TX_RGWR(data) do {\
		iowrite32(data, (void *)MMC_INTR_MASK_TX_RGOFFADDR);\
} while (0)

#define MMC_INTR_MASK_TX_RGRD(data) do {\
		(data) = ioread32((void *)MMC_INTR_MASK_TX_RGOFFADDR);\
} while (0)

/*#define  MMC_INTR_MASK_TX_Mask_25 (ULONG)(~(~0<<(7)))*/

#define  MMC_INTR_MASK_TX_MASK_25 (ULONG)(0x7f)

/*#define MMC_INTR_MASK_TX_RES_Wr_Mask_25 (ULONG)(~((~(~0<<(7)))<<(25)))*/

#define MMC_INTR_MASK_TX_RES_WR_MASK_25 (ULONG)(0x1ffffff)

/*#define MMC_INTR_MASK_TX_TXVLANFRAMES_G_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXVLANFRAMES_G_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXVLANFRAMES_G_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define MMC_INTR_MASK_TX_TXVLANFRAMES_G_WR_MASK (ULONG)(0xfeffffff)

#define MMC_INTR_MASK_TX_TXVLANFRAMES_G_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_TX_RES_WR_MASK_25)) | (((0) & (MMC_INTR_MASK_TX_MASK_25)) << 25);\
		v = ((v & MMC_INTR_MASK_TX_TXVLANFRAMES_G_WR_MASK) | ((data & MMC_INTR_MASK_TX_TXVLANFRAMES_G_MASK) << 24));\
		MMC_INTR_MASK_TX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_TX_TXVLANFRAMES_G_UDFRD(data) do {\
		MMC_INTR_MASK_TX_RGRD(data);\
		data = ((data >> 24) & MMC_INTR_MASK_TX_TXVLANFRAMES_G_MASK);\
} while (0)

/*#define MMC_INTR_MASK_TX_TXPAUSEFRAMES_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXPAUSEFRAMES_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXPAUSEFRAMES_Wr_Mask (ULONG)(~((~(~0 << (1))) << (23)))*/

#define MMC_INTR_MASK_TX_TXPAUSEFRAMES_WR_MASK (ULONG)(0xff7fffff)

#define MMC_INTR_MASK_TX_TXPAUSEFRAMES_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_TX_RES_WR_MASK_25)) | (((0) & (MMC_INTR_MASK_TX_MASK_25)) << 25);\
		v = ((v & MMC_INTR_MASK_TX_TXPAUSEFRAMES_WR_MASK) | ((data & MMC_INTR_MASK_TX_TXPAUSEFRAMES_MASK) << 23));\
		MMC_INTR_MASK_TX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_TX_TXPAUSEFRAMES_UDFRD(data) do {\
		MMC_INTR_MASK_TX_RGRD(data);\
		data = ((data >> 23) & MMC_INTR_MASK_TX_TXPAUSEFRAMES_MASK);\
} while (0)

/*#define MMC_INTR_MASK_TX_TXEXCESSDEF_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXEXCESSDEF_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXEXCESSDEF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (22)))*/

#define MMC_INTR_MASK_TX_TXEXCESSDEF_WR_MASK (ULONG)(0xffbfffff)

#define MMC_INTR_MASK_TX_TXEXCESSDEF_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_TX_RES_WR_MASK_25)) | (((0) & (MMC_INTR_MASK_TX_MASK_25)) << 25);\
		v = ((v & MMC_INTR_MASK_TX_TXEXCESSDEF_WR_MASK) | ((data & MMC_INTR_MASK_TX_TXEXCESSDEF_MASK) << 22));\
		MMC_INTR_MASK_TX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_TX_TXEXCESSDEF_UDFRD(data) do {\
		MMC_INTR_MASK_TX_RGRD(data);\
		data = ((data >> 22) & MMC_INTR_MASK_TX_TXEXCESSDEF_MASK);\
} while (0)

/*#define MMC_INTR_MASK_TX_TXFRAMECOUNT_G_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXFRAMECOUNT_G_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXFRAMECOUNT_G_Wr_Mask (ULONG)(~((~(~0 << (1))) << (21)))*/

#define MMC_INTR_MASK_TX_TXFRAMECOUNT_G_WR_MASK (ULONG)(0xffdfffff)

#define MMC_INTR_MASK_TX_TXFRAMECOUNT_G_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_TX_RES_WR_MASK_25)) | (((0) & (MMC_INTR_MASK_TX_MASK_25)) << 25);\
		v = ((v & MMC_INTR_MASK_TX_TXFRAMECOUNT_G_WR_MASK) | ((data & MMC_INTR_MASK_TX_TXFRAMECOUNT_G_MASK) << 21));\
		MMC_INTR_MASK_TX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_TX_TXFRAMECOUNT_G_UDFRD(data) do {\
		MMC_INTR_MASK_TX_RGRD(data);\
		data = ((data >> 21) & MMC_INTR_MASK_TX_TXFRAMECOUNT_G_MASK);\
} while (0)

/*#define MMC_INTR_MASK_TX_TXOCTETCOUNT_G_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXOCTETCOUNT_G_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXOCTETCOUNT_G_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MMC_INTR_MASK_TX_TXOCTETCOUNT_G_WR_MASK (ULONG)(0xffefffff)

#define MMC_INTR_MASK_TX_TXOCTETCOUNT_G_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_TX_RES_WR_MASK_25)) | (((0) & (MMC_INTR_MASK_TX_MASK_25)) << 25);\
		v = ((v & MMC_INTR_MASK_TX_TXOCTETCOUNT_G_WR_MASK) | ((data & MMC_INTR_MASK_TX_TXOCTETCOUNT_G_MASK) << 20));\
		MMC_INTR_MASK_TX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_TX_TXOCTETCOUNT_G_UDFRD(data) do {\
		MMC_INTR_MASK_TX_RGRD(data);\
		data = ((data >> 20) & MMC_INTR_MASK_TX_TXOCTETCOUNT_G_MASK);\
} while (0)

/*#define MMC_INTR_MASK_TX_TXCARRIERERROR_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXCARRIERERROR_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXCARRIERERROR_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MMC_INTR_MASK_TX_TXCARRIERERROR_WR_MASK (ULONG)(0xfff7ffff)

#define MMC_INTR_MASK_TX_TXCARRIERERROR_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_TX_RES_WR_MASK_25)) | (((0) & (MMC_INTR_MASK_TX_MASK_25)) << 25);\
		v = ((v & MMC_INTR_MASK_TX_TXCARRIERERROR_WR_MASK) | ((data & MMC_INTR_MASK_TX_TXCARRIERERROR_MASK) << 19));\
		MMC_INTR_MASK_TX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_TX_TXCARRIERERROR_UDFRD(data) do {\
		MMC_INTR_MASK_TX_RGRD(data);\
		data = ((data >> 19) & MMC_INTR_MASK_TX_TXCARRIERERROR_MASK);\
} while (0)

/*#define MMC_INTR_MASK_TX_TXEXESSCOL_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXEXESSCOL_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXEXESSCOL_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MMC_INTR_MASK_TX_TXEXESSCOL_WR_MASK (ULONG)(0xfffbffff)

#define MMC_INTR_MASK_TX_TXEXESSCOL_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_TX_RES_WR_MASK_25)) | (((0) & (MMC_INTR_MASK_TX_MASK_25)) << 25);\
		v = ((v & MMC_INTR_MASK_TX_TXEXESSCOL_WR_MASK) | ((data & MMC_INTR_MASK_TX_TXEXESSCOL_MASK) << 18));\
		MMC_INTR_MASK_TX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_TX_TXEXESSCOL_UDFRD(data) do {\
		MMC_INTR_MASK_TX_RGRD(data);\
		data = ((data >> 18) & MMC_INTR_MASK_TX_TXEXESSCOL_MASK);\
} while (0)

/*#define MMC_INTR_MASK_TX_TXLATECOL_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXLATECOL_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXLATECOL_Wr_Mask (ULONG)(~((~(~0 << (1))) << (17)))*/

#define MMC_INTR_MASK_TX_TXLATECOL_WR_MASK (ULONG)(0xfffdffff)

#define MMC_INTR_MASK_TX_TXLATECOL_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_TX_RES_WR_MASK_25)) | (((0) & (MMC_INTR_MASK_TX_MASK_25)) << 25);\
		v = ((v & MMC_INTR_MASK_TX_TXLATECOL_WR_MASK) | ((data & MMC_INTR_MASK_TX_TXLATECOL_MASK) << 17));\
		MMC_INTR_MASK_TX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_TX_TXLATECOL_UDFRD(data) do {\
		MMC_INTR_MASK_TX_RGRD(data);\
		data = ((data >> 17) & MMC_INTR_MASK_TX_TXLATECOL_MASK);\
} while (0)

/*#define MMC_INTR_MASK_TX_TXDEFERRED_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXDEFERRED_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXDEFERRED_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MMC_INTR_MASK_TX_TXDEFERRED_WR_MASK (ULONG)(0xfffeffff)

#define MMC_INTR_MASK_TX_TXDEFERRED_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_TX_RES_WR_MASK_25)) | (((0) & (MMC_INTR_MASK_TX_MASK_25)) << 25);\
		v = ((v & MMC_INTR_MASK_TX_TXDEFERRED_WR_MASK) | ((data & MMC_INTR_MASK_TX_TXDEFERRED_MASK) << 16));\
		MMC_INTR_MASK_TX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_TX_TXDEFERRED_UDFRD(data) do {\
		MMC_INTR_MASK_TX_RGRD(data);\
		data = ((data >> 16) & MMC_INTR_MASK_TX_TXDEFERRED_MASK);\
} while (0)

/*#define MMC_INTR_MASK_TX_TXMULTICOL_G_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXMULTICOL_G_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXMULTICOL_G_Wr_Mask (ULONG)(~((~(~0 << (1))) << (15)))*/

#define MMC_INTR_MASK_TX_TXMULTICOL_G_WR_MASK (ULONG)(0xffff7fff)

#define MMC_INTR_MASK_TX_TXMULTICOL_G_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_TX_RES_WR_MASK_25)) | (((0) & (MMC_INTR_MASK_TX_MASK_25)) << 25);\
		v = ((v & MMC_INTR_MASK_TX_TXMULTICOL_G_WR_MASK) | ((data & MMC_INTR_MASK_TX_TXMULTICOL_G_MASK) << 15));\
		MMC_INTR_MASK_TX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_TX_TXMULTICOL_G_UDFRD(data) do {\
		MMC_INTR_MASK_TX_RGRD(data);\
		data = ((data >> 15) & MMC_INTR_MASK_TX_TXMULTICOL_G_MASK);\
} while (0)

/*#define MMC_INTR_MASK_TX_TXSINGLECOL_G_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXSINGLECOL_G_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXSINGLECOL_G_Wr_Mask (ULONG)(~((~(~0 << (1))) << (14)))*/

#define MMC_INTR_MASK_TX_TXSINGLECOL_G_WR_MASK (ULONG)(0xffffbfff)

#define MMC_INTR_MASK_TX_TXSINGLECOL_G_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_TX_RES_WR_MASK_25)) | (((0) & (MMC_INTR_MASK_TX_MASK_25)) << 25);\
		v = ((v & MMC_INTR_MASK_TX_TXSINGLECOL_G_WR_MASK) | ((data & MMC_INTR_MASK_TX_TXSINGLECOL_G_MASK) << 14));\
		MMC_INTR_MASK_TX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_TX_TXSINGLECOL_G_UDFRD(data) do {\
		MMC_INTR_MASK_TX_RGRD(data);\
		data = ((data >> 14) & MMC_INTR_MASK_TX_TXSINGLECOL_G_MASK);\
} while (0)

/*#define MMC_INTR_MASK_TX_TXUNDERFLOWERROR_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXUNDERFLOWERROR_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXUNDERFLOWERROR_Wr_Mask (ULONG)(~((~(~0 << (1))) << (13)))*/

#define MMC_INTR_MASK_TX_TXUNDERFLOWERROR_WR_MASK (ULONG)(0xffffdfff)

#define MMC_INTR_MASK_TX_TXUNDERFLOWERROR_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_TX_RES_WR_MASK_25)) | (((0) & (MMC_INTR_MASK_TX_MASK_25)) << 25);\
		v = ((v & MMC_INTR_MASK_TX_TXUNDERFLOWERROR_WR_MASK) | ((data & MMC_INTR_MASK_TX_TXUNDERFLOWERROR_MASK) << 13));\
		MMC_INTR_MASK_TX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_TX_TXUNDERFLOWERROR_UDFRD(data) do {\
		MMC_INTR_MASK_TX_RGRD(data);\
		data = ((data >> 13) & MMC_INTR_MASK_TX_TXUNDERFLOWERROR_MASK);\
} while (0)

/*#define MMC_INTR_MASK_TX_TXBROADCASTFRAMES_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXBROADCASTFRAMES_GB_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXBROADCASTFRAMES_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define MMC_INTR_MASK_TX_TXBROADCASTFRAMES_GB_WR_MASK (ULONG)(0xffffefff)

#define MMC_INTR_MASK_TX_TXBROADCASTFRAMES_GB_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_TX_RES_WR_MASK_25)) | (((0) & (MMC_INTR_MASK_TX_MASK_25)) << 25);\
		v = ((v & MMC_INTR_MASK_TX_TXBROADCASTFRAMES_GB_WR_MASK) | ((data & MMC_INTR_MASK_TX_TXBROADCASTFRAMES_GB_MASK) << 12));\
		MMC_INTR_MASK_TX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_TX_TXBROADCASTFRAMES_GB_UDFRD(data) do {\
		MMC_INTR_MASK_TX_RGRD(data);\
		data = ((data >> 12) & MMC_INTR_MASK_TX_TXBROADCASTFRAMES_GB_MASK);\
} while (0)

/*#define MMC_INTR_MASK_TX_TXMULTICASTFRAMES_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXMULTICASTFRAMES_GB_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXMULTICASTFRAMES_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MMC_INTR_MASK_TX_TXMULTICASTFRAMES_GB_WR_MASK (ULONG)(0xfffff7ff)

#define MMC_INTR_MASK_TX_TXMULTICASTFRAMES_GB_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_TX_RES_WR_MASK_25)) | (((0) & (MMC_INTR_MASK_TX_MASK_25)) << 25);\
		v = ((v & MMC_INTR_MASK_TX_TXMULTICASTFRAMES_GB_WR_MASK) | ((data & MMC_INTR_MASK_TX_TXMULTICASTFRAMES_GB_MASK) << 11));\
		MMC_INTR_MASK_TX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_TX_TXMULTICASTFRAMES_GB_UDFRD(data) do {\
		MMC_INTR_MASK_TX_RGRD(data);\
		data = ((data >> 11) & MMC_INTR_MASK_TX_TXMULTICASTFRAMES_GB_MASK);\
} while (0)

/*#define MMC_INTR_MASK_TX_TXUNICASTFRAMES_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXUNICASTFRAMES_GB_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXUNICASTFRAMES_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (10)))*/

#define MMC_INTR_MASK_TX_TXUNICASTFRAMES_GB_WR_MASK (ULONG)(0xfffffbff)

#define MMC_INTR_MASK_TX_TXUNICASTFRAMES_GB_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_TX_RES_WR_MASK_25)) | (((0) & (MMC_INTR_MASK_TX_MASK_25)) << 25);\
		v = ((v & MMC_INTR_MASK_TX_TXUNICASTFRAMES_GB_WR_MASK) | ((data & MMC_INTR_MASK_TX_TXUNICASTFRAMES_GB_MASK) << 10));\
		MMC_INTR_MASK_TX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_TX_TXUNICASTFRAMES_GB_UDFRD(data) do {\
		MMC_INTR_MASK_TX_RGRD(data);\
		data = ((data >> 10) & MMC_INTR_MASK_TX_TXUNICASTFRAMES_GB_MASK);\
} while (0)

/*#define MMC_INTR_MASK_TX_TX1024TOMAXOCTETS_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TX1024TOMAXOCTETS_GB_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TX1024TOMAXOCTETS_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (9)))*/

#define MMC_INTR_MASK_TX_TX1024TOMAXOCTETS_GB_WR_MASK (ULONG)(0xfffffdff)

#define MMC_INTR_MASK_TX_TX1024TOMAXOCTETS_GB_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_TX_RES_WR_MASK_25)) | (((0) & (MMC_INTR_MASK_TX_MASK_25)) << 25);\
		v = ((v & MMC_INTR_MASK_TX_TX1024TOMAXOCTETS_GB_WR_MASK) | ((data & MMC_INTR_MASK_TX_TX1024TOMAXOCTETS_GB_MASK) << 9));\
		MMC_INTR_MASK_TX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_TX_TX1024TOMAXOCTETS_GB_UDFRD(data) do {\
		MMC_INTR_MASK_TX_RGRD(data);\
		data = ((data >> 9) & MMC_INTR_MASK_TX_TX1024TOMAXOCTETS_GB_MASK);\
} while (0)

/*#define MMC_INTR_MASK_TX_TX512TO1023OCTETS_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TX512TO1023OCTETS_GB_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TX512TO1023OCTETS_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (8)))*/

#define MMC_INTR_MASK_TX_TX512TO1023OCTETS_GB_WR_MASK (ULONG)(0xfffffeff)

#define MMC_INTR_MASK_TX_TX512TO1023OCTETS_GB_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_TX_RES_WR_MASK_25)) | (((0) & (MMC_INTR_MASK_TX_MASK_25)) << 25);\
		v = ((v & MMC_INTR_MASK_TX_TX512TO1023OCTETS_GB_WR_MASK) | ((data & MMC_INTR_MASK_TX_TX512TO1023OCTETS_GB_MASK) << 8));\
		MMC_INTR_MASK_TX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_TX_TX512TO1023OCTETS_GB_UDFRD(data) do {\
		MMC_INTR_MASK_TX_RGRD(data);\
		data = ((data >> 8) & MMC_INTR_MASK_TX_TX512TO1023OCTETS_GB_MASK);\
} while (0)

/*#define MMC_INTR_MASK_TX_TX256TO511OCTETS_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TX256TO511OCTETS_GB_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TX256TO511OCTETS_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MMC_INTR_MASK_TX_TX256TO511OCTETS_GB_WR_MASK (ULONG)(0xffffff7f)

#define MMC_INTR_MASK_TX_TX256TO511OCTETS_GB_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_TX_RES_WR_MASK_25)) | (((0) & (MMC_INTR_MASK_TX_MASK_25)) << 25);\
		v = ((v & MMC_INTR_MASK_TX_TX256TO511OCTETS_GB_WR_MASK) | ((data & MMC_INTR_MASK_TX_TX256TO511OCTETS_GB_MASK) << 7));\
		MMC_INTR_MASK_TX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_TX_TX256TO511OCTETS_GB_UDFRD(data) do {\
		MMC_INTR_MASK_TX_RGRD(data);\
		data = ((data >> 7) & MMC_INTR_MASK_TX_TX256TO511OCTETS_GB_MASK);\
} while (0)

/*#define MMC_INTR_MASK_TX_TX128TO255OCTETS_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TX128TO255OCTETS_GB_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TX128TO255OCTETS_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (6)))*/

#define MMC_INTR_MASK_TX_TX128TO255OCTETS_GB_WR_MASK (ULONG)(0xffffffbf)

#define MMC_INTR_MASK_TX_TX128TO255OCTETS_GB_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_TX_RES_WR_MASK_25)) | (((0) & (MMC_INTR_MASK_TX_MASK_25)) << 25);\
		v = ((v & MMC_INTR_MASK_TX_TX128TO255OCTETS_GB_WR_MASK) | ((data & MMC_INTR_MASK_TX_TX128TO255OCTETS_GB_MASK) << 6));\
		MMC_INTR_MASK_TX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_TX_TX128TO255OCTETS_GB_UDFRD(data) do {\
		MMC_INTR_MASK_TX_RGRD(data);\
		data = ((data >> 6) & MMC_INTR_MASK_TX_TX128TO255OCTETS_GB_MASK);\
} while (0)

/*#define MMC_INTR_MASK_TX_TX65TO127OCTETS_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TX65TO127OCTETS_GB_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TX65TO127OCTETS_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MMC_INTR_MASK_TX_TX65TO127OCTETS_GB_WR_MASK (ULONG)(0xffffffdf)

#define MMC_INTR_MASK_TX_TX65TO127OCTETS_GB_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_TX_RES_WR_MASK_25)) | (((0) & (MMC_INTR_MASK_TX_MASK_25)) << 25);\
		v = ((v & MMC_INTR_MASK_TX_TX65TO127OCTETS_GB_WR_MASK) | ((data & MMC_INTR_MASK_TX_TX65TO127OCTETS_GB_MASK) << 5));\
		MMC_INTR_MASK_TX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_TX_TX65TO127OCTETS_GB_UDFRD(data) do {\
		MMC_INTR_MASK_TX_RGRD(data);\
		data = ((data >> 5) & MMC_INTR_MASK_TX_TX65TO127OCTETS_GB_MASK);\
} while (0)

/*#define MMC_INTR_MASK_TX_TX64OCTETS_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TX64OCTETS_GB_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TX64OCTETS_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MMC_INTR_MASK_TX_TX64OCTETS_GB_WR_MASK (ULONG)(0xffffffef)

#define MMC_INTR_MASK_TX_TX64OCTETS_GB_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_TX_RES_WR_MASK_25)) | (((0) & (MMC_INTR_MASK_TX_MASK_25)) << 25);\
		v = ((v & MMC_INTR_MASK_TX_TX64OCTETS_GB_WR_MASK) | ((data & MMC_INTR_MASK_TX_TX64OCTETS_GB_MASK) << 4));\
		MMC_INTR_MASK_TX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_TX_TX64OCTETS_GB_UDFRD(data) do {\
		MMC_INTR_MASK_TX_RGRD(data);\
		data = ((data >> 4) & MMC_INTR_MASK_TX_TX64OCTETS_GB_MASK);\
} while (0)

/*#define MMC_INTR_MASK_TX_TXMULTICASTFRAMES_G_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXMULTICASTFRAMES_G_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXMULTICASTFRAMES_G_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MMC_INTR_MASK_TX_TXMULTICASTFRAMES_G_WR_MASK (ULONG)(0xfffffff7)

#define MMC_INTR_MASK_TX_TXMULTICASTFRAMES_G_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_TX_RES_WR_MASK_25)) | (((0) & (MMC_INTR_MASK_TX_MASK_25)) << 25);\
		v = ((v & MMC_INTR_MASK_TX_TXMULTICASTFRAMES_G_WR_MASK) | ((data & MMC_INTR_MASK_TX_TXMULTICASTFRAMES_G_MASK) << 3));\
		MMC_INTR_MASK_TX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_TX_TXMULTICASTFRAMES_G_UDFRD(data) do {\
		MMC_INTR_MASK_TX_RGRD(data);\
		data = ((data >> 3) & MMC_INTR_MASK_TX_TXMULTICASTFRAMES_G_MASK);\
} while (0)

/*#define MMC_INTR_MASK_TX_TXBROADCASTFRAMES_G_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXBROADCASTFRAMES_G_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXBROADCASTFRAMES_G_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MMC_INTR_MASK_TX_TXBROADCASTFRAMES_G_WR_MASK (ULONG)(0xfffffffb)

#define MMC_INTR_MASK_TX_TXBROADCASTFRAMES_G_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_TX_RES_WR_MASK_25)) | (((0) & (MMC_INTR_MASK_TX_MASK_25)) << 25);\
		v = ((v & MMC_INTR_MASK_TX_TXBROADCASTFRAMES_G_WR_MASK) | ((data & MMC_INTR_MASK_TX_TXBROADCASTFRAMES_G_MASK) << 2));\
		MMC_INTR_MASK_TX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_TX_TXBROADCASTFRAMES_G_UDFRD(data) do {\
		MMC_INTR_MASK_TX_RGRD(data);\
		data = ((data >> 2) & MMC_INTR_MASK_TX_TXBROADCASTFRAMES_G_MASK);\
} while (0)

/*#define MMC_INTR_MASK_TX_TXFRAMECOUNT_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXFRAMECOUNT_GB_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXFRAMECOUNT_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MMC_INTR_MASK_TX_TXFRAMECOUNT_GB_WR_MASK (ULONG)(0xfffffffd)

#define MMC_INTR_MASK_TX_TXFRAMECOUNT_GB_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_TX_RES_WR_MASK_25)) | (((0) & (MMC_INTR_MASK_TX_MASK_25)) << 25);\
		v = ((v & MMC_INTR_MASK_TX_TXFRAMECOUNT_GB_WR_MASK) | ((data & MMC_INTR_MASK_TX_TXFRAMECOUNT_GB_MASK) << 1));\
		MMC_INTR_MASK_TX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_TX_TXFRAMECOUNT_GB_UDFRD(data) do {\
		MMC_INTR_MASK_TX_RGRD(data);\
		data = ((data >> 1) & MMC_INTR_MASK_TX_TXFRAMECOUNT_GB_MASK);\
} while (0)

/*#define MMC_INTR_MASK_TX_TXOCTETCOUNT_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXOCTETCOUNT_GB_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXOCTETCOUNT_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MMC_INTR_MASK_TX_TXOCTETCOUNT_GB_WR_MASK (ULONG)(0xfffffffe)

#define MMC_INTR_MASK_TX_TXOCTETCOUNT_GB_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_TX_RES_WR_MASK_25)) | (((0) & (MMC_INTR_MASK_TX_MASK_25)) << 25);\
		v = ((v & MMC_INTR_MASK_TX_TXOCTETCOUNT_GB_WR_MASK) | ((data & MMC_INTR_MASK_TX_TXOCTETCOUNT_GB_MASK) << 0));\
		MMC_INTR_MASK_TX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_TX_TXOCTETCOUNT_GB_UDFRD(data) do {\
		MMC_INTR_MASK_TX_RGRD(data);\
		data = ((data >> 0) & MMC_INTR_MASK_TX_TXOCTETCOUNT_GB_MASK);\
} while (0)

#define MMC_INTR_MASK_RX_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x70c))

#define MMC_INTR_MASK_RX_RGWR(data) do {\
		iowrite32(data, (void *)MMC_INTR_MASK_RX_RGOFFADDR);\
} while (0)

#define MMC_INTR_MASK_RX_RGRD(data) do {\
		(data) = ioread32((void *)MMC_INTR_MASK_RX_RGOFFADDR);\
} while (0)

/*#define  MMC_INTR_MASK_RX_Mask_24 (ULONG)(~(~0<<(8)))*/

#define  MMC_INTR_MASK_RX_MASK_24 (ULONG)(0xff)

/*#define MMC_INTR_MASK_RX_RES_Wr_Mask_24 (ULONG)(~((~(~0<<(8)))<<(24)))*/

#define MMC_INTR_MASK_RX_RES_WR_MASK_24 (ULONG)(0xffffff)

/*#define MMC_INTR_MASK_RX_RXWATCHDOG_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXWATCHDOG_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXWATCHDOG_Wr_Mask (ULONG)(~((~(~0 << (1))) << (23)))*/

#define MMC_INTR_MASK_RX_RXWATCHDOG_WR_MASK (ULONG)(0xff7fffff)

#define MMC_INTR_MASK_RX_RXWATCHDOG_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_RX_RES_WR_MASK_24)) | (((0) & (MMC_INTR_MASK_RX_MASK_24)) << 24);\
		v = ((v & MMC_INTR_MASK_RX_RXWATCHDOG_WR_MASK) | ((data & MMC_INTR_MASK_RX_RXWATCHDOG_MASK) << 23));\
		MMC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_RX_RXWATCHDOG_UDFRD(data) do {\
		MMC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 23) & MMC_INTR_MASK_RX_RXWATCHDOG_MASK);\
} while (0)

/*#define MMC_INTR_MASK_RX_RXVLANFRAMES_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXVLANFRAMES_GB_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXVLANFRAMES_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (22)))*/

#define MMC_INTR_MASK_RX_RXVLANFRAMES_GB_WR_MASK (ULONG)(0xffbfffff)

#define MMC_INTR_MASK_RX_RXVLANFRAMES_GB_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_RX_RES_WR_MASK_24)) | (((0) & (MMC_INTR_MASK_RX_MASK_24)) << 24);\
		v = ((v & MMC_INTR_MASK_RX_RXVLANFRAMES_GB_WR_MASK) | ((data & MMC_INTR_MASK_RX_RXVLANFRAMES_GB_MASK) << 22));\
		MMC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_RX_RXVLANFRAMES_GB_UDFRD(data) do {\
		MMC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 22) & MMC_INTR_MASK_RX_RXVLANFRAMES_GB_MASK);\
} while (0)

/*#define MMC_INTR_MASK_RX_RXFIFOOVERFLOW_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXFIFOOVERFLOW_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXFIFOOVERFLOW_Wr_Mask (ULONG)(~((~(~0 << (1))) << (21)))*/

#define MMC_INTR_MASK_RX_RXFIFOOVERFLOW_WR_MASK (ULONG)(0xffdfffff)

#define MMC_INTR_MASK_RX_RXFIFOOVERFLOW_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_RX_RES_WR_MASK_24)) | (((0) & (MMC_INTR_MASK_RX_MASK_24)) << 24);\
		v = ((v & MMC_INTR_MASK_RX_RXFIFOOVERFLOW_WR_MASK) | ((data & MMC_INTR_MASK_RX_RXFIFOOVERFLOW_MASK) << 21));\
		MMC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_RX_RXFIFOOVERFLOW_UDFRD(data) do {\
		MMC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 21) & MMC_INTR_MASK_RX_RXFIFOOVERFLOW_MASK);\
} while (0)

/*#define MMC_INTR_MASK_RX_RXPAUSEFRAMES_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXPAUSEFRAMES_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXPAUSEFRAMES_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MMC_INTR_MASK_RX_RXPAUSEFRAMES_WR_MASK (ULONG)(0xffefffff)

#define MMC_INTR_MASK_RX_RXPAUSEFRAMES_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_RX_RES_WR_MASK_24)) | (((0) & (MMC_INTR_MASK_RX_MASK_24)) << 24);\
		v = ((v & MMC_INTR_MASK_RX_RXPAUSEFRAMES_WR_MASK) | ((data & MMC_INTR_MASK_RX_RXPAUSEFRAMES_MASK) << 20));\
		MMC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_RX_RXPAUSEFRAMES_UDFRD(data) do {\
		MMC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 20) & MMC_INTR_MASK_RX_RXPAUSEFRAMES_MASK);\
} while (0)

/*#define MMC_INTR_MASK_RX_RXOUTOFRANGETYPE_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXOUTOFRANGETYPE_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXOUTOFRANGETYPE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MMC_INTR_MASK_RX_RXOUTOFRANGETYPE_WR_MASK (ULONG)(0xfff7ffff)

#define MMC_INTR_MASK_RX_RXOUTOFRANGETYPE_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_RX_RES_WR_MASK_24)) | (((0) & (MMC_INTR_MASK_RX_MASK_24)) << 24);\
		v = ((v & MMC_INTR_MASK_RX_RXOUTOFRANGETYPE_WR_MASK) | ((data & MMC_INTR_MASK_RX_RXOUTOFRANGETYPE_MASK) << 19));\
		MMC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_RX_RXOUTOFRANGETYPE_UDFRD(data) do {\
		MMC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 19) & MMC_INTR_MASK_RX_RXOUTOFRANGETYPE_MASK);\
} while (0)

/*#define MMC_INTR_MASK_RX_RXLENGTHERROR_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXLENGTHERROR_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXLENGTHERROR_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MMC_INTR_MASK_RX_RXLENGTHERROR_WR_MASK (ULONG)(0xfffbffff)

#define MMC_INTR_MASK_RX_RXLENGTHERROR_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_RX_RES_WR_MASK_24)) | (((0) & (MMC_INTR_MASK_RX_MASK_24)) << 24);\
		v = ((v & MMC_INTR_MASK_RX_RXLENGTHERROR_WR_MASK) | ((data & MMC_INTR_MASK_RX_RXLENGTHERROR_MASK) << 18));\
		MMC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_RX_RXLENGTHERROR_UDFRD(data) do {\
		MMC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 18) & MMC_INTR_MASK_RX_RXLENGTHERROR_MASK);\
} while (0)

/*#define MMC_INTR_MASK_RX_RXUNICASTFRAMES_G_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXUNICASTFRAMES_G_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXUNICASTFRAMES_G_Wr_Mask (ULONG)(~((~(~0 << (1))) << (17)))*/

#define MMC_INTR_MASK_RX_RXUNICASTFRAMES_G_WR_MASK (ULONG)(0xfffdffff)

#define MMC_INTR_MASK_RX_RXUNICASTFRAMES_G_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_RX_RES_WR_MASK_24)) | (((0) & (MMC_INTR_MASK_RX_MASK_24)) << 24);\
		v = ((v & MMC_INTR_MASK_RX_RXUNICASTFRAMES_G_WR_MASK) | ((data & MMC_INTR_MASK_RX_RXUNICASTFRAMES_G_MASK) << 17));\
		MMC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_RX_RXUNICASTFRAMES_G_UDFRD(data) do {\
		MMC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 17) & MMC_INTR_MASK_RX_RXUNICASTFRAMES_G_MASK);\
} while (0)

/*#define MMC_INTR_MASK_RX_RX1024TOMAXOCTETS_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RX1024TOMAXOCTETS_GB_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RX1024TOMAXOCTETS_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MMC_INTR_MASK_RX_RX1024TOMAXOCTETS_GB_WR_MASK (ULONG)(0xfffeffff)

#define MMC_INTR_MASK_RX_RX1024TOMAXOCTETS_GB_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_RX_RES_WR_MASK_24)) | (((0) & (MMC_INTR_MASK_RX_MASK_24)) << 24);\
		v = ((v & MMC_INTR_MASK_RX_RX1024TOMAXOCTETS_GB_WR_MASK) | ((data & MMC_INTR_MASK_RX_RX1024TOMAXOCTETS_GB_MASK) << 16));\
		MMC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_RX_RX1024TOMAXOCTETS_GB_UDFRD(data) do {\
		MMC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 16) & MMC_INTR_MASK_RX_RX1024TOMAXOCTETS_GB_MASK);\
} while (0)

/*#define MMC_INTR_MASK_RX_RX512TO1023OCTETS_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RX512TO1023OCTETS_GB_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RX512TO1023OCTETS_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (15)))*/

#define MMC_INTR_MASK_RX_RX512TO1023OCTETS_GB_WR_MASK (ULONG)(0xffff7fff)

#define MMC_INTR_MASK_RX_RX512TO1023OCTETS_GB_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_RX_RES_WR_MASK_24)) | (((0) & (MMC_INTR_MASK_RX_MASK_24)) << 24);\
		v = ((v & MMC_INTR_MASK_RX_RX512TO1023OCTETS_GB_WR_MASK) | ((data & MMC_INTR_MASK_RX_RX512TO1023OCTETS_GB_MASK) << 15));\
		MMC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_RX_RX512TO1023OCTETS_GB_UDFRD(data) do {\
		MMC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 15) & MMC_INTR_MASK_RX_RX512TO1023OCTETS_GB_MASK);\
} while (0)

/*#define MMC_INTR_MASK_RX_RX256TO511OCTETS_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RX256TO511OCTETS_GB_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RX256TO511OCTETS_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (14)))*/

#define MMC_INTR_MASK_RX_RX256TO511OCTETS_GB_WR_MASK (ULONG)(0xffffbfff)

#define MMC_INTR_MASK_RX_RX256TO511OCTETS_GB_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_RX_RES_WR_MASK_24)) | (((0) & (MMC_INTR_MASK_RX_MASK_24)) << 24);\
		v = ((v & MMC_INTR_MASK_RX_RX256TO511OCTETS_GB_WR_MASK) | ((data & MMC_INTR_MASK_RX_RX256TO511OCTETS_GB_MASK) << 14));\
		MMC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_RX_RX256TO511OCTETS_GB_UDFRD(data) do {\
		MMC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 14) & MMC_INTR_MASK_RX_RX256TO511OCTETS_GB_MASK);\
} while (0)

/*#define MMC_INTR_MASK_RX_RX128TO255OCTETS_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RX128TO255OCTETS_GB_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RX128TO255OCTETS_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (13)))*/

#define MMC_INTR_MASK_RX_RX128TO255OCTETS_GB_WR_MASK (ULONG)(0xffffdfff)

#define MMC_INTR_MASK_RX_RX128TO255OCTETS_GB_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_RX_RES_WR_MASK_24)) | (((0) & (MMC_INTR_MASK_RX_MASK_24)) << 24);\
		v = ((v & MMC_INTR_MASK_RX_RX128TO255OCTETS_GB_WR_MASK) | ((data & MMC_INTR_MASK_RX_RX128TO255OCTETS_GB_MASK) << 13));\
		MMC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_RX_RX128TO255OCTETS_GB_UDFRD(data) do {\
		MMC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 13) & MMC_INTR_MASK_RX_RX128TO255OCTETS_GB_MASK);\
} while (0)

/*#define MMC_INTR_MASK_RX_RX65TO127OCTETS_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RX65TO127OCTETS_GB_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RX65TO127OCTETS_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define MMC_INTR_MASK_RX_RX65TO127OCTETS_GB_WR_MASK (ULONG)(0xffffefff)

#define MMC_INTR_MASK_RX_RX65TO127OCTETS_GB_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_RX_RES_WR_MASK_24)) | (((0) & (MMC_INTR_MASK_RX_MASK_24)) << 24);\
		v = ((v & MMC_INTR_MASK_RX_RX65TO127OCTETS_GB_WR_MASK) | ((data & MMC_INTR_MASK_RX_RX65TO127OCTETS_GB_MASK) << 12));\
		MMC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_RX_RX65TO127OCTETS_GB_UDFRD(data) do {\
		MMC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 12) & MMC_INTR_MASK_RX_RX65TO127OCTETS_GB_MASK);\
} while (0)

/*#define MMC_INTR_MASK_RX_RX64OCTETS_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RX64OCTETS_GB_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RX64OCTETS_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MMC_INTR_MASK_RX_RX64OCTETS_GB_WR_MASK (ULONG)(0xfffff7ff)

#define MMC_INTR_MASK_RX_RX64OCTETS_GB_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_RX_RES_WR_MASK_24)) | (((0) & (MMC_INTR_MASK_RX_MASK_24)) << 24);\
		v = ((v & MMC_INTR_MASK_RX_RX64OCTETS_GB_WR_MASK) | ((data & MMC_INTR_MASK_RX_RX64OCTETS_GB_MASK) << 11));\
		MMC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_RX_RX64OCTETS_GB_UDFRD(data) do {\
		MMC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 11) & MMC_INTR_MASK_RX_RX64OCTETS_GB_MASK);\
} while (0)

/*#define MMC_INTR_MASK_RX_RXOVERSIZE_G_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXOVERSIZE_G_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXOVERSIZE_G_Wr_Mask (ULONG)(~((~(~0 << (1))) << (10)))*/

#define MMC_INTR_MASK_RX_RXOVERSIZE_G_WR_MASK (ULONG)(0xfffffbff)

#define MMC_INTR_MASK_RX_RXOVERSIZE_G_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_RX_RES_WR_MASK_24)) | (((0) & (MMC_INTR_MASK_RX_MASK_24)) << 24);\
		v = ((v & MMC_INTR_MASK_RX_RXOVERSIZE_G_WR_MASK) | ((data & MMC_INTR_MASK_RX_RXOVERSIZE_G_MASK) << 10));\
		MMC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_RX_RXOVERSIZE_G_UDFRD(data) do {\
		MMC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 10) & MMC_INTR_MASK_RX_RXOVERSIZE_G_MASK);\
} while (0)

/*#define MMC_INTR_MASK_RX_RXUNDERSIZE_G_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXUNDERSIZE_G_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXUNDERSIZE_G_Wr_Mask (ULONG)(~((~(~0 << (1))) << (9)))*/

#define MMC_INTR_MASK_RX_RXUNDERSIZE_G_WR_MASK (ULONG)(0xfffffdff)

#define MMC_INTR_MASK_RX_RXUNDERSIZE_G_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_RX_RES_WR_MASK_24)) | (((0) & (MMC_INTR_MASK_RX_MASK_24)) << 24);\
		v = ((v & MMC_INTR_MASK_RX_RXUNDERSIZE_G_WR_MASK) | ((data & MMC_INTR_MASK_RX_RXUNDERSIZE_G_MASK) << 9));\
		MMC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_RX_RXUNDERSIZE_G_UDFRD(data) do {\
		MMC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 9) & MMC_INTR_MASK_RX_RXUNDERSIZE_G_MASK);\
} while (0)

/*#define MMC_INTR_MASK_RX_RXJABBERERROR_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXJABBERERROR_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXJABBERERROR_Wr_Mask (ULONG)(~((~(~0 << (1))) << (8)))*/

#define MMC_INTR_MASK_RX_RXJABBERERROR_WR_MASK (ULONG)(0xfffffeff)

#define MMC_INTR_MASK_RX_RXJABBERERROR_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_RX_RES_WR_MASK_24)) | (((0) & (MMC_INTR_MASK_RX_MASK_24)) << 24);\
		v = ((v & MMC_INTR_MASK_RX_RXJABBERERROR_WR_MASK) | ((data & MMC_INTR_MASK_RX_RXJABBERERROR_MASK) << 8));\
		MMC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_RX_RXJABBERERROR_UDFRD(data) do {\
		MMC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 8) & MMC_INTR_MASK_RX_RXJABBERERROR_MASK);\
} while (0)

/*#define MMC_INTR_MASK_RX_RXRUNTERROR_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXRUNTERROR_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXRUNTERROR_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MMC_INTR_MASK_RX_RXRUNTERROR_WR_MASK (ULONG)(0xffffff7f)

#define MMC_INTR_MASK_RX_RXRUNTERROR_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_RX_RES_WR_MASK_24)) | (((0) & (MMC_INTR_MASK_RX_MASK_24)) << 24);\
		v = ((v & MMC_INTR_MASK_RX_RXRUNTERROR_WR_MASK) | ((data & MMC_INTR_MASK_RX_RXRUNTERROR_MASK) << 7));\
		MMC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_RX_RXRUNTERROR_UDFRD(data) do {\
		MMC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 7) & MMC_INTR_MASK_RX_RXRUNTERROR_MASK);\
} while (0)

/*#define MMC_INTR_MASK_RX_RXALIGNMENTERROR_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXALIGNMENTERROR_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXALIGNMENTERROR_Wr_Mask (ULONG)(~((~(~0 << (1))) << (6)))*/

#define MMC_INTR_MASK_RX_RXALIGNMENTERROR_WR_MASK (ULONG)(0xffffffbf)

#define MMC_INTR_MASK_RX_RXALIGNMENTERROR_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_RX_RES_WR_MASK_24)) | (((0) & (MMC_INTR_MASK_RX_MASK_24)) << 24);\
		v = ((v & MMC_INTR_MASK_RX_RXALIGNMENTERROR_WR_MASK) | ((data & MMC_INTR_MASK_RX_RXALIGNMENTERROR_MASK) << 6));\
		MMC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_RX_RXALIGNMENTERROR_UDFRD(data) do {\
		MMC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 6) & MMC_INTR_MASK_RX_RXALIGNMENTERROR_MASK);\
} while (0)

/*#define MMC_INTR_MASK_RX_RXCRCERROR_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXCRCERROR_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXCRCERROR_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MMC_INTR_MASK_RX_RXCRCERROR_WR_MASK (ULONG)(0xffffffdf)

#define MMC_INTR_MASK_RX_RXCRCERROR_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_RX_RES_WR_MASK_24)) | (((0) & (MMC_INTR_MASK_RX_MASK_24)) << 24);\
		v = ((v & MMC_INTR_MASK_RX_RXCRCERROR_WR_MASK) | ((data & MMC_INTR_MASK_RX_RXCRCERROR_MASK) << 5));\
		MMC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_RX_RXCRCERROR_UDFRD(data) do {\
		MMC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 5) & MMC_INTR_MASK_RX_RXCRCERROR_MASK);\
} while (0)

/*#define MMC_INTR_MASK_RX_RXMULTICASTFRAMES_G_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXMULTICASTFRAMES_G_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXMULTICASTFRAMES_G_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MMC_INTR_MASK_RX_RXMULTICASTFRAMES_G_WR_MASK (ULONG)(0xffffffef)

#define MMC_INTR_MASK_RX_RXMULTICASTFRAMES_G_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_RX_RES_WR_MASK_24)) | (((0) & (MMC_INTR_MASK_RX_MASK_24)) << 24);\
		v = ((v & MMC_INTR_MASK_RX_RXMULTICASTFRAMES_G_WR_MASK) | ((data & MMC_INTR_MASK_RX_RXMULTICASTFRAMES_G_MASK) << 4));\
		MMC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_RX_RXMULTICASTFRAMES_G_UDFRD(data) do {\
		MMC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 4) & MMC_INTR_MASK_RX_RXMULTICASTFRAMES_G_MASK);\
} while (0)

/*#define MMC_INTR_MASK_RX_RXBROADCASTFRAMES_G_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXBROADCASTFRAMES_G_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXBROADCASTFRAMES_G_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MMC_INTR_MASK_RX_RXBROADCASTFRAMES_G_WR_MASK (ULONG)(0xfffffff7)

#define MMC_INTR_MASK_RX_RXBROADCASTFRAMES_G_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_RX_RES_WR_MASK_24)) | (((0) & (MMC_INTR_MASK_RX_MASK_24)) << 24);\
		v = ((v & MMC_INTR_MASK_RX_RXBROADCASTFRAMES_G_WR_MASK) | ((data & MMC_INTR_MASK_RX_RXBROADCASTFRAMES_G_MASK) << 3));\
		MMC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_RX_RXBROADCASTFRAMES_G_UDFRD(data) do {\
		MMC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 3) & MMC_INTR_MASK_RX_RXBROADCASTFRAMES_G_MASK);\
} while (0)

/*#define MMC_INTR_MASK_RX_RXOCTETCOUNT_G_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXOCTETCOUNT_G_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXOCTETCOUNT_G_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MMC_INTR_MASK_RX_RXOCTETCOUNT_G_WR_MASK (ULONG)(0xfffffffb)

#define MMC_INTR_MASK_RX_RXOCTETCOUNT_G_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_RX_RES_WR_MASK_24)) | (((0) & (MMC_INTR_MASK_RX_MASK_24)) << 24);\
		v = ((v & MMC_INTR_MASK_RX_RXOCTETCOUNT_G_WR_MASK) | ((data & MMC_INTR_MASK_RX_RXOCTETCOUNT_G_MASK) << 2));\
		MMC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_RX_RXOCTETCOUNT_G_UDFRD(data) do {\
		MMC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 2) & MMC_INTR_MASK_RX_RXOCTETCOUNT_G_MASK);\
} while (0)

/*#define MMC_INTR_MASK_RX_RXOCTETCOUNT_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXOCTETCOUNT_GB_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXOCTETCOUNT_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MMC_INTR_MASK_RX_RXOCTETCOUNT_GB_WR_MASK (ULONG)(0xfffffffd)

#define MMC_INTR_MASK_RX_RXOCTETCOUNT_GB_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_RX_RES_WR_MASK_24)) | (((0) & (MMC_INTR_MASK_RX_MASK_24)) << 24);\
		v = ((v & MMC_INTR_MASK_RX_RXOCTETCOUNT_GB_WR_MASK) | ((data & MMC_INTR_MASK_RX_RXOCTETCOUNT_GB_MASK) << 1));\
		MMC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_RX_RXOCTETCOUNT_GB_UDFRD(data) do {\
		MMC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 1) & MMC_INTR_MASK_RX_RXOCTETCOUNT_GB_MASK);\
} while (0)

/*#define MMC_INTR_MASK_RX_RXFRAMECOUNT_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXFRAMECOUNT_GB_MASK (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXFRAMECOUNT_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MMC_INTR_MASK_RX_RXFRAMECOUNT_GB_WR_MASK (ULONG)(0xfffffffe)

#define MMC_INTR_MASK_RX_RXFRAMECOUNT_GB_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RGRD(v);\
		v = (v & (MMC_INTR_MASK_RX_RES_WR_MASK_24)) | (((0) & (MMC_INTR_MASK_RX_MASK_24)) << 24);\
		v = ((v & MMC_INTR_MASK_RX_RXFRAMECOUNT_GB_WR_MASK) | ((data & MMC_INTR_MASK_RX_RXFRAMECOUNT_GB_MASK) << 0));\
		MMC_INTR_MASK_RX_RGWR(v);\
} while (0)

#define MMC_INTR_MASK_RX_RXFRAMECOUNT_GB_UDFRD(data) do {\
		MMC_INTR_MASK_RX_RGRD(data);\
		data = ((data >> 0) & MMC_INTR_MASK_RX_RXFRAMECOUNT_GB_MASK);\
} while (0)

#define MMC_INTR_TX_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x708))

#define MMC_INTR_TX_RGWR(data) do {\
		iowrite32(data, (void *)MMC_INTR_TX_RGOFFADDR);\
} while (0)

#define MMC_INTR_TX_RGRD(data) do {\
		(data) = ioread32((void *)MMC_INTR_TX_RGOFFADDR);\
} while (0)

/*#define  MMC_INTR_TX_Mask_26 (ULONG)(~(~0<<(6)))*/

#define  MMC_INTR_TX_MASK_26 (ULONG)(0x3f)

/*#define MMC_INTR_TX_RES_Wr_Mask_26 (ULONG)(~((~(~0<<(6)))<<(26)))*/

#define MMC_INTR_TX_RES_WR_MASK_26 (ULONG)(0x3ffffff)

/*#define MMC_INTR_TX_TXOSIZEGPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXOSIZEGPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_TX_TXOSIZEGPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (25)))*/

#define MMC_INTR_TX_TXOSIZEGPIS_WR_MASK (ULONG)(0xfdffffff)

#define MMC_INTR_TX_TXOSIZEGPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_TX_RGRD(v);\
		v = (v & (MMC_INTR_TX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_TX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_TX_TXOSIZEGPIS_WR_MASK) | ((data & MMC_INTR_TX_TXOSIZEGPIS_MASK) << 25));\
		MMC_INTR_TX_RGWR(v);\
} while (0)

#define MMC_INTR_TX_TXOSIZEGPIS_UDFRD(data) do {\
		MMC_INTR_TX_RGRD(data);\
		data = ((data >> 25) & MMC_INTR_TX_TXOSIZEGPIS_MASK);\
} while (0)

/*#define MMC_INTR_TX_TXVLANGPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXVLANGPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_TX_TXVLANGPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define MMC_INTR_TX_TXVLANGPIS_WR_MASK (ULONG)(0xfeffffff)

#define MMC_INTR_TX_TXVLANGPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_TX_RGRD(v);\
		v = (v & (MMC_INTR_TX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_TX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_TX_TXVLANGPIS_WR_MASK) | ((data & MMC_INTR_TX_TXVLANGPIS_MASK) << 24));\
		MMC_INTR_TX_RGWR(v);\
} while (0)

#define MMC_INTR_TX_TXVLANGPIS_UDFRD(data) do {\
		MMC_INTR_TX_RGRD(data);\
		data = ((data >> 24) & MMC_INTR_TX_TXVLANGPIS_MASK);\
} while (0)

/*#define MMC_INTR_TX_TXPAUSPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXPAUSPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_TX_TXPAUSPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (23)))*/

#define MMC_INTR_TX_TXPAUSPIS_WR_MASK (ULONG)(0xff7fffff)

#define MMC_INTR_TX_TXPAUSPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_TX_RGRD(v);\
		v = (v & (MMC_INTR_TX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_TX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_TX_TXPAUSPIS_WR_MASK) | ((data & MMC_INTR_TX_TXPAUSPIS_MASK) << 23));\
		MMC_INTR_TX_RGWR(v);\
} while (0)

#define MMC_INTR_TX_TXPAUSPIS_UDFRD(data) do {\
		MMC_INTR_TX_RGRD(data);\
		data = ((data >> 23) & MMC_INTR_TX_TXPAUSPIS_MASK);\
} while (0)

/*#define MMC_INTR_TX_TXEXDEFPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXEXDEFPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_TX_TXEXDEFPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (22)))*/

#define MMC_INTR_TX_TXEXDEFPIS_WR_MASK (ULONG)(0xffbfffff)

#define MMC_INTR_TX_TXEXDEFPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_TX_RGRD(v);\
		v = (v & (MMC_INTR_TX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_TX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_TX_TXEXDEFPIS_WR_MASK) | ((data & MMC_INTR_TX_TXEXDEFPIS_MASK) << 22));\
		MMC_INTR_TX_RGWR(v);\
} while (0)

#define MMC_INTR_TX_TXEXDEFPIS_UDFRD(data) do {\
		MMC_INTR_TX_RGRD(data);\
		data = ((data >> 22) & MMC_INTR_TX_TXEXDEFPIS_MASK);\
} while (0)

/*#define MMC_INTR_TX_TXGPKTIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXGPKTIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_TX_TXGPKTIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (21)))*/

#define MMC_INTR_TX_TXGPKTIS_WR_MASK (ULONG)(0xffdfffff)

#define MMC_INTR_TX_TXGPKTIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_TX_RGRD(v);\
		v = (v & (MMC_INTR_TX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_TX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_TX_TXGPKTIS_WR_MASK) | ((data & MMC_INTR_TX_TXGPKTIS_MASK) << 21));\
		MMC_INTR_TX_RGWR(v);\
} while (0)

#define MMC_INTR_TX_TXGPKTIS_UDFRD(data) do {\
		MMC_INTR_TX_RGRD(data);\
		data = ((data >> 21) & MMC_INTR_TX_TXGPKTIS_MASK);\
} while (0)

/*#define MMC_INTR_TX_TXGOCTIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXGOCTIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_TX_TXGOCTIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MMC_INTR_TX_TXGOCTIS_WR_MASK (ULONG)(0xffefffff)

#define MMC_INTR_TX_TXGOCTIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_TX_RGRD(v);\
		v = (v & (MMC_INTR_TX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_TX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_TX_TXGOCTIS_WR_MASK) | ((data & MMC_INTR_TX_TXGOCTIS_MASK) << 20));\
		MMC_INTR_TX_RGWR(v);\
} while (0)

#define MMC_INTR_TX_TXGOCTIS_UDFRD(data) do {\
		MMC_INTR_TX_RGRD(data);\
		data = ((data >> 20) & MMC_INTR_TX_TXGOCTIS_MASK);\
} while (0)

/*#define MMC_INTR_TX_TXCARERPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXCARERPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_TX_TXCARERPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MMC_INTR_TX_TXCARERPIS_WR_MASK (ULONG)(0xfff7ffff)

#define MMC_INTR_TX_TXCARERPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_TX_RGRD(v);\
		v = (v & (MMC_INTR_TX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_TX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_TX_TXCARERPIS_WR_MASK) | ((data & MMC_INTR_TX_TXCARERPIS_MASK) << 19));\
		MMC_INTR_TX_RGWR(v);\
} while (0)

#define MMC_INTR_TX_TXCARERPIS_UDFRD(data) do {\
		MMC_INTR_TX_RGRD(data);\
		data = ((data >> 19) & MMC_INTR_TX_TXCARERPIS_MASK);\
} while (0)

/*#define MMC_INTR_TX_TXEXCOLPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXEXCOLPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_TX_TXEXCOLPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MMC_INTR_TX_TXEXCOLPIS_WR_MASK (ULONG)(0xfffbffff)

#define MMC_INTR_TX_TXEXCOLPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_TX_RGRD(v);\
		v = (v & (MMC_INTR_TX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_TX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_TX_TXEXCOLPIS_WR_MASK) | ((data & MMC_INTR_TX_TXEXCOLPIS_MASK) << 18));\
		MMC_INTR_TX_RGWR(v);\
} while (0)

#define MMC_INTR_TX_TXEXCOLPIS_UDFRD(data) do {\
		MMC_INTR_TX_RGRD(data);\
		data = ((data >> 18) & MMC_INTR_TX_TXEXCOLPIS_MASK);\
} while (0)

/*#define MMC_INTR_TX_TXLATCOLPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXLATCOLPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_TX_TXLATCOLPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (17)))*/

#define MMC_INTR_TX_TXLATCOLPIS_WR_MASK (ULONG)(0xfffdffff)

#define MMC_INTR_TX_TXLATCOLPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_TX_RGRD(v);\
		v = (v & (MMC_INTR_TX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_TX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_TX_TXLATCOLPIS_WR_MASK) | ((data & MMC_INTR_TX_TXLATCOLPIS_MASK) << 17));\
		MMC_INTR_TX_RGWR(v);\
} while (0)

#define MMC_INTR_TX_TXLATCOLPIS_UDFRD(data) do {\
		MMC_INTR_TX_RGRD(data);\
		data = ((data >> 17) & MMC_INTR_TX_TXLATCOLPIS_MASK);\
} while (0)

/*#define MMC_INTR_TX_TXDEFPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXDEFPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_TX_TXDEFPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MMC_INTR_TX_TXDEFPIS_WR_MASK (ULONG)(0xfffeffff)

#define MMC_INTR_TX_TXDEFPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_TX_RGRD(v);\
		v = (v & (MMC_INTR_TX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_TX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_TX_TXDEFPIS_WR_MASK) | ((data & MMC_INTR_TX_TXDEFPIS_MASK) << 16));\
		MMC_INTR_TX_RGWR(v);\
} while (0)

#define MMC_INTR_TX_TXDEFPIS_UDFRD(data) do {\
		MMC_INTR_TX_RGRD(data);\
		data = ((data >> 16) & MMC_INTR_TX_TXDEFPIS_MASK);\
} while (0)

/*#define MMC_INTR_TX_TXMCOLGPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXMCOLGPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_TX_TXMCOLGPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (15)))*/

#define MMC_INTR_TX_TXMCOLGPIS_WR_MASK (ULONG)(0xffff7fff)

#define MMC_INTR_TX_TXMCOLGPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_TX_RGRD(v);\
		v = (v & (MMC_INTR_TX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_TX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_TX_TXMCOLGPIS_WR_MASK) | ((data & MMC_INTR_TX_TXMCOLGPIS_MASK) << 15));\
		MMC_INTR_TX_RGWR(v);\
} while (0)

#define MMC_INTR_TX_TXMCOLGPIS_UDFRD(data) do {\
		MMC_INTR_TX_RGRD(data);\
		data = ((data >> 15) & MMC_INTR_TX_TXMCOLGPIS_MASK);\
} while (0)

/*#define MMC_INTR_TX_TXSCOLGPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXSCOLGPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_TX_TXSCOLGPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (14)))*/

#define MMC_INTR_TX_TXSCOLGPIS_WR_MASK (ULONG)(0xffffbfff)

#define MMC_INTR_TX_TXSCOLGPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_TX_RGRD(v);\
		v = (v & (MMC_INTR_TX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_TX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_TX_TXSCOLGPIS_WR_MASK) | ((data & MMC_INTR_TX_TXSCOLGPIS_MASK) << 14));\
		MMC_INTR_TX_RGWR(v);\
} while (0)

#define MMC_INTR_TX_TXSCOLGPIS_UDFRD(data) do {\
		MMC_INTR_TX_RGRD(data);\
		data = ((data >> 14) & MMC_INTR_TX_TXSCOLGPIS_MASK);\
} while (0)

/*#define MMC_INTR_TX_TXUFLOWERFIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXUFLOWERFIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_TX_TXUFLOWERFIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (13)))*/

#define MMC_INTR_TX_TXUFLOWERFIS_WR_MASK (ULONG)(0xffffdfff)

#define MMC_INTR_TX_TXUFLOWERFIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_TX_RGRD(v);\
		v = (v & (MMC_INTR_TX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_TX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_TX_TXUFLOWERFIS_WR_MASK) | ((data & MMC_INTR_TX_TXUFLOWERFIS_MASK) << 13));\
		MMC_INTR_TX_RGWR(v);\
} while (0)

#define MMC_INTR_TX_TXUFLOWERFIS_UDFRD(data) do {\
		MMC_INTR_TX_RGRD(data);\
		data = ((data >> 13) & MMC_INTR_TX_TXUFLOWERFIS_MASK);\
} while (0)

/*#define MMC_INTR_TX_TXBCGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXBCGBPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_TX_TXBCGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define MMC_INTR_TX_TXBCGBPIS_WR_MASK (ULONG)(0xffffefff)

#define MMC_INTR_TX_TXBCGBPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_TX_RGRD(v);\
		v = (v & (MMC_INTR_TX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_TX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_TX_TXBCGBPIS_WR_MASK) | ((data & MMC_INTR_TX_TXBCGBPIS_MASK) << 12));\
		MMC_INTR_TX_RGWR(v);\
} while (0)

#define MMC_INTR_TX_TXBCGBPIS_UDFRD(data) do {\
		MMC_INTR_TX_RGRD(data);\
		data = ((data >> 12) & MMC_INTR_TX_TXBCGBPIS_MASK);\
} while (0)

/*#define MMC_INTR_TX_TXMCGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXMCGBPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_TX_TXMCGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MMC_INTR_TX_TXMCGBPIS_WR_MASK (ULONG)(0xfffff7ff)

#define MMC_INTR_TX_TXMCGBPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_TX_RGRD(v);\
		v = (v & (MMC_INTR_TX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_TX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_TX_TXMCGBPIS_WR_MASK) | ((data & MMC_INTR_TX_TXMCGBPIS_MASK) << 11));\
		MMC_INTR_TX_RGWR(v);\
} while (0)

#define MMC_INTR_TX_TXMCGBPIS_UDFRD(data) do {\
		MMC_INTR_TX_RGRD(data);\
		data = ((data >> 11) & MMC_INTR_TX_TXMCGBPIS_MASK);\
} while (0)

/*#define MMC_INTR_TX_TXUCGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXUCGBPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_TX_TXUCGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (10)))*/

#define MMC_INTR_TX_TXUCGBPIS_WR_MASK (ULONG)(0xfffffbff)

#define MMC_INTR_TX_TXUCGBPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_TX_RGRD(v);\
		v = (v & (MMC_INTR_TX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_TX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_TX_TXUCGBPIS_WR_MASK) | ((data & MMC_INTR_TX_TXUCGBPIS_MASK) << 10));\
		MMC_INTR_TX_RGWR(v);\
} while (0)

#define MMC_INTR_TX_TXUCGBPIS_UDFRD(data) do {\
		MMC_INTR_TX_RGRD(data);\
		data = ((data >> 10) & MMC_INTR_TX_TXUCGBPIS_MASK);\
} while (0)

/*#define MMC_INTR_TX_TX1024TMAXOCTGBFIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TX1024TMAXOCTGBFIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_TX_TX1024TMAXOCTGBFIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (9)))*/

#define MMC_INTR_TX_TX1024TMAXOCTGBFIS_WR_MASK (ULONG)(0xfffffdff)

#define MMC_INTR_TX_TX1024TMAXOCTGBFIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_TX_RGRD(v);\
		v = (v & (MMC_INTR_TX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_TX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_TX_TX1024TMAXOCTGBFIS_WR_MASK) | ((data & MMC_INTR_TX_TX1024TMAXOCTGBFIS_MASK) << 9));\
		MMC_INTR_TX_RGWR(v);\
} while (0)

#define MMC_INTR_TX_TX1024TMAXOCTGBFIS_UDFRD(data) do {\
		MMC_INTR_TX_RGRD(data);\
		data = ((data >> 9) & MMC_INTR_TX_TX1024TMAXOCTGBFIS_MASK);\
} while (0)

/*#define MMC_INTR_TX_TX512T1023OCTGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TX512T1023OCTGBPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_TX_TX512T1023OCTGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (8)))*/

#define MMC_INTR_TX_TX512T1023OCTGBPIS_WR_MASK (ULONG)(0xfffffeff)

#define MMC_INTR_TX_TX512T1023OCTGBPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_TX_RGRD(v);\
		v = (v & (MMC_INTR_TX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_TX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_TX_TX512T1023OCTGBPIS_WR_MASK) | ((data & MMC_INTR_TX_TX512T1023OCTGBPIS_MASK) << 8));\
		MMC_INTR_TX_RGWR(v);\
} while (0)

#define MMC_INTR_TX_TX512T1023OCTGBPIS_UDFRD(data) do {\
		MMC_INTR_TX_RGRD(data);\
		data = ((data >> 8) & MMC_INTR_TX_TX512T1023OCTGBPIS_MASK);\
} while (0)

/*#define MMC_INTR_TX_TX256T511OCTGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TX256T511OCTGBPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_TX_TX256T511OCTGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MMC_INTR_TX_TX256T511OCTGBPIS_WR_MASK (ULONG)(0xffffff7f)

#define MMC_INTR_TX_TX256T511OCTGBPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_TX_RGRD(v);\
		v = (v & (MMC_INTR_TX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_TX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_TX_TX256T511OCTGBPIS_WR_MASK) | ((data & MMC_INTR_TX_TX256T511OCTGBPIS_MASK) << 7));\
		MMC_INTR_TX_RGWR(v);\
} while (0)

#define MMC_INTR_TX_TX256T511OCTGBPIS_UDFRD(data) do {\
		MMC_INTR_TX_RGRD(data);\
		data = ((data >> 7) & MMC_INTR_TX_TX256T511OCTGBPIS_MASK);\
} while (0)

/*#define MMC_INTR_TX_TX128T255OCTGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TX128T255OCTGBPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_TX_TX128T255OCTGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (6)))*/

#define MMC_INTR_TX_TX128T255OCTGBPIS_WR_MASK (ULONG)(0xffffffbf)

#define MMC_INTR_TX_TX128T255OCTGBPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_TX_RGRD(v);\
		v = (v & (MMC_INTR_TX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_TX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_TX_TX128T255OCTGBPIS_WR_MASK) | ((data & MMC_INTR_TX_TX128T255OCTGBPIS_MASK) << 6));\
		MMC_INTR_TX_RGWR(v);\
} while (0)

#define MMC_INTR_TX_TX128T255OCTGBPIS_UDFRD(data) do {\
		MMC_INTR_TX_RGRD(data);\
		data = ((data >> 6) & MMC_INTR_TX_TX128T255OCTGBPIS_MASK);\
} while (0)

/*#define MMC_INTR_TX_TX65T127OCTGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TX65T127OCTGBPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_TX_TX65T127OCTGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MMC_INTR_TX_TX65T127OCTGBPIS_WR_MASK (ULONG)(0xffffffdf)

#define MMC_INTR_TX_TX65T127OCTGBPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_TX_RGRD(v);\
		v = (v & (MMC_INTR_TX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_TX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_TX_TX65T127OCTGBPIS_WR_MASK) | ((data & MMC_INTR_TX_TX65T127OCTGBPIS_MASK) << 5));\
		MMC_INTR_TX_RGWR(v);\
} while (0)

#define MMC_INTR_TX_TX65T127OCTGBPIS_UDFRD(data) do {\
		MMC_INTR_TX_RGRD(data);\
		data = ((data >> 5) & MMC_INTR_TX_TX65T127OCTGBPIS_MASK);\
} while (0)

/*#define MMC_INTR_TX_TX64OCTGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TX64OCTGBPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_TX_TX64OCTGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MMC_INTR_TX_TX64OCTGBPIS_WR_MASK (ULONG)(0xffffffef)

#define MMC_INTR_TX_TX64OCTGBPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_TX_RGRD(v);\
		v = (v & (MMC_INTR_TX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_TX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_TX_TX64OCTGBPIS_WR_MASK) | ((data & MMC_INTR_TX_TX64OCTGBPIS_MASK) << 4));\
		MMC_INTR_TX_RGWR(v);\
} while (0)

#define MMC_INTR_TX_TX64OCTGBPIS_UDFRD(data) do {\
		MMC_INTR_TX_RGRD(data);\
		data = ((data >> 4) & MMC_INTR_TX_TX64OCTGBPIS_MASK);\
} while (0)

/*#define MMC_INTR_TX_TXMCGPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXMCGPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_TX_TXMCGPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MMC_INTR_TX_TXMCGPIS_WR_MASK (ULONG)(0xfffffff7)

#define MMC_INTR_TX_TXMCGPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_TX_RGRD(v);\
		v = (v & (MMC_INTR_TX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_TX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_TX_TXMCGPIS_WR_MASK) | ((data & MMC_INTR_TX_TXMCGPIS_MASK) << 3));\
		MMC_INTR_TX_RGWR(v);\
} while (0)

#define MMC_INTR_TX_TXMCGPIS_UDFRD(data) do {\
		MMC_INTR_TX_RGRD(data);\
		data = ((data >> 3) & MMC_INTR_TX_TXMCGPIS_MASK);\
} while (0)

/*#define MMC_INTR_TX_TXBCGPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXBCGPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_TX_TXBCGPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MMC_INTR_TX_TXBCGPIS_WR_MASK (ULONG)(0xfffffffb)

#define MMC_INTR_TX_TXBCGPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_TX_RGRD(v);\
		v = (v & (MMC_INTR_TX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_TX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_TX_TXBCGPIS_WR_MASK) | ((data & MMC_INTR_TX_TXBCGPIS_MASK) << 2));\
		MMC_INTR_TX_RGWR(v);\
} while (0)

#define MMC_INTR_TX_TXBCGPIS_UDFRD(data) do {\
		MMC_INTR_TX_RGRD(data);\
		data = ((data >> 2) & MMC_INTR_TX_TXBCGPIS_MASK);\
} while (0)

/*#define MMC_INTR_TX_TXGBPKTIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXGBPKTIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_TX_TXGBPKTIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MMC_INTR_TX_TXGBPKTIS_WR_MASK (ULONG)(0xfffffffd)

#define MMC_INTR_TX_TXGBPKTIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_TX_RGRD(v);\
		v = (v & (MMC_INTR_TX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_TX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_TX_TXGBPKTIS_WR_MASK) | ((data & MMC_INTR_TX_TXGBPKTIS_MASK) << 1));\
		MMC_INTR_TX_RGWR(v);\
} while (0)

#define MMC_INTR_TX_TXGBPKTIS_UDFRD(data) do {\
		MMC_INTR_TX_RGRD(data);\
		data = ((data >> 1) & MMC_INTR_TX_TXGBPKTIS_MASK);\
} while (0)

/*#define MMC_INTR_TX_TXGBOCTIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXGBOCTIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_TX_TXGBOCTIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MMC_INTR_TX_TXGBOCTIS_WR_MASK (ULONG)(0xfffffffe)

#define MMC_INTR_TX_TXGBOCTIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_TX_RGRD(v);\
		v = (v & (MMC_INTR_TX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_TX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_TX_TXGBOCTIS_WR_MASK) | ((data & MMC_INTR_TX_TXGBOCTIS_MASK) << 0));\
		MMC_INTR_TX_RGWR(v);\
} while (0)

#define MMC_INTR_TX_TXGBOCTIS_UDFRD(data) do {\
		MMC_INTR_TX_RGRD(data);\
		data = ((data >> 0) & MMC_INTR_TX_TXGBOCTIS_MASK);\
} while (0)

#define MMC_INTR_RX_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x704))

#define MMC_INTR_RX_RGWR(data) do {\
		iowrite32(data, (void *)MMC_INTR_RX_RGOFFADDR);\
} while (0)

#define MMC_INTR_RX_RGRD(data) do {\
		(data) = ioread32((void *)MMC_INTR_RX_RGOFFADDR);\
} while (0)

/*#define  MMC_INTR_RX_Mask_26 (ULONG)(~(~0<<(6)))*/

#define  MMC_INTR_RX_MASK_26 (ULONG)(0x3f)

/*#define MMC_INTR_RX_RES_Wr_Mask_26 (ULONG)(~((~(~0<<(6)))<<(26)))*/

#define MMC_INTR_RX_RES_WR_MASK_26 (ULONG)(0x3ffffff)

/*#define MMC_INTR_RX_RXCTRLPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXCTRLPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_RX_RXCTRLPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (25)))*/

#define MMC_INTR_RX_RXCTRLPIS_WR_MASK (ULONG)(0xfdffffff)

#define MMC_INTR_RX_RXCTRLPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_RX_RGRD(v);\
		v = (v & (MMC_INTR_RX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_RX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_RX_RXCTRLPIS_WR_MASK) | ((data & MMC_INTR_RX_RXCTRLPIS_MASK) << 25));\
		MMC_INTR_RX_RGWR(v);\
} while (0)

#define MMC_INTR_RX_RXCTRLPIS_UDFRD(data) do {\
		MMC_INTR_RX_RGRD(data);\
		data = ((data >> 25) & MMC_INTR_RX_RXCTRLPIS_MASK);\
} while (0)

/*#define MMC_INTR_RX_RXRCVERRPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXRCVERRPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_RX_RXRCVERRPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define MMC_INTR_RX_RXRCVERRPIS_WR_MASK (ULONG)(0xfeffffff)

#define MMC_INTR_RX_RXRCVERRPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_RX_RGRD(v);\
		v = (v & (MMC_INTR_RX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_RX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_RX_RXRCVERRPIS_WR_MASK) | ((data & MMC_INTR_RX_RXRCVERRPIS_MASK) << 24));\
		MMC_INTR_RX_RGWR(v);\
} while (0)

#define MMC_INTR_RX_RXRCVERRPIS_UDFRD(data) do {\
		MMC_INTR_RX_RGRD(data);\
		data = ((data >> 24) & MMC_INTR_RX_RXRCVERRPIS_MASK);\
} while (0)

/*#define MMC_INTR_RX_RXWDOGPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXWDOGPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_RX_RXWDOGPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (23)))*/

#define MMC_INTR_RX_RXWDOGPIS_WR_MASK (ULONG)(0xff7fffff)

#define MMC_INTR_RX_RXWDOGPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_RX_RGRD(v);\
		v = (v & (MMC_INTR_RX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_RX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_RX_RXWDOGPIS_WR_MASK) | ((data & MMC_INTR_RX_RXWDOGPIS_MASK) << 23));\
		MMC_INTR_RX_RGWR(v);\
} while (0)

#define MMC_INTR_RX_RXWDOGPIS_UDFRD(data) do {\
		MMC_INTR_RX_RGRD(data);\
		data = ((data >> 23) & MMC_INTR_RX_RXWDOGPIS_MASK);\
} while (0)

/*#define MMC_INTR_RX_RXVLANGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXVLANGBPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_RX_RXVLANGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (22)))*/

#define MMC_INTR_RX_RXVLANGBPIS_WR_MASK (ULONG)(0xffbfffff)

#define MMC_INTR_RX_RXVLANGBPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_RX_RGRD(v);\
		v = (v & (MMC_INTR_RX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_RX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_RX_RXVLANGBPIS_WR_MASK) | ((data & MMC_INTR_RX_RXVLANGBPIS_MASK) << 22));\
		MMC_INTR_RX_RGWR(v);\
} while (0)

#define MMC_INTR_RX_RXVLANGBPIS_UDFRD(data) do {\
		MMC_INTR_RX_RGRD(data);\
		data = ((data >> 22) & MMC_INTR_RX_RXVLANGBPIS_MASK);\
} while (0)

/*#define MMC_INTR_RX_RXFOVPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXFOVPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_RX_RXFOVPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (21)))*/

#define MMC_INTR_RX_RXFOVPIS_WR_MASK (ULONG)(0xffdfffff)

#define MMC_INTR_RX_RXFOVPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_RX_RGRD(v);\
		v = (v & (MMC_INTR_RX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_RX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_RX_RXFOVPIS_WR_MASK) | ((data & MMC_INTR_RX_RXFOVPIS_MASK) << 21));\
		MMC_INTR_RX_RGWR(v);\
} while (0)

#define MMC_INTR_RX_RXFOVPIS_UDFRD(data) do {\
		MMC_INTR_RX_RGRD(data);\
		data = ((data >> 21) & MMC_INTR_RX_RXFOVPIS_MASK);\
} while (0)

/*#define MMC_INTR_RX_RXPAUSPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXPAUSPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_RX_RXPAUSPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MMC_INTR_RX_RXPAUSPIS_WR_MASK (ULONG)(0xffefffff)

#define MMC_INTR_RX_RXPAUSPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_RX_RGRD(v);\
		v = (v & (MMC_INTR_RX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_RX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_RX_RXPAUSPIS_WR_MASK) | ((data & MMC_INTR_RX_RXPAUSPIS_MASK) << 20));\
		MMC_INTR_RX_RGWR(v);\
} while (0)

#define MMC_INTR_RX_RXPAUSPIS_UDFRD(data) do {\
		MMC_INTR_RX_RGRD(data);\
		data = ((data >> 20) & MMC_INTR_RX_RXPAUSPIS_MASK);\
} while (0)

/*#define MMC_INTR_RX_RXORANGEPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXORANGEPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_RX_RXORANGEPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MMC_INTR_RX_RXORANGEPIS_WR_MASK (ULONG)(0xfff7ffff)

#define MMC_INTR_RX_RXORANGEPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_RX_RGRD(v);\
		v = (v & (MMC_INTR_RX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_RX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_RX_RXORANGEPIS_WR_MASK) | ((data & MMC_INTR_RX_RXORANGEPIS_MASK) << 19));\
		MMC_INTR_RX_RGWR(v);\
} while (0)

#define MMC_INTR_RX_RXORANGEPIS_UDFRD(data) do {\
		MMC_INTR_RX_RGRD(data);\
		data = ((data >> 19) & MMC_INTR_RX_RXORANGEPIS_MASK);\
} while (0)

/*#define MMC_INTR_RX_RXLENERPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXLENERPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_RX_RXLENERPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MMC_INTR_RX_RXLENERPIS_WR_MASK (ULONG)(0xfffbffff)

#define MMC_INTR_RX_RXLENERPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_RX_RGRD(v);\
		v = (v & (MMC_INTR_RX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_RX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_RX_RXLENERPIS_WR_MASK) | ((data & MMC_INTR_RX_RXLENERPIS_MASK) << 18));\
		MMC_INTR_RX_RGWR(v);\
} while (0)

#define MMC_INTR_RX_RXLENERPIS_UDFRD(data) do {\
		MMC_INTR_RX_RGRD(data);\
		data = ((data >> 18) & MMC_INTR_RX_RXLENERPIS_MASK);\
} while (0)

/*#define MMC_INTR_RX_RXUCBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXUCBPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_RX_RXUCBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (17)))*/

#define MMC_INTR_RX_RXUCBPIS_WR_MASK (ULONG)(0xfffdffff)

#define MMC_INTR_RX_RXUCBPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_RX_RGRD(v);\
		v = (v & (MMC_INTR_RX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_RX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_RX_RXUCBPIS_WR_MASK) | ((data & MMC_INTR_RX_RXUCBPIS_MASK) << 17));\
		MMC_INTR_RX_RGWR(v);\
} while (0)

#define MMC_INTR_RX_RXUCBPIS_UDFRD(data) do {\
		MMC_INTR_RX_RGRD(data);\
		data = ((data >> 17) & MMC_INTR_RX_RXUCBPIS_MASK);\
} while (0)

/*#define MMC_INTR_RX_RX1024TMAXOCTGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RX1024TMAXOCTGBPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_RX_RX1024TMAXOCTGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MMC_INTR_RX_RX1024TMAXOCTGBPIS_WR_MASK (ULONG)(0xfffeffff)

#define MMC_INTR_RX_RX1024TMAXOCTGBPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_RX_RGRD(v);\
		v = (v & (MMC_INTR_RX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_RX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_RX_RX1024TMAXOCTGBPIS_WR_MASK) | ((data & MMC_INTR_RX_RX1024TMAXOCTGBPIS_MASK) << 16));\
		MMC_INTR_RX_RGWR(v);\
} while (0)

#define MMC_INTR_RX_RX1024TMAXOCTGBPIS_UDFRD(data) do {\
		MMC_INTR_RX_RGRD(data);\
		data = ((data >> 16) & MMC_INTR_RX_RX1024TMAXOCTGBPIS_MASK);\
} while (0)

/*#define MMC_INTR_RX_RX512T1023OCTGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RX512T1023OCTGBPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_RX_RX512T1023OCTGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (15)))*/

#define MMC_INTR_RX_RX512T1023OCTGBPIS_WR_MASK (ULONG)(0xffff7fff)

#define MMC_INTR_RX_RX512T1023OCTGBPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_RX_RGRD(v);\
		v = (v & (MMC_INTR_RX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_RX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_RX_RX512T1023OCTGBPIS_WR_MASK) | ((data & MMC_INTR_RX_RX512T1023OCTGBPIS_MASK) << 15));\
		MMC_INTR_RX_RGWR(v);\
} while (0)

#define MMC_INTR_RX_RX512T1023OCTGBPIS_UDFRD(data) do {\
		MMC_INTR_RX_RGRD(data);\
		data = ((data >> 15) & MMC_INTR_RX_RX512T1023OCTGBPIS_MASK);\
} while (0)

/*#define MMC_INTR_RX_RX256T511OCTGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RX256T511OCTGBPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_RX_RX256T511OCTGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (14)))*/

#define MMC_INTR_RX_RX256T511OCTGBPIS_WR_MASK (ULONG)(0xffffbfff)

#define MMC_INTR_RX_RX256T511OCTGBPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_RX_RGRD(v);\
		v = (v & (MMC_INTR_RX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_RX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_RX_RX256T511OCTGBPIS_WR_MASK) | ((data & MMC_INTR_RX_RX256T511OCTGBPIS_MASK) << 14));\
		MMC_INTR_RX_RGWR(v);\
} while (0)

#define MMC_INTR_RX_RX256T511OCTGBPIS_UDFRD(data) do {\
		MMC_INTR_RX_RGRD(data);\
		data = ((data >> 14) & MMC_INTR_RX_RX256T511OCTGBPIS_MASK);\
} while (0)

/*#define MMC_INTR_RX_RX128T255OCTGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RX128T255OCTGBPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_RX_RX128T255OCTGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (13)))*/

#define MMC_INTR_RX_RX128T255OCTGBPIS_WR_MASK (ULONG)(0xffffdfff)

#define MMC_INTR_RX_RX128T255OCTGBPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_RX_RGRD(v);\
		v = (v & (MMC_INTR_RX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_RX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_RX_RX128T255OCTGBPIS_WR_MASK) | ((data & MMC_INTR_RX_RX128T255OCTGBPIS_MASK) << 13));\
		MMC_INTR_RX_RGWR(v);\
} while (0)

#define MMC_INTR_RX_RX128T255OCTGBPIS_UDFRD(data) do {\
		MMC_INTR_RX_RGRD(data);\
		data = ((data >> 13) & MMC_INTR_RX_RX128T255OCTGBPIS_MASK);\
} while (0)

/*#define MMC_INTR_RX_RX65T127OCTGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RX65T127OCTGBPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_RX_RX65T127OCTGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define MMC_INTR_RX_RX65T127OCTGBPIS_WR_MASK (ULONG)(0xffffefff)

#define MMC_INTR_RX_RX65T127OCTGBPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_RX_RGRD(v);\
		v = (v & (MMC_INTR_RX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_RX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_RX_RX65T127OCTGBPIS_WR_MASK) | ((data & MMC_INTR_RX_RX65T127OCTGBPIS_MASK) << 12));\
		MMC_INTR_RX_RGWR(v);\
} while (0)

#define MMC_INTR_RX_RX65T127OCTGBPIS_UDFRD(data) do {\
		MMC_INTR_RX_RGRD(data);\
		data = ((data >> 12) & MMC_INTR_RX_RX65T127OCTGBPIS_MASK);\
} while (0)

/*#define MMC_INTR_RX_RX64OCTGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RX64OCTGBPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_RX_RX64OCTGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MMC_INTR_RX_RX64OCTGBPIS_WR_MASK (ULONG)(0xfffff7ff)

#define MMC_INTR_RX_RX64OCTGBPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_RX_RGRD(v);\
		v = (v & (MMC_INTR_RX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_RX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_RX_RX64OCTGBPIS_WR_MASK) | ((data & MMC_INTR_RX_RX64OCTGBPIS_MASK) << 11));\
		MMC_INTR_RX_RGWR(v);\
} while (0)

#define MMC_INTR_RX_RX64OCTGBPIS_UDFRD(data) do {\
		MMC_INTR_RX_RGRD(data);\
		data = ((data >> 11) & MMC_INTR_RX_RX64OCTGBPIS_MASK);\
} while (0)

/*#define MMC_INTR_RX_RXOSIZEGPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXOSIZEGPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_RX_RXOSIZEGPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (10)))*/

#define MMC_INTR_RX_RXOSIZEGPIS_WR_MASK (ULONG)(0xfffffbff)

#define MMC_INTR_RX_RXOSIZEGPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_RX_RGRD(v);\
		v = (v & (MMC_INTR_RX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_RX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_RX_RXOSIZEGPIS_WR_MASK) | ((data & MMC_INTR_RX_RXOSIZEGPIS_MASK) << 10));\
		MMC_INTR_RX_RGWR(v);\
} while (0)

#define MMC_INTR_RX_RXOSIZEGPIS_UDFRD(data) do {\
		MMC_INTR_RX_RGRD(data);\
		data = ((data >> 10) & MMC_INTR_RX_RXOSIZEGPIS_MASK);\
} while (0)

/*#define MMC_INTR_RX_RXUSIZEGPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXUSIZEGPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_RX_RXUSIZEGPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (9)))*/

#define MMC_INTR_RX_RXUSIZEGPIS_WR_MASK (ULONG)(0xfffffdff)

#define MMC_INTR_RX_RXUSIZEGPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_RX_RGRD(v);\
		v = (v & (MMC_INTR_RX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_RX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_RX_RXUSIZEGPIS_WR_MASK) | ((data & MMC_INTR_RX_RXUSIZEGPIS_MASK) << 9));\
		MMC_INTR_RX_RGWR(v);\
} while (0)

#define MMC_INTR_RX_RXUSIZEGPIS_UDFRD(data) do {\
		MMC_INTR_RX_RGRD(data);\
		data = ((data >> 9) & MMC_INTR_RX_RXUSIZEGPIS_MASK);\
} while (0)

/*#define MMC_INTR_RX_RXJABERPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXJABERPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_RX_RXJABERPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (8)))*/

#define MMC_INTR_RX_RXJABERPIS_WR_MASK (ULONG)(0xfffffeff)

#define MMC_INTR_RX_RXJABERPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_RX_RGRD(v);\
		v = (v & (MMC_INTR_RX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_RX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_RX_RXJABERPIS_WR_MASK) | ((data & MMC_INTR_RX_RXJABERPIS_MASK) << 8));\
		MMC_INTR_RX_RGWR(v);\
} while (0)

#define MMC_INTR_RX_RXJABERPIS_UDFRD(data) do {\
		MMC_INTR_RX_RGRD(data);\
		data = ((data >> 8) & MMC_INTR_RX_RXJABERPIS_MASK);\
} while (0)

/*#define MMC_INTR_RX_RXRUNTRIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXRUNTRIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_RX_RXRUNTRIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MMC_INTR_RX_RXRUNTRIS_WR_MASK (ULONG)(0xffffff7f)

#define MMC_INTR_RX_RXRUNTRIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_RX_RGRD(v);\
		v = (v & (MMC_INTR_RX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_RX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_RX_RXRUNTRIS_WR_MASK) | ((data & MMC_INTR_RX_RXRUNTRIS_MASK) << 7));\
		MMC_INTR_RX_RGWR(v);\
} while (0)

#define MMC_INTR_RX_RXRUNTRIS_UDFRD(data) do {\
		MMC_INTR_RX_RGRD(data);\
		data = ((data >> 7) & MMC_INTR_RX_RXRUNTRIS_MASK);\
} while (0)

/*#define MMC_INTR_RX_RXALGNERPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXALGNERPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_RX_RXALGNERPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (6)))*/

#define MMC_INTR_RX_RXALGNERPIS_WR_MASK (ULONG)(0xffffffbf)

#define MMC_INTR_RX_RXALGNERPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_RX_RGRD(v);\
		v = (v & (MMC_INTR_RX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_RX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_RX_RXALGNERPIS_WR_MASK) | ((data & MMC_INTR_RX_RXALGNERPIS_MASK) << 6));\
		MMC_INTR_RX_RGWR(v);\
} while (0)

#define MMC_INTR_RX_RXALGNERPIS_UDFRD(data) do {\
		MMC_INTR_RX_RGRD(data);\
		data = ((data >> 6) & MMC_INTR_RX_RXALGNERPIS_MASK);\
} while (0)

/*#define MMC_INTR_RX_RXCRCERPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXCRCERPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_RX_RXCRCERPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MMC_INTR_RX_RXCRCERPIS_WR_MASK (ULONG)(0xffffffdf)

#define MMC_INTR_RX_RXCRCERPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_RX_RGRD(v);\
		v = (v & (MMC_INTR_RX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_RX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_RX_RXCRCERPIS_WR_MASK) | ((data & MMC_INTR_RX_RXCRCERPIS_MASK) << 5));\
		MMC_INTR_RX_RGWR(v);\
} while (0)

#define MMC_INTR_RX_RXCRCERPIS_UDFRD(data) do {\
		MMC_INTR_RX_RGRD(data);\
		data = ((data >> 5) & MMC_INTR_RX_RXCRCERPIS_MASK);\
} while (0)

/*#define MMC_INTR_RX_RXMCGPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXMCGPIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_RX_RXMCGPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MMC_INTR_RX_RXMCGPIS_WR_MASK (ULONG)(0xffffffef)

#define MMC_INTR_RX_RXMCGPIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_RX_RGRD(v);\
		v = (v & (MMC_INTR_RX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_RX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_RX_RXMCGPIS_WR_MASK) | ((data & MMC_INTR_RX_RXMCGPIS_MASK) << 4));\
		MMC_INTR_RX_RGWR(v);\
} while (0)

#define MMC_INTR_RX_RXMCGPIS_UDFRD(data) do {\
		MMC_INTR_RX_RGRD(data);\
		data = ((data >> 4) & MMC_INTR_RX_RXMCGPIS_MASK);\
} while (0)

/*#define MMC_INTR_RX_RXBCGTIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXBCGTIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_RX_RXBCGTIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MMC_INTR_RX_RXBCGTIS_WR_MASK (ULONG)(0xfffffff7)

#define MMC_INTR_RX_RXBCGTIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_RX_RGRD(v);\
		v = (v & (MMC_INTR_RX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_RX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_RX_RXBCGTIS_WR_MASK) | ((data & MMC_INTR_RX_RXBCGTIS_MASK) << 3));\
		MMC_INTR_RX_RGWR(v);\
} while (0)

#define MMC_INTR_RX_RXBCGTIS_UDFRD(data) do {\
		MMC_INTR_RX_RGRD(data);\
		data = ((data >> 3) & MMC_INTR_RX_RXBCGTIS_MASK);\
} while (0)

/*#define MMC_INTR_RX_RXGOCTIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXGOCTIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_RX_RXGOCTIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MMC_INTR_RX_RXGOCTIS_WR_MASK (ULONG)(0xfffffffb)

#define MMC_INTR_RX_RXGOCTIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_RX_RGRD(v);\
		v = (v & (MMC_INTR_RX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_RX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_RX_RXGOCTIS_WR_MASK) | ((data & MMC_INTR_RX_RXGOCTIS_MASK) << 2));\
		MMC_INTR_RX_RGWR(v);\
} while (0)

#define MMC_INTR_RX_RXGOCTIS_UDFRD(data) do {\
		MMC_INTR_RX_RGRD(data);\
		data = ((data >> 2) & MMC_INTR_RX_RXGOCTIS_MASK);\
} while (0)

/*#define MMC_INTR_RX_RXGBOCTIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXGBOCTIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_RX_RXGBOCTIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MMC_INTR_RX_RXGBOCTIS_WR_MASK (ULONG)(0xfffffffd)

#define MMC_INTR_RX_RXGBOCTIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_RX_RGRD(v);\
		v = (v & (MMC_INTR_RX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_RX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_RX_RXGBOCTIS_WR_MASK) | ((data & MMC_INTR_RX_RXGBOCTIS_MASK) << 1));\
		MMC_INTR_RX_RGWR(v);\
} while (0)

#define MMC_INTR_RX_RXGBOCTIS_UDFRD(data) do {\
		MMC_INTR_RX_RGRD(data);\
		data = ((data >> 1) & MMC_INTR_RX_RXGBOCTIS_MASK);\
} while (0)

/*#define MMC_INTR_RX_RXGBPKTIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXGBPKTIS_MASK (ULONG)(0x1)

/*#define MMC_INTR_RX_RXGBPKTIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MMC_INTR_RX_RXGBPKTIS_WR_MASK (ULONG)(0xfffffffe)

#define MMC_INTR_RX_RXGBPKTIS_UDFWR(data) do {\
		ULONG v;\
		MMC_INTR_RX_RGRD(v);\
		v = (v & (MMC_INTR_RX_RES_WR_MASK_26)) | (((0) & (MMC_INTR_RX_MASK_26)) << 26);\
		v = ((v & MMC_INTR_RX_RXGBPKTIS_WR_MASK) | ((data & MMC_INTR_RX_RXGBPKTIS_MASK) << 0));\
		MMC_INTR_RX_RGWR(v);\
} while (0)

#define MMC_INTR_RX_RXGBPKTIS_UDFRD(data) do {\
		MMC_INTR_RX_RGRD(data);\
		data = ((data >> 0) & MMC_INTR_RX_RXGBPKTIS_MASK);\
} while (0)

#define MMC_CNTRL_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x700))

#define MMC_CNTRL_RGWR(data) do {\
		iowrite32(data, (void *)MMC_CNTRL_RGOFFADDR);\
} while (0)

#define MMC_CNTRL_RGRD(data) do {\
		(data) = ioread32((void *)MMC_CNTRL_RGOFFADDR);\
} while (0)

/*#define  MMC_CNTRL_Mask_9 (ULONG)(~(~0<<(23)))*/

#define  MMC_CNTRL_MASK_9 (ULONG)(0x7fffff)

/*#define MMC_CNTRL_RES_Wr_Mask_9 (ULONG)(~((~(~0<<(23)))<<(9)))*/

#define MMC_CNTRL_RES_WR_MASK_9 (ULONG)(0x1ff)

/*#define  MMC_CNTRL_Mask_6 (ULONG)(~(~0<<(2)))*/

#define  MMC_CNTRL_MASK_6 (ULONG)(0x3)

/*#define MMC_CNTRL_RES_Wr_Mask_6 (ULONG)(~((~(~0<<(2)))<<(6)))*/

#define MMC_CNTRL_RES_WR_MASK_6 (ULONG)(0xffffff3f)

/*#define MMC_CNTRL_UCDBC_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_CNTRL_UCDBC_MASK (ULONG)(0x1)

/*#define MMC_CNTRL_UCDBC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (8)))*/

#define MMC_CNTRL_UCDBC_WR_MASK (ULONG)(0xfffffeff)

#define MMC_CNTRL_UCDBC_UDFWR(data) do {\
		ULONG v;\
		MMC_CNTRL_RGRD(v);\
		v = (v & (MMC_CNTRL_RES_WR_MASK_9)) | (((0) & (MMC_CNTRL_MASK_9)) << 9);\
		v = (v & (MMC_CNTRL_RES_WR_MASK_6)) | (((0) & (MMC_CNTRL_MASK_6)) << 6);\
		v = ((v & MMC_CNTRL_UCDBC_WR_MASK) | ((data & MMC_CNTRL_UCDBC_MASK) << 8));\
		MMC_CNTRL_RGWR(v);\
} while (0)

#define MMC_CNTRL_UCDBC_UDFRD(data) do {\
		MMC_CNTRL_RGRD(data);\
		data = ((data >> 8) & MMC_CNTRL_UCDBC_MASK);\
} while (0)

/*#define MMC_CNTRL_CNPRSTLVL_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_CNTRL_CNPRSTLVL_MASK (ULONG)(0x1)

/*#define MMC_CNTRL_CNPRSTLVL_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MMC_CNTRL_CNPRSTLVL_WR_MASK (ULONG)(0xffffffdf)

#define MMC_CNTRL_CNPRSTLVL_UDFWR(data) do {\
		ULONG v;\
		MMC_CNTRL_RGRD(v);\
		v = (v & (MMC_CNTRL_RES_WR_MASK_9)) | (((0) & (MMC_CNTRL_MASK_9)) << 9);\
		v = (v & (MMC_CNTRL_RES_WR_MASK_6)) | (((0) & (MMC_CNTRL_MASK_6)) << 6);\
		v = ((v & MMC_CNTRL_CNPRSTLVL_WR_MASK) | ((data & MMC_CNTRL_CNPRSTLVL_MASK) << 5));\
		MMC_CNTRL_RGWR(v);\
} while (0)

#define MMC_CNTRL_CNPRSTLVL_UDFRD(data) do {\
		MMC_CNTRL_RGRD(data);\
		data = ((data >> 5) & MMC_CNTRL_CNPRSTLVL_MASK);\
} while (0)

/*#define MMC_CNTRL_CNTPRST_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_CNTRL_CNTPRST_MASK (ULONG)(0x1)

/*#define MMC_CNTRL_CNTPRST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MMC_CNTRL_CNTPRST_WR_MASK (ULONG)(0xffffffef)

#define MMC_CNTRL_CNTPRST_UDFWR(data) do {\
		ULONG v;\
		MMC_CNTRL_RGRD(v);\
		v = (v & (MMC_CNTRL_RES_WR_MASK_9)) | (((0) & (MMC_CNTRL_MASK_9)) << 9);\
		v = (v & (MMC_CNTRL_RES_WR_MASK_6)) | (((0) & (MMC_CNTRL_MASK_6)) << 6);\
		v = ((v & MMC_CNTRL_CNTPRST_WR_MASK) | ((data & MMC_CNTRL_CNTPRST_MASK) << 4));\
		MMC_CNTRL_RGWR(v);\
} while (0)

#define MMC_CNTRL_CNTPRST_UDFRD(data) do {\
		MMC_CNTRL_RGRD(data);\
		data = ((data >> 4) & MMC_CNTRL_CNTPRST_MASK);\
} while (0)

/*#define MMC_CNTRL_CNTFREEZ_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_CNTRL_CNTFREEZ_MASK (ULONG)(0x1)

/*#define MMC_CNTRL_CNTFREEZ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MMC_CNTRL_CNTFREEZ_WR_MASK (ULONG)(0xfffffff7)

#define MMC_CNTRL_CNTFREEZ_UDFWR(data) do {\
		ULONG v;\
		MMC_CNTRL_RGRD(v);\
		v = (v & (MMC_CNTRL_RES_WR_MASK_9)) | (((0) & (MMC_CNTRL_MASK_9)) << 9);\
		v = (v & (MMC_CNTRL_RES_WR_MASK_6)) | (((0) & (MMC_CNTRL_MASK_6)) << 6);\
		v = ((v & MMC_CNTRL_CNTFREEZ_WR_MASK) | ((data & MMC_CNTRL_CNTFREEZ_MASK) << 3));\
		MMC_CNTRL_RGWR(v);\
} while (0)

#define MMC_CNTRL_CNTFREEZ_UDFRD(data) do {\
		MMC_CNTRL_RGRD(data);\
		data = ((data >> 3) & MMC_CNTRL_CNTFREEZ_MASK);\
} while (0)

/*#define MMC_CNTRL_RSTONRD_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_CNTRL_RSTONRD_MASK (ULONG)(0x1)

/*#define MMC_CNTRL_RSTONRD_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MMC_CNTRL_RSTONRD_WR_MASK (ULONG)(0xfffffffb)

#define MMC_CNTRL_RSTONRD_UDFWR(data) do {\
		ULONG v;\
		MMC_CNTRL_RGRD(v);\
		v = (v & (MMC_CNTRL_RES_WR_MASK_9)) | (((0) & (MMC_CNTRL_MASK_9)) << 9);\
		v = (v & (MMC_CNTRL_RES_WR_MASK_6)) | (((0) & (MMC_CNTRL_MASK_6)) << 6);\
		v = ((v & MMC_CNTRL_RSTONRD_WR_MASK) | ((data & MMC_CNTRL_RSTONRD_MASK) << 2));\
		MMC_CNTRL_RGWR(v);\
} while (0)

#define MMC_CNTRL_RSTONRD_UDFRD(data) do {\
		MMC_CNTRL_RGRD(data);\
		data = ((data >> 2) & MMC_CNTRL_RSTONRD_MASK);\
} while (0)

/*#define MMC_CNTRL_CNTSTOPRO_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_CNTRL_CNTSTOPRO_MASK (ULONG)(0x1)

/*#define MMC_CNTRL_CNTSTOPRO_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MMC_CNTRL_CNTSTOPRO_WR_MASK (ULONG)(0xfffffffd)

#define MMC_CNTRL_CNTSTOPRO_UDFWR(data) do {\
		ULONG v;\
		MMC_CNTRL_RGRD(v);\
		v = (v & (MMC_CNTRL_RES_WR_MASK_9)) | (((0) & (MMC_CNTRL_MASK_9)) << 9);\
		v = (v & (MMC_CNTRL_RES_WR_MASK_6)) | (((0) & (MMC_CNTRL_MASK_6)) << 6);\
		v = ((v & MMC_CNTRL_CNTSTOPRO_WR_MASK) | ((data & MMC_CNTRL_CNTSTOPRO_MASK) << 1));\
		MMC_CNTRL_RGWR(v);\
} while (0)

#define MMC_CNTRL_CNTSTOPRO_UDFRD(data) do {\
		MMC_CNTRL_RGRD(data);\
		data = ((data >> 1) & MMC_CNTRL_CNTSTOPRO_MASK);\
} while (0)

/*#define MMC_CNTRL_CNTRST_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_CNTRL_CNTRST_MASK (ULONG)(0x1)

/*#define MMC_CNTRL_CNTRST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MMC_CNTRL_CNTRST_WR_MASK (ULONG)(0xfffffffe)

#define MMC_CNTRL_CNTRST_UDFWR(data) do {\
		ULONG v;\
		MMC_CNTRL_RGRD(v);\
		v = (v & (MMC_CNTRL_RES_WR_MASK_9)) | (((0) & (MMC_CNTRL_MASK_9)) << 9);\
		v = (v & (MMC_CNTRL_RES_WR_MASK_6)) | (((0) & (MMC_CNTRL_MASK_6)) << 6);\
		v = ((v & MMC_CNTRL_CNTRST_WR_MASK) | ((data & MMC_CNTRL_CNTRST_MASK) << 0));\
		MMC_CNTRL_RGWR(v);\
} while (0)

#define MMC_CNTRL_CNTRST_UDFRD(data) do {\
		MMC_CNTRL_RGRD(data);\
		data = ((data >> 0) & MMC_CNTRL_CNTRST_MASK);\
} while (0)

#define MAC_MA1LR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x30c))

#define MAC_MA1LR_RGWR(data) do {\
		iowrite32(data, (void *)MAC_MA1LR_RGOFFADDR);\
} while (0)

#define MAC_MA1LR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_MA1LR_RGOFFADDR);\
} while (0)

#define MAC_MA1LR_ADDRLO_UDFWR(data) do {\
		MAC_MA1LR_RGWR(data);\
} while (0)

#define MAC_MA1LR_ADDRLO_UDFRD(data) do {\
		MAC_MA1LR_RGRD(data);\
} while (0)

#define MAC_MA1HR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x308))

#define MAC_MA1HR_RGWR(data) do {\
		iowrite32(data, (void *)MAC_MA1HR_RGOFFADDR);\
} while (0)

#define MAC_MA1HR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_MA1HR_RGOFFADDR);\
} while (0)

/*#define  MAC_MA1HR_Mask_19 (ULONG)(~(~0<<(5)))*/

#define  MAC_MA1HR_MASK_19 (ULONG)(0x1f)

/*#define MAC_MA1HR_RES_Wr_Mask_19 (ULONG)(~((~(~0<<(5)))<<(19)))*/

#define MAC_MA1HR_RES_WR_MASK_19 (ULONG)(0xff07ffff)

/*#define MAC_MA1HR_AE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_MA1HR_AE_MASK (ULONG)(0x1)

/*#define MAC_MA1HR_AE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (31)))*/

#define MAC_MA1HR_AE_WR_MASK (ULONG)(0x7fffffff)

#define MAC_MA1HR_AE_UDFWR(data) do {\
		ULONG v;\
		MAC_MA1HR_RGRD(v);\
		v = (v & (MAC_MA1HR_RES_WR_MASK_19)) | (((0) & (MAC_MA1HR_MASK_19)) << 19);\
		v = ((v & MAC_MA1HR_AE_WR_MASK) | ((data & MAC_MA1HR_AE_MASK) << 31));\
		MAC_MA1HR_RGWR(v);\
} while (0)

#define MAC_MA1HR_AE_UDFRD(data) do {\
		MAC_MA1HR_RGRD(data);\
		data = ((data >> 31) & MAC_MA1HR_AE_MASK);\
} while (0)

/*#define MAC_MA1HR_SA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_MA1HR_SA_MASK (ULONG)(0x1)

/*#define MAC_MA1HR_SA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (30)))*/

#define MAC_MA1HR_SA_WR_MASK (ULONG)(0xbfffffff)

#define MAC_MA1HR_SA_UDFWR(data) do {\
		ULONG v;\
		MAC_MA1HR_RGRD(v);\
		v = (v & (MAC_MA1HR_RES_WR_MASK_19)) | (((0) & (MAC_MA1HR_MASK_19)) << 19);\
		v = ((v & MAC_MA1HR_SA_WR_MASK) | ((data & MAC_MA1HR_SA_MASK) << 30));\
		MAC_MA1HR_RGWR(v);\
} while (0)

#define MAC_MA1HR_SA_UDFRD(data) do {\
		MAC_MA1HR_RGRD(data);\
		data = ((data >> 30) & MAC_MA1HR_SA_MASK);\
} while (0)

/*#define MAC_MA1HR_MBC_Mask (ULONG)(~(~0<<(6)))*/

#define MAC_MA1HR_MBC_MASK (ULONG)(0x3f)

/*#define MAC_MA1HR_MBC_Wr_Mask (ULONG)(~((~(~0 << (6))) << (24)))*/

#define MAC_MA1HR_MBC_WR_MASK (ULONG)(0xc0ffffff)

#define MAC_MA1HR_MBC_UDFWR(data) do {\
		ULONG v;\
		MAC_MA1HR_RGRD(v);\
		v = (v & (MAC_MA1HR_RES_WR_MASK_19)) | (((0) & (MAC_MA1HR_MASK_19)) << 19);\
		v = ((v & MAC_MA1HR_MBC_WR_MASK) | ((data & MAC_MA1HR_MBC_MASK) << 24));\
		MAC_MA1HR_RGWR(v);\
} while (0)

#define MAC_MA1HR_MBC_UDFRD(data) do {\
		MAC_MA1HR_RGRD(data);\
		data = ((data >> 24) & MAC_MA1HR_MBC_MASK);\
} while (0)

/*#define MAC_MA1HR_DCS_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_MA1HR_DCS_MASK (ULONG)(0x7)

/*#define MAC_MA1HR_DCS_Wr_Mask (ULONG)(~((~(~0 << (3))) << (16)))*/

#define MAC_MA1HR_DCS_WR_MASK (ULONG)(0xfff8ffff)

#define MAC_MA1HR_DCS_UDFWR(data) do {\
		ULONG v;\
		MAC_MA1HR_RGRD(v);\
		v = (v & (MAC_MA1HR_RES_WR_MASK_19)) | (((0) & (MAC_MA1HR_MASK_19)) << 19);\
		v = ((v & MAC_MA1HR_DCS_WR_MASK) | ((data & MAC_MA1HR_DCS_MASK) << 16));\
		MAC_MA1HR_RGWR(v);\
} while (0)

#define MAC_MA1HR_DCS_UDFRD(data) do {\
		MAC_MA1HR_RGRD(data);\
		data = ((data >> 16) & MAC_MA1HR_DCS_MASK);\
} while (0)

/*#define MAC_MA1HR_ADDRHI_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_MA1HR_ADDRHI_MASK (ULONG)(0xffff)

/*#define MAC_MA1HR_ADDRHI_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_MA1HR_ADDRHI_WR_MASK (ULONG)(0xffff0000)

#define MAC_MA1HR_ADDRHI_UDFWR(data) do {\
		ULONG v;\
		MAC_MA1HR_RGRD(v);\
		v = (v & (MAC_MA1HR_RES_WR_MASK_19)) | (((0) & (MAC_MA1HR_MASK_19)) << 19);\
		v = ((v & MAC_MA1HR_ADDRHI_WR_MASK) | ((data & MAC_MA1HR_ADDRHI_MASK) << 0));\
		MAC_MA1HR_RGWR(v);\
} while (0)

#define MAC_MA1HR_ADDRHI_UDFRD(data) do {\
		MAC_MA1HR_RGRD(data);\
		data = ((data >> 0) & MAC_MA1HR_ADDRHI_MASK);\
} while (0)

#define MAC_MA0LR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x304))

#define MAC_MA0LR_RGWR(data) do {\
		iowrite32(data, (void *)MAC_MA0LR_RGOFFADDR);\
} while (0)

#define MAC_MA0LR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_MA0LR_RGOFFADDR);\
} while (0)

#define MAC_MA0LR_ADDRLO_UDFWR(data) do {\
		MAC_MA0LR_RGWR(data);\
} while (0)

#define MAC_MA0LR_ADDRLO_UDFRD(data) do {\
		MAC_MA0LR_RGRD(data);\
} while (0)

#define MAC_MA0HR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x300))

#define MAC_MA0HR_RGWR(data) do {\
		iowrite32(data, (void *)MAC_MA0HR_RGOFFADDR);\
} while (0)

#define MAC_MA0HR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_MA0HR_RGOFFADDR);\
} while (0)

/*#define  MAC_MA0HR_Mask_19 (ULONG)(~(~0<<(12)))*/

#define  MAC_MA0HR_MASK_19 (ULONG)(0xfff)

/*#define MAC_MA0HR_RES_Wr_Mask_19 (ULONG)(~((~(~0<<(12)))<<(19)))*/

#define MAC_MA0HR_RES_WR_MASK_19 (ULONG)(0x8007ffff)

/*#define MAC_MA0HR_AE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_MA0HR_AE_MASK (ULONG)(0x1)

/*#define MAC_MA0HR_AE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (31)))*/

#define MAC_MA0HR_AE_WR_MASK (ULONG)(0x7fffffff)

#define MAC_MA0HR_AE_UDFWR(data) do {\
		ULONG v;\
		MAC_MA0HR_RGRD(v);\
		v = (v & (MAC_MA0HR_RES_WR_MASK_19)) | (((0) & (MAC_MA0HR_MASK_19)) << 19);\
		v = ((v & MAC_MA0HR_AE_WR_MASK) | ((data & MAC_MA0HR_AE_MASK) << 31));\
		MAC_MA0HR_RGWR(v);\
} while (0)

#define MAC_MA0HR_AE_UDFRD(data) do {\
		MAC_MA0HR_RGRD(data);\
		data = ((data >> 31) & MAC_MA0HR_AE_MASK);\
} while (0)

/*#define MAC_MA0HR_DCS_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_MA0HR_DCS_MASK (ULONG)(0x7)

/*#define MAC_MA0HR_DCS_Wr_Mask (ULONG)(~((~(~0 << (3))) << (16)))*/

#define MAC_MA0HR_DCS_WR_MASK (ULONG)(0xfff8ffff)

#define MAC_MA0HR_DCS_UDFWR(data) do {\
		ULONG v;\
		MAC_MA0HR_RGRD(v);\
		v = (v & (MAC_MA0HR_RES_WR_MASK_19)) | (((0) & (MAC_MA0HR_MASK_19)) << 19);\
		v = ((v & MAC_MA0HR_DCS_WR_MASK) | ((data & MAC_MA0HR_DCS_MASK) << 16));\
		MAC_MA0HR_RGWR(v);\
} while (0)

#define MAC_MA0HR_DCS_UDFRD(data) do {\
		MAC_MA0HR_RGRD(data);\
		data = ((data >> 16) & MAC_MA0HR_DCS_MASK);\
} while (0)

/*#define MAC_MA0HR_ADDRHI_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_MA0HR_ADDRHI_MASK (ULONG)(0xffff)

/*#define MAC_MA0HR_ADDRHI_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_MA0HR_ADDRHI_WR_MASK (ULONG)(0xffff0000)

#define MAC_MA0HR_ADDRHI_UDFWR(data) do {\
		ULONG v;\
		MAC_MA0HR_RGRD(v);\
		v = (v & (MAC_MA0HR_RES_WR_MASK_19)) | (((0) & (MAC_MA0HR_MASK_19)) << 19);\
		v = ((v & MAC_MA0HR_ADDRHI_WR_MASK) | ((data & MAC_MA0HR_ADDRHI_MASK) << 0));\
		MAC_MA0HR_RGWR(v);\
} while (0)

#define MAC_MA0HR_ADDRHI_UDFRD(data) do {\
		MAC_MA0HR_RGRD(data);\
		data = ((data >> 0) & MAC_MA0HR_ADDRHI_MASK);\
} while (0)

#define MAC_GPIOR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x208))

#define MAC_GPIOR_RGWR(data) do {\
		iowrite32(data, (void *)MAC_GPIOR_RGOFFADDR);\
} while (0)

#define MAC_GPIOR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_GPIOR_RGOFFADDR);\
} while (0)

/*#define  MAC_GPIOR_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  MAC_GPIOR_MASK_28 (ULONG)(0xf)

/*#define MAC_GPIOR_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define MAC_GPIOR_RES_WR_MASK_28 (ULONG)(0xfffffff)

/*#define  MAC_GPIOR_Mask_20 (ULONG)(~(~0<<(4)))*/

#define  MAC_GPIOR_MASK_20 (ULONG)(0xf)

/*#define MAC_GPIOR_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(4)))<<(20)))*/

#define MAC_GPIOR_RES_WR_MASK_20 (ULONG)(0xff0fffff)

/*#define  MAC_GPIOR_Mask_12 (ULONG)(~(~0<<(4)))*/

#define  MAC_GPIOR_MASK_12 (ULONG)(0xf)

/*#define MAC_GPIOR_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(4)))<<(12)))*/

#define MAC_GPIOR_RES_WR_MASK_12 (ULONG)(0xffff0fff)

/*#define  MAC_GPIOR_Mask_4 (ULONG)(~(~0<<(4)))*/

#define  MAC_GPIOR_MASK_4 (ULONG)(0xf)

/*#define MAC_GPIOR_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(4)))<<(4)))*/

#define MAC_GPIOR_RES_WR_MASK_4 (ULONG)(0xffffff0f)

/*#define MAC_GPIOR_GPIT_Mask (ULONG)(~(~0<<(4)))*/

#define MAC_GPIOR_GPIT_MASK (ULONG)(0xf)

/*#define MAC_GPIOR_GPIT_Wr_Mask (ULONG)(~((~(~0 << (4))) << (24)))*/

#define MAC_GPIOR_GPIT_WR_MASK (ULONG)(0xf0ffffff)

#define MAC_GPIOR_GPIT_UDFWR(data) do {\
		ULONG v;\
		MAC_GPIOR_RGRD(v);\
		v = (v & (MAC_GPIOR_RES_WR_MASK_28)) | (((0) & (MAC_GPIOR_MASK_28)) << 28);\
		v = (v & (MAC_GPIOR_RES_WR_MASK_20)) | (((0) & (MAC_GPIOR_MASK_20)) << 20);\
		v = (v & (MAC_GPIOR_RES_WR_MASK_12)) | (((0) & (MAC_GPIOR_MASK_12)) << 12);\
		v = (v & (MAC_GPIOR_RES_WR_MASK_4)) | (((0) & (MAC_GPIOR_MASK_4)) << 4);\
		v = ((v & MAC_GPIOR_GPIT_WR_MASK) | ((data & MAC_GPIOR_GPIT_MASK) << 24));\
		MAC_GPIOR_RGWR(v);\
} while (0)

#define MAC_GPIOR_GPIT_UDFRD(data) do {\
		MAC_GPIOR_RGRD(data);\
		data = ((data >> 24) & MAC_GPIOR_GPIT_MASK);\
} while (0)

/*#define MAC_GPIOR_GPIE_Mask (ULONG)(~(~0<<(4)))*/

#define MAC_GPIOR_GPIE_MASK (ULONG)(0xf)

/*#define MAC_GPIOR_GPIE_Wr_Mask (ULONG)(~((~(~0 << (4))) << (16)))*/

#define MAC_GPIOR_GPIE_WR_MASK (ULONG)(0xfff0ffff)

#define MAC_GPIOR_GPIE_UDFWR(data) do {\
		ULONG v;\
		MAC_GPIOR_RGRD(v);\
		v = (v & (MAC_GPIOR_RES_WR_MASK_28)) | (((0) & (MAC_GPIOR_MASK_28)) << 28);\
		v = (v & (MAC_GPIOR_RES_WR_MASK_20)) | (((0) & (MAC_GPIOR_MASK_20)) << 20);\
		v = (v & (MAC_GPIOR_RES_WR_MASK_12)) | (((0) & (MAC_GPIOR_MASK_12)) << 12);\
		v = (v & (MAC_GPIOR_RES_WR_MASK_4)) | (((0) & (MAC_GPIOR_MASK_4)) << 4);\
		v = ((v & MAC_GPIOR_GPIE_WR_MASK) | ((data & MAC_GPIOR_GPIE_MASK) << 16));\
		MAC_GPIOR_RGWR(v);\
} while (0)

#define MAC_GPIOR_GPIE_UDFRD(data) do {\
		MAC_GPIOR_RGRD(data);\
		data = ((data >> 16) & MAC_GPIOR_GPIE_MASK);\
} while (0)

/*#define MAC_GPIOR_GPO_Mask (ULONG)(~(~0<<(4)))*/

#define MAC_GPIOR_GPO_MASK (ULONG)(0xf)

/*#define MAC_GPIOR_GPO_Wr_Mask (ULONG)(~((~(~0 << (4))) << (8)))*/

#define MAC_GPIOR_GPO_WR_MASK (ULONG)(0xfffff0ff)

#define MAC_GPIOR_GPO_UDFWR(data) do {\
		ULONG v;\
		MAC_GPIOR_RGRD(v);\
		v = (v & (MAC_GPIOR_RES_WR_MASK_28)) | (((0) & (MAC_GPIOR_MASK_28)) << 28);\
		v = (v & (MAC_GPIOR_RES_WR_MASK_20)) | (((0) & (MAC_GPIOR_MASK_20)) << 20);\
		v = (v & (MAC_GPIOR_RES_WR_MASK_12)) | (((0) & (MAC_GPIOR_MASK_12)) << 12);\
		v = (v & (MAC_GPIOR_RES_WR_MASK_4)) | (((0) & (MAC_GPIOR_MASK_4)) << 4);\
		v = ((v & MAC_GPIOR_GPO_WR_MASK) | ((data & MAC_GPIOR_GPO_MASK) << 8));\
		MAC_GPIOR_RGWR(v);\
} while (0)

#define MAC_GPIOR_GPO_UDFRD(data) do {\
		MAC_GPIOR_RGRD(data);\
		data = ((data >> 8) & MAC_GPIOR_GPO_MASK);\
} while (0)

/*#define MAC_GPIOR_GPIS_Mask (ULONG)(~(~0<<(4)))*/

#define MAC_GPIOR_GPIS_MASK (ULONG)(0xf)

/*#define MAC_GPIOR_GPIS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (0)))*/

#define MAC_GPIOR_GPIS_WR_MASK (ULONG)(0xfffffff0)

#define MAC_GPIOR_GPIS_UDFWR(data) do {\
		ULONG v;\
		MAC_GPIOR_RGRD(v);\
		v = (v & (MAC_GPIOR_RES_WR_MASK_28)) | (((0) & (MAC_GPIOR_MASK_28)) << 28);\
		v = (v & (MAC_GPIOR_RES_WR_MASK_20)) | (((0) & (MAC_GPIOR_MASK_20)) << 20);\
		v = (v & (MAC_GPIOR_RES_WR_MASK_12)) | (((0) & (MAC_GPIOR_MASK_12)) << 12);\
		v = (v & (MAC_GPIOR_RES_WR_MASK_4)) | (((0) & (MAC_GPIOR_MASK_4)) << 4);\
		v = ((v & MAC_GPIOR_GPIS_WR_MASK) | ((data & MAC_GPIOR_GPIS_MASK) << 0));\
		MAC_GPIOR_RGWR(v);\
} while (0)

#define MAC_GPIOR_GPIS_UDFRD(data) do {\
		MAC_GPIOR_RGRD(data);\
		data = ((data >> 0) & MAC_GPIOR_GPIS_MASK);\
} while (0)

#define MAC_GMIIDR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x204))

#define MAC_GMIIDR_RGWR(data) do {\
		iowrite32(data, (void *)MAC_GMIIDR_RGOFFADDR);\
} while (0)

#define MAC_GMIIDR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_GMIIDR_RGOFFADDR);\
} while (0)

/*#define MAC_GMIIDR_RA_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_GMIIDR_RA_MASK (ULONG)(0xffff)

/*#define MAC_GMIIDR_RA_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_GMIIDR_RA_WR_MASK (ULONG)(0xffff)

#define MAC_GMIIDR_RA_UDFWR(data) do {\
		ULONG v;\
		MAC_GMIIDR_RGRD(v);\
		v = ((v & MAC_GMIIDR_RA_WR_MASK) | ((data & MAC_GMIIDR_RA_MASK) << 16));\
		MAC_GMIIDR_RGWR(v);\
} while (0)

#define MAC_GMIIDR_RA_UDFRD(data) do {\
		MAC_GMIIDR_RGRD(data);\
		data = ((data >> 16) & MAC_GMIIDR_RA_MASK);\
} while (0)

/*#define MAC_GMIIDR_GD_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_GMIIDR_GD_MASK (ULONG)(0xffff)

/*#define MAC_GMIIDR_GD_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_GMIIDR_GD_WR_MASK (ULONG)(0xffff0000)

#define MAC_GMIIDR_GD_UDFWR(data) do {\
		ULONG v;\
		MAC_GMIIDR_RGRD(v);\
		v = ((v & MAC_GMIIDR_GD_WR_MASK) | ((data & MAC_GMIIDR_GD_MASK) << 0));\
		MAC_GMIIDR_RGWR(v);\
} while (0)

#define MAC_GMIIDR_GD_UDFRD(data) do {\
		MAC_GMIIDR_RGRD(data);\
		data = ((data >> 0) & MAC_GMIIDR_GD_MASK);\
} while (0)

#define MAC_GMIIAR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x200))

#define MAC_GMIIAR_RGWR(data) do {\
		iowrite32(data, (void *)MAC_GMIIAR_RGOFFADDR);\
} while (0)

#define MAC_GMIIAR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_GMIIAR_RGOFFADDR);\
} while (0)

/*#define  MAC_GMIIAR_Mask_26 (ULONG)(~(~0<<(6)))*/

#define  MAC_GMIIAR_MASK_26 (ULONG)(0x3f)

/*#define MAC_GMIIAR_RES_Wr_Mask_26 (ULONG)(~((~(~0<<(6)))<<(26)))*/

#define MAC_GMIIAR_RES_WR_MASK_26 (ULONG)(0x3ffffff)

/*#define  MAC_GMIIAR_Mask_12 (ULONG)(~(~0<<(4)))*/

#define  MAC_GMIIAR_MASK_12 (ULONG)(0xf)

/*#define MAC_GMIIAR_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(4)))<<(12)))*/

#define MAC_GMIIAR_RES_WR_MASK_12 (ULONG)(0xffff0fff)

/*#define  MAC_GMIIAR_Mask_5 (ULONG)(~(~0<<(3)))*/

#define  MAC_GMIIAR_MASK_5 (ULONG)(0x7)

/*#define MAC_GMIIAR_RES_Wr_Mask_5 (ULONG)(~((~(~0<<(3)))<<(5)))*/

#define MAC_GMIIAR_RES_WR_MASK_5 (ULONG)(0xffffff1f)

/*#define MAC_GMIIAR_PA_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_GMIIAR_PA_MASK (ULONG)(0x1f)

/*#define MAC_GMIIAR_PA_Wr_Mask (ULONG)(~((~(~0 << (5))) << (21)))*/

#define MAC_GMIIAR_PA_WR_MASK (ULONG)(0xfc1fffff)

#define MAC_GMIIAR_PA_UDFWR(data) do {\
		ULONG v;\
		MAC_GMIIAR_RGRD(v);\
		v = (v & (MAC_GMIIAR_RES_WR_MASK_26)) | (((0) & (MAC_GMIIAR_MASK_26)) << 26);\
		v = (v & (MAC_GMIIAR_RES_WR_MASK_12)) | (((0) & (MAC_GMIIAR_MASK_12)) << 12);\
		v = (v & (MAC_GMIIAR_RES_WR_MASK_5)) | (((0) & (MAC_GMIIAR_MASK_5)) << 5);\
		v = ((v & MAC_GMIIAR_PA_WR_MASK) | ((data & MAC_GMIIAR_PA_MASK) << 21));\
		MAC_GMIIAR_RGWR(v);\
} while (0)

#define MAC_GMIIAR_PA_UDFRD(data) do {\
		MAC_GMIIAR_RGRD(data);\
		data = ((data >> 21) & MAC_GMIIAR_PA_MASK);\
} while (0)

/*#define MAC_GMIIAR_GR_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_GMIIAR_GR_MASK (ULONG)(0x1f)

/*#define MAC_GMIIAR_GR_Wr_Mask (ULONG)(~((~(~0 << (5))) << (16)))*/

#define MAC_GMIIAR_GR_WR_MASK (ULONG)(0xffe0ffff)

#define MAC_GMIIAR_GR_UDFWR(data) do {\
		ULONG v;\
		MAC_GMIIAR_RGRD(v);\
		v = (v & (MAC_GMIIAR_RES_WR_MASK_26)) | (((0) & (MAC_GMIIAR_MASK_26)) << 26);\
		v = (v & (MAC_GMIIAR_RES_WR_MASK_12)) | (((0) & (MAC_GMIIAR_MASK_12)) << 12);\
		v = (v & (MAC_GMIIAR_RES_WR_MASK_5)) | (((0) & (MAC_GMIIAR_MASK_5)) << 5);\
		v = ((v & MAC_GMIIAR_GR_WR_MASK) | ((data & MAC_GMIIAR_GR_MASK) << 16));\
		MAC_GMIIAR_RGWR(v);\
} while (0)

#define MAC_GMIIAR_GR_UDFRD(data) do {\
		MAC_GMIIAR_RGRD(data);\
		data = ((data >> 16) & MAC_GMIIAR_GR_MASK);\
} while (0)

/*#define MAC_GMIIAR_CR_Mask (ULONG)(~(~0<<(4)))*/

#define MAC_GMIIAR_CR_MASK (ULONG)(0xf)

/*#define MAC_GMIIAR_CR_Wr_Mask (ULONG)(~((~(~0 << (4))) << (8)))*/

#define MAC_GMIIAR_CR_WR_MASK (ULONG)(0xfffff0ff)

#define MAC_GMIIAR_CR_UDFWR(data) do {\
		ULONG v;\
		MAC_GMIIAR_RGRD(v);\
		v = (v & (MAC_GMIIAR_RES_WR_MASK_26)) | (((0) & (MAC_GMIIAR_MASK_26)) << 26);\
		v = (v & (MAC_GMIIAR_RES_WR_MASK_12)) | (((0) & (MAC_GMIIAR_MASK_12)) << 12);\
		v = (v & (MAC_GMIIAR_RES_WR_MASK_5)) | (((0) & (MAC_GMIIAR_MASK_5)) << 5);\
		v = ((v & MAC_GMIIAR_CR_WR_MASK) | ((data & MAC_GMIIAR_CR_MASK) << 8));\
		MAC_GMIIAR_RGWR(v);\
} while (0)

#define MAC_GMIIAR_CR_UDFRD(data) do {\
		MAC_GMIIAR_RGRD(data);\
		data = ((data >> 8) & MAC_GMIIAR_CR_MASK);\
} while (0)

/*#define MAC_GMIIAR_SKAP_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_GMIIAR_SKAP_MASK (ULONG)(0x1)

/*#define MAC_GMIIAR_SKAP_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MAC_GMIIAR_SKAP_WR_MASK (ULONG)(0xffffffef)

#define MAC_GMIIAR_SKAP_UDFWR(data) do {\
		ULONG v;\
		MAC_GMIIAR_RGRD(v);\
		v = (v & (MAC_GMIIAR_RES_WR_MASK_26)) | (((0) & (MAC_GMIIAR_MASK_26)) << 26);\
		v = (v & (MAC_GMIIAR_RES_WR_MASK_12)) | (((0) & (MAC_GMIIAR_MASK_12)) << 12);\
		v = (v & (MAC_GMIIAR_RES_WR_MASK_5)) | (((0) & (MAC_GMIIAR_MASK_5)) << 5);\
		v = ((v & MAC_GMIIAR_SKAP_WR_MASK) | ((data & MAC_GMIIAR_SKAP_MASK) << 4));\
		MAC_GMIIAR_RGWR(v);\
} while (0)

#define MAC_GMIIAR_SKAP_UDFRD(data) do {\
		MAC_GMIIAR_RGRD(data);\
		data = ((data >> 4) & MAC_GMIIAR_SKAP_MASK);\
} while (0)

/*#define MAC_GMIIAR_GOC_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_GMIIAR_GOC_MASK (ULONG)(0x3)

/*#define MAC_GMIIAR_GOC_Wr_Mask (ULONG)(~((~(~0 << (2))) << (2)))*/

#define MAC_GMIIAR_GOC_WR_MASK (ULONG)(0xfffffff3)

#define MAC_GMIIAR_GOC_UDFWR(data) do {\
		ULONG v;\
		MAC_GMIIAR_RGRD(v);\
		v = (v & (MAC_GMIIAR_RES_WR_MASK_26)) | (((0) & (MAC_GMIIAR_MASK_26)) << 26);\
		v = (v & (MAC_GMIIAR_RES_WR_MASK_12)) | (((0) & (MAC_GMIIAR_MASK_12)) << 12);\
		v = (v & (MAC_GMIIAR_RES_WR_MASK_5)) | (((0) & (MAC_GMIIAR_MASK_5)) << 5);\
		v = ((v & MAC_GMIIAR_GOC_WR_MASK) | ((data & MAC_GMIIAR_GOC_MASK) << 2));\
		MAC_GMIIAR_RGWR(v);\
} while (0)

#define MAC_GMIIAR_GOC_UDFRD(data) do {\
		MAC_GMIIAR_RGRD(data);\
		data = ((data >> 2) & MAC_GMIIAR_GOC_MASK);\
} while (0)

/*#define MAC_GMIIAR_C45E_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_GMIIAR_C45E_MASK (ULONG)(0x1)

/*#define MAC_GMIIAR_C45E_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_GMIIAR_C45E_WR_MASK (ULONG)(0xfffffffd)

#define MAC_GMIIAR_C45E_UDFWR(data) do {\
		ULONG v;\
		MAC_GMIIAR_RGRD(v);\
		v = (v & (MAC_GMIIAR_RES_WR_MASK_26)) | (((0) & (MAC_GMIIAR_MASK_26)) << 26);\
		v = (v & (MAC_GMIIAR_RES_WR_MASK_12)) | (((0) & (MAC_GMIIAR_MASK_12)) << 12);\
		v = (v & (MAC_GMIIAR_RES_WR_MASK_5)) | (((0) & (MAC_GMIIAR_MASK_5)) << 5);\
		v = ((v & MAC_GMIIAR_C45E_WR_MASK) | ((data & MAC_GMIIAR_C45E_MASK) << 1));\
		MAC_GMIIAR_RGWR(v);\
} while (0)

#define MAC_GMIIAR_C45E_UDFRD(data) do {\
		MAC_GMIIAR_RGRD(data);\
		data = ((data >> 1) & MAC_GMIIAR_C45E_MASK);\
} while (0)

/*#define MAC_GMIIAR_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_GMIIAR_GB_MASK (ULONG)(0x1)

/*#define MAC_GMIIAR_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_GMIIAR_GB_WR_MASK (ULONG)(0xfffffffe)

#define MAC_GMIIAR_GB_UDFWR(data) do {\
		ULONG v;\
		MAC_GMIIAR_RGRD(v);\
		v = (v & (MAC_GMIIAR_RES_WR_MASK_26)) | (((0) & (MAC_GMIIAR_MASK_26)) << 26);\
		v = (v & (MAC_GMIIAR_RES_WR_MASK_12)) | (((0) & (MAC_GMIIAR_MASK_12)) << 12);\
		v = (v & (MAC_GMIIAR_RES_WR_MASK_5)) | (((0) & (MAC_GMIIAR_MASK_5)) << 5);\
		v = ((v & MAC_GMIIAR_GB_WR_MASK) | ((data & MAC_GMIIAR_GB_MASK) << 0));\
		MAC_GMIIAR_RGWR(v);\
} while (0)

#define MAC_GMIIAR_GB_UDFRD(data) do {\
		MAC_GMIIAR_RGRD(data);\
		data = ((data >> 0) & MAC_GMIIAR_GB_MASK);\
} while (0)

#define MAC_HFR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x124))

#define MAC_HFR2_RGRD(data) do {\
		(data) = ioread32((void *)MAC_HFR2_RGOFFADDR);\
} while (0)

/*#define MAC_HFR2_AUXSNAPNUM_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_HFR2_AUXSNAPNUM_MASK (ULONG)(0x7)

#define MAC_HFR2_AUXSNAPNUM_UDFRD(data) do {\
		MAC_HFR2_RGRD(data);\
		data = ((data >> 28) & MAC_HFR2_AUXSNAPNUM_MASK);\
} while (0)

/*#define MAC_HFR2_PPSOUTNUM_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_HFR2_PPSOUTNUM_MASK (ULONG)(0x7)

#define MAC_HFR2_PPSOUTNUM_UDFRD(data) do {\
		MAC_HFR2_RGRD(data);\
		data = ((data >> 24) & MAC_HFR2_PPSOUTNUM_MASK);\
} while (0)

/*#define MAC_HFR2_TXCHCNT_Mask (ULONG)(~(~0<<(4)))*/

#define MAC_HFR2_TXCHCNT_MASK (ULONG)(0xf)

#define MAC_HFR2_TXCHCNT_UDFRD(data) do {\
		MAC_HFR2_RGRD(data);\
		data = ((data >> 18) & MAC_HFR2_TXCHCNT_MASK);\
} while (0)

/*#define MAC_HFR2_RXCHCNT_Mask (ULONG)(~(~0<<(4)))*/

#define MAC_HFR2_RXCHCNT_MASK (ULONG)(0xf)

#define MAC_HFR2_RXCHCNT_UDFRD(data) do {\
		MAC_HFR2_RGRD(data);\
		data = ((data >> 12) & MAC_HFR2_RXCHCNT_MASK);\
} while (0)

/*#define MAC_HFR2_TXQCNT_Mask (ULONG)(~(~0<<(4)))*/

#define MAC_HFR2_TXQCNT_MASK (ULONG)(0xf)

#define MAC_HFR2_TXQCNT_UDFRD(data) do {\
		MAC_HFR2_RGRD(data);\
		data = ((data >> 6) & MAC_HFR2_TXQCNT_MASK);\
} while (0)

/*#define MAC_HFR2_RXQCNT_Mask (ULONG)(~(~0<<(4)))*/

#define MAC_HFR2_RXQCNT_MASK (ULONG)(0xf)

#define MAC_HFR2_RXQCNT_UDFRD(data) do {\
		MAC_HFR2_RGRD(data);\
		data = ((data >> 0) & MAC_HFR2_RXQCNT_MASK);\
} while (0)

#define MAC_HFR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x120))

#define MAC_HFR1_RGRD(data) do {\
		(data) = ioread32((void *)MAC_HFR1_RGOFFADDR);\
} while (0)

/*#define MAC_HFR1_L3L4FILTERNUM_Mask (ULONG)(~(~0<<(4)))*/

#define MAC_HFR1_L3L4FILTERNUM_MASK (ULONG)(0xf)

#define MAC_HFR1_L3L4FILTERNUM_UDFRD(data) do {\
		MAC_HFR1_RGRD(data);\
		data = ((data >> 27) & MAC_HFR1_L3L4FILTERNUM_MASK);\
} while (0)

/*#define MAC_HFR1_HASHTBLSZ_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_HFR1_HASHTBLSZ_MASK (ULONG)(0x3)

#define MAC_HFR1_HASHTBLSZ_UDFRD(data) do {\
		MAC_HFR1_RGRD(data);\
		data = ((data >> 24) & MAC_HFR1_HASHTBLSZ_MASK);\
} while (0)

/*#define MAC_HFR1_LPMODEEN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR1_LPMODEEN_MASK (ULONG)(0x1)

#define MAC_HFR1_LPMODEEN_UDFRD(data) do {\
		MAC_HFR1_RGRD(data);\
		data = ((data >> 23) & MAC_HFR1_LPMODEEN_MASK);\
} while (0)

/*#define MAC_HFR1_AVSEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR1_AVSEL_MASK (ULONG)(0x1)

#define MAC_HFR1_AVSEL_UDFRD(data) do {\
		MAC_HFR1_RGRD(data);\
		data = ((data >> 20) & MAC_HFR1_AVSEL_MASK);\
} while (0)

/*#define MAC_HFR1_DMADEBUGEN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR1_DMADEBUGEN_MASK (ULONG)(0x1)

#define MAC_HFR1_DMADEBUGEN_UDFRD(data) do {\
		MAC_HFR1_RGRD(data);\
		data = ((data >> 19) & MAC_HFR1_DMADEBUGEN_MASK);\
} while (0)

/*#define MAC_HFR1_TSOEN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR1_TSOEN_MASK (ULONG)(0x1)

#define MAC_HFR1_TSOEN_UDFRD(data) do {\
		MAC_HFR1_RGRD(data);\
		data = ((data >> 18) & MAC_HFR1_TSOEN_MASK);\
} while (0)

/*#define MAC_HFR1_SPHEN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR1_SPHEN_MASK (ULONG)(0x1)

#define MAC_HFR1_SPHEN_UDFRD(data) do {\
		MAC_HFR1_RGRD(data);\
		data = ((data >> 17) & MAC_HFR1_SPHEN_MASK);\
} while (0)

/*#define MAC_HFR1_DCBEN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR1_DCBEN_MASK (ULONG)(0x1)

#define MAC_HFR1_DCBEN_UDFRD(data) do {\
		MAC_HFR1_RGRD(data);\
		data = ((data >> 16) & MAC_HFR1_DCBEN_MASK);\
} while (0)

/*#define MAC_HFR1_ADVTHWORD_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR1_ADVTHWORD_MASK (ULONG)(0x1)

#define MAC_HFR1_ADVTHWORD_UDFRD(data) do {\
		MAC_HFR1_RGRD(data);\
		data = ((data >> 13) & MAC_HFR1_ADVTHWORD_MASK);\
} while (0)

/*#define MAC_HFR1_TXFIFOSIZE_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_HFR1_TXFIFOSIZE_MASK (ULONG)(0x1f)

#define MAC_HFR1_TXFIFOSIZE_UDFRD(data) do {\
		MAC_HFR1_RGRD(data);\
		data = ((data >> 6) & MAC_HFR1_TXFIFOSIZE_MASK);\
} while (0)

/*#define MAC_HFR1_RXFIFOSIZE_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_HFR1_RXFIFOSIZE_MASK (ULONG)(0x1f)

#define MAC_HFR1_RXFIFOSIZE_UDFRD(data) do {\
		MAC_HFR1_RGRD(data);\
		data = ((data >> 0) & MAC_HFR1_RXFIFOSIZE_MASK);\
} while (0)

#define MAC_HFR0_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x11c))

#define MAC_HFR0_RGRD(data) do {\
		(data) = ioread32((void *)MAC_HFR0_RGOFFADDR);\
} while (0)

/*#define MAC_HFR0_ACTPHYSEL_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_HFR0_ACTPHYSEL_MASK (ULONG)(0x7)

#define MAC_HFR0_ACTPHYSEL_UDFRD(data) do {\
		MAC_HFR0_RGRD(data);\
		data = ((data >> 28) & MAC_HFR0_ACTPHYSEL_MASK);\
} while (0)

/*#define MAC_HFR0_SAVLANINS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_SAVLANINS_MASK (ULONG)(0x0)

#define MAC_HFR0_SAVLANINS_UDFRD(data) do {\
		MAC_HFR0_RGRD(data);\
		data = ((data >> 27) & MAC_HFR0_SAVLANINS_MASK);\
} while (0)

/*#define MAC_HFR0_TSINTSEL_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_HFR0_TSINTSEL_MASK (ULONG)(0x3)

#define MAC_HFR0_TSINTSEL_UDFRD(data) do {\
		MAC_HFR0_RGRD(data);\
		data = ((data >> 25) & MAC_HFR0_TSINTSEL_MASK);\
} while (0)

/*#define MAC_HFR0_MACADR64SEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_MACADR64SEL_MASK (ULONG)(0x1)

#define MAC_HFR0_MACADR64SEL_UDFRD(data) do {\
		MAC_HFR0_RGRD(data);\
		data = ((data >> 24) & MAC_HFR0_MACADR64SEL_MASK);\
} while (0)

/*#define MAC_HFR0_MACADR32SEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_MACADR32SEL_MASK (ULONG)(0x1)

#define MAC_HFR0_MACADR32SEL_UDFRD(data) do {\
		MAC_HFR0_RGRD(data);\
		data = ((data >> 23) & MAC_HFR0_MACADR32SEL_MASK);\
} while (0)

/*#define MAC_HFR0_ADDMACADRSEL_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_HFR0_ADDMACADRSEL_MASK (ULONG)(0x1f)

#define MAC_HFR0_ADDMACADRSEL_UDFRD(data) do {\
		MAC_HFR0_RGRD(data);\
		data = ((data >> 18) & MAC_HFR0_ADDMACADRSEL_MASK);\
} while (0)

/*#define MAC_HFR0_RXCOE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_RXCOE_MASK (ULONG)(0x1)

#define MAC_HFR0_RXCOE_UDFRD(data) do {\
		MAC_HFR0_RGRD(data);\
		data = ((data >> 16) & MAC_HFR0_RXCOE_MASK);\
} while (0)

/*#define MAC_HFR0_TXCOESEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_TXCOESEL_MASK (ULONG)(0x1)

#define MAC_HFR0_TXCOESEL_UDFRD(data) do {\
		MAC_HFR0_RGRD(data);\
		data = ((data >> 14) & MAC_HFR0_TXCOESEL_MASK);\
} while (0)

/*#define MAC_HFR0_EEESEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_EEESEL_MASK (ULONG)(0x1)

#define MAC_HFR0_EEESEL_UDFRD(data) do {\
		MAC_HFR0_RGRD(data);\
		data = ((data >> 13) & MAC_HFR0_EEESEL_MASK);\
} while (0)

/*#define MAC_HFR0_TSSSEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_TSSSEL_MASK (ULONG)(0x1)

#define MAC_HFR0_TSSSEL_UDFRD(data) do {\
		MAC_HFR0_RGRD(data);\
		data = ((data >> 12) & MAC_HFR0_TSSSEL_MASK);\
} while (0)

/*#define MAC_HFR0_ARPOFFLDEN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_ARPOFFLDEN_MASK (ULONG)(0x1)

#define MAC_HFR0_ARPOFFLDEN_UDFRD(data) do {\
		MAC_HFR0_RGRD(data);\
		data = ((data >> 9) & MAC_HFR0_ARPOFFLDEN_MASK);\
} while (0)

/*#define MAC_HFR0_MMCSEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_MMCSEL_MASK (ULONG)(0x1)

#define MAC_HFR0_MMCSEL_UDFRD(data) do {\
		MAC_HFR0_RGRD(data);\
		data = ((data >> 8) & MAC_HFR0_MMCSEL_MASK);\
} while (0)

/*#define MAC_HFR0_MGKSEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_MGKSEL_MASK (ULONG)(0x1)

#define MAC_HFR0_MGKSEL_UDFRD(data) do {\
		MAC_HFR0_RGRD(data);\
		data = ((data >> 7) & MAC_HFR0_MGKSEL_MASK);\
} while (0)

/*#define MAC_HFR0_RWKSEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_RWKSEL_MASK (ULONG)(0x1)

#define MAC_HFR0_RWKSEL_UDFRD(data) do {\
		MAC_HFR0_RGRD(data);\
		data = ((data >> 6) & MAC_HFR0_RWKSEL_MASK);\
} while (0)

/*#define MAC_HFR0_SMASEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_SMASEL_MASK (ULONG)(0x1)

#define MAC_HFR0_SMASEL_UDFRD(data) do {\
		MAC_HFR0_RGRD(data);\
		data = ((data >> 5) & MAC_HFR0_SMASEL_MASK);\
} while (0)

/*#define MAC_HFR0_VLANHASEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_VLANHASEL_MASK (ULONG)(0x1)

#define MAC_HFR0_VLANHASEL_UDFRD(data) do {\
		MAC_HFR0_RGRD(data);\
		data = ((data >> 4) & MAC_HFR0_VLANHASEL_MASK);\
} while (0)

/*#define MAC_HFR0_PCSSEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_PCSSEL_MASK (ULONG)(0x1)

#define MAC_HFR0_PCSSEL_UDFRD(data) do {\
		MAC_HFR0_RGRD(data);\
		data = ((data >> 3) & MAC_HFR0_PCSSEL_MASK);\
} while (0)

/*#define MAC_HFR0_HDSEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_HDSEL_MASK (ULONG)(0x1)

#define MAC_HFR0_HDSEL_UDFRD(data) do {\
		MAC_HFR0_RGRD(data);\
		data = ((data >> 2) & MAC_HFR0_HDSEL_MASK);\
} while (0)

/*#define MAC_HFR0_GMIISEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_GMIISEL_MASK (ULONG)(0x1)

#define MAC_HFR0_GMIISEL_UDFRD(data) do {\
		MAC_HFR0_RGRD(data);\
		data = ((data >> 1) & MAC_HFR0_GMIISEL_MASK);\
} while (0)

/*#define MAC_HFR0_MIISEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_MIISEL_MASK (ULONG)(0x1)

#define MAC_HFR0_MIISEL_UDFRD(data) do {\
		MAC_HFR0_RGRD(data);\
		data = ((data >> 0) & MAC_HFR0_MIISEL_MASK);\
} while (0)

#define MAC_MDR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x114))

#define MAC_MDR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_MDR_RGOFFADDR);\
} while (0)

/*#define MAC_MDR_TFCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_MDR_TFCSTS_MASK (ULONG)(0x3)

#define MAC_MDR_TFCSTS_UDFRD(data) do {\
		MAC_MDR_RGRD(data);\
		data = ((data >> 17) & MAC_MDR_TFCSTS_MASK);\
} while (0)

/*#define MAC_MDR_TPESTS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_MDR_TPESTS_MASK (ULONG)(0x1)

#define MAC_MDR_TPESTS_UDFRD(data) do {\
		MAC_MDR_RGRD(data);\
		data = ((data >> 16) & MAC_MDR_TPESTS_MASK);\
} while (0)

/*#define MAC_MDR_RFCFCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_MDR_RFCFCSTS_MASK (ULONG)(0x3)

#define MAC_MDR_RFCFCSTS_UDFRD(data) do {\
		MAC_MDR_RGRD(data);\
		data = ((data >> 1) & MAC_MDR_RFCFCSTS_MASK);\
} while (0)

/*#define MAC_MDR_RPESTS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_MDR_RPESTS_MASK (ULONG)(0x1)

#define MAC_MDR_RPESTS_UDFRD(data) do {\
		MAC_MDR_RGRD(data);\
		data = ((data >> 0) & MAC_MDR_RPESTS_MASK);\
} while (0)

#define MAC_VR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x110))

#define MAC_VR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_VR_RGOFFADDR);\
} while (0)

/*#define MAC_VR_USERVER_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_VR_USERVER_MASK (ULONG)(0xff)

#define MAC_VR_USERVER_UDFRD(data) do {\
		MAC_VR_RGRD(data);\
		data = ((data >> 8) & MAC_VR_USERVER_MASK);\
} while (0)

/*#define MAC_VR_SNPSVER_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_VR_SNPSVER_MASK (ULONG)(0xff)

#define MAC_VR_SNPSVER_UDFRD(data) do {\
		MAC_VR_RGRD(data);\
		data = ((data >> 0) & MAC_VR_SNPSVER_MASK);\
} while (0)

#define MAC_HTR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x2c))

#define MAC_HTR7_RGWR(data) do {\
		iowrite32(data, (void *)MAC_HTR7_RGOFFADDR);\
} while (0)

#define MAC_HTR7_RGRD(data) do {\
		(data) = ioread32((void *)MAC_HTR7_RGOFFADDR);\
} while (0)

#define MAC_HTR7_HT_UDFWR(data) do {\
		MAC_HTR7_RGWR(data);\
} while (0)

#define MAC_HTR7_HT_UDFRD(data) do {\
		MAC_HTR7_RGRD(data);\
} while (0)

#define MAC_HTR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x28))

#define MAC_HTR6_RGWR(data) do {\
		iowrite32(data, (void *)MAC_HTR6_RGOFFADDR);\
} while (0)

#define MAC_HTR6_RGRD(data) do {\
		(data) = ioread32((void *)MAC_HTR6_RGOFFADDR);\
} while (0)

#define MAC_HTR6_HT_UDFWR(data) do {\
		MAC_HTR6_RGWR(data);\
} while (0)

#define MAC_HTR6_HT_UDFRD(data) do {\
		MAC_HTR6_RGRD(data);\
} while (0)

#define MAC_HTR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x24))

#define MAC_HTR5_RGWR(data) do {\
		iowrite32(data, (void *)MAC_HTR5_RGOFFADDR);\
} while (0)

#define MAC_HTR5_RGRD(data) do {\
		(data) = ioread32((void *)MAC_HTR5_RGOFFADDR);\
} while (0)

#define MAC_HTR5_HT_UDFWR(data) do {\
		MAC_HTR5_RGWR(data);\
} while (0)

#define MAC_HTR5_HT_UDFRD(data) do {\
		MAC_HTR5_RGRD(data);\
} while (0)

#define MAC_HTR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x20))

#define MAC_HTR4_RGWR(data) do {\
		iowrite32(data, (void *)MAC_HTR4_RGOFFADDR);\
} while (0)

#define MAC_HTR4_RGRD(data) do {\
		(data) = ioread32((void *)MAC_HTR4_RGOFFADDR);\
} while (0)

#define MAC_HTR4_HT_UDFWR(data) do {\
		MAC_HTR4_RGWR(data);\
} while (0)

#define MAC_HTR4_HT_UDFRD(data) do {\
		MAC_HTR4_RGRD(data);\
} while (0)

#define MAC_HTR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1c))

#define MAC_HTR3_RGWR(data) do {\
		iowrite32(data, (void *)MAC_HTR3_RGOFFADDR);\
} while (0)

#define MAC_HTR3_RGRD(data) do {\
		(data) = ioread32((void *)MAC_HTR3_RGOFFADDR);\
} while (0)

#define MAC_HTR3_HT_UDFWR(data) do {\
		MAC_HTR3_RGWR(data);\
} while (0)

#define MAC_HTR3_HT_UDFRD(data) do {\
		MAC_HTR3_RGRD(data);\
} while (0)

#define MAC_HTR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x18))

#define MAC_HTR2_RGWR(data) do {\
		iowrite32(data, (void *)MAC_HTR2_RGOFFADDR);\
} while (0)

#define MAC_HTR2_RGRD(data) do {\
		(data) = ioread32((void *)MAC_HTR2_RGOFFADDR);\
} while (0)

#define MAC_HTR2_HT_UDFWR(data) do {\
		MAC_HTR2_RGWR(data);\
} while (0)

#define MAC_HTR2_HT_UDFRD(data) do {\
		MAC_HTR2_RGRD(data);\
} while (0)

#define MAC_HTR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x14))

#define MAC_HTR1_RGWR(data) do {\
		iowrite32(data, (void *)MAC_HTR1_RGOFFADDR);\
} while (0)

#define MAC_HTR1_RGRD(data) do {\
		(data) = ioread32((void *)MAC_HTR1_RGOFFADDR);\
} while (0)

#define MAC_HTR1_HT_UDFWR(data) do {\
		MAC_HTR1_RGWR(data);\
} while (0)

#define MAC_HTR1_HT_UDFRD(data) do {\
		MAC_HTR1_RGRD(data);\
} while (0)

#define MAC_HTR0_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x10))

#define MAC_HTR0_RGWR(data) do {\
		iowrite32(data, (void *)MAC_HTR0_RGOFFADDR);\
} while (0)

#define MAC_HTR0_RGRD(data) do {\
		(data) = ioread32((void *)MAC_HTR0_RGOFFADDR);\
} while (0)

#define MAC_HTR0_HT_UDFWR(data) do {\
		MAC_HTR0_RGWR(data);\
} while (0)

#define MAC_HTR0_HT_UDFRD(data) do {\
		MAC_HTR0_RGRD(data);\
} while (0)

#define DMA_RIWTR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x14b8))

#define DMA_RIWTR7_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RIWTR7_RGOFFADDR);\
} while (0)

#define DMA_RIWTR7_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RIWTR7_RGOFFADDR);\
} while (0)

/*#define  DMA_RIWTR7_Mask_8 (ULONG)(~(~0<<(24)))*/

#define  DMA_RIWTR7_MASK_8 (ULONG)(0xffffff)

/*#define DMA_RIWTR7_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(24)))<<(8)))*/

#define DMA_RIWTR7_RES_WR_MASK_8 (ULONG)(0xff)

/*#define DMA_RIWTR7_RWT_Mask (ULONG)(~(~0<<(8)))*/

#define DMA_RIWTR7_RWT_MASK (ULONG)(0xff)

/*#define DMA_RIWTR7_RWT_Wr_Mask (ULONG)(~((~(~0 << (8))) << (0)))*/

#define DMA_RIWTR7_RWT_WR_MASK (ULONG)(0xffffff00)

#define DMA_RIWTR7_RWT_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RIWTR7_RES_WR_MASK_8)) | (((0) & (DMA_RIWTR7_MASK_8)) << 8);\
		(v) = ((v & DMA_RIWTR7_RWT_WR_MASK) | ((data & DMA_RIWTR7_RWT_MASK) << 0));\
		DMA_RIWTR7_RGWR(v);\
} while (0)

#define DMA_RIWTR7_RWT_UDFRD(data) do {\
		DMA_RIWTR7_RGRD(data);\
		data = ((data >> 0) & DMA_RIWTR7_RWT_MASK);\
} while (0)

#define DMA_RIWTR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1438))

#define DMA_RIWTR6_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RIWTR6_RGOFFADDR);\
} while (0)

#define DMA_RIWTR6_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RIWTR6_RGOFFADDR);\
} while (0)

/*#define  DMA_RIWTR6_Mask_8 (ULONG)(~(~0<<(24)))*/

#define  DMA_RIWTR6_MASK_8 (ULONG)(0xffffff)

/*#define DMA_RIWTR6_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(24)))<<(8)))*/

#define DMA_RIWTR6_RES_WR_MASK_8 (ULONG)(0xff)

/*#define DMA_RIWTR6_RWT_Mask (ULONG)(~(~0<<(8)))*/

#define DMA_RIWTR6_RWT_MASK (ULONG)(0xff)

/*#define DMA_RIWTR6_RWT_Wr_Mask (ULONG)(~((~(~0 << (8))) << (0)))*/

#define DMA_RIWTR6_RWT_WR_MASK (ULONG)(0xffffff00)

#define DMA_RIWTR6_RWT_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RIWTR6_RES_WR_MASK_8)) | (((0) & (DMA_RIWTR6_MASK_8)) << 8);\
		(v) = ((v & DMA_RIWTR6_RWT_WR_MASK) | ((data & DMA_RIWTR6_RWT_MASK) << 0));\
		DMA_RIWTR6_RGWR(v);\
} while (0)

#define DMA_RIWTR6_RWT_UDFRD(data) do {\
		DMA_RIWTR6_RGRD(data);\
		data = ((data >> 0) & DMA_RIWTR6_RWT_MASK);\
} while (0)

#define DMA_RIWTR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x13b8))

#define DMA_RIWTR5_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RIWTR5_RGOFFADDR);\
} while (0)

#define DMA_RIWTR5_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RIWTR5_RGOFFADDR);\
} while (0)

/*#define  DMA_RIWTR5_Mask_8 (ULONG)(~(~0<<(24)))*/

#define  DMA_RIWTR5_MASK_8 (ULONG)(0xffffff)

/*#define DMA_RIWTR5_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(24)))<<(8)))*/

#define DMA_RIWTR5_RES_WR_MASK_8 (ULONG)(0xff)

/*#define DMA_RIWTR5_RWT_Mask (ULONG)(~(~0<<(8)))*/

#define DMA_RIWTR5_RWT_MASK (ULONG)(0xff)

/*#define DMA_RIWTR5_RWT_Wr_Mask (ULONG)(~((~(~0 << (8))) << (0)))*/

#define DMA_RIWTR5_RWT_WR_MASK (ULONG)(0xffffff00)

#define DMA_RIWTR5_RWT_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RIWTR5_RES_WR_MASK_8)) | (((0) & (DMA_RIWTR5_MASK_8)) << 8);\
		(v) = ((v & DMA_RIWTR5_RWT_WR_MASK) | ((data & DMA_RIWTR5_RWT_MASK) << 0));\
		DMA_RIWTR5_RGWR(v);\
} while (0)

#define DMA_RIWTR5_RWT_UDFRD(data) do {\
		DMA_RIWTR5_RGRD(data);\
		data = ((data >> 0) & DMA_RIWTR5_RWT_MASK);\
} while (0)

#define DMA_RIWTR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1338))

#define DMA_RIWTR4_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RIWTR4_RGOFFADDR);\
} while (0)

#define DMA_RIWTR4_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RIWTR4_RGOFFADDR);\
} while (0)

/*#define  DMA_RIWTR4_Mask_8 (ULONG)(~(~0<<(24)))*/

#define  DMA_RIWTR4_MASK_8 (ULONG)(0xffffff)

/*#define DMA_RIWTR4_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(24)))<<(8)))*/

#define DMA_RIWTR4_RES_WR_MASK_8 (ULONG)(0xff)

/*#define DMA_RIWTR4_RWT_Mask (ULONG)(~(~0<<(8)))*/

#define DMA_RIWTR4_RWT_MASK (ULONG)(0xff)

/*#define DMA_RIWTR4_RWT_Wr_Mask (ULONG)(~((~(~0 << (8))) << (0)))*/

#define DMA_RIWTR4_RWT_WR_MASK (ULONG)(0xffffff00)

#define DMA_RIWTR4_RWT_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RIWTR4_RES_WR_MASK_8)) | (((0) & (DMA_RIWTR4_MASK_8)) << 8);\
		(v) = ((v & DMA_RIWTR4_RWT_WR_MASK) | ((data & DMA_RIWTR4_RWT_MASK) << 0));\
		DMA_RIWTR4_RGWR(v);\
} while (0)

#define DMA_RIWTR4_RWT_UDFRD(data) do {\
		DMA_RIWTR4_RGRD(data);\
		data = ((data >> 0) & DMA_RIWTR4_RWT_MASK);\
} while (0)

#define DMA_RIWTR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x12b8))

#define DMA_RIWTR3_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RIWTR3_RGOFFADDR);\
} while (0)

#define DMA_RIWTR3_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RIWTR3_RGOFFADDR);\
} while (0)

/*#define  DMA_RIWTR3_Mask_8 (ULONG)(~(~0<<(24)))*/

#define  DMA_RIWTR3_MASK_8 (ULONG)(0xffffff)

/*#define DMA_RIWTR3_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(24)))<<(8)))*/

#define DMA_RIWTR3_RES_WR_MASK_8 (ULONG)(0xff)

/*#define DMA_RIWTR3_RWT_Mask (ULONG)(~(~0<<(8)))*/

#define DMA_RIWTR3_RWT_MASK (ULONG)(0xff)

/*#define DMA_RIWTR3_RWT_Wr_Mask (ULONG)(~((~(~0 << (8))) << (0)))*/

#define DMA_RIWTR3_RWT_WR_MASK (ULONG)(0xffffff00)

#define DMA_RIWTR3_RWT_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RIWTR3_RES_WR_MASK_8)) | (((0) & (DMA_RIWTR3_MASK_8)) << 8);\
		(v) = ((v & DMA_RIWTR3_RWT_WR_MASK) | ((data & DMA_RIWTR3_RWT_MASK) << 0));\
		DMA_RIWTR3_RGWR(v);\
} while (0)

#define DMA_RIWTR3_RWT_UDFRD(data) do {\
		DMA_RIWTR3_RGRD(data);\
		data = ((data >> 0) & DMA_RIWTR3_RWT_MASK);\
} while (0)

#define DMA_RIWTR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1238))

#define DMA_RIWTR2_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RIWTR2_RGOFFADDR);\
} while (0)

#define DMA_RIWTR2_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RIWTR2_RGOFFADDR);\
} while (0)

/*#define  DMA_RIWTR2_Mask_8 (ULONG)(~(~0<<(24)))*/

#define  DMA_RIWTR2_MASK_8 (ULONG)(0xffffff)

/*#define DMA_RIWTR2_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(24)))<<(8)))*/

#define DMA_RIWTR2_RES_WR_MASK_8 (ULONG)(0xff)

/*#define DMA_RIWTR2_RWT_Mask (ULONG)(~(~0<<(8)))*/

#define DMA_RIWTR2_RWT_MASK (ULONG)(0xff)

/*#define DMA_RIWTR2_RWT_Wr_Mask (ULONG)(~((~(~0 << (8))) << (0)))*/

#define DMA_RIWTR2_RWT_WR_MASK (ULONG)(0xffffff00)

#define DMA_RIWTR2_RWT_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RIWTR2_RES_WR_MASK_8)) | (((0) & (DMA_RIWTR2_MASK_8)) << 8);\
		(v) = ((v & DMA_RIWTR2_RWT_WR_MASK) | ((data & DMA_RIWTR2_RWT_MASK) << 0));\
		DMA_RIWTR2_RGWR(v);\
} while (0)

#define DMA_RIWTR2_RWT_UDFRD(data) do {\
		DMA_RIWTR2_RGRD(data);\
		data = ((data >> 0) & DMA_RIWTR2_RWT_MASK);\
} while (0)

#define DMA_RIWTR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x11b8))

#define DMA_RIWTR1_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RIWTR1_RGOFFADDR);\
} while (0)

#define DMA_RIWTR1_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RIWTR1_RGOFFADDR);\
} while (0)

/*#define  DMA_RIWTR1_Mask_8 (ULONG)(~(~0<<(24)))*/

#define  DMA_RIWTR1_MASK_8 (ULONG)(0xffffff)

/*#define DMA_RIWTR1_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(24)))<<(8)))*/

#define DMA_RIWTR1_RES_WR_MASK_8 (ULONG)(0xff)

/*#define DMA_RIWTR1_RWT_Mask (ULONG)(~(~0<<(8)))*/

#define DMA_RIWTR1_RWT_MASK (ULONG)(0xff)

/*#define DMA_RIWTR1_RWT_Wr_Mask (ULONG)(~((~(~0 << (8))) << (0)))*/

#define DMA_RIWTR1_RWT_WR_MASK (ULONG)(0xffffff00)

#define DMA_RIWTR1_RWT_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RIWTR1_RES_WR_MASK_8)) | (((0) & (DMA_RIWTR1_MASK_8)) << 8);\
		(v) = ((v & DMA_RIWTR1_RWT_WR_MASK) | ((data & DMA_RIWTR1_RWT_MASK) << 0));\
		DMA_RIWTR1_RGWR(v);\
} while (0)

#define DMA_RIWTR1_RWT_UDFRD(data) do {\
		DMA_RIWTR1_RGRD(data);\
		data = ((data >> 0) & DMA_RIWTR1_RWT_MASK);\
} while (0)

#define DMA_RIWTR0_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1138))

#define DMA_RIWTR0_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RIWTR0_RGOFFADDR);\
} while (0)

#define DMA_RIWTR0_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RIWTR0_RGOFFADDR);\
} while (0)

/*#define  DMA_RIWTR0_Mask_8 (ULONG)(~(~0<<(24)))*/

#define  DMA_RIWTR0_MASK_8 (ULONG)(0xffffff)

/*#define DMA_RIWTR0_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(24)))<<(8)))*/

#define DMA_RIWTR0_RES_WR_MASK_8 (ULONG)(0xff)

/*#define DMA_RIWTR0_RWT_Mask (ULONG)(~(~0<<(8)))*/

#define DMA_RIWTR0_RWT_MASK (ULONG)(0xff)

/*#define DMA_RIWTR0_RWT_Wr_Mask (ULONG)(~((~(~0 << (8))) << (0)))*/

#define DMA_RIWTR0_RWT_WR_MASK (ULONG)(0xffffff00)

#define DMA_RIWTR0_RWT_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RIWTR0_RES_WR_MASK_8)) | (((0) & (DMA_RIWTR0_MASK_8)) << 8);\
		(v) = ((v & DMA_RIWTR0_RWT_WR_MASK) | ((data & DMA_RIWTR0_RWT_MASK) << 0));\
		DMA_RIWTR0_RGWR(v);\
} while (0)

#define DMA_RIWTR0_RWT_UDFRD(data) do {\
		DMA_RIWTR0_RGRD(data);\
		data = ((data >> 0) & DMA_RIWTR0_RWT_MASK);\
} while (0)

#define DMA_RDRLR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x14b0))

#define DMA_RDRLR7_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RDRLR7_RGOFFADDR);\
} while (0)

#define DMA_RDRLR7_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RDRLR7_RGOFFADDR);\
} while (0)

/*#define  DMA_RDRLR7_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_RDRLR7_MASK_10 (ULONG)(0x3fffff)

/*#define DMA_RDRLR7_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_RDRLR7_RES_WR_MASK_10 (ULONG)(0x3ff)

/*#define DMA_RDRLR7_RDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_RDRLR7_RDRL_MASK (ULONG)(0x3ff)

/*#define DMA_RDRLR7_RDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_RDRLR7_RDRL_WR_MASK (ULONG)(0xfffffc00)

#define DMA_RDRLR7_RDRL_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RDRLR7_RES_WR_MASK_10)) | (((0) & (DMA_RDRLR7_MASK_10)) << 10);\
		(v) = ((v & DMA_RDRLR7_RDRL_WR_MASK) | ((data & DMA_RDRLR7_RDRL_MASK) << 0));\
		DMA_RDRLR7_RGWR(v);\
} while (0)

#define DMA_RDRLR7_RDRL_UDFRD(data) do {\
		DMA_RDRLR7_RGRD(data);\
		data = ((data >> 0) & DMA_RDRLR7_RDRL_MASK);\
} while (0)

#define DMA_RDRLR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1430))

#define DMA_RDRLR6_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RDRLR6_RGOFFADDR);\
} while (0)

#define DMA_RDRLR6_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RDRLR6_RGOFFADDR);\
} while (0)

/*#define  DMA_RDRLR6_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_RDRLR6_MASK_10 (ULONG)(0x3fffff)

/*#define DMA_RDRLR6_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_RDRLR6_RES_WR_MASK_10 (ULONG)(0x3ff)

/*#define DMA_RDRLR6_RDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_RDRLR6_RDRL_MASK (ULONG)(0x3ff)

/*#define DMA_RDRLR6_RDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_RDRLR6_RDRL_WR_MASK (ULONG)(0xfffffc00)

#define DMA_RDRLR6_RDRL_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RDRLR6_RES_WR_MASK_10)) | (((0) & (DMA_RDRLR6_MASK_10)) << 10);\
		(v) = ((v & DMA_RDRLR6_RDRL_WR_MASK) | ((data & DMA_RDRLR6_RDRL_MASK) << 0));\
		DMA_RDRLR6_RGWR(v);\
} while (0)

#define DMA_RDRLR6_RDRL_UDFRD(data) do {\
		DMA_RDRLR6_RGRD(data);\
		data = ((data >> 0) & DMA_RDRLR6_RDRL_MASK);\
} while (0)

#define DMA_RDRLR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x13b0))

#define DMA_RDRLR5_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RDRLR5_RGOFFADDR);\
} while (0)

#define DMA_RDRLR5_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RDRLR5_RGOFFADDR);\
} while (0)

/*#define  DMA_RDRLR5_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_RDRLR5_MASK_10 (ULONG)(0x3fffff)

/*#define DMA_RDRLR5_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_RDRLR5_RES_WR_MASK_10 (ULONG)(0x3ff)

/*#define DMA_RDRLR5_RDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_RDRLR5_RDRL_MASK (ULONG)(0x3ff)

/*#define DMA_RDRLR5_RDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_RDRLR5_RDRL_WR_MASK (ULONG)(0xfffffc00)

#define DMA_RDRLR5_RDRL_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RDRLR5_RES_WR_MASK_10)) | (((0) & (DMA_RDRLR5_MASK_10)) << 10);\
		(v) = ((v & DMA_RDRLR5_RDRL_WR_MASK) | ((data & DMA_RDRLR5_RDRL_MASK) << 0));\
		DMA_RDRLR5_RGWR(v);\
} while (0)

#define DMA_RDRLR5_RDRL_UDFRD(data) do {\
		DMA_RDRLR5_RGRD(data);\
		data = ((data >> 0) & DMA_RDRLR5_RDRL_MASK);\
} while (0)

#define DMA_RDRLR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1330))

#define DMA_RDRLR4_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RDRLR4_RGOFFADDR);\
} while (0)

#define DMA_RDRLR4_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RDRLR4_RGOFFADDR);\
} while (0)

/*#define  DMA_RDRLR4_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_RDRLR4_MASK_10 (ULONG)(0x3fffff)

/*#define DMA_RDRLR4_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_RDRLR4_RES_WR_MASK_10 (ULONG)(0x3ff)

/*#define DMA_RDRLR4_RDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_RDRLR4_RDRL_MASK (ULONG)(0x3ff)

/*#define DMA_RDRLR4_RDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_RDRLR4_RDRL_WR_MASK (ULONG)(0xfffffc00)

#define DMA_RDRLR4_RDRL_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RDRLR4_RES_WR_MASK_10)) | (((0) & (DMA_RDRLR4_MASK_10)) << 10);\
		(v) = ((v & DMA_RDRLR4_RDRL_WR_MASK) | ((data & DMA_RDRLR4_RDRL_MASK) << 0));\
		DMA_RDRLR4_RGWR(v);\
} while (0)

#define DMA_RDRLR4_RDRL_UDFRD(data) do {\
		DMA_RDRLR4_RGRD(data);\
		data = ((data >> 0) & DMA_RDRLR4_RDRL_MASK);\
} while (0)

#define DMA_RDRLR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x12b0))

#define DMA_RDRLR3_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RDRLR3_RGOFFADDR);\
} while (0)

#define DMA_RDRLR3_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RDRLR3_RGOFFADDR);\
} while (0)

/*#define  DMA_RDRLR3_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_RDRLR3_MASK_10 (ULONG)(0x3fffff)

/*#define DMA_RDRLR3_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_RDRLR3_RES_WR_MASK_10 (ULONG)(0x3ff)

/*#define DMA_RDRLR3_RDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_RDRLR3_RDRL_MASK (ULONG)(0x3ff)

/*#define DMA_RDRLR3_RDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_RDRLR3_RDRL_WR_MASK (ULONG)(0xfffffc00)

#define DMA_RDRLR3_RDRL_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RDRLR3_RES_WR_MASK_10)) | (((0) & (DMA_RDRLR3_MASK_10)) << 10);\
		(v) = ((v & DMA_RDRLR3_RDRL_WR_MASK) | ((data & DMA_RDRLR3_RDRL_MASK) << 0));\
		DMA_RDRLR3_RGWR(v);\
} while (0)

#define DMA_RDRLR3_RDRL_UDFRD(data) do {\
		DMA_RDRLR3_RGRD(data);\
		data = ((data >> 0) & DMA_RDRLR3_RDRL_MASK);\
} while (0)

#define DMA_RDRLR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1230))

#define DMA_RDRLR2_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RDRLR2_RGOFFADDR);\
} while (0)

#define DMA_RDRLR2_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RDRLR2_RGOFFADDR);\
} while (0)

/*#define  DMA_RDRLR2_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_RDRLR2_MASK_10 (ULONG)(0x3fffff)

/*#define DMA_RDRLR2_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_RDRLR2_RES_WR_MASK_10 (ULONG)(0x3ff)

/*#define DMA_RDRLR2_RDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_RDRLR2_RDRL_MASK (ULONG)(0x3ff)

/*#define DMA_RDRLR2_RDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_RDRLR2_RDRL_WR_MASK (ULONG)(0xfffffc00)

#define DMA_RDRLR2_RDRL_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RDRLR2_RES_WR_MASK_10)) | (((0) & (DMA_RDRLR2_MASK_10)) << 10);\
		(v) = ((v & DMA_RDRLR2_RDRL_WR_MASK) | ((data & DMA_RDRLR2_RDRL_MASK) << 0));\
		DMA_RDRLR2_RGWR(v);\
} while (0)

#define DMA_RDRLR2_RDRL_UDFRD(data) do {\
		DMA_RDRLR2_RGRD(data);\
		data = ((data >> 0) & DMA_RDRLR2_RDRL_MASK);\
} while (0)

#define DMA_RDRLR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x11b0))

#define DMA_RDRLR1_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RDRLR1_RGOFFADDR);\
} while (0)

#define DMA_RDRLR1_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RDRLR1_RGOFFADDR);\
} while (0)

/*#define  DMA_RDRLR1_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_RDRLR1_MASK_10 (ULONG)(0x3fffff)

/*#define DMA_RDRLR1_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_RDRLR1_RES_WR_MASK_10 (ULONG)(0x3ff)

/*#define DMA_RDRLR1_RDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_RDRLR1_RDRL_MASK (ULONG)(0x3ff)

/*#define DMA_RDRLR1_RDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_RDRLR1_RDRL_WR_MASK (ULONG)(0xfffffc00)

#define DMA_RDRLR1_RDRL_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RDRLR1_RES_WR_MASK_10)) | (((0) & (DMA_RDRLR1_MASK_10)) << 10);\
		(v) = ((v & DMA_RDRLR1_RDRL_WR_MASK) | ((data & DMA_RDRLR1_RDRL_MASK) << 0));\
		DMA_RDRLR1_RGWR(v);\
} while (0)

#define DMA_RDRLR1_RDRL_UDFRD(data) do {\
		DMA_RDRLR1_RGRD(data);\
		data = ((data >> 0) & DMA_RDRLR1_RDRL_MASK);\
} while (0)

#define DMA_RDRLR0_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1130))

#define DMA_RDRLR0_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RDRLR0_RGOFFADDR);\
} while (0)

#define DMA_RDRLR0_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RDRLR0_RGOFFADDR);\
} while (0)

/*#define  DMA_RDRLR0_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_RDRLR0_MASK_10 (ULONG)(0x3fffff)

/*#define DMA_RDRLR0_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_RDRLR0_RES_WR_MASK_10 (ULONG)(0x3ff)

/*#define DMA_RDRLR0_RDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_RDRLR0_RDRL_MASK (ULONG)(0x3ff)

/*#define DMA_RDRLR0_RDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_RDRLR0_RDRL_WR_MASK (ULONG)(0xfffffc00)

#define DMA_RDRLR0_RDRL_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RDRLR0_RES_WR_MASK_10)) | (((0) & (DMA_RDRLR0_MASK_10)) << 10);\
		(v) = ((v & DMA_RDRLR0_RDRL_WR_MASK) | ((data & DMA_RDRLR0_RDRL_MASK) << 0));\
		DMA_RDRLR0_RGWR(v);\
} while (0)

#define DMA_RDRLR0_RDRL_UDFRD(data) do {\
		DMA_RDRLR0_RGRD(data);\
		data = ((data >> 0) & DMA_RDRLR0_RDRL_MASK);\
} while (0)

#define DMA_TDRLR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x14ac))

#define DMA_TDRLR7_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TDRLR7_RGOFFADDR);\
} while (0)

#define DMA_TDRLR7_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TDRLR7_RGOFFADDR);\
} while (0)

/*#define  DMA_TDRLR7_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_TDRLR7_MASK_10 (ULONG)(0x3fffff)

/*#define DMA_TDRLR7_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_TDRLR7_RES_WR_MASK_10 (ULONG)(0x3ff)

/*#define DMA_TDRLR7_TDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_TDRLR7_TDRL_MASK (ULONG)(0x3ff)

/*#define DMA_TDRLR7_TDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_TDRLR7_TDRL_WR_MASK (ULONG)(0xfffffc00)

#define DMA_TDRLR7_TDRL_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (DMA_TDRLR7_RES_WR_MASK_10)) | (((0) & (DMA_TDRLR7_MASK_10)) << 10);\
		(v) = ((v & DMA_TDRLR7_TDRL_WR_MASK) | ((data & DMA_TDRLR7_TDRL_MASK) << 0));\
		DMA_TDRLR7_RGWR(v);\
} while (0)

#define DMA_TDRLR7_TDRL_UDFRD(data) do {\
		DMA_TDRLR7_RGRD(data);\
		data = ((data >> 0) & DMA_TDRLR7_TDRL_MASK);\
} while (0)

#define DMA_TDRLR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x142c))

#define DMA_TDRLR6_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TDRLR6_RGOFFADDR);\
} while (0)

#define DMA_TDRLR6_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TDRLR6_RGOFFADDR);\
} while (0)

/*#define  DMA_TDRLR6_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_TDRLR6_MASK_10 (ULONG)(0x3fffff)

/*#define DMA_TDRLR6_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_TDRLR6_RES_WR_MASK_10 (ULONG)(0x3ff)

/*#define DMA_TDRLR6_TDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_TDRLR6_TDRL_MASK (ULONG)(0x3ff)

/*#define DMA_TDRLR6_TDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_TDRLR6_TDRL_WR_MASK (ULONG)(0xfffffc00)

#define DMA_TDRLR6_TDRL_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (DMA_TDRLR6_RES_WR_MASK_10)) | (((0) & (DMA_TDRLR6_MASK_10)) << 10);\
		(v) = ((v & DMA_TDRLR6_TDRL_WR_MASK) | ((data & DMA_TDRLR6_TDRL_MASK) << 0));\
		DMA_TDRLR6_RGWR(v);\
} while (0)

#define DMA_TDRLR6_TDRL_UDFRD(data) do {\
		DMA_TDRLR6_RGRD(data);\
		data = ((data >> 0) & DMA_TDRLR6_TDRL_MASK);\
} while (0)

#define DMA_TDRLR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x13ac))

#define DMA_TDRLR5_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TDRLR5_RGOFFADDR);\
} while (0)

#define DMA_TDRLR5_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TDRLR5_RGOFFADDR);\
} while (0)

/*#define  DMA_TDRLR5_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_TDRLR5_MASK_10 (ULONG)(0x3fffff)

/*#define DMA_TDRLR5_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_TDRLR5_RES_WR_MASK_10 (ULONG)(0x3ff)

/*#define DMA_TDRLR5_TDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_TDRLR5_TDRL_MASK (ULONG)(0x3ff)

/*#define DMA_TDRLR5_TDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_TDRLR5_TDRL_WR_MASK (ULONG)(0xfffffc00)

#define DMA_TDRLR5_TDRL_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (DMA_TDRLR5_RES_WR_MASK_10)) | (((0) & (DMA_TDRLR5_MASK_10)) << 10);\
		(v) = ((v & DMA_TDRLR5_TDRL_WR_MASK) | ((data & DMA_TDRLR5_TDRL_MASK) << 0));\
		DMA_TDRLR5_RGWR(v);\
} while (0)

#define DMA_TDRLR5_TDRL_UDFRD(data) do {\
		DMA_TDRLR5_RGRD(data);\
		data = ((data >> 0) & DMA_TDRLR5_TDRL_MASK);\
} while (0)

#define DMA_TDRLR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x132c))

#define DMA_TDRLR4_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TDRLR4_RGOFFADDR);\
} while (0)

#define DMA_TDRLR4_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TDRLR4_RGOFFADDR);\
} while (0)

/*#define  DMA_TDRLR4_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_TDRLR4_MASK_10 (ULONG)(0x3fffff)

/*#define DMA_TDRLR4_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_TDRLR4_RES_WR_MASK_10 (ULONG)(0x3ff)

/*#define DMA_TDRLR4_TDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_TDRLR4_TDRL_MASK (ULONG)(0x3ff)

/*#define DMA_TDRLR4_TDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_TDRLR4_TDRL_WR_MASK (ULONG)(0xfffffc00)

#define DMA_TDRLR4_TDRL_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (DMA_TDRLR4_RES_WR_MASK_10)) | (((0) & (DMA_TDRLR4_MASK_10)) << 10);\
		(v) = ((v & DMA_TDRLR4_TDRL_WR_MASK) | ((data & DMA_TDRLR4_TDRL_MASK) << 0));\
		DMA_TDRLR4_RGWR(v);\
} while (0)

#define DMA_TDRLR4_TDRL_UDFRD(data) do {\
		DMA_TDRLR4_RGRD(data);\
		data = ((data >> 0) & DMA_TDRLR4_TDRL_MASK);\
} while (0)

#define DMA_TDRLR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x12ac))

#define DMA_TDRLR3_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TDRLR3_RGOFFADDR);\
} while (0)

#define DMA_TDRLR3_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TDRLR3_RGOFFADDR);\
} while (0)

/*#define  DMA_TDRLR3_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_TDRLR3_MASK_10 (ULONG)(0x3fffff)

/*#define DMA_TDRLR3_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_TDRLR3_RES_WR_MASK_10 (ULONG)(0x3ff)

/*#define DMA_TDRLR3_TDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_TDRLR3_TDRL_MASK (ULONG)(0x3ff)

/*#define DMA_TDRLR3_TDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_TDRLR3_TDRL_WR_MASK (ULONG)(0xfffffc00)

#define DMA_TDRLR3_TDRL_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (DMA_TDRLR3_RES_WR_MASK_10)) | (((0) & (DMA_TDRLR3_MASK_10)) << 10);\
		(v) = ((v & DMA_TDRLR3_TDRL_WR_MASK) | ((data & DMA_TDRLR3_TDRL_MASK) << 0));\
		DMA_TDRLR3_RGWR(v);\
} while (0)

#define DMA_TDRLR3_TDRL_UDFRD(data) do {\
		DMA_TDRLR3_RGRD(data);\
		data = ((data >> 0) & DMA_TDRLR3_TDRL_MASK);\
} while (0)

#define DMA_TDRLR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x122c))

#define DMA_TDRLR2_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TDRLR2_RGOFFADDR);\
} while (0)

#define DMA_TDRLR2_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TDRLR2_RGOFFADDR);\
} while (0)

/*#define  DMA_TDRLR2_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_TDRLR2_MASK_10 (ULONG)(0x3fffff)

/*#define DMA_TDRLR2_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_TDRLR2_RES_WR_MASK_10 (ULONG)(0x3ff)

/*#define DMA_TDRLR2_TDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_TDRLR2_TDRL_MASK (ULONG)(0x3ff)

/*#define DMA_TDRLR2_TDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_TDRLR2_TDRL_WR_MASK (ULONG)(0xfffffc00)

#define DMA_TDRLR2_TDRL_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (DMA_TDRLR2_RES_WR_MASK_10)) | (((0) & (DMA_TDRLR2_MASK_10)) << 10);\
		(v) = ((v & DMA_TDRLR2_TDRL_WR_MASK) | ((data & DMA_TDRLR2_TDRL_MASK) << 0));\
		DMA_TDRLR2_RGWR(v);\
} while (0)

#define DMA_TDRLR2_TDRL_UDFRD(data) do {\
		DMA_TDRLR2_RGRD(data);\
		data = ((data >> 0) & DMA_TDRLR2_TDRL_MASK);\
} while (0)

#define DMA_TDRLR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x11ac))

#define DMA_TDRLR1_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TDRLR1_RGOFFADDR);\
} while (0)

#define DMA_TDRLR1_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TDRLR1_RGOFFADDR);\
} while (0)

/*#define  DMA_TDRLR1_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_TDRLR1_MASK_10 (ULONG)(0x3fffff)

/*#define DMA_TDRLR1_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_TDRLR1_RES_WR_MASK_10 (ULONG)(0x3ff)

/*#define DMA_TDRLR1_TDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_TDRLR1_TDRL_MASK (ULONG)(0x3ff)

/*#define DMA_TDRLR1_TDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_TDRLR1_TDRL_WR_MASK (ULONG)(0xfffffc00)

#define DMA_TDRLR1_TDRL_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (DMA_TDRLR1_RES_WR_MASK_10)) | (((0) & (DMA_TDRLR1_MASK_10)) << 10);\
		(v) = ((v & DMA_TDRLR1_TDRL_WR_MASK) | ((data & DMA_TDRLR1_TDRL_MASK) << 0));\
		DMA_TDRLR1_RGWR(v);\
} while (0)

#define DMA_TDRLR1_TDRL_UDFRD(data) do {\
		DMA_TDRLR1_RGRD(data);\
		data = ((data >> 0) & DMA_TDRLR1_TDRL_MASK);\
} while (0)

#define DMA_TDRLR0_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x112c))

#define DMA_TDRLR0_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TDRLR0_RGOFFADDR);\
} while (0)

#define DMA_TDRLR0_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TDRLR0_RGOFFADDR);\
} while (0)

/*#define  DMA_TDRLR0_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_TDRLR0_MASK_10 (ULONG)(0x3fffff)

/*#define DMA_TDRLR0_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_TDRLR0_RES_WR_MASK_10 (ULONG)(0x3ff)

/*#define DMA_TDRLR0_TDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_TDRLR0_TDRL_MASK (ULONG)(0x3ff)

/*#define DMA_TDRLR0_TDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_TDRLR0_TDRL_WR_MASK (ULONG)(0xfffffc00)

#define DMA_TDRLR0_TDRL_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (DMA_TDRLR0_RES_WR_MASK_10)) | (((0) & (DMA_TDRLR0_MASK_10)) << 10);\
		(v) = ((v & DMA_TDRLR0_TDRL_WR_MASK) | ((data & DMA_TDRLR0_TDRL_MASK) << 0));\
		DMA_TDRLR0_RGWR(v);\
} while (0)

#define DMA_TDRLR0_TDRL_UDFRD(data) do {\
		DMA_TDRLR0_RGRD(data);\
		data = ((data >> 0) & DMA_TDRLR0_TDRL_MASK);\
} while (0)

#define DMA_RDTP_RPDR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x14a8))

#define DMA_RDTP_RPDR7_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RDTP_RPDR7_RGOFFADDR);\
} while (0)

#define DMA_RDTP_RPDR7_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RDTP_RPDR7_RGOFFADDR);\
} while (0)

#define DMA_RDTP_RPDR7_RDT_UDFWR(data) do {\
		DMA_RDTP_RPDR7_RGWR(data);\
} while (0)

#define DMA_RDTP_RPDR7_RDT_UDFRD(data) do {\
		DMA_RDTP_RPDR7_RGRD(data);\
} while (0)

#define DMA_RDTP_RPDR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1428))

#define DMA_RDTP_RPDR6_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RDTP_RPDR6_RGOFFADDR);\
} while (0)

#define DMA_RDTP_RPDR6_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RDTP_RPDR6_RGOFFADDR);\
} while (0)

#define DMA_RDTP_RPDR6_RDT_UDFWR(data) do {\
		DMA_RDTP_RPDR6_RGWR(data);\
} while (0)

#define DMA_RDTP_RPDR6_RDT_UDFRD(data) do {\
		DMA_RDTP_RPDR6_RGRD(data);\
} while (0)

#define DMA_RDTP_RPDR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x13a8))

#define DMA_RDTP_RPDR5_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RDTP_RPDR5_RGOFFADDR);\
} while (0)

#define DMA_RDTP_RPDR5_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RDTP_RPDR5_RGOFFADDR);\
} while (0)

#define DMA_RDTP_RPDR5_RDT_UDFWR(data) do {\
		DMA_RDTP_RPDR5_RGWR(data);\
} while (0)

#define DMA_RDTP_RPDR5_RDT_UDFRD(data) do {\
		DMA_RDTP_RPDR5_RGRD(data);\
} while (0)

#define DMA_RDTP_RPDR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1328))

#define DMA_RDTP_RPDR4_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RDTP_RPDR4_RGOFFADDR);\
} while (0)

#define DMA_RDTP_RPDR4_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RDTP_RPDR4_RGOFFADDR);\
} while (0)

#define DMA_RDTP_RPDR4_RDT_UDFWR(data) do {\
		DMA_RDTP_RPDR4_RGWR(data);\
} while (0)

#define DMA_RDTP_RPDR4_RDT_UDFRD(data) do {\
		DMA_RDTP_RPDR4_RGRD(data);\
} while (0)

#define DMA_RDTP_RPDR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x12a8))

#define DMA_RDTP_RPDR3_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RDTP_RPDR3_RGOFFADDR);\
} while (0)

#define DMA_RDTP_RPDR3_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RDTP_RPDR3_RGOFFADDR);\
} while (0)

#define DMA_RDTP_RPDR3_RDT_UDFWR(data) do {\
		DMA_RDTP_RPDR3_RGWR(data);\
} while (0)

#define DMA_RDTP_RPDR3_RDT_UDFRD(data) do {\
		DMA_RDTP_RPDR3_RGRD(data);\
} while (0)

#define DMA_RDTP_RPDR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1228))

#define DMA_RDTP_RPDR2_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RDTP_RPDR2_RGOFFADDR);\
} while (0)

#define DMA_RDTP_RPDR2_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RDTP_RPDR2_RGOFFADDR);\
} while (0)

#define DMA_RDTP_RPDR2_RDT_UDFWR(data) do {\
		DMA_RDTP_RPDR2_RGWR(data);\
} while (0)

#define DMA_RDTP_RPDR2_RDT_UDFRD(data) do {\
		DMA_RDTP_RPDR2_RGRD(data);\
} while (0)

#define DMA_RDTP_RPDR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x11a8))

#define DMA_RDTP_RPDR1_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RDTP_RPDR1_RGOFFADDR);\
} while (0)

#define DMA_RDTP_RPDR1_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RDTP_RPDR1_RGOFFADDR);\
} while (0)

#define DMA_RDTP_RPDR1_RDT_UDFWR(data) do {\
		DMA_RDTP_RPDR1_RGWR(data);\
} while (0)

#define DMA_RDTP_RPDR1_RDT_UDFRD(data) do {\
		DMA_RDTP_RPDR1_RGRD(data);\
} while (0)

#define DMA_RDTP_RPDR0_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1128))

#define DMA_RDTP_RPDR0_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RDTP_RPDR0_RGOFFADDR);\
} while (0)

#define DMA_RDTP_RPDR0_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RDTP_RPDR0_RGOFFADDR);\
} while (0)

#define DMA_RDTP_RPDR0_RDT_UDFWR(data) do {\
		DMA_RDTP_RPDR0_RGWR(data);\
} while (0)

#define DMA_RDTP_RPDR0_RDT_UDFRD(data) do {\
		DMA_RDTP_RPDR0_RGRD(data);\
} while (0)

#define DMA_TDTP_TPDR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x14a0))

#define DMA_TDTP_TPDR7_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TDTP_TPDR7_RGOFFADDR);\
} while (0)

#define DMA_TDTP_TPDR7_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TDTP_TPDR7_RGOFFADDR);\
} while (0)

#define DMA_TDTP_TPDR7_TDT_UDFWR(data) do {\
		DMA_TDTP_TPDR7_RGWR(data);\
} while (0)

#define DMA_TDTP_TPDR7_TDT_UDFRD(data) do {\
		DMA_TDTP_TPDR7_RGRD(data);\
} while (0)

#define DMA_TDTP_TPDR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1420))

#define DMA_TDTP_TPDR6_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TDTP_TPDR6_RGOFFADDR);\
} while (0)

#define DMA_TDTP_TPDR6_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TDTP_TPDR6_RGOFFADDR);\
} while (0)

#define DMA_TDTP_TPDR6_TDT_UDFWR(data) do {\
		DMA_TDTP_TPDR6_RGWR(data);\
} while (0)

#define DMA_TDTP_TPDR6_TDT_UDFRD(data) do {\
		DMA_TDTP_TPDR6_RGRD(data);\
} while (0)

#define DMA_TDTP_TPDR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x13a0))

#define DMA_TDTP_TPDR5_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TDTP_TPDR5_RGOFFADDR);\
} while (0)

#define DMA_TDTP_TPDR5_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TDTP_TPDR5_RGOFFADDR);\
} while (0)

#define DMA_TDTP_TPDR5_TDT_UDFWR(data) do {\
		DMA_TDTP_TPDR5_RGWR(data);\
} while (0)

#define DMA_TDTP_TPDR5_TDT_UDFRD(data) do {\
		DMA_TDTP_TPDR5_RGRD(data);\
} while (0)

#define DMA_TDTP_TPDR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1320))

#define DMA_TDTP_TPDR4_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TDTP_TPDR4_RGOFFADDR);\
} while (0)

#define DMA_TDTP_TPDR4_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TDTP_TPDR4_RGOFFADDR);\
} while (0)

#define DMA_TDTP_TPDR4_TDT_UDFWR(data) do {\
		DMA_TDTP_TPDR4_RGWR(data);\
} while (0)

#define DMA_TDTP_TPDR4_TDT_UDFRD(data) do {\
		DMA_TDTP_TPDR4_RGRD(data);\
} while (0)

#define DMA_TDTP_TPDR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x12a0))

#define DMA_TDTP_TPDR3_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TDTP_TPDR3_RGOFFADDR);\
} while (0)

#define DMA_TDTP_TPDR3_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TDTP_TPDR3_RGOFFADDR);\
} while (0)

#define DMA_TDTP_TPDR3_TDT_UDFWR(data) do {\
		DMA_TDTP_TPDR3_RGWR(data);\
} while (0)

#define DMA_TDTP_TPDR3_TDT_UDFRD(data) do {\
		DMA_TDTP_TPDR3_RGRD(data);\
} while (0)

#define DMA_TDTP_TPDR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1220))

#define DMA_TDTP_TPDR2_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TDTP_TPDR2_RGOFFADDR);\
} while (0)

#define DMA_TDTP_TPDR2_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TDTP_TPDR2_RGOFFADDR);\
} while (0)

#define DMA_TDTP_TPDR2_TDT_UDFWR(data) do {\
		DMA_TDTP_TPDR2_RGWR(data);\
} while (0)

#define DMA_TDTP_TPDR2_TDT_UDFRD(data) do {\
		DMA_TDTP_TPDR2_RGRD(data);\
} while (0)

#define DMA_TDTP_TPDR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x11a0))

#define DMA_TDTP_TPDR1_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TDTP_TPDR1_RGOFFADDR);\
} while (0)

#define DMA_TDTP_TPDR1_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TDTP_TPDR1_RGOFFADDR);\
} while (0)

#define DMA_TDTP_TPDR1_TDT_UDFWR(data) do {\
		DMA_TDTP_TPDR1_RGWR(data);\
} while (0)

#define DMA_TDTP_TPDR1_TDT_UDFRD(data) do {\
		DMA_TDTP_TPDR1_RGRD(data);\
} while (0)

#define DMA_TDTP_TPDR0_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1120))

#define DMA_TDTP_TPDR0_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TDTP_TPDR0_RGOFFADDR);\
} while (0)

#define DMA_TDTP_TPDR0_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TDTP_TPDR0_RGOFFADDR);\
} while (0)

#define DMA_TDTP_TPDR0_TDT_UDFWR(data) do {\
		DMA_TDTP_TPDR0_RGWR(data);\
} while (0)

#define DMA_TDTP_TPDR0_TDT_UDFRD(data) do {\
		DMA_TDTP_TPDR0_RGRD(data);\
} while (0)

#define DMA_RDLAR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x149c))

#define DMA_RDLAR7_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RDLAR7_RGOFFADDR);\
} while (0)

#define DMA_RDLAR7_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RDLAR7_RGOFFADDR);\
} while (0)

#define DMA_RDLAR7_RDESLA_UDFWR(data) do {\
		DMA_RDLAR7_RGWR(data);\
} while (0)

#define DMA_RDLAR7_RDESLA_UDFRD(data) do {\
		DMA_RDLAR7_RGRD(data);\
} while (0)

#define DMA_RDLAR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x141c))

#define DMA_RDLAR6_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RDLAR6_RGOFFADDR);\
} while (0)

#define DMA_RDLAR6_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RDLAR6_RGOFFADDR);\
} while (0)

#define DMA_RDLAR6_RDESLA_UDFWR(data) do {\
		DMA_RDLAR6_RGWR(data);\
} while (0)

#define DMA_RDLAR6_RDESLA_UDFRD(data) do {\
		DMA_RDLAR6_RGRD(data);\
} while (0)

#define DMA_RDLAR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x139c))

#define DMA_RDLAR5_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RDLAR5_RGOFFADDR);\
} while (0)

#define DMA_RDLAR5_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RDLAR5_RGOFFADDR);\
} while (0)

#define DMA_RDLAR5_RDESLA_UDFWR(data) do {\
		DMA_RDLAR5_RGWR(data);\
} while (0)

#define DMA_RDLAR5_RDESLA_UDFRD(data) do {\
		DMA_RDLAR5_RGRD(data);\
} while (0)

#define DMA_RDLAR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x131c))

#define DMA_RDLAR4_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RDLAR4_RGOFFADDR);\
} while (0)

#define DMA_RDLAR4_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RDLAR4_RGOFFADDR);\
} while (0)

#define DMA_RDLAR4_RDESLA_UDFWR(data) do {\
		DMA_RDLAR4_RGWR(data);\
} while (0)

#define DMA_RDLAR4_RDESLA_UDFRD(data) do {\
		DMA_RDLAR4_RGRD(data);\
} while (0)

#define DMA_RDLAR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x129c))

#define DMA_RDLAR3_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RDLAR3_RGOFFADDR);\
} while (0)

#define DMA_RDLAR3_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RDLAR3_RGOFFADDR);\
} while (0)

#define DMA_RDLAR3_RDESLA_UDFWR(data) do {\
		DMA_RDLAR3_RGWR(data);\
} while (0)

#define DMA_RDLAR3_RDESLA_UDFRD(data) do {\
		DMA_RDLAR3_RGRD(data);\
} while (0)

#define DMA_RDLAR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x121c))

#define DMA_RDLAR2_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RDLAR2_RGOFFADDR);\
} while (0)

#define DMA_RDLAR2_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RDLAR2_RGOFFADDR);\
} while (0)

#define DMA_RDLAR2_RDESLA_UDFWR(data) do {\
		DMA_RDLAR2_RGWR(data);\
} while (0)

#define DMA_RDLAR2_RDESLA_UDFRD(data) do {\
		DMA_RDLAR2_RGRD(data);\
} while (0)

#define DMA_RDLAR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x119c))

#define DMA_RDLAR1_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RDLAR1_RGOFFADDR);\
} while (0)

#define DMA_RDLAR1_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RDLAR1_RGOFFADDR);\
} while (0)

#define DMA_RDLAR1_RDESLA_UDFWR(data) do {\
		DMA_RDLAR1_RGWR(data);\
} while (0)

#define DMA_RDLAR1_RDESLA_UDFRD(data) do {\
		DMA_RDLAR1_RGRD(data);\
} while (0)

#define DMA_RDLAR0_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x111c))

#define DMA_RDLAR0_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RDLAR0_RGOFFADDR);\
} while (0)

#define DMA_RDLAR0_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RDLAR0_RGOFFADDR);\
} while (0)

#define DMA_RDLAR0_RDESLA_UDFWR(data) do {\
		DMA_RDLAR0_RGWR(data);\
} while (0)

#define DMA_RDLAR0_RDESLA_UDFRD(data) do {\
		DMA_RDLAR0_RGRD(data);\
} while (0)

#define DMA_TDLAR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1494))

#define DMA_TDLAR7_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TDLAR7_RGOFFADDR);\
} while (0)

#define DMA_TDLAR7_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TDLAR7_RGOFFADDR);\
} while (0)

#define DMA_TDLAR7_TDESLA_UDFWR(data) do {\
		DMA_TDLAR7_RGWR(data);\
} while (0)

#define DMA_TDLAR7_TDESLA_UDFRD(data) do {\
		DMA_TDLAR7_RGRD(data);\
} while (0)

#define DMA_TDLAR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1414))

#define DMA_TDLAR6_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TDLAR6_RGOFFADDR);\
} while (0)

#define DMA_TDLAR6_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TDLAR6_RGOFFADDR);\
} while (0)

#define DMA_TDLAR6_TDESLA_UDFWR(data) do {\
		DMA_TDLAR6_RGWR(data);\
} while (0)

#define DMA_TDLAR6_TDESLA_UDFRD(data) do {\
		DMA_TDLAR6_RGRD(data);\
} while (0)

#define DMA_TDLAR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1394))

#define DMA_TDLAR5_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TDLAR5_RGOFFADDR);\
} while (0)

#define DMA_TDLAR5_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TDLAR5_RGOFFADDR);\
} while (0)

#define DMA_TDLAR5_TDESLA_UDFWR(data) do {\
		DMA_TDLAR5_RGWR(data);\
} while (0)

#define DMA_TDLAR5_TDESLA_UDFRD(data) do {\
		DMA_TDLAR5_RGRD(data);\
} while (0)

#define DMA_TDLAR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1314))

#define DMA_TDLAR4_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TDLAR4_RGOFFADDR);\
} while (0)

#define DMA_TDLAR4_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TDLAR4_RGOFFADDR);\
} while (0)

#define DMA_TDLAR4_TDESLA_UDFWR(data) do {\
		DMA_TDLAR4_RGWR(data);\
} while (0)

#define DMA_TDLAR4_TDESLA_UDFRD(data) do {\
		DMA_TDLAR4_RGRD(data);\
} while (0)

#define DMA_TDLAR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1294))

#define DMA_TDLAR3_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TDLAR3_RGOFFADDR);\
} while (0)

#define DMA_TDLAR3_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TDLAR3_RGOFFADDR);\
} while (0)

#define DMA_TDLAR3_TDESLA_UDFWR(data) do {\
		DMA_TDLAR3_RGWR(data);\
} while (0)

#define DMA_TDLAR3_TDESLA_UDFRD(data) do {\
		DMA_TDLAR3_RGRD(data);\
} while (0)

#define DMA_TDLAR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1214))

#define DMA_TDLAR2_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TDLAR2_RGOFFADDR);\
} while (0)

#define DMA_TDLAR2_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TDLAR2_RGOFFADDR);\
} while (0)

#define DMA_TDLAR2_TDESLA_UDFWR(data) do {\
		DMA_TDLAR2_RGWR(data);\
} while (0)

#define DMA_TDLAR2_TDESLA_UDFRD(data) do {\
		DMA_TDLAR2_RGRD(data);\
} while (0)

#define DMA_TDLAR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1194))

#define DMA_TDLAR1_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TDLAR1_RGOFFADDR);\
} while (0)

#define DMA_TDLAR1_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TDLAR1_RGOFFADDR);\
} while (0)

#define DMA_TDLAR1_TDESLA_UDFWR(data) do {\
		DMA_TDLAR1_RGWR(data);\
} while (0)

#define DMA_TDLAR1_TDESLA_UDFRD(data) do {\
		DMA_TDLAR1_RGRD(data);\
} while (0)

#define DMA_TDLAR0_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1114))

#define DMA_TDLAR0_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TDLAR0_RGOFFADDR);\
} while (0)

#define DMA_TDLAR0_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TDLAR0_RGOFFADDR);\
} while (0)

#define DMA_TDLAR0_TDESLA_UDFWR(data) do {\
		DMA_TDLAR0_RGWR(data);\
} while (0)

#define DMA_TDLAR0_TDESLA_UDFRD(data) do {\
		DMA_TDLAR0_RGRD(data);\
} while (0)

#define MAC_IMR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xb4))

#define MAC_IMR_RGWR(data) do {\
		iowrite32(data, (void *)MAC_IMR_RGOFFADDR);\
} while (0)

#define MAC_IMR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_IMR_RGOFFADDR);\
} while (0)

/*#define  MAC_IMR_Mask_13 (ULONG)(~(~0<<(19)))*/

#define  MAC_IMR_MASK_13 (ULONG)(0x7ffff)

/*#define MAC_IMR_RES_Wr_Mask_13 (ULONG)(~((~(~0<<(19)))<<(13)))*/

#define MAC_IMR_RES_WR_MASK_13 (ULONG)(0x1fff)

/*#define  MAC_IMR_Mask_6 (ULONG)(~(~0<<(6)))*/

#define  MAC_IMR_MASK_6 (ULONG)(0x3f)

/*#define MAC_IMR_RES_Wr_Mask_6 (ULONG)(~((~(~0<<(6)))<<(6)))*/

#define MAC_IMR_RES_WR_MASK_6 (ULONG)(0xfffff03f)

/*#define MAC_IMR_TSIM_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_IMR_TSIM_MASK (ULONG)(0x1)

/*#define MAC_IMR_TSIM_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define MAC_IMR_TSIM_WR_MASK (ULONG)(0xffffefff)

#define MAC_IMR_TSIM_UDFWR(data) do {\
		ULONG v;\
		MAC_IMR_RGRD(v);\
		v = (v & (MAC_IMR_RES_WR_MASK_13)) | (((0) & (MAC_IMR_MASK_13)) << 13);\
		v = (v & (MAC_IMR_RES_WR_MASK_6)) | (((0) & (MAC_IMR_MASK_6)) << 6);\
		v = ((v & MAC_IMR_TSIM_WR_MASK) | ((data & MAC_IMR_TSIM_MASK) << 12));\
		MAC_IMR_RGWR(v);\
} while (0)

#define MAC_IMR_TSIM_UDFRD(data) do {\
		MAC_IMR_RGRD(data);\
		data = ((data >> 12) & MAC_IMR_TSIM_MASK);\
} while (0)

/*#define MAC_IMR_LPIIM_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_IMR_LPIIM_MASK (ULONG)(0x1)

/*#define MAC_IMR_LPIIM_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MAC_IMR_LPIIM_WR_MASK (ULONG)(0xffffffdf)

#define MAC_IMR_LPIIM_UDFWR(data) do {\
		ULONG v;\
		MAC_IMR_RGRD(v);\
		v = (v & (MAC_IMR_RES_WR_MASK_13)) | (((0) & (MAC_IMR_MASK_13)) << 13);\
		v = (v & (MAC_IMR_RES_WR_MASK_6)) | (((0) & (MAC_IMR_MASK_6)) << 6);\
		v = ((v & MAC_IMR_LPIIM_WR_MASK) | ((data & MAC_IMR_LPIIM_MASK) << 5));\
		MAC_IMR_RGWR(v);\
} while (0)

#define MAC_IMR_LPIIM_UDFRD(data) do {\
		MAC_IMR_RGRD(data);\
		data = ((data >> 5) & MAC_IMR_LPIIM_MASK);\
} while (0)

/*#define MAC_IMR_PMTIM_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_IMR_PMTIM_MASK (ULONG)(0x1)

/*#define MAC_IMR_PMTIM_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MAC_IMR_PMTIM_WR_MASK (ULONG)(0xffffffef)

#define MAC_IMR_PMTIM_UDFWR(data) do {\
		ULONG v;\
		MAC_IMR_RGRD(v);\
		v = (v & (MAC_IMR_RES_WR_MASK_13)) | (((0) & (MAC_IMR_MASK_13)) << 13);\
		v = (v & (MAC_IMR_RES_WR_MASK_6)) | (((0) & (MAC_IMR_MASK_6)) << 6);\
		v = ((v & MAC_IMR_PMTIM_WR_MASK) | ((data & MAC_IMR_PMTIM_MASK) << 4));\
		MAC_IMR_RGWR(v);\
} while (0)

#define MAC_IMR_PMTIM_UDFRD(data) do {\
		MAC_IMR_RGRD(data);\
		data = ((data >> 4) & MAC_IMR_PMTIM_MASK);\
} while (0)

/*#define MAC_IMR_PHYIM_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_IMR_PHYIM_MASK (ULONG)(0x1)

/*#define MAC_IMR_PHYIM_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MAC_IMR_PHYIM_WR_MASK (ULONG)(0xfffffff7)

#define MAC_IMR_PHYIM_UDFWR(data) do {\
		ULONG v;\
		MAC_IMR_RGRD(v);\
		v = (v & (MAC_IMR_RES_WR_MASK_13)) | (((0) & (MAC_IMR_MASK_13)) << 13);\
		v = (v & (MAC_IMR_RES_WR_MASK_6)) | (((0) & (MAC_IMR_MASK_6)) << 6);\
		v = ((v & MAC_IMR_PHYIM_WR_MASK) | ((data & MAC_IMR_PHYIM_MASK) << 3));\
		MAC_IMR_RGWR(v);\
} while (0)

#define MAC_IMR_PHYIM_UDFRD(data) do {\
		MAC_IMR_RGRD(data);\
		data = ((data >> 3) & MAC_IMR_PHYIM_MASK);\
} while (0)

/*#define MAC_IMR_PCSANCIM_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_IMR_PCSANCIM_MASK (ULONG)(0x1)

/*#define MAC_IMR_PCSANCIM_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MAC_IMR_PCSANCIM_WR_MASK (ULONG)(0xfffffffb)

#define MAC_IMR_PCSANCIM_UDFWR(data) do {\
		ULONG v;\
		MAC_IMR_RGRD(v);\
		v = (v & (MAC_IMR_RES_WR_MASK_13)) | (((0) & (MAC_IMR_MASK_13)) << 13);\
		v = (v & (MAC_IMR_RES_WR_MASK_6)) | (((0) & (MAC_IMR_MASK_6)) << 6);\
		v = ((v & MAC_IMR_PCSANCIM_WR_MASK) | ((data & MAC_IMR_PCSANCIM_MASK) << 2));\
		MAC_IMR_RGWR(v);\
} while (0)

#define MAC_IMR_PCSANCIM_UDFRD(data) do {\
		MAC_IMR_RGRD(data);\
		data = ((data >> 2) & MAC_IMR_PCSANCIM_MASK);\
} while (0)

/*#define MAC_IMR_PCSLCHGIM_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_IMR_PCSLCHGIM_MASK (ULONG)(0x1)

/*#define MAC_IMR_PCSLCHGIM_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_IMR_PCSLCHGIM_WR_MASK (ULONG)(0xfffffffd)

#define MAC_IMR_PCSLCHGIM_UDFWR(data) do {\
		ULONG v;\
		MAC_IMR_RGRD(v);\
		v = (v & (MAC_IMR_RES_WR_MASK_13)) | (((0) & (MAC_IMR_MASK_13)) << 13);\
		v = (v & (MAC_IMR_RES_WR_MASK_6)) | (((0) & (MAC_IMR_MASK_6)) << 6);\
		v = ((v & MAC_IMR_PCSLCHGIM_WR_MASK) | ((data & MAC_IMR_PCSLCHGIM_MASK) << 1));\
		MAC_IMR_RGWR(v);\
} while (0)

#define MAC_IMR_PCSLCHGIM_UDFRD(data) do {\
		MAC_IMR_RGRD(data);\
		data = ((data >> 1) & MAC_IMR_PCSLCHGIM_MASK);\
} while (0)

/*#define MAC_IMR_RGSMIIIM_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_IMR_RGSMIIIM_MASK (ULONG)(0x1)

/*#define MAC_IMR_RGSMIIIM_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_IMR_RGSMIIIM_WR_MASK (ULONG)(0xfffffffe)

#define MAC_IMR_RGSMIIIM_UDFWR(data) do {\
		ULONG v;\
		MAC_IMR_RGRD(v);\
		v = (v & (MAC_IMR_RES_WR_MASK_13)) | (((0) & (MAC_IMR_MASK_13)) << 13);\
		v = (v & (MAC_IMR_RES_WR_MASK_6)) | (((0) & (MAC_IMR_MASK_6)) << 6);\
		v = ((v & MAC_IMR_RGSMIIIM_WR_MASK) | ((data & MAC_IMR_RGSMIIIM_MASK) << 0));\
		MAC_IMR_RGWR(v);\
} while (0)

#define MAC_IMR_RGSMIIIM_UDFRD(data) do {\
		MAC_IMR_RGRD(data);\
		data = ((data >> 0) & MAC_IMR_RGSMIIIM_MASK);\
} while (0)

#define MAC_ISR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xb0))

#define MAC_ISR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_ISR_RGOFFADDR);\
} while (0)

/*#define MAC_ISR_RWT_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ISR_RWT_MASK (ULONG)(0x1)

#define MAC_ISR_RWT_UDFRD(data) do {\
		MAC_ISR_RGRD(data);\
		data = ((data >> 14) & MAC_ISR_RWT_MASK);\
} while (0)

/*#define MAC_ISR_TJT_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ISR_TJT_MASK (ULONG)(0x1)

#define MAC_ISR_TJT_UDFRD(data) do {\
		MAC_ISR_RGRD(data);\
		data = ((data >> 13) & MAC_ISR_TJT_MASK);\
} while (0)

/*#define MAC_ISR_TSIS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ISR_TSIS_MASK (ULONG)(0x1)

#define MAC_ISR_TSIS_UDFRD(data) do {\
		MAC_ISR_RGRD(data);\
		data = ((data >> 12) & MAC_ISR_TSIS_MASK);\
} while (0)

/*#define MAC_ISR_MMCRXIPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ISR_MMCRXIPIS_MASK (ULONG)(0x1)

#define MAC_ISR_MMCRXIPIS_UDFRD(data) do {\
		MAC_ISR_RGRD(data);\
		data = ((data >> 11) & MAC_ISR_MMCRXIPIS_MASK);\
} while (0)

/*#define MAC_ISR_MMCTXIS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ISR_MMCTXIS_MASK (ULONG)(0x1)

#define MAC_ISR_MMCTXIS_UDFRD(data) do {\
		MAC_ISR_RGRD(data);\
		data = ((data >> 10) & MAC_ISR_MMCTXIS_MASK);\
} while (0)

/*#define MAC_ISR_MMCRXIS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ISR_MMCRXIS_MASK (ULONG)(0x1)

#define MAC_ISR_MMCRXIS_UDFRD(data) do {\
		MAC_ISR_RGRD(data);\
		data = ((data >> 9) & MAC_ISR_MMCRXIS_MASK);\
} while (0)

/*#define MAC_ISR_MMCIS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ISR_MMCIS_MASK (ULONG)(0x1)

#define MAC_ISR_MMCIS_UDFRD(data) do {\
		MAC_ISR_RGRD(data);\
		data = ((data >> 8) & MAC_ISR_MMCIS_MASK);\
} while (0)

/*#define MAC_ISR_LPIIS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ISR_LPIIS_MASK (ULONG)(0x1)

#define MAC_ISR_LPIIS_UDFRD(data) do {\
		MAC_ISR_RGRD(data);\
		data = ((data >> 5) & MAC_ISR_LPIIS_MASK);\
} while (0)

/*#define MAC_ISR_PMTIS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ISR_PMTIS_MASK (ULONG)(0x1)

#define MAC_ISR_PMTIS_UDFRD(data) do {\
		MAC_ISR_RGRD(data);\
		data = ((data >> 4) & MAC_ISR_PMTIS_MASK);\
} while (0)

/*#define MAC_ISR_PHYIS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ISR_PHYIS_MASK (ULONG)(0x1)

#define MAC_ISR_PHYIS_UDFRD(data) do {\
		MAC_ISR_RGRD(data);\
		data = ((data >> 3) & MAC_ISR_PHYIS_MASK);\
} while (0)

/*#define MAC_ISR_PCSANCIA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ISR_PCSANCIA_MASK (ULONG)(0x1)

#define MAC_ISR_PCSANCIA_UDFRD(data) do {\
		MAC_ISR_RGRD(data);\
		data = ((data >> 2) & MAC_ISR_PCSANCIA_MASK);\
} while (0)

/*#define MAC_ISR_PCSLCHGIS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ISR_PCSLCHGIS_MASK (ULONG)(0x1)

#define MAC_ISR_PCSLCHGIS_UDFRD(data) do {\
		MAC_ISR_RGRD(data);\
		data = ((data >> 1) & MAC_ISR_PCSLCHGIS_MASK);\
} while (0)

/*#define MAC_ISR_RGSMIIIS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ISR_RGSMIIIS_MASK (ULONG)(0x1)

#define MAC_ISR_RGSMIIIS_UDFRD(data) do {\
		MAC_ISR_RGRD(data);\
		data = ((data >> 0) & MAC_ISR_RGSMIIIS_MASK);\
} while (0)

#define MTL_ISR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xc20))

#define MTL_ISR_RGRD(data) do {\
		(data) = ioread32((void *)MTL_ISR_RGOFFADDR);\
} while (0)

/*#define MTL_ISR_MACIS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_MACIS_MASK (ULONG)(0x1)

#define MTL_ISR_MACIS_UDFRD(data) do {\
		MTL_ISR_RGRD(data);\
		data = ((data >> 16) & MTL_ISR_MACIS_MASK);\
} while (0)

/*#define MTL_ISR_Q7RXO_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q7RXO_MASK (ULONG)(0x1)

#define MTL_ISR_Q7RXO_UDFRD(data) do {\
		MTL_ISR_RGRD(data);\
		data = ((data >> 15) & MTL_ISR_Q7RXO_MASK);\
} while (0)

/*#define MTL_ISR_Q7TXU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q7TXU_MASK (ULONG)(0x1)

#define MTL_ISR_Q7TXU_UDFRD(data) do {\
		MTL_ISR_RGRD(data);\
		data = ((data >> 14) & MTL_ISR_Q7TXU_MASK);\
} while (0)

/*#define MTL_ISR_Q6RXO_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q6RXO_MASK (ULONG)(0x1)

#define MTL_ISR_Q6RXO_UDFRD(data) do {\
		MTL_ISR_RGRD(data);\
		data = ((data >> 13) & MTL_ISR_Q6RXO_MASK);\
} while (0)

/*#define MTL_ISR_Q6TXU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q6TXU_MASK (ULONG)(0x1)

#define MTL_ISR_Q6TXU_UDFRD(data) do {\
		MTL_ISR_RGRD(data);\
		data = ((data >> 12) & MTL_ISR_Q6TXU_MASK);\
} while (0)

/*#define MTL_ISR_Q5RXO_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q5RXO_MASK (ULONG)(0x1)

#define MTL_ISR_Q5RXO_UDFRD(data) do {\
		MTL_ISR_RGRD(data);\
		data = ((data >> 11) & MTL_ISR_Q5RXO_MASK);\
} while (0)

/*#define MTL_ISR_Q5TXU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q5TXU_MASK (ULONG)(0x1)

#define MTL_ISR_Q5TXU_UDFRD(data) do {\
		MTL_ISR_RGRD(data);\
		data = ((data >> 10) & MTL_ISR_Q5TXU_MASK);\
} while (0)

/*#define MTL_ISR_Q4RXO_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q4RXO_MASK (ULONG)(0x1)

#define MTL_ISR_Q4RXO_UDFRD(data) do {\
		MTL_ISR_RGRD(data);\
		data = ((data >> 9) & MTL_ISR_Q4RXO_MASK);\
} while (0)

/*#define MTL_ISR_Q4TXU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q4TXU_MASK (ULONG)(0x1)

#define MTL_ISR_Q4TXU_UDFRD(data) do {\
		MTL_ISR_RGRD(data);\
		data = ((data >> 8) & MTL_ISR_Q4TXU_MASK);\
} while (0)

/*#define MTL_ISR_Q3RXO_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q3RXO_MASK (ULONG)(0x1)

#define MTL_ISR_Q3RXO_UDFRD(data) do {\
		MTL_ISR_RGRD(data);\
		data = ((data >> 7) & MTL_ISR_Q3RXO_MASK);\
} while (0)

/*#define MTL_ISR_Q3TXU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q3TXU_MASK (ULONG)(0x1)

#define MTL_ISR_Q3TXU_UDFRD(data) do {\
		MTL_ISR_RGRD(data);\
		data = ((data >> 6) & MTL_ISR_Q3TXU_MASK);\
} while (0)

/*#define MTL_ISR_Q2RXO_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q2RXO_MASK (ULONG)(0x1)

#define MTL_ISR_Q2RXO_UDFRD(data) do {\
		MTL_ISR_RGRD(data);\
		data = ((data >> 5) & MTL_ISR_Q2RXO_MASK);\
} while (0)

/*#define MTL_ISR_Q2TXU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q2TXU_MASK (ULONG)(0x1)

#define MTL_ISR_Q2TXU_UDFRD(data) do {\
		MTL_ISR_RGRD(data);\
		data = ((data >> 4) & MTL_ISR_Q2TXU_MASK);\
} while (0)

/*#define MTL_ISR_Q1RXO_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q1RXO_MASK (ULONG)(0x1)

#define MTL_ISR_Q1RXO_UDFRD(data) do {\
		MTL_ISR_RGRD(data);\
		data = ((data >> 3) & MTL_ISR_Q1RXO_MASK);\
} while (0)

/*#define MTL_ISR_Q1TXU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q1TXU_MASK (ULONG)(0x1)

#define MTL_ISR_Q1TXU_UDFRD(data) do {\
		MTL_ISR_RGRD(data);\
		data = ((data >> 2) & MTL_ISR_Q1TXU_MASK);\
} while (0)

/*#define MTL_ISR_Q0RXO_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q0RXO_MASK (ULONG)(0x1)

#define MTL_ISR_Q0RXO_UDFRD(data) do {\
		MTL_ISR_RGRD(data);\
		data = ((data >> 1) & MTL_ISR_Q0RXO_MASK);\
} while (0)

/*#define MTL_ISR_Q0TXU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q0TXU_MASK (ULONG)(0x1)

#define MTL_ISR_Q0TXU_UDFRD(data) do {\
		MTL_ISR_RGRD(data);\
		data = ((data >> 0) & MTL_ISR_Q0TXU_MASK);\
} while (0)

#define DMA_ISR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1008))

#define DMA_ISR_RGRD(data) do {\
		(data) = ioread32((void *)DMA_ISR_RGOFFADDR);\
} while (0)

/*#define DMA_ISR_MACIS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_ISR_MACIS_MASK (ULONG)(0x1)

#define DMA_ISR_MACIS_UDFRD(data) do {\
		DMA_ISR_RGRD(data);\
		data = ((data >> 17) & DMA_ISR_MACIS_MASK);\
} while (0)

/*#define DMA_ISR_MTLIS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_ISR_MTLIS_MASK (ULONG)(0x1)

#define DMA_ISR_MTLIS_UDFRD(data) do {\
		DMA_ISR_RGRD(data);\
		data = ((data >> 16) & DMA_ISR_MTLIS_MASK);\
} while (0)

/*#define DMA_ISR_DC7IS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_ISR_DC7IS_MASK (ULONG)(0x1)

#define DMA_ISR_DC7IS_UDFRD(data) do {\
		DMA_ISR_RGRD(data);\
		data = ((data >> 7) & DMA_ISR_DC7IS_MASK);\
} while (0)

/*#define DMA_ISR_DC6IS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_ISR_DC6IS_MASK (ULONG)(0x1)

#define DMA_ISR_DC6IS_UDFRD(data) do {\
		DMA_ISR_RGRD(data);\
		data = ((data >> 6) & DMA_ISR_DC6IS_MASK);\
} while (0)

/*#define DMA_ISR_DC5IS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_ISR_DC5IS_MASK (ULONG)(0x1)

#define DMA_ISR_DC5IS_UDFRD(data) do {\
		DMA_ISR_RGRD(data);\
		data = ((data >> 5) & DMA_ISR_DC5IS_MASK);\
} while (0)

/*#define DMA_ISR_DC4IS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_ISR_DC4IS_MASK (ULONG)(0x1)

#define DMA_ISR_DC4IS_UDFRD(data) do {\
		DMA_ISR_RGRD(data);\
		data = ((data >> 4) & DMA_ISR_DC4IS_MASK);\
} while (0)

/*#define DMA_ISR_DC3IS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_ISR_DC3IS_MASK (ULONG)(0x1)

#define DMA_ISR_DC3IS_UDFRD(data) do {\
		DMA_ISR_RGRD(data);\
		data = ((data >> 3) & DMA_ISR_DC3IS_MASK);\
} while (0)

/*#define DMA_ISR_DC2IS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_ISR_DC2IS_MASK (ULONG)(0x1)

#define DMA_ISR_DC2IS_UDFRD(data) do {\
		DMA_ISR_RGRD(data);\
		data = ((data >> 2) & DMA_ISR_DC2IS_MASK);\
} while (0)

/*#define DMA_ISR_DC1IS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_ISR_DC1IS_MASK (ULONG)(0x1)

#define DMA_ISR_DC1IS_UDFRD(data) do {\
		DMA_ISR_RGRD(data);\
		data = ((data >> 1) & DMA_ISR_DC1IS_MASK);\
} while (0)

/*#define DMA_ISR_DC0IS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_ISR_DC0IS_MASK (ULONG)(0x1)

#define DMA_ISR_DC0IS_UDFRD(data) do {\
		DMA_ISR_RGRD(data);\
		data = ((data >> 0) & DMA_ISR_DC0IS_MASK);\
} while (0)

#define DMA_DSR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1014))

#define DMA_DSR2_RGRD(data) do {\
		(data) = ioread32((void *)DMA_DSR2_RGOFFADDR);\
} while (0)

/*#define DMA_DSR2_TPS7_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR2_TPS7_MASK (ULONG)(0xf)

#define DMA_DSR2_TPS7_UDFRD(data) do {\
		DMA_DSR2_RGRD(data);\
		data = ((data >> 4) & DMA_DSR2_TPS7_MASK);\
} while (0)

/*#define DMA_DSR2_RPS7_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR2_RPS7_MASK (ULONG)(0xf)

#define DMA_DSR2_RPS7_UDFRD(data) do {\
		DMA_DSR2_RGRD(data);\
		data = ((data >> 0) & DMA_DSR2_RPS7_MASK);\
} while (0)

#define DMA_DSR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1010))

#define DMA_DSR1_RGRD(data) do {\
		(data) = ioread32((void *)DMA_DSR1_RGOFFADDR);\
} while (0)

/*#define DMA_DSR1_TPS6_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR1_TPS6_MASK (ULONG)(0xf)

#define DMA_DSR1_TPS6_UDFRD(data) do {\
		DMA_DSR1_RGRD(data);\
		data = ((data >> 28) & DMA_DSR1_TPS6_MASK);\
} while (0)

/*#define DMA_DSR1_RPS6_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR1_RPS6_MASK (ULONG)(0xf)

#define DMA_DSR1_RPS6_UDFRD(data) do {\
		DMA_DSR1_RGRD(data);\
		data = ((data >> 24) & DMA_DSR1_RPS6_MASK);\
} while (0)

/*#define DMA_DSR1_TPS5_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR1_TPS5_MASK (ULONG)(0xf)

#define DMA_DSR1_TPS5_UDFRD(data) do {\
		DMA_DSR1_RGRD(data);\
		data = ((data >> 20) & DMA_DSR1_TPS5_MASK);\
} while (0)

/*#define DMA_DSR1_RPS5_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR1_RPS5_MASK (ULONG)(0xf)

#define DMA_DSR1_RPS5_UDFRD(data) do {\
		DMA_DSR1_RGRD(data);\
		data = ((data >> 16) & DMA_DSR1_RPS5_MASK);\
} while (0)

/*#define DMA_DSR1_TPS4_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR1_TPS4_MASK (ULONG)(0xf)

#define DMA_DSR1_TPS4_UDFRD(data) do {\
		DMA_DSR1_RGRD(data);\
		data = ((data >> 12) & DMA_DSR1_TPS4_MASK);\
} while (0)

/*#define DMA_DSR1_RPS4_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR1_RPS4_MASK (ULONG)(0xf)

#define DMA_DSR1_RPS4_UDFRD(data) do {\
		DMA_DSR1_RGRD(data);\
		data = ((data >> 8) & DMA_DSR1_RPS4_MASK);\
} while (0)

/*#define DMA_DSR1_TPS3_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR1_TPS3_MASK (ULONG)(0xf)

#define DMA_DSR1_TPS3_UDFRD(data) do {\
		DMA_DSR1_RGRD(data);\
		data = ((data >> 4) & DMA_DSR1_TPS3_MASK);\
} while (0)

/*#define DMA_DSR1_RPS3_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR1_RPS3_MASK (ULONG)(0xf)

#define DMA_DSR1_RPS3_UDFRD(data) do {\
		DMA_DSR1_RGRD(data);\
		data = ((data >> 0) & DMA_DSR1_RPS3_MASK);\
} while (0)

#define DMA_DSR0_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x100c))

#define DMA_DSR0_RGRD(data) do {\
		(data) = ioread32((void *)DMA_DSR0_RGOFFADDR);\
} while (0)

/*#define DMA_DSR0_TPS2_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR0_TPS2_MASK (ULONG)(0xf)

#define DMA_DSR0_TPS2_UDFRD(data) do {\
		DMA_DSR0_RGRD(data);\
		data = ((data >> 28) & DMA_DSR0_TPS2_MASK);\
} while (0)

/*#define DMA_DSR0_RPS2_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR0_RPS2_MASK (ULONG)(0xf)

#define DMA_DSR0_RPS2_UDFRD(data) do {\
		DMA_DSR0_RGRD(data);\
		data = ((data >> 24) & DMA_DSR0_RPS2_MASK);\
} while (0)

/*#define DMA_DSR0_TPS1_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR0_TPS1_MASK (ULONG)(0xf)

#define DMA_DSR0_TPS1_UDFRD(data) do {\
		DMA_DSR0_RGRD(data);\
		data = ((data >> 20) & DMA_DSR0_TPS1_MASK);\
} while (0)

/*#define DMA_DSR0_RPS1_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR0_RPS1_MASK (ULONG)(0xf)

#define DMA_DSR0_RPS1_UDFRD(data) do {\
		DMA_DSR0_RGRD(data);\
		data = ((data >> 16) & DMA_DSR0_RPS1_MASK);\
} while (0)

/*#define DMA_DSR0_TPS0_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR0_TPS0_MASK (ULONG)(0xf)

#define DMA_DSR0_TPS0_UDFRD(data) do {\
		DMA_DSR0_RGRD(data);\
		data = ((data >> 12) & DMA_DSR0_TPS0_MASK);\
} while (0)

/*#define DMA_DSR0_RPS0_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR0_RPS0_MASK (ULONG)(0xf)

#define DMA_DSR0_RPS0_UDFRD(data) do {\
		DMA_DSR0_RGRD(data);\
		data = ((data >> 8) & DMA_DSR0_RPS0_MASK);\
} while (0)

/*#define DMA_DSR0_AXRHSTS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_DSR0_AXRHSTS_MASK (ULONG)(0x1)

#define DMA_DSR0_AXRHSTS_UDFRD(data) do {\
		DMA_DSR0_RGRD(data);\
		data = ((data >> 1) & DMA_DSR0_AXRHSTS_MASK);\
} while (0)

/*#define DMA_DSR0_AXWHSTS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_DSR0_AXWHSTS_MASK (ULONG)(0x1)

#define DMA_DSR0_AXWHSTS_UDFRD(data) do {\
		DMA_DSR0_RGRD(data);\
		data = ((data >> 0) & DMA_DSR0_AXWHSTS_MASK);\
} while (0)

#define MTL_Q0RDR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd38))

#define MTL_Q0RDR_RGRD(data) do {\
		(data) = ioread32((void *)MTL_Q0RDR_RGOFFADDR);\
} while (0)

/*#define MTL_Q0RDR_PRXQ_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_Q0RDR_PRXQ_MASK (ULONG)(0x3fff)

#define MTL_Q0RDR_PRXQ_UDFRD(data) do {\
		MTL_Q0RDR_RGRD(data);\
		data = ((data >> 16) & MTL_Q0RDR_PRXQ_MASK);\
} while (0)

/*#define MTL_Q0RDR_RXQSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_Q0RDR_RXQSTS_MASK (ULONG)(0x3)

#define MTL_Q0RDR_RXQSTS_UDFRD(data) do {\
		MTL_Q0RDR_RGRD(data);\
		data = ((data >> 4) & MTL_Q0RDR_RXQSTS_MASK);\
} while (0)

/*#define MTL_Q0RDR_RRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_Q0RDR_RRCSTS_MASK (ULONG)(0x3)

#define MTL_Q0RDR_RRCSTS_UDFRD(data) do {\
		MTL_Q0RDR_RGRD(data);\
		data = ((data >> 1) & MTL_Q0RDR_RRCSTS_MASK);\
} while (0)

/*#define MTL_Q0RDR_RWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0RDR_RWCSTS_MASK (ULONG)(0x1)

#define MTL_Q0RDR_RWCSTS_UDFRD(data) do {\
		MTL_Q0RDR_RGRD(data);\
		data = ((data >> 0) & MTL_Q0RDR_RWCSTS_MASK);\
} while (0)

#define MTL_Q0ESR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd14))

#define MTL_Q0ESR_RGRD(data) do {\
		(data) = ioread32((void *)MTL_Q0ESR_RGOFFADDR);\
} while (0)

/*#define MTL_Q0ESR_ABSU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0ESR_ABSU_MASK (ULONG)(0x1)

#define MTL_Q0ESR_ABSU_UDFRD(data) do {\
		MTL_Q0ESR_RGRD(data);\
		data = ((data >> 24) & MTL_Q0ESR_ABSU_MASK);\
} while (0)

/*#define MTL_Q0ESR_ABS_Mask (ULONG)(~(~0<<(24)))*/

#define MTL_Q0ESR_ABS_MASK (ULONG)(0xffffff)

#define MTL_Q0ESR_ABS_UDFRD(data) do {\
		MTL_Q0ESR_RGRD(data);\
		data = ((data >> 0) & MTL_Q0ESR_ABS_MASK);\
} while (0)

#define MTL_Q0TDR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd08))

#define MTL_Q0TDR_RGRD(data) do {\
		(data) = ioread32((void *)MTL_Q0TDR_RGOFFADDR);\
} while (0)

/*#define MTL_Q0TDR_STXSTSF_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_Q0TDR_STXSTSF_MASK (ULONG)(0x7)

#define MTL_Q0TDR_STXSTSF_UDFRD(data) do {\
		MTL_Q0TDR_RGRD(data);\
		data = ((data >> 20) & MTL_Q0TDR_STXSTSF_MASK);\
} while (0)

/*#define MTL_Q0TDR_PTXQ_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_Q0TDR_PTXQ_MASK (ULONG)(0x7)

#define MTL_Q0TDR_PTXQ_UDFRD(data) do {\
		MTL_Q0TDR_RGRD(data);\
		data = ((data >> 16) & MTL_Q0TDR_PTXQ_MASK);\
} while (0)

/*#define MTL_Q0TDR_TXSTSFSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0TDR_TXSTSFSTS_MASK (ULONG)(0x1)

#define MTL_Q0TDR_TXSTSFSTS_UDFRD(data) do {\
		MTL_Q0TDR_RGRD(data);\
		data = ((data >> 5) & MTL_Q0TDR_TXSTSFSTS_MASK);\
} while (0)

/*#define MTL_Q0TDR_TXQSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0TDR_TXQSTS_MASK (ULONG)(0x1)

#define MTL_Q0TDR_TXQSTS_UDFRD(data) do {\
		MTL_Q0TDR_RGRD(data);\
		data = ((data >> 4) & MTL_Q0TDR_TXQSTS_MASK);\
} while (0)

/*#define MTL_Q0TDR_TWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0TDR_TWCSTS_MASK (ULONG)(0x1)

#define MTL_Q0TDR_TWCSTS_UDFRD(data) do {\
		MTL_Q0TDR_RGRD(data);\
		data = ((data >> 3) & MTL_Q0TDR_TWCSTS_MASK);\
} while (0)

/*#define MTL_Q0TDR_TRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_Q0TDR_TRCSTS_MASK (ULONG)(0x3)

#define MTL_Q0TDR_TRCSTS_UDFRD(data) do {\
		MTL_Q0TDR_RGRD(data);\
		data = ((data >> 1) & MTL_Q0TDR_TRCSTS_MASK);\
} while (0)

/*#define MTL_Q0TDR_TXQPAUSED_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0TDR_TXQPAUSED_MASK (ULONG)(0x1)

#define MTL_Q0TDR_TXQPAUSED_UDFRD(data) do {\
		MTL_Q0TDR_RGRD(data);\
		data = ((data >> 0) & MTL_Q0TDR_TXQPAUSED_MASK);\
} while (0)

#define DMA_CHRBAR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x14dc))

#define DMA_CHRBAR7_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHRBAR7_RGOFFADDR);\
} while (0)

#define DMA_CHRBAR7_CURRBUFAPTR_UDFRD(data) do {\
		DMA_CHRBAR7_RGRD(data);\
} while (0)

#define DMA_CHRBAR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x145c))

#define DMA_CHRBAR6_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHRBAR6_RGOFFADDR);\
} while (0)

#define DMA_CHRBAR6_CURRBUFAPTR_UDFRD(data) do {\
		DMA_CHRBAR6_RGRD(data);\
} while (0)

#define DMA_CHRBAR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x13dc))

#define DMA_CHRBAR5_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHRBAR5_RGOFFADDR);\
} while (0)

#define DMA_CHRBAR5_CURRBUFAPTR_UDFRD(data) do {\
		DMA_CHRBAR5_RGRD(data);\
} while (0)

#define DMA_CHRBAR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x135c))

#define DMA_CHRBAR4_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHRBAR4_RGOFFADDR);\
} while (0)

#define DMA_CHRBAR4_CURRBUFAPTR_UDFRD(data) do {\
		DMA_CHRBAR4_RGRD(data);\
} while (0)

#define DMA_CHRBAR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x12dc))

#define DMA_CHRBAR3_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHRBAR3_RGOFFADDR);\
} while (0)

#define DMA_CHRBAR3_CURRBUFAPTR_UDFRD(data) do {\
		DMA_CHRBAR3_RGRD(data);\
} while (0)

#define DMA_CHRBAR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x125c))

#define DMA_CHRBAR2_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHRBAR2_RGOFFADDR);\
} while (0)

#define DMA_CHRBAR2_CURRBUFAPTR_UDFRD(data) do {\
		DMA_CHRBAR2_RGRD(data);\
} while (0)

#define DMA_CHRBAR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x11dc))

#define DMA_CHRBAR1_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHRBAR1_RGOFFADDR);\
} while (0)

#define DMA_CHRBAR1_CURRBUFAPTR_UDFRD(data) do {\
		DMA_CHRBAR1_RGRD(data);\
} while (0)

#define DMA_CHRBAR0_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x115c))

#define DMA_CHRBAR0_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHRBAR0_RGOFFADDR);\
} while (0)

#define DMA_CHRBAR0_CURRBUFAPTR_UDFRD(data) do {\
		DMA_CHRBAR0_RGRD(data);\
} while (0)

#define DMA_CHTBAR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x14d4))

#define DMA_CHTBAR7_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHTBAR7_RGOFFADDR);\
} while (0)

#define DMA_CHTBAR7_CURTBUFAPTR_UDFRD(data) do {\
		DMA_CHTBAR7_RGRD(data);\
} while (0)

#define DMA_CHTBAR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1454))

#define DMA_CHTBAR6_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHTBAR6_RGOFFADDR);\
} while (0)

#define DMA_CHTBAR6_CURTBUFAPTR_UDFRD(data) do {\
		DMA_CHTBAR6_RGRD(data);\
} while (0)

#define DMA_CHTBAR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x13d4))

#define DMA_CHTBAR5_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHTBAR5_RGOFFADDR);\
} while (0)

#define DMA_CHTBAR5_CURTBUFAPTR_UDFRD(data) do {\
		DMA_CHTBAR5_RGRD(data);\
} while (0)

#define DMA_CHTBAR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1354))

#define DMA_CHTBAR4_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHTBAR4_RGOFFADDR);\
} while (0)

#define DMA_CHTBAR4_CURTBUFAPTR_UDFRD(data) do {\
		DMA_CHTBAR4_RGRD(data);\
} while (0)

#define DMA_CHTBAR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x12d4))

#define DMA_CHTBAR3_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHTBAR3_RGOFFADDR);\
} while (0)

#define DMA_CHTBAR3_CURTBUFAPTR_UDFRD(data) do {\
		DMA_CHTBAR3_RGRD(data);\
} while (0)

#define DMA_CHTBAR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1254))

#define DMA_CHTBAR2_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHTBAR2_RGOFFADDR);\
} while (0)

#define DMA_CHTBAR2_CURTBUFAPTR_UDFRD(data) do {\
		DMA_CHTBAR2_RGRD(data);\
} while (0)

#define DMA_CHTBAR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x11d4))

#define DMA_CHTBAR1_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHTBAR1_RGOFFADDR);\
} while (0)

#define DMA_CHTBAR1_CURTBUFAPTR_UDFRD(data) do {\
		DMA_CHTBAR1_RGRD(data);\
} while (0)

#define DMA_CHTBAR0_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1154))

#define DMA_CHTBAR0_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHTBAR0_RGOFFADDR);\
} while (0)

#define DMA_CHTBAR0_CURTBUFAPTR_UDFRD(data) do {\
		DMA_CHTBAR0_RGRD(data);\
} while (0)

#define DMA_CHRDR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x14cc))

#define DMA_CHRDR7_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHRDR7_RGOFFADDR);\
} while (0)

#define DMA_CHRDR7_CURRDESAPTR_UDFRD(data) do {\
		DMA_CHRDR7_RGRD(data);\
} while (0)

#define DMA_CHRDR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x144c))

#define DMA_CHRDR6_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHRDR6_RGOFFADDR);\
} while (0)

#define DMA_CHRDR6_CURRDESAPTR_UDFRD(data) do {\
		DMA_CHRDR6_RGRD(data);\
} while (0)

#define DMA_CHRDR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x13cc))

#define DMA_CHRDR5_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHRDR5_RGOFFADDR);\
} while (0)

#define DMA_CHRDR5_CURRDESAPTR_UDFRD(data) do {\
		DMA_CHRDR5_RGRD(data);\
} while (0)

#define DMA_CHRDR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x134c))

#define DMA_CHRDR4_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHRDR4_RGOFFADDR);\
} while (0)

#define DMA_CHRDR4_CURRDESAPTR_UDFRD(data) do {\
		DMA_CHRDR4_RGRD(data);\
} while (0)

#define DMA_CHRDR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x12cc))

#define DMA_CHRDR3_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHRDR3_RGOFFADDR);\
} while (0)

#define DMA_CHRDR3_CURRDESAPTR_UDFRD(data) do {\
		DMA_CHRDR3_RGRD(data);\
} while (0)

#define DMA_CHRDR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x124c))

#define DMA_CHRDR2_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHRDR2_RGOFFADDR);\
} while (0)

#define DMA_CHRDR2_CURRDESAPTR_UDFRD(data) do {\
		DMA_CHRDR2_RGRD(data);\
} while (0)

#define DMA_CHRDR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x11cc))

#define DMA_CHRDR1_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHRDR1_RGOFFADDR);\
} while (0)

#define DMA_CHRDR1_CURRDESAPTR_UDFRD(data) do {\
		DMA_CHRDR1_RGRD(data);\
} while (0)

#define DMA_CHRDR0_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x114c))

#define DMA_CHRDR0_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHRDR0_RGOFFADDR);\
} while (0)

#define DMA_CHRDR0_CURRDESAPTR_UDFRD(data) do {\
		DMA_CHRDR0_RGRD(data);\
} while (0)

#define DMA_CHTDR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x14c4))

#define DMA_CHTDR7_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHTDR7_RGOFFADDR);\
} while (0)

#define DMA_CHTDR7_CURTDESAPTR_UDFRD(data) do {\
		DMA_CHTDR7_RGRD(data);\
} while (0)

#define DMA_CHTDR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1444))

#define DMA_CHTDR6_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHTDR6_RGOFFADDR);\
} while (0)

#define DMA_CHTDR6_CURTDESAPTR_UDFRD(data) do {\
		DMA_CHTDR6_RGRD(data);\
} while (0)

#define DMA_CHTDR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x13c4))

#define DMA_CHTDR5_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHTDR5_RGOFFADDR);\
} while (0)

#define DMA_CHTDR5_CURTDESAPTR_UDFRD(data) do {\
		DMA_CHTDR5_RGRD(data);\
} while (0)

#define DMA_CHTDR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1344))

#define DMA_CHTDR4_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHTDR4_RGOFFADDR);\
} while (0)

#define DMA_CHTDR4_CURTDESAPTR_UDFRD(data) do {\
		DMA_CHTDR4_RGRD(data);\
} while (0)

#define DMA_CHTDR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x12c4))

#define DMA_CHTDR3_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHTDR3_RGOFFADDR);\
} while (0)

#define DMA_CHTDR3_CURTDESAPTR_UDFRD(data) do {\
		DMA_CHTDR3_RGRD(data);\
} while (0)

#define DMA_CHTDR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1244))

#define DMA_CHTDR2_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHTDR2_RGOFFADDR);\
} while (0)

#define DMA_CHTDR2_CURTDESAPTR_UDFRD(data) do {\
		DMA_CHTDR2_RGRD(data);\
} while (0)

#define DMA_CHTDR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x11c4))

#define DMA_CHTDR1_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHTDR1_RGOFFADDR);\
} while (0)

#define DMA_CHTDR1_CURTDESAPTR_UDFRD(data) do {\
		DMA_CHTDR1_RGRD(data);\
} while (0)

#define DMA_CHTDR0_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1144))

#define DMA_CHTDR0_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CHTDR0_RGOFFADDR);\
} while (0)

#define DMA_CHTDR0_CURTDESAPTR_UDFRD(data) do {\
		DMA_CHTDR0_RGRD(data);\
} while (0)

#define DMA_SFCSR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x14bc))

#define DMA_SFCSR7_RGWR(data) do {\
		iowrite32(data, (void *)DMA_SFCSR7_RGOFFADDR);\
} while (0)

#define DMA_SFCSR7_RGRD(data) do {\
		(data) = ioread32((void *)DMA_SFCSR7_RGOFFADDR);\
} while (0)

/*#define  DMA_SFCSR7_Mask_2 (ULONG)(~(~0<<(14)))*/

#define  DMA_SFCSR7_MASK_2 (ULONG)(0x3fff)

/*#define DMA_SFCSR7_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(14)))<<(2)))*/

#define DMA_SFCSR7_RES_WR_MASK_2 (ULONG)(0xffff0003)

/*#define  DMA_SFCSR7_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_SFCSR7_MASK_20 (ULONG)(0xfff)

/*#define DMA_SFCSR7_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_SFCSR7_RES_WR_MASK_20 (ULONG)(0xfffff)

/*#define DMA_SFCSR7_ESC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR7_ESC_MASK (ULONG)(0x1)

/*#define DMA_SFCSR7_ESC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_SFCSR7_ESC_WR_MASK (ULONG)(0xfffffffe)

#define DMA_SFCSR7_ESC_UDFWR(data) do {\
		ULONG v;\
		DMA_SFCSR7_RGRD(v);\
		v = (v & (DMA_SFCSR7_RES_WR_MASK_2)) | (((0) & (DMA_SFCSR7_MASK_2)) << 2);\
		v = (v & (DMA_SFCSR7_RES_WR_MASK_20)) | (((0) & (DMA_SFCSR7_MASK_20)) << 20);\
		v = ((v & DMA_SFCSR7_ESC_WR_MASK) | ((data & DMA_SFCSR7_ESC_MASK) << 0));\
		DMA_SFCSR7_RGWR(v);\
} while (0)

#define DMA_SFCSR7_ESC_UDFRD(data) do {\
		DMA_SFCSR7_RGRD(data);\
		data = ((data >> 0) & DMA_SFCSR7_ESC_MASK);\
} while (0)

/*#define DMA_SFCSR7_ASC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR7_ASC_MASK (ULONG)(0x1)

/*#define DMA_SFCSR7_ASC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define DMA_SFCSR7_ASC_WR_MASK (ULONG)(0xfffffffd)

#define DMA_SFCSR7_ASC_UDFWR(data) do {\
		ULONG v;\
		DMA_SFCSR7_RGRD(v);\
		v = (v & (DMA_SFCSR7_RES_WR_MASK_2)) | (((0) & (DMA_SFCSR7_MASK_2)) << 2);\
		v = (v & (DMA_SFCSR7_RES_WR_MASK_20)) | (((0) & (DMA_SFCSR7_MASK_20)) << 20);\
		v = ((v & DMA_SFCSR7_ASC_WR_MASK) | ((data & DMA_SFCSR7_ASC_MASK) << 1));\
		DMA_SFCSR7_RGWR(v);\
} while (0)

#define DMA_SFCSR7_ASC_UDFRD(data) do {\
		DMA_SFCSR7_RGRD(data);\
		data = ((data >> 1) & DMA_SFCSR7_ASC_MASK);\
} while (0)

/*#define DMA_SFCSR7_RSN_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_SFCSR7_RSN_MASK (ULONG)(0xf)

#define DMA_SFCSR7_RSN_UDFRD(data) do {\
		DMA_SFCSR7_RGRD(data);\
		data = ((data >> 16) & DMA_SFCSR7_RSN_MASK);\
} while (0)

#define DMA_SFCSR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x143c))

#define DMA_SFCSR6_RGWR(data) do {\
		iowrite32(data, (void *)DMA_SFCSR6_RGOFFADDR);\
} while (0)

#define DMA_SFCSR6_RGRD(data) do {\
		(data) = ioread32((void *)DMA_SFCSR6_RGOFFADDR);\
} while (0)

/*#define  DMA_SFCSR6_Mask_2 (ULONG)(~(~0<<(14)))*/

#define  DMA_SFCSR6_MASK_2 (ULONG)(0x3fff)

/*#define DMA_SFCSR6_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(14)))<<(2)))*/

#define DMA_SFCSR6_RES_WR_MASK_2 (ULONG)(0xffff0003)

/*#define  DMA_SFCSR6_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_SFCSR6_MASK_20 (ULONG)(0xfff)

/*#define DMA_SFCSR6_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_SFCSR6_RES_WR_MASK_20 (ULONG)(0xfffff)

/*#define DMA_SFCSR6_ESC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR6_ESC_MASK (ULONG)(0x1)

/*#define DMA_SFCSR6_ESC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_SFCSR6_ESC_WR_MASK (ULONG)(0xfffffffe)

#define DMA_SFCSR6_ESC_UDFWR(data) do {\
		ULONG v;\
		DMA_SFCSR6_RGRD(v);\
		v = (v & (DMA_SFCSR6_RES_WR_MASK_2)) | (((0) & (DMA_SFCSR6_MASK_2)) << 2);\
		v = (v & (DMA_SFCSR6_RES_WR_MASK_20)) | (((0) & (DMA_SFCSR6_MASK_20)) << 20);\
		v = ((v & DMA_SFCSR6_ESC_WR_MASK) | ((data & DMA_SFCSR6_ESC_MASK) << 0));\
		DMA_SFCSR6_RGWR(v);\
} while (0)

#define DMA_SFCSR6_ESC_UDFRD(data) do {\
		DMA_SFCSR6_RGRD(data);\
		data = ((data >> 0) & DMA_SFCSR6_ESC_MASK);\
} while (0)

/*#define DMA_SFCSR6_ASC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR6_ASC_MASK (ULONG)(0x1)

/*#define DMA_SFCSR6_ASC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define DMA_SFCSR6_ASC_WR_MASK (ULONG)(0xfffffffd)

#define DMA_SFCSR6_ASC_UDFWR(data) do {\
		ULONG v;\
		DMA_SFCSR6_RGRD(v);\
		v = (v & (DMA_SFCSR6_RES_WR_MASK_2)) | (((0) & (DMA_SFCSR6_MASK_2)) << 2);\
		v = (v & (DMA_SFCSR6_RES_WR_MASK_20)) | (((0) & (DMA_SFCSR6_MASK_20)) << 20);\
		v = ((v & DMA_SFCSR6_ASC_WR_MASK) | ((data & DMA_SFCSR6_ASC_MASK) << 1));\
		DMA_SFCSR6_RGWR(v);\
} while (0)

#define DMA_SFCSR6_ASC_UDFRD(data) do {\
		DMA_SFCSR6_RGRD(data);\
		data = ((data >> 1) & DMA_SFCSR6_ASC_MASK);\
} while (0)

/*#define DMA_SFCSR6_RSN_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_SFCSR6_RSN_MASK (ULONG)(0xf)

#define DMA_SFCSR6_RSN_UDFRD(data) do {\
		DMA_SFCSR6_RGRD(data);\
		data = ((data >> 16) & DMA_SFCSR6_RSN_MASK);\
} while (0)

#define DMA_SFCSR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x13bc))

#define DMA_SFCSR5_RGWR(data) do {\
		iowrite32(data, (void *)DMA_SFCSR5_RGOFFADDR);\
} while (0)

#define DMA_SFCSR5_RGRD(data) do {\
		(data) = ioread32((void *)DMA_SFCSR5_RGOFFADDR);\
} while (0)

/*#define  DMA_SFCSR5_Mask_2 (ULONG)(~(~0<<(14)))*/

#define  DMA_SFCSR5_MASK_2 (ULONG)(0x3fff)

/*#define DMA_SFCSR5_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(14)))<<(2)))*/

#define DMA_SFCSR5_RES_WR_MASK_2 (ULONG)(0xffff0003)

/*#define  DMA_SFCSR5_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_SFCSR5_MASK_20 (ULONG)(0xfff)

/*#define DMA_SFCSR5_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_SFCSR5_RES_WR_MASK_20 (ULONG)(0xfffff)

/*#define DMA_SFCSR5_ESC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR5_ESC_MASK (ULONG)(0x1)

/*#define DMA_SFCSR5_ESC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_SFCSR5_ESC_WR_MASK (ULONG)(0xfffffffe)

#define DMA_SFCSR5_ESC_UDFWR(data) do {\
		ULONG v;\
		DMA_SFCSR5_RGRD(v);\
		v = (v & (DMA_SFCSR5_RES_WR_MASK_2)) | (((0) & (DMA_SFCSR5_MASK_2)) << 2);\
		v = (v & (DMA_SFCSR5_RES_WR_MASK_20)) | (((0) & (DMA_SFCSR5_MASK_20)) << 20);\
		v = ((v & DMA_SFCSR5_ESC_WR_MASK) | ((data & DMA_SFCSR5_ESC_MASK) << 0));\
		DMA_SFCSR5_RGWR(v);\
} while (0)

#define DMA_SFCSR5_ESC_UDFRD(data) do {\
		DMA_SFCSR5_RGRD(data);\
		data = ((data >> 0) & DMA_SFCSR5_ESC_MASK);\
} while (0)

/*#define DMA_SFCSR5_ASC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR5_ASC_MASK (ULONG)(0x1)

/*#define DMA_SFCSR5_ASC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define DMA_SFCSR5_ASC_WR_MASK (ULONG)(0xfffffffd)

#define DMA_SFCSR5_ASC_UDFWR(data) do {\
		ULONG v;\
		DMA_SFCSR5_RGRD(v);\
		v = (v & (DMA_SFCSR5_RES_WR_MASK_2)) | (((0) & (DMA_SFCSR5_MASK_2)) << 2);\
		v = (v & (DMA_SFCSR5_RES_WR_MASK_20)) | (((0) & (DMA_SFCSR5_MASK_20)) << 20);\
		v = ((v & DMA_SFCSR5_ASC_WR_MASK) | ((data & DMA_SFCSR5_ASC_MASK) << 1));\
		DMA_SFCSR5_RGWR(v);\
} while (0)

#define DMA_SFCSR5_ASC_UDFRD(data) do {\
		DMA_SFCSR5_RGRD(data);\
		data = ((data >> 1) & DMA_SFCSR5_ASC_MASK);\
} while (0)

/*#define DMA_SFCSR5_RSN_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_SFCSR5_RSN_MASK (ULONG)(0xf)

#define DMA_SFCSR5_RSN_UDFRD(data) do {\
		DMA_SFCSR5_RGRD(data);\
		data = ((data >> 16) & DMA_SFCSR5_RSN_MASK);\
} while (0)

#define DMA_SFCSR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x133c))

#define DMA_SFCSR4_RGWR(data) do {\
		iowrite32(data, (void *)DMA_SFCSR4_RGOFFADDR);\
} while (0)

#define DMA_SFCSR4_RGRD(data) do {\
		(data) = ioread32((void *)DMA_SFCSR4_RGOFFADDR);\
} while (0)

/*#define  DMA_SFCSR4_Mask_2 (ULONG)(~(~0<<(14)))*/

#define  DMA_SFCSR4_MASK_2 (ULONG)(0x3fff)

/*#define DMA_SFCSR4_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(14)))<<(2)))*/

#define DMA_SFCSR4_RES_WR_MASK_2 (ULONG)(0xffff0003)

/*#define  DMA_SFCSR4_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_SFCSR4_MASK_20 (ULONG)(0xfff)

/*#define DMA_SFCSR4_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_SFCSR4_RES_WR_MASK_20 (ULONG)(0xfffff)

/*#define DMA_SFCSR4_ESC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR4_ESC_MASK (ULONG)(0x1)

/*#define DMA_SFCSR4_ESC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_SFCSR4_ESC_WR_MASK (ULONG)(0xfffffffe)

#define DMA_SFCSR4_ESC_UDFWR(data) do {\
		ULONG v;\
		DMA_SFCSR4_RGRD(v);\
		v = (v & (DMA_SFCSR4_RES_WR_MASK_2)) | (((0) & (DMA_SFCSR4_MASK_2)) << 2);\
		v = (v & (DMA_SFCSR4_RES_WR_MASK_20)) | (((0) & (DMA_SFCSR4_MASK_20)) << 20);\
		v = ((v & DMA_SFCSR4_ESC_WR_MASK) | ((data & DMA_SFCSR4_ESC_MASK) << 0));\
		DMA_SFCSR4_RGWR(v);\
} while (0)

#define DMA_SFCSR4_ESC_UDFRD(data) do {\
		DMA_SFCSR4_RGRD(data);\
		data = ((data >> 0) & DMA_SFCSR4_ESC_MASK);\
} while (0)

/*#define DMA_SFCSR4_ASC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR4_ASC_MASK (ULONG)(0x1)

/*#define DMA_SFCSR4_ASC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define DMA_SFCSR4_ASC_WR_MASK (ULONG)(0xfffffffd)

#define DMA_SFCSR4_ASC_UDFWR(data) do {\
		ULONG v;\
		DMA_SFCSR4_RGRD(v);\
		v = (v & (DMA_SFCSR4_RES_WR_MASK_2)) | (((0) & (DMA_SFCSR4_MASK_2)) << 2);\
		v = (v & (DMA_SFCSR4_RES_WR_MASK_20)) | (((0) & (DMA_SFCSR4_MASK_20)) << 20);\
		v = ((v & DMA_SFCSR4_ASC_WR_MASK) | ((data & DMA_SFCSR4_ASC_MASK) << 1));\
		DMA_SFCSR4_RGWR(v);\
} while (0)

#define DMA_SFCSR4_ASC_UDFRD(data) do {\
		DMA_SFCSR4_RGRD(data);\
		data = ((data >> 1) & DMA_SFCSR4_ASC_MASK);\
} while (0)

/*#define DMA_SFCSR4_RSN_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_SFCSR4_RSN_MASK (ULONG)(0xf)

#define DMA_SFCSR4_RSN_UDFRD(data) do {\
		DMA_SFCSR4_RGRD(data);\
		data = ((data >> 16) & DMA_SFCSR4_RSN_MASK);\
} while (0)

#define DMA_SFCSR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x12bc))

#define DMA_SFCSR3_RGWR(data) do {\
		iowrite32(data, (void *)DMA_SFCSR3_RGOFFADDR);\
} while (0)

#define DMA_SFCSR3_RGRD(data) do {\
		(data) = ioread32((void *)DMA_SFCSR3_RGOFFADDR);\
} while (0)

/*#define  DMA_SFCSR3_Mask_2 (ULONG)(~(~0<<(14)))*/

#define  DMA_SFCSR3_MASK_2 (ULONG)(0x3fff)

/*#define DMA_SFCSR3_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(14)))<<(2)))*/

#define DMA_SFCSR3_RES_WR_MASK_2 (ULONG)(0xffff0003)

/*#define  DMA_SFCSR3_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_SFCSR3_MASK_20 (ULONG)(0xfff)

/*#define DMA_SFCSR3_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_SFCSR3_RES_WR_MASK_20 (ULONG)(0xfffff)

/*#define DMA_SFCSR3_ESC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR3_ESC_MASK (ULONG)(0x1)

/*#define DMA_SFCSR3_ESC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_SFCSR3_ESC_WR_MASK (ULONG)(0xfffffffe)

#define DMA_SFCSR3_ESC_UDFWR(data) do {\
		ULONG v;\
		DMA_SFCSR3_RGRD(v);\
		v = (v & (DMA_SFCSR3_RES_WR_MASK_2)) | (((0) & (DMA_SFCSR3_MASK_2)) << 2);\
		v = (v & (DMA_SFCSR3_RES_WR_MASK_20)) | (((0) & (DMA_SFCSR3_MASK_20)) << 20);\
		v = ((v & DMA_SFCSR3_ESC_WR_MASK) | ((data & DMA_SFCSR3_ESC_MASK) << 0));\
		DMA_SFCSR3_RGWR(v);\
} while (0)

#define DMA_SFCSR3_ESC_UDFRD(data) do {\
		DMA_SFCSR3_RGRD(data);\
		data = ((data >> 0) & DMA_SFCSR3_ESC_MASK);\
} while (0)

/*#define DMA_SFCSR3_ASC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR3_ASC_MASK (ULONG)(0x1)

/*#define DMA_SFCSR3_ASC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define DMA_SFCSR3_ASC_WR_MASK (ULONG)(0xfffffffd)

#define DMA_SFCSR3_ASC_UDFWR(data) do {\
		ULONG v;\
		DMA_SFCSR3_RGRD(v);\
		v = (v & (DMA_SFCSR3_RES_WR_MASK_2)) | (((0) & (DMA_SFCSR3_MASK_2)) << 2);\
		v = (v & (DMA_SFCSR3_RES_WR_MASK_20)) | (((0) & (DMA_SFCSR3_MASK_20)) << 20);\
		v = ((v & DMA_SFCSR3_ASC_WR_MASK) | ((data & DMA_SFCSR3_ASC_MASK) << 1));\
		DMA_SFCSR3_RGWR(v);\
} while (0)

#define DMA_SFCSR3_ASC_UDFRD(data) do {\
		DMA_SFCSR3_RGRD(data);\
		data = ((data >> 1) & DMA_SFCSR3_ASC_MASK);\
} while (0)

/*#define DMA_SFCSR3_RSN_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_SFCSR3_RSN_MASK (ULONG)(0xf)

#define DMA_SFCSR3_RSN_UDFRD(data) do {\
		DMA_SFCSR3_RGRD(data);\
		data = ((data >> 16) & DMA_SFCSR3_RSN_MASK);\
} while (0)

#define DMA_SFCSR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x123c))

#define DMA_SFCSR2_RGWR(data) do {\
		iowrite32(data, (void *)DMA_SFCSR2_RGOFFADDR);\
} while (0)

#define DMA_SFCSR2_RGRD(data) do {\
		(data) = ioread32((void *)DMA_SFCSR2_RGOFFADDR);\
} while (0)

/*#define  DMA_SFCSR2_Mask_2 (ULONG)(~(~0<<(14)))*/

#define  DMA_SFCSR2_MASK_2 (ULONG)(0x3fff)

/*#define DMA_SFCSR2_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(14)))<<(2)))*/

#define DMA_SFCSR2_RES_WR_MASK_2 (ULONG)(0xffff0003)

/*#define  DMA_SFCSR2_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_SFCSR2_MASK_20 (ULONG)(0xfff)

/*#define DMA_SFCSR2_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_SFCSR2_RES_WR_MASK_20 (ULONG)(0xfffff)

/*#define DMA_SFCSR2_ESC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR2_ESC_MASK (ULONG)(0x1)

/*#define DMA_SFCSR2_ESC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_SFCSR2_ESC_WR_MASK (ULONG)(0xfffffffe)

#define DMA_SFCSR2_ESC_UDFWR(data) do {\
		ULONG v;\
		DMA_SFCSR2_RGRD(v);\
		v = (v & (DMA_SFCSR2_RES_WR_MASK_2)) | (((0) & (DMA_SFCSR2_MASK_2)) << 2);\
		v = (v & (DMA_SFCSR2_RES_WR_MASK_20)) | (((0) & (DMA_SFCSR2_MASK_20)) << 20);\
		v = ((v & DMA_SFCSR2_ESC_WR_MASK) | ((data & DMA_SFCSR2_ESC_MASK) << 0));\
		DMA_SFCSR2_RGWR(v);\
} while (0)

#define DMA_SFCSR2_ESC_UDFRD(data) do {\
		DMA_SFCSR2_RGRD(data);\
		data = ((data >> 0) & DMA_SFCSR2_ESC_MASK);\
} while (0)

/*#define DMA_SFCSR2_ASC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR2_ASC_MASK (ULONG)(0x1)

/*#define DMA_SFCSR2_ASC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define DMA_SFCSR2_ASC_WR_MASK (ULONG)(0xfffffffd)

#define DMA_SFCSR2_ASC_UDFWR(data) do {\
		ULONG v;\
		DMA_SFCSR2_RGRD(v);\
		v = (v & (DMA_SFCSR2_RES_WR_MASK_2)) | (((0) & (DMA_SFCSR2_MASK_2)) << 2);\
		v = (v & (DMA_SFCSR2_RES_WR_MASK_20)) | (((0) & (DMA_SFCSR2_MASK_20)) << 20);\
		v = ((v & DMA_SFCSR2_ASC_WR_MASK) | ((data & DMA_SFCSR2_ASC_MASK) << 1));\
		DMA_SFCSR2_RGWR(v);\
} while (0)

#define DMA_SFCSR2_ASC_UDFRD(data) do {\
		DMA_SFCSR2_RGRD(data);\
		data = ((data >> 1) & DMA_SFCSR2_ASC_MASK);\
} while (0)

/*#define DMA_SFCSR2_RSN_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_SFCSR2_RSN_MASK (ULONG)(0xf)

#define DMA_SFCSR2_RSN_UDFRD(data) do {\
		DMA_SFCSR2_RGRD(data);\
		data = ((data >> 16) & DMA_SFCSR2_RSN_MASK);\
} while (0)

#define DMA_SFCSR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x11bc))

#define DMA_SFCSR1_RGWR(data) do {\
		iowrite32(data, (void *)DMA_SFCSR1_RGOFFADDR);\
} while (0)

#define DMA_SFCSR1_RGRD(data) do {\
		(data) = ioread32((void *)DMA_SFCSR1_RGOFFADDR);\
} while (0)

/*#define  DMA_SFCSR1_Mask_2 (ULONG)(~(~0<<(14)))*/

#define  DMA_SFCSR1_MASK_2 (ULONG)(0x3fff)

/*#define DMA_SFCSR1_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(14)))<<(2)))*/

#define DMA_SFCSR1_RES_WR_MASK_2 (ULONG)(0xffff0003)

/*#define  DMA_SFCSR1_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_SFCSR1_MASK_20 (ULONG)(0xfff)

/*#define DMA_SFCSR1_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_SFCSR1_RES_WR_MASK_20 (ULONG)(0xfffff)

/*#define DMA_SFCSR1_ESC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR1_ESC_MASK (ULONG)(0x1)

/*#define DMA_SFCSR1_ESC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_SFCSR1_ESC_WR_MASK (ULONG)(0xfffffffe)

#define DMA_SFCSR1_ESC_UDFWR(data) do {\
		ULONG v;\
		DMA_SFCSR1_RGRD(v);\
		v = (v & (DMA_SFCSR1_RES_WR_MASK_2)) | (((0) & (DMA_SFCSR1_MASK_2)) << 2);\
		v = (v & (DMA_SFCSR1_RES_WR_MASK_20)) | (((0) & (DMA_SFCSR1_MASK_20)) << 20);\
		v = ((v & DMA_SFCSR1_ESC_WR_MASK) | ((data & DMA_SFCSR1_ESC_MASK) << 0));\
		DMA_SFCSR1_RGWR(v);\
} while (0)

#define DMA_SFCSR1_ESC_UDFRD(data) do {\
		DMA_SFCSR1_RGRD(data);\
		data = ((data >> 0) & DMA_SFCSR1_ESC_MASK);\
} while (0)

/*#define DMA_SFCSR1_ASC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR1_ASC_MASK (ULONG)(0x1)

/*#define DMA_SFCSR1_ASC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define DMA_SFCSR1_ASC_WR_MASK (ULONG)(0xfffffffd)

#define DMA_SFCSR1_ASC_UDFWR(data) do {\
		ULONG v;\
		DMA_SFCSR1_RGRD(v);\
		v = (v & (DMA_SFCSR1_RES_WR_MASK_2)) | (((0) & (DMA_SFCSR1_MASK_2)) << 2);\
		v = (v & (DMA_SFCSR1_RES_WR_MASK_20)) | (((0) & (DMA_SFCSR1_MASK_20)) << 20);\
		v = ((v & DMA_SFCSR1_ASC_WR_MASK) | ((data & DMA_SFCSR1_ASC_MASK) << 1));\
		DMA_SFCSR1_RGWR(v);\
} while (0)

#define DMA_SFCSR1_ASC_UDFRD(data) do {\
		DMA_SFCSR1_RGRD(data);\
		data = ((data >> 1) & DMA_SFCSR1_ASC_MASK);\
} while (0)

/*#define DMA_SFCSR1_RSN_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_SFCSR1_RSN_MASK (ULONG)(0xf)

#define DMA_SFCSR1_RSN_UDFRD(data) do {\
		DMA_SFCSR1_RGRD(data);\
		data = ((data >> 16) & DMA_SFCSR1_RSN_MASK);\
} while (0)

#define DMA_SFCSR0_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x113c))

#define DMA_SFCSR0_RGWR(data) do {\
		iowrite32(data, (void *)DMA_SFCSR0_RGOFFADDR);\
} while (0)

#define DMA_SFCSR0_RGRD(data) do {\
		(data) = ioread32((void *)DMA_SFCSR0_RGOFFADDR);\
} while (0)

/*#define  DMA_SFCSR0_Mask_2 (ULONG)(~(~0<<(14)))*/

#define  DMA_SFCSR0_MASK_2 (ULONG)(0x3fff)

/*#define DMA_SFCSR0_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(14)))<<(2)))*/

#define DMA_SFCSR0_RES_WR_MASK_2 (ULONG)(0xffff0003)

/*#define  DMA_SFCSR0_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_SFCSR0_MASK_20 (ULONG)(0xfff)

/*#define DMA_SFCSR0_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_SFCSR0_RES_WR_MASK_20 (ULONG)(0xfffff)

/*#define DMA_SFCSR0_ESC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR0_ESC_MASK (ULONG)(0x1)

/*#define DMA_SFCSR0_ESC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_SFCSR0_ESC_WR_MASK (ULONG)(0xfffffffe)

#define DMA_SFCSR0_ESC_UDFWR(data) do {\
		ULONG v;\
		DMA_SFCSR0_RGRD(v);\
		v = (v & (DMA_SFCSR0_RES_WR_MASK_2)) | (((0) & (DMA_SFCSR0_MASK_2)) << 2);\
		v = (v & (DMA_SFCSR0_RES_WR_MASK_20)) | (((0) & (DMA_SFCSR0_MASK_20)) << 20);\
		v = ((v & DMA_SFCSR0_ESC_WR_MASK) | ((data & DMA_SFCSR0_ESC_MASK) << 0));\
		DMA_SFCSR0_RGWR(v);\
} while (0)

#define DMA_SFCSR0_ESC_UDFRD(data) do {\
		DMA_SFCSR0_RGRD(data);\
		data = ((data >> 0) & DMA_SFCSR0_ESC_MASK);\
} while (0)

/*#define DMA_SFCSR0_ASC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR0_ASC_MASK (ULONG)(0x1)

/*#define DMA_SFCSR0_ASC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define DMA_SFCSR0_ASC_WR_MASK (ULONG)(0xfffffffd)

#define DMA_SFCSR0_ASC_UDFWR(data) do {\
		ULONG v;\
		DMA_SFCSR0_RGRD(v);\
		v = (v & (DMA_SFCSR0_RES_WR_MASK_2)) | (((0) & (DMA_SFCSR0_MASK_2)) << 2);\
		v = (v & (DMA_SFCSR0_RES_WR_MASK_20)) | (((0) & (DMA_SFCSR0_MASK_20)) << 20);\
		v = ((v & DMA_SFCSR0_ASC_WR_MASK) | ((data & DMA_SFCSR0_ASC_MASK) << 1));\
		DMA_SFCSR0_RGWR(v);\
} while (0)

#define DMA_SFCSR0_ASC_UDFRD(data) do {\
		DMA_SFCSR0_RGRD(data);\
		data = ((data >> 1) & DMA_SFCSR0_ASC_MASK);\
} while (0)

/*#define DMA_SFCSR0_RSN_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_SFCSR0_RSN_MASK (ULONG)(0xf)

#define DMA_SFCSR0_RSN_UDFRD(data) do {\
		DMA_SFCSR0_RGRD(data);\
		data = ((data >> 16) & DMA_SFCSR0_RSN_MASK);\
} while (0)

#define MAC_IVLANTIRR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x64))

#define MAC_IVLANTIRR_RGWR(data) do {\
		iowrite32(data, (void *)MAC_IVLANTIRR_RGOFFADDR);\
} while (0)

#define MAC_IVLANTIRR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_IVLANTIRR_RGOFFADDR);\
} while (0)

/*#define  MAC_IVLANTIRR_Mask_21 (ULONG)(~(~0<<(11)))*/

#define  MAC_IVLANTIRR_MASK_21 (ULONG)(0x7ff)

/*#define MAC_IVLANTIRR_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(11)))<<(21)))*/

#define MAC_IVLANTIRR_RES_WR_MASK_21 (ULONG)(0x1fffff)

/*#define MAC_IVLANTIRR_VLTI_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_IVLANTIRR_VLTI_MASK (ULONG)(0x1)

/*#define MAC_IVLANTIRR_VLTI_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MAC_IVLANTIRR_VLTI_WR_MASK (ULONG)(0xffefffff)

#define MAC_IVLANTIRR_VLTI_UDFWR(data) do {\
		ULONG v;\
		MAC_IVLANTIRR_RGRD(v);\
		v = (v & (MAC_IVLANTIRR_RES_WR_MASK_21)) | (((0) & (MAC_IVLANTIRR_MASK_21)) << 21);\
		v = ((v & MAC_IVLANTIRR_VLTI_WR_MASK) | ((data & MAC_IVLANTIRR_VLTI_MASK) << 20));\
		MAC_IVLANTIRR_RGWR(v);\
} while (0)

#define MAC_IVLANTIRR_VLTI_UDFRD(data) do {\
		MAC_IVLANTIRR_RGRD(data);\
		data = ((data >> 20) & MAC_IVLANTIRR_VLTI_MASK);\
} while (0)

/*#define MAC_IVLANTIRR_CSVL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_IVLANTIRR_CSVL_MASK (ULONG)(0x1)

/*#define MAC_IVLANTIRR_CSVL_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MAC_IVLANTIRR_CSVL_WR_MASK (ULONG)(0xfff7ffff)

#define MAC_IVLANTIRR_CSVL_UDFWR(data) do {\
		ULONG v;\
		MAC_IVLANTIRR_RGRD(v);\
		v = (v & (MAC_IVLANTIRR_RES_WR_MASK_21)) | (((0) & (MAC_IVLANTIRR_MASK_21)) << 21);\
		v = ((v & MAC_IVLANTIRR_CSVL_WR_MASK) | ((data & MAC_IVLANTIRR_CSVL_MASK) << 19));\
		MAC_IVLANTIRR_RGWR(v);\
} while (0)

#define MAC_IVLANTIRR_CSVL_UDFRD(data) do {\
		MAC_IVLANTIRR_RGRD(data);\
		data = ((data >> 19) & MAC_IVLANTIRR_CSVL_MASK);\
} while (0)

/*#define MAC_IVLANTIRR_VLP_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_IVLANTIRR_VLP_MASK (ULONG)(0x1)

/*#define MAC_IVLANTIRR_VLP_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MAC_IVLANTIRR_VLP_WR_MASK (ULONG)(0xfffbffff)

#define MAC_IVLANTIRR_VLP_UDFWR(data) do {\
		ULONG v;\
		MAC_IVLANTIRR_RGRD(v);\
		v = (v & (MAC_IVLANTIRR_RES_WR_MASK_21)) | (((0) & (MAC_IVLANTIRR_MASK_21)) << 21);\
		v = ((v & MAC_IVLANTIRR_VLP_WR_MASK) | ((data & MAC_IVLANTIRR_VLP_MASK) << 18));\
		MAC_IVLANTIRR_RGWR(v);\
} while (0)

#define MAC_IVLANTIRR_VLP_UDFRD(data) do {\
		MAC_IVLANTIRR_RGRD(data);\
		data = ((data >> 18) & MAC_IVLANTIRR_VLP_MASK);\
} while (0)

/*#define MAC_IVLANTIRR_VLC_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_IVLANTIRR_VLC_MASK (ULONG)(0x3)

/*#define MAC_IVLANTIRR_VLC_Wr_Mask (ULONG)(~((~(~0 << (2))) << (16)))*/

#define MAC_IVLANTIRR_VLC_WR_MASK (ULONG)(0xfffcffff)

#define MAC_IVLANTIRR_VLC_UDFWR(data) do {\
		ULONG v;\
		MAC_IVLANTIRR_RGRD(v);\
		v = (v & (MAC_IVLANTIRR_RES_WR_MASK_21)) | (((0) & (MAC_IVLANTIRR_MASK_21)) << 21);\
		v = ((v & MAC_IVLANTIRR_VLC_WR_MASK) | ((data & MAC_IVLANTIRR_VLC_MASK) << 16));\
		MAC_IVLANTIRR_RGWR(v);\
} while (0)

#define MAC_IVLANTIRR_VLC_UDFRD(data) do {\
		MAC_IVLANTIRR_RGRD(data);\
		data = ((data >> 16) & MAC_IVLANTIRR_VLC_MASK);\
} while (0)

/*#define MAC_IVLANTIRR_VLT_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_IVLANTIRR_VLT_MASK (ULONG)(0xffff)

/*#define MAC_IVLANTIRR_VLT_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_IVLANTIRR_VLT_WR_MASK (ULONG)(0xffff0000)

#define MAC_IVLANTIRR_VLT_UDFWR(data) do {\
		ULONG v;\
		MAC_IVLANTIRR_RGRD(v);\
		v = (v & (MAC_IVLANTIRR_RES_WR_MASK_21)) | (((0) & (MAC_IVLANTIRR_MASK_21)) << 21);\
		v = ((v & MAC_IVLANTIRR_VLT_WR_MASK) | ((data & MAC_IVLANTIRR_VLT_MASK) << 0));\
		MAC_IVLANTIRR_RGWR(v);\
} while (0)

#define MAC_IVLANTIRR_VLT_UDFRD(data) do {\
		MAC_IVLANTIRR_RGRD(data);\
		data = ((data >> 0) & MAC_IVLANTIRR_VLT_MASK);\
} while (0)

#define MAC_VLANTIRR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x60))

#define MAC_VLANTIRR_RGWR(data) do {\
		iowrite32(data, (void *)MAC_VLANTIRR_RGOFFADDR);\
} while (0)

#define MAC_VLANTIRR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_VLANTIRR_RGOFFADDR);\
} while (0)

/*#define  MAC_VLANTIRR_Mask_21 (ULONG)(~(~0<<(11)))*/

#define  MAC_VLANTIRR_MASK_21 (ULONG)(0x7ff)

/*#define MAC_VLANTIRR_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(11)))<<(21)))*/

#define MAC_VLANTIRR_RES_WR_MASK_21 (ULONG)(0x1fffff)

/*#define MAC_VLANTIRR_VLTI_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_VLANTIRR_VLTI_MASK (ULONG)(0x1)

/*#define MAC_VLANTIRR_VLTI_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MAC_VLANTIRR_VLTI_WR_MASK (ULONG)(0xffefffff)

#define MAC_VLANTIRR_VLTI_UDFWR(data) do {\
		ULONG v;\
		MAC_VLANTIRR_RGRD(v);\
		v = (v & (MAC_VLANTIRR_RES_WR_MASK_21)) | (((0) & (MAC_VLANTIRR_MASK_21)) << 21);\
		v = ((v & MAC_VLANTIRR_VLTI_WR_MASK) | ((data & MAC_VLANTIRR_VLTI_MASK) << 20));\
		MAC_VLANTIRR_RGWR(v);\
} while (0)

#define MAC_VLANTIRR_VLTI_UDFRD(data) do {\
		MAC_VLANTIRR_RGRD(data);\
		data = ((data >> 20) & MAC_VLANTIRR_VLTI_MASK);\
} while (0)

/*#define MAC_VLANTIRR_CSVL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_VLANTIRR_CSVL_MASK (ULONG)(0x1)

/*#define MAC_VLANTIRR_CSVL_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MAC_VLANTIRR_CSVL_WR_MASK (ULONG)(0xfff7ffff)

#define MAC_VLANTIRR_CSVL_UDFWR(data) do {\
		ULONG v;\
		MAC_VLANTIRR_RGRD(v);\
		v = (v & (MAC_VLANTIRR_RES_WR_MASK_21)) | (((0) & (MAC_VLANTIRR_MASK_21)) << 21);\
		v = ((v & MAC_VLANTIRR_CSVL_WR_MASK) | ((data & MAC_VLANTIRR_CSVL_MASK) << 19));\
		MAC_VLANTIRR_RGWR(v);\
} while (0)

#define MAC_VLANTIRR_CSVL_UDFRD(data) do {\
		MAC_VLANTIRR_RGRD(data);\
		data = ((data >> 19) & MAC_VLANTIRR_CSVL_MASK);\
} while (0)

/*#define MAC_VLANTIRR_VLP_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_VLANTIRR_VLP_MASK (ULONG)(0x1)

/*#define MAC_VLANTIRR_VLP_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MAC_VLANTIRR_VLP_WR_MASK (ULONG)(0xfffbffff)

#define MAC_VLANTIRR_VLP_UDFWR(data) do {\
		ULONG v;\
		MAC_VLANTIRR_RGRD(v);\
		v = (v & (MAC_VLANTIRR_RES_WR_MASK_21)) | (((0) & (MAC_VLANTIRR_MASK_21)) << 21);\
		v = ((v & MAC_VLANTIRR_VLP_WR_MASK) | ((data & MAC_VLANTIRR_VLP_MASK) << 18));\
		MAC_VLANTIRR_RGWR(v);\
} while (0)

#define MAC_VLANTIRR_VLP_UDFRD(data) do {\
		MAC_VLANTIRR_RGRD(data);\
		data = ((data >> 18) & MAC_VLANTIRR_VLP_MASK);\
} while (0)

/*#define MAC_VLANTIRR_VLC_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_VLANTIRR_VLC_MASK (ULONG)(0x3)

/*#define MAC_VLANTIRR_VLC_Wr_Mask (ULONG)(~((~(~0 << (2))) << (16)))*/

#define MAC_VLANTIRR_VLC_WR_MASK (ULONG)(0xfffcffff)

#define MAC_VLANTIRR_VLC_UDFWR(data) do {\
		ULONG v;\
		MAC_VLANTIRR_RGRD(v);\
		v = (v & (MAC_VLANTIRR_RES_WR_MASK_21)) | (((0) & (MAC_VLANTIRR_MASK_21)) << 21);\
		v = ((v & MAC_VLANTIRR_VLC_WR_MASK) | ((data & MAC_VLANTIRR_VLC_MASK) << 16));\
		MAC_VLANTIRR_RGWR(v);\
} while (0)

#define MAC_VLANTIRR_VLC_UDFRD(data) do {\
		MAC_VLANTIRR_RGRD(data);\
		data = ((data >> 16) & MAC_VLANTIRR_VLC_MASK);\
} while (0)

/*#define MAC_VLANTIRR_VLT_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_VLANTIRR_VLT_MASK (ULONG)(0xffff)

/*#define MAC_VLANTIRR_VLT_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_VLANTIRR_VLT_WR_MASK (ULONG)(0xffff0000)

#define MAC_VLANTIRR_VLT_UDFWR(data) do {\
		ULONG v;\
		MAC_VLANTIRR_RGRD(v);\
		v = (v & (MAC_VLANTIRR_RES_WR_MASK_21)) | (((0) & (MAC_VLANTIRR_MASK_21)) << 21);\
		v = ((v & MAC_VLANTIRR_VLT_WR_MASK) | ((data & MAC_VLANTIRR_VLT_MASK) << 0));\
		MAC_VLANTIRR_RGWR(v);\
} while (0)

#define MAC_VLANTIRR_VLT_UDFRD(data) do {\
		MAC_VLANTIRR_RGRD(data);\
		data = ((data >> 0) & MAC_VLANTIRR_VLT_MASK);\
} while (0)

#define MAC_VLANHTR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x58))

#define MAC_VLANHTR_RGWR(data) do {\
		iowrite32(data, (void *)MAC_VLANHTR_RGOFFADDR);\
} while (0)

#define MAC_VLANHTR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_VLANHTR_RGOFFADDR);\
} while (0)

/*#define  MAC_VLANHTR_Mask_16 (ULONG)(~(~0<<(16)))*/

#define  MAC_VLANHTR_MASK_16 (ULONG)(0xffff)

/*#define MAC_VLANHTR_RES_Wr_Mask_16 (ULONG)(~((~(~0<<(16)))<<(16)))*/

#define MAC_VLANHTR_RES_WR_MASK_16 (ULONG)(0xffff)

/*#define MAC_VLANHTR_VLHT_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_VLANHTR_VLHT_MASK (ULONG)(0xffff)

/*#define MAC_VLANHTR_VLHT_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_VLANHTR_VLHT_WR_MASK (ULONG)(0xffff0000)

#define MAC_VLANHTR_VLHT_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MAC_VLANHTR_RES_WR_MASK_16)) | (((0) & (MAC_VLANHTR_MASK_16)) << 16);\
		(v) = ((v & MAC_VLANHTR_VLHT_WR_MASK) | ((data & MAC_VLANHTR_VLHT_MASK) << 0));\
		MAC_VLANHTR_RGWR(v);\
} while (0)

#define MAC_VLANHTR_VLHT_UDFRD(data) do {\
		MAC_VLANHTR_RGRD(data);\
		data = ((data >> 0) & MAC_VLANHTR_VLHT_MASK);\
} while (0)

#define MAC_VLANTR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x50))

#define MAC_VLANTR_RGWR(data) do {\
		iowrite32(data, (void *)MAC_VLANTR_RGOFFADDR);\
} while (0)

#define MAC_VLANTR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_VLANTR_RGOFFADDR);\
} while (0)

/*#define  MAC_VLANTR_Mask_30 (ULONG)(~(~0<<(1)))*/

#define  MAC_VLANTR_MASK_30 (ULONG)(0x1)

/*#define MAC_VLANTR_RES_Wr_Mask_30 (ULONG)(~((~(~0<<(1)))<<(30)))*/

#define MAC_VLANTR_RES_WR_MASK_30 (ULONG)(0xbfffffff)

/*#define  MAC_VLANTR_Mask_23 (ULONG)(~(~0<<(1)))*/

#define  MAC_VLANTR_MASK_23 (ULONG)(0x1)

/*#define MAC_VLANTR_RES_Wr_Mask_23 (ULONG)(~((~(~0<<(1)))<<(23)))*/

#define MAC_VLANTR_RES_WR_MASK_23 (ULONG)(0xff7fffff)

/*#define MAC_VLANTR_EIVLRXS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_VLANTR_EIVLRXS_MASK (ULONG)(0x1)

/*#define MAC_VLANTR_EIVLRXS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (31)))*/

#define MAC_VLANTR_EIVLRXS_WR_MASK (ULONG)(0x7fffffff)

#define MAC_VLANTR_EIVLRXS_UDFWR(data) do {\
		ULONG v;\
		MAC_VLANTR_RGRD(v);\
		v = (v & (MAC_VLANTR_RES_WR_MASK_30)) | (((0) & (MAC_VLANTR_MASK_30)) << 30);\
		v = (v & (MAC_VLANTR_RES_WR_MASK_23)) | (((0) & (MAC_VLANTR_MASK_23)) << 23);\
		v = ((v & MAC_VLANTR_EIVLRXS_WR_MASK) | ((data & MAC_VLANTR_EIVLRXS_MASK) << 31));\
		MAC_VLANTR_RGWR(v);\
} while (0)

#define MAC_VLANTR_EIVLRXS_UDFRD(data) do {\
		MAC_VLANTR_RGRD(data);\
		data = ((data >> 31) & MAC_VLANTR_EIVLRXS_MASK);\
} while (0)

/*#define MAC_VLANTR_EIVLS_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_VLANTR_EIVLS_MASK (ULONG)(0x3)

/*#define MAC_VLANTR_EIVLS_Wr_Mask (ULONG)(~((~(~0 << (2))) << (28)))*/

#define MAC_VLANTR_EIVLS_WR_MASK (ULONG)(0xcfffffff)

#define MAC_VLANTR_EIVLS_UDFWR(data) do {\
		ULONG v;\
		MAC_VLANTR_RGRD(v);\
		v = (v & (MAC_VLANTR_RES_WR_MASK_30)) | (((0) & (MAC_VLANTR_MASK_30)) << 30);\
		v = (v & (MAC_VLANTR_RES_WR_MASK_23)) | (((0) & (MAC_VLANTR_MASK_23)) << 23);\
		v = ((v & MAC_VLANTR_EIVLS_WR_MASK) | ((data & MAC_VLANTR_EIVLS_MASK) << 28));\
		MAC_VLANTR_RGWR(v);\
} while (0)

#define MAC_VLANTR_EIVLS_UDFRD(data) do {\
		MAC_VLANTR_RGRD(data);\
		data = ((data >> 28) & MAC_VLANTR_EIVLS_MASK);\
} while (0)

/*#define MAC_VLANTR_ERIVLT_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_VLANTR_ERIVLT_MASK (ULONG)(0x1)

/*#define MAC_VLANTR_ERIVLT_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define MAC_VLANTR_ERIVLT_WR_MASK (ULONG)(0xf7ffffff)

#define MAC_VLANTR_ERIVLT_UDFWR(data) do {\
		ULONG v;\
		MAC_VLANTR_RGRD(v);\
		v = (v & (MAC_VLANTR_RES_WR_MASK_30)) | (((0) & (MAC_VLANTR_MASK_30)) << 30);\
		v = (v & (MAC_VLANTR_RES_WR_MASK_23)) | (((0) & (MAC_VLANTR_MASK_23)) << 23);\
		v = ((v & MAC_VLANTR_ERIVLT_WR_MASK) | ((data & MAC_VLANTR_ERIVLT_MASK) << 27));\
		MAC_VLANTR_RGWR(v);\
} while (0)

#define MAC_VLANTR_ERIVLT_UDFRD(data) do {\
		MAC_VLANTR_RGRD(data);\
		data = ((data >> 27) & MAC_VLANTR_ERIVLT_MASK);\
} while (0)

/*#define MAC_VLANTR_EDVLP_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_VLANTR_EDVLP_MASK (ULONG)(0x1)

/*#define MAC_VLANTR_EDVLP_Wr_Mask (ULONG)(~((~(~0 << (1))) << (26)))*/

#define MAC_VLANTR_EDVLP_WR_MASK (ULONG)(0xfbffffff)

#define MAC_VLANTR_EDVLP_UDFWR(data) do {\
		ULONG v;\
		MAC_VLANTR_RGRD(v);\
		v = (v & (MAC_VLANTR_RES_WR_MASK_30)) | (((0) & (MAC_VLANTR_MASK_30)) << 30);\
		v = (v & (MAC_VLANTR_RES_WR_MASK_23)) | (((0) & (MAC_VLANTR_MASK_23)) << 23);\
		v = ((v & MAC_VLANTR_EDVLP_WR_MASK) | ((data & MAC_VLANTR_EDVLP_MASK) << 26));\
		MAC_VLANTR_RGWR(v);\
} while (0)

#define MAC_VLANTR_EDVLP_UDFRD(data) do {\
		MAC_VLANTR_RGRD(data);\
		data = ((data >> 26) & MAC_VLANTR_EDVLP_MASK);\
} while (0)

/*#define MAC_VLANTR_VTHM_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_VLANTR_VTHM_MASK (ULONG)(0x1)

/*#define MAC_VLANTR_VTHM_Wr_Mask (ULONG)(~((~(~0 << (1))) << (25)))*/

#define MAC_VLANTR_VTHM_WR_MASK (ULONG)(0xfdffffff)

#define MAC_VLANTR_VTHM_UDFWR(data) do {\
		ULONG v;\
		MAC_VLANTR_RGRD(v);\
		v = (v & (MAC_VLANTR_RES_WR_MASK_30)) | (((0) & (MAC_VLANTR_MASK_30)) << 30);\
		v = (v & (MAC_VLANTR_RES_WR_MASK_23)) | (((0) & (MAC_VLANTR_MASK_23)) << 23);\
		v = ((v & MAC_VLANTR_VTHM_WR_MASK) | ((data & MAC_VLANTR_VTHM_MASK) << 25));\
		MAC_VLANTR_RGWR(v);\
} while (0)

#define MAC_VLANTR_VTHM_UDFRD(data) do {\
		MAC_VLANTR_RGRD(data);\
		data = ((data >> 25) & MAC_VLANTR_VTHM_MASK);\
} while (0)

/*#define MAC_VLANTR_EVLRXS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_VLANTR_EVLRXS_MASK (ULONG)(0x1)

/*#define MAC_VLANTR_EVLRXS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define MAC_VLANTR_EVLRXS_WR_MASK (ULONG)(0xfeffffff)

#define MAC_VLANTR_EVLRXS_UDFWR(data) do {\
		ULONG v;\
		MAC_VLANTR_RGRD(v);\
		v = (v & (MAC_VLANTR_RES_WR_MASK_30)) | (((0) & (MAC_VLANTR_MASK_30)) << 30);\
		v = (v & (MAC_VLANTR_RES_WR_MASK_23)) | (((0) & (MAC_VLANTR_MASK_23)) << 23);\
		v = ((v & MAC_VLANTR_EVLRXS_WR_MASK) | ((data & MAC_VLANTR_EVLRXS_MASK) << 24));\
		MAC_VLANTR_RGWR(v);\
} while (0)

#define MAC_VLANTR_EVLRXS_UDFRD(data) do {\
		MAC_VLANTR_RGRD(data);\
		data = ((data >> 24) & MAC_VLANTR_EVLRXS_MASK);\
} while (0)

/*#define MAC_VLANTR_EVLS_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_VLANTR_EVLS_MASK (ULONG)(0x3)

/*#define MAC_VLANTR_EVLS_Wr_Mask (ULONG)(~((~(~0 << (2))) << (21)))*/

#define MAC_VLANTR_EVLS_WR_MASK (ULONG)(0xff9fffff)

#define MAC_VLANTR_EVLS_UDFWR(data) do {\
		ULONG v;\
		MAC_VLANTR_RGRD(v);\
		v = (v & (MAC_VLANTR_RES_WR_MASK_30)) | (((0) & (MAC_VLANTR_MASK_30)) << 30);\
		v = (v & (MAC_VLANTR_RES_WR_MASK_23)) | (((0) & (MAC_VLANTR_MASK_23)) << 23);\
		v = ((v & MAC_VLANTR_EVLS_WR_MASK) | ((data & MAC_VLANTR_EVLS_MASK) << 21));\
		MAC_VLANTR_RGWR(v);\
} while (0)

#define MAC_VLANTR_EVLS_UDFRD(data) do {\
		MAC_VLANTR_RGRD(data);\
		data = ((data >> 21) & MAC_VLANTR_EVLS_MASK);\
} while (0)

/*#define MAC_VLANTR_DOVLTC_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_VLANTR_DOVLTC_MASK (ULONG)(0x1)

/*#define MAC_VLANTR_DOVLTC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MAC_VLANTR_DOVLTC_WR_MASK (ULONG)(0xffefffff)

#define MAC_VLANTR_DOVLTC_UDFWR(data) do {\
		ULONG v;\
		MAC_VLANTR_RGRD(v);\
		v = (v & (MAC_VLANTR_RES_WR_MASK_30)) | (((0) & (MAC_VLANTR_MASK_30)) << 30);\
		v = (v & (MAC_VLANTR_RES_WR_MASK_23)) | (((0) & (MAC_VLANTR_MASK_23)) << 23);\
		v = ((v & MAC_VLANTR_DOVLTC_WR_MASK) | ((data & MAC_VLANTR_DOVLTC_MASK) << 20));\
		MAC_VLANTR_RGWR(v);\
} while (0)

#define MAC_VLANTR_DOVLTC_UDFRD(data) do {\
		MAC_VLANTR_RGRD(data);\
		data = ((data >> 20) & MAC_VLANTR_DOVLTC_MASK);\
} while (0)

/*#define MAC_VLANTR_ERSVLM_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_VLANTR_ERSVLM_MASK (ULONG)(0x1)

/*#define MAC_VLANTR_ERSVLM_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MAC_VLANTR_ERSVLM_WR_MASK (ULONG)(0xfff7ffff)

#define MAC_VLANTR_ERSVLM_UDFWR(data) do {\
		ULONG v;\
		MAC_VLANTR_RGRD(v);\
		v = (v & (MAC_VLANTR_RES_WR_MASK_30)) | (((0) & (MAC_VLANTR_MASK_30)) << 30);\
		v = (v & (MAC_VLANTR_RES_WR_MASK_23)) | (((0) & (MAC_VLANTR_MASK_23)) << 23);\
		v = ((v & MAC_VLANTR_ERSVLM_WR_MASK) | ((data & MAC_VLANTR_ERSVLM_MASK) << 19));\
		MAC_VLANTR_RGWR(v);\
} while (0)

#define MAC_VLANTR_ERSVLM_UDFRD(data) do {\
		MAC_VLANTR_RGRD(data);\
		data = ((data >> 19) & MAC_VLANTR_ERSVLM_MASK);\
} while (0)

/*#define MAC_VLANTR_ESVL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_VLANTR_ESVL_MASK (ULONG)(0x1)

/*#define MAC_VLANTR_ESVL_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MAC_VLANTR_ESVL_WR_MASK (ULONG)(0xfffbffff)

#define MAC_VLANTR_ESVL_UDFWR(data) do {\
		ULONG v;\
		MAC_VLANTR_RGRD(v);\
		v = (v & (MAC_VLANTR_RES_WR_MASK_30)) | (((0) & (MAC_VLANTR_MASK_30)) << 30);\
		v = (v & (MAC_VLANTR_RES_WR_MASK_23)) | (((0) & (MAC_VLANTR_MASK_23)) << 23);\
		v = ((v & MAC_VLANTR_ESVL_WR_MASK) | ((data & MAC_VLANTR_ESVL_MASK) << 18));\
		MAC_VLANTR_RGWR(v);\
} while (0)

#define MAC_VLANTR_ESVL_UDFRD(data) do {\
		MAC_VLANTR_RGRD(data);\
		data = ((data >> 18) & MAC_VLANTR_ESVL_MASK);\
} while (0)

/*#define MAC_VLANTR_VTIM_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_VLANTR_VTIM_MASK (ULONG)(0x1)

/*#define MAC_VLANTR_VTIM_Wr_Mask (ULONG)(~((~(~0 << (1))) << (17)))*/

#define MAC_VLANTR_VTIM_WR_MASK (ULONG)(0xfffdffff)

#define MAC_VLANTR_VTIM_UDFWR(data) do {\
		ULONG v;\
		MAC_VLANTR_RGRD(v);\
		v = (v & (MAC_VLANTR_RES_WR_MASK_30)) | (((0) & (MAC_VLANTR_MASK_30)) << 30);\
		v = (v & (MAC_VLANTR_RES_WR_MASK_23)) | (((0) & (MAC_VLANTR_MASK_23)) << 23);\
		v = ((v & MAC_VLANTR_VTIM_WR_MASK) | ((data & MAC_VLANTR_VTIM_MASK) << 17));\
		MAC_VLANTR_RGWR(v);\
} while (0)

#define MAC_VLANTR_VTIM_UDFRD(data) do {\
		MAC_VLANTR_RGRD(data);\
		data = ((data >> 17) & MAC_VLANTR_VTIM_MASK);\
} while (0)

/*#define MAC_VLANTR_ETV_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_VLANTR_ETV_MASK (ULONG)(0x1)

/*#define MAC_VLANTR_ETV_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MAC_VLANTR_ETV_WR_MASK (ULONG)(0xfffeffff)

#define MAC_VLANTR_ETV_UDFWR(data) do {\
		ULONG v;\
		MAC_VLANTR_RGRD(v);\
		v = (v & (MAC_VLANTR_RES_WR_MASK_30)) | (((0) & (MAC_VLANTR_MASK_30)) << 30);\
		v = (v & (MAC_VLANTR_RES_WR_MASK_23)) | (((0) & (MAC_VLANTR_MASK_23)) << 23);\
		v = ((v & MAC_VLANTR_ETV_WR_MASK) | ((data & MAC_VLANTR_ETV_MASK) << 16));\
		MAC_VLANTR_RGWR(v);\
} while (0)

#define MAC_VLANTR_ETV_UDFRD(data) do {\
		MAC_VLANTR_RGRD(data);\
		data = ((data >> 16) & MAC_VLANTR_ETV_MASK);\
} while (0)

/*#define MAC_VLANTR_VL_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_VLANTR_VL_MASK (ULONG)(0xffff)

/*#define MAC_VLANTR_VL_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_VLANTR_VL_WR_MASK (ULONG)(0xffff0000)

#define MAC_VLANTR_VL_UDFWR(data) do {\
		ULONG v;\
		MAC_VLANTR_RGRD(v);\
		v = (v & (MAC_VLANTR_RES_WR_MASK_30)) | (((0) & (MAC_VLANTR_MASK_30)) << 30);\
		v = (v & (MAC_VLANTR_RES_WR_MASK_23)) | (((0) & (MAC_VLANTR_MASK_23)) << 23);\
		v = ((v & MAC_VLANTR_VL_WR_MASK) | ((data & MAC_VLANTR_VL_MASK) << 0));\
		MAC_VLANTR_RGWR(v);\
} while (0)

#define MAC_VLANTR_VL_UDFRD(data) do {\
		MAC_VLANTR_RGRD(data);\
		data = ((data >> 0) & MAC_VLANTR_VL_MASK);\
} while (0)

#define MAC_VLANTR_OFS_MASK (ULONG)(0x1f)

#define MAC_VLANTR_OFS_WR_MASK (ULONG)(0xffffff83)

#define MAC_VLANTR_OFS_UDFWR(data) do {\
		ULONG v;\
		MAC_VLANTR_RGRD(v);\
		v = ((v & MAC_VLANTR_OFS_WR_MASK) | ((data & MAC_VLANTR_OFS_MASK) << 2));\
		MAC_VLANTR_RGWR(v);\
} while (0)

#define MAC_VLANTR_OFS_UDFRD(data) do {\
		MAC_VLANTR_RGRD(data);\
		data = ((data >> 2) & MAC_VLANTR_OFS_MASK);\
} while (0)

#define MAC_VLANTR_CT_MASK (ULONG)(0x1)

#define MAC_VLANTR_CT_WR_MASK (ULONG)(0xfffffffd)

#define MAC_VLANTR_CT_UDFWR(data) do {\
		ULONG v;\
		MAC_VLANTR_RGRD(v);\
		v = ((v & MAC_VLANTR_CT_WR_MASK) | ((data & MAC_VLANTR_CT_MASK) << 1));\
		MAC_VLANTR_RGWR(v);\
} while (0)

#define MAC_VLANTR_CT_UDFRD(data) do {\
		MAC_VLANTR_RGRD(data);\
		data = ((data >> 1) & MAC_VLANTR_CT_MASK);\
} while (0)

#define MAC_VLANTR_OB_MASK (ULONG)(0x1)

#define MAC_VLANTR_OB_WR_MASK (ULONG)(0xfffffffe)

#define MAC_VLANTR_OB_UDFWR(data) do {\
		ULONG v;\
		MAC_VLANTR_RGRD(v);\
		v = ((v & MAC_VLANTR_OB_WR_MASK) | ((data & MAC_VLANTR_OB_MASK) << 0));\
		MAC_VLANTR_RGWR(v);\
} while (0)

#define MAC_VLANTR_OB_UDFRD(data) do {\
		MAC_VLANTR_RGRD(data);\
		data = ((data >> 0) & MAC_VLANTR_OB_MASK);\
} while (0)


#define MAC_VLAN_TAG_DATA_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x54))

#define MAC_VLAN_TAG_DATA_RGWR(data) do {\
		iowrite32(data, (void *)MAC_VLAN_TAG_DATA_RGOFFADDR);\
} while (0)

#define MAC_VLAN_TAG_DATA_RGRD(data) do {\
		(data) = ioread32((void *)MAC_VLAN_TAG_DATA_RGOFFADDR);\
} while (0)

#define MAC_VLAN_TAG_DATA_18_MASK (ULONG)(0x1)

#define MAC_VLAN_TAG_DATA_18_WR_MASK (ULONG)(0xfffbffff)

#define MAC_VLAN_TAG_DATA_18_UDFWR(data) do {\
		ULONG v;\
		MAC_VLAN_TAG_DATA_RGRD(v);\
		v = ((v & MAC_VLAN_TAG_DATA_18_WR_MASK) | ((data & MAC_VLAN_TAG_DATA_18_MASK) << 18));\
		MAC_VLAN_TAG_DATA_RGWR(v);\
} while (0)

#define MAC_VLANTR_DATA_18_UDFRD(data) do {\
		MAC_VLAN_TAG_DATA_RGRD(data);\
		data = ((data >> 18) & MAC_VLAN_TAG_DATA_18_MASK);\
} while (0)

#define MAC_VLAN_TAG_DATA_17_MASK (ULONG)(0x1)

#define MAC_VLAN_TAG_DATA_17_WR_MASK (ULONG)(0xfffdffff)

#define MAC_VLAN_TAG_DATA_17_UDFWR(data) do {\
		ULONG v;\
		MAC_VLAN_TAG_DATA_RGRD(v);\
		v = ((v & MAC_VLAN_TAG_DATA_17_WR_MASK) | ((data & MAC_VLAN_TAG_DATA_17_MASK) << 17));\
		MAC_VLAN_TAG_DATA_RGWR(v);\
} while (0)

#define MAC_VLANTR_DATA_17_UDFRD(data) do {\
		MAC_VLAN_TAG_DATA_RGRD(data);\
		data = ((data >> 17) & MAC_VLAN_TAG_DATA_17_MASK);\
} while (0)

#define MAC_VLAN_TAG_DATA_16_MASK (ULONG)(0x1)

#define MAC_VLAN_TAG_DATA_16_WR_MASK (ULONG)(0xfffeffff)

#define MAC_VLAN_TAG_DATA_16_UDFWR(data) do {\
		ULONG v;\
		MAC_VLAN_TAG_DATA_RGRD(v);\
		v = ((v & MAC_VLAN_TAG_DATA_16_WR_MASK) | ((data & MAC_VLAN_TAG_DATA_16_MASK) << 16));\
		MAC_VLAN_TAG_DATA_RGWR(v);\
} while (0)

#define MAC_VLANTR_DATA_16_UDFRD(data) do {\
		MAC_VLAN_TAG_DATA_RGRD(data);\
		data = ((data >> 16) & MAC_VLAN_TAG_DATA_16_MASK);\
} while (0)

#define MAC_VLAN_TAG_DATA_15_0_MASK (ULONG)(0xffff)

#define MAC_VLAN_TAG_DATA_15_0_WR_MASK (ULONG)(0xffff0000)

#define MAC_VLAN_TAG_DATA_15_0_UDFWR(data) do {\
		ULONG v;\
		MAC_VLAN_TAG_DATA_RGRD(v);\
		v = ((v & MAC_VLAN_TAG_DATA_15_0_WR_MASK) | ((data & MAC_VLAN_TAG_DATA_15_0_MASK) << 0));\
		MAC_VLAN_TAG_DATA_RGWR(v);\
} while (0)

#define MAC_VLANTR_DATA_15_0_UDFRD(data) do {\
		MAC_VLAN_TAG_DATA_RGRD(data);\
		data = ((data >> 0) & MAC_VLAN_TAG_DATA_15_0_MASK);\
} while (0)

#define DMA_SBUS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1004))

#define DMA_SBUS_RGWR(data) do {\
		iowrite32(data, (void *)DMA_SBUS_RGOFFADDR);\
} while (0)

#define DMA_SBUS_RGRD(data) do {\
		(data) = ioread32((void *)DMA_SBUS_RGOFFADDR);\
} while (0)

/*#define  DMA_SBUS_Mask_25 (ULONG)(~(~0<<(5)))*/

#define  DMA_SBUS_MASK_25 (ULONG)(0x1f)

/*#define DMA_SBUS_RES_Wr_Mask_25 (ULONG)(~((~(~0<<(5)))<<(25)))*/

#define DMA_SBUS_RES_WR_MASK_25 (ULONG)(0xc1ffffff)

/*#define  DMA_SBUS_Mask_20 (ULONG)(~(~0<<(1)))*/

#define  DMA_SBUS_MASK_20 (ULONG)(0x1)

/*#define DMA_SBUS_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(1)))<<(20)))*/

#define DMA_SBUS_RES_WR_MASK_20 (ULONG)(0xffefffff)

/*#define  DMA_SBUS_Mask_15 (ULONG)(~(~0<<(1)))*/

#define  DMA_SBUS_MASK_15 (ULONG)(0x1)

/*#define DMA_SBUS_RES_Wr_Mask_15 (ULONG)(~((~(~0<<(1)))<<(15)))*/

#define DMA_SBUS_RES_WR_MASK_15 (ULONG)(0xffff7fff)

/*#define  DMA_SBUS_Mask_8 (ULONG)(~(~0<<(4)))*/

#define  DMA_SBUS_MASK_8 (ULONG)(0xf)

/*#define DMA_SBUS_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(4)))<<(8)))*/

#define DMA_SBUS_RES_WR_MASK_8 (ULONG)(0xfffff0ff)

/*#define DMA_SBUS_EN_LPI_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SBUS_EN_LPI_MASK (ULONG)(0x1)

/*#define DMA_SBUS_EN_LPI_Wr_Mask (ULONG)(~((~(~0 << (1))) << (31)))*/

#define DMA_SBUS_EN_LPI_WR_MASK (ULONG)(0x7fffffff)

#define DMA_SBUS_EN_LPI_UDFWR(data) do {\
		ULONG v;\
		DMA_SBUS_RGRD(v);\
		v = (v & (DMA_SBUS_RES_WR_MASK_25)) | (((0) & (DMA_SBUS_MASK_25)) << 25);\
		v = (v & (DMA_SBUS_RES_WR_MASK_20)) | (((0) & (DMA_SBUS_MASK_20)) << 20);\
		v = (v & (DMA_SBUS_RES_WR_MASK_15)) | (((0) & (DMA_SBUS_MASK_15)) << 15);\
		v = (v & (DMA_SBUS_RES_WR_MASK_8)) | (((0) & (DMA_SBUS_MASK_8)) << 8);\
		v = ((v & DMA_SBUS_EN_LPI_WR_MASK) | ((data & DMA_SBUS_EN_LPI_MASK) << 31));\
		DMA_SBUS_RGWR(v);\
} while (0)

#define DMA_SBUS_EN_LPI_UDFRD(data) do {\
		DMA_SBUS_RGRD(data);\
		data = ((data >> 31) & DMA_SBUS_EN_LPI_MASK);\
} while (0)

/*#define DMA_SBUS_LPI_XIT_PKT_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SBUS_LPI_XIT_PKT_MASK (ULONG)(0x1)

/*#define DMA_SBUS_LPI_XIT_PKT_Wr_Mask (ULONG)(~((~(~0 << (1))) << (30)))*/

#define DMA_SBUS_LPI_XIT_PKT_WR_MASK (ULONG)(0xbfffffff)

#define DMA_SBUS_LPI_XIT_PKT_UDFWR(data) do {\
		ULONG v;\
		DMA_SBUS_RGRD(v);\
		v = (v & (DMA_SBUS_RES_WR_MASK_25)) | (((0) & (DMA_SBUS_MASK_25)) << 25);\
		v = (v & (DMA_SBUS_RES_WR_MASK_20)) | (((0) & (DMA_SBUS_MASK_20)) << 20);\
		v = (v & (DMA_SBUS_RES_WR_MASK_15)) | (((0) & (DMA_SBUS_MASK_15)) << 15);\
		v = (v & (DMA_SBUS_RES_WR_MASK_8)) | (((0) & (DMA_SBUS_MASK_8)) << 8);\
		v = ((v & DMA_SBUS_LPI_XIT_PKT_WR_MASK) | ((data & DMA_SBUS_LPI_XIT_PKT_MASK) << 30));\
		DMA_SBUS_RGWR(v);\
} while (0)

#define DMA_SBUS_LPI_XIT_PKT_UDFRD(data) do {\
		DMA_SBUS_RGRD(data);\
		data = ((data >> 30) & DMA_SBUS_LPI_XIT_PKT_MASK);\
} while (0)

/*#define DMA_SBUS_WR_OSR_LMT_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_SBUS_WR_OSR_LMT_MASK (ULONG)(0xf)

/*#define DMA_SBUS_WR_OSR_LMT_Wr_Mask (ULONG)(~((~(~0 << (4))) << (21)))*/

#define DMA_SBUS_WR_OSR_LMT_WR_MASK (ULONG)(0xfe1fffff)

#define DMA_SBUS_WR_OSR_LMT_UDFWR(data) do {\
		ULONG v;\
		DMA_SBUS_RGRD(v);\
		v = (v & (DMA_SBUS_RES_WR_MASK_25)) | (((0) & (DMA_SBUS_MASK_25)) << 25);\
		v = (v & (DMA_SBUS_RES_WR_MASK_20)) | (((0) & (DMA_SBUS_MASK_20)) << 20);\
		v = (v & (DMA_SBUS_RES_WR_MASK_15)) | (((0) & (DMA_SBUS_MASK_15)) << 15);\
		v = (v & (DMA_SBUS_RES_WR_MASK_8)) | (((0) & (DMA_SBUS_MASK_8)) << 8);\
		v = ((v & DMA_SBUS_WR_OSR_LMT_WR_MASK) | ((data & DMA_SBUS_WR_OSR_LMT_MASK) << 21));\
		DMA_SBUS_RGWR(v);\
} while (0)

#define DMA_SBUS_WR_OSR_LMT_UDFRD(data) do {\
		DMA_SBUS_RGRD(data);\
		data = ((data >> 21) & DMA_SBUS_WR_OSR_LMT_MASK);\
} while (0)

/*#define DMA_SBUS_RD_OSR_LMT_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_SBUS_RD_OSR_LMT_MASK (ULONG)(0xf)

/*#define DMA_SBUS_RD_OSR_LMT_Wr_Mask (ULONG)(~((~(~0 << (4))) << (16)))*/

#define DMA_SBUS_RD_OSR_LMT_WR_MASK (ULONG)(0xfff0ffff)

#define DMA_SBUS_RD_OSR_LMT_UDFWR(data) do {\
		ULONG v;\
		DMA_SBUS_RGRD(v);\
		v = (v & (DMA_SBUS_RES_WR_MASK_25)) | (((0) & (DMA_SBUS_MASK_25)) << 25);\
		v = (v & (DMA_SBUS_RES_WR_MASK_20)) | (((0) & (DMA_SBUS_MASK_20)) << 20);\
		v = (v & (DMA_SBUS_RES_WR_MASK_15)) | (((0) & (DMA_SBUS_MASK_15)) << 15);\
		v = (v & (DMA_SBUS_RES_WR_MASK_8)) | (((0) & (DMA_SBUS_MASK_8)) << 8);\
		v = ((v & DMA_SBUS_RD_OSR_LMT_WR_MASK) | ((data & DMA_SBUS_RD_OSR_LMT_MASK) << 16));\
		DMA_SBUS_RGWR(v);\
} while (0)

#define DMA_SBUS_RD_OSR_LMT_UDFRD(data) do {\
		DMA_SBUS_RGRD(data);\
		data = ((data >> 16) & DMA_SBUS_RD_OSR_LMT_MASK);\
} while (0)

/*#define DMA_SBUS_MB_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SBUS_MB_MASK (ULONG)(0x1)

/*#define DMA_SBUS_MB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (14)))*/

#define DMA_SBUS_MB_WR_MASK (ULONG)(0xffffbfff)

#define DMA_SBUS_MB_UDFWR(data) do {\
		ULONG v;\
		DMA_SBUS_RGRD(v);\
		v = (v & (DMA_SBUS_RES_WR_MASK_25)) | (((0) & (DMA_SBUS_MASK_25)) << 25);\
		v = (v & (DMA_SBUS_RES_WR_MASK_20)) | (((0) & (DMA_SBUS_MASK_20)) << 20);\
		v = (v & (DMA_SBUS_RES_WR_MASK_15)) | (((0) & (DMA_SBUS_MASK_15)) << 15);\
		v = (v & (DMA_SBUS_RES_WR_MASK_8)) | (((0) & (DMA_SBUS_MASK_8)) << 8);\
		v = ((v & DMA_SBUS_MB_WR_MASK) | ((data & DMA_SBUS_MB_MASK) << 14));\
		DMA_SBUS_RGWR(v);\
} while (0)

#define DMA_SBUS_MB_UDFRD(data) do {\
		DMA_SBUS_RGRD(data);\
		data = ((data >> 14) & DMA_SBUS_MB_MASK);\
} while (0)

/*#define DMA_SBUS_ONEKBBE_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SBUS_ONEKBBE_MASK (ULONG)(0x1)

/*#define DMA_SBUS_ONEKBBE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (13)))*/

#define DMA_SBUS_ONEKBBE_WR_MASK (ULONG)(0xffffdfff)

#define DMA_SBUS_ONEKBBE_UDFWR(data) do {\
		ULONG v;\
		DMA_SBUS_RGRD(v);\
		v = (v & (DMA_SBUS_RES_WR_MASK_25)) | (((0) & (DMA_SBUS_MASK_25)) << 25);\
		v = (v & (DMA_SBUS_RES_WR_MASK_20)) | (((0) & (DMA_SBUS_MASK_20)) << 20);\
		v = (v & (DMA_SBUS_RES_WR_MASK_15)) | (((0) & (DMA_SBUS_MASK_15)) << 15);\
		v = (v & (DMA_SBUS_RES_WR_MASK_8)) | (((0) & (DMA_SBUS_MASK_8)) << 8);\
		v = ((v & DMA_SBUS_ONEKBBE_WR_MASK) | ((data & DMA_SBUS_ONEKBBE_MASK) << 13));\
		DMA_SBUS_RGWR(v);\
} while (0)

#define DMA_SBUS_ONEKBBE_UDFRD(data) do {\
		DMA_SBUS_RGRD(data);\
		data = ((data >> 13) & DMA_SBUS_ONEKBBE_MASK);\
} while (0)

/*#define DMA_SBUS_AAL_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SBUS_AAL_MASK (ULONG)(0x1)

/*#define DMA_SBUS_AAL_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define DMA_SBUS_AAL_WR_MASK (ULONG)(0xffffefff)

#define DMA_SBUS_AAL_UDFWR(data) do {\
		ULONG v;\
		DMA_SBUS_RGRD(v);\
		v = (v & (DMA_SBUS_RES_WR_MASK_25)) | (((0) & (DMA_SBUS_MASK_25)) << 25);\
		v = (v & (DMA_SBUS_RES_WR_MASK_20)) | (((0) & (DMA_SBUS_MASK_20)) << 20);\
		v = (v & (DMA_SBUS_RES_WR_MASK_15)) | (((0) & (DMA_SBUS_MASK_15)) << 15);\
		v = (v & (DMA_SBUS_RES_WR_MASK_8)) | (((0) & (DMA_SBUS_MASK_8)) << 8);\
		v = ((v & DMA_SBUS_AAL_WR_MASK) | ((data & DMA_SBUS_AAL_MASK) << 12));\
		DMA_SBUS_RGWR(v);\
} while (0)

#define DMA_SBUS_AAL_UDFRD(data) do {\
		DMA_SBUS_RGRD(data);\
		data = ((data >> 12) & DMA_SBUS_AAL_MASK);\
} while (0)

/*#define DMA_SBUS_BLEN256_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SBUS_BLEN256_MASK (ULONG)(0x1)

/*#define DMA_SBUS_BLEN256_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define DMA_SBUS_BLEN256_WR_MASK (ULONG)(0xffffff7f)

#define DMA_SBUS_BLEN256_UDFWR(data) do {\
		ULONG v;\
		DMA_SBUS_RGRD(v);\
		v = (v & (DMA_SBUS_RES_WR_MASK_25)) | (((0) & (DMA_SBUS_MASK_25)) << 25);\
		v = (v & (DMA_SBUS_RES_WR_MASK_20)) | (((0) & (DMA_SBUS_MASK_20)) << 20);\
		v = (v & (DMA_SBUS_RES_WR_MASK_15)) | (((0) & (DMA_SBUS_MASK_15)) << 15);\
		v = (v & (DMA_SBUS_RES_WR_MASK_8)) | (((0) & (DMA_SBUS_MASK_8)) << 8);\
		v = ((v & DMA_SBUS_BLEN256_WR_MASK) | ((data & DMA_SBUS_BLEN256_MASK) << 7));\
		DMA_SBUS_RGWR(v);\
} while (0)

#define DMA_SBUS_BLEN256_UDFRD(data) do {\
		DMA_SBUS_RGRD(data);\
		data = ((data >> 7) & DMA_SBUS_BLEN256_MASK);\
} while (0)

/*#define DMA_SBUS_BLEN128_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SBUS_BLEN128_MASK (ULONG)(0x1)

/*#define DMA_SBUS_BLEN128_Wr_Mask (ULONG)(~((~(~0 << (1))) << (6)))*/

#define DMA_SBUS_BLEN128_WR_MASK (ULONG)(0xffffffbf)

#define DMA_SBUS_BLEN128_UDFWR(data) do {\
		ULONG v;\
		DMA_SBUS_RGRD(v);\
		v = (v & (DMA_SBUS_RES_WR_MASK_25)) | (((0) & (DMA_SBUS_MASK_25)) << 25);\
		v = (v & (DMA_SBUS_RES_WR_MASK_20)) | (((0) & (DMA_SBUS_MASK_20)) << 20);\
		v = (v & (DMA_SBUS_RES_WR_MASK_15)) | (((0) & (DMA_SBUS_MASK_15)) << 15);\
		v = (v & (DMA_SBUS_RES_WR_MASK_8)) | (((0) & (DMA_SBUS_MASK_8)) << 8);\
		v = ((v & DMA_SBUS_BLEN128_WR_MASK) | ((data & DMA_SBUS_BLEN128_MASK) << 6));\
		DMA_SBUS_RGWR(v);\
} while (0)

#define DMA_SBUS_BLEN128_UDFRD(data) do {\
		DMA_SBUS_RGRD(data);\
		data = ((data >> 6) & DMA_SBUS_BLEN128_MASK);\
} while (0)

/*#define DMA_SBUS_BLEN64_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SBUS_BLEN64_MASK (ULONG)(0x1)

/*#define DMA_SBUS_BLEN64_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define DMA_SBUS_BLEN64_WR_MASK (ULONG)(0xffffffdf)

#define DMA_SBUS_BLEN64_UDFWR(data) do {\
		ULONG v;\
		DMA_SBUS_RGRD(v);\
		v = (v & (DMA_SBUS_RES_WR_MASK_25)) | (((0) & (DMA_SBUS_MASK_25)) << 25);\
		v = (v & (DMA_SBUS_RES_WR_MASK_20)) | (((0) & (DMA_SBUS_MASK_20)) << 20);\
		v = (v & (DMA_SBUS_RES_WR_MASK_15)) | (((0) & (DMA_SBUS_MASK_15)) << 15);\
		v = (v & (DMA_SBUS_RES_WR_MASK_8)) | (((0) & (DMA_SBUS_MASK_8)) << 8);\
		v = ((v & DMA_SBUS_BLEN64_WR_MASK) | ((data & DMA_SBUS_BLEN64_MASK) << 5));\
		DMA_SBUS_RGWR(v);\
} while (0)

#define DMA_SBUS_BLEN64_UDFRD(data) do {\
		DMA_SBUS_RGRD(data);\
		data = ((data >> 5) & DMA_SBUS_BLEN64_MASK);\
} while (0)

/*#define DMA_SBUS_BLEN32_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SBUS_BLEN32_MASK (ULONG)(0x1)

/*#define DMA_SBUS_BLEN32_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define DMA_SBUS_BLEN32_WR_MASK (ULONG)(0xffffffef)

#define DMA_SBUS_BLEN32_UDFWR(data) do {\
		ULONG v;\
		DMA_SBUS_RGRD(v);\
		v = (v & (DMA_SBUS_RES_WR_MASK_25)) | (((0) & (DMA_SBUS_MASK_25)) << 25);\
		v = (v & (DMA_SBUS_RES_WR_MASK_20)) | (((0) & (DMA_SBUS_MASK_20)) << 20);\
		v = (v & (DMA_SBUS_RES_WR_MASK_15)) | (((0) & (DMA_SBUS_MASK_15)) << 15);\
		v = (v & (DMA_SBUS_RES_WR_MASK_8)) | (((0) & (DMA_SBUS_MASK_8)) << 8);\
		v = ((v & DMA_SBUS_BLEN32_WR_MASK) | ((data & DMA_SBUS_BLEN32_MASK) << 4));\
		DMA_SBUS_RGWR(v);\
} while (0)

#define DMA_SBUS_BLEN32_UDFRD(data) do {\
		DMA_SBUS_RGRD(data);\
		data = ((data >> 4) & DMA_SBUS_BLEN32_MASK);\
} while (0)

/*#define DMA_SBUS_BLEN16_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SBUS_BLEN16_MASK (ULONG)(0x1)

/*#define DMA_SBUS_BLEN16_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define DMA_SBUS_BLEN16_WR_MASK (ULONG)(0xfffffff7)

#define DMA_SBUS_BLEN16_UDFWR(data) do {\
		ULONG v;\
		DMA_SBUS_RGRD(v);\
		v = (v & (DMA_SBUS_RES_WR_MASK_25)) | (((0) & (DMA_SBUS_MASK_25)) << 25);\
		v = (v & (DMA_SBUS_RES_WR_MASK_20)) | (((0) & (DMA_SBUS_MASK_20)) << 20);\
		v = (v & (DMA_SBUS_RES_WR_MASK_15)) | (((0) & (DMA_SBUS_MASK_15)) << 15);\
		v = (v & (DMA_SBUS_RES_WR_MASK_8)) | (((0) & (DMA_SBUS_MASK_8)) << 8);\
		v = ((v & DMA_SBUS_BLEN16_WR_MASK) | ((data & DMA_SBUS_BLEN16_MASK) << 3));\
		DMA_SBUS_RGWR(v);\
} while (0)

#define DMA_SBUS_BLEN16_UDFRD(data) do {\
		DMA_SBUS_RGRD(data);\
		data = ((data >> 3) & DMA_SBUS_BLEN16_MASK);\
} while (0)

/*#define DMA_SBUS_BLEN8_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SBUS_BLEN8_MASK (ULONG)(0x1)

/*#define DMA_SBUS_BLEN8_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define DMA_SBUS_BLEN8_WR_MASK (ULONG)(0xfffffffb)

#define DMA_SBUS_BLEN8_UDFWR(data) do {\
		ULONG v;\
		DMA_SBUS_RGRD(v);\
		v = (v & (DMA_SBUS_RES_WR_MASK_25)) | (((0) & (DMA_SBUS_MASK_25)) << 25);\
		v = (v & (DMA_SBUS_RES_WR_MASK_20)) | (((0) & (DMA_SBUS_MASK_20)) << 20);\
		v = (v & (DMA_SBUS_RES_WR_MASK_15)) | (((0) & (DMA_SBUS_MASK_15)) << 15);\
		v = (v & (DMA_SBUS_RES_WR_MASK_8)) | (((0) & (DMA_SBUS_MASK_8)) << 8);\
		v = ((v & DMA_SBUS_BLEN8_WR_MASK) | ((data & DMA_SBUS_BLEN8_MASK) << 2));\
		DMA_SBUS_RGWR(v);\
} while (0)

#define DMA_SBUS_BLEN8_UDFRD(data) do {\
		DMA_SBUS_RGRD(data);\
		data = ((data >> 2) & DMA_SBUS_BLEN8_MASK);\
} while (0)

/*#define DMA_SBUS_BLEN4_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SBUS_BLEN4_MASK (ULONG)(0x1)

/*#define DMA_SBUS_BLEN4_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define DMA_SBUS_BLEN4_WR_MASK (ULONG)(0xfffffffd)

#define DMA_SBUS_BLEN4_UDFWR(data) do {\
		ULONG v;\
		DMA_SBUS_RGRD(v);\
		v = (v & (DMA_SBUS_RES_WR_MASK_25)) | (((0) & (DMA_SBUS_MASK_25)) << 25);\
		v = (v & (DMA_SBUS_RES_WR_MASK_20)) | (((0) & (DMA_SBUS_MASK_20)) << 20);\
		v = (v & (DMA_SBUS_RES_WR_MASK_15)) | (((0) & (DMA_SBUS_MASK_15)) << 15);\
		v = (v & (DMA_SBUS_RES_WR_MASK_8)) | (((0) & (DMA_SBUS_MASK_8)) << 8);\
		v = ((v & DMA_SBUS_BLEN4_WR_MASK) | ((data & DMA_SBUS_BLEN4_MASK) << 1));\
		DMA_SBUS_RGWR(v);\
} while (0)

#define DMA_SBUS_BLEN4_UDFRD(data) do {\
		DMA_SBUS_RGRD(data);\
		data = ((data >> 1) & DMA_SBUS_BLEN4_MASK);\
} while (0)

/*#define DMA_SBUS_UNDEF_FB_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SBUS_UNDEF_FB_MASK (ULONG)(0x1)

/*#define DMA_SBUS_UNDEF_FB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_SBUS_UNDEF_FB_WR_MASK (ULONG)(0xfffffffe)

#define DMA_SBUS_UNDEF_FB_UDFWR(data) do {\
		ULONG v;\
		DMA_SBUS_RGRD(v);\
		v = (v & (DMA_SBUS_RES_WR_MASK_25)) | (((0) & (DMA_SBUS_MASK_25)) << 25);\
		v = (v & (DMA_SBUS_RES_WR_MASK_20)) | (((0) & (DMA_SBUS_MASK_20)) << 20);\
		v = (v & (DMA_SBUS_RES_WR_MASK_15)) | (((0) & (DMA_SBUS_MASK_15)) << 15);\
		v = (v & (DMA_SBUS_RES_WR_MASK_8)) | (((0) & (DMA_SBUS_MASK_8)) << 8);\
		v = ((v & DMA_SBUS_UNDEF_FB_WR_MASK) | ((data & DMA_SBUS_UNDEF_FB_MASK) << 0));\
		DMA_SBUS_RGWR(v);\
} while (0)

#define DMA_SBUS_UNDEF_FB_UDFRD(data) do {\
		DMA_SBUS_RGRD(data);\
		data = ((data >> 0) & DMA_SBUS_UNDEF_FB_MASK);\
} while (0)

#define DMA_BMR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1000))

#define DMA_BMR_RGWR(data) do {\
		iowrite32(data, (void *)DMA_BMR_RGOFFADDR);\
} while (0)

#define DMA_BMR_RGRD(data) do {\
		(data) = ioread32((void *)DMA_BMR_RGOFFADDR);\
} while (0)

/*#define  DMA_BMR_Mask_15 (ULONG)(~(~0<<(16)))*/

#define  DMA_BMR_MASK_15 (ULONG)(0xffff)

/*#define DMA_BMR_RES_Wr_Mask_15 (ULONG)(~((~(~0<<(16)))<<(15)))*/

#define DMA_BMR_RES_WR_MASK_15 (ULONG)(0x80007fff)

/*#define  DMA_BMR_Mask_6 (ULONG)(~(~0<<(5)))*/

#define  DMA_BMR_MASK_6 (ULONG)(0x1f)

/*#define DMA_BMR_RES_Wr_Mask_6 (ULONG)(~((~(~0<<(5)))<<(6)))*/

#define DMA_BMR_RES_WR_MASK_6 (ULONG)(0xfffff83f)

/*#define DMA_BMR_RIB_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_BMR_RIB_MASK (ULONG)(0x1)

/*#define DMA_BMR_RIB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (31)))*/


#define DMA_BMR_RIB_WR_MASK (ULONG)(0x7fffffff)

#define DMA_BMR_INTM_MASK (ULONG) (0x30000)
#define DMA_BMR_INTM_WR_MASK (ULONG) (0xfffcffff)

#define DMA_BMR_INTMWR(data) do {\
		ULONG v;\
		DMA_BMR_RGRD(v);\
		v = ((v & DMA_BMR_INTM_WR_MASK) | ((data <<16) & DMA_BMR_INTM_MASK));\
		DMA_BMR_RGWR(v);\
} while(0)


#define DMA_BMR_RIB_UDFWR(data) do {\
		ULONG v;\
		DMA_BMR_RGRD(v);\
		v = (v & (DMA_BMR_RES_WR_MASK_15)) | (((0) & (DMA_BMR_MASK_15)) << 15);\
		v = (v & (DMA_BMR_RES_WR_MASK_6)) | (((0) & (DMA_BMR_MASK_6)) << 6);\
		v = ((v & DMA_BMR_RIB_WR_MASK) | ((data & DMA_BMR_RIB_MASK) << 31));\
		DMA_BMR_RGWR(v);\
} while (0)

#define DMA_BMR_RIB_UDFRD(data) do {\
		DMA_BMR_RGRD(data);\
		data = ((data >> 31) & DMA_BMR_RIB_MASK);\
} while (0)

/*#define DMA_BMR_PR_Mask (ULONG)(~(~0<<(3)))*/

#define DMA_BMR_PR_MASK (ULONG)(0x7)

/*#define DMA_BMR_PR_Wr_Mask (ULONG)(~((~(~0 << (3))) << (12)))*/

#define DMA_BMR_PR_WR_MASK (ULONG)(0xffff8fff)

#define DMA_BMR_PR_UDFWR(data) do {\
		ULONG v;\
		DMA_BMR_RGRD(v);\
		v = (v & (DMA_BMR_RES_WR_MASK_15)) | (((0) & (DMA_BMR_MASK_15)) << 15);\
		v = (v & (DMA_BMR_RES_WR_MASK_6)) | (((0) & (DMA_BMR_MASK_6)) << 6);\
		v = ((v & DMA_BMR_PR_WR_MASK) | ((data & DMA_BMR_PR_MASK) << 12));\
		DMA_BMR_RGWR(v);\
} while (0)

#define DMA_BMR_PR_UDFRD(data) do {\
		DMA_BMR_RGRD(data);\
		data = ((data >> 12) & DMA_BMR_PR_MASK);\
} while (0)

/*#define DMA_BMR_TXPR_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_BMR_TXPR_MASK (ULONG)(0x1)

/*#define DMA_BMR_TXPR_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define DMA_BMR_TXPR_WR_MASK (ULONG)(0xfffff7ff)

#define DMA_BMR_TXPR_UDFWR(data) do {\
		ULONG v;\
		DMA_BMR_RGRD(v);\
		v = (v & (DMA_BMR_RES_WR_MASK_15)) | (((0) & (DMA_BMR_MASK_15)) << 15);\
		v = (v & (DMA_BMR_RES_WR_MASK_6)) | (((0) & (DMA_BMR_MASK_6)) << 6);\
		v = ((v & DMA_BMR_TXPR_WR_MASK) | ((data & DMA_BMR_TXPR_MASK) << 11));\
		DMA_BMR_RGWR(v);\
} while (0)

#define DMA_BMR_TXPR_UDFRD(data) do {\
		DMA_BMR_RGRD(data);\
		data = ((data >> 11) & DMA_BMR_TXPR_MASK);\
} while (0)

#define DMA_BMR_DSPW_MASK (ULONG)(0x1)

#define DMA_BMR_DSPW_WR_MASK (ULONG)(0xfffffeff)

#define DMA_BMR_DSPW_UDFWR(data) do {\
		ULONG v;\
		DMA_BMR_RGRD(v);\
		v = ((v & DMA_BMR_DSPW_WR_MASK) |\
			(((data) & DMA_BMR_DSPW_MASK) << 8));\
		DMA_BMR_RGWR(v);\
} while (0)

#define DMA_BMR_DSPW_UDFRD(data) do {\
		DMA_BMR_RGRD(data);\
		data = ((data >> 8) & DMA_BMR_DSPW_MASK);\
} while (0)

/*#define DMA_BMR_DTXSTS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_BMR_DTXSTS_MASK (ULONG)(0x1)

/*#define DMA_BMR_DTXSTS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define DMA_BMR_DTXSTS_WR_MASK (ULONG)(0xffffffdf)

#define DMA_BMR_DTXSTS_UDFWR(data) do {\
		ULONG v;\
		DMA_BMR_RGRD(v);\
		v = (v & (DMA_BMR_RES_WR_MASK_15)) | (((0) & (DMA_BMR_MASK_15)) << 15);\
		v = (v & (DMA_BMR_RES_WR_MASK_6)) | (((0) & (DMA_BMR_MASK_6)) << 6);\
		v = ((v & DMA_BMR_DTXSTS_WR_MASK) | ((data & DMA_BMR_DTXSTS_MASK) << 5));\
		DMA_BMR_RGWR(v);\
} while (0)

#define DMA_BMR_DTXSTS_UDFRD(data) do {\
		DMA_BMR_RGRD(data);\
		data = ((data >> 5) & DMA_BMR_DTXSTS_MASK);\
} while (0)

/*#define DMA_BMR_TAA_Mask (ULONG)(~(~0<<(3)))*/

#define DMA_BMR_TAA_MASK (ULONG)(0x7)

/*#define DMA_BMR_TAA_Wr_Mask (ULONG)(~((~(~0 << (3))) << (2)))*/

#define DMA_BMR_TAA_WR_MASK (ULONG)(0xffffffe3)

#define DMA_BMR_TAA_UDFWR(data) do {\
		ULONG v;\
		DMA_BMR_RGRD(v);\
		v = (v & (DMA_BMR_RES_WR_MASK_15)) | (((0) & (DMA_BMR_MASK_15)) << 15);\
		v = (v & (DMA_BMR_RES_WR_MASK_6)) | (((0) & (DMA_BMR_MASK_6)) << 6);\
		v = ((v & DMA_BMR_TAA_WR_MASK) | ((data & DMA_BMR_TAA_MASK) << 2));\
		DMA_BMR_RGWR(v);\
} while (0)

#define DMA_BMR_TAA_UDFRD(data) do {\
		DMA_BMR_RGRD(data);\
		data = ((data >> 2) & DMA_BMR_TAA_MASK);\
} while (0)

/*#define DMA_BMR_DA_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_BMR_DA_MASK (ULONG)(0x1)

/*#define DMA_BMR_DA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define DMA_BMR_DA_WR_MASK (ULONG)(0xfffffffd)

#define DMA_BMR_DA_UDFWR(data) do {\
		ULONG v;\
		DMA_BMR_RGRD(v);\
		v = (v & (DMA_BMR_RES_WR_MASK_15)) | (((0) & (DMA_BMR_MASK_15)) << 15);\
		v = (v & (DMA_BMR_RES_WR_MASK_6)) | (((0) & (DMA_BMR_MASK_6)) << 6);\
		v = ((v & DMA_BMR_DA_WR_MASK) | ((data & DMA_BMR_DA_MASK) << 1));\
		DMA_BMR_RGWR(v);\
} while (0)

#define DMA_BMR_DA_UDFRD(data) do {\
		DMA_BMR_RGRD(data);\
		data = ((data >> 1) & DMA_BMR_DA_MASK);\
} while (0)

/*#define DMA_BMR_SWR_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_BMR_SWR_MASK (ULONG)(0x1)

/*#define DMA_BMR_SWR_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_BMR_SWR_WR_MASK (ULONG)(0xfffffffe)

#define DMA_BMR_SWR_UDFWR(data) do {\
		ULONG v;\
		DMA_BMR_RGRD(v);\
		v = (v & (DMA_BMR_RES_WR_MASK_15)) | (((0) & (DMA_BMR_MASK_15)) << 15);\
		v = (v & (DMA_BMR_RES_WR_MASK_6)) | (((0) & (DMA_BMR_MASK_6)) << 6);\
		v = ((v & DMA_BMR_SWR_WR_MASK) | ((data & DMA_BMR_SWR_MASK) << 0));\
		DMA_BMR_RGWR(v);\
} while (0)

#define DMA_BMR_SWR_UDFRD(data) do {\
		DMA_BMR_RGRD(data);\
		data = ((data >> 0) & DMA_BMR_SWR_MASK);\
} while (0)

#define MTL_Q0RCR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd3c))

#define MTL_Q0RCR_RGWR(data) do {\
		iowrite32(data, (void *)MTL_Q0RCR_RGOFFADDR);\
} while (0)

#define MTL_Q0RCR_RGRD(data) do {\
		(data) = ioread32((void *)MTL_Q0RCR_RGOFFADDR);\
} while (0)

/*#define  MTL_Q0RCR_Mask_4 (ULONG)(~(~0<<(28)))*/

#define  MTL_Q0RCR_MASK_4 (ULONG)(0xfffffff)

/*#define MTL_Q0RCR_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(28)))<<(4)))*/

#define MTL_Q0RCR_RES_WR_MASK_4 (ULONG)(0xf)

/*#define MTL_Q0RCR_RXQ_PKT_ARBIT_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0RCR_RXQ_PKT_ARBIT_MASK (ULONG)(0x1)

/*#define MTL_Q0RCR_RXQ_PKT_ARBIT_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_Q0RCR_RXQ_PKT_ARBIT_WR_MASK (ULONG)(0xfffffff7)

#define MTL_Q0RCR_RXQ_PKT_ARBIT_UDFWR(data) do {\
		ULONG v;\
		MTL_Q0RCR_RGRD(v);\
		v = (v & (MTL_Q0RCR_RES_WR_MASK_4)) | (((0) & (MTL_Q0RCR_MASK_4)) << 4);\
		v = ((v & MTL_Q0RCR_RXQ_PKT_ARBIT_WR_MASK) | ((data & MTL_Q0RCR_RXQ_PKT_ARBIT_MASK) << 3));\
		MTL_Q0RCR_RGWR(v);\
} while (0)

#define MTL_Q0RCR_RXQ_PKT_ARBIT_UDFRD(data) do {\
		MTL_Q0RCR_RGRD(data);\
		data = ((data >> 3) & MTL_Q0RCR_RXQ_PKT_ARBIT_MASK);\
} while (0)

/*#define MTL_Q0RCR_RQW_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_Q0RCR_RQW_MASK (ULONG)(0x7)

/*#define MTL_Q0RCR_RQW_Wr_Mask (ULONG)(~((~(~0 << (3))) << (0)))*/

#define MTL_Q0RCR_RQW_WR_MASK (ULONG)(0xfffffff8)

#define MTL_Q0RCR_RQW_UDFWR(data) do {\
		ULONG v;\
		MTL_Q0RCR_RGRD(v);\
		v = (v & (MTL_Q0RCR_RES_WR_MASK_4)) | (((0) & (MTL_Q0RCR_MASK_4)) << 4);\
		v = ((v & MTL_Q0RCR_RQW_WR_MASK) | ((data & MTL_Q0RCR_RQW_MASK) << 0));\
		MTL_Q0RCR_RGWR(v);\
} while (0)

#define MTL_Q0RCR_RQW_UDFRD(data) do {\
		MTL_Q0RCR_RGRD(data);\
		data = ((data >> 0) & MTL_Q0RCR_RQW_MASK);\
} while (0)

#define MTL_Q0OCR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd34))

#define MTL_Q0OCR_RGRD(data) do {\
		(data) = ioread32((void *)MTL_Q0OCR_RGOFFADDR);\
} while (0)

/*#define MTL_Q0OCR_MISCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0OCR_MISCNTOVF_MASK (ULONG)(0x1)

#define MTL_Q0OCR_MISCNTOVF_UDFRD(data) do {\
		MTL_Q0OCR_RGRD(data);\
		data = ((data >> 27) & MTL_Q0OCR_MISCNTOVF_MASK);\
} while (0)

/*#define MTL_Q0OCR_MISPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_Q0OCR_MISPKTCNT_MASK (ULONG)(0x7ff)

#define MTL_Q0OCR_MISPKTCNT_UDFRD(data) do {\
		MTL_Q0OCR_RGRD(data);\
		data = ((data >> 16) & MTL_Q0OCR_MISPKTCNT_MASK);\
} while (0)

/*#define MTL_Q0OCR_OVFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0OCR_OVFCNTOVF_MASK (ULONG)(0x1)

#define MTL_Q0OCR_OVFCNTOVF_UDFRD(data) do {\
		MTL_Q0OCR_RGRD(data);\
		data = ((data >> 11) & MTL_Q0OCR_OVFCNTOVF_MASK);\
} while (0)

/*#define MTL_Q0OCR_OVFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_Q0OCR_OVFPKTCNT_MASK (ULONG)(0x7ff)

#define MTL_Q0OCR_OVFPKTCNT_UDFRD(data) do {\
		MTL_Q0OCR_RGRD(data);\
		data = ((data >> 0) & MTL_Q0OCR_OVFPKTCNT_MASK);\
} while (0)

#define MTL_Q0ROMR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd30))

#define MTL_Q0ROMR_RGWR(data) do {\
		iowrite32(data, (void *)MTL_Q0ROMR_RGOFFADDR);\
} while (0)

#define MTL_Q0ROMR_RGRD(data) do {\
		(data) = ioread32((void *)MTL_Q0ROMR_RGOFFADDR);\
} while (0)

/*#define  MTL_Q0ROMR_Mask_30 (ULONG)(~(~0<<(2)))*/

#define  MTL_Q0ROMR_MASK_30 (ULONG)(0x3)

/*#define MTL_Q0ROMR_RES_Wr_Mask_30 (ULONG)(~((~(~0<<(2)))<<(30)))*/

#define MTL_Q0ROMR_RES_WR_MASK_30 (ULONG)(0x3fffffff)

/*#define  MTL_Q0ROMR_Mask_16 (ULONG)(~(~0<<(4)))*/

#define  MTL_Q0ROMR_MASK_16 (ULONG)(0xf)

/*#define MTL_Q0ROMR_RES_Wr_Mask_16 (ULONG)(~((~(~0<<(4)))<<(16)))*/

#define MTL_Q0ROMR_RES_WR_MASK_16 (ULONG)(0xfff0ffff)

/*#define  MTL_Q0ROMR_Mask_11 (ULONG)(~(~0<<(2)))*/

#define  MTL_Q0ROMR_MASK_11 (ULONG)(0x3)

/*#define MTL_Q0ROMR_RES_Wr_Mask_11 (ULONG)(~((~(~0<<(2)))<<(11)))*/

#define MTL_Q0ROMR_RES_WR_MASK_11 (ULONG)(0xffffe7ff)

/*#define  MTL_Q0ROMR_Mask_2 (ULONG)(~(~0<<(1)))*/

#define  MTL_Q0ROMR_MASK_2 (ULONG)(0x1)

/*#define MTL_Q0ROMR_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(1)))<<(2)))*/

#define MTL_Q0ROMR_RES_WR_MASK_2 (ULONG)(0xfffffffb)

/*#define MTL_Q0ROMR_RQS_Mask (ULONG)(~(~0<<(10)))*/

#define MTL_Q0ROMR_RQS_MASK (ULONG)(0x3ff)

/*#define MTL_Q0ROMR_RQS_Wr_Mask (ULONG)(~((~(~0 << (10))) << (20)))*/

#define MTL_Q0ROMR_RQS_WR_MASK (ULONG)(0xc00fffff)

#define MTL_Q0ROMR_RQS_UDFWR(data) do {\
		ULONG v;\
		MTL_Q0ROMR_RGRD(v);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_30)) | (((0) & (MTL_Q0ROMR_MASK_30)) << 30);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_16)) | (((0) & (MTL_Q0ROMR_MASK_16)) << 16);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_11)) | (((0) & (MTL_Q0ROMR_MASK_11)) << 11);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_2)) | (((0) & (MTL_Q0ROMR_MASK_2)) << 2);\
		v = ((v & MTL_Q0ROMR_RQS_WR_MASK) | ((data & MTL_Q0ROMR_RQS_MASK) << 20));\
		MTL_Q0ROMR_RGWR(v);\
} while (0)

#define MTL_Q0ROMR_RQS_UDFRD(data) do {\
		MTL_Q0ROMR_RGRD(data);\
		data = ((data >> 20) & MTL_Q0ROMR_RQS_MASK);\
} while (0)

/*#define MTL_Q0ROMR_RFD_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_Q0ROMR_RFD_MASK (ULONG)(0x7)

/*#define MTL_Q0ROMR_RFD_Wr_Mask (ULONG)(~((~(~0 << (3))) << (13)))*/

#define MTL_Q0ROMR_RFD_WR_MASK (ULONG)(0xffff1fff)

#define MTL_Q0ROMR_RFD_UDFWR(data) do {\
		ULONG v;\
		MTL_Q0ROMR_RGRD(v);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_30)) | (((0) & (MTL_Q0ROMR_MASK_30)) << 30);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_16)) | (((0) & (MTL_Q0ROMR_MASK_16)) << 16);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_11)) | (((0) & (MTL_Q0ROMR_MASK_11)) << 11);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_2)) | (((0) & (MTL_Q0ROMR_MASK_2)) << 2);\
		v = ((v & MTL_Q0ROMR_RFD_WR_MASK) | ((data & MTL_Q0ROMR_RFD_MASK) << 13));\
		MTL_Q0ROMR_RGWR(v);\
} while (0)

#define MTL_Q0ROMR_RFD_UDFRD(data) do {\
		MTL_Q0ROMR_RGRD(data);\
		data = ((data >> 13) & MTL_Q0ROMR_RFD_MASK);\
} while (0)

/*#define MTL_Q0ROMR_RFA_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_Q0ROMR_RFA_MASK (ULONG)(0x7)

/*#define MTL_Q0ROMR_RFA_Wr_Mask (ULONG)(~((~(~0 << (3))) << (8)))*/

#define MTL_Q0ROMR_RFA_WR_MASK (ULONG)(0xfffff8ff)

#define MTL_Q0ROMR_RFA_UDFWR(data) do {\
		ULONG v;\
		MTL_Q0ROMR_RGRD(v);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_30)) | (((0) & (MTL_Q0ROMR_MASK_30)) << 30);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_16)) | (((0) & (MTL_Q0ROMR_MASK_16)) << 16);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_11)) | (((0) & (MTL_Q0ROMR_MASK_11)) << 11);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_2)) | (((0) & (MTL_Q0ROMR_MASK_2)) << 2);\
		v = ((v & MTL_Q0ROMR_RFA_WR_MASK) | ((data & MTL_Q0ROMR_RFA_MASK) << 8));\
		MTL_Q0ROMR_RGWR(v);\
} while (0)

#define MTL_Q0ROMR_RFA_UDFRD(data) do {\
		MTL_Q0ROMR_RGRD(data);\
		data = ((data >> 8) & MTL_Q0ROMR_RFA_MASK);\
} while (0)

/*#define MTL_Q0ROMR_EFC_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0ROMR_EFC_MASK (ULONG)(0x1)

/*#define MTL_Q0ROMR_EFC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MTL_Q0ROMR_EFC_WR_MASK (ULONG)(0xffffff7f)

#define MTL_Q0ROMR_EFC_UDFWR(data) do {\
		ULONG v;\
		MTL_Q0ROMR_RGRD(v);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_30)) | (((0) & (MTL_Q0ROMR_MASK_30)) << 30);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_16)) | (((0) & (MTL_Q0ROMR_MASK_16)) << 16);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_11)) | (((0) & (MTL_Q0ROMR_MASK_11)) << 11);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_2)) | (((0) & (MTL_Q0ROMR_MASK_2)) << 2);\
		v = ((v & MTL_Q0ROMR_EFC_WR_MASK) | ((data & MTL_Q0ROMR_EFC_MASK) << 7));\
		MTL_Q0ROMR_RGWR(v);\
} while (0)

#define MTL_Q0ROMR_EFC_UDFRD(data) do {\
		MTL_Q0ROMR_RGRD(data);\
		data = ((data >> 7) & MTL_Q0ROMR_EFC_MASK);\
} while (0)

/*#define MTL_Q0ROMR_DT_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0ROMR_DT_MASK (ULONG)(0x1)

/*#define MTL_Q0ROMR_DT_Wr_Mask (ULONG)(~((~(~0 << (1))) << (6)))*/

#define MTL_Q0ROMR_DT_WR_MASK (ULONG)(0xffffffbf)

#define MTL_Q0ROMR_DT_UDFWR(data) do {\
		ULONG v;\
		MTL_Q0ROMR_RGRD(v);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_30)) | (((0) & (MTL_Q0ROMR_MASK_30)) << 30);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_16)) | (((0) & (MTL_Q0ROMR_MASK_16)) << 16);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_11)) | (((0) & (MTL_Q0ROMR_MASK_11)) << 11);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_2)) | (((0) & (MTL_Q0ROMR_MASK_2)) << 2);\
		v = ((v & MTL_Q0ROMR_DT_WR_MASK) | ((data & MTL_Q0ROMR_DT_MASK) << 6));\
		MTL_Q0ROMR_RGWR(v);\
} while (0)

#define MTL_Q0ROMR_DT_UDFRD(data) do {\
		MTL_Q0ROMR_RGRD(data);\
		data = ((data >> 6) & MTL_Q0ROMR_DT_MASK);\
} while (0)

/*#define MTL_Q0ROMR_RSF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0ROMR_RSF_MASK (ULONG)(0x1)

/*#define MTL_Q0ROMR_RSF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MTL_Q0ROMR_RSF_WR_MASK (ULONG)(0xffffffdf)

#define MTL_Q0ROMR_RSF_UDFWR(data) do {\
		ULONG v;\
		MTL_Q0ROMR_RGRD(v);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_30)) | (((0) & (MTL_Q0ROMR_MASK_30)) << 30);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_16)) | (((0) & (MTL_Q0ROMR_MASK_16)) << 16);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_11)) | (((0) & (MTL_Q0ROMR_MASK_11)) << 11);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_2)) | (((0) & (MTL_Q0ROMR_MASK_2)) << 2);\
		v = ((v & MTL_Q0ROMR_RSF_WR_MASK) | ((data & MTL_Q0ROMR_RSF_MASK) << 5));\
		MTL_Q0ROMR_RGWR(v);\
} while (0)

#define MTL_Q0ROMR_RSF_UDFRD(data) do {\
		MTL_Q0ROMR_RGRD(data);\
		data = ((data >> 5) & MTL_Q0ROMR_RSF_MASK);\
} while (0)

/*#define MTL_Q0ROMR_FEP_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0ROMR_FEP_MASK (ULONG)(0x1)

/*#define MTL_Q0ROMR_FEP_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MTL_Q0ROMR_FEP_WR_MASK (ULONG)(0xffffffef)

#define MTL_Q0ROMR_FEP_UDFWR(data) do {\
		ULONG v;\
		MTL_Q0ROMR_RGRD(v);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_30)) | (((0) & (MTL_Q0ROMR_MASK_30)) << 30);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_16)) | (((0) & (MTL_Q0ROMR_MASK_16)) << 16);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_11)) | (((0) & (MTL_Q0ROMR_MASK_11)) << 11);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_2)) | (((0) & (MTL_Q0ROMR_MASK_2)) << 2);\
		v = ((v & MTL_Q0ROMR_FEP_WR_MASK) | ((data & MTL_Q0ROMR_FEP_MASK) << 4));\
		MTL_Q0ROMR_RGWR(v);\
} while (0)

#define MTL_Q0ROMR_FEP_UDFRD(data) do {\
		MTL_Q0ROMR_RGRD(data);\
		data = ((data >> 4) & MTL_Q0ROMR_FEP_MASK);\
} while (0)

/*#define MTL_Q0ROMR_FUP_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0ROMR_FUP_MASK (ULONG)(0x1)

/*#define MTL_Q0ROMR_FUP_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_Q0ROMR_FUP_WR_MASK (ULONG)(0xfffffff7)

#define MTL_Q0ROMR_FUP_UDFWR(data) do {\
		ULONG v;\
		MTL_Q0ROMR_RGRD(v);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_30)) | (((0) & (MTL_Q0ROMR_MASK_30)) << 30);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_16)) | (((0) & (MTL_Q0ROMR_MASK_16)) << 16);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_11)) | (((0) & (MTL_Q0ROMR_MASK_11)) << 11);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_2)) | (((0) & (MTL_Q0ROMR_MASK_2)) << 2);\
		v = ((v & MTL_Q0ROMR_FUP_WR_MASK) | ((data & MTL_Q0ROMR_FUP_MASK) << 3));\
		MTL_Q0ROMR_RGWR(v);\
} while (0)

#define MTL_Q0ROMR_FUP_UDFRD(data) do {\
		MTL_Q0ROMR_RGRD(data);\
		data = ((data >> 3) & MTL_Q0ROMR_FUP_MASK);\
} while (0)

/*#define MTL_Q0ROMR_RTC_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_Q0ROMR_RTC_MASK (ULONG)(0x3)

/*#define MTL_Q0ROMR_RTC_Wr_Mask (ULONG)(~((~(~0 << (2))) << (0)))*/

#define MTL_Q0ROMR_RTC_WR_MASK (ULONG)(0xfffffffc)

#define MTL_Q0ROMR_RTC_UDFWR(data) do {\
		ULONG v;\
		MTL_Q0ROMR_RGRD(v);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_30)) | (((0) & (MTL_Q0ROMR_MASK_30)) << 30);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_16)) | (((0) & (MTL_Q0ROMR_MASK_16)) << 16);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_11)) | (((0) & (MTL_Q0ROMR_MASK_11)) << 11);\
		v = (v & (MTL_Q0ROMR_RES_WR_MASK_2)) | (((0) & (MTL_Q0ROMR_MASK_2)) << 2);\
		v = ((v & MTL_Q0ROMR_RTC_WR_MASK) | ((data & MTL_Q0ROMR_RTC_MASK) << 0));\
		MTL_Q0ROMR_RGWR(v);\
} while (0)

#define MTL_Q0ROMR_RTC_UDFRD(data) do {\
		MTL_Q0ROMR_RGRD(data);\
		data = ((data >> 0) & MTL_Q0ROMR_RTC_MASK);\
} while (0)

#define MTL_Q0QR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd18))

#define MTL_Q0QR_RGWR(data) do {\
		iowrite32(data, (void *)MTL_Q0QR_RGOFFADDR);\
} while (0)

#define MTL_Q0QR_RGRD(data) do {\
		(data) = ioread32((void *)MTL_Q0QR_RGOFFADDR);\
} while (0)

/*#define  MTL_Q0QR_Mask_21 (ULONG)(~(~0<<(11)))*/

#define  MTL_Q0QR_MASK_21 (ULONG)(0x7ff)

/*#define MTL_Q0QR_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(11)))<<(21)))*/

#define MTL_Q0QR_RES_WR_MASK_21 (ULONG)(0x1fffff)

/*#define MTL_Q0QR_QW_Mask (ULONG)(~(~0<<(21)))*/

#define MTL_Q0QR_QW_MASK (ULONG)(0x1fffff)

/*#define MTL_Q0QR_QW_Wr_Mask (ULONG)(~((~(~0 << (21))) << (0)))*/

#define MTL_Q0QR_QW_WR_MASK (ULONG)(0xffe00000)

#define MTL_Q0QR_QW_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_Q0QR_RES_WR_MASK_21)) | (((0) & (MTL_Q0QR_MASK_21)) << 21);\
		(v) = ((v & MTL_Q0QR_QW_WR_MASK) | ((data & MTL_Q0QR_QW_MASK) << 0));\
		MTL_Q0QR_RGWR(v);\
} while (0)

#define MTL_Q0QR_QW_UDFRD(data) do {\
		MTL_Q0QR_RGRD(data);\
		data = ((data >> 0) & MTL_Q0QR_QW_MASK);\
} while (0)

#define MTL_Q0ECR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd10))

#define MTL_Q0ECR_RGWR(data) do {\
		iowrite32(data, (void *)MTL_Q0ECR_RGOFFADDR);\
} while (0)

#define MTL_Q0ECR_RGRD(data) do {\
		(data) = ioread32((void *)MTL_Q0ECR_RGOFFADDR);\
} while (0)

/*#define  MTL_Q0ECR_Mask_25 (ULONG)(~(~0<<(7)))*/

#define  MTL_Q0ECR_MASK_25 (ULONG)(0x7f)

/*#define MTL_Q0ECR_RES_Wr_Mask_25 (ULONG)(~((~(~0<<(7)))<<(25)))*/

#define MTL_Q0ECR_RES_WR_MASK_25 (ULONG)(0x1ffffff)

/*#define  MTL_Q0ECR_Mask_0 (ULONG)(~(~0<<(24)))*/

#define  MTL_Q0ECR_MASK_0 (ULONG)(0xffffff)

/*#define MTL_Q0ECR_RES_Wr_Mask_0 (ULONG)(~((~(~0<<(24)))<<(0)))*/

#define MTL_Q0ECR_RES_WR_MASK_0 (ULONG)(0xff000000)

/*#define MTL_Q0ECR_ABPSSIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0ECR_ABPSSIE_MASK (ULONG)(0x1)

/*#define MTL_Q0ECR_ABPSSIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define MTL_Q0ECR_ABPSSIE_WR_MASK (ULONG)(0xfeffffff)

#define MTL_Q0ECR_ABPSSIE_UDFWR(data) do {\
		ULONG v = 0; \
		v = (v & (MTL_Q0ECR_RES_WR_MASK_25)) | (((0) & (MTL_Q0ECR_MASK_25)) << 25);\
		v = (v & (MTL_Q0ECR_RES_WR_MASK_0)) | (((0) & (MTL_Q0ECR_MASK_0)) << 0);\
		(v) = ((v & MTL_Q0ECR_ABPSSIE_WR_MASK) | ((data & MTL_Q0ECR_ABPSSIE_MASK) << 24));\
		MTL_Q0ECR_RGWR(v);\
} while (0)

#define MTL_Q0ECR_ABPSSIE_UDFRD(data) do {\
		MTL_Q0ECR_RGRD(data);\
		data = ((data >> 24) & MTL_Q0ECR_ABPSSIE_MASK);\
} while (0)

#define MTL_Q0UCR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd04))

#define MTL_Q0UCR_RGWR(data) do {\
		iowrite32(data, (void *)MTL_Q0UCR_RGOFFADDR);\
} while (0)

#define MTL_Q0UCR_RGRD(data) do {\
		(data) = ioread32((void *)MTL_Q0UCR_RGOFFADDR);\
} while (0)

/*#define  MTL_Q0UCR_Mask_12 (ULONG)(~(~0<<(20)))*/

#define  MTL_Q0UCR_MASK_12 (ULONG)(0xfffff)

/*#define MTL_Q0UCR_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(20)))<<(12)))*/

#define MTL_Q0UCR_RES_WR_MASK_12 (ULONG)(0xfff)

/*#define MTL_Q0UCR_UFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0UCR_UFCNTOVF_MASK (ULONG)(0x1)

#define MTL_Q0UCR_UFCNTOVF_UDFRD(data) do {\
		MTL_Q0UCR_RGRD(data);\
		data = ((data >> 11) & MTL_Q0UCR_UFCNTOVF_MASK);\
} while (0)

/*#define MTL_Q0UCR_UFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_Q0UCR_UFPKTCNT_MASK (ULONG)(0x7ff)

/*#define MTL_Q0UCR_UFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_Q0UCR_UFPKTCNT_WR_MASK (ULONG)(0xfffff800)

#define MTL_Q0UCR_UFPKTCNT_UDFWR(data) do {\
		ULONG v;\
		MTL_Q0UCR_RGRD(v);\
		v = (v & (MTL_Q0UCR_RES_WR_MASK_12)) | (((0) & (MTL_Q0UCR_MASK_12)) << 12);\
		v = ((v & MTL_Q0UCR_UFPKTCNT_WR_MASK) | ((data & MTL_Q0UCR_UFPKTCNT_MASK) << 0));\
		MTL_Q0UCR_RGWR(v);\
} while (0)

#define MTL_Q0UCR_UFPKTCNT_UDFRD(data) do {\
		MTL_Q0UCR_RGRD(data);\
		data = ((data >> 0) & MTL_Q0UCR_UFPKTCNT_MASK);\
} while (0)

#define MTL_Q0TOMR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xd00))

#define MTL_Q0TOMR_RGWR(data) do {\
		iowrite32(data, (void *)MTL_Q0TOMR_RGOFFADDR);\
} while (0)

#define MTL_Q0TOMR_RGRD(data) do {\
		(data) = ioread32((void *)MTL_Q0TOMR_RGOFFADDR);\
} while (0)

/*#define  MTL_Q0TOMR_Mask_26 (ULONG)(~(~0<<(6)))*/

#define  MTL_Q0TOMR_MASK_26 (ULONG)(0x3f)

/*#define MTL_Q0TOMR_RES_Wr_Mask_26 (ULONG)(~((~(~0<<(6)))<<(26)))*/

#define MTL_Q0TOMR_RES_WR_MASK_26 (ULONG)(0x3ffffff)

/*#define  MTL_Q0TOMR_Mask_7 (ULONG)(~(~0<<(9)))*/

#define  MTL_Q0TOMR_MASK_7 (ULONG)(0x1ff)

/*#define MTL_Q0TOMR_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(9)))<<(7)))*/

#define MTL_Q0TOMR_RES_WR_MASK_7 (ULONG)(0xffff007f)

/*#define MTL_Q0TOMR_TQS_Mask (ULONG)(~(~0<<(10)))*/

#define MTL_Q0TOMR_TQS_MASK (ULONG)(0x3ff)

/*#define MTL_Q0TOMR_TQS_Wr_Mask (ULONG)(~((~(~0 << (10))) << (16)))*/

#define MTL_Q0TOMR_TQS_WR_MASK (ULONG)(0xfc00ffff)

#define MTL_Q0TOMR_TQS_UDFWR(data) do {\
		ULONG v;\
		MTL_Q0TOMR_RGRD(v);\
		v = (v & (MTL_Q0TOMR_RES_WR_MASK_26)) | (((0) & (MTL_Q0TOMR_MASK_26)) << 26);\
		v = (v & (MTL_Q0TOMR_RES_WR_MASK_7)) | (((0) & (MTL_Q0TOMR_MASK_7)) << 7);\
		v = ((v & MTL_Q0TOMR_TQS_WR_MASK) | ((data & MTL_Q0TOMR_TQS_MASK) << 16));\
		MTL_Q0TOMR_RGWR(v);\
} while (0)

#define MTL_Q0TOMR_TQS_UDFRD(data) do {\
		MTL_Q0TOMR_RGRD(data);\
		data = ((data >> 16) & MTL_Q0TOMR_TQS_MASK);\
} while (0)

/*#define MTL_Q0TOMR_TTC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_Q0TOMR_TTC_MASK (ULONG)(0x7)

/*#define MTL_Q0TOMR_TTC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_Q0TOMR_TTC_WR_MASK (ULONG)(0xffffff8f)

#define MTL_Q0TOMR_TTC_UDFWR(data) do {\
		ULONG v;\
		MTL_Q0TOMR_RGRD(v);\
		v = (v & (MTL_Q0TOMR_RES_WR_MASK_26)) | (((0) & (MTL_Q0TOMR_MASK_26)) << 26);\
		v = (v & (MTL_Q0TOMR_RES_WR_MASK_7)) | (((0) & (MTL_Q0TOMR_MASK_7)) << 7);\
		v = ((v & MTL_Q0TOMR_TTC_WR_MASK) | ((data & MTL_Q0TOMR_TTC_MASK) << 4));\
		MTL_Q0TOMR_RGWR(v);\
} while (0)

#define MTL_Q0TOMR_TTC_UDFRD(data) do {\
		MTL_Q0TOMR_RGRD(data);\
		data = ((data >> 4) & MTL_Q0TOMR_TTC_MASK);\
} while (0)

/*#define MTL_Q0TOMR_TXQEN_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_Q0TOMR_TXQEN_MASK (ULONG)(0x3)

/*#define MTL_Q0TOMR_TXQEN_Wr_Mask (ULONG)(~((~(~0 << (2))) << (2)))*/

#define MTL_Q0TOMR_TXQEN_WR_MASK (ULONG)(0xfffffff3)

#define MTL_Q0TOMR_TXQEN_UDFWR(data) do {\
		ULONG v;\
		MTL_Q0TOMR_RGRD(v);\
		v = (v & (MTL_Q0TOMR_RES_WR_MASK_26)) | (((0) & (MTL_Q0TOMR_MASK_26)) << 26);\
		v = (v & (MTL_Q0TOMR_RES_WR_MASK_7)) | (((0) & (MTL_Q0TOMR_MASK_7)) << 7);\
		v = ((v & MTL_Q0TOMR_TXQEN_WR_MASK) | ((data & MTL_Q0TOMR_TXQEN_MASK) << 2));\
		MTL_Q0TOMR_RGWR(v);\
} while (0)

#define MTL_Q0TOMR_TXQEN_UDFRD(data) do {\
		MTL_Q0TOMR_RGRD(data);\
		data = ((data >> 2) & MTL_Q0TOMR_TXQEN_MASK);\
} while (0)

/*#define MTL_Q0TOMR_TSF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0TOMR_TSF_MASK (ULONG)(0x1)

/*#define MTL_Q0TOMR_TSF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MTL_Q0TOMR_TSF_WR_MASK (ULONG)(0xfffffffd)

#define MTL_Q0TOMR_TSF_UDFWR(data) do {\
		ULONG v;\
		MTL_Q0TOMR_RGRD(v);\
		v = (v & (MTL_Q0TOMR_RES_WR_MASK_26)) | (((0) & (MTL_Q0TOMR_MASK_26)) << 26);\
		v = (v & (MTL_Q0TOMR_RES_WR_MASK_7)) | (((0) & (MTL_Q0TOMR_MASK_7)) << 7);\
		v = ((v & MTL_Q0TOMR_TSF_WR_MASK) | ((data & MTL_Q0TOMR_TSF_MASK) << 1));\
		MTL_Q0TOMR_RGWR(v);\
} while (0)

#define MTL_Q0TOMR_TSF_UDFRD(data) do {\
		MTL_Q0TOMR_RGRD(data);\
		data = ((data >> 1) & MTL_Q0TOMR_TSF_MASK);\
} while (0)

/*#define MTL_Q0TOMR_FTQ_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0TOMR_FTQ_MASK (ULONG)(0x1)

/*#define MTL_Q0TOMR_FTQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MTL_Q0TOMR_FTQ_WR_MASK (ULONG)(0xfffffffe)

#define MTL_Q0TOMR_FTQ_UDFWR(data) do {\
		ULONG v;\
		MTL_Q0TOMR_RGRD(v);\
		v = (v & (MTL_Q0TOMR_RES_WR_MASK_26)) | (((0) & (MTL_Q0TOMR_MASK_26)) << 26);\
		v = (v & (MTL_Q0TOMR_RES_WR_MASK_7)) | (((0) & (MTL_Q0TOMR_MASK_7)) << 7);\
		v = ((v & MTL_Q0TOMR_FTQ_WR_MASK) | ((data & MTL_Q0TOMR_FTQ_MASK) << 0));\
		MTL_Q0TOMR_RGWR(v);\
} while (0)

#define MTL_Q0TOMR_FTQ_UDFRD(data) do {\
		MTL_Q0TOMR_RGRD(data);\
		data = ((data >> 0) & MTL_Q0TOMR_FTQ_MASK);\
} while (0)

#define MTL_RQDCM1R_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xc34))

#define MTL_RQDCM1R_RGWR(data) do {\
		iowrite32(data, (void *)MTL_RQDCM1R_RGOFFADDR);\
} while (0)

#define MTL_RQDCM1R_RGRD(data) do {\
		(data) = ioread32((void *)MTL_RQDCM1R_RGOFFADDR);\
} while (0)

/*#define  MTL_RQDCM1R_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_RQDCM1R_MASK_29 (ULONG)(0x7)

/*#define MTL_RQDCM1R_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_RQDCM1R_RES_WR_MASK_29 (ULONG)(0x1fffffff)

/*#define  MTL_RQDCM1R_Mask_27 (ULONG)(~(~0<<(1)))*/

#define  MTL_RQDCM1R_MASK_27 (ULONG)(0x1)

/*#define MTL_RQDCM1R_RES_Wr_Mask_27 (ULONG)(~((~(~0<<(1)))<<(27)))*/

#define MTL_RQDCM1R_RES_WR_MASK_27 (ULONG)(0xf7ffffff)

/*#define  MTL_RQDCM1R_Mask_21 (ULONG)(~(~0<<(3)))*/

#define  MTL_RQDCM1R_MASK_21 (ULONG)(0x7)

/*#define MTL_RQDCM1R_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(3)))<<(21)))*/

#define MTL_RQDCM1R_RES_WR_MASK_21 (ULONG)(0xff1fffff)

/*#define  MTL_RQDCM1R_Mask_19 (ULONG)(~(~0<<(1)))*/

#define  MTL_RQDCM1R_MASK_19 (ULONG)(0x1)

/*#define MTL_RQDCM1R_RES_Wr_Mask_19 (ULONG)(~((~(~0<<(1)))<<(19)))*/

#define MTL_RQDCM1R_RES_WR_MASK_19 (ULONG)(0xfff7ffff)

/*#define  MTL_RQDCM1R_Mask_13 (ULONG)(~(~0<<(3)))*/

#define  MTL_RQDCM1R_MASK_13 (ULONG)(0x7)

/*#define MTL_RQDCM1R_RES_Wr_Mask_13 (ULONG)(~((~(~0<<(3)))<<(13)))*/

#define MTL_RQDCM1R_RES_WR_MASK_13 (ULONG)(0xffff1fff)

/*#define  MTL_RQDCM1R_Mask_11 (ULONG)(~(~0<<(1)))*/

#define  MTL_RQDCM1R_MASK_11 (ULONG)(0x1)

/*#define MTL_RQDCM1R_RES_Wr_Mask_11 (ULONG)(~((~(~0<<(1)))<<(11)))*/

#define MTL_RQDCM1R_RES_WR_MASK_11 (ULONG)(0xfffff7ff)

/*#define  MTL_RQDCM1R_Mask_5 (ULONG)(~(~0<<(3)))*/

#define  MTL_RQDCM1R_MASK_5 (ULONG)(0x7)

/*#define MTL_RQDCM1R_RES_Wr_Mask_5 (ULONG)(~((~(~0<<(3)))<<(5)))*/

#define MTL_RQDCM1R_RES_WR_MASK_5 (ULONG)(0xffffff1f)

/*#define  MTL_RQDCM1R_Mask_3 (ULONG)(~(~0<<(1)))*/

#define  MTL_RQDCM1R_MASK_3 (ULONG)(0x1)

/*#define MTL_RQDCM1R_RES_Wr_Mask_3 (ULONG)(~((~(~0<<(1)))<<(3)))*/

#define MTL_RQDCM1R_RES_WR_MASK_3 (ULONG)(0xfffffff7)

/*#define MTL_RQDCM1R_RXQ7DADMACH_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_RQDCM1R_RXQ7DADMACH_MASK (ULONG)(0x1)

/*#define MTL_RQDCM1R_RXQ7DADMACH_Wr_Mask (ULONG)(~((~(~0 << (1))) << (28)))*/

#define MTL_RQDCM1R_RXQ7DADMACH_WR_MASK (ULONG)(0xefffffff)

#define MTL_RQDCM1R_RXQ7DADMACH_UDFWR(data) do {\
		ULONG v;\
		MTL_RQDCM1R_RGRD(v);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_29)) | (((0) & (MTL_RQDCM1R_MASK_29)) << 29);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_27)) | (((0) & (MTL_RQDCM1R_MASK_27)) << 27);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_21)) | (((0) & (MTL_RQDCM1R_MASK_21)) << 21);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_19)) | (((0) & (MTL_RQDCM1R_MASK_19)) << 19);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_13)) | (((0) & (MTL_RQDCM1R_MASK_13)) << 13);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_11)) | (((0) & (MTL_RQDCM1R_MASK_11)) << 11);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_5)) | (((0) & (MTL_RQDCM1R_MASK_5)) << 5);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_3)) | (((0) & (MTL_RQDCM1R_MASK_3)) << 3);\
		v = ((v & MTL_RQDCM1R_RXQ7DADMACH_WR_MASK) | ((data & MTL_RQDCM1R_RXQ7DADMACH_MASK) << 28));\
		MTL_RQDCM1R_RGWR(v);\
} while (0)

#define MTL_RQDCM1R_RXQ7DADMACH_UDFRD(data) do {\
		MTL_RQDCM1R_RGRD(data);\
		data = ((data >> 28) & MTL_RQDCM1R_RXQ7DADMACH_MASK);\
} while (0)

/*#define MTL_RQDCM1R_RXQ72DMA_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_RQDCM1R_RXQ72DMA_MASK (ULONG)(0x7)

/*#define MTL_RQDCM1R_RXQ72DMA_Wr_Mask (ULONG)(~((~(~0 << (3))) << (24)))*/

#define MTL_RQDCM1R_RXQ72DMA_WR_MASK (ULONG)(0xf8ffffff)

#define MTL_RQDCM1R_RXQ72DMA_UDFWR(data) do {\
		ULONG v;\
		MTL_RQDCM1R_RGRD(v);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_29)) | (((0) & (MTL_RQDCM1R_MASK_29)) << 29);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_27)) | (((0) & (MTL_RQDCM1R_MASK_27)) << 27);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_21)) | (((0) & (MTL_RQDCM1R_MASK_21)) << 21);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_19)) | (((0) & (MTL_RQDCM1R_MASK_19)) << 19);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_13)) | (((0) & (MTL_RQDCM1R_MASK_13)) << 13);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_11)) | (((0) & (MTL_RQDCM1R_MASK_11)) << 11);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_5)) | (((0) & (MTL_RQDCM1R_MASK_5)) << 5);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_3)) | (((0) & (MTL_RQDCM1R_MASK_3)) << 3);\
		v = ((v & MTL_RQDCM1R_RXQ72DMA_WR_MASK) | ((data & MTL_RQDCM1R_RXQ72DMA_MASK) << 24));\
		MTL_RQDCM1R_RGWR(v);\
} while (0)

#define MTL_RQDCM1R_RXQ72DMA_UDFRD(data) do {\
		MTL_RQDCM1R_RGRD(data);\
		data = ((data >> 24) & MTL_RQDCM1R_RXQ72DMA_MASK);\
} while (0)

/*#define MTL_RQDCM1R_RXQ6DADMACH_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_RQDCM1R_RXQ6DADMACH_MASK (ULONG)(0x1)

/*#define MTL_RQDCM1R_RXQ6DADMACH_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MTL_RQDCM1R_RXQ6DADMACH_WR_MASK (ULONG)(0xffefffff)

#define MTL_RQDCM1R_RXQ6DADMACH_UDFWR(data) do {\
		ULONG v;\
		MTL_RQDCM1R_RGRD(v);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_29)) | (((0) & (MTL_RQDCM1R_MASK_29)) << 29);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_27)) | (((0) & (MTL_RQDCM1R_MASK_27)) << 27);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_21)) | (((0) & (MTL_RQDCM1R_MASK_21)) << 21);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_19)) | (((0) & (MTL_RQDCM1R_MASK_19)) << 19);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_13)) | (((0) & (MTL_RQDCM1R_MASK_13)) << 13);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_11)) | (((0) & (MTL_RQDCM1R_MASK_11)) << 11);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_5)) | (((0) & (MTL_RQDCM1R_MASK_5)) << 5);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_3)) | (((0) & (MTL_RQDCM1R_MASK_3)) << 3);\
		v = ((v & MTL_RQDCM1R_RXQ6DADMACH_WR_MASK) | ((data & MTL_RQDCM1R_RXQ6DADMACH_MASK) << 20));\
		MTL_RQDCM1R_RGWR(v);\
} while (0)

#define MTL_RQDCM1R_RXQ6DADMACH_UDFRD(data) do {\
		MTL_RQDCM1R_RGRD(data);\
		data = ((data >> 20) & MTL_RQDCM1R_RXQ6DADMACH_MASK);\
} while (0)

/*#define MTL_RQDCM1R_RXQ26DMA_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_RQDCM1R_RXQ26DMA_MASK (ULONG)(0x7)

/*#define MTL_RQDCM1R_RXQ26DMA_Wr_Mask (ULONG)(~((~(~0 << (3))) << (16)))*/

#define MTL_RQDCM1R_RXQ26DMA_WR_MASK (ULONG)(0xfff8ffff)

#define MTL_RQDCM1R_RXQ26DMA_UDFWR(data) do {\
		ULONG v;\
		MTL_RQDCM1R_RGRD(v);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_29)) | (((0) & (MTL_RQDCM1R_MASK_29)) << 29);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_27)) | (((0) & (MTL_RQDCM1R_MASK_27)) << 27);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_21)) | (((0) & (MTL_RQDCM1R_MASK_21)) << 21);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_19)) | (((0) & (MTL_RQDCM1R_MASK_19)) << 19);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_13)) | (((0) & (MTL_RQDCM1R_MASK_13)) << 13);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_11)) | (((0) & (MTL_RQDCM1R_MASK_11)) << 11);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_5)) | (((0) & (MTL_RQDCM1R_MASK_5)) << 5);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_3)) | (((0) & (MTL_RQDCM1R_MASK_3)) << 3);\
		v = ((v & MTL_RQDCM1R_RXQ26DMA_WR_MASK) | ((data & MTL_RQDCM1R_RXQ26DMA_MASK) << 16));\
		MTL_RQDCM1R_RGWR(v);\
} while (0)

#define MTL_RQDCM1R_RXQ26DMA_UDFRD(data) do {\
		MTL_RQDCM1R_RGRD(data);\
		data = ((data >> 16) & MTL_RQDCM1R_RXQ26DMA_MASK);\
} while (0)

/*#define MTL_RQDCM1R_RXQ5DADMACH_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_RQDCM1R_RXQ5DADMACH_MASK (ULONG)(0x1)

/*#define MTL_RQDCM1R_RXQ5DADMACH_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define MTL_RQDCM1R_RXQ5DADMACH_WR_MASK (ULONG)(0xffffefff)

#define MTL_RQDCM1R_RXQ5DADMACH_UDFWR(data) do {\
		ULONG v;\
		MTL_RQDCM1R_RGRD(v);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_29)) | (((0) & (MTL_RQDCM1R_MASK_29)) << 29);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_27)) | (((0) & (MTL_RQDCM1R_MASK_27)) << 27);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_21)) | (((0) & (MTL_RQDCM1R_MASK_21)) << 21);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_19)) | (((0) & (MTL_RQDCM1R_MASK_19)) << 19);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_13)) | (((0) & (MTL_RQDCM1R_MASK_13)) << 13);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_11)) | (((0) & (MTL_RQDCM1R_MASK_11)) << 11);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_5)) | (((0) & (MTL_RQDCM1R_MASK_5)) << 5);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_3)) | (((0) & (MTL_RQDCM1R_MASK_3)) << 3);\
		v = ((v & MTL_RQDCM1R_RXQ5DADMACH_WR_MASK) | ((data & MTL_RQDCM1R_RXQ5DADMACH_MASK) << 12));\
		MTL_RQDCM1R_RGWR(v);\
} while (0)

#define MTL_RQDCM1R_RXQ5DADMACH_UDFRD(data) do {\
		MTL_RQDCM1R_RGRD(data);\
		data = ((data >> 12) & MTL_RQDCM1R_RXQ5DADMACH_MASK);\
} while (0)

/*#define MTL_RQDCM1R_RXQ25DMA_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_RQDCM1R_RXQ25DMA_MASK (ULONG)(0x7)

/*#define MTL_RQDCM1R_RXQ25DMA_Wr_Mask (ULONG)(~((~(~0 << (3))) << (8)))*/

#define MTL_RQDCM1R_RXQ25DMA_WR_MASK (ULONG)(0xfffff8ff)

#define MTL_RQDCM1R_RXQ25DMA_UDFWR(data) do {\
		ULONG v;\
		MTL_RQDCM1R_RGRD(v);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_29)) | (((0) & (MTL_RQDCM1R_MASK_29)) << 29);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_27)) | (((0) & (MTL_RQDCM1R_MASK_27)) << 27);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_21)) | (((0) & (MTL_RQDCM1R_MASK_21)) << 21);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_19)) | (((0) & (MTL_RQDCM1R_MASK_19)) << 19);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_13)) | (((0) & (MTL_RQDCM1R_MASK_13)) << 13);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_11)) | (((0) & (MTL_RQDCM1R_MASK_11)) << 11);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_5)) | (((0) & (MTL_RQDCM1R_MASK_5)) << 5);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_3)) | (((0) & (MTL_RQDCM1R_MASK_3)) << 3);\
		v = ((v & MTL_RQDCM1R_RXQ25DMA_WR_MASK) | ((data & MTL_RQDCM1R_RXQ25DMA_MASK) << 8));\
		MTL_RQDCM1R_RGWR(v);\
} while (0)

#define MTL_RQDCM1R_RXQ25DMA_UDFRD(data) do {\
		MTL_RQDCM1R_RGRD(data);\
		data = ((data >> 8) & MTL_RQDCM1R_RXQ25DMA_MASK);\
} while (0)

/*#define MTL_RQDCM1R_RXQ4DADMACH_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_RQDCM1R_RXQ4DADMACH_MASK (ULONG)(0x1)

/*#define MTL_RQDCM1R_RXQ4DADMACH_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MTL_RQDCM1R_RXQ4DADMACH_WR_MASK (ULONG)(0xffffffef)

#define MTL_RQDCM1R_RXQ4DADMACH_UDFWR(data) do {\
		ULONG v;\
		MTL_RQDCM1R_RGRD(v);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_29)) | (((0) & (MTL_RQDCM1R_MASK_29)) << 29);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_27)) | (((0) & (MTL_RQDCM1R_MASK_27)) << 27);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_21)) | (((0) & (MTL_RQDCM1R_MASK_21)) << 21);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_19)) | (((0) & (MTL_RQDCM1R_MASK_19)) << 19);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_13)) | (((0) & (MTL_RQDCM1R_MASK_13)) << 13);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_11)) | (((0) & (MTL_RQDCM1R_MASK_11)) << 11);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_5)) | (((0) & (MTL_RQDCM1R_MASK_5)) << 5);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_3)) | (((0) & (MTL_RQDCM1R_MASK_3)) << 3);\
		v = ((v & MTL_RQDCM1R_RXQ4DADMACH_WR_MASK) | ((data & MTL_RQDCM1R_RXQ4DADMACH_MASK) << 4));\
		MTL_RQDCM1R_RGWR(v);\
} while (0)

#define MTL_RQDCM1R_RXQ4DADMACH_UDFRD(data) do {\
		MTL_RQDCM1R_RGRD(data);\
		data = ((data >> 4) & MTL_RQDCM1R_RXQ4DADMACH_MASK);\
} while (0)

/*#define MTL_RQDCM1R_RXQ42DMA_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_RQDCM1R_RXQ42DMA_MASK (ULONG)(0x7)

/*#define MTL_RQDCM1R_RXQ42DMA_Wr_Mask (ULONG)(~((~(~0 << (3))) << (0)))*/

#define MTL_RQDCM1R_RXQ42DMA_WR_MASK (ULONG)(0xfffffff8)

#define MTL_RQDCM1R_RXQ42DMA_UDFWR(data) do {\
		ULONG v;\
		MTL_RQDCM1R_RGRD(v);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_29)) | (((0) & (MTL_RQDCM1R_MASK_29)) << 29);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_27)) | (((0) & (MTL_RQDCM1R_MASK_27)) << 27);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_21)) | (((0) & (MTL_RQDCM1R_MASK_21)) << 21);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_19)) | (((0) & (MTL_RQDCM1R_MASK_19)) << 19);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_13)) | (((0) & (MTL_RQDCM1R_MASK_13)) << 13);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_11)) | (((0) & (MTL_RQDCM1R_MASK_11)) << 11);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_5)) | (((0) & (MTL_RQDCM1R_MASK_5)) << 5);\
		v = (v & (MTL_RQDCM1R_RES_WR_MASK_3)) | (((0) & (MTL_RQDCM1R_MASK_3)) << 3);\
		v = ((v & MTL_RQDCM1R_RXQ42DMA_WR_MASK) | ((data & MTL_RQDCM1R_RXQ42DMA_MASK) << 0));\
		MTL_RQDCM1R_RGWR(v);\
} while (0)

#define MTL_RQDCM1R_RXQ42DMA_UDFRD(data) do {\
		MTL_RQDCM1R_RGRD(data);\
		data = ((data >> 0) & MTL_RQDCM1R_RXQ42DMA_MASK);\
} while (0)

#define MTL_RQDCM0R_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xc30))

#define MTL_RQDCM0R_RGWR(data) do {\
		iowrite32(data, (void *)MTL_RQDCM0R_RGOFFADDR);\
} while (0)

#define MTL_RQDCM0R_RGRD(data) do {\
		(data) = ioread32((void *)MTL_RQDCM0R_RGOFFADDR);\
} while (0)

/*#define  MTL_RQDCM0R_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_RQDCM0R_MASK_29 (ULONG)(0x7)

/*#define MTL_RQDCM0R_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_RQDCM0R_RES_WR_MASK_29 (ULONG)(0x1fffffff)

/*#define  MTL_RQDCM0R_Mask_27 (ULONG)(~(~0<<(1)))*/

#define  MTL_RQDCM0R_MASK_27 (ULONG)(0x1)

/*#define MTL_RQDCM0R_RES_Wr_Mask_27 (ULONG)(~((~(~0<<(1)))<<(27)))*/

#define MTL_RQDCM0R_RES_WR_MASK_27 (ULONG)(0xf7ffffff)

/*#define  MTL_RQDCM0R_Mask_21 (ULONG)(~(~0<<(3)))*/

#define  MTL_RQDCM0R_MASK_21 (ULONG)(0x7)

/*#define MTL_RQDCM0R_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(3)))<<(21)))*/

#define MTL_RQDCM0R_RES_WR_MASK_21 (ULONG)(0xff1fffff)

/*#define  MTL_RQDCM0R_Mask_19 (ULONG)(~(~0<<(1)))*/

#define  MTL_RQDCM0R_MASK_19 (ULONG)(0x1)

/*#define MTL_RQDCM0R_RES_Wr_Mask_19 (ULONG)(~((~(~0<<(1)))<<(19)))*/

#define MTL_RQDCM0R_RES_WR_MASK_19 (ULONG)(0xfff7ffff)

/*#define  MTL_RQDCM0R_Mask_13 (ULONG)(~(~0<<(3)))*/

#define  MTL_RQDCM0R_MASK_13 (ULONG)(0x7)

/*#define MTL_RQDCM0R_RES_Wr_Mask_13 (ULONG)(~((~(~0<<(3)))<<(13)))*/

#define MTL_RQDCM0R_RES_WR_MASK_13 (ULONG)(0xffff1fff)

/*#define  MTL_RQDCM0R_Mask_11 (ULONG)(~(~0<<(1)))*/

#define  MTL_RQDCM0R_MASK_11 (ULONG)(0x1)

/*#define MTL_RQDCM0R_RES_Wr_Mask_11 (ULONG)(~((~(~0<<(1)))<<(11)))*/

#define MTL_RQDCM0R_RES_WR_MASK_11 (ULONG)(0xfffff7ff)

/*#define  MTL_RQDCM0R_Mask_5 (ULONG)(~(~0<<(3)))*/

#define  MTL_RQDCM0R_MASK_5 (ULONG)(0x7)

/*#define MTL_RQDCM0R_RES_Wr_Mask_5 (ULONG)(~((~(~0<<(3)))<<(5)))*/

#define MTL_RQDCM0R_RES_WR_MASK_5 (ULONG)(0xffffff1f)

/*#define  MTL_RQDCM0R_Mask_3 (ULONG)(~(~0<<(1)))*/

#define  MTL_RQDCM0R_MASK_3 (ULONG)(0x1)

/*#define MTL_RQDCM0R_RES_Wr_Mask_3 (ULONG)(~((~(~0<<(1)))<<(3)))*/

#define MTL_RQDCM0R_RES_WR_MASK_3 (ULONG)(0xfffffff7)

/*#define MTL_RQDCM0R_RXQ3DADMACH_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_RQDCM0R_RXQ3DADMACH_MASK (ULONG)(0x1)

/*#define MTL_RQDCM0R_RXQ3DADMACH_Wr_Mask (ULONG)(~((~(~0 << (1))) << (28)))*/

#define MTL_RQDCM0R_RXQ3DADMACH_WR_MASK (ULONG)(0xefffffff)

#define MTL_RQDCM0R_RXQ3DADMACH_UDFWR(data) do {\
		ULONG v;\
		MTL_RQDCM0R_RGRD(v);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_29)) | (((0) & (MTL_RQDCM0R_MASK_29)) << 29);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_27)) | (((0) & (MTL_RQDCM0R_MASK_27)) << 27);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_21)) | (((0) & (MTL_RQDCM0R_MASK_21)) << 21);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_19)) | (((0) & (MTL_RQDCM0R_MASK_19)) << 19);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_13)) | (((0) & (MTL_RQDCM0R_MASK_13)) << 13);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_11)) | (((0) & (MTL_RQDCM0R_MASK_11)) << 11);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_5)) | (((0) & (MTL_RQDCM0R_MASK_5)) << 5);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_3)) | (((0) & (MTL_RQDCM0R_MASK_3)) << 3);\
		v = ((v & MTL_RQDCM0R_RXQ3DADMACH_WR_MASK) | ((data & MTL_RQDCM0R_RXQ3DADMACH_MASK) << 28));\
		MTL_RQDCM0R_RGWR(v);\
} while (0)

#define MTL_RQDCM0R_RXQ3DADMACH_UDFRD(data) do {\
		MTL_RQDCM0R_RGRD(data);\
		data = ((data >> 28) & MTL_RQDCM0R_RXQ3DADMACH_MASK);\
} while (0)

/*#define MTL_RQDCM0R_RXQ32DMA_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_RQDCM0R_RXQ32DMA_MASK (ULONG)(0x7)

/*#define MTL_RQDCM0R_RXQ32DMA_Wr_Mask (ULONG)(~((~(~0 << (3))) << (24)))*/

#define MTL_RQDCM0R_RXQ32DMA_WR_MASK (ULONG)(0xf8ffffff)

#define MTL_RQDCM0R_RXQ32DMA_UDFWR(data) do {\
		ULONG v;\
		MTL_RQDCM0R_RGRD(v);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_29)) | (((0) & (MTL_RQDCM0R_MASK_29)) << 29);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_27)) | (((0) & (MTL_RQDCM0R_MASK_27)) << 27);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_21)) | (((0) & (MTL_RQDCM0R_MASK_21)) << 21);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_19)) | (((0) & (MTL_RQDCM0R_MASK_19)) << 19);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_13)) | (((0) & (MTL_RQDCM0R_MASK_13)) << 13);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_11)) | (((0) & (MTL_RQDCM0R_MASK_11)) << 11);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_5)) | (((0) & (MTL_RQDCM0R_MASK_5)) << 5);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_3)) | (((0) & (MTL_RQDCM0R_MASK_3)) << 3);\
		v = ((v & MTL_RQDCM0R_RXQ32DMA_WR_MASK) | ((data & MTL_RQDCM0R_RXQ32DMA_MASK) << 24));\
		MTL_RQDCM0R_RGWR(v);\
} while (0)

#define MTL_RQDCM0R_RXQ32DMA_UDFRD(data) do {\
		MTL_RQDCM0R_RGRD(data);\
		data = ((data >> 24) & MTL_RQDCM0R_RXQ32DMA_MASK);\
} while (0)

/*#define MTL_RQDCM0R_RXQ2DADMACH_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_RQDCM0R_RXQ2DADMACH_MASK (ULONG)(0x1)

/*#define MTL_RQDCM0R_RXQ2DADMACH_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MTL_RQDCM0R_RXQ2DADMACH_WR_MASK (ULONG)(0xffefffff)

#define MTL_RQDCM0R_RXQ2DADMACH_UDFWR(data) do {\
		ULONG v;\
		MTL_RQDCM0R_RGRD(v);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_29)) | (((0) & (MTL_RQDCM0R_MASK_29)) << 29);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_27)) | (((0) & (MTL_RQDCM0R_MASK_27)) << 27);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_21)) | (((0) & (MTL_RQDCM0R_MASK_21)) << 21);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_19)) | (((0) & (MTL_RQDCM0R_MASK_19)) << 19);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_13)) | (((0) & (MTL_RQDCM0R_MASK_13)) << 13);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_11)) | (((0) & (MTL_RQDCM0R_MASK_11)) << 11);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_5)) | (((0) & (MTL_RQDCM0R_MASK_5)) << 5);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_3)) | (((0) & (MTL_RQDCM0R_MASK_3)) << 3);\
		v = ((v & MTL_RQDCM0R_RXQ2DADMACH_WR_MASK) | ((data & MTL_RQDCM0R_RXQ2DADMACH_MASK) << 20));\
		MTL_RQDCM0R_RGWR(v);\
} while (0)

#define MTL_RQDCM0R_RXQ2DADMACH_UDFRD(data) do {\
		MTL_RQDCM0R_RGRD(data);\
		data = ((data >> 20) & MTL_RQDCM0R_RXQ2DADMACH_MASK);\
} while (0)

/*#define MTL_RQDCM0R_RXQ22DMA_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_RQDCM0R_RXQ22DMA_MASK (ULONG)(0x7)

/*#define MTL_RQDCM0R_RXQ22DMA_Wr_Mask (ULONG)(~((~(~0 << (3))) << (16)))*/

#define MTL_RQDCM0R_RXQ22DMA_WR_MASK (ULONG)(0xfff8ffff)

#define MTL_RQDCM0R_RXQ22DMA_UDFWR(data) do {\
		ULONG v;\
		MTL_RQDCM0R_RGRD(v);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_29)) | (((0) & (MTL_RQDCM0R_MASK_29)) << 29);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_27)) | (((0) & (MTL_RQDCM0R_MASK_27)) << 27);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_21)) | (((0) & (MTL_RQDCM0R_MASK_21)) << 21);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_19)) | (((0) & (MTL_RQDCM0R_MASK_19)) << 19);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_13)) | (((0) & (MTL_RQDCM0R_MASK_13)) << 13);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_11)) | (((0) & (MTL_RQDCM0R_MASK_11)) << 11);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_5)) | (((0) & (MTL_RQDCM0R_MASK_5)) << 5);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_3)) | (((0) & (MTL_RQDCM0R_MASK_3)) << 3);\
		v = ((v & MTL_RQDCM0R_RXQ22DMA_WR_MASK) | ((data & MTL_RQDCM0R_RXQ22DMA_MASK) << 16));\
		MTL_RQDCM0R_RGWR(v);\
} while (0)

#define MTL_RQDCM0R_RXQ22DMA_UDFRD(data) do {\
		MTL_RQDCM0R_RGRD(data);\
		data = ((data >> 16) & MTL_RQDCM0R_RXQ22DMA_MASK);\
} while (0)

/*#define MTL_RQDCM0R_RXQ1DADMACH_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_RQDCM0R_RXQ1DADMACH_MASK (ULONG)(0x1)

/*#define MTL_RQDCM0R_RXQ1DADMACH_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define MTL_RQDCM0R_RXQ1DADMACH_WR_MASK (ULONG)(0xffffefff)

#define MTL_RQDCM0R_RXQ1DADMACH_UDFWR(data) do {\
		ULONG v;\
		MTL_RQDCM0R_RGRD(v);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_29)) | (((0) & (MTL_RQDCM0R_MASK_29)) << 29);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_27)) | (((0) & (MTL_RQDCM0R_MASK_27)) << 27);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_21)) | (((0) & (MTL_RQDCM0R_MASK_21)) << 21);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_19)) | (((0) & (MTL_RQDCM0R_MASK_19)) << 19);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_13)) | (((0) & (MTL_RQDCM0R_MASK_13)) << 13);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_11)) | (((0) & (MTL_RQDCM0R_MASK_11)) << 11);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_5)) | (((0) & (MTL_RQDCM0R_MASK_5)) << 5);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_3)) | (((0) & (MTL_RQDCM0R_MASK_3)) << 3);\
		v = ((v & MTL_RQDCM0R_RXQ1DADMACH_WR_MASK) | ((data & MTL_RQDCM0R_RXQ1DADMACH_MASK) << 12));\
		MTL_RQDCM0R_RGWR(v);\
} while (0)

#define MTL_RQDCM0R_RXQ1DADMACH_UDFRD(data) do {\
		MTL_RQDCM0R_RGRD(data);\
		data = ((data >> 12) & MTL_RQDCM0R_RXQ1DADMACH_MASK);\
} while (0)

/*#define MTL_RQDCM0R_RXQ12DMA_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_RQDCM0R_RXQ12DMA_MASK (ULONG)(0x7)

/*#define MTL_RQDCM0R_RXQ12DMA_Wr_Mask (ULONG)(~((~(~0 << (3))) << (8)))*/

#define MTL_RQDCM0R_RXQ12DMA_WR_MASK (ULONG)(0xfffff8ff)

#define MTL_RQDCM0R_RXQ12DMA_UDFWR(data) do {\
		ULONG v;\
		MTL_RQDCM0R_RGRD(v);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_29)) | (((0) & (MTL_RQDCM0R_MASK_29)) << 29);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_27)) | (((0) & (MTL_RQDCM0R_MASK_27)) << 27);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_21)) | (((0) & (MTL_RQDCM0R_MASK_21)) << 21);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_19)) | (((0) & (MTL_RQDCM0R_MASK_19)) << 19);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_13)) | (((0) & (MTL_RQDCM0R_MASK_13)) << 13);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_11)) | (((0) & (MTL_RQDCM0R_MASK_11)) << 11);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_5)) | (((0) & (MTL_RQDCM0R_MASK_5)) << 5);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_3)) | (((0) & (MTL_RQDCM0R_MASK_3)) << 3);\
		v = ((v & MTL_RQDCM0R_RXQ12DMA_WR_MASK) | ((data & MTL_RQDCM0R_RXQ12DMA_MASK) << 8));\
		MTL_RQDCM0R_RGWR(v);\
} while (0)

#define MTL_RQDCM0R_RXQ12DMA_UDFRD(data) do {\
		MTL_RQDCM0R_RGRD(data);\
		data = ((data >> 8) & MTL_RQDCM0R_RXQ12DMA_MASK);\
} while (0)

/*#define MTL_RQDCM0R_RXQ0DADMACH_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_RQDCM0R_RXQ0DADMACH_MASK (ULONG)(0x1)

/*#define MTL_RQDCM0R_RXQ0DADMACH_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MTL_RQDCM0R_RXQ0DADMACH_WR_MASK (ULONG)(0xffffffef)

#define MTL_RQDCM0R_RXQ0DADMACH_UDFWR(data) do {\
		ULONG v;\
		MTL_RQDCM0R_RGRD(v);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_29)) | (((0) & (MTL_RQDCM0R_MASK_29)) << 29);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_27)) | (((0) & (MTL_RQDCM0R_MASK_27)) << 27);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_21)) | (((0) & (MTL_RQDCM0R_MASK_21)) << 21);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_19)) | (((0) & (MTL_RQDCM0R_MASK_19)) << 19);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_13)) | (((0) & (MTL_RQDCM0R_MASK_13)) << 13);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_11)) | (((0) & (MTL_RQDCM0R_MASK_11)) << 11);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_5)) | (((0) & (MTL_RQDCM0R_MASK_5)) << 5);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_3)) | (((0) & (MTL_RQDCM0R_MASK_3)) << 3);\
		v = ((v & MTL_RQDCM0R_RXQ0DADMACH_WR_MASK) | ((data & MTL_RQDCM0R_RXQ0DADMACH_MASK) << 4));\
		MTL_RQDCM0R_RGWR(v);\
} while (0)

#define MTL_RQDCM0R_RXQ0DADMACH_UDFRD(data) do {\
		MTL_RQDCM0R_RGRD(data);\
		data = ((data >> 4) & MTL_RQDCM0R_RXQ0DADMACH_MASK);\
} while (0)

/*#define MTL_RQDCM0R_RXQ02DMA_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_RQDCM0R_RXQ02DMA_MASK (ULONG)(0x7)

/*#define MTL_RQDCM0R_RXQ02DMA_Wr_Mask (ULONG)(~((~(~0 << (3))) << (0)))*/

#define MTL_RQDCM0R_RXQ02DMA_WR_MASK (ULONG)(0xfffffff8)

#define MTL_RQDCM0R_RXQ02DMA_UDFWR(data) do {\
		ULONG v;\
		MTL_RQDCM0R_RGRD(v);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_29)) | (((0) & (MTL_RQDCM0R_MASK_29)) << 29);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_27)) | (((0) & (MTL_RQDCM0R_MASK_27)) << 27);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_21)) | (((0) & (MTL_RQDCM0R_MASK_21)) << 21);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_19)) | (((0) & (MTL_RQDCM0R_MASK_19)) << 19);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_13)) | (((0) & (MTL_RQDCM0R_MASK_13)) << 13);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_11)) | (((0) & (MTL_RQDCM0R_MASK_11)) << 11);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_5)) | (((0) & (MTL_RQDCM0R_MASK_5)) << 5);\
		v = (v & (MTL_RQDCM0R_RES_WR_MASK_3)) | (((0) & (MTL_RQDCM0R_MASK_3)) << 3);\
		v = ((v & MTL_RQDCM0R_RXQ02DMA_WR_MASK) | ((data & MTL_RQDCM0R_RXQ02DMA_MASK) << 0));\
		MTL_RQDCM0R_RGWR(v);\
} while (0)

#define MTL_RQDCM0R_RXQ02DMA_UDFRD(data) do {\
		MTL_RQDCM0R_RGRD(data);\
		data = ((data >> 0) & MTL_RQDCM0R_RXQ02DMA_MASK);\
} while (0)

#define MTL_FDDR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xc10))

#define MTL_FDDR_RGWR(data) do {\
		iowrite32(data, (void *)MTL_FDDR_RGOFFADDR);\
} while (0)

#define MTL_FDDR_RGRD(data) do {\
		(data) = ioread32((void *)MTL_FDDR_RGOFFADDR);\
} while (0)

#define MTL_FDDR_FDBGDATA_UDFWR(data) do {\
		MTL_FDDR_RGWR(data);\
} while (0)

#define MTL_FDDR_FDBGDATA_UDFRD(data) do {\
		MTL_FDDR_RGRD(data);\
} while (0)

#define MTL_FDACS_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xc08))

#define MTL_FDACS_RGWR(data) do {\
		iowrite32(data, (void *)MTL_FDACS_RGOFFADDR);\
} while (0)

#define MTL_FDACS_RGRD(data) do {\
		(data) = ioread32((void *)MTL_FDACS_RGOFFADDR);\
} while (0)

/*#define  MTL_FDACS_Mask_16 (ULONG)(~(~0<<(16)))*/

#define  MTL_FDACS_MASK_16 (ULONG)(0xffff)

/*#define MTL_FDACS_RES_Wr_Mask_16 (ULONG)(~((~(~0<<(16)))<<(16)))*/

#define MTL_FDACS_RES_WR_MASK_16 (ULONG)(0xffff)

/*#define  MTL_FDACS_Mask_7 (ULONG)(~(~0<<(1)))*/

#define  MTL_FDACS_MASK_7 (ULONG)(0x1)

/*#define MTL_FDACS_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(1)))<<(7)))*/

#define MTL_FDACS_RES_WR_MASK_7 (ULONG)(0xffffff7f)

/*#define  MTL_FDACS_Mask_4 (ULONG)(~(~0<<(1)))*/

#define  MTL_FDACS_MASK_4 (ULONG)(0x1)

/*#define MTL_FDACS_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(1)))<<(4)))*/

#define MTL_FDACS_RES_WR_MASK_4 (ULONG)(0xffffffef)

/*#define MTL_FDACS_STSE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_FDACS_STSE_MASK (ULONG)(0x1)

/*#define MTL_FDACS_STSE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (15)))*/

#define MTL_FDACS_STSE_WR_MASK (ULONG)(0xffff7fff)

#define MTL_FDACS_STSE_UDFWR(data) do {\
		ULONG v;\
		MTL_FDACS_RGRD(v);\
		v = (v & (MTL_FDACS_RES_WR_MASK_16)) | (((0) & (MTL_FDACS_MASK_16)) << 16);\
		v = (v & (MTL_FDACS_RES_WR_MASK_7)) | (((0) & (MTL_FDACS_MASK_7)) << 7);\
		v = (v & (MTL_FDACS_RES_WR_MASK_4)) | (((0) & (MTL_FDACS_MASK_4)) << 4);\
		v = ((v & MTL_FDACS_STSE_WR_MASK) | ((data & MTL_FDACS_STSE_MASK) << 15));\
		MTL_FDACS_RGWR(v);\
} while (0)

#define MTL_FDACS_STSE_UDFRD(data) do {\
		MTL_FDACS_RGRD(data);\
		data = ((data >> 15) & MTL_FDACS_STSE_MASK);\
} while (0)

/*#define MTL_FDACS_PKTE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_FDACS_PKTE_MASK (ULONG)(0x1)

/*#define MTL_FDACS_PKTE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (14)))*/

#define MTL_FDACS_PKTE_WR_MASK (ULONG)(0xffffbfff)

#define MTL_FDACS_PKTE_UDFWR(data) do {\
		ULONG v;\
		MTL_FDACS_RGRD(v);\
		v = (v & (MTL_FDACS_RES_WR_MASK_16)) | (((0) & (MTL_FDACS_MASK_16)) << 16);\
		v = (v & (MTL_FDACS_RES_WR_MASK_7)) | (((0) & (MTL_FDACS_MASK_7)) << 7);\
		v = (v & (MTL_FDACS_RES_WR_MASK_4)) | (((0) & (MTL_FDACS_MASK_4)) << 4);\
		v = ((v & MTL_FDACS_PKTE_WR_MASK) | ((data & MTL_FDACS_PKTE_MASK) << 14));\
		MTL_FDACS_RGWR(v);\
} while (0)

#define MTL_FDACS_PKTE_UDFRD(data) do {\
		MTL_FDACS_RGRD(data);\
		data = ((data >> 14) & MTL_FDACS_PKTE_MASK);\
} while (0)

/*#define MTL_FDACS_FIFOSEL_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_FDACS_FIFOSEL_MASK (ULONG)(0x3)

/*#define MTL_FDACS_FIFOSEL_Wr_Mask (ULONG)(~((~(~0 << (2))) << (12)))*/

#define MTL_FDACS_FIFOSEL_WR_MASK (ULONG)(0xffffcfff)

#define MTL_FDACS_FIFOSEL_UDFWR(data) do {\
		ULONG v;\
		MTL_FDACS_RGRD(v);\
		v = (v & (MTL_FDACS_RES_WR_MASK_16)) | (((0) & (MTL_FDACS_MASK_16)) << 16);\
		v = (v & (MTL_FDACS_RES_WR_MASK_7)) | (((0) & (MTL_FDACS_MASK_7)) << 7);\
		v = (v & (MTL_FDACS_RES_WR_MASK_4)) | (((0) & (MTL_FDACS_MASK_4)) << 4);\
		v = ((v & MTL_FDACS_FIFOSEL_WR_MASK) | ((data & MTL_FDACS_FIFOSEL_MASK) << 12));\
		MTL_FDACS_RGWR(v);\
} while (0)

#define MTL_FDACS_FIFOSEL_UDFRD(data) do {\
		MTL_FDACS_RGRD(data);\
		data = ((data >> 12) & MTL_FDACS_FIFOSEL_MASK);\
} while (0)

/*#define MTL_FDACS_FIFOWREN_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_FDACS_FIFOWREN_MASK (ULONG)(0x1)

/*#define MTL_FDACS_FIFOWREN_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MTL_FDACS_FIFOWREN_WR_MASK (ULONG)(0xfffff7ff)

#define MTL_FDACS_FIFOWREN_UDFWR(data) do {\
		ULONG v;\
		MTL_FDACS_RGRD(v);\
		v = (v & (MTL_FDACS_RES_WR_MASK_16)) | (((0) & (MTL_FDACS_MASK_16)) << 16);\
		v = (v & (MTL_FDACS_RES_WR_MASK_7)) | (((0) & (MTL_FDACS_MASK_7)) << 7);\
		v = (v & (MTL_FDACS_RES_WR_MASK_4)) | (((0) & (MTL_FDACS_MASK_4)) << 4);\
		v = ((v & MTL_FDACS_FIFOWREN_WR_MASK) | ((data & MTL_FDACS_FIFOWREN_MASK) << 11));\
		MTL_FDACS_RGWR(v);\
} while (0)

#define MTL_FDACS_FIFOWREN_UDFRD(data) do {\
		MTL_FDACS_RGRD(data);\
		data = ((data >> 11) & MTL_FDACS_FIFOWREN_MASK);\
} while (0)

/*#define MTL_FDACS_FIFORDEN_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_FDACS_FIFORDEN_MASK (ULONG)(0x1)

/*#define MTL_FDACS_FIFORDEN_Wr_Mask (ULONG)(~((~(~0 << (1))) << (10)))*/

#define MTL_FDACS_FIFORDEN_WR_MASK (ULONG)(0xfffffbff)

#define MTL_FDACS_FIFORDEN_UDFWR(data) do {\
		ULONG v;\
		MTL_FDACS_RGRD(v);\
		v = (v & (MTL_FDACS_RES_WR_MASK_16)) | (((0) & (MTL_FDACS_MASK_16)) << 16);\
		v = (v & (MTL_FDACS_RES_WR_MASK_7)) | (((0) & (MTL_FDACS_MASK_7)) << 7);\
		v = (v & (MTL_FDACS_RES_WR_MASK_4)) | (((0) & (MTL_FDACS_MASK_4)) << 4);\
		v = ((v & MTL_FDACS_FIFORDEN_WR_MASK) | ((data & MTL_FDACS_FIFORDEN_MASK) << 10));\
		MTL_FDACS_RGWR(v);\
} while (0)

#define MTL_FDACS_FIFORDEN_UDFRD(data) do {\
		MTL_FDACS_RGRD(data);\
		data = ((data >> 10) & MTL_FDACS_FIFORDEN_MASK);\
} while (0)

/*#define MTL_FDACS_RSTSEL_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_FDACS_RSTSEL_MASK (ULONG)(0x1)

/*#define MTL_FDACS_RSTSEL_Wr_Mask (ULONG)(~((~(~0 << (1))) << (9)))*/

#define MTL_FDACS_RSTSEL_WR_MASK (ULONG)(0xfffffdff)

#define MTL_FDACS_RSTSEL_UDFWR(data) do {\
		ULONG v;\
		MTL_FDACS_RGRD(v);\
		v = (v & (MTL_FDACS_RES_WR_MASK_16)) | (((0) & (MTL_FDACS_MASK_16)) << 16);\
		v = (v & (MTL_FDACS_RES_WR_MASK_7)) | (((0) & (MTL_FDACS_MASK_7)) << 7);\
		v = (v & (MTL_FDACS_RES_WR_MASK_4)) | (((0) & (MTL_FDACS_MASK_4)) << 4);\
		v = ((v & MTL_FDACS_RSTSEL_WR_MASK) | ((data & MTL_FDACS_RSTSEL_MASK) << 9));\
		MTL_FDACS_RGWR(v);\
} while (0)

#define MTL_FDACS_RSTSEL_UDFRD(data) do {\
		MTL_FDACS_RGRD(data);\
		data = ((data >> 9) & MTL_FDACS_RSTSEL_MASK);\
} while (0)

/*#define MTL_FDACS_RSTALL_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_FDACS_RSTALL_MASK (ULONG)(0x1)

/*#define MTL_FDACS_RSTALL_Wr_Mask (ULONG)(~((~(~0 << (1))) << (8)))*/

#define MTL_FDACS_RSTALL_WR_MASK (ULONG)(0xfffffeff)

#define MTL_FDACS_RSTALL_UDFWR(data) do {\
		ULONG v;\
		MTL_FDACS_RGRD(v);\
		v = (v & (MTL_FDACS_RES_WR_MASK_16)) | (((0) & (MTL_FDACS_MASK_16)) << 16);\
		v = (v & (MTL_FDACS_RES_WR_MASK_7)) | (((0) & (MTL_FDACS_MASK_7)) << 7);\
		v = (v & (MTL_FDACS_RES_WR_MASK_4)) | (((0) & (MTL_FDACS_MASK_4)) << 4);\
		v = ((v & MTL_FDACS_RSTALL_WR_MASK) | ((data & MTL_FDACS_RSTALL_MASK) << 8));\
		MTL_FDACS_RGWR(v);\
} while (0)

#define MTL_FDACS_RSTALL_UDFRD(data) do {\
		MTL_FDACS_RGRD(data);\
		data = ((data >> 8) & MTL_FDACS_RSTALL_MASK);\
} while (0)

/*#define MTL_FDACS_PKTSTATE_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_FDACS_PKTSTATE_MASK (ULONG)(0x3)

/*#define MTL_FDACS_PKTSTATE_Wr_Mask (ULONG)(~((~(~0 << (2))) << (5)))*/

#define MTL_FDACS_PKTSTATE_WR_MASK (ULONG)(0xffffff9f)

#define MTL_FDACS_PKTSTATE_UDFWR(data) do {\
		ULONG v;\
		MTL_FDACS_RGRD(v);\
		v = (v & (MTL_FDACS_RES_WR_MASK_16)) | (((0) & (MTL_FDACS_MASK_16)) << 16);\
		v = (v & (MTL_FDACS_RES_WR_MASK_7)) | (((0) & (MTL_FDACS_MASK_7)) << 7);\
		v = (v & (MTL_FDACS_RES_WR_MASK_4)) | (((0) & (MTL_FDACS_MASK_4)) << 4);\
		v = ((v & MTL_FDACS_PKTSTATE_WR_MASK) | ((data & MTL_FDACS_PKTSTATE_MASK) << 5));\
		MTL_FDACS_RGWR(v);\
} while (0)

#define MTL_FDACS_PKTSTATE_UDFRD(data) do {\
		MTL_FDACS_RGRD(data);\
		data = ((data >> 5) & MTL_FDACS_PKTSTATE_MASK);\
} while (0)

/*#define MTL_FDACS_BYTEEN_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_FDACS_BYTEEN_MASK (ULONG)(0x3)

/*#define MTL_FDACS_BYTEEN_Wr_Mask (ULONG)(~((~(~0 << (2))) << (2)))*/

#define MTL_FDACS_BYTEEN_WR_MASK (ULONG)(0xfffffff3)

#define MTL_FDACS_BYTEEN_UDFWR(data) do {\
		ULONG v;\
		MTL_FDACS_RGRD(v);\
		v = (v & (MTL_FDACS_RES_WR_MASK_16)) | (((0) & (MTL_FDACS_MASK_16)) << 16);\
		v = (v & (MTL_FDACS_RES_WR_MASK_7)) | (((0) & (MTL_FDACS_MASK_7)) << 7);\
		v = (v & (MTL_FDACS_RES_WR_MASK_4)) | (((0) & (MTL_FDACS_MASK_4)) << 4);\
		v = ((v & MTL_FDACS_BYTEEN_WR_MASK) | ((data & MTL_FDACS_BYTEEN_MASK) << 2));\
		MTL_FDACS_RGWR(v);\
} while (0)

#define MTL_FDACS_BYTEEN_UDFRD(data) do {\
		MTL_FDACS_RGRD(data);\
		data = ((data >> 2) & MTL_FDACS_BYTEEN_MASK);\
} while (0)

/*#define MTL_FDACS_DEGMOD_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_FDACS_DEGMOD_MASK (ULONG)(0x1)

/*#define MTL_FDACS_DEGMOD_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MTL_FDACS_DEGMOD_WR_MASK (ULONG)(0xfffffffd)

#define MTL_FDACS_DEGMOD_UDFWR(data) do {\
		ULONG v;\
		MTL_FDACS_RGRD(v);\
		v = (v & (MTL_FDACS_RES_WR_MASK_16)) | (((0) & (MTL_FDACS_MASK_16)) << 16);\
		v = (v & (MTL_FDACS_RES_WR_MASK_7)) | (((0) & (MTL_FDACS_MASK_7)) << 7);\
		v = (v & (MTL_FDACS_RES_WR_MASK_4)) | (((0) & (MTL_FDACS_MASK_4)) << 4);\
		v = ((v & MTL_FDACS_DEGMOD_WR_MASK) | ((data & MTL_FDACS_DEGMOD_MASK) << 1));\
		MTL_FDACS_RGWR(v);\
} while (0)

#define MTL_FDACS_DEGMOD_UDFRD(data) do {\
		MTL_FDACS_RGRD(data);\
		data = ((data >> 1) & MTL_FDACS_DEGMOD_MASK);\
} while (0)

/*#define MTL_FDACS_FDBGEN_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_FDACS_FDBGEN_MASK (ULONG)(0x1)

/*#define MTL_FDACS_FDBGEN_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MTL_FDACS_FDBGEN_WR_MASK (ULONG)(0xfffffffe)

#define MTL_FDACS_FDBGEN_UDFWR(data) do {\
		ULONG v;\
		MTL_FDACS_RGRD(v);\
		v = (v & (MTL_FDACS_RES_WR_MASK_16)) | (((0) & (MTL_FDACS_MASK_16)) << 16);\
		v = (v & (MTL_FDACS_RES_WR_MASK_7)) | (((0) & (MTL_FDACS_MASK_7)) << 7);\
		v = (v & (MTL_FDACS_RES_WR_MASK_4)) | (((0) & (MTL_FDACS_MASK_4)) << 4);\
		v = ((v & MTL_FDACS_FDBGEN_WR_MASK) | ((data & MTL_FDACS_FDBGEN_MASK) << 0));\
		MTL_FDACS_RGWR(v);\
} while (0)

#define MTL_FDACS_FDBGEN_UDFRD(data) do {\
		MTL_FDACS_RGRD(data);\
		data = ((data >> 0) & MTL_FDACS_FDBGEN_MASK);\
} while (0)

#define MTL_OMR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xc00))

#define MTL_OMR_RGWR(data) do {\
		iowrite32(data, (void *)MTL_OMR_RGOFFADDR);\
} while (0)

#define MTL_OMR_RGRD(data) do {\
		(data) = ioread32((void *)MTL_OMR_RGOFFADDR);\
} while (0)

/*#define  MTL_OMR_Mask_7 (ULONG)(~(~0<<(25)))*/

#define  MTL_OMR_MASK_7 (ULONG)(0x1ffffff)

/*#define MTL_OMR_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(25)))<<(7)))*/

#define MTL_OMR_RES_WR_MASK_7 (ULONG)(0x7f)

/*#define  MTL_OMR_Mask_0 (ULONG)(~(~0<<(1)))*/

#define  MTL_OMR_MASK_0 (ULONG)(0x1)

/*#define MTL_OMR_RES_Wr_Mask_0 (ULONG)(~((~(~0<<(1)))<<(0)))*/

#define MTL_OMR_RES_WR_MASK_0 (ULONG)(0xfffffffe)

/*#define MTL_OMR_SCHALG_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_OMR_SCHALG_MASK (ULONG)(0x3)

/*#define MTL_OMR_SCHALG_Wr_Mask (ULONG)(~((~(~0 << (2))) << (5)))*/

#define MTL_OMR_SCHALG_WR_MASK (ULONG)(0xffffff9f)

#define MTL_OMR_SCHALG_UDFWR(data) do {\
		ULONG v;\
		MTL_OMR_RGRD(v);\
		v = ((v & MTL_OMR_SCHALG_WR_MASK) | ((data & MTL_OMR_SCHALG_MASK) << 5));\
		MTL_OMR_RGWR(v);\
} while (0)

#define MTL_OMR_SCHALG_UDFRD(data) do {\
		MTL_OMR_RGRD(data);\
		data = ((data >> 5) & MTL_OMR_SCHALG_MASK);\
} while (0)

/*#define MTL_OMR_RAA_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_OMR_RAA_MASK (ULONG)(0x7)

/*#define MTL_OMR_RAA_Wr_Mask (ULONG)(~((~(~0 << (3))) << (2)))*/

#define MTL_OMR_RAA_WR_MASK (ULONG)(0xffffffe3)

#define MTL_OMR_RAA_UDFWR(data) do {\
		ULONG v;\
		MTL_OMR_RGRD(v);\
		v = ((v & MTL_OMR_RAA_WR_MASK) | ((data & MTL_OMR_RAA_MASK) << 2));\
		MTL_OMR_RGWR(v);\
} while (0)

#define MTL_OMR_RAA_UDFRD(data) do {\
		MTL_OMR_RGRD(data);\
		data = ((data >> 2) & MTL_OMR_RAA_MASK);\
} while (0)

/*#define MTL_OMR_DTXSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_OMR_DTXSTS_MASK (ULONG)(0x1)

/*#define MTL_OMR_DTXSTS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MTL_OMR_DTXSTS_WR_MASK (ULONG)(0xfffffffd)

#define MTL_OMR_DTXSTS_UDFWR(data) do {\
		ULONG v;\
		MTL_OMR_RGRD(v);\
		v = (v & (MTL_OMR_RES_WR_MASK_7)) | (((0) & (MTL_OMR_MASK_7)) << 7);\
		v = (v & (MTL_OMR_RES_WR_MASK_0)) | (((0) & (MTL_OMR_MASK_0)) << 0);\
		v = ((v & MTL_OMR_DTXSTS_WR_MASK) | ((data & MTL_OMR_DTXSTS_MASK) << 1));\
		MTL_OMR_RGWR(v);\
} while (0)

#define MTL_OMR_DTXSTS_UDFRD(data) do {\
		MTL_OMR_RGRD(data);\
		data = ((data >> 1) & MTL_OMR_DTXSTS_MASK);\
} while (0)

#define MAC_RQC3R_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xac))

#define MAC_RQC3R_RGWR(data) do {\
		iowrite32(data, (void *)MAC_RQC3R_RGOFFADDR);\
} while (0)

#define MAC_RQC3R_RGRD(data) do {\
		(data) = ioread32((void *)MAC_RQC3R_RGOFFADDR);\
} while (0)

/*#define MAC_RQC3R_PSRQ7_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_RQC3R_PSRQ7_MASK (ULONG)(0xff)

/*#define MAC_RQC3R_PSRQ7_Wr_Mask (ULONG)(~((~(~0 << (8))) << (24)))*/

#define MAC_RQC3R_PSRQ7_WR_MASK (ULONG)(0xffffff)

#define MAC_RQC3R_PSRQ7_UDFWR(data) do {\
		ULONG v;\
		MAC_RQC3R_RGRD(v);\
		v = ((v & MAC_RQC3R_PSRQ7_WR_MASK) | ((data & MAC_RQC3R_PSRQ7_MASK) << 24));\
		MAC_RQC3R_RGWR(v);\
} while (0)

#define MAC_RQC3R_PSRQ7_UDFRD(data) do {\
		MAC_RQC3R_RGRD(data);\
		data = ((data >> 24) & MAC_RQC3R_PSRQ7_MASK);\
} while (0)

/*#define MAC_RQC3R_PSRQ6_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_RQC3R_PSRQ6_MASK (ULONG)(0xff)

/*#define MAC_RQC3R_PSRQ6_Wr_Mask (ULONG)(~((~(~0 << (8))) << (16)))*/

#define MAC_RQC3R_PSRQ6_WR_MASK (ULONG)(0xff00ffff)

#define MAC_RQC3R_PSRQ6_UDFWR(data) do {\
		ULONG v;\
		MAC_RQC3R_RGRD(v);\
		v = ((v & MAC_RQC3R_PSRQ6_WR_MASK) | ((data & MAC_RQC3R_PSRQ6_MASK) << 16));\
		MAC_RQC3R_RGWR(v);\
} while (0)

#define MAC_RQC3R_PSRQ6_UDFRD(data) do {\
		MAC_RQC3R_RGRD(data);\
		data = ((data >> 16) & MAC_RQC3R_PSRQ6_MASK);\
} while (0)

/*#define MAC_RQC3R_PSRQ5_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_RQC3R_PSRQ5_MASK (ULONG)(0xff)

/*#define MAC_RQC3R_PSRQ5_Wr_Mask (ULONG)(~((~(~0 << (8))) << (8)))*/

#define MAC_RQC3R_PSRQ5_WR_MASK (ULONG)(0xffff00ff)

#define MAC_RQC3R_PSRQ5_UDFWR(data) do {\
		ULONG v;\
		MAC_RQC3R_RGRD(v);\
		v = ((v & MAC_RQC3R_PSRQ5_WR_MASK) | ((data & MAC_RQC3R_PSRQ5_MASK) << 8));\
		MAC_RQC3R_RGWR(v);\
} while (0)

#define MAC_RQC3R_PSRQ5_UDFRD(data) do {\
		MAC_RQC3R_RGRD(data);\
		data = ((data >> 8) & MAC_RQC3R_PSRQ5_MASK);\
} while (0)

/*#define MAC_RQC3R_PSRQ4_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_RQC3R_PSRQ4_MASK (ULONG)(0xff)

/*#define MAC_RQC3R_PSRQ4_Wr_Mask (ULONG)(~((~(~0 << (8))) << (0)))*/

#define MAC_RQC3R_PSRQ4_WR_MASK (ULONG)(0xffffff00)

#define MAC_RQC3R_PSRQ4_UDFWR(data) do {\
		ULONG v;\
		MAC_RQC3R_RGRD(v);\
		v = ((v & MAC_RQC3R_PSRQ4_WR_MASK) | ((data & MAC_RQC3R_PSRQ4_MASK) << 0));\
		MAC_RQC3R_RGWR(v);\
} while (0)

#define MAC_RQC3R_PSRQ4_UDFRD(data) do {\
		MAC_RQC3R_RGRD(data);\
		data = ((data >> 0) & MAC_RQC3R_PSRQ4_MASK);\
} while (0)

#define MAC_RQC2R_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xa8))

#define MAC_RQC2R_RGWR(data) do {\
		iowrite32(data, (void *)MAC_RQC2R_RGOFFADDR);\
} while (0)

#define MAC_RQC2R_RGRD(data) do {\
		(data) = ioread32((void *)MAC_RQC2R_RGOFFADDR);\
} while (0)

/*#define MAC_RQC2R_PSRQ3_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_RQC2R_PSRQ3_MASK (ULONG)(0xff)

/*#define MAC_RQC2R_PSRQ3_Wr_Mask (ULONG)(~((~(~0 << (8))) << (24)))*/

#define MAC_RQC2R_PSRQ3_WR_MASK (ULONG)(0xffffff)

#define MAC_RQC2R_PSRQ3_UDFWR(data) do {\
		ULONG v;\
		MAC_RQC2R_RGRD(v);\
		v = ((v & MAC_RQC2R_PSRQ3_WR_MASK) | ((data & MAC_RQC2R_PSRQ3_MASK) << 24));\
		MAC_RQC2R_RGWR(v);\
} while (0)

#define MAC_RQC2R_PSRQ3_UDFRD(data) do {\
		MAC_RQC2R_RGRD(data);\
		data = ((data >> 24) & MAC_RQC2R_PSRQ3_MASK);\
} while (0)

/*#define MAC_RQC2R_PSRQ2_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_RQC2R_PSRQ2_MASK (ULONG)(0xff)

/*#define MAC_RQC2R_PSRQ2_Wr_Mask (ULONG)(~((~(~0 << (8))) << (16)))*/

#define MAC_RQC2R_PSRQ2_WR_MASK (ULONG)(0xff00ffff)

#define MAC_RQC2R_PSRQ2_UDFWR(data) do {\
		ULONG v;\
		MAC_RQC2R_RGRD(v);\
		v = ((v & MAC_RQC2R_PSRQ2_WR_MASK) | ((data & MAC_RQC2R_PSRQ2_MASK) << 16));\
		MAC_RQC2R_RGWR(v);\
} while (0)

#define MAC_RQC2R_PSRQ2_UDFRD(data) do {\
		MAC_RQC2R_RGRD(data);\
		data = ((data >> 16) & MAC_RQC2R_PSRQ2_MASK);\
} while (0)

/*#define MAC_RQC2R_PSRQ1_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_RQC2R_PSRQ1_MASK (ULONG)(0xff)

/*#define MAC_RQC2R_PSRQ1_Wr_Mask (ULONG)(~((~(~0 << (8))) << (8)))*/

#define MAC_RQC2R_PSRQ1_WR_MASK (ULONG)(0xffff00ff)

#define MAC_RQC2R_PSRQ1_UDFWR(data) do {\
		ULONG v;\
		MAC_RQC2R_RGRD(v);\
		v = ((v & MAC_RQC2R_PSRQ1_WR_MASK) | ((data & MAC_RQC2R_PSRQ1_MASK) << 8));\
		MAC_RQC2R_RGWR(v);\
} while (0)

#define MAC_RQC2R_PSRQ1_UDFRD(data) do {\
		MAC_RQC2R_RGRD(data);\
		data = ((data >> 8) & MAC_RQC2R_PSRQ1_MASK);\
} while (0)

/*#define MAC_RQC2R_PSRQ0_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_RQC2R_PSRQ0_MASK (ULONG)(0xff)

/*#define MAC_RQC2R_PSRQ0_Wr_Mask (ULONG)(~((~(~0 << (8))) << (0)))*/

#define MAC_RQC2R_PSRQ0_WR_MASK (ULONG)(0xffffff00)

#define MAC_RQC2R_PSRQ0_UDFWR(data) do {\
		ULONG v;\
		MAC_RQC2R_RGRD(v);\
		v = ((v & MAC_RQC2R_PSRQ0_WR_MASK) | ((data & MAC_RQC2R_PSRQ0_MASK) << 0));\
		MAC_RQC2R_RGWR(v);\
} while (0)

#define MAC_RQC2R_PSRQ0_UDFRD(data) do {\
		MAC_RQC2R_RGRD(data);\
		data = ((data >> 0) & MAC_RQC2R_PSRQ0_MASK);\
} while (0)

#define MAC_RQC1R_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xa4))

#define MAC_RQC1R_RGWR(data) do {\
		iowrite32(data, (void *)MAC_RQC1R_RGOFFADDR);\
} while (0)

#define MAC_RQC1R_RGRD(data) do {\
		(data) = ioread32((void *)MAC_RQC1R_RGOFFADDR);\
} while (0)

/*#define  MAC_RQC1R_Mask_11 (ULONG)(~(~0<<(21)))*/

#define  MAC_RQC1R_MASK_11 (ULONG)(0x1fffff)

/*#define MAC_RQC1R_RES_Wr_Mask_11 (ULONG)(~((~(~0<<(21)))<<(11)))*/

#define MAC_RQC1R_RES_WR_MASK_11 (ULONG)(0x7ff)

/*#define  MAC_RQC1R_Mask_7 (ULONG)(~(~0<<(1)))*/

#define  MAC_RQC1R_MASK_7 (ULONG)(0x1)

/*#define MAC_RQC1R_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(1)))<<(7)))*/

#define MAC_RQC1R_RES_WR_MASK_7 (ULONG)(0xffffff7f)

/*#define  MAC_RQC1R_Mask_3 (ULONG)(~(~0<<(1)))*/

#define  MAC_RQC1R_MASK_3 (ULONG)(0x1)

/*#define MAC_RQC1R_RES_Wr_Mask_3 (ULONG)(~((~(~0<<(1)))<<(3)))*/

#define MAC_RQC1R_RES_WR_MASK_3 (ULONG)(0xfffffff7)

/*#define MAC_RQC1R_DCBCPQ_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_RQC1R_DCBCPQ_MASK (ULONG)(0x7)

/*#define MAC_RQC1R_DCBCPQ_Wr_Mask (ULONG)(~((~(~0 << (3))) << (8)))*/

#define MAC_RQC1R_DCBCPQ_WR_MASK (ULONG)(0xfffff8ff)

#define MAC_RQC1R_DCBCPQ_UDFWR(data) do {\
		ULONG v;\
		MAC_RQC1R_RGRD(v);\
		v = (v & (MAC_RQC1R_RES_WR_MASK_11)) | (((0) & (MAC_RQC1R_MASK_11)) << 11);\
		v = (v & (MAC_RQC1R_RES_WR_MASK_7)) | (((0) & (MAC_RQC1R_MASK_7)) << 7);\
		v = (v & (MAC_RQC1R_RES_WR_MASK_3)) | (((0) & (MAC_RQC1R_MASK_3)) << 3);\
		v = ((v & MAC_RQC1R_DCBCPQ_WR_MASK) | ((data & MAC_RQC1R_DCBCPQ_MASK) << 8));\
		MAC_RQC1R_RGWR(v);\
} while (0)

#define MAC_RQC1R_DCBCPQ_UDFRD(data) do {\
		MAC_RQC1R_RGRD(data);\
		data = ((data >> 8) & MAC_RQC1R_DCBCPQ_MASK);\
} while (0)

/*#define MAC_RQC1R_AVPTPQ_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_RQC1R_AVPTPQ_MASK (ULONG)(0x7)

/*#define MAC_RQC1R_AVPTPQ_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MAC_RQC1R_AVPTPQ_WR_MASK (ULONG)(0xffffff8f)

#define MAC_RQC1R_AVPTPQ_UDFWR(data) do {\
		ULONG v;\
		MAC_RQC1R_RGRD(v);\
		v = ((v & MAC_RQC1R_AVPTPQ_WR_MASK) | ((data & MAC_RQC1R_AVPTPQ_MASK) << 4));\
		MAC_RQC1R_RGWR(v);\
} while (0)

#define MAC_RQC1R_AVPTPQ_UDFRD(data) do {\
		MAC_RQC1R_RGRD(data);\
		data = ((data >> 4) & MAC_RQC1R_AVPTPQ_MASK);\
} while (0)

/*#define MAC_RQC1R_AVUCPQ_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_RQC1R_AVUCPQ_MASK (ULONG)(0x7)

/*#define MAC_RQC1R_AVUCPQ_Wr_Mask (ULONG)(~((~(~0 << (3))) << (0)))*/

#define MAC_RQC1R_AVUCPQ_WR_MASK (ULONG)(0xfffffff8)

#define MAC_RQC1R_AVUCPQ_UDFWR(data) do {\
		ULONG v;\
		MAC_RQC1R_RGRD(v);\
		v = ((v & MAC_RQC1R_AVUCPQ_WR_MASK) | ((data & MAC_RQC1R_AVUCPQ_MASK) << 0));\
		MAC_RQC1R_RGWR(v);\
} while (0)

#define MAC_RQC1R_AVUCPQ_UDFRD(data) do {\
		MAC_RQC1R_RGRD(data);\
		data = ((data >> 0) & MAC_RQC1R_AVUCPQ_MASK);\
} while (0)

#define MAC_RQC1R_UPQ_MASK (ULONG)(0x7)

#define MAC_RQC1R_UPQ_WR_MASK (ULONG)(0xffff8fff)

#define MAC_RQC1R_UPQ_UDFWR(data) do {\
		ULONG v;\
		MAC_RQC1R_RGRD(v);\
		v = ((v & MAC_RQC1R_UPQ_WR_MASK) |\
			(((data) & MAC_RQC1R_UPQ_MASK) << 12));\
		MAC_RQC1R_RGWR(v);\
} while (0)

#define MAC_RQC1R_UPQ_UDFRD(data) do {\
		MAC_RQC1R_RGRD(data);\
		data = ((data >> 12) & MAC_RQC1R_UPQ_MASK);\
} while (0)

#define MAC_RQC1R_MCBCQ_MASK (ULONG)(0x7)

#define MAC_RQC1R_MCBCQ_WR_MASK (ULONG)(0xfff8ffff)

#define MAC_RQC1R_MCBCQ_UDFWR(data) do {\
		ULONG v;\
		MAC_RQC1R_RGRD(v);\
		v = ((v & MAC_RQC1R_MCBCQ_WR_MASK) |\
			(((data) & MAC_RQC1R_MCBCQ_MASK) << 16));\
		MAC_RQC1R_RGWR(v);\
} while (0)

#define MAC_RQC1R_MCBCQ_UDFRD(data) do {\
		MAC_RQC1R_RGRD(data);\
		data = ((data >> 16) & MAC_RQC1R_MCBCQ_MASK);\
} while (0)

#define MAC_RQC1R_MCBCQEN_MASK (ULONG)(0x1)

#define MAC_RQC1R_MCBCQEN_WR_MASK (ULONG)(0xffefffff)

#define MAC_RQC1R_MCBCQEN_UDFWR(data) do {\
		ULONG v;\
		MAC_RQC1R_RGRD(v);\
		v = ((v & MAC_RQC1R_MCBCQEN_WR_MASK) |\
		(((data) & MAC_RQC1R_MCBCQEN_MASK) << 20));\
		MAC_RQC1R_RGWR(v);\
} while (0)

#define MAC_RQC1R_MCBCQEN_UDFRD(data) do {\
		MAC_RQC1R_RGRD(data);\
		data = ((data >> 20) & MAC_RQC1R_MCBCQEN_MASK);\
} while (0)

#define MAC_RQC1R_TACPQE_MASK (ULONG)(0x1)

#define MAC_RQC1R_TACPQE_WR_MASK (ULONG)(0xffdfffff)

#define MAC_RQC1R_TACPQE_UDFWR(data) do {\
		ULONG v;\
		MAC_RQC1R_RGRD(v);\
		v = ((v & MAC_RQC1R_TACPQE_WR_MASK) |\
			(((data) & MAC_RQC1R_TACPQE_MASK) << 21));\
		MAC_RQC1R_RGWR(v);\
} while (0)

#define MAC_RQC1R_TACPQE_UDFRD(data) do {\
		MAC_RQC1R_RGRD(data);\
		data = ((data >> 21) & MAC_RQC1R_TACPQE_MASK);\
} while (0)

#define MAC_RQC1R_TPQC_MASK (ULONG)(0x3)

#define MAC_RQC1R_TPQC_WR_MASK (ULONG)(0xff3fffff)

#define MAC_RQC1R_TPQC_UDFWR(data) do {\
		ULONG v;\
		MAC_RQC1R_RGRD(v);\
		v = ((v & MAC_RQC1R_TPQC_WR_MASK) |\
			(((data) & MAC_RQC1R_TPQC_MASK) << 22));\
		MAC_RQC1R_RGWR(v);\
} while (0)

#define MAC_RQC1R_TPQC_UDFRD(data) do {\
		MAC_RQC1R_RGRD(data);\
		data = ((data >> 22) & MAC_RQC1R_TPQC_MASK);\
} while (0)

#define MAC_RQC0R_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0xa0))

#define MAC_RQC0R_RGWR(data) do {\
		iowrite32(data, (void *)MAC_RQC0R_RGOFFADDR);\
} while (0)

#define MAC_RQC0R_RGRD(data) do {\
		(data) = ioread32((void *)MAC_RQC0R_RGOFFADDR);\
} while (0)

/*#define  MAC_RQC0R_Mask_16 (ULONG)(~(~0<<(16)))*/

#define  MAC_RQC0R_MASK_16 (ULONG)(0xffff)

/*#define MAC_RQC0R_RES_Wr_Mask_16 (ULONG)(~((~(~0<<(16)))<<(16)))*/

#define MAC_RQC0R_RES_WR_MASK_16 (ULONG)(0xffff)

/*#define MAC_RQC0R_RXQEN7_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_RQC0R_RXQEN7_MASK (ULONG)(0x3)

/*#define MAC_RQC0R_RXQEN7_Wr_Mask (ULONG)(~((~(~0 << (2))) << (14)))*/

#define MAC_RQC0R_RXQEN7_WR_MASK (ULONG)(0xffff3fff)

#define MAC_RQC0R_RXQEN7_UDFWR(data) do {\
		ULONG v;\
		MAC_RQC0R_RGRD(v);\
		v = (v & (MAC_RQC0R_RES_WR_MASK_16)) | (((0) & (MAC_RQC0R_MASK_16)) << 16);\
		v = ((v & MAC_RQC0R_RXQEN7_WR_MASK) | ((data & MAC_RQC0R_RXQEN7_MASK) << 14));\
		MAC_RQC0R_RGWR(v);\
} while (0)

#define MAC_RQC0R_RXQEN7_UDFRD(data) do {\
		MAC_RQC0R_RGRD(data);\
		data = ((data >> 14) & MAC_RQC0R_RXQEN7_MASK);\
} while (0)

/*#define MAC_RQC0R_RXQEN6_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_RQC0R_RXQEN6_MASK (ULONG)(0x3)

/*#define MAC_RQC0R_RXQEN6_Wr_Mask (ULONG)(~((~(~0 << (2))) << (12)))*/

#define MAC_RQC0R_RXQEN6_WR_MASK (ULONG)(0xffffcfff)

#define MAC_RQC0R_RXQEN6_UDFWR(data) do {\
		ULONG v;\
		MAC_RQC0R_RGRD(v);\
		v = (v & (MAC_RQC0R_RES_WR_MASK_16)) | (((0) & (MAC_RQC0R_MASK_16)) << 16);\
		v = ((v & MAC_RQC0R_RXQEN6_WR_MASK) | ((data & MAC_RQC0R_RXQEN6_MASK) << 12));\
		MAC_RQC0R_RGWR(v);\
} while (0)

#define MAC_RQC0R_RXQEN6_UDFRD(data) do {\
		MAC_RQC0R_RGRD(data);\
		data = ((data >> 12) & MAC_RQC0R_RXQEN6_MASK);\
} while (0)

/*#define MAC_RQC0R_RXQEN5_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_RQC0R_RXQEN5_MASK (ULONG)(0x3)

/*#define MAC_RQC0R_RXQEN5_Wr_Mask (ULONG)(~((~(~0 << (2))) << (10)))*/

#define MAC_RQC0R_RXQEN5_WR_MASK (ULONG)(0xfffff3ff)

#define MAC_RQC0R_RXQEN5_UDFWR(data) do {\
		ULONG v;\
		MAC_RQC0R_RGRD(v);\
		v = (v & (MAC_RQC0R_RES_WR_MASK_16)) | (((0) & (MAC_RQC0R_MASK_16)) << 16);\
		v = ((v & MAC_RQC0R_RXQEN5_WR_MASK) | ((data & MAC_RQC0R_RXQEN5_MASK) << 10));\
		MAC_RQC0R_RGWR(v);\
} while (0)

#define MAC_RQC0R_RXQEN5_UDFRD(data) do {\
		MAC_RQC0R_RGRD(data);\
		data = ((data >> 10) & MAC_RQC0R_RXQEN5_MASK);\
} while (0)

/*#define MAC_RQC0R_RXQEN4_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_RQC0R_RXQEN4_MASK (ULONG)(0x3)

/*#define MAC_RQC0R_RXQEN4_Wr_Mask (ULONG)(~((~(~0 << (2))) << (8)))*/

#define MAC_RQC0R_RXQEN4_WR_MASK (ULONG)(0xfffffcff)

#define MAC_RQC0R_RXQEN4_UDFWR(data) do {\
		ULONG v;\
		MAC_RQC0R_RGRD(v);\
		v = (v & (MAC_RQC0R_RES_WR_MASK_16)) | (((0) & (MAC_RQC0R_MASK_16)) << 16);\
		v = ((v & MAC_RQC0R_RXQEN4_WR_MASK) | ((data & MAC_RQC0R_RXQEN4_MASK) << 8));\
		MAC_RQC0R_RGWR(v);\
} while (0)

#define MAC_RQC0R_RXQEN4_UDFRD(data) do {\
		MAC_RQC0R_RGRD(data);\
		data = ((data >> 8) & MAC_RQC0R_RXQEN4_MASK);\
} while (0)

/*#define MAC_RQC0R_RXQEN3_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_RQC0R_RXQEN3_MASK (ULONG)(0x3)

/*#define MAC_RQC0R_RXQEN3_Wr_Mask (ULONG)(~((~(~0 << (2))) << (6)))*/

#define MAC_RQC0R_RXQEN3_WR_MASK (ULONG)(0xffffff3f)

#define MAC_RQC0R_RXQEN3_UDFWR(data) do {\
		ULONG v;\
		MAC_RQC0R_RGRD(v);\
		v = (v & (MAC_RQC0R_RES_WR_MASK_16)) | (((0) & (MAC_RQC0R_MASK_16)) << 16);\
		v = ((v & MAC_RQC0R_RXQEN3_WR_MASK) | ((data & MAC_RQC0R_RXQEN3_MASK) << 6));\
		MAC_RQC0R_RGWR(v);\
} while (0)

#define MAC_RQC0R_RXQEN3_UDFRD(data) do {\
		MAC_RQC0R_RGRD(data);\
		data = ((data >> 6) & MAC_RQC0R_RXQEN3_MASK);\
} while (0)

/*#define MAC_RQC0R_RXQEN2_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_RQC0R_RXQEN2_MASK (ULONG)(0x3)

/*#define MAC_RQC0R_RXQEN2_Wr_Mask (ULONG)(~((~(~0 << (2))) << (4)))*/

#define MAC_RQC0R_RXQEN2_WR_MASK (ULONG)(0xffffffcf)

#define MAC_RQC0R_RXQEN2_UDFWR(data) do {\
		ULONG v;\
		MAC_RQC0R_RGRD(v);\
		v = (v & (MAC_RQC0R_RES_WR_MASK_16)) | (((0) & (MAC_RQC0R_MASK_16)) << 16);\
		v = ((v & MAC_RQC0R_RXQEN2_WR_MASK) | ((data & MAC_RQC0R_RXQEN2_MASK) << 4));\
		MAC_RQC0R_RGWR(v);\
} while (0)

#define MAC_RQC0R_RXQEN2_UDFRD(data) do {\
		MAC_RQC0R_RGRD(data);\
		data = ((data >> 4) & MAC_RQC0R_RXQEN2_MASK);\
} while (0)

/*#define MAC_RQC0R_RXQEN1_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_RQC0R_RXQEN1_MASK (ULONG)(0x3)

/*#define MAC_RQC0R_RXQEN1_Wr_Mask (ULONG)(~((~(~0 << (2))) << (2)))*/

#define MAC_RQC0R_RXQEN1_WR_MASK (ULONG)(0xfffffff3)

#define MAC_RQC0R_RXQEN1_UDFWR(data) do {\
		ULONG v;\
		MAC_RQC0R_RGRD(v);\
		v = (v & (MAC_RQC0R_RES_WR_MASK_16)) | (((0) & (MAC_RQC0R_MASK_16)) << 16);\
		v = ((v & MAC_RQC0R_RXQEN1_WR_MASK) | ((data & MAC_RQC0R_RXQEN1_MASK) << 2));\
		MAC_RQC0R_RGWR(v);\
} while (0)

#define MAC_RQC0R_RXQEN1_UDFRD(data) do {\
		MAC_RQC0R_RGRD(data);\
		data = ((data >> 2) & MAC_RQC0R_RXQEN1_MASK);\
} while (0)

/*#define MAC_RQC0R_RXQEN0_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_RQC0R_RXQEN0_MASK (ULONG)(0x3)

/*#define MAC_RQC0R_RXQEN0_Wr_Mask (ULONG)(~((~(~0 << (2))) << (0)))*/

#define MAC_RQC0R_RXQEN0_WR_MASK (ULONG)(0xfffffffc)

#define MAC_RQC0R_RXQEN0_UDFWR(data) do {\
		ULONG v;\
		MAC_RQC0R_RGRD(v);\
		v = (v & (MAC_RQC0R_RES_WR_MASK_16)) | (((0) & (MAC_RQC0R_MASK_16)) << 16);\
		v = ((v & MAC_RQC0R_RXQEN0_WR_MASK) | ((data & MAC_RQC0R_RXQEN0_MASK) << 0));\
		MAC_RQC0R_RGWR(v);\
} while (0)

#define MAC_RQC0R_RXQEN0_UDFRD(data) do {\
		MAC_RQC0R_RGRD(data);\
		data = ((data >> 0) & MAC_RQC0R_RXQEN0_MASK);\
} while (0)

/*#define MAC_RQC0R_RXQEN_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_RQC0R_RXQEN_MASK (ULONG)(0x3)

/*#define MAC_RQC0R_RXQEN_Wr_Mask(i) (ULONG)(~((~(~0 << (2))) << (0 + (i * 2))))*/

#define MAC_RQC0R_RXQEN_WR_MASK(i)  (ULONG)(~((~(~0 << (2))) << (0 + (i * 2))))

#define MAC_RQC0R_RXQEN_UDFWR(i, data) do {\
		ULONG v;\
		MAC_RQC0R_RGRD(v);\
		v = (v & (MAC_RQC0R_RES_WR_MASK_16)) | (((0) & (MAC_RQC0R_MASK_16)) << 16);\
		v = ((v & MAC_RQC0R_RXQEN_WR_MASK(i)) | ((data & MAC_RQC0R_RXQEN_MASK) << (0 + i * 2)));\
		MAC_RQC0R_RGWR(v);\
} while (0)

#define MAC_RQC0R_RXQEN_UDFRD(i, data) do {\
		MAC_RQC0R_RGRD(data);\
		data = ((data >> (0 + (i * 2))) & MAC_RQC0R_RXQEN_MASK);\
} while (0)

#define MAC_TQPM1R_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x9c))

#define MAC_TQPM1R_RGWR(data) do {\
		iowrite32(data, (void *)MAC_TQPM1R_RGOFFADDR);\
} while (0)

#define MAC_TQPM1R_RGRD(data) do {\
		(data) = ioread32((void *)MAC_TQPM1R_RGOFFADDR);\
} while (0)

#ifndef DWC_ETH_QOS_QUEUE_SELECT_ALGO
#define MAC_TQPM1R_PSTQ7_Mask (ULONG)(~(~0 << (8)))

#define MAC_TQPM1R_PSTQ7_MASK (ULONG)(0xff)

/*#define MAC_TQPM1R_PSTQ7_Wr_Mask (ULONG)(~((~(~0 << (8))) << (24)))*/

#define MAC_TQPM1R_PSTQ7_WR_MASK (ULONG)(0xffffff)

#define MAC_TQPM1R_PSTQ7_UDFWR(data) do {\
		ULONG v;\
		MAC_TQPM1R_RGRD(v);\
		v = ((v & MAC_TQPM1R_PSTQ7_WR_MASK) | ((data & MAC_TQPM1R_PSTQ7_MASK) << 24));\
		MAC_TQPM1R_RGWR(v);\
} while (0)

#define MAC_TQPM1R_PSTQ7_UDFRD(data) do {\
		MAC_TQPM1R_RGRD(data);\
		data = ((data >> 24) & MAC_TQPM1R_PSTQ7_MASK);\
} while (0)

/*#define MAC_TQPM1R_PSTQ6_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_TQPM1R_PSTQ6_MASK (ULONG)(0xff)

/*#define MAC_TQPM1R_PSTQ6_Wr_Mask (ULONG)(~((~(~0 << (8))) << (16)))*/

#define MAC_TQPM1R_PSTQ6_WR_MASK (ULONG)(0xff00ffff)

#define MAC_TQPM1R_PSTQ6_UDFWR(data) do {\
		ULONG v;\
		MAC_TQPM1R_RGRD(v);\
		v = ((v & MAC_TQPM1R_PSTQ6_WR_MASK) | ((data & MAC_TQPM1R_PSTQ6_MASK) << 16));\
		MAC_TQPM1R_RGWR(v);\
} while (0)

#define MAC_TQPM1R_PSTQ6_UDFRD(data) do {\
		MAC_TQPM1R_RGRD(data);\
		data = ((data >> 16) & MAC_TQPM1R_PSTQ6_MASK);\
} while (0)

/*#define MAC_TQPM1R_PSTQ5_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_TQPM1R_PSTQ5_MASK (ULONG)(0xff)

/*#define MAC_TQPM1R_PSTQ5_Wr_Mask (ULONG)(~((~(~0 << (8))) << (8)))*/

#define MAC_TQPM1R_PSTQ5_WR_MASK (ULONG)(0xffff00ff)

#define MAC_TQPM1R_PSTQ5_UDFWR(data) do {\
		ULONG v;\
		MAC_TQPM1R_RGRD(v);\
		v = ((v & MAC_TQPM1R_PSTQ5_WR_MASK) | ((data & MAC_TQPM1R_PSTQ5_MASK) << 8));\
		MAC_TQPM1R_RGWR(v);\
} while (0)

#define MAC_TQPM1R_PSTQ5_UDFRD(data) do {\
		MAC_TQPM1R_RGRD(data);\
		data = ((data >> 8) & MAC_TQPM1R_PSTQ5_MASK);\
} while (0)

/*#define MAC_TQPM1R_PSTQ4_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_TQPM1R_PSTQ4_MASK (ULONG)(0xff)

/*#define MAC_TQPM1R_PSTQ4_Wr_Mask (ULONG)(~((~(~0 << (8))) << (0)))*/

#define MAC_TQPM1R_PSTQ4_WR_MASK (ULONG)(0xffffff00)

#define MAC_TQPM1R_PSTQ4_UDFWR(data) do {\
		ULONG v;\
		MAC_TQPM1R_RGRD(v);\
		v = ((v & MAC_TQPM1R_PSTQ4_WR_MASK) | ((data & MAC_TQPM1R_PSTQ4_MASK) << 0));\
		MAC_TQPM1R_RGWR(v);\
} while (0)

#define MAC_TQPM1R_PSTQ4_UDFRD(data) do {\
		MAC_TQPM1R_RGRD(data);\
		data = ((data >> 0) & MAC_TQPM1R_PSTQ4_MASK);\
} while (0)

#define MAC_TQPM0R_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x98))

#define MAC_TQPM0R_RGWR(data) do {\
		iowrite32(data, (void *)MAC_TQPM0R_RGOFFADDR);\
} while (0)

#define MAC_TQPM0R_RGRD(data) do {\
		(data) = ioread32((void *)MAC_TQPM0R_RGOFFADDR);\
} while (0)

/*#define MAC_TQPM0R_PSTQ3_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_TQPM0R_PSTQ3_MASK (ULONG)(0xff)

/*#define MAC_TQPM0R_PSTQ3_Wr_Mask (ULONG)(~((~(~0 << (8))) << (24)))*/

#define MAC_TQPM0R_PSTQ3_WR_MASK (ULONG)(0xffffff)

#define MAC_TQPM0R_PSTQ3_UDFWR(data) do {\
		ULONG v;\
		MAC_TQPM0R_RGRD(v);\
		v = ((v & MAC_TQPM0R_PSTQ3_WR_MASK) | ((data & MAC_TQPM0R_PSTQ3_MASK) << 24));\
		MAC_TQPM0R_RGWR(v);\
} while (0)

#define MAC_TQPM0R_PSTQ3_UDFRD(data) do {\
		MAC_TQPM0R_RGRD(data);\
		data = ((data >> 24) & MAC_TQPM0R_PSTQ3_MASK);\
} while (0)

/*#define MAC_TQPM0R_PSTQ2_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_TQPM0R_PSTQ2_MASK (ULONG)(0xff)

/*#define MAC_TQPM0R_PSTQ2_Wr_Mask (ULONG)(~((~(~0 << (8))) << (16)))*/

#define MAC_TQPM0R_PSTQ2_WR_MASK (ULONG)(0xff00ffff)

#define MAC_TQPM0R_PSTQ2_UDFWR(data) do {\
		ULONG v;\
		MAC_TQPM0R_RGRD(v);\
		v = ((v & MAC_TQPM0R_PSTQ2_WR_MASK) | ((data & MAC_TQPM0R_PSTQ2_MASK) << 16));\
		MAC_TQPM0R_RGWR(v);\
} while (0)

#define MAC_TQPM0R_PSTQ2_UDFRD(data) do {\
		MAC_TQPM0R_RGRD(data);\
		data = ((data >> 16) & MAC_TQPM0R_PSTQ2_MASK);\
} while (0)

/*#define MAC_TQPM0R_PSTQ1_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_TQPM0R_PSTQ1_MASK (ULONG)(0xff)

/*#define MAC_TQPM0R_PSTQ1_Wr_Mask (ULONG)(~((~(~0 << (8))) << (8)))*/

#define MAC_TQPM0R_PSTQ1_WR_MASK (ULONG)(0xffff00ff)

#define MAC_TQPM0R_PSTQ1_UDFWR(data) do {\
		ULONG v;\
		MAC_TQPM0R_RGRD(v);\
		v = ((v & MAC_TQPM0R_PSTQ1_WR_MASK) | ((data & MAC_TQPM0R_PSTQ1_MASK) << 8));\
		MAC_TQPM0R_RGWR(v);\
} while (0)

#define MAC_TQPM0R_PSTQ1_UDFRD(data) do {\
		MAC_TQPM0R_RGRD(data);\
		data = ((data >> 8) & MAC_TQPM0R_PSTQ1_MASK);\
} while (0)

/*#define MAC_TQPM0R_PSTQ0_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_TQPM0R_PSTQ0_MASK (ULONG)(0xff)

/*#define MAC_TQPM0R_PSTQ0_Wr_Mask (ULONG)(~((~(~0 << (8))) << (0)))*/

#define MAC_TQPM0R_PSTQ0_WR_MASK (ULONG)(0xffffff00)

#define MAC_TQPM0R_PSTQ0_UDFWR(data) do {\
		ULONG v;\
		MAC_TQPM0R_RGRD(v);\
		v = ((v & MAC_TQPM0R_PSTQ0_WR_MASK) | ((data & MAC_TQPM0R_PSTQ0_MASK) << 0));\
		MAC_TQPM0R_RGWR(v);\
} while (0)

#define MAC_TQPM0R_PSTQ0_UDFRD(data) do {\
		MAC_TQPM0R_RGRD(data);\
		data = ((data >> 0) & MAC_TQPM0R_PSTQ0_MASK);\
} while (0)
#endif

#define MAC_RFCR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x90))

#define MAC_RFCR_RGWR(data) do {\
		iowrite32(data, (void *)MAC_RFCR_RGOFFADDR);\
} while (0)

#define MAC_RFCR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_RFCR_RGOFFADDR);\
} while (0)

/*#define  MAC_RFCR_Mask_9 (ULONG)(~(~0<<(23)))*/

#define  MAC_RFCR_MASK_9 (ULONG)(0x7fffff)

/*#define MAC_RFCR_RES_Wr_Mask_9 (ULONG)(~((~(~0<<(23)))<<(9)))*/

#define MAC_RFCR_RES_WR_MASK_9 (ULONG)(0x1ff)

/*#define  MAC_RFCR_Mask_2 (ULONG)(~(~0<<(6)))*/

#define  MAC_RFCR_MASK_2 (ULONG)(0x3f)

/*#define MAC_RFCR_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(6)))<<(2)))*/

#define MAC_RFCR_RES_WR_MASK_2 (ULONG)(0xffffff03)

/*#define MAC_RFCR_PFCE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_RFCR_PFCE_MASK (ULONG)(0x1)

/*#define MAC_RFCR_PFCE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (8)))*/

#define MAC_RFCR_PFCE_WR_MASK (ULONG)(0xfffffeff)

#define MAC_RFCR_PFCE_UDFWR(data) do {\
		ULONG v;\
		MAC_RFCR_RGRD(v);\
		v = (v & (MAC_RFCR_RES_WR_MASK_9)) | (((0) & (MAC_RFCR_MASK_9)) << 9);\
		v = (v & (MAC_RFCR_RES_WR_MASK_2)) | (((0) & (MAC_RFCR_MASK_2)) << 2);\
		v = ((v & MAC_RFCR_PFCE_WR_MASK) | ((data & MAC_RFCR_PFCE_MASK) << 8));\
		MAC_RFCR_RGWR(v);\
} while (0)

#define MAC_RFCR_PFCE_UDFRD(data) do {\
		MAC_RFCR_RGRD(data);\
		data = ((data >> 8) & MAC_RFCR_PFCE_MASK);\
} while (0)

/*#define MAC_RFCR_UP_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_RFCR_UP_MASK (ULONG)(0x1)

/*#define MAC_RFCR_UP_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_RFCR_UP_WR_MASK (ULONG)(0xfffffffd)

#define MAC_RFCR_UP_UDFWR(data) do {\
		ULONG v;\
		MAC_RFCR_RGRD(v);\
		v = (v & (MAC_RFCR_RES_WR_MASK_9)) | (((0) & (MAC_RFCR_MASK_9)) << 9);\
		v = (v & (MAC_RFCR_RES_WR_MASK_2)) | (((0) & (MAC_RFCR_MASK_2)) << 2);\
		v = ((v & MAC_RFCR_UP_WR_MASK) | ((data & MAC_RFCR_UP_MASK) << 1));\
		MAC_RFCR_RGWR(v);\
} while (0)

#define MAC_RFCR_UP_UDFRD(data) do {\
		MAC_RFCR_RGRD(data);\
		data = ((data >> 1) & MAC_RFCR_UP_MASK);\
} while (0)

/*#define MAC_RFCR_RFE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_RFCR_RFE_MASK (ULONG)(0x1)

/*#define MAC_RFCR_RFE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_RFCR_RFE_WR_MASK (ULONG)(0xfffffffe)

#define MAC_RFCR_RFE_UDFWR(data) do {\
		ULONG v;\
		MAC_RFCR_RGRD(v);\
		v = (v & (MAC_RFCR_RES_WR_MASK_9)) | (((0) & (MAC_RFCR_MASK_9)) << 9);\
		v = (v & (MAC_RFCR_RES_WR_MASK_2)) | (((0) & (MAC_RFCR_MASK_2)) << 2);\
		v = ((v & MAC_RFCR_RFE_WR_MASK) | ((data & MAC_RFCR_RFE_MASK) << 0));\
		MAC_RFCR_RGWR(v);\
} while (0)

#define MAC_RFCR_RFE_UDFRD(data) do {\
		MAC_RFCR_RGRD(data);\
		data = ((data >> 0) & MAC_RFCR_RFE_MASK);\
} while (0)

#define MAC_QTFCR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x8c))

#define MAC_QTFCR7_RGWR(data) do {\
		iowrite32(data, (void *)MAC_QTFCR7_RGOFFADDR);\
} while (0)

#define MAC_QTFCR7_RGRD(data) do {\
		(data) = ioread32((void *)MAC_QTFCR7_RGOFFADDR);\
} while (0)

/*#define  MAC_QTFCR7_Mask_8 (ULONG)(~(~0<<(8)))*/

#define  MAC_QTFCR7_MASK_8 (ULONG)(0xff)

/*#define MAC_QTFCR7_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(8)))<<(8)))*/

#define MAC_QTFCR7_RES_WR_MASK_8 (ULONG)(0xffff00ff)

/*#define  MAC_QTFCR7_Mask_2 (ULONG)(~(~0<<(2)))*/

#define  MAC_QTFCR7_MASK_2 (ULONG)(0x3)

/*#define MAC_QTFCR7_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(2)))<<(2)))*/

#define MAC_QTFCR7_RES_WR_MASK_2 (ULONG)(0xfffffff3)

/*#define MAC_QTFCR7_FCB_BPA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR7_FCB_BPA_MASK (ULONG)(0x1)

/*#define MAC_QTFCR7_FCB_BPA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_QTFCR7_FCB_BPA_WR_MASK (ULONG)(0xfffffffe)

#define MAC_QTFCR7_FCB_BPA_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR7_RGRD(v);\
		v = (v & (MAC_QTFCR7_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR7_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR7_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR7_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR7_FCB_BPA_WR_MASK) | ((data & MAC_QTFCR7_FCB_BPA_MASK) << 0));\
		MAC_QTFCR7_RGWR(v);\
} while (0)

#define MAC_QTFCR7_FCB_BPA_UDFRD(data) do {\
		MAC_QTFCR7_RGRD(data);\
		data = ((data >> 0) & MAC_QTFCR7_FCB_BPA_MASK);\
} while (0)

/*#define MAC_QTFCR7_TFE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR7_TFE_MASK (ULONG)(0x1)

/*#define MAC_QTFCR7_TFE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_QTFCR7_TFE_WR_MASK (ULONG)(0xfffffffd)

#define MAC_QTFCR7_TFE_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR7_RGRD(v);\
		v = (v & (MAC_QTFCR7_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR7_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR7_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR7_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR7_TFE_WR_MASK) | ((data & MAC_QTFCR7_TFE_MASK) << 1));\
		MAC_QTFCR7_RGWR(v);\
} while (0)

#define MAC_QTFCR7_TFE_UDFRD(data) do {\
		MAC_QTFCR7_RGRD(data);\
		data = ((data >> 1) & MAC_QTFCR7_TFE_MASK);\
} while (0)

/*#define MAC_QTFCR7_PLT_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_QTFCR7_PLT_MASK (ULONG)(0x7)

/*#define MAC_QTFCR7_PLT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MAC_QTFCR7_PLT_WR_MASK (ULONG)(0xffffff8f)

#define MAC_QTFCR7_PLT_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR7_RGRD(v);\
		v = (v & (MAC_QTFCR7_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR7_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR7_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR7_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR7_PLT_WR_MASK) | ((data & MAC_QTFCR7_PLT_MASK) << 4));\
		MAC_QTFCR7_RGWR(v);\
} while (0)

#define MAC_QTFCR7_PLT_UDFRD(data) do {\
		MAC_QTFCR7_RGRD(data);\
		data = ((data >> 4) & MAC_QTFCR7_PLT_MASK);\
} while (0)

/*#define MAC_QTFCR7_DZPQ_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR7_DZPQ_MASK (ULONG)(0x1)

/*#define MAC_QTFCR7_DZPQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MAC_QTFCR7_DZPQ_WR_MASK (ULONG)(0xffffff7f)

#define MAC_QTFCR7_DZPQ_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR7_RGRD(v);\
		v = (v & (MAC_QTFCR7_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR7_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR7_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR7_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR7_DZPQ_WR_MASK) | ((data & MAC_QTFCR7_DZPQ_MASK) << 7));\
		MAC_QTFCR7_RGWR(v);\
} while (0)

#define MAC_QTFCR7_DZPQ_UDFRD(data) do {\
		MAC_QTFCR7_RGRD(data);\
		data = ((data >> 7) & MAC_QTFCR7_DZPQ_MASK);\
} while (0)

/*#define MAC_QTFCR7_PT_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_QTFCR7_PT_MASK (ULONG)(0xffff)

/*#define MAC_QTFCR7_PT_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_QTFCR7_PT_WR_MASK (ULONG)(0xffff)

#define MAC_QTFCR7_PT_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR7_RGRD(v);\
		v = (v & (MAC_QTFCR7_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR7_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR7_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR7_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR7_PT_WR_MASK) | ((data & MAC_QTFCR7_PT_MASK) << 16));\
		MAC_QTFCR7_RGWR(v);\
} while (0)

#define MAC_QTFCR7_PT_UDFRD(data) do {\
		MAC_QTFCR7_RGRD(data);\
		data = ((data >> 16) & MAC_QTFCR7_PT_MASK);\
} while (0)

#define MAC_QTFCR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x88))

#define MAC_QTFCR6_RGWR(data) do {\
		iowrite32(data, (void *)MAC_QTFCR6_RGOFFADDR);\
} while (0)

#define MAC_QTFCR6_RGRD(data) do {\
		(data) = ioread32((void *)MAC_QTFCR6_RGOFFADDR);\
} while (0)

/*#define  MAC_QTFCR6_Mask_8 (ULONG)(~(~0<<(8)))*/

#define  MAC_QTFCR6_MASK_8 (ULONG)(0xff)

/*#define MAC_QTFCR6_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(8)))<<(8)))*/

#define MAC_QTFCR6_RES_WR_MASK_8 (ULONG)(0xffff00ff)

/*#define  MAC_QTFCR6_Mask_2 (ULONG)(~(~0<<(2)))*/

#define  MAC_QTFCR6_MASK_2 (ULONG)(0x3)

/*#define MAC_QTFCR6_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(2)))<<(2)))*/

#define MAC_QTFCR6_RES_WR_MASK_2 (ULONG)(0xfffffff3)

/*#define MAC_QTFCR6_FCB_BPA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR6_FCB_BPA_MASK (ULONG)(0x1)

/*#define MAC_QTFCR6_FCB_BPA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_QTFCR6_FCB_BPA_WR_MASK (ULONG)(0xfffffffe)

#define MAC_QTFCR6_FCB_BPA_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR6_RGRD(v);\
		v = (v & (MAC_QTFCR6_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR6_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR6_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR6_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR6_FCB_BPA_WR_MASK) | ((data & MAC_QTFCR6_FCB_BPA_MASK) << 0));\
		MAC_QTFCR6_RGWR(v);\
} while (0)

#define MAC_QTFCR6_FCB_BPA_UDFRD(data) do {\
		MAC_QTFCR6_RGRD(data);\
		data = ((data >> 0) & MAC_QTFCR6_FCB_BPA_MASK);\
} while (0)

/*#define MAC_QTFCR6_TFE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR6_TFE_MASK (ULONG)(0x1)

/*#define MAC_QTFCR6_TFE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_QTFCR6_TFE_WR_MASK (ULONG)(0xfffffffd)

#define MAC_QTFCR6_TFE_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR6_RGRD(v);\
		v = (v & (MAC_QTFCR6_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR6_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR6_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR6_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR6_TFE_WR_MASK) | ((data & MAC_QTFCR6_TFE_MASK) << 1));\
		MAC_QTFCR6_RGWR(v);\
} while (0)

#define MAC_QTFCR6_TFE_UDFRD(data) do {\
		MAC_QTFCR6_RGRD(data);\
		data = ((data >> 1) & MAC_QTFCR6_TFE_MASK);\
} while (0)

/*#define MAC_QTFCR6_PLT_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_QTFCR6_PLT_MASK (ULONG)(0x7)

/*#define MAC_QTFCR6_PLT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MAC_QTFCR6_PLT_WR_MASK (ULONG)(0xffffff8f)

#define MAC_QTFCR6_PLT_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR6_RGRD(v);\
		v = (v & (MAC_QTFCR6_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR6_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR6_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR6_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR6_PLT_WR_MASK) | ((data & MAC_QTFCR6_PLT_MASK) << 4));\
		MAC_QTFCR6_RGWR(v);\
} while (0)

#define MAC_QTFCR6_PLT_UDFRD(data) do {\
		MAC_QTFCR6_RGRD(data);\
		data = ((data >> 4) & MAC_QTFCR6_PLT_MASK);\
} while (0)

/*#define MAC_QTFCR6_DZPQ_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR6_DZPQ_MASK (ULONG)(0x1)

/*#define MAC_QTFCR6_DZPQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MAC_QTFCR6_DZPQ_WR_MASK (ULONG)(0xffffff7f)

#define MAC_QTFCR6_DZPQ_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR6_RGRD(v);\
		v = (v & (MAC_QTFCR6_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR6_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR6_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR6_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR6_DZPQ_WR_MASK) | ((data & MAC_QTFCR6_DZPQ_MASK) << 7));\
		MAC_QTFCR6_RGWR(v);\
} while (0)

#define MAC_QTFCR6_DZPQ_UDFRD(data) do {\
		MAC_QTFCR6_RGRD(data);\
		data = ((data >> 7) & MAC_QTFCR6_DZPQ_MASK);\
} while (0)

/*#define MAC_QTFCR6_PT_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_QTFCR6_PT_MASK (ULONG)(0xffff)

/*#define MAC_QTFCR6_PT_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_QTFCR6_PT_WR_MASK (ULONG)(0xffff)

#define MAC_QTFCR6_PT_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR6_RGRD(v);\
		v = (v & (MAC_QTFCR6_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR6_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR6_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR6_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR6_PT_WR_MASK) | ((data & MAC_QTFCR6_PT_MASK) << 16));\
		MAC_QTFCR6_RGWR(v);\
} while (0)

#define MAC_QTFCR6_PT_UDFRD(data) do {\
		MAC_QTFCR6_RGRD(data);\
		data = ((data >> 16) & MAC_QTFCR6_PT_MASK);\
} while (0)

#define MAC_QTFCR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x84))

#define MAC_QTFCR5_RGWR(data) do {\
		iowrite32(data, (void *)MAC_QTFCR5_RGOFFADDR);\
} while (0)

#define MAC_QTFCR5_RGRD(data) do {\
		(data) = ioread32((void *)MAC_QTFCR5_RGOFFADDR);\
} while (0)

/*#define  MAC_QTFCR5_Mask_8 (ULONG)(~(~0<<(8)))*/

#define  MAC_QTFCR5_MASK_8 (ULONG)(0xff)

/*#define MAC_QTFCR5_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(8)))<<(8)))*/

#define MAC_QTFCR5_RES_WR_MASK_8 (ULONG)(0xffff00ff)

/*#define  MAC_QTFCR5_Mask_2 (ULONG)(~(~0<<(2)))*/

#define  MAC_QTFCR5_MASK_2 (ULONG)(0x3)

/*#define MAC_QTFCR5_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(2)))<<(2)))*/

#define MAC_QTFCR5_RES_WR_MASK_2 (ULONG)(0xfffffff3)

/*#define MAC_QTFCR5_FCB_BPA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR5_FCB_BPA_MASK (ULONG)(0x1)

/*#define MAC_QTFCR5_FCB_BPA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_QTFCR5_FCB_BPA_WR_MASK (ULONG)(0xfffffffe)

#define MAC_QTFCR5_FCB_BPA_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR5_RGRD(v);\
		v = (v & (MAC_QTFCR5_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR5_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR5_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR5_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR5_FCB_BPA_WR_MASK) | ((data & MAC_QTFCR5_FCB_BPA_MASK) << 0));\
		MAC_QTFCR5_RGWR(v);\
} while (0)

#define MAC_QTFCR5_FCB_BPA_UDFRD(data) do {\
		MAC_QTFCR5_RGRD(data);\
		data = ((data >> 0) & MAC_QTFCR5_FCB_BPA_MASK);\
} while (0)

/*#define MAC_QTFCR5_TFE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR5_TFE_MASK (ULONG)(0x1)

/*#define MAC_QTFCR5_TFE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_QTFCR5_TFE_WR_MASK (ULONG)(0xfffffffd)

#define MAC_QTFCR5_TFE_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR5_RGRD(v);\
		v = (v & (MAC_QTFCR5_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR5_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR5_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR5_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR5_TFE_WR_MASK) | ((data & MAC_QTFCR5_TFE_MASK) << 1));\
		MAC_QTFCR5_RGWR(v);\
} while (0)

#define MAC_QTFCR5_TFE_UDFRD(data) do {\
		MAC_QTFCR5_RGRD(data);\
		data = ((data >> 1) & MAC_QTFCR5_TFE_MASK);\
} while (0)

/*#define MAC_QTFCR5_PLT_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_QTFCR5_PLT_MASK (ULONG)(0x7)

/*#define MAC_QTFCR5_PLT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MAC_QTFCR5_PLT_WR_MASK (ULONG)(0xffffff8f)

#define MAC_QTFCR5_PLT_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR5_RGRD(v);\
		v = (v & (MAC_QTFCR5_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR5_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR5_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR5_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR5_PLT_WR_MASK) | ((data & MAC_QTFCR5_PLT_MASK) << 4));\
		MAC_QTFCR5_RGWR(v);\
} while (0)

#define MAC_QTFCR5_PLT_UDFRD(data) do {\
		MAC_QTFCR5_RGRD(data);\
		data = ((data >> 4) & MAC_QTFCR5_PLT_MASK);\
} while (0)

/*#define MAC_QTFCR5_DZPQ_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR5_DZPQ_MASK (ULONG)(0x1)

/*#define MAC_QTFCR5_DZPQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MAC_QTFCR5_DZPQ_WR_MASK (ULONG)(0xffffff7f)

#define MAC_QTFCR5_DZPQ_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR5_RGRD(v);\
		v = (v & (MAC_QTFCR5_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR5_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR5_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR5_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR5_DZPQ_WR_MASK) | ((data & MAC_QTFCR5_DZPQ_MASK) << 7));\
		MAC_QTFCR5_RGWR(v);\
} while (0)

#define MAC_QTFCR5_DZPQ_UDFRD(data) do {\
		MAC_QTFCR5_RGRD(data);\
		data = ((data >> 7) & MAC_QTFCR5_DZPQ_MASK);\
} while (0)

/*#define MAC_QTFCR5_PT_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_QTFCR5_PT_MASK (ULONG)(0xffff)

/*#define MAC_QTFCR5_PT_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_QTFCR5_PT_WR_MASK (ULONG)(0xffff)

#define MAC_QTFCR5_PT_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR5_RGRD(v);\
		v = (v & (MAC_QTFCR5_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR5_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR5_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR5_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR5_PT_WR_MASK) | ((data & MAC_QTFCR5_PT_MASK) << 16));\
		MAC_QTFCR5_RGWR(v);\
} while (0)

#define MAC_QTFCR5_PT_UDFRD(data) do {\
		MAC_QTFCR5_RGRD(data);\
		data = ((data >> 16) & MAC_QTFCR5_PT_MASK);\
} while (0)

#define MAC_QTFCR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x80))

#define MAC_QTFCR4_RGWR(data) do {\
		iowrite32(data, (void *)MAC_QTFCR4_RGOFFADDR);\
} while (0)

#define MAC_QTFCR4_RGRD(data) do {\
		(data) = ioread32((void *)MAC_QTFCR4_RGOFFADDR);\
} while (0)

/*#define  MAC_QTFCR4_Mask_8 (ULONG)(~(~0<<(8)))*/

#define  MAC_QTFCR4_MASK_8 (ULONG)(0xff)

/*#define MAC_QTFCR4_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(8)))<<(8)))*/

#define MAC_QTFCR4_RES_WR_MASK_8 (ULONG)(0xffff00ff)

/*#define  MAC_QTFCR4_Mask_2 (ULONG)(~(~0<<(2)))*/

#define  MAC_QTFCR4_MASK_2 (ULONG)(0x3)

/*#define MAC_QTFCR4_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(2)))<<(2)))*/

#define MAC_QTFCR4_RES_WR_MASK_2 (ULONG)(0xfffffff3)

/*#define MAC_QTFCR4_FCB_BPA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR4_FCB_BPA_MASK (ULONG)(0x1)

/*#define MAC_QTFCR4_FCB_BPA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_QTFCR4_FCB_BPA_WR_MASK (ULONG)(0xfffffffe)

#define MAC_QTFCR4_FCB_BPA_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR4_RGRD(v);\
		v = (v & (MAC_QTFCR4_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR4_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR4_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR4_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR4_FCB_BPA_WR_MASK) | ((data & MAC_QTFCR4_FCB_BPA_MASK) << 0));\
		MAC_QTFCR4_RGWR(v);\
} while (0)

#define MAC_QTFCR4_FCB_BPA_UDFRD(data) do {\
		MAC_QTFCR4_RGRD(data);\
		data = ((data >> 0) & MAC_QTFCR4_FCB_BPA_MASK);\
} while (0)

/*#define MAC_QTFCR4_TFE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR4_TFE_MASK (ULONG)(0x1)

/*#define MAC_QTFCR4_TFE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_QTFCR4_TFE_WR_MASK (ULONG)(0xfffffffd)

#define MAC_QTFCR4_TFE_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR4_RGRD(v);\
		v = (v & (MAC_QTFCR4_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR4_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR4_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR4_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR4_TFE_WR_MASK) | ((data & MAC_QTFCR4_TFE_MASK) << 1));\
		MAC_QTFCR4_RGWR(v);\
} while (0)

#define MAC_QTFCR4_TFE_UDFRD(data) do {\
		MAC_QTFCR4_RGRD(data);\
		data = ((data >> 1) & MAC_QTFCR4_TFE_MASK);\
} while (0)

/*#define MAC_QTFCR4_PLT_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_QTFCR4_PLT_MASK (ULONG)(0x7)

/*#define MAC_QTFCR4_PLT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MAC_QTFCR4_PLT_WR_MASK (ULONG)(0xffffff8f)

#define MAC_QTFCR4_PLT_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR4_RGRD(v);\
		v = (v & (MAC_QTFCR4_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR4_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR4_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR4_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR4_PLT_WR_MASK) | ((data & MAC_QTFCR4_PLT_MASK) << 4));\
		MAC_QTFCR4_RGWR(v);\
} while (0)

#define MAC_QTFCR4_PLT_UDFRD(data) do {\
		MAC_QTFCR4_RGRD(data);\
		data = ((data >> 4) & MAC_QTFCR4_PLT_MASK);\
} while (0)

/*#define MAC_QTFCR4_DZPQ_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR4_DZPQ_MASK (ULONG)(0x1)

/*#define MAC_QTFCR4_DZPQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MAC_QTFCR4_DZPQ_WR_MASK (ULONG)(0xffffff7f)

#define MAC_QTFCR4_DZPQ_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR4_RGRD(v);\
		v = (v & (MAC_QTFCR4_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR4_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR4_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR4_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR4_DZPQ_WR_MASK) | ((data & MAC_QTFCR4_DZPQ_MASK) << 7));\
		MAC_QTFCR4_RGWR(v);\
} while (0)

#define MAC_QTFCR4_DZPQ_UDFRD(data) do {\
		MAC_QTFCR4_RGRD(data);\
		data = ((data >> 7) & MAC_QTFCR4_DZPQ_MASK);\
} while (0)

/*#define MAC_QTFCR4_PT_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_QTFCR4_PT_MASK (ULONG)(0xffff)

/*#define MAC_QTFCR4_PT_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_QTFCR4_PT_WR_MASK (ULONG)(0xffff)

#define MAC_QTFCR4_PT_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR4_RGRD(v);\
		v = (v & (MAC_QTFCR4_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR4_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR4_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR4_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR4_PT_WR_MASK) | ((data & MAC_QTFCR4_PT_MASK) << 16));\
		MAC_QTFCR4_RGWR(v);\
} while (0)

#define MAC_QTFCR4_PT_UDFRD(data) do {\
		MAC_QTFCR4_RGRD(data);\
		data = ((data >> 16) & MAC_QTFCR4_PT_MASK);\
} while (0)

#define MAC_QTFCR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x7c))

#define MAC_QTFCR3_RGWR(data) do {\
		iowrite32(data, (void *)MAC_QTFCR3_RGOFFADDR);\
} while (0)

#define MAC_QTFCR3_RGRD(data) do {\
		(data) = ioread32((void *)MAC_QTFCR3_RGOFFADDR);\
} while (0)

/*#define  MAC_QTFCR3_Mask_8 (ULONG)(~(~0<<(8)))*/

#define  MAC_QTFCR3_MASK_8 (ULONG)(0xff)

/*#define MAC_QTFCR3_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(8)))<<(8)))*/

#define MAC_QTFCR3_RES_WR_MASK_8 (ULONG)(0xffff00ff)

/*#define  MAC_QTFCR3_Mask_2 (ULONG)(~(~0<<(2)))*/

#define  MAC_QTFCR3_MASK_2 (ULONG)(0x3)

/*#define MAC_QTFCR3_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(2)))<<(2)))*/

#define MAC_QTFCR3_RES_WR_MASK_2 (ULONG)(0xfffffff3)

/*#define MAC_QTFCR3_FCB_BPA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR3_FCB_BPA_MASK (ULONG)(0x1)

/*#define MAC_QTFCR3_FCB_BPA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_QTFCR3_FCB_BPA_WR_MASK (ULONG)(0xfffffffe)

#define MAC_QTFCR3_FCB_BPA_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR3_RGRD(v);\
		v = (v & (MAC_QTFCR3_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR3_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR3_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR3_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR3_FCB_BPA_WR_MASK) | ((data & MAC_QTFCR3_FCB_BPA_MASK) << 0));\
		MAC_QTFCR3_RGWR(v);\
} while (0)

#define MAC_QTFCR3_FCB_BPA_UDFRD(data) do {\
		MAC_QTFCR3_RGRD(data);\
		data = ((data >> 0) & MAC_QTFCR3_FCB_BPA_MASK);\
} while (0)

/*#define MAC_QTFCR3_TFE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR3_TFE_MASK (ULONG)(0x1)

/*#define MAC_QTFCR3_TFE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_QTFCR3_TFE_WR_MASK (ULONG)(0xfffffffd)

#define MAC_QTFCR3_TFE_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR3_RGRD(v);\
		v = (v & (MAC_QTFCR3_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR3_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR3_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR3_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR3_TFE_WR_MASK) | ((data & MAC_QTFCR3_TFE_MASK) << 1));\
		MAC_QTFCR3_RGWR(v);\
} while (0)

#define MAC_QTFCR3_TFE_UDFRD(data) do {\
		MAC_QTFCR3_RGRD(data);\
		data = ((data >> 1) & MAC_QTFCR3_TFE_MASK);\
} while (0)

/*#define MAC_QTFCR3_PLT_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_QTFCR3_PLT_MASK (ULONG)(0x7)

/*#define MAC_QTFCR3_PLT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MAC_QTFCR3_PLT_WR_MASK (ULONG)(0xffffff8f)

#define MAC_QTFCR3_PLT_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR3_RGRD(v);\
		v = (v & (MAC_QTFCR3_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR3_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR3_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR3_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR3_PLT_WR_MASK) | ((data & MAC_QTFCR3_PLT_MASK) << 4));\
		MAC_QTFCR3_RGWR(v);\
} while (0)

#define MAC_QTFCR3_PLT_UDFRD(data) do {\
		MAC_QTFCR3_RGRD(data);\
		data = ((data >> 4) & MAC_QTFCR3_PLT_MASK);\
} while (0)

/*#define MAC_QTFCR3_DZPQ_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR3_DZPQ_MASK (ULONG)(0x1)

/*#define MAC_QTFCR3_DZPQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MAC_QTFCR3_DZPQ_WR_MASK (ULONG)(0xffffff7f)

#define MAC_QTFCR3_DZPQ_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR3_RGRD(v);\
		v = (v & (MAC_QTFCR3_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR3_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR3_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR3_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR3_DZPQ_WR_MASK) | ((data & MAC_QTFCR3_DZPQ_MASK) << 7));\
		MAC_QTFCR3_RGWR(v);\
} while (0)

#define MAC_QTFCR3_DZPQ_UDFRD(data) do {\
		MAC_QTFCR3_RGRD(data);\
		data = ((data >> 7) & MAC_QTFCR3_DZPQ_MASK);\
} while (0)

/*#define MAC_QTFCR3_PT_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_QTFCR3_PT_MASK (ULONG)(0xffff)

/*#define MAC_QTFCR3_PT_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_QTFCR3_PT_WR_MASK (ULONG)(0xffff)

#define MAC_QTFCR3_PT_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR3_RGRD(v);\
		v = (v & (MAC_QTFCR3_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR3_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR3_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR3_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR3_PT_WR_MASK) | ((data & MAC_QTFCR3_PT_MASK) << 16));\
		MAC_QTFCR3_RGWR(v);\
} while (0)

#define MAC_QTFCR3_PT_UDFRD(data) do {\
		MAC_QTFCR3_RGRD(data);\
		data = ((data >> 16) & MAC_QTFCR3_PT_MASK);\
} while (0)

#define MAC_QTFCR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x78))

#define MAC_QTFCR2_RGWR(data) do {\
		iowrite32(data, (void *)MAC_QTFCR2_RGOFFADDR);\
} while (0)

#define MAC_QTFCR2_RGRD(data) do {\
		(data) = ioread32((void *)MAC_QTFCR2_RGOFFADDR);\
} while (0)

/*#define  MAC_QTFCR2_Mask_8 (ULONG)(~(~0<<(8)))*/

#define  MAC_QTFCR2_MASK_8 (ULONG)(0xff)

/*#define MAC_QTFCR2_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(8)))<<(8)))*/

#define MAC_QTFCR2_RES_WR_MASK_8 (ULONG)(0xffff00ff)

/*#define  MAC_QTFCR2_Mask_2 (ULONG)(~(~0<<(2)))*/

#define  MAC_QTFCR2_MASK_2 (ULONG)(0x3)

/*#define MAC_QTFCR2_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(2)))<<(2)))*/

#define MAC_QTFCR2_RES_WR_MASK_2 (ULONG)(0xfffffff3)

/*#define MAC_QTFCR2_FCB_BPA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR2_FCB_BPA_MASK (ULONG)(0x1)

/*#define MAC_QTFCR2_FCB_BPA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_QTFCR2_FCB_BPA_WR_MASK (ULONG)(0xfffffffe)

#define MAC_QTFCR2_FCB_BPA_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR2_RGRD(v);\
		v = (v & (MAC_QTFCR2_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR2_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR2_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR2_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR2_FCB_BPA_WR_MASK) | ((data & MAC_QTFCR2_FCB_BPA_MASK) << 0));\
		MAC_QTFCR2_RGWR(v);\
} while (0)

#define MAC_QTFCR2_FCB_BPA_UDFRD(data) do {\
		MAC_QTFCR2_RGRD(data);\
		data = ((data >> 0) & MAC_QTFCR2_FCB_BPA_MASK);\
} while (0)

/*#define MAC_QTFCR2_TFE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR2_TFE_MASK (ULONG)(0x1)

/*#define MAC_QTFCR2_TFE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_QTFCR2_TFE_WR_MASK (ULONG)(0xfffffffd)

#define MAC_QTFCR2_TFE_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR2_RGRD(v);\
		v = (v & (MAC_QTFCR2_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR2_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR2_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR2_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR2_TFE_WR_MASK) | ((data & MAC_QTFCR2_TFE_MASK) << 1));\
		MAC_QTFCR2_RGWR(v);\
} while (0)

#define MAC_QTFCR2_TFE_UDFRD(data) do {\
		MAC_QTFCR2_RGRD(data);\
		data = ((data >> 1) & MAC_QTFCR2_TFE_MASK);\
} while (0)

/*#define MAC_QTFCR2_PLT_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_QTFCR2_PLT_MASK (ULONG)(0x7)

/*#define MAC_QTFCR2_PLT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MAC_QTFCR2_PLT_WR_MASK (ULONG)(0xffffff8f)

#define MAC_QTFCR2_PLT_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR2_RGRD(v);\
		v = (v & (MAC_QTFCR2_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR2_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR2_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR2_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR2_PLT_WR_MASK) | ((data & MAC_QTFCR2_PLT_MASK) << 4));\
		MAC_QTFCR2_RGWR(v);\
} while (0)

#define MAC_QTFCR2_PLT_UDFRD(data) do {\
		MAC_QTFCR2_RGRD(data);\
		data = ((data >> 4) & MAC_QTFCR2_PLT_MASK);\
} while (0)

/*#define MAC_QTFCR2_DZPQ_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR2_DZPQ_MASK (ULONG)(0x1)

/*#define MAC_QTFCR2_DZPQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MAC_QTFCR2_DZPQ_WR_MASK (ULONG)(0xffffff7f)

#define MAC_QTFCR2_DZPQ_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR2_RGRD(v);\
		v = (v & (MAC_QTFCR2_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR2_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR2_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR2_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR2_DZPQ_WR_MASK) | ((data & MAC_QTFCR2_DZPQ_MASK) << 7));\
		MAC_QTFCR2_RGWR(v);\
} while (0)

#define MAC_QTFCR2_DZPQ_UDFRD(data) do {\
		MAC_QTFCR2_RGRD(data);\
		data = ((data >> 7) & MAC_QTFCR2_DZPQ_MASK);\
} while (0)

/*#define MAC_QTFCR2_PT_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_QTFCR2_PT_MASK (ULONG)(0xffff)

/*#define MAC_QTFCR2_PT_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_QTFCR2_PT_WR_MASK (ULONG)(0xffff)

#define MAC_QTFCR2_PT_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR2_RGRD(v);\
		v = (v & (MAC_QTFCR2_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR2_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR2_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR2_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR2_PT_WR_MASK) | ((data & MAC_QTFCR2_PT_MASK) << 16));\
		MAC_QTFCR2_RGWR(v);\
} while (0)

#define MAC_QTFCR2_PT_UDFRD(data) do {\
		MAC_QTFCR2_RGRD(data);\
		data = ((data >> 16) & MAC_QTFCR2_PT_MASK);\
} while (0)

#define MAC_QTFCR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x74))

#define MAC_QTFCR1_RGWR(data) do {\
		iowrite32(data, (void *)MAC_QTFCR1_RGOFFADDR);\
} while (0)

#define MAC_QTFCR1_RGRD(data) do {\
		(data) = ioread32((void *)MAC_QTFCR1_RGOFFADDR);\
} while (0)

/*#define  MAC_QTFCR1_Mask_8 (ULONG)(~(~0<<(8)))*/

#define  MAC_QTFCR1_MASK_8 (ULONG)(0xff)

/*#define MAC_QTFCR1_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(8)))<<(8)))*/

#define MAC_QTFCR1_RES_WR_MASK_8 (ULONG)(0xffff00ff)

/*#define  MAC_QTFCR1_Mask_2 (ULONG)(~(~0<<(2)))*/

#define  MAC_QTFCR1_MASK_2 (ULONG)(0x3)

/*#define MAC_QTFCR1_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(2)))<<(2)))*/

#define MAC_QTFCR1_RES_WR_MASK_2 (ULONG)(0xfffffff3)

/*#define MAC_QTFCR1_FCB_BPA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR1_FCB_BPA_MASK (ULONG)(0x1)

/*#define MAC_QTFCR1_FCB_BPA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_QTFCR1_FCB_BPA_WR_MASK (ULONG)(0xfffffffe)

#define MAC_QTFCR1_FCB_BPA_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR1_RGRD(v);\
		v = (v & (MAC_QTFCR1_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR1_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR1_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR1_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR1_FCB_BPA_WR_MASK) | ((data & MAC_QTFCR1_FCB_BPA_MASK) << 0));\
		MAC_QTFCR1_RGWR(v);\
} while (0)

#define MAC_QTFCR1_FCB_BPA_UDFRD(data) do {\
		MAC_QTFCR1_RGRD(data);\
		data = ((data >> 0) & MAC_QTFCR1_FCB_BPA_MASK);\
} while (0)

/*#define MAC_QTFCR1_TFE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR1_TFE_MASK (ULONG)(0x1)

/*#define MAC_QTFCR1_TFE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_QTFCR1_TFE_WR_MASK (ULONG)(0xfffffffd)

#define MAC_QTFCR1_TFE_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR1_RGRD(v);\
		v = (v & (MAC_QTFCR1_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR1_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR1_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR1_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR1_TFE_WR_MASK) | ((data & MAC_QTFCR1_TFE_MASK) << 1));\
		MAC_QTFCR1_RGWR(v);\
} while (0)

#define MAC_QTFCR1_TFE_UDFRD(data) do {\
		MAC_QTFCR1_RGRD(data);\
		data = ((data >> 1) & MAC_QTFCR1_TFE_MASK);\
} while (0)

/*#define MAC_QTFCR1_PLT_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_QTFCR1_PLT_MASK (ULONG)(0x7)

/*#define MAC_QTFCR1_PLT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MAC_QTFCR1_PLT_WR_MASK (ULONG)(0xffffff8f)

#define MAC_QTFCR1_PLT_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR1_RGRD(v);\
		v = (v & (MAC_QTFCR1_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR1_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR1_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR1_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR1_PLT_WR_MASK) | ((data & MAC_QTFCR1_PLT_MASK) << 4));\
		MAC_QTFCR1_RGWR(v);\
} while (0)

#define MAC_QTFCR1_PLT_UDFRD(data) do {\
		MAC_QTFCR1_RGRD(data);\
		data = ((data >> 4) & MAC_QTFCR1_PLT_MASK);\
} while (0)

/*#define MAC_QTFCR1_DZPQ_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR1_DZPQ_MASK (ULONG)(0x1)

/*#define MAC_QTFCR1_DZPQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MAC_QTFCR1_DZPQ_WR_MASK (ULONG)(0xffffff7f)

#define MAC_QTFCR1_DZPQ_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR1_RGRD(v);\
		v = (v & (MAC_QTFCR1_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR1_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR1_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR1_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR1_DZPQ_WR_MASK) | ((data & MAC_QTFCR1_DZPQ_MASK) << 7));\
		MAC_QTFCR1_RGWR(v);\
} while (0)

#define MAC_QTFCR1_DZPQ_UDFRD(data) do {\
		MAC_QTFCR1_RGRD(data);\
		data = ((data >> 7) & MAC_QTFCR1_DZPQ_MASK);\
} while (0)

/*#define MAC_QTFCR1_PT_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_QTFCR1_PT_MASK (ULONG)(0xffff)

/*#define MAC_QTFCR1_PT_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_QTFCR1_PT_WR_MASK (ULONG)(0xffff)

#define MAC_QTFCR1_PT_UDFWR(data) do {\
		ULONG v;\
		MAC_QTFCR1_RGRD(v);\
		v = (v & (MAC_QTFCR1_RES_WR_MASK_8)) | (((0) & (MAC_QTFCR1_MASK_8)) << 8);\
		v = (v & (MAC_QTFCR1_RES_WR_MASK_2)) | (((0) & (MAC_QTFCR1_MASK_2)) << 2);\
		v = ((v & MAC_QTFCR1_PT_WR_MASK) | ((data & MAC_QTFCR1_PT_MASK) << 16));\
		MAC_QTFCR1_RGWR(v);\
} while (0)

#define MAC_QTFCR1_PT_UDFRD(data) do {\
		MAC_QTFCR1_RGRD(data);\
		data = ((data >> 16) & MAC_QTFCR1_PT_MASK);\
} while (0)

#define MAC_Q0TFCR_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x70))

#define MAC_Q0TFCR_RGWR(data) do {\
		iowrite32(data, (void *)MAC_Q0TFCR_RGOFFADDR);\
} while (0)

#define MAC_Q0TFCR_RGRD(data) do {\
		(data) = ioread32((void *)MAC_Q0TFCR_RGOFFADDR);\
} while (0)

/*#define  MAC_Q0TFCR_Mask_8 (ULONG)(~(~0<<(8)))*/

#define  MAC_Q0TFCR_MASK_8 (ULONG)(0xff)

/*#define MAC_Q0TFCR_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(8)))<<(8)))*/

#define MAC_Q0TFCR_RES_WR_MASK_8 (ULONG)(0xffff00ff)

/*#define  MAC_Q0TFCR_Mask_2 (ULONG)(~(~0<<(2)))*/

#define  MAC_Q0TFCR_MASK_2 (ULONG)(0x3)

/*#define MAC_Q0TFCR_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(2)))<<(2)))*/

#define MAC_Q0TFCR_RES_WR_MASK_2 (ULONG)(0xfffffff3)

/*#define MAC_Q0TFCR_PT_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_Q0TFCR_PT_MASK (ULONG)(0xffff)

/*#define MAC_Q0TFCR_PT_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_Q0TFCR_PT_WR_MASK (ULONG)(0xffff)

#define MAC_Q0TFCR_PT_UDFWR(data) do {\
		ULONG v;\
		MAC_Q0TFCR_RGRD(v);\
		v = (v & (MAC_Q0TFCR_RES_WR_MASK_8)) | (((0) & (MAC_Q0TFCR_MASK_8)) << 8);\
		v = (v & (MAC_Q0TFCR_RES_WR_MASK_2)) | (((0) & (MAC_Q0TFCR_MASK_2)) << 2);\
		v = ((v & MAC_Q0TFCR_PT_WR_MASK) | ((data & MAC_Q0TFCR_PT_MASK) << 16));\
		MAC_Q0TFCR_RGWR(v);\
} while (0)

#define MAC_Q0TFCR_PT_UDFRD(data) do {\
		MAC_Q0TFCR_RGRD(data);\
		data = ((data >> 16) & MAC_Q0TFCR_PT_MASK);\
} while (0)

/*#define MAC_Q0TFCR_DZPQ_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_Q0TFCR_DZPQ_MASK (ULONG)(0x1)

/*#define MAC_Q0TFCR_DZPQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MAC_Q0TFCR_DZPQ_WR_MASK (ULONG)(0xffffff7f)

#define MAC_Q0TFCR_DZPQ_UDFWR(data) do {\
		ULONG v;\
		MAC_Q0TFCR_RGRD(v);\
		v = (v & (MAC_Q0TFCR_RES_WR_MASK_8)) | (((0) & (MAC_Q0TFCR_MASK_8)) << 8);\
		v = (v & (MAC_Q0TFCR_RES_WR_MASK_2)) | (((0) & (MAC_Q0TFCR_MASK_2)) << 2);\
		v = ((v & MAC_Q0TFCR_DZPQ_WR_MASK) | ((data & MAC_Q0TFCR_DZPQ_MASK) << 7));\
		MAC_Q0TFCR_RGWR(v);\
} while (0)

#define MAC_Q0TFCR_DZPQ_UDFRD(data) do {\
		MAC_Q0TFCR_RGRD(data);\
		data = ((data >> 7) & MAC_Q0TFCR_DZPQ_MASK);\
} while (0)

/*#define MAC_Q0TFCR_PLT_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_Q0TFCR_PLT_MASK (ULONG)(0x7)

/*#define MAC_Q0TFCR_PLT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MAC_Q0TFCR_PLT_WR_MASK (ULONG)(0xffffff8f)

#define MAC_Q0TFCR_PLT_UDFWR(data) do {\
		ULONG v;\
		MAC_Q0TFCR_RGRD(v);\
		v = (v & (MAC_Q0TFCR_RES_WR_MASK_8)) | (((0) & (MAC_Q0TFCR_MASK_8)) << 8);\
		v = (v & (MAC_Q0TFCR_RES_WR_MASK_2)) | (((0) & (MAC_Q0TFCR_MASK_2)) << 2);\
		v = ((v & MAC_Q0TFCR_PLT_WR_MASK) | ((data & MAC_Q0TFCR_PLT_MASK) << 4));\
		MAC_Q0TFCR_RGWR(v);\
} while (0)

#define MAC_Q0TFCR_PLT_UDFRD(data) do {\
		MAC_Q0TFCR_RGRD(data);\
		data = ((data >> 4) & MAC_Q0TFCR_PLT_MASK);\
} while (0)

/*#define MAC_Q0TFCR_TFE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_Q0TFCR_TFE_MASK (ULONG)(0x1)

/*#define MAC_Q0TFCR_TFE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_Q0TFCR_TFE_WR_MASK (ULONG)(0xfffffffd)

#define MAC_Q0TFCR_TFE_UDFWR(data) do {\
		ULONG v;\
		MAC_Q0TFCR_RGRD(v);\
		v = (v & (MAC_Q0TFCR_RES_WR_MASK_8)) | (((0) & (MAC_Q0TFCR_MASK_8)) << 8);\
		v = (v & (MAC_Q0TFCR_RES_WR_MASK_2)) | (((0) & (MAC_Q0TFCR_MASK_2)) << 2);\
		v = ((v & MAC_Q0TFCR_TFE_WR_MASK) | ((data & MAC_Q0TFCR_TFE_MASK) << 1));\
		MAC_Q0TFCR_RGWR(v);\
} while (0)

#define MAC_Q0TFCR_TFE_UDFRD(data) do {\
		MAC_Q0TFCR_RGRD(data);\
		data = ((data >> 1) & MAC_Q0TFCR_TFE_MASK);\
} while (0)

/*#define MAC_Q0TFCR_FCB_BPA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_Q0TFCR_FCB_BPA_MASK (ULONG)(0x1)

/*#define MAC_Q0TFCR_FCB_BPA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_Q0TFCR_FCB_BPA_WR_MASK (ULONG)(0xfffffffe)

#define MAC_Q0TFCR_FCB_BPA_UDFWR(data) do {\
		ULONG v;\
		MAC_Q0TFCR_RGRD(v);\
		v = (v & (MAC_Q0TFCR_RES_WR_MASK_8)) | (((0) & (MAC_Q0TFCR_MASK_8)) << 8);\
		v = (v & (MAC_Q0TFCR_RES_WR_MASK_2)) | (((0) & (MAC_Q0TFCR_MASK_2)) << 2);\
		v = ((v & MAC_Q0TFCR_FCB_BPA_WR_MASK) | ((data & MAC_Q0TFCR_FCB_BPA_MASK) << 0));\
		MAC_Q0TFCR_RGWR(v);\
} while (0)

#define MAC_Q0TFCR_FCB_BPA_UDFRD(data) do {\
		MAC_Q0TFCR_RGRD(data);\
		data = ((data >> 0) & MAC_Q0TFCR_FCB_BPA_MASK);\
} while (0)

#define DMA_AXI4CR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x14e4))

#define DMA_AXI4CR7_RGWR(data) do {\
		iowrite32(data, (void *)DMA_AXI4CR7_RGOFFADDR);\
} while (0)

#define DMA_AXI4CR7_RGRD(data) do {\
		(data) = ioread32((void *)DMA_AXI4CR7_RGOFFADDR);\
} while (0)

/*#define  DMA_AXI4CR7_Mask_4 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR7_MASK_4 (ULONG)(0xfff)

/*#define DMA_AXI4CR7_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(12)))<<(4)))*/

#define DMA_AXI4CR7_RES_WR_MASK_4 (ULONG)(0xffff000f)

/*#define  DMA_AXI4CR7_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR7_MASK_20 (ULONG)(0xfff)

/*#define DMA_AXI4CR7_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_AXI4CR7_RES_WR_MASK_20 (ULONG)(0xfffff)

/*#define DMA_AXI4CR7_AWQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR7_AWQOS_MASK (ULONG)(0xf)

/*#define DMA_AXI4CR7_AWQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (0)))*/

#define DMA_AXI4CR7_AWQOS_WR_MASK (ULONG)(0xfffffff0)

#define DMA_AXI4CR7_AWQOS_UDFWR(data) do {\
		ULONG v;\
		DMA_AXI4CR7_RGRD(v);\
		v = (v & (DMA_AXI4CR7_RES_WR_MASK_4)) | (((0) & (DMA_AXI4CR7_MASK_4)) << 4);\
		v = (v & (DMA_AXI4CR7_RES_WR_MASK_20)) | (((0) & (DMA_AXI4CR7_MASK_20)) << 20);\
		v = ((v & DMA_AXI4CR7_AWQOS_WR_MASK) | ((data & DMA_AXI4CR7_AWQOS_MASK) << 0));\
		DMA_AXI4CR7_RGWR(v);\
} while (0)

#define DMA_AXI4CR7_AWQOS_UDFRD(data) do {\
		DMA_AXI4CR7_RGRD(data);\
		data = ((data >> 0) & DMA_AXI4CR7_AWQOS_MASK);\
} while (0)

/*#define DMA_AXI4CR7_ARQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR7_ARQOS_MASK (ULONG)(0xf)

/*#define DMA_AXI4CR7_ARQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (16)))*/

#define DMA_AXI4CR7_ARQOS_WR_MASK (ULONG)(0xfff0ffff)

#define DMA_AXI4CR7_ARQOS_UDFWR(data) do {\
		ULONG v;\
		DMA_AXI4CR7_RGRD(v);\
		v = (v & (DMA_AXI4CR7_RES_WR_MASK_4)) | (((0) & (DMA_AXI4CR7_MASK_4)) << 4);\
		v = (v & (DMA_AXI4CR7_RES_WR_MASK_20)) | (((0) & (DMA_AXI4CR7_MASK_20)) << 20);\
		v = ((v & DMA_AXI4CR7_ARQOS_WR_MASK) | ((data & DMA_AXI4CR7_ARQOS_MASK) << 16));\
		DMA_AXI4CR7_RGWR(v);\
} while (0)

#define DMA_AXI4CR7_ARQOS_UDFRD(data) do {\
		DMA_AXI4CR7_RGRD(data);\
		data = ((data >> 16) & DMA_AXI4CR7_ARQOS_MASK);\
} while (0)

#define DMA_AXI4CR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1464))

#define DMA_AXI4CR6_RGWR(data) do {\
		iowrite32(data, (void *)DMA_AXI4CR6_RGOFFADDR);\
} while (0)

#define DMA_AXI4CR6_RGRD(data) do {\
		(data) = ioread32((void *)DMA_AXI4CR6_RGOFFADDR);\
} while (0)

/*#define  DMA_AXI4CR6_Mask_4 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR6_MASK_4 (ULONG)(0xfff)

/*#define DMA_AXI4CR6_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(12)))<<(4)))*/

#define DMA_AXI4CR6_RES_WR_MASK_4 (ULONG)(0xffff000f)

/*#define  DMA_AXI4CR6_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR6_MASK_20 (ULONG)(0xfff)

/*#define DMA_AXI4CR6_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_AXI4CR6_RES_WR_MASK_20 (ULONG)(0xfffff)

/*#define DMA_AXI4CR6_AWQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR6_AWQOS_MASK (ULONG)(0xf)

/*#define DMA_AXI4CR6_AWQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (0)))*/

#define DMA_AXI4CR6_AWQOS_WR_MASK (ULONG)(0xfffffff0)

#define DMA_AXI4CR6_AWQOS_UDFWR(data) do {\
		ULONG v;\
		DMA_AXI4CR6_RGRD(v);\
		v = (v & (DMA_AXI4CR6_RES_WR_MASK_4)) | (((0) & (DMA_AXI4CR6_MASK_4)) << 4);\
		v = (v & (DMA_AXI4CR6_RES_WR_MASK_20)) | (((0) & (DMA_AXI4CR6_MASK_20)) << 20);\
		v = ((v & DMA_AXI4CR6_AWQOS_WR_MASK) | ((data & DMA_AXI4CR6_AWQOS_MASK) << 0));\
		DMA_AXI4CR6_RGWR(v);\
} while (0)

#define DMA_AXI4CR6_AWQOS_UDFRD(data) do {\
		DMA_AXI4CR6_RGRD(data);\
		data = ((data >> 0) & DMA_AXI4CR6_AWQOS_MASK);\
} while (0)

/*#define DMA_AXI4CR6_ARQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR6_ARQOS_MASK (ULONG)(0xf)

/*#define DMA_AXI4CR6_ARQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (16)))*/

#define DMA_AXI4CR6_ARQOS_WR_MASK (ULONG)(0xfff0ffff)

#define DMA_AXI4CR6_ARQOS_UDFWR(data) do {\
		ULONG v;\
		DMA_AXI4CR6_RGRD(v);\
		v = (v & (DMA_AXI4CR6_RES_WR_MASK_4)) | (((0) & (DMA_AXI4CR6_MASK_4)) << 4);\
		v = (v & (DMA_AXI4CR6_RES_WR_MASK_20)) | (((0) & (DMA_AXI4CR6_MASK_20)) << 20);\
		v = ((v & DMA_AXI4CR6_ARQOS_WR_MASK) | ((data & DMA_AXI4CR6_ARQOS_MASK) << 16));\
		DMA_AXI4CR6_RGWR(v);\
} while (0)

#define DMA_AXI4CR6_ARQOS_UDFRD(data) do {\
		DMA_AXI4CR6_RGRD(data);\
		data = ((data >> 16) & DMA_AXI4CR6_ARQOS_MASK);\
} while (0)

#define DMA_AXI4CR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x13e4))

#define DMA_AXI4CR5_RGWR(data) do {\
		iowrite32(data, (void *)DMA_AXI4CR5_RGOFFADDR);\
} while (0)

#define DMA_AXI4CR5_RGRD(data) do {\
		(data) = ioread32((void *)DMA_AXI4CR5_RGOFFADDR);\
} while (0)

/*#define  DMA_AXI4CR5_Mask_4 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR5_MASK_4 (ULONG)(0xfff)

/*#define DMA_AXI4CR5_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(12)))<<(4)))*/

#define DMA_AXI4CR5_RES_WR_MASK_4 (ULONG)(0xffff000f)

/*#define  DMA_AXI4CR5_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR5_MASK_20 (ULONG)(0xfff)

/*#define DMA_AXI4CR5_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_AXI4CR5_RES_WR_MASK_20 (ULONG)(0xfffff)

/*#define DMA_AXI4CR5_AWQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR5_AWQOS_MASK (ULONG)(0xf)

/*#define DMA_AXI4CR5_AWQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (0)))*/

#define DMA_AXI4CR5_AWQOS_WR_MASK (ULONG)(0xfffffff0)

#define DMA_AXI4CR5_AWQOS_UDFWR(data) do {\
		ULONG v;\
		DMA_AXI4CR5_RGRD(v);\
		v = (v & (DMA_AXI4CR5_RES_WR_MASK_4)) | (((0) & (DMA_AXI4CR5_MASK_4)) << 4);\
		v = (v & (DMA_AXI4CR5_RES_WR_MASK_20)) | (((0) & (DMA_AXI4CR5_MASK_20)) << 20);\
		v = ((v & DMA_AXI4CR5_AWQOS_WR_MASK) | ((data & DMA_AXI4CR5_AWQOS_MASK) << 0));\
		DMA_AXI4CR5_RGWR(v);\
} while (0)

#define DMA_AXI4CR5_AWQOS_UDFRD(data) do {\
		DMA_AXI4CR5_RGRD(data);\
		data = ((data >> 0) & DMA_AXI4CR5_AWQOS_MASK);\
} while (0)

/*#define DMA_AXI4CR5_ARQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR5_ARQOS_MASK (ULONG)(0xf)

/*#define DMA_AXI4CR5_ARQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (16)))*/

#define DMA_AXI4CR5_ARQOS_WR_MASK (ULONG)(0xfff0ffff)

#define DMA_AXI4CR5_ARQOS_UDFWR(data) do {\
		ULONG v;\
		DMA_AXI4CR5_RGRD(v);\
		v = (v & (DMA_AXI4CR5_RES_WR_MASK_4)) | (((0) & (DMA_AXI4CR5_MASK_4)) << 4);\
		v = (v & (DMA_AXI4CR5_RES_WR_MASK_20)) | (((0) & (DMA_AXI4CR5_MASK_20)) << 20);\
		v = ((v & DMA_AXI4CR5_ARQOS_WR_MASK) | ((data & DMA_AXI4CR5_ARQOS_MASK) << 16));\
		DMA_AXI4CR5_RGWR(v);\
} while (0)

#define DMA_AXI4CR5_ARQOS_UDFRD(data) do {\
		DMA_AXI4CR5_RGRD(data);\
		data = ((data >> 16) & DMA_AXI4CR5_ARQOS_MASK);\
} while (0)

#define DMA_AXI4CR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1364))

#define DMA_AXI4CR4_RGWR(data) do {\
		iowrite32(data, (void *)DMA_AXI4CR4_RGOFFADDR);\
} while (0)

#define DMA_AXI4CR4_RGRD(data) do {\
		(data) = ioread32((void *)DMA_AXI4CR4_RGOFFADDR);\
} while (0)

/*#define  DMA_AXI4CR4_Mask_4 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR4_MASK_4 (ULONG)(0xfff)

/*#define DMA_AXI4CR4_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(12)))<<(4)))*/

#define DMA_AXI4CR4_RES_WR_MASK_4 (ULONG)(0xffff000f)

/*#define  DMA_AXI4CR4_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR4_MASK_20 (ULONG)(0xfff)

/*#define DMA_AXI4CR4_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_AXI4CR4_RES_WR_MASK_20 (ULONG)(0xfffff)

/*#define DMA_AXI4CR4_AWQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR4_AWQOS_MASK (ULONG)(0xf)

/*#define DMA_AXI4CR4_AWQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (0)))*/

#define DMA_AXI4CR4_AWQOS_WR_MASK (ULONG)(0xfffffff0)

#define DMA_AXI4CR4_AWQOS_UDFWR(data) do {\
		ULONG v;\
		DMA_AXI4CR4_RGRD(v);\
		v = (v & (DMA_AXI4CR4_RES_WR_MASK_4)) | (((0) & (DMA_AXI4CR4_MASK_4)) << 4);\
		v = (v & (DMA_AXI4CR4_RES_WR_MASK_20)) | (((0) & (DMA_AXI4CR4_MASK_20)) << 20);\
		v = ((v & DMA_AXI4CR4_AWQOS_WR_MASK) | ((data & DMA_AXI4CR4_AWQOS_MASK) << 0));\
		DMA_AXI4CR4_RGWR(v);\
} while (0)

#define DMA_AXI4CR4_AWQOS_UDFRD(data) do {\
		DMA_AXI4CR4_RGRD(data);\
		data = ((data >> 0) & DMA_AXI4CR4_AWQOS_MASK);\
} while (0)

/*#define DMA_AXI4CR4_ARQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR4_ARQOS_MASK (ULONG)(0xf)

/*#define DMA_AXI4CR4_ARQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (16)))*/

#define DMA_AXI4CR4_ARQOS_WR_MASK (ULONG)(0xfff0ffff)

#define DMA_AXI4CR4_ARQOS_UDFWR(data) do {\
		ULONG v;\
		DMA_AXI4CR4_RGRD(v);\
		v = (v & (DMA_AXI4CR4_RES_WR_MASK_4)) | (((0) & (DMA_AXI4CR4_MASK_4)) << 4);\
		v = (v & (DMA_AXI4CR4_RES_WR_MASK_20)) | (((0) & (DMA_AXI4CR4_MASK_20)) << 20);\
		v = ((v & DMA_AXI4CR4_ARQOS_WR_MASK) | ((data & DMA_AXI4CR4_ARQOS_MASK) << 16));\
		DMA_AXI4CR4_RGWR(v);\
} while (0)

#define DMA_AXI4CR4_ARQOS_UDFRD(data) do {\
		DMA_AXI4CR4_RGRD(data);\
		data = ((data >> 16) & DMA_AXI4CR4_ARQOS_MASK);\
} while (0)

#define DMA_AXI4CR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x12e4))

#define DMA_AXI4CR3_RGWR(data) do {\
		iowrite32(data, (void *)DMA_AXI4CR3_RGOFFADDR);\
} while (0)

#define DMA_AXI4CR3_RGRD(data) do {\
		(data) = ioread32((void *)DMA_AXI4CR3_RGOFFADDR);\
} while (0)

/*#define  DMA_AXI4CR3_Mask_4 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR3_MASK_4 (ULONG)(0xfff)

/*#define DMA_AXI4CR3_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(12)))<<(4)))*/

#define DMA_AXI4CR3_RES_WR_MASK_4 (ULONG)(0xffff000f)

/*#define  DMA_AXI4CR3_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR3_MASK_20 (ULONG)(0xfff)

/*#define DMA_AXI4CR3_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_AXI4CR3_RES_WR_MASK_20 (ULONG)(0xfffff)

/*#define DMA_AXI4CR3_AWQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR3_AWQOS_MASK (ULONG)(0xf)

/*#define DMA_AXI4CR3_AWQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (0)))*/

#define DMA_AXI4CR3_AWQOS_WR_MASK (ULONG)(0xfffffff0)

#define DMA_AXI4CR3_AWQOS_UDFWR(data) do {\
		ULONG v;\
		DMA_AXI4CR3_RGRD(v);\
		v = (v & (DMA_AXI4CR3_RES_WR_MASK_4)) | (((0) & (DMA_AXI4CR3_MASK_4)) << 4);\
		v = (v & (DMA_AXI4CR3_RES_WR_MASK_20)) | (((0) & (DMA_AXI4CR3_MASK_20)) << 20);\
		v = ((v & DMA_AXI4CR3_AWQOS_WR_MASK) | ((data & DMA_AXI4CR3_AWQOS_MASK) << 0));\
		DMA_AXI4CR3_RGWR(v);\
} while (0)

#define DMA_AXI4CR3_AWQOS_UDFRD(data) do {\
		DMA_AXI4CR3_RGRD(data);\
		data = ((data >> 0) & DMA_AXI4CR3_AWQOS_MASK);\
} while (0)

/*#define DMA_AXI4CR3_ARQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR3_ARQOS_MASK (ULONG)(0xf)

/*#define DMA_AXI4CR3_ARQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (16)))*/

#define DMA_AXI4CR3_ARQOS_WR_MASK (ULONG)(0xfff0ffff)

#define DMA_AXI4CR3_ARQOS_UDFWR(data) do {\
		ULONG v;\
		DMA_AXI4CR3_RGRD(v);\
		v = (v & (DMA_AXI4CR3_RES_WR_MASK_4)) | (((0) & (DMA_AXI4CR3_MASK_4)) << 4);\
		v = (v & (DMA_AXI4CR3_RES_WR_MASK_20)) | (((0) & (DMA_AXI4CR3_MASK_20)) << 20);\
		v = ((v & DMA_AXI4CR3_ARQOS_WR_MASK) | ((data & DMA_AXI4CR3_ARQOS_MASK) << 16));\
		DMA_AXI4CR3_RGWR(v);\
} while (0)

#define DMA_AXI4CR3_ARQOS_UDFRD(data) do {\
		DMA_AXI4CR3_RGRD(data);\
		data = ((data >> 16) & DMA_AXI4CR3_ARQOS_MASK);\
} while (0)

#define DMA_AXI4CR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1264))

#define DMA_AXI4CR2_RGWR(data) do {\
		iowrite32(data, (void *)DMA_AXI4CR2_RGOFFADDR);\
} while (0)

#define DMA_AXI4CR2_RGRD(data) do {\
		(data) = ioread32((void *)DMA_AXI4CR2_RGOFFADDR);\
} while (0)

/*#define  DMA_AXI4CR2_Mask_4 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR2_MASK_4 (ULONG)(0xfff)

/*#define DMA_AXI4CR2_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(12)))<<(4)))*/

#define DMA_AXI4CR2_RES_WR_MASK_4 (ULONG)(0xffff000f)

/*#define  DMA_AXI4CR2_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR2_MASK_20 (ULONG)(0xfff)

/*#define DMA_AXI4CR2_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_AXI4CR2_RES_WR_MASK_20 (ULONG)(0xfffff)

/*#define DMA_AXI4CR2_AWQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR2_AWQOS_MASK (ULONG)(0xf)

/*#define DMA_AXI4CR2_AWQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (0)))*/

#define DMA_AXI4CR2_AWQOS_WR_MASK (ULONG)(0xfffffff0)

#define DMA_AXI4CR2_AWQOS_UDFWR(data) do {\
		ULONG v;\
		DMA_AXI4CR2_RGRD(v);\
		v = (v & (DMA_AXI4CR2_RES_WR_MASK_4)) | (((0) & (DMA_AXI4CR2_MASK_4)) << 4);\
		v = (v & (DMA_AXI4CR2_RES_WR_MASK_20)) | (((0) & (DMA_AXI4CR2_MASK_20)) << 20);\
		v = ((v & DMA_AXI4CR2_AWQOS_WR_MASK) | ((data & DMA_AXI4CR2_AWQOS_MASK) << 0));\
		DMA_AXI4CR2_RGWR(v);\
} while (0)

#define DMA_AXI4CR2_AWQOS_UDFRD(data) do {\
		DMA_AXI4CR2_RGRD(data);\
		data = ((data >> 0) & DMA_AXI4CR2_AWQOS_MASK);\
} while (0)

/*#define DMA_AXI4CR2_ARQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR2_ARQOS_MASK (ULONG)(0xf)

/*#define DMA_AXI4CR2_ARQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (16)))*/

#define DMA_AXI4CR2_ARQOS_WR_MASK (ULONG)(0xfff0ffff)

#define DMA_AXI4CR2_ARQOS_UDFWR(data) do {\
		ULONG v;\
		DMA_AXI4CR2_RGRD(v);\
		v = (v & (DMA_AXI4CR2_RES_WR_MASK_4)) | (((0) & (DMA_AXI4CR2_MASK_4)) << 4);\
		v = (v & (DMA_AXI4CR2_RES_WR_MASK_20)) | (((0) & (DMA_AXI4CR2_MASK_20)) << 20);\
		v = ((v & DMA_AXI4CR2_ARQOS_WR_MASK) | ((data & DMA_AXI4CR2_ARQOS_MASK) << 16));\
		DMA_AXI4CR2_RGWR(v);\
} while (0)

#define DMA_AXI4CR2_ARQOS_UDFRD(data) do {\
		DMA_AXI4CR2_RGRD(data);\
		data = ((data >> 16) & DMA_AXI4CR2_ARQOS_MASK);\
} while (0)

#define DMA_AXI4CR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x11e4))

#define DMA_AXI4CR1_RGWR(data) do {\
		iowrite32(data, (void *)DMA_AXI4CR1_RGOFFADDR);\
} while (0)

#define DMA_AXI4CR1_RGRD(data) do {\
		(data) = ioread32((void *)DMA_AXI4CR1_RGOFFADDR);\
} while (0)

/*#define  DMA_AXI4CR1_Mask_4 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR1_MASK_4 (ULONG)(0xfff)

/*#define DMA_AXI4CR1_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(12)))<<(4)))*/

#define DMA_AXI4CR1_RES_WR_MASK_4 (ULONG)(0xffff000f)

/*#define  DMA_AXI4CR1_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR1_MASK_20 (ULONG)(0xfff)

/*#define DMA_AXI4CR1_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_AXI4CR1_RES_WR_MASK_20 (ULONG)(0xfffff)

/*#define DMA_AXI4CR1_AWQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR1_AWQOS_MASK (ULONG)(0xf)

/*#define DMA_AXI4CR1_AWQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (0)))*/

#define DMA_AXI4CR1_AWQOS_WR_MASK (ULONG)(0xfffffff0)

#define DMA_AXI4CR1_AWQOS_UDFWR(data) do {\
		ULONG v;\
		DMA_AXI4CR1_RGRD(v);\
		v = (v & (DMA_AXI4CR1_RES_WR_MASK_4)) | (((0) & (DMA_AXI4CR1_MASK_4)) << 4);\
		v = (v & (DMA_AXI4CR1_RES_WR_MASK_20)) | (((0) & (DMA_AXI4CR1_MASK_20)) << 20);\
		v = ((v & DMA_AXI4CR1_AWQOS_WR_MASK) | ((data & DMA_AXI4CR1_AWQOS_MASK) << 0));\
		DMA_AXI4CR1_RGWR(v);\
} while (0)

#define DMA_AXI4CR1_AWQOS_UDFRD(data) do {\
		DMA_AXI4CR1_RGRD(data);\
		data = ((data >> 0) & DMA_AXI4CR1_AWQOS_MASK);\
} while (0)

/*#define DMA_AXI4CR1_ARQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR1_ARQOS_MASK (ULONG)(0xf)

/*#define DMA_AXI4CR1_ARQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (16)))*/

#define DMA_AXI4CR1_ARQOS_WR_MASK (ULONG)(0xfff0ffff)

#define DMA_AXI4CR1_ARQOS_UDFWR(data) do {\
		ULONG v;\
		DMA_AXI4CR1_RGRD(v);\
		v = (v & (DMA_AXI4CR1_RES_WR_MASK_4)) | (((0) & (DMA_AXI4CR1_MASK_4)) << 4);\
		v = (v & (DMA_AXI4CR1_RES_WR_MASK_20)) | (((0) & (DMA_AXI4CR1_MASK_20)) << 20);\
		v = ((v & DMA_AXI4CR1_ARQOS_WR_MASK) | ((data & DMA_AXI4CR1_ARQOS_MASK) << 16));\
		DMA_AXI4CR1_RGWR(v);\
} while (0)

#define DMA_AXI4CR1_ARQOS_UDFRD(data) do {\
		DMA_AXI4CR1_RGRD(data);\
		data = ((data >> 16) & DMA_AXI4CR1_ARQOS_MASK);\
} while (0)

#define DMA_AXI4CR0_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1164))

#define DMA_AXI4CR0_RGWR(data) do {\
		iowrite32(data, (void *)DMA_AXI4CR0_RGOFFADDR);\
} while (0)

#define DMA_AXI4CR0_RGRD(data) do {\
		(data) = ioread32((void *)DMA_AXI4CR0_RGOFFADDR);\
} while (0)

/*#define  DMA_AXI4CR0_Mask_4 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR0_MASK_4 (ULONG)(0xfff)

/*#define DMA_AXI4CR0_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(12)))<<(4)))*/

#define DMA_AXI4CR0_RES_WR_MASK_4 (ULONG)(0xffff000f)

/*#define  DMA_AXI4CR0_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR0_MASK_20 (ULONG)(0xfff)

/*#define DMA_AXI4CR0_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_AXI4CR0_RES_WR_MASK_20 (ULONG)(0xfffff)

/*#define DMA_AXI4CR0_AWQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR0_AWQOS_MASK (ULONG)(0xf)

/*#define DMA_AXI4CR0_AWQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (0)))*/

#define DMA_AXI4CR0_AWQOS_WR_MASK (ULONG)(0xfffffff0)

#define DMA_AXI4CR0_AWQOS_UDFWR(data) do {\
		ULONG v;\
		DMA_AXI4CR0_RGRD(v);\
		v = (v & (DMA_AXI4CR0_RES_WR_MASK_4)) | (((0) & (DMA_AXI4CR0_MASK_4)) << 4);\
		v = (v & (DMA_AXI4CR0_RES_WR_MASK_20)) | (((0) & (DMA_AXI4CR0_MASK_20)) << 20);\
		v = ((v & DMA_AXI4CR0_AWQOS_WR_MASK) | ((data & DMA_AXI4CR0_AWQOS_MASK) << 0));\
		DMA_AXI4CR0_RGWR(v);\
} while (0)

#define DMA_AXI4CR0_AWQOS_UDFRD(data) do {\
		DMA_AXI4CR0_RGRD(data);\
		data = ((data >> 0) & DMA_AXI4CR0_AWQOS_MASK);\
} while (0)

/*#define DMA_AXI4CR0_ARQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR0_ARQOS_MASK (ULONG)(0xf)

/*#define DMA_AXI4CR0_ARQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (16)))*/

#define DMA_AXI4CR0_ARQOS_WR_MASK (ULONG)(0xfff0ffff)

#define DMA_AXI4CR0_ARQOS_UDFWR(data) do {\
		ULONG v;\
		DMA_AXI4CR0_RGRD(v);\
		v = (v & (DMA_AXI4CR0_RES_WR_MASK_4)) | (((0) & (DMA_AXI4CR0_MASK_4)) << 4);\
		v = (v & (DMA_AXI4CR0_RES_WR_MASK_20)) | (((0) & (DMA_AXI4CR0_MASK_20)) << 20);\
		v = ((v & DMA_AXI4CR0_ARQOS_WR_MASK) | ((data & DMA_AXI4CR0_ARQOS_MASK) << 16));\
		DMA_AXI4CR0_RGWR(v);\
} while (0)

#define DMA_AXI4CR0_ARQOS_UDFRD(data) do {\
		DMA_AXI4CR0_RGRD(data);\
		data = ((data >> 16) & DMA_AXI4CR0_ARQOS_MASK);\
} while (0)

#define DMA_RCR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1488))

#define DMA_RCR7_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RCR7_RGOFFADDR);\
} while (0)

#define DMA_RCR7_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RCR7_RGOFFADDR);\
} while (0)

/*#define  DMA_RCR7_Mask_15 (ULONG)(~(~0<<(1)))*/

#define  DMA_RCR7_MASK_15 (ULONG)(0x1)

/*#define DMA_RCR7_RES_Wr_Mask_15 (ULONG)(~((~(~0<<(1)))<<(15)))*/

#define DMA_RCR7_RES_WR_MASK_15 (ULONG)(0xffff7fff)

/*#define  DMA_RCR7_Mask_22 (ULONG)(~(~0<<(3)))*/

#define  DMA_RCR7_MASK_22 (ULONG)(0x7)

/*#define DMA_RCR7_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(3)))<<(22)))*/

#define DMA_RCR7_RES_WR_MASK_22 (ULONG)(0xfe3fffff)

/*#define  DMA_RCR7_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  DMA_RCR7_MASK_28 (ULONG)(0xf)

/*#define DMA_RCR7_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define DMA_RCR7_RES_WR_MASK_28 (ULONG)(0xfffffff)

/*#define DMA_RCR7_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR7_ST_MASK (ULONG)(0x1)

/*#define DMA_RCR7_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_RCR7_ST_WR_MASK (ULONG)(0xfffffffe)

#define DMA_RCR7_ST_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR7_RGRD(v);\
		v = (v & (DMA_RCR7_RES_WR_MASK_15)) | (((0) & (DMA_RCR7_MASK_15)) << 15);\
		v = (v & (DMA_RCR7_RES_WR_MASK_22)) | (((0) & (DMA_RCR7_MASK_22)) << 22);\
		v = (v & (DMA_RCR7_RES_WR_MASK_28)) | (((0) & (DMA_RCR7_MASK_28)) << 28);\
		v = ((v & DMA_RCR7_ST_WR_MASK) | ((data & DMA_RCR7_ST_MASK) << 0));\
		DMA_RCR7_RGWR(v);\
} while (0)

#define DMA_RCR7_ST_UDFRD(data) do {\
		DMA_RCR7_RGRD(data);\
		data = ((data >> 0) & DMA_RCR7_ST_MASK);\
} while (0)

/*#define DMA_RCR7_RBSZ_Mask (ULONG)(~(~0<<(14)))*/

#define DMA_RCR7_RBSZ_MASK (ULONG)(0x3fff)

/*#define DMA_RCR7_RBSZ_Wr_Mask (ULONG)(~((~(~0 << (14))) << (1)))*/

#define DMA_RCR7_RBSZ_WR_MASK (ULONG)(0xffff8001)

#define DMA_RCR7_RBSZ_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR7_RGRD(v);\
		v = (v & (DMA_RCR7_RES_WR_MASK_15)) | (((0) & (DMA_RCR7_MASK_15)) << 15);\
		v = (v & (DMA_RCR7_RES_WR_MASK_22)) | (((0) & (DMA_RCR7_MASK_22)) << 22);\
		v = (v & (DMA_RCR7_RES_WR_MASK_28)) | (((0) & (DMA_RCR7_MASK_28)) << 28);\
		v = ((v & DMA_RCR7_RBSZ_WR_MASK) | ((data & DMA_RCR7_RBSZ_MASK) << 1));\
		DMA_RCR7_RGWR(v);\
} while (0)

#define DMA_RCR7_RBSZ_UDFRD(data) do {\
		DMA_RCR7_RGRD(data);\
		data = ((data >> 1) & DMA_RCR7_RBSZ_MASK);\
} while (0)

/*#define DMA_RCR7_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_RCR7_PBL_MASK (ULONG)(0x3f)

/*#define DMA_RCR7_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_RCR7_PBL_WR_MASK (ULONG)(0xffc0ffff)

#define DMA_RCR7_PBL_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR7_RGRD(v);\
		v = (v & (DMA_RCR7_RES_WR_MASK_15)) | (((0) & (DMA_RCR7_MASK_15)) << 15);\
		v = (v & (DMA_RCR7_RES_WR_MASK_22)) | (((0) & (DMA_RCR7_MASK_22)) << 22);\
		v = (v & (DMA_RCR7_RES_WR_MASK_28)) | (((0) & (DMA_RCR7_MASK_28)) << 28);\
		v = ((v & DMA_RCR7_PBL_WR_MASK) | ((data & DMA_RCR7_PBL_MASK) << 16));\
		DMA_RCR7_RGWR(v);\
} while (0)

#define DMA_RCR7_PBL_UDFRD(data) do {\
		DMA_RCR7_RGRD(data);\
		data = ((data >> 16) & DMA_RCR7_PBL_MASK);\
} while (0)

/*#define DMA_RCR7_RES_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR7_RES_MASK (ULONG)(0x1)

/*#define DMA_RCR7_RES_Wr_Mask (ULONG)(~((~(~0 << (1))) << (25)))*/

#define DMA_RCR7_RES_WR_MASK (ULONG)(0xfdffffff)

#define DMA_RCR7_RES_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR7_RGRD(v);\
		v = (v & (DMA_RCR7_RES_WR_MASK_15)) | (((0) & (DMA_RCR7_MASK_15)) << 15);\
		v = (v & (DMA_RCR7_RES_WR_MASK_22)) | (((0) & (DMA_RCR7_MASK_22)) << 22);\
		v = (v & (DMA_RCR7_RES_WR_MASK_28)) | (((0) & (DMA_RCR7_MASK_28)) << 28);\
		v = ((v & DMA_RCR7_RES_WR_MASK) | ((data & DMA_RCR7_RES_MASK) << 25));\
		DMA_RCR7_RGWR(v);\
} while (0)

#define DMA_RCR7_RES_UDFRD(data) do {\
		DMA_RCR7_RGRD(data);\
		data = ((data >> 25) & DMA_RCR7_RES_MASK);\
} while (0)

/*#define DMA_RCR7_DFF_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR7_DFF_MASK (ULONG)(0x1)

/*#define DMA_RCR7_DFF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (26)))*/

#define DMA_RCR7_DFF_WR_MASK (ULONG)(0xfbffffff)

#define DMA_RCR7_DFF_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR7_RGRD(v);\
		v = (v & (DMA_RCR7_RES_WR_MASK_15)) | (((0) & (DMA_RCR7_MASK_15)) << 15);\
		v = (v & (DMA_RCR7_RES_WR_MASK_22)) | (((0) & (DMA_RCR7_MASK_22)) << 22);\
		v = (v & (DMA_RCR7_RES_WR_MASK_28)) | (((0) & (DMA_RCR7_MASK_28)) << 28);\
		v = ((v & DMA_RCR7_DFF_WR_MASK) | ((data & DMA_RCR7_DFF_MASK) << 26));\
		DMA_RCR7_RGWR(v);\
} while (0)

#define DMA_RCR7_DFF_UDFRD(data) do {\
		DMA_RCR7_RGRD(data);\
		data = ((data >> 26) & DMA_RCR7_DFF_MASK);\
} while (0)

/*#define DMA_RCR7_MAMS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR7_MAMS_MASK (ULONG)(0x1)

/*#define DMA_RCR7_MAMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define DMA_RCR7_MAMS_WR_MASK (ULONG)(0xf7ffffff)

#define DMA_RCR7_MAMS_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR7_RGRD(v);\
		v = (v & (DMA_RCR7_RES_WR_MASK_15)) | (((0) & (DMA_RCR7_MASK_15)) << 15);\
		v = (v & (DMA_RCR7_RES_WR_MASK_22)) | (((0) & (DMA_RCR7_MASK_22)) << 22);\
		v = (v & (DMA_RCR7_RES_WR_MASK_28)) | (((0) & (DMA_RCR7_MASK_28)) << 28);\
		v = ((v & DMA_RCR7_MAMS_WR_MASK) | ((data & DMA_RCR7_MAMS_MASK) << 27));\
		DMA_RCR7_RGWR(v);\
} while (0)

#define DMA_RCR7_MAMS_UDFRD(data) do {\
		DMA_RCR7_RGRD(data);\
		data = ((data >> 27) & DMA_RCR7_MAMS_MASK);\
} while (0)

#define DMA_RCR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1408))

#define DMA_RCR6_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RCR6_RGOFFADDR);\
} while (0)

#define DMA_RCR6_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RCR6_RGOFFADDR);\
} while (0)

/*#define  DMA_RCR6_Mask_15 (ULONG)(~(~0<<(1)))*/

#define  DMA_RCR6_MASK_15 (ULONG)(0x1)

/*#define DMA_RCR6_RES_Wr_Mask_15 (ULONG)(~((~(~0<<(1)))<<(15)))*/

#define DMA_RCR6_RES_WR_MASK_15 (ULONG)(0xffff7fff)

/*#define  DMA_RCR6_Mask_22 (ULONG)(~(~0<<(3)))*/

#define  DMA_RCR6_MASK_22 (ULONG)(0x7)

/*#define DMA_RCR6_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(3)))<<(22)))*/

#define DMA_RCR6_RES_WR_MASK_22 (ULONG)(0xfe3fffff)

/*#define  DMA_RCR6_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  DMA_RCR6_MASK_28 (ULONG)(0xf)

/*#define DMA_RCR6_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define DMA_RCR6_RES_WR_MASK_28 (ULONG)(0xfffffff)

/*#define DMA_RCR6_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR6_ST_MASK (ULONG)(0x1)

/*#define DMA_RCR6_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_RCR6_ST_WR_MASK (ULONG)(0xfffffffe)

#define DMA_RCR6_ST_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR6_RGRD(v);\
		v = (v & (DMA_RCR6_RES_WR_MASK_15)) | (((0) & (DMA_RCR6_MASK_15)) << 15);\
		v = (v & (DMA_RCR6_RES_WR_MASK_22)) | (((0) & (DMA_RCR6_MASK_22)) << 22);\
		v = (v & (DMA_RCR6_RES_WR_MASK_28)) | (((0) & (DMA_RCR6_MASK_28)) << 28);\
		v = ((v & DMA_RCR6_ST_WR_MASK) | ((data & DMA_RCR6_ST_MASK) << 0));\
		DMA_RCR6_RGWR(v);\
} while (0)

#define DMA_RCR6_ST_UDFRD(data) do {\
		DMA_RCR6_RGRD(data);\
		data = ((data >> 0) & DMA_RCR6_ST_MASK);\
} while (0)

/*#define DMA_RCR6_RBSZ_Mask (ULONG)(~(~0<<(14)))*/

#define DMA_RCR6_RBSZ_MASK (ULONG)(0x3fff)

/*#define DMA_RCR6_RBSZ_Wr_Mask (ULONG)(~((~(~0 << (14))) << (1)))*/

#define DMA_RCR6_RBSZ_WR_MASK (ULONG)(0xffff8001)

#define DMA_RCR6_RBSZ_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR6_RGRD(v);\
		v = (v & (DMA_RCR6_RES_WR_MASK_15)) | (((0) & (DMA_RCR6_MASK_15)) << 15);\
		v = (v & (DMA_RCR6_RES_WR_MASK_22)) | (((0) & (DMA_RCR6_MASK_22)) << 22);\
		v = (v & (DMA_RCR6_RES_WR_MASK_28)) | (((0) & (DMA_RCR6_MASK_28)) << 28);\
		v = ((v & DMA_RCR6_RBSZ_WR_MASK) | ((data & DMA_RCR6_RBSZ_MASK) << 1));\
		DMA_RCR6_RGWR(v);\
} while (0)

#define DMA_RCR6_RBSZ_UDFRD(data) do {\
		DMA_RCR6_RGRD(data);\
		data = ((data >> 1) & DMA_RCR6_RBSZ_MASK);\
} while (0)

/*#define DMA_RCR6_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_RCR6_PBL_MASK (ULONG)(0x3f)

/*#define DMA_RCR6_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_RCR6_PBL_WR_MASK (ULONG)(0xffc0ffff)

#define DMA_RCR6_PBL_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR6_RGRD(v);\
		v = (v & (DMA_RCR6_RES_WR_MASK_15)) | (((0) & (DMA_RCR6_MASK_15)) << 15);\
		v = (v & (DMA_RCR6_RES_WR_MASK_22)) | (((0) & (DMA_RCR6_MASK_22)) << 22);\
		v = (v & (DMA_RCR6_RES_WR_MASK_28)) | (((0) & (DMA_RCR6_MASK_28)) << 28);\
		v = ((v & DMA_RCR6_PBL_WR_MASK) | ((data & DMA_RCR6_PBL_MASK) << 16));\
		DMA_RCR6_RGWR(v);\
} while (0)

#define DMA_RCR6_PBL_UDFRD(data) do {\
		DMA_RCR6_RGRD(data);\
		data = ((data >> 16) & DMA_RCR6_PBL_MASK);\
} while (0)

/*#define DMA_RCR6_RES_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR6_RES_MASK (ULONG)(0x1)

/*#define DMA_RCR6_RES_Wr_Mask (ULONG)(~((~(~0 << (1))) << (25)))*/

#define DMA_RCR6_RES_WR_MASK (ULONG)(0xfdffffff)

#define DMA_RCR6_RES_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR6_RGRD(v);\
		v = (v & (DMA_RCR6_RES_WR_MASK_15)) | (((0) & (DMA_RCR6_MASK_15)) << 15);\
		v = (v & (DMA_RCR6_RES_WR_MASK_22)) | (((0) & (DMA_RCR6_MASK_22)) << 22);\
		v = (v & (DMA_RCR6_RES_WR_MASK_28)) | (((0) & (DMA_RCR6_MASK_28)) << 28);\
		v = ((v & DMA_RCR6_RES_WR_MASK) | ((data & DMA_RCR6_RES_MASK) << 25));\
		DMA_RCR6_RGWR(v);\
} while (0)

#define DMA_RCR6_RES_UDFRD(data) do {\
		DMA_RCR6_RGRD(data);\
		data = ((data >> 25) & DMA_RCR6_RES_MASK);\
} while (0)

/*#define DMA_RCR6_DFF_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR6_DFF_MASK (ULONG)(0x1)

/*#define DMA_RCR6_DFF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (26)))*/

#define DMA_RCR6_DFF_WR_MASK (ULONG)(0xfbffffff)

#define DMA_RCR6_DFF_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR6_RGRD(v);\
		v = (v & (DMA_RCR6_RES_WR_MASK_15)) | (((0) & (DMA_RCR6_MASK_15)) << 15);\
		v = (v & (DMA_RCR6_RES_WR_MASK_22)) | (((0) & (DMA_RCR6_MASK_22)) << 22);\
		v = (v & (DMA_RCR6_RES_WR_MASK_28)) | (((0) & (DMA_RCR6_MASK_28)) << 28);\
		v = ((v & DMA_RCR6_DFF_WR_MASK) | ((data & DMA_RCR6_DFF_MASK) << 26));\
		DMA_RCR6_RGWR(v);\
} while (0)

#define DMA_RCR6_DFF_UDFRD(data) do {\
		DMA_RCR6_RGRD(data);\
		data = ((data >> 26) & DMA_RCR6_DFF_MASK);\
} while (0)

/*#define DMA_RCR6_MAMS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR6_MAMS_MASK (ULONG)(0x1)

/*#define DMA_RCR6_MAMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define DMA_RCR6_MAMS_WR_MASK (ULONG)(0xf7ffffff)

#define DMA_RCR6_MAMS_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR6_RGRD(v);\
		v = (v & (DMA_RCR6_RES_WR_MASK_15)) | (((0) & (DMA_RCR6_MASK_15)) << 15);\
		v = (v & (DMA_RCR6_RES_WR_MASK_22)) | (((0) & (DMA_RCR6_MASK_22)) << 22);\
		v = (v & (DMA_RCR6_RES_WR_MASK_28)) | (((0) & (DMA_RCR6_MASK_28)) << 28);\
		v = ((v & DMA_RCR6_MAMS_WR_MASK) | ((data & DMA_RCR6_MAMS_MASK) << 27));\
		DMA_RCR6_RGWR(v);\
} while (0)

#define DMA_RCR6_MAMS_UDFRD(data) do {\
		DMA_RCR6_RGRD(data);\
		data = ((data >> 27) & DMA_RCR6_MAMS_MASK);\
} while (0)

#define DMA_RCR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1388))

#define DMA_RCR5_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RCR5_RGOFFADDR);\
} while (0)

#define DMA_RCR5_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RCR5_RGOFFADDR);\
} while (0)

/*#define  DMA_RCR5_Mask_15 (ULONG)(~(~0<<(1)))*/

#define  DMA_RCR5_MASK_15 (ULONG)(0x1)

/*#define DMA_RCR5_RES_Wr_Mask_15 (ULONG)(~((~(~0<<(1)))<<(15)))*/

#define DMA_RCR5_RES_WR_MASK_15 (ULONG)(0xffff7fff)

/*#define  DMA_RCR5_Mask_22 (ULONG)(~(~0<<(3)))*/

#define  DMA_RCR5_MASK_22 (ULONG)(0x7)

/*#define DMA_RCR5_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(3)))<<(22)))*/

#define DMA_RCR5_RES_WR_MASK_22 (ULONG)(0xfe3fffff)

/*#define  DMA_RCR5_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  DMA_RCR5_MASK_28 (ULONG)(0xf)

/*#define DMA_RCR5_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define DMA_RCR5_RES_WR_MASK_28 (ULONG)(0xfffffff)

/*#define DMA_RCR5_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR5_ST_MASK (ULONG)(0x1)

/*#define DMA_RCR5_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_RCR5_ST_WR_MASK (ULONG)(0xfffffffe)

#define DMA_RCR5_ST_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR5_RGRD(v);\
		v = (v & (DMA_RCR5_RES_WR_MASK_15)) | (((0) & (DMA_RCR5_MASK_15)) << 15);\
		v = (v & (DMA_RCR5_RES_WR_MASK_22)) | (((0) & (DMA_RCR5_MASK_22)) << 22);\
		v = (v & (DMA_RCR5_RES_WR_MASK_28)) | (((0) & (DMA_RCR5_MASK_28)) << 28);\
		v = ((v & DMA_RCR5_ST_WR_MASK) | ((data & DMA_RCR5_ST_MASK) << 0));\
		DMA_RCR5_RGWR(v);\
} while (0)

#define DMA_RCR5_ST_UDFRD(data) do {\
		DMA_RCR5_RGRD(data);\
		data = ((data >> 0) & DMA_RCR5_ST_MASK);\
} while (0)

/*#define DMA_RCR5_RBSZ_Mask (ULONG)(~(~0<<(14)))*/

#define DMA_RCR5_RBSZ_MASK (ULONG)(0x3fff)

/*#define DMA_RCR5_RBSZ_Wr_Mask (ULONG)(~((~(~0 << (14))) << (1)))*/

#define DMA_RCR5_RBSZ_WR_MASK (ULONG)(0xffff8001)

#define DMA_RCR5_RBSZ_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR5_RGRD(v);\
		v = (v & (DMA_RCR5_RES_WR_MASK_15)) | (((0) & (DMA_RCR5_MASK_15)) << 15);\
		v = (v & (DMA_RCR5_RES_WR_MASK_22)) | (((0) & (DMA_RCR5_MASK_22)) << 22);\
		v = (v & (DMA_RCR5_RES_WR_MASK_28)) | (((0) & (DMA_RCR5_MASK_28)) << 28);\
		v = ((v & DMA_RCR5_RBSZ_WR_MASK) | ((data & DMA_RCR5_RBSZ_MASK) << 1));\
		DMA_RCR5_RGWR(v);\
} while (0)

#define DMA_RCR5_RBSZ_UDFRD(data) do {\
		DMA_RCR5_RGRD(data);\
		data = ((data >> 1) & DMA_RCR5_RBSZ_MASK);\
} while (0)

/*#define DMA_RCR5_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_RCR5_PBL_MASK (ULONG)(0x3f)

/*#define DMA_RCR5_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_RCR5_PBL_WR_MASK (ULONG)(0xffc0ffff)

#define DMA_RCR5_PBL_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR5_RGRD(v);\
		v = (v & (DMA_RCR5_RES_WR_MASK_15)) | (((0) & (DMA_RCR5_MASK_15)) << 15);\
		v = (v & (DMA_RCR5_RES_WR_MASK_22)) | (((0) & (DMA_RCR5_MASK_22)) << 22);\
		v = (v & (DMA_RCR5_RES_WR_MASK_28)) | (((0) & (DMA_RCR5_MASK_28)) << 28);\
		v = ((v & DMA_RCR5_PBL_WR_MASK) | ((data & DMA_RCR5_PBL_MASK) << 16));\
		DMA_RCR5_RGWR(v);\
} while (0)

#define DMA_RCR5_PBL_UDFRD(data) do {\
		DMA_RCR5_RGRD(data);\
		data = ((data >> 16) & DMA_RCR5_PBL_MASK);\
} while (0)

/*#define DMA_RCR5_RES_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR5_RES_MASK (ULONG)(0x1)

/*#define DMA_RCR5_RES_Wr_Mask (ULONG)(~((~(~0 << (1))) << (25)))*/

#define DMA_RCR5_RES_WR_MASK (ULONG)(0xfdffffff)

#define DMA_RCR5_RES_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR5_RGRD(v);\
		v = (v & (DMA_RCR5_RES_WR_MASK_15)) | (((0) & (DMA_RCR5_MASK_15)) << 15);\
		v = (v & (DMA_RCR5_RES_WR_MASK_22)) | (((0) & (DMA_RCR5_MASK_22)) << 22);\
		v = (v & (DMA_RCR5_RES_WR_MASK_28)) | (((0) & (DMA_RCR5_MASK_28)) << 28);\
		v = ((v & DMA_RCR5_RES_WR_MASK) | ((data & DMA_RCR5_RES_MASK) << 25));\
		DMA_RCR5_RGWR(v);\
} while (0)

#define DMA_RCR5_RES_UDFRD(data) do {\
		DMA_RCR5_RGRD(data);\
		data = ((data >> 25) & DMA_RCR5_RES_MASK);\
} while (0)

/*#define DMA_RCR5_DFF_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR5_DFF_MASK (ULONG)(0x1)

/*#define DMA_RCR5_DFF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (26)))*/

#define DMA_RCR5_DFF_WR_MASK (ULONG)(0xfbffffff)

#define DMA_RCR5_DFF_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR5_RGRD(v);\
		v = (v & (DMA_RCR5_RES_WR_MASK_15)) | (((0) & (DMA_RCR5_MASK_15)) << 15);\
		v = (v & (DMA_RCR5_RES_WR_MASK_22)) | (((0) & (DMA_RCR5_MASK_22)) << 22);\
		v = (v & (DMA_RCR5_RES_WR_MASK_28)) | (((0) & (DMA_RCR5_MASK_28)) << 28);\
		v = ((v & DMA_RCR5_DFF_WR_MASK) | ((data & DMA_RCR5_DFF_MASK) << 26));\
		DMA_RCR5_RGWR(v);\
} while (0)

#define DMA_RCR5_DFF_UDFRD(data) do {\
		DMA_RCR5_RGRD(data);\
		data = ((data >> 26) & DMA_RCR5_DFF_MASK);\
} while (0)

/*#define DMA_RCR5_MAMS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR5_MAMS_MASK (ULONG)(0x1)

/*#define DMA_RCR5_MAMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define DMA_RCR5_MAMS_WR_MASK (ULONG)(0xf7ffffff)

#define DMA_RCR5_MAMS_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR5_RGRD(v);\
		v = (v & (DMA_RCR5_RES_WR_MASK_15)) | (((0) & (DMA_RCR5_MASK_15)) << 15);\
		v = (v & (DMA_RCR5_RES_WR_MASK_22)) | (((0) & (DMA_RCR5_MASK_22)) << 22);\
		v = (v & (DMA_RCR5_RES_WR_MASK_28)) | (((0) & (DMA_RCR5_MASK_28)) << 28);\
		v = ((v & DMA_RCR5_MAMS_WR_MASK) | ((data & DMA_RCR5_MAMS_MASK) << 27));\
		DMA_RCR5_RGWR(v);\
} while (0)

#define DMA_RCR5_MAMS_UDFRD(data) do {\
		DMA_RCR5_RGRD(data);\
		data = ((data >> 27) & DMA_RCR5_MAMS_MASK);\
} while (0)

#define DMA_RCR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1308))

#define DMA_RCR4_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RCR4_RGOFFADDR);\
} while (0)

#define DMA_RCR4_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RCR4_RGOFFADDR);\
} while (0)

/*#define  DMA_RCR4_Mask_15 (ULONG)(~(~0<<(1)))*/

#define  DMA_RCR4_MASK_15 (ULONG)(0x1)

/*#define DMA_RCR4_RES_Wr_Mask_15 (ULONG)(~((~(~0<<(1)))<<(15)))*/

#define DMA_RCR4_RES_WR_MASK_15 (ULONG)(0xffff7fff)

/*#define  DMA_RCR4_Mask_22 (ULONG)(~(~0<<(3)))*/

#define  DMA_RCR4_MASK_22 (ULONG)(0x7)

/*#define DMA_RCR4_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(3)))<<(22)))*/

#define DMA_RCR4_RES_WR_MASK_22 (ULONG)(0xfe3fffff)

/*#define  DMA_RCR4_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  DMA_RCR4_MASK_28 (ULONG)(0xf)

/*#define DMA_RCR4_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define DMA_RCR4_RES_WR_MASK_28 (ULONG)(0xfffffff)

/*#define DMA_RCR4_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR4_ST_MASK (ULONG)(0x1)

/*#define DMA_RCR4_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_RCR4_ST_WR_MASK (ULONG)(0xfffffffe)

#define DMA_RCR4_ST_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR4_RGRD(v);\
		v = (v & (DMA_RCR4_RES_WR_MASK_15)) | (((0) & (DMA_RCR4_MASK_15)) << 15);\
		v = (v & (DMA_RCR4_RES_WR_MASK_22)) | (((0) & (DMA_RCR4_MASK_22)) << 22);\
		v = (v & (DMA_RCR4_RES_WR_MASK_28)) | (((0) & (DMA_RCR4_MASK_28)) << 28);\
		v = ((v & DMA_RCR4_ST_WR_MASK) | ((data & DMA_RCR4_ST_MASK) << 0));\
		DMA_RCR4_RGWR(v);\
} while (0)

#define DMA_RCR4_ST_UDFRD(data) do {\
		DMA_RCR4_RGRD(data);\
		data = ((data >> 0) & DMA_RCR4_ST_MASK);\
} while (0)

/*#define DMA_RCR4_RBSZ_Mask (ULONG)(~(~0<<(14)))*/

#define DMA_RCR4_RBSZ_MASK (ULONG)(0x3fff)

/*#define DMA_RCR4_RBSZ_Wr_Mask (ULONG)(~((~(~0 << (14))) << (1)))*/

#define DMA_RCR4_RBSZ_WR_MASK (ULONG)(0xffff8001)

#define DMA_RCR4_RBSZ_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR4_RGRD(v);\
		v = (v & (DMA_RCR4_RES_WR_MASK_15)) | (((0) & (DMA_RCR4_MASK_15)) << 15);\
		v = (v & (DMA_RCR4_RES_WR_MASK_22)) | (((0) & (DMA_RCR4_MASK_22)) << 22);\
		v = (v & (DMA_RCR4_RES_WR_MASK_28)) | (((0) & (DMA_RCR4_MASK_28)) << 28);\
		v = ((v & DMA_RCR4_RBSZ_WR_MASK) | ((data & DMA_RCR4_RBSZ_MASK) << 1));\
		DMA_RCR4_RGWR(v);\
} while (0)

#define DMA_RCR4_RBSZ_UDFRD(data) do {\
		DMA_RCR4_RGRD(data);\
		data = ((data >> 1) & DMA_RCR4_RBSZ_MASK);\
} while (0)

/*#define DMA_RCR4_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_RCR4_PBL_MASK (ULONG)(0x3f)

/*#define DMA_RCR4_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_RCR4_PBL_WR_MASK (ULONG)(0xffc0ffff)

#define DMA_RCR4_PBL_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR4_RGRD(v);\
		v = (v & (DMA_RCR4_RES_WR_MASK_15)) | (((0) & (DMA_RCR4_MASK_15)) << 15);\
		v = (v & (DMA_RCR4_RES_WR_MASK_22)) | (((0) & (DMA_RCR4_MASK_22)) << 22);\
		v = (v & (DMA_RCR4_RES_WR_MASK_28)) | (((0) & (DMA_RCR4_MASK_28)) << 28);\
		v = ((v & DMA_RCR4_PBL_WR_MASK) | ((data & DMA_RCR4_PBL_MASK) << 16));\
		DMA_RCR4_RGWR(v);\
} while (0)

#define DMA_RCR4_PBL_UDFRD(data) do {\
		DMA_RCR4_RGRD(data);\
		data = ((data >> 16) & DMA_RCR4_PBL_MASK);\
} while (0)

/*#define DMA_RCR4_RES_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR4_RES_MASK (ULONG)(0x1)

/*#define DMA_RCR4_RES_Wr_Mask (ULONG)(~((~(~0 << (1))) << (25)))*/

#define DMA_RCR4_RES_WR_MASK (ULONG)(0xfdffffff)

#define DMA_RCR4_RES_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR4_RGRD(v);\
		v = (v & (DMA_RCR4_RES_WR_MASK_15)) | (((0) & (DMA_RCR4_MASK_15)) << 15);\
		v = (v & (DMA_RCR4_RES_WR_MASK_22)) | (((0) & (DMA_RCR4_MASK_22)) << 22);\
		v = (v & (DMA_RCR4_RES_WR_MASK_28)) | (((0) & (DMA_RCR4_MASK_28)) << 28);\
		v = ((v & DMA_RCR4_RES_WR_MASK) | ((data & DMA_RCR4_RES_MASK) << 25));\
		DMA_RCR4_RGWR(v);\
} while (0)

#define DMA_RCR4_RES_UDFRD(data) do {\
		DMA_RCR4_RGRD(data);\
		data = ((data >> 25) & DMA_RCR4_RES_MASK);\
} while (0)

/*#define DMA_RCR4_DFF_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR4_DFF_MASK (ULONG)(0x1)

/*#define DMA_RCR4_DFF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (26)))*/

#define DMA_RCR4_DFF_WR_MASK (ULONG)(0xfbffffff)

#define DMA_RCR4_DFF_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR4_RGRD(v);\
		v = (v & (DMA_RCR4_RES_WR_MASK_15)) | (((0) & (DMA_RCR4_MASK_15)) << 15);\
		v = (v & (DMA_RCR4_RES_WR_MASK_22)) | (((0) & (DMA_RCR4_MASK_22)) << 22);\
		v = (v & (DMA_RCR4_RES_WR_MASK_28)) | (((0) & (DMA_RCR4_MASK_28)) << 28);\
		v = ((v & DMA_RCR4_DFF_WR_MASK) | ((data & DMA_RCR4_DFF_MASK) << 26));\
		DMA_RCR4_RGWR(v);\
} while (0)

#define DMA_RCR4_DFF_UDFRD(data) do {\
		DMA_RCR4_RGRD(data);\
		data = ((data >> 26) & DMA_RCR4_DFF_MASK);\
} while (0)

/*#define DMA_RCR4_MAMS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR4_MAMS_MASK (ULONG)(0x1)

/*#define DMA_RCR4_MAMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define DMA_RCR4_MAMS_WR_MASK (ULONG)(0xf7ffffff)

#define DMA_RCR4_MAMS_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR4_RGRD(v);\
		v = (v & (DMA_RCR4_RES_WR_MASK_15)) | (((0) & (DMA_RCR4_MASK_15)) << 15);\
		v = (v & (DMA_RCR4_RES_WR_MASK_22)) | (((0) & (DMA_RCR4_MASK_22)) << 22);\
		v = (v & (DMA_RCR4_RES_WR_MASK_28)) | (((0) & (DMA_RCR4_MASK_28)) << 28);\
		v = ((v & DMA_RCR4_MAMS_WR_MASK) | ((data & DMA_RCR4_MAMS_MASK) << 27));\
		DMA_RCR4_RGWR(v);\
} while (0)

#define DMA_RCR4_MAMS_UDFRD(data) do {\
		DMA_RCR4_RGRD(data);\
		data = ((data >> 27) & DMA_RCR4_MAMS_MASK);\
} while (0)

#define DMA_RCR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1288))

#define DMA_RCR3_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RCR3_RGOFFADDR);\
} while (0)

#define DMA_RCR3_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RCR3_RGOFFADDR);\
} while (0)

/*#define  DMA_RCR3_Mask_15 (ULONG)(~(~0<<(1)))*/

#define  DMA_RCR3_MASK_15 (ULONG)(0x1)

/*#define DMA_RCR3_RES_Wr_Mask_15 (ULONG)(~((~(~0<<(1)))<<(15)))*/

#define DMA_RCR3_RES_WR_MASK_15 (ULONG)(0xffff7fff)

/*#define  DMA_RCR3_Mask_22 (ULONG)(~(~0<<(3)))*/

#define  DMA_RCR3_MASK_22 (ULONG)(0x7)

/*#define DMA_RCR3_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(3)))<<(22)))*/

#define DMA_RCR3_RES_WR_MASK_22 (ULONG)(0xfe3fffff)

/*#define  DMA_RCR3_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  DMA_RCR3_MASK_28 (ULONG)(0xf)

/*#define DMA_RCR3_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define DMA_RCR3_RES_WR_MASK_28 (ULONG)(0xfffffff)

/*#define DMA_RCR3_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR3_ST_MASK (ULONG)(0x1)

/*#define DMA_RCR3_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_RCR3_ST_WR_MASK (ULONG)(0xfffffffe)

#define DMA_RCR3_ST_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR3_RGRD(v);\
		v = (v & (DMA_RCR3_RES_WR_MASK_15)) | (((0) & (DMA_RCR3_MASK_15)) << 15);\
		v = (v & (DMA_RCR3_RES_WR_MASK_22)) | (((0) & (DMA_RCR3_MASK_22)) << 22);\
		v = (v & (DMA_RCR3_RES_WR_MASK_28)) | (((0) & (DMA_RCR3_MASK_28)) << 28);\
		v = ((v & DMA_RCR3_ST_WR_MASK) | ((data & DMA_RCR3_ST_MASK) << 0));\
		DMA_RCR3_RGWR(v);\
} while (0)

#define DMA_RCR3_ST_UDFRD(data) do {\
		DMA_RCR3_RGRD(data);\
		data = ((data >> 0) & DMA_RCR3_ST_MASK);\
} while (0)

/*#define DMA_RCR3_RBSZ_Mask (ULONG)(~(~0<<(14)))*/

#define DMA_RCR3_RBSZ_MASK (ULONG)(0x3fff)

/*#define DMA_RCR3_RBSZ_Wr_Mask (ULONG)(~((~(~0 << (14))) << (1)))*/

#define DMA_RCR3_RBSZ_WR_MASK (ULONG)(0xffff8001)

#define DMA_RCR3_RBSZ_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR3_RGRD(v);\
		v = (v & (DMA_RCR3_RES_WR_MASK_15)) | (((0) & (DMA_RCR3_MASK_15)) << 15);\
		v = (v & (DMA_RCR3_RES_WR_MASK_22)) | (((0) & (DMA_RCR3_MASK_22)) << 22);\
		v = (v & (DMA_RCR3_RES_WR_MASK_28)) | (((0) & (DMA_RCR3_MASK_28)) << 28);\
		v = ((v & DMA_RCR3_RBSZ_WR_MASK) | ((data & DMA_RCR3_RBSZ_MASK) << 1));\
		DMA_RCR3_RGWR(v);\
} while (0)

#define DMA_RCR3_RBSZ_UDFRD(data) do {\
		DMA_RCR3_RGRD(data);\
		data = ((data >> 1) & DMA_RCR3_RBSZ_MASK);\
} while (0)

/*#define DMA_RCR3_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_RCR3_PBL_MASK (ULONG)(0x3f)

/*#define DMA_RCR3_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_RCR3_PBL_WR_MASK (ULONG)(0xffc0ffff)

#define DMA_RCR3_PBL_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR3_RGRD(v);\
		v = (v & (DMA_RCR3_RES_WR_MASK_15)) | (((0) & (DMA_RCR3_MASK_15)) << 15);\
		v = (v & (DMA_RCR3_RES_WR_MASK_22)) | (((0) & (DMA_RCR3_MASK_22)) << 22);\
		v = (v & (DMA_RCR3_RES_WR_MASK_28)) | (((0) & (DMA_RCR3_MASK_28)) << 28);\
		v = ((v & DMA_RCR3_PBL_WR_MASK) | ((data & DMA_RCR3_PBL_MASK) << 16));\
		DMA_RCR3_RGWR(v);\
} while (0)

#define DMA_RCR3_PBL_UDFRD(data) do {\
		DMA_RCR3_RGRD(data);\
		data = ((data >> 16) & DMA_RCR3_PBL_MASK);\
} while (0)

/*#define DMA_RCR3_RES_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR3_RES_MASK (ULONG)(0x1)

/*#define DMA_RCR3_RES_Wr_Mask (ULONG)(~((~(~0 << (1))) << (25)))*/

#define DMA_RCR3_RES_WR_MASK (ULONG)(0xfdffffff)

#define DMA_RCR3_RES_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR3_RGRD(v);\
		v = (v & (DMA_RCR3_RES_WR_MASK_15)) | (((0) & (DMA_RCR3_MASK_15)) << 15);\
		v = (v & (DMA_RCR3_RES_WR_MASK_22)) | (((0) & (DMA_RCR3_MASK_22)) << 22);\
		v = (v & (DMA_RCR3_RES_WR_MASK_28)) | (((0) & (DMA_RCR3_MASK_28)) << 28);\
		v = ((v & DMA_RCR3_RES_WR_MASK) | ((data & DMA_RCR3_RES_MASK) << 25));\
		DMA_RCR3_RGWR(v);\
} while (0)

#define DMA_RCR3_RES_UDFRD(data) do {\
		DMA_RCR3_RGRD(data);\
		data = ((data >> 25) & DMA_RCR3_RES_MASK);\
} while (0)

/*#define DMA_RCR3_DFF_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR3_DFF_MASK (ULONG)(0x1)

/*#define DMA_RCR3_DFF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (26)))*/

#define DMA_RCR3_DFF_WR_MASK (ULONG)(0xfbffffff)

#define DMA_RCR3_DFF_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR3_RGRD(v);\
		v = (v & (DMA_RCR3_RES_WR_MASK_15)) | (((0) & (DMA_RCR3_MASK_15)) << 15);\
		v = (v & (DMA_RCR3_RES_WR_MASK_22)) | (((0) & (DMA_RCR3_MASK_22)) << 22);\
		v = (v & (DMA_RCR3_RES_WR_MASK_28)) | (((0) & (DMA_RCR3_MASK_28)) << 28);\
		v = ((v & DMA_RCR3_DFF_WR_MASK) | ((data & DMA_RCR3_DFF_MASK) << 26));\
		DMA_RCR3_RGWR(v);\
} while (0)

#define DMA_RCR3_DFF_UDFRD(data) do {\
		DMA_RCR3_RGRD(data);\
		data = ((data >> 26) & DMA_RCR3_DFF_MASK);\
} while (0)

/*#define DMA_RCR3_MAMS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR3_MAMS_MASK (ULONG)(0x1)

/*#define DMA_RCR3_MAMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define DMA_RCR3_MAMS_WR_MASK (ULONG)(0xf7ffffff)

#define DMA_RCR3_MAMS_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR3_RGRD(v);\
		v = (v & (DMA_RCR3_RES_WR_MASK_15)) | (((0) & (DMA_RCR3_MASK_15)) << 15);\
		v = (v & (DMA_RCR3_RES_WR_MASK_22)) | (((0) & (DMA_RCR3_MASK_22)) << 22);\
		v = (v & (DMA_RCR3_RES_WR_MASK_28)) | (((0) & (DMA_RCR3_MASK_28)) << 28);\
		v = ((v & DMA_RCR3_MAMS_WR_MASK) | ((data & DMA_RCR3_MAMS_MASK) << 27));\
		DMA_RCR3_RGWR(v);\
} while (0)

#define DMA_RCR3_MAMS_UDFRD(data) do {\
		DMA_RCR3_RGRD(data);\
		data = ((data >> 27) & DMA_RCR3_MAMS_MASK);\
} while (0)

#define DMA_RCR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1208))

#define DMA_RCR2_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RCR2_RGOFFADDR);\
} while (0)

#define DMA_RCR2_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RCR2_RGOFFADDR);\
} while (0)

/*#define  DMA_RCR2_Mask_15 (ULONG)(~(~0<<(1)))*/

#define  DMA_RCR2_MASK_15 (ULONG)(0x1)

/*#define DMA_RCR2_RES_Wr_Mask_15 (ULONG)(~((~(~0<<(1)))<<(15)))*/

#define DMA_RCR2_RES_WR_MASK_15 (ULONG)(0xffff7fff)

/*#define  DMA_RCR2_Mask_22 (ULONG)(~(~0<<(3)))*/

#define  DMA_RCR2_MASK_22 (ULONG)(0x7)

/*#define DMA_RCR2_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(3)))<<(22)))*/

#define DMA_RCR2_RES_WR_MASK_22 (ULONG)(0xfe3fffff)

/*#define  DMA_RCR2_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  DMA_RCR2_MASK_28 (ULONG)(0xf)

/*#define DMA_RCR2_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define DMA_RCR2_RES_WR_MASK_28 (ULONG)(0xfffffff)

/*#define DMA_RCR2_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR2_ST_MASK (ULONG)(0x1)

/*#define DMA_RCR2_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_RCR2_ST_WR_MASK (ULONG)(0xfffffffe)

#define DMA_RCR2_ST_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR2_RGRD(v);\
		v = (v & (DMA_RCR2_RES_WR_MASK_15)) | (((0) & (DMA_RCR2_MASK_15)) << 15);\
		v = (v & (DMA_RCR2_RES_WR_MASK_22)) | (((0) & (DMA_RCR2_MASK_22)) << 22);\
		v = (v & (DMA_RCR2_RES_WR_MASK_28)) | (((0) & (DMA_RCR2_MASK_28)) << 28);\
		v = ((v & DMA_RCR2_ST_WR_MASK) | ((data & DMA_RCR2_ST_MASK) << 0));\
		DMA_RCR2_RGWR(v);\
} while (0)

#define DMA_RCR2_ST_UDFRD(data) do {\
		DMA_RCR2_RGRD(data);\
		data = ((data >> 0) & DMA_RCR2_ST_MASK);\
} while (0)

/*#define DMA_RCR2_RBSZ_Mask (ULONG)(~(~0<<(14)))*/

#define DMA_RCR2_RBSZ_MASK (ULONG)(0x3fff)

/*#define DMA_RCR2_RBSZ_Wr_Mask (ULONG)(~((~(~0 << (14))) << (1)))*/

#define DMA_RCR2_RBSZ_WR_MASK (ULONG)(0xffff8001)

#define DMA_RCR2_RBSZ_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR2_RGRD(v);\
		v = (v & (DMA_RCR2_RES_WR_MASK_15)) | (((0) & (DMA_RCR2_MASK_15)) << 15);\
		v = (v & (DMA_RCR2_RES_WR_MASK_22)) | (((0) & (DMA_RCR2_MASK_22)) << 22);\
		v = (v & (DMA_RCR2_RES_WR_MASK_28)) | (((0) & (DMA_RCR2_MASK_28)) << 28);\
		v = ((v & DMA_RCR2_RBSZ_WR_MASK) | ((data & DMA_RCR2_RBSZ_MASK) << 1));\
		DMA_RCR2_RGWR(v);\
} while (0)

#define DMA_RCR2_RBSZ_UDFRD(data) do {\
		DMA_RCR2_RGRD(data);\
		data = ((data >> 1) & DMA_RCR2_RBSZ_MASK);\
} while (0)

/*#define DMA_RCR2_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_RCR2_PBL_MASK (ULONG)(0x3f)

/*#define DMA_RCR2_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_RCR2_PBL_WR_MASK (ULONG)(0xffc0ffff)

#define DMA_RCR2_PBL_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR2_RGRD(v);\
		v = (v & (DMA_RCR2_RES_WR_MASK_15)) | (((0) & (DMA_RCR2_MASK_15)) << 15);\
		v = (v & (DMA_RCR2_RES_WR_MASK_22)) | (((0) & (DMA_RCR2_MASK_22)) << 22);\
		v = (v & (DMA_RCR2_RES_WR_MASK_28)) | (((0) & (DMA_RCR2_MASK_28)) << 28);\
		v = ((v & DMA_RCR2_PBL_WR_MASK) | ((data & DMA_RCR2_PBL_MASK) << 16));\
		DMA_RCR2_RGWR(v);\
} while (0)

#define DMA_RCR2_PBL_UDFRD(data) do {\
		DMA_RCR2_RGRD(data);\
		data = ((data >> 16) & DMA_RCR2_PBL_MASK);\
} while (0)

/*#define DMA_RCR2_RES_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR2_RES_MASK (ULONG)(0x1)

/*#define DMA_RCR2_RES_Wr_Mask (ULONG)(~((~(~0 << (1))) << (25)))*/

#define DMA_RCR2_RES_WR_MASK (ULONG)(0xfdffffff)

#define DMA_RCR2_RES_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR2_RGRD(v);\
		v = (v & (DMA_RCR2_RES_WR_MASK_15)) | (((0) & (DMA_RCR2_MASK_15)) << 15);\
		v = (v & (DMA_RCR2_RES_WR_MASK_22)) | (((0) & (DMA_RCR2_MASK_22)) << 22);\
		v = (v & (DMA_RCR2_RES_WR_MASK_28)) | (((0) & (DMA_RCR2_MASK_28)) << 28);\
		v = ((v & DMA_RCR2_RES_WR_MASK) | ((data & DMA_RCR2_RES_MASK) << 25));\
		DMA_RCR2_RGWR(v);\
} while (0)

#define DMA_RCR2_RES_UDFRD(data) do {\
		DMA_RCR2_RGRD(data);\
		data = ((data >> 25) & DMA_RCR2_RES_MASK);\
} while (0)

/*#define DMA_RCR2_DFF_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR2_DFF_MASK (ULONG)(0x1)

/*#define DMA_RCR2_DFF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (26)))*/

#define DMA_RCR2_DFF_WR_MASK (ULONG)(0xfbffffff)

#define DMA_RCR2_DFF_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR2_RGRD(v);\
		v = (v & (DMA_RCR2_RES_WR_MASK_15)) | (((0) & (DMA_RCR2_MASK_15)) << 15);\
		v = (v & (DMA_RCR2_RES_WR_MASK_22)) | (((0) & (DMA_RCR2_MASK_22)) << 22);\
		v = (v & (DMA_RCR2_RES_WR_MASK_28)) | (((0) & (DMA_RCR2_MASK_28)) << 28);\
		v = ((v & DMA_RCR2_DFF_WR_MASK) | ((data & DMA_RCR2_DFF_MASK) << 26));\
		DMA_RCR2_RGWR(v);\
} while (0)

#define DMA_RCR2_DFF_UDFRD(data) do {\
		DMA_RCR2_RGRD(data);\
		data = ((data >> 26) & DMA_RCR2_DFF_MASK);\
} while (0)

/*#define DMA_RCR2_MAMS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR2_MAMS_MASK (ULONG)(0x1)

/*#define DMA_RCR2_MAMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define DMA_RCR2_MAMS_WR_MASK (ULONG)(0xf7ffffff)

#define DMA_RCR2_MAMS_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR2_RGRD(v);\
		v = (v & (DMA_RCR2_RES_WR_MASK_15)) | (((0) & (DMA_RCR2_MASK_15)) << 15);\
		v = (v & (DMA_RCR2_RES_WR_MASK_22)) | (((0) & (DMA_RCR2_MASK_22)) << 22);\
		v = (v & (DMA_RCR2_RES_WR_MASK_28)) | (((0) & (DMA_RCR2_MASK_28)) << 28);\
		v = ((v & DMA_RCR2_MAMS_WR_MASK) | ((data & DMA_RCR2_MAMS_MASK) << 27));\
		DMA_RCR2_RGWR(v);\
} while (0)

#define DMA_RCR2_MAMS_UDFRD(data) do {\
		DMA_RCR2_RGRD(data);\
		data = ((data >> 27) & DMA_RCR2_MAMS_MASK);\
} while (0)

#define DMA_RCR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1188))

#define DMA_RCR1_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RCR1_RGOFFADDR);\
} while (0)

#define DMA_RCR1_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RCR1_RGOFFADDR);\
} while (0)

/*#define  DMA_RCR1_Mask_15 (ULONG)(~(~0<<(1)))*/

#define  DMA_RCR1_MASK_15 (ULONG)(0x1)

/*#define DMA_RCR1_RES_Wr_Mask_15 (ULONG)(~((~(~0<<(1)))<<(15)))*/

#define DMA_RCR1_RES_WR_MASK_15 (ULONG)(0xffff7fff)

/*#define  DMA_RCR1_Mask_22 (ULONG)(~(~0<<(3)))*/

#define  DMA_RCR1_MASK_22 (ULONG)(0x7)

/*#define DMA_RCR1_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(3)))<<(22)))*/

#define DMA_RCR1_RES_WR_MASK_22 (ULONG)(0xfe3fffff)

/*#define  DMA_RCR1_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  DMA_RCR1_MASK_28 (ULONG)(0xf)

/*#define DMA_RCR1_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define DMA_RCR1_RES_WR_MASK_28 (ULONG)(0xfffffff)

/*#define DMA_RCR1_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR1_ST_MASK (ULONG)(0x1)

/*#define DMA_RCR1_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_RCR1_ST_WR_MASK (ULONG)(0xfffffffe)

#define DMA_RCR1_ST_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR1_RGRD(v);\
		v = (v & (DMA_RCR1_RES_WR_MASK_15)) | (((0) & (DMA_RCR1_MASK_15)) << 15);\
		v = (v & (DMA_RCR1_RES_WR_MASK_22)) | (((0) & (DMA_RCR1_MASK_22)) << 22);\
		v = (v & (DMA_RCR1_RES_WR_MASK_28)) | (((0) & (DMA_RCR1_MASK_28)) << 28);\
		v = ((v & DMA_RCR1_ST_WR_MASK) | ((data & DMA_RCR1_ST_MASK) << 0));\
		DMA_RCR1_RGWR(v);\
} while (0)

#define DMA_RCR1_ST_UDFRD(data) do {\
		DMA_RCR1_RGRD(data);\
		data = ((data >> 0) & DMA_RCR1_ST_MASK);\
} while (0)

/*#define DMA_RCR1_RBSZ_Mask (ULONG)(~(~0<<(14)))*/

#define DMA_RCR1_RBSZ_MASK (ULONG)(0x3fff)

/*#define DMA_RCR1_RBSZ_Wr_Mask (ULONG)(~((~(~0 << (14))) << (1)))*/

#define DMA_RCR1_RBSZ_WR_MASK (ULONG)(0xffff8001)

#define DMA_RCR1_RBSZ_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR1_RGRD(v);\
		v = (v & (DMA_RCR1_RES_WR_MASK_15)) | (((0) & (DMA_RCR1_MASK_15)) << 15);\
		v = (v & (DMA_RCR1_RES_WR_MASK_22)) | (((0) & (DMA_RCR1_MASK_22)) << 22);\
		v = (v & (DMA_RCR1_RES_WR_MASK_28)) | (((0) & (DMA_RCR1_MASK_28)) << 28);\
		v = ((v & DMA_RCR1_RBSZ_WR_MASK) | ((data & DMA_RCR1_RBSZ_MASK) << 1));\
		DMA_RCR1_RGWR(v);\
} while (0)

#define DMA_RCR1_RBSZ_UDFRD(data) do {\
		DMA_RCR1_RGRD(data);\
		data = ((data >> 1) & DMA_RCR1_RBSZ_MASK);\
} while (0)

/*#define DMA_RCR1_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_RCR1_PBL_MASK (ULONG)(0x3f)

/*#define DMA_RCR1_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_RCR1_PBL_WR_MASK (ULONG)(0xffc0ffff)

#define DMA_RCR1_PBL_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR1_RGRD(v);\
		v = (v & (DMA_RCR1_RES_WR_MASK_15)) | (((0) & (DMA_RCR1_MASK_15)) << 15);\
		v = (v & (DMA_RCR1_RES_WR_MASK_22)) | (((0) & (DMA_RCR1_MASK_22)) << 22);\
		v = (v & (DMA_RCR1_RES_WR_MASK_28)) | (((0) & (DMA_RCR1_MASK_28)) << 28);\
		v = ((v & DMA_RCR1_PBL_WR_MASK) | ((data & DMA_RCR1_PBL_MASK) << 16));\
		DMA_RCR1_RGWR(v);\
} while (0)

#define DMA_RCR1_PBL_UDFRD(data) do {\
		DMA_RCR1_RGRD(data);\
		data = ((data >> 16) & DMA_RCR1_PBL_MASK);\
} while (0)

/*#define DMA_RCR1_RES_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR1_RES_MASK (ULONG)(0x1)

/*#define DMA_RCR1_RES_Wr_Mask (ULONG)(~((~(~0 << (1))) << (25)))*/

#define DMA_RCR1_RES_WR_MASK (ULONG)(0xfdffffff)

#define DMA_RCR1_RES_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR1_RGRD(v);\
		v = (v & (DMA_RCR1_RES_WR_MASK_15)) | (((0) & (DMA_RCR1_MASK_15)) << 15);\
		v = (v & (DMA_RCR1_RES_WR_MASK_22)) | (((0) & (DMA_RCR1_MASK_22)) << 22);\
		v = (v & (DMA_RCR1_RES_WR_MASK_28)) | (((0) & (DMA_RCR1_MASK_28)) << 28);\
		v = ((v & DMA_RCR1_RES_WR_MASK) | ((data & DMA_RCR1_RES_MASK) << 25));\
		DMA_RCR1_RGWR(v);\
} while (0)

#define DMA_RCR1_RES_UDFRD(data) do {\
		DMA_RCR1_RGRD(data);\
		data = ((data >> 25) & DMA_RCR1_RES_MASK);\
} while (0)

/*#define DMA_RCR1_DFF_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR1_DFF_MASK (ULONG)(0x1)

/*#define DMA_RCR1_DFF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (26)))*/

#define DMA_RCR1_DFF_WR_MASK (ULONG)(0xfbffffff)

#define DMA_RCR1_DFF_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR1_RGRD(v);\
		v = (v & (DMA_RCR1_RES_WR_MASK_15)) | (((0) & (DMA_RCR1_MASK_15)) << 15);\
		v = (v & (DMA_RCR1_RES_WR_MASK_22)) | (((0) & (DMA_RCR1_MASK_22)) << 22);\
		v = (v & (DMA_RCR1_RES_WR_MASK_28)) | (((0) & (DMA_RCR1_MASK_28)) << 28);\
		v = ((v & DMA_RCR1_DFF_WR_MASK) | ((data & DMA_RCR1_DFF_MASK) << 26));\
		DMA_RCR1_RGWR(v);\
} while (0)

#define DMA_RCR1_DFF_UDFRD(data) do {\
		DMA_RCR1_RGRD(data);\
		data = ((data >> 26) & DMA_RCR1_DFF_MASK);\
} while (0)

/*#define DMA_RCR1_MAMS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR1_MAMS_MASK (ULONG)(0x1)

/*#define DMA_RCR1_MAMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define DMA_RCR1_MAMS_WR_MASK (ULONG)(0xf7ffffff)

#define DMA_RCR1_MAMS_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR1_RGRD(v);\
		v = (v & (DMA_RCR1_RES_WR_MASK_15)) | (((0) & (DMA_RCR1_MASK_15)) << 15);\
		v = (v & (DMA_RCR1_RES_WR_MASK_22)) | (((0) & (DMA_RCR1_MASK_22)) << 22);\
		v = (v & (DMA_RCR1_RES_WR_MASK_28)) | (((0) & (DMA_RCR1_MASK_28)) << 28);\
		v = ((v & DMA_RCR1_MAMS_WR_MASK) | ((data & DMA_RCR1_MAMS_MASK) << 27));\
		DMA_RCR1_RGWR(v);\
} while (0)

#define DMA_RCR1_MAMS_UDFRD(data) do {\
		DMA_RCR1_RGRD(data);\
		data = ((data >> 27) & DMA_RCR1_MAMS_MASK);\
} while (0)

#define DMA_RCR0_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1108))

#define DMA_RCR0_RGWR(data) do {\
		iowrite32(data, (void *)DMA_RCR0_RGOFFADDR);\
} while (0)

#define DMA_RCR0_RGRD(data) do {\
		(data) = ioread32((void *)DMA_RCR0_RGOFFADDR);\
} while (0)

/*#define  DMA_RCR0_Mask_15 (ULONG)(~(~0<<(1)))*/

#define  DMA_RCR0_MASK_15 (ULONG)(0x1)

/*#define DMA_RCR0_RES_Wr_Mask_15 (ULONG)(~((~(~0<<(1)))<<(15)))*/

#define DMA_RCR0_RES_WR_MASK_15 (ULONG)(0xffff7fff)

/*#define  DMA_RCR0_Mask_22 (ULONG)(~(~0<<(3)))*/

#define  DMA_RCR0_MASK_22 (ULONG)(0x7)

/*#define DMA_RCR0_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(3)))<<(22)))*/

#define DMA_RCR0_RES_WR_MASK_22 (ULONG)(0xfe3fffff)

/*#define  DMA_RCR0_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  DMA_RCR0_MASK_28 (ULONG)(0xf)

/*#define DMA_RCR0_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define DMA_RCR0_RES_WR_MASK_28 (ULONG)(0xfffffff)

/*#define DMA_RCR0_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR0_ST_MASK (ULONG)(0x1)

/*#define DMA_RCR0_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_RCR0_ST_WR_MASK (ULONG)(0xfffffffe)

#define DMA_RCR0_ST_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR0_RGRD(v);\
		v = (v & (DMA_RCR0_RES_WR_MASK_15)) | (((0) & (DMA_RCR0_MASK_15)) << 15);\
		v = (v & (DMA_RCR0_RES_WR_MASK_22)) | (((0) & (DMA_RCR0_MASK_22)) << 22);\
		v = (v & (DMA_RCR0_RES_WR_MASK_28)) | (((0) & (DMA_RCR0_MASK_28)) << 28);\
		v = ((v & DMA_RCR0_ST_WR_MASK) | ((data & DMA_RCR0_ST_MASK) << 0));\
		DMA_RCR0_RGWR(v);\
} while (0)

#define DMA_RCR0_ST_UDFRD(data) do {\
		DMA_RCR0_RGRD(data);\
		data = ((data >> 0) & DMA_RCR0_ST_MASK);\
} while (0)

/*#define DMA_RCR0_RBSZ_Mask (ULONG)(~(~0<<(14)))*/

#define DMA_RCR0_RBSZ_MASK (ULONG)(0x3fff)

/*#define DMA_RCR0_RBSZ_Wr_Mask (ULONG)(~((~(~0 << (14))) << (1)))*/

#define DMA_RCR0_RBSZ_WR_MASK (ULONG)(0xffff8001)

#define DMA_RCR0_RBSZ_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR0_RGRD(v);\
		v = (v & (DMA_RCR0_RES_WR_MASK_15)) | (((0) & (DMA_RCR0_MASK_15)) << 15);\
		v = (v & (DMA_RCR0_RES_WR_MASK_22)) | (((0) & (DMA_RCR0_MASK_22)) << 22);\
		v = (v & (DMA_RCR0_RES_WR_MASK_28)) | (((0) & (DMA_RCR0_MASK_28)) << 28);\
		v = ((v & DMA_RCR0_RBSZ_WR_MASK) | ((data & DMA_RCR0_RBSZ_MASK) << 1));\
		DMA_RCR0_RGWR(v);\
} while (0)

#define DMA_RCR0_RBSZ_UDFRD(data) do {\
		DMA_RCR0_RGRD(data);\
		data = ((data >> 1) & DMA_RCR0_RBSZ_MASK);\
} while (0)

/*#define DMA_RCR0_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_RCR0_PBL_MASK (ULONG)(0x3f)

/*#define DMA_RCR0_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_RCR0_PBL_WR_MASK (ULONG)(0xffc0ffff)

#define DMA_RCR0_PBL_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR0_RGRD(v);\
		v = (v & (DMA_RCR0_RES_WR_MASK_15)) | (((0) & (DMA_RCR0_MASK_15)) << 15);\
		v = (v & (DMA_RCR0_RES_WR_MASK_22)) | (((0) & (DMA_RCR0_MASK_22)) << 22);\
		v = (v & (DMA_RCR0_RES_WR_MASK_28)) | (((0) & (DMA_RCR0_MASK_28)) << 28);\
		v = ((v & DMA_RCR0_PBL_WR_MASK) | ((data & DMA_RCR0_PBL_MASK) << 16));\
		DMA_RCR0_RGWR(v);\
} while (0)

#define DMA_RCR0_PBL_UDFRD(data) do {\
		DMA_RCR0_RGRD(data);\
		data = ((data >> 16) & DMA_RCR0_PBL_MASK);\
} while (0)

/*#define DMA_RCR0_RES_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR0_RES_MASK (ULONG)(0x1)

/*#define DMA_RCR0_RES_Wr_Mask (ULONG)(~((~(~0 << (1))) << (25)))*/

#define DMA_RCR0_RES_WR_MASK (ULONG)(0xfdffffff)

#define DMA_RCR0_RES_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR0_RGRD(v);\
		v = (v & (DMA_RCR0_RES_WR_MASK_15)) | (((0) & (DMA_RCR0_MASK_15)) << 15);\
		v = (v & (DMA_RCR0_RES_WR_MASK_22)) | (((0) & (DMA_RCR0_MASK_22)) << 22);\
		v = (v & (DMA_RCR0_RES_WR_MASK_28)) | (((0) & (DMA_RCR0_MASK_28)) << 28);\
		v = ((v & DMA_RCR0_RES_WR_MASK) | ((data & DMA_RCR0_RES_MASK) << 25));\
		DMA_RCR0_RGWR(v);\
} while (0)

#define DMA_RCR0_RES_UDFRD(data) do {\
		DMA_RCR0_RGRD(data);\
		data = ((data >> 25) & DMA_RCR0_RES_MASK);\
} while (0)

/*#define DMA_RCR0_DFF_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR0_DFF_MASK (ULONG)(0x1)

/*#define DMA_RCR0_DFF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (26)))*/

#define DMA_RCR0_DFF_WR_MASK (ULONG)(0xfbffffff)

#define DMA_RCR0_DFF_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR0_RGRD(v);\
		v = (v & (DMA_RCR0_RES_WR_MASK_15)) | (((0) & (DMA_RCR0_MASK_15)) << 15);\
		v = (v & (DMA_RCR0_RES_WR_MASK_22)) | (((0) & (DMA_RCR0_MASK_22)) << 22);\
		v = (v & (DMA_RCR0_RES_WR_MASK_28)) | (((0) & (DMA_RCR0_MASK_28)) << 28);\
		v = ((v & DMA_RCR0_DFF_WR_MASK) | ((data & DMA_RCR0_DFF_MASK) << 26));\
		DMA_RCR0_RGWR(v);\
} while (0)

#define DMA_RCR0_DFF_UDFRD(data) do {\
		DMA_RCR0_RGRD(data);\
		data = ((data >> 26) & DMA_RCR0_DFF_MASK);\
} while (0)

/*#define DMA_RCR0_MAMS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR0_MAMS_MASK (ULONG)(0x1)

/*#define DMA_RCR0_MAMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define DMA_RCR0_MAMS_WR_MASK (ULONG)(0xf7ffffff)

#define DMA_RCR0_MAMS_UDFWR(data) do {\
		ULONG v;\
		DMA_RCR0_RGRD(v);\
		v = (v & (DMA_RCR0_RES_WR_MASK_15)) | (((0) & (DMA_RCR0_MASK_15)) << 15);\
		v = (v & (DMA_RCR0_RES_WR_MASK_22)) | (((0) & (DMA_RCR0_MASK_22)) << 22);\
		v = (v & (DMA_RCR0_RES_WR_MASK_28)) | (((0) & (DMA_RCR0_MASK_28)) << 28);\
		v = ((v & DMA_RCR0_MAMS_WR_MASK) | ((data & DMA_RCR0_MAMS_MASK) << 27));\
		DMA_RCR0_RGWR(v);\
} while (0)

#define DMA_RCR0_MAMS_UDFRD(data) do {\
		DMA_RCR0_RGRD(data);\
		data = ((data >> 27) & DMA_RCR0_MAMS_MASK);\
} while (0)

#define DMA_TCR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1484))

#define DMA_TCR7_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TCR7_RGOFFADDR);\
} while (0)

#define DMA_TCR7_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TCR7_RGOFFADDR);\
} while (0)

/*#define  DMA_TCR7_Mask_5 (ULONG)(~(~0<<(7)))*/

#define  DMA_TCR7_MASK_5 (ULONG)(0x7f)

/*#define DMA_TCR7_RES_Wr_Mask_5 (ULONG)(~((~(~0<<(7)))<<(5)))*/

#define DMA_TCR7_RES_WR_MASK_5 (ULONG)(0xfffff01f)

/*#define  DMA_TCR7_Mask_13 (ULONG)(~(~0<<(3)))*/

#define  DMA_TCR7_MASK_13 (ULONG)(0x7)

/*#define DMA_TCR7_RES_Wr_Mask_13 (ULONG)(~((~(~0<<(3)))<<(13)))*/

#define DMA_TCR7_RES_WR_MASK_13 (ULONG)(0xffff1fff)

/*#define  DMA_TCR7_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  DMA_TCR7_MASK_22 (ULONG)(0x3ff)

/*#define DMA_TCR7_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define DMA_TCR7_RES_WR_MASK_22 (ULONG)(0x3fffff)

/*#define DMA_TCR7_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR7_ST_MASK (ULONG)(0x1)

/*#define DMA_TCR7_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_TCR7_ST_WR_MASK (ULONG)(0xfffffffe)

#define DMA_TCR7_ST_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR7_RGRD(v);\
		v = (v & (DMA_TCR7_RES_WR_MASK_5)) | (((0) & (DMA_TCR7_MASK_5)) << 5);\
		v = (v & (DMA_TCR7_RES_WR_MASK_13)) | (((0) & (DMA_TCR7_MASK_13)) << 13);\
		v = (v & (DMA_TCR7_RES_WR_MASK_22)) | (((0) & (DMA_TCR7_MASK_22)) << 22);\
		v = ((v & DMA_TCR7_ST_WR_MASK) | ((data & DMA_TCR7_ST_MASK) << 0));\
		DMA_TCR7_RGWR(v);\
} while (0)

#define DMA_TCR7_ST_UDFRD(data) do {\
		DMA_TCR7_RGRD(data);\
		data = ((data >> 0) & DMA_TCR7_ST_MASK);\
} while (0)

/*#define DMA_TCR7_TCW_Mask (ULONG)(~(~0<<(3)))*/

#define DMA_TCR7_TCW_MASK (ULONG)(0x7)

/*#define DMA_TCR7_TCW_Wr_Mask (ULONG)(~((~(~0 << (3))) << (1)))*/

#define DMA_TCR7_TCW_WR_MASK (ULONG)(0xfffffff1)

#define DMA_TCR7_TCW_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR7_RGRD(v);\
		v = (v & (DMA_TCR7_RES_WR_MASK_5)) | (((0) & (DMA_TCR7_MASK_5)) << 5);\
		v = (v & (DMA_TCR7_RES_WR_MASK_13)) | (((0) & (DMA_TCR7_MASK_13)) << 13);\
		v = (v & (DMA_TCR7_RES_WR_MASK_22)) | (((0) & (DMA_TCR7_MASK_22)) << 22);\
		v = ((v & DMA_TCR7_TCW_WR_MASK) | ((data & DMA_TCR7_TCW_MASK) << 1));\
		DMA_TCR7_RGWR(v);\
} while (0)

#define DMA_TCR7_TCW_UDFRD(data) do {\
		DMA_TCR7_RGRD(data);\
		data = ((data >> 1) & DMA_TCR7_TCW_MASK);\
} while (0)

/*#define DMA_TCR7_OSP_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR7_OSP_MASK (ULONG)(0x1)

/*#define DMA_TCR7_OSP_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define DMA_TCR7_OSP_WR_MASK (ULONG)(0xffffffef)

#define DMA_TCR7_OSP_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR7_RGRD(v);\
		v = (v & (DMA_TCR7_RES_WR_MASK_5)) | (((0) & (DMA_TCR7_MASK_5)) << 5);\
		v = (v & (DMA_TCR7_RES_WR_MASK_13)) | (((0) & (DMA_TCR7_MASK_13)) << 13);\
		v = (v & (DMA_TCR7_RES_WR_MASK_22)) | (((0) & (DMA_TCR7_MASK_22)) << 22);\
		v = ((v & DMA_TCR7_OSP_WR_MASK) | ((data & DMA_TCR7_OSP_MASK) << 4));\
		DMA_TCR7_RGWR(v);\
} while (0)

#define DMA_TCR7_OSP_UDFRD(data) do {\
		DMA_TCR7_RGRD(data);\
		data = ((data >> 4) & DMA_TCR7_OSP_MASK);\
} while (0)

/*#define DMA_TCR7_TSE_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR7_TSE_MASK (ULONG)(0x1)

/*#define DMA_TCR7_TSE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define DMA_TCR7_TSE_WR_MASK (ULONG)(0xffffefff)

#define DMA_TCR7_TSE_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR7_RGRD(v);\
		v = (v & (DMA_TCR7_RES_WR_MASK_5)) | (((0) & (DMA_TCR7_MASK_5)) << 5);\
		v = (v & (DMA_TCR7_RES_WR_MASK_13)) | (((0) & (DMA_TCR7_MASK_13)) << 13);\
		v = (v & (DMA_TCR7_RES_WR_MASK_22)) | (((0) & (DMA_TCR7_MASK_22)) << 22);\
		v = ((v & DMA_TCR7_TSE_WR_MASK) | ((data & DMA_TCR7_TSE_MASK) << 12));\
		DMA_TCR7_RGWR(v);\
} while (0)

#define DMA_TCR7_TSE_UDFRD(data) do {\
		DMA_TCR7_RGRD(data);\
		data = ((data >> 12) & DMA_TCR7_TSE_MASK);\
} while (0)

/*#define DMA_TCR7_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_TCR7_PBL_MASK (ULONG)(0x3f)

/*#define DMA_TCR7_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_TCR7_PBL_WR_MASK (ULONG)(0xffc0ffff)

#define DMA_TCR7_PBL_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR7_RGRD(v);\
		v = (v & (DMA_TCR7_RES_WR_MASK_5)) | (((0) & (DMA_TCR7_MASK_5)) << 5);\
		v = (v & (DMA_TCR7_RES_WR_MASK_13)) | (((0) & (DMA_TCR7_MASK_13)) << 13);\
		v = (v & (DMA_TCR7_RES_WR_MASK_22)) | (((0) & (DMA_TCR7_MASK_22)) << 22);\
		v = ((v & DMA_TCR7_PBL_WR_MASK) | ((data & DMA_TCR7_PBL_MASK) << 16));\
		DMA_TCR7_RGWR(v);\
} while (0)

#define DMA_TCR7_PBL_UDFRD(data) do {\
		DMA_TCR7_RGRD(data);\
		data = ((data >> 16) & DMA_TCR7_PBL_MASK);\
} while (0)

#define DMA_TCR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1404))

#define DMA_TCR6_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TCR6_RGOFFADDR);\
} while (0)

#define DMA_TCR6_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TCR6_RGOFFADDR);\
} while (0)

/*#define  DMA_TCR6_Mask_5 (ULONG)(~(~0<<(7)))*/

#define  DMA_TCR6_MASK_5 (ULONG)(0x7f)

/*#define DMA_TCR6_RES_Wr_Mask_5 (ULONG)(~((~(~0<<(7)))<<(5)))*/

#define DMA_TCR6_RES_WR_MASK_5 (ULONG)(0xfffff01f)

/*#define  DMA_TCR6_Mask_13 (ULONG)(~(~0<<(3)))*/

#define  DMA_TCR6_MASK_13 (ULONG)(0x7)

/*#define DMA_TCR6_RES_Wr_Mask_13 (ULONG)(~((~(~0<<(3)))<<(13)))*/

#define DMA_TCR6_RES_WR_MASK_13 (ULONG)(0xffff1fff)

/*#define  DMA_TCR6_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  DMA_TCR6_MASK_22 (ULONG)(0x3ff)

/*#define DMA_TCR6_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define DMA_TCR6_RES_WR_MASK_22 (ULONG)(0x3fffff)

/*#define DMA_TCR6_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR6_ST_MASK (ULONG)(0x1)

/*#define DMA_TCR6_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_TCR6_ST_WR_MASK (ULONG)(0xfffffffe)

#define DMA_TCR6_ST_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR6_RGRD(v);\
		v = (v & (DMA_TCR6_RES_WR_MASK_5)) | (((0) & (DMA_TCR6_MASK_5)) << 5);\
		v = (v & (DMA_TCR6_RES_WR_MASK_13)) | (((0) & (DMA_TCR6_MASK_13)) << 13);\
		v = (v & (DMA_TCR6_RES_WR_MASK_22)) | (((0) & (DMA_TCR6_MASK_22)) << 22);\
		v = ((v & DMA_TCR6_ST_WR_MASK) | ((data & DMA_TCR6_ST_MASK) << 0));\
		DMA_TCR6_RGWR(v);\
} while (0)

#define DMA_TCR6_ST_UDFRD(data) do {\
		DMA_TCR6_RGRD(data);\
		data = ((data >> 0) & DMA_TCR6_ST_MASK);\
} while (0)

/*#define DMA_TCR6_TCW_Mask (ULONG)(~(~0<<(3)))*/

#define DMA_TCR6_TCW_MASK (ULONG)(0x7)

/*#define DMA_TCR6_TCW_Wr_Mask (ULONG)(~((~(~0 << (3))) << (1)))*/

#define DMA_TCR6_TCW_WR_MASK (ULONG)(0xfffffff1)

#define DMA_TCR6_TCW_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR6_RGRD(v);\
		v = (v & (DMA_TCR6_RES_WR_MASK_5)) | (((0) & (DMA_TCR6_MASK_5)) << 5);\
		v = (v & (DMA_TCR6_RES_WR_MASK_13)) | (((0) & (DMA_TCR6_MASK_13)) << 13);\
		v = (v & (DMA_TCR6_RES_WR_MASK_22)) | (((0) & (DMA_TCR6_MASK_22)) << 22);\
		v = ((v & DMA_TCR6_TCW_WR_MASK) | ((data & DMA_TCR6_TCW_MASK) << 1));\
		DMA_TCR6_RGWR(v);\
} while (0)

#define DMA_TCR6_TCW_UDFRD(data) do {\
		DMA_TCR6_RGRD(data);\
		data = ((data >> 1) & DMA_TCR6_TCW_MASK);\
} while (0)

/*#define DMA_TCR6_OSP_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR6_OSP_MASK (ULONG)(0x1)

/*#define DMA_TCR6_OSP_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define DMA_TCR6_OSP_WR_MASK (ULONG)(0xffffffef)

#define DMA_TCR6_OSP_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR6_RGRD(v);\
		v = (v & (DMA_TCR6_RES_WR_MASK_5)) | (((0) & (DMA_TCR6_MASK_5)) << 5);\
		v = (v & (DMA_TCR6_RES_WR_MASK_13)) | (((0) & (DMA_TCR6_MASK_13)) << 13);\
		v = (v & (DMA_TCR6_RES_WR_MASK_22)) | (((0) & (DMA_TCR6_MASK_22)) << 22);\
		v = ((v & DMA_TCR6_OSP_WR_MASK) | ((data & DMA_TCR6_OSP_MASK) << 4));\
		DMA_TCR6_RGWR(v);\
} while (0)

#define DMA_TCR6_OSP_UDFRD(data) do {\
		DMA_TCR6_RGRD(data);\
		data = ((data >> 4) & DMA_TCR6_OSP_MASK);\
} while (0)

/*#define DMA_TCR6_TSE_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR6_TSE_MASK (ULONG)(0x1)

/*#define DMA_TCR6_TSE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define DMA_TCR6_TSE_WR_MASK (ULONG)(0xffffefff)

#define DMA_TCR6_TSE_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR6_RGRD(v);\
		v = (v & (DMA_TCR6_RES_WR_MASK_5)) | (((0) & (DMA_TCR6_MASK_5)) << 5);\
		v = (v & (DMA_TCR6_RES_WR_MASK_13)) | (((0) & (DMA_TCR6_MASK_13)) << 13);\
		v = (v & (DMA_TCR6_RES_WR_MASK_22)) | (((0) & (DMA_TCR6_MASK_22)) << 22);\
		v = ((v & DMA_TCR6_TSE_WR_MASK) | ((data & DMA_TCR6_TSE_MASK) << 12));\
		DMA_TCR6_RGWR(v);\
} while (0)

#define DMA_TCR6_TSE_UDFRD(data) do {\
		DMA_TCR6_RGRD(data);\
		data = ((data >> 12) & DMA_TCR6_TSE_MASK);\
} while (0)

/*#define DMA_TCR6_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_TCR6_PBL_MASK (ULONG)(0x3f)

/*#define DMA_TCR6_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_TCR6_PBL_WR_MASK (ULONG)(0xffc0ffff)

#define DMA_TCR6_PBL_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR6_RGRD(v);\
		v = (v & (DMA_TCR6_RES_WR_MASK_5)) | (((0) & (DMA_TCR6_MASK_5)) << 5);\
		v = (v & (DMA_TCR6_RES_WR_MASK_13)) | (((0) & (DMA_TCR6_MASK_13)) << 13);\
		v = (v & (DMA_TCR6_RES_WR_MASK_22)) | (((0) & (DMA_TCR6_MASK_22)) << 22);\
		v = ((v & DMA_TCR6_PBL_WR_MASK) | ((data & DMA_TCR6_PBL_MASK) << 16));\
		DMA_TCR6_RGWR(v);\
} while (0)

#define DMA_TCR6_PBL_UDFRD(data) do {\
		DMA_TCR6_RGRD(data);\
		data = ((data >> 16) & DMA_TCR6_PBL_MASK);\
} while (0)

#define DMA_TCR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1384))

#define DMA_TCR5_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TCR5_RGOFFADDR);\
} while (0)

#define DMA_TCR5_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TCR5_RGOFFADDR);\
} while (0)

/*#define  DMA_TCR5_Mask_5 (ULONG)(~(~0<<(7)))*/

#define  DMA_TCR5_MASK_5 (ULONG)(0x7f)

/*#define DMA_TCR5_RES_Wr_Mask_5 (ULONG)(~((~(~0<<(7)))<<(5)))*/

#define DMA_TCR5_RES_WR_MASK_5 (ULONG)(0xfffff01f)

/*#define  DMA_TCR5_Mask_13 (ULONG)(~(~0<<(3)))*/

#define  DMA_TCR5_MASK_13 (ULONG)(0x7)

/*#define DMA_TCR5_RES_Wr_Mask_13 (ULONG)(~((~(~0<<(3)))<<(13)))*/

#define DMA_TCR5_RES_WR_MASK_13 (ULONG)(0xffff1fff)

/*#define  DMA_TCR5_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  DMA_TCR5_MASK_22 (ULONG)(0x3ff)

/*#define DMA_TCR5_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define DMA_TCR5_RES_WR_MASK_22 (ULONG)(0x3fffff)

/*#define DMA_TCR5_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR5_ST_MASK (ULONG)(0x1)

/*#define DMA_TCR5_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_TCR5_ST_WR_MASK (ULONG)(0xfffffffe)

#define DMA_TCR5_ST_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR5_RGRD(v);\
		v = (v & (DMA_TCR5_RES_WR_MASK_5)) | (((0) & (DMA_TCR5_MASK_5)) << 5);\
		v = (v & (DMA_TCR5_RES_WR_MASK_13)) | (((0) & (DMA_TCR5_MASK_13)) << 13);\
		v = (v & (DMA_TCR5_RES_WR_MASK_22)) | (((0) & (DMA_TCR5_MASK_22)) << 22);\
		v = ((v & DMA_TCR5_ST_WR_MASK) | ((data & DMA_TCR5_ST_MASK) << 0));\
		DMA_TCR5_RGWR(v);\
} while (0)

#define DMA_TCR5_ST_UDFRD(data) do {\
		DMA_TCR5_RGRD(data);\
		data = ((data >> 0) & DMA_TCR5_ST_MASK);\
} while (0)

/*#define DMA_TCR5_TCW_Mask (ULONG)(~(~0<<(3)))*/

#define DMA_TCR5_TCW_MASK (ULONG)(0x7)

/*#define DMA_TCR5_TCW_Wr_Mask (ULONG)(~((~(~0 << (3))) << (1)))*/

#define DMA_TCR5_TCW_WR_MASK (ULONG)(0xfffffff1)

#define DMA_TCR5_TCW_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR5_RGRD(v);\
		v = (v & (DMA_TCR5_RES_WR_MASK_5)) | (((0) & (DMA_TCR5_MASK_5)) << 5);\
		v = (v & (DMA_TCR5_RES_WR_MASK_13)) | (((0) & (DMA_TCR5_MASK_13)) << 13);\
		v = (v & (DMA_TCR5_RES_WR_MASK_22)) | (((0) & (DMA_TCR5_MASK_22)) << 22);\
		v = ((v & DMA_TCR5_TCW_WR_MASK) | ((data & DMA_TCR5_TCW_MASK) << 1));\
		DMA_TCR5_RGWR(v);\
} while (0)

#define DMA_TCR5_TCW_UDFRD(data) do {\
		DMA_TCR5_RGRD(data);\
		data = ((data >> 1) & DMA_TCR5_TCW_MASK);\
} while (0)

/*#define DMA_TCR5_OSP_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR5_OSP_MASK (ULONG)(0x1)

/*#define DMA_TCR5_OSP_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define DMA_TCR5_OSP_WR_MASK (ULONG)(0xffffffef)

#define DMA_TCR5_OSP_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR5_RGRD(v);\
		v = (v & (DMA_TCR5_RES_WR_MASK_5)) | (((0) & (DMA_TCR5_MASK_5)) << 5);\
		v = (v & (DMA_TCR5_RES_WR_MASK_13)) | (((0) & (DMA_TCR5_MASK_13)) << 13);\
		v = (v & (DMA_TCR5_RES_WR_MASK_22)) | (((0) & (DMA_TCR5_MASK_22)) << 22);\
		v = ((v & DMA_TCR5_OSP_WR_MASK) | ((data & DMA_TCR5_OSP_MASK) << 4));\
		DMA_TCR5_RGWR(v);\
} while (0)

#define DMA_TCR5_OSP_UDFRD(data) do {\
		DMA_TCR5_RGRD(data);\
		data = ((data >> 4) & DMA_TCR5_OSP_MASK);\
} while (0)

/*#define DMA_TCR5_TSE_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR5_TSE_MASK (ULONG)(0x1)

/*#define DMA_TCR5_TSE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define DMA_TCR5_TSE_WR_MASK (ULONG)(0xffffefff)

#define DMA_TCR5_TSE_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR5_RGRD(v);\
		v = (v & (DMA_TCR5_RES_WR_MASK_5)) | (((0) & (DMA_TCR5_MASK_5)) << 5);\
		v = (v & (DMA_TCR5_RES_WR_MASK_13)) | (((0) & (DMA_TCR5_MASK_13)) << 13);\
		v = (v & (DMA_TCR5_RES_WR_MASK_22)) | (((0) & (DMA_TCR5_MASK_22)) << 22);\
		v = ((v & DMA_TCR5_TSE_WR_MASK) | ((data & DMA_TCR5_TSE_MASK) << 12));\
		DMA_TCR5_RGWR(v);\
} while (0)

#define DMA_TCR5_TSE_UDFRD(data) do {\
		DMA_TCR5_RGRD(data);\
		data = ((data >> 12) & DMA_TCR5_TSE_MASK);\
} while (0)

/*#define DMA_TCR5_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_TCR5_PBL_MASK (ULONG)(0x3f)

/*#define DMA_TCR5_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_TCR5_PBL_WR_MASK (ULONG)(0xffc0ffff)

#define DMA_TCR5_PBL_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR5_RGRD(v);\
		v = (v & (DMA_TCR5_RES_WR_MASK_5)) | (((0) & (DMA_TCR5_MASK_5)) << 5);\
		v = (v & (DMA_TCR5_RES_WR_MASK_13)) | (((0) & (DMA_TCR5_MASK_13)) << 13);\
		v = (v & (DMA_TCR5_RES_WR_MASK_22)) | (((0) & (DMA_TCR5_MASK_22)) << 22);\
		v = ((v & DMA_TCR5_PBL_WR_MASK) | ((data & DMA_TCR5_PBL_MASK) << 16));\
		DMA_TCR5_RGWR(v);\
} while (0)

#define DMA_TCR5_PBL_UDFRD(data) do {\
		DMA_TCR5_RGRD(data);\
		data = ((data >> 16) & DMA_TCR5_PBL_MASK);\
} while (0)

#define DMA_TCR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1304))

#define DMA_TCR4_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TCR4_RGOFFADDR);\
} while (0)

#define DMA_TCR4_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TCR4_RGOFFADDR);\
} while (0)

/*#define  DMA_TCR4_Mask_5 (ULONG)(~(~0<<(7)))*/

#define  DMA_TCR4_MASK_5 (ULONG)(0x7f)

/*#define DMA_TCR4_RES_Wr_Mask_5 (ULONG)(~((~(~0<<(7)))<<(5)))*/

#define DMA_TCR4_RES_WR_MASK_5 (ULONG)(0xfffff01f)

/*#define  DMA_TCR4_Mask_13 (ULONG)(~(~0<<(3)))*/

#define  DMA_TCR4_MASK_13 (ULONG)(0x7)

/*#define DMA_TCR4_RES_Wr_Mask_13 (ULONG)(~((~(~0<<(3)))<<(13)))*/

#define DMA_TCR4_RES_WR_MASK_13 (ULONG)(0xffff1fff)

/*#define  DMA_TCR4_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  DMA_TCR4_MASK_22 (ULONG)(0x3ff)

/*#define DMA_TCR4_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define DMA_TCR4_RES_WR_MASK_22 (ULONG)(0x3fffff)

/*#define DMA_TCR4_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR4_ST_MASK (ULONG)(0x1)

/*#define DMA_TCR4_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_TCR4_ST_WR_MASK (ULONG)(0xfffffffe)

#define DMA_TCR4_ST_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR4_RGRD(v);\
		v = (v & (DMA_TCR4_RES_WR_MASK_5)) | (((0) & (DMA_TCR4_MASK_5)) << 5);\
		v = (v & (DMA_TCR4_RES_WR_MASK_13)) | (((0) & (DMA_TCR4_MASK_13)) << 13);\
		v = (v & (DMA_TCR4_RES_WR_MASK_22)) | (((0) & (DMA_TCR4_MASK_22)) << 22);\
		v = ((v & DMA_TCR4_ST_WR_MASK) | ((data & DMA_TCR4_ST_MASK) << 0));\
		DMA_TCR4_RGWR(v);\
} while (0)

#define DMA_TCR4_ST_UDFRD(data) do {\
		DMA_TCR4_RGRD(data);\
		data = ((data >> 0) & DMA_TCR4_ST_MASK);\
} while (0)

/*#define DMA_TCR4_TCW_Mask (ULONG)(~(~0<<(3)))*/

#define DMA_TCR4_TCW_MASK (ULONG)(0x7)

/*#define DMA_TCR4_TCW_Wr_Mask (ULONG)(~((~(~0 << (3))) << (1)))*/

#define DMA_TCR4_TCW_WR_MASK (ULONG)(0xfffffff1)

#define DMA_TCR4_TCW_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR4_RGRD(v);\
		v = (v & (DMA_TCR4_RES_WR_MASK_5)) | (((0) & (DMA_TCR4_MASK_5)) << 5);\
		v = (v & (DMA_TCR4_RES_WR_MASK_13)) | (((0) & (DMA_TCR4_MASK_13)) << 13);\
		v = (v & (DMA_TCR4_RES_WR_MASK_22)) | (((0) & (DMA_TCR4_MASK_22)) << 22);\
		v = ((v & DMA_TCR4_TCW_WR_MASK) | ((data & DMA_TCR4_TCW_MASK) << 1));\
		DMA_TCR4_RGWR(v);\
} while (0)

#define DMA_TCR4_TCW_UDFRD(data) do {\
		DMA_TCR4_RGRD(data);\
		data = ((data >> 1) & DMA_TCR4_TCW_MASK);\
} while (0)

/*#define DMA_TCR4_OSP_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR4_OSP_MASK (ULONG)(0x1)

/*#define DMA_TCR4_OSP_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define DMA_TCR4_OSP_WR_MASK (ULONG)(0xffffffef)

#define DMA_TCR4_OSP_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR4_RGRD(v);\
		v = (v & (DMA_TCR4_RES_WR_MASK_5)) | (((0) & (DMA_TCR4_MASK_5)) << 5);\
		v = (v & (DMA_TCR4_RES_WR_MASK_13)) | (((0) & (DMA_TCR4_MASK_13)) << 13);\
		v = (v & (DMA_TCR4_RES_WR_MASK_22)) | (((0) & (DMA_TCR4_MASK_22)) << 22);\
		v = ((v & DMA_TCR4_OSP_WR_MASK) | ((data & DMA_TCR4_OSP_MASK) << 4));\
		DMA_TCR4_RGWR(v);\
} while (0)

#define DMA_TCR4_OSP_UDFRD(data) do {\
		DMA_TCR4_RGRD(data);\
		data = ((data >> 4) & DMA_TCR4_OSP_MASK);\
} while (0)

/*#define DMA_TCR4_TSE_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR4_TSE_MASK (ULONG)(0x1)

/*#define DMA_TCR4_TSE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define DMA_TCR4_TSE_WR_MASK (ULONG)(0xffffefff)

#define DMA_TCR4_TSE_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR4_RGRD(v);\
		v = (v & (DMA_TCR4_RES_WR_MASK_5)) | (((0) & (DMA_TCR4_MASK_5)) << 5);\
		v = (v & (DMA_TCR4_RES_WR_MASK_13)) | (((0) & (DMA_TCR4_MASK_13)) << 13);\
		v = (v & (DMA_TCR4_RES_WR_MASK_22)) | (((0) & (DMA_TCR4_MASK_22)) << 22);\
		v = ((v & DMA_TCR4_TSE_WR_MASK) | ((data & DMA_TCR4_TSE_MASK) << 12));\
		DMA_TCR4_RGWR(v);\
} while (0)

#define DMA_TCR4_TSE_UDFRD(data) do {\
		DMA_TCR4_RGRD(data);\
		data = ((data >> 12) & DMA_TCR4_TSE_MASK);\
} while (0)

/*#define DMA_TCR4_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_TCR4_PBL_MASK (ULONG)(0x3f)

/*#define DMA_TCR4_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_TCR4_PBL_WR_MASK (ULONG)(0xffc0ffff)

#define DMA_TCR4_PBL_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR4_RGRD(v);\
		v = (v & (DMA_TCR4_RES_WR_MASK_5)) | (((0) & (DMA_TCR4_MASK_5)) << 5);\
		v = (v & (DMA_TCR4_RES_WR_MASK_13)) | (((0) & (DMA_TCR4_MASK_13)) << 13);\
		v = (v & (DMA_TCR4_RES_WR_MASK_22)) | (((0) & (DMA_TCR4_MASK_22)) << 22);\
		v = ((v & DMA_TCR4_PBL_WR_MASK) | ((data & DMA_TCR4_PBL_MASK) << 16));\
		DMA_TCR4_RGWR(v);\
} while (0)

#define DMA_TCR4_PBL_UDFRD(data) do {\
		DMA_TCR4_RGRD(data);\
		data = ((data >> 16) & DMA_TCR4_PBL_MASK);\
} while (0)

#define DMA_TCR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1284))

#define DMA_TCR3_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TCR3_RGOFFADDR);\
} while (0)

#define DMA_TCR3_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TCR3_RGOFFADDR);\
} while (0)

/*#define  DMA_TCR3_Mask_5 (ULONG)(~(~0<<(7)))*/

#define  DMA_TCR3_MASK_5 (ULONG)(0x7f)

/*#define DMA_TCR3_RES_Wr_Mask_5 (ULONG)(~((~(~0<<(7)))<<(5)))*/

#define DMA_TCR3_RES_WR_MASK_5 (ULONG)(0xfffff01f)

/*#define  DMA_TCR3_Mask_13 (ULONG)(~(~0<<(3)))*/

#define  DMA_TCR3_MASK_13 (ULONG)(0x7)

/*#define DMA_TCR3_RES_Wr_Mask_13 (ULONG)(~((~(~0<<(3)))<<(13)))*/

#define DMA_TCR3_RES_WR_MASK_13 (ULONG)(0xffff1fff)

/*#define  DMA_TCR3_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  DMA_TCR3_MASK_22 (ULONG)(0x3ff)

/*#define DMA_TCR3_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define DMA_TCR3_RES_WR_MASK_22 (ULONG)(0x3fffff)

/*#define DMA_TCR3_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR3_ST_MASK (ULONG)(0x1)

/*#define DMA_TCR3_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_TCR3_ST_WR_MASK (ULONG)(0xfffffffe)

#define DMA_TCR3_ST_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR3_RGRD(v);\
		v = (v & (DMA_TCR3_RES_WR_MASK_5)) | (((0) & (DMA_TCR3_MASK_5)) << 5);\
		v = (v & (DMA_TCR3_RES_WR_MASK_13)) | (((0) & (DMA_TCR3_MASK_13)) << 13);\
		v = (v & (DMA_TCR3_RES_WR_MASK_22)) | (((0) & (DMA_TCR3_MASK_22)) << 22);\
		v = ((v & DMA_TCR3_ST_WR_MASK) | ((data & DMA_TCR3_ST_MASK) << 0));\
		DMA_TCR3_RGWR(v);\
} while (0)

#define DMA_TCR3_ST_UDFRD(data) do {\
		DMA_TCR3_RGRD(data);\
		data = ((data >> 0) & DMA_TCR3_ST_MASK);\
} while (0)

/*#define DMA_TCR3_TCW_Mask (ULONG)(~(~0<<(3)))*/

#define DMA_TCR3_TCW_MASK (ULONG)(0x7)

/*#define DMA_TCR3_TCW_Wr_Mask (ULONG)(~((~(~0 << (3))) << (1)))*/

#define DMA_TCR3_TCW_WR_MASK (ULONG)(0xfffffff1)

#define DMA_TCR3_TCW_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR3_RGRD(v);\
		v = (v & (DMA_TCR3_RES_WR_MASK_5)) | (((0) & (DMA_TCR3_MASK_5)) << 5);\
		v = (v & (DMA_TCR3_RES_WR_MASK_13)) | (((0) & (DMA_TCR3_MASK_13)) << 13);\
		v = (v & (DMA_TCR3_RES_WR_MASK_22)) | (((0) & (DMA_TCR3_MASK_22)) << 22);\
		v = ((v & DMA_TCR3_TCW_WR_MASK) | ((data & DMA_TCR3_TCW_MASK) << 1));\
		DMA_TCR3_RGWR(v);\
} while (0)

#define DMA_TCR3_TCW_UDFRD(data) do {\
		DMA_TCR3_RGRD(data);\
		data = ((data >> 1) & DMA_TCR3_TCW_MASK);\
} while (0)

/*#define DMA_TCR3_OSP_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR3_OSP_MASK (ULONG)(0x1)

/*#define DMA_TCR3_OSP_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define DMA_TCR3_OSP_WR_MASK (ULONG)(0xffffffef)

#define DMA_TCR3_OSP_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR3_RGRD(v);\
		v = (v & (DMA_TCR3_RES_WR_MASK_5)) | (((0) & (DMA_TCR3_MASK_5)) << 5);\
		v = (v & (DMA_TCR3_RES_WR_MASK_13)) | (((0) & (DMA_TCR3_MASK_13)) << 13);\
		v = (v & (DMA_TCR3_RES_WR_MASK_22)) | (((0) & (DMA_TCR3_MASK_22)) << 22);\
		v = ((v & DMA_TCR3_OSP_WR_MASK) | ((data & DMA_TCR3_OSP_MASK) << 4));\
		DMA_TCR3_RGWR(v);\
} while (0)

#define DMA_TCR3_OSP_UDFRD(data) do {\
		DMA_TCR3_RGRD(data);\
		data = ((data >> 4) & DMA_TCR3_OSP_MASK);\
} while (0)

/*#define DMA_TCR3_TSE_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR3_TSE_MASK (ULONG)(0x1)

/*#define DMA_TCR3_TSE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define DMA_TCR3_TSE_WR_MASK (ULONG)(0xffffefff)

#define DMA_TCR3_TSE_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR3_RGRD(v);\
		v = (v & (DMA_TCR3_RES_WR_MASK_5)) | (((0) & (DMA_TCR3_MASK_5)) << 5);\
		v = (v & (DMA_TCR3_RES_WR_MASK_13)) | (((0) & (DMA_TCR3_MASK_13)) << 13);\
		v = (v & (DMA_TCR3_RES_WR_MASK_22)) | (((0) & (DMA_TCR3_MASK_22)) << 22);\
		v = ((v & DMA_TCR3_TSE_WR_MASK) | ((data & DMA_TCR3_TSE_MASK) << 12));\
		DMA_TCR3_RGWR(v);\
} while (0)

#define DMA_TCR3_TSE_UDFRD(data) do {\
		DMA_TCR3_RGRD(data);\
		data = ((data >> 12) & DMA_TCR3_TSE_MASK);\
} while (0)

/*#define DMA_TCR3_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_TCR3_PBL_MASK (ULONG)(0x3f)

/*#define DMA_TCR3_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_TCR3_PBL_WR_MASK (ULONG)(0xffc0ffff)

#define DMA_TCR3_PBL_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR3_RGRD(v);\
		v = (v & (DMA_TCR3_RES_WR_MASK_5)) | (((0) & (DMA_TCR3_MASK_5)) << 5);\
		v = (v & (DMA_TCR3_RES_WR_MASK_13)) | (((0) & (DMA_TCR3_MASK_13)) << 13);\
		v = (v & (DMA_TCR3_RES_WR_MASK_22)) | (((0) & (DMA_TCR3_MASK_22)) << 22);\
		v = ((v & DMA_TCR3_PBL_WR_MASK) | ((data & DMA_TCR3_PBL_MASK) << 16));\
		DMA_TCR3_RGWR(v);\
} while (0)

#define DMA_TCR3_PBL_UDFRD(data) do {\
		DMA_TCR3_RGRD(data);\
		data = ((data >> 16) & DMA_TCR3_PBL_MASK);\
} while (0)

#define DMA_TCR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1204))

#define DMA_TCR2_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TCR2_RGOFFADDR);\
} while (0)

#define DMA_TCR2_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TCR2_RGOFFADDR);\
} while (0)

/*#define  DMA_TCR2_Mask_5 (ULONG)(~(~0<<(7)))*/

#define  DMA_TCR2_MASK_5 (ULONG)(0x7f)

/*#define DMA_TCR2_RES_Wr_Mask_5 (ULONG)(~((~(~0<<(7)))<<(5)))*/

#define DMA_TCR2_RES_WR_MASK_5 (ULONG)(0xfffff01f)

/*#define  DMA_TCR2_Mask_13 (ULONG)(~(~0<<(3)))*/

#define  DMA_TCR2_MASK_13 (ULONG)(0x7)

/*#define DMA_TCR2_RES_Wr_Mask_13 (ULONG)(~((~(~0<<(3)))<<(13)))*/

#define DMA_TCR2_RES_WR_MASK_13 (ULONG)(0xffff1fff)

/*#define  DMA_TCR2_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  DMA_TCR2_MASK_22 (ULONG)(0x3ff)

/*#define DMA_TCR2_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define DMA_TCR2_RES_WR_MASK_22 (ULONG)(0x3fffff)

/*#define DMA_TCR2_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR2_ST_MASK (ULONG)(0x1)

/*#define DMA_TCR2_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_TCR2_ST_WR_MASK (ULONG)(0xfffffffe)

#define DMA_TCR2_ST_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR2_RGRD(v);\
		v = (v & (DMA_TCR2_RES_WR_MASK_5)) | (((0) & (DMA_TCR2_MASK_5)) << 5);\
		v = (v & (DMA_TCR2_RES_WR_MASK_13)) | (((0) & (DMA_TCR2_MASK_13)) << 13);\
		v = (v & (DMA_TCR2_RES_WR_MASK_22)) | (((0) & (DMA_TCR2_MASK_22)) << 22);\
		v = ((v & DMA_TCR2_ST_WR_MASK) | ((data & DMA_TCR2_ST_MASK) << 0));\
		DMA_TCR2_RGWR(v);\
} while (0)

#define DMA_TCR2_ST_UDFRD(data) do {\
		DMA_TCR2_RGRD(data);\
		data = ((data >> 0) & DMA_TCR2_ST_MASK);\
} while (0)

/*#define DMA_TCR2_TCW_Mask (ULONG)(~(~0<<(3)))*/

#define DMA_TCR2_TCW_MASK (ULONG)(0x7)

/*#define DMA_TCR2_TCW_Wr_Mask (ULONG)(~((~(~0 << (3))) << (1)))*/

#define DMA_TCR2_TCW_WR_MASK (ULONG)(0xfffffff1)

#define DMA_TCR2_TCW_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR2_RGRD(v);\
		v = (v & (DMA_TCR2_RES_WR_MASK_5)) | (((0) & (DMA_TCR2_MASK_5)) << 5);\
		v = (v & (DMA_TCR2_RES_WR_MASK_13)) | (((0) & (DMA_TCR2_MASK_13)) << 13);\
		v = (v & (DMA_TCR2_RES_WR_MASK_22)) | (((0) & (DMA_TCR2_MASK_22)) << 22);\
		v = ((v & DMA_TCR2_TCW_WR_MASK) | ((data & DMA_TCR2_TCW_MASK) << 1));\
		DMA_TCR2_RGWR(v);\
} while (0)

#define DMA_TCR2_TCW_UDFRD(data) do {\
		DMA_TCR2_RGRD(data);\
		data = ((data >> 1) & DMA_TCR2_TCW_MASK);\
} while (0)

/*#define DMA_TCR2_OSP_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR2_OSP_MASK (ULONG)(0x1)

/*#define DMA_TCR2_OSP_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define DMA_TCR2_OSP_WR_MASK (ULONG)(0xffffffef)

#define DMA_TCR2_OSP_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR2_RGRD(v);\
		v = (v & (DMA_TCR2_RES_WR_MASK_5)) | (((0) & (DMA_TCR2_MASK_5)) << 5);\
		v = (v & (DMA_TCR2_RES_WR_MASK_13)) | (((0) & (DMA_TCR2_MASK_13)) << 13);\
		v = (v & (DMA_TCR2_RES_WR_MASK_22)) | (((0) & (DMA_TCR2_MASK_22)) << 22);\
		v = ((v & DMA_TCR2_OSP_WR_MASK) | ((data & DMA_TCR2_OSP_MASK) << 4));\
		DMA_TCR2_RGWR(v);\
} while (0)

#define DMA_TCR2_OSP_UDFRD(data) do {\
		DMA_TCR2_RGRD(data);\
		data = ((data >> 4) & DMA_TCR2_OSP_MASK);\
} while (0)

/*#define DMA_TCR2_TSE_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR2_TSE_MASK (ULONG)(0x1)

/*#define DMA_TCR2_TSE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define DMA_TCR2_TSE_WR_MASK (ULONG)(0xffffefff)

#define DMA_TCR2_TSE_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR2_RGRD(v);\
		v = (v & (DMA_TCR2_RES_WR_MASK_5)) | (((0) & (DMA_TCR2_MASK_5)) << 5);\
		v = (v & (DMA_TCR2_RES_WR_MASK_13)) | (((0) & (DMA_TCR2_MASK_13)) << 13);\
		v = (v & (DMA_TCR2_RES_WR_MASK_22)) | (((0) & (DMA_TCR2_MASK_22)) << 22);\
		v = ((v & DMA_TCR2_TSE_WR_MASK) | ((data & DMA_TCR2_TSE_MASK) << 12));\
		DMA_TCR2_RGWR(v);\
} while (0)

#define DMA_TCR2_TSE_UDFRD(data) do {\
		DMA_TCR2_RGRD(data);\
		data = ((data >> 12) & DMA_TCR2_TSE_MASK);\
} while (0)

/*#define DMA_TCR2_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_TCR2_PBL_MASK (ULONG)(0x3f)

/*#define DMA_TCR2_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_TCR2_PBL_WR_MASK (ULONG)(0xffc0ffff)

#define DMA_TCR2_PBL_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR2_RGRD(v);\
		v = (v & (DMA_TCR2_RES_WR_MASK_5)) | (((0) & (DMA_TCR2_MASK_5)) << 5);\
		v = (v & (DMA_TCR2_RES_WR_MASK_13)) | (((0) & (DMA_TCR2_MASK_13)) << 13);\
		v = (v & (DMA_TCR2_RES_WR_MASK_22)) | (((0) & (DMA_TCR2_MASK_22)) << 22);\
		v = ((v & DMA_TCR2_PBL_WR_MASK) | ((data & DMA_TCR2_PBL_MASK) << 16));\
		DMA_TCR2_RGWR(v);\
} while (0)

#define DMA_TCR2_PBL_UDFRD(data) do {\
		DMA_TCR2_RGRD(data);\
		data = ((data >> 16) & DMA_TCR2_PBL_MASK);\
} while (0)

#define DMA_TCR1_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1184))

#define DMA_TCR1_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TCR1_RGOFFADDR);\
} while (0)

#define DMA_TCR1_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TCR1_RGOFFADDR);\
} while (0)

/*#define  DMA_TCR1_Mask_5 (ULONG)(~(~0<<(7)))*/

#define  DMA_TCR1_MASK_5 (ULONG)(0x7f)

/*#define DMA_TCR1_RES_Wr_Mask_5 (ULONG)(~((~(~0<<(7)))<<(5)))*/

#define DMA_TCR1_RES_WR_MASK_5 (ULONG)(0xfffff01f)

/*#define  DMA_TCR1_Mask_13 (ULONG)(~(~0<<(3)))*/

#define  DMA_TCR1_MASK_13 (ULONG)(0x7)

/*#define DMA_TCR1_RES_Wr_Mask_13 (ULONG)(~((~(~0<<(3)))<<(13)))*/

#define DMA_TCR1_RES_WR_MASK_13 (ULONG)(0xffff1fff)

/*#define  DMA_TCR1_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  DMA_TCR1_MASK_22 (ULONG)(0x3ff)

/*#define DMA_TCR1_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define DMA_TCR1_RES_WR_MASK_22 (ULONG)(0x3fffff)

/*#define DMA_TCR1_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR1_ST_MASK (ULONG)(0x1)

/*#define DMA_TCR1_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_TCR1_ST_WR_MASK (ULONG)(0xfffffffe)

#define DMA_TCR1_ST_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR1_RGRD(v);\
		v = (v & (DMA_TCR1_RES_WR_MASK_5)) | (((0) & (DMA_TCR1_MASK_5)) << 5);\
		v = (v & (DMA_TCR1_RES_WR_MASK_13)) | (((0) & (DMA_TCR1_MASK_13)) << 13);\
		v = (v & (DMA_TCR1_RES_WR_MASK_22)) | (((0) & (DMA_TCR1_MASK_22)) << 22);\
		v = ((v & DMA_TCR1_ST_WR_MASK) | ((data & DMA_TCR1_ST_MASK) << 0));\
		DMA_TCR1_RGWR(v);\
} while (0)

#define DMA_TCR1_ST_UDFRD(data) do {\
		DMA_TCR1_RGRD(data);\
		data = ((data >> 0) & DMA_TCR1_ST_MASK);\
} while (0)

/*#define DMA_TCR1_TCW_Mask (ULONG)(~(~0<<(3)))*/

#define DMA_TCR1_TCW_MASK (ULONG)(0x7)

/*#define DMA_TCR1_TCW_Wr_Mask (ULONG)(~((~(~0 << (3))) << (1)))*/

#define DMA_TCR1_TCW_WR_MASK (ULONG)(0xfffffff1)

#define DMA_TCR1_TCW_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR1_RGRD(v);\
		v = (v & (DMA_TCR1_RES_WR_MASK_5)) | (((0) & (DMA_TCR1_MASK_5)) << 5);\
		v = (v & (DMA_TCR1_RES_WR_MASK_13)) | (((0) & (DMA_TCR1_MASK_13)) << 13);\
		v = (v & (DMA_TCR1_RES_WR_MASK_22)) | (((0) & (DMA_TCR1_MASK_22)) << 22);\
		v = ((v & DMA_TCR1_TCW_WR_MASK) | ((data & DMA_TCR1_TCW_MASK) << 1));\
		DMA_TCR1_RGWR(v);\
} while (0)

#define DMA_TCR1_TCW_UDFRD(data) do {\
		DMA_TCR1_RGRD(data);\
		data = ((data >> 1) & DMA_TCR1_TCW_MASK);\
} while (0)

/*#define DMA_TCR1_OSP_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR1_OSP_MASK (ULONG)(0x1)

/*#define DMA_TCR1_OSP_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define DMA_TCR1_OSP_WR_MASK (ULONG)(0xffffffef)

#define DMA_TCR1_OSP_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR1_RGRD(v);\
		v = (v & (DMA_TCR1_RES_WR_MASK_5)) | (((0) & (DMA_TCR1_MASK_5)) << 5);\
		v = (v & (DMA_TCR1_RES_WR_MASK_13)) | (((0) & (DMA_TCR1_MASK_13)) << 13);\
		v = (v & (DMA_TCR1_RES_WR_MASK_22)) | (((0) & (DMA_TCR1_MASK_22)) << 22);\
		v = ((v & DMA_TCR1_OSP_WR_MASK) | ((data & DMA_TCR1_OSP_MASK) << 4));\
		DMA_TCR1_RGWR(v);\
} while (0)

#define DMA_TCR1_OSP_UDFRD(data) do {\
		DMA_TCR1_RGRD(data);\
		data = ((data >> 4) & DMA_TCR1_OSP_MASK);\
} while (0)

/*#define DMA_TCR1_TSE_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR1_TSE_MASK (ULONG)(0x1)

/*#define DMA_TCR1_TSE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define DMA_TCR1_TSE_WR_MASK (ULONG)(0xffffefff)

#define DMA_TCR1_TSE_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR1_RGRD(v);\
		v = (v & (DMA_TCR1_RES_WR_MASK_5)) | (((0) & (DMA_TCR1_MASK_5)) << 5);\
		v = (v & (DMA_TCR1_RES_WR_MASK_13)) | (((0) & (DMA_TCR1_MASK_13)) << 13);\
		v = (v & (DMA_TCR1_RES_WR_MASK_22)) | (((0) & (DMA_TCR1_MASK_22)) << 22);\
		v = ((v & DMA_TCR1_TSE_WR_MASK) | ((data & DMA_TCR1_TSE_MASK) << 12));\
		DMA_TCR1_RGWR(v);\
} while (0)

#define DMA_TCR1_TSE_UDFRD(data) do {\
		DMA_TCR1_RGRD(data);\
		data = ((data >> 12) & DMA_TCR1_TSE_MASK);\
} while (0)

/*#define DMA_TCR1_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_TCR1_PBL_MASK (ULONG)(0x3f)

/*#define DMA_TCR1_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_TCR1_PBL_WR_MASK (ULONG)(0xffc0ffff)

#define DMA_TCR1_PBL_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR1_RGRD(v);\
		v = (v & (DMA_TCR1_RES_WR_MASK_5)) | (((0) & (DMA_TCR1_MASK_5)) << 5);\
		v = (v & (DMA_TCR1_RES_WR_MASK_13)) | (((0) & (DMA_TCR1_MASK_13)) << 13);\
		v = (v & (DMA_TCR1_RES_WR_MASK_22)) | (((0) & (DMA_TCR1_MASK_22)) << 22);\
		v = ((v & DMA_TCR1_PBL_WR_MASK) | ((data & DMA_TCR1_PBL_MASK) << 16));\
		DMA_TCR1_RGWR(v);\
} while (0)

#define DMA_TCR1_PBL_UDFRD(data) do {\
		DMA_TCR1_RGRD(data);\
		data = ((data >> 16) & DMA_TCR1_PBL_MASK);\
} while (0)

#define DMA_TCR0_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1104))

#define DMA_TCR0_RGWR(data) do {\
		iowrite32(data, (void *)DMA_TCR0_RGOFFADDR);\
} while (0)

#define DMA_TCR0_RGRD(data) do {\
		(data) = ioread32((void *)DMA_TCR0_RGOFFADDR);\
} while (0)

/*#define  DMA_TCR0_Mask_5 (ULONG)(~(~0<<(7)))*/

#define  DMA_TCR0_MASK_5 (ULONG)(0x7f)

/*#define DMA_TCR0_RES_Wr_Mask_5 (ULONG)(~((~(~0<<(7)))<<(5)))*/

#define DMA_TCR0_RES_WR_MASK_5 (ULONG)(0xfffff01f)

/*#define  DMA_TCR0_Mask_13 (ULONG)(~(~0<<(3)))*/

#define  DMA_TCR0_MASK_13 (ULONG)(0x7)

/*#define DMA_TCR0_RES_Wr_Mask_13 (ULONG)(~((~(~0<<(3)))<<(13)))*/

#define DMA_TCR0_RES_WR_MASK_13 (ULONG)(0xffff1fff)

/*#define  DMA_TCR0_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  DMA_TCR0_MASK_22 (ULONG)(0x3ff)

/*#define DMA_TCR0_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define DMA_TCR0_RES_WR_MASK_22 (ULONG)(0x3fffff)

/*#define DMA_TCR0_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR0_ST_MASK (ULONG)(0x1)

/*#define DMA_TCR0_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_TCR0_ST_WR_MASK (ULONG)(0xfffffffe)

#define DMA_TCR0_ST_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR0_RGRD(v);\
		v = (v & (DMA_TCR0_RES_WR_MASK_5)) | (((0) & (DMA_TCR0_MASK_5)) << 5);\
		v = (v & (DMA_TCR0_RES_WR_MASK_13)) | (((0) & (DMA_TCR0_MASK_13)) << 13);\
		v = (v & (DMA_TCR0_RES_WR_MASK_22)) | (((0) & (DMA_TCR0_MASK_22)) << 22);\
		v = ((v & DMA_TCR0_ST_WR_MASK) | ((data & DMA_TCR0_ST_MASK) << 0));\
		DMA_TCR0_RGWR(v);\
} while (0)

#define DMA_TCR0_ST_UDFRD(data) do {\
		DMA_TCR0_RGRD(data);\
		data = ((data >> 0) & DMA_TCR0_ST_MASK);\
} while (0)

/*#define DMA_TCR0_TCW_Mask (ULONG)(~(~0<<(3)))*/

#define DMA_TCR0_TCW_MASK (ULONG)(0x7)

/*#define DMA_TCR0_TCW_Wr_Mask (ULONG)(~((~(~0 << (3))) << (1)))*/

#define DMA_TCR0_TCW_WR_MASK (ULONG)(0xfffffff1)

#define DMA_TCR0_TCW_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR0_RGRD(v);\
		v = (v & (DMA_TCR0_RES_WR_MASK_5)) | (((0) & (DMA_TCR0_MASK_5)) << 5);\
		v = (v & (DMA_TCR0_RES_WR_MASK_13)) | (((0) & (DMA_TCR0_MASK_13)) << 13);\
		v = (v & (DMA_TCR0_RES_WR_MASK_22)) | (((0) & (DMA_TCR0_MASK_22)) << 22);\
		v = ((v & DMA_TCR0_TCW_WR_MASK) | ((data & DMA_TCR0_TCW_MASK) << 1));\
		DMA_TCR0_RGWR(v);\
} while (0)

#define DMA_TCR0_TCW_UDFRD(data) do {\
		DMA_TCR0_RGRD(data);\
		data = ((data >> 1) & DMA_TCR0_TCW_MASK);\
} while (0)

/*#define DMA_TCR0_OSP_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR0_OSP_MASK (ULONG)(0x1)

/*#define DMA_TCR0_OSP_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define DMA_TCR0_OSP_WR_MASK (ULONG)(0xffffffef)

#define DMA_TCR0_OSP_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR0_RGRD(v);\
		v = (v & (DMA_TCR0_RES_WR_MASK_5)) | (((0) & (DMA_TCR0_MASK_5)) << 5);\
		v = (v & (DMA_TCR0_RES_WR_MASK_13)) | (((0) & (DMA_TCR0_MASK_13)) << 13);\
		v = (v & (DMA_TCR0_RES_WR_MASK_22)) | (((0) & (DMA_TCR0_MASK_22)) << 22);\
		v = ((v & DMA_TCR0_OSP_WR_MASK) | ((data & DMA_TCR0_OSP_MASK) << 4));\
		DMA_TCR0_RGWR(v);\
} while (0)

#define DMA_TCR0_OSP_UDFRD(data) do {\
		DMA_TCR0_RGRD(data);\
		data = ((data >> 4) & DMA_TCR0_OSP_MASK);\
} while (0)

/*#define DMA_TCR0_TSE_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR0_TSE_MASK (ULONG)(0x1)

/*#define DMA_TCR0_TSE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define DMA_TCR0_TSE_WR_MASK (ULONG)(0xffffefff)

#define DMA_TCR0_TSE_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR0_RGRD(v);\
		v = (v & (DMA_TCR0_RES_WR_MASK_5)) | (((0) & (DMA_TCR0_MASK_5)) << 5);\
		v = (v & (DMA_TCR0_RES_WR_MASK_13)) | (((0) & (DMA_TCR0_MASK_13)) << 13);\
		v = (v & (DMA_TCR0_RES_WR_MASK_22)) | (((0) & (DMA_TCR0_MASK_22)) << 22);\
		v = ((v & DMA_TCR0_TSE_WR_MASK) | ((data & DMA_TCR0_TSE_MASK) << 12));\
		DMA_TCR0_RGWR(v);\
} while (0)

#define DMA_TCR0_TSE_UDFRD(data) do {\
		DMA_TCR0_RGRD(data);\
		data = ((data >> 12) & DMA_TCR0_TSE_MASK);\
} while (0)

/*#define DMA_TCR0_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_TCR0_PBL_MASK (ULONG)(0x3f)

/*#define DMA_TCR0_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_TCR0_PBL_WR_MASK (ULONG)(0xffc0ffff)

#define DMA_TCR0_PBL_UDFWR(data) do {\
		ULONG v;\
		DMA_TCR0_RGRD(v);\
		v = (v & (DMA_TCR0_RES_WR_MASK_5)) | (((0) & (DMA_TCR0_MASK_5)) << 5);\
		v = (v & (DMA_TCR0_RES_WR_MASK_13)) | (((0) & (DMA_TCR0_MASK_13)) << 13);\
		v = (v & (DMA_TCR0_RES_WR_MASK_22)) | (((0) & (DMA_TCR0_MASK_22)) << 22);\
		v = ((v & DMA_TCR0_PBL_WR_MASK) | ((data & DMA_TCR0_PBL_MASK) << 16));\
		DMA_TCR0_RGWR(v);\
} while (0)

#define DMA_TCR0_PBL_UDFRD(data) do {\
		DMA_TCR0_RGRD(data);\
		data = ((data >> 16) & DMA_TCR0_PBL_MASK);\
} while (0)

#define DMA_CR7_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1480))

#define DMA_CR7_RGWR(data) do {\
		iowrite32(data, (void *)DMA_CR7_RGOFFADDR);\
} while (0)

#define DMA_CR7_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CR7_RGOFFADDR);\
} while (0)

/*#define  DMA_CR7_Mask_21 (ULONG)(~(~0<<(2)))*/

#define  DMA_CR7_MASK_21 (ULONG)(0x3)

/*#define DMA_CR7_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(2)))<<(21)))*/

#define DMA_CR7_RES_WR_MASK_21 (ULONG)(0xff9fffff)

/*#define  DMA_CR7_Mask_25 (ULONG)(~(~0<<(7)))*/

#define  DMA_CR7_MASK_25 (ULONG)(0x7f)

/*#define DMA_CR7_RES_Wr_Mask_25 (ULONG)(~((~(~0<<(7)))<<(25)))*/

#define DMA_CR7_RES_WR_MASK_25 (ULONG)(0x1ffffff)

/*#define DMA_CR7_MSS_Mask (ULONG)(~(~0<<(16)))*/

#define DMA_CR7_MSS_MASK (ULONG)(0xffff)

/*#define DMA_CR7_MSS_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define DMA_CR7_MSS_WR_MASK (ULONG)(0xffff0000)

#define DMA_CR7_MSS_UDFWR(data) do {\
		ULONG v;\
		DMA_CR7_RGRD(v);\
		v = (v & (DMA_CR7_RES_WR_MASK_21)) | (((0) & (DMA_CR7_MASK_21)) << 21);\
		v = (v & (DMA_CR7_RES_WR_MASK_25)) | (((0) & (DMA_CR7_MASK_25)) << 25);\
		v = ((v & DMA_CR7_MSS_WR_MASK) | ((data & DMA_CR7_MSS_MASK) << 0));\
		DMA_CR7_RGWR(v);\
} while (0)

#define DMA_CR7_MSS_UDFRD(data) do {\
		DMA_CR7_RGRD(data);\
		data = ((data >> 0) & DMA_CR7_MSS_MASK);\
} while (0)

/*#define DMA_CR7_PBLx8_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_CR7_PBLX8_MASK (ULONG)(0x1)

/*#define DMA_CR7_PBLx8_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define DMA_CR7_PBLX8_WR_MASK (ULONG)(0xfffeffff)

#define DMA_CR7_PBLX8_UDFWR(data) do {\
		ULONG v;\
		DMA_CR7_RGRD(v);\
		v = (v & (DMA_CR7_RES_WR_MASK_21)) | (((0) & (DMA_CR7_MASK_21)) << 21);\
		v = (v & (DMA_CR7_RES_WR_MASK_25)) | (((0) & (DMA_CR7_MASK_25)) << 25);\
		v = ((v & DMA_CR7_PBLX8_WR_MASK) | ((data & DMA_CR7_PBLX8_MASK) << 16));\
		DMA_CR7_RGWR(v);\
} while (0)

#define DMA_CR7_PBLX8_UDFRD(data) do {\
		DMA_CR7_RGRD(data);\
		data = ((data >> 16) & DMA_CR7_PBLX8_MASK);\
} while (0)

/*#define DMA_CR7_DPE_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_CR7_DPE_MASK (ULONG)(0x1)

/*#define DMA_CR7_DPE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (17)))*/

#define DMA_CR7_DPE_WR_MASK (ULONG)(0xfffdffff)

#define DMA_CR7_DPE_UDFWR(data) do {\
		ULONG v;\
		DMA_CR7_RGRD(v);\
		v = (v & (DMA_CR7_RES_WR_MASK_21)) | (((0) & (DMA_CR7_MASK_21)) << 21);\
		v = (v & (DMA_CR7_RES_WR_MASK_25)) | (((0) & (DMA_CR7_MASK_25)) << 25);\
		v = ((v & DMA_CR7_DPE_WR_MASK) | ((data & DMA_CR7_DPE_MASK) << 17));\
		DMA_CR7_RGWR(v);\
} while (0)

#define DMA_CR7_DPE_UDFRD(data) do {\
		DMA_CR7_RGRD(data);\
		data = ((data >> 17) & DMA_CR7_DPE_MASK);\
} while (0)

/*#define DMA_CR7_DSL_Mask (ULONG)(~(~0<<(3)))*/

#define DMA_CR7_DSL_MASK (ULONG)(0x7)

/*#define DMA_CR7_DSL_Wr_Mask (ULONG)(~((~(~0 << (3))) << (18)))*/

#define DMA_CR7_DSL_WR_MASK (ULONG)(0xffe3ffff)

#define DMA_CR7_DSL_UDFWR(data) do {\
		ULONG v;\
		DMA_CR7_RGRD(v);\
		v = (v & (DMA_CR7_RES_WR_MASK_21)) | (((0) & (DMA_CR7_MASK_21)) << 21);\
		v = (v & (DMA_CR7_RES_WR_MASK_25)) | (((0) & (DMA_CR7_MASK_25)) << 25);\
		v = ((v & DMA_CR7_DSL_WR_MASK) | ((data & DMA_CR7_DSL_MASK) << 18));\
		DMA_CR7_RGWR(v);\
} while (0)

#define DMA_CR7_DSL_UDFRD(data) do {\
		DMA_CR7_RGRD(data);\
		data = ((data >> 18) & DMA_CR7_DSL_MASK);\
} while (0)

/*#define DMA_CR7_CH_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_CR7_CH_MASK (ULONG)(0x1)

/*#define DMA_CR7_CH_Wr_Mask (ULONG)(~((~(~0 << (1))) << (23)))*/

#define DMA_CR7_CH_WR_MASK (ULONG)(0xff7fffff)

#define DMA_CR7_CH_UDFWR(data) do {\
		ULONG v;\
		DMA_CR7_RGRD(v);\
		v = (v & (DMA_CR7_RES_WR_MASK_21)) | (((0) & (DMA_CR7_MASK_21)) << 21);\
		v = (v & (DMA_CR7_RES_WR_MASK_25)) | (((0) & (DMA_CR7_MASK_25)) << 25);\
		v = ((v & DMA_CR7_CH_WR_MASK) | ((data & DMA_CR7_CH_MASK) << 23));\
		DMA_CR7_RGWR(v);\
} while (0)

#define DMA_CR7_CH_UDFRD(data) do {\
		DMA_CR7_RGRD(data);\
		data = ((data >> 23) & DMA_CR7_CH_MASK);\
} while (0)

/*#define DMA_CR7_SPH_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_CR7_SPH_MASK (ULONG)(0x1)

/*#define DMA_CR7_SPH_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define DMA_CR7_SPH_WR_MASK (ULONG)(0xfeffffff)

#define DMA_CR7_SPH_UDFWR(data) do {\
		ULONG v;\
		DMA_CR7_RGRD(v);\
		v = (v & (DMA_CR7_RES_WR_MASK_21)) | (((0) & (DMA_CR7_MASK_21)) << 21);\
		v = (v & (DMA_CR7_RES_WR_MASK_25)) | (((0) & (DMA_CR7_MASK_25)) << 25);\
		v = ((v & DMA_CR7_SPH_WR_MASK) | ((data & DMA_CR7_SPH_MASK) << 24));\
		DMA_CR7_RGWR(v);\
} while (0)

#define DMA_CR7_SPH_UDFRD(data) do {\
		DMA_CR7_RGRD(data);\
		data = ((data >> 24) & DMA_CR7_SPH_MASK);\
} while (0)

#define DMA_CR6_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1400))

#define DMA_CR6_RGWR(data) do {\
		iowrite32(data, (void *)DMA_CR6_RGOFFADDR);\
} while (0)

#define DMA_CR6_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CR6_RGOFFADDR);\
} while (0)

/*#define  DMA_CR6_Mask_21 (ULONG)(~(~0<<(2)))*/

#define  DMA_CR6_MASK_21 (ULONG)(0x3)

/*#define DMA_CR6_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(2)))<<(21)))*/

#define DMA_CR6_RES_WR_MASK_21 (ULONG)(0xff9fffff)

/*#define  DMA_CR6_Mask_25 (ULONG)(~(~0<<(7)))*/

#define  DMA_CR6_MASK_25 (ULONG)(0x7f)

/*#define DMA_CR6_RES_Wr_Mask_25 (ULONG)(~((~(~0<<(7)))<<(25)))*/

#define DMA_CR6_RES_WR_MASK_25 (ULONG)(0x1ffffff)

/*#define DMA_CR6_MSS_Mask (ULONG)(~(~0<<(16)))*/

#define DMA_CR6_MSS_MASK (ULONG)(0xffff)

/*#define DMA_CR6_MSS_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define DMA_CR6_MSS_WR_MASK (ULONG)(0xffff0000)

#define DMA_CR6_MSS_UDFWR(data) do {\
		ULONG v;\
		DMA_CR6_RGRD(v);\
		v = (v & (DMA_CR6_RES_WR_MASK_21)) | (((0) & (DMA_CR6_MASK_21)) << 21);\
		v = (v & (DMA_CR6_RES_WR_MASK_25)) | (((0) & (DMA_CR6_MASK_25)) << 25);\
		v = ((v & DMA_CR6_MSS_WR_MASK) | ((data & DMA_CR6_MSS_MASK) << 0));\
		DMA_CR6_RGWR(v);\
} while (0)

#define DMA_CR6_MSS_UDFRD(data) do {\
		DMA_CR6_RGRD(data);\
		data = ((data >> 0) & DMA_CR6_MSS_MASK);\
} while (0)

/*#define DMA_CR6_PBLx8_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_CR6_PBLX8_MASK (ULONG)(0x1)

/*#define DMA_CR6_PBLx8_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define DMA_CR6_PBLX8_WR_MASK (ULONG)(0xfffeffff)

#define DMA_CR6_PBLX8_UDFWR(data) do {\
		ULONG v;\
		DMA_CR6_RGRD(v);\
		v = (v & (DMA_CR6_RES_WR_MASK_21)) | (((0) & (DMA_CR6_MASK_21)) << 21);\
		v = (v & (DMA_CR6_RES_WR_MASK_25)) | (((0) & (DMA_CR6_MASK_25)) << 25);\
		v = ((v & DMA_CR6_PBLX8_WR_MASK) | ((data & DMA_CR6_PBLX8_MASK) << 16));\
		DMA_CR6_RGWR(v);\
} while (0)

#define DMA_CR6_PBLX8_UDFRD(data) do {\
		DMA_CR6_RGRD(data);\
		data = ((data >> 16) & DMA_CR6_PBLX8_MASK);\
} while (0)

/*#define DMA_CR6_DPE_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_CR6_DPE_MASK (ULONG)(0x1)

/*#define DMA_CR6_DPE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (17)))*/

#define DMA_CR6_DPE_WR_MASK (ULONG)(0xfffdffff)

#define DMA_CR6_DPE_UDFWR(data) do {\
		ULONG v;\
		DMA_CR6_RGRD(v);\
		v = (v & (DMA_CR6_RES_WR_MASK_21)) | (((0) & (DMA_CR6_MASK_21)) << 21);\
		v = (v & (DMA_CR6_RES_WR_MASK_25)) | (((0) & (DMA_CR6_MASK_25)) << 25);\
		v = ((v & DMA_CR6_DPE_WR_MASK) | ((data & DMA_CR6_DPE_MASK) << 17));\
		DMA_CR6_RGWR(v);\
} while (0)

#define DMA_CR6_DPE_UDFRD(data) do {\
		DMA_CR6_RGRD(data);\
		data = ((data >> 17) & DMA_CR6_DPE_MASK);\
} while (0)

/*#define DMA_CR6_DSL_Mask (ULONG)(~(~0<<(3)))*/

#define DMA_CR6_DSL_MASK (ULONG)(0x7)

/*#define DMA_CR6_DSL_Wr_Mask (ULONG)(~((~(~0 << (3))) << (18)))*/

#define DMA_CR6_DSL_WR_MASK (ULONG)(0xffe3ffff)

#define DMA_CR6_DSL_UDFWR(data) do {\
		ULONG v;\
		DMA_CR6_RGRD(v);\
		v = (v & (DMA_CR6_RES_WR_MASK_21)) | (((0) & (DMA_CR6_MASK_21)) << 21);\
		v = (v & (DMA_CR6_RES_WR_MASK_25)) | (((0) & (DMA_CR6_MASK_25)) << 25);\
		v = ((v & DMA_CR6_DSL_WR_MASK) | ((data & DMA_CR6_DSL_MASK) << 18));\
		DMA_CR6_RGWR(v);\
} while (0)

#define DMA_CR6_DSL_UDFRD(data) do {\
		DMA_CR6_RGRD(data);\
		data = ((data >> 18) & DMA_CR6_DSL_MASK);\
} while (0)

/*#define DMA_CR6_CH_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_CR6_CH_MASK (ULONG)(0x1)

/*#define DMA_CR6_CH_Wr_Mask (ULONG)(~((~(~0 << (1))) << (23)))*/

#define DMA_CR6_CH_WR_MASK (ULONG)(0xff7fffff)

#define DMA_CR6_CH_UDFWR(data) do {\
		ULONG v;\
		DMA_CR6_RGRD(v);\
		v = (v & (DMA_CR6_RES_WR_MASK_21)) | (((0) & (DMA_CR6_MASK_21)) << 21);\
		v = (v & (DMA_CR6_RES_WR_MASK_25)) | (((0) & (DMA_CR6_MASK_25)) << 25);\
		v = ((v & DMA_CR6_CH_WR_MASK) | ((data & DMA_CR6_CH_MASK) << 23));\
		DMA_CR6_RGWR(v);\
} while (0)

#define DMA_CR6_CH_UDFRD(data) do {\
		DMA_CR6_RGRD(data);\
		data = ((data >> 23) & DMA_CR6_CH_MASK);\
} while (0)

/*#define DMA_CR6_SPH_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_CR6_SPH_MASK (ULONG)(0x1)

/*#define DMA_CR6_SPH_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define DMA_CR6_SPH_WR_MASK (ULONG)(0xfeffffff)

#define DMA_CR6_SPH_UDFWR(data) do {\
		ULONG v;\
		DMA_CR6_RGRD(v);\
		v = (v & (DMA_CR6_RES_WR_MASK_21)) | (((0) & (DMA_CR6_MASK_21)) << 21);\
		v = (v & (DMA_CR6_RES_WR_MASK_25)) | (((0) & (DMA_CR6_MASK_25)) << 25);\
		v = ((v & DMA_CR6_SPH_WR_MASK) | ((data & DMA_CR6_SPH_MASK) << 24));\
		DMA_CR6_RGWR(v);\
} while (0)

#define DMA_CR6_SPH_UDFRD(data) do {\
		DMA_CR6_RGRD(data);\
		data = ((data >> 24) & DMA_CR6_SPH_MASK);\
} while (0)

#define DMA_CR5_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1380))

#define DMA_CR5_RGWR(data) do {\
		iowrite32(data, (void *)DMA_CR5_RGOFFADDR);\
} while (0)

#define DMA_CR5_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CR5_RGOFFADDR);\
} while (0)

/*#define  DMA_CR5_Mask_21 (ULONG)(~(~0<<(2)))*/

#define  DMA_CR5_MASK_21 (ULONG)(0x3)

/*#define DMA_CR5_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(2)))<<(21)))*/

#define DMA_CR5_RES_WR_MASK_21 (ULONG)(0xff9fffff)

/*#define  DMA_CR5_Mask_25 (ULONG)(~(~0<<(7)))*/

#define  DMA_CR5_MASK_25 (ULONG)(0x7f)

/*#define DMA_CR5_RES_Wr_Mask_25 (ULONG)(~((~(~0<<(7)))<<(25)))*/

#define DMA_CR5_RES_WR_MASK_25 (ULONG)(0x1ffffff)

/*#define DMA_CR5_MSS_Mask (ULONG)(~(~0<<(16)))*/

#define DMA_CR5_MSS_MASK (ULONG)(0xffff)

/*#define DMA_CR5_MSS_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define DMA_CR5_MSS_WR_MASK (ULONG)(0xffff0000)

#define DMA_CR5_MSS_UDFWR(data) do {\
		ULONG v;\
		DMA_CR5_RGRD(v);\
		v = (v & (DMA_CR5_RES_WR_MASK_21)) | (((0) & (DMA_CR5_MASK_21)) << 21);\
		v = (v & (DMA_CR5_RES_WR_MASK_25)) | (((0) & (DMA_CR5_MASK_25)) << 25);\
		v = ((v & DMA_CR5_MSS_WR_MASK) | ((data & DMA_CR5_MSS_MASK) << 0));\
		DMA_CR5_RGWR(v);\
} while (0)

#define DMA_CR5_MSS_UDFRD(data) do {\
		DMA_CR5_RGRD(data);\
		data = ((data >> 0) & DMA_CR5_MSS_MASK);\
} while (0)

/*#define DMA_CR5_PBLx8_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_CR5_PBLX8_MASK (ULONG)(0x1)

/*#define DMA_CR5_PBLx8_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define DMA_CR5_PBLX8_WR_MASK (ULONG)(0xfffeffff)

#define DMA_CR5_PBLX8_UDFWR(data) do {\
		ULONG v;\
		DMA_CR5_RGRD(v);\
		v = (v & (DMA_CR5_RES_WR_MASK_21)) | (((0) & (DMA_CR5_MASK_21)) << 21);\
		v = (v & (DMA_CR5_RES_WR_MASK_25)) | (((0) & (DMA_CR5_MASK_25)) << 25);\
		v = ((v & DMA_CR5_PBLX8_WR_MASK) | ((data & DMA_CR5_PBLX8_MASK) << 16));\
		DMA_CR5_RGWR(v);\
} while (0)

#define DMA_CR5_PBLX8_UDFRD(data) do {\
		DMA_CR5_RGRD(data);\
		data = ((data >> 16) & DMA_CR5_PBLX8_MASK);\
} while (0)

/*#define DMA_CR5_DPE_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_CR5_DPE_MASK (ULONG)(0x1)

/*#define DMA_CR5_DPE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (17)))*/

#define DMA_CR5_DPE_WR_MASK (ULONG)(0xfffdffff)

#define DMA_CR5_DPE_UDFWR(data) do {\
		ULONG v;\
		DMA_CR5_RGRD(v);\
		v = (v & (DMA_CR5_RES_WR_MASK_21)) | (((0) & (DMA_CR5_MASK_21)) << 21);\
		v = (v & (DMA_CR5_RES_WR_MASK_25)) | (((0) & (DMA_CR5_MASK_25)) << 25);\
		v = ((v & DMA_CR5_DPE_WR_MASK) | ((data & DMA_CR5_DPE_MASK) << 17));\
		DMA_CR5_RGWR(v);\
} while (0)

#define DMA_CR5_DPE_UDFRD(data) do {\
		DMA_CR5_RGRD(data);\
		data = ((data >> 17) & DMA_CR5_DPE_MASK);\
} while (0)

/*#define DMA_CR5_DSL_Mask (ULONG)(~(~0<<(3)))*/

#define DMA_CR5_DSL_MASK (ULONG)(0x7)

/*#define DMA_CR5_DSL_Wr_Mask (ULONG)(~((~(~0 << (3))) << (18)))*/

#define DMA_CR5_DSL_WR_MASK (ULONG)(0xffe3ffff)

#define DMA_CR5_DSL_UDFWR(data) do {\
		ULONG v;\
		DMA_CR5_RGRD(v);\
		v = (v & (DMA_CR5_RES_WR_MASK_21)) | (((0) & (DMA_CR5_MASK_21)) << 21);\
		v = (v & (DMA_CR5_RES_WR_MASK_25)) | (((0) & (DMA_CR5_MASK_25)) << 25);\
		v = ((v & DMA_CR5_DSL_WR_MASK) | ((data & DMA_CR5_DSL_MASK) << 18));\
		DMA_CR5_RGWR(v);\
} while (0)

#define DMA_CR5_DSL_UDFRD(data) do {\
		DMA_CR5_RGRD(data);\
		data = ((data >> 18) & DMA_CR5_DSL_MASK);\
} while (0)

/*#define DMA_CR5_CH_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_CR5_CH_MASK (ULONG)(0x1)

/*#define DMA_CR5_CH_Wr_Mask (ULONG)(~((~(~0 << (1))) << (23)))*/

#define DMA_CR5_CH_WR_MASK (ULONG)(0xff7fffff)

#define DMA_CR5_CH_UDFWR(data) do {\
		ULONG v;\
		DMA_CR5_RGRD(v);\
		v = (v & (DMA_CR5_RES_WR_MASK_21)) | (((0) & (DMA_CR5_MASK_21)) << 21);\
		v = (v & (DMA_CR5_RES_WR_MASK_25)) | (((0) & (DMA_CR5_MASK_25)) << 25);\
		v = ((v & DMA_CR5_CH_WR_MASK) | ((data & DMA_CR5_CH_MASK) << 23));\
		DMA_CR5_RGWR(v);\
} while (0)

#define DMA_CR5_CH_UDFRD(data) do {\
		DMA_CR5_RGRD(data);\
		data = ((data >> 23) & DMA_CR5_CH_MASK);\
} while (0)

/*#define DMA_CR5_SPH_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_CR5_SPH_MASK (ULONG)(0x1)

/*#define DMA_CR5_SPH_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define DMA_CR5_SPH_WR_MASK (ULONG)(0xfeffffff)

#define DMA_CR5_SPH_UDFWR(data) do {\
		ULONG v;\
		DMA_CR5_RGRD(v);\
		v = (v & (DMA_CR5_RES_WR_MASK_21)) | (((0) & (DMA_CR5_MASK_21)) << 21);\
		v = (v & (DMA_CR5_RES_WR_MASK_25)) | (((0) & (DMA_CR5_MASK_25)) << 25);\
		v = ((v & DMA_CR5_SPH_WR_MASK) | ((data & DMA_CR5_SPH_MASK) << 24));\
		DMA_CR5_RGWR(v);\
} while (0)

#define DMA_CR5_SPH_UDFRD(data) do {\
		DMA_CR5_RGRD(data);\
		data = ((data >> 24) & DMA_CR5_SPH_MASK);\
} while (0)

#define DMA_CR4_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1300))

#define DMA_CR4_RGWR(data) do {\
		iowrite32(data, (void *)DMA_CR4_RGOFFADDR);\
} while (0)

#define DMA_CR4_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CR4_RGOFFADDR);\
} while (0)

/*#define  DMA_CR4_Mask_21 (ULONG)(~(~0<<(2)))*/

#define  DMA_CR4_MASK_21 (ULONG)(0x3)

/*#define DMA_CR4_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(2)))<<(21)))*/

#define DMA_CR4_RES_WR_MASK_21 (ULONG)(0xff9fffff)

/*#define  DMA_CR4_Mask_25 (ULONG)(~(~0<<(7)))*/

#define  DMA_CR4_MASK_25 (ULONG)(0x7f)

/*#define DMA_CR4_RES_Wr_Mask_25 (ULONG)(~((~(~0<<(7)))<<(25)))*/

#define DMA_CR4_RES_WR_MASK_25 (ULONG)(0x1ffffff)

/*#define DMA_CR4_MSS_Mask (ULONG)(~(~0<<(16)))*/

#define DMA_CR4_MSS_MASK (ULONG)(0xffff)

/*#define DMA_CR4_MSS_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define DMA_CR4_MSS_WR_MASK (ULONG)(0xffff0000)

#define DMA_CR4_MSS_UDFWR(data) do {\
		ULONG v;\
		DMA_CR4_RGRD(v);\
		v = (v & (DMA_CR4_RES_WR_MASK_21)) | (((0) & (DMA_CR4_MASK_21)) << 21);\
		v = (v & (DMA_CR4_RES_WR_MASK_25)) | (((0) & (DMA_CR4_MASK_25)) << 25);\
		v = ((v & DMA_CR4_MSS_WR_MASK) | ((data & DMA_CR4_MSS_MASK) << 0));\
		DMA_CR4_RGWR(v);\
} while (0)

#define DMA_CR4_MSS_UDFRD(data) do {\
		DMA_CR4_RGRD(data);\
		data = ((data >> 0) & DMA_CR4_MSS_MASK);\
} while (0)

/*#define DMA_CR4_PBLx8_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_CR4_PBLX8_MASK (ULONG)(0x1)

/*#define DMA_CR4_PBLx8_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define DMA_CR4_PBLX8_WR_MASK (ULONG)(0xfffeffff)

#define DMA_CR4_PBLX8_UDFWR(data) do {\
		ULONG v;\
		DMA_CR4_RGRD(v);\
		v = (v & (DMA_CR4_RES_WR_MASK_21)) | (((0) & (DMA_CR4_MASK_21)) << 21);\
		v = (v & (DMA_CR4_RES_WR_MASK_25)) | (((0) & (DMA_CR4_MASK_25)) << 25);\
		v = ((v & DMA_CR4_PBLX8_WR_MASK) | ((data & DMA_CR4_PBLX8_MASK) << 16));\
		DMA_CR4_RGWR(v);\
} while (0)

#define DMA_CR4_PBLX8_UDFRD(data) do {\
		DMA_CR4_RGRD(data);\
		data = ((data >> 16) & DMA_CR4_PBLX8_MASK);\
} while (0)

/*#define DMA_CR4_DPE_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_CR4_DPE_MASK (ULONG)(0x1)

/*#define DMA_CR4_DPE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (17)))*/

#define DMA_CR4_DPE_WR_MASK (ULONG)(0xfffdffff)

#define DMA_CR4_DPE_UDFWR(data) do {\
		ULONG v;\
		DMA_CR4_RGRD(v);\
		v = (v & (DMA_CR4_RES_WR_MASK_21)) | (((0) & (DMA_CR4_MASK_21)) << 21);\
		v = (v & (DMA_CR4_RES_WR_MASK_25)) | (((0) & (DMA_CR4_MASK_25)) << 25);\
		v = ((v & DMA_CR4_DPE_WR_MASK) | ((data & DMA_CR4_DPE_MASK) << 17));\
		DMA_CR4_RGWR(v);\
} while (0)

#define DMA_CR4_DPE_UDFRD(data) do {\
		DMA_CR4_RGRD(data);\
		data = ((data >> 17) & DMA_CR4_DPE_MASK);\
} while (0)

/*#define DMA_CR4_DSL_Mask (ULONG)(~(~0<<(3)))*/

#define DMA_CR4_DSL_MASK (ULONG)(0x7)

/*#define DMA_CR4_DSL_Wr_Mask (ULONG)(~((~(~0 << (3))) << (18)))*/

#define DMA_CR4_DSL_WR_MASK (ULONG)(0xffe3ffff)

#define DMA_CR4_DSL_UDFWR(data) do {\
		ULONG v;\
		DMA_CR4_RGRD(v);\
		v = (v & (DMA_CR4_RES_WR_MASK_21)) | (((0) & (DMA_CR4_MASK_21)) << 21);\
		v = (v & (DMA_CR4_RES_WR_MASK_25)) | (((0) & (DMA_CR4_MASK_25)) << 25);\
		v = ((v & DMA_CR4_DSL_WR_MASK) | ((data & DMA_CR4_DSL_MASK) << 18));\
		DMA_CR4_RGWR(v);\
} while (0)

#define DMA_CR4_DSL_UDFRD(data) do {\
		DMA_CR4_RGRD(data);\
		data = ((data >> 18) & DMA_CR4_DSL_MASK);\
} while (0)

/*#define DMA_CR4_CH_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_CR4_CH_MASK (ULONG)(0x1)

/*#define DMA_CR4_CH_Wr_Mask (ULONG)(~((~(~0 << (1))) << (23)))*/

#define DMA_CR4_CH_WR_MASK (ULONG)(0xff7fffff)

#define DMA_CR4_CH_UDFWR(data) do {\
		ULONG v;\
		DMA_CR4_RGRD(v);\
		v = (v & (DMA_CR4_RES_WR_MASK_21)) | (((0) & (DMA_CR4_MASK_21)) << 21);\
		v = (v & (DMA_CR4_RES_WR_MASK_25)) | (((0) & (DMA_CR4_MASK_25)) << 25);\
		v = ((v & DMA_CR4_CH_WR_MASK) | ((data & DMA_CR4_CH_MASK) << 23));\
		DMA_CR4_RGWR(v);\
} while (0)

#define DMA_CR4_CH_UDFRD(data) do {\
		DMA_CR4_RGRD(data);\
		data = ((data >> 23) & DMA_CR4_CH_MASK);\
} while (0)

/*#define DMA_CR4_SPH_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_CR4_SPH_MASK (ULONG)(0x1)

/*#define DMA_CR4_SPH_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define DMA_CR4_SPH_WR_MASK (ULONG)(0xfeffffff)

#define DMA_CR4_SPH_UDFWR(data) do {\
		ULONG v;\
		DMA_CR4_RGRD(v);\
		v = (v & (DMA_CR4_RES_WR_MASK_21)) | (((0) & (DMA_CR4_MASK_21)) << 21);\
		v = (v & (DMA_CR4_RES_WR_MASK_25)) | (((0) & (DMA_CR4_MASK_25)) << 25);\
		v = ((v & DMA_CR4_SPH_WR_MASK) | ((data & DMA_CR4_SPH_MASK) << 24));\
		DMA_CR4_RGWR(v);\
} while (0)

#define DMA_CR4_SPH_UDFRD(data) do {\
		DMA_CR4_RGRD(data);\
		data = ((data >> 24) & DMA_CR4_SPH_MASK);\
} while (0)

#define DMA_CR3_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1280))

#define DMA_CR3_RGWR(data) do {\
		iowrite32(data, (void *)DMA_CR3_RGOFFADDR);\
} while (0)

#define DMA_CR3_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CR3_RGOFFADDR);\
} while (0)

/*#define  DMA_CR3_Mask_21 (ULONG)(~(~0<<(2)))*/

#define  DMA_CR3_MASK_21 (ULONG)(0x3)

/*#define DMA_CR3_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(2)))<<(21)))*/

#define DMA_CR3_RES_WR_MASK_21 (ULONG)(0xff9fffff)

/*#define  DMA_CR3_Mask_25 (ULONG)(~(~0<<(7)))*/

#define  DMA_CR3_MASK_25 (ULONG)(0x7f)

/*#define DMA_CR3_RES_Wr_Mask_25 (ULONG)(~((~(~0<<(7)))<<(25)))*/

#define DMA_CR3_RES_WR_MASK_25 (ULONG)(0x1ffffff)

/*#define DMA_CR3_MSS_Mask (ULONG)(~(~0<<(16)))*/

#define DMA_CR3_MSS_MASK (ULONG)(0xffff)

/*#define DMA_CR3_MSS_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define DMA_CR3_MSS_WR_MASK (ULONG)(0xffff0000)

#define DMA_CR3_MSS_UDFWR(data) do {\
		ULONG v;\
		DMA_CR3_RGRD(v);\
		v = (v & (DMA_CR3_RES_WR_MASK_21)) | (((0) & (DMA_CR3_MASK_21)) << 21);\
		v = (v & (DMA_CR3_RES_WR_MASK_25)) | (((0) & (DMA_CR3_MASK_25)) << 25);\
		v = ((v & DMA_CR3_MSS_WR_MASK) | ((data & DMA_CR3_MSS_MASK) << 0));\
		DMA_CR3_RGWR(v);\
} while (0)

#define DMA_CR3_MSS_UDFRD(data) do {\
		DMA_CR3_RGRD(data);\
		data = ((data >> 0) & DMA_CR3_MSS_MASK);\
} while (0)

/*#define DMA_CR3_PBLx8_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_CR3_PBLX8_MASK (ULONG)(0x1)

/*#define DMA_CR3_PBLx8_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define DMA_CR3_PBLX8_WR_MASK (ULONG)(0xfffeffff)

#define DMA_CR3_PBLX8_UDFWR(data) do {\
		ULONG v;\
		DMA_CR3_RGRD(v);\
		v = (v & (DMA_CR3_RES_WR_MASK_21)) | (((0) & (DMA_CR3_MASK_21)) << 21);\
		v = (v & (DMA_CR3_RES_WR_MASK_25)) | (((0) & (DMA_CR3_MASK_25)) << 25);\
		v = ((v & DMA_CR3_PBLX8_WR_MASK) | ((data & DMA_CR3_PBLX8_MASK) << 16));\
		DMA_CR3_RGWR(v);\
} while (0)

#define DMA_CR3_PBLX8_UDFRD(data) do {\
		DMA_CR3_RGRD(data);\
		data = ((data >> 16) & DMA_CR3_PBLX8_MASK);\
} while (0)

/*#define DMA_CR3_DPE_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_CR3_DPE_MASK (ULONG)(0x1)

/*#define DMA_CR3_DPE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (17)))*/

#define DMA_CR3_DPE_WR_MASK (ULONG)(0xfffdffff)

#define DMA_CR3_DPE_UDFWR(data) do {\
		ULONG v;\
		DMA_CR3_RGRD(v);\
		v = (v & (DMA_CR3_RES_WR_MASK_21)) | (((0) & (DMA_CR3_MASK_21)) << 21);\
		v = (v & (DMA_CR3_RES_WR_MASK_25)) | (((0) & (DMA_CR3_MASK_25)) << 25);\
		v = ((v & DMA_CR3_DPE_WR_MASK) | ((data & DMA_CR3_DPE_MASK) << 17));\
		DMA_CR3_RGWR(v);\
} while (0)

#define DMA_CR3_DPE_UDFRD(data) do {\
		DMA_CR3_RGRD(data);\
		data = ((data >> 17) & DMA_CR3_DPE_MASK);\
} while (0)

/*#define DMA_CR3_DSL_Mask (ULONG)(~(~0<<(3)))*/

#define DMA_CR3_DSL_MASK (ULONG)(0x7)

/*#define DMA_CR3_DSL_Wr_Mask (ULONG)(~((~(~0 << (3))) << (18)))*/

#define DMA_CR3_DSL_WR_MASK (ULONG)(0xffe3ffff)

#define DMA_CR3_DSL_UDFWR(data) do {\
		ULONG v;\
		DMA_CR3_RGRD(v);\
		v = (v & (DMA_CR3_RES_WR_MASK_21)) | (((0) & (DMA_CR3_MASK_21)) << 21);\
		v = (v & (DMA_CR3_RES_WR_MASK_25)) | (((0) & (DMA_CR3_MASK_25)) << 25);\
		v = ((v & DMA_CR3_DSL_WR_MASK) | ((data & DMA_CR3_DSL_MASK) << 18));\
		DMA_CR3_RGWR(v);\
} while (0)

#define DMA_CR3_DSL_UDFRD(data) do {\
		DMA_CR3_RGRD(data);\
		data = ((data >> 18) & DMA_CR3_DSL_MASK);\
} while (0)

/*#define DMA_CR3_CH_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_CR3_CH_MASK (ULONG)(0x1)

/*#define DMA_CR3_CH_Wr_Mask (ULONG)(~((~(~0 << (1))) << (23)))*/

#define DMA_CR3_CH_WR_MASK (ULONG)(0xff7fffff)

#define DMA_CR3_CH_UDFWR(data) do {\
		ULONG v;\
		DMA_CR3_RGRD(v);\
		v = (v & (DMA_CR3_RES_WR_MASK_21)) | (((0) & (DMA_CR3_MASK_21)) << 21);\
		v = (v & (DMA_CR3_RES_WR_MASK_25)) | (((0) & (DMA_CR3_MASK_25)) << 25);\
		v = ((v & DMA_CR3_CH_WR_MASK) | ((data & DMA_CR3_CH_MASK) << 23));\
		DMA_CR3_RGWR(v);\
} while (0)

#define DMA_CR3_CH_UDFRD(data) do {\
		DMA_CR3_RGRD(data);\
		data = ((data >> 23) & DMA_CR3_CH_MASK);\
} while (0)

/*#define DMA_CR3_SPH_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_CR3_SPH_MASK (ULONG)(0x1)

/*#define DMA_CR3_SPH_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define DMA_CR3_SPH_WR_MASK (ULONG)(0xfeffffff)

#define DMA_CR3_SPH_UDFWR(data) do {\
		ULONG v;\
		DMA_CR3_RGRD(v);\
		v = (v & (DMA_CR3_RES_WR_MASK_21)) | (((0) & (DMA_CR3_MASK_21)) << 21);\
		v = (v & (DMA_CR3_RES_WR_MASK_25)) | (((0) & (DMA_CR3_MASK_25)) << 25);\
		v = ((v & DMA_CR3_SPH_WR_MASK) | ((data & DMA_CR3_SPH_MASK) << 24));\
		DMA_CR3_RGWR(v);\
} while (0)

#define DMA_CR3_SPH_UDFRD(data) do {\
		DMA_CR3_RGRD(data);\
		data = ((data >> 24) & DMA_CR3_SPH_MASK);\
} while (0)

#define DMA_CR2_RGOFFADDR ((volatile ULONG *)(BASE_ADDRESS + 0x1200))

#define DMA_CR2_RGWR(data) do {\
		iowrite32(data, (void *)DMA_CR2_RGOFFADDR);\
} while (0)

#define DMA_CR2_RGRD(data) do {\
		(data) = ioread32((void *)DMA_CR2_RGOFFADDR);\
} while (0)

/*#define  DMA_CR2_Mask_21 (ULONG)(~(~0<<(2)))*/

#define  DMA_CR2_MASK_21 (ULONG)(0x3)

/*#define DMA_CR2_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(2)))<<(21)))*/

#define DMA_CR2_RES_WR_MASK_21 (ULONG)(0xff9fffff)

/*#define  DMA_CR2_Mask_25 (ULONG)(~(~0<<(7)))*/

#define  DMA_CR2_MASK_25 (ULONG)(0x7f)

/*#define DMA_CR2_RES_Wr_Mask_25 (ULONG)(~((~(~0<<(7)))<<(25)))*/

#define DMA_CR2_RES_WR_MASK_25 (ULONG)(0x1ffffff)

/*#define DMA_CR2_MSS_Mask (ULONG)(~(~0<<(16)))*/

#define DMA_CR2_MSS_MASK (ULONG)(0xffff)

/*#define DMA_CR2_MSS_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define DMA_CR2_MSS_WR_MASK (ULONG)(0xffff0000)

#define DMA_CR2_MSS_UDFWR(data) do {\
		ULONG v;\
		DMA_CR2_RGRD(v);\
		v = (v & (DMA_CR2_RES_WR_MASK_21)) | (((0) & (DMA_CR2_MASK_21)) << 21);\
		v = (v & (DMA_CR2_RES_WR_MASK_25)) | (((0) & (DMA_CR2_MASK_25)) << 25);\
		v = ((v & DMA_CR2_MSS_WR_MASK) | ((data & DMA_CR2_MSS_MASK) << 0));\
		DMA_CR2_RGWR(v);\
} while (0)

#define DMA_CR2_MSS_UDFRD(data) do {\
		DMA_CR2_RGRD(data);\
		data = ((data >> 0) & DMA_CR2_MSS_MASK);\
} while (0)

/*#define DMA_CR2_PBLx8_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_CR2_PBLX8_MASK (ULONG)(0x1)

/*#define DMA_CR2_PBLx8_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define DMA_CR2_PBLX8_WR_MASK (ULONG)(0xfffeffff)

#define DMA_CR2_PBLX8_UDFWR(data) do {\
		ULONG v;\
		DMA_CR2_RGRD(v);\
		v = (v & (DMA_CR2_RES_WR_MASK_21)) | (((0) & (DMA_CR2_MASK_21)) << 21);\
		v = (v & (DMA_CR2_RES_WR_MASK_25)) | (((0) & (DMA_CR2_MASK_25)) << 25);\
		v = ((v & DMA_CR2_PBLX8_WR_MASK) | ((data & DMA_CR2_PBLX8_MASK) << 16));\
		DMA_CR2_RGWR(v);\
} while (0)

#define DMA_CR2_PBLX8_UDFRD(data) do {\
		DMA_CR2_RGRD(data);\
		data = ((data >> 16) & DMA_CR2_PBLX8_MASK);\
} while (0)

/*#define DMA_CR2_DPE_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_CR2_DPE_MASK (ULONG)(0x1)

/*#define DMA_CR2_DPE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (17)))*/

#define DMA_CR2_DPE_WR_MASK (ULONG)(0xfffdffff)

#define DMA_CR2_DPE_UDFWR(data) do {\
		ULONG v;\
		DMA_CR2_RGRD(v);\
		v = (v & (DMA_CR2_RES_WR_MASK_21)) | (((0) & (DMA_CR2_MASK_21)) << 21);\
		v = (v & (DMA_CR2_RES_WR_MASK_25)) | (((0) & (DMA_CR2_MASK_25)) << 25);\
		v = ((v & DMA_CR2_DPE_WR_MAS