/*----------------------------------------------------------------------------*/
// (C) 2021 FCNT LIMITED
/*----------------------------------------------------------------------------*/
// SPDX-License-Identifier: GPL-2.0

//==============================================================================
// include file
//==============================================================================
#include <linux/init.h>
#include <linux/module.h>
#include <linux/version.h>
#include <linux/kernel.h>
#include <linux/custom_mode.h>
#include <linux/nonvolatile_common.h>
#include <linux/seq_file.h>
#include <linux/proc_fs.h>
#include <linux/soc/qcom/smem_custom.h>

//==============================================================================
// define
//==============================================================================

//==============================================================================
// const data
//==============================================================================

//==============================================================================
// global valuable
//==============================================================================
int custom_boot_mode = CUSTOM_MODE_NORMAL;
EXPORT_SYMBOL(custom_boot_mode);
int charging_mode = 0;
EXPORT_SYMBOL(charging_mode);
int makercmd_mode = 0;
EXPORT_SYMBOL(makercmd_mode);
int custom_recovery_mode = 0;
EXPORT_SYMBOL(custom_recovery_mode);
int repair_mode = 0;
EXPORT_SYMBOL(repair_mode);

//==============================================================================
// private valuable
//==============================================================================

//==============================================================================
// static functions prototype
//==============================================================================

//==============================================================================
// functions
//==============================================================================
static int androidboot_mode_enable(char *str)
{
	if (strncmp(str, "charger", strlen("charger")) == 0) {
		charging_mode = 1;
		custom_boot_mode = CUSTOM_MODE_OFF_CHARGE;
	} else if (strncmp(str, "makermode", strlen("makermode")) == 0) {
		makercmd_mode = 1;
		custom_boot_mode = CUSTOM_MODE_MAKER_MODE;
	} else if (strncmp(str, "kernelmode", strlen("kernelmode")) == 0) {
		makercmd_mode = 1;
		custom_boot_mode = CUSTOM_MODE_KERNEL_MODE;
	} else if (!strncmp(str, "recoverymenu", strlen("recoverymenu"))) {
		custom_recovery_mode = 1;
		custom_boot_mode = CUSTOM_MODE_SP_MODE;
	} else if (!strncmp(str, "osupdatemode", strlen("osupdatemode"))) {
		custom_recovery_mode = 1;
		custom_boot_mode = CUSTOM_MODE_SD_DOWNLOADER;
	} else if (!strncmp(str, "masterclear", strlen("masterclear"))) {
		custom_recovery_mode = 1;
		custom_boot_mode = CUSTOM_MODE_MASTER_CLEAR;
	} else if (!strncmp(str, "repair", strlen("repair"))) {
		repair_mode = 1;
		custom_boot_mode = CUSTOM_MODE_REPAIR_MODE;
	}

	pr_info("custom_boot_mode = %d\n", custom_boot_mode);
	pr_info("chargemode: %d\n", charging_mode);
	pr_info("recoverymode: %d\n", custom_recovery_mode);
	pr_info("makermode : %d\n", makercmd_mode);
	pr_info("repairmode : %d\n", repair_mode);

	return 0;
}

static void androidboot_mode_set()
{
	char *cmdline = (char *)smem_alloc_vendor0(SMEM_OEM_V0_022);
	char *boot_mode;

	if (cmdline == NULL) {
		pr_err("[Custom mode]smem_alloc_vendor0(SMEM_OEM_V0_022) error: %s\n", __func__);
		return;
	}

	boot_mode = strstr(cmdline, "androidboot.mode=");
	if (boot_mode == NULL) {
		pr_err("[Custom mode]Can't find the  androidboot.moden cmdline : %s\n", __func__);
		return;
	}

	boot_mode += strlen("androidboot.mode=");
	androidboot_mode_enable(boot_mode);

	return;
}
#define APLNV_DATABU_ADB_ENABLE_I    (49294)

static int force_adb_off_show(struct seq_file *m, void *unused)
{
	unsigned char buf;
	int ret = 0;

	ret = get_nonvolatile((uint8_t*)&buf, APLNV_DATABU_ADB_ENABLE_I, 1);
	if (unlikely(ret < 0)) {
		ret = -EFAULT;
		return ret;
	}

	if (ret == sizeof(buf)) {
		seq_printf(m, "%d\n", buf);
	} else {
		seq_printf(m, "%d\n", 0);
	}

	return 0;
}

static ssize_t force_adb_off_write(struct file *file, const char __user *userbuf,
			     size_t count, loff_t *data)
{
	unsigned char buf = 0;

	set_nonvolatile((uint8_t*)&buf, APLNV_DATABU_ADB_ENABLE_I, 1);
	return count;
}

static int force_adb_off_open(struct inode *inode, struct file *file)
{
	return single_open(file, force_adb_off_show, NULL);
}

static const struct file_operations force_adb_off_fops = {
	.owner = THIS_MODULE,
	.open = force_adb_off_open,
	.read = seq_read,
	.llseek = seq_lseek,
	.release = single_release,
	.write		= force_adb_off_write,
};

static int force_adb_off_init(void)
{
	proc_create("force_adb_off", 0600, NULL, &force_adb_off_fops);
	return 0;
}

static int __init fcnt_custom_init(void)
{
	force_adb_off_init();
	androidboot_mode_set();

	return 0;
}
module_init(fcnt_custom_init);

MODULE_LICENSE("GPL v2");
