#ifndef CTS_CONFIG_H
#define CTS_CONFIG_H

#ifdef CONFIG_TP_GKI_FACTORY_FCNT
        #define  FACTORY_TEST_RESULT_TO_SDCARD      1 //uesrdebug include file_open class function
#else
        #define  FACTORY_TEST_RESULT_TO_SDCARD      0 //uesr dont include file_open class function
#endif
/** Driver version */
#define CFG_CTS_DRIVER_MAJOR_VERSION        1
#define CFG_CTS_DRIVER_MINOR_VERSION        0
#define CFG_CTS_DRIVER_PATCH_VERSION        2

#define CFG_CTS_DRIVER_VERSION              "v1.0.2"

/** Whether reset pin is used */
#define CFG_CTS_HAS_RESET_PIN

/* Handle IRQ whether in workqueue or kthread. */
//#define CFG_CTS_HANDLE_IRQ_USE_WORKQUEUE

/* With SCHED_RR option, kthread will get better performance by
 * dramatic decrease delay between irq and work.
 */
#define CFG_CTS_HANDLE_IRQ_USE_KTHREAD
/* UP event missing by some reason will cause touch remaining when
 * all fingers are lifted or flying line when touch in the next time.
 * Enable following option will prevent this.
 * FIXME:
 *   Currently, one finger UP event missing in multi-touch, it will
 *   report UP to system when all fingers are lifted.
 */
#define CFG_CTS_MAKEUP_EVENT_UP
/** Whether force download firmware to chip */
//#define CFG_CTS_FIRMWARE_FORCE_UPDATE

/** Use build in firmware or firmware file in fs*/
#define CFG_CTS_DRIVER_BUILTIN_FIRMWARE
#define CFG_CTS_KERNEL_BUILTIN_FIRMWARE
#define CFG_CTS_FIRMWARE_IN_FS


//#define  SUPPORT_SENSOR_ID
#define  CTS_TOUCH_FACTORY_TEST 


#ifdef CONFIG_PROC_FS
    /* Proc FS for backward compatibility for APK tool com.ICN85xx */
    #define CONFIG_CTS_LEGACY_TOOL
#endif /* CONFIG_PROC_FS */

#ifdef CONFIG_SYSFS
    /* Sys FS for gesture report, debug feature etc. */
   #define CONFIG_CTS_SYSFS
#endif /* CONFIG_SYSFS */

#define CFG_CTS_MAX_TOUCH_NUM               (10)

/* Virtual key support */
//#define CONFIG_CTS_VIRTUALKEY
#ifdef CONFIG_CTS_VIRTUALKEY
    #define CFG_CTS_MAX_VKEY_NUM            (4)
    #define CFG_CTS_NUM_VKEY                (3)
    #define CFG_CTS_VKEY_KEYCODES           {KEY_BACK, KEY_HOME, KEY_MENU}
#endif /* CONFIG_CTS_VIRTUALKEY */
/* proc glove node*/
#define CONFIG_CTS_PROC_GLOVE

/* Gesture wakeup */
#define CONFIG_CTS_GESTURE

#ifdef CONFIG_CTS_GESTURE

#define CONFIG_CTS_GESTURE_SWITCH

#define GESTURE_UP                          0x11
#define GESTURE_C                           0x12
#define GESTURE_O                           0x13
#define GESTURE_M                           0x14
#define GESTURE_W                           0x15
#define GESTURE_E                           0x16
#define GESTURE_S                           0x17
#define GESTURE_Z                           0x1d
#define GESTURE_V                           0x1e
#define GESTURE_D_TAP                       0x50

    #define CFG_CTS_NUM_GESTURE             (9u)
    #define CFG_CTS_GESTURE_REPORT_KEY
    #define CFG_CTS_GESTURE_KEYMAP  \
        {{GESTURE_C, KEY_C,},       \
         {GESTURE_W, KEY_W,},       \
         {GESTURE_V, KEY_V,},       \
         {GESTURE_D_TAP, KEY_POWER,},  \
         {GESTURE_Z, KEY_Z,},       \
         {GESTURE_M, KEY_M,},       \
         {GESTURE_O, KEY_O,},       \
         {GESTURE_E, KEY_E,},       \
         {GESTURE_S, KEY_S,},       \
        }
    #define CFG_CTS_GESTURE_REPORT_TRACE    0
#endif /* CONFIG_CTS_GESTURE */


//#define CONFIG_CTS_PROXIMITY

/* ESD protection */
#define CONFIG_CTS_ESD_PROTECTION
#ifdef CONFIG_CTS_ESD_PROTECTION
    #define CFG_CTS_ESD_PROTECTION_CHECK_PERIOD         (2 * HZ)
#endif /* CONFIG_CTS_ESD_PROTECTION */

/* Use slot protocol (protocol B), comment it if use protocol A. */
#define CONFIG_CTS_SLOTPROTOCOL

#ifdef CONFIG_CTS_LEGACY_TOOL
    #define CFG_CTS_TOOL_PROC_FILENAME      "icn85xx_tool"
#endif /* CONFIG_CTS_LEGACY_TOOL */

#ifdef  CTS_TOUCH_FACTORY_TEST
    #define CFG_CTS_FACTORY_TEST_FILENAME      "tp_selftest"
#endif

#ifdef CONFIG_CTS_GESTURE_SWITCH
    #define CFG_CTS_GESTURE_STATE      "chsc_guesture"
#endif
#ifdef CONFIG_CTS_PROC_GLOVE
    #define CFG_CTS_GLOVE_NODE	   	    "chsc_glove"
#endif
/****************************************************************************
 * Platform configurations
 ****************************************************************************/

// #ifdef CONFIG_ARCH_MSM
#if 1
#include "cts_plat_qcom_config.h"
#endif /* CONFIG_ARCH_MSM */

#endif /* CTS_CONFIG_H */

