#define LOG_TAG         "Test"

#include "cts_config.h"
#include "cts_platform.h"
#include "cts_core.h"
#include "cts_test.h"
#include "cts_firmware.h"

bool test_debug = 0;
struct cts_log cts_log;
extern struct chipone_ts_data *g_cts_data;

/*static char *cts_test_config_data = \
                                                      "\n" "fw_version_test=1"
                                                      "\n" "short_test=1"
                                                      "\n"  "open_test=1"
                                                      "\n" "rawdata_test=1"
                                                      "\n"  "firmware_version=0x0900"
                                                      "\n" "short_threshold = 800"
                                                      "\n" "rawdata_max=3086"
                                                      "\n"  "rawdata_min=1841"
                                                        ;
                                                        */
#define SUPPORT_FW_VERSION_TEST		0
#define TARGET_FW_VERSION		0x1d01

#define SUPPORT_RAWDATA_TEST	1
#define SUPPORT_OPEN_TEST		1
#define SUPPORT_SHORT_TEST		1
#define SHORT_TEST_TH			800


#if 1

  u16 rawdata_test_min[] = {
	 2969, 3269, 3221, 3261, 3204, 3236, 3189, 3210, 3168, 3187, 3163, 3186, 3198, 3161, 2541, 2653, 2653, 2704, 2714, 2765, 2798, 2851, 2873, 2933, 2966, 3034, 2784,
	 3444, 3804, 3742, 3791, 3723, 3764, 3707, 3735, 3685, 3708, 3669, 3689, 3667, 3544, 3236, 3389, 3393, 3457, 3472, 3533, 3576, 3643, 3673, 3752, 3793, 3875, 3524,
	 3071, 3398, 3343, 3389, 3330, 3367, 3313, 3342, 3298, 3320, 3285, 3309, 3286, 3175, 2951, 3094, 3096, 3154, 3164, 3219, 3258, 3324, 3351, 3421, 3457, 3535, 3197,
	 3038, 3366, 3304, 3350, 3289, 3328, 3276, 3304, 3263, 3288, 3256, 3278, 3259, 3146, 2977, 3122, 3125, 3181, 3191, 3248, 3285, 3350, 3379, 3448, 3482, 3558, 3219,
	 3030, 3348, 3294, 3334, 3279, 3313, 3268, 3290, 3252, 3274, 3246, 3264, 3247, 3132, 3021, 3166, 3170, 3225, 3236, 3292, 3332, 3395, 3425, 3493, 3530, 3601, 3254,
	 2819, 3146, 3220, 3263, 3211, 3243, 3200, 3222, 3185, 3205, 3181, 3197, 3182, 3069, 3005, 3148, 3152, 3205, 3218, 3271, 3311, 3371, 3400, 3466, 3500, 3569, 3231,
	 1856, 2344, 3275, 3323, 3273, 3303, 3261, 3279, 3243, 3256, 3232, 3244, 3231, 3108, 3093, 3240, 3240, 3291, 3303, 3353, 3391, 3442, 3467, 3528, 3562, 3625, 3276,
	 2938, 3183, 3243, 3291, 3232, 3273, 3226, 3253, 3215, 3240, 3212, 3237, 3221, 3111, 3146, 3292, 3295, 3359, 3370, 3428, 3467, 3531, 3562, 3634, 3669, 3747, 3393,
	 2906, 3248, 3199, 3237, 3185, 3219, 3178, 3203, 3170, 3193, 3172, 3191, 3181, 3072, 3154, 3296, 3301, 3362, 3375, 3430, 3465, 3528, 3561, 3630, 3665, 3742, 3391,
	 2833, 3215, 3169, 3205, 3156, 3188, 3149, 3173, 3145, 3167, 3147, 3165, 3160, 3052, 3189, 3328, 3329, 3390, 3405, 3458, 3497, 3555, 3585, 3656, 3688, 3763, 3407,
	 2799, 3182, 3138, 3175, 3129, 3161, 3122, 3146, 3118, 3138, 3121, 3141, 3137, 3029, 3219, 3352, 3357, 3417, 3430, 3481, 3522, 3578, 3605, 3676, 3708, 3778, 3420,
	 2835, 3172, 3130, 3166, 3123, 3153, 3117, 3138, 3115, 3133, 3120, 3138, 3136, 3032, 3291, 3420, 3423, 3482, 3493, 3545, 3585, 3641, 3673, 3737, 3772, 3841, 3491,
	 2470, 2719, 2680, 2714, 2677, 2707, 2675, 2692, 2673, 2691, 2679, 2696, 2696, 2609, 3111, 3214, 3214, 3264, 3268, 3315, 3347, 3397, 3422, 3476, 3507, 3575, 3263,
 };
  u16 rawdata_test_max[] = {
	 5146, 5666, 5582, 5652, 5553, 5609, 5527, 5564, 5491, 5524, 5483, 5522, 5543, 5480, 4404, 4598, 4598, 4686, 4705, 4793, 4849, 4942, 4980, 5085, 5141, 5259, 4825,
	 5969, 6594, 6487, 6572, 6452, 6524, 6425, 6474, 6387, 6427, 6360, 6393, 6356, 6142, 5608, 5875, 5881, 5992, 6018, 6124, 6198, 6314, 6367, 6503, 6575, 6717, 6108,
	 5322, 5890, 5794, 5875, 5771, 5836, 5742, 5793, 5717, 5755, 5695, 5735, 5696, 5503, 5116, 5364, 5367, 5467, 5485, 5580, 5647, 5761, 5809, 5930, 5992, 6127, 5541,
	 5266, 5835, 5728, 5806, 5701, 5768, 5679, 5727, 5655, 5700, 5644, 5681, 5649, 5454, 5160, 5411, 5416, 5515, 5532, 5629, 5694, 5807, 5858, 5977, 6036, 6167, 5580,
	 5253, 5803, 5710, 5780, 5683, 5742, 5664, 5703, 5637, 5674, 5627, 5658, 5629, 5429, 5236, 5487, 5494, 5590, 5609, 5706, 5776, 5884, 5938, 6055, 6119, 6241, 5640,
	 4886, 5453, 5581, 5656, 5565, 5621, 5546, 5585, 5521, 5556, 5514, 5541, 5516, 5319, 5209, 5457, 5463, 5556, 5579, 5670, 5739, 5844, 5893, 6008, 6067, 6187, 5601,
	 3217, 4062, 5676, 5760, 5673, 5725, 5652, 5683, 5621, 5644, 5603, 5622, 5600, 5387, 5361, 5617, 5616, 5704, 5725, 5812, 5877, 5966, 6009, 6116, 6174, 6283, 5678,
	 5092, 5517, 5621, 5705, 5602, 5673, 5591, 5638, 5573, 5617, 5568, 5610, 5582, 5392, 5452, 5706, 5711, 5823, 5841, 5942, 6010, 6120, 6174, 6300, 6359, 6494, 5882,
	 5037, 5630, 5545, 5611, 5520, 5579, 5509, 5551, 5494, 5534, 5498, 5532, 5513, 5325, 5467, 5713, 5722, 5827, 5849, 5945, 6007, 6115, 6173, 6291, 6354, 6486, 5878,
	 4910, 5573, 5492, 5556, 5470, 5526, 5459, 5500, 5452, 5489, 5455, 5486, 5477, 5290, 5528, 5769, 5771, 5877, 5902, 5993, 6061, 6162, 6213, 6338, 6393, 6522, 5905,
	 4852, 5516, 5439, 5502, 5424, 5480, 5412, 5453, 5405, 5439, 5409, 5445, 5437, 5250, 5580, 5811, 5818, 5922, 5945, 6033, 6104, 6201, 6248, 6371, 6426, 6549, 5928,
	 4914, 5498, 5425, 5487, 5413, 5465, 5403, 5439, 5400, 5431, 5408, 5438, 5437, 5255, 5704, 5928, 5933, 6035, 6054, 6144, 6213, 6311, 6366, 6477, 6539, 6658, 6052,
	 4282, 4713, 4646, 4705, 4641, 4692, 4636, 4667, 4634, 4664, 4644, 4674, 4674, 4522, 5392, 5572, 5571, 5658, 5665, 5746, 5801, 5889, 5932, 6025, 6078, 6197, 5656,
 };


#else

 u16 rawdata_test_min[] = {
		3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,
		3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,
		3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,
		3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,
		3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,
		3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,
		3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,
		3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,
		3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,
		3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,
		3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,
		3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,
		3000,3000,3000,3000,3000,3000,1500,1500,3000,3000,3000,3000,3000,
		3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,
		3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,
		3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,
		3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,
		3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,
		3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,
		3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,
		3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,
		3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,
		3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,
		3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,
		3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,
		3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,
		3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,
};		
 u16 rawdata_test_max[] = {
		5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,
		5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,
		5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,
		5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,
		5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,
		5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,
		5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,
		5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,
		5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,
		5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,
		5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,
		5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,
		5500,5500,5500,5500,5500,5500,4000,4000,5500,5500,5500,5500,5500,
		5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,
		5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,
		5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,
		5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,
		5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,
		5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,
		5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,
		5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,
		5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,
		5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,
		5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,
		5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,
		5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,
		5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,5500,
};

#endif

 u16 open_rawdata_min[] = {
		600,600,600,600,600,600,600,600,600,600,600,600,600,
		600,600,600,600,600,600,600,600,600,600,600,600,600,
		600,600,600,600,600,600,600,600,600,600,600,600,600,
		600,600,600,600,600,600,600,600,600,600,600,600,600,
		600,600,600,600,600,600,600,600,600,600,600,600,600,
		600,600,600,600,600,600,600,600,600,600,600,600,600,
		600,600,600,600,600,600,600,600,600,600,600,600,600,
		600,600,600,600,600,600,600,600,600,600,600,600,600,
		600,600,600,600,600,600,600,600,600,600,600,600,600,
		600,600,600,600,600,600,600,600,600,600,600,600,600,
		600,600,600,600,600,600,600,600,600,600,600,600,600,
		600,600,600,600,600,600,600,600,600,600,600,600,600,
		600,600,600,600,600,600,400,400,600,600,600,600,600,
		600,600,600,600,600,600,600,600,600,600,600,600,600,
		600,600,600,600,600,600,600,600,600,600,600,600,600,
		600,600,600,600,600,600,600,600,600,600,600,600,600,
		600,600,600,600,600,600,600,600,600,600,600,600,600,
		600,600,600,600,600,600,600,600,600,600,600,600,600,
		600,600,600,600,600,600,600,600,600,600,600,600,600,
		600,600,600,600,600,600,600,600,600,600,600,600,600,
		600,600,600,600,600,600,600,600,600,600,600,600,600,
		600,600,600,600,600,600,600,600,600,600,600,600,600,
		600,600,600,600,600,600,600,600,600,600,600,600,600,
		600,600,600,600,600,600,600,600,600,600,600,600,600,
		600,600,600,600,600,600,600,600,600,600,600,600,600,
		600,600,600,600,600,600,600,600,600,600,600,600,600,
		600,600,600,600,600,600,600,600,600,600,600,600,600,
};		
 u16 open_rawdata_max[] = {
		1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,
		1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,
		1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,
		1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,
		1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,
		1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,
		1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,
		1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,
		1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,
		1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,
		1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,
		1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,
		1600,1600,1600,1600,1600,1600,1000,1000,1600,1600,1600,1600,1600,
		1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,
		1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,
		1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,
		1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,
		1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,
		1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,
		1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,
		1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,
		1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,
		1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,
		1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,
		1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,
		1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,
		1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,
};
#if FACTORY_TEST_RESULT_TO_SDCARD
int cts_test_save_log(struct cts_device *cts_dev, const char *filepath, char *buf)
{

    struct file *file;
    //u32 size;
    u32 len;
    int ret;
	loff_t pos = 0;

#ifndef SUPPORT_SAVE_TEST_LOG
    cts_info("Unsupport save log file");
    return -1;
#endif

    if(buf == NULL){
        cts_err("buf is NULL");
        return -1;
    }
    
    file = filp_open(filepath, O_RDWR |O_CREAT |O_APPEND , 0666);//O_TRUNC  //O_APPEND
    if (IS_ERR(file)) {
        cts_err("Open file '%s' failed %ld", filepath, PTR_ERR(file));
        return -1;
    }

    len =strlen(buf);
    cts_info("write to file %s size: %d", filepath, len);
	pos = 0;
#if LINUX_VERSION_CODE >= KERNEL_VERSION(4,14,0)
    ret = kernel_write(file, buf, len, &pos);
#else
    ret = kernel_write(file, buf, len, pos);
#endif                
    if(ret != len){
        cts_err("kernel write %s fail %d",filepath,ret);
    }
    ret = filp_close(file, NULL);
    if (ret) {
        cts_warn("Close file '%s' failed %d", filepath, ret);
    }
    return ret;

}
#else
void print_test_log(char *s)
{
    char *t, *de = "\n";
    while (*s && *s != '\0') {
      t = strsep(&s, de);
      printk("%s\n", t);
    }
}
#endif

int cts_fw_version_test_fun( struct cts_device * cts_dev, u16 para1, u16 para2)
{
    return cts_fw_version_test(cts_dev, para1);
}
int cts_short_test_fun( struct cts_device * cts_dev, u16 para1, u16 para2)
{   
    return cts_short_test(cts_dev, para1);
}

int cts_open_test_fun( struct cts_device * cts_dev, u16 *para1, u16 *para2)
{   
    return cts_open_test(cts_dev, para1, para2);
}

int cts_rawdata_test_fun( struct cts_device * cts_dev, u16 *para1, u16 *para2)
{   
    return cts_rawdata_test(cts_dev, para1, para2);
}

struct cts_test_cfg cts_test_items[] ={
    {
        .item_name = "fw_version_test",
		.need_test= SUPPORT_FW_VERSION_TEST,
        .result = 0,
        .para = {
            .para1 = "firmware_version",
        },
       // .cts_test_fun = cts_fw_version_test_fun,
    },
    
    {
        .item_name = "short_test",
		.need_test= SUPPORT_SHORT_TEST,
        .result = 0,
        .para = {
            .para1 = "short_threshold",
        },
       // .cts_test_fun = cts_short_test_fun,
    },
   
    {
        .item_name = "open_test",
		.need_test= SUPPORT_OPEN_TEST,
        .result = 0,
        //.para = {
        //    .para1 = "rawdata_min",
       // },
       // .cts_test_fun = cts_open_test_fun,
    },
    
    {
        .item_name = "rawdata_test",
		.need_test= SUPPORT_RAWDATA_TEST,
        .result = 0,
        .para = {
            .para1 = "rawdata_min",
            .para2 = "rawdata_max",
        },
       // .cts_test_fun = cts_rawdata_test_fun,
    },
};

int cts_tiny_short_test_init(struct cts_device *cts_dev)
{
    u32 regAddr[128];
    u8 regData[128];
    u32 regCount = 0;
    int ret,i;

    //Step1:  initial setting
    regAddr[regCount] = 0x040005; regData[regCount++] = 0x01;
    regAddr[regCount] = 0x040138; regData[regCount++] = 0x01;
    regAddr[regCount] = 0x040140; regData[regCount++] = 0x00;
    regAddr[regCount] = 0x04013c; regData[regCount++] = 0x00;
    regAddr[regCount] = 0x04010B; regData[regCount++] = 0x30;
    regAddr[regCount] = 0x040105; regData[regCount++] = 0x1a;
    regAddr[regCount] = 0x040136; regData[regCount++] = 0x30;
    regAddr[regCount] = 0x040100; regData[regCount++] = 0x07;
    regAddr[regCount] = 0x04011c; regData[regCount++] = 0xff;
    regAddr[regCount] = 0x04011d; regData[regCount++] = 0xff;
    regAddr[regCount] = 0x04011e; regData[regCount++] = 0x03;
    regAddr[regCount] = 0x04015c; regData[regCount++] = 0x00;
    regAddr[regCount] = 0x040195; regData[regCount++] = 0xF1;
    regAddr[regCount] = 0x0401B2; regData[regCount++] = 0x03;
    regAddr[regCount] = 0x0401BC; regData[regCount++] = 0x01;
    regAddr[regCount] = 0x040197; regData[regCount++] = 0x02;
    regAddr[regCount] = 0x040178; regData[regCount++] = 0x00;
    regAddr[regCount] = 0x04019C; regData[regCount++] = 0xFF;
    regAddr[regCount] = 0x0401B3; regData[regCount++] = 0x1F;
    regAddr[regCount] = 0x04088D; regData[regCount++] = 0x03;
    regAddr[regCount] = 0x04088C; regData[regCount++] = 0x84;
    regAddr[regCount] = 0x04088F; regData[regCount++] = 0x02;
    regAddr[regCount] = 0x04088E; regData[regCount++] = 0x58;
    regAddr[regCount] = 0x0408C4; regData[regCount++] = 0x20;
    regAddr[regCount] = 0x0408C5; regData[regCount++] = 0x00;
    regAddr[regCount] = 0x0408C6; regData[regCount++] = 0x01;
    regAddr[regCount] = 0x040841; regData[regCount++] = 0x0b;
    regAddr[regCount] = 0x040858; regData[regCount++] = 0x12;
    regAddr[regCount] = 0x040859; regData[regCount++] = 0x12;
    regAddr[regCount] = 0x040145; regData[regCount++] = 0x00;
    regAddr[regCount] = 0x040198; regData[regCount++] = 0x1A;
    regAddr[regCount] = 0x04010A; regData[regCount++] = 0x44;
    regAddr[regCount] = 0x04082C; regData[regCount++] = 0x08;
    for (i = 0; i < RX_CHANNEL_NUM / 2; i++)
    {
        regAddr[regCount] = (u32)(0x040800 + i); 
        regData[regCount++] = (u8)(0x40 + i * 2);
    }
    for (i = 0; i < RX_CHANNEL_NUM / 2; i++)
    {
        regAddr[regCount] = (u32)(0x040814 + i); 
        regData[regCount++] = (u8)(0x40 + i * 2 + 1);
    }
    regAddr[regCount] = 0x040874; regData[regCount++] = 0x01;
    regAddr[regCount] = 0x040868; regData[regCount++] = 0x01;
    regAddr[regCount] = 0x0408F0; regData[regCount++] = 0x01;

    //Debug.WriteLine("-----------InitialSetting-----------------");
    //for (int i = 0; i < regCount;i++ )
    //{
    //    Debug.WriteLine(string.Format("{0:X6}={1:X2}",regAddr[i],regData[i]));
    //}
    for(i=0; i< regCount; i++){
        ret = icn85xx_prog_i2c_txdata(cts_dev, regAddr[i], &regData[i], 1);
        if(ret)
            return 0;
        udelay(10);
    }

   // if (testConfig.chip.I2cWriteProgModeEx(regAddr, regData, regCount) != 0)
   // {
   //     return false;
   // }
    return 1;
}

int cts_get_adc_data(struct cts_device *cts_dev, u16 *adc_data, int len)
{
    ////////////////////////////////////////////
    u8 ucTemp[4];
    u8 data[128];
    u16 count = 0;
    int i;

    //adc stop
    ucTemp[0] = 0x01;
    if (icn85xx_prog_i2c_txdata(cts_dev, 0x0408ac, ucTemp, 1) != 0)
        return 0;

    ucTemp[0] = 0x0f;
    if (icn85xx_prog_i2c_txdata(cts_dev, 0x040100, ucTemp, 1) != 0)
        return 0;

    ucTemp[0] = 0x07;
    if (icn85xx_prog_i2c_txdata(cts_dev, 0x040100, ucTemp, 1) != 0)
        return 0;

    //adc start
    ucTemp[0] = 0x01;
    if (icn85xx_prog_i2c_txdata(cts_dev, 0x040870, ucTemp, 1) != 0)
        return 0;

    //Thread.Sleep(10);
    msleep(10);

    //poll status,Wait adc data ready
    //uint start = timeGetTime();
    while (1)
    {
        count++;
        if (icn85xx_prog_i2c_rxdata(cts_dev, 0x040870, ucTemp, 1) != 0)
            return 0;

        if ((ucTemp[0] & 0x02) != 0)
            break;

        msleep(1);
        if (count > 1000)
            return 0;
    }

    //adc stop
    ucTemp[0] = 0x01;
    if (icn85xx_prog_i2c_txdata(cts_dev, 0x0408ac, ucTemp, 1) != 0)
        return 0;

    //Read ADC data from SRAM 0x24000.
    if (icn85xx_prog_i2c_rxdata(cts_dev, 0x24000, data, (u32)len * 2) != 0)
        return 0;


    for(i=0;i<len;i++)
    {
        adc_data[i] = (u16)(data[i * 2] + data[i * 2 + 1] * 256);
    }
    return 1;
    
}

 int cts_get_short_resistor_data(struct cts_device *cts_dev, u16 *data, enum adc_data type)
{
     u32 regAddr[128];
     u16 temp_data[RX_CHANNEL_NUM];
     u8 regData[128];
     u8 ucTemp[4] = {0};
     u32 regCount = 0;
     int ret,i;

     switch (type)
     {
         case CHANNEL_OFFSET:
             regCount = 0;
             regAddr[regCount] = 0x040118; regData[regCount++] = 0x00;
             regAddr[regCount] = 0x040119; regData[regCount++] = 0x00;
             regAddr[regCount] = 0x040136; regData[regCount++] = 0x30;
             regAddr[regCount] = 0x0401A0; regData[regCount++] = 0x00;
             regAddr[regCount] = 0x0401A1; regData[regCount++] = 0x00;
             regAddr[regCount] = 0x0401A2; regData[regCount++] = 0x00;
             regAddr[regCount] = 0x0401A3; regData[regCount++] = 0x00;
             regAddr[regCount] = 0x0401A4; regData[regCount++] = 0x00;
             regAddr[regCount] = 0x0401C0; regData[regCount++] = 0x00;
             regAddr[regCount] = 0x0401C1; regData[regCount++] = 0x00;
             regAddr[regCount] = 0x0401C2; regData[regCount++] = 0x00;
             regAddr[regCount] = 0x0401C3; regData[regCount++] = 0x00;

             //Debug.WriteLine(string.Format("-----------{0}-----------------", type.ToString()));
             //for (int i = 0; i < regCount; i++)
             //{
             //    Debug.WriteLine(string.Format("{0:X6}={1:X2}", regAddr[i], regData[i]));
             //}

            // if (icn85xx_prog_i2c_txdata(cts_dev, regAddr, regData, regCount) != 0)
            //     return 0;
             for(i=0; i< regCount; i++){
                ret = icn85xx_prog_i2c_txdata(cts_dev, regAddr[i], &regData[i], 1);
                if(ret)
                    return 0;
                udelay(10);
            }

             if (cts_get_adc_data(cts_dev, data, RX_CHANNEL_NUM) == 0)
                 return 0;

             break;
         case INTERNAL_REFERENCE_RESISTOR:
             regCount = 0;
             regAddr[regCount] = 0x040118; regData[regCount++] = 0x00;
             regAddr[regCount] = 0x040119; regData[regCount++] = 0x00;
             regAddr[regCount] = 0x040136; regData[regCount++] = 0x31;
             regAddr[regCount] = 0x0401A0; regData[regCount++] = 0x00;
             regAddr[regCount] = 0x0401A1; regData[regCount++] = 0x00;
             regAddr[regCount] = 0x0401A2; regData[regCount++] = 0x00;
             regAddr[regCount] = 0x0401A3; regData[regCount++] = 0x00;
             regAddr[regCount] = 0x0401A4; regData[regCount++] = 0x00;
             regAddr[regCount] = 0x0401C0; regData[regCount++] = 0x00;
             regAddr[regCount] = 0x0401C1; regData[regCount++] = 0x00;
             regAddr[regCount] = 0x0401C2; regData[regCount++] = 0x00;
             regAddr[regCount] = 0x0401C3; regData[regCount++] = 0x00;

             //Debug.WriteLine(string.Format("-----------{0}-----------------", type.ToString()));
             //for (int i = 0; i < regCount; i++)
             //{
             //    Debug.WriteLine(string.Format("{0:X6}={1:X2}", regAddr[i], regData[i]));
             //}

            // if (testConfig.chip.I2cWriteProgModeEx(regAddr, regData, regCount) != 0)
            //     return false;
             for(i=0; i< regCount; i++){
                ret = icn85xx_prog_i2c_txdata(cts_dev, regAddr[i], &regData[i], 1);
                if(ret)
                    return 0;
                udelay(10);
            }

             if (cts_get_adc_data(cts_dev, data, RX_CHANNEL_NUM) == 0)
                 return 0;

             break;
         case ODD_RX_TO_GROUND_SHORT_RESISTOR:
             regCount = 0;
             regAddr[regCount] = 0x040118; regData[regCount++] = 0x10;
             regAddr[regCount] = 0x040119; regData[regCount++] = 0x00;
             regAddr[regCount] = 0x040136; regData[regCount++] = 0x30;
             regAddr[regCount] = 0x0401A0; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401A1; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401A2; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401A3; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401A4; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401C0; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401C1; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401C2; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401C3; regData[regCount++] = 0xff;

             //Debug.WriteLine(string.Format("-----------{0}-----------------", type.ToString()));
             //for (int i = 0; i < regCount; i++)
             //{
             //    Debug.WriteLine(string.Format("{0:X6}={1:X2}", regAddr[i], regData[i]));
             //}

             //if (testConfig.chip.I2cWriteProgModeEx(regAddr, regData, regCount) != 0)
             //    return false;
             for(i=0; i< regCount; i++){
                ret = icn85xx_prog_i2c_txdata(cts_dev, regAddr[i], &regData[i], 1);
                if(ret)
                    return 0;
                udelay(10);
             }

             for (i = 0; i < RX_CHANNEL_NUM / 2; i++)
             {
                 //byte[] ucTemp = new byte[4];
                 //Array.Clear(ucTemp, 0, ucTemp.Count());
                 memset(ucTemp,0x00,sizeof(ucTemp));
                 ucTemp[i / 8] = (u8)(1 << (i % 8));
                 if (icn85xx_prog_i2c_txdata(cts_dev, 0x04011c, ucTemp, 3) != 0)
                     return 0;

                 //for (int j = 0; j < 3; j++)
                 //{
                 //    Debug.WriteLine(string.Format("{0:X6}={1:X2}", 0x04011c + j, ucTemp[j]));
                 //}

                 //UInt16[] temp_data = new UInt16[RX_CHANNEL_NUM];
                 if (cts_get_adc_data(cts_dev, temp_data, RX_CHANNEL_NUM) == 0)
                     return 0;

                 data[i * 2] = temp_data[i * 2];
             }

             break;
         case EVEN_RX_TO_GROUND_SHORT_RESISTOR:
             regAddr[regCount] = 0x040118; regData[regCount++] = 0x20;
             regAddr[regCount] = 0x040119; regData[regCount++] = 0x00;
             regAddr[regCount] = 0x040136; regData[regCount++] = 0x30;
             regAddr[regCount] = 0x0401A0; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401A1; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401A2; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401A3; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401A4; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401C0; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401C1; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401C2; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401C3; regData[regCount++] = 0xff;

             //Debug.WriteLine(string.Format("-----------{0}-----------------", type.ToString()));
             //for (int i = 0; i < regCount; i++)
             //{
             //    Debug.WriteLine(string.Format("{0:X6}={1:X2}", regAddr[i], regData[i]));
             //}

             //if (testConfig.chip.I2cWriteProgModeEx(regAddr, regData, regCount) != 0)
             //    return false;
             for(i=0; i< regCount; i++){
                ret = icn85xx_prog_i2c_txdata(cts_dev, regAddr[i], &regData[i], 1);
                if(ret)
                    return 0;
                udelay(10);
             }

             for (i = 0; i < RX_CHANNEL_NUM / 2; i++)
             {
                 //byte[] ucTemp = new byte[4];
                 //Array.Clear(ucTemp, 0, ucTemp.Count());
                memset(ucTemp,0x00,sizeof(ucTemp));

                 ucTemp[i / 8] = (u8)(1 << (i % 8));
                 if (icn85xx_prog_i2c_txdata(cts_dev, 0x04011c, ucTemp, 3) != 0)
                     return 0;

                 //for (int j = 0; j < 3; j++)
                 //{
                 //    Debug.WriteLine(string.Format("{0:X6}={1:X2}", 0x04011c + j, ucTemp[j]));
                 //}

                 //UInt16[] temp_data = new UInt16[RX_CHANNEL_NUM];
                 if (cts_get_adc_data(cts_dev, temp_data, RX_CHANNEL_NUM) == 0)
                     return 0;

                 data[i * 2] = temp_data[i * 2];
             }

             break;
         case ODD_TX_TO_GROUND_SHORT_RESISTOR:
             regAddr[regCount] = 0x040118; regData[regCount++] = 0x00;
             regAddr[regCount] = 0x040119; regData[regCount++] = 0x01;
             regAddr[regCount] = 0x040136; regData[regCount++] = 0x30;
             regAddr[regCount] = 0x0401A0; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401A1; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401A2; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401A3; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401A4; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401C0; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401C1; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401C2; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401C3; regData[regCount++] = 0xff;

             //if (testConfig.chip.I2cWriteProgModeEx(regAddr, regData, regCount) != 0)
             //    return false;
             for(i=0; i< regCount; i++){
                ret = icn85xx_prog_i2c_txdata(cts_dev, regAddr[i], &regData[i], 1);
                if(ret)
                    return 0;
                udelay(10);
             }

             for (i = 0; i < TX_CHANNEL_NUM / 2; i++)
             {
                 //byte[] ucTemp = new byte[4];
                 //Array.Clear(ucTemp, 0, ucTemp.Count());
                memset(ucTemp,0x00,sizeof(ucTemp));
                 ucTemp[i / 8] = (u8)(1 << (i % 8));
                 if (icn85xx_prog_i2c_txdata(cts_dev, 0x04011c, ucTemp, 3) != 0)
                     return 0;

                 //UInt16[] temp_data = new UInt16[TX_CHANNEL_NUM];
                 if (cts_get_adc_data(cts_dev,  temp_data, TX_CHANNEL_NUM) == 0)
                     return 0;

                 data[i * 2] = temp_data[i * 2];
             }

             break;
         case EVEN_TX_TO_GROUND_SHORT_RESISTOR:
             regAddr[regCount] = 0x040118; regData[regCount++] = 0x00;
             regAddr[regCount] = 0x040119; regData[regCount++] = 0x02;
             regAddr[regCount] = 0x040136; regData[regCount++] = 0x30;
             regAddr[regCount] = 0x0401A0; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401A1; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401A2; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401A3; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401A4; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401C0; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401C1; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401C2; regData[regCount++] = 0xff;
             regAddr[regCount] = 0x0401C3; regData[regCount++] = 0xff;

            // if (testConfig.chip.I2cWriteProgModeEx(regAddr, regData, regCount) != 0)
             //    return false;
             for(i=0; i< regCount; i++){
                ret = icn85xx_prog_i2c_txdata(cts_dev, regAddr[i], &regData[i], 1);
                if(ret)
                    return 0;
                udelay(10);
             }

             for (i = 0; i < TX_CHANNEL_NUM / 2; i++)
             {
                // byte[] ucTemp = new byte[4];
               //  Array.Clear(ucTemp, 0, ucTemp.Count());
                 memset(ucTemp,0x00,sizeof(ucTemp));
                 ucTemp[i / 8] = (u8)(1 << (i % 8));
                 if (icn85xx_prog_i2c_txdata(cts_dev, 0x04011c, ucTemp, 3) != 0)
                     return 0;

                // UInt16[] temp_data = new UInt16[TX_CHANNEL_NUM];
                 if (cts_get_adc_data(cts_dev,  temp_data, TX_CHANNEL_NUM) == 0)
                     return 0;

                 data[i * 2] = temp_data[i * 2];
             }

             break;
     }
     return 1;
 }  

 int cts_get_tiny_short_data(struct cts_device *cts_dev, 
    struct tiny_short_config *tiny_short_config)
{
    u16 temp_data[RX_CHANNEL_NUM];
    u16 offset_data[RX_CHANNEL_NUM];
    u16 ref_data[RX_CHANNEL_NUM];
    u16 rx_data[RX_CHANNEL_NUM];
    
    u16 tx_data[TX_CHANNEL_NUM];
    //float rx_registor[RX_CHANNEL_NUM];
    //float tx_registor[TX_CHANNEL_NUM];
   // float a;
    //float b;    
    int a,b;
    int rx_registor[RX_CHANNEL_NUM];
    int tx_registor[TX_CHANNEL_NUM];
    int i;        



    if (cts_tiny_short_test_init(cts_dev) == false)
        return false;

    if (cts_get_short_resistor_data(cts_dev, temp_data, CHANNEL_OFFSET) == false)
        return false;

    for (i = 0; i < RX_CHANNEL_NUM; i += 2)
    {
        offset_data[i] = temp_data[i];
        offset_data[i+1] = temp_data[i];
    }

    if (cts_show_debug_log)
    {
        cts_info("offset_data");
        for (i = 0; i < RX_CHANNEL_NUM; i++)
            cts_info("%d",offset_data[i]);
    }

    //////////////////////////REF DATA
    if (cts_get_short_resistor_data(cts_dev, temp_data, INTERNAL_REFERENCE_RESISTOR) == 0)
        return 0;

    for (i = 0; i < RX_CHANNEL_NUM; i += 2)
    {
        ref_data[i] = temp_data[i];
        ref_data[i + 1] = temp_data[i];
    }

    if (test_debug)
    {
        cts_info("ref_data");
        for (i = 0; i < RX_CHANNEL_NUM; i++)
            cts_info("%d",ref_data[i]);
    }      

    //////////////////////////RX DATA
    if (cts_get_short_resistor_data(cts_dev, temp_data, ODD_RX_TO_GROUND_SHORT_RESISTOR) == 0)
        return 0;
    for (i = 0; i < RX_CHANNEL_NUM; i+=2)
    {
        rx_data[i] = temp_data[i];
    }
    if (cts_get_short_resistor_data(cts_dev, temp_data, EVEN_RX_TO_GROUND_SHORT_RESISTOR) == 0)
        return 0;
    for ( i = 0; i < RX_CHANNEL_NUM; i += 2)
    {
        rx_data[i + 1] = temp_data[i];
    }

    if (test_debug)
    {
        cts_info("rx_data");
        for (i = 0; i < RX_CHANNEL_NUM; i++)
            cts_info("%d",rx_data[i]);
    }

    //////////////////////////TX DATA
    if (cts_get_short_resistor_data(cts_dev, temp_data, ODD_TX_TO_GROUND_SHORT_RESISTOR) == 0)
        return 0;
    for (i = 0; i < TX_CHANNEL_NUM; i += 2)
    {
        tx_data[i] = temp_data[i];
    }
    if (cts_get_short_resistor_data(cts_dev, temp_data, EVEN_TX_TO_GROUND_SHORT_RESISTOR) == 0)
        return 0;
    for (i = 0; i < TX_CHANNEL_NUM; i += 2)
    {
        tx_data[i + 1] = temp_data[i];
    }

    if (test_debug)
    {
        cts_info("tx_data");
        for (i = 0; i < TX_CHANNEL_NUM; i++)
            cts_info("%d",tx_data[i]);
    }

    for (i = 0; i < RX_CHANNEL_NUM; i++)
    {
        //a = (float)fabs((float)ref_data[i] - (float)offset_data[i]);
        //b = (float)fabs((float)rx_data[i] - (float)offset_data[i]);
        a = (int)((ref_data[i] >= offset_data[i])? (ref_data[i]-offset_data[i]):(offset_data[i]-ref_data[i]));
        b = (int)((rx_data[i] >= offset_data[i])? (rx_data[i]-offset_data[i]):(offset_data[i]-rx_data[i]));
        if( b < 1)
            b = 1;
        //rx_registor[i] = (a / b * 2 - 1) * 100;
        rx_registor[i] = (a*100 / b * 2 - 100);
        if(test_debug)
            cts_info("a:%d, b:%d, rx_registor[%d]:%d", a, b, i, rx_registor[i]);
        tiny_short_config->rx_data[i] = (u32)rx_registor[i];
    }

    if (test_debug)
    {
        for ( i = 0; i < RX_CHANNEL_NUM; i++)
        {
            cts_info("RX Resistor: %d ,", tiny_short_config->rx_data[i]);
        }
    }

    for (i = 0; i < TX_CHANNEL_NUM; i++)
    {
        //float a = (float)fabs((float)ref_data[i] - (float)offset_data[i]);
        //float b = (float)fabs((float)tx_data[i] - (float)offset_data[i]);
        a = (int)((ref_data[i] >= offset_data[i])? (ref_data[i]-offset_data[i]):(offset_data[i]-ref_data[i]));
        b = (int)((tx_data[i] >= offset_data[i])? (tx_data[i]-offset_data[i]):(offset_data[i]-tx_data[i]));
        if (b < 1)
            b = 1;
        //tx_registor[i] = (a / b * 2 - 1) * 100;
        tx_registor[i] = (a*100 / b * 2 - 100) ;
        if(test_debug)
            cts_info("a:%d,b:%d,tx_registor[%d]:%d", a, b, i, tx_registor[i]);
        tiny_short_config->tx_data[i] = (u32)tx_registor[i];
    }

    if (test_debug)
    {
        for ( i = 0; i < TX_CHANNEL_NUM; i++)
        {
            cts_info("TX Resistor: %d ,", tiny_short_config->tx_data[i]);
        }
    }

    return 1;
}

int cts_start_tiny_short_test(struct cts_device * cts_dev, char *buf,
        struct tiny_short_config *tiny_short_config)
{
    u8 table[4] = { 3, 2, 1, 0 };
    int index;
    int i;
    u32 th = (u32)(tiny_short_config->tiny_short_threshold);
    
    tiny_short_config->tiny_short_result = true;

    for (i = 0; i < RX_CHANNEL_NUM; i++)
    {
        tiny_short_config->rx_status[i] = 0;
    }
    for (i = 0; i < TX_CHANNEL_NUM; i++)
    {
        tiny_short_config->tx_status[i] = 0;
    }

    if (cts_get_tiny_short_data(cts_dev,tiny_short_config) == 1)
    {
        tiny_short_config->tiny_short_resistor = 0;
        tiny_short_config->short_tx_num = 0;
        tiny_short_config->short_rx_num = 0;
        
        for (i = 0; i < RX_CHANNEL_NUM; i++)
        {
            if (tiny_short_config->rx_data[i] < th)
            {
                tiny_short_config->tiny_short_result  = false;
                tiny_short_config->rx_status[i] = 1;
                if (tiny_short_config->rx_data[i] > tiny_short_config->tiny_short_resistor){
                    tiny_short_config->tiny_short_resistor = (int)tiny_short_config->rx_data[i];
                }
                cts_err("RX  physical index: %d tiny short test fail resistor: %d!!!", i, (int)tiny_short_config->rx_data[i]);
            }
        }

        for (i = 0; i < TX_CHANNEL_NUM; i++)
        {
            if (tiny_short_config->tx_data[i] < th)
            {
                tiny_short_config->tiny_short_result  = false;
                tiny_short_config->tx_status[i] = 1;
                if (tiny_short_config->tx_data[i] > tiny_short_config->tiny_short_resistor){
                    tiny_short_config->tiny_short_resistor = (int)tiny_short_config->tx_data[i];
                }
                cts_err("TX  physical index: %d tiny short test fail resistor: %d!!!",i, (int)tiny_short_config->tx_data[i]);

            }
        }

        for (i = 0; i < RX_CHANNEL_NUM; i++)
        {
            tiny_short_config->rx_logic_data[i] = 0;
            tiny_short_config->rx_logic_status[i] = 0;
        }

        for (i = 0; i < TX_CHANNEL_NUM; i++)
        {
            tiny_short_config->tx_logic_data[i] = 0;
            tiny_short_config->tx_logic_status[i] = 0;
        }

        cts_log.log_cnt += sprintf(buf+cts_log.log_cnt, "short threshold:%d\n",th);
        // rx data
        cts_log.log_cnt += sprintf(buf+cts_log.log_cnt, "rx_logic_data:");
        
        for ( i = 0; i < tiny_short_config->u8col_num; i++)
        {
            tiny_short_config->rx_logic_data[i] = tiny_short_config->rx_data[tiny_short_config->rx_order[i]];
            tiny_short_config->rx_logic_status[i] = tiny_short_config->rx_status[tiny_short_config->rx_order[i]];
            if(tiny_short_config->rx_logic_status[i]){
                tiny_short_config->short_rx_num++;
                cts_err("Logic order: RX%d tiny short test fail resistor: %d !!!", i+1, tiny_short_config->rx_logic_data[i]);
            }
            
            if((i%10) == 0){
                cts_log.log_cnt += sprintf(buf+cts_log.log_cnt, "\n");
            }
            cts_log.log_cnt += sprintf(buf+cts_log.log_cnt, "%-8d", tiny_short_config->rx_logic_data[i]);
        }

        for ( i = 0; i < tiny_short_config->u8col_num; i++){
            if(tiny_short_config->rx_logic_status[i]){
                cts_log.log_cnt += sprintf(buf+cts_log.log_cnt, "\nLogic order: RX%d tiny short test fail resistor: %d !!!\n",
                    i+1, tiny_short_config->rx_logic_data[i]);
            }
        }
        // tx data
        cts_log.log_cnt += sprintf(buf+cts_log.log_cnt, "\ntx_logic_data:");
        
        for ( i = 0; i < tiny_short_config->u8row_num; i++)
        {
            if (tiny_short_config->tx_order[i] > TX_CHANNEL_NUM - 2)
            {
                table[0] = 3;
                table[1] = 2;
                table[2] = 1;
                table[3] = 0;
                index = (RX_CHANNEL_NUM - 4) + table[(tiny_short_config->tx_order[i] - (TX_CHANNEL_NUM - 1))];
                tiny_short_config->tx_logic_data[i] = tiny_short_config->rx_data[index];
                tiny_short_config->tx_logic_status[i] = tiny_short_config->rx_status[index];
            }
            else
            {
                tiny_short_config->tx_logic_data[i] = tiny_short_config->tx_data[tiny_short_config->tx_order[i]];
                tiny_short_config->tx_logic_status[i] = tiny_short_config->tx_status[tiny_short_config->tx_order[i]];
            }
            if(tiny_short_config->tx_logic_status[i]){
                tiny_short_config->short_tx_num++;
                cts_err("Logic order: TX%d tiny short test fail resistor: %d !!!", i+1, tiny_short_config->tx_logic_data[i]);
            }
            
            if((i%10) == 0){
                cts_log.log_cnt += sprintf(buf+cts_log.log_cnt, "\n");
            }
            cts_log.log_cnt += sprintf(buf+cts_log.log_cnt, "%-8d", tiny_short_config->tx_logic_data[i]);

        }

        for ( i = 0; i < tiny_short_config->u8row_num; i++){
            if(tiny_short_config->tx_logic_status[i]){
                cts_log.log_cnt += sprintf(buf+cts_log.log_cnt, "\nLogic order: TX%d tiny short test fail resistor: %d !!!",
                    i+1, tiny_short_config->tx_logic_data[i]);
            }
        }
        cts_log.log_cnt += sprintf(buf+cts_log.log_cnt, "\n");

    }else{
        tiny_short_config->tiny_short_result = false;
        return -1;
    }

    return 0;
}

int cts_rawdata_alu(struct cts_device *cts_dev, char *buf, s16 *rawdata, u16 *threshold_min, 
        u16 *threshold_max, u8 is_open_test)
{
#define RAWDATA_BUFFER_SIZE(cts_dev) \
    (cts_dev->fwdata.rows * cts_dev->fwdata.cols * 2)

    s16 *result = NULL;
    int i,j,ret=0;
    u16 ng_num = 0;
   // u16 *th_min, *th_max;
    u16 count = 0;

    cts_info("rawdata process");
    result = (s16 *)kmalloc(RAWDATA_BUFFER_SIZE(cts_dev), GFP_KERNEL);
    if (result == NULL) {
        cts_err("Allocate memory for rawdata failed");
        return -1;
    }
#if 0
    if(is_open_test){
        th_min = threshold_min;
        th_max = 0xffff;
    }else{
        th_min = threshold_min;
        th_max = threshold_max;
    }
#endif
    cts_info("th_min:%d, th_max: %d",threshold_min[0],threshold_max[0]);
    count += sprintf(buf+count, "th_min:%d, th_max: %d\n",threshold_min[0],threshold_max[0]);
    for(i=0; i<cts_dev->fwdata.rows; i++){
        for(j=0; j<cts_dev->fwdata.cols; j++){
            if((rawdata[i*cts_dev->fwdata.cols + j] < threshold_min[i*cts_dev->fwdata.cols + j])
                ||(rawdata[i*cts_dev->fwdata.cols + j] > threshold_max[i*cts_dev->fwdata.cols + j])){
                result[i*cts_dev->fwdata.cols + j] = 1;
                ng_num++;
                cts_err("Test node:[TX%d,RX%d]:%d FAIL",i+1,j+1,rawdata[i*cts_dev->fwdata.cols + j]);
            }
            count += sprintf(buf+count, "%-6d", rawdata[i*cts_dev->fwdata.cols + j]);
        }
        count += sprintf(buf+count, "\n");
    }
    
    //open test: result save as format: tx[rows]+rx[cols]
    if(is_open_test && ng_num){
        // tx open test...
        cts_info("TX open test");
        count += sprintf(buf+count, "TX open test...\n");
        for(i=0; i<cts_dev->fwdata.rows; i++){
            result[i] = 0;
            for(j=0; j<cts_dev->fwdata.cols; j++){
                if((rawdata[i*cts_dev->fwdata.cols + j] < threshold_min[i*cts_dev->fwdata.cols + j])
                    ||(rawdata[i*cts_dev->fwdata.cols + j] > threshold_max[i*cts_dev->fwdata.cols + j])){
                    result[i]++;
                }
                if(j==cts_dev->fwdata.cols-1){
                    if(result[i] == cts_dev->fwdata.cols){
                        result[i] = 1;
                        ret++;
                        cts_err("TX%d open test fail",i+1);
                        count += sprintf(buf+count, "TX%d open test fail\n",i+1);
                    }else{
                        result[i] = 0;
                    }
                }
            }
        }
        // rx open test...
        cts_info("RX open test");
        count += sprintf(buf+count, "RX open test...\n");
        for(j=0; j<cts_dev->fwdata.cols; j++){
            result[cts_dev->fwdata.rows + j] = 0;
            for(i=0; i<cts_dev->fwdata.rows; i++){
                if((rawdata[i*cts_dev->fwdata.cols + j] < threshold_min[i*cts_dev->fwdata.cols + j])
                    ||(rawdata[i*cts_dev->fwdata.cols + j] > threshold_max[i*cts_dev->fwdata.cols + j])){
                    result[cts_dev->fwdata.rows + j]++;
                }
                if(i==cts_dev->fwdata.rows-1){
                    if(result[cts_dev->fwdata.rows + j] == cts_dev->fwdata.rows){
                        result[cts_dev->fwdata.rows + j] = 1;
                        ret++;
                        cts_err("RX%d open test fail",j+1);
                        count += sprintf(buf+count, "RX%d open test fail\n",j+1);
                    }else{
                        result[cts_dev->fwdata.rows + j] = 0;
                    }
                }
            }
        }
    }else{
        //rawdata test
        ret =  ng_num;
    }
    cts_log.log_cnt += count;
    
    kfree(result);

    return ret;
#undef RAWDATA_BUFFER_SIZE
}
int cts_open_prepare(struct cts_device *cts_dev)
{
	u8 cmd;
	int i;
	int ret;
	
	cts_info("open prepare");

	//scan mode
	cmd = 0;
	ret = cts_fw_reg_writeb_retry(cts_dev, CTS_DEVICE_FW_REG_SCAN_MODE, cmd, 2, 1);
	if (ret) {
            cts_err("set scan mode failed %d", ret);
     }
	
	cmd = 0x01;
	ret = cts_fw_reg_writeb_retry(cts_dev, CTS_DEVICE_FW_REG_WORK_MODE, cmd, 2, 1);
	if (ret) {
            cts_err("set factory mode failed %d", ret);
     }
	
	for (i = 0; i < 50; i++) {
        u8 ready;
        mdelay(10);
        ret = cts_fw_reg_readb_retry(cts_dev,
                    CTS_DEVICE_FW_REG_SYSTEM_BUSY, &ready, 3, 1);
        if (ret) {
            cts_err("Get system busy flag failed %d", ret);
            return ret;
        }
        if (ready == 0) 
            break;
        else
			cts_info("system busy flag= %d %d", ready);
    }

	if(i >= 400)
		return -ENODEV;
	
	cts_info("goto factory mode success");
	return ret;
}

/* Return 0 success 
          negative value while error occurs
          positive value means how many nodes fail */
int cts_rawdata_process(struct cts_device *cts_dev,  char *buf,
        u16 *threshold_min, u16 *threshold_max, u8 is_open_test)
{
#define RAWDATA_BUFFER_SIZE(cts_dev) \
    (cts_dev->fwdata.rows * cts_dev->fwdata.cols * 2)
    
    s16 *rawdata = NULL;
    //u8 row_index[128]={0};
    //u8 col_index[128]={0};

    int  ret;

    cts_info("cts rawdata process");

    rawdata = (s16 *)kmalloc(RAWDATA_BUFFER_SIZE(cts_dev), GFP_KERNEL);
    if (rawdata == NULL) {
        cts_err("Allocate memory for rawdata failed");
        return -ENOMEM;
    }
    cts_stop_device(cts_dev);
    cts_dev->rtdata.testing = true;

    ret = cts_enable_get_rawdata(cts_dev);
    if (ret) {
        cts_err("Enable read raw data failed %d", ret);
        goto err_free_rawdata;
    }

    ret = cts_send_command(cts_dev, CTS_CMD_QUIT_GESTURE_MONITOR);
    if (ret) {
        cts_err("Send cmd QUIT_GESTURE_MONITOR failed %d", ret);
        goto err_free_rawdata;
    }
    msleep(50);

    ret = cts_get_rawdata(cts_dev, rawdata);
    if(ret) {
        cts_err("Get raw data failed %d", ret);
        // Fall through to disable get rawdata
    }
    ret = cts_disable_get_rawdata(cts_dev);
    if (ret) {
        cts_err("Disable read raw data failed %d", ret);
        // Fall through to show rawdata
    }

    ret = cts_rawdata_alu(cts_dev, buf, rawdata, threshold_min, threshold_max, is_open_test);
    
 err_free_rawdata:
    kfree(rawdata);
    cts_dev->rtdata.testing = false;
    cts_start_device(cts_dev);

    return ret;
    
#undef RAWDATA_BUFFER_SIZE

}


int cts_parse_test_para(char *test_config,  char *name, u16 *th)
{
    char *item_name;
    char *item_value;
    char *temp_ptr;
    char temp[128];
    u16 value;
    int count = 0;
    u16 len;
    int ret;
    
    item_name = strstr(test_config, name);
    if(item_name){
        len = strlen(name);
        cts_info("parse para name: %s len: %d",name,len);
        if(len > sizeof(temp)){
            cts_info("parse para name too long!!! len: %d",len);
            return false;
        }
        
        item_value = strchr(item_name, '=');//item_name + len +1; 
        if(item_value == NULL){
            cts_err("parse para value not found");
            return false;
        }
        
        item_value += 1;
        count = 0;
        while(item_value[count] !='\r' 
                    && item_value[count] !='\n'
                    && item_value[count] !='\0'){
            count++;
        }
        if(count >= sizeof(temp)){
            cts_info("parse para value too long!!! len: %d",count);
            return false;
        }

        temp_ptr = strncpy((char*)&temp[0], item_value, count);
        temp_ptr[count] = '\0';
        temp_ptr = strim(temp);
        
        cts_info("parse para value :%s count: %d",temp_ptr,count);
        
        if(isdigit(temp_ptr[0])){
            ret = kstrtou16(temp_ptr, 0, &value);
            cts_info("parse para:%s = %d [0x%x]", name, value, value);
            if(ret){
                cts_err("parse para value error!!!");
                return false;
            }
            *th = value;
            return true;
        }else{
            cts_err("parse para value invalid:%c",temp_ptr[0]);
        }
    }else{
        cts_err("parse para : %s not found in config file", name);
    }

    return false;
}

int cts_fw_version_test( struct cts_device * cts_dev, u16 fw_ver)
{
    u16 version;
    int ret;
    char *buf = NULL;
    
    cts_info("cts firmware version test");
    
   // cts_info("request log memery size: %d", PAGE_SIZE);
    buf = (char*)kzalloc(PAGE_SIZE, GFP_KERNEL);
    if(buf == NULL){
        cts_err("allocate memery for firmware version test log fail");
        return -ENOMEM;
    }
    cts_log.log_cnt = 0;
    cts_log.log_cnt += sprintf(buf, "\nStart firmware version test...\n"); 

    ret = cts_get_firmware_version(cts_dev, &version);
    if(ret){
        cts_err("cts firmware version test error");
        cts_log.log_cnt += sprintf(buf + cts_log.log_cnt, "cts firmware version test error\n"); 
#if FACTORY_TEST_RESULT_TO_SDCARD
        cts_test_save_log(cts_dev, CTS_TEST_LOG_PATH, buf);
#else
        print_test_log(buf);
#endif
        kfree(buf);
        return ret;
    }
    if(fw_ver ==  version){
        cts_info("cts firmware version: 0x%x test PASS",version);
        cts_log.log_cnt += sprintf(buf + cts_log.log_cnt, "cts firmware version: 0x%x test PASS\n",version); 
#if FACTORY_TEST_RESULT_TO_SDCARD   
        cts_test_save_log(cts_dev, CTS_TEST_LOG_PATH, buf);
#else
        print_test_log(buf);
#endif
        kfree(buf);
        return 0;
    }else{
        cts_info("cts firmware version test FAIL");
        cts_log.log_cnt += sprintf(buf + cts_log.log_cnt,
                                        "cts firmware current version: 0x%x!= 0x%x test FAIL\n",version,fw_ver); 
#if FACTORY_TEST_RESULT_TO_SDCARD                                           
        cts_test_save_log(cts_dev, CTS_TEST_LOG_PATH, buf);
#else
        print_test_log(buf);
#endif
        kfree(buf);
        return -1;
    }
}
 
/* Return 0 success 
          negative value while error occurs
          positive value means how many nodes fail */
int cts_short_test(struct cts_device *cts_dev, u16 threshold)
{
    int  ret;
    int  err_num = 0;
    char *buf = NULL;
    struct tiny_short_config *tiny_short_config = NULL;
    
    cts_info("cts short test");
    cts_stop_device(cts_dev);

    cts_dev->rtdata.testing = true;
    tiny_short_config = (struct tiny_short_config *)kzalloc(sizeof(*tiny_short_config), GFP_KERNEL);
    if (tiny_short_config == NULL) {
        cts_err("Allocate tiny_short_config failed");
        return -ENOMEM;
    }
    
   // cts_info("request short test log memery size: %d", PAGE_SIZE);
    buf = (char*)kzalloc(PAGE_SIZE, GFP_KERNEL);
    if(buf == NULL){
        cts_err("allocate memery for short test log fail");
        return -ENOMEM;
    }
    
    tiny_short_config->u8row_num = cts_dev->fwdata.rows;
    tiny_short_config->u8col_num = cts_dev->fwdata.cols;
    tiny_short_config->tiny_short_threshold = threshold;
    tiny_short_config->tiny_short_result = false;
    
    ret = cts_get_para_rx_order(cts_dev, tiny_short_config->rx_order);
    if(ret){
        cts_err("get para rx order fail");
    }
    ret = cts_get_para_tx_order(cts_dev, tiny_short_config->tx_order);
    if(ret){
        cts_err("get para tx order fail");
    }

    cts_enter_program_mode(cts_dev);

    cts_log.log_cnt = 0;
    cts_log.log_cnt += sprintf(buf+cts_log.log_cnt, "\nStart cts short test...\n");
    
    ret = cts_start_tiny_short_test(cts_dev, buf,tiny_short_config);
    err_num = tiny_short_config->short_tx_num + tiny_short_config->short_rx_num;
    
    if(ret){
        cts_info("!!! Cts short test error !!!");
        cts_log.log_cnt += sprintf(buf+cts_log.log_cnt, "!!! Cts short test error !!!\n");
        ret = -1;
    }else{
        if(tiny_short_config->tiny_short_result){
            cts_info("Cts short test PASS !");
            cts_log.log_cnt += sprintf(buf+cts_log.log_cnt, "!!! Cts short test PASS !!!\n");
            ret = 0;
        }else{
            cts_info("!!! Cts short test Fail  !!!");
            cts_log.log_cnt += sprintf(buf+cts_log.log_cnt, "!!! Cts short test Fail !!!\n");
            ret = err_num;
        }
    }
#if FACTORY_TEST_RESULT_TO_SDCARD
    cts_test_save_log(cts_dev,CTS_TEST_LOG_PATH,buf);
#else
        print_test_log(buf);
#endif
    kfree(buf);
    
    cts_dev->rtdata.testing = false;

    cts_plat_reset_device(cts_dev->pdata);

    cts_enter_normal_mode(cts_dev);

    cts_start_device(cts_dev);
    
    kfree(tiny_short_config);

    return ret;
    
}

/* Return 0 success 
          negative value while error occurs
          positive value means how many nodes fail */

int cts_rawdata_test(struct cts_device *cts_dev, u16* th_min, u16* th_max)
{
    int ret;
    char *buf = NULL;
    //u16 count = 0;
    
    cts_info("cts rawdata test");

   // cts_info("request rawdata test log memery size: %d", PAGE_SIZE);
    buf = (char*)kzalloc(PAGE_SIZE, GFP_KERNEL);
    if(buf == NULL){
        cts_err("allocate memery for rawdata test log fail");
        return -ENOMEM;
    }
    
    cts_log.log_cnt = 0;
    cts_log.log_cnt += sprintf(buf, "\nStart rawdata test...\n"); 

    ret = cts_rawdata_process(cts_dev, buf+cts_log.log_cnt, th_min, th_max, 0);
    if(ret < 0){
        cts_info("!!! Cts rawdata test error !!!");
        sprintf(buf+cts_log.log_cnt,"!!! Cts rawdata test error !!!\n");
    }else if(ret > 0){
        cts_info("!!! Cts rawdata test FAIL  !!!");
        sprintf(buf+cts_log.log_cnt,"!!! Cts rawdata test FAIL !!!\n");
    }else{
        cts_info("!!! Cts rawdata test PASS  !!!");
        sprintf(buf+cts_log.log_cnt,"!!! Cts rawdata test PASS !!!\n");
    }
#if FACTORY_TEST_RESULT_TO_SDCARD
    cts_test_save_log(cts_dev,CTS_TEST_LOG_PATH,buf);
#else
        print_test_log(buf);
#endif
    kfree(buf);
    return ret;
}

/* Return 0 success 
          negative value while error occurs
          positive value means how many nodes fail */

int cts_open_test(struct cts_device *cts_dev, u16 *th_min, u16 *th_max)
{
    int ret;
    char *buf = NULL;
    //u16 count = 0;
    
    cts_info("cts open test");
    
  //  cts_info("request log memery size: %d", PAGE_SIZE);
    buf = (char*)kzalloc(PAGE_SIZE, GFP_KERNEL);
    if(buf == NULL){
        cts_err("allocate memery for open test log fail");
        return -ENOMEM;
    }
    cts_log.log_cnt = 0;
    cts_log.log_cnt += sprintf(buf, "\nStart open test...\n"); 

	ret = cts_open_prepare(cts_dev);
	if(ret){
		cts_err("!!! Cts open test prepare error !!!");
		}
	
    ret = cts_rawdata_process(cts_dev, buf+cts_log.log_cnt, th_min, th_max, 1);
    if(ret < 0){
        cts_info("!!! Cts open test error !!!");
        sprintf(buf+cts_log.log_cnt,"!!! Cts open test error !!!\n");
    }else if(ret > 0){
        cts_info("!!! Cts open test FAIL  !!!");
        sprintf(buf+cts_log.log_cnt,"!!! Cts open test FAIL !!!\n");
    }else{
        cts_info("!!! Cts open test PASS  !!!");
        sprintf(buf+cts_log.log_cnt,"!!! Cts open test PASS !!!\n");
    }
	cts_plat_reset_device(cts_dev->pdata);
#if FACTORY_TEST_RESULT_TO_SDCARD
    cts_test_save_log(cts_dev, CTS_TEST_LOG_PATH, buf);
#else
        print_test_log(buf);
#endif
    kfree(buf);
    return ret;
}

int cts_test(struct cts_device *cts_dev, const char *filepath)
{
#define CTS_TEST_PASS   \
    "*********************************************\
    \n****************!!!PASSED!!!****************\
    \n*********************************************"
 #define CTS_TEST_FAIL   \
    "*********************************************\
    \n****************!!!FAILED!!!****************\
    \n*********************************************"
   
    struct file *file=NULL;
 //   char* test_config;
 //   u16 th;
 //   u16 size;
	u16 test_node;
//    int i ;
    int  ret;
    char *pass = CTS_TEST_PASS;
    char *fail = CTS_TEST_FAIL;
    char *buf = NULL;
//	loff_t pos = 0;
	
    cts_info("Cts test");
    
    cts_stop_device(cts_dev);
    cts_dev->rtdata.testing = true;

	test_node = cts_dev->fwdata.rows * cts_dev->fwdata.cols;
#if 0
    if(filepath == NULL){
        test_config = cts_test_config_data;
        cts_info("Use cts test configure bultin driver");
    }else{
        cts_info("Open cts test cfg file '%s'", filepath);
        file = filp_open(filepath, O_RDONLY, 0);
        if (IS_ERR(file)) {
            cts_err("Open file '%s' failed %ld", filepath, PTR_ERR(file));
            return -1;
        }
      
        test_config = (char*)kzalloc(1024, GFP_KERNEL);
        if (test_config == NULL) {
            cts_err("Allocate test_config memery failed");
            goto cts_cfg_file_err;
            return -ENOMEM;
        }
        
        size = file_inode(file)->i_size;
        if(size <=0 && size > 1024){
            cts_err("Cts test config file invalid");
            goto cts_cfg_file_err;
        }
		pos = 0;
#if LINUX_VERSION_CODE >= KERNEL_VERSION(4,14,0)
    ret = kernel_read(file, buf, size, &pos);
#else
    ret = kernel_read(file, pos, buf, size);
#endif
    if (ret < 0) {
        cts_err("Read version from offset failed");
        goto cts_cfg_file_err;
		}
    }

    cts_info("cts_test_config:\n%s",test_config);
    
    for(i=0; i<ARRAY_SIZE(cts_test_items); i++){
        cts_info("cts test item[----step %d----] : %s", i, cts_test_items[i].item_name);
        ret = cts_parse_test_para(test_config, cts_test_items[i].item_name, &th);
        if(ret){
            cts_test_items[i].need_test = true;
        }else{
            cts_test_items[i].need_test = false;
        }

        if(cts_test_items[i].need_test){
            if(cts_test_items[i].para.para1){
                ret = cts_parse_test_para(test_config, cts_test_items[i].para.para1, &th);
                if(ret){
                   cts_test_items[i].para.threshold1 = th;
                   cts_info("Get test item para1: %s threshold1 = %d [0x%x]",cts_test_items[i].item_name, th,th);
                }else{
                    cts_err("Get test item para1: %s error!!! ",cts_test_items[i].item_name);
                    continue;
                }
            }
            if(cts_test_items[i].para.para2){
                ret = cts_parse_test_para(test_config, cts_test_items[i].para.para2, &th);
                if(ret){
                   cts_test_items[i].para.threshold2 = th;
                   cts_info("Get test item para2: %s threshold2 = %d [0x%x]",cts_test_items[i].item_name, th,th);
                }else{
                    cts_err("Get test item para2: %s error!!! ",cts_test_items[i].item_name);
                    continue;
                }
            }

            cts_test_items[i].result = cts_test_items[i].cts_test_fun(cts_dev, 
                cts_test_items[i].para.threshold1, cts_test_items[i].para.threshold2);
        }
        cts_info(" ");
    }
#endif

	if(cts_test_items[0].need_test){   // fw version test
        cts_test_items[0].result = cts_fw_version_test(cts_dev, TARGET_FW_VERSION);
    }

	if(cts_test_items[1].need_test){   // short test
        cts_test_items[1].result = cts_short_test(cts_dev, SHORT_TEST_TH);
    }

	if(cts_test_items[2].need_test){   // open test
		if( test_node > sizeof(open_rawdata_min) / sizeof(open_rawdata_min[0])
			|| test_node > sizeof(open_rawdata_max) / sizeof(open_rawdata_max[0]))
		{
			cts_err("rawdata threshod config error,rows = %d,cols = %d,arraysize_min = %d, arraysize_max = %d", cts_dev->fwdata.rows, 
					cts_dev->fwdata.cols, sizeof(open_rawdata_min) / sizeof(open_rawdata_min[0]), sizeof(open_rawdata_max) / sizeof(open_rawdata_max[0]));
			cts_test_items[3].result = 1;
		} else {
			cts_test_items[3].result = cts_open_test(cts_dev, open_rawdata_min, open_rawdata_max);
		}
    }

	if(cts_test_items[3].need_test){   // rawdata test
		if(test_node > sizeof(rawdata_test_min) / sizeof(rawdata_test_min[0])
			|| test_node > sizeof(rawdata_test_max) / sizeof(rawdata_test_max[0]))
		{
			cts_err("rawdata threshod config error,rows = %d,cols = %d,arraysize_min = %d, arraysize_max = %d", cts_dev->fwdata.rows, 
					cts_dev->fwdata.cols, sizeof(rawdata_test_min) / sizeof(rawdata_test_min[0]), sizeof(rawdata_test_max) / sizeof(rawdata_test_max[0]));
			cts_test_items[3].result = 1;
		} else {
			cts_test_items[3].result = cts_rawdata_test(cts_dev, rawdata_test_min, rawdata_test_max);
		}
    }

	ret = cts_test_items[0].result || cts_test_items[1].result 
		|| cts_test_items[2].result || cts_test_items[3].result;
    if(ret){
		cts_info(CTS_TEST_FAIL);
        buf = fail;
        
    }else{
        cts_info(CTS_TEST_PASS);
        buf = pass;
    }
#if FACTORY_TEST_RESULT_TO_SDCARD
    cts_test_save_log(cts_dev, CTS_TEST_LOG_PATH, buf);
#else
        print_test_log(buf);
#endif
    if(filepath != NULL){
      //  kfree(test_config);
        ret = filp_close(file, NULL);
        if (ret) {
            cts_warn("Close file '%s' failed %d", filepath, ret);
        }
    }

    cts_dev->rtdata.testing = false;

    cts_plat_reset_device(cts_dev->pdata);

    cts_enter_normal_mode(cts_dev);

    cts_start_device(cts_dev);

    return ret;

#if 0
cts_cfg_file_err:
        
    kfree(test_config);
//allocate_test_cfg_err:
    ret = filp_close(file, NULL);
    if (ret) {
        cts_warn("Close file '%s' failed %d", filepath, ret);
    }
    return -ENOMEM;
#endif
 #undef CTS_TEST_PASS
 #undef CTS_TEST_FAIL
}

#ifdef CTS_TOUCH_FACTORY_TEST
static ssize_t cts_test_read(struct file *file,
        char __user *buffer, size_t count, loff_t *ppos)
{
//	struct chipone_ts_data *cts_data;
	int ret = 0;
	if (*ppos) {
		return 0;
	}
	cts_info("cts_test_read");
#ifdef SUPPORT_TEST_CFG_FILE
    ret = cts_test(&g_cts_data->cts_dev, CTS_TEST_CFG_FILE_PATH);
#else
    ret = cts_test(&g_cts_data->cts_dev, NULL);
#endif
	if(ret){
		ret = copy_to_user(buffer, "FAIL\n", 5);
	}else{
		ret = copy_to_user(buffer, "Pass\n", 5);
	}
	*ppos += 5;
	return 5;
}

static ssize_t cts_test_write(struct file *file,
				const char __user * buffer, size_t count, loff_t * ppos)
{
	int ret  = 0;
	cts_info("cts_test_write");
    return ret;
}


static struct file_operations cts_factory_test_fops = {
    .owner = THIS_MODULE,
    .read  = cts_test_read,
    .write = cts_test_write,
};

int cts_factory_init(struct chipone_ts_data *cts_data)
{
    int ret = 0;

    cts_info("cts_factory Init");

    cts_data->proc_test_entry = proc_create_data(CFG_CTS_FACTORY_TEST_FILENAME,
            0666, NULL, &cts_factory_test_fops, cts_data);
    if (IS_ERR(cts_data->proc_test_entry)) {
        cts_err("Create proc test entry failed %ld",
            PTR_ERR(cts_data->proc_test_entry));
        cts_data->proc_test_entry = NULL;
    }
    return ret;
}

void cts_factory_deinit(struct chipone_ts_data *data)
{
    cts_info("cts_factory Deinit");

    if (data->proc_test_entry) {
        remove_proc_entry(CFG_CTS_FACTORY_TEST_FILENAME, NULL);
    }
}

#endif 

