#include "platform.h"

/**************************************************************************************************/
//chip ic 5472 firmware code bin
/**************************************************************************************************/
#if TYPE_OF_IC(SEMI_TOUCH_IC) == TYPE_OF_IC(SEMI_TOUCH_5472)
#if (SEMI_TOUCH_ONLINE_UPDATE_EN || SEMI_TOUCH_BOOTUP_UPDATE_EN || SEMI_TOUCH_APK_NODE_EN)
static const unsigned char fw_burn_mcapshare[] = {
    0x37,0x02,0x00,0x20,0x13,0x02,0x02,0x02,0xB7,0x82,0x00,0x40,0x93,0x82,0x82,0x00,
    0x23,0xA0,0x02,0x00,0x02,0x82,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x73,0x70,0x04,0x30,
    0x81,0x42,0x37,0x13,0x00,0x40,0x13,0x03,0x83,0x05,0x23,0x20,0x53,0x00,0x81,0x42,
    0x37,0xF3,0x00,0xE0,0x23,0x20,0x53,0x00,0x17,0x41,0x00,0x00,0x13,0x01,0x81,0x1B,
    0x17,0x15,0x00,0x00,0x13,0x05,0x85,0xCC,0x97,0x45,0x00,0x00,0x93,0x85,0x85,0xFA,
    0x17,0x46,0x00,0x00,0x13,0x06,0x06,0xFA,0x63,0xFA,0xC5,0x00,0x83,0x22,0x05,0x00,
    0x23,0xA0,0x55,0x00,0x11,0x05,0x91,0x05,0xE3,0xEA,0xC5,0xFE,0x17,0x45,0x00,0x00,
    0x13,0x05,0x45,0xF8,0x97,0x45,0x00,0x00,0x93,0x85,0x85,0x18,0x63,0x77,0xB5,0x00,
    0x23,0x20,0x05,0x00,0x11,0x05,0xE3,0x6D,0xB5,0xFE,0xEF,0x00,0xE0,0x5B,0x01,0xA0,
    0x93,0x17,0x15,0x00,0x3E,0x95,0x06,0x05,0x11,0xC5,0x81,0x47,0x01,0x00,0x85,0x07,
    0xE3,0x1E,0xF5,0xFE,0x82,0x80,0x15,0xC1,0x51,0x11,0x06,0xC4,0x22,0xC2,0x26,0xC0,
    0xAA,0x84,0x01,0x44,0x13,0x05,0x80,0x3E,0xE1,0x3F,0x05,0x04,0xE3,0x9C,0x84,0xFE,
    0xA2,0x40,0x12,0x44,0x82,0x44,0x31,0x01,0x82,0x80,0x82,0x80,0x09,0x86,0x63,0x5C,
    0xC0,0x00,0x0A,0x06,0x2A,0x96,0x91,0x05,0x11,0x05,0x83,0xA7,0xC5,0xFF,0x23,0x2E,
    0xF5,0xFE,0xE3,0x1A,0xA6,0xFE,0x82,0x80,0x63,0x59,0xC0,0x00,0x81,0x47,0x11,0x05,
    0x23,0x2E,0xB5,0xFE,0x85,0x07,0xE3,0x1C,0xF6,0xFE,0x82,0x80,0x9D,0xC9,0x81,0x47,
    0x81,0x46,0x01,0x46,0x33,0x07,0xF5,0x00,0x03,0x47,0x07,0x00,0x3A,0x96,0x42,0x06,
    0x41,0x82,0x33,0x07,0xF7,0x02,0x36,0x97,0x93,0x16,0x07,0x01,0xC1,0x82,0x85,0x07,
    0x13,0x97,0x07,0x01,0x41,0x83,0xE3,0x6F,0xB7,0xFC,0xC2,0x06,0x33,0xE5,0xC6,0x00,
    0x82,0x80,0xAE,0x86,0x2E,0x86,0xD5,0xBF,0x85,0x81,0x95,0xC1,0xAA,0x87,0xFD,0x15,
    0xC2,0x05,0xC1,0x81,0x86,0x05,0x09,0x05,0x33,0x87,0xA5,0x00,0x81,0x45,0x03,0xD5,
    0x07,0x00,0xAA,0x95,0xC2,0x05,0xC1,0x81,0x89,0x07,0xE3,0x9A,0xE7,0xFE,0x2E,0x85,
    0x82,0x80,0x37,0x47,0x00,0x20,0x83,0x26,0x07,0x21,0xFD,0x77,0x93,0x87,0x27,0x9A,
    0x23,0x91,0xF6,0x00,0x83,0x27,0x07,0x21,0x05,0x67,0x13,0x07,0xD7,0x65,0x23,0x92,
    0xE7,0x00,0x37,0x47,0x00,0x20,0x03,0x27,0x07,0x20,0x23,0x93,0xE7,0x00,0x23,0x94,
    0x07,0x00,0x37,0x47,0x00,0x20,0x03,0x27,0x47,0x20,0x23,0x95,0xE7,0x00,0x23,0x96,
    0x07,0x00,0x23,0x87,0x07,0x00,0x82,0x80,0x41,0x11,0x06,0xC6,0x22,0xC4,0x26,0xC2,
    0xB7,0x47,0x00,0x20,0x03,0xA7,0x47,0x21,0x83,0x57,0x67,0x00,0x83,0x56,0x27,0x00,
    0xB3,0x86,0xF6,0x02,0x7D,0x76,0xF1,0x8E,0x36,0xC0,0x83,0x54,0x47,0x00,0xB3,0x87,
    0xF4,0x02,0x93,0xD4,0xF7,0x41,0xD2,0x04,0xD1,0x80,0xBE,0x94,0xB1,0x84,0x81,0xCC,
    0x01,0x44,0x02,0x45,0xEF,0x00,0x90,0x1D,0x82,0x47,0x05,0x67,0xBA,0x97,0x3E,0xC0,
    0x05,0x04,0xE3,0x98,0x84,0xFE,0xB7,0x47,0x00,0x20,0x83,0xA7,0x07,0x21,0x23,0x87,
    0x07,0x00,0xB2,0x40,0x22,0x44,0x92,0x44,0x41,0x01,0x82,0x80,0x31,0x11,0x06,0xC8,
    0x22,0xC6,0x26,0xC4,0xB7,0x47,0x00,0x20,0x83,0xA7,0x47,0x21,0x83,0xD4,0x47,0x00,
    0x03,0xD7,0xC7,0x00,0x3A,0xC0,0x03,0xD7,0x27,0x00,0x3A,0xC2,0x03,0xD4,0xA7,0x00,
    0x13,0x17,0x04,0x01,0x03,0xD4,0x67,0x00,0x3A,0x94,0xA6,0x85,0x37,0x85,0x00,0x20,
    0x75,0x3D,0x63,0x0E,0xA4,0x00,0xB7,0x47,0x00,0x20,0x83,0xA7,0x07,0x21,0x0D,0x47,
    0x23,0x87,0xE7,0x00,0xC2,0x40,0x32,0x44,0xA2,0x44,0x51,0x01,0x82,0x80,0xB7,0x47,
    0x00,0x20,0x03,0xA7,0x07,0x21,0x95,0x67,0x93,0x87,0x37,0x50,0x23,0x16,0xF7,0x00,
    0x93,0x07,0x00,0x40,0x63,0xEF,0x97,0x02,0x82,0x47,0x13,0x94,0x07,0x01,0x92,0x47,
    0x3E,0x94,0x93,0x17,0x44,0x01,0x95,0xCB,0x93,0x87,0xF4,0xFF,0xA2,0x97,0xA1,0x8F,
    0x7D,0x77,0xF9,0x8F,0x9D,0xE7,0x37,0x86,0x00,0x20,0xA2,0x85,0x26,0x85,0xEF,0x00,
    0x00,0x75,0x1D,0xE5,0xB7,0x47,0x00,0x20,0x83,0xA7,0x07,0x21,0x23,0x87,0x07,0x00,
    0x55,0xB7,0x95,0x47,0x23,0x07,0xF7,0x00,0x71,0xBF,0x22,0x85,0xEF,0x00,0x10,0x10,
    0xE1,0xB7,0xFD,0x77,0xE1,0x8F,0x05,0x65,0x3E,0x95,0xEF,0x00,0x30,0x0F,0xE1,0xB7,
    0xB7,0x47,0x00,0x20,0x83,0xA7,0x07,0x21,0x25,0x47,0x23,0x87,0xE7,0x00,0x9D,0xBF,
    0x51,0x11,0x06,0xC4,0x22,0xC2,0x26,0xC0,0xB7,0x47,0x00,0x20,0x03,0xA7,0x47,0x21,
    0x83,0x54,0x47,0x00,0x83,0x57,0xC7,0x00,0xC2,0x07,0x83,0x55,0x27,0x00,0x37,0x84,
    0x00,0x20,0x13,0x06,0x04,0x40,0xBE,0x95,0x26,0x85,0xEF,0x00,0x50,0x09,0xA6,0x85,
    0x13,0x05,0x04,0x40,0xE5,0x33,0xB7,0x47,0x00,0x20,0x03,0xA7,0x07,0x21,0x23,0x11,
    0xA7,0x00,0x83,0xA7,0x07,0x21,0x41,0x81,0x23,0x92,0xA7,0x00,0x23,0x87,0x07,0x00,
    0xA2,0x40,0x12,0x44,0x82,0x44,0x31,0x01,0x82,0x80,0x51,0x11,0x06,0xC4,0x29,0x2D,
    0xB7,0x47,0x00,0x20,0x83,0xA7,0x07,0x21,0x23,0x87,0x07,0x00,0xA2,0x40,0x31,0x01,
    0x82,0x80,0x99,0xC9,0x81,0x47,0x33,0x07,0xF5,0x00,0x14,0x43,0x33,0x07,0xF6,0x00,
    0x14,0xC3,0x91,0x07,0xE3,0xE9,0xB7,0xFE,0x82,0x80,0x89,0xCD,0xB2,0x95,0xB2,0x87,
    0x11,0x8D,0x33,0x07,0xF5,0x00,0x03,0x47,0x07,0x00,0x23,0x80,0xE7,0x00,0x85,0x07,
    0xE3,0x99,0xB7,0xFE,0x82,0x80,0x21,0x11,0x06,0xCA,0x22,0xC8,0x26,0xC6,0x2A,0xC4,
    0x02,0xC2,0x81,0x44,0x01,0x44,0x89,0xA8,0xB7,0x47,0x00,0x20,0x13,0x86,0xC7,0x21,
    0x82,0x45,0x12,0x45,0x7D,0x37,0xA2,0x46,0xA1,0xCA,0x12,0x47,0x81,0x46,0xB7,0x47,
    0x00,0x20,0x13,0x86,0xC7,0x21,0x92,0x47,0xB3,0x07,0xF7,0x40,0xB2,0x97,0x83,0xC7,
    0x07,0x00,0x3E,0x94,0x42,0x04,0x41,0x80,0xB3,0x87,0xE7,0x02,0xBE,0x94,0xC2,0x04,
    0xC1,0x80,0x85,0x06,0x05,0x07,0x82,0x47,0xE3,0xEF,0xF6,0xFC,0xA2,0x47,0x82,0x46,
    0x95,0x8F,0x3E,0xC4,0x91,0xCB,0x3A,0xC2,0x22,0x47,0x3A,0xC0,0x93,0x07,0x00,0x40,
    0xE3,0xF4,0xE7,0xFA,0x3E,0xC0,0x4D,0xB7,0x13,0x95,0x04,0x01,0x41,0x8D,0xD2,0x40,
    0x42,0x44,0xB2,0x44,0x61,0x01,0x82,0x80,0x03,0x27,0x00,0x00,0xB7,0x47,0x00,0x20,
    0x23,0x8E,0xE7,0x20,0x93,0x56,0x87,0x00,0xA3,0x8E,0xD7,0x20,0x93,0x56,0x07,0x01,
    0x23,0x8F,0xD7,0x20,0x93,0x56,0x87,0x01,0xA3,0x8F,0xD7,0x20,0x03,0x26,0x40,0x00,
    0x93,0x87,0xC7,0x21,0x23,0x82,0xC7,0x00,0x93,0x56,0x86,0x00,0xA3,0x82,0xD7,0x00,
    0x93,0x56,0x06,0x01,0x23,0x83,0xD7,0x00,0x93,0x56,0x86,0x01,0xA3,0x83,0xD7,0x00,
    0x83,0x26,0x80,0x00,0x23,0x84,0xD7,0x00,0x93,0xD5,0x86,0x00,0xA3,0x84,0xB7,0x00,
    0x93,0xD5,0x06,0x01,0x23,0x85,0xB7,0x00,0xE1,0x82,0xA3,0x85,0xD7,0x00,0x71,0x8F,
    0xFD,0x57,0x63,0x02,0xF7,0x08,0x41,0x11,0x06,0xC6,0x22,0xC4,0x26,0xC2,0x03,0x27,
    0x00,0x03,0xB7,0x47,0x00,0x20,0x93,0x87,0xC7,0x21,0x23,0x88,0xE7,0x02,0x93,0x56,
    0x87,0x00,0xA3,0x88,0xD7,0x02,0x93,0x56,0x07,0x01,0x23,0x89,0xD7,0x02,0x93,0x56,
    0x87,0x01,0xA3,0x89,0xD7,0x02,0x03,0x24,0x40,0x03,0x23,0x8A,0x87,0x02,0x93,0x56,
    0x84,0x00,0xA3,0x8A,0xD7,0x02,0x93,0x56,0x04,0x01,0x23,0x8B,0xD7,0x02,0x93,0x56,
    0x84,0x01,0xA3,0x8B,0xD7,0x02,0x42,0x07,0x41,0x83,0x95,0x67,0x93,0x87,0x27,0x47,
    0x63,0x17,0xF7,0x00,0x93,0x04,0xC4,0xFF,0xC1,0x67,0x63,0xE6,0xF4,0x02,0xB7,0x47,
    0x00,0x20,0x83,0xA7,0x07,0x21,0x45,0x47,0x23,0x87,0xE7,0x00,0xB2,0x40,0x22,0x44,
    0x92,0x44,0x41,0x01,0x82,0x80,0xB7,0x47,0x00,0x20,0x83,0xA7,0x07,0x21,0x21,0x47,
    0x23,0x87,0xE7,0x00,0x82,0x80,0x26,0x85,0xBD,0x3D,0x2A,0xC0,0x37,0x86,0x00,0x20,
    0x13,0x06,0x06,0x40,0xA1,0x45,0x26,0x85,0x89,0x3D,0x83,0x27,0xC4,0xFF,0x02,0x47,
    0x63,0x0A,0xF7,0x00,0xB7,0x47,0x00,0x20,0x83,0xA7,0x07,0x21,0x0D,0x47,0x23,0x87,
    0xE7,0x00,0x6D,0xBF,0xB7,0x47,0x00,0x20,0x83,0xA7,0x07,0x21,0x23,0x87,0x07,0x00,
    0x75,0xB7,0x51,0x11,0x06,0xC4,0x22,0xC2,0xB7,0x47,0x00,0x20,0x83,0xA7,0x07,0x21,
    0x25,0x47,0x23,0x87,0xE7,0x00,0xC1,0x45,0xB7,0x47,0x00,0x20,0x03,0xA5,0x47,0x21,
    0xE1,0x3E,0x3D,0xE1,0xB7,0x47,0x00,0x20,0x83,0xA7,0x47,0x21,0x83,0xC7,0xE7,0x00,
    0x13,0x07,0x00,0x03,0x63,0x8F,0xE7,0x02,0x13,0x07,0x10,0x03,0x63,0x83,0xE7,0x02,
    0x13,0x07,0x30,0x03,0x63,0x81,0xE7,0x02,0x13,0x07,0x40,0x03,0x63,0x8F,0xE7,0x00,
    0x05,0x47,0x63,0x8E,0xE7,0x00,0x13,0x07,0x20,0x03,0x63,0x9F,0xE7,0x02,0x95,0x47,
    0x11,0xA8,0x85,0x47,0x01,0xA8,0x89,0x47,0x31,0xA0,0x8D,0x47,0x21,0xA0,0x91,0x47,
    0x11,0xA0,0x81,0x47,0x13,0x97,0x37,0x00,0xB7,0x17,0x00,0x20,0x93,0x87,0x87,0xCE,
    0xBA,0x97,0xDC,0x43,0x82,0x97,0x09,0xA8,0xB7,0x47,0x00,0x20,0x83,0xA7,0x07,0x21,
    0x13,0x07,0x10,0x05,0x23,0x87,0xE7,0x00,0x37,0x44,0x00,0x20,0x03,0x25,0x04,0x21,
    0xB7,0x47,0x00,0x20,0x83,0xA7,0x47,0x21,0x83,0xC7,0xE7,0x00,0xA3,0x07,0xF5,0x00,
    0xB9,0x45,0x09,0x05,0x91,0x36,0x83,0x27,0x04,0x21,0x33,0x05,0xA0,0x40,0x23,0x90,
    0xA7,0x00,0xA2,0x40,0x12,0x44,0x31,0x01,0x82,0x80,0xB7,0x07,0x00,0x20,0x03,0xC7,
    0xF7,0x00,0x93,0x07,0x90,0x0E,0x63,0x03,0xF7,0x00,0x82,0x80,0x51,0x11,0x06,0xC4,
    0x22,0xC2,0x41,0x46,0xB7,0x05,0x00,0x20,0x37,0x94,0x00,0x20,0x13,0x05,0x04,0xC0,
    0x71,0x3C,0x01,0x3F,0x41,0x46,0x93,0x05,0x04,0xD0,0x37,0x05,0x00,0x20,0x79,0x34,
    0xA2,0x40,0x12,0x44,0x31,0x01,0x82,0x80,0x51,0x11,0x06,0xC4,0x22,0xC2,0x26,0xC0,
    0xB7,0x87,0x00,0x40,0x13,0x07,0xA0,0x05,0xD8,0xC7,0xB7,0x17,0x00,0x40,0x37,0x17,
    0x10,0x00,0x09,0x07,0xD8,0xCB,0x23,0xA8,0x07,0x04,0x41,0x47,0xF8,0xCB,0xB7,0x07,
    0x00,0x20,0x37,0x47,0x00,0x20,0x23,0x2C,0xF7,0x20,0x37,0x47,0x00,0x20,0x23,0x26,
    0xF7,0x20,0x37,0x94,0x00,0x20,0x93,0x04,0x04,0xC0,0xB7,0x47,0x00,0x20,0x23,0xAA,
    0x97,0x20,0x13,0x04,0x04,0xD0,0xB7,0x47,0x00,0x20,0x23,0xA8,0x87,0x20,0x21,0x46,
    0x81,0x45,0x37,0x05,0x00,0x20,0x89,0x34,0x21,0x46,0x81,0x45,0x26,0x85,0x2D,0x3C,
    0x21,0x46,0x81,0x45,0x22,0x85,0x0D,0x3C,0x35,0x23,0x81,0x3F,0xFD,0xBF,0x51,0x11,
    0x06,0xC4,0x22,0xC2,0x26,0xC0,0x1D,0x64,0x13,0x04,0x04,0x53,0x01,0x47,0xB7,0x14,
    0x00,0x40,0x01,0xA8,0x05,0x07,0x21,0xA0,0x29,0x45,0x5D,0x3A,0x01,0x47,0x7D,0x14,
    0x09,0xCC,0x9C,0x40,0xE3,0xDA,0x07,0xFE,0x8D,0x47,0xE3,0xF5,0xE7,0xFE,0x05,0x45,
    0xA2,0x40,0x12,0x44,0x82,0x44,0x31,0x01,0x82,0x80,0x01,0x45,0xD5,0xBF,0x51,0x11,
    0x06,0xC4,0x22,0xC2,0x26,0xC0,0x2A,0x84,0x5D,0x3F,0x85,0x47,0x63,0x1C,0xF5,0x04,
    0xB7,0x17,0x00,0x40,0x23,0xA8,0x87,0x08,0x13,0x64,0x14,0x00,0x23,0xA8,0x87,0x08,
    0x83,0xA7,0x07,0x09,0x89,0x8B,0x85,0xC7,0x05,0x45,0x9D,0x32,0x09,0x64,0x13,0x04,
    0xE4,0x70,0xB7,0x14,0x00,0x40,0x83,0xA7,0x04,0x09,0x89,0x8B,0x81,0xCB,0x05,0x45,
    0x81,0x3A,0x7D,0x14,0xFD,0x57,0xE3,0x18,0xF4,0xFE,0x11,0xA0,0x11,0xCC,0x85,0x3F,
    0x7D,0x15,0x33,0x35,0xA0,0x00,0x33,0x05,0xA0,0x40,0xA2,0x40,0x12,0x44,0x82,0x44,
    0x31,0x01,0x82,0x80,0x7D,0x55,0xD5,0xBF,0x7D,0x55,0xC5,0xBF,0x51,0x11,0x06,0xC4,
    0x22,0xC2,0x26,0xC0,0x2E,0x84,0xB2,0x84,0x93,0x87,0xF5,0xFF,0xD2,0x07,0x37,0x07,
    0x70,0x00,0xF9,0x8F,0x62,0x05,0xC9,0x8F,0x37,0x05,0x80,0x00,0x5D,0x8D,0x85,0x3F,
    0x1D,0xE1,0xB7,0x17,0x00,0x40,0x83,0xA7,0x07,0x0A,0x9C,0xC0,0x91,0x47,0x63,0xF7,
    0x87,0x00,0xB7,0x17,0x00,0x40,0x83,0xA7,0x47,0x0A,0xDC,0xC0,0xA2,0x40,0x12,0x44,
    0x82,0x44,0x31,0x01,0x82,0x80,0x7D,0x55,0xD5,0xBF,0x41,0x11,0x06,0xC6,0x22,0xC4,
    0xFD,0x3D,0x85,0x47,0x63,0x1A,0xF5,0x02,0x29,0x45,0xF1,0x38,0x02,0xC0,0x1D,0x64,
    0x13,0x04,0x04,0x53,0x13,0x05,0x40,0x1F,0x65,0x38,0x0A,0x86,0x85,0x45,0x15,0x45,
    0x71,0x37,0x02,0x45,0x05,0x89,0x19,0xC1,0x7D,0x14,0x6D,0xF4,0x33,0x05,0xA0,0x40,
    0xB2,0x40,0x22,0x44,0x41,0x01,0x82,0x80,0x7D,0x55,0xDD,0xBF,0x93,0x87,0xF5,0xFF,
    0xAA,0x97,0xA9,0x8F,0x93,0xF7,0x07,0xF0,0xA1,0xEB,0x51,0x11,0x06,0xC4,0xB3,0x67,
    0xB5,0x00,0x8D,0x8B,0x95,0xC3,0xB3,0x06,0xB6,0x00,0x11,0x8D,0x91,0xC9,0x03,0x47,
    0x06,0x00,0xB3,0x07,0xC5,0x00,0x23,0x80,0xE7,0x00,0x05,0x06,0xE3,0x19,0xD6,0xFE,
    0x69,0x37,0xA2,0x40,0x31,0x01,0x82,0x80,0x89,0x81,0x89,0xCD,0x8A,0x05,0xB3,0x07,
    0xB6,0x00,0x32,0x87,0x11,0x8D,0x10,0x43,0xB3,0x06,0xE5,0x00,0x90,0xC2,0x11,0x07,
    0xE3,0x1B,0xF7,0xFE,0x9D,0x37,0xF1,0xBF,0x79,0x55,0x82,0x80,0x51,0x11,0x06,0xC4,
    0x22,0xC2,0x93,0x87,0xF5,0xFF,0x1D,0x47,0x63,0x6C,0xF7,0x02,0x14,0x42,0x37,0x17,
    0x00,0x40,0x23,0x24,0xD7,0x0A,0x11,0x47,0x63,0x77,0xB7,0x00,0x54,0x42,0x37,0x17,
    0x00,0x40,0x23,0x26,0xD7,0x0A,0xB2,0x07,0x62,0x05,0xC9,0x8F,0x21,0x65,0x5D,0x8D,
    0xBD,0x35,0x2A,0x84,0x1D,0x37,0x22,0x85,0xA2,0x40,0x12,0x44,0x31,0x01,0x82,0x80,
    0x7D,0x54,0xD5,0xBF,0x51,0x11,0x06,0xC4,0x62,0x05,0x91,0x3D,0xA2,0x40,0x31,0x01,
    0x82,0x80,0x51,0x11,0x06,0xC4,0x62,0x05,0xB7,0x17,0x00,0x40,0x23,0xAA,0xB7,0x08,
    0xB7,0x07,0x0A,0x00,0x5D,0x8D,0x25,0x3D,0xA2,0x40,0x31,0x01,0x82,0x80,0x51,0x11,
    0x06,0xC4,0x22,0xC2,0xB7,0x47,0x00,0x20,0x03,0xA7,0x07,0x20,0x91,0x67,0x93,0x87,
    0x57,0x08,0x63,0x00,0xF7,0x02,0x99,0x67,0x93,0x87,0x87,0x0C,0x63,0x01,0xF7,0x04,
    0xB7,0x17,0x00,0x40,0x23,0xAC,0x07,0x04,0x01,0x45,0xA2,0x40,0x12,0x44,0x31,0x01,
    0x82,0x80,0xB7,0x47,0x00,0x20,0x83,0xA7,0x47,0x20,0x13,0xF7,0xC7,0x07,0x6D,0xD7,
    0x37,0x44,0x00,0x20,0x13,0x04,0x04,0x20,0x93,0xF7,0x07,0xF8,0x5C,0xC0,0x19,0x45,
    0x51,0x37,0x13,0x06,0x44,0x00,0x89,0x45,0x05,0x45,0x0D,0x3F,0xD1,0xB7,0xB7,0x47,
    0x00,0x20,0x83,0xA7,0x47,0x20,0x13,0xF7,0xC7,0x01,0x5D,0xDF,0x37,0x44,0x00,0x20,
    0x13,0x04,0x04,0x20,0x81,0x9B,0x5C,0xC0,0x19,0x45,0xA9,0x3F,0x13,0x06,0x44,0x00,
    0x85,0x45,0x05,0x45,0x21,0x37,0x69,0xBF,0x51,0x11,0x06,0xC4,0x22,0xC2,0xB7,0x47,
    0x00,0x20,0x03,0xA7,0x07,0x20,0x91,0x67,0x93,0x87,0x57,0x08,0x63,0x00,0xF7,0x02,
    0x99,0x67,0x93,0x87,0x87,0x0C,0x63,0x04,0xF7,0x04,0xB7,0x17,0x00,0x40,0x09,0x47,
    0xB8,0xCF,0x01,0x45,0xA2,0x40,0x12,0x44,0x31,0x01,0x82,0x80,0xB7,0x47,0x00,0x20,
    0x83,0xA7,0x47,0x20,0x93,0xF6,0xC7,0x07,0x13,0x07,0xC0,0x07,0xE3,0x8F,0xE6,0xFC,
    0x37,0x44,0x00,0x20,0x13,0x04,0x04,0x20,0x93,0xE7,0xF7,0x07,0x5C,0xC0,0x19,0x45,
    0xD5,0x3D,0x13,0x06,0x44,0x00,0x85,0x45,0x05,0x45,0x4D,0x35,0x7D,0xBF,0xB7,0x47,
    0x00,0x20,0x83,0xA7,0x47,0x20,0x93,0xF6,0xC7,0x01,0x71,0x47,0xE3,0x87,0xE6,0xFA,
    0x37,0x44,0x00,0x20,0x13,0x04,0x04,0x20,0x93,0xE7,0xF7,0x01,0x5C,0xC0,0x19,0x45,
    0xD1,0x35,0x13,0x06,0x44,0x00,0x85,0x45,0x05,0x45,0x8D,0x3D,0x79,0xB7,0x01,0x11,
    0x06,0xCE,0x22,0xCC,0x26,0xCA,0xAA,0x84,0x2A,0xC6,0x2E,0xC4,0x32,0x84,0x32,0xC8,
    0x7D,0x39,0x85,0x47,0x63,0x16,0xF5,0x0C,0xE1,0xCC,0x22,0xC2,0xA2,0x47,0x3E,0xC0,
    0x25,0xA0,0x12,0x46,0xA2,0x85,0x02,0x45,0xD5,0x33,0x15,0xE9,0x12,0x46,0xA2,0x85,
    0x02,0x45,0xE9,0x3B,0x0D,0xE5,0x92,0x47,0x33,0x87,0x87,0x00,0x3A,0xC2,0x82,0x47,
    0xA2,0x97,0x3E,0xC0,0x81,0x8C,0xCD,0xC4,0x82,0x47,0x13,0xF4,0xF7,0x0F,0x93,0x07,
    0x00,0x10,0x33,0x84,0x87,0x40,0xE3,0xF6,0x84,0xFC,0x26,0x84,0xD9,0xB7,0xB5,0x33,
    0xD1,0xE0,0xA2,0x47,0x13,0xF5,0x37,0x00,0x71,0xC9,0x22,0x46,0x03,0x47,0x06,0x00,
    0xB7,0x47,0x00,0x20,0x23,0x8E,0xE7,0x20,0x83,0x46,0x16,0x00,0x93,0x87,0xC7,0x21,
    0xA3,0x80,0xD7,0x00,0x83,0x46,0x26,0x00,0x23,0x81,0xD7,0x00,0x91,0x47,0x33,0x85,
    0xA7,0x40,0xB2,0x47,0x63,0xF3,0xA7,0x00,0x3E,0x85,0xC2,0x46,0x83,0xC7,0x06,0x00,
    0x63,0x94,0xE7,0x04,0x37,0x47,0x00,0x20,0x13,0x07,0xC7,0x21,0x93,0x87,0x16,0x00,
    0xB3,0x85,0xA6,0x00,0x63,0x8B,0xB7,0x06,0x03,0x46,0x17,0x00,0x83,0xC6,0x07,0x00,
    0x05,0x07,0x85,0x07,0xE3,0x08,0xD6,0xFE,0x7D,0x55,0x31,0xA0,0x01,0x45,0xB2,0x47,
    0xD1,0xEF,0x11,0xA0,0x01,0x45,0xF2,0x40,0x62,0x44,0xD2,0x44,0x05,0x61,0x82,0x80,
    0x71,0x55,0xD5,0xBF,0x7D,0x55,0xC5,0xBF,0x7D,0x55,0xF5,0xB7,0x7D,0x55,0xE5,0xB7,
    0xE9,0x39,0xA2,0x47,0x8D,0x8B,0xB9,0xC3,0x91,0x46,0x9D,0x8E,0xA2,0x45,0x03,0xC7,
    0x05,0x00,0xB7,0x47,0x00,0x20,0x23,0x8E,0xE7,0x20,0x03,0xC6,0x15,0x00,0x93,0x87,
    0xC7,0x21,0xA3,0x80,0xC7,0x00,0x03,0xC6,0x25,0x00,0x23,0x81,0xC7,0x00,0xB2,0x47,
    0x3E,0x85,0x63,0xF3,0xF6,0x00,0x36,0x85,0x2D,0xF9,0xC2,0x47,0xAA,0x97,0x3E,0xC8,
    0xA2,0x47,0xAA,0x97,0x3E,0xC4,0xB2,0x47,0x89,0x8F,0x3E,0xC6,0x32,0x47,0x93,0x55,
    0x27,0x00,0x8D,0x47,0xE3,0xF4,0xE7,0xF8,0xB7,0x47,0x00,0x20,0x13,0x86,0xC7,0x21,
    0x93,0x87,0xC7,0x21,0x01,0x47,0xA2,0x46,0x33,0x86,0xC6,0x40,0xB3,0x06,0xF6,0x00,
    0x94,0x42,0x94,0xC3,0x05,0x07,0x91,0x07,0xE3,0x6A,0xB7,0xFE,0xB7,0x47,0x00,0x20,
    0x03,0xC7,0xC7,0x21,0xC2,0x46,0x83,0xC7,0x06,0x00,0xE3,0x19,0xF7,0xF6,0xB7,0x47,
    0x00,0x20,0x93,0x87,0xD7,0x21,0x13,0x87,0x16,0x00,0xB7,0x45,0x00,0x20,0x93,0x85,
    0xC5,0x21,0xB2,0x46,0xB6,0x95,0xE3,0x8F,0xB7,0xF2,0x03,0xC6,0x07,0x00,0x83,0x46,
    0x07,0x00,0x85,0x07,0x05,0x07,0xE3,0x08,0xD6,0xFE,0x7D,0x55,0x2D,0xB7,0x09,0xCD,
    0x32,0x95,0xB2,0x87,0x91,0x8D,0x33,0x87,0xF5,0x00,0x03,0x47,0x07,0x00,0x23,0x80,
    0xE7,0x00,0x85,0x07,0xE3,0x99,0xA7,0xFE,0x01,0x45,0x82,0x80,0x51,0x11,0x06,0xC4,
    0x22,0xC2,0x2A,0x84,0x29,0x33,0xD5,0x3E,0x19,0x45,0xE9,0x39,0xA2,0x85,0x13,0x05,
    0x00,0x02,0xC5,0x31,0x79,0x45,0xEF,0xF0,0x0F,0xCD,0xC5,0x36,0xA2,0x40,0x12,0x44,
    0x31,0x01,0x82,0x80,0x41,0x11,0x06,0xC6,0x22,0xC4,0x26,0xC2,0x37,0x46,0x00,0x20,
    0x13,0x06,0x06,0x20,0x8D,0x45,0x13,0x05,0xF0,0x09,0x8D,0x3E,0x3D,0xE1,0x37,0x46,
    0x00,0x20,0x13,0x06,0x06,0x20,0x83,0x57,0x06,0x00,0x1C,0xC2,0x11,0x06,0x85,0x45,
    0x15,0x45,0xA9,0x3E,0x2A,0x84,0x45,0xED,0xB7,0x47,0x00,0x20,0x93,0x87,0x07,0x20,
    0x03,0xC7,0x47,0x00,0xD8,0xC3,0x98,0x43,0x91,0x67,0x93,0x87,0x57,0x08,0x63,0x00,
    0xF7,0x04,0xB7,0x47,0x00,0x20,0x03,0xC7,0x87,0x20,0x89,0x47,0x63,0x01,0xF7,0x08,
    0x37,0x17,0x00,0x40,0xB7,0x07,0x01,0x08,0x93,0x87,0xB7,0x03,0x5C,0xC3,0xB7,0x17,
    0x00,0x40,0x23,0xAC,0x07,0x04,0x22,0x85,0xB2,0x40,0x22,0x44,0x92,0x44,0x41,0x01,
    0x82,0x80,0xB7,0x47,0x00,0x20,0x23,0xA0,0x07,0x20,0x7D,0x54,0xED,0xB7,0x0A,0x86,
    0x85,0x45,0x13,0x05,0x50,0x03,0xDD,0x3C,0x29,0xED,0x82,0x47,0xA2,0x07,0x41,0x67,
    0x7D,0x17,0xF9,0x8F,0x3E,0xC0,0x37,0x47,0x00,0x20,0x13,0x07,0x07,0x20,0x54,0x43,
    0xD5,0x8F,0x5C,0xC3,0x13,0xF7,0x07,0x20,0x49,0xFF,0xB7,0x44,0x00,0x20,0x93,0x84,
    0x04,0x20,0x09,0x47,0x23,0x84,0xE4,0x00,0x93,0xE7,0x07,0x20,0xDC,0xC0,0x19,0x45,
    0xD5,0x3E,0x13,0x86,0x44,0x00,0x89,0x45,0x05,0x45,0x4D,0x36,0x9D,0xBF,0x37,0x17,
    0x00,0x40,0xB7,0x07,0x02,0x08,0x93,0x87,0xB7,0x06,0x5C,0xC3,0x49,0xB7,0x7D,0x54,
    0x59,0xB7,0x7D,0x54,0x49,0xB7,0x00,0x00,0x30,0x00,0x00,0x00,0x1C,0x02,0x00,0x20,
    0x31,0x00,0x00,0x00,0xF0,0x02,0x00,0x20,0x33,0x00,0x00,0x00,0x18,0x04,0x00,0x20,
    0x34,0x00,0x00,0x00,0x4A,0x03,0x00,0x20,0x01,0x00,0x00,0x00,0x72,0x01,0x00,0x20,
    0x32,0x00,0x00,0x00,0xB8,0x01,0x00,0x20,
};
#else
static const unsigned char fw_burn_mcapshare[] = {

};
#endif

#if (SEMI_TOUCH_APK_NODE_EN)
static const unsigned char fw_short_mcapshare[] = {
    0x37,0x02,0x00,0x20,0x13,0x02,0x02,0x02,0xb7,0x82,0x00,0x40,0x93,0x82,0x82,0x00,
    0x23,0xa0,0x02,0x00,0x02,0x82,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x73,0x70,0x04,0x30,
    0x97,0x82,0x00,0x00,0x93,0x82,0x02,0x05,0x93,0xe2,0x32,0x00,0x73,0x90,0x52,0x30,
    0x97,0x82,0x00,0x00,0x93,0x82,0x02,0xfc,0x73,0x90,0x72,0x30,0x17,0x91,0x00,0x00,
    0x13,0x01,0x81,0x91,0x17,0x15,0x00,0x00,0x13,0x05,0x85,0x9a,0x97,0x85,0x00,0x00,
    0x93,0x85,0x45,0xfa,0x17,0x86,0x00,0x00,0x13,0x06,0xe6,0x0f,0x63,0xfa,0xc5,0x00,
    0x83,0x22,0x05,0x00,0x23,0xa0,0x55,0x00,0x11,0x05,0x91,0x05,0xe3,0xea,0xc5,0xfe,
    0x17,0x85,0x00,0x00,0x13,0x05,0x45,0x0e,0x97,0x95,0x00,0x00,0x93,0x85,0xc5,0x50,
    0x63,0x77,0xb5,0x00,0x23,0x20,0x05,0x00,0x11,0x05,0xe3,0x6d,0xb5,0xfe,0xef,0x00,
    0x60,0x00,0x01,0xa0,0x51,0x11,0x06,0xc4,0x22,0xc2,0x37,0x04,0x00,0x20,0xb7,0x07,
    0x00,0x54,0x1c,0xc0,0xb7,0x87,0x00,0x40,0x13,0x07,0xa0,0x05,0xd8,0xc7,0x98,0x43,
    0xe1,0x76,0x93,0x86,0xf6,0xcf,0x75,0x8f,0x98,0xc3,0x1d,0x2a,0xb7,0x97,0x00,0x20,
    0x93,0x87,0x87,0xaf,0x5c,0xc0,0x8d,0x25,0xe1,0x25,0x73,0x60,0x04,0x30,0xef,0x00,
    0x10,0x08,0xf5,0xbf,0x21,0x11,0x06,0xca,0x22,0xc8,0x26,0xc6,0xb1,0xc5,0x2e,0xc4,
    0x2a,0xc2,0x01,0x44,0x02,0xc0,0x81,0x44,0x92,0x47,0xa2,0x97,0x03,0xc5,0x07,0x00,
    0xaa,0x94,0xc2,0x04,0xc1,0x80,0xa2,0x85,0xef,0x00,0xd0,0x0d,0x82,0x47,0x3e,0x95,
    0x93,0x17,0x05,0x01,0xc1,0x83,0x3e,0xc0,0x05,0x04,0x93,0x17,0x04,0x01,0xc1,0x83,
    0x22,0x47,0xe3,0xeb,0xe7,0xfc,0x82,0x47,0x13,0x95,0x07,0x01,0x45,0x8d,0xd2,0x40,
    0x42,0x44,0xb2,0x44,0x61,0x01,0x82,0x80,0x2e,0xc0,0xae,0x84,0xed,0xb7,0xb3,0xe7,
    0xc5,0x00,0xc9,0x8f,0x8d,0x8b,0x8d,0xc3,0x33,0x07,0xc5,0x00,0x2e,0x96,0xaa,0x87,
    0x63,0x7b,0xe5,0x00,0x85,0x05,0x85,0x07,0x03,0xc7,0xf5,0xff,0xa3,0x8f,0xe7,0xfe,
    0xe3,0x9a,0xc5,0xfe,0x82,0x80,0x82,0x80,0x2a,0x96,0xe3,0x7d,0xc5,0xfe,0xaa,0x87,
    0x91,0x05,0x91,0x07,0x03,0xa7,0xc5,0xff,0x23,0xae,0xe7,0xfe,0xe3,0xea,0xc7,0xfe,
    0x82,0x80,0xb3,0x67,0xc5,0x00,0x8d,0x8b,0x81,0xcf,0x2a,0x96,0xaa,0x87,0x63,0x78,
    0xc5,0x00,0x85,0x07,0xa3,0x8f,0xb7,0xfe,0xe3,0x9d,0xc7,0xfe,0x82,0x80,0x82,0x80,
    0x93,0xf5,0xf5,0x0f,0x93,0x97,0x85,0x00,0xcd,0x8f,0x93,0x95,0x07,0x01,0xdd,0x8d,
    0x2a,0x96,0xe3,0x75,0xc5,0xfe,0xaa,0x87,0x91,0x07,0x23,0xae,0xb7,0xfe,0xe3,0xed,
    0xc7,0xfe,0x82,0x80,0x93,0x17,0x15,0x00,0x3e,0x95,0x06,0x05,0x11,0xc5,0x81,0x47,
    0x01,0x00,0x85,0x07,0xe3,0x1e,0xf5,0xfe,0x82,0x80,0x15,0xc1,0x51,0x11,0x06,0xc4,
    0x22,0xc2,0x26,0xc0,0xaa,0x84,0x01,0x44,0x13,0x05,0x80,0x3e,0xe1,0x3f,0x05,0x04,
    0xe3,0x9c,0x84,0xfe,0xa2,0x40,0x12,0x44,0x82,0x44,0x31,0x01,0x82,0x80,0x82,0x80,
    0xb7,0xe7,0x00,0xe0,0x93,0x87,0x07,0x10,0x05,0x67,0xba,0x97,0x11,0x47,0x23,0x80,
    0xe7,0xb0,0xb7,0x96,0x00,0x20,0x93,0x86,0x46,0xa6,0x01,0x47,0xb7,0xe5,0x00,0xe0,
    0x93,0x85,0x05,0x10,0x85,0x62,0x7d,0x43,0x37,0x86,0x00,0x20,0x13,0x06,0x06,0x08,
    0x13,0x05,0x40,0x02,0xb3,0x87,0xe5,0x00,0x23,0x80,0x07,0x40,0x23,0x80,0x07,0x00,
    0x96,0x97,0x23,0x80,0x67,0x80,0x90,0xc2,0x05,0x07,0x91,0x06,0xe3,0x14,0xa7,0xfe,
    0xb7,0xe7,0x00,0xe0,0x93,0x87,0x07,0x10,0x05,0x67,0xba,0x97,0x7d,0x57,0x23,0x88,
    0xe7,0x80,0x82,0x80,0x93,0x07,0x30,0x02,0x63,0xe9,0xa7,0x00,0x0a,0x05,0xb7,0x97,
    0x00,0x20,0x93,0x87,0x47,0xa6,0x3e,0x95,0x0c,0xc1,0x82,0x80,0x93,0x07,0x30,0x02,
    0x63,0xed,0xa7,0x00,0xb7,0xe7,0x00,0xe0,0x93,0x87,0x07,0x10,0x3e,0x95,0x83,0x47,
    0x05,0x40,0x93,0xe7,0x17,0x00,0x23,0x00,0xf5,0x40,0x82,0x80,0x93,0x07,0x30,0x02,
    0x63,0xed,0xa7,0x00,0xb7,0xe7,0x00,0xe0,0x93,0x87,0x07,0x10,0x3e,0x95,0x83,0x47,
    0x05,0x40,0x93,0xf7,0xe7,0x0f,0x23,0x00,0xf5,0x40,0x82,0x80,0xb7,0x96,0x00,0x20,
    0x93,0x86,0xc6,0x59,0x93,0x07,0x80,0x02,0xa3,0x82,0xf6,0x00,0xb7,0x87,0x00,0x20,
    0x83,0xa7,0xc7,0x15,0x03,0xa7,0x47,0x08,0x79,0x76,0x3d,0x06,0x71,0x8f,0x13,0x67,
    0x07,0x28,0x23,0xa2,0xe7,0x08,0x29,0x47,0x23,0x83,0xe6,0x00,0x03,0xa7,0x87,0x08,
    0xb7,0x06,0x10,0xe0,0xfd,0x16,0x75,0x8f,0xb7,0x06,0xa0,0x00,0x55,0x8f,0x23,0xa4,
    0xe7,0x08,0x37,0xb7,0x00,0x20,0x13,0x07,0x47,0xb4,0x23,0xa4,0xe7,0x10,0x05,0x47,
    0x63,0x80,0xe5,0x10,0x03,0xa7,0xc7,0x0f,0x85,0x66,0x55,0x8f,0x23,0xae,0xe7,0x0e,
    0x03,0xa7,0x47,0x0f,0x13,0x67,0x07,0x10,0x23,0xaa,0xe7,0x0e,0x13,0x07,0x70,0x02,
    0x63,0x7e,0xa7,0x0e,0x37,0x97,0x00,0x20,0x03,0x47,0x77,0x5a,0x19,0x8d,0x05,0x47,
    0x33,0x17,0xa7,0x00,0x13,0x47,0xf7,0xff,0x23,0xa8,0xe7,0x0e,0x7d,0x57,0x23,0xa4,
    0xe7,0x0e,0x23,0xa6,0xe7,0x0e,0x03,0xa7,0xc7,0x0f,0x85,0x66,0x55,0x8f,0x23,0xae,
    0xe7,0x0e,0x03,0xa7,0x07,0x09,0xb7,0x06,0x00,0x01,0x55,0x8f,0x23,0xa8,0xe7,0x08,
    0x03,0xa7,0xc7,0x0f,0xb7,0x06,0x10,0x00,0x55,0x8f,0x23,0xae,0xe7,0x0e,0x03,0xa7,
    0xc7,0x0f,0x62,0x05,0xb7,0x06,0x00,0x03,0x75,0x8d,0xb7,0x06,0x00,0xfd,0xfd,0x16,
    0x75,0x8f,0x59,0x8d,0x23,0xae,0xa7,0x0e,0xb7,0x87,0x00,0x20,0x83,0xa7,0xc7,0x15,
    0x03,0xa7,0x87,0x0f,0x79,0x9b,0x23,0xac,0xe7,0x0e,0x03,0xa7,0xc7,0x0f,0xb7,0x06,
    0x00,0x10,0x55,0x8f,0x23,0xae,0xe7,0x0e,0x03,0xa7,0xc7,0x0f,0x13,0x67,0x07,0x01,
    0x23,0xae,0xe7,0x0e,0x83,0xa6,0x87,0x0f,0x7d,0x77,0x7d,0x17,0xf9,0x8e,0x23,0xac,
    0xd7,0x0e,0x83,0xa6,0xc7,0x0f,0x93,0xf6,0xf6,0xef,0x23,0xae,0xd7,0x0e,0x83,0xa6,
    0x07,0x10,0x41,0x76,0x7d,0x16,0xf1,0x8e,0x23,0xa0,0xd7,0x10,0x83,0xa6,0x07,0x10,
    0x75,0x8f,0x23,0xa0,0xe7,0x10,0x03,0xa7,0x87,0x08,0x85,0x66,0x55,0x8f,0x23,0xa4,
    0xe7,0x08,0x03,0xa7,0x87,0x08,0xc1,0x66,0x55,0x8f,0x23,0xa4,0xe7,0x08,0x82,0x80,
    0x03,0xa7,0xc7,0x0f,0xfd,0x76,0xfd,0x16,0x75,0x8f,0x23,0xae,0xe7,0x0e,0x03,0xa7,
    0x47,0x0f,0x13,0x77,0xf7,0xef,0x23,0xaa,0xe7,0x0e,0x09,0xb7,0x7d,0x47,0x63,0x76,
    0xa7,0x04,0x01,0x15,0x05,0x47,0x33,0x15,0xa7,0x00,0x13,0x45,0xf5,0xff,0x23,0xa4,
    0xa7,0x0e,0x7d,0x57,0x23,0xa6,0xe7,0x0e,0x23,0xa8,0xe7,0x0e,0x03,0xa7,0x47,0x0f,
    0x13,0x77,0xf7,0xef,0x23,0xaa,0xe7,0x0e,0x03,0xa7,0x07,0x09,0xb7,0x06,0x00,0xff,
    0xfd,0x16,0x75,0x8f,0x23,0xa8,0xe7,0x08,0x03,0xa7,0xc7,0x0f,0xb7,0x06,0xf0,0xff,
    0xfd,0x16,0x75,0x8f,0x23,0xae,0xe7,0x0e,0x05,0xb7,0xfd,0x56,0x23,0xa4,0xd7,0x0e,
    0x05,0x47,0x33,0x15,0xa7,0x00,0x13,0x45,0xf5,0xff,0x23,0xa6,0xa7,0x0e,0x23,0xa8,
    0xd7,0x0e,0x03,0xa7,0x47,0x0f,0x13,0x77,0xf7,0xef,0x23,0xaa,0xe7,0x0e,0x03,0xa7,
    0x07,0x09,0xb7,0x06,0x00,0xff,0xfd,0x16,0x75,0x8f,0x23,0xa8,0xe7,0x08,0x03,0xa7,
    0xc7,0x0f,0xb7,0x06,0xf0,0xff,0xfd,0x16,0x75,0x8f,0x23,0xae,0xe7,0x0e,0xe9,0xbd,
    0xb7,0x97,0x00,0x20,0x03,0xc7,0x77,0x5a,0xae,0x87,0x63,0xe6,0xe5,0x00,0xb3,0x87,
    0xe5,0x40,0x93,0xf7,0xc7,0x0f,0x05,0x47,0x63,0x0a,0xe5,0x06,0x13,0x97,0x15,0x00,
    0x37,0x95,0x00,0x20,0x83,0x26,0xc5,0x60,0xba,0x96,0x86,0x07,0x37,0xb6,0x00,0x20,
    0x13,0x06,0x46,0xb4,0xb2,0x97,0x83,0xd7,0x07,0x00,0x23,0x90,0xf6,0x00,0x83,0x27,
    0xc5,0x60,0xba,0x97,0x83,0x96,0x07,0x00,0xb7,0x97,0x00,0x20,0x83,0xa7,0x87,0x60,
    0x3e,0x97,0x83,0x17,0x07,0x00,0x63,0xdc,0xd7,0x04,0x13,0x97,0x15,0x00,0x37,0xb6,
    0x00,0x20,0x13,0x06,0x06,0xab,0x32,0x97,0xb3,0x87,0xf6,0x40,0x23,0x10,0xf7,0x00,
    0x93,0x07,0x70,0x04,0x63,0x88,0xf5,0x04,0xb7,0xb7,0x00,0x20,0x93,0x87,0x87,0xbe,
    0x03,0xc7,0x77,0x01,0x05,0x07,0xa3,0x8b,0xe7,0x00,0x82,0x80,0x37,0x97,0x00,0x20,
    0x03,0x27,0x87,0x60,0x86,0x05,0x2e,0x97,0x86,0x07,0xb7,0xb6,0x00,0x20,0x93,0x86,
    0x46,0xb4,0xb6,0x97,0x83,0xd7,0x07,0x00,0x23,0x10,0xf7,0x00,0xf1,0xb7,0x13,0x97,
    0x15,0x00,0x37,0xb6,0x00,0x20,0x13,0x06,0x06,0xab,0x32,0x97,0x95,0x8f,0x23,0x10,
    0xf7,0x00,0x7d,0xb7,0x51,0x11,0x06,0xc4,0xb7,0x97,0x00,0x20,0x05,0x47,0x23,0xa8,
    0xe7,0x58,0x37,0xb7,0x00,0x20,0x13,0x07,0x07,0xb0,0x37,0xb6,0x00,0x20,0x13,0x03,
    0x06,0xab,0x13,0x05,0x03,0x09,0x13,0x06,0x00,0xfb,0x33,0x06,0x66,0x40,0xb7,0xa5,
    0x00,0x20,0x83,0x16,0x07,0x00,0x83,0xa7,0x45,0x01,0xba,0x97,0xb2,0x97,0x23,0x90,
    0xd7,0x00,0x09,0x07,0xe3,0x17,0xa7,0xfe,0x13,0x05,0x03,0x05,0x1a,0x87,0x13,0x06,
    0x00,0x04,0x33,0x06,0x66,0x40,0xb7,0xa5,0x00,0x20,0x83,0x16,0x07,0x00,0x83,0xa7,
    0x45,0x01,0xba,0x97,0xb2,0x97,0x23,0x90,0xd7,0x00,0x09,0x07,0xe3,0x17,0xa7,0xfe,
    0x93,0x05,0x00,0x09,0xb7,0xa7,0x00,0x20,0x03,0xa5,0x47,0x01,0xe5,0x34,0xb7,0x07,
    0x00,0x20,0x88,0xc7,0x37,0x07,0x00,0x45,0x98,0xc3,0xb7,0xb7,0x00,0x20,0x93,0x87,
    0x87,0xbe,0x03,0xc7,0x77,0x01,0x05,0x07,0xa3,0x8b,0xe7,0x00,0xa2,0x40,0x31,0x01,
    0x82,0x80,0xb7,0xb7,0x00,0x20,0x05,0x47,0x23,0x85,0xe7,0xbe,0x82,0x80,0xb7,0xb7,
    0x00,0x20,0x23,0x85,0x07,0xbe,0x82,0x80,0xb7,0xb7,0x00,0x20,0x83,0xc7,0x97,0xbe,
    0x8d,0xc7,0x37,0x87,0x00,0x20,0x03,0x27,0xc7,0x15,0x03,0x27,0x87,0x0a,0x4d,0xef,
    0xfd,0x17,0x37,0xb7,0x00,0x20,0x13,0x07,0x87,0xbe,0xba,0x97,0x83,0xc6,0xa7,0x00,
    0x85,0x06,0x23,0x85,0xd7,0x00,0xa3,0x00,0x07,0x00,0xb7,0xb7,0x00,0x20,0x93,0x87,
    0x87,0xbe,0x03,0xc7,0x07,0x01,0x83,0xc7,0x77,0x01,0x63,0x17,0xf7,0x00,0xb7,0xb7,
    0x00,0x20,0x83,0xc7,0x17,0xbf,0x99,0xe7,0xb7,0xb7,0x00,0x20,0x05,0x47,0x23,0x85,
    0xe7,0xbe,0x82,0x80,0x51,0x11,0x06,0xc4,0x22,0xc2,0x26,0xc0,0xb7,0xb7,0x00,0x20,
    0x1d,0x47,0xa3,0x84,0xe7,0xbe,0xb7,0x94,0x00,0x20,0x93,0x84,0x44,0xaf,0x03,0xd4,
    0x04,0x00,0xb7,0xa7,0x00,0x20,0x23,0x98,0x87,0x00,0xb7,0x87,0x00,0x20,0x83,0xd5,
    0x07,0x16,0xb7,0xa7,0x00,0x20,0x23,0x99,0xb7,0x00,0x22,0x85,0xc5,0x3e,0x05,0x04,
    0x42,0x04,0x41,0x80,0x23,0x90,0x84,0x00,0xb7,0x97,0x00,0x20,0x93,0x87,0xc7,0x59,
    0x03,0xc7,0xb7,0x00,0x83,0xc7,0xa7,0x00,0xba,0x97,0x63,0x4a,0xf4,0x00,0xb7,0x97,
    0x00,0x20,0x23,0x9a,0x07,0xae,0xb7,0x87,0x00,0x20,0x23,0x90,0x07,0x16,0xa2,0x40,
    0x12,0x44,0x82,0x44,0x31,0x01,0x82,0x80,0x82,0x80,0x51,0x11,0x06,0xc4,0xb7,0x87,
    0x00,0x20,0x83,0xa7,0xc7,0x15,0x7d,0x57,0x23,0xa0,0xe7,0x12,0x23,0xa0,0x07,0x12,
    0xb7,0xe7,0x00,0xe0,0x03,0xc7,0x57,0x51,0x13,0x67,0x17,0x00,0xa3,0x8a,0xe7,0x50,
    0x21,0x37,0xa2,0x40,0x31,0x01,0x82,0x80,0x37,0x96,0x00,0x20,0x93,0x07,0xc6,0x59,
    0x93,0x06,0x00,0x02,0xa3,0x84,0xd7,0x00,0x23,0x85,0xd7,0x00,0x13,0x07,0x80,0x02,
    0xa3,0x85,0xe7,0x00,0x23,0x86,0xd7,0x00,0xa3,0x86,0xe7,0x00,0xd1,0x45,0x23,0x88,
    0xb7,0x00,0xa3,0x87,0xe7,0x00,0x23,0x87,0xd7,0x00,0x8d,0x46,0xa3,0x81,0xd7,0x00,
    0x21,0x45,0x23,0x82,0xa7,0x00,0xa3,0x82,0xe7,0x00,0x23,0x83,0xb7,0x00,0x23,0x0e,
    0xd6,0x58,0x09,0x47,0xa3,0x80,0xe7,0x00,0x19,0x46,0x23,0x81,0xc7,0x00,0xa3,0x83,
    0xe7,0x00,0x23,0x84,0xd7,0x00,0x13,0x07,0x00,0x50,0x23,0x99,0xe7,0x00,0x82,0x80,
    0x51,0x11,0x06,0xc4,0x22,0xc2,0x26,0xc0,0xb7,0x87,0x00,0x20,0x93,0x84,0xc7,0x15,
    0x9c,0x40,0x7d,0x57,0x23,0xa0,0xe7,0x12,0x23,0xa0,0x07,0x12,0x03,0xa7,0x47,0x12,
    0x3d,0x9b,0x23,0xa2,0xe7,0x12,0x03,0xa7,0xc7,0x10,0xb7,0x06,0x00,0xf0,0xfd,0x16,
    0x75,0x8f,0x23,0xa6,0xe7,0x10,0x03,0xa7,0xc7,0x0f,0x3d,0x9b,0x23,0xae,0xe7,0x0e,
    0x03,0xa7,0x87,0x0f,0x85,0x66,0x55,0x8f,0x23,0xac,0xe7,0x0e,0x03,0xa7,0x47,0x0f,
    0xb7,0x06,0x00,0xd0,0xfd,0x16,0x75,0x8f,0xb7,0x06,0x00,0x20,0x55,0x8f,0x23,0xaa,
    0xe7,0x0e,0x03,0xa7,0x47,0x0f,0xb7,0x06,0x00,0xfd,0xfd,0x16,0x75,0x8f,0xb7,0x06,
    0x00,0x01,0x55,0x8f,0x23,0xaa,0xe7,0x0e,0x03,0xa7,0x47,0x0f,0xfd,0x76,0x93,0x86,
    0xf6,0x0e,0x75,0x8f,0x13,0x67,0x07,0x01,0x23,0xaa,0xe7,0x0e,0x23,0xa2,0x07,0x0e,
    0x23,0xa4,0x07,0x0e,0x23,0xa6,0x07,0x0e,0x23,0xa8,0x07,0x0e,0x37,0x97,0x00,0x20,
    0x13,0x07,0x07,0x61,0x23,0xa2,0xe7,0x10,0x37,0x97,0x00,0x20,0x13,0x07,0x87,0x5b,
    0x23,0xa4,0xe7,0x10,0x37,0x96,0x00,0x20,0x13,0x07,0xc6,0x59,0x83,0x46,0x97,0x00,
    0x23,0xa0,0xd7,0x0e,0x83,0x46,0x57,0x00,0x92,0x06,0x83,0x45,0x37,0x00,0xc2,0x05,
    0xcd,0x8e,0x83,0x45,0x27,0x00,0xcd,0x8e,0x83,0x45,0x17,0x00,0xe2,0x05,0xcd,0x8e,
    0x23,0xa2,0xd7,0x08,0x83,0x46,0x67,0x00,0xd2,0x06,0x83,0x45,0x47,0x00,0x92,0x05,
    0xcd,0x8e,0x23,0xa4,0xd7,0x08,0x83,0x46,0x87,0x00,0xc2,0x06,0x83,0x45,0x77,0x00,
    0xe2,0x05,0xcd,0x8e,0x23,0xa6,0xd7,0x08,0x83,0x46,0xc6,0x59,0xf2,0x06,0x03,0x46,
    0xf7,0x00,0x32,0x06,0xd1,0x8e,0x03,0x47,0xe7,0x00,0x55,0x8f,0x23,0xa8,0xe7,0x08,
    0xb7,0xb7,0x00,0x20,0x23,0x80,0x07,0xc0,0x93,0x87,0x07,0xc0,0xa3,0x80,0x07,0x00,
    0x23,0x81,0x07,0x00,0xa3,0x81,0x07,0x00,0x23,0x82,0x07,0x00,0xa3,0x82,0x07,0x00,
    0x23,0x83,0x07,0x00,0xa3,0x83,0x07,0x00,0x37,0xb4,0x00,0x20,0x61,0x46,0x81,0x45,
    0x13,0x05,0x84,0xbe,0x79,0x30,0x13,0x07,0x84,0xbe,0x85,0x47,0xa3,0x04,0xf7,0x00,
    0x37,0x97,0x00,0x20,0xb7,0x97,0x00,0x20,0x93,0x87,0x07,0xba,0x23,0x24,0xf7,0x60,
    0x37,0x97,0x00,0x20,0xb7,0x97,0x00,0x20,0x93,0x87,0x87,0xc4,0x23,0x26,0xf7,0x60,
    0x37,0xa7,0x00,0x20,0xb7,0x97,0x00,0x20,0x93,0x87,0x87,0xaf,0x23,0x2a,0xf7,0x00,
    0xb7,0x05,0x00,0x20,0x93,0x85,0xa5,0x70,0x55,0x45,0x2d,0x32,0x55,0x45,0x3d,0x3a,
    0x85,0x47,0x23,0x04,0xf4,0xbe,0x98,0x40,0x83,0x27,0x47,0x12,0x93,0x96,0x77,0x00,
    0xe3,0xdc,0x06,0xfe,0xa2,0x40,0x12,0x44,0x82,0x44,0x31,0x01,0x82,0x80,0x51,0x11,
    0x06,0xc4,0xb7,0xb7,0x00,0x20,0x83,0xc7,0x97,0xbe,0x8d,0xc7,0xb7,0x97,0x00,0x20,
    0x83,0xa7,0xc7,0x58,0x95,0xc3,0x11,0x47,0x63,0x8d,0xe7,0x02,0xb7,0x97,0x00,0x20,
    0x83,0xa7,0xc7,0x58,0x19,0x47,0x63,0x9e,0xe7,0x00,0xb7,0x97,0x00,0x20,0x23,0xa6,
    0x07,0x58,0x29,0xa8,0x55,0x31,0xd9,0xbf,0x37,0x97,0x00,0x20,0x03,0x27,0x07,0x59,
    0x11,0xe7,0x85,0x07,0x37,0x97,0x00,0x20,0x23,0x26,0xf7,0x58,0xa2,0x40,0x31,0x01,
    0x82,0x80,0x37,0xb7,0x00,0x20,0x03,0x47,0x17,0xbf,0x65,0xd7,0xb7,0xb7,0x00,0x20,
    0x93,0x87,0x87,0xbe,0x03,0xc7,0x07,0x01,0x83,0xc7,0x77,0x01,0xe3,0x00,0xf7,0xfe,
    0xb7,0xa7,0x00,0x20,0x83,0xd5,0x07,0x01,0xb7,0xa7,0x00,0x20,0x03,0xd5,0x27,0x01,
    0xc5,0x34,0x69,0xbf,0x2a,0x86,0x01,0x45,0x93,0xf6,0x15,0x00,0x91,0xc2,0x32,0x95,
    0x85,0x81,0x06,0x06,0xf5,0xf9,0x82,0x80,0x00,0x00,0x00,0x00,0x80,0x80,0x00,0x20,
    0x80,0x80,0x00,0x20,0x80,0x80,0x00,0x20,0x80,0x80,0x00,0x20,0x80,0x80,0x00,0x20,
    0x80,0x80,0x00,0x20,0x80,0x80,0x00,0x20,0xf4,0x80,0x00,0x20,0x80,0x80,0x00,0x20,
    0x80,0x80,0x00,0x20,0x80,0x80,0x00,0x20,0x80,0x80,0x00,0x20,0x80,0x80,0x00,0x20,
    0x80,0x80,0x00,0x20,0x80,0x80,0x00,0x20,0x80,0x80,0x00,0x20,0xf4,0x80,0x00,0x20,
    0xf4,0x80,0x00,0x20,0xf4,0x80,0x00,0x20,0xf4,0x80,0x00,0x20,0xf4,0x80,0x00,0x20,
    0xf4,0x80,0x00,0x20,0xf4,0x80,0x00,0x20,0xf4,0x80,0x00,0x20,0xf4,0x80,0x00,0x20,
    0xf4,0x80,0x00,0x20,0xf4,0x80,0x00,0x20,0xf4,0x80,0x00,0x20,0xf4,0x80,0x00,0x20,
    0xf4,0x80,0x00,0x20,0xf4,0x80,0x00,0x20,0xf4,0x80,0x00,0x20,0x71,0x11,0x16,0xc0,
    0xf3,0x22,0x20,0x34,0x63,0xc2,0x02,0x06,0x11,0x01,0x97,0x12,0x00,0x00,0x93,0x82,
    0x62,0x9d,0x93,0x82,0xc2,0xfb,0x23,0xa0,0x12,0x00,0x23,0xa2,0x22,0x00,0x23,0xa4,
    0x32,0x00,0x23,0xa6,0x42,0x00,0x23,0xaa,0x62,0x00,0x23,0xac,0x72,0x00,0x23,0xae,
    0x82,0x00,0x23,0xa0,0x92,0x02,0x23,0xa2,0xa2,0x02,0x23,0xa4,0xb2,0x02,0x23,0xa6,
    0xc2,0x02,0x23,0xa8,0xd2,0x02,0x23,0xaa,0xe2,0x02,0x23,0xac,0xf2,0x02,0x73,0x25,
    0x10,0x34,0x23,0xae,0xa2,0x02,0x73,0x25,0x00,0x30,0x23,0xa0,0xa2,0x04,0x16,0x85,
    0x83,0x22,0xc1,0xff,0x2a,0x81,0x16,0xc8,0x82,0x42,0x11,0x01,0x11,0xa0,0x00,0x00,
    0x79,0x71,0x16,0xc2,0x1a,0xc4,0xf3,0x22,0x10,0x34,0x73,0x23,0x20,0x34,0x1a,0xd4,
    0x16,0xd6,0x73,0x60,0x04,0x30,0x06,0xc0,0x1e,0xc6,0x2a,0xc8,0x2e,0xca,0x32,0xcc,
    0x36,0xce,0x3a,0xd0,0x3e,0xd2,0x13,0x73,0xf3,0x03,0x0a,0x03,0x97,0x12,0x00,0x00,
    0x93,0x82,0x42,0x94,0x9a,0x92,0x83,0xa3,0x02,0x00,0x82,0x93,0x82,0x40,0x92,0x42,
    0x22,0x43,0xb2,0x43,0x62,0x46,0xf2,0x46,0x02,0x57,0x92,0x57,0x73,0x70,0x04,0x30,
    0x22,0x55,0x73,0x10,0x25,0x34,0xb2,0x55,0x73,0x90,0x15,0x34,0x42,0x45,0xd2,0x45,
    0x45,0x61,0x73,0x00,0x20,0x30,0x00,0x00,0x00,0x20,0x00,0x40,0x01,0x00,0x00,0x00
};
#else
static const unsigned char fw_short_mcapshare[] = {

};
#endif



/**************************************************************************************************/
//chip ic 5816 firmware code bin
/**************************************************************************************************/
#elif TYPE_OF_IC(SEMI_TOUCH_IC) == TYPE_OF_IC(SEMI_TOUCH_5816)
#if (SEMI_TOUCH_ONLINE_UPDATE_EN || SEMI_TOUCH_BOOTUP_UPDATE_EN || SEMI_TOUCH_APK_NODE_EN)
static const unsigned char fw_burn_mcapshare[] = {
    0x37,0x02,0x00,0x20,0x13,0x02,0x02,0x02,0x37,0x77,0x00,0x40,0x37,0x45,0x04,0x12,
    0x05,0x05,0x08,0xC3,0x02,0x82,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x01,0x00,0x01,0x00,0x01,0x00,0x73,0x70,0x04,0x30,0x17,0x11,0x00,0x00,0x13,0x01,
    0xE1,0x1D,0x17,0x15,0x00,0x00,0x13,0x05,0xE5,0xA4,0x97,0x15,0x00,0x00,0x93,0x85,
    0x65,0xFC,0x17,0x16,0x00,0x00,0x13,0x06,0x66,0xFC,0x63,0xFA,0xC5,0x00,0x83,0x22,
    0x05,0x00,0x23,0xA0,0x55,0x00,0x11,0x05,0x91,0x05,0xE3,0xEA,0xC5,0xFE,0x17,0x15,
    0x00,0x00,0x13,0x05,0xA5,0xFA,0x97,0x15,0x00,0x00,0x93,0x85,0x25,0x1A,0x63,0x77,
    0xB5,0x00,0x23,0x20,0x05,0x00,0x11,0x05,0xE3,0x6D,0xB5,0xFE,0xEF,0x00,0xA0,0x56,
    0x01,0xA0,0x37,0x17,0x00,0x20,0x83,0x26,0x07,0x62,0xFD,0x77,0x93,0x87,0x27,0x9A,
    0x23,0x91,0xF6,0x00,0x83,0x27,0x07,0x62,0x05,0x67,0x13,0x07,0xD7,0x65,0x23,0x92,
    0xE7,0x00,0x0D,0x67,0x13,0x07,0x07,0x03,0x23,0x93,0xE7,0x00,0x23,0x94,0x07,0x00,
    0x23,0x95,0x07,0x00,0x23,0x96,0x07,0x00,0x23,0x87,0x07,0x00,0x82,0x80,0x31,0x11,
    0x06,0xC8,0x22,0xC6,0x26,0xC4,0xB7,0x17,0x00,0x20,0x03,0xA7,0x47,0x63,0x83,0x54,
    0x47,0x00,0x03,0x54,0x27,0x00,0xB3,0xE7,0x84,0x00,0x8D,0x8B,0x89,0xCF,0xB7,0x17,
    0x00,0x20,0x83,0xA7,0x07,0x62,0x15,0x47,0x23,0x87,0xE7,0x00,0xC2,0x40,0x32,0x44,
    0xA2,0x44,0x51,0x01,0x82,0x80,0xB3,0x86,0x84,0x00,0xA9,0x67,0x93,0x87,0x07,0x10,
    0xE3,0xEF,0xD7,0xFC,0xA9,0x67,0x63,0x74,0xF4,0x00,0x63,0xEA,0xD7,0x02,0x83,0x57,
    0xA7,0x00,0x3E,0xC0,0x03,0x57,0x67,0x00,0x3A,0xC2,0xA6,0x85,0x37,0x25,0x00,0x20,
    0x4D,0x23,0x82,0x47,0xC2,0x07,0x12,0x47,0xBA,0x97,0x63,0x82,0xA7,0x02,0xB7,0x17,
    0x00,0x20,0x83,0xA7,0x07,0x62,0x0D,0x47,0x23,0x87,0xE7,0x00,0x45,0xBF,0xB7,0x17,
    0x00,0x20,0x83,0xA7,0x07,0x62,0x15,0x47,0x23,0x87,0xE7,0x00,0x45,0xB7,0xB7,0x17,
    0x00,0x20,0x03,0xA7,0x07,0x62,0x95,0x67,0x93,0x87,0xB7,0x5B,0x23,0x16,0xF7,0x00,
    0x37,0x26,0x00,0x20,0xA6,0x85,0x22,0x85,0xB5,0x25,0x01,0xE9,0xB7,0x17,0x00,0x20,
    0x83,0xA7,0x07,0x62,0x23,0x87,0x07,0x00,0x95,0xBF,0xB7,0x17,0x00,0x20,0x83,0xA7,
    0x07,0x62,0x13,0x07,0x40,0xFA,0x23,0x87,0xE7,0x00,0x8D,0xB7,0xB7,0x17,0x00,0x20,
    0x83,0xA7,0x47,0x63,0x03,0xD5,0xC7,0x00,0x42,0x05,0x03,0xD7,0x27,0x00,0x3A,0x95,
    0x13,0x77,0x35,0x00,0x3D,0xEF,0x51,0x11,0x06,0xC4,0x22,0xC2,0x26,0xC0,0x03,0xD4,
    0x47,0x00,0x93,0x77,0x34,0x00,0xB1,0xE3,0xA9,0x67,0x63,0x78,0xF5,0x00,0x93,0x07,
    0xF4,0xFF,0xAA,0x97,0x29,0x67,0x63,0xF6,0xE7,0x04,0xB7,0x24,0x00,0x20,0x13,0x86,
    0x04,0x40,0xA2,0x85,0x5D,0x23,0xA2,0x85,0x13,0x85,0x04,0x40,0xDD,0x21,0xB7,0x17,
    0x00,0x20,0x03,0xA7,0x07,0x62,0x23,0x11,0xA7,0x00,0x83,0xA7,0x07,0x62,0x41,0x81,
    0x23,0x92,0xA7,0x00,0x23,0x87,0x07,0x00,0x01,0xA8,0xB7,0x17,0x00,0x20,0x83,0xA7,
    0x07,0x62,0x15,0x47,0x23,0x87,0xE7,0x00,0xA2,0x40,0x12,0x44,0x82,0x44,0x31,0x01,
    0x82,0x80,0xB7,0x17,0x00,0x20,0x83,0xA7,0x07,0x62,0x15,0x47,0x23,0x87,0xE7,0x00,
    0xE5,0xB7,0xB7,0x17,0x00,0x20,0x83,0xA7,0x07,0x62,0x15,0x47,0x23,0x87,0xE7,0x00,
    0x82,0x80,0xB7,0x17,0x00,0x20,0x83,0xA7,0x07,0x62,0x25,0x47,0x23,0x87,0xE7,0x00,
    0xB7,0x17,0x00,0x20,0x83,0xA7,0x47,0x63,0x03,0xD5,0x27,0x00,0x9D,0x47,0x63,0xF3,
    0xA7,0x00,0x82,0x80,0x51,0x11,0x06,0xC4,0x91,0x2F,0x63,0x4C,0x05,0x00,0xB7,0x17,
    0x00,0x20,0x03,0xA7,0x07,0x62,0x23,0x11,0xA7,0x00,0x83,0xA7,0x07,0x62,0x23,0x87,
    0x07,0x00,0xA2,0x40,0x31,0x01,0x82,0x80,0x41,0x11,0x06,0xC6,0x22,0xC4,0x26,0xC2,
    0x2A,0x84,0xAE,0x84,0x32,0xC0,0x71,0x99,0x8D,0x05,0xA2,0x95,0xF1,0x99,0x37,0x16,
    0x00,0x20,0x13,0x06,0x86,0x21,0x89,0x8D,0xCD,0x21,0x95,0xC0,0x0D,0x88,0xB7,0x17,
    0x00,0x20,0x93,0x87,0x87,0x21,0x3E,0x94,0x02,0x47,0xBA,0x87,0xBA,0x94,0x03,0x47,
    0x04,0x00,0x23,0x80,0xE7,0x00,0x05,0x04,0x85,0x07,0xE3,0x9A,0x97,0xFE,0xB2,0x40,
    0x22,0x44,0x92,0x44,0x41,0x01,0x82,0x80,0x21,0x11,0x06,0xCA,0x22,0xC8,0x26,0xC6,
    0x2A,0xC4,0x02,0xC2,0x81,0x44,0x01,0x44,0xA1,0xA8,0x82,0x47,0x93,0x85,0x37,0x00,
    0xB7,0x17,0x00,0x20,0x13,0x86,0x87,0x21,0xF1,0x99,0x12,0x45,0x79,0x21,0xA2,0x46,
    0xA1,0xCA,0x12,0x47,0x81,0x46,0xB7,0x17,0x00,0x20,0x13,0x86,0x87,0x21,0x92,0x47,
    0xB3,0x07,0xF7,0x40,0xB2,0x97,0x83,0xC7,0x07,0x00,0x3E,0x94,0x42,0x04,0x41,0x80,
    0xB3,0x87,0xE7,0x02,0xBE,0x94,0xC2,0x04,0xC1,0x80,0x85,0x06,0x05,0x07,0x82,0x47,
    0xE3,0xEF,0xF6,0xFC,0xA2,0x47,0x82,0x46,0x95,0x8F,0x3E,0xC4,0x91,0xCB,0x3A,0xC2,
    0x22,0x47,0x3A,0xC0,0x93,0x07,0x00,0x40,0xE3,0xF1,0xE7,0xFA,0x3E,0xC0,0x71,0xBF,
    0x13,0x95,0x04,0x01,0x41,0x8D,0xD2,0x40,0x42,0x44,0xB2,0x44,0x61,0x01,0x82,0x80,
    0x03,0x27,0x00,0x00,0xB7,0x17,0x00,0x20,0x23,0x8C,0xE7,0x20,0x93,0x56,0x87,0x00,
    0xA3,0x8C,0xD7,0x20,0x93,0x56,0x07,0x01,0x23,0x8D,0xD7,0x20,0x93,0x56,0x87,0x01,
    0xA3,0x8D,0xD7,0x20,0x03,0x26,0x40,0x00,0x93,0x87,0x87,0x21,0x23,0x82,0xC7,0x00,
    0x93,0x56,0x86,0x00,0xA3,0x82,0xD7,0x00,0x93,0x56,0x06,0x01,0x23,0x83,0xD7,0x00,
    0x93,0x56,0x86,0x01,0xA3,0x83,0xD7,0x00,0x83,0x26,0x80,0x00,0x23,0x84,0xD7,0x00,
    0x93,0xD5,0x86,0x00,0xA3,0x84,0xB7,0x00,0x93,0xD5,0x06,0x01,0x23,0x85,0xB7,0x00,
    0xE1,0x82,0xA3,0x85,0xD7,0x00,0x71,0x8F,0xFD,0x57,0x63,0x02,0xF7,0x08,0x41,0x11,
    0x06,0xC6,0x22,0xC4,0x26,0xC2,0x03,0x27,0x00,0x03,0xB7,0x17,0x00,0x20,0x93,0x87,
    0x87,0x21,0x23,0x88,0xE7,0x02,0x93,0x56,0x87,0x00,0xA3,0x88,0xD7,0x02,0x93,0x56,
    0x07,0x01,0x23,0x89,0xD7,0x02,0x93,0x56,0x87,0x01,0xA3,0x89,0xD7,0x02,0x03,0x24,
    0x40,0x03,0x23,0x8A,0x87,0x02,0x93,0x56,0x84,0x00,0xA3,0x8A,0xD7,0x02,0x93,0x56,
    0x04,0x01,0x23,0x8B,0xD7,0x02,0x93,0x56,0x84,0x01,0xA3,0x8B,0xD7,0x02,0x42,0x07,
    0x41,0x83,0x99,0x67,0x93,0x87,0x67,0x81,0x63,0x17,0xF7,0x00,0x93,0x04,0xC4,0xFF,
    0xC1,0x67,0x63,0xE6,0xF4,0x02,0xB7,0x17,0x00,0x20,0x83,0xA7,0x07,0x62,0x45,0x47,
    0x23,0x87,0xE7,0x00,0xB2,0x40,0x22,0x44,0x92,0x44,0x41,0x01,0x82,0x80,0xB7,0x17,
    0x00,0x20,0x83,0xA7,0x07,0x62,0x21,0x47,0x23,0x87,0xE7,0x00,0x82,0x80,0x26,0x85,
    0xA5,0x3D,0x2A,0xC0,0x37,0x26,0x00,0x20,0x13,0x06,0x06,0x40,0xA1,0x45,0x26,0x85,
    0x21,0x3D,0x83,0x27,0xC4,0xFF,0x02,0x47,0x63,0x0A,0xF7,0x00,0xB7,0x17,0x00,0x20,
    0x83,0xA7,0x07,0x62,0x0D,0x47,0x23,0x87,0xE7,0x00,0x6D,0xBF,0xB7,0x17,0x00,0x20,
    0x83,0xA7,0x07,0x62,0x23,0x87,0x07,0x00,0x75,0xB7,0x51,0x11,0x06,0xC4,0x22,0xC2,
    0xB7,0x17,0x00,0x20,0x83,0xA7,0x07,0x62,0x25,0x47,0x23,0x87,0xE7,0x00,0xC1,0x45,
    0xB7,0x17,0x00,0x20,0x03,0xA5,0x47,0x63,0x99,0x2C,0x29,0xED,0xB7,0x17,0x00,0x20,
    0x83,0xA7,0x47,0x63,0x83,0xC7,0xE7,0x00,0x13,0x07,0x00,0x03,0x63,0x89,0xE7,0x02,
    0x13,0x07,0x10,0x03,0x63,0x8F,0xE7,0x00,0x13,0x07,0x30,0x03,0x63,0x8D,0xE7,0x00,
    0x05,0x47,0x63,0x8C,0xE7,0x00,0x13,0x07,0x20,0x03,0x63,0x9C,0xE7,0x02,0x91,0x47,
    0x01,0xA8,0x85,0x47,0x31,0xA0,0x89,0x47,0x21,0xA0,0x8D,0x47,0x11,0xA0,0x81,0x47,
    0x13,0x97,0x37,0x00,0xB7,0x17,0x00,0x20,0x93,0x87,0x87,0xA5,0xBA,0x97,0xDC,0x43,
    0x82,0x97,0x01,0xA8,0xB7,0x17,0x00,0x20,0x83,0xA7,0x07,0x62,0x09,0x47,0x23,0x87,
    0xE7,0x00,0x37,0x14,0x00,0x20,0x03,0x25,0x04,0x62,0xB7,0x17,0x00,0x20,0x83,0xA7,
    0x47,0x63,0x83,0xC7,0xE7,0x00,0xA3,0x07,0xF5,0x00,0xB9,0x45,0x09,0x05,0xC1,0x2A,
    0x83,0x27,0x04,0x62,0x33,0x05,0xA0,0x40,0x23,0x90,0xA7,0x00,0xA2,0x40,0x12,0x44,
    0x31,0x01,0x82,0x80,0xB7,0x07,0x00,0x20,0x03,0xC7,0xF7,0x00,0x93,0x07,0x90,0x0E,
    0x63,0x03,0xF7,0x00,0x82,0x80,0x51,0x11,0x06,0xC4,0x41,0x46,0xB7,0x05,0x00,0x20,
    0x37,0x15,0x00,0x20,0x13,0x05,0x45,0x62,0x35,0x22,0x05,0x37,0x41,0x46,0xB7,0x15,
    0x00,0x20,0x93,0x85,0x85,0x20,0x37,0x05,0x00,0x20,0x29,0x2A,0xA2,0x40,0x31,0x01,
    0x82,0x80,0xB7,0x17,0x00,0x20,0x03,0xA7,0x47,0x00,0x93,0x06,0x10,0x0B,0x14,0xC3,
    0x03,0xA7,0x47,0x00,0x5C,0x47,0x85,0x8B,0xF5,0xDF,0x83,0x26,0x00,0x00,0x93,0x07,
    0x00,0x0B,0x1C,0xC3,0xB7,0x17,0x00,0x20,0x03,0xA7,0x47,0x00,0x5C,0x47,0x85,0x8B,
    0xF5,0xDF,0x13,0xC7,0xF6,0xFF,0x93,0x97,0x16,0x01,0xC5,0x83,0x41,0x83,0x63,0x03,
    0xF7,0x00,0x82,0x80,0x37,0x16,0x00,0x20,0x03,0x27,0x86,0x61,0x81,0x76,0x8D,0x06,
    0x75,0x8F,0x8A,0x07,0xD9,0x8F,0x23,0x2C,0xF6,0x60,0x37,0x17,0x00,0x20,0x03,0x27,
    0x07,0x00,0x5C,0xC3,0xF9,0xBF,0x51,0x11,0x06,0xC4,0x22,0xC2,0x26,0xC0,0xB7,0x17,
    0x00,0x20,0x93,0x87,0x07,0x00,0x94,0x43,0x25,0x67,0x13,0x07,0xA7,0x25,0x98,0xCA,
    0x37,0x47,0x06,0x02,0x15,0x07,0x98,0xC2,0x94,0x43,0xB7,0x37,0x49,0x13,0x93,0x87,
    0x97,0xE0,0xDC,0xC2,0x37,0x17,0x04,0x00,0x41,0x17,0xD8,0xC6,0x37,0x17,0x00,0x20,
    0x23,0x2C,0xF7,0x60,0xB7,0x17,0x00,0x20,0x03,0xA7,0x47,0x00,0x93,0x07,0x00,0x1E,
    0x1C,0xCB,0xB7,0x47,0x49,0x00,0x93,0x87,0x07,0xE0,0x1C,0xD3,0x5C,0xD3,0xB7,0x07,
    0x00,0x20,0x37,0x17,0x00,0x20,0x23,0x2C,0xF7,0x62,0x37,0x17,0x00,0x20,0x23,0x2E,
    0xF7,0x60,0xB7,0x14,0x00,0x20,0x13,0x87,0x44,0x62,0xB7,0x17,0x00,0x20,0x23,0xAA,
    0xE7,0x62,0x37,0x14,0x00,0x20,0x13,0x07,0x84,0x20,0xB7,0x17,0x00,0x20,0x23,0xA0,
    0xE7,0x62,0x41,0x46,0x81,0x45,0x37,0x05,0x00,0x20,0x15,0x28,0x41,0x46,0x81,0x45,
    0x13,0x85,0x44,0x62,0x2D,0x20,0x41,0x46,0x81,0x45,0x13,0x05,0x84,0x20,0x05,0x20,
    0x55,0x3D,0xFD,0xBF,0x09,0x86,0x19,0xCA,0x0A,0x06,0x2A,0x96,0x91,0x05,0x11,0x05,
    0x83,0xA7,0xC5,0xFF,0x23,0x2E,0xF5,0xFE,0xE3,0x1A,0xA6,0xFE,0x82,0x80,0x09,0x86,
    0x01,0xCA,0x0A,0x06,0x2A,0x96,0x11,0x05,0x23,0x2E,0xB5,0xFE,0xE3,0x1D,0xA6,0xFE,
    0x82,0x80,0x9D,0xC9,0x81,0x47,0x81,0x46,0x01,0x46,0x33,0x07,0xF5,0x00,0x03,0x47,
    0x07,0x00,0x3A,0x96,0x42,0x06,0x41,0x82,0x33,0x07,0xF7,0x02,0x36,0x97,0x93,0x16,
    0x07,0x01,0xC1,0x82,0x85,0x07,0x13,0x97,0x07,0x01,0x41,0x83,0xE3,0x6F,0xB7,0xFC,
    0xC2,0x06,0x33,0xE5,0xC6,0x00,0x82,0x80,0xAE,0x86,0x2E,0x86,0xD5,0xBF,0x85,0x81,
    0x95,0xC1,0xAA,0x87,0xFD,0x15,0xC2,0x05,0xC1,0x81,0x86,0x05,0x09,0x05,0x33,0x87,
    0xA5,0x00,0x81,0x45,0x03,0xD5,0x07,0x00,0xAA,0x95,0xC2,0x05,0xC1,0x81,0x89,0x07,
    0xE3,0x9A,0xE7,0xFE,0x2E,0x85,0x82,0x80,0x89,0x81,0x09,0x81,0x95,0xC5,0x81,0x46,
    0x37,0x13,0x00,0x20,0xB3,0x07,0xD5,0x00,0x13,0x07,0x43,0x00,0x83,0x22,0x07,0x00,
    0x23,0xA2,0xF2,0x00,0x23,0xA0,0xC2,0x00,0x18,0x43,0x5C,0x47,0x85,0x8B,0xF5,0xDF,
    0x93,0x86,0x06,0x02,0xE3,0xE0,0xB6,0xFE,0x82,0x80,0x51,0x11,0x06,0xC4,0x13,0x06,
    0xA0,0x09,0xA9,0x65,0x01,0x45,0xC9,0x37,0x13,0x06,0xB0,0x09,0x93,0x05,0x00,0x10,
    0x01,0x45,0x5D,0x3F,0xA2,0x40,0x31,0x01,0x82,0x80,0xA9,0x67,0x13,0x07,0x00,0x0B,
    0x63,0x66,0xF5,0x00,0xD9,0x77,0x3E,0x95,0x13,0x07,0x10,0x0B,0x89,0x81,0xB7,0x17,
    0x00,0x20,0x93,0x87,0x47,0x00,0x94,0x43,0x98,0xC2,0x98,0x43,0x5C,0x47,0x85,0x8B,
    0xF5,0xDF,0x81,0xCD,0x8A,0x05,0xAA,0x95,0xAA,0x87,0x94,0x43,0x33,0x87,0xA7,0x40,
    0x32,0x97,0x14,0xC3,0x91,0x07,0xE3,0x9A,0xF5,0xFE,0xB7,0x17,0x00,0x20,0x93,0x87,
    0x47,0x00,0x98,0x43,0x93,0x06,0x00,0x0B,0x14,0xC3,0x98,0x43,0x5C,0x47,0x85,0x8B,
    0xF5,0xDF,0x82,0x80,0x41,0x11,0x22,0xC6,0x26,0xC4,0x2A,0x83,0xA9,0x67,0x63,0x68,
    0xF5,0x0C,0xD9,0x76,0xAA,0x96,0x93,0x07,0x10,0x09,0x3E,0xC2,0x93,0x07,0x10,0x0B,
    0x3E,0xC0,0x93,0x04,0x70,0x09,0x89,0x82,0x89,0x81,0xB7,0x17,0x00,0x20,0x83,0xA7,
    0x47,0x00,0x13,0x07,0x00,0x1E,0x98,0xCB,0x9D,0xC5,0xB2,0x82,0x33,0x84,0xB6,0x00,
    0xB7,0x17,0x00,0x20,0x13,0x87,0x47,0x00,0x1C,0x43,0xD4,0xC3,0x83,0xA3,0x02,0x00,
    0x23,0xA4,0x77,0x00,0x84,0xC3,0x18,0x43,0x5C,0x47,0x85,0x8B,0xF5,0xDF,0x85,0x06,
    0x91,0x02,0xE3,0x9F,0x86,0xFC,0xB7,0x17,0x00,0x20,0x93,0x87,0x47,0x00,0x98,0x43,
    0x93,0x06,0x00,0x1E,0x14,0xCB,0x82,0x46,0x14,0xC3,0x83,0xA2,0x07,0x00,0x83,0xA7,
    0xC2,0x00,0x85,0x8B,0xED,0xDF,0xAD,0xC9,0x18,0x41,0x1C,0x42,0x63,0x17,0xF7,0x0A,
    0x13,0x94,0x25,0x00,0x2A,0x94,0xAA,0x87,0x81,0x46,0x85,0x06,0x91,0x07,0x63,0x0A,
    0xF4,0x04,0x83,0xA3,0x07,0x00,0x33,0x87,0xA7,0x40,0x32,0x97,0x18,0x43,0xE3,0x86,
    0xE3,0xFE,0xFD,0x55,0xB7,0x17,0x00,0x20,0x93,0x87,0x47,0x00,0x98,0x43,0x93,0x06,
    0x00,0x0B,0x14,0xC3,0x98,0x43,0x5C,0x47,0x85,0x8B,0xF5,0xDF,0x85,0x05,0x13,0xB5,
    0x15,0x00,0x33,0x05,0xA0,0x40,0x32,0x44,0xA2,0x44,0x41,0x01,0x82,0x80,0xAA,0x86,
    0x93,0x07,0x00,0x09,0x3E,0xC2,0x93,0x07,0x00,0x0B,0x3E,0xC0,0x93,0x04,0x60,0x09,
    0x1D,0xBF,0xFD,0x57,0x63,0x85,0xF6,0x04,0x92,0x47,0x23,0xA0,0xF2,0x00,0xB7,0x17,
    0x00,0x20,0x03,0xA7,0x47,0x00,0x5C,0x47,0x85,0x8B,0xF5,0xDF,0xC5,0xD5,0x18,0x41,
    0x1C,0x42,0x63,0x18,0xF7,0x02,0x93,0x96,0x25,0x00,0xAA,0x96,0x81,0x45,0x85,0x05,
    0x11,0x03,0xE3,0x89,0x66,0xF8,0x03,0x27,0x03,0x00,0xB3,0x07,0xA3,0x40,0xB2,0x97,
    0x9C,0x43,0xE3,0x06,0xF7,0xFE,0xFD,0x55,0xB5,0xBF,0xFD,0x55,0xA5,0xBF,0xB6,0x85,
    0x95,0xBF,0xFD,0x55,0x85,0xBF,0x51,0x11,0x06,0xC4,0x22,0xC2,0x93,0x77,0x45,0x00,
    0x85,0xC7,0xB7,0x17,0x00,0x20,0x93,0x87,0x47,0x00,0x98,0x43,0x23,0x22,0x07,0x00,
    0x93,0x06,0x30,0x09,0x14,0xC3,0x98,0x43,0x5C,0x47,0x85,0x8B,0xF5,0xDF,0x31,0x3D,
    0xA2,0x40,0x12,0x44,0x31,0x01,0x82,0x80,0x93,0x76,0x15,0x00,0x99,0xCE,0xB7,0x17,
    0x00,0x20,0x93,0x87,0x47,0x00,0x98,0x43,0x23,0x22,0x07,0x00,0x13,0x06,0x20,0x09,
    0x10,0xC3,0x98,0x43,0x5C,0x47,0x85,0x8B,0xF5,0xDF,0x13,0x74,0x25,0x00,0x1D,0xC4,
    0xB7,0x17,0x00,0x20,0x93,0x87,0x47,0x00,0x98,0x43,0x23,0x22,0x07,0x00,0x13,0x06,
    0x50,0x09,0x10,0xC3,0x98,0x43,0x5C,0x47,0x85,0x8B,0xF5,0xDF,0x89,0xEA,0x13,0x06,
    0xB0,0x09,0x93,0x05,0x00,0x10,0x01,0x45,0x41,0x3B,0x5D,0xB7,0xD5,0xD2,0x13,0x06,
    0xA0,0x09,0xA9,0x65,0x01,0x45,0x49,0x33,0x41,0xDC,0xD5,0xB7,0x41,0x11,0x06,0xC6,
    0x22,0xC4,0x26,0xC2,0x2A,0x84,0x02,0xC0,0xB7,0x14,0x00,0x20,0x22,0x85,0xA1,0x3F,
    0x93,0x77,0x54,0x00,0x8D,0xC7,0x93,0x87,0x44,0x00,0x98,0x43,0x93,0x06,0x00,0x09,
    0x14,0xC3,0x98,0x43,0x5C,0x47,0x85,0x8B,0xF5,0xDF,0x83,0x27,0x00,0x00,0xA5,0xE7,
    0x91,0x47,0xA9,0x66,0x98,0x43,0x25,0xE3,0x91,0x07,0xE3,0x9D,0xD7,0xFE,0x93,0x77,
    0x64,0x00,0x95,0xC7,0x93,0x87,0x44,0x00,0x98,0x43,0x93,0x06,0x10,0x09,0x14,0xC3,
    0x98,0x43,0x5C,0x47,0x85,0x8B,0xF5,0xDF,0x83,0x27,0x00,0x00,0x8D,0xEF,0x91,0x47,
    0x93,0x06,0x00,0x10,0x98,0x43,0x05,0xEB,0x91,0x07,0xE3,0x9D,0xD7,0xFE,0x22,0x85,
    0xDD,0x3D,0x02,0x45,0xB7,0x17,0x00,0x20,0x93,0x87,0x47,0x00,0x98,0x43,0x93,0x06,
    0x00,0x0B,0x14,0xC3,0x98,0x43,0x5C,0x47,0x85,0x8B,0xF5,0xDF,0xB2,0x40,0x22,0x44,
    0x92,0x44,0x41,0x01,0x82,0x80,0x82,0x47,0x85,0x07,0x3E,0x87,0x3E,0xC0,0x95,0x47,
    0xE3,0x16,0xF7,0xF6,0x7D,0x55,0xF9,0xB7,0x30,0x00,0x00,0x00,0xBE,0x00,0x00,0x20,
    0x31,0x00,0x00,0x00,0x8C,0x01,0x00,0x20,0x33,0x00,0x00,0x00,0x50,0x03,0x00,0x20,
    0x01,0x00,0x00,0x00,0x82,0x00,0x00,0x20,0x32,0x00,0x00,0x00,0x32,0x02,0x00,0x20,
    0x00,0x70,0x00,0x40,0x00,0x10,0x00,0x40,
};
#else
static const unsigned char fw_burn_mcapshare[] = {
};
#endif

#if (SEMI_TOUCH_APK_NODE_EN)
static const unsigned char fw_short_mcapshare[] = {
    0x37,0x02,0x00,0x20,0x13,0x02,0x02,0x02,0x37,0x77,0x00,0x40,0x37,0x45,0x04,0x12,
    0x05,0x05,0x08,0xC3,0x02,0x82,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x01,0x00,0x01,0x00,0x01,0x00,0x73,0x70,0x04,0x30,0x17,0x11,0x00,0x00,0x13,0x01,
    0xE1,0x1D,0x17,0x05,0x00,0x00,0x13,0x05,0xA5,0x3B,0x97,0x15,0x00,0x00,0x93,0x85,
    0x65,0xFC,0x17,0x16,0x00,0x00,0x13,0x06,0x66,0xFC,0x63,0xFA,0xC5,0x00,0x83,0x22,
    0x05,0x00,0x23,0xA0,0x55,0x00,0x11,0x05,0x91,0x05,0xE3,0xEA,0xC5,0xFE,0x17,0x15,
    0x00,0x00,0x13,0x05,0xA5,0xFA,0x97,0x15,0x00,0x00,0x93,0x85,0x25,0x1A,0x63,0x77,
    0xB5,0x00,0x23,0x20,0x05,0x00,0x11,0x05,0xE3,0x6D,0xB5,0xFE,0xEF,0x00,0x80,0x1B,
    0x01,0xA0,0xB7,0x17,0x00,0x20,0x83,0xA7,0x07,0x00,0xD4,0x43,0x37,0x07,0x00,0xE1,
    0x13,0x06,0xF7,0xFF,0xF1,0x8E,0xB7,0x05,0x00,0x04,0xCD,0x8E,0xD4,0xC3,0x98,0x47,
    0x71,0x8F,0x4D,0x8F,0x98,0xC7,0x98,0x47,0xB7,0x16,0xE0,0xFF,0xFD,0x16,0x75,0x8F,
    0xE1,0x66,0x55,0x8F,0x98,0xC7,0x98,0x47,0x13,0x77,0x07,0xE0,0x13,0x67,0x87,0x00,
    0x98,0xC7,0x31,0x47,0xD8,0xD3,0x37,0x37,0x54,0x76,0x13,0x07,0x07,0x21,0x98,0xD7,
    0x31,0x67,0x13,0x07,0x87,0xA9,0xD8,0xD7,0x85,0x46,0x23,0xA0,0xD7,0x0C,0x37,0x17,
    0x00,0x20,0x13,0x07,0x07,0x22,0x23,0xA2,0xE7,0x0C,0x03,0xA7,0xC7,0x1E,0x13,0x67,
    0x17,0x00,0x23,0xA6,0xE7,0x1E,0x03,0xA7,0x47,0x1F,0x11,0x66,0x13,0x06,0x06,0xF0,
    0x51,0x8F,0x23,0xAA,0xE7,0x1E,0x03,0xA7,0x47,0x1F,0x13,0x67,0x07,0x01,0x23,0xAA,
    0xE7,0x1E,0x03,0xA7,0x07,0x1E,0x13,0x67,0x17,0x00,0x23,0xA0,0xE7,0x1E,0x03,0xA7,
    0x07,0x1E,0x13,0x77,0xF7,0x8F,0x23,0xA0,0xE7,0x1E,0x03,0xA7,0x47,0x1E,0x13,0x77,
    0xF7,0xEF,0x23,0xA2,0xE7,0x1E,0x03,0xA7,0x47,0x1E,0x79,0x9B,0x23,0xA2,0xE7,0x1E,
    0x03,0xA7,0x87,0x1E,0x13,0x67,0x07,0x10,0x23,0xA4,0xE7,0x1E,0x23,0xA0,0xD7,0x16,
    0x82,0x80,0x2D,0x47,0xAE,0x87,0x63,0x76,0xB7,0x00,0x93,0x87,0x45,0xFF,0x93,0xF7,
    0xF7,0x0F,0x05,0x47,0x63,0x0E,0xE5,0x04,0x86,0x05,0x86,0x07,0x37,0x17,0x00,0x20,
    0x13,0x07,0x07,0x22,0xBA,0x97,0x83,0x96,0x07,0x00,0x37,0x17,0x00,0x20,0x83,0x27,
    0x07,0x21,0xAE,0x97,0x23,0x90,0xD7,0x00,0x37,0x16,0x00,0x20,0x83,0x27,0xC6,0x21,
    0xAE,0x97,0x03,0x27,0x07,0x21,0x2E,0x97,0xB7,0x16,0x00,0x20,0x83,0xA6,0x86,0x20,
    0xAE,0x96,0x03,0x57,0x07,0x00,0x83,0xD6,0x06,0x00,0x15,0x8F,0x23,0x90,0xE7,0x00,
    0x83,0x27,0xC6,0x21,0xBE,0x95,0x83,0x97,0x05,0x00,0x63,0xC4,0x07,0x02,0x82,0x80,
    0x86,0x07,0x37,0x17,0x00,0x20,0x13,0x07,0x07,0x22,0xBA,0x97,0x03,0x97,0x07,0x00,
    0xB7,0x17,0x00,0x20,0x83,0xA7,0x87,0x20,0x86,0x05,0xAE,0x97,0x23,0x90,0xE7,0x00,
    0x82,0x80,0xB3,0x07,0xF0,0x40,0x23,0x90,0xF5,0x00,0xD1,0xBF,0x51,0x11,0x06,0xC4,
    0xB7,0x17,0x00,0x20,0x03,0xA5,0xC7,0x21,0x83,0x56,0x05,0x00,0x93,0x07,0x25,0x00,
    0x13,0x06,0x05,0x02,0x21,0xA0,0x89,0x07,0x63,0x8A,0xC7,0x00,0x03,0x97,0x07,0x00,
    0xE3,0xDB,0xE6,0xFE,0x93,0x16,0x07,0x01,0xC1,0x82,0xF5,0xB7,0x93,0x05,0x00,0x02,
    0x9D,0x22,0xB7,0x07,0x00,0x20,0x88,0xC7,0x37,0x07,0x00,0x45,0x98,0xC3,0xA2,0x40,
    0x31,0x01,0x82,0x80,0x51,0x11,0x06,0xC4,0x22,0xC2,0x26,0xC0,0x37,0x14,0x00,0x20,
    0x13,0x04,0x04,0x00,0x58,0x40,0xA5,0x67,0x93,0x87,0xA7,0x25,0x1C,0xCB,0xB7,0x47,
    0x06,0x02,0x95,0x07,0x1C,0xC3,0x58,0x40,0xB7,0x37,0x49,0x13,0x93,0x87,0x97,0xE0,
    0x5C,0xC3,0x37,0x07,0x00,0x20,0xB7,0x07,0x00,0x54,0x1C,0xC3,0xB7,0x17,0x00,0x20,
    0x93,0x87,0xC7,0x23,0x5C,0xC3,0x37,0x17,0x00,0x20,0x23,0x2E,0xF7,0x20,0x37,0x17,
    0x00,0x20,0xB7,0x17,0x00,0x20,0x93,0x87,0xC7,0x25,0x23,0x28,0xF7,0x20,0x37,0x17,
    0x00,0x20,0xB7,0x17,0x00,0x20,0x93,0x87,0xC7,0x27,0x23,0x24,0xF7,0x20,0xB7,0x17,
    0x00,0x20,0x05,0x47,0x23,0x8E,0xE7,0x2A,0xB7,0x17,0x00,0x20,0x23,0x8A,0x07,0x20,
    0xC9,0x3B,0x18,0x40,0x83,0x27,0xC7,0x1E,0xF9,0x9B,0x23,0x26,0xF7,0x1E,0x81,0x44,
    0x37,0x14,0x00,0x20,0x89,0xA0,0x83,0x45,0x44,0x21,0xB7,0x17,0x00,0x20,0x03,0xA7,
    0x07,0x00,0x93,0x96,0x15,0x00,0x89,0x47,0xB3,0x97,0xD7,0x00,0x23,0x28,0xF7,0x1E,
    0x85,0x47,0x7C,0xD3,0x3C,0x57,0xFD,0xFF,0xB7,0x17,0x00,0x20,0x03,0xC5,0xC7,0x2B,
    0x8D,0x35,0x83,0x47,0x44,0x21,0x85,0x07,0x93,0xF7,0xF7,0x0F,0x23,0x0A,0xF4,0x20,
    0x41,0x47,0x63,0x84,0xE7,0x00,0xE1,0xD0,0x01,0xA0,0x23,0x0A,0x04,0x20,0xB7,0x17,
    0x00,0x20,0x83,0xC7,0xC7,0x2B,0x85,0xC3,0xB7,0x17,0x00,0x20,0x23,0x8E,0x07,0x2A,
    0xB7,0x17,0x00,0x20,0x03,0xA7,0x07,0x00,0x83,0x27,0xC7,0x1E,0x93,0xE7,0x17,0x00,
    0x23,0x26,0xF7,0x1E,0xC9,0xBF,0x5D,0x3D,0xB7,0x17,0x00,0x20,0x03,0xA7,0x07,0x00,
    0x83,0x27,0xC7,0x1E,0xF9,0x9B,0x23,0x26,0xF7,0x1E,0xB7,0x17,0x00,0x20,0x05,0x47,
    0x23,0x8E,0xE7,0x2A,0x85,0x44,0x45,0xBF,0x09,0x86,0x19,0xCA,0x0A,0x06,0x2A,0x96,
    0x91,0x05,0x11,0x05,0x83,0xA7,0xC5,0xFF,0x23,0x2E,0xF5,0xFE,0xE3,0x1A,0xA6,0xFE,
    0x82,0x80,0x09,0x86,0x01,0xCA,0x0A,0x06,0x2A,0x96,0x11,0x05,0x23,0x2E,0xB5,0xFE,
    0xE3,0x1D,0xA6,0xFE,0x82,0x80,0x9D,0xC9,0x81,0x47,0x81,0x46,0x01,0x46,0x33,0x07,
    0xF5,0x00,0x03,0x47,0x07,0x00,0x3A,0x96,0x42,0x06,0x41,0x82,0x33,0x07,0xF7,0x02,
    0x36,0x97,0x93,0x16,0x07,0x01,0xC1,0x82,0x85,0x07,0x13,0x97,0x07,0x01,0x41,0x83,
    0xE3,0x6F,0xB7,0xFC,0xC2,0x06,0x33,0xE5,0xC6,0x00,0x82,0x80,0xAE,0x86,0x2E,0x86,
    0xD5,0xBF,0x85,0x81,0x95,0xC1,0xAA,0x87,0xFD,0x15,0xC2,0x05,0xC1,0x81,0x86,0x05,
    0x09,0x05,0x33,0x87,0xA5,0x00,0x81,0x45,0x03,0xD5,0x07,0x00,0xAA,0x95,0xC2,0x05,
    0xC1,0x81,0x89,0x07,0xE3,0x9A,0xE7,0xFE,0x2E,0x85,0x82,0x80,0x00,0x20,0x00,0x40,
    0x00,0x70,0x00,0x40,
};
#else
static const unsigned char fw_short_mcapshare[] = {

};
#endif

#endif //TYPE_OF_IC(SEMI_TOUCH_IC) == TYPE_OF_IC(SEMI_TOUCH_5472)
