#include <linux/delay.h>
#include <linux/slab.h>
#include "semi_touch_test_5448.h"
#include "semi_touch_function.h"

#if SEMI_TOUCH_FACTORY_TEST_EN

#define MAX_TX_NUM_5472                          32
#define MAX_RX_NUM_5472                          40
#define MAX_CAP_DATA_SIZE                        (MAX_TX_NUM_5472 * MAX_RX_NUM_5472 * 2)
#define SAVE_LOG_NAME                            "/sdcard/chsc_factory_test_result.txt"

#define SHORT_TEST_THL                           800
#define RAWDATA_TEST_THL                         30

 

#define MAX_KERNEL_LOG_BUFFER_SIZE               (5 * 1024)

extern int semi_touch_run_ram_code(unsigned char code);

#define semi_touch_log_file(fmt, ...) do{ memset(gFactory.catch_buffer, 0, sizeof(gFactory.catch_buffer)); sprintf(gFactory.catch_buffer, fmt, ##__VA_ARGS__); semi_touch_log_file_imp(gFactory.catch_buffer); }while(0)

const short rawdata_min[] = {
	7647,9481,9528,9486,9460,5510,200,5581,9408,9524,9568,9532,7281,
	8768,9250,9334,9302,9362,9207,9151,9216,9384,9215,9299,9297,9747,
	8767,9109,9194,9148,9214,9192,9268,9201,9227,9190,9288,9282,9757,
	8907,9290,9364,9329,9386,9322,9404,9336,9396,9325,9428,9423,9891,
	8772,9114,9188,9147,9204,9180,9269,9199,9235,9195,9295,9283,9767,
	8820,9053,9128,9093,9150,9221,9305,9242,9177,9229,9328,9321,9815,
	8669,9004,9063,9023,9080,9056,9142,9073,9106,9069,9159,9161,9654,
	8796,9054,9113,9071,9126,9181,9269,9188,9149,9188,9284,9278,9788,
	8646,8988,9039,8999,9061,9032,9115,9035,9083,9034,9124,9115,9623,
	8796,9044,9089,9048,9116,9171,9258,9184,9147,9193,9271,9271,9795,
	8762,9195,9248,9204,9262,9143,9219,9149,9277,9150,9240,9237,9763,
	8556,8991,9045,9004,9062,8935,9013,8961,9100,8959,9054,9057,9635,
	8768,9241,9294,9246,9308,9152,9223,9245,9409,9248,9340,9346,9956,
	8906,9340,9407,9354,9414,9295,9375,9415,9544,9418,9517,9533,10382,
	9598,9203,9220,9147,9169,9114,9152,9056,9067,9008,9069,9021,8684,
	9873,9426,9438,9370,9391,9409,9451,9369,9299,9314,9382,9336,8954,
	9786,9416,9434,9366,9386,9333,9382,9295,9311,9241,9309,9274,8886,
	9604,9316,9334,9265,9284,9169,9207,9114,9197,9071,9128,9094,8743,
	9724,9382,9401,9327,9352,9289,9331,9239,9259,9195,9253,9217,8853,
	9906,9426,9438,9369,9395,9473,9510,9431,9310,9390,9459,9414,9028,
	9897,9563,9572,9503,9521,9463,9501,9424,9443,9390,9442,9406,9019,
	9827,9357,9377,9307,9317,9393,9438,9352,9227,9308,9368,9329,8969,
	9795,9465,9483,9419,9435,9385,9421,9344,9346,9292,9353,9316,8939,
	9830,9345,9365,9298,9305,9421,9463,9379,9213,9333,9386,9343,8989,
	9955,9656,9693,9630,9626,9559,9602,9520,9528,9471,9511,9474,9084,
	9843,9588,9624,9584,9595,9540,9567,9497,9484,9431,9466,9417,9013,
	8894,9435,9473,9433,9412,9349,9396,9327,9340,9276,9294,9225,8229,
};
const short rawdata_max[] = {
	15881,19691,19788,19700,19646,11442,5000,11589,19538,19780,19870,19796,15121,
	18210,19210,19384,19318,19444,19121,19005,19138,19488,19137,19313,19309,20243,
	18207,18917,19094,18998,19136,19090,19248,19107,19161,19086,19288,19278,20263,
	18497,19294,19448,19373,19494,19360,19530,19388,19514,19367,19580,19569,20541,
	18218,18928,19080,18997,19114,19064,19249,19103,19179,19097,19303,19279,20285,
	18318,18801,18956,18883,19002,19151,19323,19194,19059,19167,19372,19359,20385,
	18003,18700,18821,18739,18856,18808,18986,18843,18910,18835,19021,19025,20050,
	18268,18802,18925,18839,18954,19067,19249,19082,18999,19082,19280,19268,20328,
	17956,18666,18773,18689,18819,18756,18929,18765,18863,18762,18948,18929,19985,
	18268,18782,18875,18790,18932,19047,19226,19074,18995,19091,19253,19253,20343,
	18198,19095,19206,19114,19234,18987,19145,19001,19265,19002,19188,19183,20277,
	17770,18671,18785,18698,18820,18555,18719,18609,18900,18607,18804,18809,20011,
	18208,19191,19302,19202,19330,19006,19155,19201,19539,19206,19398,19410,20676,
	18496,19398,19535,19426,19552,19305,19471,19553,19822,19558,19765,19799,21560,
	19934,19111,19148,18995,19041,18928,19008,18808,18829,18708,18833,18733,18036,
	20505,19576,19600,19460,19503,19539,19627,19457,19311,19342,19484,19388,18594,
	20322,19554,19592,19452,19494,19383,19484,19303,19337,19191,19333,19260,18454,
	19944,19348,19384,19241,19280,19041,19121,18928,19099,18839,18958,18886,18157,
	20196,19484,19525,19371,19422,19291,19379,19187,19229,19097,19215,19143,18385,
	20574,19576,19600,19457,19511,19673,19750,19585,19336,19502,19643,19550,18748,
	20553,19859,19880,19735,19773,19651,19731,19570,19611,19500,19608,19534,18731,
	20409,19431,19473,19329,19349,19507,19602,19422,19161,19332,19456,19375,18625,
	20341,19657,19695,19561,19593,19491,19565,19404,19410,19296,19425,19346,18565,
	20416,19407,19449,19310,19325,19565,19651,19479,19133,19381,19492,19403,18667,
	20675,20054,20131,20000,19990,19853,19940,19772,19786,19669,19753,19674,18866,
	20441,19912,19988,19904,19927,19812,19867,19723,19696,19585,19658,19557,18717,
	18472,19593,19673,19589,19548,19417,19512,19369,19396,19264,19300,19157,17091,
};

struct factory_test_init
{
    unsigned char rowsCnt;
    unsigned char colsCnt;
    unsigned short sensor_2_ic_map[MAX_RX_NUM_5472 + MAX_TX_NUM_5472];
    char catch_buffer[100];
    unsigned char read_buffer[MAX_CAP_DATA_SIZE];

#if FACTORY_TEST_RESULT_TO_SDCARD
    struct file * file;
#else
    char* szTestlog;
#endif
    loff_t pos;
};

static struct factory_test_init gFactory;

int semi_touch_test_prepare(void)
{
    int ret = 0, index = 0;
    //unsigned char read_buffer[256];
    struct m_ctp_cmd_std_t cmd_send_tp;
    struct m_ctp_rsp_std_t ack_from_tp;

    close_esd_function(st_dev.stc.custom_function_en);

    gFactory.pos = 0;
#if FACTORY_TEST_RESULT_TO_SDCARD
    gFactory.file = filp_open(SAVE_LOG_NAME, O_RDWR|O_CREAT|O_TRUNC, 0644);
	if(IS_ERR(gFactory.file)) {
        kernel_log_d("open file %s error\n", SAVE_LOG_NAME);
        return -EINVAL;
    }else if(NULL == gFactory.file){
        kernel_log_d("open file %s error\n", SAVE_LOG_NAME);
        return -EINVAL;
    }
#else
    gFactory.szTestlog = NULL;
    gFactory.szTestlog = kmalloc(MAX_KERNEL_LOG_BUFFER_SIZE, GFP_KERNEL);
    if(NULL == gFactory.szTestlog){
        kernel_log_d("kmalloc memory error\n");
        return -EINVAL;
    }
#endif

    msleep(50);

    cmd_send_tp.id = CMD_IDENTITY;
    ret = cmd_send_to_tp(&cmd_send_tp, &ack_from_tp, 2000);
    check_return_if_fail(ret, NULL);

    if((ack_from_tp.d0 == 0xE902) && (ack_from_tp.d1 == 0x16fd))
    {
        ret = semi_touch_read_bytes(0x20000080, gFactory.read_buffer, 256);
        check_return_if_fail(ret, NULL);

        gFactory.rowsCnt = gFactory.read_buffer[0x1a];
        gFactory.colsCnt = gFactory.read_buffer[0x19];
        for(index = 0; index < MAX_TX_NUM_5472; index++)
        {
            gFactory.sensor_2_ic_map[index] = gFactory.read_buffer[0x90 + index];
        }
        for(index = 0; index < MAX_RX_NUM_5472; index++)
        {
            gFactory.sensor_2_ic_map[index + MAX_TX_NUM_5472] = gFactory.read_buffer[0xb0 + index];
        }
    }
    else
    {
        ret = -SEMI_DRV_ERR_NO_INIT;
    }

    kernel_log_d("row = %d, col = %d\n", gFactory.rowsCnt, gFactory.colsCnt);
    
    return ret;
}

void semi_touch_log_file_imp(char* sztext)
{
#if FACTORY_TEST_RESULT_TO_SDCARD
    mm_segment_t old_fs;

    old_fs = get_fs();
	set_fs(KERNEL_DS);

    if(!IS_ERR(gFactory.file))
    {
        //gFactory.file->f_op->llseek(gFactory.file, 0, SEEK_END);
        //gFactory.file->f_op->write(gFactory.file, sztext, strlen(sztext), &gFactory.file->f_pos);

        kernel_write(gFactory.file, sztext, strlen(sztext), &gFactory.pos);
    }

    set_fs(old_fs);
#else
    if(gFactory.pos + strlen(sztext) < MAX_KERNEL_LOG_BUFFER_SIZE)
    {
        memcpy(gFactory.szTestlog + gFactory.pos, sztext, strlen(sztext));
        gFactory.pos += strlen(sztext);
    }
    
#endif
}

void semi_touch_print_matrix(short* matrix, int rows, int cols)
{
    int row = 0, col = 0;
    for(row = 0; row < rows; row++)
    {
        for(col = 0; col < cols; col++)
        {
            semi_touch_log_file("%-6d", *matrix);
            matrix++;
        }
        semi_touch_log_file("\n");
    }
    semi_touch_log_file("\n");
}

int semi_touch_rawdata_test(void)
{
    int ret = 0, raw_averate = 0, failer_cnt = 0;
    int row = 0, col = 0, channels = 0, index = 0;
    short *rawdata_p = NULL;
    const short *max_p = rawdata_max, *min_p = rawdata_min;
    unsigned short *pTail = NULL;
    struct m_ctp_cmd_std_t cmd_send_tp;
    struct m_ctp_rsp_std_t ack_from_tp;

    semi_touch_log_file("\n\n------------------------------MCap RawData Test------------------------------\n\n");

    channels = gFactory.rowsCnt * gFactory.colsCnt + gFactory.rowsCnt + gFactory.colsCnt;
    for(index = 0; index < 5; index++)
    {
        cmd_send_tp.id = CMD_CTP_SSCAN;
        cmd_send_tp.d0 = 0;
        ret = cmd_send_to_tp(&cmd_send_tp, &ack_from_tp, 200);
        check_return_if_fail(ret, NULL);

        msleep(50);

        ret = semi_touch_read_bytes(st_dev.stc.rawdata_addr, gFactory.read_buffer, (channels * 2 + 6 + 3) & 0xfffc);
        check_return_if_fail(ret, NULL);

        pTail = (unsigned short*)&gFactory.read_buffer[channels * 2];
        if(*pTail + *(pTail + 1) == 0xffff)
        {
            if(*pTail == caculate_checksum_u16( (unsigned short*)gFactory.read_buffer, channels * 2 ))
            {
                break;
            }
        }

        cmd_send_tp.id = CMD_CTP_SSCAN;
        cmd_send_tp.d0 = 1;
        ret = cmd_send_to_tp(&cmd_send_tp, &ack_from_tp, 200);
        check_return_if_fail(ret, NULL);
    }

    rawdata_p = (short*)gFactory.read_buffer;
    semi_touch_log_file("mcap_rawdata:\n");
    semi_touch_print_matrix(rawdata_p, gFactory.rowsCnt, gFactory.colsCnt);
    for(index = 0; index < gFactory.rowsCnt * gFactory.colsCnt; index++)
    {
        raw_averate += *rawdata_p;
        rawdata_p++;
    }
    raw_averate /= (gFactory.rowsCnt * gFactory.colsCnt);

    semi_touch_log_file("\navage = %d\n", raw_averate);

    rawdata_p = (short*)gFactory.read_buffer;
    for(row = 0; row < gFactory.rowsCnt; row++)
    {
        for(col = 0; col < gFactory.colsCnt; col++)
        {
            //not realy used node
            if(0 == row && 6 == col)
            {
                
            }
            else
            {
                if(*rawdata_p > *max_p)
                {
                    failer_cnt++;
                    semi_touch_log_file("node(%d, %d) out of range: %d(%d-%d)\n", row, col, *rawdata_p, *min_p, *max_p);
                }
                else if(*rawdata_p < *min_p)
                {
                    failer_cnt++;
                    semi_touch_log_file("node(%d, %d) out of range: %d(%d-%d)\n", row, col, *rawdata_p, *min_p, *max_p);
                }
            }

            min_p++;
            max_p++;
            rawdata_p++;
        }
    }

    if(failer_cnt)
    {
        semi_touch_log_file("\nrawdata test fail\n");
        return 1;
    }
    else
    {
        semi_touch_log_file("\nrawdata test pass\n");
        return 0;
    }
}

int semi_touch_short_test(void)
{
    int ret = 0, tx = 0, rx = 0, loop = 0, failer_cnt = 0;
    short *short_p = NULL, ic_channle = 0;
    unsigned int u32_para_buff[4];
    short short_maxtrix[2][MAX_RX_NUM_5472];

    semi_touch_log_file("\n\n------------------------------Short Test------------------------------\n\n");

    ret = semi_touch_run_ram_code(1/*RAM_CODE_SHORT_DATA_SHARE*/);
    check_return_if_fail(ret, NULL);

    for(loop  = 0; loop < 10; loop++)
    {
        msleep(30);
        u32_para_buff[0] = 0;

        semi_touch_read_bytes(0x20000000, (unsigned char *)u32_para_buff, 12);
        if(0x45000000 == u32_para_buff[0])
        {
            break;
        }
    }

    if(0x45000000 == u32_para_buff[0])
    {
        msleep(30);
        ret = semi_touch_read_bytes(u32_para_buff[1], gFactory.catch_buffer, (MAX_TX_NUM_5472 + MAX_RX_NUM_5472) * 2);
        check_return_if_fail(ret, NULL);

        short_p = (short*)gFactory.catch_buffer;
        for(tx = 0; tx < gFactory.rowsCnt; tx++)
        {
            ic_channle = gFactory.sensor_2_ic_map[tx];
            short_maxtrix[0][tx] = short_p[ic_channle];
        }
        for(rx = 0; rx < gFactory.colsCnt; rx++)
        {
            ic_channle = gFactory.sensor_2_ic_map[rx + MAX_TX_NUM_5472];
            short_maxtrix[1][rx] = short_p[ic_channle + MAX_TX_NUM_5472];
        }

        semi_touch_print_matrix(&short_maxtrix[0][0], 1, gFactory.rowsCnt);
        semi_touch_print_matrix(&short_maxtrix[1][0], 1, gFactory.colsCnt);

        for(tx = 0; tx < gFactory.rowsCnt; tx++)
        {
            if(short_maxtrix[0][tx] > SHORT_TEST_THL)
            {
                failer_cnt++;
                semi_touch_log_file("node(%d, %d) out of range: %d\n", 0, tx, short_maxtrix[0][tx]);
            } 
        }
        for(rx = 0; rx < gFactory.colsCnt; rx++)
        {
            if(short_maxtrix[1][rx] > SHORT_TEST_THL)
            {
                failer_cnt++;
                semi_touch_log_file("node(%d, %d) out of range: %d\n", 1, rx, short_maxtrix[1][rx]);
            }
        }
    }
    else
    {
        failer_cnt++;
    }
    
    if(failer_cnt)
    {
        semi_touch_log_file("\nshort test fail\n");
        return 2;
    }
    else
    {
        semi_touch_log_file("\nshort test pass\n");
        return 0;
    }
}

void semi_touch_factory_test_over(void)
{
#if FACTORY_TEST_RESULT_TO_SDCARD
    if(!IS_ERR(gFactory.file))
    {
        filp_close(gFactory.file, NULL);
    }
#else
    int index = 0;
    char* header = gFactory.szTestlog;
    if(gFactory.pos > 0)
    {
        for(index = 0; index < gFactory.pos; index++)
        {
            if('\n' == gFactory.szTestlog[index])
            {
                gFactory.szTestlog[index] = 0;
                kernel_log_d("%s\n", header);
                header = gFactory.szTestlog + index + 1;
            }
        }
    }
    if(NULL != gFactory.szTestlog)
    {
        kfree(gFactory.szTestlog);
        gFactory.szTestlog = NULL;
    }
#endif

    semi_touch_reset(do_report_after_reset);

    open_esd_function(st_dev.stc.custom_function_en);
}

int semi_touch_start_factory_test(void)
{
    int ret = 0;

    if(0 == ret)
        ret = semi_touch_test_prepare();
    
    if(0 == ret)
        ret = semi_touch_rawdata_test();
    
    if(0 == ret)
        ret = semi_touch_short_test();

    semi_touch_factory_test_over();

    // if(0 == ret)
    //     sprintf(detail, "rawdata test = %s\n, short test = %s\n", "PASS", "PASS");
    // else if(1 == ret)
    //     sprintf(detail, "rawdata test = %s\n", "NG");
    // else if(2 == ret)
    //     sprintf(detail, "short test = %s\n", "NG");
    // else 
    //     sprintf(detail, "exception, code = %d\n", ret);

    return ret;

}

#endif
