#ifndef _HAPTIC_H_
#define _HAPTIC_H_
#include <linux/regmap.h>
#include <linux/timer.h>
#include <linux/workqueue.h>
#include <linux/hrtimer.h>
#include <linux/mutex.h>
#include <linux/cdev.h>
#include <linux/device.h>
#include <linux/syscalls.h>


/*********************************************************
*
* marco
*
********************************************************/
/*#define AW_CHECK_RAM_DATA*/
#define AW_READ_BIN_FLEXBALLY
#define AW_OSC_COARSE_CALI
/* #define AW_ENABLE_RTP_PRINT_LOG */
#define AWINIC_DEV_NAME	("awinic_vibrator")

#define AW_RAMDATA_RD_BUFFER_SIZE	(1024)
#define AW_RAMDATA_WR_BUFFER_SIZE	(2048)
#define AW_I2C_BYTE_ONE			(1)
#define AW_I2C_BYTE_TWO			(2)
#define AW_I2C_BYTE_THREE		(3)
#define AW_I2C_BYTE_FOUR		(4)
#define AW_I2C_BYTE_FIVE		(5)
#define AW_I2C_BYTE_SIX			(6)
#define AW_I2C_BYTE_SEVEN		(7)
#define AW_I2C_BYTE_EIGHT		(8)
#define AW_SET_RAMADDR_H(addr)		((addr) >> 8)
#define AW_SET_RAMADDR_L(addr)		((addr) & 0x00FF)
#define AW_SET_BASEADDR_H(addr)		((addr) >> 8)
#define AW_SET_BASEADDR_L(addr)		((addr) & 0x00FF)
#define AW8622X_SET_AEADDR_H(addr)		((((addr) >> 1) >> 4) & 0xF0)
#define AW8622X_SET_AEADDR_L(addr)		(((addr) >> 1) & 0x00FF)
#define AW8622X_SET_AFADDR_H(addr)		((((addr) - ((addr) >> 2)) >> 8) & 0x0F)
#define AW8622X_SET_AFADDR_L(addr)		(((addr) - ((addr) >> 2)) & 0x00FF)
#define AW8622X_BIT_RTPCFG3_FIFO_AEH_MASK		(~(0x0F<<4))
#define AW8622X_BIT_RTPCFG3_FIFO_AFH_MASK		(~(0x0F<<0))
#define AW8622X_BIT_RTPCFG3_FIFO_AEH			(0x0F<<4)
#define AW8622X_BIT_RTPCFG3_FIFO_AFH			(0x0F<<0)

/********************************************
 * print information control
 *******************************************/
#define aw_dev_err(dev, format, ...) \
			pr_err("[%s]" format, dev_name(dev), ##__VA_ARGS__)

#define aw_dev_info(dev, format, ...) \
			pr_info("[%s]" format, dev_name(dev), ##__VA_ARGS__)

#define aw_dev_dbg(dev, format, ...) \
			pr_debug("[%s]" format, dev_name(dev), ##__VA_ARGS__)


enum awinic_chip_name {
	AW86223 = 0,
	AW86224_5 = 1,
	AW8624 = 2,
};

/*awinic*/
struct awinic {
	struct i2c_client *i2c;
	struct device *dev;
	unsigned char name;
	bool IsUsedIRQ;

	unsigned int aw8622x_i2c_addr;
	int reset_gpio;
	int irq_gpio;
	int reset_gpio_ret;
	int irq_gpio_ret;

	struct aw8624 *aw8624;
	struct aw8622x *aw8622x;
};


struct ram {
	unsigned int len;
	unsigned int check_sum;
	unsigned int base_addr;
	unsigned char version;
	unsigned char ram_shift;
	unsigned char baseaddr_shift;
	unsigned char ram_num;
};

struct haptic_ctr {
	unsigned char cnt;
	unsigned char cmd;
	unsigned char play;
	unsigned char wavseq;
	unsigned char loop;
	unsigned char gain;
	struct list_head list;
};

struct haptic_audio {
	struct mutex lock;
	struct hrtimer timer;
	struct work_struct work;
	int delay_val;
	int timer_val;
	struct haptic_ctr ctr;
	struct list_head ctr_list;
};

extern struct aw8624 *g_aw8624;
extern struct aw8622x *g_aw8622x;
#endif
