/*
 * (C) 2021 FCNT LIMITED
 */
// SPDX-License-Identifier: GPL-2.0

#ifndef _NONVOLATILE_H
#define _NONVOLATILE_H

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <linux/nonvolatile_common.h>

struct nv_manage_area
{
	char			nv_state[4];
	unsigned int	header_size;
	unsigned int	index_size;
	unsigned int	total_item_num;
};


struct nv_item_area_info
{
	unsigned int	data_area_offset;
	unsigned int	item_num;
	unsigned int	item_total_size;
	int				reserved;
};


#define nv_item_flag_master_clear		(1)
#define nv_item_flag_clear_type_2		(1 << 1)
#define nv_item_flag_clear_type_1		(1 << 2)
#define nv_item_flag_adjust				(1 << 3)
#define nv_item_flag_valiable			(1 << 4)
#define nv_item_flag_secure				(1 << 5)
#define nv_item_flag_active				(1 << 6)
#define nv_item_flag_enable				(1 << 7)
#define nv_item_flag_early_init_flag	(1 << 8)
#define nv_item_flag_backup				(1 << (8 + 4))

struct nv_backup_area_info
{
	uint8_t			backup_area_state[4];
	int				item_num;
	unsigned int	item_total_size;
	unsigned int	data_area_offset;
};


struct backup_item_list
{
	unsigned int	backup_item_num;
	struct nv_item	*backup_item;
};


struct nv_item_info
{
	unsigned int	item_id;
	unsigned int	item_flag;
	unsigned int	item_offset;
	unsigned int	item_size;
};


struct nv_item
{
	struct nv_item_info	item_info;
	uint8_t				*item_data;
};


struct nv_info_area
{
	struct nv_manage_area		nv_manage_area;
	struct nv_item_area_info	item_area_info[4];
	int 						nv_crypt_info;
	int 						reserved[3];
	int 						nv_version_info[12];
};


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* _NONVOLATILE_H */

