// SPDX-License-Identifier: GPL-2.0
/*
 * (C) 2021 FCNT LIMITED
 */
/* Function to enter ship mode */
#include <linux/module.h>
#include <linux/init.h>
#include <linux/slab.h>
#include <linux/wait.h>
#include <linux/kthread.h>
#include <linux/enter_ship.h>
#include <linux/soc/qcom/smem_custom.h>
#include <linux/power_supply.h>
#include <dt-bindings/iio/qti_power_supply_iio.h>

#include "smb5-lib.h"

#define ES_LOG_I(fmt, args...)		pr_info("[enter_ship]" fmt, ## args)
#define ES_LOG_E(fmt, args...)		pr_err("[enter_ship]" fmt, ## args)
#define ES_LOG_D(fmt, args...)		pr_debug("[enter_ship]" fmt, ## args)

struct enter_ship_info_local {
	struct smb_charger *chg;
	struct enter_ship_info com;
};

static int enter_ship_f(void *arg)
{
	struct enter_ship_info_local *info = (struct enter_ship_info_local *)arg;
	int rc;

	ES_LOG_I("enter_ship_func run\n");

	rc = smb5_iio_set_prop(info->chg, PSY_IIO_SET_SHIP_MODE, 1);
	if (rc < 0) {
		ES_LOG_E("error:%d\n", rc);
	}

	ES_LOG_I("enter_ship_func exit\n");
	return 0;
}

static bool enter_ship_check_repairmode(void)
{
	char *cmdline = (char *)smem_alloc_vendor0(SMEM_OEM_V0_022);
	char *boot_mode = NULL;

	if (cmdline == NULL) {
		ES_LOG_E("smem_alloc_vendor0(SMEM_OEM_V0_022) error\n");
		return false;
	}

	boot_mode = strstr(cmdline, "androidboot.mode=");
	if (boot_mode != NULL) {
		boot_mode += strlen("androidboot.mode=");

		if (strncmp(boot_mode, "repair", strlen("repair")) == 0) {
			ES_LOG_I("is_repairmode\n");
			return true;
		}
	}

	return false;
}

int enter_ship_init(struct smb_charger *chg)
{
	int ret = 0;
	struct enter_ship_info_local *info;
	struct enter_ship_info **com;

	if (!enter_ship_check_repairmode())
		goto out;

	info = kzalloc(sizeof(struct enter_ship_info_local), GFP_KERNEL);
	if (info == NULL) {
		ES_LOG_E("kzalloc error\n");
		ret = -ENOMEM;
		goto out;
	}

	chg->wa_flags &= ~SW_THERM_REGULATION_WA;
	info->chg = chg;
	info->com.func = &enter_ship_f;
	info->com.arg = info;

	com = (struct enter_ship_info **)smem_alloc_vendor0(SMEM_OEM_V0_023);
	if (com == NULL) {
		ES_LOG_E("smem_alloc_vendor0(SMEM_OEM_V0_023) error\n");
		ret = -ENOMEM;
		goto out;
	}
	*com = &info->com;
out:
	return ret;
}

MODULE_LICENSE("GPL v2");
