/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2020-2021 The Linux Foundation. All rights reserved.
 */

#ifndef _DT_BINDINGS_QCOM_SPMI_VADC_PM7325B_H
#define _DT_BINDINGS_QCOM_SPMI_VADC_PM7325B_H

#ifndef PM7325B_SID
#define PM7325B_SID					3
#endif

/* ADC channels for PM7325B_ADC for PMIC7 */
#define PM7325B_ADC7_REF_GND			(PM7325B_SID << 8 | 0x0)
#define PM7325B_ADC7_1P25VREF			(PM7325B_SID << 8 | 0x01)
#define PM7325B_ADC7_VREF_VADC			(PM7325B_SID << 8 | 0x02)
#define PM7325B_ADC7_DIE_TEMP			(PM7325B_SID << 8 | 0x03)

#define PM7325B_ADC7_AMUX_THM1			(PM7325B_SID << 8 | 0x04)
#define PM7325B_ADC7_AMUX_THM2			(PM7325B_SID << 8 | 0x05)
#define PM7325B_ADC7_AMUX_THM3			(PM7325B_SID << 8 | 0x06)
#define PM7325B_ADC7_AMUX_THM4			(PM7325B_SID << 8 | 0x07)
#define PM7325B_ADC7_AMUX_THM5			(PM7325B_SID << 8 | 0x08)
#define PM7325B_ADC7_AMUX_THM6			(PM7325B_SID << 8 | 0x09)
#define PM7325B_ADC7_GPIO1			(PM7325B_SID << 8 | 0x0a)
#define PM7325B_ADC7_GPIO2			(PM7325B_SID << 8 | 0x0b)
#define PM7325B_ADC7_GPIO3			(PM7325B_SID << 8 | 0x0c)
#define PM7325B_ADC7_GPIO4			(PM7325B_SID << 8 | 0x0d)

#define PM7325B_ADC7_CHG_TEMP			(PM7325B_SID << 8 | 0x10)
#define PM7325B_ADC7_USB_IN_V_16		(PM7325B_SID << 8 | 0x11)
#define PM7325B_ADC7_CC1_ID			(PM7325B_SID << 8 | 0x13)
#define PM7325B_ADC7_VREF_BAT_THERM		(PM7325B_SID << 8 | 0x15)
#define PM7325B_ADC7_IIN_FB                    (PM7325B_SID << 8 | 0x17)
#define PM7325B_ADC7_ICHG_FB			(PM7325B_SID << 8 | 0xa1)

/* 30k pull-up1 */
#define PM7325B_ADC7_AMUX_THM1_30K_PU		(PM7325B_SID << 8 | 0x24)
#define PM7325B_ADC7_AMUX_THM2_30K_PU		(PM7325B_SID << 8 | 0x25)
#define PM7325B_ADC7_AMUX_THM3_30K_PU		(PM7325B_SID << 8 | 0x26)
#define PM7325B_ADC7_AMUX_THM4_30K_PU		(PM7325B_SID << 8 | 0x27)
#define PM7325B_ADC7_AMUX_THM5_30K_PU		(PM7325B_SID << 8 | 0x28)
#define PM7325B_ADC7_AMUX_THM6_30K_PU		(PM7325B_SID << 8 | 0x29)
#define PM7325B_ADC7_GPIO1_30K_PU		(PM7325B_SID << 8 | 0x2a)
#define PM7325B_ADC7_GPIO2_30K_PU		(PM7325B_SID << 8 | 0x2b)
#define PM7325B_ADC7_GPIO3_30K_PU		(PM7325B_SID << 8 | 0x2c)
#define PM7325B_ADC7_GPIO4_30K_PU		(PM7325B_SID << 8 | 0x2d)
#define PM7325B_ADC7_CC1_ID_30K_PU		(PM7325B_SID << 8 | 0x33)

/* 100k pull-up2 */
#define PM7325B_ADC7_AMUX_THM1_100K_PU		(PM7325B_SID << 8 | 0x44)
#define PM7325B_ADC7_AMUX_THM2_100K_PU		(PM7325B_SID << 8 | 0x45)
#define PM7325B_ADC7_AMUX_THM3_100K_PU		(PM7325B_SID << 8 | 0x46)
#define PM7325B_ADC7_AMUX_THM4_100K_PU		(PM7325B_SID << 8 | 0x47)
#define PM7325B_ADC7_AMUX_THM5_100K_PU		(PM7325B_SID << 8 | 0x48)
#define PM7325B_ADC7_AMUX_THM6_100K_PU		(PM7325B_SID << 8 | 0x49)
#define PM7325B_ADC7_GPIO1_100K_PU		(PM7325B_SID << 8 | 0x4a)
#define PM7325B_ADC7_GPIO2_100K_PU		(PM7325B_SID << 8 | 0x4b)
#define PM7325B_ADC7_GPIO3_100K_PU		(PM7325B_SID << 8 | 0x4c)
#define PM7325B_ADC7_GPIO4_100K_PU		(PM7325B_SID << 8 | 0x4d)
#define PM7325B_ADC7_CC1_ID_100K_PU		(PM7325B_SID << 8 | 0x53)

/* 400k pull-up3 */
#define PM7325B_ADC7_AMUX_THM1_400K_PU		(PM7325B_SID << 8 | 0x64)
#define PM7325B_ADC7_AMUX_THM2_400K_PU		(PM7325B_SID << 8 | 0x65)
#define PM7325B_ADC7_AMUX_THM3_400K_PU		(PM7325B_SID << 8 | 0x66)
#define PM7325B_ADC7_AMUX_THM4_400K_PU		(PM7325B_SID << 8 | 0x67)
#define PM7325B_ADC7_AMUX_THM5_400K_PU		(PM7325B_SID << 8 | 0x68)
#define PM7325B_ADC7_AMUX_THM6_400K_PU		(PM7325B_SID << 8 | 0x69)
#define PM7325B_ADC7_GPIO1_400K_PU		(PM7325B_SID << 8 | 0x6a)
#define PM7325B_ADC7_GPIO2_400K_PU		(PM7325B_SID << 8 | 0x6b)
#define PM7325B_ADC7_GPIO3_400K_PU		(PM7325B_SID << 8 | 0x6c)
#define PM7325B_ADC7_GPIO4_400K_PU		(PM7325B_SID << 8 | 0x6d)
#define PM7325B_ADC7_CC1_ID_400K_PU		(PM7325B_SID << 8 | 0x73)

/* 1/3 Divider */
#define PM7325B_ADC7_GPIO1_DIV3			(PM7325B_SID << 8 | 0x8a)
#define PM7325B_ADC7_GPIO2_DIV3			(PM7325B_SID << 8 | 0x8b)
#define PM7325B_ADC7_GPIO3_DIV3			(PM7325B_SID << 8 | 0x8c)
#define PM7325B_ADC7_GPIO4_DIV3			(PM7325B_SID << 8 | 0x8d)

#define PM7325B_ADC7_VPH_PWR			(PM7325B_SID << 8 | 0x8e)
#define PM7325B_ADC7_VBAT_SNS			(PM7325B_SID << 8 | 0x8f)

#define PM7325B_ADC7_SBUx			(PM7325B_SID << 8 | 0x94)
#define PM7325B_ADC7_V_I_BAT_THERM		(PM7325B_SID << 8 | 0xb8)

#endif /* _DT_BINDINGS_QCOM_SPMI_VADC_PM7325B_H */
