/*
 * Copyright (c) 2003, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package test.java.net.InetAddress;

/**
 * @test
 * @bug 4639861 8133015
 * @summary API to test reachability of a host
 */
import java.net.InetAddress;
import java.io.IOException;
import java.net.NetworkInterface;
import org.testng.annotations.Test;
import static org.testng.Assert.fail;

public class IsReachable {
    @Test
    public void testIsReachable() {
        try {
            InetAddress addr = InetAddress.getByName("localhost");
            if (!addr.isReachable(10000))
                fail("Localhost should always be reachable");
            NetworkInterface inf = NetworkInterface.getByInetAddress(addr);
            if (inf != null) {
                if (!addr.isReachable(inf, 20, 10000))
                    fail("Localhost should always be reachable");
            }
        } catch (IOException e) {
            fail("Unexpected exception:" + e);
        }
    }
}