/*
 * Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * Portions Copyright (c) 2011 IBM Corporation
 */

/*
 * @test
 * @bug 6312706
 * @summary Iterator.remove() from Map.entrySet().iterator() invalidates returned Entry.
 * @author Neil Richards <neil.richards@ngmr.net>, <neil_richards@uk.ibm.com>
 */
package test.java.util.EnumMap;

import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;

import org.testng.Assert;
import org.testng.annotations.Test;

public class EntrySetIteratorRemoveInvalidatesEntry {
    static enum TestEnum { e00, e01, e02 }

    @Test
    public void testInvalidatesEntry() throws Exception {
        final EnumMap<TestEnum, String> enumMap = new EnumMap<>(TestEnum.class);

        for (TestEnum e : TestEnum.values()) {
            enumMap.put(e, e.name());
        }

        Iterator<Map.Entry<TestEnum, String>> entrySetIterator =
                enumMap.entrySet().iterator();
        Map.Entry<TestEnum, String> entry = entrySetIterator.next();

        entrySetIterator.remove();

        try {
            entry.getKey();
            Assert.fail();
        } catch (Exception e) { }
    }
}