/*
 * Copyright (c) 2016, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * @test
 * @bug 8139233
 * @summary ensure entry set's iterator doesn't have side effects on the entry set
 * @run testng EntrySetIterator
 */
package test.java.util.Map;

import java.util.*;
import org.testng.annotations.Test;
import static org.testng.Assert.assertTrue;
import static org.testng.Assert.assertEquals;

public class EntrySetIterator {
    @Test
    public void testEntrySetIterator() {
        Map<String, String> map = Map.of("a", "1", "b", "2", "c", "3");
        Set<Map.Entry<String, String>> entrySet = map.entrySet();
        Iterator<Map.Entry<String, String>> iterator = entrySet.iterator();

        assertTrue(iterator.hasNext());

        // copying implicitly iterates an iterator
        Set<Map.Entry<String, String>> copy1 = new HashSet<>(entrySet);
        Set<Map.Entry<String, String>> copy2 = new HashSet<>(entrySet);

        assertEquals(copy2, copy1);
        assertTrue(iterator.hasNext());
    }
}