<?php
/**
 * Provide an admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://mxchat.ai/
 * @since      1.0.0
 *
 * @package    MxChat_Assistant_API
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

$options = get_option('mxchat_assistant_api_options', array());
$main_plugin_options = get_option('mxchat_options', array());
$api_key = $main_plugin_options['api_key'] ?? '';
?>

<div class="mxchat-assistant-api-wrap">
    <!-- Header Section with Gradient -->
    <div class="mxchat-assistant-api-header">
        <div class="mxchat-assistant-api-header-content">
            <h1 class="mxchat-assistant-api-title">
                <span class="mxchat-gradient-text">Assistant</span> 
                <span class="mxchat-gradient-text-secondary">API</span> 
                Manager
            </h1>
            <p class="mxchat-assistant-api-subtitle">
                Connect your custom OpenAI Assistant with advanced MxChat action integration. 
                Your Assistant handles conversations while maintaining access to most MxChat features.
            </p>
        </div>
    </div>

    <!-- Main Content -->
    <div class="mxchat-assistant-api-content">
        
        <!-- Status Notice -->
        <?php if (($options['enabled'] ?? '') === 'on'): ?>
            <div class="mxchat-notice mxchat-notice-warning">
                <div class="mxchat-notice-icon">⚠️</div>
                <div class="mxchat-notice-content">
                    <strong>Assistant API is currently ACTIVE</strong><br>
                    All chat requests are being handled by OpenAI Assistant ID: 
                    <code><?php echo esc_html($options['assistant_id'] ?? 'Not Set'); ?></code>
                </div>
            </div>
        <?php endif; ?>

        <!-- Setup Guide -->
        <div class="mxchat-card">
            <div class="mxchat-card-header">
                <h2>Setup Guide</h2>
                <p>Follow these steps to set up your OpenAI Assistant with MxChat integration.</p>
            </div>
            
            <div class="mxchat-steps">
                <div class="mxchat-step">
                    <div class="mxchat-step-number">1</div>
                    <div class="mxchat-step-content">
                        <h3>Configure OpenAI API Key</h3>
                        <p>Make sure your OpenAI API key is configured in 
                           <a href="<?php echo admin_url('admin.php?page=mxchat-max'); ?>">MxChat Settings</a>.
                        </p>
                        <?php if (!empty($api_key)): ?>
                            <div class="mxchat-status-indicator mxchat-status-success">
                                ✓ API Key Configured
                            </div>
                        <?php else: ?>
                            <div class="mxchat-status-indicator mxchat-status-error">
                                ✗ API Key Not Found
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="mxchat-step">
                    <div class="mxchat-step-number">2</div>
                    <div class="mxchat-step-content">
                        <h3>Create OpenAI Assistant</h3>
                        <p>Create a custom Assistant in your 
                           <a href="https://platform.openai.com/assistants" target="_blank">OpenAI Dashboard</a> 
                           with your desired instructions and capabilities.
                        </p>
                        <div class="mxchat-status-indicator mxchat-status-info">
                            💡 Your Assistant will automatically have access to MxChat actions
                        </div>
                    </div>
                </div>

                <div class="mxchat-step">
                    <div class="mxchat-step-number">3</div>
                    <div class="mxchat-step-content">
                        <h3>Enter Assistant ID</h3>
                        <p>Copy your Assistant ID (starts with "asst_") and enter it in the configuration below.</p>
                        <?php if (!empty($options['assistant_id'])): ?>
                            <div class="mxchat-status-indicator mxchat-status-success">
                                ✓ Assistant ID: <?php echo esc_html(substr($options['assistant_id'], 0, 12)) . '...'; ?>
                            </div>
                        <?php else: ?>
                            <div class="mxchat-status-indicator mxchat-status-warning">
                                ⚠ No Assistant ID entered
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="mxchat-step">
                    <div class="mxchat-step-number">4</div>
                    <div class="mxchat-step-content">
                        <h3>Enable Assistant API</h3>
                        <p>Check "Enable Assistant API" in the configuration below and save to activate the integration.</p>
                        <?php if (($options['enabled'] ?? '') === 'on'): ?>
                            <div class="mxchat-status-indicator mxchat-status-success">
                                ✓ Assistant API Active with Action Integration
                            </div>
                        <?php else: ?>
                            <div class="mxchat-status-indicator mxchat-status-inactive">
                                ○ Assistant API Disabled
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="mxchat-step">
                    <div class="mxchat-step-number">5</div>
                    <div class="mxchat-step-content">
                        <h3>Test & Monitor</h3>
                        <p>Use the testing panel to monitor action similarity scores and verify integration.</p>
                        <div class="mxchat-status-indicator mxchat-status-info">
                            🔧 Action scores are visible in the admin testing interface
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Configuration Form -->
        <div class="mxchat-card">
            <div class="mxchat-card-header">
                <h2>Configuration</h2>
                <p>Set up your OpenAI Assistant to work alongside MxChat's powerful action system.</p>
            </div>
            
            <form method="post" action="options.php" class="mxchat-assistant-api-form">
                <?php settings_fields('mxchat_assistant_api'); ?>
                <?php do_settings_sections('mxchat_assistant_api'); ?>
                
                <div class="mxchat-form-actions">
                    <?php submit_button(__('Save Configuration', 'mxchat-assistant-api'), 'primary', 'submit', false); ?>
                </div>
            </form>
        </div>

        <!-- Action Support & Roadmap -->
        <div class="mxchat-card">
            <div class="mxchat-card-header">
                <h2>Action Support & Roadmap</h2>
                <p>Current status and upcoming features for MxChat action integration with your Assistant.</p>
            </div>
            
            <div class="mxchat-action-roadmap">
                <!-- Supported Actions -->
                <div class="mxchat-roadmap-section">
                    <h3>✅ Currently Supported Actions</h3>
                    <ul class="mxchat-action-list mxchat-action-supported">
                        <li>Image Generation</li>
                        <li>Brave Image Search</li>
                        <li>Show Product Card</li>
                        <li>Order History</li>
                        <li>Back to Chatbot</li>
                        <li>MxChat Forms</li>
                        <li>Loops Action</li>
                    </ul>
                </div>

                <!-- Coming Soon -->
                <div class="mxchat-roadmap-section">
                    <h3>🔄 Coming Soon</h3>
                    <ul class="mxchat-action-list mxchat-action-coming">
                        <li>Smart Recommender <span class="mxchat-badge-small">In Development</span></li>
                        <li>WooCommerce Recommender <span class="mxchat-badge-small">In Development</span></li>
                        <li>Chat with PDF <span class="mxchat-badge-small">In Development</span></li>
                        <li>Transfer to Slack <span class="mxchat-badge-small">In Development</span></li>
                        <li>Streaming Responses <span class="mxchat-badge-small">High Priority</span></li>
                    </ul>
                </div>

            </div>

            <div class="mxchat-notice mxchat-notice-info" style="margin-top: 20px;">
                <div class="mxchat-notice-icon">💡</div>
                <div class="mxchat-notice-content">
                    <strong>Action Testing:</strong> You can see action similarity scores and test integrations in the Admin Debugger panel when Assistant API is enabled.
                </div>
            </div>
        </div>
    </div>
</div>