<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="mxchat-card" id="form-editor" style="display: none;">
    <div class="mxchat-card-header">
        <h2 id="editor-title"><?php esc_html_e('Create Form', 'mxchat-forms'); ?></h2>
        <button type="button" class="mxchat-button secondary" id="close-editor">
            <span class="dashicons dashicons-no-alt"></span>
        </button>
    </div>

    <form id="mxchat-form-editor">
        <input type="hidden" name="form_id" id="form_id" value="">

        <div class="form-group">
            <label for="form_title"><?php esc_html_e('Form Title', 'mxchat-forms'); ?></label>
            <input type="text" id="form_title" name="title" class="regular-text" required>
            <p class="description">
                <?php esc_html_e('Give your form a descriptive title.', 'mxchat-forms'); ?>
            </p>
        </div>

        <div class="form-group">
            <label><?php esc_html_e('Form Fields', 'mxchat-forms'); ?></label>
            <div id="form-fields"></div>
            <div class="field-actions">
                <button type="button" class="mxchat-button secondary add-field">
                    <span class="dashicons dashicons-plus"></span>
                    <?php esc_html_e('Add Field', 'mxchat-forms'); ?>
                </button>
            </div>
        </div>

        <div class="form-group">
            <label for="trigger_phrases"><?php esc_html_e('Trigger Phrases (required)', 'mxchat-forms'); ?></label>
            <textarea id="trigger_phrases" name="trigger_phrases" rows="4" class="large-text" 
                      placeholder="<?php esc_attr_e('Enter one phrase per line', 'mxchat-forms'); ?>"></textarea>
            <p class="description">
                <?php esc_html_e('Enter phrases that will trigger this form in the chat. One phrase per line.', 'mxchat-forms'); ?>
            </p>
        </div>
        
        <!-- Add this new form-group after the trigger phrases section -->
        <div class="form-group">
            <label for="message_count"><?php esc_html_e('Trigger After X Messages', 'mxchat-forms'); ?></label>
            <input type="number" id="message_count" name="message_count" min="0" value="0" class="small-text">
            <p class="description">
                <?php esc_html_e('Optionally trigger this form after a specific number of messages in the conversation (0 = disabled).', 'mxchat-forms'); ?>
            </p>
        </div>
        
        <div class="form-group">
            <label for="allowed_roles"><?php esc_html_e('Allowed User Roles', 'mxchat-forms'); ?></label>
            <select id="allowed_roles" name="allowed_roles[]" multiple="multiple" class="regular-text">
                <option value="all" selected><?php esc_html_e('All Users', 'mxchat-forms'); ?></option>
                <option value="visitor"><?php esc_html_e('Visitors (Not Logged In)', 'mxchat-forms'); ?></option>
                <?php
                $roles = wp_roles()->get_names();
                foreach ($roles as $role_id => $role_name) {
                    echo '<option value="' . esc_attr($role_id) . '">' . esc_html($role_name) . '</option>';
                }
                ?>
            </select>
            <p class="description">
                <?php esc_html_e('Select which users this form will trigger for. If "All Users" is selected, the form will trigger for everyone.', 'mxchat-forms'); ?>
            </p>
        </div>
        
        <div class="form-group">
            <label for="response_message"><?php esc_html_e('Response Message', 'mxchat-forms'); ?></label>
            <textarea id="response_message" name="response_message" rows="3" class="large-text" 
                      placeholder="<?php esc_attr_e('Enter a custom response message to display after form submission', 'mxchat-forms'); ?>"></textarea>
            <p class="description">
                <?php esc_html_e('This message will be shown to the user after they submit the form.', 'mxchat-forms'); ?>
            </p>
        </div>
        
        <div class="form-group form-options">
            <label class="checkbox-label">
                <input type="checkbox" name="blocks_chat" id="form_blocks_chat">
                <?php esc_html_e('Block chat until submitted', 'mxchat-forms'); ?>
            </label>
            <p class="description">
                <?php esc_html_e('If enabled, users cannot send new messages until they submit this form.', 'mxchat-forms'); ?>
            </p>
        </div>
        
        <div class="form-group">
            <label for="notification_email"><?php esc_html_e('Notification Email', 'mxchat-forms'); ?></label>
            <input type="email" id="notification_email" name="notification_email" class="regular-text" 
                   placeholder="<?php esc_attr_e('example@yourdomain.com', 'mxchat-forms'); ?>">
            <p class="description">
                <?php esc_html_e('Optionally specify an email address to receive form submissions. If left blank, the WordPress admin email will be used.', 'mxchat-forms'); ?>
            </p>
        </div>
        
        <div class="form-group">
            <label for="similarity_threshold"><?php esc_html_e('Intent Recognition Threshold', 'mxchat-forms'); ?></label>
            <div class="similarity-slider-container">
                <input type="range" id="similarity_threshold" name="similarity_threshold" min="0.1" max="1" step="0.05" value="0.85" class="similarity-slider">
                <div class="similarity-value"><span id="similarity_value">85</span>%</div>
            </div>
            <p class="description">
                <?php esc_html_e('Set how closely a user message must match your trigger phrases (higher values require closer matches).', 'mxchat-forms'); ?>
            </p>
        </div>
        
        <div class="form-group">
            <label for="regex_pattern"><?php esc_html_e('Regex Match Pattern (Optional)', 'mxchat-forms'); ?></label>
            <input type="text" id="regex_pattern" name="regex_pattern" class="regular-text" 
                   placeholder="<?php esc_attr_e('e.g. contact|support|help', 'mxchat-forms'); ?>">
            <p class="description">
                <?php esc_html_e('If specified, the user\'s message must match both the similarity threshold AND this regex pattern. Leave empty to only use similarity matching.', 'mxchat-forms'); ?>
            </p>
        </div>

        <div class="form-group form-options">
            <label class="checkbox-label">
                <input type="checkbox" name="enabled" id="form_enabled" checked>
                <?php esc_html_e('Enable this form', 'mxchat-forms'); ?>
            </label>
        </div>

        <!-- Field Template (Hidden) -->
        <template id="field-template">
            <div class="form-field" data-field-id="{id}">
                <div class="field-header">
                    <div class="field-move-actions">
                        <button type="button" class="field-move-up" title="<?php esc_attr_e('Move Up', 'mxchat-forms'); ?>">
                            <span class="dashicons dashicons-arrow-up-alt2"></span>
                        </button>
                        <button type="button" class="field-move-down" title="<?php esc_attr_e('Move Down', 'mxchat-forms'); ?>">
                            <span class="dashicons dashicons-arrow-down-alt2"></span>
                        </button>
                    </div>
                    <span class="field-title">New Field</span>
                    <div class="field-actions">
                        <button type="button" class="field-toggle">
                            <span class="dashicons dashicons-arrow-down-alt2"></span>
                        </button>
                        <button type="button" class="field-remove">
                            <span class="dashicons dashicons-trash"></span>
                        </button>
                    </div>
                </div>
                <div class="field-content">
                    <div class="field-row">
                        <label><?php esc_html_e('Field Type', 'mxchat-forms'); ?></label>
                        <select name="fields[{id}][type]" class="field-type">
                            <option value="static"><?php esc_html_e('Static Text', 'mxchat-forms'); ?></option>
                            <option value="text"><?php esc_html_e('Single Line Input', 'mxchat-forms'); ?></option>
                            <option value="textarea"><?php esc_html_e('Message', 'mxchat-forms'); ?></option>
                            <option value="email"><?php esc_html_e('Email', 'mxchat-forms'); ?></option>
                            <option value="tel"><?php esc_html_e('Phone', 'mxchat-forms'); ?></option>
                        </select>
                    </div>
                    <div class="field-row">
                        <label><?php esc_html_e('Field Label', 'mxchat-forms'); ?></label>
                        <input type="text" name="fields[{id}][label]" class="field-label" required>
                    </div>
                    <div class="field-row">
                        <label class="checkbox-label">
                            <input type="checkbox" name="fields[{id}][required]" class="field-required">
                            <?php esc_html_e('Required Field', 'mxchat-forms'); ?>
                        </label>
                    </div>
                </div>
            </div>
        </template>

        <div class="form-actions">
            <button type="submit" class="mxchat-button primary">
                <?php esc_html_e('Save Form', 'mxchat-forms'); ?>
            </button>
            <button type="button" class="mxchat-button secondary" id="cancel-edit">
                <?php esc_html_e('Cancel', 'mxchat-forms'); ?>
            </button>
        </div>
    </form>
</div>