<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Get forms
$form_handler = new MxChat_Forms_Form_Handler();
$forms = $form_handler->get_forms();
?>

<div class="wrap mxchat-wrapper">
    <div class="mxchat-hero">
        <h1 class="mxchat-main-title">
            <span class="mxchat-gradient-text">Form</span> Collection
        </h1>
        <p class="mxchat-hero-subtitle">
            <?php esc_html_e('Create and manage forms to collect information from your chat users.', 'mxchat-forms'); ?>
        </p>
    </div>

    <div class="mxchat-content">
        <!-- Forms List -->
        <div class="mxchat-card" id="forms-list">
            <div class="mxchat-card-header">
                <h2><?php esc_html_e('Your Forms', 'mxchat-forms'); ?></h2>
                <button type="button" class="mxchat-button primary" id="create-form">
                    <?php esc_html_e('Create New Form', 'mxchat-forms'); ?>
                </button>
            </div>

            <table class="wp-list-table widefat fixed striped">
                <thead>
                    <tr>
                        <th><?php esc_html_e('Title', 'mxchat-forms'); ?></th>
                        <th><?php esc_html_e('Fields', 'mxchat-forms'); ?></th>
                        <th><?php esc_html_e('Trigger Phrases', 'mxchat-forms'); ?></th>
                        <th><?php esc_html_e('Created', 'mxchat-forms'); ?></th>
                        <th><?php esc_html_e('Status', 'mxchat-forms'); ?></th>
                        <th><?php esc_html_e('Actions', 'mxchat-forms'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($forms)) : ?>
                        <tr>
                            <td colspan="6"><?php esc_html_e('No forms created yet.', 'mxchat-forms'); ?></td>
                        </tr>
                    <?php else : ?>
                        <?php foreach ($forms as $form) : ?>
                            <tr>
                                <td><?php echo esc_html($form->title); ?></td>
                                <td><?php echo count($form->fields); ?></td>
                                <td><?php echo esc_html($form->trigger_phrases); ?></td>
                                <td><?php echo esc_html(date_i18n(get_option('date_format'), strtotime($form->created_at))); ?></td>
                                <td>
                                    <span class="mxchat-status-badge <?php echo $form->enabled ? 'active' : 'inactive'; ?>">
                                        <?php echo $form->enabled ? esc_html__('Active', 'mxchat-forms') : esc_html__('Inactive', 'mxchat-forms'); ?>
                                    </span>
                                </td>
                                <td>
                                    <div class="mxchat-action-buttons">
                                        <button type="button" class="mxchat-button secondary edit-form" 
                                                data-id="<?php echo esc_attr($form->id); ?>">
                                            <?php esc_html_e('Edit', 'mxchat-forms'); ?>
                                        </button>
                                        <button type="button" class="mxchat-button secondary delete-form" 
                                                data-id="<?php echo esc_attr($form->id); ?>">
                                            <?php esc_html_e('Delete', 'mxchat-forms'); ?>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        
        
        <!-- Form Editor -->
        <?php include('form-editor.php'); ?>
        
            <?php 
    // Include message count testing tools for admins
    if (current_user_can('manage_options')) {
        include('message-count-tools.php');
    }
    ?>

        <!-- Submissions -->
        <?php include('submissions-table.php'); ?>
    </div>
</div>