<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Get current user's message count
$user_id = get_current_user_id();
$rate_limit_transient_key = 'mxchat_chat_limit_' . $user_id;
$chat_count = get_transient($rate_limit_transient_key);
$chat_count = ($chat_count !== false) ? $chat_count : 0;

// Get current user's session ID from cookie
$session_id = '';
if (isset($_COOKIE['mxchat_session_id'])) {
    $session_id = sanitize_text_field($_COOKIE['mxchat_session_id']);
}
?>

<div class="mxchat-card" id="message-count-tools">
    <div class="mxchat-card-header">
        <h2><?php esc_html_e('Message Count Testing Tools', 'mxchat-forms'); ?></h2>
    </div>
    <div class="mxchat-card-content" style="padding: 15px;">
        <div class="mxchat-message-count-info">
            <p>
                <strong><?php esc_html_e('Your current message count:', 'mxchat-forms'); ?></strong> 
                <span id="current-message-count"><?php echo intval($chat_count); ?></span>
            </p>
            <?php if (!empty($session_id)): ?>
            <p>
                <strong><?php esc_html_e('Your current session ID:', 'mxchat-forms'); ?></strong>
                <span id="current-session-id"><?php echo esc_html($session_id); ?></span>
            </p>
            <?php endif; ?>
            <p class="description">
                <?php esc_html_e('Use this information to test your message count-based form triggers. Forms set to trigger at exactly this number will appear on your next chat message.', 'mxchat-forms'); ?>
            </p>
        </div>
        <div class="mxchat-message-count-actions" style="margin-top: 10px;">
            <button type="button" id="reset-message-count" class="mxchat-button secondary">
                <?php esc_html_e('Reset Your Message Count', 'mxchat-forms'); ?>
            </button>
            <p class="description" style="margin-top: 5px;">
                <?php esc_html_e('This will reset your personal message count to zero, allowing you to test form triggers from the beginning.', 'mxchat-forms'); ?>
            </p>
        </div>
    </div>
</div>