<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Get submissions
$submissions_handler = new MxChat_Forms_Submissions();
$submissions = $submissions_handler->get_submissions();
?>

<div class="mxchat-card" id="submissions-list">
    
<div class="mxchat-card-header">
    <h2><?php esc_html_e('Form Submissions', 'mxchat-forms'); ?></h2>
    <?php if (!empty($submissions)) : ?>
        <div class="mxchat-card-actions">
            <button type="button" class="mxchat-button secondary" id="export-submissions">
                <?php esc_html_e('Export CSV', 'mxchat-forms'); ?>
            </button>
            <button type="button" class="mxchat-button danger" id="delete-all-submissions">
                <?php esc_html_e('Delete All', 'mxchat-forms'); ?>
            </button>
        </div>
    <?php endif; ?>
</div>

    <?php if (empty($submissions)) : ?>
        <p class="mxchat-no-data">
            <?php esc_html_e('No submissions yet.', 'mxchat-forms'); ?>
        </p>
    <?php else : ?>
        <div class="mxchat-table-container">
            <table class="wp-list-table widefat fixed striped">
                <thead>
                    <tr>
                        <th><?php esc_html_e('Date', 'mxchat-forms'); ?></th>
                        <th><?php esc_html_e('Form', 'mxchat-forms'); ?></th>
                        <th><?php esc_html_e('Submitted Data', 'mxchat-forms'); ?></th>
                        <th><?php esc_html_e('User', 'mxchat-forms'); ?></th>
                        <th><?php esc_html_e('Session ID', 'mxchat-forms'); ?></th>
                        <th><?php esc_html_e('Actions', 'mxchat-forms'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($submissions as $submission) : ?>
                        <tr>
                            <td>
                                <?php echo esc_html(date_i18n(
                                    get_option('date_format') . ' ' . get_option('time_format'),
                                    strtotime($submission->created_at)
                                )); ?>
                            </td>
                            <td><?php echo esc_html($submission->form_title); ?></td>
                            <td class="submission-data">
                                <?php if (!empty($submission->submission_data)) : ?>
                                    <div class="submission-data-preview">
                                        <?php foreach ($submission->submission_data as $key => $value) : ?>
                                            <div class="data-row">
                                                <strong><?php echo esc_html($key); ?>:</strong>
                                                <?php echo esc_html($value); ?>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php
                                if ($submission->user_id) {
                                    $user = get_userdata($submission->user_id);
                                    echo $user ? esc_html($user->display_name) : esc_html__('Deleted User', 'mxchat-forms');
                                } else {
                                    esc_html_e('Guest', 'mxchat-forms');
                                }
                                ?>
                            </td>
                            <td>
                                <span class="session-id" title="<?php echo esc_attr($submission->session_id); ?>">
                                    <?php echo esc_html(substr($submission->session_id, 0, 8) . '...'); ?>
                                </span>
                            </td>
                            <td>
                                <div class="mxchat-action-buttons">
                                    <button type="button" 
                                            class="mxchat-button secondary view-submission" 
                                            data-id="<?php echo esc_attr($submission->id); ?>">
                                        <?php esc_html_e('View', 'mxchat-forms'); ?>
                                    </button>
                                    <button type="button" 
                                            class="mxchat-button secondary delete-submission" 
                                            data-id="<?php echo esc_attr($submission->id); ?>">
                                        <?php esc_html_e('Delete', 'mxchat-forms'); ?>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Submission Detail Modal Template -->
        <div id="submission-modal" class="mxforms-modal" style="display: none;">
            <div class="mxforms-modal__content">
                <div class="mxforms-modal__header">
                    <h3><?php esc_html_e('Submission Details', 'mxchat-forms'); ?></h3>
                    <button type="button" class="mxforms-modal__close" id="mxforms-close-x">
                        <span class="dashicons dashicons-no-alt"></span>
                    </button>
                </div>
                <div class="mxforms-modal__body">
                    <!-- Content will be dynamically populated -->
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>