# MxChat Migration Tool - Installation Guide

## Quick Start

### Prerequisites

1. **MxChat Basic Plugin** must be installed and activated
2. **WordPress** 5.0 or higher
3. **PHP** 7.4 or higher
4. Valid API keys for embedding models

### Installation Steps

#### Option 1: Manual Installation (Recommended for Development)

1. **Upload Plugin Files**
   ```
   - Navigate to your WordPress installation
   - Go to: wp-content/plugins/
   - Create or upload the 'mxchat-migration-tool' folder
   - Ensure all files are in place
   ```

2. **Verify File Structure**
   ```
   mxchat-migration-tool/
   ├── mxchat-migration-tool.php (main plugin file)
   ├── README.md
   ├── INSTALLATION.md
   ├── includes/
   │   ├── class-migration-admin.php
   │   ├── class-knowledge-migrator.php
   │   ├── class-actions-migrator.php
   │   └── class-migration-handler.php
   └── assets/
       ├── css/
       │   └── admin.css
       └── js/
           └── admin.js
   ```

3. **Activate Plugin**
   - Log in to WordPress Admin
   - Go to: Plugins > Installed Plugins
   - Find "MxChat Migration Tool"
   - Click "Activate"

4. **Verify Installation**
   - Check for "Migration Tool" under MxChat menu
   - You should see: MxChat > Migration Tool

#### Option 2: ZIP Installation

1. **Create ZIP File**
   - Compress the 'mxchat-migration-tool' folder into a ZIP file
   - Ensure the folder name is included in the ZIP

2. **Upload via WordPress**
   - Go to: Plugins > Add New
   - Click "Upload Plugin"
   - Choose your ZIP file
   - Click "Install Now"
   - Click "Activate Plugin"

### First-Time Setup

1. **Access Migration Tool**
   - Navigate to: MxChat > Migration Tool
   - You'll see the migration interface

2. **Review Current Configuration**
   - The page displays your current:
     - Vector database (WordPress or Pinecone)
     - Embedding model
     - Number of knowledge base entries
     - Number of actions

3. **You're Ready to Migrate!**

## File Permissions

Ensure proper file permissions:

```bash
# From your WordPress root directory
chmod 644 wp-content/plugins/mxchat-migration-tool/mxchat-migration-tool.php
chmod 644 wp-content/plugins/mxchat-migration-tool/includes/*.php
chmod 644 wp-content/plugins/mxchat-migration-tool/assets/css/*.css
chmod 644 wp-content/plugins/mxchat-migration-tool/assets/js/*.js
```

## Troubleshooting Installation

### "MxChat Basic plugin required" Error

**Cause**: MxChat Basic is not installed or activated

**Solution**:
1. Install and activate MxChat Basic first
2. Then activate MxChat Migration Tool

### "Plugin could not be activated" Error

**Cause**: File permissions or PHP version issues

**Solution**:
1. Check PHP version: Requires PHP 7.4+
2. Check file permissions (see above)
3. Check WordPress debug log for specific errors

### Migration Tool Menu Not Appearing

**Cause**: Plugin not fully activated or cache issue

**Solution**:
1. Deactivate and reactivate the plugin
2. Clear WordPress cache
3. Log out and log back in
4. Check user has 'manage_options' capability

### Database Table Not Created

**Cause**: Activation hook didn't run or database permissions

**Solution**:
1. Deactivate and reactivate the plugin
2. Check database user has CREATE TABLE permissions
3. Manually verify table exists:
   ```sql
   SHOW TABLES LIKE '%mxchat_migration_logs%';
   ```

### CSS/JS Not Loading

**Cause**: Assets not found or permissions issue

**Solution**:
1. Verify files exist in assets/ folders
2. Check file permissions (chmod 644)
3. Clear browser cache
4. Check WordPress debug log

## Database Requirements

The plugin creates one table on activation:

```sql
CREATE TABLE wp_mxchat_migration_logs (
    id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
    migration_id VARCHAR(64) NOT NULL,
    migration_type VARCHAR(50) NOT NULL,
    source_database VARCHAR(50) NOT NULL,
    target_database VARCHAR(50) NOT NULL,
    source_model VARCHAR(100) NOT NULL,
    target_model VARCHAR(100) NOT NULL,
    total_items INT(11) DEFAULT 0,
    processed_items INT(11) DEFAULT 0,
    failed_items INT(11) DEFAULT 0,
    status VARCHAR(20) DEFAULT 'pending',
    started_at DATETIME,
    completed_at DATETIME,
    error_log LONGTEXT,
    PRIMARY KEY (id),
    KEY migration_id (migration_id),
    KEY status (status)
);
```

**Verify Table Creation**:
```sql
SELECT * FROM wp_mxchat_migration_logs LIMIT 1;
```

## Uninstallation

### Safe Removal (Keep Data)

1. Deactivate the plugin
2. Migration history remains in database
3. Can reactivate later without data loss

### Complete Removal (Delete Everything)

1. Deactivate the plugin
2. Delete plugin files
3. Manually drop database table:
   ```sql
   DROP TABLE IF EXISTS wp_mxchat_migration_logs;
   ```

## Server Requirements

### Recommended Server Configuration

```ini
# PHP Settings
memory_limit = 256M
max_execution_time = 300
post_max_size = 64M
upload_max_filesize = 64M

# MySQL Settings
max_allowed_packet = 64M
```

### For Large Migrations

If migrating 1,000+ items, increase:

```ini
memory_limit = 512M
max_execution_time = 600
```

## Compatibility

### Compatible With

- ✅ MxChat Basic (all versions with embedding support)
- ✅ MxChat Multi-Bot Manager add-on
- ✅ MxChat Pinecone add-on
- ✅ WordPress Multisite
- ✅ Most caching plugins

### Known Conflicts

- ⚠️ Aggressive security plugins may block AJAX requests
  - **Solution**: Whitelist plugin AJAX actions
- ⚠️ Some page builders may interfere with admin pages
  - **Solution**: None needed - migration tool is admin-only

## Support

### Before Requesting Support

1. ✅ Verify MxChat Basic is activated
2. ✅ Check PHP and WordPress versions
3. ✅ Enable WordPress debug mode
4. ✅ Review browser console for JavaScript errors
5. ✅ Check server error logs

### Getting Help

Include this information:
- WordPress version
- PHP version
- MxChat Basic version
- Migration error messages
- Migration ID (from history table)
- Server configuration (PHP settings)

## Next Steps

After successful installation:

1. 📖 Read the [README.md](README.md) for usage guide
2. 🔍 Review your current configuration on the migration page
3. 🧪 Test with a small migration first (if possible)
4. 💾 Always backup your database before major migrations
5. 🚀 Start your first migration!

---

**Need Help?** Check the README.md for detailed usage instructions and troubleshooting tips.
