<?php
/**
 * Ban Form Partial - Modern Sidebar Design
 *
 * Form for adding or editing bans.
 */

if (!defined('ABSPATH')) {
    exit;
}

// Variables available from parent:
// $ban - object if editing, null if adding
$is_edit = !empty($ban);
$form_id_suffix = $is_edit ? 'edit' : 'add';
?>

<div class="mxch-card">
    <div class="mxch-card-header">
        <h3 class="mxch-card-title">
            <span class="mxch-card-title-icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <?php if ($is_edit): ?>
                        <path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"></path>
                        <path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"></path>
                    <?php else: ?>
                        <circle cx="12" cy="12" r="10"></circle>
                        <line x1="12" y1="8" x2="12" y2="16"></line>
                        <line x1="8" y1="12" x2="16" y2="12"></line>
                    <?php endif; ?>
                </svg>
            </span>
            <?php echo $is_edit ? esc_html__('Edit Ban Details', 'mx-chat-moderation') : esc_html__('Ban Information', 'mx-chat-moderation'); ?>
        </h3>
    </div>
    <div class="mxch-card-body">
        <form method="post" action="<?php echo esc_url(admin_url('admin.php?page=mx-chat-moderation')); ?>" class="mxch-form mx-chat-mod-form" id="mx-chat-mod-form-<?php echo $form_id_suffix; ?>">
            <?php wp_nonce_field('mx_chat_moderation_action', 'mx_chat_moderation_nonce'); ?>
            <input type="hidden" name="mx_chat_moderation_action" value="<?php echo $is_edit ? 'edit_ban' : 'add_ban'; ?>">
            <?php if ($is_edit): ?>
                <input type="hidden" name="ban_id" value="<?php echo esc_attr($ban->id); ?>">
            <?php endif; ?>

            <div class="mxch-field">
                <label class="mxch-field-label" for="identifier-<?php echo $form_id_suffix; ?>">
                    <?php esc_html_e('Identifier', 'mx-chat-moderation'); ?>
                    <span class="mxch-field-label-required">*</span>
                </label>
                <input type="text"
                       id="identifier-<?php echo $form_id_suffix; ?>"
                       name="identifier"
                       class="mxch-input"
                       value="<?php echo $is_edit ? esc_attr($ban->identifier) : ''; ?>"
                       placeholder="<?php esc_attr_e('Enter email address or IP', 'mx-chat-moderation'); ?>"
                       <?php echo $is_edit ? 'readonly' : 'required'; ?>>
                <p class="mxch-field-description">
                    <?php if ($is_edit): ?>
                        <?php esc_html_e('The identifier cannot be changed after a ban is created.', 'mx-chat-moderation'); ?>
                    <?php else: ?>
                        <?php esc_html_e('Enter the email address or IP address you want to ban.', 'mx-chat-moderation'); ?>
                    <?php endif; ?>
                </p>
            </div>

            <div class="mxch-field">
                <label class="mxch-field-label" for="type-<?php echo $form_id_suffix; ?>">
                    <?php esc_html_e('Ban Type', 'mx-chat-moderation'); ?>
                    <span class="mxch-field-label-required">*</span>
                </label>
                <select id="type-<?php echo $form_id_suffix; ?>"
                        name="type"
                        class="mxch-select"
                        <?php echo $is_edit ? 'disabled' : 'required'; ?>>
                    <option value=""><?php esc_html_e('Select Type', 'mx-chat-moderation'); ?></option>
                    <option value="email" <?php selected($is_edit ? $ban->type : '', 'email'); ?>>
                        <?php esc_html_e('Email Address', 'mx-chat-moderation'); ?>
                    </option>
                    <option value="ip" <?php selected($is_edit ? $ban->type : '', 'ip'); ?>>
                        <?php esc_html_e('IP Address', 'mx-chat-moderation'); ?>
                    </option>
                </select>
                <?php if ($is_edit): ?>
                    <input type="hidden" name="type" value="<?php echo esc_attr($ban->type); ?>">
                <?php endif; ?>
                <p class="mxch-field-description">
                    <?php esc_html_e('Choose whether you\'re banning an email address or an IP address.', 'mx-chat-moderation'); ?>
                </p>
            </div>

            <div class="mxch-field">
                <label class="mxch-field-label" for="notes-<?php echo $form_id_suffix; ?>">
                    <?php esc_html_e('Notes', 'mx-chat-moderation'); ?>
                </label>
                <textarea id="notes-<?php echo $form_id_suffix; ?>"
                          name="notes"
                          class="mxch-textarea"
                          placeholder="<?php esc_attr_e('Add any notes about this ban (optional)', 'mx-chat-moderation'); ?>"
                          rows="4"><?php echo $is_edit ? esc_textarea($ban->notes) : ''; ?></textarea>
                <p class="mxch-field-description">
                    <?php esc_html_e('Optional notes for your reference. These are not shown to the banned user.', 'mx-chat-moderation'); ?>
                </p>
            </div>

            <div class="mxch-form-actions">
                <button type="button" class="mxch-btn mxch-btn-secondary" data-section="bans">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="19" y1="12" x2="5" y2="12"></line>
                        <polyline points="12 19 5 12 12 5"></polyline>
                    </svg>
                    <?php esc_html_e('Cancel', 'mx-chat-moderation'); ?>
                </button>
                <button type="submit" class="mxch-btn mxch-btn-primary">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                    <?php echo $is_edit ? esc_html__('Update Ban', 'mx-chat-moderation') : esc_html__('Add Ban', 'mx-chat-moderation'); ?>
                </button>
            </div>
        </form>
    </div>
</div>

<?php if (!$is_edit): ?>
<!-- Help Card -->
<div class="mxch-card">
    <div class="mxch-card-header">
        <h3 class="mxch-card-title">
            <span class="mxch-card-title-icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <circle cx="12" cy="12" r="10"></circle>
                    <line x1="12" y1="16" x2="12" y2="12"></line>
                    <line x1="12" y1="8" x2="12.01" y2="8"></line>
                </svg>
            </span>
            <?php esc_html_e('Helpful Tips', 'mx-chat-moderation'); ?>
        </h3>
    </div>
    <div class="mxch-card-body">
        <div class="mxch-notice mxch-notice-info" style="margin-bottom: 16px;">
            <span class="mxch-notice-icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path>
                    <polyline points="22,6 12,13 2,6"></polyline>
                </svg>
            </span>
            <div>
                <strong><?php esc_html_e('Email Bans', 'mx-chat-moderation'); ?></strong>
                <p style="margin: 4px 0 0 0;"><?php esc_html_e('Ban specific email addresses. The user will be blocked when they try to use the chat with this email.', 'mx-chat-moderation'); ?></p>
            </div>
        </div>

        <div class="mxch-notice mxch-notice-info">
            <span class="mxch-notice-icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <rect x="2" y="2" width="20" height="8" rx="2" ry="2"></rect>
                    <rect x="2" y="14" width="20" height="8" rx="2" ry="2"></rect>
                    <line x1="6" y1="6" x2="6.01" y2="6"></line>
                    <line x1="6" y1="18" x2="6.01" y2="18"></line>
                </svg>
            </span>
            <div>
                <strong><?php esc_html_e('IP Bans', 'mx-chat-moderation'); ?></strong>
                <p style="margin: 4px 0 0 0;"><?php esc_html_e('Ban specific IP addresses. This blocks all users from that IP, regardless of the email they use.', 'mx-chat-moderation'); ?></p>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>
