<?php
/**
 * Ban List Partial - Modern Sidebar Design
 *
 * Displays the list of banned users with search, filter, and pagination.
 */

if (!defined('ABSPATH')) {
    exit;
}

// Variables available from parent:
// $bans - array with 'items', 'total', 'total_pages'
// $search - current search query
// $type - current type filter
// $paged - current page number
?>

<!-- Search and Filter Card -->
<div class="mxch-card mxch-table-card">
    <div class="mxch-table-toolbar">
        <form id="mx-chat-mod-search" class="mxch-table-search" method="get">
            <input type="hidden" name="page" value="mx-chat-moderation">
            <input type="hidden" name="section" value="bans">
            <input type="search"
                   id="mx-chat-mod-search-input"
                   name="s"
                   value="<?php echo esc_attr($search); ?>"
                   placeholder="<?php esc_attr_e('Search bans...', 'mx-chat-moderation'); ?>"
                   class="mxch-input">
            <button type="submit" class="mxch-btn mxch-btn-secondary mxch-btn-sm">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <circle cx="11" cy="11" r="8"></circle>
                    <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
                </svg>
                <?php esc_html_e('Search', 'mx-chat-moderation'); ?>
            </button>
        </form>

        <div class="mxch-table-filters">
            <select name="type" id="mx-chat-mod-type-filter" class="mxch-select" style="width: auto; min-width: 140px;">
                <option value=""><?php esc_html_e('All Types', 'mx-chat-moderation'); ?></option>
                <option value="email" <?php selected($type, 'email'); ?>><?php esc_html_e('Email', 'mx-chat-moderation'); ?></option>
                <option value="ip" <?php selected($type, 'ip'); ?>><?php esc_html_e('IP Address', 'mx-chat-moderation'); ?></option>
            </select>
        </div>

        <div class="mxch-table-actions">
            <button type="button" class="mxch-btn mxch-btn-primary mxch-btn-sm" data-section="add-ban">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <line x1="12" y1="5" x2="12" y2="19"></line>
                    <line x1="5" y1="12" x2="19" y2="12"></line>
                </svg>
                <?php esc_html_e('Add Ban', 'mx-chat-moderation'); ?>
            </button>
        </div>
    </div>

    <!-- Table -->
    <div class="mxch-table-wrapper">
        <table class="mxch-table">
            <thead>
                <tr>
                    <th><?php esc_html_e('Identifier', 'mx-chat-moderation'); ?></th>
                    <th><?php esc_html_e('Type', 'mx-chat-moderation'); ?></th>
                    <th><?php esc_html_e('Banned At', 'mx-chat-moderation'); ?></th>
                    <th><?php esc_html_e('Banned By', 'mx-chat-moderation'); ?></th>
                    <th><?php esc_html_e('Notes', 'mx-chat-moderation'); ?></th>
                    <th style="text-align: right;"><?php esc_html_e('Actions', 'mx-chat-moderation'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($bans['items'])): ?>
                    <?php foreach ($bans['items'] as $ban_item): ?>
                        <tr data-ban-id="<?php echo esc_attr($ban_item->id); ?>">
                            <td class="mxch-table-cell-identifier">
                                <?php echo esc_html($ban_item->identifier); ?>
                            </td>
                            <td>
                                <span class="mxch-badge mxch-badge-<?php echo esc_attr($ban_item->type); ?>">
                                    <?php echo esc_html(ucfirst($ban_item->type)); ?>
                                </span>
                            </td>
                            <td>
                                <?php echo esc_html(get_date_from_gmt($ban_item->banned_at, get_option('date_format') . ' ' . get_option('time_format'))); ?>
                            </td>
                            <td>
                                <?php
                                $user = get_user_by('id', $ban_item->banned_by);
                                echo $user ? esc_html($user->display_name) : esc_html__('Unknown', 'mx-chat-moderation');
                                ?>
                            </td>
                            <td class="mxch-table-cell-notes" title="<?php echo esc_attr($ban_item->notes); ?>">
                                <?php echo esc_html($ban_item->notes ?: '—'); ?>
                            </td>
                            <td class="mxch-table-cell-actions">
                                <div class="action-buttons">
                                    <a href="<?php echo esc_url(admin_url('admin.php?page=mx-chat-moderation&action=edit&id=' . $ban_item->id)); ?>"
                                       class="mxch-btn-icon"
                                       title="<?php esc_attr_e('Edit', 'mx-chat-moderation'); ?>">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"></path>
                                            <path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"></path>
                                        </svg>
                                    </a>
                                    <button type="button"
                                            class="mxch-btn-icon mxch-btn-danger mx-chat-mod-delete"
                                            data-id="<?php echo esc_attr($ban_item->id); ?>"
                                            title="<?php esc_attr_e('Delete', 'mx-chat-moderation'); ?>">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <polyline points="3 6 5 6 21 6"></polyline>
                                            <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path>
                                            <line x1="10" y1="11" x2="10" y2="17"></line>
                                            <line x1="14" y1="11" x2="14" y2="17"></line>
                                        </svg>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr class="mxch-empty-row">
                        <td colspan="6">
                            <div class="mxch-empty-state">
                                <div class="mxch-empty-state-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                        <circle cx="12" cy="12" r="10"></circle>
                                        <line x1="4.93" y1="4.93" x2="19.07" y2="19.07"></line>
                                    </svg>
                                </div>
                                <h3 class="mxch-empty-state-title"><?php esc_html_e('No bans found', 'mx-chat-moderation'); ?></h3>
                                <p class="mxch-empty-state-text">
                                    <?php if ($search || $type): ?>
                                        <?php esc_html_e('Try adjusting your search or filter criteria.', 'mx-chat-moderation'); ?>
                                    <?php else: ?>
                                        <?php esc_html_e('You haven\'t banned any users yet. Use the "Add Ban" button to get started.', 'mx-chat-moderation'); ?>
                                    <?php endif; ?>
                                </p>
                            </div>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <?php if (isset($bans['total_pages']) && $bans['total_pages'] > 1): ?>
        <div class="mxch-pagination">
            <?php
            echo paginate_links(array(
                'base' => add_query_arg(array('paged' => '%#%', 'section' => 'bans')),
                'format' => '',
                'prev_text' => '&laquo;',
                'next_text' => '&raquo;',
                'total' => $bans['total_pages'],
                'current' => $paged
            ));
            ?>
        </div>
    <?php endif; ?>
</div>
