<?php
if (!defined('ABSPATH')) {
    exit;
}
class MX_Chat_Ban_Handler {
    private $table_name;
    public function __construct() {
        global $wpdb;
        $this->table_name = $wpdb->prefix . 'mxchat_bans';
    }
    public function add_ban($identifier, $type, $notes = '') {
        global $wpdb;
        if (!in_array($type, ['email', 'ip'])) {
            return false;
        }
        $data = array(
        'identifier' => sanitize_text_field($identifier),
        'type' => $type,
        'banned_at' => current_time('mysql'),
        'banned_by' => get_current_user_id(),
        'notes' => sanitize_textarea_field($notes)
    );
    $result = $wpdb->insert(
    $this->table_name,
    $data,
    array('%s', '%s', '%s', '%d', '%s')
);
return $result !== false;
}
public function remove_ban($id) {
    global $wpdb;
    $result = $wpdb->delete(
    $this->table_name,
    array('id' => $id),
    array('%d')
);
return $result !== false;
}
public function check_ban($identifier, $type) {
    global $wpdb;
    $result = $wpdb->get_row($wpdb->prepare(
    "SELECT * FROM {$this->table_name} WHERE identifier = %s AND type = %s",
    $identifier,
    $type
));
return !empty($result);
}
public function get_bans($args = array()) {
    global $wpdb;
    $defaults = array(
    'orderby' => 'banned_at',
    'order' => 'DESC',
    'per_page' => 20,
    'paged' => 1,
    'search' => '',
    'type' => ''
);
$args = wp_parse_args($args, $defaults);
$where = "WHERE 1=1";
$values = array();
if (!empty($args['search'])) {
    $where .= " AND (identifier LIKE %s OR notes LIKE %s)";
    $search_term = '%' . $wpdb->esc_like($args['search']) . '%';
    $values[] = $search_term;
    $values[] = $search_term;
}
if (!empty($args['type'])) {
    $where .= " AND type = %s";
    $values[] = $args['type'];
}
$orderby = sanitize_sql_orderby($args['orderby'] . ' ' . $args['order']);
$offset = ($args['paged'] - 1) * $args['per_page'];
$limit = absint($args['per_page']);
$query = "SELECT * FROM {$this->table_name} {$where} ORDER BY {$orderby} LIMIT {$offset}, {$limit}";
if (!empty($values)) {
    $query = $wpdb->prepare($query, $values);
}
$results = $wpdb->get_results($query);
$total_query = "SELECT COUNT(*) FROM {$this->table_name} {$where}";
if (!empty($values)) {
    $total_query = $wpdb->prepare($total_query, $values);
}
$total = $wpdb->get_var($total_query);
return array(
'items' => $results,
'total' => (int) $total,
'total_pages' => ceil($total / $args['per_page'])
);
}
public function get_ban($id) {
    global $wpdb;
    return $wpdb->get_row($wpdb->prepare(
    "SELECT * FROM {$this->table_name} WHERE id = %d",
    $id
));
}
public function update_ban($id, $data) {
    global $wpdb;
    $update_data = array();
    $update_format = array();
    if (isset($data['identifier'])) {
        $update_data['identifier'] = sanitize_text_field($data['identifier']);
        $update_format[] = '%s';
    }
    if (isset($data['type']) && in_array($data['type'], ['email', 'ip'])) {
        $update_data['type'] = $data['type'];
        $update_format[] = '%s';
    }
    if (isset($data['notes'])) {
        $update_data['notes'] = sanitize_textarea_field($data['notes']);
        $update_format[] = '%s';
    }
    if (empty($update_data)) {
        return false;
    }
    $result = $wpdb->update(
    $this->table_name,
    $update_data,
    array('id' => $id),
    $update_format,
    array('%d')
);
return $result !== false;
}
}
