<?php
/**
 * Bot Create View for MxChat Multi-Bot Manager
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="mxchat-multi-bot-admin">
    <div class="mxchat-header">
        <div class="mxchat-header-content">
            <h1 class="mxchat-title">
                <?php _e('Create New', 'mxchat-multi-bot'); ?> <span class="mxchat-title-gradient"><?php _e('Bot', 'mxchat-multi-bot'); ?></span>
            </h1>
            <p class="mxchat-subtitle">
                Set up a new specialized chatbot with its own configuration and knowledge base connection.
            </p>
        </div>
    </div>

    <div class="mxchat-content">
        <div class="mxchat-action-bar">
            <div class="mxchat-stats">
                <span class="mxchat-stat">
                    <strong><?php _e('Step 1:', 'mxchat-multi-bot'); ?></strong> <?php _e('Basic Configuration', 'mxchat-multi-bot'); ?>
                </span>
            </div>
            <div class="mxchat-actions">
                <a href="<?php echo admin_url('admin.php?page=mxchat-multi-bot'); ?>" class="mxchat-button-multi mxchat-button-secondary">
                    ← <?php _e('Back to Bots', 'mxchat-multi-bot'); ?>
                </a>
            </div>
        </div>

        <div class="mxchat-form-container">
            <form id="mxchat-bot-form" method="post" class="mxchat-form">
                <input type="hidden" id="is_new" name="is_new" value="true">
                
                <div class="mxchat-form-section">
                    <h2 class="mxchat-section-title"><?php _e('Basic Settings', 'mxchat-multi-bot'); ?></h2>
                    
                    <div class="mxchat-form-row">
                        <div class="mxchat-form-group">
                            <label for="bot_id" class="mxchat-label">
                                <?php _e('Bot ID', 'mxchat-multi-bot'); ?>
                                <span class="mxchat-label-required">*</span>
                            </label>
                            <input type="text" 
                                   id="bot_id" 
                                   name="bot_id" 
                                   value="" 
                                   class="mxchat-input" 
                                   required 
                                   pattern="[a-z0-9_]+" 
                                   title="<?php _e('Only lowercase letters, numbers, and underscores', 'mxchat-multi-bot'); ?>">
                            <span id="mxchat-bot-id-status" class="mxchat-bot-id-status"></span>
                            <p class="mxchat-help-text">
                                <?php _e('Unique identifier for this bot. Use only lowercase letters, numbers, and underscores.', 'mxchat-multi-bot'); ?>
                            </p>
                        </div>
                    </div>

                    <div class="mxchat-form-row">
                        <div class="mxchat-form-group">
                            <label for="bot_name" class="mxchat-label">
                                <?php _e('Bot Name', 'mxchat-multi-bot'); ?>
                                <span class="mxchat-label-required">*</span>
                            </label>
                            <input type="text" 
                                   id="bot_name" 
                                   name="bot_name" 
                                   value="" 
                                   class="mxchat-input" 
                                   required>
                            <p class="mxchat-help-text">
                                <?php _e('Display name for this bot.', 'mxchat-multi-bot'); ?>
                            </p>
                        </div>
                    </div>
                </div>

                <!-- NEW: AI Model Configuration Section -->
                <div class="mxchat-form-section">
                    <h2 class="mxchat-section-title"><?php _e('AI Model Configuration', 'mxchat-multi-bot'); ?></h2>
                    
                    <div class="mxchat-form-row">
                        <div class="mxchat-form-group">
                            <label for="model" class="mxchat-label">
                                <?php _e('AI Model', 'mxchat-multi-bot'); ?>
                            </label>
                            <?php 
                            // Get the default model from core plugin options
                            $core_options = get_option('mxchat_options', array());
                            $default_model = isset($core_options['model']) ? $core_options['model'] : 'gpt-4o';
                            ?>
                            <select id="model" name="model" class="mxchat-input">
                                <option value=""><?php _e('Use Default Model', 'mxchat-multi-bot'); ?> (<?php echo esc_html($default_model); ?>)</option>
                                <optgroup label="<?php esc_attr_e('Google Gemini Models', 'mxchat-multi-bot'); ?>">
                                    <option value="gemini-2.0-flash"><?php _e('Gemini 2.0 Flash (Next-Gen Features)', 'mxchat-multi-bot'); ?></option>
                                    <option value="gemini-2.0-flash-lite"><?php _e('Gemini 2.0 Flash-Lite (Cost-Efficient)', 'mxchat-multi-bot'); ?></option>
                                    <option value="gemini-1.5-pro"><?php _e('Gemini 1.5 Pro (Complex Reasoning)', 'mxchat-multi-bot'); ?></option>
                                    <option value="gemini-1.5-flash"><?php _e('Gemini 1.5 Flash (Fast & Versatile)', 'mxchat-multi-bot'); ?></option>
                                </optgroup>
                                <optgroup label="<?php esc_attr_e('X.AI Models', 'mxchat-multi-bot'); ?>">
                                    <option value="grok-4-0709"><?php _e('Grok 4 (Latest Flagship)', 'mxchat-multi-bot'); ?></option>
                                    <option value="grok-3-beta"><?php _e('Grok-3 (Powerful)', 'mxchat-multi-bot'); ?></option>
                                    <option value="grok-3-fast-beta"><?php _e('Grok-3 Fast (High Performance)', 'mxchat-multi-bot'); ?></option>
                                    <option value="grok-3-mini-beta"><?php _e('Grok-3 Mini (Affordable)', 'mxchat-multi-bot'); ?></option>
                                    <option value="grok-3-mini-fast-beta"><?php _e('Grok-3 Mini Fast (Quick Response)', 'mxchat-multi-bot'); ?></option>
                                    <option value="grok-2"><?php _e('Grok 2', 'mxchat-multi-bot'); ?></option>
                                </optgroup>
                                <optgroup label="<?php esc_attr_e('DeepSeek Models', 'mxchat-multi-bot'); ?>">
                                    <option value="deepseek-chat"><?php _e('DeepSeek-V3', 'mxchat-multi-bot'); ?></option>
                                </optgroup>
                                <optgroup label="<?php esc_attr_e('Claude Models', 'mxchat-multi-bot'); ?>">
                                    <option value="claude-opus-4-20250514"><?php _e('Claude 4 Opus (Most Capable)', 'mxchat-multi-bot'); ?></option>
                                    <option value="claude-sonnet-4-20250514"><?php _e('Claude 4 Sonnet (High Performance)', 'mxchat-multi-bot'); ?></option>
                                    <option value="claude-3-7-sonnet-20250219"><?php _e('Claude 3.7 Sonnet (High Intelligence)', 'mxchat-multi-bot'); ?></option>
                                    <option value="claude-3-5-sonnet-20241022"><?php _e('Claude 3.5 Sonnet (Intelligent)', 'mxchat-multi-bot'); ?></option>
                                    <option value="claude-3-opus-20240229"><?php _e('Claude 3 Opus (Complex Tasks)', 'mxchat-multi-bot'); ?></option>
                                    <option value="claude-3-sonnet-20240229"><?php _e('Claude 3 Sonnet (Balanced)', 'mxchat-multi-bot'); ?></option>
                                    <option value="claude-3-haiku-20240307"><?php _e('Claude 3 Haiku (Fastest)', 'mxchat-multi-bot'); ?></option>
                                </optgroup>
                                <optgroup label="<?php esc_attr_e('OpenAI Models', 'mxchat-multi-bot'); ?>">
                                    <option value="gpt-5"><?php _e('GPT-5 (Flagship for Coding, Reasoning & Agents)', 'mxchat-multi-bot'); ?></option>
                                    <option value="gpt-5-mini"><?php _e('GPT-5 Mini (Faster, Cost-Efficient for Precise Prompts)', 'mxchat-multi-bot'); ?></option>
                                    <option value="gpt-5-nano"><?php _e('GPT-5 Nano (Fastest & Cheapest for Summarization/Classification)', 'mxchat-multi-bot'); ?></option>
                                    <option value="gpt-4.1-2025-04-14"><?php _e('GPT-4.1 (Flagship for Complex Tasks)', 'mxchat-multi-bot'); ?></option>
                                    <option value="gpt-4o"><?php _e('GPT-4o (Recommended)', 'mxchat-multi-bot'); ?></option>
                                    <option value="gpt-4o-mini"><?php _e('GPT-4o Mini (Fast and Lightweight)', 'mxchat-multi-bot'); ?></option>
                                    <option value="gpt-4-turbo"><?php _e('GPT-4 Turbo (High-Performance)', 'mxchat-multi-bot'); ?></option>
                                    <option value="gpt-4"><?php _e('GPT-4 (High Intelligence)', 'mxchat-multi-bot'); ?></option>
                                    <option value="gpt-3.5-turbo"><?php _e('GPT-3.5 Turbo (Affordable and Fast)', 'mxchat-multi-bot'); ?></option>
                                </optgroup>
                            </select>
                            <p class="mxchat-help-text">
                                <?php _e('Select a specific AI model for this bot, or leave as default to use the main chatbot\'s model setting. Each model has different capabilities and costs.', 'mxchat-multi-bot'); ?>
                            </p>
                        </div>
                    </div>
                    
                    
                    <!-- Add this in the AI Model Configuration section -->
                    <div class="mxchat-form-row">
                        <div class="mxchat-form-group">
                            <label for="enable_streaming_toggle" class="mxchat-label">
                                <?php _e('Enable Streaming', 'mxchat-multi-bot'); ?>
                            </label>
                            <label class="toggle-switch">
                                <input type="checkbox" 
                                       id="enable_streaming_toggle" 
                                       name="enable_streaming_toggle" 
                                       value="on" 
                                       <?php checked(isset($bot_settings['enable_streaming_toggle']) ? $bot_settings['enable_streaming_toggle'] : 'on', 'on'); ?> />
                                <span class="slider"></span>
                            </label>
                            <p class="mxchat-help-text">
                                <?php _e('Enable real-time streaming responses for this bot. When disabled, responses will load all at once.', 'mxchat-multi-bot'); ?>
                            </p>
                        </div>
                    </div>
                </div>
                
                <!-- Bot-Specific Rate Limits Section -->
<div class="mxchat-form-section">
    <h2 class="mxchat-section-title"><?php _e('Rate Limits', 'mxchat-multi-bot'); ?></h2>
    
    <div class="mxchat-form-row">
        <div class="mxchat-form-group">
            <label class="mxchat-label">
                <input type="checkbox" 
                       id="use_custom_rate_limits" 
                       name="use_custom_rate_limits" 
                       value="on" 
                       <?php 
                       if (isset($bot)) {
                           checked(isset($bot_settings['use_custom_rate_limits']) ? $bot_settings['use_custom_rate_limits'] : 'off', 'on');
                       }
                       ?> />
                <?php _e('Override Default Rate Limits', 'mxchat-multi-bot'); ?>
            </label>
            <p class="mxchat-help-text">
                <?php _e('Enable custom rate limits for this bot. When disabled, uses the default rate limits from main settings.', 'mxchat-multi-bot'); ?>
            </p>
        </div>
    </div>

    <div id="custom-rate-limits-section" style="<?php echo (!isset($bot_settings['use_custom_rate_limits']) || $bot_settings['use_custom_rate_limits'] !== 'on') ? 'display: none;' : ''; ?>">
        <?php
        // Get default rate limits from core plugin
        $core_rate_limits = get_option('mxchat_options', [])['rate_limits'] ?? [];
        
        // Get roles
        $roles = wp_roles()->get_names();
        $roles['logged_out'] = __('Logged Out Users', 'mxchat-multi-bot');
        
        foreach ($roles as $role_id => $role_name) :
            $bot_rate_limit = isset($bot_settings['rate_limits'][$role_id]) ? $bot_settings['rate_limits'][$role_id] : [];
        ?>
            <div class="mxchat-form-row">
                <div class="mxchat-form-group">
                    <h4><?php echo esc_html($role_name); ?></h4>
                    <div style="display: flex; gap: 15px; align-items: end;">
                        <div>
                            <label><?php _e('Limit:', 'mxchat-multi-bot'); ?></label>
                            <select name="rate_limits[<?php echo esc_attr($role_id); ?>][limit]" class="mxchat-input">
                                <?php 
                                $limits = ['1', '3', '5', '10', '15', '20', '50', '100', 'unlimited'];
                                $current_limit = $bot_rate_limit['limit'] ?? '10';
                                foreach ($limits as $limit) {
                                    echo '<option value="' . esc_attr($limit) . '" ' . selected($current_limit, $limit, false) . '>' . esc_html($limit) . '</option>';
                                }
                                ?>
                            </select>
                        </div>
                        <div>
                            <label><?php _e('Timeframe:', 'mxchat-multi-bot'); ?></label>
                            <select name="rate_limits[<?php echo esc_attr($role_id); ?>][timeframe]" class="mxchat-input">
                                <?php 
                                $timeframes = [
                                    'hourly' => __('Per Hour', 'mxchat-multi-bot'),
                                    'daily' => __('Per Day', 'mxchat-multi-bot'),
                                    'weekly' => __('Per Week', 'mxchat-multi-bot'),
                                    'monthly' => __('Per Month', 'mxchat-multi-bot')
                                ];
                                $current_timeframe = $bot_rate_limit['timeframe'] ?? 'daily';
                                foreach ($timeframes as $value => $label) {
                                    echo '<option value="' . esc_attr($value) . '" ' . selected($current_timeframe, $value, false) . '>' . esc_html($label) . '</option>';
                                }
                                ?>
                            </select>
                        </div>
                    </div>
                    <div style="margin-top: 10px;">
                        <label><?php _e('Custom Message:', 'mxchat-multi-bot'); ?></label>
                        <textarea name="rate_limits[<?php echo esc_attr($role_id); ?>][message]" 
                                  class="mxchat-textarea" 
                                  rows="2"
                                  placeholder="<?php esc_attr_e('Custom rate limit message', 'mxchat-multi-bot'); ?>"><?php echo esc_textarea($bot_rate_limit['message'] ?? ''); ?></textarea>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>

<script>
document.getElementById('use_custom_rate_limits').addEventListener('change', function() {
    document.getElementById('custom-rate-limits-section').style.display = this.checked ? 'block' : 'none';
});
</script>

                <div class="mxchat-form-section">
                    <h2 class="mxchat-section-title"><?php _e('Knowledge Base Configuration', 'mxchat-multi-bot'); ?></h2>
                    
                    <div class="mxchat-form-row">
                        <div class="mxchat-form-group">
                            <label for="pinecone_host" class="mxchat-label">
                                <?php _e('Pinecone Host', 'mxchat-multi-bot'); ?>
                            </label>
                            <input type="text" 
                                   id="pinecone_host" 
                                   name="pinecone_host" 
                                   value="" 
                                   class="mxchat-input" 
                                   placeholder="your-index-12345.svc.us-west1-gcp.pinecone.io">
                            <p class="mxchat-help-text">
                                <?php _e('Pinecone index host URL for this bot\'s knowledge base.', 'mxchat-multi-bot'); ?>
                            </p>
                        </div>
                    </div>

                    <div class="mxchat-form-row">
                        <div class="mxchat-form-group mxchat-form-group-small">
                            <label for="similarity_threshold" class="mxchat-label">
                                <?php _e('Similarity Threshold', 'mxchat-multi-bot'); ?>
                            </label>
                            <div class="mxchat-input-group">
                                <input type="number" 
                                       id="similarity_threshold" 
                                       name="similarity_threshold" 
                                       value="75" 
                                       min="0" 
                                       max="100" 
                                       class="mxchat-input mxchat-input-small">
                                <span class="mxchat-input-suffix">%</span>
                            </div>
                            <p class="mxchat-help-text">
                                <?php _e('Minimum similarity score for knowledge retrieval (0-100).', 'mxchat-multi-bot'); ?>
                            </p>
                        </div>
                    </div>
                </div>

                <div class="mxchat-form-section">
                    <h2 class="mxchat-section-title"><?php _e('Chat Interface', 'mxchat-multi-bot'); ?></h2>
                    
                    <div class="mxchat-form-row">
                        <div class="mxchat-form-group">
                            <label for="top_bar_title" class="mxchat-label">
                                <?php _e('Chat Window Title', 'mxchat-multi-bot'); ?>
                            </label>
                            <input type="text" 
                                   id="top_bar_title" 
                                   name="top_bar_title" 
                                   value="" 
                                   class="mxchat-input" 
                                   placeholder="<?php _e('Enter chat window title', 'mxchat-multi-bot'); ?>">
                            <p class="mxchat-help-text">
                                <?php _e('Title displayed in the chat window header.', 'mxchat-multi-bot'); ?>
                            </p>
                        </div>
                    </div>

                    <div class="mxchat-form-row">
                        <div class="mxchat-form-group">
                            <label for="intro_message" class="mxchat-label">
                                <?php _e('Welcome Message', 'mxchat-multi-bot'); ?>
                            </label>
                            <div class="mxchat-editor-container">
                                <?php 
                                wp_editor(
                                    'Hello! How can I assist you today?',
                                    'intro_message',
                                    array(
                                        'textarea_name' => 'intro_message',
                                        'textarea_rows' => 5,
                                        'media_buttons' => false,
                                        'teeny' => true,
                                        'quicktags' => false
                                    )
                                );
                                ?>
                            </div>
                            <p class="mxchat-help-text">
                                <?php _e('Initial message displayed when chat opens.', 'mxchat-multi-bot'); ?>
                            </p>
                        </div>
                    </div>
                </div>
                
                <div class="mxchat-form-section">
                    <h2 class="mxchat-section-title"><?php _e('AI Behavior', 'mxchat-multi-bot'); ?></h2>
                    
                    <div class="mxchat-form-row">
                        <div class="mxchat-form-group">
                            <label for="system_prompt_instructions" class="mxchat-label">
                                <?php _e('AI Instructions (System Prompt)', 'mxchat-multi-bot'); ?>
                            </label>
                            <textarea id="system_prompt_instructions" 
                                     name="system_prompt_instructions" 
                                     rows="8" 
                                     class="mxchat-textarea"
                                     placeholder="<?php _e('Enter custom instructions for this bot\'s behavior...', 'mxchat-multi-bot'); ?>"></textarea>
                            <p class="mxchat-help-text">
                                <?php _e('Custom system-level instructions to guide this bot\'s behavior. Leave empty to use default instructions.', 'mxchat-multi-bot'); ?>
                            </p>
                        </div>
                    </div>
                </div>
                
                <div class="mxchat-form-section mxchat-multi-quick-questions-section">
                    <h2 class="mxchat-section-title"><?php _e('Quick Questions', 'mxchat-multi-bot'); ?></h2>
                    <p class="mxchat-multi-quick-questions-description">
                        <?php _e('Set up custom quick questions for this bot. These will replace any default quick questions when this bot is active.', 'mxchat-multi-bot'); ?>
                    </p>
                    
                    <div class="mxchat-form-row">
                        <div class="mxchat-multi-question-form-group">
                            <label for="popular_question_1" class="mxchat-multi-question-label">
                                <?php _e('Quick Question 1', 'mxchat-multi-bot'); ?>
                            </label>
                            <input type="text" 
                                   id="popular_question_1" 
                                   name="popular_question_1" 
                                   value="" 
                                   class="mxchat-multi-question-input" 
                                   placeholder="<?php _e('Enter Quick Question 1', 'mxchat-multi-bot'); ?>">
                            <p class="mxchat-multi-question-help-text">
                                <?php _e('This will be the first Quick Question in the chatbot, displayed above the input field.', 'mxchat-multi-bot'); ?>
                            </p>
                        </div>
                    </div>

                    <div class="mxchat-form-row">
                        <div class="mxchat-multi-question-form-group">
                            <label for="popular_question_2" class="mxchat-multi-question-label">
                                <?php _e('Quick Question 2', 'mxchat-multi-bot'); ?>
                            </label>
                            <input type="text" 
                                   id="popular_question_2" 
                                   name="popular_question_2" 
                                   value="" 
                                   class="mxchat-multi-question-input" 
                                   placeholder="<?php _e('Enter Quick Question 2', 'mxchat-multi-bot'); ?>">
                            <p class="mxchat-multi-question-help-text">
                                <?php _e('This will be the second Quick Question in the chatbot.', 'mxchat-multi-bot'); ?>
                            </p>
                        </div>
                    </div>

                    <div class="mxchat-form-row">
                        <div class="mxchat-multi-question-form-group">
                            <label for="popular_question_3" class="mxchat-multi-question-label">
                                <?php _e('Quick Question 3', 'mxchat-multi-bot'); ?>
                            </label>
                            <input type="text" 
                                   id="popular_question_3" 
                                   name="popular_question_3" 
                                   value="" 
                                   class="mxchat-multi-question-input" 
                                   placeholder="<?php _e('Enter Quick Question 3', 'mxchat-multi-bot'); ?>">
                            <p class="mxchat-multi-question-help-text">
                                <?php _e('This will be the third Quick Question in the chatbot.', 'mxchat-multi-bot'); ?>
                            </p>
                        </div>
                    </div>

                    <div class="mxchat-form-row">
                        <div class="mxchat-multi-question-form-group">
                            <label class="mxchat-multi-question-label">
                                <?php _e('Additional Quick Questions', 'mxchat-multi-bot'); ?>
                            </label>
                            <div class="mxchat-multi-additional-questions-container" id="mxchat-additional-questions-container">
                                <div class="mxchat-multi-question-row">
                                    <input type="text" 
                                           name="additional_popular_questions[]"
                                           value=""
                                           placeholder="<?php _e('Enter Additional Quick Question 4', 'mxchat-multi-bot'); ?>"
                                           class="mxchat-multi-question-input" />
                                    <button type="button" class="mxchat-multi-quick-question-remove-btn">
                                        <?php _e('Remove', 'mxchat-multi-bot'); ?>
                                    </button>
                                </div>
                            </div>
                            <button type="button" class="mxchat-multi-quick-question-add-btn">
                                <?php _e('Add Question', 'mxchat-multi-bot'); ?>
                            </button>
                            <p class="mxchat-multi-question-help-text">
                                <?php _e('Add as many Quick Questions as you need.', 'mxchat-multi-bot'); ?>
                            </p>
                        </div>
                    </div>
                </div>

                <div class="mxchat-form-actions">
                    <button type="submit" class="mxchat-button-multi mxchat-button-primary mxchat-button-large" id="save-bot">
                        <?php _e('Create Bot', 'mxchat-multi-bot'); ?>
                    </button>
                    <a href="<?php echo admin_url('admin.php?page=mxchat-multi-bot'); ?>" class="mxchat-button-multi mxchat-button-secondary mxchat-button-large">
                        <?php _e('Cancel', 'mxchat-multi-bot'); ?>
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>