<?php
/**
 * Fired during plugin activation
 */
class MxChat_Perplexity_Activator {

    /**
     * Run actions during plugin activation
     */
    public static function activate() {
        // Set default options if they don't exist
        if (!get_option('mxchat_perplexity_installed')) {
            update_option('mxchat_perplexity_installed', true);
            update_option('mxchat_perplexity_version', MXCHAT_PERPLEXITY_VERSION);
            
            // Set default settings
            if (!get_option('mxchat_perplexity_response_mode')) {
                update_option('mxchat_perplexity_response_mode', 'conversational');
            }
            
            if (!get_option('mxchat_perplexity_model')) {
                update_option('mxchat_perplexity_model', 'llama-3-sonar-small-online');
            }
        }
        
        // Check if main plugin is active
        if (!is_mxchat_perplexity_requirements_met()) {
            deactivate_plugins(plugin_basename(__FILE__));
            wp_die(
                __('<strong>MxChat Perplexity Integration</strong> requires the MxChat plugin to be installed and activated.', 'mxchat-perplexity'),
                __('Plugin Activation Error', 'mxchat-perplexity'),
                array('back_link' => true)
            );
        }
    }
}