<?php
/**
 * AI Theme Generator UI Template with CSS Editor
 * File: mxchat-theme/templates/ai-theme-generator.php
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

$ai_generator = new MxChat_AI_Theme_Generator();
$saved_themes = $ai_generator->get_saved_ai_themes();
$active_css = $ai_generator->get_active_ai_theme_css();
$active_theme_name = $ai_generator->get_active_ai_theme_name();
?>

<div class="mxchat-ai-theme-section">
<div class="mxchat-section-header">
    <p class="mxchat-section-description">
        <?php esc_html_e('Describe your ideal chatbot theme and let ', 'mxchat-theme'); ?>
        <span class="mxchat-gradient-text"><?php esc_html_e('AI generate custom CSS', 'mxchat-theme'); ?></span>
        <?php esc_html_e(' for you.', 'mxchat-theme'); ?>
    </p>
</div>
    
    <div class="mxchat-ai-generator-container">
        <!-- Input Section -->
        <div class="mxchat-ai-input-section">
            <div class="mxchat-form-group">
                <label for="ai-theme-description"><?php esc_html_e('Theme Description', 'mxchat-theme'); ?></label>
                <textarea 
                    id="ai-theme-description" 
                    class="mxchat-ai-description-input"
                    placeholder="<?php esc_attr_e('Describe your theme... e.g., "Dark mode theme for SaaS company with gradients" or "Professional blue and white theme with alternating quick question color shades"', 'mxchat-theme'); ?>"
                    rows="4"
                ></textarea>
                <p class="mxchat-field-description">
                    <?php esc_html_e('Be specific about colors, styles, and mood. The more detail you provide, the better the AI can match your vision.', 'mxchat-theme'); ?>
                </p>
            </div>
            
            <div class="mxchat-form-group">
                <label><?php esc_html_e('AI Model', 'mxchat-theme'); ?></label>
                <div class="mxchat-model-selector" id="mxchat-ai-model-selector">
                    <button type="button" class="mxchat-model-selector-btn">
                        <span id="selected-model-name"><?php esc_html_e('Select Model', 'mxchat-theme'); ?></span>
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <polyline points="6,9 12,15 18,9"></polyline>
                        </svg>
                    </button>
                </div>
                <input type="hidden" id="selected-model-id" value="">
            </div>
            
            <div class="mxchat-ai-actions">
                <button id="generate-ai-theme" class="mxchat-button-primary mxchat-ai-generate-btn" disabled>
                    <span class="button-text">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M14.828 14.828a4 4 0 0 1-5.656 0M9 10h.01M15 10h.01M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z"/>
                        </svg>
                        <?php esc_html_e('Generate Theme', 'mxchat-theme'); ?>
                    </span>
                    <span class="button-loading" style="display: none;">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" class="mxchat-spin">
                            <path d="M21 12a9 9 0 1 1-6.219-8.56"/>
                        </svg>
                        <?php esc_html_e('Generating...', 'mxchat-theme'); ?>
                    </span>
                </button>
            </div>
        </div>
        
        <!-- Results Section -->
<div class="mxchat-ai-results-section" id="ai-results-section" style="display: none;">
    <h3><?php esc_html_e('Generated Theme', 'mxchat-theme'); ?></h3>
    <div class="mxchat-results-hint">
        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
            <circle cx="12" cy="12" r="10"/>
            <path d="M12 16v-4"/>
            <path d="M12 8h.01"/>
        </svg>
        <span><?php esc_html_e('After saving the theme, you will be able to edit the CSS using the built-in editor.', 'mxchat-theme'); ?></span>
    </div>
    
            <div class="mxchat-ai-result-actions">
                <button id="preview-ai-theme" class="mxchat-button-secondary">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"/>
                        <circle cx="12" cy="12" r="3"/>
                    </svg>
                    <?php esc_html_e('Preview', 'mxchat-theme'); ?>
                </button>
                <button id="apply-ai-theme" class="mxchat-button-primary">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <polyline points="20,6 9,17 4,12"/>
                    </svg>
                    <?php esc_html_e('Apply & Save', 'mxchat-theme'); ?>
                </button>
                <button id="regenerate-theme" class="mxchat-button-outline">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <polyline points="23,4 23,10 17,10"/>
                        <path d="M20.49 15a9 9 0 1 1-2.12-9.36L23 10"/>
                    </svg>
                    <?php esc_html_e('Regenerate', 'mxchat-theme'); ?>
                </button>
                <button id="view-generated-css" class="mxchat-button-secondary">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <polyline points="16,18 22,12 16,6"/>
                        <polyline points="8,6 2,12 8,18"/>
                    </svg>
                    <?php esc_html_e('View CSS', 'mxchat-theme'); ?>
                </button>
            </div>
            
            <div class="mxchat-css-preview" id="generated-css-preview" style="display: none;">
                <h4><?php esc_html_e('Generated CSS', 'mxchat-theme'); ?></h4>
                <div class="mxchat-css-code-container">
                    <button id="copy-css-code" class="mxchat-copy-button">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <rect x="9" y="9" width="13" height="13" rx="2" ry="2"/>
                            <path d="M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1"/>
                        </svg>
                        <?php esc_html_e('Copy', 'mxchat-theme'); ?>
                    </button>
                    <pre id="generated-css-code" class="mxchat-css-code"></pre>
                </div>
            </div>
        </div>
        
        <!-- Current Active AI Theme -->
        <?php if (!empty($active_css)): ?>
        <div class="mxchat-active-ai-theme-section">
            <h3><?php esc_html_e('Currently Applied AI Theme', 'mxchat-theme'); ?></h3>
            <div class="mxchat-applied-theme-info">
                <?php if (!empty($active_theme_name)): ?>
                <p><strong><?php esc_html_e('Theme Name:', 'mxchat-theme'); ?></strong> 
                   <span class="mxchat-applied-theme-name"><?php echo esc_html($active_theme_name); ?></span>
                </p>
                <?php endif; ?>
                <p><small><?php esc_html_e('Theme is currently active', 'mxchat-theme'); ?></small></p>
            </div>
            <div class="mxchat-active-theme-actions">
                <button id="view-active-css" class="mxchat-button-secondary">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <polyline points="16,18 22,12 16,6"/>
                        <polyline points="8,6 2,12 8,18"/>
                    </svg>
                    <?php esc_html_e('View CSS', 'mxchat-theme'); ?>
                </button>
                <button id="edit-active-css" class="mxchat-button-secondary">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"/>
                        <path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"/>
                    </svg>
                    <?php esc_html_e('Edit CSS', 'mxchat-theme'); ?>
                </button>
                <button id="remove-active-theme" class="mxchat-button-outline">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <line x1="18" y1="6" x2="6" y2="18"/>
                        <line x1="6" y1="6" x2="18" y2="18"/>
                    </svg>
                    <?php esc_html_e('Remove Theme', 'mxchat-theme'); ?>
                </button>
            </div>
            <div id="active-css-display" class="mxchat-css-code-container" style="display: none;">
                <button class="mxchat-copy-button" data-copy-target="#active-css-code">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <rect x="9" y="9" width="13" height="13" rx="2" ry="2"/>
                        <path d="M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1"/>
                    </svg>
                    <?php esc_html_e('Copy', 'mxchat-theme'); ?>
                </button>
                <pre id="active-css-code" class="mxchat-css-code"><?php echo esc_html($active_css); ?></pre>
            </div>
        </div>
        <?php endif; ?>
        
        <!-- Saved Themes Section -->
        <?php if (!empty($saved_themes)): ?>
        <div class="mxchat-saved-themes-section">
            <h3><?php esc_html_e('Saved AI Themes', 'mxchat-theme'); ?></h3>
            <div class="mxchat-saved-themes-grid">
                <?php foreach ($saved_themes as $theme_name => $theme_data): ?>
                <div class="mxchat-saved-theme-card" data-theme-name="<?php echo esc_attr($theme_name); ?>">
                    <div class="mxchat-theme-card-header">
                        <h4><?php echo esc_html($theme_name); ?></h4>
                        <div class="mxchat-theme-card-actions">
                            <button class="mxchat-theme-action-btn mxchat-theme-preview-btn" 
                                    data-css="<?php echo esc_attr($theme_data['css']); ?>" 
                                    title="<?php esc_attr_e('Preview Theme', 'mxchat-theme'); ?>">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"/>
                                    <circle cx="12" cy="12" r="3"/>
                                </svg>
                                <span class="mxchat-btn-text"><?php esc_html_e('Preview', 'mxchat-theme'); ?></span>
                            </button>
                            <button class="mxchat-theme-action-btn mxchat-theme-apply-btn" 
                                    data-css="<?php echo esc_attr($theme_data['css']); ?>" 
                                    title="<?php esc_attr_e('Apply Theme', 'mxchat-theme'); ?>">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <polyline points="20,6 9,17 4,12"/>
                                </svg>
                                <span class="mxchat-btn-text"><?php esc_html_e('Apply', 'mxchat-theme'); ?></span>
                            </button>
                            <button class="mxchat-theme-action-btn mxchat-theme-edit-btn" 
                                    data-css="<?php echo esc_attr($theme_data['css']); ?>" 
                                    title="<?php esc_attr_e('Edit Theme CSS', 'mxchat-theme'); ?>">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"/>
                                    <path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"/>
                                </svg>
                                <span class="mxchat-btn-text"><?php esc_html_e('Edit', 'mxchat-theme'); ?></span>
                            </button>
                            <button class="mxchat-theme-action-btn mxchat-theme-delete-btn" 
                                    data-theme="<?php echo esc_attr($theme_name); ?>" 
                                    title="<?php esc_attr_e('Delete Theme', 'mxchat-theme'); ?>">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <polyline points="3,6 5,6 21,6"/>
                                    <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"/>
                                </svg>
                                <span class="mxchat-btn-text"><?php esc_html_e('Delete', 'mxchat-theme'); ?></span>
                            </button>
                        </div>
                    </div>
                    <div class="mxchat-theme-card-meta">
                        <span class="mxchat-theme-date">
                            <?php echo esc_html(date('M j, Y', strtotime($theme_data['created']))); ?>
                        </span>
                        <?php if (!empty($theme_data['description'])): ?>
                        <p class="mxchat-theme-description">
                            <?php echo esc_html($theme_data['description']); ?>
                        </p>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- CSS Editor Modal -->
<div id="mxchat-css-editor-modal" class="mxchat-css-editor-modal" style="display: none;">
    <div class="mxchat-css-editor-modal-content">
        <div class="mxchat-css-editor-modal-header">
            <h3><?php esc_html_e('Edit CSS - ', 'mxchat-theme'); ?><span id="css-editor-theme-name"></span></h3>
            <button class="mxchat-css-editor-modal-close">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <line x1="18" y1="6" x2="6" y2="18"/>
                    <line x1="6" y1="6" x2="18" y2="18"/>
                </svg>
            </button>
        </div>
        <div class="mxchat-css-editor-modal-body">
            <div class="mxchat-css-editor-container">
                <div class="mxchat-css-editor-toolbar">
                    <div class="mxchat-css-editor-info">
                        <small><?php esc_html_e('Tip: Use Ctrl+S (Cmd+S on Mac) to save quickly', 'mxchat-theme'); ?></small>
                    </div>
                </div>
                <textarea 
                    id="css-editor-textarea" 
                    class="mxchat-css-editor-textarea"
                    placeholder="<?php esc_attr_e('Enter your CSS here...', 'mxchat-theme'); ?>"
                    spellcheck="false"
                ></textarea>
                <input type="hidden" id="css-editor-source" value="">
                <input type="hidden" id="css-editor-original-name" value="">
            </div>
        </div>
        <div class="mxchat-css-editor-modal-footer">
            <button id="cancel-css-editor" class="mxchat-button-outline">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <line x1="18" y1="6" x2="6" y2="18"/>
                    <line x1="6" y1="6" x2="18" y2="18"/>
                </svg>
                <?php esc_html_e('Cancel', 'mxchat-theme'); ?>
            </button>
            <button id="save-css-editor" class="mxchat-button-primary">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"/>
                    <polyline points="17,21 17,13 7,13 7,21"/>
                    <polyline points="7,3 7,8 15,8"/>
                </svg>
                <?php esc_html_e('Save Changes', 'mxchat-theme'); ?>
            </button>
        </div>
    </div>
</div>

<!-- CSS Preview Modal -->
<div id="css-preview-modal" class="mxchat-modal" style="display: none;">
    <div class="mxchat-modal-content mxchat-modal-large">
        <div class="mxchat-modal-header">
            <h3><?php esc_html_e('CSS Preview', 'mxchat-theme'); ?></h3>
            <button class="mxchat-modal-close">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <line x1="18" y1="6" x2="6" y2="18"/>
                    <line x1="6" y1="6" x2="18" y2="18"/>
                </svg>
            </button>
        </div>
        <div class="mxchat-modal-body">
            <div class="mxchat-css-code-container">
                <button class="mxchat-copy-button" data-copy-target="#preview-css-code">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <rect x="9" y="9" width="13" height="13" rx="2" ry="2"/>
                        <path d="M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1"/>
                    </svg>
                    <?php esc_html_e('Copy', 'mxchat-theme'); ?>
                </button>
                <pre id="preview-css-code" class="mxchat-css-code"></pre>
            </div>
        </div>
        <div class="mxchat-modal-footer">
            <button class="mxchat-modal-close mxchat-button-secondary">
                <?php esc_html_e('Close', 'mxchat-theme'); ?>
            </button>
        </div>
    </div>
</div>


<script type="text/javascript">
// Store the nonce for AJAX calls
window.mxchatAiThemeNonce = '<?php echo wp_create_nonce('mxchat_ai_theme_nonce'); ?>';

// Add keyboard shortcuts for CSS editor
jQuery(document).ready(function($) {
    // Ctrl+S / Cmd+S to save in CSS editor
    $(document).on('keydown', '#css-editor-textarea', function(e) {
        if ((e.ctrlKey || e.metaKey) && e.keyCode === 83) {
            e.preventDefault();
            $('#save-css-editor').click();
        }
    });
    
    // Tab support in textarea
    $(document).on('keydown', '#css-editor-textarea', function(e) {
        if (e.keyCode === 9) {
            e.preventDefault();
            var start = this.selectionStart;
            var end = this.selectionEnd;
            var $this = $(this);
            var value = $this.val();
            
            $this.val(value.substring(0, start) + "\t" + value.substring(end));
            this.selectionStart = this.selectionEnd = start + 1;
        }
    });
});
</script>