<?php
/**
 * MxChat Trigger Admin Settings Page - Sidebar Navigation Layout
 *
 * @package MxChat_Trigger
 * @since 2.2.0
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Render the sidebar-based admin settings page
 */
function mxchat_trigger_render_admin_page($trigger_instance) {
    $options = get_option('mxchat_trigger_options', array('enabled' => 'on'));
    $enabled = isset($options['enabled']) ? $options['enabled'] : 'on';
    $nonce = wp_create_nonce('mxchat_trigger_nonce');
    $plugin_url = MXCHAT_TRIGGER_URL;

    // Check multi-bot status
    $is_multi_bot = class_exists('MxChat_Multi_Bot_Core_Manager');
    $available_bots = array();

    if ($is_multi_bot) {
        try {
            $manager = MxChat_Multi_Bot_Core_Manager::get_instance();
            if (method_exists($manager, 'get_available_bots')) {
                $available_bots = $manager->get_available_bots();
            }
        } catch (Exception $e) {
            // Silently fail
        }
    }

    if (empty($available_bots)) {
        $available_bots = array('default' => __('Default Bot', 'mxchat-trigger'));
    }
    ?>
    <div class="mxch-admin-wrapper">
        <!-- Mobile Header -->
        <header class="mxch-mobile-header">
            <a href="#" class="mxch-mobile-logo">
                <div class="mxch-mobile-logo-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="url(#triggerGradientMobile)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <defs>
                            <linearGradient id="triggerGradientMobile" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" style="stop-color:#fa73e6"/>
                                <stop offset="50%" style="stop-color:#7873f5"/>
                                <stop offset="100%" style="stop-color:#3ac9d1"/>
                            </linearGradient>
                        </defs>
                        <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"/>
                        <path d="M13 8l-2 2-2-2"/>
                        <path d="M11 10v4"/>
                    </svg>
                </div>
                <span class="mxch-mobile-logo-text"><?php esc_html_e('Chat Triggers', 'mxchat-trigger'); ?></span>
            </a>
            <button type="button" class="mxch-mobile-menu-btn" aria-label="<?php esc_attr_e('Open menu', 'mxchat-trigger'); ?>">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="1"/><circle cx="12" cy="5" r="1"/><circle cx="12" cy="19" r="1"/></svg>
            </button>
        </header>

        <!-- Mobile Menu Overlay -->
        <div class="mxch-mobile-overlay"></div>

        <!-- Mobile Menu Modal -->
        <div class="mxch-mobile-menu">
            <div class="mxch-mobile-menu-header">
                <span class="mxch-mobile-menu-title"><?php esc_html_e('Settings', 'mxchat-trigger'); ?></span>
                <button type="button" class="mxch-mobile-menu-close" aria-label="<?php esc_attr_e('Close menu', 'mxchat-trigger'); ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><line x1="18" y1="6" x2="6" y2="18"/><line x1="6" y1="6" x2="18" y2="18"/></svg>
                </button>
            </div>
            <nav class="mxch-mobile-menu-nav">
                <!-- Configuration Section -->
                <div class="mxch-mobile-nav-section">
                    <div class="mxch-mobile-nav-section-title"><?php esc_html_e('Configuration', 'mxchat-trigger'); ?></div>
                    <button class="mxch-mobile-nav-link active" data-target="getting-started">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"/><polyline points="12 6 12 12 16 14"/></svg>
                        <span><?php esc_html_e('Getting Started', 'mxchat-trigger'); ?></span>
                    </button>
                    <button class="mxch-mobile-nav-link" data-target="usage-guide">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M2 3h6a4 4 0 0 1 4 4v14a3 3 0 0 0-3-3H2z"/><path d="M22 3h-6a4 4 0 0 0-4 4v14a3 3 0 0 1 3-3h7z"/></svg>
                        <span><?php esc_html_e('Usage Guide', 'mxchat-trigger'); ?></span>
                    </button>
                    <button class="mxch-mobile-nav-link" data-target="styling">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"/><path d="M12 2a7 7 0 0 0 0 14 3.5 3.5 0 0 1 3.5 3.5 1.5 1.5 0 0 0 2.5-1.1A10 10 0 0 0 12 2z"/></svg>
                        <span><?php esc_html_e('Styling', 'mxchat-trigger'); ?></span>
                    </button>
                </div>
                <!-- Developer Section -->
                <div class="mxch-mobile-nav-section">
                    <div class="mxch-mobile-nav-section-title"><?php esc_html_e('Developer', 'mxchat-trigger'); ?></div>
                    <button class="mxch-mobile-nav-link" data-target="javascript-api">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="16 18 22 12 16 6"/><polyline points="8 6 2 12 8 18"/></svg>
                        <span><?php esc_html_e('JavaScript API', 'mxchat-trigger'); ?></span>
                    </button>
                    <button class="mxch-mobile-nav-link" data-target="shortcode">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="4 17 10 11 4 5"/><line x1="12" y1="19" x2="20" y2="19"/></svg>
                        <span><?php esc_html_e('Shortcode', 'mxchat-trigger'); ?></span>
                    </button>
                </div>
                <?php if ($is_multi_bot): ?>
                <!-- Multi-Bot Section -->
                <div class="mxch-mobile-nav-section">
                    <div class="mxch-mobile-nav-section-title"><?php esc_html_e('Multi-Bot', 'mxchat-trigger'); ?></div>
                    <button class="mxch-mobile-nav-link" data-target="multi-bot">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"/><circle cx="9" cy="7" r="4"/><path d="M23 21v-2a4 4 0 0 0-3-3.87"/><path d="M16 3.13a4 4 0 0 1 0 7.75"/></svg>
                        <span><?php esc_html_e('Bot Selection', 'mxchat-trigger'); ?></span>
                    </button>
                </div>
                <?php endif; ?>
            </nav>
        </div>

        <!-- Sidebar Navigation -->
        <aside class="mxch-sidebar">
            <div class="mxch-sidebar-header">
                <a href="#" class="mxch-sidebar-logo">
                    <div class="mxch-sidebar-logo-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 24 24" fill="none" stroke="url(#triggerGradient)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <defs>
                                <linearGradient id="triggerGradient" x1="0%" y1="0%" x2="100%" y2="100%">
                                    <stop offset="0%" style="stop-color:#fa73e6"/>
                                    <stop offset="50%" style="stop-color:#7873f5"/>
                                    <stop offset="100%" style="stop-color:#3ac9d1"/>
                                </linearGradient>
                            </defs>
                            <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"/>
                            <path d="M13 8l-2 2-2-2"/>
                            <path d="M11 10v4"/>
                        </svg>
                    </div>
                    <span class="mxch-sidebar-logo-text"><?php esc_html_e('Chat Triggers', 'mxchat-trigger'); ?></span>
                    <span class="mxch-sidebar-version">v<?php echo esc_html(MXCHAT_TRIGGER_VERSION); ?></span>
                </a>
            </div>

            <nav class="mxch-sidebar-nav">
                <!-- Configuration Section -->
                <div class="mxch-nav-section">
                    <div class="mxch-nav-section-title"><?php esc_html_e('Configuration', 'mxchat-trigger'); ?></div>

                    <div class="mxch-nav-item" data-section="getting-started">
                        <button class="mxch-nav-link active" data-target="getting-started">
                            <span class="mxch-nav-link-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"/><polyline points="12 6 12 12 16 14"/></svg>
                            </span>
                            <span class="mxch-nav-link-text"><?php esc_html_e('Getting Started', 'mxchat-trigger'); ?></span>
                        </button>
                    </div>

                    <div class="mxch-nav-item" data-section="usage-guide">
                        <button class="mxch-nav-link" data-target="usage-guide">
                            <span class="mxch-nav-link-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M2 3h6a4 4 0 0 1 4 4v14a3 3 0 0 0-3-3H2z"/><path d="M22 3h-6a4 4 0 0 0-4 4v14a3 3 0 0 1 3-3h7z"/></svg>
                            </span>
                            <span class="mxch-nav-link-text"><?php esc_html_e('Usage Guide', 'mxchat-trigger'); ?></span>
                        </button>
                    </div>

                    <div class="mxch-nav-item" data-section="styling">
                        <button class="mxch-nav-link" data-target="styling">
                            <span class="mxch-nav-link-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"/><path d="M12 2a7 7 0 0 0 0 14 3.5 3.5 0 0 1 3.5 3.5 1.5 1.5 0 0 0 2.5-1.1A10 10 0 0 0 12 2z"/></svg>
                            </span>
                            <span class="mxch-nav-link-text"><?php esc_html_e('Styling', 'mxchat-trigger'); ?></span>
                        </button>
                    </div>
                </div>

                <!-- Developer Section -->
                <div class="mxch-nav-section">
                    <div class="mxch-nav-section-title"><?php esc_html_e('Developer', 'mxchat-trigger'); ?></div>

                    <div class="mxch-nav-item" data-section="javascript-api">
                        <button class="mxch-nav-link" data-target="javascript-api">
                            <span class="mxch-nav-link-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="16 18 22 12 16 6"/><polyline points="8 6 2 12 8 18"/></svg>
                            </span>
                            <span class="mxch-nav-link-text"><?php esc_html_e('JavaScript API', 'mxchat-trigger'); ?></span>
                        </button>
                    </div>

                    <div class="mxch-nav-item" data-section="shortcode">
                        <button class="mxch-nav-link" data-target="shortcode">
                            <span class="mxch-nav-link-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="4 17 10 11 4 5"/><line x1="12" y1="19" x2="20" y2="19"/></svg>
                            </span>
                            <span class="mxch-nav-link-text"><?php esc_html_e('Shortcode', 'mxchat-trigger'); ?></span>
                        </button>
                    </div>
                </div>

                <?php if ($is_multi_bot): ?>
                <!-- Multi-Bot Section -->
                <div class="mxch-nav-section">
                    <div class="mxch-nav-section-title"><?php esc_html_e('Multi-Bot', 'mxchat-trigger'); ?></div>

                    <div class="mxch-nav-item" data-section="multi-bot">
                        <button class="mxch-nav-link" data-target="multi-bot">
                            <span class="mxch-nav-link-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"/><circle cx="9" cy="7" r="4"/><path d="M23 21v-2a4 4 0 0 0-3-3.87"/><path d="M16 3.13a4 4 0 0 1 0 7.75"/></svg>
                            </span>
                            <span class="mxch-nav-link-text"><?php esc_html_e('Bot Selection', 'mxchat-trigger'); ?></span>
                            <span class="mxch-nav-link-badge"><?php echo count($available_bots); ?></span>
                        </button>
                    </div>
                </div>
                <?php endif; ?>
            </nav>

            <div class="mxch-sidebar-footer">
                <a href="https://mxchat.ai/docs/triggers" target="_blank" class="mxch-sidebar-upgrade-v2">
                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"/><path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3"/><line x1="12" y1="17" x2="12.01" y2="17"/></svg>
                    <?php esc_html_e('Documentation', 'mxchat-trigger'); ?>
                </a>
            </div>
        </aside>

        <!-- Main Content Area -->
        <main class="mxch-content">
            <!-- ========================================
                 GETTING STARTED SECTION
                 ======================================== -->
            <div id="getting-started" class="mxch-section active">
                <div class="mxch-content-header">
                    <h1 class="mxch-content-title"><?php esc_html_e('Getting Started', 'mxchat-trigger'); ?></h1>
                    <p class="mxch-content-subtitle"><?php esc_html_e('Turn any element on your site into a chat trigger. Add data attributes to buttons, links, or images to open MxChat and send predefined messages.', 'mxchat-trigger'); ?></p>
                </div>

                <div class="mxch-card">
                    <div class="mxch-card-header">
                        <h3 class="mxch-card-title">
                            <svg class="mxch-card-title-icon" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"/></svg>
                            <?php esc_html_e('Enable Triggers', 'mxchat-trigger'); ?>
                        </h3>
                    </div>
                    <div class="mxch-card-body">
                        <div class="mxch-field">
                            <label class="mxch-field-label"><?php esc_html_e('Chat Triggers', 'mxchat-trigger'); ?></label>
                            <div class="mxch-field-control">
                                <label class="mxch-toggle">
                                    <input type="checkbox" class="mxch-toggle-input" id="triggers_enabled" name="enabled" value="on" <?php checked($enabled, 'on'); ?> />
                                    <span class="mxch-toggle-switch"></span>
                                </label>
                            </div>
                            <p class="mxch-field-description"><?php esc_html_e('Enable data attribute triggers to open the chat from any element on your site.', 'mxchat-trigger'); ?></p>
                        </div>
                    </div>
                </div>

                <div class="mxch-card">
                    <div class="mxch-card-header">
                        <h3 class="mxch-card-title">
                            <svg class="mxch-card-title-icon" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polygon points="13 2 3 14 12 14 11 22 21 10 12 10 13 2"/></svg>
                            <?php esc_html_e('Quick Start', 'mxchat-trigger'); ?>
                        </h3>
                    </div>
                    <div class="mxch-card-body">
                        <div class="mxch-notice mxch-notice-info" style="margin-bottom: 16px;">
                            <svg class="mxch-notice-icon" xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"/><line x1="12" y1="16" x2="12" y2="12"/><line x1="12" y1="8" x2="12.01" y2="8"/></svg>
                            <div>
                                <strong><?php esc_html_e('Step 1:', 'mxchat-trigger'); ?></strong> <?php esc_html_e('Add', 'mxchat-trigger'); ?> <code>data-mxchat-trigger="Your message"</code> <?php esc_html_e('to any HTML element.', 'mxchat-trigger'); ?><br>
                                <strong><?php esc_html_e('Step 2:', 'mxchat-trigger'); ?></strong> <?php esc_html_e('When a visitor clicks the element, the chatbot opens automatically.', 'mxchat-trigger'); ?><br>
                                <strong><?php esc_html_e('Step 3:', 'mxchat-trigger'); ?></strong> <?php esc_html_e('Your predefined message is sent to the chatbot and the conversation begins.', 'mxchat-trigger'); ?>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="mxch-card">
                    <div class="mxch-card-header">
                        <h3 class="mxch-card-title">
                            <svg class="mxch-card-title-icon" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"/><line x1="3" y1="9" x2="21" y2="9"/><line x1="9" y1="21" x2="9" y2="9"/></svg>
                            <?php esc_html_e('Data Attributes Reference', 'mxchat-trigger'); ?>
                        </h3>
                    </div>
                    <div class="mxch-card-body">
                        <table class="form-table" style="margin: 0;">
                            <tr>
                                <th style="width: 40%;"><code>data-mxchat-trigger="message"</code></th>
                                <td><?php esc_html_e('Opens chat and sends the specified message', 'mxchat-trigger'); ?></td>
                            </tr>
                            <tr>
                                <th><code>data-mxchat-open</code></th>
                                <td><?php esc_html_e('Opens the chat without sending a message', 'mxchat-trigger'); ?></td>
                            </tr>
                            <?php if ($is_multi_bot): ?>
                            <tr>
                                <th><code>data-mxchat-bot-id="bot_id"</code></th>
                                <td><?php esc_html_e('Target a specific bot (requires Multi-Bot add-on)', 'mxchat-trigger'); ?></td>
                            </tr>
                            <?php endif; ?>
                        </table>
                    </div>
                </div>
            </div>

            <!-- ========================================
                 USAGE GUIDE SECTION
                 ======================================== -->
            <div id="usage-guide" class="mxch-section">
                <div class="mxch-content-header">
                    <h1 class="mxch-content-title"><?php esc_html_e('Usage Guide', 'mxchat-trigger'); ?></h1>
                    <p class="mxch-content-subtitle"><?php esc_html_e('Learn how to add chat triggers to your website using HTML, page builders, or the block editor.', 'mxchat-trigger'); ?></p>
                </div>

                <div class="mxch-card">
                    <div class="mxch-card-header">
                        <h3 class="mxch-card-title">
                            <svg class="mxch-card-title-icon" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="16 18 22 12 16 6"/><polyline points="8 6 2 12 8 18"/></svg>
                            <?php esc_html_e('Open Chat & Send Message', 'mxchat-trigger'); ?>
                        </h3>
                    </div>
                    <div class="mxch-card-body">
                        <p class="mxch-field-description" style="margin-bottom: 16px;"><?php esc_html_e('Use', 'mxchat-trigger'); ?> <code>data-mxchat-trigger</code> <?php esc_html_e('to open the chat and automatically send a predefined message:', 'mxchat-trigger'); ?></p>

                        <div class="mxch-code-block" style="background: #1e1e2e; border-radius: 8px; overflow: hidden; margin-bottom: 16px;">
                            <div style="display: flex; justify-content: space-between; align-items: center; padding: 8px 12px; background: rgba(255,255,255,0.05); border-bottom: 1px solid rgba(255,255,255,0.1);">
                                <span style="color: #a0a0b0; font-size: 12px;"><?php esc_html_e('Button Example', 'mxchat-trigger'); ?></span>
                                <button type="button" class="mxch-copy-btn" data-copy-target="code-btn-example" style="background: transparent; border: 1px solid rgba(255,255,255,0.2); color: #a0a0b0; padding: 4px 8px; border-radius: 4px; font-size: 12px; cursor: pointer;">
                                    <?php esc_html_e('Copy', 'mxchat-trigger'); ?>
                                </button>
                            </div>
                            <pre id="code-btn-example" style="margin: 0; padding: 12px; color: #e0e0e0; font-size: 13px; overflow-x: auto;"><code>&lt;button data-mxchat-trigger="I want to learn about pricing"&gt;
    Get Pricing Info
&lt;/button&gt;</code></pre>
                        </div>

                        <div class="mxch-code-block" style="background: #1e1e2e; border-radius: 8px; overflow: hidden; margin-bottom: 16px;">
                            <div style="display: flex; justify-content: space-between; align-items: center; padding: 8px 12px; background: rgba(255,255,255,0.05); border-bottom: 1px solid rgba(255,255,255,0.1);">
                                <span style="color: #a0a0b0; font-size: 12px;"><?php esc_html_e('Link Example', 'mxchat-trigger'); ?></span>
                                <button type="button" class="mxch-copy-btn" data-copy-target="code-link-example" style="background: transparent; border: 1px solid rgba(255,255,255,0.2); color: #a0a0b0; padding: 4px 8px; border-radius: 4px; font-size: 12px; cursor: pointer;">
                                    <?php esc_html_e('Copy', 'mxchat-trigger'); ?>
                                </button>
                            </div>
                            <pre id="code-link-example" style="margin: 0; padding: 12px; color: #e0e0e0; font-size: 13px; overflow-x: auto;"><code>&lt;a href="#" data-mxchat-trigger="I need help with my order"&gt;
    Contact Support
&lt;/a&gt;</code></pre>
                        </div>
                    </div>
                </div>

                <div class="mxch-card">
                    <div class="mxch-card-header">
                        <h3 class="mxch-card-title">
                            <svg class="mxch-card-title-icon" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"/></svg>
                            <?php esc_html_e('Open Chat Only (No Message)', 'mxchat-trigger'); ?>
                        </h3>
                    </div>
                    <div class="mxch-card-body">
                        <p class="mxch-field-description" style="margin-bottom: 16px;"><?php esc_html_e('Use', 'mxchat-trigger'); ?> <code>data-mxchat-open</code> <?php esc_html_e('to simply open the chat without sending a message:', 'mxchat-trigger'); ?></p>

                        <div class="mxch-code-block" style="background: #1e1e2e; border-radius: 8px; overflow: hidden;">
                            <div style="display: flex; justify-content: space-between; align-items: center; padding: 8px 12px; background: rgba(255,255,255,0.05); border-bottom: 1px solid rgba(255,255,255,0.1);">
                                <span style="color: #a0a0b0; font-size: 12px;"><?php esc_html_e('Open Chat Only', 'mxchat-trigger'); ?></span>
                                <button type="button" class="mxch-copy-btn" data-copy-target="code-open-example" style="background: transparent; border: 1px solid rgba(255,255,255,0.2); color: #a0a0b0; padding: 4px 8px; border-radius: 4px; font-size: 12px; cursor: pointer;">
                                    <?php esc_html_e('Copy', 'mxchat-trigger'); ?>
                                </button>
                            </div>
                            <pre id="code-open-example" style="margin: 0; padding: 12px; color: #e0e0e0; font-size: 13px; overflow-x: auto;"><code>&lt;button data-mxchat-open&gt;Chat with Us&lt;/button&gt;</code></pre>
                        </div>
                    </div>
                </div>

                <div class="mxch-card">
                    <div class="mxch-card-header">
                        <h3 class="mxch-card-title">
                            <svg class="mxch-card-title-icon" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="3" width="7" height="7"/><rect x="14" y="3" width="7" height="7"/><rect x="14" y="14" width="7" height="7"/><rect x="3" y="14" width="7" height="7"/></svg>
                            <?php esc_html_e('Page Builders & Block Editor', 'mxchat-trigger'); ?>
                        </h3>
                    </div>
                    <div class="mxch-card-body">
                        <table class="form-table" style="margin: 0;">
                            <tr>
                                <th style="width: 30%;"><?php esc_html_e('WordPress/Gutenberg', 'mxchat-trigger'); ?></th>
                                <td><?php esc_html_e('Use a Custom HTML block to add the data attribute.', 'mxchat-trigger'); ?></td>
                            </tr>
                            <tr>
                                <th><?php esc_html_e('Elementor', 'mxchat-trigger'); ?></th>
                                <td><?php esc_html_e('Advanced tab', 'mxchat-trigger'); ?> &rarr; <?php esc_html_e('Attributes', 'mxchat-trigger'); ?> &rarr; <?php esc_html_e('Add', 'mxchat-trigger'); ?> <code>data-mxchat-trigger|Your message</code></td>
                            </tr>
                            <tr>
                                <th><?php esc_html_e('Divi', 'mxchat-trigger'); ?></th>
                                <td><?php esc_html_e('Advanced tab', 'mxchat-trigger'); ?> &rarr; <?php esc_html_e('CSS ID & Classes', 'mxchat-trigger'); ?> &rarr; <?php esc_html_e('use a Code module', 'mxchat-trigger'); ?></td>
                            </tr>
                            <tr>
                                <th><?php esc_html_e('Beaver Builder', 'mxchat-trigger'); ?></th>
                                <td><?php esc_html_e('Advanced tab', 'mxchat-trigger'); ?> &rarr; <?php esc_html_e('HTML Element', 'mxchat-trigger'); ?> &rarr; <?php esc_html_e('Attributes', 'mxchat-trigger'); ?></td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>

            <!-- ========================================
                 STYLING SECTION
                 ======================================== -->
            <div id="styling" class="mxch-section">
                <div class="mxch-content-header">
                    <h1 class="mxch-content-title"><?php esc_html_e('Styling Options', 'mxchat-trigger'); ?></h1>
                    <p class="mxch-content-subtitle"><?php esc_html_e('Optional CSS classes to style your trigger elements with beautiful buttons and animations.', 'mxchat-trigger'); ?></p>
                </div>

                <div class="mxch-card">
                    <div class="mxch-card-header">
                        <h3 class="mxch-card-title">
                            <svg class="mxch-card-title-icon" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"/><path d="M3 9h18"/><path d="M9 21V9"/></svg>
                            <?php esc_html_e('Button Styles', 'mxchat-trigger'); ?>
                        </h3>
                    </div>
                    <div class="mxch-card-body">
                        <div style="display: flex; gap: 12px; margin-bottom: 20px; flex-wrap: wrap;">
                            <button class="mxchat-btn mxchat-btn-primary"><?php esc_html_e('Primary Button', 'mxchat-trigger'); ?></button>
                            <button class="mxchat-btn mxchat-btn-secondary"><?php esc_html_e('Secondary Button', 'mxchat-trigger'); ?></button>
                            <button class="mxchat-btn mxchat-btn-gradient"><?php esc_html_e('Gradient Button', 'mxchat-trigger'); ?></button>
                        </div>

                        <div class="mxch-code-block" style="background: #1e1e2e; border-radius: 8px; overflow: hidden;">
                            <div style="display: flex; justify-content: space-between; align-items: center; padding: 8px 12px; background: rgba(255,255,255,0.05); border-bottom: 1px solid rgba(255,255,255,0.1);">
                                <span style="color: #a0a0b0; font-size: 12px;"><?php esc_html_e('Button Classes', 'mxchat-trigger'); ?></span>
                                <button type="button" class="mxch-copy-btn" data-copy-target="code-btn-styles" style="background: transparent; border: 1px solid rgba(255,255,255,0.2); color: #a0a0b0; padding: 4px 8px; border-radius: 4px; font-size: 12px; cursor: pointer;">
                                    <?php esc_html_e('Copy', 'mxchat-trigger'); ?>
                                </button>
                            </div>
                            <pre id="code-btn-styles" style="margin: 0; padding: 12px; color: #e0e0e0; font-size: 13px; overflow-x: auto;"><code>&lt;!-- Primary button --&gt;
&lt;button class="mxchat-btn mxchat-btn-primary" data-mxchat-trigger="Hello!"&gt;
    Chat with Us
&lt;/button&gt;

&lt;!-- Secondary/outline button --&gt;
&lt;button class="mxchat-btn mxchat-btn-secondary" data-mxchat-trigger="Hello!"&gt;
    Get Help
&lt;/button&gt;

&lt;!-- Gradient animated button --&gt;
&lt;button class="mxchat-btn mxchat-btn-gradient" data-mxchat-trigger="Hello!"&gt;
    Special Offer
&lt;/button&gt;</code></pre>
                        </div>
                    </div>
                </div>

                <div class="mxch-card">
                    <div class="mxch-card-header">
                        <h3 class="mxch-card-title">
                            <svg class="mxch-card-title-icon" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M5 16V9h14V2H5l14 14h-7v7H5v-7z"/></svg>
                            <?php esc_html_e('Animation Classes', 'mxchat-trigger'); ?>
                        </h3>
                    </div>
                    <div class="mxch-card-body">
                        <div style="display: flex; gap: 12px; margin-bottom: 20px; flex-wrap: wrap;">
                            <button class="mxchat-btn mxchat-btn-primary mxchat-trigger-shake"><?php esc_html_e('Shake', 'mxchat-trigger'); ?></button>
                            <button class="mxchat-btn mxchat-btn-primary mxchat-trigger-pulse"><?php esc_html_e('Pulse', 'mxchat-trigger'); ?></button>
                            <button class="mxchat-btn mxchat-btn-primary mxchat-trigger-bounce"><?php esc_html_e('Bounce', 'mxchat-trigger'); ?></button>
                        </div>

                        <div class="mxch-code-block" style="background: #1e1e2e; border-radius: 8px; overflow: hidden;">
                            <div style="display: flex; justify-content: space-between; align-items: center; padding: 8px 12px; background: rgba(255,255,255,0.05); border-bottom: 1px solid rgba(255,255,255,0.1);">
                                <span style="color: #a0a0b0; font-size: 12px;"><?php esc_html_e('Animation Classes', 'mxchat-trigger'); ?></span>
                                <button type="button" class="mxch-copy-btn" data-copy-target="code-animations" style="background: transparent; border: 1px solid rgba(255,255,255,0.2); color: #a0a0b0; padding: 4px 8px; border-radius: 4px; font-size: 12px; cursor: pointer;">
                                    <?php esc_html_e('Copy', 'mxchat-trigger'); ?>
                                </button>
                            </div>
                            <pre id="code-animations" style="margin: 0; padding: 12px; color: #e0e0e0; font-size: 13px; overflow-x: auto;"><code>&lt;!-- Subtle shake animation --&gt;
&lt;button class="mxchat-trigger-shake" data-mxchat-trigger="Hello!"&gt;
    Ask a Question
&lt;/button&gt;

&lt;!-- Pulse/glow animation --&gt;
&lt;button class="mxchat-trigger-pulse" data-mxchat-trigger="Hello!"&gt;
    Get Started
&lt;/button&gt;

&lt;!-- Bounce animation --&gt;
&lt;button class="mxchat-trigger-bounce" data-mxchat-trigger="Hello!"&gt;
    Need Help?
&lt;/button&gt;</code></pre>
                        </div>
                    </div>
                </div>
            </div>

            <!-- ========================================
                 JAVASCRIPT API SECTION
                 ======================================== -->
            <div id="javascript-api" class="mxch-section">
                <div class="mxch-content-header">
                    <h1 class="mxch-content-title"><?php esc_html_e('JavaScript API', 'mxchat-trigger'); ?></h1>
                    <p class="mxch-content-subtitle"><?php esc_html_e('Programmatic control for developers who need custom trigger logic.', 'mxchat-trigger'); ?></p>
                </div>

                <div class="mxch-card">
                    <div class="mxch-card-header">
                        <h3 class="mxch-card-title">
                            <svg class="mxch-card-title-icon" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M14.7 6.3a1 1 0 0 0 0 1.4l1.6 1.6a1 1 0 0 0 1.4 0l3.77-3.77a6 6 0 0 1-7.94 7.94l-6.91 6.91a2.12 2.12 0 0 1-3-3l6.91-6.91a6 6 0 0 1 7.94-7.94l-3.76 3.76z"/></svg>
                            <?php esc_html_e('Available Functions', 'mxchat-trigger'); ?>
                        </h3>
                    </div>
                    <div class="mxch-card-body">
                        <div class="mxch-code-block" style="background: #1e1e2e; border-radius: 8px; overflow: hidden;">
                            <div style="display: flex; justify-content: space-between; align-items: center; padding: 8px 12px; background: rgba(255,255,255,0.05); border-bottom: 1px solid rgba(255,255,255,0.1);">
                                <span style="color: #a0a0b0; font-size: 12px;"><?php esc_html_e('JavaScript Functions', 'mxchat-trigger'); ?></span>
                                <button type="button" class="mxch-copy-btn" data-copy-target="code-js-api" style="background: transparent; border: 1px solid rgba(255,255,255,0.2); color: #a0a0b0; padding: 4px 8px; border-radius: 4px; font-size: 12px; cursor: pointer;">
                                    <?php esc_html_e('Copy', 'mxchat-trigger'); ?>
                                </button>
                            </div>
                            <pre id="code-js-api" style="margin: 0; padding: 12px; color: #e0e0e0; font-size: 13px; overflow-x: auto;"><code>// Open chat and send a message
window.mxchatOpenAndSend('Your message here');

// Just open the chat
window.mxchatOpen();

// Send a message (chat must be open)
window.mxchatSendMessage('Your message');

// Check if chat is ready
if (window.mxchatIsReady()) {
    // Chat is loaded and ready
}
<?php if ($is_multi_bot): ?>

// Multi-Bot: Target a specific bot
window.mxchatOpenAndSend('Your message', 'sales_bot');
window.mxchatOpen('support_bot');
window.mxchatIsReady('custom_bot');
window.mxchatSendMessage('Hello', 'sales_bot');

// Get list of available bots on the page
var bots = window.mxchatGetAvailableBots();
console.log('Available bots:', bots);
<?php endif; ?></code></pre>
                        </div>
                    </div>
                </div>

                <div class="mxch-card">
                    <div class="mxch-card-header">
                        <h3 class="mxch-card-title">
                            <svg class="mxch-card-title-icon" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polygon points="13 2 3 14 12 14 11 22 21 10 12 10 13 2"/></svg>
                            <?php esc_html_e('Custom Events', 'mxchat-trigger'); ?>
                        </h3>
                    </div>
                    <div class="mxch-card-body">
                        <p class="mxch-field-description" style="margin-bottom: 16px;"><?php esc_html_e('Listen to these events for custom integrations:', 'mxchat-trigger'); ?></p>

                        <div class="mxch-code-block" style="background: #1e1e2e; border-radius: 8px; overflow: hidden;">
                            <div style="display: flex; justify-content: space-between; align-items: center; padding: 8px 12px; background: rgba(255,255,255,0.05); border-bottom: 1px solid rgba(255,255,255,0.1);">
                                <span style="color: #a0a0b0; font-size: 12px;"><?php esc_html_e('Event Listeners', 'mxchat-trigger'); ?></span>
                                <button type="button" class="mxch-copy-btn" data-copy-target="code-events" style="background: transparent; border: 1px solid rgba(255,255,255,0.2); color: #a0a0b0; padding: 4px 8px; border-radius: 4px; font-size: 12px; cursor: pointer;">
                                    <?php esc_html_e('Copy', 'mxchat-trigger'); ?>
                                </button>
                            </div>
                            <pre id="code-events" style="margin: 0; padding: 12px; color: #e0e0e0; font-size: 13px; overflow-x: auto;"><code>// Fired when a trigger opens the chat
document.addEventListener('mxchat:trigger:open', function(e) {
    console.log('Chat opened via trigger');
    <?php if ($is_multi_bot): ?>console.log('Bot ID:', e.detail.botId);<?php endif ?>

});

// Fired when a trigger sends a message
document.addEventListener('mxchat:trigger:message', function(e) {
    console.log('Message sent:', e.detail.message);
    <?php if ($is_multi_bot): ?>console.log('To bot:', e.detail.botId);<?php endif ?>

});</code></pre>
                        </div>
                    </div>
                </div>
            </div>

            <!-- ========================================
                 SHORTCODE SECTION
                 ======================================== -->
            <div id="shortcode" class="mxch-section">
                <div class="mxch-content-header">
                    <h1 class="mxch-content-title"><?php esc_html_e('Shortcode Reference', 'mxchat-trigger'); ?></h1>
                    <p class="mxch-content-subtitle"><?php esc_html_e('Use the shortcode to quickly add trigger buttons without writing HTML.', 'mxchat-trigger'); ?></p>
                </div>

                <div class="mxch-card">
                    <div class="mxch-card-header">
                        <h3 class="mxch-card-title">
                            <svg class="mxch-card-title-icon" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="4 17 10 11 4 5"/><line x1="12" y1="19" x2="20" y2="19"/></svg>
                            <?php esc_html_e('Basic Usage', 'mxchat-trigger'); ?>
                        </h3>
                    </div>
                    <div class="mxch-card-body">
                        <div class="mxch-code-block" style="background: #1e1e2e; border-radius: 8px; overflow: hidden; margin-bottom: 16px;">
                            <div style="display: flex; justify-content: space-between; align-items: center; padding: 8px 12px; background: rgba(255,255,255,0.05); border-bottom: 1px solid rgba(255,255,255,0.1);">
                                <span style="color: #a0a0b0; font-size: 12px;"><?php esc_html_e('Shortcode', 'mxchat-trigger'); ?></span>
                                <button type="button" class="mxch-copy-btn" data-copy-target="code-shortcode" style="background: transparent; border: 1px solid rgba(255,255,255,0.2); color: #a0a0b0; padding: 4px 8px; border-radius: 4px; font-size: 12px; cursor: pointer;">
                                    <?php esc_html_e('Copy', 'mxchat-trigger'); ?>
                                </button>
                            </div>
                            <pre id="code-shortcode" style="margin: 0; padding: 12px; color: #e0e0e0; font-size: 13px; overflow-x: auto;"><code>[mxchat_trigger message="Hello! I have a question" text="Ask a Question"]</code></pre>
                        </div>

                        <?php if ($is_multi_bot): ?>
                        <div class="mxch-code-block" style="background: #1e1e2e; border-radius: 8px; overflow: hidden;">
                            <div style="display: flex; justify-content: space-between; align-items: center; padding: 8px 12px; background: rgba(255,255,255,0.05); border-bottom: 1px solid rgba(255,255,255,0.1);">
                                <span style="color: #a0a0b0; font-size: 12px;"><?php esc_html_e('Multi-Bot Shortcode', 'mxchat-trigger'); ?></span>
                                <button type="button" class="mxch-copy-btn" data-copy-target="code-shortcode-multibot" style="background: transparent; border: 1px solid rgba(255,255,255,0.2); color: #a0a0b0; padding: 4px 8px; border-radius: 4px; font-size: 12px; cursor: pointer;">
                                    <?php esc_html_e('Copy', 'mxchat-trigger'); ?>
                                </button>
                            </div>
                            <pre id="code-shortcode-multibot" style="margin: 0; padding: 12px; color: #e0e0e0; font-size: 13px; overflow-x: auto;"><code>[mxchat_trigger message="I need help" text="Get Support" bot_id="support_bot"]

[mxchat_trigger text="Chat with Sales" bot_id="sales_bot" open_only="yes"]</code></pre>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="mxch-card">
                    <div class="mxch-card-header">
                        <h3 class="mxch-card-title">
                            <svg class="mxch-card-title-icon" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"/><line x1="3" y1="9" x2="21" y2="9"/><line x1="9" y1="21" x2="9" y2="9"/></svg>
                            <?php esc_html_e('Parameters', 'mxchat-trigger'); ?>
                        </h3>
                    </div>
                    <div class="mxch-card-body">
                        <table class="form-table" style="margin: 0;">
                            <tr>
                                <th style="width: 25%;"><code>message</code></th>
                                <td style="width: 20%;">"Hello!"</td>
                                <td><?php esc_html_e('The message to send when clicked', 'mxchat-trigger'); ?></td>
                            </tr>
                            <tr>
                                <th><code>text</code></th>
                                <td>"Chat with Us"</td>
                                <td><?php esc_html_e('The button text displayed', 'mxchat-trigger'); ?></td>
                            </tr>
                            <tr>
                                <th><code>class</code></th>
                                <td>(empty)</td>
                                <td><?php esc_html_e('Additional CSS classes', 'mxchat-trigger'); ?></td>
                            </tr>
                            <?php if ($is_multi_bot): ?>
                            <tr>
                                <th><code>bot_id</code></th>
                                <td>(empty)</td>
                                <td><?php esc_html_e('Target a specific bot ID', 'mxchat-trigger'); ?></td>
                            </tr>
                            <tr>
                                <th><code>open_only</code></th>
                                <td>"no"</td>
                                <td><?php esc_html_e('Set to "yes" to only open chat without sending message', 'mxchat-trigger'); ?></td>
                            </tr>
                            <?php endif; ?>
                        </table>
                    </div>
                </div>
            </div>

            <?php if ($is_multi_bot): ?>
            <!-- ========================================
                 MULTI-BOT SECTION
                 ======================================== -->
            <div id="multi-bot" class="mxch-section">
                <div class="mxch-content-header">
                    <h1 class="mxch-content-title"><?php esc_html_e('Multi-Bot Support', 'mxchat-trigger'); ?></h1>
                    <p class="mxch-content-subtitle"><?php esc_html_e('Target specific bots with your triggers using the Multi-Bot add-on.', 'mxchat-trigger'); ?></p>
                </div>

                <div class="mxch-notice mxch-notice-success" style="margin-bottom: 24px;">
                    <svg class="mxch-notice-icon" xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/><polyline points="22 4 12 14.01 9 11.01"/></svg>
                    <div>
                        <strong><?php esc_html_e('Multi-Bot Active!', 'mxchat-trigger'); ?></strong> <?php esc_html_e('You can target specific bots with your triggers using the', 'mxchat-trigger'); ?> <code>data-mxchat-bot-id</code> <?php esc_html_e('attribute.', 'mxchat-trigger'); ?>
                    </div>
                </div>

                <div class="mxch-card">
                    <div class="mxch-card-header">
                        <h3 class="mxch-card-title">
                            <svg class="mxch-card-title-icon" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"/><circle cx="9" cy="7" r="4"/><path d="M23 21v-2a4 4 0 0 0-3-3.87"/><path d="M16 3.13a4 4 0 0 1 0 7.75"/></svg>
                            <?php esc_html_e('Available Bots', 'mxchat-trigger'); ?>
                            <span class="mxch-nav-link-badge" style="margin-left: 8px;"><?php echo count($available_bots); ?></span>
                        </h3>
                    </div>
                    <div class="mxch-card-body">
                        <table class="form-table" style="margin: 0;">
                            <?php foreach ($available_bots as $bot_id => $bot_name): ?>
                            <tr>
                                <th style="width: 40%;"><?php echo esc_html($bot_name); ?></th>
                                <td>
                                    <code><?php echo esc_html($bot_id); ?></code>
                                    <button type="button" class="mxch-copy-inline" data-copy-text="<?php echo esc_attr($bot_id); ?>" title="<?php esc_attr_e('Copy Bot ID', 'mxchat-trigger'); ?>" style="background: none; border: none; cursor: pointer; color: var(--mxch-text-muted); margin-left: 8px;">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="9" y="9" width="13" height="13" rx="2" ry="2"/><path d="M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1"/></svg>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </table>
                    </div>
                </div>

                <div class="mxch-card">
                    <div class="mxch-card-header">
                        <h3 class="mxch-card-title">
                            <svg class="mxch-card-title-icon" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="16 18 22 12 16 6"/><polyline points="8 6 2 12 8 18"/></svg>
                            <?php esc_html_e('Usage Examples', 'mxchat-trigger'); ?>
                        </h3>
                    </div>
                    <div class="mxch-card-body">
                        <div class="mxch-code-block" style="background: #1e1e2e; border-radius: 8px; overflow: hidden;">
                            <div style="display: flex; justify-content: space-between; align-items: center; padding: 8px 12px; background: rgba(255,255,255,0.05); border-bottom: 1px solid rgba(255,255,255,0.1);">
                                <span style="color: #a0a0b0; font-size: 12px;"><?php esc_html_e('Target Specific Bot', 'mxchat-trigger'); ?></span>
                                <button type="button" class="mxch-copy-btn" data-copy-target="code-multibot-example" style="background: transparent; border: 1px solid rgba(255,255,255,0.2); color: #a0a0b0; padding: 4px 8px; border-radius: 4px; font-size: 12px; cursor: pointer;">
                                    <?php esc_html_e('Copy', 'mxchat-trigger'); ?>
                                </button>
                            </div>
                            <pre id="code-multibot-example" style="margin: 0; padding: 12px; color: #e0e0e0; font-size: 13px; overflow-x: auto;"><code>&lt;!-- Open sales bot and send message --&gt;
&lt;button data-mxchat-trigger="I want pricing info"
        data-mxchat-bot-id="sales_bot"&gt;
    Talk to Sales
&lt;/button&gt;

&lt;!-- Open support bot without message --&gt;
&lt;button data-mxchat-open
        data-mxchat-bot-id="support_bot"&gt;
    Get Support
&lt;/button&gt;</code></pre>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>

        </main>
    </div>

    <script type="text/javascript">
    window.mxchatTriggerNonce = '<?php echo esc_js($nonce); ?>';
    </script>
    <?php
}
