jQuery(document).ready(function($) {
    
    // Simple toggle switch animation
    $('.mxchat-toggle-switch input').on('change', function() {
        var $slider = $(this).siblings('.mxchat-toggle-slider');
        if ($(this).is(':checked')) {
            $slider.addClass('mxchat-toggle-active');
        } else {
            $slider.removeClass('mxchat-toggle-active');
        }
    });
    
    // Initialize toggle switch states on page load
    $('.mxchat-toggle-switch input:checked').each(function() {
        $(this).siblings('.mxchat-toggle-slider').addClass('mxchat-toggle-active');
    });
    
    // Password field toggle for WooCommerce secret
    if ($('#toggleWooCommerceSecretVisibility').length) {
        $('#toggleWooCommerceSecretVisibility').on('click', function(e) {
            e.preventDefault();
            var $passwordField = $('input[name="mxchat_woo_options[woocommerce_consumer_secret]"]');
            var $button = $(this);
            
            if ($passwordField.attr('type') === 'password') {
                $passwordField.attr('type', 'text');
                $button.text('Hide');
            } else {
                $passwordField.attr('type', 'password');
                $button.text('Show');
            }
        });
    }
    
    // Smooth scrolling for anchor links
    $('a[href^="#"]').on('click', function(e) {
        var target = $($(this).attr('href'));
        if (target.length) {
            e.preventDefault();
            $('html, body').animate({
                scrollTop: target.offset().top - 50
            }, 500);
        }
    });
    
    // Form validation feedback
    $('form').on('submit', function() {
        var $submitButton = $(this).find('input[type="submit"]');
        $submitButton.prop('disabled', true);
        $submitButton.val('Saving...');
        
        // Re-enable after a delay in case of errors
        setTimeout(function() {
            $submitButton.prop('disabled', false);
            $submitButton.val('Save Changes');
        }, 3000);
    });
    
    // Add visual feedback when settings are changed
    $('input, textarea, select').on('change', function() {
        var $field = $(this);
        
        // Add a subtle indicator that changes have been made
        if (!$field.hasClass('changed')) {
            $field.addClass('changed');
            $field.css('border-left', '3px solid #fa73e6');
        }
    });
    
    // Success/error message handling if they exist
    $('.notice').each(function() {
        var $notice = $(this);
        if ($notice.hasClass('notice-success') || $notice.hasClass('notice-error')) {
            // Auto-dismiss after 5 seconds
            setTimeout(function() {
                $notice.fadeOut(500);
            }, 5000);
        }
    });
    
    // Enhanced focus states for better accessibility
    $('input, textarea, select').on('focus', function() {
        $(this).closest('tr, .form-group').addClass('focused');
    }).on('blur', function() {
        $(this).closest('tr, .form-group').removeClass('focused');
    });
    
    // Tooltip functionality for help text (if WordPress tooltips are available)
    if (typeof wp !== 'undefined' && wp.a11y) {
        $('.description').each(function() {
            var $desc = $(this);
            var $field = $desc.prev('input, textarea, select');
            
            if ($field.length) {
                $field.attr('aria-describedby', $desc.attr('id') || 'desc-' + Math.random().toString(36).substr(2, 9));
            }
        });
    }
});