<?php
if (!defined('ABSPATH')) {
    exit;
}
?>
<div class="wrap mxchat-wrapper">
    <div class="mxchat-hero">
        <h1 class="mxchat-main-title">
            <?php echo esc_html__('MxChat ', 'mxchat-woo'); ?>
            <span class="mxchat-gradient-text"><?php echo esc_html__('WooCommerce Integration', 'mxchat-woo'); ?></span>
        </h1>
        <p class="mxchat-hero-subtitle">
            <?php echo esc_html__('Enhance your chat experience with WooCommerce integration. Allow your chatbot to access product information, handle orders, and assist customers with their shopping experience.', 'mxchat-woo'); ?>
        </p>
    </div>

    <div class="mxchat-content">
        <!-- Product Display Settings -->
        <div class="mxchat-card">
            <h2><?php esc_html_e('Product Display Settings', 'mxchat-woo'); ?></h2>
            <form method="post" action="options.php">
                <?php
                settings_fields('mxchat_woo_options');
                do_settings_sections('mxchat-woo');
                submit_button(__('Save Display Settings', 'mxchat-woo'));
                ?>
            </form>
        </div>

        <!-- Filtered Product Search Settings -->
        <div class="mxchat-card">
            <h2><?php esc_html_e('Filtered Product Search', 'mxchat-woo'); ?></h2>
            <p class="mxchat-card-description">
                <?php esc_html_e('Configure advanced product search with AI-powered filter extraction. This feature allows customers to search for products using natural language queries with price ranges, categories, and attributes.', 'mxchat-woo'); ?>
            </p>
            
            <div class="mxchat-notice mxchat-notice-info">
                <span class="dashicons dashicons-info"></span>
                <div>
                    <strong><?php esc_html_e('Important:', 'mxchat-woo'); ?></strong>
                    <?php esc_html_e('After configuring these settings, you must enable the "Filtered Product Search" action in', 'mxchat-woo'); ?>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=mxchat-actions')); ?>"><?php esc_html_e('MxChat → Actions', 'mxchat-woo'); ?></a>
                    <?php esc_html_e('for this feature to work.', 'mxchat-woo'); ?>
                </div>
            </div>
            
            <form method="post" action="options.php">
                <?php
                settings_fields('mxchat_woo_filtered_search_settings');
                do_settings_sections('mxchat-woo-filtered-search');
                submit_button(__('Save Filtered Search Settings', 'mxchat-woo'));
                ?>
            </form>
        </div>

        <?php if ($this->is_activated): ?>
        <div class="mxchat-card">
            <h2><?php esc_html_e('WooCommerce Integration Features', 'mxchat-woo'); ?></h2>
            <div class="mxchat-import-methods">
                <div class="mxchat-method-card">
                    <span class="dashicons dashicons-products"></span>
                    <h4><?php esc_html_e('Product Information', 'mxchat-woo'); ?></h4>
                    <p><?php esc_html_e('Allow your chatbot to access and display product details, prices, and availability.', 'mxchat-woo'); ?></p>
                </div>
                <div class="mxchat-method-card">
                    <span class="dashicons dashicons-clipboard"></span>
                    <h4><?php esc_html_e('Order Management', 'mxchat-woo'); ?></h4>
                    <p><?php esc_html_e('Help customers track orders and view their order history through the chat interface.', 'mxchat-woo'); ?></p>
                </div>
                <div class="mxchat-method-card">
                    <span class="dashicons dashicons-cart"></span>
                    <h4><?php esc_html_e('Shopping Cart', 'mxchat-woo'); ?></h4>
                    <p><?php esc_html_e('Enable customers to add products to cart and manage their shopping cart directly through chat.', 'mxchat-woo'); ?></p>
                </div>
                <div class="mxchat-method-card">
                    <span class="dashicons dashicons-filter"></span>
                    <h4><?php esc_html_e('Filtered Search', 'mxchat-woo'); ?></h4>
                    <p><?php esc_html_e('Advanced product search with AI-powered filter extraction for price, category, and attributes.', 'mxchat-woo'); ?></p>
                </div>
            </div>
        </div>

        <!-- User Documentation -->
        <div class="mxchat-card mxchat-documentation">
            <h2>
                <span class="dashicons dashicons-book"></span>
                <?php esc_html_e('Filtered Product Search Documentation', 'mxchat-woo'); ?>
            </h2>
            
            <div class="mxchat-doc-section">
                <h3><?php esc_html_e('What is Filtered Product Search?', 'mxchat-woo'); ?></h3>
                <p>
                    <?php esc_html_e('Filtered Product Search is an advanced feature that allows customers to search for products using natural language. The AI automatically extracts search criteria like price ranges, categories, and product attributes from customer queries.', 'mxchat-woo'); ?>
                </p>
            </div>

            <div class="mxchat-doc-section">
                <h3><?php esc_html_e('How It Works', 'mxchat-woo'); ?></h3>
                <ol class="mxchat-doc-list">
                    <li>
                        <strong><?php esc_html_e('Trigger Detection:', 'mxchat-woo'); ?></strong>
                        <?php esc_html_e('When a customer sends a message, the system compares it to your configured trigger phrases using AI-powered semantic similarity.', 'mxchat-woo'); ?>
                    </li>
                    <li>
                        <strong><?php esc_html_e('Filter Extraction:', 'mxchat-woo'); ?></strong>
                        <?php esc_html_e('If the similarity threshold is met, the AI analyzes the query and extracts structured filters (price, category, attributes, search terms).', 'mxchat-woo'); ?>
                    </li>
                    <li>
                        <strong><?php esc_html_e('Product Filtering:', 'mxchat-woo'); ?></strong>
                        <?php esc_html_e('The system queries your WooCommerce database using the extracted filters to find matching products.', 'mxchat-woo'); ?>
                    </li>
                    <li>
                        <strong><?php esc_html_e('Semantic Re-ranking (Optional):', 'mxchat-woo'); ?></strong>
                        <?php esc_html_e('Results can be re-ordered based on semantic relevance to the original query for better accuracy.', 'mxchat-woo'); ?>
                    </li>
                </ol>
            </div>

            <div class="mxchat-doc-section">
                <h3><?php esc_html_e('Example Customer Queries', 'mxchat-woo'); ?></h3>
                <div class="mxchat-examples-grid">
                    <div class="mxchat-example">
                        <strong><?php esc_html_e('Price-based:', 'mxchat-woo'); ?></strong>
                        <ul>
                            <li>"<?php esc_html_e('Show me products under $50', 'mxchat-woo'); ?>"</li>
                            <li>"<?php esc_html_e('I need something between $100 and $200', 'mxchat-woo'); ?>"</li>
                            <li>"<?php esc_html_e('What do you have for less than $30?', 'mxchat-woo'); ?>"</li>
                        </ul>
                    </div>
                    <div class="mxchat-example">
                        <strong><?php esc_html_e('Category-based:', 'mxchat-woo'); ?></strong>
                        <ul>
                            <li>"<?php esc_html_e('Show me electronics', 'mxchat-woo'); ?>"</li>
                            <li>"<?php esc_html_e('Products in the clothing category', 'mxchat-woo'); ?>"</li>
                            <li>"<?php esc_html_e('Do you have any accessories?', 'mxchat-woo'); ?>"</li>
                        </ul>
                    </div>
                    <div class="mxchat-example">
                        <strong><?php esc_html_e('Attribute-based:', 'mxchat-woo'); ?></strong>
                        <ul>
                            <li>"<?php esc_html_e('I need a red shirt in size large', 'mxchat-woo'); ?>"</li>
                            <li>"<?php esc_html_e('Show me blue shoes', 'mxchat-woo'); ?>"</li>
                            <li>"<?php esc_html_e('Do you have any Nike products?', 'mxchat-woo'); ?>"</li>
                        </ul>
                    </div>
                    <div class="mxchat-example">
                        <strong><?php esc_html_e('Combined filters:', 'mxchat-woo'); ?></strong>
                        <ul>
                            <li>"<?php esc_html_e('Red t-shirts under $40', 'mxchat-woo'); ?>"</li>
                            <li>"<?php esc_html_e('Electronics between $200-$500', 'mxchat-woo'); ?>"</li>
                            <li>"<?php esc_html_e('Large blue jackets in the clothing category', 'mxchat-woo'); ?>"</li>
                        </ul>
                    </div>
                </div>
            </div>

        </div>
        <?php endif; ?>
    </div>
</div>

<style>
.mxchat-notice {
    display: flex;
    gap: 12px;
    padding: 12px 16px;
    background: #e7f3ff;
    border-left: 4px solid #2271b1;
    margin: 20px 0;
    border-radius: 4px;
}

.mxchat-notice-info {
    background: #e7f3ff;
    border-left-color: #2271b1;
}

.mxchat-notice .dashicons {
    color: #2271b1;
    font-size: 20px;
    margin-top: 2px;
    flex-shrink: 0;
}

.mxchat-card-description {
    color: #646970;
    font-size: 14px;
    margin-bottom: 20px;
}

/* Test Section Styles */
.mxchat-test-section {
    margin-top: 30px;
    padding-top: 30px;
    border-top: 1px solid #dcdcde;
}

.mxchat-test-section h3 {
    margin-top: 0;
}

.mxchat-test-examples {
    background: #f6f7f7;
    padding: 15px;
    border-radius: 4px;
    margin: 15px 0;
}

.mxchat-test-examples strong {
    display: block;
    margin-bottom: 10px;
}

.mxchat-test-examples ul {
    margin: 0;
    padding-left: 20px;
}

.mxchat-test-examples code {
    background: white;
    padding: 2px 6px;
    border-radius: 3px;
}

.mxchat-test-input-group {
    display: flex;
    gap: 10px;
    margin: 20px 0;
}

.mxchat-test-input-group input {
    flex: 1;
}

.mxchat-test-input-group .button .dashicons {
    margin-top: 4px;
}

.mxchat-test-results {
    margin-top: 20px;
    border: 1px solid #dcdcde;
    border-radius: 4px;
    background: white;
}

.mxchat-test-results-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 15px;
    background: #f6f7f7;
    border-bottom: 1px solid #dcdcde;
}

.mxchat-test-results-header h4 {
    margin: 0;
}

#mxchat-test-results-content {
    padding: 20px;
}

.mxchat-test-loading {
    text-align: center;
    padding: 40px;
    color: #646970;
}

.mxchat-test-loading .dashicons {
    animation: spin 1s linear infinite;
    font-size: 32px;
}

@keyframes spin {
    from { transform: rotate(0deg); }
    to { transform: rotate(360deg); }
}

.mxchat-test-error {
    padding: 15px;
    background: #fcf0f1;
    border-left: 4px solid #d63638;
    color: #3c434a;
}

.mxchat-test-success {
    padding: 15px;
    background: #edfaef;
    border-left: 4px solid #00a32a;
    color: #1e4620;
}

/* Documentation Styles */
.mxchat-documentation {
    background: linear-gradient(135deg, #f6f7f7 0%, #ffffff 100%);
}

.mxchat-documentation h2 {
    display: flex;
    align-items: center;
    gap: 10px;
}

.mxchat-documentation h2 .dashicons {
    color: #2271b1;
}

.mxchat-doc-section {
    margin: 30px 0;
    padding: 20px;
    background: white;
    border-radius: 6px;
    border: 1px solid #dcdcde;
}

.mxchat-doc-section h3 {
    color: #1e1e1e;
    margin-top: 0;
    padding-bottom: 10px;
    border-bottom: 2px solid #2271b1;
}

.mxchat-doc-section h4 {
    color: #2c3338;
    margin-top: 20px;
}

.mxchat-doc-list {
    line-height: 1.8;
}

.mxchat-doc-list li {
    margin-bottom: 10px;
}

.mxchat-doc-list code {
    background: #f6f7f7;
    padding: 2px 8px;
    border-radius: 3px;
    font-family: 'Courier New', monospace;
    color: #d63638;
}

.mxchat-examples-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
    margin-top: 20px;
}

.mxchat-example {
    background: #f6f7f7;
    padding: 15px;
    border-radius: 6px;
    border-left: 3px solid #2271b1;
}

.mxchat-example strong {
    display: block;
    color: #1e1e1e;
    margin-bottom: 10px;
}

.mxchat-example ul {
    margin: 0;
    padding-left: 20px;
}

.mxchat-example li {
    margin-bottom: 8px;
    color: #3c434a;
    font-style: italic;
}

.mxchat-import-methods {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
    margin-top: 20px;
}

.mxchat-method-card {
    padding: 20px;
    background: #f6f7f7;
    border-radius: 6px;
    border: 1px solid #dcdcde;
    transition: all 0.3s ease;
}

.mxchat-method-card:hover {
    border-color: #2271b1;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}

.mxchat-method-card .dashicons {
    font-size: 32px;
    color: #2271b1;
    margin-bottom: 10px;
}

.mxchat-method-card h4 {
    margin-top: 0;
    color: #1e1e1e;
}

.mxchat-method-card p {
    color: #646970;
    margin-bottom: 0;
}
</style>
