(function($) {
    var modal_box = $("#announcement-modal");
    var body      = $("body");
    body.append(modal_box); //move modal out of navbar

    setTimeout(function () {
        $('.banner:first-child, .overlay:first-child').addClass('in');
    }, 1000);

    if (modals.length > 0) {
        initialise_modal(modal_box, modals[0]);
        modal_box.modal({
            backdrop: "static",
            keyboard: false
        });
    }

    body.on("click", "[data-announcement-id] input[type=checkbox]", function (event) {
        var button = $(this).closest("[data-announcement-id]").find(".js-button-area button");

        if (this.checked) {
            button.removeClass("disabled");
        } else {
            button.addClass("disabled");
        }
    });

    body.on("click", "[data-announcement-id] .js-button-area button", function (event) {
        if ($(this).hasClass("disabled"))
            return;

        $(this).addClass("disabled");

        var box  = $(this).closest("[data-announcement-id]");
        var id   = box.attr('data-announcement-id');
        var that = $(this);

        $.ajax("/api/announcements/ack/" + id, {
            method: 'POST',
            success: function () {
                if (box.hasClass("modal")) {
                    dismiss_modal(box);
                } else {
                    box.removeClass('in').next().addClass('in');
                }
            },
            error: function () {
                cla.showMessage("Failed to acknowledge announcement", "", true);
                that.removeClass("disabled");
            }
        })
    });


    function dismiss_modal(box) {
        var id  = parseInt(box.attr('data-announcement-id'));
        var idx = modals.findIndex(function (modal) {
            return modal.id === id;
        });
        if (idx < 0) {
            throw new Error("Bad modal ID: " + id);
        }

        if (idx === (modals.length - 1)) {
            box.modal("hide");
        } else {
            var modal       = modals[idx + 1];
            var content_box = box.find(".modal-content");
            content_box.animate({ opacity: 0, duration: 600 }, {
                done: function () {
                    initialise_modal(box, modal);
                    content_box.animate({ opacity: 1, duration: 600 });
                }
            });
        }
    }

    function initialise_modal(box, modal) {
        box.attr("data-announcement-id", modal.id);
        box.find('.js-modal-title').text(modal.title);
        box.find('.js-modal-content').html(modal.body);
        if (modal.need_ack) {
            box.find('.js-modal-agree-text').text(modal.ack_msg);
            box.find('.js-modal-agree-area').show();
            box.find(".js-button-area button").addClass("disabled");
            box.find(".js-modal-agree-area input[type=checkbox]").prop("checked", false);
        } else {
            box.find('.js-modal-agree-text').text("");
            box.find('.js-modal-agree-area').hide();
            box.find(".js-button-area button").removeClass("disabled");
        }
    }

})(jQuery);
