# Announcements Change Log

## 3.0.3 - 20th November 2025

### Improvements

- !38 AN-37 Improved the layout and design of the Announcements landing page 

## 3.0.2 - 28th July 2025

- Merged upstream changes from 2.0.10

## 3.0.1 - 4th July 2025

### Bug Fixes

- !36 BT-5382 Update Broadcast Message styling to fit with adjusted navbar UI

## 3.0.0 - 9th June 2025

### Bug fixes

- !35 BT-5352 Fixed date/time picker alignment in 'Add Announcement' and 'Add Broadcast message' pages

### Developer notes

- Merged upstream changes from 2.0.8 and 2.0.9

## 3.0.0-alpha2 - 16th April 2025

### Bug fixes
- !33 BT-5128 Fixed broadcast message display when the main menu hides on scroll

## 3.0.0-alpha - 14th November 2024

### New features

- !22 AN-42 Added new Broadcast Message announcement type
  - AN-43 Added announcement type column to the announcements list
  - AN-44 Improved Announcement creation flow and refactored creation JS code  
  - BT-4337 Changed admin template to improve display of Announcements table

### Breaking changes

- !22 AN-42 Added new Broadcast Message announcement type
  - Added columns `announcements.bg_color` and `announcements.txt_color` for announcement customization
  - Replaced localization phrase `announcements:admin:abstract.body` with `announcements:admin:message.body`
  - Added methods `GetBgColor(): string` and `GetTxtColor(): string` to `AnnouncementDataInterface`
  - `AnnouncementDataInterface::GetEndDate()` is now nullable

## 2.0.10 - 22nd July 2025

### Bug fixes

- !37 AN-55 Disco 047925 Fixed an issue where enabling "Send email to targeted users" when editing an announcement did not trigger an email

## 2.0.9 - 3rd April 2025

### Improvements

- !34 AN-54 Moved Announcement acknowledgement help text to the edit form and updated text 

## 2.0.8 - 3rd February 2025

### Bug fixes

- !32 BT-5132 Disco 048067 Resolved an issue where the announcement acknowledgements data was not being displayed correctly

## 2.0.7 - 1st November 2024

- !31 BT-4275 Disco 043437 Resolved an issue where the announcement formatting was incorrect in both the Announcement Widget and the Announcement List.

## 2.0.6 - 18th October 2024

### Bug fixes

- !30 BT-4857 Disco 046763 Fixed line break spacing in Announcements paragraph

## 2.0.5 - 19th June 2024

### Improvements

- !28 BT-4696 Updated French localisation
- !27 BT-4684 Updated German localisation

### Bug fixes
- !26 BT-4337 Fixed admin horizontal scroll issue by using a different template

## 2.0.4 - 4th April 2024

### Improvements

- !25 AN-52 Centered and limited the width of content for the create/edit Announcements page and the Announcements list page when using full width themes

## 2.0.3 - 11th August 2023

- Merged upstream changes from 1.1.7

## 2.0.2 - 13th December 2022

### Improvement
- !18 BOOTY-582 Replaced utility classes usages with Bootstrap 4 standard utility classes
- a2db7ae4 FRAM-838 Added menu item registration

## 2.0.1 - 5th August 2022

- a618c86c 6b6357c1 BOOTY-500 BOOTY-514 Updated Announcements pages component IDs so it uses the new class structure

## 2.0.0 - 26th April 2022

- 0a8bbb05 BOOTY-409 Number of small fixes to Announcements including creating component specific CSS file and refining design
- e2baa25c 83812a52 BT-3344 Added responsive table class

## 2.0.0-beta - 25th February 2022

### New features

* Claromentis 9 compatibility

### Improvements

* BOOTY-91 Updated module for Bootstrap 4 upgrade / UI Refresh
* BOOTY-91 Updated JS ad CSS to new file structure and changed module use Webpack

## 1.1.8 - 19th June 2024

### Developer notes

* No changes (internal release)

## 1.1.7 - 9th August 2023

### Improvements

* !19 AN-40 Added audit logging for announcement creation, editing and deletion

## 1.1.6 - 7th March 2022

### Bug fixes

* !17 AN-39 Removed the default `All registered` users from Target users field

## 1.1.5 - 29th November 2021

### Bug fixes

* !16 BT-3073 Overlay bold abstract text not shown

## 1.1.4 - 9th November 2020

### Bug fixes

* !14 BT-2072 Component options could cause layout issues with Pages

## 1.1.3 - 2nd November 2020

### Improvements

* Changed PHP compatibility to allow PHP 7.3 and above. Checked with 7.4

## 1.1.2 - 21st August 2020

### Bug fixes
#### Merged forwards from 1.0.3

* !13 BT-1917 Announcements are no longer shown on the forced password change page. This is to prevent a situation where the user cannot dismiss an announcement because they haven't changed their password, and cannot change their password because they have not dissmissed the announcement.

## 1.1.1 - 14th August 2020

### Bug fixes
#### Merged forwards from 1.0.2
* !12 BT-1869 Notifications for announcements with future publish start dates are now sent on the start date/time and not on creation

## 1.1.0 - 4th August 2020

### Features

* !11 AN-23 Added announcement list pages component

### Developer notes

* !11 The `$lang` parameter taken by public methods on `AnnouncementRepository` is now type-hinted as a `string` and must be passed as such.

## 1.0.3 - 21st August 2020

### Bug fixes

* !13 BT-1917 Announcements are no longer shown on the forced password change page. This is to prevent a situation where the user cannot dismiss an announcement because they haven't changed their password, and cannot change their password because they have not dissmissed the announcement.


## 1.0.2 - 14th August 2020

### Bug fixes

* !12 BT-1869 Notifications for announcements with future publish start dates are now sent on the start date/time and not on creation

## 1.0.1 - 17th March 2020 ☘️

### Bug fixes

* !2 BT-1261 Fixed announcements not showing on the calendar page
* !3 BT-1042 Changed styling of frontend announcements module to allow links to be displayed
* !4 BT-1264 Hidden Acknowledgement progress bar those announcements which don't require it
* !5 BT-1269 Fixed error where lines break at the wrong place
* !5 BT-1265 Swapped localisation of 'Acceptance' in the list of announcements page to 'Acknowledged'.
* !5 BT-1280 Fixed issue where bullet points don't take on announcement colour correctly.
* !6 BT-1093 Users who are in both a group and its parent group will no longer cause the viewed/accepted percentage to be more than 100%
* !7 BT-1307 removed custom 'Dismiss' button opacity which caused it to be hard to read and changed link text in overlay banners to white so they're readable
* !10 BT-1303 Users will no longer be shown the same announcement twice when they are a member of two targeted groups
* !7 BT-1307 Removed custom 'Dismiss' button opacity which caused it to be hard to read and changed link text in overlay banners to white so they're readable
* !8 BT-1303 Announcements with a language now only count users of that language when calculating view and acceptance percentages

## 1.0.0 - 22nd January 2020

### New features

* Administrators can now create and target system-wide announcements
* Emails can be sent to an announcement's targeted users when it is created or updated
* Announcements can require agreement to be dismissed
* Announcements can be displayed in three ways: banner (does not prevent usage of the site),
overlay (makes usage of the site awkward) and modal (completely prevents usage of the
 site until dismissed)
