<?php
$_db_migration_to = '01.01'; // 1.0.0
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_create_table.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$table_desc = [
	'id' => "IDENTITY",
	'from_date' => 'INT_DATE',
	'to_date' => 'INT_DATE',
	'type' => 'INT',
	'title' => 'VARCHAR(200)',
	'body' => 'CLOB'
];

$db->CreateTable('announcements', $table_desc);
DB_UPDATE_FILE
);


$migrations->Run('02_need_ack.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AddColumn('announcements', 'need_ack', "BOOL DEFAULT 0");

DB_UPDATE_FILE
);


$migrations->Run('03_ack_msg.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AddColumn('announcements', 'ack_msg', "VARCHAR_MAX DEFAULT ''");


DB_UPDATE_FILE
);


$migrations->Run('04_create_acknowledgements.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$table_desc = [
	'id' => "IDENTITY",
	'user_id' => 'INT',
	'announcement_id' => 'INT'
];

$db->CreateTable('announcement_acknowledgements', $table_desc);
DB_UPDATE_FILE
);


$migrations->Run('05_announcement_creator.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AddColumn("announcements", "owner_id", "INT");
DB_UPDATE_FILE
);


$migrations->Run('05_view_log.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$table_desc = [
	'id' => "IDENTITY",
	'user_id' => 'INT',
	'announcement_id' => 'INT',
	'time' => 'INT_DATE'
];

$db->CreateTable('announcement_views', $table_desc);
$db->AddColumn('announcement_acknowledgements', 'time', 'INT_DATE');

DB_UPDATE_FILE
);


$migrations->Run('06_add_language.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AddColumn("announcements", "language", "VARCHAR(10) DEFAULT 'all'");
DB_UPDATE_FILE
);


$migrations->Run('07_announcement_emails.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->CreateTable(
	"announcement_email",
	[
		"id"              => "IDENTITY",
		"announcement_id" => "INT",
		"user_id"         => "INT",
		"status"          => "INT"
	]
);

DB_UPDATE_FILE
);


$migrations->Run('08_persistent_email_flag.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AddColumn("announcements", "send_email", "BOOL NOT_NULL DEFAULT 0");

DB_UPDATE_FILE
);


$migrations->Run('09_create_indicies.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->CreateIndex('announcement_acknowledgements', 'announcement_ack_time', 'time');
$db->CreateIndex('announcement_views', 'announcement_view_time', 'time');

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('01.01');
