<?php
// This file contains the database schema version 04.01
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
if ($migrations->GetVersion() > 0)
	throw new Exception("The database is already initialized");
//===========================================================================================

// announcement_acknowledgements
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NULL",
	'announcement_id'	=>	"INT NULL",
	'time'	=>	"INT_DATE NULL",
);

$db->CreateTable('announcement_acknowledgements', $table_descr, true);
$db->CreateIndex('announcement_acknowledgements', 'announcement_ack_time', 'time');



// announcement_email
$table_descr = array(
	'id'	=>	"IDENTITY",
	'announcement_id'	=>	"INT NULL",
	'user_id'	=>	"INT NULL",
	'status'	=>	"INT NULL",
);

$db->CreateTable('announcement_email', $table_descr, true);



// announcement_views
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NULL",
	'announcement_id'	=>	"INT NULL",
	'time'	=>	"INT_DATE NULL",
);

$db->CreateTable('announcement_views', $table_descr, true);
$db->CreateIndex('announcement_views', 'announcement_view_time', 'time');



// announcements
$table_descr = array(
	'id'	=>	"IDENTITY",
	'from_date'	=>	"INT_DATE NULL",
	'to_date'	=>	"INT_DATE NULL",
	'type'	=>	"INT NULL",
	'title'	=>	"VARCHAR(200) NULL",
	'body'	=>	"CLOB NULL",
	'need_ack'	=>	"BOOL NULL DEFAULT 0",
	'ack_msg'	=>	"VARCHAR_MAX NULL DEFAULT ''",
	'owner_id'	=>	"INT NULL",
	'language'	=>	"VARCHAR(10) NULL DEFAULT 'all'",
	'send_email'	=>	"BOOL NOT_NULL DEFAULT 0",
	'date_email_sent'	=>	"INT_DATE NULL DEFAULT NULL",
	'bg_color'	=>	"VARCHAR(7) NULL DEFAULT NULL",
	'txt_color'	=>	"VARCHAR(7) NULL DEFAULT NULL",
);

$db->CreateTable('announcements', $table_descr, true);





//===========================================================================================
$migrations->SetVersion('04.01');
