module.exports = {
    init: function () {
        //Announcement type code
        $('cla-picker[name="announcement_type"]').on('click focus', function(){
            $('.announcment-type-help').addClass('d-none');
            $('.announcement-type-' + this.value).removeClass('d-none');
        })
        //Language code
        var languageSelect = $('#lang-select');

        languageSelect.select2({
            width: '100%',
            templateResult: formatLang,
            templateSelection: formatLang
        });

        toggleLangHelpVisibility();

        languageSelect.on("change", function(){
            toggleLangHelpVisibility();
        })

        function toggleLangHelpVisibility() {
            languageSelect.val() !== "all" ? $('#langHelp').removeClass('d-none') : $('#langHelp').addClass('d-none');
        }

        function formatLang(state) {
            if (!state.id)
                return state.text;
            return $('<span><img src="/images/default/languages/small/' + state.id + '.gif"> ' + state.text + '</span>');
        }

        //Acknowledgment code
        $('cla-toggle-switch[name="require_ack"]').on('change', '#require_ack', function(){
            if ($('#require_ack').is(':checked')) {
                $('.ack-text').removeClass('d-none');
            } else {
                $('.ack-text').addClass('d-none');
            }
        });
    }
}

