<?php
$_db_migration_to = '01.01';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('00_schema.php', <<<'DB_UPDATE_FILE'
<?php
$DROP_TABLES = TRUE;

/**
 * dam_asset
 * the table contains the data of asset
 */
$db->CreateTable('dam_asset',array(
	'id'						=> 'IDENTITY',
	'security_group_id'			=> 'INT NOT_NULL',
	'user_id'					=> 'INT NOT_NULL',
	'title'						=> 'VARCHAR(255)',
	'description'				=> 'VARCHAR_MAX',
	'type'						=> 'VARCHAR(100)',
	'is_request_uncompressed'	=> 'BOOL DEFAULT 0',
	'date_created'				=> 'INT_DATE',
	'date_viewed'				=> 'INT_DATE',
	'date_modified'				=> 'INT_DATE',
),$DROP_TABLES);

/**
 * dam_file
 * the table contains the data about files of asset
 */
$db->CreateTable('dam_file',array(
	'id'						=> 'IDENTITY',
	'user_id'					=> 'INT NOT_NULL',
	'asset_id'					=> 'INT NOT_NULL',
	'name'						=> 'VARCHAR(255)',
	'resolution_width'			=> 'INT',
	'resolution_height'			=> 'INT',
	'size_in_bytes'				=> 'INT',
	'date_upload'				=> 'INT_DATE',
	),$DROP_TABLES);

/**
 * dam_cart
 * the table for save a cart of the user between sessions
 */
$db->CreateTable('dam_cart',array(
	'id'						=> 'IDENTITY',
	'user_id'					=> 'INT NOT_NULL',
	'file_id'					=> 'INT NOT_NULL',
	'date_created'				=> 'INT_DATE',
	),$DROP_TABLES);

/**
 * dam_downloads
 * the table for log of downloads
 */
$db->CreateTable('dam_downloads',array(
	'id'						=> 'IDENTITY',
	'user_id'					=> 'INT NOT_NULL',
	'file_id'					=> 'INT NOT_NULL',
	'date_created'				=> 'INT_DATE',
	),$DROP_TABLES);

/**
 * dam_security_group
 * the table contains security groups
 */
$db->CreateTable('dam_security_group',array(
	'id'						=> 'IDENTITY',
	'name'						=> 'VARCHAR(255)',
	'display_order'				=> 'INT DEFAULT 0',
	'is_default'				=> 'BOOL DEFAULT 0',
	),$DROP_TABLES);

/**
 * dam_category
 * the table contains categories of assets
 */
$db->CreateTable('dam_category',array(
	'id'						=> 'IDENTITY',
	'name'						=> 'VARCHAR(255)',
	'display_order'				=> 'INT DEFAULT 0',
	),$DROP_TABLES);

/**
 * dam_asset_category
 * the table for relations of assets and categories
 */
$db->CreateTable('dam_asset_category',array(
	'category_id'				=> 'INT NOT_NULL',
	'asset_id'					=> 'INT NOT_NULL',
	),$DROP_TABLES);

/**
 * dam_template
 * the table for DAM mail templates
 */
$db->CreateTable('dam_template',array(
	'id'						=> 'IDENTITY',
	'user_id'					=> 'INT NOT_NULL',
	'email_to'					=> 'VARCHAR(100)',
	'subject'					=> 'VARCHAR(255)',
	'body'						=> 'VARCHAR(500)',
	'replace_keys'				=> 'VARCHAR(255)',
	'alias'						=> 'VARCHAR(100)',
	'date_created'				=> 'INT_DATE',
),$DROP_TABLES);


DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('01.01');
