<?php
$_db_migration_to = '07.04'; // 2.3.3
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('2022-10-26_pdf-thumbnails.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */

use Claromentis\Core\Services;

$logger         = $migrations->getLogger();
$imageMagickBin = $migrations->GetConfigFull()->Get('imageMagickBin');

if (!file_exists($imageMagickBin) || !is_executable($imageMagickBin)) {
	$logger->notice('ImageMagick library is not installed or not executable, skipping thumbnail generations for PDF files');

	return;
}

if (!$migrations->GetPluginsRepository()->Exists('assets')) {
	$logger->notice('Digital Assets Management application is disabled, skipping thumbnail generations for PDF files');

	return;
}

$database  = $migrations->GetDb();
$im        = Services::I()->{'assets.imager'};
$fileUtils = Services::I()->GetFilesystemUtil();
$res       = $database->query("SELECT id FROM dam_asset WHERE type = 'file'");
$logger->notice('Found ' . $res->numRows() . ' file assets');

while ([$id] = $res->fetchRow()) {
	$asset       = new AssetsAsset($id);
	if ($asset->IsError()) {
		$logger->error($asset->GetErrMsg());
		continue;
	}

	$coverImg    = $asset->GetCoverImageUrl();
	$defCoverImg = $asset->GetDefaultCoverImage();
	if ($coverImg === $defCoverImg) {
		foreach ($asset->GetFiles() as $value) {
			if ($fileUtils->GetFileExtension($value->GetProperty('name')) === '.pdf') {
				$filePath      = $value->GetFilePath();
				$coverFilePath = $filePath . '.jpg';
				try {
					$logger->notice("Generating preview thumbnail for PDF asset id: $id using the file: $filePath");
					$im->CreateFromFile($filePath)
						->Resize(650, 650)
						->MoveTo($coverFilePath);
					$asset->SetTmpImagePath($coverFilePath);
					AssetsHelper::CreateCoverImage($asset);
				} catch (Exception $exception) {
					$logger->error("Failed to generate PDF thumbnail for asset id: $id using the file: $filePath");
					$logger->error($exception);
				}
				break;
			}
		}
	}
}

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('07.04');
