<?php
// This file contains the database schema version 09.01
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
if ($migrations->GetVersion() > 0)
	throw new Exception("The database is already initialized");
//===========================================================================================

// dam_asset
$table_descr = array(
	'id'	=>	"IDENTITY",
	'security_group_id'	=>	"INT NOT_NULL",
	'user_id'	=>	"INT NOT_NULL",
	'title'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'type'	=>	"VARCHAR(100) NULL",
	'is_request_uncompressed'	=>	"BOOL NULL DEFAULT 0",
	'date_created'	=>	"INT_DATE NULL",
	'date_viewed'	=>	"INT_DATE NULL",
	'date_modified'	=>	"INT_DATE NULL",
);

$db->CreateTable('dam_asset', $table_descr, true);



// dam_asset_category
$table_descr = array(
	'category_id'	=>	"INT NOT_NULL",
	'asset_id'	=>	"INT NOT_NULL",
);

$db->CreateTable('dam_asset_category', $table_descr, true);



// dam_cart
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NOT_NULL",
	'file_id'	=>	"INT NOT_NULL",
	'date_created'	=>	"INT_DATE NULL",
);

$db->CreateTable('dam_cart', $table_descr, true);



// dam_category
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(255) NULL",
	'display_order'	=>	"INT NULL DEFAULT 0",
);

$db->CreateTable('dam_category', $table_descr, true);



// dam_downloads
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NOT_NULL",
	'file_id'	=>	"INT NOT_NULL",
	'date_created'	=>	"INT_DATE NULL",
	'asset_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('dam_downloads', $table_descr, true);



// dam_file
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NOT_NULL",
	'asset_id'	=>	"INT NOT_NULL",
	'name'	=>	"VARCHAR(255) NULL",
	'resolution_width'	=>	"INT NULL",
	'resolution_height'	=>	"INT NULL",
	'size_in_bytes'	=>	"INT NULL",
	'date_upload'	=>	"INT_DATE NULL",
);

$db->CreateTable('dam_file', $table_descr, true);



// dam_security_group
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(255) NULL",
	'display_order'	=>	"INT NULL DEFAULT 0",
	'is_default'	=>	"BOOL NULL DEFAULT 0",
);

$db->CreateTable('dam_security_group', $table_descr, true);



// dam_template
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NOT_NULL",
	'email_to'	=>	"VARCHAR(100) NULL",
	'subject'	=>	"VARCHAR(255) NULL",
	'body'	=>	"VARCHAR(500) NULL",
	'replace_keys'	=>	"VARCHAR(255) NULL",
	'alias'	=>	"VARCHAR(100) NULL",
	'date_created'	=>	"INT_DATE NULL",
);

$db->CreateTable('dam_template', $table_descr, true);





//===========================================================================================
$migrations->SetVersion('09.01');
