define(['jquery'], function(jQuery){
	/**
	 * @param $type string (image, video, file)
	 */
	var switch_by_type = function(type)
	{
		if (type == 'image') {
			jQuery('#need_resize_container').show();
			jQuery('#need_uncompressed_container').hide();

			jQuery('#file_upload_container').hide();
			jQuery('#file_select_container').show();

			jQuery('#cover_image_label_upload').hide();
			jQuery('#cover_image_label_choose').show();
		}
		if (type == 'video') {
			jQuery('#need_resize_container').hide();
			jQuery('#need_uncompressed_container').show();

			jQuery('#file_upload_container').show();
			jQuery('#file_select_container').hide();

			jQuery('#cover_image_label_upload').show();
			jQuery('#cover_image_label_choose').hide();
		}
		if (type == 'file') {
			jQuery('#need_resize_container').hide();
			jQuery('#need_uncompressed_container').hide();

			jQuery('#file_upload_container').show();
			jQuery('#file_select_container').show();

			jQuery('#cover_image_label_upload').hide();
			jQuery('#cover_image_label_choose').show();
		}
	}

	var populate_cover_files = function()
	{
		jQuery('#cover_file').html('');
		jQuery('#cover_file').append(
			jQuery('<option></option>').val('').html(document.lc['assets.edit.choose_from'])
		);

		jQuery('ul.dd_selected_files li').each(function() {
			var file_name = jQuery(this).find('input[name="selected_files[]"]').attr('data-filename');
			if (file_name && check_available_file_type(file_name))
				jQuery('#cover_file').append(
					jQuery('<option></option>').val(file_name).html(file_name)
				);
		});

		jQuery('#asset_files tbody tr').each(function() {
			var file_name = this.children[0].innerText.trim();
			if (file_name && check_available_file_type(file_name))
				jQuery('#cover_file').append(
					jQuery('<option></option>').val(file_name).html(file_name)
				);
		});
	}

	var check_available_file_type = function(file_name)
	{
        var types = ['jpg', 'jpeg', 'png', 'gif'];
        var is_imagick_installed = jQuery('#isImagickInstalled').val();
        if (is_imagick_installed) {
          types.push('pdf')
        }

		var file_part = file_name.split(".");
		var ext = file_part[file_part.length - 1];

		for (var i=0; i<types.length; i++)
		{
			if (ext.toLowerCase() == types[i])
				return true;
		}

		return false;
	};

	function init() {

		switch_by_type(jQuery('input[name="asset_type"]:checked').val());

		jQuery('input[name="asset_type"]').each(function() {
			jQuery(this).click(function() {
				if (jQuery(this).prop('checked')) {
					switch_by_type(jQuery(this).attr('value'));
                    populate_cover_files();
				}
			});
		});

		populate_cover_files();

		jQuery('body').on('dd_change', function(event) {
			populate_cover_files();
		});

		//textarea maxlength for IE
		jQuery('textarea[maxlength]').keyup(function(){
			var limit = parseInt(jQuery(this).attr('maxlength'));
			var text = jQuery(this).val();
			var chars = text.length;

			if(chars > limit){
				var new_text = text.substr(0, limit);
				jQuery(this).val(new_text);
			}
		});

		jQuery('#asset_tagstags_input').attr('maxlength', 100);

	}

	return init;

});


