define(['jquery'], function(jQuery){

	window.search_by_tag = function(tag)
	{
		tag = tag.replace('+', ' ');
		jQuery('#asset_search_form input#tag').val(tag);
		jQuery('#asset_search_form').submit();
	}

	function init() {
		var result_view = jQuery.sessionStorage( 'asset-search-view');
		if (!result_view)
			result_view = '#assetsResultsList';

		jQuery(result_view + '_view').addClass('active');

		jQuery(result_view).ready(function(){
			jQuery(result_view).show();

			jQuery('#ajax-loader').hide();
			jQuery('#search_results').show();
		});

		jQuery('.js-results-view').click(function(){
			if (!jQuery(this).hasClass('active')) {
				var target = jQuery(this).attr('href');
				jQuery.sessionStorage( 'asset-search-view', target );
				jQuery(this).toggleClass('active').siblings().toggleClass('active');
				jQuery(target).siblings().hide();
				jQuery(target).show();
			}

			return false;
		});

		jQuery('#sort_select').change(function(){
			jQuery('#sort').val(jQuery('#sort_select').val());
			jQuery('#asset_search_form').submit();
		});

		jQuery('#search_clear').click(function(){
			jQuery('#q').val('');
			jQuery('#type').val('');
			jQuery('#group').val('');
		});

		var current_tag = jQuery('#asset_search_form input#tag').val();
		jQuery('#tags_cloud a').each(function() {
			var tag = jQuery(this).html();

			if (jQuery(this).attr('id') == 'tag_all')
				tag = '';

			if (tag == current_tag)
				jQuery(this).addClass('active');
		});

		jQuery('#asset_search_form').submit(function(event){
			if (jQuery('#q').attr('placeholder') == jQuery('#q').val())
				jQuery('#q').val('');

			//event.preventDefault();
		});
	}
	return init;

});


