(function()
{
    var moduleName = 'cla.badges_core';
    var template = require('../../html/directives/badge_add_modal.html');

    angular.module(moduleName)
        .directive('claBadgeAddModal', badgeAddModal);

    badgeAddModal.$inject = ['$timeout', '$rootScope', 'claBadgesService', 'claBadgeImageService', 'growl.service'];
    function badgeAddModal($timeout, $rootScope, service, imageService, growlService)
    {
        return {
            restrict: 'E',
            templateUrl: template,
            controllerAs: 'badge',
            bindToController: true,
            controller: controller,
            link: link
        };

        function controller()
        {
            var ctrl = this;
            this.$onInit = function() {

                ctrl.statuses = [
                    {
                        id: 'live',
                        name: lmsg('badges.edit.modal.badge-status.live')
                    },
                    {
                        id: 'archived',
                        name: lmsg('badges.edit.modal.badge-status.archived')
                    }
                ];

                ctrl.isSubmittingNewImage = false;

                ctrl.title = "New badge";
                ctrl.description = 'Desc';
                ctrl.imageId = ctrl.getBlankImageId();
                ctrl.colour = '#abc123';
                ctrl.colourControl = {};
                ctrl.imageSetId = 1;
                ctrl.imageUpload = null;
                ctrl.imageUploadToken = {};
                ctrl.pickImageModal = false;

                ctrl.modalCheck();
            };

            ctrl.getBlankImageId = function()
            {
                var badges = imageService.getImages();

                for (var i = 0; i < badges.length; i++)
                {
                    if (badges[i].image_url.indexOf('000-empty.svg') > 0)
                        return badges[i].id;
                }
            };

            ctrl.getUrl = function(imageId)
            {
                if (imageId === 0)
                    return '/intranet/badges/images/000-placeholder.svg';

                var badges = imageService.getImages();

                for (var i = 0; i < badges.length; i++)
                {
                    if (badges[i].id === imageId)
                        return badges[i].image_url;
                }
            };

            ctrl.submit = function()
            {
                if (ctrl.title === '')
                {
                    growlService.showError(lmsg('badges.add.validation.no_title'));
                    return;
                }

                if (ctrl.title.length > 200)
                {
                    growlService.showError(lmsg('badges.add.validation.title_too_long'));
                    return;
                }

                if (ctrl.description && ctrl.description.length > 1000)
                {
                    growlService.showError(lmsg('badges.add.validation.description_too_long'));
                    return;
                }

                if (ctrl.imageId === ctrl.getBlankImageId())
                {
                    growlService.showError(lmsg('badges.add.validation.no_icon'));
                    return;
                }

                var colour = ctrl.colour;
                if (colour.indexOf('#') === 0)
                    colour = colour.substr(1);
                service.saveBadge(ctrl.id, ctrl.title, ctrl.description, ctrl.imageId, ctrl.status, colour, function(){
                    angular.element('cla-badge-add-modal .modal').modal('hide');
                }, function(){
                    $timeout(function(){
                        $rootScope.$digest();
                    }, 0);
                });
            };

            ctrl.newImage = function()
            {
                // Don't do anything if we are already uploading
                if (ctrl.isSubmittingNewImage)
                    return;

                ctrl.isSubmittingNewImage = true;
                imageService.addImage(ctrl.imageUpload.new_image, function(){
                    ctrl.imageUpload.new_image = '';
                    ctrl.imageUpload.new_url = '';

                    ctrl.imageUploadToken.reset();
                    ctrl.isSubmittingNewImage = false;
                });
            };

            ctrl.isActive = function()
            {
                return service.isActive;
            };

            // Double Bootstrap modals via add/edit badge->add image confuse the system and stops
            // the add/edit modal being scrollable. This monitors the second modal and re-applies
            // the right class to keep it working.
            ctrl.modalCheck = function()
            {
                var modal = angular.element('#ICModal');
                if ((!modal.hasClass('show')) &&
                    (ctrl.pickImageModal))
                {
                    ctrl.pickImageModal = false;

                    $timeout(function() {
                        angular.element('body').addClass('modal-open');
                    }, 500);
                }
                if ((modal.hasClass('show')) &&
                    (!ctrl.pickImageModal))
                {
                    ctrl.pickImageModal = true;
                }

                $timeout(function(){
                    ctrl.modalCheck();
                }, 250);
            };

            // ToDo: Remove these lines when a Claro >=8.10 compatible branch of this module is available
            if (angular.version.major === 1 && angular.version.minor < 5) {
                this.$onInit();
            }
        }

        function link(scope, element, attrs, ctrl)
        {
            ctrl.image_alt_text = ctrl.title + ' ' + lmsg('badges.image.alt');

            angular.element(element).on('cla-reset', function(event, data) {
                ctrl.id = data.id;
                if (data.id === 0)
                {
                    ctrl.title = '';
                    ctrl.description = '';
                    ctrl.imageId = ctrl.getBlankImageId();
                    ctrl.colour = '#2196F3';
                    ctrl.status = 'live';
                    ctrl.imageSetId = 1;
                } else
                {
                    var badges = service.getBadges();
                    var images = imageService.getImages();
                    for (var i = 0; i < badges.length; i++)
                    {
                        if (badges[i].id == data.id)
                        {
                            ctrl.title = badges[i].title;
                            ctrl.description = badges[i].description;
                            ctrl.imageId = badges[i].image_id;
                            ctrl.colour = '#' + badges[i].background_colour;
                            ctrl.status = badges[i].status;

                            for (var j = 0; j < images.length; j++)
                            {
                                if (images[j].id == ctrl.imageId)
                                    ctrl.imageSetId = images[j].set_id;
                            }
                        }
                    }
                }

                setTimeout(function(){
                    scope.$digest();
                    ctrl.colourControl.reset();
                }, 0);
            });
        }
    }
}());
