(function()
{
	var template = require('../../html/directives/badge_image_picker.html');
    var moduleName = 'cla.badges_core';

    angular.module(moduleName)
        .directive('claBadgeImagePicker', badgeImagePicker);

    badgeImagePicker.$inject = ['claBadgeImageService'];
    function badgeImagePicker(service)
    {
        var controller = function($scope, $timeout)
        {
            var ctrl = this;
            this.$onInit = function() {
                ctrl.images = [[], []];
                service.registerUpdateCallback(ctrl.onUpdate);
                ctrl.onUpdate();
            };

            ctrl.onUpdate = function()
			{
				ctrl.images[0].length = 0;
				ctrl.images[1].length = 0;
				var images = service.getImages();

				for (var i = 0; i < images.length; i++)
				{
					ctrl.images[images[i].set_id].push(images[i]);
				}

				$timeout(function(){
					$scope.$digest();
				}, 0);
			};

            // ToDo: Remove these lines when a Claro >=8.10 compatible branch of this module is available
            if (angular.version.major === 1 && angular.version.minor < 5) {
                this.$onInit();
            }
        };
		controller.$inject = ['$scope', '$timeout'];

		return {
			restrict: 'E',
			templateUrl: template,
			scope: {
				ngModel: '=',
				setId: '@'
			},
			require: '^ngModel',
			controllerAs: 'picker',
			bindToController: true,
			controller: controller
		};
    }
}());
