define(['cla_angular'], function (angular)
{
	var moduleName = 'cla.badges.options.service';

	angular.module(moduleName, [])
		.service('badgesOptionsService', BadgesService);

	function BadgesService()
	{
		var service = this;

		service.callback = null;
		service.badges_order = [];
		service.badges_data = [];

		service.register_callback = function (callback) {
			service.callback = callback;
		};

		service.addBadge = function (badge) {
			if (!service.badgeExists(badge))
			{
				service.addBadgeData(badge);
				service.addBadgeOrder(badge.id);
			}
		};

		service.addBadgeOrder = function (badge_id) {
			service.badges_order.push(badge_id);
			if (service.callback !== null)
				service.callback();
		};

		service.addBadgeData = function (badge) {
			service.badges_data.push(badge);
		};

		service.badgeExists = function (badge) {
			for (var i = 0; i < service.badges_data.length; i++)
				if (badge.id === service.badges_data[i].id)
					return true;

			return false;
		};


		service.getBadgeData = function (badge_id) {
			for (var i = 0; i < service.badges_data.length; i++)
				if (service.badges_data[i].id == badge_id)
					return service.badges_data[i];

			return {};
		};

		service.removeBadge = function (badge) {

			var index = null;
			var order_index = null;

			for (var i = 0; i < service.badges_data.length; i++)
			{
				if (badge.id === service.badges_data[i].id)
				{
					index = i;
					order_index = service.badges_order.indexOf(service.badges_data[i].id);
					break;
				}
			}

			if (index !== null)
				service.badges_data.splice(index, 1);

			if(order_index !== -1)
				service.badges_order.splice(order_index, 1);

			if (service.callback !== null)
				service.callback();

		};

		service.compareBadgeDataAndOrder = function () {
			var badges_ids = [];
			for (var i = 0; i < service.badges_data.length; i++)
				badges_ids.push(service.badges_data[i].id);

			for (var i = 0; i < badges_ids.length; i++)
				if (service.badges_order.indexOf(badges_ids[i]) === -1)
					service.addBadgeOrder(badges_ids[i]);

			var i = service.badges_order.length;
			while (i--) {
				if (badges_ids.indexOf(service.badges_order[i]) === -1)
					service.badges_order.splice(i, 1);
			}

			service.callback();
		};
	}
});