define(['cla_angular', '../../html/directives/badge_order_item.html'], function (angular, template)
{
	var moduleName = 'cla.badges.badge_order_item';
	var module;
	try {
		module = angular.module(moduleName);
	} catch(err) {
		// named module does not exist, so create one
		module = angular.module(moduleName, ['cla.badges.options.service', 'ui.sortable']);
	}

	module.directive('claBadgeOrderItem', ['badgesOptionsService', badgeOrderItem]);

	function badgeOrderItem(service)
	{
		var controller = function()
		{
			var ctrl = this;

			this.$onInit = function() {
				ctrl.badge = service.getBadgeData(ctrl.badgeId);
			};
		};

		return {
			controller: controller,
			bindToController: true,
			controllerAs: 'ctrl',
			restrict: 'E',
			require: '^ngModel',
			templateUrl: template,
			scope: {
				badgeId: '@'
			}
		};
	}
});
