(function()
{
	var moduleName = 'cla.badges_detail';
	var template = require('../../../html/directives/detail/badge_detail.html');

	angular.module(moduleName)
		.directive('badgeDetail', badgeDetail);

	badgeDetail.$inject = ['claSingleBadgeService'];
	function badgeDetail(service)
	{
		return {
			restrict: 'E',
			templateUrl: template,
			scope: {
				userId : '@',
				filterUsers: '@'
			},
			controllerAs: 'ctrl',
			bindToController: true,
			controller: controller
		};

		function controller()
		{
			var ctrl = this;
            this.$onInit = function() {
                ctrl.badge = {
                    id: 0,
                    title: '',
                    description: '',
                    created_by: {
                        id: 0,
                        name: ''
                    },
                    created_date: {
                        date_str: '',
                        timezone: '',
                        date: 20010101010100
                    },
                    modified_by: {
                        id: 0,
                        name: ''
                    },
                    modified_date: {
                        date_str: '',
                        timezone: '',
                        date: 20010101010100
                    },
                    archived_by: {
                        id: 0,
                        name: ''
                    },
                    archived_date: {
                        date_str: '',
                        timezone: '',
                        date: 20010101010100
                    },
                    assigned: [],
                    background_colour: '4499cc',
                    image: 'http://core88.localhost:72/intranet/badges/images/000-placeholder.svg',
                    status: 'archived'
                };
                ctrl.is_earned = false;

                var perms = service.getPerms();
                ctrl.perms = {
                    canManage: perms.canManage,
                    canAssignAny: perms.canAssignAny,
                    canAssignSubordinates: perms.canAssignSubordinates,
                    canAssign: perms.canAssign,
                    subordinates: []
                };
                for (var i = 0; i < perms.subordinates.length; i++)
                {
                    ctrl.perms.subordinates.push(perms.subordinates[i]);
                }

                service.registerUpdateCallback(function () {
                    ctrl.init(service.getBadge());
                    var perms = service.getPerms();
                    ctrl.perms.canManage = perms.canManage;
                    ctrl.perms.canAssignAny = perms.canAssignAny;
                    ctrl.perms.canAssignSubordinates = perms.canAssignSubordinates;
                    ctrl.perms.canAssign = perms.canAssign;
                    ctrl.perms.subordinates.length = 0;
                    for (var i = 0; i < perms.subordinates.length; i++)
                    {
                        ctrl.perms.subordinates.push(perms.subordinates[i]);
                    }
                });

                ctrl.init(service.getBadge());
            };

			ctrl.init = function (badge) {


				ctrl.is_earned = false;

                ctrl.badge.id = badge.id;
                ctrl.badge.title = badge.title;

                ctrl.badge.description = badge.description;
                ctrl.badge.created_by.id = badge.created_by.id;
                ctrl.badge.created_by.name = badge.created_by.name;
                ctrl.badge.created_date.date_str = badge.created_date.date_str;
                ctrl.badge.created_date.timezone = badge.created_date.timezone;
                ctrl.badge.created_date.date = badge.created_date.date;
                ctrl.badge.modified_by.id = badge.modified_by.id;
                ctrl.badge.modified_by.name = badge.modified_by.name;
                ctrl.badge.modified_date.date_str = badge.modified_date.date_str;
                ctrl.badge.modified_date.timezone = badge.modified_date.timezone;
                ctrl.badge.modified_date.date = badge.modified_date.date;
                ctrl.badge.archived_by.id = badge.archived_by.id;
                ctrl.badge.archived_by.name = badge.archived_by.name;
                ctrl.badge.archived_date.date_str = badge.archived_date.date_str;
                ctrl.badge.archived_date.timezone = badge.archived_date.timezone;
                ctrl.badge.archived_date.date = badge.archived_date.date;
                ctrl.badge.background_colour = badge.background_colour;
                ctrl.badge.status = badge.status;
                ctrl.badge.image = badge.image;
                ctrl.badge.image_alt_text = badge.title + ' ' + lmsg('badges.image.alttext');
                ctrl.badge.assigned.length = 0;

                if (badge.assigned !== undefined)
                {
                    for (var i = 0; i < badge.assigned.length; i++)
                    {
                        ctrl.badge.assigned.push(badge.assigned[i]);
                    }
                }

				ctrl.edit = function($event)
				{
					$event.preventDefault();

					var element = angular.element('cla-badge-add-modal');
					element.trigger('cla-reset', {id: ctrl.badge.id});
					element.find('.modal').modal('show');
				};

			};

            // ToDo: Remove these lines when a Claro >=8.10 compatible branch of this module is available
            if (angular.version.major === 1 && angular.version.minor < 5) {
                this.$onInit();
            }
		}
	}
}());
