(function()
{
	var moduleName = 'cla.badges_core';

	angular.module(moduleName)
		.controller('headerBreadcrumb', headerBreadcrumb);

	headerBreadcrumb.$inject = ['claSingleBadgeService', 'breadcrumb.service'];
	function headerBreadcrumb(service, breadcrumbService)
	{
		var ctrl = this;
        ctrl.badge_name = '';
        ctrl.badge_id = 0;

		ctrl.init = function (badge)
		{
		    ctrl.badge_id = badge.id;
            ctrl.badge_name = badge.title;

			breadcrumbService.setCrumbs(
			[
				{
					'url': '/badges/',
					'name': 'Badges'
				},
				{
					'url': '/badges/' + ctrl.badge_id,
					'name': ctrl.badge_name
				}
			]);
		};
        service.registerUpdateCallback(function () {
            ctrl.init(service.getBadge());
        });

        ctrl.init(service.getBadge())
	}
}());
