(function()
{
    var moduleName = 'cla.badges_core';

    // Manual singleton as the .service() appears to return multiple instances across Angular apps
    var instance = null;
    if (instance === null)
        instance = new BadgeAssignmentService();

    angular.module(moduleName)
        .service('badgeAssignmentService', function(){
            return instance;
        });

    function BadgeAssignmentService()
    {
        var service = this;

        service.control = {};

        service.setControl = function(control)
        {
            service.control = control;
        };

        service.open = function(id)
        {
            if (service.control.reset !== undefined)
                service.control.reset();
            angular.element('#badge_assignment_modal-' + id).modal('show');
        };

        service.close = function(id)
        {
            angular.element('#badge_assignment_modal-' + id).modal('hide');
        };
    }
}());
